<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'ro', version '4.0'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'DEFĂCUT';
$string['activityisscheduledfordeletion'] = 'Ștergerea activității este în curs...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" nu este o valoare validă pentru vârstă.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" are mai multe virgule.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" nu este o valoare validă pentru țară.';
$string['agedigitalconsentmapinvaliddefault'] = 'Valoarea implicită (*) lipsește.';
$string['agelocationverificationdisabled'] = 'Verificarea vârstei și a locației este dezactivată';
$string['alreadyloggedin'] = 'Sunteți deja conectat ca {$a}; trebuie să vă deconectați, înainte de a vă conecta ca alt utilizator.';
$string['authnotexisting'] = 'Plugin-ul de autorizare nu există';
$string['backupcontainexternal'] = 'Acest fișier de rezervă conține gazde externe de rețea Moodle care nu sunt configurate local';
$string['backuptablefail'] = 'Tabelele de rezervă NU au putut fi configurate cu succes!';
$string['blockcannotconfig'] = 'Acest bloc nu acceptă configurația globală';
$string['blockcannotinistantiate'] = 'Problemă în instanțierea obiectului bloc';
$string['blockcannotread'] = 'Nu s-au putut citi datele pentru blockid= {$a}';
$string['blockdoesnotexist'] = 'Acest bloc nu există';
$string['blockdoesnotexistonpage'] = 'Acest bloc (id={$a->instanceid}) nu există pe această pagină ({$a->url}).';
$string['blocknameconflict'] = 'Conflict de denumire: blocul {$a->name} are același titlu cu un bloc existent: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Comentariul de apel invers a respins acest comentariu.';
$string['cannotaddcoursemodule'] = 'Nu s-a putut adăuga un nou modul de curs';
$string['cannotaddcoursemoduletosection'] = 'Nu s-a putut adăuga noul modul de curs la secțiunea respectivă';
$string['cannotaddmodule'] = '{$a} modulul nu a putut fi adăugat la lista modulelor!';
$string['cannotaddnewmodule'] = 'Nu s-a putut adăuga un nou modul de {$a}';
$string['cannotaddrss'] = 'Nu aveți permisiunea de a adăuga fluxuri RSS';
$string['cannotaddthisblocktype'] = 'Nu puteți adăuga un bloc {$a} la această pagină.';
$string['cannotassignrole'] = 'Nu se poate atribui rolul în curs';
$string['cannotassignrolehere'] = 'Nu aveți permisiunea de a atribui acest rol (id = {$a->roleid}) în acest context ({$a->context})';
$string['cannotassignselfasparent'] = 'Nu se poate atribui persoana proprie ca părinte!';
$string['cannotcallscript'] = 'Nu puteți apela acest script astfel';
$string['cannotcallusgetselecteduser'] = 'Nu puteți apela user_selector::get_selected_user, dacă selectarea multiplă este adevărată.';
$string['cannotcreatebackupdir'] = 'Nu s-a putut crea folderul backupdata. Administratorul site-ului trebuie să remedieze permisiunile fișierului';
$string['cannotcreatecategory'] = 'Categoria nu a fost inserată';
$string['cannotcreatedboninstall'] = '<p>Nu se poate crea baza de date.</p>
<p>Baza de date specificată nu există și utilizatorul dat nu are permisiunea de a crea baza de date.</p>
<p>Administratorul site-ului trebuie să verifice configurația bazei de date.</p>';
$string['cannotcreategroup'] = 'Eroare la crearea grupului';
$string['cannotcreatelangbase'] = 'Eroare: Nu s-a putut crea directorul lang de bază';
$string['cannotcreatelangdir'] = 'Nu se poate crea directorul lang';
$string['cannotcreateorfindstructs'] = 'Eroare la găsirea sau crearea structurilor de secțiuni pentru acest curs';
$string['cannotcreatepopupwin'] = 'Element nedefinit - nu se poate crea o fereastră pop-up';
$string['cannotcreatesitedir'] = 'Nu se poate crea folderul site-ului. Administratorul site-ului trebuie să remedieze permisiunile fișierului.';
$string['cannotcreatetempdir'] = 'Nu se poate crea directorul temporar';
$string['cannotcreateuploaddir'] = 'Nu se poate crea folderul de încărcare. Administratorul site-ului trebuie să remedieze permisiunile fișierului.';
$string['cannotcustomisefiltersblockuser'] = 'Nu puteți personaliza setările filtrelor în contexte de utilizator sau de blocare.';
$string['cannotdeletebackupids'] = 'Nu s-au putut șterge ID-urile de backup anterioare';
$string['cannotdeletecategorycourse'] = 'Cursul "{$a}" nu a putut fi șters.';
$string['cannotdeletecategoryquestions'] = 'Nu s-au putut șterge întrebările din categorie "{$a}"';
$string['cannotdeletecourse'] = 'Nu aveți permisiunea de a șterge acest curs';
$string['cannotdeletecustomfield'] = 'Eroare la ștergerea datelor de câmp personalizate';
$string['cannotdeletedir'] = 'Nu se poate șterge ({$a})';
$string['cannotdeletefile'] = 'Nu se poate șterge acest fișier';
$string['cannotdeleterole'] = 'Nu poate fi șters, deoarece {$a}';
$string['cannotdeleterolewithid'] = 'Nu s-a putut șterge rolul cu ID {$a}';
$string['cannotdeletethisrole'] = 'Nu puteți șterge acest rol, deoarece este utilizat de sistem sau deoarece este ultimul rol cu funcții de administrator.';
$string['cannotdisableformat'] = 'Nu puteți dezactiva formatul implicit';
$string['cannotdownloadcomponents'] = 'Nu se pot descărca componente';
$string['cannotdownloadlanguageupdatelist'] = 'Nu se poate descărca lista actualizărilor de limbă de pe download.moodle.org';
$string['cannotdownloadzipfile'] = 'Nu se poate descărca fișierul ZIP';
$string['cannoteditcomment'] = 'Acest comentariu nu poate fi editat de dvs.!';
$string['cannoteditcommentexpired'] = 'Nu puteți edita acest element. Timpul a expirat!';
$string['cannoteditpostorblog'] = 'Nu puteți posta sau edita bloguri';
$string['cannoteditsiteform'] = 'Nu puteți edita cursul site-ului prin intermediul acestui formular';
$string['cannotedituserpreferences'] = 'Nu pot fi editate preferințele acestui utilizator';
$string['cannotedityourprofile'] = 'Ne pare rău, nu puteți edita propriul profil';
$string['cannotexecduringupgrade'] = 'Nu poate fi executat în timpul actualizării';
$string['cannotfindcategory'] = 'Înregistrarea categoriilor din baza de date după ID - {$a} nu poate fi găsită';
$string['cannotfindcomponent'] = 'Componenta nu poate fi găsită';
$string['cannotfindcontext'] = 'Contextul nu a fost găsit';
$string['cannotfindcourse'] = 'Cursul nu poate fi găsit';
$string['cannotfinddocs'] = 'Fișierele documente de limbă „{$a}” nu pot fi găsite';
$string['cannotfindgradeitem'] = 'evaluare_element nu poate fi găsit';
$string['cannotfindgroup'] = 'Grupul nu poate fi găsit';
$string['cannotfindhelp'] = 'Fișierele de ajutor în limba „{$a}” nu pot fi găsite';
$string['cannotfindinfo'] = 'Informațiile pentru: "{$a}" nu pot fi găsite';
$string['cannotfindlang'] = 'Pachetul de limbă "{$a}" nu poate fi găsit!';
$string['cannotfindteacher'] = 'Formatorul nu poate fi găsit';
$string['cannotfinduser'] = 'Utilizatorul cu numele "{$a}" nu poate fi găsit';
$string['cannotgeoplugin'] = 'Conexiunea la serverul geoPlugin pe adresa http://www.geoplugin.com nu se poate realiza; vă rugăm să verificați setările proxy sau, mai bine, să instalați fișierul de date MaxMind GeoLite City';
$string['cannotgetblock'] = 'Nu s-au putut prelua blocuri din baza de date';
$string['cannotgetcats'] = 'Nu se poate obține înregistrarea categoriei';
$string['cannotgetdata'] = 'Nu se pot obține date';
$string['cannotgradeuser'] = 'Nu se poate nota acest utilizator';
$string['cannothaveparentcate'] = 'Categoria cursului nu poate avea părinte!';
$string['cannotimport'] = 'Eroare la import';
$string['cannotimportformat'] = 'Ne pare rău, importul acestui format nu este încă implementat!';
$string['cannotimportgrade'] = 'Eroare la importul notelor';
$string['cannotinsertgrade'] = 'Nu se poate insera un element de notă fără codul cursului';
$string['cannotinsertrate'] = 'Nu s-a putut insera o evaluare nouă ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Nu s-a putut insera un nou ID de înregistrare {$a}';
$string['cannotmailconfirm'] = 'Eroare la trimiterea e-mailului de confirmare a modificării parolei';
$string['cannotmanualctrack'] = 'Activitatea nu oferă urmărirea manuală a finalizării';
$string['cannotmapfield'] = 'S-a detectat un conflict de mapare - două câmpuri mapează același element de notă {$a}';
$string['cannotmarktopic'] = 'Nu am putut marca acel subiect pentru acest curs';
$string['cannotmigratedatacomments'] = 'Nu se pot migra comentariile modulului de date';
$string['cannotmodulename'] = 'Nu se poate obține numele modulului în navigarea de construire';
$string['cannotmoduletype'] = 'Nu se poate obține tipul de modul în navigarea de construire';
$string['cannotmovecategory'] = 'Nu se poate muta categoria';
$string['cannotmovecourses'] = 'Nu se pot muta cursurile din categoria în care se află în altă categorie.';
$string['cannotmoverolewithid'] = 'Nu se poate muta rolul cu ID {$a}';
$string['cannotopencsv'] = 'Nu se poate deschide fișierul CSV';
$string['cannotopenfile'] = 'Nu pot deschide fisierul ({$a})';
$string['cannotopenforwrit'] = 'Nu se poate deschide pentru scriere: {$a}';
$string['cannotopentemplate'] = 'Nu se poate deschide fișierul șablon ({$a})';
$string['cannotopenzip'] = 'Nu se poate deschide fișierul zip; probabil bug-ul extensiei zip pe sistemul de operare este pe 64 de biți';
$string['cannotoverridebaserole'] = 'Nu se pot suprascrie capacitățile rolului de bază';
$string['cannotoverriderolehere'] = 'Nu aveți permisiunea de a anula acest rol (id = {$a->roleid}) în acest context ({$a->context})';
$string['cannotreadfile'] = 'Nu se poate citi fișierul ({$a})';
$string['cannotreadtmpfile'] = 'Eroare la citirea fișierului temporar';
$string['cannotreaduploadfile'] = 'Nu s-a putut citi fișierul încărcat';
$string['cannotremovefrommeta'] = 'Nu s-a putut elimina cursul selectat din acest meta-curs!';
$string['cannotreprocessgrades'] = 'Nu s-au putut reprocesa notele pentru această activitate {$a}';
$string['cannotresetguestpwd'] = 'Nu puteți reseta parola invitatului';
$string['cannotresetmail'] = 'Eroare la resetarea parolei și la trimiterea prin e-mail';
$string['cannotresetthisrole'] = 'Nu se poate reseta acest rol';
$string['cannotrestore'] = 'A apărut o eroare și restaurarea nu a putut fi finalizată!';
$string['cannotrestoreadminorcreator'] = 'Trebuie să fiți creator sau administrator de utilizatori pentru restabilire în noul curs!';
$string['cannotrestoreadminoredit'] = 'Trebuie să fiți formator cu drepturi de editare sau administrator, pentru a restabili cursul selectat!';
$string['cannotsaveagreement'] = 'Nu s-a putut salva acordul';
$string['cannotsaveblock'] = 'Eroare la salvarea configurației blocului';
$string['cannotsavecomment'] = 'Nu se poate salva comentariul';
$string['cannotsavedata'] = 'Nu se pot salva date';
$string['cannotsavefile'] = 'Nu se poate salva fișierul "{$a}"!';
$string['cannotsavemd5file'] = 'Nu se poate salva fișierul md5';
$string['cannotsavezipfile'] = 'Nu se poate salva fișierul ZIP';
$string['cannotservefile'] = 'Nu poate fi accesat fișierul - problemă de configurare a serverului.';
$string['cannotsetparentforcatoritem'] = 'Nu se poate seta părintele pentru categorie sau element de curs!';
$string['cannotsetpassword'] = 'Nu s-a putut seta parola utilizatorului!';
$string['cannotsetprefgrade'] = 'Nu s-a putut seta agregarea preferințelor la {$a} pentru această categorie de note';
$string['cannotsettheme'] = 'Nu s-a putut seta tema!';
$string['cannotsetupblock'] = 'Tabele bloc NU au putut fi configurate cu succes!';
$string['cannotsetupcapformod'] = 'Nu s-au putut configura capacitățile pentru {$a}';
$string['cannotsetupcapforplugin'] = 'Nu s-au putut configura capacitățile pentru {$a}';
$string['cannotshowhidecoursesincategory'] = 'Nu se pot afișa/ ascunde cursurile din categoria {$a}.';
$string['cannotsignup'] = 'Nu puteți crea un cont nou, deoarece sunteți deja conectat ca {$a}.';
$string['cannotswitcheditmodeon'] = 'Nu s-a putut activa modul de editare';
$string['cannotunassigncap'] = 'Nu s-a putut anula atribuirea depreciată {$a->cap} din rolul {$a->role}';
$string['cannotunassignrolefrom'] = 'Nu se poate anula atribuirea acestui utilizator din ID-ul rolului: {$a}';
$string['cannotunzipfile'] = 'Nu se poate dezarhiva fișierul';
$string['cannotupdatemod'] = 'Nu s-a putut actualiza {$a}';
$string['cannotupdatepasswordonextauth'] = 'Nu s-a putut actualiza parola pentru autentificarea externă: {$a}. Consultați jurnalele serverului pentru mai multe detalii.';
$string['cannotupdateprofile'] = 'Eroare la actualizarea înregistrării utilizatorului';
$string['cannotupdaterecord'] = 'Nu s-a putut actualiza ID-ul înregistrării {$a}';
$string['cannotupdaterss'] = 'Nu se poate actualiza RSS';
$string['cannotupdatesubcourse'] = 'Nu s-a putut actualiza un curs secundar!';
$string['cannotupdateusermsgpref'] = 'Nu se pot actualiza preferințele utilizatorului în materie de mesaje';
$string['cannotupdateuseronexauth'] = 'Actualizarea datelor utilizatorului despre autentificarea externă a eșuat: {$a}. Consultați jurnalele serverului pentru mai multe detalii.';
$string['cannotuploadfile'] = 'Eroare la procesarea fișierului de încărcare';
$string['cannotuseadmin'] = 'Trebuie să fiți administrator pentru a putea utiliza această pagină';
$string['cannotuseadminadminorteacher'] = 'Pentru a putea utiliza această pagină trebuie să fiți formator sau administrator';
$string['cannotusepage'] = 'Numai formatorii și administratorii pot folosi această pagină';
$string['cannotusepage2'] = 'Ne pare rău, nu poți utiliza această pagină';
$string['cannotviewcategory'] = 'Nu aveți permisiunea sa vedeți lista de cursuri.';
$string['cannotviewprofile'] = 'Nu puteți vizualiza profilul acestui utilizator';
$string['cannotviewreport'] = 'Nu puteți vizualiza acest raport';
$string['cannotwritefile'] = 'Nu se poate scrie în fișier ({$a})';
$string['categoryerror'] = 'Eroare de categorie';
$string['categoryidnumbertaken'] = 'Numărul de identificare este deja utilizat pentru altă categorie';
$string['categorynamerequired'] = 'Numele categoriei este obligatoriu';
$string['categorytoolong'] = 'Numele categoriei este prea lung';
$string['commentmisconf'] = 'ID-ul comentariului este configurat greșit';
$string['componentisuptodate'] = 'Componenta este actualizată';
$string['confirmationnotenabled'] = 'Confirmarea utilizatorului nu este activată pe acest site';
$string['confirmsesskeybad'] = 'Ne pare rău, dar cheia de sesiune nu a putut fi confirmată, pentru a efectua această acțiune. Această caracteristică de securitate previne executarea accidentală sau rău intenționată a unor funcții importante în numele dvs. Vă rugăm să vă asigurați că ați dorit cu adevărat să executați această funcție.';
$string['contenttypenotfound'] = 'Tipul de bancă de conținut \'{$a}\' nu există sau nu este recunoscut.';
$string['contentvisibilitynotfound'] = 'Vizibilitatea conținutului cu valoarea „{$a}” nu există sau nu este recunoscută.';
$string['couldnotassignrole'] = 'A apărut o eroare gravă, dar nespecificată, la încercarea de a vă atribui un rol';
$string['couldnotupdatenoexistinguser'] = 'Nu se poate actualiza utilizatorul - utilizatorul nu există';
$string['couldnotverifyagedigitalconsent'] = 'A apărut o eroare la încercarea de a verifica vârsta consimțământului digital. <br />Vă rugăm să contactați administratorul.';
$string['countriesphpempty'] = 'Eroare: fișierul countries.php din pachetul lingvistic {$a} este gol sau lipsește.';
$string['coursedoesnotbelongtocategory'] = 'Cursul nu face parte din această categorie';
$string['courseformatnotfound'] = 'Formatul de curs "{$a}" nu există sau nu este recunoscut';
$string['coursegroupunknown'] = 'Cursul corespunzător grupului {$a} nu este specificat';
$string['courseidnotfound'] = 'Id-ul cursului este inexistent.';
$string['courseidnumbertaken'] = 'Numărul de identificare este deja utilizat pentru un alt curs ({$a})';
$string['coursemisconf'] = 'Cursul este configurat greșit';
$string['courserequestdisabled'] = 'Ne pare rău, dar solicitările de curs au fost dezactivate de administrator.';
$string['csvcolumnduplicates'] = 'Au fost detectate coloane duplicate';
$string['csvemptyfile'] = 'Fișierul CSV este gol';
$string['csvfewcolumns'] = 'Nu există suficiente coloane, vă rugăm să verificați setarea delimitatorului';
$string['csvfileerror'] = 'Este ceva în neregulă cu formatul fișierului CSV. Vă rugăm să verificați numărul de titluri și coloane care se potrivesc și dacă delimitatorul și codificarea fișierelor sunt corecte. {$a}';
$string['csvinvalidcols'] = '<b>fișier CSV invalid:</b> Prima linie trebuie să includă „Câmpuri antet” și fișierul trebuie să fie de tip <br />„Câmpuri extinse/Separate prin virgulă”<br />sau<br />„Câmpuri extinse cu cod de rezultat CAVV/Separate prin virgulă"';
$string['csvinvalidcolsnum'] = 'Fișier CSV invalid - fiecare linie trebuie să includă 49 sau 70 de câmpuri';
$string['csvloaderror'] = 'A apărut o eroare la încărcarea fișierului CSV: {$a}';
$string['csvnodata'] = 'Tipul de fișier CSV nu este valid - Fișierul CSV are antete dar nu conține date.';
$string['csvweirdcolumns'] = 'Format de fișier CSV invalid - numărul de coloane nu este constant!';
$string['dbconnectionfailed'] = '<p>Eroare: conectarea la baza de date a eșuat</p>
<p>Este posibil ca baza de date să fie supraîncărcată sau să nu funcționeze corect.</p>
<p>Administratorul site-ului trebuie, de asemenea, să verifice dacă detaliile bazei de date au fost specificate corect în config.php</p>';
$string['dbdriverproblem'] = '<p>Eroare: a fost detectată o problemă a driver-ului bazei de date </p>
<p>Administratorul site-ului trebuie să verifice configurația serverului</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'A fost detectată o problemă gravă la sesiunea bazei de date. <br /> <br /> Vă rugăm să informați administratorul serverului.';
$string['dbsessionhandlerproblem'] = 'Configurarea sesiunii bazei de date a eșuat. Vă rugăm să luați legătura cu administratorul serverului.';
$string['dbsessionmysqlpacketsize'] = 'A fost detectată o eroare gravă de sesiune. Vă rugăm să anunțați administratorul site-ului. Problema este cel mai probabil cauzată de o valoare mică în setarea My_SQL max_allowed_packet.';
$string['dbupdatefailed'] = 'Actualizarea bazei de date a eșuat';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" nu poate fi modificat. Dependență găsită cu {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Eroare de executare DDL sql';
$string['ddlfieldalreadyexists'] = 'Câmpul „{$a}” există deja';
$string['ddlfieldnotexist'] = 'Câmpul "{$a->fieldname}" nu există în tabelul "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabelul „{$a}” există deja';
$string['ddltablenotexist'] = 'Tabelul „{$a}” nu există';
$string['ddlunknownerror'] = 'Eroare necunoscută a bibliotecii DDL';
$string['ddlxmlfileerror'] = 'S-au găsit erori de fișiere în baza de date XML';
$string['ddsequenceerror'] = 'Definiție incorectă a tabelului „{$a}”; poate exista o singură coloană automată și aceasta trebuie definită ca o cheie.';
$string['destinationcmnotexit'] = 'Modulul de curs destinație nu există';
$string['detectedbrokenplugin'] = 'Plugin-ul „{$a}” este defect sau învechit și nu se poate continua, ne pare rău.';
$string['dmlexceptiononinstall'] = '<p>A apărut o eroare în baza de date [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Eroare la analizarea interogării SQL';
$string['dmlreadexception'] = 'Eroare la citirea din baza de date';
$string['dmltransactionexception'] = 'Eroare tranzacție bază de date';
$string['dmlwriteexception'] = 'Eroare la scrierea în baza de date';
$string['downgradedcore'] = 'EROARE!!! Codul pe care îl utilizați este mai vechi decât versiunea care a creat aceste baze de date!';
$string['downloadedfilecheckfailed'] = 'Verificarea fișierului descărcat a eșuat';
$string['duplicatefieldname'] = 'A fost detectat numele de câmp duplicat „{$a}”';
$string['duplicatenosupport'] = '"{$a->modname}" activitatea nu a putut fi duplicată, deoarece modulul {$a->modtype} nu acceptă backup și restaurare.';
$string['duplicateparaminsql'] = 'EROARE: nume parametru duplicat în interogare';
$string['duplicaterolename'] = 'Există deja un rol cu acest nume!';
$string['duplicateroleshortname'] = 'Există deja un rol cu acest nume scurt!';
$string['duplicateusername'] = 'Numele de utilizator duplicat - înregistrarea este omisă';
$string['emailfail'] = 'Trimiterea prin e-mail a eșuat';
$string['encryption_decryptfailed'] = 'Decriptarea a eșuat';
$string['encryption_encryptfailed'] = 'Criptarea a eșuat';
$string['encryption_invalidkey'] = 'Cheia nu este validă';
$string['encryption_keyalreadyexists'] = 'Cheia există deja';
$string['encryption_nokey'] = 'Cheia nu a fost găsită';
$string['encryption_wrongmethod'] = 'Datele nu se potrivesc cu o metodă de criptare acceptată';
$string['enddatebeforestartdate'] = 'Data de încheiere a cursului trebuie să fie ulterioară datei de începere.';
$string['error'] = 'A apărut o eroare';
$string['error_question_answers_missing_in_db'] = 'Nu s-a găsit un răspuns care să se potrivească cu „{$a->answer}” în tabelul bazei de date question_answers. Acest lucru s-a întâmplat în timp ce restaurați întrebarea cu id {$a->filequestionid} în fișierul de rezervă, care a fost potrivită cu întrebarea existentă cu id {$a->dbquestionid} din baza de date.';
$string['errorcleaningdirectory'] = 'Eroare la curățarea directorului "{$a}"';
$string['errorcopyingfiles'] = 'Eroare la copierea fișierelor';
$string['errorcreatingdirectory'] = 'Eroare la crearea directorului "{$a}"';
$string['errorcreatingfile'] = 'Eroare la crearea fișierului "{$a}"';
$string['errorcreatingrole'] = 'Eroare la crearea rolului';
$string['errorfetchingrssfeed'] = 'Eroare la preluarea fluxului RSS.';
$string['erroronline'] = 'Eroare on-line {$a}';
$string['erroroutput'] = 'Eroare la ieșire: prin urmare, se dezactivează redirecționarea automată.';
$string['errorparsingxml'] = 'Eroare la analizarea XML: {$a->errorstring} la linia {$a->errorline}, chiar {$a->errorchar}';
$string['errorprocessingarchive'] = 'Eroare la procesarea fișierului arhivă';
$string['errorreadingfile'] = 'Eroare la citirea fișierului "{$a}"';
$string['errorsavingrequest'] = 'A apărut o eroare la încercarea de a salva solicitarea dvs..';
$string['errorsettinguserpref'] = 'Eroare la setarea preferințelor utilizatorului';
$string['errorunzippingfiles'] = 'Eroare la dezarhivarea fișierelor';
$string['expiredkey'] = 'Cheie expirată';
$string['externalauthpassworderror'] = 'Parolă necompletată pentru autentificare externă';
$string['externalfilenolocation'] = 'Fișierul extern nu are cale de localizare';
$string['failtoloadblocks'] = 'Unul sau mai multe blocuri sunt înregistrate în baza de date, dar toate nu au reușit să se încarce!';
$string['fieldrequired'] = '"{$a}" este un câmp obligatoriu';
$string['fileexists'] = 'Fișierul exista';
$string['filemismatch'] = 'Neadecvare nume de fișier non-core. Fișierul „{$a->current}” trebuie să fie {$a->file}';
$string['filenotfound'] = 'Ne pare rău, fișierul solicitat nu a putut fi găsit';
$string['filenotreadable'] = 'Fișierul nu poate fi citit';
$string['filterdoesnothavelocalconfig'] = 'Filtrul {$a} nu permite configurarea locală.';
$string['filternotactive'] = 'Filtrul {$a} nu este activ în prezent';
$string['filternotenabled'] = 'Filtrul nu este activat!';
$string['filternotinstalled'] = 'Filtrul {$a} nu este instalat momentan';
$string['forumblockingtoomanyposts'] = 'Ați depășit pragul de postare stabilit pentru acest forum';
$string['functionalityremoved'] = 'Ați încercat să accesați o funcționalitate care a fost ștearsă.';
$string['generalexceptionmessage'] = 'Excepție - {$a}';
$string['gradecantregrade'] = 'A apărut o eroare în timpul calculului calificativului: {$a}';
$string['gradepubdisable'] = 'Publicarea notelor este dezactivată';
$string['gradesneedregrading'] = 'Notele cursului trebuie recalculate';
$string['groupalready'] = 'Utilizatorul aparține deja grupului {$a}';
$string['groupexistforcourse'] = 'Grupul „{$a}” există deja pentru acest curs';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grupul "{$a->name}" cu un număr de identificare „{$a->idnumber}” există deja pentru acest curs';
$string['grouphasidnumber'] = 'Grupul „{$a}” are un număr de identificare și este posibil să fi fost creat automat de un sistem extern. Nu aveți permisiunea de a elimina acest grup.';
$string['groupinghasidnumber'] = 'Gruparea „{$a}” are un număr de identificare și este posibil să fi fost creat automat de un sistem extern. Nu aveți permisiunea de a elimina această grupare.';
$string['groupingnotaddederror'] = 'Gruparea „{$a}” nu a fost adăugată';
$string['groupnotaddederror'] = 'Grupul „{$a}” nu a fost adăugat';
$string['groupnotaddedtogroupingerror'] = 'Grupul „{$a->groupname}” nu a fost adăugat la gruparea „{$a->groupingname}”';
$string['groupunknown'] = 'Grupul {$a} nu este asociat cursului specificat';
$string['groupusernotmember'] = 'Utilizatorul nu este membru al acestui grup.';
$string['guestcantaccessprofiles'] = 'Invitații nu pot accesa profilurile de utilizator. Conectați-vă cu un cont de utilizator complet, pentru a continua.';
$string['guestnocomment'] = 'Invitații nu au voie să posteze comentarii!';
$string['guestnoeditprofile'] = 'Utilizatorul invitat nu își poate edita profilul';
$string['guestnoeditprofileother'] = 'Profilul utilizatorului invitat nu poate fi editat';
$string['guestnorate'] = 'Invitații nu au voie să evalueze intrările';
$string['guestsarenotallowed'] = 'Utilizatorul invitat nu are voie să facă acest lucru';
$string['hackdetected'] = 'A fost detectat un atac de hacking!';
$string['hashpoolproblem'] = 'Conținut de fișier de pool incorect {$a}.';
$string['headersent'] = 'Anteturi deja trimise';
$string['idnumbertaken'] = 'Acest număr de identificare este deja utilizat';
$string['idnumbertoolong'] = 'Numărul de identificare este prea lung';
$string['importformatnotimplement'] = 'Ne pare rău, importul acestui format nu este încă implementat!';
$string['incorrectext'] = 'Fișierul are o extensie incorectă';
$string['inplaceeditableerror'] = 'Eroare la apelarea procesorului de actualizare';
$string['installproblem'] = 'De obicei, nu este posibilă recuperarea după erorile declanșate în timpul instalării; probabil, va trebui să creați o nouă bază de date sau să utilizați un prefix de bază de date diferit, dacă doriți să reîncercați instalarea.';
$string['internalauthpassworderror'] = 'Lipsește parola sau politica de parolă invalidă pentru autentificarea internă';
$string['invalidaccess'] = 'Această pagină nu a fost accesată corect';
$string['invalidaccessparameter'] = 'Parametru de acces invalid';
$string['invalidaction'] = 'Parametru de acțiune invalid';
$string['invalidactivityid'] = 'Identidicator de activitate nu este valid';
$string['invalidadminsettingname'] = 'Setare invalidă de administrator ({$a})';
$string['invalidargorconf'] = 'Nu au fost furnizate argumente valide sau nu s-a configurat incorect serverul';
$string['invalidarguments'] = 'Nu sunt furnizate argumente valide';
$string['invalidblockinstance'] = 'Instanță de bloc invalidă pentru: {$a}';
$string['invalidbulkenrolop'] = 'A fost solicitată o operațiune de înregistrare invalidă în bloc.';
$string['invalidcategory'] = 'Categoria este incorectă!';
$string['invalidcategoryid'] = 'ID de categorie incorect!';
$string['invalidcomment'] = 'Comentariul este incorect';
$string['invalidcommentarea'] = 'Zona invalidă de comentarii';
$string['invalidcommentid'] = 'id-ul comentariului nu este valid';
$string['invalidcommentitemid'] = 'Element de comentariu invalid';
$string['invalidcommentparam'] = 'Parametri de comentariu invalizi';
$string['invalidcomponent'] = 'Nume component invalid';
$string['invalidconfirmdata'] = 'Date de confirmare invalide';
$string['invalidcontentid'] = 'ID de conținut nevalid';
$string['invalidcontext'] = 'Context invalid';
$string['invalidcountrycode'] = 'Codul țării nu este valid: {$a}';
$string['invalidcourse'] = 'Curs invalid';
$string['invalidcourseformat'] = 'Format de curs invalid';
$string['invalidcourseid'] = 'ID-ul de curs pe care îl folosiţi este incorect';
$string['invalidcourselevel'] = 'Nivel de context incorect';
$string['invalidcoursemodule'] = 'ID modul de curs invalid';
$string['invalidcoursenameshort'] = 'Numele cursului nu este valid';
$string['invaliddata'] = 'Datele trimise nu sunt valide';
$string['invaliddatarootpermissions'] = 'Permisiuni invalide detectate la încercarea de a crea un director. Activați depanarea pentru detalii suplimentare.';
$string['invaliddevicetype'] = 'Tipul dispozitivului nu este valid';
$string['invalidelementid'] = 'ID element incorect!';
$string['invalidentry'] = 'Aceasta nu este o intrare validă!';
$string['invalidevent'] = 'Evenimentul nu este valid';
$string['invalidfieldname'] = '"{$a}" nu este un nume de câmp valid';
$string['invalidfiletype'] = '"{$a}" nu este un tip de fișier valid';
$string['invalidformatpara'] = 'Format incorect pentru parametrul ales';
$string['invalidformdata'] = 'Date de formular incorecte';
$string['invalidfunction'] = 'Funcție incorectă';
$string['invalidgradeitemid'] = 'Cod incorect al elementului de notă';
$string['invalidgroupid'] = 'A fost specificat un cod incorect de grup';
$string['invalidipformat'] = 'Format de adresă IP invalid';
$string['invaliditemid'] = 'ID articol incorect';
$string['invalidkey'] = 'Cheie incorectă';
$string['invalidlanguagecode'] = 'Cod de limbă nevalid: {$a}';
$string['invalidlegacy'] = 'Definiție de rol moștenită incorectă pentru tipul: {$a}';
$string['invalidmd5'] = 'Variabila de verificare a fost greșită - încercați din nou';
$string['invalidmode'] = 'Mod invalid ({$a})';
$string['invalidmodule'] = 'Modul invalid';
$string['invalidmoduleid'] = 'ID modul invalid: {$a}';
$string['invalidmodulename'] = 'Nume modul invalid: {$a}';
$string['invalidnum'] = 'Valoare numerică invalidă';
$string['invalidnumkey'] = '$matricea de condiții nu poate conține chei numerice, vă rugăm să remediați codul!';
$string['invalidoutcome'] = 'ID de rezultat incorect';
$string['invalidpagesize'] = 'Dimensiune pagină invalidă';
$string['invalidpasswordpolicy'] = 'Politică de parolă invalidă';
$string['invalidpaymentmethod'] = 'Metodă de plată invalidă: {$a}';
$string['invalidpersistenterror'] = 'Eroare: {$a}';
$string['invalidqueryparam'] = 'EROARE: număr incorect de parametri de interogare. Estimat {$a->expected}, real {$a->actual}.';
$string['invalidratingarea'] = 'Zonă de evaluare invalidă';
$string['invalidrecord'] = 'Nu se poate găsi înregistrarea datelor în tabelul bazei de date {$a}.';
$string['invalidrecordunknown'] = 'Nu se poate găsi înregistrarea datelor în baza de date.';
$string['invalidrequest'] = 'Cerere invalidă';
$string['invalidrole'] = 'Rol invalid';
$string['invalidroleid'] = 'ID rol invalid';
$string['invalidscaleid'] = 'Cod scală incorect';
$string['invalidsection'] = 'Înregistrarea modulului de curs conține o secțiune invalidă';
$string['invalidsesskey'] = 'Cel mai probabil sesiunea dvs. a expirat. Vă rog Loghați-vă din nou.';
$string['invalidshortname'] = 'Acesta este un nume de curs scurt invalid';
$string['invalidsourcefield'] = 'Câmpul sursă al fișierului proiect nu este valid';
$string['invalidstatedetected'] = 'Ceva nu a funcționat corect: {$a}. Acest lucru nu ar trebui să se întâmple în mod normal.';
$string['invalidurl'] = 'URL invalid';
$string['invaliduser'] = 'Utilizator incorect';
$string['invaliduserdata'] = 'Date de utilizator invalide: {$a}';
$string['invaliduserfield'] = 'Câmp de utilizator invalid: {$a}';
$string['invaliduserid'] = 'ID de utilizator invalid';
$string['invalidusername'] = 'Numele de utilizator dat conține caractere invalide';
$string['invalidusernameblank'] = 'Trebuie completat numele utilizatorului';
$string['invalidxmlfile'] = '"{$a}" nu este un fișier XML valid';
$string['iplookupfailed'] = 'Nu se pot găsi informații geografice despre această adresă IP {$a}';
$string['iplookupprivate'] = 'Nu se poate afișa căutarea adresei IP private';
$string['ipmismatch'] = 'Adresa IP client nu corespunde';
$string['listcantmovedown'] = 'Nu s-a putut muta elementul în jos, deoarece este ultimul din listă';
$string['listcantmoveleft'] = 'Nu s-a putut muta elementul la stânga, deoarece nu are părinte';
$string['listcantmoveright'] = 'Nu s-a putut muta elementul spre dreapta, deoarece nu există un egal care să-l facă copil. Mișcați-l sub un alt element de același nivel și apoi îl puteți muta la dreapta.';
$string['listcantmoveup'] = 'Nu s-a putut muta articolul în sus, deoarece este primul din listă';
$string['listnochildren'] = 'Nu s-au găsit copii ai articolului';
$string['listnoitem'] = 'Elementul nu a fost găsit';
$string['listnopeers'] = 'Nu s-au găsit elemente de același nivel';
$string['listupdatefail'] = 'Operațiunea DB nu a reușit la editarea ierarhiei listelor';
$string['logfilenotavailable'] = 'Jurnalele nu sunt disponibile';
$string['loginasnoenrol'] = 'Nu puteți utiliza, înscrie sau anula înregistrarea, atunci când participați la sesiunea „Conectare ca”';
$string['loginasonecourse'] = 'Nu puteți intra în acest curs. <br /> Trebuie să încheiați sesiunea „Conectați-vă ca”, înainte de a intra în orice alt curs.';
$string['maxareabytes'] = 'Fișierul este mai mare decât spațiul rămas în această zonă.';
$string['maxbytesfile'] = 'Fișierul {$a->file} este prea mare. Dimensiunea maximă, pe care o puteți încărca, este {$a->size}.';
$string['maxdraftitemids'] = 'Încărcările dumneavoastră de fișiere sunt temporar limitate după ce ați încărcat un volum mare de fișiere. Vă rugăm să așteptați, apoi să încercați din nou.';
$string['messageundeliveredbynotificationsettings'] = 'Mesajul nu a putut fi trimis deoarece mesajele personale între utilizatori (în setările Notificare) au fost dezactivate de către un administrator de site.';
$string['messagingdisable'] = 'Mesageria este dezactivată pe acest site';
$string['mimetexisnotexist'] = 'Sistemul dvs. nu este configurat, pentru a rula mimeTeX. Trebuie să obțineți sursa C de la <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip </a>, să o compilați și să o puneți executabil în directorul dvs. moodle / filter / tex /.';
$string['mimetexnotexecutable'] = 'Mimetex personalizat nu este executabil!';
$string['missing_moodle_backup_xml_file'] = 'Funcția de rezervă lipsește fișierul XML: {$a}';
$string['missingfield'] = 'Câmpul „{$a}” lipsește';
$string['missingkeyinsql'] = 'EROARE: parametrul „{$a}” lipsește în interogare';
$string['missingparam'] = 'A lipsit un parametru obligatoriu ({$a})';
$string['missingparameter'] = 'Parametrul lipsește';
$string['missingrequiredfield'] = 'Un câmp obligatoriu lipsește';
$string['missinguseranditemid'] = 'ID-ul utilizatorului și elementul ID lipsesc';
$string['missingvarname'] = 'Numele variabilei obligatorii lipsește!';
$string['mixedtypesqlparam'] = 'EROARE: Tipuri mixte de parametri de interogare sql !!';
$string['mnetdisable'] = 'MNET este dezactivat';
$string['mnetlocal'] = 'Utilizatorii MNET la distanță nu se pot conecta local';
$string['moduledisable'] = 'Acest modul ({$a}) a fost dezactivat pentru acest curs';
$string['moduledoesnotexist'] = 'Acest modul nu există';
$string['moduleinstancedoesnotexist'] = 'Instanța acestui modul nu există';
$string['modulemissingcode'] = 'Modulului {$a} îi lipsește codul necesar, pentru a îndeplini această funcție';
$string['movecatcontentstoroot'] = 'Nu este permisă mutarea conținutului categoriei în rădăcină. Trebuie să mutați conținutul într-o categorie existentă!';
$string['movecatcontentstoselected'] = 'O parte din conținutul categoriei nu poate fi mutat în categoria selectată.';
$string['movecategorynotpossible'] = 'Nu puteți muta categoria "{$a}" în categoria selectată.';
$string['movecategoryownparent'] = 'Nu puteți face din categoria "{$a}" un părinte în sine.';
$string['movecategoryparentconflict'] = 'Nu puteți face din categoria "{$a}" o subcategorie a uneia dintre subcategoriile sale.';
$string['mssqlrcsmodemissing'] = 'Baza de date nu utilizează modulul READ_COMMITTED_SNAPSHOT așteptat, care poate duce la rezultate greșite, în special, în scenarii de concurență ridicată. Vă rugăm să îl activați pentru un comportament corect. Pentru informații suplimentare, consultați documentația <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP"> Instalarea MSSQL pentru PHP </a>.';
$string['multiplerecordsfound'] = 'Au fost găsite mai multe înregistrări, se aștepta o singură înregistrare.';
$string['multiplerestorenotallow'] = 'Execuția restaurării multiple nu este permisă!';
$string['mustbeloggedin'] = 'Trebuie să fiți conectat pentru a face acest lucru';
$string['mustbeteacher'] = 'Trebuie să fii formator, pentru a vizualiza această pagină';
$string['myisamproblem'] = 'Tabelele de baze de date utilizează motorul de baze de date MyISAM; se recomandă utilizarea unui motor compatibil ACID cu suport complet pentru tranzacții, cum ar fi InnoDB.';
$string['needcopy'] = 'Mai întâi, trebuie să copiați ceva!';
$string['needcoursecategroyid'] = 'Trebuie specificat, fie ID-ul cursului, fie categoria';
$string['needphpext'] = 'Trebuie să adăugați asistență {$a} la instalarea dvs. PHP';
$string['noadmins'] = 'Fără administratori!';
$string['noblocks'] = 'Nu s-au găsit blocuri!';
$string['nocapabilitytousethisservice'] = 'Utilizatorul nu are capacitatea necesară de a utiliza acest serviciu';
$string['nocategorydelete'] = 'Categoria "{$a}" nu poate fi ștearsă!';
$string['nocontext'] = 'Ne pare rău, dar cursul respectiv nu este un context valid';
$string['nodata'] = 'Nu există date';
$string['noexistingcategory'] = 'Nicio categorie existentă';
$string['nofile'] = 'Fișier nespecificat';
$string['nofiltersenabled'] = 'Nu sunt activate filtre.';
$string['nofolder'] = 'Directorul solicitat nu există';
$string['noformdesc'] = 'Nu a fost găsit niciun fișier de descriere a formularului pentru această activitate.';
$string['noguest'] = 'Niciun invitat aici!';
$string['noinstances'] = 'Nu există instanțe a {$a} în acest curs!';
$string['nologinas'] = 'Nu aveți permisiunea de a vă conecta ca utilizator';
$string['nonmeaningfulcontent'] = 'Conținut mai puțin important';
$string['noparticipants'] = 'Niciun participant nu a fost găsit pentru acest curs';
$string['noparticipatorycms'] = 'Ne pare rău, dar nu aveți module de curs participativ la care să vă raportați';
$string['nopermissions'] = 'Ne pare rău, dar în prezent nu aveți permisiunea de a face acest lucru ({$a}).';
$string['nopermissiontoaccesspage'] = 'Nu aveți permisiunea să accesați această pagină.';
$string['nopermissiontocomment'] = 'Nu puteți adăuga comentarii';
$string['nopermissiontodelentry'] = 'Nu puteți șterge acest comentariu!';
$string['nopermissiontoeditcomment'] = 'Nu puteți edita comentariile altor persoane!';
$string['nopermissiontohide'] = 'Nici o permisiune de ascundere!';
$string['nopermissiontoimportact'] = 'Nu aveți permisiunile necesare, pentru a importa activități în acest curs';
$string['nopermissiontolock'] = 'Nu aveți permisiunea de a bloca!';
$string['nopermissiontomanagegroup'] = 'Nu aveți permisiunile necesare pentru a gestiona grupurile';
$string['nopermissiontorate'] = 'Evaluarea articolelor nu este permisă!';
$string['nopermissiontoshow'] = 'Nu aveți permisiunea de a vizualiza acest aspect!';
$string['nopermissiontounlock'] = 'Nu aveți permisiunea de a debloca!';
$string['nopermissiontoupdatecalendar'] = 'Ne pare rău, dar nu aveți permisiunea de a actualiza evenimentul din calendar.';
$string['nopermissiontoviewcalendar'] = 'Ne pare rău, dar nu aveți permisiunea să vedeți evenimentul din calendar.';
$string['nopermissiontoviewgrades'] = 'Nu se pot vizualiza notele.';
$string['nopermissiontoviewletergrade'] = 'Lipsește permisiunea pentru a vizualiza notele literelor';
$string['nopermissiontoviewpage'] = 'Nu aveți voie să vizionați această pagină';
$string['nosite'] = 'Nu s-a putut găsi un curs de nivel superior!';
$string['nositeid'] = 'Niciun identificator de site';
$string['nostartdatenoenddate'] = 'O dată de încheiere a cursului poate fi setată, numai dacă este stabilită și o dată de începere.';
$string['nostatstodisplay'] = 'Ne pare rău, nu există date disponibile de afișat';
$string['notallowedtoupdateprefremotely'] = 'Nu aveți permisiunea să actualizați această preferință de utilizator de la distanță';
$string['notavailable'] = 'Acest aspect nu este disponibil în prezent';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Nu sunteți membru al acestui grup de cursuri';
$string['notownerofkey'] = 'Nu sunteți proprietarul acestei chei';
$string['nousers'] = 'Nu există un astfel de utilizator!';
$string['oauth1accesstoken'] = 'Eroare OAuth 1.0: Nu am obținut token-ul de acces.';
$string['oauth1requesttoken'] = 'Eroare OAuth 1.0: Nu am obținut token-ul de solicitare - este posibil ca furnizorul de servicii să nu fie momentan disponibil.';
$string['oauth2refreshtokenerror'] = 'Cheia OAuth 2 nu a putut fi actualizată. Status-ul HTTP pentru conectorul la distanță: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Nu s-a putut reîmprospăta indicativul OAuth 2 pentru unul sau mai mulți emitenți. Vedeți rezultatul sarcinii pentru detalii.';
$string['oauth2upgradetokenerror'] = 'Nu se poate actualiza token-ul OAuth 2. Status-ul HTTP pentru conectorul la distanță: {$a}';
$string['onlyadmins'] = 'Doar administratorii pot face asta';
$string['onlyeditingteachers'] = 'Doar profesorii de editare pot face asta';
$string['onlyeditown'] = 'Puteți edita doar propriile informații';
$string['orderidnotfound'] = 'ID-ul comenzii {$a} nu a fost găsit';
$string['pagenotexist'] = 'A apărut o eroare neobișnuită (s-a încercat accesarea unei pagini care nu există)';
$string['pagenotexisttitle'] = 'Eroare 404: Fișierul nu a fost găsit';
$string['pathdoesnotstartslash'] = 'Nu sunt furnizate argumente valabile, calea nu începe cu slash!';
$string['pleasereport'] = 'Dacă aveți timp, vă rugăm să ne anunțați ce ați încercat să faceți, atunci când a apărut eroarea:';
$string['pluginrequirementsnotmet'] = 'Plugin-ul „{$a->pluginname}” ({$a->pluginversion}) nu a putut fi instalat. Necesită o versiune mai nouă a Moodle (în prezent utilizați {$a->currentmoodle} și aveți nevoie de {$a->requiremoodle}).Pluginul „{$a->pluginname}” ({$a->pluginversion}) nu a putut fi instalat. Este necesară o versiune mai nouă a Moodle (în prezent utilizați {$a->currentmoodle}; deci, aveți nevoie de {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Pluginul „{$a->pluginname}” {$a->pluginversion} nu acceptă această versiune de Moodle {$a->moodleversion}. Căutați informații despre plugin pentru a găsi versiuni acceptate.';
$string['prefixcannotbeempty'] = '<p>Eroare: prefixul tabelului bazei de date nu poate fi gol ({$a}) </p>
<p> Administratorul site-ului trebuie să remedieze această problemă. </p>';
$string['prefixtoolong'] = '<p>Eroare: prefixul tabelului bazei de date este prea lung ({$a->dbfamily}) </p>
<p> Administratorul site-ului trebuie să remedieze această problemă. Lungimea maximă pentru prefixele tabelelor din {$a->dbfamily} este de {$a->maxlength} caractere.</p>';
$string['privatefilesupload'] = 'Încărcarea directă în zona de fișiere private a utilizatorului nu mai este acceptată. Încărcați într-o zonă de schiță și apoi mutați fișierele cu core_user::add_user_private_files';
$string['processingstops'] = 'Procesarea se oprește aici. Înregistrările rămase au fost ignorate.';
$string['protected_cc_not_supported'] = 'Cartușele protejate nu sunt acceptate.';
$string['querystringcannotbeempty'] = 'Șirul de interogare nu poate fi gol.';
$string['redirecterrordetected'] = 'A fost detectată o redirecționare neacceptată, executarea scriptului a fost încheiată';
$string['refoundto'] = 'Poate fi rambursat la {$a}';
$string['refoundtoorigi'] = 'Rambursat la suma inițială: {$a}';
$string['registrationdisabled'] = 'Înregistrarea este dezactivată pe acest site';
$string['remotedownloaderror'] = '<p>Descărcarea componentei pe serverul dvs. nu a reușit. Vă rugăm să verificați setările proxy; extensia PHP cURL este foarte recomandată.</p>
<p>Trebuie să descărcați manual fișierul <a href="{$a->url}">{$a->url}</a>, copiați-l în „{$a->dest}" de pe server și dezarhivați-l Acolo.</p>';
$string['remotedownloadnotallowed'] = 'Descărcarea componentelor pe serverul dvs. nu este permisă (allow_url_fopen este dezactivat). <br /> <br /> Trebuie să descărcați <a href="{$a->url}">{$a->url}</a> fișierul manual, să-l copiați în „{$a->dest}” de pe serverul dvs. și să-l dezarhivați acolo.';
$string['reportnotavailable'] = 'Acest tip de raport este disponibil numai pentru cursul site-ului';
$string['requirecorrectaccess'] = 'Adresa URL sau portul nu este valid.';
$string['requireloginerror'] = 'Cursul sau activitatea nu sunt accesibile.';
$string['restore_path_element_missingmethod'] = 'Metoda de restaurare {$a} lipsește. Trebuie definit de un dezvoltator.';
$string['restore_path_element_noobject'] = 'Restaurarea obiectului {$a} nu este un obiect.';
$string['restorechecksumfailed'] = 'S-a întâmplat o problemă cu informațiile de restaurare stocate în sesiunea dvs. Vă rugăm să verificați limitele dimensiunii pachetului de memorie PHP/DB. Restabilirea a fost oprită.';
$string['restrictedcontextexception'] = 'Ne pare rău, executarea funcției externe încalcă restricțiile de context.';
$string['restricteduser'] = 'Ne pare rău, dar contul dvs. curent „{$a}” este restricționat să facă acest lucru';
$string['reverseproxyabused'] = 'Proxy invers a fost activat, serverul nu poate fi accesat direct.<br />Vă rugăm să contactați administratorul serverului.';
$string['rpcerror'] = 'Of! Comunicarea dvs. MNET a eșuat! Iată mesajul de eroare pe care trebuie să îl transmiteți administratorului: {$a}';
$string['scheduledbackupsdisabled'] = 'Copiile de rezervă programate au fost dezactivate de administratorul serverului';
$string['secretalreadyused'] = 'Linkul de confirmare a modificării parolei a fost deja utilizat, parola nu a fost modificată';
$string['sectionnotexist'] = 'Această secțiune nu există';
$string['sendmessage'] = 'Trimite mesaj';
$string['sendmessagesent'] = 'Vă mulțumim pentru feedback-ul în legătură cu:<br>{$a}';
$string['serverconnection'] = 'Eroare la conectarea la server';
$string['servicedonotexist'] = 'Serviciul nu există';
$string['sessioncookiesdisable'] = 'Utilizarea incorectă a require_key_login () - cookie-urile de sesiune trebuie să fie dezactivate!';
$string['sessiondiskfull'] = 'Partiția sesiunii este plină. Conectarea este imposibilă în acest moment. Vă rugăm să anunțați administratorul serverului.';
$string['sessionerroruser'] = 'Sesiunea dvs. a expirat. Vă rugăm să vă logați din nou.';
$string['sessionerroruser2'] = 'A fost detectată o eroare de server care vă afectează sesiunea de conectare. Vă rugăm să vă conectați din nou sau să reporniți browserul.';
$string['sessionexpired'] = 'Sesiune expirată';
$string['sessionhandlerproblem'] = 'Handler-ul sesiunii este configurat greșit';
$string['sessionipnomatch'] = 'Ne pare rău, dar numărul dvs. IP pare să se fi schimbat de la prima conectare. Această caracteristică de securitate împiedică cracker-ii să vă fure identitatea în timp ce sunteți conectat la acest site. Utilizatorii normali nu ar trebui să vadă acest mesaj - vă rugăm să cereți ajutorul administratorului site-ului.';
$string['sessionipnomatch2'] = '<p>Ne pare rău, dar IP-ul tău  pare să se fi schimbat de la prima conectare. Această caracteristică de securitate împiedică cracker-ii să vă fure identitatea în timp ce sunteți conectat la acest site. Puteți vedea această eroare, dacă utilizați rețele fără fir sau dacă faceți roaming între diferite rețele. Puteți apela la ajutorul administratorului site-ului.</p>
<p>Dacă doriți să continuați, apăsați tasta F5 pentru a actualiza această pagină.</p>';
$string['sessionwaiterr'] = 'A expirat în timp ce așteptați blocarea sesiunii. <br /> Așteptați finalizarea solicitărilor dvs. curente și încercați din nou mai târziu.';
$string['shortnametaken'] = 'Numele prescurtate sunt deja utilizate pentru un alt curs ({$a})';
$string['sitepolicynotagreed'] = 'Nu ați aprobat Politica site-ului: <a href="{$a}"> Faceți click aici, pentru a deschide politica site-ului.</a>';
$string['socksnotsupported'] = 'Proxy-ul SOCKS5 nu este acceptat în PHP4';
$string['spellcheckernotconf'] = 'Verificatorul ortografic nu este configurat';
$string['sslonlyaccess'] = 'Din motive de securitate, numai conexiunile https sunt permise, ne pare rău.';
$string['statscatchupmode'] = 'Statisticile sunt în prezent în modul de recuperare. Până în prezent s-au procesat {$a->daysdone} zile și {$a->dayspending} sunt în așteptare. Verificați din nou în curând!';
$string['statsdisable'] = 'Statisticile nu sunt activate.';
$string['statsnodata'] = 'Nu există date disponibile pentru acea combinație de curs și perioadă de timp';
$string['storedfilecannotcreatefile'] = 'Nu se poate crea  local file pool file. Vă rugăm să verificați permisiunile din dataroot și spațiul disponibil pe disc.';
$string['storedfilecannotcreatefiledirs'] = 'Nu se pot crea depozite locale de fișiere. Vă rugăm să verificați permisiunile în dataroot.';
$string['storedfilecannotread'] = 'Nu se poate citi fișierul. Fie fișierul nu există, fie există o problemă de permisiune.';
$string['storedfilecannotreadfile'] = 'Nu se poate citi fișierul "{$a}". Fie fișierul nu există, fie există o problemă de permisiune.';
$string['storedfilenotcreated'] = 'Nu se poate crea fișierul {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Excepție necunoscută legată de fișierele locale ({$a})';
$string['tagdisabled'] = 'Etichetele sunt dezactivate!';
$string['tagnotfound'] = 'Eticheta specificată nu a fost găsită în baza de date';
$string['targetdatabasenotempty'] = 'Baza de date țintă nu este goală. Transferul a fost întrerupt din motive de siguranță.';
$string['textconditionsnotallowed'] = 'Nu sunt permise comparații ale condițiilor coloanei de text. Vă rugăm să utilizați sql_compare_text () în interogarea dvs.';
$string['themenotinstall'] = 'Această temă nu este instalată!';
$string['tokengenerationfailed'] = 'Nu se poate genera un nou token.';
$string['transactionvoid'] = 'Tranzacția nu poate fi anulată, deoarece a fost deja anulată';
$string['unenrolerror'] = 'A apărut o eroare la încercarea de anulare a persoanei respective';
$string['unicodeupgradeerror'] = 'Ne pare rău, dar baza de date nu este deja în Unicode, iar această versiune de Moodle nu poate migra baza de date în Unicode. Vă rugăm să faceți upgrade la Moodle 1.7.x mai întâi și să efectuați migrarea Unicode din pagina Admin. După ce ați terminat, ar trebui să puteți migra la Moodle {$a}';
$string['unknowaction'] = 'Acțiune necunoscută!';
$string['unknowcategory'] = 'Categorie necunoscută!';
$string['unknowcontext'] = 'Acesta este un context necunoscut ({$a}) în get_child_contexts!';
$string['unknowformat'] = 'Format necunoscut ({$a})';
$string['unknownbackupexporterror'] = 'Eroare necunoscută la pregătirea informațiilor pentru import';
$string['unknownblockregion'] = 'Regiunea de blocare „{$a}” nu este recunoscută pe această pagină.';
$string['unknowncontext'] = 'Acesta este un context necunoscut.';
$string['unknowncourse'] = 'Curs necunoscut numit "{$a}"';
$string['unknowncourseidnumber'] = 'Identificator curs necunoscut "{$a}"';
$string['unknowncourserequest'] = 'Cerere de curs necunoscută';
$string['unknowncoursesection'] = 'Secțiune de curs necunoscută în curs "{$a}"';
$string['unknownevent'] = 'Eveniment necunoscut';
$string['unknownfiletype'] = 'Eroare tip de filtru necunoscut';
$string['unknowngroup'] = 'Grup necunoscut "{$a}"';
$string['unknownhelp'] = 'Subiect de ajutor necunoscut {$a}';
$string['unknownjsinrequirejs'] = 'Nu se poate găsi biblioteca JavaScript: {$a}';
$string['unknownmodulename'] = 'Numele modulului necunoscut pentru formular';
$string['unknownrole'] = 'Rol necunoscut "{$a}"';
$string['unknownsortcolumn'] = 'Coloana de sortare necunoscută {$a}';
$string['unknownuseraction'] = 'Ne pare rău, nu înțeleg această acțiune a utilizatorului';
$string['unknownuserselector'] = 'Selector de utilizator necunoscut';
$string['unknoworder'] = 'Ordine necunoscută';
$string['unknowparamtype'] = 'Tip de parametru necunoscut: {$a}';
$string['unknowquestiontype'] = 'Tip de întrebare neacceptat {$a}';
$string['unknowuploadaction'] = 'Eroare: acțiune de încărcare necunoscută ({$a})';
$string['unspecifycourseid'] = 'Trebuie să specifici ID-ul cursului, numele scurt sau numărul de identificare';
$string['unsupportedevent'] = 'Tipul evenimentului neacceptat';
$string['unsupportedstate'] = 'Stare de finalizare neacceptată';
$string['unsupportedwebserver'] = 'Softul web server ({$a}) nu este acceptat, ne pare rău.';
$string['upgraderequires19'] = 'Eroare: Noua versiune Moodle a fost instalată pe server; din păcate, actualizarea de la versiunea anterioară nu este acceptată.<br />Vă rugăm să faceți upgrade mai întâi la cea mai recentă versiune 1.9.x. De asemenea, puteți reveni la versiunea anterioară, reinstalând fișierele originale.';
$string['upgraderunning'] = 'Site-ul este în curs de actualizare. Încercați din nou mai târziu.';
$string['urlnotdefinerss'] = 'Adresa URL nu este definită pentru fluxul RSS';
$string['useradmineditadmin'] = 'Doar administratorii au dreptul să modifice alte conturi de administrator';
$string['useradminodelete'] = 'Conturile de administrator nu pot fi șterse.';
$string['userautherror'] = 'Plugin de autentificare necunoscut';
$string['userauthunsupported'] = 'Plugin-ul de autentificare nu este acceptat aici';
$string['useremailduplicate'] = 'Adresă duplicat';
$string['usermustbemnet'] = 'Utilizatorii din lista de control acces MNET trebuie să fie utilizatori MNET la distanță';
$string['usernamelowercase'] = 'Numele de utilizator trebuie să fie scris cu litere mici';
$string['usernotaddederror'] = 'Utilizatorul nu a fost adăugat - eroare';
$string['usernotaddedregistered'] = 'Utilizatorul nu a fost adăugat - este deja înregistrat';
$string['usernotavailable'] = 'Detaliile acestui utilizator nu vă sunt disponibile';
$string['usernotdeletedadmin'] = 'Utilizatorul nu a fost șters deoarece nu se pot șterge conturile de administrator';
$string['usernotdeleteddeleted'] = 'Acest utilizator a fost șters.';
$string['usernotdeletederror'] = 'Utilizatorul nu a fost șters - eroare';
$string['usernotdeletedmissing'] = 'Utilizatorul nu a fost șters - nu a putut găsi numele de utilizator';
$string['usernotdeletedoff'] = 'Utilizatorul nu a fost șters - ștergerea nu este permisă';
$string['usernotfullysetup'] = 'Utilizatorul nu este complet configurat';
$string['usernotincourse'] = 'Acest utilizator nu face parte din acest curs!';
$string['usernotrenamedadmin'] = 'Nu se pot redenumi conturile de administrator';
$string['usernotrenamedexists'] = 'Utilizatorul nu a fost redenumit - noul nume de utilizator este deja utilizat';
$string['usernotrenamedmissing'] = 'Utilizatorul nu a fost redenumit - nu s-a putut găsi vechiul nume de utilizator';
$string['usernotrenamedoff'] = 'Utilizatorul nu a fost redenumit - redenumirea nu este permisă';
$string['usernotupdatedadmin'] = 'Nu se pot actualiza conturile de administrator';
$string['usernotupdatederror'] = 'Utilizatorul nu a fost actualizat - eroare';
$string['usernotupdatednotexists'] = 'Utilizatorul nu este actualizat - nu există';
$string['userquotalimit'] = 'Ați atins limita cotei de fișiere.';
$string['userselectortoomany'] = 'user_selector a primit mai mult de un utilizator selectat, chiar dacă selectarea multiplă este falsă.';
$string['verifyagedigitalconsentnotpossible'] = 'Ne pare rău, verificarea consimțământului vârstei digitale nu este posibilă în acest moment.';
$string['wrongcall'] = 'Acest script este denumit greșit';
$string['wrongcontextid'] = 'Identificatorul contextului a fost incorect (nu poate fi găsit)';
$string['wrongdestpath'] = 'Cale de destinație greșită';
$string['wrongroleid'] = 'ID rol incorect!';
$string['wrongsourcebase'] = 'Baza de adrese URL sursă este greșită';
$string['wrongusernamepassword'] = 'Utilizator/ parolă greșite';
$string['wrongzipfilename'] = 'Numele fișierului ZIP greșit';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Nu s-a putut crea cursul - Fără permisiune';
$string['wwwrootmismatch'] = 'A fost detectat un acces incorect, acest server poate fi accesat numai prin adresa „{$a}”, îmi pare rău.<br />Vă rugăm să informați administratorul serverului.';
$string['wwwrootslash'] = 'S-a detectat $CFG->wwwroot incorect(ă) în config.php, nu trebuie să conțină slash-ul final.<br />Vă rugăm să informați administratorul serverului.';
$string['xmldberror'] = 'Eroare XMLDB!';
$string['youcannotdeletecategory'] = 'Nu poți șterge categoria "{$a}", deoarece nu poți șterge conținutul și nici nu îl poți muta în altă parte.';
