<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'fr', version '4.0'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Le processus de sauvegarde s\'est terminé';
$string['asyncbackupcompletebutton'] = 'Continuer';
$string['asyncbackupcompletedetail'] = 'Le processus de sauvegarde s\'est terminé correctement.<br />Vous pouvez accéder à la sauvegarde sur la <a href="{$a}">page de restauration</a>.';
$string['asyncbackuperror'] = 'Le processus de sauvegarde a échoué';
$string['asyncbackuperrordetail'] = 'Le processus de sauvegarde a échoué. Veuillez contacter l\'administrateur de votre système.';
$string['asyncbackuppending'] = 'Le processus de sauvegarde est en attente';
$string['asyncbackupprocessing'] = 'Le processus de sauvegarde est en cours';
$string['asyncbadexecution'] = 'Erreur d\'exécution du contrôleur de sauvegarde. Devrait être 2, au lieu de {$a}.';
$string['asynccheckprogress'] = 'Vous pouvez vérifier la progression à tout moment sur la <a href="{$a}">page de restauration</a>.';
$string['asyncemailenable'] = 'Activer les messages de notification';
$string['asyncemailenabledetail'] = 'Si ce réglage est activé, les utilisateurs recevront un message lorsqu\'une sauvegarde ou une restauration asynchrone se termine.';
$string['asyncgeneralsettings'] = 'Sauvegarde/restauration asynchrone';
$string['asyncmessagebody'] = 'Message';
$string['asyncmessagebodydefault'] = 'Votre {operation} (ID : {backupid}) s\'est terminée correctement. Vous pouvez la trouver ici : <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Message à envoyer au terme d\'une sauvegarde ou d\'une restauration asynchrone.';
$string['asyncmessagesubject'] = 'Objet';
$string['asyncmessagesubjectdefault'] = '{operation} de Moodle terminée correctement';
$string['asyncmessagesubjectdetail'] = 'Objet du message';
$string['asyncnowait'] = 'Il n\'est pas nécessaire d\'attendre ici, car le processus continue en tâche de fond.';
$string['asyncprocesspending'] = 'Processus en attente';
$string['asyncrestorecomplete'] = 'Le processus de restauration est terminé';
$string['asyncrestorecompletebutton'] = 'Continuer';
$string['asyncrestorecompletedetail'] = 'Le processus de restauration s\'est terminé correctement. Après avoir cliqué sur « Continuer », vous serez dirigé vers le <a href="{$a}">cours de l\'élément restauré</a>.';
$string['asyncrestoreerror'] = 'Le processus de restauration a échoué';
$string['asyncrestoreerrordetail'] = 'Le processus de restauration a échoué. Veuillez contacter l\'administrateur de votre système.';
$string['asyncrestoreinprogress'] = 'Restauration en cours';
$string['asyncrestoreinprogress_help'] = 'Les restaurations de cours asynchrones en cours sont affichées ici.';
$string['asyncrestorepending'] = 'Le processus de restauration est en attente';
$string['asyncrestoreprocessing'] = 'La restauration est en cours';
$string['asyncreturn'] = 'Retourner au cours';
$string['autoactivedescription'] = 'Ce réglage permet d\'activer ou non les sauvegardes automatiques. Si l\'option « Manuelle » est sélectionnée, les sauvegardes automatiques ne pourront avoir lieu que via le script en ligne de commande, lancé manuellement ou via un cron spécifique.';
$string['autoactivedisabled'] = 'Désactivée';
$string['autoactiveenabled'] = 'Activée';
$string['autoactivemanual'] = 'Manuelle';
$string['automatedbackupschedule'] = 'Planification';
$string['automatedbackupschedulehelp'] = 'Choisissez le jour de la semaine durant lequel lancer les sauvegardes automatiques.';
$string['automatedbackupsinactive'] = 'Les sauvegardes automatiques n\'ont pas été activées par l\'administrateur du site';
$string['automatedbackupstatus'] = 'Statut des sauvegardes automatiques';
$string['automateddeletedays'] = 'Supprimer les sauvegardes plus anciennes que';
$string['automatedmaxkept'] = 'Nombre maximal de sauvegardes conservées';
$string['automatedmaxkepthelp'] = 'Ce réglage spécifie le nombre maximal de sauvegardes automatiques récentes à conserver pour chaque cours. Les sauvegardes plus anciennes sont supprimées automatiquement.';
$string['automatedminkept'] = 'Nombre minimal de sauvegardes conservées';
$string['automatedminkepthelp'] = 'Si des sauvegardes plus anciennes qu\'un nombre spécifié de jours sont supprimées, il peut arriver qu\'un cours inactif n\'ait plus de sauvegarde. Afin d\'éviter ceci, un nombre minimal de sauvegardes conservées doit être spécifié.';
$string['automatedsettings'] = 'Réglages de la sauvegarde programmée';
$string['automatedsetup'] = 'Sauvegarde automatique';
$string['automatedstorage'] = 'Stockage des sauvegardes automatiques';
$string['automatedstoragehelp'] = 'Spécifier l\'endroit où les sauvegardes doivent être enregistrées quand elles sont créées automatiquement.';
$string['backupactivity'] = 'Sauvegarde activité : {$a}';
$string['backupautoactivitiesdescription'] = 'Détermine si par défaut les activités sont incluses dans les sauvegardes. Pour que la corbeille fonctionne, ce réglage doit être activé.';
$string['backupcourse'] = 'Sauvegarde cours : {$a}';
$string['backupcoursedetails'] = 'Informations sur le cours';
$string['backupcoursesection'] = 'Section : {$a}';
$string['backupcoursesections'] = 'Sections du cours';
$string['backupdate'] = 'Date de la sauvegarde';
$string['backupdetails'] = 'Informations sur la sauvegarde';
$string['backupdetailsnonstandardinfo'] = 'Le fichier sélectionné n\'est pas un fichier de sauvegarde standard de Moodle. Le processus de restauration va tenter de le convertir dans le format standard, puis de le restaurer.';
$string['backupformat'] = 'Format';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Format inconnu';
$string['backuplog'] = 'Informations techniques et avertissements';
$string['backupmode'] = 'Mode';
$string['backupmode10'] = 'Général';
$string['backupmode20'] = 'Importer';
$string['backupmode30'] = 'Serveur d\'échanges';
$string['backupmode40'] = 'Même site';
$string['backupmode50'] = 'Automatisé';
$string['backupmode60'] = 'Converti';
$string['backupmode70'] = 'Asynchrone';
$string['backupsection'] = 'Sauvegarde section de cours : {$a}';
$string['backupsettings'] = 'Réglages des sauvegardes';
$string['backupsitedetails'] = 'Informations sur le site';
$string['backupstage16action'] = 'Continuer';
$string['backupstage1action'] = 'Suivant';
$string['backupstage2action'] = 'Suivant';
$string['backupstage4action'] = 'Effectuer la sauvegarde';
$string['backupstage8action'] = 'Continuer';
$string['backuptype'] = 'Type';
$string['backuptypeactivity'] = 'Activité';
$string['backuptypecourse'] = 'Cours';
$string['backuptypesection'] = 'Section';
$string['backupversion'] = 'Version de sauvegarde';
$string['cannotfindassignablerole'] = 'Le rôle {$a} du fichier de sauvegarde ne peut être mis en correspondance avec aucun des rôles que vous pouvez attribuer.';
$string['choosefilefromactivitybackup'] = 'Zone de sauvegarde d\'activités';
$string['choosefilefromactivitybackup_help'] = 'Les sauvegardes d\'activités effectuées avec les réglages par défaut sont enregistrées ici.';
$string['choosefilefromautomatedbackup'] = 'Sauvegardes automatiques';
$string['choosefilefromautomatedbackup_help'] = 'Contient les sauvegardes créées automatiquement';
$string['choosefilefromcoursebackup'] = 'Zone de sauvegarde de cours';
$string['choosefilefromcoursebackup_help'] = 'Les sauvegardes de cours effectuées avec les réglages par défaut sont enregistrées ici.';
$string['choosefilefromuserbackup'] = 'Zone de sauvegarde privée';
$string['choosefilefromuserbackup_help'] = 'Les sauvegardes effectuées avec l\'option d\'anonymisation des utilisateurs sont enregistrées ici.';
$string['config_keep_groups_and_groupings'] = 'Conserver par défaut les groupes et groupements actuels.';
$string['config_keep_roles_and_enrolments'] = 'Conserver par défaut les rôles et inscriptions actuels.';
$string['config_overwrite_conf'] = 'Permet à l\'utilisateur d\'écraser la configuration du cours actuel.';
$string['config_overwrite_course_fullname'] = 'Par défaut, remplacer le nom complet du cours avec celui indiqué dans le fichier de sauvegarde. Ce réglage requiert l\'activation de « Écraser la configuration du cours ». L\'utilisateur doit avoir en outre la capacité de modifier le nom complet du cours (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Par défaut, remplacer le nom abrégé du cours avec celui indiqué dans le fichier de sauvegarde. Ce réglage requiert l\'activation de « Écraser la configuration du cours ». L\'utilisateur doit avoir en outre la capacité de modifier le nom abrégé du cours (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Par défaut, remplacer la date de début du cours avec celle indiquée dans le fichier de sauvegarde. Ce réglage requiert l\'activation de « Écraser la configuration du cours ». L\'utilisateur doit avoir en outre la capacité de décaler les dates du cours (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Détermine le réglage par défaut pour l\'inclusion des activités dans les sauvegardes.';
$string['configgeneralanonymize'] = 'Détermine le réglage par défaut pour l\'anonymisation de toutes les données relatives aux utilisateurs dans les sauvegardes.';
$string['configgeneralbadges'] = 'Détermine le réglage par défaut pour l\'inclusion des badges dans les sauvegardes.';
$string['configgeneralblocks'] = 'Détermine le réglage par défaut pour l\'inclusion des blocs dans les sauvegardes.';
$string['configgeneralcalendarevents'] = 'Détermine le réglage par défaut pour l\'inclusion des événements de calendrier dans les sauvegardes.';
$string['configgeneralcomments'] = 'Détermine le réglage par défaut pour l\'inclusion des commentaires dans les sauvegardes.';
$string['configgeneralcompetencies'] = 'Détermine le réglage par défaut pour l\'inclusion des compétences dans les sauvegardes.';
$string['configgeneralcontentbankcontent'] = 'Détermine le réglage par défaut pour l\'inclusion de la banque de contenus dans les sauvegardes.';
$string['configgeneralfiles'] = 'Détermine le réglage par défaut pour l\'inclusion des fichiers dans les sauvegardes. Remarque : la désactivation de ce réglage aura pour conséquence que la sauvegarde ne contiendra que des références vers les fichiers. Ceci n\'est pas un problème si la sauvegarde est restaurée sur le même site et si les fichiers n\'ont pas été supprimés selon le réglage « Nettoyer les fichiers supprimés ».';
$string['configgeneralfilters'] = 'Détermine le réglage par défaut pour l\'inclusion des filtres dans les sauvegardes.';
$string['configgeneralgroups'] = 'Détermine le réglage par défaut pour l’inclusion des groupes et groupements dans les sauvegardes.';
$string['configgeneralhistories'] = 'Détermine le réglage par défaut pour l\'inclusion du journal des activités des utilisateurs dans les sauvegardes.';
$string['configgenerallogs'] = 'Détermine le réglage par défaut pour l\'inclusion des journaux dans les sauvegardes.';
$string['configgeneralpermissions'] = 'Si ce réglage est activé, les permissions de rôles seront importées. Elles pourraient alors écraser des permissions existantes pour des utilisateurs existants.';
$string['configgeneralquestionbank'] = 'Si ce réglage est activé, la banque de questions sera par défaut incluse dans les sauvegardes.
Remarque : la désactivation de ce réglage empêchera la sauvegarde des activités qui utilisent la banque de questions, comme les activités test.';
$string['configgeneralroleassignments'] = 'Détermine le réglage par défaut pour l\'inclusion des attributions de rôles dans les sauvegardes.';
$string['configgeneralusers'] = 'Détermine le réglage par défaut pour l\'inclusion des utilisateurs dans les sauvegardes.';
$string['configgeneraluserscompletion'] = 'Détermine le réglage par défaut pour l\'inclusion des informations d\'achèvement d\'activité dans les sauvegardes.';
$string['configlegacyfiles'] = 'Ce réglage détermine s\'il faut inclure les fichiers de cours obsolètes dans les sauvegardes. Les fichiers de cours obsolètes proviennent de versions de Moodle antérieures à la version 2.0.';
$string['configloglifetime'] = 'Cette valeur spécifie la durée pendant laquelle vous voulez conserver les journaux des sauvegardes. Les journaux plus anciens seront supprimés automatiquement. Il est recommandé d\'indiquer une valeur faible, car les informations stockées dans ces journaux peuvent être énormes.';
$string['configrestoreactivities'] = 'Détermine le réglage par défaut pour la restauration des activités.';
$string['configrestorebadges'] = 'Détermine le réglage par défaut pour la restauration des badges.';
$string['configrestoreblocks'] = 'Détermine le réglage par défaut pour la restauration des blocs.';
$string['configrestorecalendarevents'] = 'Détermine le réglage par défaut pour la restauration des événements de calendrier.';
$string['configrestorecomments'] = 'Détermine le réglage par défaut pour la restauration des commentaires.';
$string['configrestorecompetencies'] = 'Détermine le réglage par défaut pour la restauration des compétences.';
$string['configrestorecontentbankcontent'] = 'Définit le réglage de restauration de contenu de la banque de contenus.';
$string['configrestoreenrolments'] = 'Détermine le réglage par défaut pour la restauration des méthodes d\'inscription.';
$string['configrestorefilters'] = 'Détermine le réglage par défaut pour la restauration des filtres.';
$string['configrestoregroups'] = 'Détermine le réglage par défaut pour la restauration des groupes et groupements, lorsqu\'ils ont été inclus dans la sauvegarde.';
$string['configrestorehistories'] = 'Détermine le réglage par défaut pour la restauration des journaux, lorsqu\'ils ont été inclus dans la sauvegarde.';
$string['configrestorelogs'] = 'Si ce réglage est activé, les journaux seront restaurés par défaut s\'ils ont été inclus dans la sauvegarde.';
$string['configrestorepermissions'] = 'Si ce réglage est activé, les permissions de rôles seront restaurées. Elles pourraient alors écraser des permissions existantes pour des utilisateurs existants.';
$string['configrestoreroleassignments'] = 'Si ce réglage est activé, les attributions de rôles seront restaurées par défaut si elles ont été incluses dans la sauvegarde.';
$string['configrestoreusers'] = 'Détermine le réglage par défaut pour la restauration des utilisateurs, lorsqu\'ils ont été inclus dans la sauvegarde.';
$string['configrestoreuserscompletion'] = 'Si ce réglage est activé, les informations d\'achèvement des utilisateurs seront restaurées par défaut si elles ont été incluses dans la sauvegarde.';
$string['confirmcancel'] = 'Annuler la sauvegarde';
$string['confirmcancelimport'] = 'Annuler l\'importation';
$string['confirmcancelno'] = 'Ne pas annuler la sauvegarde';
$string['confirmcancelquestion'] = 'Voulez-vous vraiment annuler la sauvegarde ?
Toutes les informations saisies seront perdues.';
$string['confirmcancelrestore'] = 'Annuler la restauration';
$string['confirmcancelyes'] = 'Annuler la sauvegarde';
$string['confirmnewcoursecontinue'] = 'Avertissement de nouveau cours';
$string['confirmnewcoursecontinuequestion'] = 'Un cours temporaire (caché) va être créé lors du processus de restauration du cours. Pour annuler la restauration, cliquer sur Annuler. Ne pas fermer la fenêtre du navigateur durant la restauration.';
$string['copiesinprogress'] = 'Ce cours a des copies en cours. <a href="{$a}">Consulter les copies en cours.</a>';
$string['copycoursedesc'] = 'Ce cours sera dupliqué et placé dans la catégorie sélectionnée.';
$string['copycourseheading'] = 'Copier un cours';
$string['copycoursetitle'] = 'Copier le cours : {$a}';
$string['copydest'] = 'Destination';
$string['copyfieldnotfound'] = 'Un champ requis n\'a pas été trouvé pour {$a}';
$string['copyformfail'] = 'L\'envoi du formulaire de copie de cours a échoué.';
$string['copyingcourse'] = 'Copie de cours en cours';
$string['copyingcourseshortname'] = 'copie en cours';
$string['copyop'] = 'Opération actuelle';
$string['copyprogressheading'] = 'Copies de cours en cours';
$string['copyprogressheading_help'] = 'Cette table indique le statut de toutes vos copies de cours non terminées';
$string['copyprogresstitle'] = 'Progression de la copie de cours';
$string['copyreturn'] = 'Copier et revenir';
$string['copysource'] = 'Source';
$string['copyview'] = 'Copier et consulter';
$string['coursecategory'] = 'Catégorie où le cours sera restauré';
$string['courseid'] = 'Identifiant original';
$string['coursesettings'] = 'Réglages du cours';
$string['coursetitle'] = 'Titre';
$string['currentstage1'] = 'Réglages initiaux';
$string['currentstage16'] = 'Terminé';
$string['currentstage2'] = 'Réglages du schéma de sauvegarde';
$string['currentstage4'] = 'Confirmation';
$string['currentstage8'] = 'Effectuer la sauvegarde';
$string['enableasyncbackup'] = 'Activer les sauvegardes asynchrones';
$string['enableasyncbackup_help'] = 'Si ce réglage est activé, toutes les opérations de sauvegarde et de restauration seront effectuées de manière asynchrone. Ceci n\'impacte pas les importations et exportations. Les sauvegardes et restaurations asynchrones permettent aux utilisateurs d\'effectuer d\'autres opérations pendant qu\'une sauvegarde ou une restauration est en cours.';
$string['enterasearch'] = 'Saisir une expression à rechercher';
$string['error_block_for_module_not_found'] = 'Instance de bloc orpheline (id : {$a->bid}) trouvée dans un module de cours (id : {$a->mid}). Ce bloc ne sera pas sauvegardé.';
$string['error_course_module_not_found'] = 'Module de cours orphelin (id : {$a}) détecté. Ce module ne sera pas sauvegardé.';
$string['errorcopyingbackupfile'] = 'Échec de copie du fichier de sauvegarde vers le dossier temporaire avant restauration.';
$string['errorfilenamemustbezip'] = 'Le fichier doit être un fichier au format ZIP et son nom doit avoir l\'extension .mbz';
$string['errorfilenamerequired'] = 'Veuillez saisir un nom de fichier valide pour cette sauvegarde';
$string['errorfilenametoolong'] = 'Le nom du fichier ne doit pas dépasser 255 caractères.';
$string['errorinvalidformat'] = 'Format de sauvegarde inconnu';
$string['errorinvalidformatinfo'] = 'Le fichier sélectionné n\'est pas un fichier de sauvegarde Moodle valide et ne peut pas être restauré.';
$string['errorminbackup20version'] = 'Restauration impossible. Ce fichier de sauvegarde a été créé avec une version de développement du moteur de sauvegarde de Moodle ({$a->backup}). La version minimale requise pour la restaurer est {$a->min}.';
$string['errorrestorefrontpagebackup'] = 'Les sauvegardes de la page d\'accueil ne peuvent être restaurées que sur la page d\'accueil';
$string['executionsuccess'] = 'Le fichier de sauvegarde a été enregistré correctement.';
$string['extractingbackupfileto'] = 'Extraction du fichier de sauvegarde vers : {$a}';
$string['failed'] = 'Sauvegarde échouée';
$string['filealiasesrestorefailures'] = 'Échec de la restauration des alias';
$string['filealiasesrestorefailures_help'] = 'Les alias sont des liens vers d\'autres fichiers, y compris ceux qui sont stockés dans des dépôts externes. Dans certains cas, Moodle ne peut pas les restaurer, par exemple lors de la restauration de sauvegardes d\'un autre site ou si le fichier lié n\'existe pas.

Plus d\'informations sur la raison de l\'échec peuvent être trouvés dans le journal de restauration.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Certains alias inclus dans le fichier de sauvegarde n\'ont pas pu être restaurés. La liste ci-dessous contient leur emplacement attendu et le fichier source vers lequel ils pointaient dans le site original.';
$string['filename'] = 'Nom de fichier';
$string['filereferencesincluded'] = 'Des liens vers des contenus externes sont inclus dans le fichier de sauvegarde. Ces liens ne fonctionneront pas si la sauvegarde est restaurée sur un site différent.';
$string['filereferencesnotsamesite'] = 'Le fichier de sauvegarde provient d\'un site différent. Les liens vers des contenus externes ne peuvent donc pas être restaurés.';
$string['filereferencessamesite'] = 'Le fichier de sauvegarde provient de ce site. Les liens vers des contenus externes peuvent donc être restaurés.';
$string['generalactivities'] = 'Inclure les activités et ressources';
$string['generalanonymize'] = 'Anonymiser les informations';
$string['generalbackdefaults'] = 'Réglages généraux par défaut des sauvegardes';
$string['generalbadges'] = 'Inclure les badges';
$string['generalblocks'] = 'Inclure les blocs';
$string['generalcalendarevents'] = 'Inclure les événements de calendrier';
$string['generalcomments'] = 'Inclure les commentaires';
$string['generalcompetencies'] = 'Inclure les compétences';
$string['generalcontentbankcontent'] = 'Inclure le contenu de la banque de contenus';
$string['generalenrolments'] = 'Inclure les méthodes d\'inscription';
$string['generalfiles'] = 'Inclure les fichiers';
$string['generalfilters'] = 'Inclure les filtres';
$string['generalgradehistories'] = 'Inclure les historiques';
$string['generalgroups'] = 'Inclure les groupes et groupements';
$string['generalhistories'] = 'Inclure l\'historique des activités des utilisateurs';
$string['generallegacyfiles'] = 'Inclure les fichiers de cours obsolètes';
$string['generallogs'] = 'Inclure les journaux';
$string['generalpermissions'] = 'Inclure les dérogations de permissions';
$string['generalquestionbank'] = 'Inclure la banque de questions';
$string['generalrestoredefaults'] = 'Réglages généraux de restauration par défaut';
$string['generalrestoresettings'] = 'Réglages généraux de restauration';
$string['generalroleassignments'] = 'Inclure les attributions de rôles';
$string['generalsettings'] = 'Réglages généraux des sauvegardes';
$string['generalusers'] = 'Inclure les utilisateurs';
$string['generaluserscompletion'] = 'Inclure les informations d\'achèvement d\'activité';
$string['hidetypes'] = 'Cacher les types d\'options';
$string['importbackupstage16action'] = 'Continuer';
$string['importbackupstage1action'] = 'Suite';
$string['importbackupstage2action'] = 'Suite';
$string['importbackupstage4action'] = 'Effectuer l\'importation';
$string['importbackupstage8action'] = 'Continuer';
$string['importcurrentstage0'] = 'Sélection de cours';
$string['importcurrentstage1'] = 'Réglages initiaux';
$string['importcurrentstage16'] = 'Terminer';
$string['importcurrentstage2'] = 'Réglages du schéma';
$string['importcurrentstage4'] = 'Confirmation et relecture';
$string['importcurrentstage8'] = 'Effectuer l\'importation';
$string['importfile'] = 'Importer un fichier de sauvegarde';
$string['importgeneralduplicateadminallowed'] = 'Permettre la résolution de conflit admin';
$string['importgeneralduplicateadminallowed_desc'] = 'Lorsqu\'il existe sur la plateforme un compte dont le nom d\'utilisateur est « admin », la restauration d\'un fichier de sauvegarde contenant un compte avec ce même nom d\'utilisateur causera un conflit. Si ce réglage est activé, le conflit sera résolu en changeant le nom d\'utilisateur en « admin_xyz ».';
$string['importgeneralmaxresults'] = 'Nombre maximal de cours listés pour importation';
$string['importgeneralmaxresults_desc'] = 'Ce réglage détermine le nombre de cours qui sont listés lors de la première étape du processus d\'importation';
$string['importgeneralsettings'] = 'Réglages généraux d\'importation par défaut';
$string['importrootsettings'] = 'Réglages d\'importation';
$string['importsettings'] = 'Réglages généraux d\'importation';
$string['importsuccess'] = 'Importation terminée. Cliquer sur continuer pour revenir au cours.';
$string['includeactivities'] = 'Inclure :';
$string['includeditems'] = 'Éléments inclus :';
$string['includefilereferences'] = 'Liens vers des contenus externes';
$string['includesection'] = 'Section {$a}';
$string['includeuserinfo'] = 'Données utilisateur';
$string['inprogress'] = 'Sauvegarde en cours';
$string['jumptofinalstep'] = 'Passer à la dernière étape';
$string['keep'] = 'Conserver';
$string['keptroles'] = 'Inclure les inscriptions de rôle';
$string['keptroles_help'] = 'Les utilisateurs ayant les rôles sélectionnés seront inscrits avec ce ces rôles dans le nouveau cours. Aucune donnée utilisateur ne sera copiée, à moins que l\'option « Inclure les données utilisateur » soit activée.';
$string['locked'] = 'Verrouillé';
$string['lockedbyconfig'] = 'Ce réglage a été verrouillé par les réglages par défaut des sauvegardes';
$string['lockedbyhierarchy'] = 'Verrouillé en raison de contraintes';
$string['lockedbypermission'] = 'Vous n\'avez pas les permissions requises pour modifier ce réglage';
$string['loglifetime'] = 'Conserver les journaux durant';
$string['managefiles'] = 'Gérer les fichiers de sauvegarde';
$string['mergerestoredefaults'] = 'Restaurer les réglages par défaut lors de la fusion dans un autre cours';
$string['missingfilesinpool'] = 'Certains fichiers n\'ont pas pu être enregistrés durant la sauvegarde. Ils ne pourront donc pas être restaurés.';
$string['module'] = 'Module';
$string['moodleversion'] = 'Version de Moodle';
$string['morecoursesearchresults'] = 'Plus de {$a} cours trouvés, affichage des {$a} premiers';
$string['moreresults'] = 'Il y a trop de résultats. Veuillez saisir une expression à rechercher plus spécifique.';
$string['nomatchingcourses'] = 'Aucun cours à afficher';
$string['norestoreoptions'] = 'Il n\'y a pas de catégorie, ni de cours où effectuer la restauration.';
$string['originalwwwroot'] = 'URL de la sauvegarde';
$string['overwrite'] = 'Écraser';
$string['pendingasyncdeletedetail'] = 'Ce cours a une sauvegarde asynchrone en attente.<br/>Les cours ne peuvent pas être supprimés avant que cette sauvegarde soit terminée.';
$string['pendingasyncdetail'] = 'Les sauvegardes asynchrones ne permettent à un utilisateur d\'avoir en attente qu\'une sauvegarde pour une ressource à la fois.<br />Il n\'est pas possible de mettre en attente plusieurs sauvegardes asynchrones de la même ressource, car cela aurait pour conséquence probable plusieurs sauvegardes du même contenu.';
$string['pendingasyncedit'] = 'Une sauvegarde asynchrone de ce cours est en attente ou une copie en a été demandée. Veuillez ne pas modifier ce cours avant la fin de l\'opération.';
$string['pendingasyncerror'] = 'Sauvegarde de cette ressource en attente';
$string['preparingdata'] = 'Préparation des données';
$string['preparingui'] = 'Préparation de l\'affichage de la page';
$string['previousstage'] = 'Étape précédente';
$string['privacy:metadata:backup:detailsofarchive'] = 'Cette archive contient diverses données en lien avec un cours, telles que notes, inscriptions d\'utilisateurs et données d\'activités.';
$string['privacy:metadata:backup:externalpurpose'] = 'La finalité de cette archive est d\'enregistrer des informations en lien avec un cours, qui pourra être restauré ultérieurement.';
$string['privacy:metadata:backup_controllers'] = 'La liste des opérations de sauvegarde';
$string['privacy:metadata:backup_controllers:itemid'] = 'L\'identifiant du cours';
$string['privacy:metadata:backup_controllers:operation'] = 'L\'opération qui a été effectuée, par exemple restauration.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'La date à laquelle l\'action a été créée';
$string['privacy:metadata:backup_controllers:timemodified'] = 'L\'heure à laquelle l\'action a été modifiée';
$string['privacy:metadata:backup_controllers:type'] = 'Le type de l\'élément sur lequel l\'opération est effectuée, par exemple l\'activité.';
$string['qcategory2coursefallback'] = 'La catégorie de questions « {$a->name} », située dans le contexte de catégorie system/course dans le fichier de sauvegarde, sera créée dans le contexte du cours durant la restauration';
$string['qcategorycannotberestored'] = 'La catégorie de questions « {$a->name} » ne peut pas être créée durant la restauration';
$string['question2coursefallback'] = 'La catégorie de questions « {$a->name} », située dans le contexte de catégorie system/course dans le fichier de sauvegarde, sera créée dans le contexte du cours durant la restauration';
$string['questionegorycannotberestored'] = 'Les questions « {$a->name} » ne peuvent pas être créées durant la restauration';
$string['recyclebin_desc'] = 'Ces réglages seront aussi utilisés pour la corbeille.';
$string['replacerestoredefaults'] = 'Restaurer les réglages par défaut lors de la restauration vers un autre cours en supprimant son contenu';
$string['restoreactivity'] = 'Restaurer l\'activité';
$string['restorecourse'] = 'Restaurer le cours';
$string['restorecoursesettings'] = 'Réglages du cours';
$string['restoredcourseid'] = 'ID du cours restauré : {$a}';
$string['restoreexecutionsuccess'] = 'Le cours a été correctement restauré.';
$string['restorefileweremissing'] = 'Certains fichiers n\'ont pas pu être restaurés, car ils n\'étaient pas présents dans la sauvegarde.';
$string['restorenewcoursefullname'] = 'Nouveau nom du cours';
$string['restorenewcourseshortname'] = 'Nouveau nom abrégé du cours';
$string['restorenewcoursestartdate'] = 'Nouvelle date de début';
$string['restorerolemappings'] = 'Correspondance des rôles à restaurer';
$string['restorerootsettings'] = 'Réglages de restauration';
$string['restoresection'] = 'Restaurer la section';
$string['restorestage1'] = 'Confirmer';
$string['restorestage16'] = 'Revoir';
$string['restorestage16action'] = 'Effectuer la restauration';
$string['restorestage1action'] = 'Suivant';
$string['restorestage2'] = 'Destination';
$string['restorestage2action'] = 'Suivant';
$string['restorestage32'] = 'Effectuer la restauration';
$string['restorestage32action'] = 'Continuer';
$string['restorestage4'] = 'Réglages';
$string['restorestage4action'] = 'Suivant';
$string['restorestage64'] = 'Terminer';
$string['restorestage64action'] = 'Continuer';
$string['restorestage8'] = 'Schéma';
$string['restorestage8action'] = 'Suivant';
$string['restoretarget'] = 'Lieu de restauration';
$string['restoretocourse'] = 'Restaurer vers le cours';
$string['restoretocurrentcourse'] = 'Restaurer dans ce cours';
$string['restoretocurrentcourseadding'] = 'Fusionner le cours sauvegardé avec ce cours';
$string['restoretocurrentcoursedeleting'] = 'Supprimer le contenu de ce cours, puis restaurer';
$string['restoretoexistingcourse'] = 'Restaurer dans un cours existant';
$string['restoretoexistingcourseadding'] = 'Fusionner le cours sauvegardé dans le cours existant';
$string['restoretoexistingcoursedeleting'] = 'Supprimer le contenu du cours existant, puis restaurer';
$string['restoretonewcourse'] = 'Restaurer comme nouveau cours';
$string['restoringcourse'] = 'Restauration du cours en cours';
$string['restoringcourseshortname'] = 'Restauration';
$string['rootenrolmanual'] = 'Restaurer comme inscriptions manuelles';
$string['rootsettingactivities'] = 'Inclure les activités et ressources';
$string['rootsettinganonymize'] = 'Anonymiser les informations des utilisateurs';
$string['rootsettingbadges'] = 'Inclure les badges';
$string['rootsettingblocks'] = 'Inclure les blocs';
$string['rootsettingcalendarevents'] = 'Inclure les événements du calendrier';
$string['rootsettingcomments'] = 'Inclure les commentaires';
$string['rootsettingcompetencies'] = 'Inclure les compétences';
$string['rootsettingcontentbankcontent'] = 'Inclure le contenu de la banque de contenus';
$string['rootsettingcustomfield'] = 'Inclure les champs personnalisés';
$string['rootsettingenrolments'] = 'Inclure les méthodes d\'inscription';
$string['rootsettingenrolments_always'] = 'Oui, toujours';
$string['rootsettingenrolments_never'] = 'Non, restaurer les utilisateurs comme inscrits manuellement';
$string['rootsettingenrolments_withusers'] = 'Oui, mais seulement si les utilisateurs sont inclus';
$string['rootsettingfiles'] = 'Inclure les fichiers';
$string['rootsettingfilters'] = 'Inclure les filtres';
$string['rootsettinggradehistories'] = 'Inclure les historiques des notes';
$string['rootsettinggroups'] = 'Inclure les groupes et groupements';
$string['rootsettingimscc1'] = 'Convertir en IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Convertir en IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Inclure les fichiers de cours obsolètes';
$string['rootsettinglogs'] = 'Inclure les journaux du cours';
$string['rootsettingpermissions'] = 'Inclure les dérogations de permissions';
$string['rootsettingquestionbank'] = 'Inclure la banque de questions';
$string['rootsettingroleassignments'] = 'Inclure les attributions de rôles';
$string['rootsettings'] = 'Réglages de la sauvegarde';
$string['rootsettingusers'] = 'Inclure les utilisateurs inscrits';
$string['rootsettinguserscompletion'] = 'Inclure les données détaillées d\'achèvement d\'activité';
$string['samesitenotification'] = 'Ce fichier de sauvegarde a été créé avec uniquement les références vers les fichiers, et non les fichiers eux-mêmes. La restauration de cette sauvegarde ne fonctionnera que sur ce site.';
$string['sectionactivities'] = 'Activités';
$string['sectioninc'] = 'Inclus dans la sauvegarde (pas de données utilisateur)';
$string['sectionincanduser'] = 'Inclus dans la sauvegarde avec des données utilisateur';
$string['selectacategory'] = 'Sélectionner une catégorie';
$string['selectacourse'] = 'Sélectionner un cours';
$string['setting_course_fullname'] = 'Nom du cours';
$string['setting_course_shortname'] = 'Nom abrégé du cours';
$string['setting_course_startdate'] = 'Date de début du cours';
$string['setting_keep_groups_and_groupings'] = 'Conserver les groupes et groupements actuels';
$string['setting_keep_roles_and_enrolments'] = 'Conserver les rôles et inscriptions actuels';
$string['setting_overwrite_conf'] = 'Écraser la configuration du cours';
$string['setting_overwrite_course_fullname'] = 'Écraser le nom complet du cours';
$string['setting_overwrite_course_shortname'] = 'Écraser le nom abrégé du cours';
$string['setting_overwrite_course_startdate'] = 'Écraser la date de début du cours';
$string['showtypes'] = 'Afficher les types d\'options';
$string['sitecourseformatwarning'] = 'Cette sauvegarde est une sauvegarde de la page d\'accueil. Elle ne peut être restaurée que sur la page d\'accueil.';
$string['skiphidden'] = 'Omettre les cours cachés';
$string['skiphiddenhelp'] = 'Choisir s\'il faut ou non omettre les cours cachés';
$string['skipmodifdays'] = 'Omettre les cours non modifiés depuis';
$string['skipmodifdayshelp'] = 'Choisir s\'il faut ou non omettre les cours non modifiés depuis un certain nombre de jours';
$string['skipmodifprev'] = 'Omettre les cours non modifiés depuis la dernière sauvegarde';
$string['skipmodifprevhelp'] = 'Choisir s\'il faut ou non omettre les cours n\'ayant pas été modifiés depuis la dernière sauvegarde. Requiert l\'activation des journaux.';
$string['status'] = 'Statut';
$string['storagecourseandexternal'] = 'Zone de sauvegarde de cours et dossier spécifié';
$string['storagecourseonly'] = 'Zone de sauvegarde de cours';
$string['storageexternalonly'] = 'Dossier spécifié pour les sauvegardes automatiques';
$string['successful'] = 'Sauvegarde effectuée';
$string['successfulcopy'] = 'Copie terminée';
$string['successfulrestore'] = 'Restauration effectuée';
$string['timetaken'] = 'Temps mis';
$string['title'] = 'Titre';
$string['totalcategorysearchresults'] = 'Nombre de catégories : {$a}';
$string['totalcoursesearchresults'] = 'Nombre de cours : {$a}';
$string['undefinedrolemapping'] = 'Correspondance de rôle non définie pour l\'archétype « {$a} »';
$string['unnamedsection'] = 'Section sans nom';
$string['userdata'] = 'Inclure les données utilisateur';
$string['userdata_help'] = 'Si ce réglage est activé, les données telles que les messages de forums, travaux remis, etc. seront copiées dans le nouveau cours pour tous les utilisateurs ayant un rôle sélectionné dans « Inclure les inscriptions de rôle »';
$string['userinfo'] = 'Info utilisateur';
