<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'lo', version '4.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'ຂ້ອຍເຂົ້າໃຈ ແລະ ຍອມຮັບຂໍ້ຕົກລົງການປະມວນຜົນຂໍ້ມູນ';
$string['activityoverview'] = 'ທ່ານມີກອງປະຊຸມ bigbluebuttonbn ທີ່ຈະມາເຖິງ';
$string['bbbduetimeoverstartingtime'] = 'ເວລາປິດຕ້ອງຫຼັງຈາກເວລາເລີ່ມຕົ້ນ.';
$string['bbbdurationwarning'] = 'ໄລຍະເວລາສູງສຸດສຳລັບຊ່ວງເວລານີ້ແມ່ນ %duration% ນາທີ.';
$string['bbbrecordallfromstartwarning'] = 'ກອງປະຊຸມນີ້ກຳລັງຖືກບັນທຶກຕັ້ງແຕ່ເລີ່ມຕົ້ນ.';
$string['bbbrecordwarning'] = 'ຊ່ວງເວລານີ້ອາດຖືກບັນທຶກ';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'ເພີ່ມຫ້ອງ BigBlueButton ໃໝ່';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'ສ້າງຕົວຢ່າງຫ້ອງປະຊຸມສົດ';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'ສ້າງຕົວຢ່າງກັບການບັນທຶກ';
$string['bigbluebuttonbn:deleterecordings'] = 'ລຶບການບັນທຶກ';
$string['bigbluebuttonbn:importrecordings'] = 'ນຳເຂົ້າການບັນທຶກ';
$string['bigbluebuttonbn:join'] = 'ເຂົ້າຮ່ວມຫ້ອງ BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'ຈັດການການບັນທຶກ';
$string['bigbluebuttonbn:protectrecordings'] = 'ປົກປ້ອງການບັນທຶກ';
$string['bigbluebuttonbn:publishrecordings'] = 'ເຜີຍແຜ່ການບັນທຶກ';
$string['bigbluebuttonbn:unprotectrecordings'] = 'ຍົກເລີກການປົກປ້ອງການບັນທຶກ';
$string['bigbluebuttonbn:unpublishrecordings'] = 'ຍົກເລີກການເຜີຍແຜ່ການບັນທຶກ';
$string['bigbluebuttonbn:view'] = 'ເບິ່ງຫ້ອງ BigBlueButton';
$string['bigbluebuttondisablednotification'] = 'ໂມດູນກິດຈະກໍາ BigBlueButton ໄດ້ຖືກປິດໃຊ້ງານ ແລະ ກິດຈະກໍາຫຼັກສູດ BigBlueButton ທີ່ມີຢູ່ໃນປັດຈຸບັນບໍ່ສາມາດເຂົ້າເຖິງໄດ້. ກ່ອນທີ່ຈະເປີດໃຊ້ງານປລັກອິນນີ້ຄືນໃໝ່, ກະລຸນາກວດສອບໃຫ້ແນ່ໃຈວ່າທ່ານໄດ້ອ່ານ ແລະ ຍອມຮັບ <a href="{$a}" target="_blank">ຂໍ້ຕົກລົງການປະມວນຜົນຂໍ້ມູນ</a> ກັບ Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'ໂມດູນກິດຈະກຳ BigBlueButton ຖືກປິດໃຊ້ງານ.';
$string['cachedef_currentfetch'] = 'ຂໍ້ມູນໄປຫາລາຍການດຶງການບັນທຶກໃດໜຶ່ງໃນປະຈຸບັນ.';
$string['cachedef_recordings'] = 'ກຳລັງບັນທຶກ metadata';
$string['cachedef_serverinfo'] = 'ເອົາຂໍ້ມູນເຊີເວີອອກ';
$string['cachedef_validatedurls'] = 'ແຄດຂອງການກວດສອບ URL ທີ່ຖືກຕ້ອງ';
$string['calendarstarts'] = '{$a} ກໍານົດສໍາລັບ';
$string['cannotperformaction'] = 'ບໍ່ສາມາດດຳເນີນການ {$a} ໃນການບັນທຶກນີ້ໄດ້';
$string['completionattendance'] = 'ນັກຮຽນຕ້ອງເຂົ້າຮ່ວມກອງປະຊຸມສຳລັບ:';
$string['completionattendance_desc'] = 'ນັກຮຽນຕ້ອງເຂົ້າໄປຫ້ອງ ແລະ ຢູ່ໃນກອງປະຊຸມເປັນເວລາຢ່າງໜ້ອຍ {$a} ນາທີ';
$string['completionattendance_event_desc'] = 'ນັກຮຽນໄດ້ເຂົ້າໄປຫ້ອງ ແລະ ຍັງຢູ່ໃນກອງປະຊຸມເປັນເວລາຢ່າງໜ້ອຍ {$a} ນາທີ';
$string['completionattendancegroup'] = 'ການເຂົ້າຮ່ວມແມ່ນຈຳເປັນ';
$string['completionattendancegroup_help'] = 'ການເຂົ້າຮ່ວມກອງປະຊຸມສໍາລັບ (n) ນາທີ ແມ່ນຈໍາເປັນສໍາລັບການສໍາເລັດ.';
$string['completionengagement_desc'] = 'ນັກສຶກສາຕ້ອງມີສ່ວນຮ່ວມໃນກິດຈະກໍາໃນລະຫວ່າງການປະຊຸມ';
$string['completionengagementchats'] = 'ການສົນທະນາ';
$string['completionengagementchats_desc'] = 'ນັກຮຽນຕ້ອງເຂົ້າຮ່ວມການສົນທະນາ {$a} ເພື່ອເຮັດມັນໃຫ້ສຳເລັດ.';
$string['completionengagementchats_event_desc'] = 'ໄດ້ຍົກການສົນທະນາ {$a} ຂຶ້ນມາ';
$string['completionengagementemojis'] = 'ອິໂມຈິ';
$string['completionengagementemojis_desc'] = 'ນັກຮຽນຕ້ອງສົ່ງອິໂມຈິ {$a} ເຂົ້າໄປໃນແບບສຳຫຼວດເພື່ອໃຫ້ມັນສຳເລັດ.';
$string['completionengagementemojis_event_desc'] = 'ໄດ້ຍົກອິໂມຈິ {$a} ຂຶ້ນມາ';
$string['completionengagementgroup'] = 'ການມີສ່ວນພົວພັນທີ່ຕ້ອງການ';
$string['completionengagementgroup_help'] = 'ການມີສ່ວນຮ່ວມຢ່າງຫ້າວຫັນໃນລະຫວ່າງກອງປະຊຸມແມ່ນຕ້ອງການສໍາລັບການສໍາເລັດ.';
$string['completionengagementpollvotes'] = 'ການລົງຄະແນນສຽງໃນແບບສຳຫຼວດ';
$string['completionengagementpollvotes_desc'] = 'ນັກຮຽນຕ້ອງລົງຄະແນນສຽງໃນແບບສຳຫຼວດ {$a} ຄັ້ງເພື່ອໃຫ້ມັນສຳເລັດ.';
$string['completionengagementpollvotes_event_desc'] = 'ໄດ້ຍົກການລົງຄະແນນສຽງ {$a} ຂຶ້ນມາ';
$string['completionengagementraisehand'] = 'ຕ້ອງການໃຫ້ຍົກມື';
$string['completionengagementraisehand_desc'] = 'ນັກຮຽນຕ້ອງຍົກມື {$a} ເທື່ອເພື່ອເຮັດມັນໃຫ້ສຳເລັດ.';
$string['completionengagementraisehand_event_desc'] = 'ໄດ້ຍົກມື {$a} ຄັ້ງ';
$string['completionengagementtalks'] = 'ໂອ້ລົມ';
$string['completionengagementtalks_desc'] = 'ນັກຮຽນຕ້ອງໂອ້ລົມ {$a} ເທື່ອເພື່ອສຳເລັດມັນ';
$string['completionengagementtalks_event_desc'] = 'ໄດ້ຍົກການໂອ້ລົມ {$a} ຂື້ນມາ';
$string['completionupdatestate'] = 'ສະຖານະປັບປຸງການສຳເລັດ';
$string['completionvalidatestate'] = 'ກວດສອບການສໍາເລັດ';
$string['completionvalidatestatetriggered'] = 'ກວດສອບການສໍາເລັດໄດ້ເລີ່ມຂື້ນແລ້ວ';
$string['completionview'] = 'ເບິ່ງຄວາມຕ້ອງການ';
$string['completionview_desc'] = 'ນັກຮຽນຕ້ອງເຂົ້າໄປເບິ່ງຫ້ອງເພື່ອໃຫ້ມັນສໍາເລັດ.';
$string['completionview_event_desc'] = 'ໄດ້ເຂົ້າເບິ່ງໜ້າຂອງຫ້ອງ.';
$string['config_default_messages'] = 'ຂໍ້ຄວາມເລີ່ມຕົ້ນ';
$string['config_default_messages_description'] = 'ຕັ້ງຂໍ້ຄວາມເລີ່ມຕົ້ນສຳລັບກິດຈະກຳ';
$string['config_disablecam_default'] = 'ປິດໃຊ້ງານກ້ອງທີ່ຖືກເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_disablecam_default_description'] = 'ຖ້າເປີດໃຊ້ງານ webcams ຈະຖືກປິດໃຊ້ງານ.';
$string['config_disablecam_editable'] = 'ປິດໃຊ້ງານກ້ອງສາມາດແກ້ໄຂໄດ້';
$string['config_disablecam_editable_description'] = 'ປິດໃຊ້ງານກ້ອງໂດຍຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ ເມື່ອຕົວຢ່າງຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_disablemic_default'] = 'ປິດການໃຊ້ງານໄມທີ່ເປີດໃຊ້ງານໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_disablemic_default_description'] = 'ຖ້າເປີດໃຊ້ໄມໂຄຣໂຟນຈະຖືກປິດໃຊ້ງານ.';
$string['config_disablemic_editable'] = 'ປິດໄມສາມາດແກ້ໄຂໄດ້';
$string['config_disablemic_editable_description'] = 'ປິດການນຳໃຊ້ໄມຕາມຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອເພີ່ມ ຫຼື ອັບເດດຕົວຢ່າງ.';
$string['config_disablenote_default'] = 'ປິດການນຳໃຊ້ບັນທຶກທີ່ແບ່ງປັນທີ່ເປີດໃຫ້ໃຊ້ງານໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_disablenote_default_description'] = 'ຖ້າເປີດໃຊ້, ບັນທຶກທີ່ແບ່ງປັນຈະຖືກປິດໃຊ້ງານ.';
$string['config_disablenote_editable'] = 'ປິດການນຳໃຊ້ບັນທຶກທີ່ແບ່ງປັນສາມາດແກ້ໄຂໄດ້';
$string['config_disablenote_editable_description'] = 'ປິດການໃຊ້ງານບັນທຶກທີ່ແບ່ງປັນໂດຍຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອຕົວຢ່າງໄດ້ຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_disableprivatechat_default'] = 'ປິດການໃຊ້ງານການສົນທະນາສ່ວນຕົວທີ່ເປີດໃຊ້ງານໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_disableprivatechat_default_description'] = 'ຖ້າເປີດໃຊ້, ການສົນທະນາສ່ວນຕົວຈະຖືກປິດໃຊ້ງານ.';
$string['config_disableprivatechat_editable'] = 'ປິດການໃຊ້ງານການສົນທະນາສ່ວນຕົວສາມາດແກ້ໄຂໄດ້';
$string['config_disableprivatechat_editable_description'] = 'ປິດການໃຊ້ງານການສົນທະນາສ່ວນຕົວໂດຍຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອມີການເພີ່ມ ຫຼື ປັບປຸງຕົວຢ່າງ.';
$string['config_disablepublicchat_default'] = 'ປິດການໃຊ້ງານການສົນທະນາສາທາລະນະທີ່ເປີດໃຊ້ງານໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_disablepublicchat_default_description'] = 'ຖ້າເປີດໃຊ້ການສົນທະນາສາທາລະນະຈະຖືກປິດໃຊ້ງານ.';
$string['config_disablepublicchat_editable'] = 'ປິດການສົນທະນາສາທາລະນະສາມາດແກ້ໄຂໄດ້';
$string['config_disablepublicchat_editable_description'] = 'ປິດການສົນທະນາສາທາລະນະໂດຍຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອຕົວຢ່າງຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_dpa_note'] = 'ໝາຍເຫດ: ເພື່ອປະຕິບັດຕາມພັນທະການປົກປ້ອງຂໍ້ມູນຂອງທ່ານ, ກ່ອນທີ່ຈະນໍາໃຊ້ຜູ້ໃຫ້ບໍລິການສໍາລັບ ປລັກອິນນີ້, ທ່ານອາດຈະຕ້ອງໃຫ້ແນ່ໃຈວ່າທ່ານໄດ້ອ່ານ ແລະ ຍອມຮັບຂໍ້ຕົກລົງການປຸງແຕ່ງຂໍ້ມູນຂອງຜູ້ໃຫ້ບໍລິການ.
ສຳລັບບໍລິການ BigBlueButton ຟຣີໃນຄ່າເລີ່ມຕົ້ນທີ່ສະໜອງໃຫ້ໂດຍ Blindside Networks Inc., ກະລຸນາອ່ານ ແລະ ຍອມຮັບ <a href="{$a}" target="_blank">ຂໍ້ຕົກລົງການປະມວນຜົນຂໍ້ມູນ</a> ຕໍ່ໄປນີ້.<br/>
ກະລຸນາປຶກສາກັບຜູ້ຊ່ຽວຊານດ້ານຄວາມເປັນສ່ວນຕົວຂອງທ່ານເອງເພື່ອຂໍຄໍາແນະນໍາ.';
$string['config_experimental_features'] = 'ຄຸນສົມບັດດ້ານການທົດລອງ';
$string['config_experimental_features_description'] = 'ການຕັ້ງຄ່າສໍາລັບລັກສະນະດ້ານການທົດລອງ.';
$string['config_extended_capabilities'] = 'ຄວາມສາມາດຂະຫຍາຍ';
$string['config_extended_capabilities_description'] = 'ການຕັ້ງຄ່າຄວາມສາມາດຂະຫຍາຍເມື່ອເຊີບເວີ BigBlueButton ສະເໜີໃຫ້ເຂົາເຈົ້າ.';
$string['config_general'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['config_general_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ຖືກນໍາໃຊ້ສະເຫມີໄປ.';
$string['config_hideuserlist_default'] = 'ເຊື່ອງລາຍຊື່ຜູ້ໃຊ້ທີ່ຖືກເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_hideuserlist_default_description'] = 'ຖ້າເປີດໃຊ້, ລາຍຊື່ຜູ້ໃຊ້ຂອງຊ່ວງເວລາຈະຖືກເຊື່ອງໄວ້.';
$string['config_hideuserlist_editable'] = 'ເຊື່ອງລາຍຊື່ຜູ້ໃຊ້ສາມາດແກ້ໄຂໄດ້';
$string['config_hideuserlist_editable_description'] = 'ເຊື່ອງລາຍຊື່ຜູ້ໃຊ້ຕາມຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອຕົວຢ່າງຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_importrecordings'] = 'ການນໍາເຂົ້າບັນທຶກ';
$string['config_importrecordings_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ແມ່ນມີລັກສະນະສະເພາະ.';
$string['config_importrecordings_enabled'] = 'ເປີດໃຊ້ການບັນທຶກການນໍາເຂົ້າແລ້ວ';
$string['config_importrecordings_enabled_description'] = 'ໃນເວລາທີ່ນີ້ ແລະ ຄຸນນະສົມບັດການບັນທຶກໄດ້ຖືກເປີດໃຊ້, ມັນເປັນໄປໄດ້ທີ່ຈະນໍາເຂົ້າການບັນທຶກຈາກວິຊາທີ່ແຕກຕ່າງກັນເຂົ້າໄປໃນກິດຈະກໍາ.';
$string['config_importrecordings_from_deleted_enabled'] = 'ການນໍາເຂົ້າບັນທຶກຈາກກິດຈະກໍາທີ່ຖືກລົບໄດ້ເປີດໃຫ້ໃຊ້ງານ';
$string['config_importrecordings_from_deleted_enabled_description'] = 'ໃນເວລາທີ່ນີ້ ແລະ ຄຸນນະສົມບັດການບັນທຶກການນໍາເຂົ້າໄດ້ຖືກເປີດໃຊ້, ມັນເປັນໄປໄດ້ທີ່ຈະນໍາເຂົ້າການບັນທຶກຈາກກິດຈະກໍາທີ່ບໍ່ມີຕໍ່ໄປອີກແລ້ວໃນລາຍວິຊາ.';
$string['config_lockonjoin_default'] = 'ການລັອກໃນການເຂົ້າຮ່ວມຖືກເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_lockonjoin_default_description'] = 'ຖ້າເປີດໃຊ້ການຕັ້ງຄ່າທີ່ຖືກລັອກໂດຍການຕັ້ງຄ່າແມ່ນນຳໃຊ້ກັບຜູ້ໃຊ້ ເມື່ອພວກເຂົາເຂົ້າຮ່ວມ. ການຕັ້ງຄ່າລັອກຕ້ອງຖືກເປີດໃຊ້ງານເພື່ອນຳໃຊ້ໄດ້.';
$string['config_lockonjoin_editable'] = 'ການລັອກໃນການເຂົ້າຮ່ວມສາມາດແກ້ໄຂໄດ້';
$string['config_lockonjoin_editable_description'] = 'ການລັອກໃນການເຂົ້າຮ່ວມໂດຍຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອຕົວຢ່າງໄດ້ຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_locksettings'] = 'ການຕັ້ງຄ່າສໍາລັບການລັອກການຕັ້ງຄ່າ';
$string['config_locksettings_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ເປີດ ຫຼື ປິດໃຊ້ງານຕົວເລືອກໃນ UI ສໍາລັບການຕັ້ງຄ່າການລັອກ, ແລະ ຍັງກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວເລືອກເຫຼົ່ານີ້.';
$string['config_meetingevents_enabled'] = 'ລົງທະບຽນກອງປະຊຸມສົດ';
$string['config_meetingevents_enabled_description'] = 'ຖ້າເປີດໃຊ້, ກອງປະຊຸມສົດຈະຖືກປະມວນຜົນຫຼັງຈາກກອງປະຊຸມສິ້ນສຸດລົງ. ຄຸນສົມບັດນີ້ແມ່ນຕ້ອງການສໍາລັບການສໍາເລັດກິດຈະກໍາ ແລະ ຈະເຮັດວຽກພຽງແຕ່ຖ້າເຊີເວີຂອງ BigBlueButton ສາມາດປະມວນຜົນສະຄຣິບ post_events ໄດ້.';
$string['config_muteonstart'] = 'ປິດສຽງໃນຕອນເລີ່ມຕົ້ນ';
$string['config_muteonstart_default'] = 'ປິດສຽງໃນຕອນເລີ່ມຕົ້ນຖືກເປີດໃຊ້ເປັນຄ່າເລີ່ມຕົ້ນ';
$string['config_muteonstart_default_description'] = 'ຖ້າເປີດໃຊ້ງານ ຊ່ວງເວລາຈະຖືກປິດສຽງໃນຕອນເລີ່ມຕົ້ນ.';
$string['config_muteonstart_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ເປີດ ຫຼື ປິດຕົວເລືອກໃນ UI ແລະ ຍັງກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວເລືອກເຫຼົ່ານີ້.';
$string['config_muteonstart_editable'] = 'ປິດສຽງໃນຕອນເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້';
$string['config_muteonstart_editable_description'] = 'ປິດສຽງໃນຕອນເລີ່ມຕົ້ນໂດຍຄ່າເລີ່ມຕົ້ນສາມາດຖືກແກ້ໄຂໄດ້ເມື່ອຕົວຢ່າງຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_participant'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['config_participant_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ກໍານົດບົດບາດຕາມຄ່າເລີ່ມຕົ້ນສໍາລັບຜູ້ເຂົ້າຮ່ວມ.';
$string['config_participant_moderator_default'] = 'ຜູ້ຄວບຄຸມ';
$string['config_participant_moderator_default_description'] = 'ກົດລະບຽບນີ້ ຖືກນໍາໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ ເມື່ອມີຫ້ອງໃໝ່ຖືກເພີ່ມ.';
$string['config_presentation_default'] = 'ໄຟລ໌ການນຳສະເໜີເລີ່ມຕົ້ນ';
$string['config_presentation_default_description'] = 'ໄຟລ໌ອາດຖືກສະໜອງໃຫ້ສຳລັບນຳໃຊ້ໃນທຸກຫ້ອງ.';
$string['config_preuploadpresentation'] = 'ການນຳສະເໜີອັບໂຫຼດລ່ວງໜ້າ';
$string['config_preuploadpresentation_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ເປີດ ຫຼື ປິດໃຊ້ງານຕົວເລືອກໃນ UI ແລະ ຍັງກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວເລືອກເຫຼົ່ານີ້. ຄຸນສົມບັດຈະເຮັດວຽກໄດ້ພຽງແຕ່ຖ້າເຊີບເວີຂອງ Moodle ສາມາດເຂົ້າເຖິງ BigBlueButton ໄດ້.';
$string['config_preuploadpresentation_editable'] = 'ການອັບໂຫຼດລ່ວງໜ້າຂອງການນຳສະເໜີທີ່ສາມາດແກ້ໄຂໄດ້';
$string['config_preuploadpresentation_editable_description'] = 'ຄຸນສົມບັດການອັບໂຫຼດລ່ວງໜ້າຂອງການນຳສະເໜີແມ່ນສາມາດແກ້ໄຂໄດ້ໃນ UI ເມື່ອຫ້ອງ ຫຼື ຫ້ອງປະຊຸມຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_recording'] = 'ການບັນທຶກ';
$string['config_recording_all_from_start_default'] = 'ເລີ່ມບັນທຶກຕັ້ງແຕ່ຕອນຕົ້ນ';
$string['config_recording_all_from_start_default_description'] = 'ການຕັ້ງຄ່າ \'ເລີ່ມການບັນທຶກຕັ້ງແຕ່ຕອນຕົ້ນ\' ຄວນຖືກເປີດໃຊ້ເປັນຄ່າເລີ່ມຕົ້ນເມື່ອເພີ່ມຫ້ອງ BigBlueButton ໃໝ່ບໍ?';
$string['config_recording_all_from_start_editable'] = 'ເລີ່ມການບັນທຶກຕັ້ງແຕ່ຕອນຕົ້ນສາມາດແກ້ໄຂໄດ້';
$string['config_recording_all_from_start_editable_description'] = '\'ເລີ່ມການບັນທຶກຕັ້ງແຕ່ຕອນຕົ້ນ\' ຄວນສາມາດແກ້ໄຂໄດ້ໃນການຕັ້ງຄ່າກິດຈະກໍາ BigBlueButton ບໍ?';
$string['config_recording_default'] = 'ການບັນທຶກຖືກເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_recording_default_description'] = 'ການຕັ້ງຄ່າ \'ກອງປະຊຸມສາມາດຖືກບັນທຶກ\' ຄວນຖືກເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນເມື່ອເພີ່ມຫ້ອງ BigBlueButton ໃໝ່ບໍ?';
$string['config_recording_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ແມ່ນມີລັກສະນະສະເພາະ';
$string['config_recording_editable'] = 'ກອງປະຊຸມສາມາດຖືກບັນທຶກສາມາດແກ້ໄຂໄດ້';
$string['config_recording_editable_description'] = '\'ກອງປະຊຸມສາມາດຖືກບັນທຶກ\' ຄວນສາມາດແກ້ໄຂໄດ້ໃນການຕັ້ງຄ່າກິດຈະກໍາ BigBlueButton ບໍ?';
$string['config_recording_hide_button_default'] = 'ເຊື່ອງປຸ່ມການບັນທຶກ';
$string['config_recording_hide_button_default_description'] = 'ຖ້າກວດເບິ່ງປຸ່ມສຳລັບບັນທຶກຈະຖືກເຊື່ອງໄວ້';
$string['config_recording_hide_button_editable'] = 'ເຊື່ອງປຸ່ມບັນທຶກສາມາດແກ້ໄຂໄດ້';
$string['config_recording_hide_button_editable_description'] = '\'ເຊື່ອງປຸ່ມບັນທຶກ\' ຄວນສາມາດແກ້ໄຂໄດ້ໃນການຕັ້ງຄ່າກິດຈະກໍາ BigBlueButton ບໍ?';
$string['config_recording_protect_editable'] = 'ສາມາດແກ້ໄຂສະຖານະການບັນທຶກທີ່ມີການປ້ອງກັນໄດ້';
$string['config_recording_protect_editable_description'] = 'ຖ້າຫາກວ່າການກວດສອບການໂຕ້ຕອບທີ່ປະກອບມີທາງເລືອກສໍາລັບການປົກປັກຮັກສາ/ການບໍ່ປົກປ້ອງການບັນທຶກ.';
$string['config_recording_refresh_period'] = 'ການບັນທຶກໄລຍະໄດ້ໂຫຼດຂໍ້ມູນຄືນໃໝ່ (ເປັນວິນາທີ)';
$string['config_recording_refresh_period_description'] = 'ເຊີບເວີ BigBlueButton ຄວນຖືກສອບຖາມເພື່ອໂຫຼດຂໍ້ມູນທາງໄກຄືນໃໝ່ເພື່ອບັນທຶກສຽງດົນປານໃດ?';
$string['config_recordingready_enabled'] = 'ສົ່ງການແຈ້ງເຕືອນເມື່ອການບັນທຶກມີໃຫ້';
$string['config_recordingready_enabled_description'] = 'ຖ້າເປີດໃຊ້, ການແຈ້ງເຕືອນຈະຖືກສົ່ງເມື່ອມີລິ້ງບັນທຶກ. ຄຸນສົມບັດນີ້ຕ້ອງການສະຄຣິບ post_publish_recording_ready_callback ເພື່ອເປີດໃຊ້ໃນເຊີບເວີ BigBlueButton.';
$string['config_recordings'] = 'ສະແດງການບັນທຶກ';
$string['config_recordings_asc_sort'] = 'ຄຳສັ່ງບັນທຶກຈາກລຳດັບນ້ອຍຫາໃຫຍ່.';
$string['config_recordings_asc_sort_description'] = 'ຕາມການບັນທຶກໄວ້ໃນຕອນຕົ້ນແມ່ນສະແດງໃຫ້ເຫັນຢູ່ໃນລໍາດັບນ້ອຍຫາໃຫຍ່. ເມື່ອກວດເບິ່ງພວກມັນຈະຖືກຈັດຮຽງຕາມລໍາດັບ.';
$string['config_recordings_deleted_default'] = 'ລວມເອົາການບັນທຶກຈາກກິດຈະກໍາທີ່ຖືກລົບຖືກເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_recordings_deleted_default_description'] = 'ຖ້າເປີດໃຊ້, ຕາຕະລາງການບັນທຶກຈະລວມເອົາການບັນທຶກທີ່ເປັນຂອງກິດຈະກໍາໃດໆທີ່ຖືກລຶບ.';
$string['config_recordings_deleted_editable'] = 'ລວມເອົາການບັນທຶກຈາກຄຸນສົມບັດການເຄື່ອນໄຫວທີ່ຖືກລົບສາມາດແກ້ໄຂໄດ້';
$string['config_recordings_deleted_editable_description'] = 'ລວມທັງການບັນທຶກຈາກກິດຈະກໍາທີ່ຖືກລົບ ໂດຍຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອຕົວຢ່າງຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_recordings_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ແມ່ນມີລັກສະນະສະເພາະ';
$string['config_recordings_general'] = 'ສະແດງການຕັ້ງຄ່າການບັນທຶກ';
$string['config_recordings_general_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ຖືກໃຊ້ພຽງແຕ່ເມື່ອສະແດງການບັນທຶກ';
$string['config_recordings_imported_default'] = 'ສະແດງໃຫ້ເຫັນພຽງແຕ່ການນໍາເຂົ້າເຊື່ອມຕໍ່ທີ່ເປີດນໍາໃຊ້ງານໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_recordings_imported_default_description'] = 'ຖ້າເປີດໃຊ້ຕາຕະລາງການບັນທຶກຈະລວມເອົາພຽງແຕ່ການເຊື່ອມຕໍ່ທີ່ນໍາເຂົ້າກັບການບັນທຶກ.';
$string['config_recordings_imported_editable'] = 'ສະແດງພຽງແຕ່ຄຸນນະສົມບັດການເຊື່ອມຕໍ່ນໍາເຂົ້າສາມາດແກ້ໄຂໄດ້';
$string['config_recordings_imported_editable_description'] = 'ສະແດງພຽງແຕ່ການເຊື່ອມຕໍ່ທີ່ນໍາເຂົ້າໂດຍຄ່າເລີ່ມຕົ້ນ ສາມາດແກ້ໄຂໄດ້ເມື່ອ ຕົວຢ່າງໄດ້ຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_recordings_preview_default'] = 'ເບິ່ງຕົວຢ່າງຖືກເປີດໃຊ້ງານຕາມຄ່າເລີ່ມຕົ້ນ';
$string['config_recordings_preview_default_description'] = 'ຖ້າເປີດໃຊ້ຕາຕະລາງປະກອບມີການສະແດງຕົວຢ່າງຂອງການນໍາສະເໜີ.';
$string['config_recordings_preview_editable'] = 'ຄຸນສົມບັດເບິ່ງຕົວຢ່າງສາມາດແກ້ໄຂໄດ້';
$string['config_recordings_preview_editable_description'] = 'ຄຸນສົມບັດການເບິ່ງຕົວຢ່າງສາມາດແກ້ໄຂໄດ້ເມື່ອຕົວຢ່າງຖືກເພີ່ມ ຫຼື ປັບປຸງ.';
$string['config_scheduled'] = 'ກອງປະຊຸມທີ່ກໍານົດໄວ້';
$string['config_scheduled_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ກໍານົດພຶດຕິກໍາຕາມຄ່າເລີ່ມຕົ້ນສໍາລັບກອງປະຊຸມທີ່ໄດ້ກໍານົດ.';
$string['config_scheduled_pre_opening'] = 'ເຂົ້າເຖິງໄດ້ກ່ອນເວລາເປີດ';
$string['config_scheduled_pre_opening_description'] = 'ເວລາເປັນນາທີທີ່ຫ້ອງເປີດສຳລັບກ່ອນຮອດກຳນົດເວລາເປີດກຳນົດໝາຍ.';
$string['config_server_url'] = 'URL ຂອງເຊີເວີ BigBlueButton';
$string['config_server_url_description'] = 'ຂໍ້ມູນປະຈໍາຕົວເລີ່ມຕົ້ນແມ່ນສໍາລັບ <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">ບໍລິການ BigBlueButton ບໍ່ເສຍຄ່າສໍາລັບ Moodle (ເປີດຢູ່ໃນໜ້າຈໍໃໝ່)</a > ສະໜອງໃຫ້ໂດຍ Blindside Networks ມີຂໍ້ຈໍາກັດດັ່ງຕໍ່ໄປນີ້:
<ol>
<li>ຄວາມຍາວສູງສຸດຂອງແຕ່ລະກອງປະຊຸມແມ່ນ 60 ນາທີ</li>
<li>ຈຳນວນສູງສຸດຂອງຜູ້ໃຊ້ພ້ອມກັນຕໍ່ກອງປະຊຸມແມ່ນ 25</li>
<li>ການບັນທຶກຈະໝົດອາຍຸຫຼັງຈາກເຈັດ (7) ມື້ ແລະ ບໍ່ສາມາດດາວໂຫຼດໄດ້</li>
<li>ກ້ອງຖ່າຍຂອງນັກຮຽນແມ່ນເຫັນໄດ້ໂດຍຜູ້ຄວບຄຸມເທົ່ານັ້ນ.</li>
</ol>';
$string['config_shared_secret'] = 'ຄວາມລັບທີ່ໄດ້ແບ່ງປັນ BigBlueButton';
$string['config_shared_secret_description'] = 'ຄວາມລັບຄວາມປອດໄພຂອງເຊີບເວີ BigBlueButton ຂອງທ່ານ. ຄວາມລັບໃນຕອນຕົ້ນແມ່ນສຳລັບເຊີບເວີ BigBlueButton ທີ່ບໍ່ເສຍຄ່າທີ່ສະໜອງໃຫ້ໂດຍ Blindside Networks.';
$string['config_uidelegation_enabled'] = 'ເປີດໃຊ້ການມອບໝາຍ UI ແລ້ວ';
$string['config_uidelegation_enabled_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ເປີດ ຫຼື ປິດການມອບໝາຍ UI ໃຫ້ກັບເຊີບເວີ BigBlueButton.';
$string['config_userlimit'] = 'ຈຳກັດຜູ້ໃຊ້';
$string['config_userlimit_default'] = 'ເປີດໃຊ້ງານການຈຳກັດຜູ້ໃຊ້ຕາມຄ່າເລີ່ມຕົ້ນ';
$string['config_userlimit_default_description'] = 'ຈໍານວນຂອງຜູ້ໃຊ້ທີ່ອະນຸຍາດໃຫ້ໃນກອງປະຊຸມໂດຍເລີ່ມຕົ້ນໃນເວລາທີ່ຫ້ອງໃໝ່ຖືກເພີ່ມ. ຖ້າຕົວເລກຖືກຕັ້ງເປັນ 0 ເພື່ອອະນຸຍາດໃຫ້ຈໍານວນຜູ້ໃຊ້ບໍ່ຈໍາກັດ.';
$string['config_userlimit_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ເປີດ ຫຼື ປິດຕົວເລືອກໃນ UI ແລະ ຍັງກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວເລືອກເຫຼົ່ານີ້.';
$string['config_userlimit_editable'] = 'ຄຸນລັກສະນະຈຳກັດຜູ້ໃຊ້ສາມາດແກ້ໄຂໄດ້';
$string['config_userlimit_editable_description'] = 'ຄ່າຈໍາກັດຜູ້ໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນສາມາດແກ້ໄຂໄດ້ເມື່ອຫ້ອງ ຫຼື ກອງປະຊຸມຖືກເພີ່ມຫຼື ປັບປຸງ.';
$string['config_voicebridge'] = 'ຂົວສຽງ';
$string['config_voicebridge_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ເປີດ ຫຼື ປິດຕົວເລືອກໃນ UI ແລະ ຍັງກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວເລືອກເຫຼົ່ານີ້.';
$string['config_voicebridge_editable'] = 'ກອງປະຊຸມຂົວສຽງສາມາດແກ້ໄຂໄດ້';
$string['config_voicebridge_editable_description'] = 'ໝາຍເລກຂົວສຽງຂອງກອງປະຊຸມສາມາດຖືກມອບໝາຍຢ່າງຖາວອນໃຫ້ກັບຫ້ອງ. ເມື່ອຖືກມອບໝາຍ, ຈໍານວນບໍ່ສາມາດຖືກນໍາໃຊ້ໂດຍຫ້ອງອື່ນ.';
$string['config_waitformoderator'] = 'ລໍຖ້າຜູ້ຄວບຄຸມ';
$string['config_waitformoderator_cache_ttl'] = 'ລໍຖ້າສໍາລັບແຄດຜູ້ຄວບຄຸມ TTL (ວິນາທີ)';
$string['config_waitformoderator_cache_ttl_description'] = 'ເພື່ອສະໜັບສະໜູນການໂຫຼດໜັກຂອງລູກຄ້າ ປລັກອິນນີ້ເຮັດໃຫ້ການນໍາໃຊ້ແຄດ. ຕົວກຳນົດນີ້ກໍານົດເວລາທີ່ແຄດຈະຖືກເກັບໄວ້ກ່ອນທີ່ຄໍາຮ້ອງຂໍຕໍ່ໄປຈະຖືກສົ່ງໄປຫາເຊີເວີຂອງ BigBlueButton.';
$string['config_waitformoderator_default'] = 'ລໍຖ້າຜູ້ຄວບຄຸມທີ່ເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['config_waitformoderator_default_description'] = 'ການຕັ້ງຄ່າ \'ລໍຖ້າຜູ້ຄວບຄຸມ\' ຄວນຖືກເປີດໃຊ້ເປັນຄ່າເລີ່ມຕົ້ນເມື່ອເພີ່ມຫ້ອງ BigBlueButton ໃໝ່ບໍ?';
$string['config_waitformoderator_description'] = 'ການຕັ້ງຄ່າເຫຼົ່ານີ້ແມ່ນມີລັກສະນະສະເພາະ';
$string['config_waitformoderator_editable'] = 'ລໍຖ້າຜູ້ຄວບຄຸມສາມາດແກ້ໄຂໄດ້';
$string['config_waitformoderator_editable_description'] = '\'ລໍຖ້າຜູ້ຄວບຄຸມ\' ຄວນສາມາດແກ້ໄຂໄດ້ໃນການຕັ້ງຄ່າກິດຈະກໍາ BigBlueButton ບໍ?';
$string['config_waitformoderator_ping_interval'] = 'ລໍຖ້າຜູ້ຄວບຄຸມ ping (ວິນາທີ)';
$string['config_waitformoderator_ping_interval_description'] = 'ຄວນສົ່ງ ping ເຊີບເວີເລື້ອຍໆເທົ່າໃດ ເພື່ອກວດເບິ່ງວ່າຜູ້ຄວບຄຸມໄດ້ເຂົ້າໄປໃນຫ້ອງບໍ?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton ກໍາລັງໃຊ້ config.php ກັບຕົວແປທົ່ວໂລກທີ່ຖືກຍົກເລີກ. ກະລຸນາປ່ຽນໄຟລ໌ຍ້ອນວ່າ ມັນຈະບໍ່ຖືກຮອງຮັບໃນສະບັບໃນອະນາຄົດ.';
$string['config_warning_curl_not_installed'] = 'ຄຸນສົມບັດນີ້ຕ້ອງການສ່ວນຂະຫຍາຍ CURL ສໍາລັບ php ທີ່ຕິດຕັ້ງ ແລະ ເປີດໃຊ້ງານ. ການຕັ້ງຄ່າຈະສາມາດເຂົ້າເຖິງໄດ້ພຽງແຕ່ຖ້າເງື່ອນໄຂນີ້ຖືກປະຕິບັດ.';
$string['config_welcome_default'] = 'ຂໍ້ຄວາມຕ້ອນຮັບຄ່າເລີ່ມຕົ້ນ';
$string['config_welcome_default_description'] = 'ຂໍ້ຄວາມຍິນດີຕ້ອນຮັບຈະສະແດງເມື່ອຜູ້ເຂົ້າຮ່ວມເຂົ້າໄປໃນຫ້ອງ. ຖ້າຊ່ອງຂໍ້ມູນຖືກປະໄວ້ຫວ່າງເປົ່າ, ຫຼັງຈາກນັ້ນຂໍ້ຄວາມທີ່ຕັ້ງຢູ່ໃນເຊີບເວີ BigBlueButton ຈະຖືກສະແດງ.';
$string['config_welcome_editable'] = 'ຂໍ້ຄວາມຍິນດີຕ້ອນຮັບເລີ່ມຕົ້ນແມ່ນສາມາດແກ້ໄຂໄດ້ໂດຍຄູສອນ';
$string['config_welcome_editable_description'] = 'ຂໍ້ຄວາມຍິນດີຕ້ອນຮັບສາມາດຖືກແກ້ໄຂເມື່ອຕົວຢ່າງຖືກເພີ່ມ ຫຼື ປັບປຸງ';
$string['enablingbigbluebutton'] = 'ກຳລັງເປີດໃຊ້ງານກິດຈະກຳ BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'ເພື່ອປະຕິບັດຕາມພັນທະການປົກປ້ອງຂໍ້ມູນຂອງທ່ານ, ກ່ອນທີ່ຈະເປີດໃຊ້ງານປລັກອິນນີ້, ທ່ານອາດຈະຕ້ອງຮັບປະກັນວ່າທ່ານໄດ້ອ່ານ ແລະ ຍອມຮັບ <a href="{$a}" target="_blank">ຂໍ້ຕົກລົງການປະມວນຜົນຂໍ້ມູນ</a> ແລ້ວ. ກັບ Blindside Networks Inc.<br/>
ກະລຸນາປຶກສາກັບຜູ້ຊ່ຽວຊານດ້ານຄວາມເປັນສ່ວນຕົວຂອງທ່ານເອງເພື່ອຂໍຄໍາແນະນໍາ.';
$string['end_session_confirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການສິ້ນສຸດກອງປະຊຸມ?';
$string['end_session_confirm_title'] = 'ສິ້ນສຸດຊ່ວງເວລາແທ້ບໍ?';
$string['end_session_notification'] = 'ດຽວນີ້ກອງປະຊຸມໄດ້ສິ້ນສຸດແລ້ວ.';
$string['ends_at'] = 'ສິ້ນສຸດ';
$string['event_activity_created'] = 'ສ້າງກິດຈະກຳແລ້ວ';
$string['event_activity_deleted'] = 'ລຶບກິດຈະກຳແລ້ວ';
$string['event_activity_updated'] = 'ປັບປຸງກິດຈະກຳແລ້ວ';
$string['event_live_session'] = 'ເຫດການຊ່ວງເວລາສົດ';
$string['event_meeting_created'] = 'ສ້າງກອງປະຊຸມແລ້ວ';
$string['event_meeting_ended'] = 'ກອງປະຊຸມໄດ້ສິ້ນສຸດລົງໂດຍບັງຄັບ';
$string['event_meeting_joined'] = 'ຮ່ວມກອງປະຊຸມແລ້ວ';
$string['event_meeting_left'] = 'ອອກຈາກກອງປະຊຸມແລ້ວ';
$string['event_recording_deleted'] = 'ລຶບການບັນທຶກແລ້ວ';
$string['event_recording_edited'] = 'ແກ້ໄຂການບັນທຶກແລ້ວ';
$string['event_recording_imported'] = 'ນຳເຂົ້າການບັນທຶກແລ້ວ';
$string['event_recording_protected'] = 'ປົກປ້ອງການບັນທຶກແລ້ວ';
$string['event_recording_published'] = 'ເຜີຍແຜ່ການບັນທຶກແລ້ວ';
$string['event_recording_unprotected'] = 'ຍົກເລີກການປົກປ້ອງການບັນທຶກແລ້ວ';
$string['event_recording_unpublished'] = 'ຍົກເລີກການເຜີຍແຜ່ການບັນທຶກແລ້ວ';
$string['event_recording_viewed'] = 'ເບິ່ງການບັນທຶກແລ້ວ';
$string['event_unknown'] = 'ເຫດການທີ່ບໍ່ຮູ້ຈັກ';
$string['general_error_cannot_create_meeting'] = 'ບໍ່ສາມາດສ້າງກອງປະຊຸມ.';
$string['general_error_cannot_get_recordings'] = 'ບໍ່ສາມາດສ້າງການບັນທຶກ.';
$string['general_error_no_answer'] = 'ຄໍາຕອບຫວ່າງເປົ່າ. ກະລຸນາກວດເບິ່ງ url ຂອງເຊີບເວີ BigBlueButton ແລະກວດເບິ່ງວ່າເຊີບເວີ BigBlueButton ເຮັດວຽກໄດ້ຫຼືບໍ່.';
$string['general_error_not_allowed_to_create_instances'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ສ້າງປະເພດຂອງຕົວຢ່າງໃດໆ.';
$string['general_error_not_found'] = 'ບໍ່ພົບນິຕິບຸກຄົນ : {$a}.';
$string['general_error_unable_connect'] = 'ບໍ່ສາມາດທີ່ຈະເຊື່ອມຕໍ່. ກະລຸນາກວດເບິ່ງ url ຂອງເຊີບເວີ BigBlueButton ແລະກວດເບິ່ງວ່າເຊີບເວີ BigBlueButton ເຮັດວຽກໄດ້ຫຼືບໍ່.';
$string['index_confirm_end'] = 'ທ່ານຕ້ອງການທີ່ຈະສິ້ນສຸດກອງປະຊຸມບໍ?';
$string['index_disabled'] = 'ປິດໃຊ້ງານແລ້ວ';
$string['index_enabled'] = 'ເປີດໃຊ້ງານແລ້ວ';
$string['index_ending'] = 'ກຳລັງສິ້ນສຸດກອງປະຊຸມ ... ກະລຸນາລໍຖ້າ';
$string['index_error_bbtn'] = 'ລະຫັດປະຈຳຕົວ BigBlueButton {$a} ແມ່ນບໍ່ຖືກຕ້ອງ';
$string['index_error_checksum'] = 'ເກີດຄວາມຜິດພາດກັບ checksum. ກະລຸນາກວດສອບເບິ່ງວ່າທ່ານໃສ່ຄວາມລັບທີ່ຖືກຕ້ອງ.';
$string['index_error_forciblyended'] = 'ບໍ່ສາມາດເຂົ້າຮ່ວມກອງປະຊຸມເນື່ອງຈາກວ່າ ມັນໄດ້ຖືກສິ້ນສຸດດ້ວຍຕົນເອງ.';
$string['index_error_noinstances'] = 'ບໍ່ມີຕົວຢ່າງຫ້ອງ BigBlueButton';
$string['index_error_unable_display'] = 'ບໍ່ສາມາດສະແດງກອງປະຊຸມໄດ້. ກະລຸນາກວດເບິ່ງ url ຂອງເຊີບເວີ BigBlueButton ແລະ ກວດເບິ່ງຖ້າຫາກວ່າເຊີບເວີ BigBlueButton ເຮັດວຽກໄດ້ຫຼືບໍ່.';
$string['index_heading'] = 'ຫ້ອງ BigBlueButton';
$string['index_heading_actions'] = 'ປະຕິບັດ';
$string['index_heading_group'] = 'ກຸ່ມ';
$string['index_heading_moderator'] = 'ຜູ້ຄວບຄຸມ';
$string['index_heading_name'] = 'ຫ້ອງ';
$string['index_heading_recording'] = 'ການບັນທຶກ';
$string['index_heading_users'] = 'ຜູ້ໃຊ້';
$string['index_heading_viewer'] = 'ຜູ້ເບິ່ງ';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ດ້ານ BigBlueButton';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເລິກຂອງສະຕິປັນຍາບັນລຸໄດ້ໂດຍນັກຮຽນໃນກິດຈະກໍາ BigBlueButton.';
$string['indicator:socialbreadth'] = 'ສັງຄົມ BigBlueButton';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ ແມ່ນອີງໃສ່ຄວາມກວ້າງຂອງສັງຄົມທີ່ນັກຮຽນບັນລຸໄດ້ໃນກິດຈະກໍາ BigBlueButton.';
$string['instance_type_default'] = 'ຫ້ອງທີ່ມີການບັນທຶກ';
$string['instance_type_recording_only'] = 'ການບັນທຶກເທົ່ານັ້ນ';
$string['instance_type_room_only'] = 'ຫ້ອງເທົ່ານັ້ນ';
$string['instanceprofilewithoutrecordings'] = 'ໂປຼໄຟລ໌ຕົວຢ່າງນີ້ບໍ່ສາມາດສະແດງການບັນທຶກໄດ້';
$string['messageprovider:instance_updated'] = 'ປັບປຸງກອງປະຊຸມ BigBlueButton ແລ້ວ';
$string['messageprovider:recording_ready'] = 'ການບັນທຶກ BigBlueButton ກຽມພ້ອມ';
$string['minute'] = 'ນາທີ';
$string['minutes'] = 'ນາທີ';
$string['mod_form_block_general'] = 'ທົ່ວໄປ';
$string['mod_form_block_participants'] = 'ໜ້າທີ່ຖືກແຕ່ງຕັ້ງໃນເວລາຖ່າຍທອດສົດ';
$string['mod_form_block_presentation'] = 'ເນື້ອຫາການນຳສະເໜີ';
$string['mod_form_block_presentation_default'] = 'ການນຳສະເໜີເນື້ອຫາເລີ່ມຕົ້ນ';
$string['mod_form_block_record'] = 'ການຕັ້ງຄ່າການນຳສະເໜີ';
$string['mod_form_block_recordings'] = 'ເບິ່ງການບັນທຶກ';
$string['mod_form_block_room'] = 'ການຕັ້ງຄ່າຫ້ອງ';
$string['mod_form_block_schedule'] = 'ກຳນົດເວລາກອງປະຊຸມ';
$string['mod_form_field_closingtime'] = 'ປິດ';
$string['mod_form_field_conference_name'] = 'ຊື່ກອງປະຊຸມ';
$string['mod_form_field_disablecam'] = 'ປິດໃຊ້ງານກ້ອງເວັບແຄມ';
$string['mod_form_field_disablemic'] = 'ປິດໃຊ້ງານໄມໂຄຼໂຟນ';
$string['mod_form_field_disablenote'] = 'ປິດໃຊ້ງານບັນທຶກແບ່ງປັນ';
$string['mod_form_field_disableprivatechat'] = 'ປິດໃຊ້ງານການສົນທະນາສ່ວນຕົວ';
$string['mod_form_field_disablepublicchat'] = 'ປິດໃຊ້ງານການສົນທະນາສາທາລະນະ';
$string['mod_form_field_duration'] = 'ໄລຍະເວລາ';
$string['mod_form_field_duration_help'] = 'ກໍານົດໄລຍະເວລາສໍາລັບການປະຊຸມຈະກໍານົດເວລາສູງສຸດສໍາລັບການປະຊຸມເພື່ອຮັກສາໃຫ້ມີຊີວິດກ່ອນທີ່ຈະສໍາເລັດການບັນທຶກ.';
$string['mod_form_field_hideuserlist'] = 'ເຊື່ອງລາຍການຜູ້ໃຊ້';
$string['mod_form_field_instanceprofiles'] = 'ປະເພດຕົວຢ່າງ';
$string['mod_form_field_instanceprofiles_help'] = 'ຖ້າກອງປະຊຸມຈະຖືກບັນທຶກ, ເລືອກ \'ຫ້ອງທີ່ມີການບັນທຶກ\', ຖ້າບໍ່ດັ່ງນັ້ນ \'ຫ້ອງເທົ່ານັ້ນ\'. ຫຼັງຈາກກອງປະຊຸມຖືກບັນທຶກ, ຖ້າຈະບໍ່ມີກອງປະຊຸມອີກ, ເລືອກ \'ການບັນທຶກເທົ່ານັ້ນ\'.';
$string['mod_form_field_intro'] = 'ຄຳອະທິບາຍ';
$string['mod_form_field_intro_help'] = 'ຄໍາອະທິບາຍສັ້ນໆສໍາລັບຫ້ອງ.';
$string['mod_form_field_lockonjoin'] = 'ການຕັ້ງຄ່າລັອກໃນການຮ່ວມ';
$string['mod_form_field_muteonstart'] = 'ປິດສຽງເມື່ອເລີ່ມຕົ້ນ';
$string['mod_form_field_name'] = 'ຊື່ຫ້ອງ';
$string['mod_form_field_nosettings'] = 'ບໍ່ມີການຕັ້ງຄ່າສາມາດແກ້ໄຂໄດ້';
$string['mod_form_field_openingtime'] = 'ເປີດ';
$string['mod_form_field_participant_add'] = 'ເພີ່ມຜູ້ຮັບມອບໝາຍ';
$string['mod_form_field_participant_bbb_role_moderator'] = 'ຜູ້ຄວບຄຸມ';
$string['mod_form_field_participant_bbb_role_viewer'] = 'ຜູ້ເບິ່ງ';
$string['mod_form_field_participant_list'] = 'ຜູ້ຮັບມອບໝາຍ';
$string['mod_form_field_participant_list_action_add'] = 'ເພີ່ມ';
$string['mod_form_field_participant_list_action_remove'] = 'ເອົາອອກ';
$string['mod_form_field_participant_list_text_as'] = 'ຮ່ວມກອງປະຊຸມເປັນ';
$string['mod_form_field_participant_list_type_all'] = 'ລົງທະບຽນຮຽນຜູ້ໃຊ້ທັງໝົດ';
$string['mod_form_field_participant_list_type_owner'] = 'ເຈົ້າຂອງ';
$string['mod_form_field_participant_list_type_role'] = 'ໜ້າທີ່';
$string['mod_form_field_participant_list_type_user'] = 'ຜູ້ໃຊ້';
$string['mod_form_field_record'] = 'ກອງປະຊຸມອາດຈະຖືກບັນທຶກ';
$string['mod_form_field_recordallfromstart'] = 'ບັນທຶກທັງໝົດຈາກເລີ່ມຕົ້ນ';
$string['mod_form_field_recordhidebutton'] = 'ເຊື່ອງປຸ່ມການບັນທຶກ';
$string['mod_form_field_recordings_deleted'] = 'ລວມເອົາການບັນທຶກຈາກກິດຈະກໍາທີ່ຖືກລຶບ';
$string['mod_form_field_recordings_html'] = 'ສະແດງຕາຕະລາງໃນ HTML ທຳມະດາ';
$string['mod_form_field_recordings_imported'] = 'ສະແດງລິ້ງນຳເຂົ້າເທົ່ານັ້ນ';
$string['mod_form_field_recordings_preview'] = 'ສະແດງເບິ່ງຕົວຢ່າງການບັນທຶກ';
$string['mod_form_field_room_name'] = 'ຊື່ຫ້ອງ';
$string['mod_form_field_userlimit'] = 'ຈຳກັດຜູ້ໃຊ້';
$string['mod_form_field_userlimit_help'] = 'ຈຳກັດຜູ້ໃຊ້ສູງສຸດທີ່ອະນຸຍາດໃຫ້ຢູ່ໃນກອງປະຊຸມ. ຕັ້ງຄ່າເປັນ 0 ເພື່ອອະນຸຍາດໃຫ້ຈໍານວນຜູ້ໃຊ້ບໍ່ຈໍາກັດ.';
$string['mod_form_field_voicebridge'] = 'ຂົວສຽງ [####]';
$string['mod_form_field_voicebridge_format_error'] = 'ຮູບແບບຜິດພາດ. ທ່ານຄວນໃສ່ຕົວເລກລະຫວ່າງ 1 ຫາ 9999.';
$string['mod_form_field_voicebridge_help'] = 'ຕົວເລກລະຫວ່າງ 1 ແລະ 9999 ທີ່ຜູ້ເຂົ້າຮ່ວມເຂົ້າໄປເພື່ອເຂົ້າຮ່ວມກອງປະຊຸມສຽງໃນເວລາໃຊ້ໂທເຂົ້າ. ຖ້າຄ່າແມ່ນ 0, ໝາຍເລກຂົວສຽງຄົງທີ່ຈະຖືກລະເລີຍ ແລະ ຕົວເລກແບບສຸ່ມຈະຖືກສ້າງຂຶ້ນໂດຍ BigBlueButton. ຕົວເລກ 7 ຈະນຳໜ້າສີ່ຕົວເລກທີ່ພິມ.';
$string['mod_form_field_voicebridge_notunique_error'] = 'ບໍ່ແມ່ນມູນຄ່າທີ່ເປັນເອກະລັກ. ຕົວເລກນີ້ຖືກໃຊ້ໂດຍຫ້ອງອື່ນ.';
$string['mod_form_field_wait'] = 'ລໍຖ້າສຳລັບຜູ້ຄວບຄຸມ';
$string['mod_form_field_wait_help'] = 'ຜູ້ຊົມຕ້ອງລໍຖ້າຈົນກ່ວາຜູ້ຄວບຄຸມເຂົ້າມາໃນຫ້ອງບໍ?';
$string['mod_form_field_welcome'] = 'ຂໍ້ຄວາມຕ້ອນຮັບ';
$string['mod_form_field_welcome_default'] = 'ຍິນດີຕ້ອນຮັບສູ່ %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'ຂໍ້ຄວາມຍິນດີຕ້ອນຮັບຈະສະແດງເມື່ອຜູ້ເຂົ້າຮ່ວມເຂົ້າໄປໃນຫ້ອງ. ຖ້າຊ່ອງຂໍ້ມູນຖືກປະໄວ້ຫວ່າງເປົ່າ, ຫຼັງຈາກນັ້ນ, ຂໍ້ຄວາມເລີ່ມຕົ້ນທີ່ກໍານົດໄວ້ໃນການຄຸ້ມຄອງເວັບໄຊທ໌ຈະຖືກສະແດງ.';
$string['mod_form_locksettings'] = 'ການຕັ້ງຄ່າລັອກ';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton ເປັນລະບົບການປະຊຸມເວັບແບບເປີດທີ່ອອກແບບມາເພື່ອການຮຽນຮູ້ທາງອອນໄລນ໌, ເຊິ່ງຮອງຮັບການແບ່ງປັນສຽງ, ວິດີໂອ, ສົນທະນາ, ສະໄລ້, ການແບ່ງປັນໜ້າຈໍ, ກະດານຂາວທີ່ມີຜູ້ໃຊ້ຫຼາຍຄົນ, ຫ້ອງແບ່ງກຸ່ມ, ການສຳຫຼວດ ແລະ emojis.

ການນໍາໃຊ້ BigBlueButton ທ່ານສາມາດສ້າງຫ້ອງສໍາລັບກອງປະຊຸມເຊັ່ນ: ຫ້ອງຮຽນອອນໄລນ໌ສົດ, ຊົ່ວໂມງຫ້ອງການສະເໜືອນຈິງ ຫຼື ການຮ່ວມມືກຸ່ມກັບນັກຮຽນທາງໄກ. ກອງປະຊຸມສາມາດຖືກບັນທຶກສໍາລັບການຫຼິ້ນພາຍຫຼັງ.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'ກິດຈະກຳ BigBlueButton';
$string['nosuchinstance'] = 'ບໍ່ມີຕົວຢ່າງດັ່ງກ່າວ {$a->entity} ກັບລະຫັດປະຈຳຕົວ {$a->id}';
$string['notification_instance_created_intro'] = 'ຫ້ອງ <a href="{$a->link}">{$a->name}</a> BigBlueButton ຖືກສ້າງຂຶ້ນ.';
$string['notification_instance_created_small'] = 'ຫ້ອງ BigBlueButton ໃໝ່ທີ່ມີຊື່ວ່າ {$a->name} ຖືກສ້າງຂຶ້ນ.';
$string['notification_instance_created_subject'] = 'ຫ້ອງ BigBlueButton ໃໝ່ໄດ້ຖືກສ້າງຂື້ນ';
$string['notification_instance_description'] = 'ຄຳອະທິບາຍ';
$string['notification_instance_end_date'] = 'ວັນທີ່ສິ້ນສຸດ';
$string['notification_instance_name'] = 'ຫົວເລື່ອງ';
$string['notification_instance_start_date'] = 'ວັນທີ່ເລີ່ມຕົ້ນ';
$string['notification_instance_updated_intro'] = 'ຫ້ອງ <a href="{$a->link}">{$a->name}</a> BigBlueButton ໄດ້ຖືກປັບປຸງແລ້ວ.';
$string['notification_instance_updated_small'] = 'ກອງປະຊຸມ {$a->name} BigBlueButton ໄດ້ຖືກປັບປຸງແລ້ວ';
$string['notification_instance_updated_subject'] = 'ຫ້ອງ BigBlueButton ຂອງທ່ານໄດ້ຖືກປັບປຸງແລ້ວ';
$string['notification_recording_ready_html'] = 'ຕອນນີ້ການບັນທຶກສຽງມີໃຫ້ສໍາລັບການປະຊຸມທີ່ຜ່ານມາໃນຫ້ອງ BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'ຕອນນີ້ມີການບັນທຶກສຽງມີໃຫ້ສຳລັບການປະຊຸມຢູ່ໃນຫ້ອງ BigBlueButton {$a->name}. ໄປທີ່ {$a->link} ເພື່ອເຂົ້າເຖິງລິ້ງບັນທຶກ.';
$string['notification_recording_ready_small'] = 'ມີການບັນທຶກສຽງສຳລັບຫ້ອງ BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'ມີການບັນທຶກໃຫ້';
$string['pluginadministration'] = 'ການບໍລິຫານ BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'ເພື່ອສ້າງ ແລະ ເຂົ້າຮ່ວມກອງປະຊຸມ BigBlueButton, ຂໍ້ມູນຜູ້ໃຊ້ຕ້ອງໄດ້ຮັບການແລກປ່ຽນກັບເຊີເວີ.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'ຊື່ເຕັມຂອງຜູ້ໃຊ້ທີ່ເຂົ້າເຖິງເຊີບເວີຂອງ BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ເຂົ້າເຖິງເຊີບເວີຂອງ BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'ການກໍານົດກອງປະຊຸມ BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'ບັນຊີລາຍຊື່ຂອງກົດລະບຽບທີ່ກໍານົດບົດບາດຂອງຜູ້ໃຊ້ຈະມີຢູ່ໃນກອງປະຊຸມ BigBlueButton. ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ອາດຈະໄດ້ຮັບການເກັບຮັກສາໄວ້ເປັນການອະນຸຍາດສາມາດໄດ້ຮັບການອະນຸຍາດໃຫ້ຕໍ່ບົດບາດ ຫຼື ຜູ້ໃຊ້.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'ເກັບຮັກສາເຫດການທີ່ເກີດຂຶ້ນໃນເວລາໃຊ້ປລັກອິນ.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'ປະເພດຂອງເຫດການທີ່ເກີດຂຶ້ນໂດຍຜູ້ໃຊ້.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ລະຫັດປະຈຳຕົວກອງປະຊຸມທີ່ຜູ້ໃຊ້ທີ່ຈະຕ້ອງການເຂົ້າເຖິງ.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'ອາດຈະປະກອບມີຂໍ້ມູນເພີ່ມເຕີມທີ່ກ່ຽວຂ້ອງກັບກອງປະຊຸມ ຫຼື ການບັນທຶກ.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'ເວລາທີ່ບັນທຶກໄດ້ຖືກສ້າງຂຶ້ນແລ້ວ.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ເຮັດໃຫ້ເກີດເຫດການ.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'ການບັນທຶກກ່ຽວກັບການເກັບຮັກສາ metadata';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ມີການປ່ຽນແປງການບັນທຶກຄັ້ງສຸດທ້າຍ.';
$string['recordings_from_deleted_activities'] = 'ບັນທຶກຈາກກິດຈະກຳທີ່ຖືກລຶບ';
$string['recordingurlnotfound'] = 'ການບັນທຶກ URL ບໍ່ຖືກຕ້ອງ';
$string['removedevents'] = 'ລຶບເຫດການແລ້ວ';
$string['removedlogs'] = 'ລຶບບັນທຶກແບບກຳນົດເອງແລ້ວ';
$string['removedrecordings'] = 'ລຶບການບັນທຶກແລ້ວ';
$string['removedtags'] = 'ລຶບແທັກແລ້ວ';
$string['report_join_info'] = 'ໄດ້ເຂົ້າຮ່ວມຫ້ອງ {$a} ຄັ້ງ';
$string['report_play_recording_info'] = 'ໄດ້ຫຼິ້ນການບັນທຶກ {$a} ຄັ້ງ';
$string['report_room_view'] = 'ໄດ້ເບິ່ງໜ້າຂອງຫ້ອງ';
$string['resetevents'] = 'ລຶບເຫດການ';
$string['resetlogs'] = 'ລຶບບັນທຶກແບບກຳນົດເອງ';
$string['resetlogs_help'] = 'ການລຶບບັນທຶກຈະເຮັດໃຫ້ສູນເສຍການອ້າງອີງເຖິງການບັນທຶກ.';
$string['resetrecordings'] = 'ລຶບການບັນທຶກ';
$string['resetrecordings_help'] = 'ການລຶບການບັນທຶກຈະເຮັດໃຫ້ພວກມັນບໍ່ສາມາດເຂົ້າເຖິງໄດ້ຈາກທຸກບ່ອນ. ຄຳສັ່ງນີ້ບໍ່ສາມາດຍົກເລີກໄດ້!';
$string['resettags'] = 'ລຶບແທັກ';
$string['search:activity'] = 'BigBlueButton - ຂໍ້ມູນກິດຈະກຳ';
$string['search:tags'] = 'BigBlueButton - ຂໍ້ມູນແທັກ';
$string['sendnotification'] = 'ສົ່ງການແຈ້ງເຕືອນ';
$string['settings'] = 'ການຕັ້ງຄ່າ BigBlueButton';
$string['started_at'] = 'ເລີ່ມຕົ້ນແລ້ວ';
$string['starts_at'] = 'ເລີ່ມຕົ້ນ';
$string['taskname:check_pending_recordings'] = 'ດຶງບັນທຶກທີ່ຍັງລໍຖ້າ';
$string['userlimitreached'] = 'ຮອດຈຳນວນຜູ້ໃຊ້ທີ່ອະນຸຍາດໃນກອງປະຊຸມແລ້ວ.';
$string['view_conference_action_end'] = 'ສິ້ນສຸດການປະຊຸມ';
$string['view_conference_action_join'] = 'ເຂົ້າຮ່ວມການປະຊຸມ';
$string['view_error_action_not_completed'] = 'ການດຳເນີນການບໍ່ສາມາດສຳເລັດໄດ້';
$string['view_error_bigbluebutton'] = 'BigBlueButton ຕອບສະໜອງດ້ວຍຄວາມຜິດພາດ. {$a}';
$string['view_error_create'] = 'ເຊີບເວີ BigBlueButton ຕອບກັບດ້ວຍຂໍ້ຄວາມສະແດງຂໍ້ຜິດພາດ, ຫ້ອງບໍ່ສາມາດສ້າງໄດ້.';
$string['view_error_current_state_not_found'] = 'ບໍ່ພົບສະຖານະປັດຈຸບັນ. ການບັນທຶກອາດຈະຖືກລຶບໄປແລ້ວ ຫຼື ເຊີບເວີ BigBlueButton ບໍ່ເຂົ້າກັນໄດ້ກັບການປະຕິບັດທີ່ປະຕິບັດ.';
$string['view_error_import_no_courses'] = 'ບໍ່ມີວິຊາທີ່ຈະຊອກຫາການບັນທຶກ.';
$string['view_error_import_no_recordings'] = 'ບໍ່ມີການບັນທຶກໃນລາຍວິຊານີ້ສໍາລັບການນໍາເຂົ້າ.';
$string['view_error_invalid_session'] = 'ກອງປະຊຸມໝົດອາຍຸແລ້ວ. ກັບໄປທີ່ໜ້າກິດຈະກຳ.';
$string['view_error_max_concurrent'] = 'ຮອດຈຳນວນຂອງກອງປະຊຸມພ້ອມໆກັນທີ່ອະນຸຍາດແລ້ວ.';
$string['view_error_meeting_not_running'] = 'ມີບາງຢ່າງຜິດພາດເກີດຂຶ້ນ; ກອງປະຊຸມບໍ່ໄດ້ດໍາເນີນ.';
$string['view_error_no_group'] = 'ບໍ່ມີກຸ່ມ. ທ່ານຈໍາເປັນຕ້ອງສ້າງບາງກຸ່ມກ່ອນທີ່ຈະພະຍາຍາມເຂົ້າຮ່ວມກອງປະຊຸມ.';
$string['view_error_no_group_student'] = 'ທ່ານຍັງບໍ່ໄດ້ເພີ່ມເຂົ້າໃນກຸ່ມ. ກະລຸນາຕິດຕໍ່ຄູສອນຂອງທ່ານ.';
$string['view_error_no_group_teacher'] = 'ບໍ່ມີກຸ່ມ. ທ່ານຈໍາເປັນຕ້ອງສ້າງບາງກຸ່ມ.';
$string['view_error_unable_join'] = 'ບໍ່ສາມາດເຂົ້າຫ້ອງໄດ້. ກະລຸນາກວດເບິ່ງ URL ຂອງເຊີບເວີ BigBlueButton ແລະ ກວດເບິ່ງວ່າເຊີບເວີ BigBlueButton ເຮັດວຽກຫຼືບໍ່.';
$string['view_error_unable_join_student'] = 'ບໍ່ສາມາດເຊື່ອມຕໍ່ກັບເຊີບເວີ BigBlueButton ໄດ້.';
$string['view_error_unable_join_teacher'] = 'ບໍ່ສາມາດເຊື່ອມຕໍ່ກັບເຊີບເວີ BigBlueButton ໄດ້. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ.';
$string['view_error_url_missing_parameters'] = 'ບໍ່ມີຕົວກໍານົດການຢູ່ໃນ URL ນີ້';
$string['view_error_userlimit_reached'] = 'ຮອດຈຳນວນຜູ້ໃຊ້ທີ່ອະນຸຍາດໃນກອງປະຊຸມແລ້ວ.';
$string['view_groups_nogroups_warning'] = 'ຫ້ອງໄດ້ຖືກຕັ້ງຄ່າສໍາລັບການນໍາໃຊ້ກຸ່ມ ແຕ່ລາຍວິຊາບໍ່ໄດ້ກໍານົດກຸ່ມ.';
$string['view_groups_notenrolled_warning'] = 'ຫ້ອງໄດ້ຖືກຕັ້ງຄ່າສໍາລັບການນໍາໃຊ້ກຸ່ມ ແຕ່ທ່ານບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມ.';
$string['view_groups_selection'] = 'ເລືອກກຸ່ມທີ່ທ່ານຕ້ອງການທີ່ຈະເຂົ້າຮ່ວມ ແລະ ຢືນຢັນການດໍາເນີນການ';
$string['view_groups_selection_join'] = 'ເຂົ້າຮ່ວມ';
$string['view_groups_selection_warning'] = 'ມີຫ້ອງສໍາລັບແຕ່ລະກຸ່ມ ແລະ ທ່ານສາມາດເຂົ້າເຖິງຫຼາຍກວ່າໜຶ່ງ. ໃຫ້ແນ່ໃຈວ່າຈະເລືອກອັນທີ່ຖືກຕ້ອງ.';
$string['view_login_moderator'] = 'ກຳລັງເຂົ້າສູ່ລະບົບເປັນຜູ້ຄວບຄຸມ ...';
$string['view_login_viewer'] = 'ກຳລັງເຂົ້າສູ່ລະບົບເປັນຜູ້ເບິ່ງ ...';
$string['view_message_and'] = 'ແລະ';
$string['view_message_conference_has_ended'] = 'ກອງປະຊຸມໄດ້ສິ້ນສຸດແລ້ວ';
$string['view_message_conference_in_progress'] = 'ກອງປະຊຸມພວມດຳເນີນຢູ່.';
$string['view_message_conference_not_started'] = 'ກອງປະຊຸມຍັງບໍ່ທັນໄດ້ເລີ່ມຕົ້ນເທື່ອ.';
$string['view_message_conference_room_ready'] = 'ຫ້ອງນີ້ພ້ອມແລ້ວ. ທ່ານສາມາດເຂົ້າຮ່ວມກອງປະຊຸມໄດ້ໃນຕອນນີ້.';
$string['view_message_conference_wait_for_moderator'] = 'ກຳລັງລໍຖ້າຜູ້ຄວບຄຸມເຂົ້າຮ່ວມ.';
$string['view_message_finished'] = 'ກິດຈະກຳນີ້ຈົບແລ້ວ.';
$string['view_message_has_joined'] = 'ໄດ້ເຂົ້າຮ່ວມແລ້ວ';
$string['view_message_have_joined'] = 'ໄດ້ເຂົ້າຮ່ວມ';
$string['view_message_hour'] = 'ຊົ່ວໂມງ';
$string['view_message_hours'] = 'ຊົ່ວໂມງ';
$string['view_message_importrecordings_disabled'] = 'ລິ້ງການບັນທຶກການນໍາເຂົ້າຖືກປິດໃຊ້ງານຢູ່ໃນເຊີເວີ.';
$string['view_message_minute'] = 'ນາທີ';
$string['view_message_minutes'] = 'ນາທີ';
$string['view_message_moderator'] = 'ຜູ້ຄວບຄຸມ';
$string['view_message_moderators'] = 'ຜູ້ຄວບຄຸມ';
$string['view_message_norecordings'] = 'ບໍ່ມີການບັນທຶກໃຫ້.';
$string['view_message_notavailableyet'] = 'ຊ່ວງເວລານີ້ນີ້ຍັງບໍ່ທັນມີເທື່ອ.';
$string['view_message_recordings_disabled'] = 'ການບັນທຶກຖືກປິດການນຳໃຊ້ຢູ່ໃນເຊີເວີນີ້. ກິດຈະກໍາ BigBlueButton ຂອງປະເພດ \'ການບັນທຶກເທົ່ານັ້ນ\' ບໍ່ສາມາດຖືກນໍາໃຊ້.';
$string['view_message_room_closed'] = 'ຫ້ອງນີ້ປິດຢູ່.';
$string['view_message_room_open'] = 'ຫ້ອງນີ້ເປີດຢູ່.';
$string['view_message_room_ready'] = 'ຫ້ອງນີ້ພ້ອມແລ້ວ.';
$string['view_message_session_for'] = 'ຊ່ວງເວລາສຳລັບ';
$string['view_message_session_has_user'] = 'ມີ';
$string['view_message_session_has_users'] = 'ມີ';
$string['view_message_session_no_users'] = 'ບໍ່ມີຜູ້ໃຊ້ໃນຊ່ວງເວລານີ້';
$string['view_message_session_running_for'] = 'ກອງປະຊຸມນີ້ໄດ້ຖືກດໍາເນີນການສໍາລັບ';
$string['view_message_session_started_at'] = 'ກອງປະຊຸມນີ້ໄດ້ເລີ່ມຕົ້ນທີ່';
$string['view_message_tab_close'] = 'ແຖບ/ໜ້າຈໍນີ້ຕ້ອງຖືກປິດດ້ວຍຕົນເອງ';
$string['view_message_times'] = 'ເວລາ';
$string['view_message_user'] = 'ຜູ້ໃຊ້';
$string['view_message_users'] = 'ຜູ້ໃຊ້';
$string['view_message_viewer'] = 'ຜູ້ເບິ່ງ';
$string['view_message_viewers'] = 'ຜູ້ເບິ່ງ';
$string['view_mobile_message_groups_not_supported'] = 'ຕົວຢ່າງນີ້ໄດ້ເປີດໃຊ້ງານເພື່ອເຮັດວຽກກັບກຸ່ມ ແຕ່ແອັບມືຖືບໍ່ຮອງຮັບມັນ. ກະລຸນາໃຊ້ສະບັບເວັບ.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'ທ່ານໃຊ້ເວລາເກີນ 45 ວິນາທີໃນໜ້ານີ້, ກະລຸນາໂຫຼດໜ້ານີ້ຄືນໃໝ່ ເພື່ອເຂົ້າຮ່ວມກອງປະຊຸມ.';
$string['view_noguests'] = 'ຫ້ອງ BigBlueButton ບໍ່ເປີດໃຫ້ແຂກ.';
$string['view_nojoin'] = 'ທ່ານບໍ່ມີບົດບາດທີ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເຂົ້າຮ່ວມກອງປະຊຸມນີ້.';
$string['view_recording'] = 'ການບັນທຶກ';
$string['view_recording_actionbar'] = 'ແຖບເຄື່ອງມື';
$string['view_recording_activity'] = 'ກິດຈະກຳ';
$string['view_recording_button_import'] = 'ນຳເຂົ້າລິ້ງການບັນທຶກ';
$string['view_recording_button_return'] = 'ກັບຄືນ';
$string['view_recording_course'] = 'ລາຍວິຊາ';
$string['view_recording_date'] = 'ວັນທີ';
$string['view_recording_delete_confirmation'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຈະທ່ານຕ້ອງການລຶບ {$a} ນີ້?';
$string['view_recording_delete_confirmation_warning_p'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງນຳເຂົ້າໃນວິຊາ ຫຼື ກິດຈະກຳຕ່າງໆ. ຖ້າການບັນທຶກໄດ້ຖືກລຶບ, ລິ້ງເຫຼົ່ານັ້ນຈະຖືກລຶບອອກເຊັ່ນດຽວກັນ.';
$string['view_recording_delete_confirmation_warning_s'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງນຳເຂົ້າມາໃນລາຍວິຊາ ຫຼື ກິດຈະກຳທີ່ແຕກຕ່າງກັນ. ຖ້າການບັນທຶກຖືກລຶບ, ລິ້ງນີ້ຈະຖືກລຶບອອກເຊັ່ນດຽວກັນ.';
$string['view_recording_description'] = 'ຄຳອະທິບາຍ';
$string['view_recording_description_edithint'] = 'ລາຍລະອຽດອາດຈະຖືກເພີ່ມເພື່ອຊ່ວຍລະບຸການບັນທຶກ.';
$string['view_recording_description_editlabel'] = 'ແກ້ໄຂຄໍາອະທິບາຍ';
$string['view_recording_duration'] = 'ໄລຍະເວລາ';
$string['view_recording_duration_min'] = 'ນາທີ';
$string['view_recording_format_errror_unreachable'] = 'URL ສໍາລັບຮູບແບບການບັນທຶກນີ້ແມ່ນບໍ່ສາມາດຕິດຕໍ່ໄດ້.';
$string['view_recording_format_notes'] = 'ໝາຍເຫດ';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'ການນຳສະເໜີ';
$string['view_recording_format_screenshare'] = 'ແບ່ງປັນໜ້າຈໍ';
$string['view_recording_format_statistics'] = 'ສະຖິຕິ';
$string['view_recording_format_video'] = 'ວິດີໂອ';
$string['view_recording_import_confirmation'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຈະນໍາເຂົ້າການບັນທຶກນີ້?';
$string['view_recording_length'] = 'ຄວາມຍາວ';
$string['view_recording_link_warning'] = 'ນີ້ແມ່ນການເຊື່ອມຕໍ່ທີ່ຊີ້ໄປຫາບັນທຶກທີ່ຖືກສ້າງຂຶ້ນໃນລາຍວິຊາ ຫຼື ກິດຈະກໍາທີ່ແຕກຕ່າງກັນ.';
$string['view_recording_list_action_delete'] = 'ກຳລັງລຶບ';
$string['view_recording_list_action_edit'] = 'ກຳລັງປັບປຸງ';
$string['view_recording_list_action_play'] = 'ຫຼິ້ນ';
$string['view_recording_list_action_process'] = 'ກຳລັງປະມວນຜົນ';
$string['view_recording_list_action_protect'] = 'ກຳລັງປ້ອງກັນ';
$string['view_recording_list_action_publish'] = 'ກຳລັງເຜີຍແຜ່';
$string['view_recording_list_action_unprotect'] = 'ກຳລັງງຍົກເລີກປ້ອງກັນ';
$string['view_recording_list_action_unpublish'] = 'ກຳລັງຍົກເລີກເຜີຍແຜ່';
$string['view_recording_list_action_update'] = 'ກຳລັງປັບປຸງ';
$string['view_recording_list_actionbar'] = 'ແຖບເຄື່ອງມື';
$string['view_recording_list_actionbar_delete'] = 'ລຶບ';
$string['view_recording_list_actionbar_edit'] = 'ແກ້ໄຂ';
$string['view_recording_list_actionbar_hide'] = 'ເຊື່ອງ';
$string['view_recording_list_actionbar_import'] = 'ນຳເຂົ້າ';
$string['view_recording_list_actionbar_protect'] = 'ເຮັດໃຫ້ເປັນສ່ວນຕົວ';
$string['view_recording_list_actionbar_publish'] = 'ເຜີຍແຜ່';
$string['view_recording_list_actionbar_show'] = 'ສະແດງ';
$string['view_recording_list_actionbar_unprotect'] = 'ເຮັດໃຫ້ເປັນສາທາລະນະ';
$string['view_recording_list_actionbar_unpublish'] = 'ຍົກເລີກເປັນສາທາລະນະ';
$string['view_recording_list_activity'] = 'ກິດຈະກຳ';
$string['view_recording_list_course'] = 'ລາຍວິຊາ';
$string['view_recording_list_date'] = 'ວັນທີ';
$string['view_recording_list_description'] = 'ຄຳອະທິບາຍ';
$string['view_recording_list_duration'] = 'ໄລຍະເວລາ';
$string['view_recording_list_recording'] = 'ການບັນທຶກ';
$string['view_recording_meeting'] = 'ກອງປະຊຸມ';
$string['view_recording_modal_button'] = 'ນຳໃຊ້';
$string['view_recording_modal_title'] = 'ກໍານົດຄ່າສໍາລັບການບັນທຶກ';
$string['view_recording_name'] = 'ຊື່';
$string['view_recording_name_edithint'] = 'ອາດມີການເພີ່ມຊື່ເພື່ອຊ່ວຍລະບຸການບັນທຶກ.';
$string['view_recording_name_editlabel'] = 'ແກ້ໄຂຊື່';
$string['view_recording_playback'] = 'ຫຼິ້ນຄືນ';
$string['view_recording_preview'] = 'ເບິ່ງຕົວຢ່າງ';
$string['view_recording_preview_help'] = 'ເລື່ອນໃສ່ຮູບເພື່ອເບິ່ງມັນໃນຂະໜາດເຕັມ';
$string['view_recording_protect_confirmation'] = 'ທ່ານແນ່ໃຈບໍ່ທີ່ຈະປົກປ້ອງ {$a} ນີ້?';
$string['view_recording_protect_confirmation_warning_p'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າໃນວິຊາ ຫຼື ກິດຈະກຳທີ່ແຕກຕ່າງກັນ. ຖ້າການບັນທຶກຖືກປ້ອງກັນ, ມັນຈະສົ່ງຜົນກະທົບຕໍ່ການເຊື່ອມຕໍ່ທີ່ນໍາເຂົ້າ';
$string['view_recording_protect_confirmation_warning_s'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າມາໃນລາຍວິຊາ ຫຼື ກິດຈະກຳທີ່ແຕກຕ່າງກັນ. ຖ້າການບັນທຶກຖືກປ້ອງກັນ ມັນຈະສົ່ງຜົນກະທົບຕໍ່ລິ້ງທີ່ນໍາເຂົ້າ.';
$string['view_recording_publish_confirmation'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຈະເຜີຍແຜ່ {$a} ນີ້?';
$string['view_recording_publish_confirmation_warning_p'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າໃນລາຍວິຊາ ຫຼື ກິດຈະກຳທີ່ແຕກຕ່າງກັນ. ຖ້າການບັນທຶກຖືກເຜີຍແຜ່, ລິ້ງເຫຼົ່ານັ້ນຈະຖືກເຜີຍແຜ່ເຊັ່ນກັນ.';
$string['view_recording_publish_confirmation_warning_s'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າມາໃນລາຍວິຊາ ຫຼື ກິດຈະກຳທີ່ແຕກຕ່າງກັນ. ຖ້າການບັນທຶກຖືກເຜີຍແຜ່, ລິ້ງນີ້ຈະຖືກເຜີຍແຜ່ເຊັ່ນກັນ.';
$string['view_recording_publish_link_deleted'] = 'ລິ້ງນີ້ບໍ່ສາມາດເຜີຍແຜ່ຄືນໃໝ່ໄດ້ເນື່ອງຈາກການບັນທຶກຕົວຈິງບໍ່ມີຢູ່ໃນເຊີບເວີ BigBlueButton. ການເຊື່ອມຕໍ່ຄວນຈະຖືກເອົາອອກ.';
$string['view_recording_publish_link_not_published'] = 'ລິ້ງນີ້ບໍ່ສາມາດເຜີຍແຜ່ຄືນໃໝ່ໄດ້ເນື່ອງຈາກການບັນທຶກຕົວຈິງບໍ່ໄດ້ຖືກເຜີຍແຜ່.';
$string['view_recording_recording'] = 'ການບັນທຶກ';
$string['view_recording_select_course'] = 'ເລືອກຫຼັກສູດທໍາອິດໃນເມນູເລື່ອນລົງ';
$string['view_recording_tags'] = 'ແທັກ';
$string['view_recording_unprotect_confirmation'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຈະບໍ່ປົກປ້ອງ {$a} ນີ້?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າໃນວິຊາ ຫຼື ກິດຈະກຳທີ່ແຕກຕ່າງກັນ. ຖ້າການບັນທຶກບໍ່ໄດ້ຮັບການປົກປ້ອງ ມັນຈະສົ່ງຜົນກະທົບຕໍ່ການເຊື່ອມຕໍ່ທີ່ນໍາເຂົ້າ.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າໃນວິຊາ ຫຼື ກິດຈະກຳທີ່ແຕກຕ່າງກັນ. ຖ້າການບັນທຶກບໍ່ໄດ້ຮັບການປົກປ້ອງ ມັນຈະສົ່ງຜົນກະທົບຕໍ່ການເຊື່ອມຕໍ່ທີ່ນໍາເຂົ້າ.';
$string['view_recording_unprotect_link_deleted'] = 'ລິ້ງນີ້ບໍ່ສາມາດເຜີຍແຜ່ຄືນໃໝ່ໄດ້ເນື່ອງຈາກການບັນທຶກຕົວຈິງບໍ່ມີຢູ່ໃນເຊີບເວີ BigBlueButton. ການເຊື່ອມຕໍ່ຄວນຈະຖືກເອົາອອກ.';
$string['view_recording_unprotect_link_not_unprotected'] = 'ລິ້ງນີ້ບໍ່ສາມາດຖືກປ້ອງກັນໄດ້ເນື່ອງຈາກການບັນທຶກຕົວຈິງຖືກປົກປ້ອງ.';
$string['view_recording_unpublish_confirmation'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຈະຍົກເລີກການເຜີຍແຜ່ {$a} ນີ້?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າໃນວິຊາ ຫຼື ກິດຈະກຳຕ່າງໆ. ຖ້າການບັນທຶກຖືກຍົກເລີກການເຜີຍແຜ່, ລິ້ງເຫຼົ່ານັ້ນຈະຖືກຍົກເລີກການເຜີຍແຜ່ເຊັ່ນກັນ.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'ການບັນທຶກນີ້ມີລິ້ງ {$a} ທີ່ເຊື່ອມໂຍງທີ່ນຳເຂົ້າໃນວິຊາ ຫຼື ກິດຈະກຳຕ່າງໆ. ຖ້າການບັນທຶກຖືກຍົກເລີກການເຜີຍແຜ່, ລິ້ງເຫຼົ່ານັ້ນຈະຖືກຍົກເລີກການເຜີຍແຜ່ເຊັ່ນກັນ.';
$string['view_recording_yui_first'] = 'ທຳອິດ';
$string['view_recording_yui_go'] = 'ໄປຫາ';
$string['view_recording_yui_last'] = 'ສຸດທ້າຍ';
$string['view_recording_yui_next'] = 'ຕໍ່ໄປ';
$string['view_recording_yui_page'] = 'ໜ້າ';
$string['view_recording_yui_prev'] = 'ກ່ອນໜ້າ';
$string['view_recording_yui_rows'] = 'ແຖວ';
$string['view_recording_yui_show_all'] = 'ສະແດງທັງໝົດ';
$string['view_room'] = 'ເບິ່ງຫ້ອງ';
$string['view_section_title_presentation'] = 'ໄຟລ໌ການສະເໜີ';
$string['view_section_title_recordings'] = 'ການບັນທຶກ';
$string['view_warning_default_server'] = 'ເວັບໄຊນີ້ກຳລັງໃຊ້ <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">ບໍລິການ BigBlueButton ແບບບໍ່ເສຍຄ່າສຳລັບ Moodle (ເປີດຢູ່ໃນໜ້າຈໍໃໝ່)</a> ສະໜອງໃຫ້ໂດຍ Blindside Networks ມີຂໍ້ຈໍາກັດດັ່ງຕໍ່ໄປນີ້:
<ol>
<li>ຄວາມຍາວສູງສຸດຂອງແຕ່ລະກອງປະຊຸມແມ່ນ 60 ນາທີ</li>
<li>ຈຳນວນສູງສຸດຂອງຜູ້ໃຊ້ພ້ອມກັນຕໍ່ກອງປະຊຸມແມ່ນ 25</li>
<li>ການບັນທຶກຈະໝົດອາຍຸຫຼັງຈາກເຈັດ (7) ມື້ ແລະ ບໍ່ສາມາດດາວໂຫຼດໄດ້</li>
<li>ເວັບແຄມຂອງນັກຮຽນແມ່ນເຫັນໄດ້ໂດຍຜູ້ຄວບຄຸມເທົ່ານັ້ນ.</li>
</ol>';
$string['waitformoderator'] = 'ກຳລັງລໍຖ້າຜູ້ຄວບຄຸມເຂົ້າຮ່ວມ.';
