<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'lo', version '4.0'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'ປິດການປະເມີນຜົນ:';
$string['activitydate:assessmentsclosed'] = 'ປິດການປະເມີນຜົນແລ້ວ:';
$string['activitydate:assessmentsopen'] = 'ເປີດການປະເມີນຜົນ:';
$string['activitydate:assessmentsopened'] = 'ເປີດການປະເມີນຜົນແລ້ວ:';
$string['activitydate:submissionsclose'] = 'ປິດການສົ່ງ:';
$string['activitydate:submissionsclosed'] = 'ປິດການສົ່ງແລ້ວ:';
$string['activitydate:submissionsopen'] = 'ເປີດການສົ່ງ:';
$string['activitydate:submissionsopened'] = 'ເປີດການສົ່ງແລ້ວ:';
$string['aggregategrades'] = 'ຄິດໄລ່ຄະແນນໃໝ່';
$string['aggregation'] = 'ການລວມຄະແນນ';
$string['allocate'] = 'ຈັດສັນການສົ່ງ';
$string['allocatedetails'] = 'ຄວາມຄາດຫວັງ: {$a->expected}<br />ໄດ້ສົ່ງ: {$a->submitted}<br />ເພື່ອຈັດສັນ: {$a->allocate}';
$string['allocation'] = 'ສົ່ງການຈັດສັນ';
$string['allocationconfigured'] = 'ກຳນົດຄ່ການຈັດສັນ';
$string['allocationdone'] = 'ສຳເລັດການຈັດສັນ';
$string['allocationerror'] = 'ການຈັດສັນພິດພາດ';
$string['allowedfiletypesforoverallfeedback'] = 'ໄຟລ໌ແນບທີ່ມີຄຳຕິຊົມທີ່ອະນຸຍາດປະເພດໄຟລ໌';
$string['allowedfiletypesforoverallfeedback_help'] = 'ປະເພດໄຟລ໌ແນບຄຳຕິຊົມສາມາດຖືກຈຳກັດໂດຍການໃຫ້ລາຍການປະເພດໄຟລ໌ທີ່ອະນຸຍາດ. ຖ້າຊ່ອງຂໍ້ມູນຖືກປະໄວ້ຫວ່າງເປົ່າ, ປະເພດໄຟລ໌ທັງໝົດແມ່ນອະນຸຍາດ.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'ປະເພດໄຟລ໌ທີ່ອະນຸຍາດໃຫ້ເອກະສານຊ້ອນທ້າຍການສົ່ງ';
$string['allowedfiletypesforsubmission_help'] = 'ປະເພດຂອງໄຟລ໌ແນບການຍື່ນສະເໜີສາມາດຖືກຈໍາກັດໂດຍການສະໜອງບັນຊີລາຍຊື່ຂອງປະເພດໄຟລ໌ທີ່ອະນຸຍາດ. ຖ້າຊ່ອງຂໍ້ມູນຖືກປະໄວ້ຫວ່າງເປົ່າ, ປະເພດໄຟລ໌ທັງໝົດແມ່ນອະນຸຍາດ.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'ການສົ່ງທັງໝົດ ({$a})';
$string['alreadygraded'] = 'ໄດ້ຄະແນນແລ້ວ';
$string['areaconclusion'] = 'ຂໍ້ຄວາມສະຫຼຸບ';
$string['areainstructauthors'] = 'ຄຳແນະນຳສຳລັບການສົ່ງ';
$string['areainstructreviewers'] = 'ຄຳແນະນຳສຳລັບການປະເມີນຜົນ';
$string['areaoverallfeedbackattachment'] = 'ພາບລວມເອກະສານຊ້ອນທ້າຍຄຳຕິຊົມ';
$string['areaoverallfeedbackcontent'] = 'ພາບລວມຂໍ້ຄວາມຄຳຕິຊົມ';
$string['areasubmissionattachment'] = 'ການສົ່ງເອກະສານຊ້ອນທ້າຍ';
$string['areasubmissioncontent'] = 'ຂໍ້ຄວາມການສົ່ງ';
$string['assess'] = 'ປະເມີນຜົນ';
$string['assessedexample'] = 'ປະເມີນການຜົນສົ່ງຕົວຢ່າງແລ້ວ';
$string['assessedsubmission'] = 'ປະເມີນຜົນການສົ່ງແລ້ວ';
$string['assessingexample'] = 'ກຳລັງປະເມີນຜົນການສົ່ງຕົວຢ່າງ';
$string['assessingsubmission'] = 'ກຳລັງປະເມີນຜົນການສົ່ງ';
$string['assessment'] = 'ການປະເມີນຜົນ';
$string['assessmentby'] = 'ໂດຍ <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'ການປະເມີນຜົນໂດຍ {$a}';
$string['assessmentbyyourself'] = 'ການປະເມີນຜົນຂອງທ່ານ';
$string['assessmentdeleted'] = 'ການປະເມີນຜົນຈັດສັນ';
$string['assessmentend'] = 'ເສັ້ນຕາຍສໍາລັບການປະເມີນຜົນ';
$string['assessmentendbeforestart'] = 'ເສັ້ນຕາຍສໍາລັບການປະເມີນຜົນບໍ່ສາມາດກໍານົດກ່ອນວັນເປີດສໍາລັບການປະເມີນຜົນ';
$string['assessmentenddatetime'] = 'ເສັ້ນຕາຍການປະເມີນຜົນ: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} ເສັ້ນຕາຍສໍາລັບການປະເມີນຜົນ';
$string['assessmentform'] = 'ການປະເມີນຜົນຈາກ';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">ການປະເມີນຜົນ</a> of <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'ການປະເມີນຜົນອ້າງອີງ';
$string['assessmentreferenceconflict'] = 'ມັນເປັນໄປບໍ່ໄດ້ທີ່ຈະປະເມີນການຍື່ນສະເໜີຕົວຢ່າງທີ່ທ່ານສະໜອງການປະເມີນການອ້າງອິງ.';
$string['assessmentreferenceneeded'] = 'ທ່ານຕ້ອງປະເມີນຜົນການສົ່ງຕົວຢ່າງນີ້ ເພື່ອໃຫ້ການປະເມີນຜົນການອ້າງອິງ. ໃຫ້ຄລິກໃສ່ປຸ່ມ \'ສືບຕໍ່\' ເພື່ອປະເມີນຜົນການສົ່ງ.';
$string['assessments'] = 'ການປະເມີນຜົນ';
$string['assessmentsettings'] = 'ການຕັ້ງຄ່າການປະເມີນຜົນ';
$string['assessmentstart'] = 'ເປີດສຳລັບການປະເມີນຜົນຈາກ';
$string['assessmentstartdatetime'] = 'ເປີດສຳລັບການປະເມີນຜົນຈາກ {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} ເປີດສຳລັບການປະເມີນຜົນ';
$string['assessmentweight'] = 'ນ້ຳໜັກການປະເມີນຜົນ';
$string['assignedassessments'] = 'ມອບໝາຍການສົ່ງແລ້ວເພື່ອປະເມີນຜົນ';
$string['assignedassessmentsnone'] = 'ທ່ານບໍ່ໄດ້ມອບໝາຍການສົ່ງແລ້ວເພື່ອປະເມີນຜົນ';
$string['backtoeditform'] = 'ກັບຄືນຫາແບບຟອມການແກ້ໄຂ';
$string['byfullname'] = 'ໂດຍ <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'ໂດຍ {$a}';
$string['calculategradinggrades'] = 'ຄິດໄລ່ຄະແນນການປະເມີນຜົນ';
$string['calculategradinggradesdetails'] = 'ໄດ້ຄາດຫວັງ: {$a->expected}<br />ໄດ້ຄິດໄລ່: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'ຄິດໄລ່ຄະແນນການສົ່ງ';
$string['calculatesubmissiongradesdetails'] = 'ໄດ້ຄາດຫວັງ: {$a->expected}<br />ໄດ້ຄິດໄລ່: {$a->calculated}';
$string['chooseuser'] = 'ເລືອກຜູ້ໃຊ້...';
$string['clearaggregatedgrades'] = 'ລຶບຄະແນນລວມທັງໝົດ';
$string['clearaggregatedgrades_help'] = 'ຄະແນນລວມສໍາລັບການສົ່ງ ແລະ ຄະແນນສໍາລັບການປະເມີນຈະຖືກຕັ້ງໃໝ່. ທ່ານສາມາດຄິດໄລ່ຄະແນນເຫຼົ່ານີ້ຄືນໃໝ່ໄດ້ຈາກຂັ້ນຕົ້ນໃນໄລຍະການປະເມີນຜົນການໃຫ້ຄະແນນອີກຄັ້ງ.';
$string['clearaggregatedgradesconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບຄະແນນທີ່ຄິດໄລ່ໄວ້ສຳລັບການສົ່ງ ແລະ ຄະແນນສຳລັບການປະເມີນຜົນ?';
$string['clearassessments'] = 'ລ້າງການປະເມີນຜົນ';
$string['clearassessments_help'] = 'ຄະແນນທີ່ຄຳນວນແລ້ວ ສຳລັບການສົ່ງ ແລະ ຄະແນນສຳລັບການປະເມີນຜົນຈະຖືກຕັ້ງຄືນໃໝ່. ຂໍ້ມູນວິທີການຕື່ມແບບຟອມການປະເມີນຜົນ ຍັງຄົງຖືກເກັບຮັກສາໄວ້, ແຕ່ຜູ້ກວດກາທັງໝົດຕ້ອງເປີດແບບຟອມການປະເມີນອີກຄັ້ງ ແລະ ບັນທຶກມັນຄືນໃໝ່ເພື່ອເອົາຄະແນນທີ່ໃຫ້ມາຄຳນວນອີກຄັ້ງ.';
$string['clearassessmentsconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບຄະແນນການປະເມີນຜົນທັງໝົດ? ທ່ານຈະບໍ່ສາມາດເອົາຂໍ້ມູນຄືນໄດ້ດ້ວຍຕົວຂອງທ່ານເອງ, ຜູ້ທົບທວນຈະຕ້ອງປະເມີນຜົນຄືນການສົ່ງທີ່ຈັດສັນ.';
$string['conclusion'] = 'ການຄິດໄລ່';
$string['conclusion_help'] = 'ຂໍ້ຄວາມສະຫຼຸບແມ່ນສະແດງໃຫ້ຜູ້ເຂົ້າຮ່ວມໃນຕອນທ້າຍຂອງກິດຈະກໍາ.';
$string['configexamplesmode'] = 'ຮູບແບບເລີ່ມຕົ້ນຂອງການປະເມີນຜົນຕົວຢ່າງໃນກອງປະຊຸມ';
$string['configgrade'] = 'ລະດັບສູງສຸດເລີ່ມຕົ້ນສໍາລັບການສົ່ງໃນກອງປະຊຸມ';
$string['configgradedecimals'] = 'ຕົວເລກເລີ່ມຕົ້ນຂອງຕົວເລກທີ່ຄວນຈະຖືກສະແດງຫຼັງຈາກຈຸດທົດສະນິຍົມໃນເວລາສະແດງຄະແນນ.';
$string['configgradinggrade'] = 'ຄະແນນສູງສຸດເລີ່ມຕົ້ນສໍາລັບການປະເມີນໃນກອງປະຊຸມ';
$string['configmaxbytes'] = 'ຂະໜາດໄຟລ໌ການສົ່ງສູງສຸດມາດຕະຖານສຳລັບກອງປະຊຸມທັງໝົດຢູ່ໃນເວັບໄຊທ໌ (ຂຶ້ນກັບຂອບເຂດຈຳກັດຫຼັກສູດ ແລະ ການຕັ້ງຄ່າທ້ອງຖິ່ນອື່ນໆ)';
$string['configstrategy'] = 'ຍຸດທະສາດການໃຫ້ຄະແນນເລີ່ມຕົ້ນສຳລັບກອງປະຊຸມ';
$string['createsubmission'] = 'ເພີ່ມການສົ່ງ';
$string['crontask'] = 'ການປະມວນຜົນພື້ນຫຼັງສຳລັບຊຸດກອງປະຊຸມ';
$string['daysago'] = '{$a} ມື້ຜ່ານມາ';
$string['daysleft'] = '{$a} ມື້ທີ່ຍັງເຫຼືອ';
$string['daystoday'] = 'ມື້ນີ້';
$string['daystomorrow'] = 'ມື້ອື່ນ';
$string['daysyesterday'] = 'ມື້ວານ';
$string['deadlinesignored'] = 'ການຈຳກັດເວລາບໍ່ໄດ້ຖືກນຳໃຊ້ກັບທ່ານ';
$string['deletesubmission'] = 'ລຶບການສົ່ງ';
$string['editassessmentform'] = 'ແກ້ໄຂແບບຟອມການປະເມີນຜົນ';
$string['editassessmentformstrategy'] = 'ແກ້ໄຂແບບຟອມການປະເມີນຜົນ ({$a})';
$string['editingassessmentform'] = 'ກຳລັງແກ້ໄຂແບບຟອມການປະເມີນຜົນ';
$string['editingsubmission'] = 'ກຳລັງແກ້ໄຂການສົ່ງ';
$string['editsubmission'] = 'ແກ້ໄຂການສົ່ງ';
$string['err_multiplesubmissions'] = 'ໃນຂະນະທີ່ແກ້ໄຂແບບຟອມນີ້, ສະບັບອື່ນຂອງການສົ່ງໄດ້ຖືກບັນທຶກໄວ້. ບໍ່ອະນຸຍາດໃຫ້ສົ່ງຫຼາຍຄັ້ງຕໍ່ໜຶ່ງຜູ້ໃຊ້.';
$string['err_removegrademappings'] = 'ບໍ່ສາມາດເອົາແຜນທີ່ຊັ້ນຮຽນທີ່ບໍ່ໄດ້ໃຊ້ອອກໄດ້';
$string['evaluategradeswait'] = 'ກະລຸນາລໍຖ້າຈົນກ່ວາການປະເມີນຜົນໄດ້ຮັບການປະເມີນ ແລະ ໄດ້ຖືກຄິດໄລ່ຄະແນນແລ້ວ';
$string['evaluation'] = 'ການປະເມີນການໃຫ້ຄະແນນ';
$string['evaluationmethod'] = 'ວິທີການປະເມີນການໃຫ້ຄະແນນ';
$string['evaluationmethod_help'] = 'ວິທີການປະເມີນການໃຫ້ຄະແນນຈະກໍານົດວິທີການຄິດໄລ່ຄະແນນສໍາລັບການປະເມີນຜົນ. ທ່ານສາມາດປ່ອຍໃຫ້ມັນຄິດໄລ່ຄະແນນໃໝ່ຊ້ຳຊ້ອນ ດ້ວຍການຕັ້ງຄ່າທີ່ແຕກຕ່າງກັນເວັ້ນເສຍແຕ່ວ່າທ່ານພໍໃຈກັບຜົນໄດ້ຮັບ.';
$string['evaluationsettings'] = 'ການຕັ້ງຄ່າການປະເມີນການໃຫ້ຄະແນນ';
$string['eventassessableuploaded'] = 'ອັບໂຫຼດການສົ່ງແລ້ວ.';
$string['eventassessmentevaluated'] = 'ປະເມີນການປະເມີນຜົນແລ້ວ';
$string['eventassessmentevaluationsreset'] = 'ຕັ້ງໃໝ່ການປະເມີນການປະເມີນຜົນ';
$string['eventassessmentreevaluated'] = 'ປະເມີນການປະເມີນຜົນຄືນໃໝ່';
$string['eventphaseautomaticallyswitched'] = 'ໄລຍະປ່ຽນອັດຕະໂນມັດ';
$string['eventphaseswitched'] = 'ສະລັບໄລຍະແລ້ວ';
$string['eventsubmissionassessed'] = 'ປະເມີນການສົ່ງ';
$string['eventsubmissionassessmentsreset'] = 'ລ້າງການປະເມີນຜົນການສົ່ງແລ້ວ';
$string['eventsubmissioncreated'] = 'ສ້າງການສົ່ງແລ້ວ';
$string['eventsubmissiondeleted'] = 'ລຶບການສົ່ງແລ້ວ';
$string['eventsubmissionreassessed'] = 'ປະເມີນການສົ່ງຄືນໃໝ່';
$string['eventsubmissionupdated'] = 'ປັບປຸງການສົ່ງແລ້ວ';
$string['eventsubmissionviewed'] = 'ເບິ່ງການສົ່ງແລ້ວ';
$string['example'] = 'ການສົ່ງຕົວຢ່າງ';
$string['exampleadd'] = 'ເພີ່ມການສົ່ງຕົວຢ່າງ';
$string['exampleassess'] = 'ປະເມີນຜົນການສົ່ງຕົວຢ່າງ';
$string['exampleassessments'] = 'ການສົ່ງຕົວຢ່າງເພື່ອປະເມີນ';
$string['exampleassesstask'] = 'ປະເມີນຜົນຕົວຢ່າງ';
$string['exampleassesstaskdetails'] = 'ໄດ້ຄາດໝາຍ: {$a->expected}<br />ໄດ້ປະເມີນຜົນ: {$a->assessed}';
$string['examplecomparing'] = 'ກຳລັງສົມທຽບການປະເມີນຜົນຂອງການສົ່ງຕົວຢ່າງ';
$string['exampledelete'] = 'ລຶບຕົວຢ່າງ';
$string['exampledeleteconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບການສົ່ງຕົວຢ່າງຕໍ່ໄປນີ້? ຄລິກປຸ່ມ \'ສືບຕໍ່\' ເພື່ອລຶບການສົ່ງ.';
$string['exampleedit'] = 'ແກ້ໄຂຕົວຢ່າງ';
$string['exampleediting'] = 'ກຳລັງແກ້ໄຂຕົວຢ່າງ';
$string['exampleneedassessed'] = 'ທ່ານຕ້ອງປະເມີນການສົ່ງຕົວຢ່າງທັງໝົດກ່ອນ';
$string['exampleneedsubmission'] = 'ທ່ານຕ້ອງສົ່ງວຽກຂອງທ່ານ ແລະ ປະເມີນການສົ່ງຕົວຢ່າງທັງໝົດກ່ອນ';
$string['examplesbeforeassessment'] = 'ຕົວຢ່າງແມ່ນມີຢູ່ຫຼັງຈາກການສົ່ງຂອງຕົນເອງ ແລະ ຕ້ອງໄດ້ຮັບການປະເມີນຜົນກ່ອນທີ່ຈະປະເມີນເພື່ອນມິດ';
$string['examplesbeforesubmission'] = 'ຕົວຢ່າງຕ້ອງໄດ້ຮັບການປະເມີນຜົນກ່ອນທີ່ຈະຍື່ນສະເໜີຂອງຕົນເອງ';
$string['examplesmode'] = 'ໂໝດຂອງການສົ່ງຕົວຢ່າງ';
$string['examplesubmissions'] = 'ການສົ່ງຕົວຢ່າງ';
$string['examplesvoluntary'] = 'ການປະເມີນຜົນການສົ່ງຕົວຢ່າງແມ່ນມີຄວາມສະໝັກໃຈ';
$string['exportsubmission'] = 'ສົ່ງອອກໜ້ານີ້';
$string['feedbackauthor'] = 'ຄຳຕິຊົມສຳລັບຜູ້ຂຽນ';
$string['feedbackauthorattachment'] = 'ເອກະສານຊ້ອນທ້າຍ';
$string['feedbackby'] = 'ຄຳຕິຊົມໂດຍ {$a}';
$string['feedbackreviewer'] = 'ຄຳຕິຊົມສຳລັບຜູ້ທົບທວນຄືນ';
$string['feedbacksettings'] = 'ຄຳຕິຊົມ';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'ຄະແນນທີ່ໄດ້ໃຫ້';
$string['grade_grading_name'] = 'ການປະເມີນຜົນ';
$string['grade_submission_name'] = 'ການສົ່ງ';
$string['gradecalculated'] = 'ຄະແນນທີ່ຄິດໄລ່ສຳລັບການສົ່ງ';
$string['gradedecimals'] = 'ຈຸດທົດສະນິຍົມໃນຄະແນນ';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'ຄະແນນ: {$a->received} ຂອງ {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (ການປະເມີນຜົນ)';
$string['gradeitemsubmission'] = '{$a->workshopname} (ການສົ່ງ)';
$string['gradeover'] = 'ລົບລ້າງຄະແນນການສົ່ງ';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'ລາຍງານຄະແນນກອງປະຊຸມ';
$string['gradetopassgrading'] = 'ຄະແນນການປະເມີນຜົນເພື່ອຜ່ານ';
$string['gradetopasssubmission'] = 'ຄະແນນການສົ່ງເພື່ອຜ່ານ';
$string['gradinggrade'] = 'ຄະແນນສຳລັບການປະເມີນຜົນ';
$string['gradinggrade_help'] = 'ການຕັ້ງຄ່ານີ້ລະບຸລະດັບສູງສຸດທີ່ອາດຈະໄດ້ຮັບສໍາລັບການປະເມີນຜົນການສົ່ງ.';
$string['gradinggradecalculated'] = 'ຄະແນນທີ່ໄດ້ຄິດໄລ່ສຳລັບການປະເມີນຜົນ';
$string['gradinggradeof'] = 'ຄະແນນສຳລັບການປະເມີນຜົນ (ຂອງ {$a})';
$string['gradinggradeover'] = 'ລົບລ້າງຄະແນນສຳລັບການປະເມີນຜົນ';
$string['gradingsettings'] = 'ການຕັ້ງຄ່າການໃຫ້ຄະແນນ';
$string['groupnoallowed'] = 'ທ່ານຍັງບໍ່ໄດ້ອະນຸຍາດໃຫ້ເຂົ້າເຖິງກຸ່ມໃດໆໃນກອງປະຊຸມນີ້';
$string['iamsure'] = 'ແມ່ນແລ້ວ, ຂ້ອຍແນ່ໃຈ';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ກອງປະຊຸມ';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເລິກຂອງສະຕິປັນຍາບັນລຸໄດ້ໂດຍນັກຮຽນໃນກິດຈະກໍາກອງປະຊຸມ.';
$string['indicator:cognitivedepthdef'] = 'ຄວາມຮູ້ກອງປະຊຸມ';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ຂອງການມີສ່ວນພົວພັນທາງດ້ານສະຕິປັນຍາທີ່ສະໜອງໃຫ້ໂດຍກິດຈະກໍາກອງປະຊຸມໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເບິ່ງ, ເບິ່ງ, ສົ່ງ, ເບິ່ງຄໍາຕິຊົມ, ຄໍາເຫັນກ່ຽວກັບຄໍາຕິຊົມ, ສົ່ງຄືນໃໝ່ຫຼັງຈາກເບິ່ງຄໍາຕິຊົມ)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'ສັງຄົມກອງປະຊຸມ';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມກວ້າງຂອງສັງຄົມທີ່ນັກສຶກສາບັນລຸໄດ້ໃນກິດຈະກໍາກອງປະຊຸມ.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມກອງປະຊຸມ';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເໜີໂດຍກິດຈະກໍາກອງປະຊຸມໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມຢ່າງດຽວ, ຜູ້ເຂົ້າຮ່ວມກັບຜູ້ອື່ນ)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'ຂໍ້ມູນ';
$string['instructauthors'] = 'ຄຳແນະນຳສຳລັບການສົ່ງ';
$string['instructreviewers'] = 'ຄຳແນະນຳສຳລັບການປະເມີນຜົນ';
$string['introduction'] = 'ຄຳອະທິບາຍ';
$string['latesubmissions'] = 'ການສົ່ງຊັກຊ້າ';
$string['latesubmissions_desc'] = 'ອະນຸຍາດການສົ່ງຫຼັງຈາກເສັ້ນຕາຍ';
$string['latesubmissions_help'] = 'ຖ້າເປີດໃຊ້, ຜູ້ຂຽນອາດຈະສົ່ງວຽກງານຂອງເຂົາເຈົ້າຫຼັງຈາກກໍານົດເວລາການສົ່ງ ຫຼື ໃນໄລຍະການປະເມີນຜົນ. ການຍື່ນສະເໜີຊ້າແມ່ນບໍ່ສາມາດແກ້ໄຂໄດ້.';
$string['latesubmissionsallowed'] = 'ອະນຸຍາດການສົ່ງຊັກຊ້າແລ້ວ';
$string['legacyallocationplugincron'] = 'ການຈັດສັນກອງປະຊຸມ cron ເກົ່າ';
$string['maxbytes'] = 'ຂະໜາດເອກະສານຊ້ອນທ້າຍສູງສຸດ';
$string['modulename'] = 'ກອງປະຊຸມ';
$string['modulename_help'] = 'ຊຸດກິດຈະກໍາຂອງກອງປະຊຸມເຮັດໃຫ້ສາມາດເກັບກໍາ, ການທົບທວນຄືນ ແລະ ການປະເມີນຜົນການເຮັດວຽກຂອງນັກຮຽນ.

ນັກຮຽນສາມາດສົ່ງເນື້ອຫາດິຈິຕອລ (ໄຟລ໌ຕ່າງໆ), ເຊັ່ນ: ເອກະສານທີ່ປຸງແຕ່ງດ້ວຍຄໍາ ຫຼື ສະເປຣດຊີດ ແລະ ຍັງສາມາດພິມຂໍ້ຄວາມໂດຍກົງໃສ່ຊ່ອງຂໍ້ມູນໂດຍໃຊ້ຕົວແກ້ໄຂຂໍ້ຄວາມ.

ການຍື່ນສະເໜີແມ່ນຖືກປະເມີນໂດຍໃຊ້ແບບຟອມການປະເມີນຫຼາຍເງື່ອນໄຂທີ່ຄູສອນກໍານົດ. ຂັ້ນຕອນການປະເມີນເພື່ອນຮ່ວມງານ ແລະ ເຂົ້າໃຈແບບຟອມການປະເມີນຜົນ ສາມາດປະຕິບັດໄດ້ລ່ວງໜ້າ ດ້ວຍການສະເໜີຕົວຢ່າງທີ່ຄູສອນສະເໜີໃຫ້, ພ້ອມກັບການປະເມີນຜົນເອກະສານອ້າງອີງ. ນັກສຶກສາໄດ້ຮັບໂອກາດໃນການປະເມີນຜົນໜຶ່ງ ຫຼື ຫຼາຍຂອງການສົ່ງຂອງເພື່ອນຂອງເຂົາເຈົ້າ. ການສົ່ງ ແລະ ຜູ້ທົບທວນອາດຈະບໍ່ເປີດເຜີຍຊື່ຖ້າຈໍາເປັນ.

ນັກຮຽນໄດ້ຮັບສອງຄະແນນໃນກິດຈະກໍາກອງປະຊຸມ - ຄະແນນສໍາລັບການສົ່ງຂອງເຂົາເຈົ້າ ແລະ ຄະແນນສໍາລັບການປະເມີນຜົນການສົ່ງຂອງເພື່ອນຂອງເຂົາເຈົ້າ. ທັງສອງຄະແນນແມ່ນບັນທຶກໄວ້ໃນປຶ້ມຄະແນນ.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'ກອງປະຊຸມ';
$string['myassessments'] = 'ການປະເມີນຜົນຂອງຂ້ອຍ';
$string['mysubmission'] = 'ການສົ່ງຂອງຂ້ອຍ';
$string['nattachments'] = 'ຈຳນວນສູງສຸດຂອງເອກະສານຊ້ອນທ້າຍການສົ່ງ';
$string['noexamples'] = 'ບໍ່ມີຕົວຢ່າງໃນກອງປະຊຸມນີ້ເທື່ອ';
$string['noexamplesformready'] = 'ທ່ານຕ້ອງກໍານົດແບບຟອມການປະເມີນຜົນກ່ອນທີ່ຈະສະຫນອງການສົ່ງຕົວຢ່າງ';
$string['nogradeyet'] = 'ບໍ່ມີຄະແນນເທື່ອ';
$string['nosubmissionfound'] = 'ບໍ່ພົບການສົ່ງສຳລັບຜູ້ໃຊ້ນິ້';
$string['nosubmissions'] = 'ບໍ່ພົບການສົ່ງເທື່ອໃນກອງປະຊຸມນີ້';
$string['nosubmissiontype'] = 'ຕ້ອງມີຢ່າງໜ້ອຍໜຶ່ງປະເພດການສົ່ງ';
$string['notassessed'] = 'ບໍ່ໄດ້ປະເມີນຜົນເທື່ອ';
$string['nothingfound'] = 'ບໍ່ມີຫຍັງສະແດງ';
$string['nothingtoreview'] = 'ບໍ່ມີຫຍັງໃຫ້ທົບທວນຄືນ';
$string['notoverridden'] = 'ບໍ່ຖືກແທນທີ່';
$string['noworkshops'] = 'ບໍ່ມີກອງປະຊຸມໃນລາຍວິຊານີ້';
$string['noyoursubmission'] = 'ທ່ານບໍ່ໄດ້ສົ່ງວຽກຂອງທ່ານເທື່ອ';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'ພາບລວມຄຳຕິຊົມ';
$string['overallfeedbackfiles'] = 'ຈຳນວນສູງສຸດຂອງໄຟລ໌ແນບຄຳຕິຊົມໂດຍລວມ';
$string['overallfeedbackmaxbytes'] = 'ຂະໜາດໄຟລ໌ແນບຄຳຕິຊົມໂດຍລວມສູງສຸດ';
$string['overallfeedbackmode'] = 'ພາບລວມໂໝດຄຳຕິຊົມ';
$string['overallfeedbackmode_0'] = 'ປິດໃຊ້ງານ';
$string['overallfeedbackmode_1'] = 'ເປີດໃຊ້ງານ ແລະ ທາງເລືອກ';
$string['overallfeedbackmode_2'] = 'ເປີດໃຊ້ງານ ແລະ ຕ້ອງການ';
$string['overallfeedbackmode_help'] = 'ຖ້າເປີດໃຊ້, ຊ່ອງຂໍ້ຄວາມຈະສະແດງຢູ່ດ້ານລຸ່ມຂອງແບບຟອມການປະເມີນຜົນ. ຜູ້ທົບທວນສາມາດເອົາການປະເມີນຜົນໂດຍລວມຂອງການສົ່ງຢູ່ທີ່ນັ້ນ, ຫຼື ໃຫ້ຄໍາອະທິບາຍເພີ່ມເຕີມຂອງການປະເມີນຂອງພວກເຂົາ.';
$string['page-mod-workshop-x'] = 'ໜ້າຊຸດກອງປະຊຸມໃດໜຶ່ງ';
$string['participant'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['participantrevierof'] = 'ຜູ້ເຂົ້າຮ່ວມແມ່ນຜູ້ທົບທວນຂອງ';
$string['participantreviewedby'] = 'ຜູ້ເຂົ້າຮ່ວມແມ່ນຜູ້ທົບທວນໂດຍ';
$string['phaseassessment'] = 'ໄລຍະການປະເມີນຜົນ';
$string['phaseclosed'] = 'ປິດແລ້ວ';
$string['phaseevaluation'] = 'ການໃຫ້ຄະແນນໄລຍະການປະເມີນຜົນ';
$string['phasesetup'] = 'ໄລຍະການຕັ້ງຄ່າ';
$string['phasesoverlap'] = 'ໄລຍະການສົ່ງ ແລະ ໄລຍະການປະເມີນຜົນບໍ່ສາມາດທັບຊ້ອນກັນໄດ້';
$string['phasesubmission'] = 'ໄລຍະການສົ່ງ';
$string['pluginadministration'] = 'ການບໍລິຫານກອງປະຊຸມ';
$string['pluginname'] = 'ກອງປະຊຸມ';
$string['prepareexamples'] = 'ກະກຽມການສົ່ງຕົວຢ່າງ';
$string['previewassessmentform'] = 'ເບິ່ງຕົວຢ່າງ';
$string['privacy:metadata:aggregatedgradinggrade'] = 'ຄະແນນລວມສໍາລັບການປະເມີນທັງໝົດທີ່ເຮັດໂດຍຜູ້ໃຊ້ໃນກິດຈະກໍາກອງປະຊຸມທີ່ໃຫ້';
$string['privacy:metadata:assessmentgrade'] = 'ຄະແນນລວມສໍາລັບການສົ່ງທີ່ແນະນໍາໂດຍການປະເມີນນີ້';
$string['privacy:metadata:assessmentgradinggrade'] = 'ຄະແນນສໍາລັບການສະໜອງການປະເມີນຜົນນີ້';
$string['privacy:metadata:assessmentgradinggradeover'] = 'ລົບລ້າງດ້ວຍຕົນເອງມູນຄ່າຂອງຄະແນນສໍາລັບການສະໜອງການປະເມີນຜົນນີ້';
$string['privacy:metadata:assessmentid'] = 'ລະຫັດປະຈຳຕົວການປະເມີນຜົນ';
$string['privacy:metadata:authorid'] = 'ລະຫັດປະຈຳຕົວການປະເມີນຜົນຜູ້ຂຽນ';
$string['privacy:metadata:dimensiongrade'] = 'ຄະແນນຂອງຂະໜາດການປະເມີນຜົນທີ່ໄດ້ໃຫ້';
$string['privacy:metadata:dimensionid'] = 'ລະຫັດປະຈຳຕົວຂອງຂະໜາດການປະເມີນຜົນ';
$string['privacy:metadata:example'] = 'ບັນທຶກນີ້ສະແດງເຖິງການສົ່ງຕົວຢ່າງຫຼືບໍ່';
$string['privacy:metadata:feedbackauthor'] = 'ຄຳຕິຊົມສຳລັບຜູ້ຂຽນ';
$string['privacy:metadata:feedbackauthorformat'] = 'ຮູບແບບຂໍ້ຄວາມຂອງຄໍາຕິຊົມສໍາລັບຜູ້ຂຽນ';
$string['privacy:metadata:feedbackreviewer'] = 'ຄວາມຄິດເຫັນສໍາລັບຜູ້ໃຊ້ສະໜອງການປະເມີນຜົນ';
$string['privacy:metadata:feedbackreviewerformat'] = 'ຮູບແບບຂໍ້ຄວາມຂອງຄໍາຕິຊົມສໍາລັບຜູ້ໃຊ້ສະໜອງການປະເມີນຜົນ';
$string['privacy:metadata:late'] = 'ບໍ່ວ່າຈະເປັນການສົ່ງຫຼັງຈາກກຳນົດເວລາ';
$string['privacy:metadata:peercomment'] = 'ຄໍາເຫັນກ່ຽວກັບຄະແນນທີ່ໃຫ້ໂດຍຜູ້ໃຊ້ສະໜອງການປະເມີນຜົນ';
$string['privacy:metadata:peercommentformat'] = 'ຮູບແບບຂໍ້ຄວາມຂອງຄໍາເຫັນກ່ຽວກັບຄະແນນທີ່ໃຫ້';
$string['privacy:metadata:preference:perpage'] = 'ຈໍານວນການສົ່ງທີ່ຜູ້ໃຊ້ທີ່ມັກເບິ່ງໃນໜຶ່ງໜ້າ';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ຕົວຢ່າງການສົ່ງ\'.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ກອງປະຊຸມລາຍງານການສົ່ງ\'.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ແບບຟອມການປະເມີນຜົນ\'.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ການສົ່ງທີ່ມອບໝາຍເພື່ອປະເມີນຜົນ\'.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ກອງປະຊຸມກ່ອງເຄື່ອງມື\'.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ການສະຫຼຸບ\'.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ຕົວຢ່າງການສົ່ງ\'.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ຕົວຢ່າງການສົ່ງເພື່ອປະເມີນຜົນ\'.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ກອງປະຊຸມລາຍງານຄະແນນ\'.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ການແນະນຳສຳລັບການສົ່ງ\'.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ຄຳແນະນຳສຳລັບການປະເມີນຜົນ\'.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ການແນະນຳ\'.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ພາບລວມຄຳຕິຊົມ\'.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ການສົ່ງຂອງທ່ານ\'.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'ສະຖານະທີ່ຍຸບລົງ/ຂະຫຍາຍອອກສຳລັບມຸມມອງ \'ການສົ່ງທີ່ເຜີຍແຜ່ແລ້ວ\'.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'ສະຖານະຍຸບລົງ/ຂະຫຍາຍສຳລັບມຸມມອງ \'ຄະແນນຂອງທ່ານ\'.';
$string['privacy:metadata:published'] = 'ບໍ່ວ່າຈະເປັນການສົ່ງຕໍ່ຜູ້ເຂົ້າຮ່ວມທັງໝົດເມື່ອກອງປະຊຸມປິດລົງ';
$string['privacy:metadata:reviewerid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ສະໜອງການປະເມີນຜົນ';
$string['privacy:metadata:strategy'] = 'ຊື່ຂອງປລັກອິນຍ່ອຍຍຸດທະສາດການໃຫ້ຄະແນນການຕີຄວາມໝາຍຂອງຄ່າບັນທຶກ';
$string['privacy:metadata:submissioncontent'] = 'ເນື້ອຫາຂອງການສົ່ງ';
$string['privacy:metadata:submissioncontentformat'] = 'ຮູບແບບຂໍ້ຄວາມເນື້ອຫາການສົ່ງ';
$string['privacy:metadata:submissiongrade'] = 'ຄະແນນລວມສໍາລັບການສົ່ງທີ່ຂຽນເປັນຕົວເລກທົດສະນິຍົມຈາກໄລຍະຫ່າງ 0..100';
$string['privacy:metadata:submissiongradeover'] = 'ການລົບລ້າງຄ່າດ້ວຍຕົນເອງຂອງຄະແນນລວມ';
$string['privacy:metadata:submissionid'] = 'ລະຫັດປະຈຳຕົວການສົ່ງ';
$string['privacy:metadata:submissiontitle'] = 'ຫົວຂໍ້ຂອງການສົ່ງ';
$string['privacy:metadata:subsystem:corefiles'] = 'ຊຸດກອງປະຊຸມເກັບຮັກສາໄຟລ໌ທີ່ຝັງຢູ່ໃນ / ຕິດກັບຂໍ້ຄວາມທີ່ຍື່ນສະເໜີ';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'ຊຸດກອງປະຊຸມມີການສະຫນັບສະຫນູນທີ່ຕິດຕັ້ງມາພ້ອມສໍາລັບລະບົບປ້ອງກັນການລັກລອບ';
$string['privacy:metadata:timeaggregated'] = 'ເມື່ອຄະແນນລວມໄດ້ຖືກຄິດໄລ່ສຸດທ້າຍ';
$string['privacy:metadata:timecreated'] = 'ເມື່ອບັນທຶກນີ້ຖືກສ້າງຂຶ້ນໃນຖານຂໍ້ມູນ';
$string['privacy:metadata:timemodified'] = 'ເມື່ອບັນທຶກນີ້ຖືກແກ້ໄຂຄັ້ງສຸດທ້າຍໃນຖານຂໍ້ມູນ';
$string['privacy:metadata:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ຄິດໄລ່ຄະແນນລວມ';
$string['privacy:metadata:weight'] = 'ນ້ຳໜັກຂອງການປະເມີນຜົນ';
$string['privacy:metadata:workshopaggregations'] = 'ຖືຄະແນນລວມສໍາລັບການປະເມີນຜົນ';
$string['privacy:metadata:workshopassessments'] = 'ຖືຂໍ້ມູນກ່ຽວກັບການຈັດສັນການປະເມີນຜົນການສົ່ງຊຸດກອງປະຊຸມ';
$string['privacy:metadata:workshopgrades'] = 'ຖືຂໍ້ມູນກ່ຽວກັບວິທີທີ່ແບບຟອມການປະເມີນຜົນເຕັມໄປດ້ວຍຄະແນນ ແລະ ຄໍາເຫັນ';
$string['privacy:metadata:workshopid'] = 'ລະຫັດປະຈຳຕົວຂອງກິດຈະກຳກອງປະຊຸມ';
$string['privacy:metadata:workshopsubmissions'] = 'ຖືຂໍ້ມູນກ່ຽວກັບການສົ່ງຊຸດກອງປະຊຸມ';
$string['privacy:request:delete:content'] = 'ເນື້ອຫາດັ່ງກ່າວໄດ້ຖືກລຶບໄປແລ້ວ (ຮ້ອງຂໍໂດຍຜູ້ໃຊ້ ຫຼື ໝົດອາຍຸ)';
$string['privacy:request:delete:title'] = '[ລຶບແລ້ວ]';
$string['publishedsubmissions'] = 'ເຜີຍແຜ່ການສົ່ງແລ້ວ';
$string['publishsubmission'] = 'ເຜີຍແຜ່ການສົ່ງ';
$string['publishsubmission_help'] = 'ການສົ່ງທີ່ເຜີຍແຜ່ ແມ່ນມີໃຫ້ກັບຜູ້ອື່ນເມື່ອກອງປະຊຸມປິດ.';
$string['reassess'] = 'ການປະເມີນຄືນ';
$string['receivedgrades'] = 'ໄດ້ຮັບຄະແນນແລ້ວ';
$string['recentassessments'] = 'ການປະເມີນຜົນກອງປະຊຸມ:';
$string['recentsubmissions'] = 'ການສົ່ງກອງປະຊຸມ:';
$string['resetassessments'] = 'ລຶບການປະເມີນຜົນທັງໝົດ';
$string['resetassessments_help'] = 'ທ່ານສາມາດເລືອກທີ່ຈະລົບພຽງແຕ່ການປະເມີນຜົນການຈັດສັນ ໂດຍບໍ່ມີຜົນກະທົບການສົ່ງ. ຖ້າການສົ່ງຈະຖືກລຶບ, ການປະເມີນຂອງພວກມັນຈະຖືກລຶບຢ່າງຈະແຈ້ງ ແລະ ທາງເລືອກນີ້ຈະຖືກລະເລີຍ. ໃຫ້ສັງເກດວ່າ ສິ່ງນີ້ຍັງປະກອບມີການປະເມີນການຜົນການສົ່ງຕົວຢ່າງ.';
$string['resetphase'] = 'ສະລັບໄປຫາໄລຍະການຕັ້ງຄ່າ';
$string['resetphase_help'] = 'ຖ້າເປີດໃຊ້ງານ, ກອງປະຊຸມທັງໝົດຈະຖືກວາງໃສ່ໃນໄລຍະການຕັ້ງຄ່າເບື້ອງຕົ້ນ.';
$string['resetsubmissions'] = 'ລຶບການສົ່ງທັງໝົດ';
$string['resetsubmissions_help'] = 'ການສົ່ງທັງໝົດ ແລະ ການປະເມີນຜົນຂອງພວກເຂົາຈະຖືກລຶບຖິ້ມ. ສິ່ງນີ້ບໍ່ມີຜົນກະທົບຕໍ່ການສົ່ງຕົວຢ່າງ.';
$string['saveandclose'] = 'ບັນທຶກ ແລະ ປິດ';
$string['saveandcontinue'] = 'ບັນທຶກ ແລະ ສືບຕໍ່ການແກ້ໄຂ';
$string['saveandpreview'] = 'ບັນທຶກ ແລະ ເບິ່ງຕົວຢ່າງ';
$string['saveandshownext'] = 'ບັນທຶກ ແລະ ສະແດງຕໍ່ໄປ';
$string['search:activity'] = 'ກອງປະຊຸມ - ຂໍ້ມູນກິດຈະກຳ';
$string['selfassessmentdisabled'] = 'ປິດໃຊ້ງານການປະເມີນຜົນ';
$string['showingperpage'] = 'ກຳລັງສະແດງລາຍການ {$a} ຕໍ່ໜ້າ';
$string['showingperpagechange'] = 'ປ່ຽນແປງ ...';
$string['someuserswosubmission'] = 'ມີຜູ້ຂຽນຢ່າງໜ້ອຍໜຶ່ງຄົນທີ່ຍັງບໍ່ທັນໄດ້ສົ່ງຜົນງານຂອງເຂົາເຈົ້າ';
$string['sortasc'] = 'ລຽງແຕ່ໃຫຍ່ຫານ້ອຍ';
$string['sortdesc'] = 'ລຽງແຕ່ນ້ອຍຫາໃຫຍ່';
$string['strategy'] = 'ກົນລະຍຸດການໃຫ້ຄະແນນ';
$string['strategy_help'] = 'ຍຸດທະສາດການໃຫ້ຄະແນນກໍານົດແບບຟອມການປະເມີນທີ່ໃຊ້ ແລະ ວິທີການໃຫ້ຄະແນນການຍື່ນສະເຫນີ. ມີ 4 ທາງເລືອກ:

* ການໃຫ້ຄະແນນສະສົມ - ຄຳເຫັນ ແລະ ຄະແນນແມ່ນໃຫ້ກ່ຽວກັບລັກສະນະທີ່ລະບຸໄວ້
* ຄໍາເຫັນ - ຄໍາເຫັນແມ່ນໄດ້ຮັບກ່ຽວກັບລັກສະນະທີ່ກໍານົດໄວ້ ແຕ່ບໍ່ມີຄະແນນທີ່ສາມາດໃຫ້ໄດ້
* ຈໍານວນຂອງຄວາມຜິດພາດ - ຄໍາເຫັນ ແລະ ການປະເມີນຜົນແມ່ນ / ບໍ່ແມ່ນໄດ້ຮັບກ່ຽວກັບການຢືນຢັນທີ່ລະບຸໄວ້
* ລູບິກ (Rubric) - ການປະເມີນຜົນຄະແນນແມ່ນໃຫ້ກ່ຽວກັບເງື່ອນໄຂທີ່ລະບຸ';
$string['strategyhaschanged'] = 'ຍຸດທະສາດການໃຫ້ຄະແນນຂອງກອງປະຊຸມ ໄດ້ມີການປ່ຽນແປງນັບຕັ້ງແຕ່ແບບຟອມໄດ້ຖືກເປີດໃຫ້ດັດແກ້.';
$string['submission'] = 'ການສົ່ງ';
$string['submissionattachment'] = 'ເອກະສານຊ້ອນທ້າຍ';
$string['submissionby'] = 'ການສົ່ງໂດຍ {$a}';
$string['submissioncontent'] = 'ເນື້ອຫາການສົ່ງ';
$string['submissiondeleteconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບການສົ່ງຕໍ່ໄປນີ້?';
$string['submissiondeleteconfirmassess'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບການສົ່ງຕໍ່ໄປນີ້? ກະລຸນາຮັບຊາບວ່າ ສິ່ງນີ້ຈະລຶບການປະເມີນ {$a->count} ທີ່ກ່ຽວຂ້ອງກັບການສົ່ງນີ້, ເຊິ່ງອາດຈະສົ່ງຜົນກະທົບຕໍ່ຄະແນນຂອງຜູ້ກວດສອບ.';
$string['submissionend'] = 'ກຳນົດເວລາການສົ່ງ';
$string['submissionendbeforestart'] = 'ກໍານົດເວລາການສົ່ງ ແມ່ນບໍ່ສາມາດກໍານົດກ່ອນວັນເປີດສໍາລັບການສົ່ງ';
$string['submissionenddatetime'] = 'ກຳນົດເວລາການສົ່ງ: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} ກຳນົດເວລາການສົ່ງ';
$string['submissionendswitch'] = 'ປ່ຽນໄປໄລຍະຕໍ່ໄປຫຼັງຈາກເວລາກຳການສົ່ງ';
$string['submissionendswitch_help'] = 'ຖ້າກໍານົດເວລາການສົ່ງ ແລະ ກ່ອງນີ້ຖືກເລືອກ, ກອງປະຊຸມຈະປ່ຽນໄປເປັນໄລຍະການປະເມີນອັດຕະໂນມັດຫຼັງຈາກກໍານົດເວລາການສົ່ງ.

ຖ້າທ່ານເປີດໃຊ້ຄຸນສົມບັດນີ້, ມັນແນະນໍາໃຫ້ຕັ້ງຄ່າວິທີການຈັດສັນທີ່ກໍານົດເວລາ, ເຊັ່ນກັນ. ຖ້າການສົ່ງບໍ່ໄດ້ຖືກຈັດສັນ, ບໍ່ມີການປະເມີນຜົນສາມາດເຮັດໄດ້ ເຖິງແມ່ນວ່າກອງປະຊຸມຕົວເອງຈະຢູ່ໃນໄລະນການປະເມີນຜົນ.';
$string['submissiongrade'] = 'ຄະແນນສຳລັບການສົ່ງ';
$string['submissiongrade_help'] = 'ການຕັ້ງຄ່ານີ້ລະບຸຄະແນນສູງສຸດທີ່ອາດຈະໄດ້ຮັບສໍາລັບວຽກທີ່ສົ່ງມາ.';
$string['submissiongradeof'] = 'ຄະແນນສຳລັບການສົ່ງ';
$string['submissionlastmodified'] = 'ດັດແປງຫຼ້າສຸດ';
$string['submissionrequiredcontent'] = 'ທ່ານຈໍາເປັນຕ້ອງໃສ່ບາງຂໍ້ຄວາມ ຫຼື ເພີ່ມໄຟລ໌.';
$string['submissionrequiredfile'] = 'ທ່ານຈໍາເປັນຕ້ອງເພີ່ມໄຟລ໌ ຫຼື ໃສ່ບາງຂໍ້ຄວາມ.';
$string['submissionsallocation'] = 'ການຈັດສັນການສົ່ງ';
$string['submissionsettings'] = 'ການຕັ້ງຄ່າການສົ່ງ';
$string['submissionsreport'] = 'ກອງປະຊຸມລາຍງານການສົ່ງ';
$string['submissionstart'] = 'ເປີດສຳລັບການສົ່ງຈາກ';
$string['submissionstartdatetime'] = 'ເປີດສຳລັບການສົ່ງຈາກ {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} ເປີດສຳລັບການສົ່ງຈາກ';
$string['submissiontitle'] = 'ຫົວຂໍ້';
$string['submissiontypedisabled'] = 'ປະເພດການສົ່ງນີ້ແມ່ນຖືກປິດໄວ້ສໍາລັບກອງປະຊຸມນີ້.';
$string['submissiontypefileavailable'] = 'ເອກະສານຊ້ອນທ້າຍ<span class="accesshide"> ທີ່ມີໃຫ້</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">ເອກະສານຊ້ອນທ້າຍ </span>ທີ່ຕ້ອງການ';
$string['submissiontypes'] = 'ປະເພດການສົ່ງ';
$string['submissiontypetextavailable'] = 'ຂໍ້ຄວາມອອນລາຍ<span class="accesshide"> ມີໃຫ້</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">ຂໍ້ຄວາມອອນລາຍ </span>ທີ່ຕ້ອງການ';
$string['submittednotsubmitted'] = 'ສົ່ງແລ້ວ ({$a->submitted}) / ບໍ່ໄດ້ສົ່ງ ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'ວິທີການຈັດສັນການສົ່ງ';
$string['subplugintype_workshopallocation_plural'] = 'ວິທີການຈັດສັນການສົ່ງ';
$string['subplugintype_workshopeval'] = 'ວິທີການປະເມີນຜົນການໃຫ້ຄະແນນ';
$string['subplugintype_workshopeval_plural'] = 'ວິທີການປະເມີນຜົນການໃຫ້ຄະແນນ';
$string['subplugintype_workshopform'] = 'ກົນລະຍຸດການໃຫ້ຄະແນນ';
$string['subplugintype_workshopform_plural'] = 'ກົນລະຍຸດການໃຫ້ຄະແນນ';
$string['switchingphase'] = 'ກຳລັງສະລັບໄລຍະ';
$string['switchphase'] = 'ໄລຍະສະລັບ';
$string['switchphase10'] = 'ສະລັບໄປຫາໄລຍະການຕັ້ງຄ່າ';
$string['switchphase10info'] = 'ທ່ານກຳລັງຈະປ່ຽນກອງປະຊຸມໄປເປັນ <strong>ໄລຍະການຕິດຕັ້ງ</strong>. ໃນໄລຍະນີ້, ຜູ້ໃຊ້ບໍ່ສາມາດດັດແປງການຍື່ນສະເຫນີຫຼືການປະເມີນຂອງເຂົາເຈົ້າ. ຄູອາດຈະໃຊ້ໄລຍະນີ້ເພື່ອປ່ຽນການຕັ້ງຄ່າກອງປະຊຸມ, ແກ້ໄຂຍຸດທະສາດການໃຫ້ຄະແນນ ຫຼື ປັບຮູບແບບການປະເມີນຜົນ.';
$string['switchphase20'] = 'ສະລັບໄປຫາໄລຍະການສົ່ງ';
$string['switchphase20info'] = 'ທ່ານກຳລັງຈະປ່ຽນກອງປະຊຸມໄປເປັນ <strong>ໄລຍະການສົ່ງ</strong>. ນັກສຶກສາອາດຈະສົ່ງວຽກງານຂອງເຂົາເຈົ້າໃນໄລຍະນີ້ (ພາຍໃນວັນທີການຄວບຄຸມການເຂົ້າເຖິງການສົ່ງ, ຖ້າກໍານົດ). ຄູອາຈານອາດຈະຈັດສັນການສົ່ງສໍາລັບການທົບທວນເພື່ອນຮ່ວມງານ.';
$string['switchphase30'] = 'ສະລັບໄປຫາໄລຍະການປະເມີນຜົນ';
$string['switchphase30auto'] = 'ກອງປະຊຸມຈະປ່ຽນໄປສູ່ໄລຍະການປະເມີນຜົນໂດຍອັດຕະໂນມັດຫຼັງຈາກ {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'ທ່ານກຳລັງຈະປ່ຽນກອງປະຊຸມໄປສູ່ <strong>ໄລຍະການປະເມີນຜົນ</strong>. ໃນໄລຍະນີ້, ຜູ້ທົບທວນອາດຈະປະເມີນການສົ່ງທີ່ເຂົາເຈົ້າໄດ້ຖືກຈັດສັນ (ພາຍໃນວັນທີຄວບຄຸມການເຂົ້າເຖິງການປະເມີນຜົນ, ຖ້າກໍານົດ).';
$string['switchphase40'] = 'ສະລັບໄປຫາໄລຍະການປະເມີນ';
$string['switchphase40info'] = 'ທ່ານກຳລັງຈະປ່ຽນກອງປະຊຸມໄປເປັນ <strong>ໄລຍະການປະເມີນຄະແນນ</strong>. ໃນໄລຍະນີ້, ຜູ້ໃຊ້ບໍ່ສາມາດດັດແປງການສົ່ງ ຫຼື ການປະເມີນຜົນຂອງເຂົາເຈົ້າ. ຄູອາດຈະໃຊ້ເຄື່ອງມືການປະເມີນຄະແນນ ເພື່ອຄິດໄລ່ຄະແນນສຸດທ້າຍ ແລະ ໃຫ້ຄໍາຕິຊົມສໍາລັບຜູ້ທົບທວນ.';
$string['switchphase50'] = 'ກອງປະຊຸມປິດ';
$string['switchphase50info'] = 'ທ່ານກຳລັງຈະປິດກອງປະຊຸມ. ນີ້ຈະສົ່ງຜົນໃຫ້ຄະແນນທີ່ຄິດໄລ່ໄດ້ປາກົດຢູ່ໃນປຶ້ມຄະແນນ. ນັກຮຽນອາດຈະເບິ່ງການສົ່ງ ແລະ ການປະເມີນຜົນການສົ່ງຂອງເຂົາເຈົ້າ.';
$string['switchphaseauto'] = 'ການສະລັບໄດ້ຖືກນັດໝາຍແລ້ວ';
$string['switchphasenext'] = 'ສະລັບໄປໄລຍະຕໍ່ໄປ';
$string['taskassesspeers'] = 'ປະເມີນຜົນເພື່ອນຮ່ວມງານ';
$string['taskassesspeersdetails'] = 'ລວມທັງໝົດ: {$a->total}<br />ລໍຖ້າ: {$a->todo}';
$string['taskassessself'] = 'ປະເມີນຜົນຕົວເອງ';
$string['taskconclusion'] = 'ສະໜອງການສະຫຼຸບກິດຈະກຳ';
$string['taskdone'] = 'ເຮັດສຳເລັດ';
$string['taskfail'] = 'ໜ້າວຽກລົ້ມເຫຼວ';
$string['taskinfo'] = 'ຂໍ້ມູນໜ້າວຽກ';
$string['taskinstructauthors'] = 'ສະໜອງຂໍ້ມູນການສົ່ງ';
$string['taskinstructreviewers'] = 'ສະໜອງຂໍ້ມູນການປະເມີນຜົນ';
$string['taskintro'] = 'ຕັ້ງຄຳອະທິບາຍກອງປະຊຸມ';
$string['tasksubmit'] = 'ສົ່ງວຽກຂອງທ່ານ';
$string['tasktodo'] = 'ໜ້າວຽກທີ່ຕ້ອງເຮັດ';
$string['toolbox'] = 'ກ່ອງເຄື່ອງມືກອງປະຊຸມ';
$string['undersetup'] = 'ປະຈຸບັນກອງປະຊຸມໄດ້ຮັບການສ້າງຕັ້ງຂຶ້ນ. ກະລຸນາລໍຖ້າຈົນກວ່າມັນຈະຖືກປ່ຽນເປັນໄລຍະຕໍ່ໄປ.';
$string['useexamples'] = 'ນຳໃຊ້ຕົວຢ່າງ';
$string['useexamples_desc'] = 'ການສົ່ງຕົວຢ່າງ ແມ່ນສະໜອງໃຫ້ສໍາລັບການປະຕິບັດໃນການປະເມີນຜົນ';
$string['useexamples_help'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ສາມາດພະຍາຍາມປະເມີນໜຶ່ງ ຫຼື ຫຼາຍຕົວຢ່າງການຍື່ນສະເໜີ ແລະ ປຽບທຽບການປະເມີນຂອງເຂົາເຈົ້າກັບການປະເມີນການອ້າງອິງ. ຄະແນນບໍ່ໄດ້ຖືກນັບຢູ່ໃນຄະແນນສໍາລັບການປະເມີນຜົນ.';
$string['usepeerassessment'] = 'ນຳໃຊ້ການປະເມີນເພື່ອນມິດ';
$string['usepeerassessment_desc'] = 'ນັກຮຽນອາດຈະປະເມີນວຽກງານຂອງຄົນອື່ນ';
$string['usepeerassessment_help'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ອາດຈະຖືກຈັດສັນການສົ່ງຈາກຜູ້ໃຊ້ອື່ນ ເພື່ອປະເມີນ ແລະ ຈະໄດ້ຮັບຄະແນນສໍາລັບການປະເມີນຜົນນອກເໜືອຈາກຄະແນນສໍາລັບການສົ່ງຂອງຕົນເອງ.';
$string['userdatecreated'] = 'ສົ່ງແລ້ວໃນ <span>{$a}</span>';
$string['userdatemodified'] = 'ດັດແປງແລ້ວໃນ <span>{$a}</span>';
$string['userplan'] = 'ຕົວວາງແຜນກອງປະຊຸມ';
$string['userplan_help'] = 'ຜູ້ວາງແຜນກອງປະຊຸມສະແດງທຸກຂັ້ນຕອນຂອງກິດຈະກໍາ ແລະ ລາຍຊື່ໜ້າວຽກສໍາລັບແຕ່ລະໄລຍະ. ໄລຍະປະຈຸບັນໄດ້ຖືກເນັ້ນໃຫ້ເຫັນ ແລະ ການສໍາເລັດວຽກງານແມ່ນຊີ້ໃຫ້ເຫັນດ້ວຍໝາຍຕິກ.';
$string['userplanaccessibilityskip'] = 'ຂ້າມຫາໜ້າວຽກປະຈຸບັນ';
$string['userplanaccessibilitytitle'] = 'ເສັ້ນເວລາກອງປະຊຸມກັບໄລຍະ {$a}';
$string['userplancurrentphase'] = 'ໄລຍະປະຈຸບັນ';
$string['useselfassessment'] = 'ໃຊ້ການປະເມີນຜົນດ້ວຍຕົວເອງ';
$string['useselfassessment_desc'] = 'ນັກຮຽນອາດເຂົ້າເຖິງວຽກຂອງເຂົາເຈົ້າເອງ';
$string['useselfassessment_help'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ອາດຈະຖືກຈັດສັນການສົ່ງຂອງຕົນເອງ ເພື່ອປະເມີນ ແລະ ຈະໄດ້ຮັບຄະແນນສໍາລັບການປະເມີນນອກເໜືອຈາກຄະແນນສໍາລັບການສົ່ງຂອງພວກເຂົາ.';
$string['viewworkshopsummary'] = 'ເບິ່ງການສະຫຼຸບກອງປະຊຸມ';
$string['weightinfo'] = 'ນ້ຳໜັກ: {$a}';
$string['withoutsubmission'] = 'ຜູ້ທົບທວນໂດຍບໍ່ເປັນເຈົ້າຂອງການສົ່ງ';
$string['workshop:addinstance'] = 'ເພີ່ມກອງປະຊຸມໃໝ່';
$string['workshop:allocate'] = 'ການຈັດສັນການສົ່ງສຳລັບທົບທວນຄືນ';
$string['workshop:deletesubmissions'] = 'ລຶບການສົ່ງ';
$string['workshop:editdimensions'] = 'ແກ້ໄຂແບບຟອມການປະເມີນຜົນ';
$string['workshop:exportsubmissions'] = 'ສົ່ງອອກການສົ່ງ';
$string['workshop:ignoredeadlines'] = 'ບໍ່ສົນໃຈການຈຳກັດເວລາ';
$string['workshop:manageexamples'] = 'ຈັດການການສົ່ງຕົວຢ່າງ';
$string['workshop:overridegrades'] = 'ລົບລ້າງຄະແນນການຄິດໄລ່';
$string['workshop:peerassess'] = 'ເຂົ້າຫາເພື່ອນມິດ';
$string['workshop:publishsubmissions'] = 'ເຜີຍແຜ່ການສົ່ງ';
$string['workshop:submit'] = 'ສົ່ງ';
$string['workshop:switchphase'] = 'ສະຫຼັບໄລຍະ';
$string['workshop:view'] = 'ເບິ່ງກອງປະຊຸມ';
$string['workshop:viewallassessments'] = 'ເບິ່ງການປະເມີນຜົນທັງໝົດ';
$string['workshop:viewallsubmissions'] = 'ເບິ່ງການປະເມີນຜົນທັງໝົດ';
$string['workshop:viewauthornames'] = 'ເບິ່ງຊື່ຜູ້ຂຽນ';
$string['workshop:viewauthorpublished'] = 'ເບິ່ງຜູ້ຂຽນຂອງການສົ່ງທີ່ເຜີຍແຜ່';
$string['workshop:viewpublishedsubmissions'] = 'ເບິ່ງການສົ່ງທີ່ເຜີຍແຜ່';
$string['workshop:viewreviewernames'] = 'ເບິ່ງຊື່ຜູ້ທົບທວນ';
$string['workshopname'] = 'ຊື່ກອງປະຊຸມ';
$string['yourassessmentfor'] = 'ການປະເມີນຜົນຂອງທ່ານສຳລັບ {$a}';
$string['yourgrades'] = 'ຄະແນນຂອງທ່ານ';
$string['yoursubmission'] = 'ການສົ່ງຂອງທ່ານ';
$string['yoursubmissionwithassessments'] = 'ການສົ່ງຂອງທ່ານດ້ວຍການປະເມີນຜົນ';
