<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'calendar', language 'pt_br', version '4.0'.
 *
 * @package     calendar
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityevent'] = 'Evento de atividade';
$string['addevent'] = 'Adicionar eventos';
$string['advancedoptions'] = 'Opções avançadas';
$string['allday'] = 'O dia todo';
$string['annually'] = 'Anualmente';
$string['calendar'] = 'Calendário';
$string['calendarexporturl'] = 'URL do calendário';
$string['calendarheading'] = '{$a} Calendário';
$string['calendarpreferences'] = 'Preferências do calendário';
$string['calendartypes'] = 'Tipos de calendário';
$string['calendarurl'] = 'URL do calendário: {$a}';
$string['calendarurlcopiedtoclipboard'] = 'URL do calendário copiado para área de transferência';
$string['category'] = 'Categoria';
$string['categoryevent'] = 'Evento de categoria';
$string['categoryevents'] = 'Eventos de categorias';
$string['clickhide'] = 'clique para esconder';
$string['clickshow'] = 'clique para mostrar';
$string['colactions'] = 'Ações';
$string['colcalendar'] = 'Calendário';
$string['collastupdated'] = 'Última atualização';
$string['colpoll'] = 'Intervalo de atualização';
$string['commontasks'] = 'Opções';
$string['confirmeventdelete'] = 'Você tem certeza de que deseja excluir o evento "{$a}"?';
$string['confirmeventseriesdelete'] = 'O evento "{$a->name}" é parte de uma série. Você quer excluir apenas este evento ou todos os {$a->count} eventos da série?';
$string['confirmsubscriptiondelete'] = 'Tem certeza de que deseja excluir a assinatura do calendário "{$a}"?';
$string['copycalendarurl'] = 'Copiar URL do calendário';
$string['copyurl'] = 'Copiar URL';
$string['course'] = 'Curso';
$string['coursecalendar'] = '{$a} calendário';
$string['courseevent'] = 'Evento do curso';
$string['courseevents'] = 'Eventos do curso';
$string['courses'] = 'Cursos';
$string['customexport'] = 'Intervalo personalizado ({$a->timestart} - {$a->timeend})';
$string['daily'] = 'Diário';
$string['day'] = 'Dia';
$string['dayeventsmany'] = '{$a->num} eventos, {$a->day}';
$string['dayeventsnone'] = 'Sem eventos, {$a}';
$string['dayeventsone'] = '1 evento, {$a}';
$string['daynext'] = 'Próximo dia';
$string['dayprev'] = 'Dia anterior';
$string['dayviewfor'] = 'Visão do dia para:';
$string['dayviewtitle'] = 'Vista do dia: {$a}';
$string['daywithnoevents'] = 'Não há eventos neste dia.';
$string['default'] = 'Padrão';
$string['deleteallevents'] = 'Excluir todos eventos';
$string['deleteevent'] = 'Excluir evento';
$string['deleteevents'] = 'Excluir eventos';
$string['deleteoneevent'] = 'Excluir este evento';
$string['detailedmonthviewfor'] = 'Visualizar mês em detalhes para:';
$string['detailedmonthviewtitle'] = 'Visualizar mês em detalhes: {$a}';
$string['durationminutes'] = 'Duração em minutos';
$string['durationnone'] = 'Sem duração';
$string['durationuntil'] = 'Até';
$string['editevent'] = 'Editando evento';
$string['erroraddingevent'] = 'Falha ao adicionar evento';
$string['errorbadsubscription'] = 'Assinatura do calendário não encontrada.';
$string['errorbeforecoursestart'] = 'Não é possível criar um evento em uma data anterior à data inicial do curso';
$string['errorcannotimport'] = 'Você não pode configurar uma assinatura de calendário agora.';
$string['errorhasuntilandcount'] = 'Ou até ou contador podem aparecer em uma regra de recorrência, mas até ou contador não deve ocorrer na mesma regra de recorrência.';
$string['errorinvalidbydayprefix'] = 'Valores inteiros que precedem as regras POR DIA só podem estar presentes em regras recorrentes MENSAIS ou ANUAIS.';
$string['errorinvalidbydaysuffix'] = 'Os valores válidos para o dia da semana partes da regra POR DIA são MO, TU, WE, TH, FR, SA e SU';
$string['errorinvalidbyhour'] = 'Os valores válidos para a regra POR HORA são de 0 a 23.';
$string['errorinvalidbyminute'] = 'Os valores válidos para a regra Por minuto são de 0 a 59.';
$string['errorinvalidbymonth'] = 'Os valores válidos para a regra Por mês são de 1 a 12.';
$string['errorinvalidbymonthday'] = 'Os valores válidos para a regra Dia do Mês são de 1 a 31 ou -31 a -1.';
$string['errorinvalidbysecond'] = 'Os valores válidos para a regra Por segundo são de 0 a 59.';
$string['errorinvalidbysetpos'] = 'Os valores válidos para a regra BYSETPOS são de 1 a 366 ou -366 a -1.';
$string['errorinvalidbyweekno'] = 'Os valores válidos para a regra BYWEEKNO são de 1 a 53 ou -53 a -1.';
$string['errorinvalidbyyearday'] = 'Os valores válidos para a regra Por dia do ano são de 1 a 366 ou -366 a -1.';
$string['errorinvaliddate'] = 'Data inválida';
$string['errorinvalidicalurl'] = 'A URL iCal dado é inválido.';
$string['errorinvalidinterval'] = 'O valor para a regra Intervalo deve ser um inteiro positivo.';
$string['errorinvalidminutes'] = 'Definir a duração em minutos utilizando um número entre 1 e 999.';
$string['errorinvalidrepeats'] = 'Definir o número de eventos utilizando um número entre 1 e 99.';
$string['errormustbeusedwithotherbyrule'] = 'A regra BYSETPOS só deve ser usada em conjunto com outra parte de regra BYxxx.';
$string['errornodescription'] = 'Uma descrição é necessária';
$string['errornoeventname'] = 'Um nome é necessário';
$string['errornonyearlyfreqwithbyweekno'] = 'A regra BYWEEEKNO só é válida apenas para regras anuais.';
$string['errorrequiredurlorfile'] = 'É necessária uma URL ou um arquivo para importar um calendário.';
$string['errorrrule'] = 'A regra de ocorrência periódica passada parece incorreta.';
$string['errorrruleday'] = 'A regra de ocorrência periódica possui um parâmetro de dia inválido.';
$string['errorrrulefreq'] = 'A regra de ocorrência periódica possui um parâmetro de frequência inválido.';
$string['eventcalendareventcreated'] = 'Evento criado no calendário';
$string['eventcalendareventdeleted'] = 'Evento excluído do calendário';
$string['eventcalendareventupdated'] = 'Evento atualizado no calendário';
$string['eventdate'] = 'Data';
$string['eventdescription'] = 'Descrição';
$string['eventduration'] = 'Duração';
$string['eventendtime'] = 'Hora final';
$string['eventendtimewrapped'] = '{$a} (Hora final)';
$string['eventinstanttime'] = 'Hora';
$string['eventkind'] = 'Tipo de evento';
$string['eventname'] = 'Nome do evento';
$string['eventnameandcategory'] = '{$a->category}: {$a->name}';
$string['eventnameandcourse'] = '{$a->course}: {$a->name}';
$string['eventnone'] = 'Nenhum evento';
$string['eventrepeat'] = 'Repetição';
$string['events'] = 'Eventos';
$string['eventsall'] = 'Todos os eventos';
$string['eventsdeleted'] = 'Eventos excluídos: {$a}';
$string['eventsfor'] = '{$a} eventos';
$string['eventsimported'] = 'Eventos importados: {$a}';
$string['eventskey'] = 'Chave de eventos';
$string['eventsource'] = 'Origem do evento';
$string['eventspersonal'] = 'Meus eventos pessoais';
$string['eventsrelatedtocategories'] = 'Eventos relacionados às categorias';
$string['eventsrelatedtocourses'] = 'Eventos relacionados aos cursos';
$string['eventsrelatedtogroups'] = 'Eventos relacionados a grupos';
$string['eventsskipped'] = 'Eventos ignorados: {$a}';
$string['eventstarttime'] = 'Hora inicial';
$string['eventstoexport'] = 'Eventos a exportar';
$string['eventsubscriptioncreated'] = 'Inscrição de calendário criada';
$string['eventsubscriptiondeleted'] = 'Inscrição de calendário excluída';
$string['eventsubscriptioneditwarning'] = 'Este evento de calendário faz parte de uma assinatura. Todas as alterações feitas neste evento serão perdidas se a assinatura for excluída.';
$string['eventsubscriptionupdated'] = 'Inscrição de calendário atualizada';
$string['eventsupdated'] = 'Eventos atualizados: {$a}';
$string['eventtime'] = 'Hora';
$string['eventtype'] = 'Tipo de evento';
$string['eventtypecategory'] = 'categoria';
$string['eventtypecourse'] = 'curso';
$string['eventtypegroup'] = 'grupo';
$string['eventtypemodule'] = 'módulo';
$string['eventtypeother'] = 'outro';
$string['eventtypesite'] = 'site';
$string['eventtypeuser'] = 'usuário';
$string['eventview'] = 'Detalhes do evento';
$string['expired'] = 'Expirado';
$string['explain_site_timeformat'] = 'Você pode escolher a modalidade de visualização das horas para todo o site: 12 ou 24 horas. O padrão corresponde à opção de uso do idioma no site. Isto pode ser modificado pelos usuários.';
$string['export'] = 'Exportar';
$string['exportbutton'] = 'Exportar';
$string['exportcalendar'] = 'Exportar calendário';
$string['exporthelp'] = '<p> O URL do calendário fornece um link dinâmico para importar eventos para outros calendários. Todo evento novo, alterado ou excluído no calendário de origem <strong>será</strong> refletido nos outros calendários.</p>
<p>A exportação de calendário permite que você crie uma cópia de backup dos eventos, que podem ser importados para outros calendários. As atualizações feitas no calendário de origem <strong>não</strong> serão refletidas nos outros calendários.</p>';
$string['forcecalendartype'] = 'Forçar calendário';
$string['fri'] = 'Sex';
$string['friday'] = 'Sexta-feira';
$string['fullcalendar'] = 'Calendário completo';
$string['generateurlbutton'] = 'Obter URL do calendário';
$string['gotoactivity'] = 'Ir à atividade';
$string['gotocalendar'] = 'Ir ao calendário';
$string['group'] = 'Grupo';
$string['groupevent'] = 'Evento do grupo';
$string['groupevents'] = 'Eventos do grupo';
$string['hideeventtype'] = 'Ocultar eventos - {$a}';
$string['hourly'] = 'De hora em hora';
$string['importcalendar'] = 'Importar calendário';
$string['importcalendarexternal'] = 'Importar um calendário externo?';
$string['importcalendarfrom'] = 'Importar de';
$string['importcalendarheading'] = 'Importar calendário...';
$string['importfromfile'] = 'Arquivo de calendário (.ics)';
$string['importfrominstructions'] = 'Por favor, forneça uma URL de um calendário remoto, ou carregue um arquivo.';
$string['importfromurl'] = 'URL do calendário';
$string['invalideventtype'] = 'O tipo de evento que você selecionou é inválido.';
$string['invalidtimedurationminutes'] = 'A duração em minutos que você inseriu é inválida. Por favor, insira uma duração em minutos maior que zero ou selecione sem duração.';
$string['invalidtimedurationuntil'] = 'A data e hora que você selecionou para duração é anterior ao início do evento. Por favor, corrija isto antes de prosseguir.';
$string['iwanttoexport'] = 'Exportar';
$string['less'] = 'Menos';
$string['managesubscriptions'] = 'Gerenciar assinaturas';
$string['manyevents'] = '{$a} eventos';
$string['mon'] = 'Seg';
$string['monday'] = 'Segunda-feira';
$string['monthly'] = 'Mensal';
$string['monthlyview'] = 'Visualização mensal';
$string['monthnext'] = 'Próximo mês';
$string['monthprev'] = 'Mês anterior';
$string['monththis'] = 'Este mês';
$string['more'] = 'Mais';
$string['moreevents'] = 'mais {$a}';
$string['namewithsource'] = '{$a->name} ({$a->source})';
$string['never'] = 'Nunca';
$string['newevent'] = 'Novo evento';
$string['nocalendarsubscriptions'] = 'Ainda não há assinaturas de calendário. Você quer {$a}';
$string['notitle'] = 'sem título';
$string['noupcomingevents'] = 'Não há nenhum evento próximo';
$string['oneevent'] = 'Um evento';
$string['pollinterval'] = 'Atualizar intervalo';
$string['pollinterval_help'] = 'Frequência com que você quer que o calendário seja atualizado com novos eventos.';
$string['pref_lookahead'] = 'Previsão de próximos eventos';
$string['pref_lookahead_help'] = 'Isso define o número (máximo) de dias no futuro em que um evento deverá começar de modo a ser exibido como um evento futuro. Eventos que iniciam além desta não serão exibidos como futuros. Por favor note que <strong>não há garantias </strong> que todos os eventos iniciados neste período serão exibidos; se houver muitos (mais do que o "Total de eventos futuros"), então os eventos mais distantes não serão exibidos.';
$string['pref_maxevents'] = 'Número máximo de próximos eventos';
$string['pref_maxevents_help'] = 'Isso define o número máximo de eventos futuros que podem ser exibidos. Se você indicar um número grande aqui, possivelmente os eventos futuros irão ocupar muito espaço na sua tela.
';
$string['pref_persistflt'] = 'Lembrar configuração dos filtros';
$string['pref_persistflt_help'] = 'Se estiver ativado, o Moodle lembrará de suas últimas configurações de filtro de evento e irá restaurá-las automaticamente cada vez que você efetuar login.';
$string['pref_startwday'] = 'Primeiro dia da semana';
$string['pref_startwday_help'] = 'A semana exibida no calendário irá iniciar conforme o dia que você selecionar aqui.';
$string['pref_timeformat'] = 'Formato de visualização da hora';
$string['pref_timeformat_help'] = 'Você pode ver as horas no formato de 12 ou 24 horas. Se escolher "padrão", então será utilizado o padrão correspondente à opção de uso do idioma no site.';
$string['preferences'] = 'Preferências';
$string['preferences_available'] = 'Suas preferências pessoais';
$string['preferredcalendar'] = 'Calendário preferido';
$string['privacy:metadata:calendar:event'] = 'O componente Calendário pode armazenar detalhes do evento de calendário do usuário no subsistema principal.';
$string['privacy:metadata:calendar:event:description'] = 'A descrição do evento da agenda.';
$string['privacy:metadata:calendar:event:eventtype'] = 'O tipo de evento do evento de calendário.';
$string['privacy:metadata:calendar:event:name'] = 'O nome do evento da agenda.';
$string['privacy:metadata:calendar:event:timeduration'] = 'A duração do evento da agenda.';
$string['privacy:metadata:calendar:event:timestart'] = 'A hora de início do evento da agenda.';
$string['privacy:metadata:calendar:event_subscriptions'] = 'O componente Calendário pode armazenar detalhes das assinaturas de calendário do usuário no subsistema.';
$string['privacy:metadata:calendar:event_subscriptions:eventtype'] = 'O tipo de evento da assinatura do calendário.';
$string['privacy:metadata:calendar:event_subscriptions:name'] = 'O nome da assinatura do calendário.';
$string['privacy:metadata:calendar:event_subscriptions:url'] = 'A URL da assinatura do calendário.';
$string['privacy:metadata:calendar:preferences:calendar_savedflt'] = 'O tipo de evento de calendário configurado exibe a preferência do usuário.';
$string['recentupcoming'] = 'Recente e próximos 60 dias';
$string['repeatedevents'] = 'Eventos repetidos';
$string['repeateditall'] = 'Aplicar alterações a todos os {$a} eventos desta série de repetições';
$string['repeateditthis'] = 'Aplicar mudanças apenas a este evento';
$string['repeatevent'] = 'Repetir este evento';
$string['repeatnone'] = 'Nenhuma repetição';
$string['repeatweeksl'] = 'Repetir semanalmente, criar todas de uma vez';
$string['repeatweeksr'] = 'eventos';
$string['requiresaction'] = '{$a} requer ação';
$string['sat'] = 'Sáb';
$string['saturday'] = 'Sábado';
$string['showeventtype'] = 'Mostrar {$a} eventos';
$string['shown'] = 'visualizados';
$string['site'] = 'Site';
$string['siteevent'] = 'Evento do site';
$string['siteevents'] = 'Eventos de site';
$string['spanningevents'] = 'Eventos ativos';
$string['subscriptionname'] = 'Nome do calendário';
$string['subscriptionremoved'] = '{$a} assinatura calendário removido';
$string['subscriptions'] = 'Assinaturas';
$string['subscriptionsource'] = 'Fonte do evento: {$a}';
$string['subscriptionupdated'] = 'A assinatura do calendário {$a} foi atualizada';
$string['sun'] = 'Dom';
$string['sunday'] = 'Domingo';
$string['thu'] = 'Qui';
$string['thursday'] = 'Quinta-feira';
$string['timeformat_12'] = '12 horas (am/pm)';
$string['timeformat_24'] = '24 horas';
$string['timeperiod'] = 'Período';
$string['today'] = 'Hoje';
$string['todayplustitle'] = '{$a} hoje';
$string['tomorrow'] = 'Amanhã';
$string['tt_deleteevent'] = 'Cancelar evento';
$string['tt_editevent'] = 'Editar evento';
$string['tue'] = 'Ter';
$string['tuesday'] = 'Terça-feira';
$string['typecategory'] = 'Evento de categoria';
$string['typeclose'] = 'Evento fechado';
$string['typecourse'] = 'Evento do curso';
$string['typedue'] = 'Evento de entrega de atividade';
$string['typegradingdue'] = 'Evento de avaliação';
$string['typegroup'] = 'Evento do grupo';
$string['typeopen'] = 'Abrir evento';
$string['typesite'] = 'Evento do site';
$string['typeuser'] = 'Evento do usuário';
$string['upcomingevents'] = 'Próximos eventos';
$string['upcomingeventsfor'] = 'Próximos eventos para:';
$string['urlforical'] = 'URL para exportação iCalendar, para assinatura do calendário';
$string['user'] = 'Usuário';
$string['userevent'] = 'Evento do usuário';
$string['userevents'] = 'Eventos do usuário';
$string['viewupcomingactivitiesdue'] = 'Ver as próximas atividades agendadas';
$string['wed'] = 'Qua';
$string['wednesday'] = 'Quarta-feira';
$string['weekly'] = 'Semanal';
$string['weeknext'] = 'Próxima semana';
$string['weekthis'] = 'Esta semana';
$string['when'] = 'Quando';
$string['whendate'] = 'Quando:{$a}';
$string['yesterday'] = 'Ontem';
$string['youcandeleteallrepeats'] = 'Este evento é parte de uma série de eventos repetidos. Você pode excluir apenas este evento ou todos os {$a} eventos de uma vez só.';
$string['yoursubscriptions'] = 'Suas assinaturas';
