<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'sr_cr', version '4.0'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'О';
$string['Afull'] = 'Одсутан/на';
$string['Eacronym'] = 'ОО';
$string['Efull'] = 'Оправдано одсутан/на';
$string['Lacronym'] = 'З';
$string['Lfull'] = 'Закаснио/ла';
$string['Pacronym'] = 'П';
$string['Pfull'] = 'Присутан/на';
$string['absenteereport'] = 'Извештај о одсуству';
$string['acronym'] = 'Акроним';
$string['add'] = 'Додај';
$string['addedrecip'] = 'Додат {$a} нови прималац ';
$string['addedrecips'] = 'Додато нових прималаца: {$a}';
$string['addmultiplesessions'] = 'Вишеструке сесије';
$string['addsession'] = 'Додај сесију';
$string['adduser'] = 'Додај корисника';
$string['addwarning'] = 'Додај упозорење';
$string['all'] = 'Све';
$string['allcourses'] = 'Сви курсеви';
$string['allpast'] = 'Све претходне';
$string['allsessions'] = 'Све сесије';
$string['allsessionstotals'] = 'Укупно за изабране сесије';
$string['attendance:addinstance'] = 'Додавање нове активности \'Присуство\'';
$string['attendance:canbelisted'] = 'Појављује се у списку';
$string['attendance:changeattendances'] = 'Промена података о присуству';
$string['attendance:changepreferences'] = 'Промена параметара';
$string['attendance:export'] = 'Извоз извештаја';
$string['attendance:import'] = 'Увоз сесије из датотеке (csv)';
$string['attendance:manageattendances'] = 'Управљање \'Присуствима\'';
$string['attendance:managetemporaryusers'] = 'Управљање привременим корисницима';
$string['attendance:manualautomark'] = 'Ручно аутоматско обележавање присуства';
$string['attendance:takeattendances'] = 'Евидентирање присуства';
$string['attendance:view'] = 'Приказ присуства';
$string['attendance:viewreports'] = 'Приказ извештаја';
$string['attendance:viewsummaryreports'] = 'Приказ скраћених извештаја о присуству на курсевима';
$string['attendance:warningemails'] = 'Претплата на е-поруке са списком одсутних корисника';
$string['attendance_already_submitted'] = 'Ваше присуство је већ подешено.';
$string['attendance_no_status'] = 'Ниједан исправан статус није био доступан - можда сте закаснили да евидентирате присуство.';
$string['attendancedata'] = 'Подаци о присуству';
$string['attendancefile'] = 'Датотека о присуству (csv формат)';
$string['attendancefile_help'] = 'Датотека мора бити CSV датотека са заглављем и пољима која идентификују корисника и време када је присуство евидентирано, нпр. "адреса е-поште" (email,scantime) или "корисничко име,време" (username,time)';
$string['attendancegrade'] = 'Оцена за присуство';
$string['attendancenotset'] = 'Морате да означите своје присуство';
$string['attendancenotstarted'] = 'Присуство настави још увек није почело за овај курс';
$string['attendancepercent'] = 'Проценат присуства';
$string['attendancereport'] = 'Присуство';
$string['attendanceslogged'] = 'Присуства евидентирана';
$string['attendancestaken'] = 'Присуства обележена';
$string['attendancesuccess'] = 'Присуство је успешно обележено';
$string['attendanceupdated'] = 'Подаци о присуству су успешно ажурирани';
$string['attendanceuserreport'] = 'Извештај о присуству';
$string['attforblockdirstillexists'] = 'стари директоријум mod/attforblock још увек постоји - морате да обришете овај директоријум на вашем серверу пре него што покренете ову надоградњу.';
$string['attrecords'] = 'Евиденција о присуству';
$string['autoassignstatus'] = 'Аутоматски изаберите највиши доступни статус';
$string['autoassignstatus_help'] = 'Ако је ово изабрано, полазницима ће аутоматски бити додељена највиша доступна оцена.';
$string['automark'] = 'Аутоматско обележавање';
$string['automark_help'] = 'Омогућава да се обележавање заврши аутоматски.
Ако је подешено на "Да", полазници ће бити аутоматски обележени у зависности од њиховог првог приступа курсу.
Ако је подешено на "Подеси као неозначено на крају сесије", за све полазнике који нису означили своје присуство, оно ће бити подешено као неозначено.';
$string['automarkall'] = 'Да';
$string['automarkclose'] = 'Подеси као неозначено на крају сесије';
$string['automarkingcomplete'] = 'Аутоматско обележавање је завршено';
$string['automarkingnotavailableyet'] = 'Ова сесија користи аутоматско обележавање на крају сесије, а ова сесија се још није завршила.';
$string['automarkingnotenabled'] = 'Аутоматско обележавање није омогућено у овој сесији';
$string['automarktask'] = 'Провера да ли постоје сесије које захтевају аутоматско обележавање';
$string['automarkuseempty'] = 'Манипулација доступношћу аутоматског обележавања статуса';
$string['automarkuseempty_desc'] = 'Ако је означено, ставке статуса које имају празно/неподешено подешавање "доступно за" биће дозвољене током аутоматског обележавања';
$string['autorecorded'] = 'системско аутоматско обележавање присуства';
$string['averageattendance'] = 'Просечно присуство';
$string['averageattendancegraded'] = 'Просечно присуство';
$string['backtoparticipants'] = 'Назад на списак учесника';
$string['below'] = 'Испод {$a}%';
$string['calclose'] = 'Затвори';
$string['calendarevent'] = 'Креирајте догађај у календару за сесију';
$string['calendarevent_help'] = 'Ако је омогућено, у календару ће бити креиран догађај за ову сесију.
Ако је онемогућено, сви постојећи догађаји у календару за ову сесију биће обрисани.';
$string['caleventcreated'] = 'Унос догађаја у календар за ову сесију је успешно извршен';
$string['caleventdeleted'] = 'Успешно је обрисан унос у календар за сесију';
$string['calmonths'] = 'Јануар, Фебруар, Март, Април, Мај, Јун, Јул, Август, Септембар, Октобар, Новембар, Децембар';
$string['calshow'] = 'Изабери датум';
$string['calweekdays'] = 'Нед,Пон,Уто,Сре,Чет,Пет,Суб';
$string['cannottakeforgroup'] = 'Не можете да евидентирате присуство за групу  "{$a}"';
$string['cannottakethisgroup'] = 'Нисте члан групе на курсу на коју се односи ова сесија, тако да ваше присуство није евидентирано.';
$string['cantaddstatus'] = 'Морате подесити акроним и опис када додајете нови статус.';
$string['canthidestatus'] = 'Не можете сакрити овај статус јер се он већ користи у оквиру ове активности за евидентирање присуства';
$string['categoryreport'] = 'Извештај о категорији курсева';
$string['changeattendance'] = 'Промени податке о присуству';
$string['changeduration'] = 'Промени трајање';
$string['changesession'] = 'Промени сесију';
$string['checkweekdays'] = 'Одаберите дане у седмици који упадају у опсег датума одабране сесије.';
$string['closed'] = 'Ова сесија тренутно није доступна за само-обележавање присуства';
$string['column'] = 'колона';
$string['columnmap'] = 'Мапирање колона';
$string['columnmap_help'] = 'За свако од приказаних поља изаберите одговарајућу колону у csv датотеци.';
$string['columns'] = 'колоне';
$string['commonsession'] = 'Сви полазници';
$string['commonsessions'] = 'Сви полазници';
$string['confirm'] = 'Потврди';
$string['confirmcolumnmappings'] = 'Потврдите мапирања колона';
$string['confirmdeletehiddensessions'] = 'Да ли сте сигурни да желите да обришете {$a->count} сесија заказаних за пре почетка курса ({$a->date})?';
$string['confirmdeleteuser'] = 'Да ли сте сигурни да желите да обришете корисника под именом \'{$a->fullname}\' ({$a->email})?<br/>Сва забележена присуства тог корисника ће бити трајно обрисана.';
$string['copyfrom'] = 'Копирај податке о присуству из';
$string['countofselected'] = 'Број изабраних';
$string['course'] = 'Курс';
$string['coursemessage'] = 'Пошаљите поруку корисницима на курсу';
$string['courseshortname'] = 'Скраћени назив курса';
$string['coursesummary'] = 'Скраћени извештај о присуству на курсевима';
$string['createmultiplesessions'] = 'Креирај вишеструке сесије';
$string['createmultiplesessions_help'] = 'Ова функција вам омогућава да креирате више сесија у једном једноставном кораку.

Сесије почињу са датумом прве сесије и наставиће се све до датума наведеног у подешавању "поновите до".

* <strong>Поновите на дан</strong>: изаберите дане у недељи када ће ваши полазници да се сусрећу (на пример, понедељак/среда/петак).
* <strong>Поновите сваке</strong>: ово омогућава да подесите колико често ће се одржавати сесије. Ако ће се ваша група састајати сваке седмице, изаберите 1; ако ће се састајати сваке друге седмице, изаберите 2; сваке треће седмице изаберите 3 итд.
* <strong>Поновите до</strong>: изаберите последњи дан  курса (последњи дан када желите да евидентирате присуство).';
$string['createonesession'] = 'Креирај једну сесију за курс';
$string['csvdelimiter'] = 'CSV граничник';
$string['currentlyselectedusers'] = 'Тренутно изабрани корисници';
$string['customexportfields'] = 'Извезите прилагођена поља корисничког профила';
$string['customexportfields_help'] = 'Додатна прилагођена поља корисничког профила која ће бити видљива у извештају који се извози.';
$string['customfields'] = 'Прилагођена поља сесије';
$string['date'] = 'Датум';
$string['days'] = 'Дани';
$string['defaultdisplaymode'] = 'Подразумевани режим приказа';
$string['defaults'] = 'Подразумеване вредности';
$string['defaultsessionsettings'] = 'Подразумевана подешавања сесије';
$string['defaultsessionsettings_help'] = 'Ова подешавања дефинишу подразумеване вредности за све нове сесије';
$string['defaultsettings'] = 'Подразумевана подешавања присуства';
$string['defaultsettings_help'] = 'Ова подешавања дефинишу подразумеване вредности за сва нова присуства';
$string['defaultstatus'] = 'Скуп подразумеваних статуса';
$string['defaultsubnet'] = 'Подразумевана мрежна адреса';
$string['defaultsubnet_help'] = 'Евидентирање присуства може бити ограничено на одређене подмреже навођењем списка делимичних или целих IP адреса раздвојених зарезима. Ово је подразумевана вредност која се користи приликом креирања нових сесија.';
$string['defaultview'] = 'Подразумевани приказ приликом пријављивања.';
$string['defaultview_desc'] = 'Ово је подразумевани приказ који виде предавачи приликом првог пријављивања.';
$string['defaultwarnings'] = 'Скуп подразумеваних упозорења';
$string['defaultwarningsettings'] = 'Подразумевана подешавања упозорења';
$string['defaultwarningsettings_help'] = 'Ова подешавања дефинишу подразумеване вредности за сва нова упозорења';
$string['delete'] = 'Обриши';
$string['deletecheckfull'] = 'Да ли сте потпуно сигурни да желите да у потпуности oбришете {$a}, укључујући све корисничке податке?';
$string['deletedgroup'] = 'Група повезана са овом сесијом је обрисана';
$string['deletehiddensessions'] = 'Обриши све скривене сесије';
$string['deletelogs'] = 'Обриши податке о присуству';
$string['deleteselected'] = 'Обриши изабране';
$string['deletesession'] = 'Обриши сесију';
$string['deletesessions'] = 'Обриши све сесије';
$string['deleteuser'] = 'Обриши корисника';
$string['deletewarningconfirm'] = 'Да ли сте сигурни да желите да oбришете ово упозорење?';
$string['deletingsession'] = 'Брисање сесије за курс';
$string['deletingstatus'] = 'Брисање статуса за курс';
$string['description'] = 'Опис';
$string['display'] = 'Приказ';
$string['displaymode'] = 'Режим приказа';
$string['donotusepaging'] = 'Не користи страничење';
$string['downloadexcel'] = 'Преузми у Excel формату';
$string['downloadooo'] = 'Преузми у OpenOffice формату';
$string['downloadtext'] = 'Преузми у текстуалном формату';
$string['duration'] = 'Трајање';
$string['editsession'] = 'Уреди сесију';
$string['edituser'] = 'Уреди корисника';
$string['emailcontent'] = 'Садржај е-поруке';
$string['emailcontent_default'] = 'Поштовани/а %userfirstname%,
Ваше присуство на %coursename% %attendancename% је пало испод %warningpercent% и тренутно је %percent% - надамо се да сте добро!

Како бисте извукли максимум из овог курса, потребно је да побољшате своје присуство; контактирајте нас ако вам је потребна додатна подршка.';
$string['emailcontent_help'] = 'Када се полазнику шаље упозорење, оно преузима садржај е-поруке из овог поља. Могу се користити следећи џокер знаци:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Тема е-поруке';
$string['emailsubject_default'] = 'Упозорење о (не)присуствовању сесијама';
$string['emailsubject_help'] = 'Када се полазнику шаље упозорење, оно преузима тему е-поруке из овог поља.';
$string['emailuser'] = 'Адреса е-поште корисника';
$string['emailuser_help'] = 'Ако је означено, полазнику ће бити послато упозорење.';
$string['emptyacronym'] = 'Празне скраћенице нису дозвољене. Запис о статусу није ажуриран.';
$string['emptydescription'] = 'Празни описи нису дозвољени. Запис о статусу није ажуриран.';
$string['enablecalendar'] = 'Креирај догађаје у календару';
$string['enablecalendar_desc'] = 'Ако је ова опција омогућена, догађај у календару ће бити креиран за сваку сесију. Након промене овог подешавања, требало би да покренете извештај о ресетовању календара.';
$string['enablewarnings'] = 'Омогући упозорења';
$string['enablewarnings_desc'] = 'Ово омогућава да се дефинише скуп упозорења за присуство и слање обавештења е-поштом корисницима када присуство падне испод конфигурисаног прага. <br/><strong>УПОЗОРЕЊЕ: Ово је нова функција и није детаљно тестирана. Можете је користити, али на сопствени ризик. Ако нађете да је ова функција корисна и да исправно ради, молимо вас да повратне информације поделите на Moodle форумима.</strong>';
$string['encoding'] = 'Кодирање';
$string['encoding_help'] = 'Ово се односи на тип кодирања бар кода који се користи на ID картицама полазника. Типични типови шема кодирања бар кодова укључују Code-39, Code-128 и UPC-A.';
$string['endofperiod'] = 'Крај временског периода';
$string['endtime'] = 'Време завршетка сесије';
$string['enrolmentend'] = 'Учешће корисника на курсу се завршава {$a}';
$string['enrolmentstart'] = 'Учешће корисника на курсу почиње {$a}';
$string['enrolmentsuspended'] = 'Учешће на курсу суспендовано';
$string['enterpassword'] = 'Унеси лозинку';
$string['error:coursehasnoattendance'] = 'Курс са скраћеним називом {$a} нема активности присуства.';
$string['error:coursenotfound'] = 'Курс са скраћеним називом {$a} није могуће пронаћи.';
$string['error:qrcode'] = 'Да би се користио QR кôд полазницима мора бити омогућено да сами обележе своје присуство! Прескаче се.';
$string['error:sessioncourseinvalid'] = 'Сесија курса је неисправна! Прескаче се.';
$string['error:sessiondateinvalid'] = 'Датум се сесије је неисправан! Прескаче се.';
$string['error:sessionendinvalid'] = 'Време завршетка сесије је неисправно! Прескаче се.';
$string['error:sessionstartinvalid'] = 'Време почетка сесије је неисправно! Прескаче се.';
$string['error:statusnotfound'] = 'Корисник: {$a->extuser} има статус који се не може пронаћи: {$a->status}';
$string['error:timenotreadable'] = 'Корисник: {$a->extuser} има време очитавања које није могло бити конвертовано помоћу PHP функције strtotime: {$a->scantime}';
$string['error:userduplicate'] = 'Корисник {$a} је пронађен два пута у увезеној сесији. Укључите само један запис по кориснику.';
$string['errorgroupsnotselected'] = 'Изаберите једну или више група';
$string['errorinaddingsession'] = 'Грешка у додавању сесије';
$string['erroringeneratingsessions'] = 'Грешка у генерисању сесија';
$string['eventdurationupdated'] = 'Трајање сесије ажурирано';
$string['eventreportviewed'] = 'Извештај о присуству је приказан';
$string['eventscreated'] = 'Догађаји у календару креирани';
$string['eventsdeleted'] = 'Догађаји у календару обрисани';
$string['eventsessionadded'] = 'Сесија додата';
$string['eventsessiondeleted'] = 'Сесија обрисана';
$string['eventsessionipshared'] = 'IP конфликт приликом само-обележавање присуства';
$string['eventsessionsimported'] = 'Сесије увезене';
$string['eventsessionupdated'] = 'Сесија ажурирана';
$string['eventstatusadded'] = 'Статус додат';
$string['eventstatusupdated'] = 'Статус ажуриран';
$string['eventstudentattendancesessionsupdated'] = 'Извештај о сесији ажуриран';
$string['eventstudentattendancesessionsviewed'] = 'Извештај о сесији приказан';
$string['eventtaken'] = 'Присуство обележено';
$string['eventtakenbystudent'] = 'Полaзник је обележио присуство';
$string['export'] = 'Извоз';
$string['extrarestrictions'] = 'Додатна ограничења';
$string['formattexttype'] = 'Форматирање';
$string['from'] = 'од:';
$string['gradebookexplanation'] = 'Оцена у књизи оцена';
$string['gradebookexplanation_help'] = 'Модул \'Присуство\' приказује вашу тренутну оцену за присуства на основу броја бодова који сте зарадили до сада и броја бодова који сте могли да зарадите до данас; Оцена не обухвата часове који ће тек бити одржани.
У књизи оцена, ваша оцена за присуство се заснива на вашем  тренутном проценту присуства и броја бодова који се може зарадити током читавог трајања курса, укључујући и будуће часове Због тога, ваше оцене за присуство приказане у модулу \'Присуство\' и у књизи оцена не морају да имају исти број бодоава, али ће имати исти проценат.

На пример, ако сте до данас зарадили 8 од 10 бодова (80% присуства), а присуство на читавом курсу вреди 50 бодова, модул \'Присуство\' ће приказати 8/10, док ће књига оцена приказати 40/50. Још увек нисте зарадили 40 бодова, али 40 је еквивалентна вредност бодова  за ваш тренутни проценат присуства од 80%. Вредност бодова које сте зарадили у модулу \'Присуство\', никада не може да се смањи, јер се она заснива само на подацима о присуству досадашњој настави; међутим, вредност бодова за присуство приказан у књизи оцена може да се повећа или смањи у зависности од вашег будућег присуствовања настави, јер се заснива на присустви током читавог курса.';
$string['graded'] = 'Оцењене сесије';
$string['gridcolumns'] = 'Колоне мреже';
$string['group'] = 'Група';
$string['groups'] = 'Групе';
$string['groupsession'] = 'Група полазника';
$string['groupsessionsby'] = 'Групне сесије';
$string['hiddensessions'] = 'Сакривене сесије';
$string['hiddensessions_help'] = 'Сесије су сакривене уколико су заказане за пре почетка курса.

Ову функцију можете да користите како бисте сакрили старије сесије уместо да их бришете. Само видљиве сесије ће бити приказане у дневнику оцена.';
$string['hiddensessionsdeleted'] = 'Све скривене сесије су обрисане';
$string['hideextrauserdetails'] = 'Сакриј додатне податке о кориснику';
$string['hidensessiondetails'] = 'Сакриј податке о сесији';
$string['identifyby'] = 'Идентификуј студента по';
$string['import'] = 'Увоз';
$string['importfile'] = 'Увези датотеку';
$string['importfile_help'] = 'Увези датотеку';
$string['importsessions'] = 'Увоз сесија';
$string['importstatus'] = 'Поље статуса';
$string['importstatus_help'] = 'Ово омогућава да се вредност статуса укључи током увоза - нпр. вредности као што су П, З или О';
$string['includeabsentee'] = 'Укључите сесију приликом израчунавања извештаја о одсуству';
$string['includeabsentee_help'] = 'Ако је означено, ова сесија ће бити укључена у прорачуне извештаја о одсуству.';
$string['includeall'] = 'Изабери све сесије';
$string['includedescription'] = 'Укључите опис сесије';
$string['includenottaken'] = 'Укључи сесије за које присуство није обележено';
$string['includeqrcode'] = 'Укључите QR кôд';
$string['includeremarks'] = 'Укључи напомене';
$string['incorrectpassword'] = 'Унели сте погрешну лозинку и ваше присуство није евидентирано, молимо унесите тачну лозинку.';
$string['incorrectpasswordshort'] = 'Нетачна лозинка, присуство није евидентирано.';
$string['indetail'] = 'Детаљније...';
$string['indicator:cognitivedepth'] = 'Присуство - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'Присуство\'.';
$string['indicator:cognitivedepthdef'] = 'Присуство - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуди \'Присуство\' током овог интервала анализе (Нивои = Без прегледа, Преглед)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Присуство - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'Присуство\'.';
$string['indicator:socialbreadthdef'] = 'Присуство - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуди \'Присуство\' током овог интервала анализе (Нивои = Без учешћа, Учесник сâм)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Морате одабрати акцију';
$string['invalidemails'] = 'Морате да наведете адресе постојећих корисничких налога, које није могуће пронаћи: {$a}';
$string['invalidimportfile'] = 'Формат датотеке је неисправан.';
$string['invalidsessionenddate'] = 'Овај датум не може бити пре датума почетка сесије';
$string['invalidsessionendtime'] = 'Време завршетка мора бити касније у односу на време почетка сесије';
$string['invalidstatus'] = 'Изабрали сте неисправан статус, покушајте поново';
$string['iptimemissing'] = 'Неисправна вредност времена (у минутима) за ослобађање IP адресе';
$string['jumpto'] = 'скочи на';
$string['keepsearching'] = 'Наставите претрагу';
$string['lasttaken'] = 'Последње обележена присуства';
$string['manualtriggerauto'] = 'Ручно активирајте аутоматско обележавање';
$string['marksessionimportcsvhelp'] = 'Овај образац вам омогућава да поставите csv датотеку која садржи идентификатор корисника и статус – поље статуса може бити акроним статуса или време када је евидентирано присуство за тог корисника. Ако је вредност за време исправна, онда ће се бити покушано да се додели статус са највишом оценом која је доступна у том тренутку.';
$string['maxpossible'] = 'Максимално могуће';
$string['maxpossible_help'] = 'Приказује резултат који сваки корисник може постићи ако добије максималан број поена за сваку сесију (прошлу и будућу) на којој присуство још није обележено:
  <ul>
    <li><strong>Поени</strong>: максималан број поене које сваки корисник може постићи за све сесије</li>
    <li><strong>Проценти</strong>: максималан проценат који сваки корисник може постићи за све сесије.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Максимални могући проценат';
$string['maxpossiblepoints'] = 'Максимални могући број поена';
$string['maxwarn'] = 'Максималан број упозорења послатих е-поштом';
$string['maxwarn_help'] = 'Одређује колико пута максимално треба да буде послато упозорење (шаље се само једно упозорење по сесији)';
$string['mergeuser'] = 'Споји корисника';
$string['messagedselecteduserfailed'] = 'Слање поруке једном или више корисника није успело. Укључите отклањање грешака да бисте сазнали више.';
$string['mobilesessionfrom'] = 'Прикажи сесије које су старије од';
$string['mobilesessionfrom_help'] = 'Ово подешавање омогућава да списак сесија, на којима се обележава присуство, буде ограничен – приказују се само сесије које су започете пре наведеног временског интервала';
$string['mobilesessionto'] = 'Прикажи будуће сесије';
$string['mobilesessionto_help'] = 'Омогућава да се списак сесија ограничи тако да приказује само мали број будућих сесија.';
$string['mobilesettings'] = 'Подешавања мобилне апликације';
$string['mobilesettings_help'] = 'Ова подешавања контролишу понашање Moodle мобилне апликације';
$string['modulename'] = 'Присуство';
$string['modulename_help'] = 'Модул активности \'Присуство\' омогућава наставнику да води евиденцију о присуству студената настави, а студентима да виде своје податке о присуству.

Наставник може да креира вишеструке сесије и обележи статус присуства настави као "Присутан/на", "Одсутан/на", "Закаснио/ла" или "Оправдано одсутан/на", Наставник може, такође, да модификује статусе сходно својим потребама.

Извештаји о присуству су доступни како за целу групу, тако и за појединачног студента.';
$string['modulenameplural'] = 'Присуства';
$string['months'] = 'Месеци';
$string['moreattendance'] = 'Присуство је успешно обележено за ову страницу';
$string['moveleft'] = 'Помери улево';
$string['moveright'] = 'Помери удесно';
$string['multisessionexpanded'] = 'Подешавања "Вишеструке сесије" проширена';
$string['multisessionexpanded_desc'] = 'Када креирате нове сесије прикажите подешавања "Вишеструке сесије" " стандардно проширена.';
$string['mustselectusers'] = 'Морате одабрати кориснике за извоз';
$string['name'] = 'Назив';
$string['newdate'] = 'Нови датум';
$string['newduration'] = 'Ново трајање';
$string['newstatusset'] = 'Нови скуп статуса';
$string['noabsentstatusset'] = 'Скуп статуса који се користи не поседује статус за полазнике чије приуство није обележено.';
$string['noattendanceusers'] = 'Није могућ извоз података пошто нема полазника уписаних на овај курс.';
$string['noattforuser'] = 'Не постоје записи о присуству за корисника';
$string['noautomark'] = 'Онемогућено';
$string['nocapabilitytotakethisattendance'] = 'Покушали сте да промените присуство сесији са cmid ознаком: {$a} за коју немате овлаћшење да мењате податке о присуству.';
$string['nodescription'] = 'Редовни час';
$string['noeventstoreset'] = 'Нема догађаја у календару који захтевају ажурирање.';
$string['nogroups'] = 'Ова активност је подешена да користи групе, али ниједна група не постоји на курсу.';
$string['noguest'] = 'Гости не могу да виде податке о присуству настави';
$string['noofdaysabsent'] = 'Број дана одсутности';
$string['noofdaysexcused'] = 'Број дана оправдане одсутности';
$string['noofdayslate'] = 'Број дана кашњења';
$string['noofdayspresent'] = 'Број дана присутности';
$string['nosessiondayselected'] = 'Број изабраних дана сесије';
$string['nosessionexists'] = 'Не постоји сесија за овај курс';
$string['nosessionsselected'] = 'Није изабрана ниједна сесија';
$string['notfound'] = 'Активност \'Присуство\' није пронађена на овом курсу!';
$string['notifytask'] = 'Слање упозорења корисницима';
$string['notmember'] = 'није&nbsp;члан';
$string['notset'] = 'није подешено';
$string['nounmarkedstatusset'] = 'Ниједан неозначени статус није конфигурисан за ову сесију (id:{$a->sessionid}); како бисте ово исправили ажурирајте  <a href="{$a->url}">Скуп статуса</a>';
$string['noupgradefromthisversion'] = 'Модул \'Присуство\' не може бити надограђен са претходне верзије ово додатка (attforblock) који сте инсталирали - молимо вас, обришите додатак attforblock или га надоградите на последњу верзију, пре него што инсталирате нови модул \'Присуство\'.';
$string['numsessions'] = 'Број сесија';
$string['olddate'] = 'Стари датум';
$string['onactivitycompletion'] = 'По завршетку активности';
$string['onlyselectedusers'] = 'Извези конкретне кориснике';
$string['overallsessions'] = 'Све сесије';
$string['overallsessions_help'] = 'Приказује статистику за све сесије укључујући и оне код којих присуство још није обележено (прошле и будуће):
    <ul>
    <li><strong>Сесије</strong>: укупан број сесија.</li>
    <li><strong>Поени</strong>: број поена освојених на основу сесија на којима је присуство обележено.</li>
    <li><strong>Проценат</strong>: проценат освојених поена у односу на максималан број могућих поена за све сесије.</li>
    </ul>';
$string['oversessionstaken'] = 'Сесије на којима је присуство обележено';
$string['oversessionstaken_help'] = 'Приказује статистику за сесије на којима је присуство обележено:
<li><strong>Сесије</strong>: број сесија на којима је присуство обележено.</li>
    <li><strong>Поени</strong>: број освојених поена на основу сесија на којима је присуство обележено.</li>
    <li><strong>Проценат</strong>: проценат освојених поена у односу на максималан могућ број поене за сесија на којима је присуство обележено.</li>
    </ul>';
$string['pageof'] = 'Страница {$a->page} од {$a->numpages}';
$string['participant'] = 'Учесник';
$string['password'] = 'Лозинка';
$string['passwordgrp'] = 'Лозинка полазника';
$string['passwordgrp_help'] = 'Ако је подешено, студенти ће морати да унесу ову лозинку пре него што буду могли да обележе сопствени статус присуства сесије. Ако је поље празно, лозинка није потребна.';
$string['passwordheader'] = 'Употребите лозинку доле наведену како бисте обележили своје присуство';
$string['passwordrequired'] = 'Морате унети лозинку сесије пре него што будете могли да обележите своје присуство';
$string['percentage'] = 'Проценат';
$string['percentageallsessions'] = 'Проценат за све сесије';
$string['percentagesessionscompleted'] = 'Проценат за сесије на којима је обележено присуство';
$string['pluginadministration'] = 'Администрација модула "Присуство"';
$string['pluginname'] = 'Присуство';
$string['points'] = 'Поени';
$string['pointsallsessions'] = 'Број поена за све сесије';
$string['pointssessionscompleted'] = 'Број поена за сесије на којима је обележено присуство';
$string['preferences_desc'] = 'Промене скупова статуса ће утицати на постојеће сесије и могу утицати на оцењивање.';
$string['preventsharederror'] = 'Само-обележавање је онемогућено за сесију јер се чини да је овај уређај већ коришћен за евидентирање присуства за другог полазника.';
$string['preventsharedip'] = 'Спречите полазнике да деле IP адресу';
$string['preventsharedip_help'] = 'Спречите полазнике да користе исти уређај (идентификован коришћењем IP адресе) како би обележили присуство других полазника.';
$string['preventsharediptime'] = 'Време након ког IP адреса може поново да се користи (минути)';
$string['preventsharediptime_help'] = 'Дозволите да се IP адреса поново користи за обележавање присуства на овој сесији након што протекне наведени временски период.';
$string['preview'] = 'Преглед датотеке';
$string['previewhtml'] = 'Преглед HTML формата';
$string['priorto'] = 'Датум одржавања сесије је ранији у односу на датум почетка курса ({$a}) па ће нове сесије заказане за пре тог датума бити сакривене (неће бити доступне). Можете променити датум почетка курса у било које доба (погледајте подешавања курса) да бисте имали приступ ранијим сесијама.<br><br>Молимо измените датум сесије или само кликните на дугме са натписом "Додај сесију" поново како бисте потврдили свој избор.';
$string['privacy:metadata:attendancelog'] = 'Eвиденција о присуствима корисника забележена.';
$string['privacy:metadata:attendancesessions'] = 'Сесије на којима ће присуство бити евидентирано.';
$string['privacy:metadata:attendancewarningdone'] = 'Запис упозорења послатих корисницима о евиденције њиховог присутва сесијама.';
$string['privacy:metadata:duration'] = 'Трајање сесије у секундама';
$string['privacy:metadata:groupid'] = 'ID ознака групе повезана са сесијом.';
$string['privacy:metadata:ipaddress'] = 'IP адреса са које је присуство забележено.';
$string['privacy:metadata:lasttaken'] = 'Временска ознака када је последњи пут обележено присуство сесији.';
$string['privacy:metadata:lasttakenby'] = 'ID ознака последњег корисника чије је присуство овој сесији обележено.';
$string['privacy:metadata:notifyid'] = 'ID ознака обавештења са којим је упозорење о присуству сесији повезано.';
$string['privacy:metadata:remarks'] = 'Коментари о присуству корисника.';
$string['privacy:metadata:sessdate'] = 'Временска ознака када сесија почиње.';
$string['privacy:metadata:sessionid'] = 'ID ознака сесије';
$string['privacy:metadata:statusid'] = 'ID ознака статуса присуства полазника.';
$string['privacy:metadata:statusset'] = 'Скуп статуса којем припада ID ознака статуса.';
$string['privacy:metadata:studentid'] = 'ID ознака полазника чије је присуство евидентирано.';
$string['privacy:metadata:takenby'] = 'ID ознака корисника који је евидентирао присуство полазника.';
$string['privacy:metadata:timemodified'] = 'Временска ознака када је сесија последњи пут измењена';
$string['privacy:metadata:timesent'] = 'Временска ознака када је упозорење послато.';
$string['privacy:metadata:timetaken'] = 'Временска ознака када је полазнику обележено присуство.';
$string['privacy:metadata:userid'] = 'ID ознака корисника коме треба послати упозорење.';
$string['processingfile'] = 'Обрада датотеке';
$string['qr_cookie_error'] = 'QR сесија је истекла.';
$string['qr_pass_wrong'] = 'QR лозинка је погрешна или је истекла.';
$string['qrcode'] = 'QR кôд';
$string['qrcodeandpasswordheader'] = 'Скенирајте QR кôд у наставку или употребите доле наведену лозинку како бисте обележили своје присуство';
$string['qrcodeheader'] = 'Скенирајте QR кôд у наставку како бисте обележили своје присуство';
$string['qrcodevalidafter'] = 'секунде';
$string['qrcodevalidbefore'] = 'QR кôд важи:';
$string['randompassword'] = 'Насумична лозинка';
$string['remark'] = 'Напомена за: {$a}';
$string['remarks'] = 'Напомене';
$string['repeatasfollows'] = 'Поновите горе наведену сесију на следећи начин';
$string['repeatevery'] = 'Поновите сваке';
$string['repeaton'] = 'Поновите на дан';
$string['repeatuntil'] = 'Поновите до';
$string['report'] = 'Извештај';
$string['reportsessiondate'] = 'Датум сесије';
$string['reportsessionduration'] = 'Трајање сесије';
$string['reportsessionlasttaken'] = 'Време када је последњи пут обележено присуство сесији (предавач)';
$string['required'] = 'Неопходно*';
$string['requiredentries'] = 'Привремени записи се преписују преко записа о присуству учесника';
$string['requiredentry'] = 'Водич за помоћ при спајању привремених корисника';
$string['requiredentry_help'] = '<p align="center"><b>Присуство</b></p>
<p align="left"><strong>Споји налоге</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle корисник</th>
<th>Привремени корисник</th>
<th>Акција</th>
</tr>
<tr>
<td>Подаци о присуству</td>
<td>Подаци о присуству</td>
<td>Привремени корисник ће бити преписан преко Moodle корисника</td>
</tr>
<tr>
<td>Нема података о присуству</td>
<td>Подаци о присуству</td>
<td>Присуство привременог корисника ће бити пренето Moodle кориснику</td>
</tr>
<tr>
<td>Подаци о присуству</td>
<td>Нема података о присуству</td>
<td>Привремени корисник ће бити обрисан</td>
</tr>
<tr>
<td>Нема података о присуству</td>
<td>Нема података о присуству</td>
<td>Привремени корисник ће бити обрисан</td>
</tr>
</table>

</p>
<p align="left"><strong>Привремени корисник ће бити обрисан у сваком случају после акције спајања</strong></p>';
$string['requiresubnet'] = 'Захтевај мрежну адресу';
$string['requiresubnet_help'] = 'Евидентирање присуства може бити ограничено на одређене подмреже навођењем списка делимичних или целих IP адреса раздвојених зарезима.';
$string['resetcaledarcreate'] = 'Креирање догађаја у календару је омогућенo, али одређени број постојећих сесија нема догађаје. Да ли желите да креирате догађаје у календару за све постојеће сесије?';
$string['resetcaledardelete'] = 'Креирање догађаја у календару је онемогућено, али одређени број постојећих сесија има догађаје које треба oбрисати. Да ли желите да обришете све постојеће догађаје?';
$string['resetcalendar'] = 'Ресетовање календара';
$string['resetdescription'] = 'Упамтите, брисање података о присуству ће обрисати информација из базе података. Можете само да сакријете старије сесије тако што ћете променити датум почетка курса!';
$string['resetstatuses'] = 'Ресетуј статусе на подразумеване вредности';
$string['restoredefaults'] = 'Врати подразумеване вредности';
$string['resultsperpage'] = 'Број резултата по страници';
$string['resultsperpage_desc'] = 'Број студената који ће бити приказани на једној страници';
$string['rotateqrcode'] = 'Ротирајте QR кôд';
$string['rotateqrcode_cleartemppass_task'] = 'Брисање привремених лозинки генерисаних функцијом ротирања QR кôда (задатак).';
$string['rotateqrcodeexpirymargin'] = 'Временска маргина истека ротације QR кôда/лозинке (секунде)';
$string['rotateqrcodeexpirymargin_desc'] = 'Временски интервал (у секундама) за омогућавање истека QR кôда/лозинке.';
$string['rotateqrcodeinterval'] = 'Интервал (у секундама) за ротацију QR кôда/лозинке';
$string['rotateqrcodeinterval_desc'] = 'Временски интервал (у секундама) за ротирање QR кôда/лозинке.';
$string['save'] = 'Сачувај податке о присуству';
$string['saveandshownext'] = 'Сачувај и прикажи следећу страницу';
$string['scantime'] = 'Време очитавања';
$string['scantime_help'] = 'Ово подешавање пружа могућност да временска ознака буде укључена у датотеку за увоз – ово ће покушати да конвертује временску ознаку која је прослеђена помоћу PHP функције strtotime, а затим ће користити подешавања статуса присуства како би се одлучило који статус ће бити подешен за корисника';
$string['search:activity'] = 'Присуство - информације о активности';
$string['selectactivity'] = 'Изабери активност';
$string['session'] = 'Сесија';
$string['session_help'] = 'Сесија';
$string['sessionadded'] = 'Сесија успешно додата';
$string['sessionalreadyexists'] = 'Сесија већ постоји за овај датум';
$string['sessiondate'] = 'Датум';
$string['sessiondays'] = 'Дани сесије';
$string['sessiondeleted'] = 'Сесија успешно обрисана';
$string['sessiondescription'] = 'Опис сесије';
$string['sessionduplicate'] = 'Постоји дупликат сесије на курсу: {$a->course}: за присуство {$a->activity}, {$a->date}';
$string['sessionexist'] = 'Сесија није додата (већ постоји)!';
$string['sessiongenerated'] = 'Једна сесија је успешно генерисана';
$string['sessions'] = 'Сесије';
$string['sessionsallcourses'] = 'Сви курсеви';
$string['sessionsbyactivity'] = 'Инстанца присуства';
$string['sessionsbycourse'] = 'Курс';
$string['sessionsbydate'] = 'Седмица';
$string['sessionscompleted'] = 'Сесије на којима је обележено присуство';
$string['sessionscurrentcourses'] = 'Текући курсеви';
$string['sessionsgenerated'] = 'Број успешно генерисаних сесија: {$a}';
$string['sessionsids'] = 'ID бројеви сесија:';
$string['sessionsnotfound'] = 'Нема сесија у изабраном временском периоду';
$string['sessionstartdate'] = 'Датум почетка сесије';
$string['sessionstotal'] = 'Укупан број сесија';
$string['sessionsupdated'] = 'Сесије су ажуриране';
$string['sessiontype'] = 'Врста';
$string['sessiontype_help'] = 'Постоје две врсте сесије: заједничка и групне. Могућност  да се додају различите врсте сесије зависи од групног режима активности.

* У режиму "Нема група" можете да додате само заједничке сесије.
* У режиму "Одвојене групе" можете да додате само групне сесије.
* У режиму "Видљиве групе" можете да додате и заједничке и групне сесије.';
$string['sessiontypeshort'] = 'Врста';
$string['sessionunknowngroup'] = 'Сесија наводи непознате групу/e: {$a}';
$string['sessionupdated'] = 'Сесија успешно ажурирана';
$string['set_by_student'] = 'Самостално евидентирање';
$string['setallstatuses'] = 'Подеси статус за';
$string['setallstatusesto'] = 'Подеси статус на «{$a}»';
$string['setperiod'] = 'Наведено време у минутима за ослобађање IP адресе';
$string['settings'] = 'Подешавања';
$string['setunmarked'] = 'Статус се аутоматски подешава када присуство није означено';
$string['setunmarked_help'] = 'Ако је омогућено ово подешавање унутар сесије, подесите овај статус ако полазник није означио своје присуство.';
$string['showdefaults'] = 'Прикажи подразумеване вредности';
$string['showduration'] = 'Прикажи трајање';
$string['showextrauserdetails'] = 'Прикажи додатне податке о кориснику';
$string['showqrcode'] = 'Прикажи QR кôд';
$string['showsessiondescriptiononreport'] = 'Прикажи опис сесије у извештају';
$string['showsessiondescriptiononreport_desc'] = 'Прикажите опис сесије на списку извештаја о присуству.';
$string['showsessiondetails'] = 'Прикажи детаље о сесији';
$string['somedisabledstatus'] = '(Неке опције су уклоњене пошто је сесија почела).';
$string['sortedgrid'] = 'Сортирана "мрежа"';
$string['sortedlist'] = 'Сортирани списак';
$string['startofperiod'] = 'Почетак временског периода';
$string['starttime'] = 'Време почетка';
$string['status'] = 'Статус';
$string['statusall'] = 'све';
$string['statusdeleted'] = 'Статус је обрисан';
$string['statuses'] = 'Статуси';
$string['statusset'] = 'Статус је подешен на {$a}';
$string['statussetsettings'] = 'Подешавање статуса';
$string['statusunselected'] = 'неизабрано';
$string['strftimedm'] = '%b %d';
$string['strftimedmw'] = '<nobr>%a %b %d</nobr>';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'ID број студента';
$string['studentmarked'] = 'Ваше присуство на овој сесији је евидентирано.';
$string['studentmarking'] = 'Евидентирање присуства од стране полазника';
$string['studentpassword'] = 'Лозинка полазника';
$string['studentrecordingexpanded'] = 'Подешавања "Евидентирање присуства од стране полазника" проширена';
$string['studentrecordingexpanded_desc'] = 'Када креирате нове сесије прикажите подешавања "Евидентирање присуства од стране полазника" стандардно проширена.';
$string['studentscanmark'] = 'Дозволи полазницима да самостално бележе своје присуство';
$string['studentscanmark_desc'] = 'Ако је означено, предавачи ће моћи да дозволе полазницима да сами забележе своје присуство.';
$string['studentscanmark_help'] = 'Ако је означено, полазници ће моћи сами да промене свој статус за присуство сесији.';
$string['studentscanmarksessiontime'] = 'Полазници бележе присуство током сесије';
$string['studentscanmarksessiontime_desc'] = 'Ако је означено, полазници могу да евидентирају само своје присуство током сесије.';
$string['studentscanmarksessiontimeend'] = 'Крај сесије (минути)';
$string['studentscanmarksessiontimeend_desc'] = 'Ако сесија нема подешено време завршетка, колико минута сесија треба да буде на располагању полазницима како би oбележили своје присуство.';
$string['studentsearlyopentime'] = 'Отворите сесију раније за обележавање присуства';
$string['studentsearlyopentime_help'] = 'Ово даје могућност предавачима да отворе сесију раније, омогућавајући тако да присуство буде обележено пре почетка сесије.';
$string['submit'] = 'Пошаљи';
$string['submitattendance'] = 'Пошаљи присуство';
$string['submitpassword'] = 'Пошаљи лозинку';
$string['subnet'] = 'Подмрежа';
$string['subnetactivitylevel'] = 'Дозволи конфигурацију подмреже на нивоу активности';
$string['subnetactivitylevel_desc'] = 'Ако је ова опција омогућена, предавачи могу да замене подразумевану подмрежу на нивоу активности када креирају присуство. У супротном ће се приликом креирања сесије користити подразумевани адреса сајта.';
$string['subnetwrong'] = 'Присуство може бити евидентирати само са одређених локација, а овај рачунар није на списку дозвољених.';
$string['summary'] = 'Резиме';
$string['tablerenamefailed'] = 'Промена старе "attforblock" табеле у нову "attendance" није успела';
$string['tactions'] = 'Акција';
$string['takeattendance'] = 'Евидентирај присуство';
$string['takensessions'] = 'Сесије на којима је обележено присуство';
$string['tcreated'] = 'Креирано';
$string['tempaddform'] = 'Додај привременог корисника';
$string['tempexists'] = 'Већ постоји привремени корисник са том адресом електронске поште';
$string['temptable'] = 'Списак привремених корисника';
$string['tempuser'] = 'Привремени корисник';
$string['tempusermerge'] = 'Споји привременог корисника';
$string['tempusers'] = 'Привремени корисници';
$string['tempusersedit'] = 'Уреди привременог корисника';
$string['tempuserslist'] = 'Привремени корисници';
$string['thirdpartyemails'] = 'Обавести друге кориснике';
$string['thirdpartyemails_help'] = 'Списак осталих корисника који ће бити обавештени (захтева способност mod/attendance:viewreports).';
$string['thirdpartyemailsubject'] = 'Упозорење о (не)присуствовању сесијама';
$string['thirdpartyemailtext'] = 'Присуство полазника {$a->firstname} {$a->lastname} на курсу {$a->coursename} {$a->aname} мање је од {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Ову поруку добијате јер је предавач на овом курсу вашу адресу е-поште додао на списак прималаца';
$string['thiscourse'] = 'Овај курс';
$string['time'] = 'Време';
$string['timeahead'] = 'Вишеструке сесије које трају дуже од годину дана не могу бити креиране. Молимо прилагодите томе датуме почетка и краја.';
$string['timemodified'] = 'Време измењено';
$string['timetaken'] = 'Време када је присуство обележено';
$string['to'] = 'до:';
$string['todate'] = 'до данас';
$string['triggered'] = 'Прво обавештен';
$string['tuseremail'] = 'Електронска пошта';
$string['tusername'] = 'Пуно име';
$string['ungraded'] = 'Неоцењене сесије';
$string['unknowngroup'] = 'Непозната група';
$string['unknownstatus'] = 'ID ознака непознатог статуса: {$a}';
$string['update'] = 'Ажурирај';
$string['uploadattendance'] = 'Поставите податке о присуствовању путем CSV датотеке';
$string['usedefaultsubnet'] = 'Користи подразумевану адресу';
$string['usemessageform'] = 'или употребите образац у наставку како бисте послали поруку изабраним полазницима';
$string['userexists'] = 'Већ постоји стварни корисник са том адресом електронске поште';
$string['userid'] = 'ID ознака корисника';
$string['userimportfield'] = 'Поље екстерног корисника';
$string['userimportfield_help'] = 'Поље из постављене CSV  датотеке које садржи идентификатор корисника';
$string['userimportto'] = 'Поље Moodle корисника';
$string['userimportto_help'] = 'Moodle поље које одговара подацима из експортоване CSV датотеке';
$string['users'] = 'Корисници за извоз';
$string['usersessiongrade'] = 'Оцена корисника за присуство сесијама';
$string['usersessionremarks'] = 'Напомене о сесији корисника';
$string['usersessiontaken'] = 'Корисничка сесија је обележена';
$string['userstatus'] = 'Статус корисничке сесије';
$string['usestatusset'] = 'Скуп статуса';
$string['variable'] = 'променљива';
$string['variablesupdated'] = 'Променљиве су успешно ажуриране';
$string['versionforprinting'] = 'верзија за штампу';
$string['viewmode'] = 'Режим приказа';
$string['warnafter'] = 'Број обележених сесија пре слања упозорења';
$string['warnafter_help'] = 'Упозорења ће бити активирана само када је корисник обележио присуство најмање за овај број сесија.';
$string['warningdeleted'] = 'Упозорење је обрисано';
$string['warningdesc'] = 'Ова упозорења ће бити аутоматска додата свакој новој активности \'Присуство\'. Ако се више од једног упозорења активира у исто време, биће послато само оно са нижим прагом.';
$string['warningdesc_course'] = 'Овде подешени прагови за упозорења утичу на извештај о одсуству и омогућавају да полазници и трећа лица буду обавештени. Ако се више од једног упозорења активира у исто време, биће послато само оно са нижим прагом.';
$string['warningfailed'] = 'Не можете креирати упозорење које користи исти проценат и број сесија.';
$string['warningpercent'] = 'Пошаљите упозорење ако проценат падне испод';
$string['warningpercent_help'] = 'Упозорење ће бити послато када укупан проценат падне испод овог броја.';
$string['warnings'] = 'Скуп упозорења';
$string['warningthreshold'] = 'Праг за упозорење';
$string['warningupdated'] = 'Ажурирана упозорења';
$string['week'] = 'седмица(е)';
$string['weekcommencing'] = 'Седмица започиње';
$string['weeks'] = 'Седмице';
$string['youcantdo'] = 'Не можете ништа да урадите';
