<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_xmldb', language 'sr_cr', version '4.0'.
 *
 * @package     tool_xmldb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actual'] = 'Стварно';
$string['addpersistent'] = 'Додај обавезна трајна поља';
$string['aftertable'] = 'Након табеле:';
$string['back'] = 'Назад';
$string['backtomainview'] = 'Повратак на главни приказ';
$string['cannotuseidfield'] = 'Није могуће уметнути "id" поље . Реч је о аутоматски нумерисаној колони.';
$string['change'] = 'Промени';
$string['charincorrectlength'] = 'Нисправна дужина поља карактера';
$string['check_bigints'] = 'Потрага за погрешним целобројним вредностима у бази података';
$string['check_defaults'] = 'Потрага за неконзистентним подразумеваним вредностима';
$string['check_foreign_keys'] = 'Потрага за прекршајима страних кључева';
$string['check_indexes'] = 'Потрага за индексима базе података који недостају';
$string['check_oracle_semantics'] = 'Потрага за семантиком погрешне дужине';
$string['checkbigints'] = 'Провери целобројне вредности';
$string['checkdefaults'] = 'Провери подразумеване вредности';
$string['checkforeignkeys'] = 'Провери стране кључеве';
$string['checkindexes'] = 'Провери индексе';
$string['checkoraclesemantics'] = 'Провери семантику';
$string['completelogbelow'] = '(погледај комплетан запис претраге)';
$string['confirmcheckbigints'] = 'Ова функционалност ће потражити <a href="https://tracker.moodle.org/browse/MDL-11038">потенцијално погрешна поља са целобројним вредностима</a> на вашем Moodle серверу, и аутоматски генерисати (али не и извршити!) потребне SQL наредбе како би све целобројне вредности у вашој бази података биле правилно дефинисане.

Једном, када су наредбе генерисане, можете их копирати и извршити безбедно у свом омиљеном SQL клијенту (не заборавите да претходно направите резервну копију података).

Више је него препоручљиво да користите најновију доступну, тзв. + верзију вашег издања Moodlea пре него што извршите претраживање погрешних целобројних вредности.

Ова функционалност не изводи било какве акције над вашом базом података (већ само чита из ње), тако да се може безбедно извршити у сваком тренутку.';
$string['confirmcheckdefaults'] = 'Ова функционалност ће потражити  неконзистентне подразумеване вредности на вашем Moodle серверу, и аутоматски генерисати (али не и извршити!) потребне SQL наредбе како би све подразумеване вредности биле правилно дефинисане.

Једном, када су наредбе генерисане, можете их копирати и извршити безбедно у свом омиљеном SQL клијенту (не заборавите да претходно направите резервну копију података).

Више је него препоручљиво да користите најновију доступну, тзв. + верзију вашег издања Moodlea пре него што извршите претраживање неконзистентних подразумеваних вредности.

Ова функционалност не изводи било какве акције над вашом базом података (већ само чита из ње), тако да се може безбедно извршити у сваком тренутку.';
$string['confirmcheckforeignkeys'] = 'Ова функционалност ће потражити потенцијалне прекршаје страних кључева дефинисаних у install.xml (Moodle тренутно не ствара ограничења актуелних страних кључева у бази података, због чега у њој могу бити присутни неисправни подаци.)

Више је него препоручљиво да користите најновију доступну, тзв. + верзију вашег издања Moodlea пре него што извршите претраживање потенцијалних прекршаја страних кључева.

Ова функционалност не изводи било какве акције над вашом базом података (већ само чита из ње), тако да се може безбедно извршити у сваком тренутку.';
$string['confirmcheckindexes'] = 'Ова функционалност ће потражити индексе који потенцијално недостају на вашем Moodle серверу, и аутоматски генерисати (али не и извршити!) потребне SQL наредбе како би све остало ажурно.

Једном, када су наредбе генерисане, можете их копирати и извршити безбедно у свом омиљеном SQL клијенту (не заборавите да претходно направите резервну копију података).

Више је него препоручљиво да користите најновију доступну, тзв. + верзију вашег издања Moodlea пре него што извршите претраживање индекса који недостају.

Ова функционалност не изводи било какве акције над вашом базом података (већ само чита из ње), тако да се може безбедно извршити у сваком тренутку.';
$string['confirmcheckoraclesemantics'] = 'Ова функционалност ће потражити <a href="https://tracker.moodle.org/browse/MDL-29322">Oracle varchar2 колоне које користе BYTE семантику</a на вашем Moodle серверу, и аутоматски генерисати (али не и извршити!) потребне SQL наредбе како би све колоне биле конвертоване за употребу CHAR семантике (која је боља за компатибилност између база података, као и за повећани садржај макс. дужине).

Једном, када су наредбе генерисане, можете их копирати и извршити безбедно у свом омиљеном SQL клијенту (не заборавите да претходно направите резервну копију података).

Више је него препоручљиво да користите најновију доступну, тзв. + верзију вашег издања Moodlea пре него што извршите претраживање BYTE семантике.

Ова функционалност не изводи било какве акције над вашом базом података (већ само чита из ње), тако да се може безбедно извршити у сваком тренутку.';
$string['confirmdeletefield'] = 'Да ли сте потпуно сигурни да желите да обришете поље?';
$string['confirmdeleteindex'] = 'Да ли сте потпуно сигурни да желите да обришете индекс?';
$string['confirmdeletekey'] = 'Да ли сте потпуно сигурни да желите да обришете кључ?';
$string['confirmdeletetable'] = 'Да ли сте потпуно сигурни да желите да обришете табелу?';
$string['confirmdeletexmlfile'] = 'Да ли сте потпуно сигурни да желите да обришете датотеку?';
$string['confirmrevertchanges'] = 'Да ли сте потпуно сигурни да желите да поништите промене које сте направили?';
$string['create'] = 'Креирај';
$string['createtable'] = 'Креирај табелу:';
$string['defaultincorrect'] = 'Нетачна подразумевана вредност';
$string['delete'] = 'Обриши';
$string['delete_field'] = 'Обриши поље';
$string['delete_index'] = 'Обриши индекс';
$string['delete_key'] = 'Обриши кључ';
$string['delete_table'] = 'Обриши табелу';
$string['delete_xml_file'] = 'Обриши XML датотеку';
$string['doc'] = 'Документација';
$string['docindex'] = 'Индекс документације:';
$string['documentationintro'] = 'Ова документација је аутоматски генерисана из дефиниције XMLDB базе података. Доступна је само на енглеском језику.';
$string['down'] = 'Доле';
$string['duplicate'] = 'Дуплирај';
$string['duplicatefieldname'] = 'Постоји још једно поље са тим називом';
$string['duplicatefieldsused'] = 'Користе се дупликати поља';
$string['duplicateindexname'] = 'Дупликат назива индекса';
$string['duplicatekeyname'] = 'Постоји још један кључ са тим називом';
$string['duplicatetablename'] = 'Постоји још једна табела са тим именом';
$string['edit'] = 'Уреди';
$string['edit_field'] = 'Уреди поље';
$string['edit_field_save'] = 'Сачувај поље';
$string['edit_index'] = 'Уреди индекс';
$string['edit_index_save'] = 'Сачувај индекс';
$string['edit_key'] = 'Уреди кључ';
$string['edit_key_save'] = 'Сачувај кључ';
$string['edit_table'] = 'Уреди табелу';
$string['edit_table_save'] = 'Сачувај табелу';
$string['edit_xml_file'] = 'Уреди XML датотеку';
$string['enumvaluesincorrect'] = 'Нетачна вредност за поље набрајања';
$string['expected'] = 'Очекивано';
$string['extensionrequired'] = 'Опростите - За ову акцију је неопходна PHP екстензија \'{$a}\'. Молимо вас да је инсталирате уколико желите да користите ову функцију.';
$string['extraindexesfound'] = 'Пронађени су додатни индекси';
$string['field'] = 'Поље';
$string['fieldnameempty'] = 'Поље назива је празно';
$string['fields'] = 'Поља';
$string['fieldsnotintable'] = 'Поље не постоји у табели';
$string['fieldsusedinindex'] = 'Ово поље се користи као индекс';
$string['fieldsusedinkey'] = 'Ово поље се користи као кључ.';
$string['filemodifiedoutfromeditor'] = 'Упозорење: Датотека је локално измењена док сте користили XMLDB едитор. Покушај да се датотека сачува ће поништити локалне измене.';
$string['filenotwriteable'] = 'У датотеку се не може ништа уписати';
$string['fkunknownfield'] = 'Страни кључ {$a->keyname} у табели {$a->tablename} показује на непостојеће поље {$a->reffield} у референцираној табели {$a->reftable}.';
$string['fkunknowntable'] = 'Страни кључ {$a->keyname} у табели {$a->tablename} показује на непостојећу табелу {$a->reftable}.';
$string['fkviolationdetails'] = 'Страни кључ {$a->keyname} у табели {$a->tablename} прекршен је од стране {$a->numviolations} од укупно {$a->numrows} редова.';
$string['float2numbernote'] = 'Напомена: иако су поља "с покретним зарезом" 100% подржана од стране XMLDB, препоручује се миграција на поља "бројеви".';
$string['floatincorrectdecimals'] = 'Неисправан број децимала у пољу за бројеве са покретним зарезом';
$string['floatincorrectlength'] = 'Неисправна дужина поља за бројеве са покретним зарезом';
$string['generate_all_documentation'] = 'Целокупна документација';
$string['generate_documentation'] = 'Документација';
$string['gotolastused'] = 'Иди на последње коришћену датотеку';
$string['incorrectfieldname'] = 'Нетачан назив';
$string['incorrectindexname'] = 'Погрешан назив индекса';
$string['incorrectkeyname'] = 'Неисправан назив кључа';
$string['incorrecttablename'] = 'Нетачан назив табеле';
$string['index'] = 'Индекс';
$string['indexes'] = 'Индекси';
$string['indexnameempty'] = 'Назив индекса је празан';
$string['integerincorrectlength'] = 'Нетачна дужина за поље са целобројним вредностима';
$string['key'] = 'Кључ';
$string['keynameempty'] = 'Назив кључа мора да се унесе';
$string['keys'] = 'Кључеви';
$string['listreservedwords'] = 'Списак резервисаних речи<br/>(који се користи за одржавање <a href="https://docs.moodle.org/en/XMLDB_reserved_words" target="_blank">XMLDB резервисане речи</a>)';
$string['load'] = 'Учитај';
$string['main_view'] = 'Главни приказ';
$string['masterprimaryuniqueordernomatch'] = 'Поља у вашем страном кључу морају бити наведена истим редоследом као што су наведена у ЈЕДИНСТВЕНОМ КЉУЧУ коришћене табеле.';
$string['missing'] = 'Недостаје';
$string['missingindexes'] = 'Пронађени су индекси који недостају';
$string['mustselectonefield'] = 'Морате да изаберете једно поље да бисте видели акције које се односе на поља!';
$string['mustselectoneindex'] = 'Морате да изаберете један индекс да бисте видели акције које се односе на индексе!';
$string['mustselectonekey'] = 'Морате изаберете један кључ да бисте видели акције које се односе на кључеве!';
$string['new_table_from_mysql'] = 'Нова табела из MySQL-а';
$string['newfield'] = 'Ново поље';
$string['newindex'] = 'Нови индекс';
$string['newkey'] = 'Нови кључ';
$string['newtable'] = 'Нова табела';
$string['newtablefrommysql'] = 'Нова табела из MySQL-а';
$string['nofieldsspecified'] = 'Нема специфицираних поља';
$string['nomasterprimaryuniquefound'] = 'Колона/е на које се односи ваш страни кључ морају бити укључене у примарни или јединствени КЉУЧ у референцираној табели. Имајте у виду да није довољно да колона има ЈЕДИНСТВЕНИ ИНДЕКС.';
$string['nomissingorextraindexesfound'] = 'Нису пронађени недостајући или додатни индекси, тако да нису потребне никакве даље акције.';
$string['noreffieldsspecified'] = 'Нема специфицираних поља референци';
$string['noreftablespecified'] = 'Специфицирана табела референци није пронађена';
$string['noviolatedforeignkeysfound'] = 'Нису пронађени прекршени страни кључеви';
$string['nowrongdefaultsfound'] = 'Нису пронађене нелогичне подразумеване вредности  - ваша база не захтева додатне интервенције.';
$string['nowrongintsfound'] = 'Нису пронађене погрешне целобројне вредности - ваша база не захтева додатне интервенције.';
$string['nowrongoraclesemanticsfound'] = 'Није пронађена ни једна Oracle колона која користи BYTE семантику - ваша база не захтева додатне интервенције.';
$string['numberincorrectdecimals'] = 'Нетачан број децимала за поље за број';
$string['numberincorrectlength'] = 'Нетачна дужина поља за број';
$string['numberincorrectwholepart'] = 'Превелика целобројна вредност за поље за број';
$string['pendingchanges'] = 'Напомена: Направили сте промене у овој датотеци. Промене могу бити сачуване у било ком тренутку.';
$string['pendingchangescannotbesaved'] = 'Постоје промене у овој датотеци али оне не могу бити сачуване! Молимо вас, проверите да ли директоријум и датотека "install.xml" унутар њега имају дозволе за уписивање, од стране веб сервера.';
$string['pendingchangescannotbesavedreload'] = 'Постоје промене у овој датотеци али оне не могу бити сачуване! Молимо вас, проверите да ли директоријум и датотека "install.xml" унутар њега имају дозволе за уписивање, од стране веб сервера.  Затим поново учитајте ову страницу, и требало би да можете да сачувате те промене.';
$string['persistentfieldscomplete'] = 'Додата су следећа поља:';
$string['persistentfieldsconfirm'] = 'Да ли желите да додате следећа поља:';
$string['persistentfieldsexist'] = 'Следећа поља већ постоје:';
$string['pluginname'] = 'XMLDB едитор';
$string['primarykeyonlyallownotnullfields'] = 'Примарни кључеви не могу имати null вредност';
$string['privacy:metadata'] = 'Додатак XMLDB едитор не чува никакве личне податке.';
$string['reconcile_files'] = 'Потражите XMLDB датотеке којима је потребно усклађивање';
$string['reconcile_files_intro'] = 'Ова функционалност прегледа садржај свих XMLDB датотека како би проверила да ли се поклапају са резултатима њиховог генерисања из XMLDB editora.

Биће приказана списак датотека које треба ускладити (регенерисати). Како би се поправиле датотеке може се користити XMLDB едитор.';
$string['reconcile_files_no'] = 'Све датотеке су у реду. Није потребно усклађивање.';
$string['reconcile_files_yes'] = 'Пронађене датотеке за усклађивање:';
$string['reconcilefiles'] = 'Ускладите XMLDB датотеке';
$string['reserved'] = 'Резервисано';
$string['reservedwords'] = 'Резервисане речи';
$string['revert'] = 'Поништи';
$string['revert_changes'] = 'Поништи промене';
$string['save'] = 'Сачувај';
$string['searchresults'] = 'Резултати претраге';
$string['selectaction'] = 'Изаберите акцију:';
$string['selectdb'] = 'Изаберите базу података:';
$string['selectfieldkeyindex'] = 'Изаберите поље/кључ/индекс:';
$string['selectonecommand'] = 'Молимо, изаберите једну акцију са списка да бисте видели PHP кôд';
$string['selectonefieldkeyindex'] = 'Молимо изаберите једно поље/кључ/индекс са списка да бисте видели PHP кôд';
$string['selecttable'] = 'Изаберите табелу:';
$string['table'] = 'Табела';
$string['tablenameempty'] = 'Назив табеле се мора унети';
$string['tables'] = 'Табеле';
$string['unknownfield'] = 'Упућује на непознато поље';
$string['unknowntable'] = 'Упућује на непознату табелу';
$string['unload'] = 'Испразни';
$string['up'] = 'Горе';
$string['view'] = 'Преглед';
$string['view_reserved_words'] = 'Погледај резервисане речи';
$string['view_structure_php'] = 'Погледај стурктуру PHP-а структуре';
$string['view_structure_sql'] = 'Погледај структуру SQL-а';
$string['view_table_php'] = 'Погледај табелу PHP-а';
$string['view_table_sql'] = 'Погледај табелу SQL-а';
$string['viewedited'] = 'Погледај уређене';
$string['vieworiginal'] = 'Погледај оригиналне';
$string['viewphpcode'] = 'Погледај PHP кôд';
$string['viewsqlcode'] = 'Погледај SQL кôд';
$string['viewxml'] = 'XML';
$string['violatedforeignkeys'] = 'Прекршени страни кључеви';
$string['violatedforeignkeysfound'] = 'Пронађени су прекршени страни кључеви';
$string['violations'] = 'Прекршаји';
$string['wrong'] = 'Погрешно';
$string['wrongdefaults'] = 'Пронађене погрешне подразумеване вредности';
$string['wrongints'] = 'Пронађене погрешнe целобројне вредности';
$string['wronglengthforenum'] = 'Нетачна дужина за поље набрајања';
$string['wrongnumberofreffields'] = 'Погрешан број поља референци';
$string['wrongoraclesemantics'] = 'Пронађена је погрешна Oracle BYTE семантика';
$string['wrongreservedwords'] = 'Тренутно коришћене резервисане речи<br />(имајте у виду да називи табела нису важни уколико користите $CFG->prefix)';
$string['yesextraindexesfound'] = 'Пронађени су следећи додатни индекси.';
$string['yesmissingindexesfound'] = '<p>У вашој бази података пронађени су индекси који недостају. Овде су детаљније информације о њима, као и SQL наредбе које треба извршити у вашем омиљеном SQL клијенту, како бисте креирали све индексе који недостају. Немојте заборавити да прво направите резервну копију података.</p>
<p>Након што то урадите, више је него препоручљиво да покренете овај алат поново како бисте проверили да више нема индекса који недостају. </p>';
$string['yeswrongdefaultsfound'] = '<p>У вашој бази података пронађене су неконзистентне подразумеване вредности. Овде су детаљније информације о њима, као и SQL наредбе које треба извршити у вашем омиљеном SQL клијенту, како бисте их све поправили. Немојте заборавити да прво направите резервну копију података.</p>
<p>Након што то урадите, више је него препоручљиво да покренете овај алат поново како бисте проверили да више нема неконзистентних подразумеваних вредности.</p>';
$string['yeswrongintsfound'] = '<p>У вашој бази података пронађене су погрешне целобројне вредности. Овде су детаљније информације о њима, као и SQL наредбе које треба извршити у вашем омиљеном SQL клијенту, како бисте их поправили. Немојте заборавити да прво направите резервну копију података!</p>
<p>Након што их поправите, више је него препоручљиво да покренете овај алат поново како бисте проверили да више нема погрешних целобројних вредности. </p>';
$string['yeswrongoraclesemanticsfound'] = '<p>У вашој Oracle бази података пронађене су колоне које користе BYTE семантику. Овде су детаљније информације о њима, као и SQL наредбе које треба извршити у вашем омиљеном SQL клијенту, како бисте конвертовали ове колоне. Немојте заборавити да прво направите резервну копију података.</p>
<p>Након што то урадите, више је него препоручљиво да покренете овај алат поново како бисте проверили да више нема колона које користе погрешну семантику.</p>';
