<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'eu', version '4.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'instalatzeko zorian';
$string['accept'] = 'Onartu';
$string['action'] = 'Ekintza';
$string['actionchoice'] = 'Zer egin nahi duzu \'{$a}\' fitxategiarekin?';
$string['actions'] = 'Ekintzak';
$string['actionsfor'] = '{$a}(e)rako ekintzak';
$string['actionsmenu'] = 'Ekintza-menua';
$string['active'] = 'Aktiboa';
$string['activeusers'] = 'Erabiltzaile aktiboak';
$string['activities'] = 'Jarduerak';
$string['activities_help'] = 'Foroak, galdetegiak eta wikiak bezalako jarduerek aukera ematen dute ikastaroan eduki interaktiboak gehitzeko.';
$string['activity'] = 'Jarduera';
$string['activityclipboard'] = 'Jarduera hau mugitzen: {$a}';
$string['activityheader'] = 'Jarduera-menua';
$string['activityiscurrentlyhidden'] = 'Sentitzen dugu, jarduera hau ezkutuan dago';
$string['activitymodule'] = 'Jarduera-modulua';
$string['activitymodules'] = 'Jarduera-moduluak';
$string['activityreport'] = 'Jardueraren txostena';
$string['activityreports'] = 'Jardueraren txostenak';
$string['activityselect'] = 'Aukeratu jarduera hau beste norabait joateko';
$string['activitysince'] = '{$a}(e)tik aurrerako aktibitatea';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Erabiltzaileen jardueraren txostenak';
$string['add'] = 'Gehitu';
$string['addactivity'] = 'Gehitu jarduera...';
$string['addactivitytosection'] = 'Gehitu jarduera bat \'{$a}\' atalean';
$string['addadmin'] = 'Gehitu kudeatzailea';
$string['addblock'] = 'Gehitu blokea';
$string['addcomment'] = 'Gehitu iruzkina...';
$string['addcountertousername'] = 'Sortu erabiltzailea erabiltzaile-izenari zenbakia gehituz';
$string['addcreator'] = 'Gehitu ikastaro-sortzailea';
$string['adddots'] = 'Gehitu...';
$string['added'] = '{$a} gehitu da';
$string['addedtogroup'] = '"{$a}" taldera gehitu da';
$string['addedtogroupnot'] = 'Talde honetara gehitu gabe: "{$a}"';
$string['addedtogroupnotenrolled'] = 'Talde honetara gehitu gabe: "{$a}"; izan ere, ikastaro honetan izena eman gabe dago.';
$string['addfilehere'] = 'Askatu fitxategiak hemen atal honetako azpiko aldean gehitzeko.';
$string['addinganew'] = '{$a} gehitzen';
$string['addinganewto'] = '{$a->what} gehitzen hona: {$a->to}';
$string['addingdatatoexisting'] = 'Datu berriak gehitzen';
$string['additionalcustomnav'] = 'Nabigazio pertsonalizatu gehigarria';
$string['additionalnames'] = 'Beste izen batzuk';
$string['addlinkhere'] = 'Gehitu esteka hemen';
$string['addnew'] = 'Gehitu {$a} berri bat';
$string['addnewcategory'] = 'Gehitu beste kategoria bat';
$string['addnewcourse'] = 'Gehitu ikastaro berria';
$string['addnewuser'] = 'Gehitu erabiltzaile berria';
$string['addnousersrecip'] = 'Gehitu {$a} jasotzaileen zerrendara sartu ez diren erabiltzaileak';
$string['addpagehere'] = 'Gehitu testua hemen';
$string['addresource'] = 'Gehitu baliabidea...';
$string['addresourceoractivity'] = 'Gehitu jarduera edo baliabidea';
$string['addresourcetosection'] = 'Gehitu baliabide bat \'{$a}\' atalean';
$string['address'] = 'Helbidea';
$string['addsections'] = 'Gehitu atalak';
$string['addstudent'] = 'Gehitu ikaslea';
$string['addsubcategory'] = 'Gehitu azpikategoria bat';
$string['addteacher'] = 'Gehitu irakaslea';
$string['admin'] = 'Kudeatzailea';
$string['adminhelpaddnewuser'] = 'Beste erabiltzaile-kontu bat eskuz sortzeko';
$string['adminhelpassignadmins'] = 'Kudeatzaileek edozer egin dezakete eta noranahi joan';
$string['adminhelpassigncreators'] = 'Ikastaro-sortzaileek ikastaroak sortu ahal dituzte';
$string['adminhelpassignsiteroles'] = 'Aplikatu gunerako definitutako rolak erabiltzaile jakinei';
$string['adminhelpassignstudents'] = 'Ikastaro batera joan eta ikasleak gaineratu kudeaketa menutik';
$string['adminhelpauthentication'] = 'Barne erabiltzaile-kontuak erabil ditzakezu edo kanpoko datu-baseak';
$string['adminhelpbackup'] = 'Konfiguratu segurtasun-kopia automatizatuak eta beren egutegia';
$string['adminhelpconfiguration'] = 'Konfiguratu webgunearen itxura eta ezarpenak';
$string['adminhelpconfigvariables'] = 'Konfiguratu webgunearen funtzionamendu orokorra baldintzatzen duten aldagaiak';
$string['adminhelpcourses'] = 'Zehaztu ikastaroak eta kategoriak eta esleitu ikasleak, editatu onarpenaren zain dauden ikastaroak';
$string['adminhelpeditorsettings'] = 'Ezarri HTML editorearen oinarrizko ezarpenak';
$string['adminhelpedituser'] = 'Ikusi erabiltzaile-kontuen zerrenda eta aldatu bat edo beste';
$string['adminhelpenvironment'] = 'Egiaztatu zure zerbitzaria oraingo eta geroko instalaziorako baldintzetara egokituta dagoen';
$string['adminhelpfailurelogs'] = 'Arakatu huts egindako saio-hasierak';
$string['adminhelplanguage'] = 'Hizkuntza-ezaugarriak ikusi eta aldatzeko';
$string['adminhelplogs'] = 'Ikusi webgune honetako jarduera guztietan zer gertatu den';
$string['adminhelpmanageblocks'] = 'Kudeatu instalatutako blokeak eta beren ezaugarriak';
$string['adminhelpmanagedatabase'] = 'Sartu datu-basera zuzenean. Kontuz!';
$string['adminhelpmanagefilters'] = 'Aukeratu testu-iragazkiak eta beren ezaugarriak';
$string['adminhelpmanagemodules'] = 'Kudeatu instalatutako moduluak eta beren ezaugarriak';
$string['adminhelpmanageroles'] = 'Sortu eta definitu erabiltzaileei aplikatzeko moduko rolak';
$string['adminhelpmymoodle'] = 'Konfiguratu \'Nire Moodle\' blokeak erabiltzaileentzat';
$string['adminhelpreports'] = 'Irizpide ezberdinen araberako ikastaroen sailkapena';
$string['adminhelpsitefiles'] = 'Fitxategi orokorrak argitaratu edo kanpoko segurtasun-kopiak eguneratzeko';
$string['adminhelpsitesettings'] = 'Zehaztu gunearen hasiera-orriaren itxura';
$string['adminhelpstickyblocks'] = 'Konfiguratu bloke finkoak Moodleren bidez';
$string['adminhelpthemes'] = 'Erabaki webgune osoaren itxura (koloreak, letra-motak, ...)';
$string['adminhelpuploadusers'] = 'Inportatu erabiltzaile berrien kontuak testu-fitxategi batetik';
$string['adminhelpusers'] = 'Zehaztu erabiltzaileak eta autentifikazio-modua';
$string['adminhelpxmldbeditor'] = 'XMLDB fitxategiak editatzeko interfazea. Soilik garatzaileentzat.';
$string['administration'] = 'Kudeaketa';
$string['administrationsite'] = 'Gunearen kudeaketa';
$string['administrator'] = 'Kudeatzailea';
$string['administratordescription'] = 'Kudeatzaileek gunean edozer egin dezakete, baita ikastaro guztietan ere.';
$string['administrators'] = 'Kudeatzaileak';
$string['administratorsall'] = 'Kudeatzaile guztiak';
$string['administratorsandteachers'] = 'Kudeatzaileak eta irakasleak';
$string['advanced'] = 'Aurreratua';
$string['advancedfilter'] = 'Bilaketa aurreratua';
$string['advancedsettings'] = 'Ezarpen aurreratuak';
$string['afterresource'] = '"{$a}" baliabidearen ondoren';
$string['aftersection'] = '"{$a}" atalaren ondoren';
$string['again'] = 'berriro';
$string['agelocationverification'] = 'Adina eta kokapenaren egiaztapena';
$string['aimid'] = 'ID AIM';
$string['ajaxuse'] = 'AJAX eta Javascript';
$string['all'] = 'Guztiak';
$string['allactions'] = 'Ekintza guztiak';
$string['allactivities'] = 'Jarduera guztiak';
$string['allcategories'] = 'Kategoria guztiak';
$string['allchanges'] = 'Aldaketa guztiak';
$string['alldays'] = 'Orain arteko guztiak';
$string['allfiles'] = 'Fitxategi guztiak';
$string['allgroups'] = 'Talde guztiak';
$string['alllogs'] = 'Agerraldi guztiak';
$string['allmods'] = '{$a} guztiak';
$string['allow'] = 'Baimendu';
$string['allowinternal'] = 'Baimendu barne-moduak ere';
$string['allownone'] = 'Bat ere ez baimendu';
$string['allownot'] = 'Ez baimendu';
$string['allowstealthmodules'] = 'Baimendu jarduera sekretuak';
$string['allowstealthmodules_help'] = 'Gaituz gero, jarduerak eskuragarri jarri daitezke baina ikastaroko orriko gaietan erakutsi gabe. Hori eginez gero, irakasleak jarduera sekretuetarako estekak beste nonbait jarri beharko ditu, esaterako orri batean. Jarduera sekretuak kalifikazio-txostenean eta bestelako txostenetan agertuko dira.';
$string['allparticipants'] = 'Partaide guztiak';
$string['allteachers'] = 'Irakasle guztiak';
$string['alphanumerical'] = 'Alfabetoaren letrak eta zenbakiak, gidoia (-) eta puntua (.) besterik ezin da erabili';
$string['alreadyconfirmed'] = 'Erregistroa dagoeneko baieztatuta';
$string['alternatename'] = 'Ordezko izena';
$string['always'] = 'Beti';
$string['and'] = '{$a->one} eta {$a->two}';
$string['answer'] = 'Erantzun';
$string['any'] = 'Edozein';
$string['appearance'] = 'Itxura';
$string['approve'] = 'Onartu';
$string['areyousure'] = 'Ziur zaude?';
$string['areyousuretorestorethis'] = 'Jarraitu nahi al duzu?';
$string['areyousuretorestorethisinfo'] = 'Geroago izango duzu aukera kopia hau ikastaro batean gaineratzeko edo ikastaro berri bat sortzeko';
$string['asc'] = 'Behetik gora';
$string['assessment'] = 'Ebaluazioa';
$string['assignadmins'] = 'Esleitu kudeatzaileak';
$string['assigncreators'] = 'Esleitu sortzaileak';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Esleitu gune mailako rolak';
$string['authenticateduser'] = 'Autentifikatutako erabiltzailea';
$string['authenticateduserdescription'] = 'Autentifikatutako erabiltzaile guztiak';
$string['authentication'] = 'Autentifikazioa';
$string['authenticationplugins'] = 'Autentifikazio-pluginak';
$string['autosubscribe'] = 'Izen-emate automatikoa foroan';
$string['autosubscribeno'] = 'Ez: ez nazazu foroetan automatikoki harpidetu';
$string['autosubscribeyes'] = 'Bai: harpidetu nazazu foroetako elkarrizketetara bertan idazten baldin badut';
$string['availability'] = 'Eskuragarritasuna';
$string['availablecourses'] = 'Eskuragarri dauden ikastaroak';
$string['back'] = 'Atzera';
$string['backto'] = 'Itzuli {$a}-ra';
$string['backtocourselisting'] = 'Itzuli ikastaro-zerrendara';
$string['backtohome'] = 'Itzuli gunearen hasiera-orrira';
$string['backtopageyouwereon'] = 'Itzuli aurretik zeunden orrira';
$string['backup'] = 'Segurtasun-kopia';
$string['backupactivehelp'] = 'Erabaki segurtasun-kopia automatizatuak egingo diren ala ez';
$string['backupadhocpending'] = 'Ikastaroaren segurtasun-kopia ad hoc ataza zain';
$string['backupcancelled'] = 'Segurtasun-kopia ezeztatuta';
$string['backupcoursefileshelp'] = 'Gaituz gero, ikastaroetako fitxategiak segurtasun-kopia automatizatuetan sartuko dira.';
$string['backupdate'] = 'Segurtasun-kopiaren data';
$string['backupdatenew'] = '{$a->TAG} orain {$a->weekday}, {$a->mday} {$a->month} {$a->year} da<br />';
$string['backupdateold'] = '{$a->TAG} lehen {$a->weekday}, {$a->mday} {$a->month} {$a->year} zen';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Segurtasun-kopiaren xehetasunak';
$string['backuperrorinvaliddestination'] = 'Segurtasun-kopiaren helmuga-karpeta ez da existitzen edo ez da idazteko modukoa.';
$string['backupexecuteathelp'] = 'Erabaki zein ordutan egingo diren segurtasun-kopia automatizatuak';
$string['backupfailed'] = 'Ikastaro batzuk gorde gabe gelditu dira!';
$string['backupfilename'] = 'segurtasun-kopia';
$string['backupfinished'] = 'Segurtasun-kopia ondo egin da';
$string['backupfromthissite'] = 'Segurtasun-kopia gune honetan egin al da?';
$string['backupgradebookhistoryhelp'] = 'Gaituz gero, kalifikazio-liburuen historia segurtasun-kopia automatizatuetan sartuko da. Ohartu kalifikazioen historia ezin dela desgaitu zerbitzariaren ezarpenetan (disablegradehistory) funtzionatu ahal izateko';
$string['backupincludemoduleshelp'] = 'Erabaki ikastaroetako moduluak, erabiltzaileen datuekin edo horiek gabe, sartu nahi dituzun segurtasun-kopia automatizatuetan.';
$string['backupincludemoduleuserdatahelp'] = 'Erabaki moduluen erabiltzaileen datuak sartu nahi dituzun segurtasun-kopia automatizatuetan.';
$string['backuplogdetailed'] = 'Segurtasun-kopiaren exekuzioaren erregistro zehatza';
$string['backuploglaststatus'] = 'Azken segurtasun-kopiaren exekuzioaren erregistroa';
$string['backupmissinguserinfoperms'] = 'Oharra: segurtasun-kopia honek erabiltzaile ez diren datuak ditu. Ariketa eta Tailerra jarduerak ez dira sartuko segurtasun-kopiak, modulu horiek ez baitira segurtasun-kopia mota honekin bateragarriak.';
$string['backupnext'] = 'Hurrengo segurtasun-kopia';
$string['backupnonisowarning'] = 'Kontuz: kopia hau Moodle bertsio ez Unicode (1.6aren aurretikoa) batetik dator. Kopiak ISO-8859-1 ez den edozein testu badu KALTETUA izan daiteke Moodleren Unicode bertsio honetara berreskuratzean. Ikusi <a href="https://docs.moodle.org/eu/FAQ_segurtasun-kopia_eta_berreskuratu">Segurtasun-kopia FAQ</a> segurtasun-kopia hau modu egokian egiteko informazio gehiago lortzeko.';
$string['backupnotyetrun'] = 'Segurtasun-kopia automatizatua egiteke';
$string['backuporiginalname'] = 'Segurtasun-kopiaren izena';
$string['backuproleassignments'] = 'Rol hauetarako rol-esleipenen segurtasun-kopia';
$string['backupsavetohelp'] = 'Segurtasun-kopiaren fitxategiak gorde nahi dituzun direktorioaren helbide osoa';
$string['backupsitefileshelp'] = 'Gaituz gero ikastaroetan erabilitako guneko fitxategiak segurtasun-kopia automatizatuetan sartuko dira.';
$string['backuptakealook'] = 'Mesedez, eman begiratu bat zure segurtasun-kopiaren erregistroei hemen: {$a}';
$string['backupuserfileshelp'] = 'Erabaki erabiltzaileen fitxategiak (profilaren irudiak, adibidez) segurtasun-kopia automatizatuetan sartu behar diren ala ez.';
$string['backupversion'] = 'Segurtasun-kopiaren bertsioa';
$string['badges'] = 'Dominak';
$string['block'] = 'Blokea';
$string['blockconfiga'] = '{$a} blokea ezartzen';
$string['blockconfigbad'] = 'Bloke hau ez da modu egokian sortu eta, beraz, ezin dira ezarpenak ezarri.';
$string['blocks'] = 'Blokeak';
$string['blocksaddedit'] = 'Gehitu/Editatu blokeak';
$string['blockseditoff'] = 'Desaktibatu blokeen edizioa';
$string['blocksediton'] = 'Aktibatu blokeen edizioa';
$string['blocksetup'] = 'Blokeko taulak sortzen';
$string['blocksuccess'] = '{$a} taulak ondo konfiguratu dira.';
$string['brief'] = 'Laburra';
$string['bulkactions'] = 'Eragiketa masiboak';
$string['bulkactionselect'] = '{$a} eragiketa masiboaren aukeraketa';
$string['bulkmovecoursessuccess'] = '{$a->courses} ikastaroak ondo mugitu dira {$a->category} kategoriara';
$string['bycourseorder'] = 'Ikastaro-ordenaren arabera';
$string['byname'] = '{$a}(r)en arabera';
$string['bypassed'] = 'Saihestua';
$string['cachecontrols'] = 'Cache-kontrolak';
$string['calltofeedback'] = 'Software honen egileek zure feedbacka izan nahiko lukete.';
$string['calltofeedback_give'] = 'Eman software honi buruzko feedbacka';
$string['calltofeedback_remind'] = 'Gogorarazi beranduago';
$string['cancel'] = 'Utzi';
$string['cancelled'] = 'Bertan behera utzi da';
$string['categories'] = 'Ikastaro-kategoriak';
$string['categoriesandcourses'] = 'Ikastaro-kategoriak eta ikastaroak';
$string['category'] = 'Kategoria';
$string['categoryadded'] = '\'{$a}\' kategoria gehitu da';
$string['categorybulkaction'] = 'Eragiketa masiboak aukeratutako kategorietarako';
$string['categorycontents'] = 'Azpikategoriak eta ikastaroak';
$string['categorycurrentcontents'] = '{$a}-ren edukiak';
$string['categorydeleted'] = '\'{$a}\' kategoria ezabatu da';
$string['categoryduplicate'] = '\'{$a}\' izeneko kategoria badago dagoeneko!';
$string['categoryheader'] = 'Kategoria-menua';
$string['categoryhidden'] = '(ezkutuan)';
$string['categorymodifiedcancel'] = 'Kategoria aldatu egin da! Mesedez, bertan behera utzi eta saiatu berriro.';
$string['categoryname'] = 'Kategoriaren izena';
$string['categorypath'] = 'Kategoria-bidea';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory}(r)en azpikategoria';
$string['categoryupdated'] = '\'{$a}\' kategoria eguneratu egin da';
$string['changedpassword'] = 'Aldatutako pasahitza';
$string['changepassword'] = 'Aldatu pasahitza';
$string['changesmade'] = 'Aldaketa egin dira';
$string['changesmadereallygoaway'] = 'Aldaketak egin dituzu. Ziur zaude irten eta aldaketak galdu nahi dituzula?';
$string['changessaved'] = 'Aldaketak gorde dira';
$string['check'] = 'Egiaztatu';
$string['checkactual'] = 'Oraingoa';
$string['checkall'] = 'Egiaztatu guztiak';
$string['checkexpected'] = 'Esperotakoa';
$string['checkingbackup'] = 'Segurtasun-kopia egiaztatzen';
$string['checkingcourse'] = 'Ikastaroa egiaztatzen';
$string['checkingforbbexport'] = 'Blackboard-erako esportazioa egiaztatzen';
$string['checkinginstances'] = 'Instantziak egiaztatzen';
$string['checkingsections'] = 'Atalak egiaztatzen';
$string['checklanguage'] = 'Egiaztatu hizkuntza';
$string['checknone'] = 'Ez egiaztatu ezer';
$string['checks'] = 'Egiaztapenak';
$string['checksok'] = '\'{$a}\' egiaztapen guztiak ondo joan dira';
$string['childcoursenotfound'] = 'Bigarren mailako ikastarorik ez da aurkitu!';
$string['childcourses'] = 'Bigarren mailako ikastaroak';
$string['choose'] = 'Aukeratu';
$string['choosecourse'] = 'Aukeratu ikastaro bat';
$string['choosedots'] = 'Aukeratu...';
$string['chooselivelogs'] = 'Edo zer ari den orain gertatzen ikusi';
$string['chooselogs'] = 'Aukeratu noren eta noizko agerraldia ikusi nahi duzun';
$string['choosereportfilter'] = 'Aukeratu txostenerako iragazkia';
$string['choosetheme'] = 'Aukeratu azala';
$string['chooseuser'] = 'Aukeratu erabiltzaile bat';
$string['city'] = 'Hiria/Herria';
$string['cleaningtempdata'] = 'Behin behineko datuak (TEMP) ezabatzen';
$string['clear'] = 'Garbitu';
$string['clearsearch'] = 'Garbitu bilaketa-testua';
$string['clickhelpiconformoreinfo'] = '... jarraitu ...Egin klik laguntza-ikonoan artikulu osoa irakurtzeko.';
$string['clickhere'] = 'Egin klik hemen...';
$string['clicktochangeinbrackets'] = '{$a} (Egin klik aldatzeko)';
$string['clicktohideshow'] = 'Egin klik zabaltzeko edo tolesteko';
$string['closeblockdrawer'] = 'Itxi blokeen nabigazio-kutxa';
$string['closebuttontitle'] = 'Itxi';
$string['closecourseindex'] = 'Itxi ikastaroaren aurkibidea';
$string['closedrawer'] = 'Itxi nabigazio-kutxa';
$string['closewindow'] = 'Itxi leiho hau';
$string['collapse'] = 'Tolestu';
$string['collapseall'] = 'Tolestu guztia';
$string['collapsecategory'] = 'Tolestu {$a}';
$string['commentincontext'] = 'Bilatu iruzkin hau testuinguruan';
$string['comments'] = 'Iruzkinak';
$string['commentscount'] = 'Iruzkinak: ({$a})';
$string['commentsnotenabled'] = 'Iruzkinak funtzioa ez dago gaituta';
$string['commentsrequirelogin'] = 'Saioa hasi behar duzu iruzkinak ikusi ahal izateko.';
$string['comparelanguage'] = 'Oraingo hizkuntza alderatu eta editatu';
$string['complete'] = 'Osatuta';
$string['completed'] = 'Osatuta';
$string['completereport'] = 'Txosten osoa';
$string['configuration'] = 'Ezarpenak';
$string['confirm'] = 'Baieztatu';
$string['confirmcheckfull'] = 'Erabat ziur al zaude {$a} baieztatu nahi duzula?';
$string['confirmcoursemove'] = 'Ziur zaude  ({$a->course}) ikastaroa  ({$a->category}) kategoriara mugitu nahi duzula?';
$string['confirmdeletesection'] = 'Ziur al zaude "{$a}" osorik ezabatu nahi duzula, baita dituen jarduera guztiak ere?';
$string['confirmed'] = 'Zure matrikulazioa berretsi da';
$string['confirmednot'] = 'Zure matrikulazioa oraindik berrestsi gabe dago. Mesedez bilatu ezazu berrespen e-mail bat zure sarrera-ontzian.';
$string['considereddigitalminor'] = 'Gazteegia zara gune honetan kontua sortzeko.';
$string['content'] = 'Edukia';
$string['contentbank'] = 'Eduki-bankua';
$string['contentexport_aboutthiscourse'] = 'Ikastaroaren laburpena';
$string['contentexport_coursesummary'] = 'Fitxategi hau <a href="{$a->courselink}">{$a->coursename}</a> ikastarotik deskargatutako edukiaren parte da.';
$string['contentexport_footersummary'] = 'Fitxategi hau {$a->userfullname} erabiltzaileak {$a->date} egunean <a href="{$a->courselink}">{$a->coursename}</a> ikastarotik deskargatutako edukiaren parte da.';
$string['contentexport_modulesummary'] = 'Orri hau  {$a->date} egunean <a href="{$a->modulelink}">{$a->modulename}</a> modulutik deskargatutako edukiaren parte da. Kontuan izan {$a->maxfilesize} baino handiagoak diren fitxategiak ez direla deskargatzen.';
$string['contentexport_viewfilename'] = 'Ikusi {$a} fitxategia';
$string['continue'] = 'Jarraitu';
$string['continuetocourse'] = 'Egin klik hemen ikastaroan sartzeko';
$string['convertingwikitomarkdown'] = 'Wikia Markdown-era bihurtzen';
$string['cookiesenabled'] = 'Cookie-ak gaituta izan behar dituzu zure nabigatzailean';
$string['cookiesenabled_help'] = 'Gune honek bi cookie erabiltzen ditu:

Funtsezko cookie-a saioarena da, normalean MoodleSession izena duena. Zure nabigatzailean cookie hau onartu behar duzu gunean nabigatzean jarraitasuna eman eta zure saioa mantendu dadin. Plataformatik irtetean edo nabigatzailea ixtean cookie-a deuseztatzen da (zure nabigatzailean eta zerbitzarian).

Beste cookie-a zure erraztasunerako da, normalean MOODLEID edo antzeko izena duena. Nabigatzailean duzun erabiltzaile-izena baino ez du gogoratzen. Honek esan nahi du berriz gunean sartzen zarenean zure erabiltzaile-izena automatikoki beteko dela sarbide-orriko eremu horretan. Ez dago arazorik cookie hau baztertzean - hori eginez gero sartzen zaren bakoitzean zure erabiltzaile-izena sartu besterik ez duzu egin beharko.';
$string['cookiesenabled_help_html'] = 'Gune honetan bi cookie erabiltzen dira:<br/><br/>

Funtsezko cookie-a saioarena da, normalean MoodleSession izena duena. Zure nabigatzailean cookie hau onartu behar duzu gunean nabigatzean jarraitasuna eman eta zure saioa mantendu dadin. Plataformatik irtetean edo nabigatzailea ixtean cookie-a deuseztatzen da (zure nabigatzailean eta zerbitzarian).<br/><br/>

Beste cookie-a zure erraztasunerako da, normalean MOODLEID edo antzeko izena duena. Nabigatzailean duzun erabiltzaile-izena baino ez du gogoratzen. Honek esan nahi du berriz gunean sartzen zarenean zure erabiltzaile-izena automatikoki beteko dela sarbide-orriko eremu horretan. Ez dago arazorik cookie hau baztertzean - hori eginez gero sartzen zaren bakoitzean zure erabiltzaile-izena sartu besterik ez duzu egin beharko.';
$string['cookiesenabledonlysession'] = 'Cookie-ak gaituta izan behar dituzu zure nabigatzailean';
$string['cookiesenabledonlysession_help'] = 'Gune honek saioaren kudeaketarako cookie bat erabiltzen du. Zure nabigatzailean cookie hau baimendu behar duzu nabigazioari jarraikortasuna eman eta gunearen barruan mantentzeko. Gunetik atera edo nabigatzailea ixten duzunean cookie hau ezabatzen da (zure nabigatzailean eta zerbitzarian).';
$string['cookiesnotenabled'] = 'Zoritxarrez, cookie-ak ez daude gaituta zure nabigatzailean';
$string['cookiesnotice'] = 'Cookie-n oharra';
$string['copy'] = 'kopiatu';
$string['copyasnoun'] = 'kopia';
$string['copycourse'] = 'Kopiatu ikastaroa';
$string['copyingcoursefiles'] = 'Ikastaroko fitxategiak kopiatzen';
$string['copyingsitefiles'] = 'Ikastaroan erabilitako guneko fitxategiak kopiatzen';
$string['copyinguserfiles'] = 'Erabiltzaileen fitxategiak kopiatzen';
$string['copyingzipfile'] = 'Zip-fitxategia kopiatzen';
$string['copyrightnotice'] = 'Copyright oharra';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Kostua';
$string['costdefault'] = 'Lehenetsitako kostua';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Herrialdea';
$string['course'] = 'Ikastaroa';
$string['courseadministration'] = 'Ikastaroaren kudeaketa';
$string['courseapprovedemail'] = 'Zure ikastaro-eskaria, {$a->name}, onartu egin da eta zu {$a->teacher} izendatua izan zara. Zure ikastaro berrira sartzeko hona joan: {$a->url}';
$string['courseapprovedemail2'] = 'Zure ikastaro-eskaria,  {$a->name}, onartu egin da. Zure ikastaro berrira sartzeko hona joan: {$a->url}';
$string['courseapprovedfailed'] = 'Zure ikastaroa ez da onartutzat gorde!';
$string['courseapprovedsubject'] = 'Zure ikastaroa onartu da!';
$string['courseavailable'] = 'Ikastaro hau ikasleentzat eskuragarri dago';
$string['courseavailablenot'] = 'Ikastaro hau ez dago eskuragarri ikasleentzat';
$string['coursebackup'] = 'Ikastaroaren segurtasun-kopia';
$string['coursebulkaction'] = 'Eragiketa masiboak aukeratutako kategorietarako';
$string['coursecategories'] = 'Ikastaro-kategoriak';
$string['coursecategory'] = 'Ikastaro-kategoria';
$string['coursecategory_help'] = 'Ezarpen honek adierazten du zein kategoriatan agertuko den ikastaroa ikastaroen zerrendan.';
$string['coursecategorydeleted'] = '{$a} ikastaro-kategoria ezabatu da';
$string['coursecatmanagement'] = 'Ikastaro eta kategorien kudeaketa';
$string['coursecompletion'] = 'Ikastaro-osaketa';
$string['coursecompletions'] = 'Ikastaro-osaketak';
$string['coursecreators'] = 'Ikastaro-sortzailea';
$string['coursecreatorsdescription'] = 'Ikastaro sortzaileek ikastaro berriak sor ditzakete.';
$string['coursedeleted'] = '{$a} ikastaroa ezabatu da';
$string['coursedetails'] = 'Ikastaro-xehetasunak';
$string['coursedisplay'] = 'Ikastaroaren diseinua';
$string['coursedisplay_help'] = 'Aukera honek ezartzen du ikastaro osoa orri bakarrean erakusten den ala hainbat orritan banatzen den.';
$string['coursedisplay_multi'] = 'Erakutsi atal bat orriko';
$string['coursedisplay_single'] = 'Erakutsi atal guztiak orri bakar batean';
$string['courseduration'] = 'Ikastaroaren iraupena';
$string['courseduration_desc'] = 'Ikastaroaren iraupena ikastaroaren lehenetsitako amaiera-data kalkulatzeko erabiltzen da. Ikastaroaren amaiera-data ikaslearen ikastaroen zerrendan erakutsi behar den erabakitzeko erabiltzen da. Neurrira egindako txostenetan ere erabili daiteke. Erabiltzaileek amaiera-dataren ondoren ikastaroan sartu ahal izango dute.';
$string['courseenddateenabled'] = 'Ikastaroaren amaiera-data modu lehenetsian gaituta';
$string['courseenddateenabled_desc'] = 'Ezarpen honek ikastaroaren amaiera-data ikastaro berrietan modu lehenetsian gaituta egongo den eta ikastaroaren iraupenaren bitartez kalkulatuko den zehazten du.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Heredatutako ikastaroko fitxategiak';
$string['coursefilesedit'] = 'Editatu heredatutako ikastaroko fitxategiak';
$string['coursefileswarning'] = 'Ikastaro-fitxategiak dagoeneko ez dira onartzen';
$string['coursefileswarning_help'] = 'Moodle 2.0-tik aurrera ikastaro-fitxategiak ez dira onartzen; mesedez, horren ordez kanpoko biltegiak erabili itzazu.';
$string['courseformatdata'] = 'Ikastaro-formatuaren datuak';
$string['courseformatoptions'] = 'Formatu aukerak {$a}(r)entzat';
$string['courseformats'] = 'Ikastaro-formatuak';
$string['courseformatudpate'] = 'Eguneratu formatua';
$string['coursegrades'] = 'Ikastaroaren kalifikazioak';
$string['courseheader'] = 'Ikastaro-menua';
$string['coursehelpcategory'] = 'Kokatu ikastaroa ikastaroen zerrenda eta horrela erraztu egingo diezu ikasleei biltzeko lana.';
$string['coursehelpforce'] = 'Behartu ikastaroan talde-modua ikastaroko edozein jardueretarako.';
$string['coursehelpformat'] = 'Ikastaroaren hasiera-orria formatu honetan erakutsiko da';
$string['coursehelphiddensections'] = 'Ikastaroko ezkutuko atalak ikasleei nola erakutsiko zaizkien.';
$string['coursehelpmaximumupload'] = 'Zehaztu ikastaro honetara igo daitezkeen fitxategien gehieneko tamaina, gune mailako ezarpenak mugatutakoa.';
$string['coursehelpnewsitemsnumber'] = 'Ikastaroaren hasiera-orriko azken albisteak blokean agertuko diren azken albisteen kopurua. 0 ezarriz gero, blokea ez da sortuko.';
$string['coursehelpnumberweeks'] = 'Ikastaroaren aste/gai-kopurua (soilik ikastaro formatu zehatz batzuetan du eragina).';
$string['coursehelpshowgrades'] = 'Gaitu kalifikazio-liburua erakustea. Ez du galarazten kalifikazioak jarduera bakoitzean ere agertzea.';
$string['coursehidden'] = 'Ikastaroa ez dago eskuragarri ikasleentzat';
$string['courseinfo'] = 'Ikastaroaren informazioa';
$string['courselegacyfiles'] = 'Heredatutako Ikastaroko fitxategiak';
$string['courselegacyfiles_help'] = 'Ikastaroko fitxategien guneak eskaintzen du nolabaiteko bateragarritasuna Moodle 1.9 eta zaharragoekin. Gune honetako fitxategiak ikastaroko ikasleentzat eskuragarriak izango dira beti (nahiz estekatu ala ez), eta ezin da jakin non erabiltzen diren Moodle barruan.

Gune hau erabiltzen baduzu ikastaroko fitxategiak gordetzeko, pribatutasun eta segurtasun-arriskuak izan ditzakezu; halaber, gerta liteke fitxategiak galtzea babes-kopietan, ikastaroak inportatzerakoan eta edukiak partekatzerakoan edo berrerabiltzerakoan. Beraz, egiten ari zarena ondo ulertzen ez baduzu, ez da gomendagarria gune hau erabiltzea.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Heredatutako ikastaroko fitxategiak: {$a}';
$string['coursenotaccessible'] = 'Soilik ikastaro honetan matrikulatutakoak sar daitezke';
$string['courseoverview'] = 'Ikastaroen ikuspegi orokorra';
$string['courseoverviewfiles'] = 'Ikastaroko irudia';
$string['courseoverviewfiles_help'] = 'Ikastaroko irudia Aginte-paneleko ikastaroaren aurrebistan erakusten dira. Guneko kudeatzaile batek onartutako fitxategi-mota gehigarriak eta fitxategi anizkoitzak gaitu ditzake. Hala eginez gero, fitxategi horiek ikastaroaren laburpenaren ondoan erakutsiko dira ikastaroen zerrenda-orrian.';
$string['courseoverviewfilesext'] = 'Ikastaroko irudi-fitxategien luzapenak';
$string['courseoverviewfileslimit'] = 'Ikastaroaren irudi-fitxategien muga';
$string['courseoverviewgraph'] = 'Ikastaroaren grafiko globala';
$string['coursepreferences'] = 'Ikastaro-hobespenak';
$string['courseprofiles'] = 'Ikastaroetako profilak';
$string['coursereasonforrejecting'] = 'Ikastaro-eskaria ez onartzeko arrazoiak';
$string['coursereasonforrejectingemail'] = 'Hau posta elektroniko bidez bidaliko zaio eskatzaileari';
$string['coursereject'] = 'Ez onartu ikastaro-eskaria';
$string['courserejected'] = 'Ikastaroa ez da onartu eta hala jakinarazi zaio eskatzaileari.';
$string['courserejectemail'] = 'Sentitzen dugu, baina eskatu duzun ikastaroa ez da onartu arrazoi honengatik:

{$a}';
$string['courserejectreason'] = 'Ikastaro hau ez onartzeko zure arrazoiak idatzi<br/>(eskatzaileari posta elektroniko bidez bidali egingo zaizkio)';
$string['courserejectsubject'] = 'Zure ikastaroa ez da onartu';
$string['coursereport'] = 'Ikastaroaren txostena';
$string['coursereports'] = 'Ikastaroaren txostenak';
$string['courserequest'] = 'Ikastaro-eskaria';
$string['courserequestdetails'] = 'Eskatzen ari zaren ikastaroaren xehetasunak';
$string['courserequestfailed'] = 'Zure ikastaro-eskaria arrazoi ezezagunengatik ezin izan da gorde';
$string['courserequestintro'] = 'Erabili formulario hau ikastaroa sortzeko eskaria egiteko.<br />Kudeatzaileek ikastaroa zergatik eskatzen duzun jakin dezaten<br />ahalik eta informazio gehien eman, mesedez.';
$string['courserequestreason'] = 'Ikastaroa eskatzeko arrazoiak';
$string['courserequestsuccess'] = 'Ikastaro-eskaria ondo gorde da. Gutxi barru erantzuna  posta elektroniko bidez bidaliko zaizu eskaria onartu den edo ez jakinarazteko.';
$string['courserequestsupport'] = 'Informazio lagungarria kudeatzaileak eskari hau ebaluatzeko';
$string['courserequestwarning'] = 'Ikastaro honetan sartzeko eskatu duen erabiltzailea automatikoki matrikulatuko da eta {$a} rola esleituko zaio.';
$string['courserestore'] = 'Ikastaroa berreskuratu';
$string['coursereuse'] = 'Ikastaro-berrerabilpena';
$string['courses'] = 'Ikastaroak';
$string['coursesearch'] = 'Bilatu ikastaroak';
$string['coursesearch_help'] = 'Hitz asko batera bila ditzakezu eta bilaketak horrela findu ditzakezu:

* Hitz bat baino gehiago idaztekotan, bilatzaileak hitz horiek edonon dauzkaten emaitzak bilatuko ditu
* Hitz batzuk (+) ikurrak bananduta idatziz gero, hitz horiek guztiak orden berean duten emaitza guztiak erakutsiko dira.
* (-) ikurra hitzaren aurretik jarriz gero, hitz hori duten emaitzak ez dira erakutsiko.</p>';
$string['coursesectionsummaries'] = 'Ikastaro-atalen laburpenak';
$string['coursesectiontitle'] = 'Ikastaroa: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Ikastaroaren ezarpen lehenetsiak';
$string['coursesmovedout'] = '{$a}-tik kanpora mugitutako ikastaroak';
$string['coursespending'] = 'Onarpenaren zain dauden ikastaroak';
$string['coursestart'] = 'Ikastaro-hasiera';
$string['coursesummary'] = 'Ikastaroaren laburpena';
$string['coursesummary_help'] = 'Ikastaroaren laburpena ikastaroen zerrendan erakusten da. Ikastaroen bilaketak laburpenen testuetan bilatzen du eta baita ikastaroen izenetan ere.';
$string['coursetitle'] = 'Ikastaroa: {$a->course}';
$string['courseupdates'] = 'Ikastaroen eguneraketak';
$string['coursevisibility'] = 'Ikastaroaren ikusgarritasuna';
$string['coursevisibility_help'] = 'Ezarpen honek ikastaroa ikastaro-zerrendetan agertuko den eta ikasleak sartu ahal izango diren zehazten du. \'Ezkutatu\' aukeratuz gero, soilik ikastaro ezkutuak ikusteko gaitasuna duten erabiltzaileek izango dute sarbidea (irakasleak adibidez).';
$string['create'] = 'Sortu';
$string['createaccount'] = 'Sortu nire kontu berria';
$string['createcategory'] = 'Sortu kategoria';
$string['createfolder'] = 'Sortu karpeta hemen: {$a}';
$string['createnew'] = 'Sortu beste bat';
$string['createnewcategory'] = 'Sortu beste kategoria bat';
$string['createnewcourse'] = 'Sortu beste ikastaro bat';
$string['createnewsubcategory'] = 'Sortu beste azpikategoria bat';
$string['createsubcategoryof'] = 'Sortu {$a}(r)en azpikategoria';
$string['createuser'] = 'Sortu erabiltzailea';
$string['createuserandpass'] = 'Aukeratu zure erabiltzaile-izena eta pasahitza';
$string['createziparchive'] = 'Sortu zip-fitxategia';
$string['creatingblocks'] = 'Blokeak sortzen';
$string['creatingblocksroles'] = 'Bloke mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingblogsinfo'] = 'Blogen informazioa sortzen';
$string['creatingcategoriesandquestions'] = 'Kategoriak eta galderak sortzen';
$string['creatingcoursemodules'] = 'Ikastaro-moduluak sortzen';
$string['creatingcourseroles'] = 'Ikastaro mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingevents'] = 'Ekitaldiak sortzen';
$string['creatinggradebook'] = 'Kalifikazio-liburua sortzen';
$string['creatinggroupings'] = 'Talde-multzoak sortzen';
$string['creatinggroupingsgroups'] = 'Taldeak talde-multzoetara gehitzen';
$string['creatinggroups'] = 'Taldeak sortzen';
$string['creatinglogentries'] = 'Erregistro-sarrerak sortzen';
$string['creatingmessagesinfo'] = 'Informazio-mezuak sortzen';
$string['creatingmodroles'] = 'Modulu mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingnewcourse'] = 'Ikastaro berria sortzen';
$string['creatingrolesdefinitions'] = 'Rolen definizioak sortzen';
$string['creatingscales'] = 'Eskalak sortzen';
$string['creatingsections'] = 'Atalak sortzen';
$string['creatingtemporarystructures'] = 'Denbora-egiturak sortzen';
$string['creatinguserroles'] = 'Erabiltzaile mailako rol ezarpenak eta baliogabetzeak sortzen';
$string['creatingusers'] = 'Erabiltzaileak sortzen';
$string['creatingxmlfile'] = 'XML fitxategia sortzen';
$string['currency'] = 'Moneta';
$string['currentcourse'] = 'Oraingo ikastaroa';
$string['currentcourseadding'] = 'Datuak gehitzen ikastaro honetara';
$string['currentcoursedeleting'] = 'Oraingo ikastaroa ezabatzen lehenik';
$string['currentlanguage'] = 'Oraingo hizkuntza';
$string['currentlocaltime'] = 'bertako ordua';
$string['currentpicture'] = 'Oraingo argazkia';
$string['currentrelease'] = 'Oraingo bertsioari buruzko informazioa';
$string['currentversion'] = 'Oraingo bertsioa';
$string['databasechecking'] = 'Moodleko datu-basea eguneratzen {$a->oldversion}(e)tik {$a->newversion}(e)ra';
$string['databaseperformance'] = 'Datu-basearen errendimendua';
$string['databasesetup'] = 'Datu-basea ezartzen';
$string['databasesuccess'] = 'Datu-basea ondo eguneratu da';
$string['databaseupgradebackups'] = 'Segurtasun-kopiaren orain bertsioa {$a} da';
$string['databaseupgradeblocks'] = 'Blokeen bertsioa orain {$a} da';
$string['databaseupgradegroups'] = 'Taldeen bertsioa {$a} da orain';
$string['databaseupgradelocal'] = 'Datu-base lokalaren pertsonalizazio-bertsioa zera da: {$a}';
$string['databaseupgrades'] = 'Datu-basea eguneratzen';
$string['dataformats'] = 'Datu-formatuak';
$string['date'] = 'Data';
$string['datechanged'] = 'Data aldatuta';
$string['datemostrecentfirst'] = 'Data - berrienak lehenak';
$string['datemostrecentlast'] = 'Data - berrienak azkenak';
$string['day'] = 'egun';
$string['days'] = 'egun';
$string['decodinginternallinks'] = 'Barneko estekak dekodifikatzen';
$string['default'] = 'Lehenetsitakoa';
$string['defaultcategoryname'] = 'Kategoria 1';
$string['defaultcompetencescale'] = 'Lehenetsitako konpetentzia-eskala';
$string['defaultcompetencescaledesc'] = 'Puntuazio eskala bitarra, norbaitek gaitasun bat erakutsi duen baino ez duena erakusten.';
$string['defaultcompetencescalenotproficient'] = 'Oraindik ez da gai';
$string['defaultcompetencescaleproficient'] = 'Gai da';
$string['defaultcoursestudent'] = 'Ikaslea';
$string['defaultcoursestudentdescription'] = 'Ikasleek oro har ikastaro baten barruan baimen gutxi dute';
$string['defaultcoursestudents'] = 'Ikasleak';
$string['defaultcoursesummary'] = 'Idatzi paragrafo labur eta interesgarri bat ikastaroaren nondik norakoen azalpen labur gisa';
$string['defaultcourseteacher'] = 'Irakaslea';
$string['defaultcourseteacherdescription'] = 'Irakasleek edozer egin dezakete ikastaro batean, baita ikasleen jarduerak eta kalifikazioak aldatu ere.';
$string['defaultcourseteachers'] = 'Irakasleak';
$string['defaulteditor'] = 'Lehenetsitako editorea';
$string['defaulthomepageuser'] = 'Hasiera orria';
$string['defaulthomepageuser_help'] = 'Zein orrira bideratuko zaitugu gunean saioa hasterakoan?';
$string['delete'] = 'Ezabatu';
$string['deleteablock'] = 'Ezabatu blokea';
$string['deleteall'] = 'Ezabatu guztia';
$string['deleteallcannotundo'] = 'Ezabatu guztia - ezin da desegin';
$string['deleteallcomments'] = 'Ezabatu iruzkin guztiak';
$string['deleteallratings'] = 'Ezabatu puntuazio guztiak';
$string['deletecategory'] = 'Ezabatu kategoria: {$a}';
$string['deletecategorycheck'] = 'Ziur al zaude <b>\'{$a}\'</b> kategoria erabat ezabatu nahi duzula?<br />Honek goragoko kategoriara mugituko ditu ikastaroak, halakorik balego, edo Saski-naskira.';
$string['deletecategorycheck2'] = 'Kategoria hau ezabatzen baduzu, erabaki beharko duzu barruan dauden ikastaro eta azpikategoriekin zer egin';
$string['deletecategoryempty'] = 'Kategoria hau hutsik dago.';
$string['deletecheck'] = 'Ezabatu {$a}?';
$string['deletecheckfiles'] = 'Ziur al zaude fitxategi hauek ezabatu nahi dituzula?';
$string['deletecheckfull'] = 'Ziur al zaude {$a} erabiltzailea guztiz ezabatu nahi duzula, bere matrikulazioak, aktibitatea eta bestelako erabiltzaile-datuak barne?';
$string['deletechecktype'] = 'Ziur zaude {$a->type} ezabatu nahi duzula?';
$string['deletechecktypename'] = 'Ziur zaude "{$a->name}" {$a->type} ezabatu nahi duzula?';
$string['deletecheckwarning'] = 'Fitxategi hauek ezabatu egingo dituzu';
$string['deletecommentbyon'] = 'Ezabatu {$a->user}-(k) argitaratutako iruzkina {$a->time} datan';
$string['deletecompletely'] = 'Guztiz ezabatu';
$string['deletecourse'] = 'Ezabatu ikastaro bat';
$string['deletecoursecheck'] = 'Ziur al zaude ikastaro hau eta bere eduki guztiak guztiz ezabatu nahi dituzula?';
$string['deleted'] = 'Ezabatuta';
$string['deletedactivity'] = '{$a} ezabatuta';
$string['deletedcourse'] = '{$a} guztiz ezabatu da';
$string['deletednot'] = 'Ezin izan da {$a} ezabatu!';
$string['deletepicture'] = 'Ezabatu';
$string['deletesection'] = 'Ezabatu atala';
$string['deleteselected'] = 'Ezabatu aukeratutakoa';
$string['deleteselectedkey'] = 'Ezabatu aukeratutako gakoa';
$string['deletingcourse'] = '{$a} ezabatzen';
$string['deletingexistingcoursedata'] = 'Ikastaroko datuak ezabatzen';
$string['deletingolddata'] = 'Datu zaharrak ezabatzen';
$string['department'] = 'Departamentua';
$string['deprecatedeventname'] = '{$a} (dagoeneko ez da erabiltzen)';
$string['desc'] = 'Goitik behera';
$string['description'] = 'Deskribapena';
$string['descriptiona'] = 'Deskribapena: {$a}';
$string['deselectall'] = 'Desmarkatu guztiak';
$string['deselectnos'] = 'Desmarkatu \'Ez\' guztiak';
$string['detailedless'] = 'Orokorrago';
$string['detailedmore'] = 'Zehatzago';
$string['details'] = 'Xehetasunak';
$string['digitalminor'] = 'Digitalki adin txikikoa';
$string['digitalminor_desc'] = 'Eska iezaiozu zure guraso/tutore bati hurrengo pertsonarekin harremanetan jartzeko:';
$string['directory'] = 'Direktorioa';
$string['disable'] = 'Desgaitu';
$string['disabledcomments'] = 'Iruzkinak desgaituta daude';
$string['dismissnotification'] = 'Baztertu jakinarazpen hau';
$string['displayingfirst'] = 'Soilik lehenengo {$a->count} {$a->things} erakusten dira';
$string['displayingrecords'] = '{$a} elementu erakusten';
$string['displayingusers'] = 'Ikasleak erakusten {$a->start}, lehena; {$a->end}, azkena';
$string['displayonpage'] = 'Erakutsi orrian';
$string['dndcourse'] = 'Ikastaro hau hartu eta eraman dezakezu ordena aldarazteko edo beste kategoria batera mugitzeko.';
$string['dndenabled_inbox'] = 'Fitxategiak gehitzeko, hartu eta eraman ahal dituzu.';
$string['dndnotsupported'] = 'Hartu eta eraman bidezko igoera ez da onartzen';
$string['dndnotsupported_help'] = 'Zure nabigatzaileak ez du onartzen hartu eta eraman bidezko igoera. Aukera honek funtzionatzen du Chrome-ren, Firefox-en eta Safari-ren azken bertsio guztietan, baita ere Internet Explorer v10-etik gorakoetan.';
$string['dndnotsupported_insentence'] = '\'hartu eta eraman\' ez da onartzen';
$string['dnduploadwithoutcontent'] = 'Igotakoak ez du edukirik';
$string['dndworkingfile'] = 'Hartu eta eraman fitxategiak ikastaro-ataletara igotzeko';
$string['dndworkingfilelink'] = 'Hartu eta eraman fitxategiak edo estekak ikastaro-ataletara igotzeko';
$string['dndworkingfiletext'] = 'Hartu eta eraman fitxategiak edo testua ikastaro-ataletara igotzeko';
$string['dndworkingfiletextlink'] = 'Hartu eta eraman fitxategiak, testua edo estekak ikastaro-ataletara igotzeko';
$string['dndworkinglink'] = 'Hartu eta eraman estekak ikastaro-ataletara igotzeko';
$string['dndworkingtext'] = 'Hartu eta eraman testua ikastaro-ataletara igotzeko';
$string['dndworkingtextlink'] = 'Hartu eta eraman testua edo estekak ikastaro-ataletara igotzeko';
$string['documentation'] = 'Moodleren dokumentazioa';
$string['dontsortcategories'] = 'Ez ordenatu kategoriak';
$string['dontsortcourses'] = 'Ez ordenatu ikastaroak';
$string['down'] = 'Jaitsi';
$string['download'] = 'Jaitsi';
$string['downloadall'] = 'Jaitsi dena';
$string['downloadexcel'] = 'Excel-formatuan jaitsi';
$string['downloadfile'] = 'Fitxategia jaitsi';
$string['downloadods'] = 'ODS formatuan jaitsi';
$string['downloadtext'] = 'Testu-formatuan jaitsi';
$string['doyouagree'] = 'Baldintza hauek irakurri eta ulertu dituzu?';
$string['droptoupload'] = 'Fitxategiak igotzeko hona ekarri';
$string['duplicate'] = 'Bikoiztu';
$string['duplicatedmodule'] = '{$a} (kopia)';
$string['edhelpaspellpath'] = 'Editorearen barruan ortografia-zuzentzailea erabiltzeko, <strong>aspell 0.50</strong> edo bertsio zaharragoa instalatuta izan behar duzu, eta aspell bikoitzaren bide egokia adierazi behar duzu. Unix/Linux sistemetan bide hori <strong>/usr/bin/aspell</strong> izaten da, baina beste edozein izan liteke.';
$string['edhelpbgcolor'] = 'Zehaztu edizio-eremuaren hondo-kolorea.<br />Balio onargarriak #FFFFFF o \'white\' dira, adibidez';
$string['edhelpcleanword'] = 'Egokipen honek Wordeko formatu-iragazkia aktibatu edo desaktibatzen du.';
$string['edhelpenablespelling'] = 'Zuzenketa ortografikoa gaitu edo desgaitzen du. Gaituta badago, zerbitzarian <strong>aspell</strong> instalatuta egon behar da. Balio hau erabiliko da aspell-ek erabiltzailearen hizkuntzarentzako hiztegirik ez badu.';
$string['edhelpfontfamily'] = 'Letra-moten familiaren ezaugarria familia generiko baten izenen edo eta hizki-izenen zerrenda da. Familiaren izenek kakotxez banatuta egon behar dute.';
$string['edhelpfontlist'] = 'Zehaztu erabilitako letra-motak editoreen menu kontestualean.';
$string['edhelpfontsize'] = 'Letra-motarako lehenetsitako tamainak aipatutako tamaina zehazten du. <br />Balio baliagarriak hauek izan daitezke, adibidez: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Editatu';
$string['edita'] = 'Editatu {$a}';
$string['editcategorysettings'] = 'Editatu kategoria-ezarpenak';
$string['editcategorythis'] = 'Editatu kategoria hau';
$string['editcoursesettings'] = 'Editatu ikastaroaren ezarpenak';
$string['editfiles'] = 'Editatu fitxategiak';
$string['editgroupprofile'] = 'Editatu taldearen profila';
$string['editinga'] = '{$a} editatzen';
$string['editingteachershort'] = 'Editorea';
$string['editlock'] = 'Ezarpen hau ezin da editatu!';
$string['editmode'] = 'Edizio-modua';
$string['editmyprofile'] = 'Editatu profila';
$string['editorbgcolor'] = 'Atzeko planoko kolorea';
$string['editorcleanonpaste'] = 'Itsastean Wordeko HTMLa garbitu';
$string['editorcommonsettings'] = 'Ezarpen komunak';
$string['editordefaultfont'] = 'Lehenetsitako letra-mota';
$string['editorenablespelling'] = 'Gaitu zuzentzaile ortografikoa';
$string['editorfontlist'] = 'Letra-moten zerrenda';
$string['editorfontsize'] = 'Lehenetsitako letra-tamaina';
$string['editorpreferences'] = 'Editorearen hobespenak';
$string['editorresettodefaults'] = 'Berrezarri lehenetsitako balioak';
$string['editorsettings'] = 'Editorearen ezarpenak';
$string['editorshortcutkeys'] = 'Editorearen laster-bideak';
$string['editsection'] = 'Editatu atala';
$string['editsectionname'] = 'Editatu atalaren izena';
$string['editsettings'] = 'Editatu ezarpenak';
$string['editsummary'] = 'Editatu laburpena';
$string['editthisactivity'] = 'Editatu aktibitate hau';
$string['editthiscategory'] = 'Editatu kategoria hau';
$string['edittitle'] = 'Editatu izenburua';
$string['edittitleinstructions'] = 'Sakatu "Esc" uzteko, "Enter" gordetzeko';
$string['edituser'] = 'Editatu erabiltzaile-kontuak';
$string['edulevel'] = 'Ekitaldi guztiak';
$string['edulevel_help'] = '* Irakaskuntza - irakasle batek egindako ekintzak, ad. baliabide bat eguneratu
* Partaidetza - ikasle batek egindako ekintzak, ad. foro batean mezua idatzi
* Beste batzuk - erabiltzaile batek egindako beste ekintzak, irakasle edo ikaslearena ez den rolarekin';
$string['edulevelother'] = 'Bestelako bat';
$string['edulevelparticipating'] = 'Parte hartzen';
$string['edulevelteacher'] = 'Irakaskuntza';
$string['email'] = 'Helbide elektronikoa';
$string['emailactive'] = 'Posta elektronikoa erabili ala ez';
$string['emailagain'] = 'Helbide elektronikoa (berriro)';
$string['emailalreadysent'] = 'Pasahitza berrezartzeko e-mail bat bidali da jada. Mesedez begiratu zure posta elektronikoa.';
$string['emailcharset'] = 'Posta elektronikorako karaktere-multzoa';
$string['emailconfirm'] = 'Zure kontua berretsi';
$string['emailconfirmation'] = 'Kaixo:

\'{$a->sitename}\' gunean kontu berri baten eskaera bat jaso dugu zure helbide elektronikotik.

Zure kontua berresteko, mesedez hurrengo helbide honetara joan zaitez:

{$a->link}

Posta elektronikoko programa gehienetan goiko helbidea esteka urdin gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan beharko zenuke. Horrela ez bada, helbidea kopiatu eta zure nabigatzailearen goialdean dagoen helbide-barran itsatsi ezazu.

Laguntza behar izanez gero, mesedez jarri harremanetan guneko kudeatzailearekin.
{$a->admin}';
$string['emailconfirmationresend'] = 'Berriz bidali berrespen e-maila';
$string['emailconfirmationsubject'] = '{$a}: kontuaren berrespena';
$string['emailconfirmsent'] = '<p>E-mail bat bidali dugu zure hurrengo helbide honetara: <b>{$a}</b></p>
   <p>Izena ematen amaitzeko argibide erraz batzuk ditu.</p>
   <p>Arazorik baduzu, jarri harremanetan kudeatzailearekin.</p>';
$string['emailconfirmsentfailure'] = 'Berrespen e-maila bidaltzeak huts egin du';
$string['emailconfirmsentsuccess'] = 'Berrespen e-maila ondo bidali da';
$string['emaildigest'] = 'Posta elektroniko bidez laburpen-mezuak jasotzeko modua';
$string['emaildigest_help'] = 'Hau foroek eguneko jakinarazpen-mezuak bidaltzeko modu lehenetsian erabiliko duten ezarpena da.

* Laburpenik ez - foroetako mezu bakoitzeko e-mail bana jasoko duzu;
* Laburpena - mezu osoak - egun bakoitzean foro bakoitzeko mezuen eduki guztiak dituen laburpen-mezu bat jasoko duzu;
* Laburpena - gaiak soilik - egun bakoitzean foro bakoitzeko mezuen izenburuak dituen laburpen-mezu bat jasoko duzu.

Nahi izanez gero, foro bakoitzean ezarpen ezberdin bat aukeratu dezakezu.';
$string['emaildigestcomplete'] = 'Osoa (egunean e-mail bakarra mezu guztiekin)';
$string['emaildigestoff'] = 'Laburpenik ez (foroetako mezu bakoitzeko e-mail bana jaso)';
$string['emaildigestsubjects'] = 'Gaiak (egunean e-mail bakarra soilik mezuen gaiekin)';
$string['emaildisable'] = 'Helbide elektroniko hau desgaituta dago';
$string['emaildisableclick'] = 'Egin klik hemen helbide honetara inongo e-mailik ez bidaltzeko';
$string['emaildisplay'] = 'Helbide elektronikoaren ikusgarritasuna';
$string['emaildisplay_help'] = '* Ezkutuan - soilik beharrezko baimenak dituztenek ikusi ahalko dute zure helbide elektronikoa, hala nola irakasleak.
* Edozeinentzako ikusgai - guneko erabiltzaile guztiek zure helbide elektronikoa ikusi ahalko dute.
* Ikastaroko partaideentzat ikusgai - soilik matrikulatuta zauden ikastaroetako partaideek ikusi ahalko dute zure helbide elektronikoa.';
$string['emaildisplaycourse'] = 'Ikastaroko partaideentzat ikusgai';
$string['emaildisplaycoursemembersonly'] = '(Ikusgai ikastaroko beste partaideentzat)';
$string['emaildisplayeveryone'] = '(Ikusgai denentzat)';
$string['emaildisplayhide'] = '(Ezkutuan beharrezko baimenak ez dituzten guztientzat)';
$string['emaildisplayno'] = 'Ezkutuan';
$string['emaildisplayyes'] = 'Edozeinentzako ikusgai';
$string['emailenable'] = 'Erabili helbide elektroniko hau';
$string['emailenableclick'] = 'Egin klik hemen helbide honetara e-mailak bidali ahal izateko';
$string['emailexists'] = 'Helbide elektroniko hau dagoeneko erregistratuta dago.';
$string['emailexistshintlink'] = 'Berreskuratu ahaztutako erabiltzaile-izena edo pasahitza';
$string['emailexistssignuphint'] = 'Beharbada iraganean kontu bat sortu zenuen? {$a}';
$string['emailformat'] = 'E-mail formatua';
$string['emailmustbereal'] = 'Oharra: zure helbide elektronikoak benetakoa izan behar du';
$string['emailnotallowed'] = 'Domeinu hauetako helbide elektronikoak ez dira onartzen ({$a})';
$string['emailnotfound'] = 'Ez da helbide elektronikoa datu-basean aurkitu';
$string['emailonlyallowed'] = 'Helbide elektroniko hau ez da onartzen ({$a})';
$string['emailpasswordchangeinfo'] = 'Kaixo, {$a->firstname}:

Norbaitek (ziurrenik zeuk) zure \'{$a->sitename}\' guneko \'{$a->username}\' konturako pasahitz berria eskatu du.

Zure pasahitza aldatzeko, mesedez hurrengo helbide honetara joan zaitez:

{$a->link}

Posta elektronikoko programa gehienetan goiko helbidea esteka urdin gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan beharko zenuke. Horrela ez bada, helbidea kopiatu eta zure nabigatzailearen goialdean dagoen helbide-barran itsatsi ezazu.

Laguntza behar izanez gero, mesedez jarri harremanetan guneko kudeatzailearekin.
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Kaixo, {$a->firstname}:

Norbaitek (zeuk ziurrenik) \'{$a->sitename}\' guneko zure konturako pasahitz berria eskatu du.

Tamalez, gune honetako zure kontua desgaitu egin da eta ezin da berriz ezarri. Mesedez, jarri harremanetan gunearen kudeatzailearekin,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Kaixo, {$a->firstname}:

Norbaitek (zeuk ziurrenik) \'{$a->sitename}\' guneko zure konturako pasahitz berria eskatu du.

Tamalez pasahitzak ezin dira aldatu gune honetan. Mesedez, jarri harremanetan gunearen kudeatzailearekin,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Pasahitz-aldaketari buruzko informazioa';
$string['emailpasswordconfirmation'] = 'Kaixo, {$a->firstname}:

Norbaitek (ziurrenik zeuk) zure \'{$a->sitename}\' guneko zure konturako pasahitz berria eskatu du.

Eskaera hau berretsi eta pasahitz berria posta elektroniko bidez jaso ahal izateko, mesedez hurrengo helbide honetara joan zaitez:

{$a->link}

Posta elektronikoko programa gehienetan goiko helbidea esteka urdin gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan beharko zenuke. Horrela ez bada, helbidea kopiatu eta zure nabigatzailearen goialdean dagoen helbide-barran itsatsi ezazu.

Laguntza behar izanez gero, mesedez jarri harremanetan guneko kudeatzailearekin.
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Pasahitz-aldaketaren berrespena';
$string['emailpasswordconfirmmaybesent'] = '<p>Erabiltzaile-izen edo helbide elektroniko bakar eta zuzena eman baduzu honezkero e-maila bidaliko zitzaizun.</p>
   <p>Pasahitza-aldaketa baieztatu eta egiteko argibide errazak ditu. Arazorik bazenu, mesedez gunearen kudeatzailearekin  harremanetan jarri.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Aukeratu duzun kontuak ez du helbide elektronikorik.</p>
<p>Mesedez, jarri harremanetan sistemaren kudeatzailearekin.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Emandako erabiltzaile detaileak ez datoz bat inolako erabiltzaile kontuekin.</p>
<p>Mesedez, berriz aztertu sartu duzun informazioa eta saiatu berriro. Hala eta guztiz ere arazoak badituzu, jarri harremanetan sistemaren kudeatzailearekin.</p>';
$string['emailpasswordconfirmsent'] = 'Zure <b>{$a}</b> helbidera e-mail bat bidali dugu.
<br />Mezu horrek pasahitz-aldaketa egin eta baieztatzeko argibide errazak ditu.
Arazorik bazenu, mesedez gunearen kudeatzailearekin harremanetan jarri.';
$string['emailpasswordsent'] = 'Mila esker pasahitz aldaketa baieztatzeagatik. Zure pasahitz berria duen e-mail bat helbide honetara bidali dizugu: <br /><b>{$a->email}</b>.<br />
Pasahitz berria automatikoki sortu da. Agian, <a href="{$a->link}">zure pasahitza aldatu</a> nahiko duzu eta gogoratzeko errazagoa den beste bat ezarri.';
$string['emailresetconfirmation'] = 'Kaixo, {$a->firstname}:

Norbaitek (zeuk ziurrenik) \'{$a->sitename}\' zure \'{$a->username}\' konturako pasahitz berria eskatu du.

Zure pasahitza aldatzeko, jo helbide honetara:
{$a->link}

(Esteka hau baliagarria izango da {$a->resetminutes} minutu eskaera egin zenetik hasita.)

Ez baduzu pasahitza eskaerarik egin, ez duzu ezer egin behar.

Laguntza gehiago behar baduzu, mesedez jar zaitez harremanetan guneko kudeatzailerekin,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: pasahitza berrezartzeko eskaria';
$string['emailresetconfirmsent'] = 'Zure <b>{$a}</b> helbidera e-mail bat bidali dugu.
<br />Mezu horrek pasahitz-aldaketa egin eta baieztatzeko argibide errazak ditu.
Arazorik bazenu, mesedez gunearen kudeatzailearekin harremanetan jarri.';
$string['emailstop'] = 'Desgaitu jakinarazpenak';
$string['emailtoprivatefiles'] = 'Era berean, fitxategiak e-mailetara erantsi eta zuzenean bidali ditzakezu zure fitxategi gune pribatura. Horretarako, bidali e-maila {$a}-ra.';
$string['emailtoprivatefilesdenied'] = 'Zure kudeatzaileak zure gune pribatura fitxategiak igotzeko aukera desgaitu du.';
$string['emailvia'] = '{$a->name} ({$a->siteshortname}(r)en bitartez)';
$string['emojicategoryactivities'] = 'Jarduerak';
$string['emojicategoryanimalsnature'] = 'Animaliak eta natura';
$string['emojicategoryflags'] = 'Banderak';
$string['emojicategoryfooddrink'] = 'Janaria eta edaria';
$string['emojicategoryobjects'] = 'Objektuak';
$string['emojicategorypeoplebody'] = 'Jendea eta gorputza';
$string['emojicategoryrecent'] = 'Orain dela gutxi';
$string['emojicategorysmileysemotion'] = 'Aurpegierak eta emotikonoak';
$string['emojicategorysymbols'] = 'Ikurrak';
$string['emojicategorytravelplaces'] = 'Bidaia eta lekuak';
$string['emptycmids'] = 'Hutsik dauden ikastaro-moduluen IDak';
$string['emptydragdropregion'] = 'lurraldea hutsik dago';
$string['emptysectionids'] = 'Hutsik dauden gaien IDak';
$string['enable'] = 'Gaitu';
$string['encryptedcode'] = 'Zifraturiko kodea';
$string['enddate'] = 'Ikastaroaren amaiera-data';
$string['enddate_help'] = 'Ikastaroaren amaiera-data ikaslearen ikastaroen zerrendan iraganeko gisa erakutsi behar den erabakitzeko erabiltzen da. Amaiera-data neurrira egindako txostenetan ere erabili daiteke. Kontuan izan erabiltzaileek amaiera-dataren ondoren ikastaroan sartu ahal izango dutela; beste era batera esanda, data honek ez du ikastaroaren sarbidea mugatzen.';
$string['english'] = 'Ingelesa';
$string['enrolmentmethods'] = 'Matrikulazio-metodoak';
$string['entercourse'] = 'Egin klik hemen ikastaro honetan sartzeko';
$string['enteremail'] = 'Idatzi zure helbide elektronikoa';
$string['enteremailaddress'] = 'Zure pasahitza berrezartzeko idatzi ezazu mesedez zure helbide elektronikoa eta pasahitz berria posta elektroniko bidez bidaliko dizugu.';
$string['enterusername'] = 'Idatzi zure erabiltzaile-izena';
$string['entries'] = 'Sarrerak';
$string['error'] = 'Errorea';
$string['errorcreatingactivity'] = 'Ezin izan da sortu \'{$a}\' zeregin berria';
$string['errorfiletoobig'] = 'Fitxategia {$a} byteko muga baino handiagoa da';
$string['errornouploadrepo'] = 'Gune honetan ez da gaitu fitxategiak igotzeko biltegirik';
$string['errorwhenconfirming'] = 'Ezin izan duzu kontua baieztatu errore bat gertatu delako. Hona iristeko e-mail bateko esteka batean klik egin baduzu, ziurtatu zure e-maileko estekaren errenkada osorik zegoela eta ez zegoela apurtuta edo moztuta. Baliteke ebaki/itsatsi erabili behar izatea esteka behar bezala berriz osatzeko.';
$string['eventcommentcreated'] = 'Iruzkina sortu da';
$string['eventcommentdeleted'] = 'Iruzkina ezabatu da';
$string['eventcommentsviewed'] = 'Iruzkinak ikusi dira';
$string['eventconfiglogcreated'] = 'Konfigurazio-loga sortu da';
$string['eventcontentviewed'] = 'Edukia ikusi da';
$string['eventcoursebackupcreated'] = 'Ikastaroaren segurtasun-kopia sortu da';
$string['eventcoursecategorycreated'] = 'Kategoria sortu da';
$string['eventcoursecategorydeleted'] = 'Kategoria ezabatu da';
$string['eventcoursecategoryupdated'] = 'Kategoria eguneratu da';
$string['eventcoursecategoryviewed'] = 'Kategoria ikusi da';
$string['eventcoursecontentdeleted'] = 'Ikastaro-edukia ezabatu da';
$string['eventcoursecreated'] = 'Ikastaroa sortu da';
$string['eventcoursedeleted'] = 'Ikastaroa ezabatu da';
$string['eventcourseinformationviewed'] = 'Ikastaroaren laburpena ikusi da';
$string['eventcoursemodulecreated'] = 'Ikastaro-modulua sortu da';
$string['eventcoursemoduledeleted'] = 'Ikastaro-modulua ezabatu da';
$string['eventcoursemoduleinstancelistviewed'] = 'Ikastaroko moduluen instantzien zerrenda ikusia';
$string['eventcoursemoduleupdated'] = 'Ikastaro-modulua eguneratu da';
$string['eventcoursemoduleviewed'] = 'Ikastaro-modulua ikusi da';
$string['eventcourseresetended'] = 'Ikastaroaren berrabiaraztea amaitu da';
$string['eventcourseresetstarted'] = 'Ikastaroaren berrabiaraztea hasi da';
$string['eventcourserestored'] = 'Ikastaroa berreskuratu da';
$string['eventcoursesectioncreated'] = 'Ikastaro-atala sortu da';
$string['eventcoursesectiondeleted'] = 'Ikastaro-atala ezabatu da';
$string['eventcoursesectionupdated'] = 'Ikastaroaren atalak eguneratu dira';
$string['eventcoursessearched'] = 'Ikastaroak bilatu dira';
$string['eventcourseupdated'] = 'Ikastaroa eguneratu da';
$string['eventcourseuserreportviewed'] = 'Ikastaroko erabiltzaile-txostena ikusita';
$string['eventcourseviewed'] = 'Ikastaroa ikusi da';
$string['eventdashboardreset'] = 'Berrabiarazi Aginte-panela';
$string['eventdashboardsreset'] = 'Berrabiarazi Aginte-panelak';
$string['eventdashboardviewed'] = 'Aginte-panela ikusi da';
$string['eventdatabasetextfieldcontentreplaced'] = 'Datu-baseko bilaketa eta ordezkapen orokorra';
$string['eventemailfailed'] = 'E-maila bidaltzeak huts egin du';
$string['eventmycoursesviewed'] = 'Nire Ikastaroak ikusita';
$string['eventname'] = 'Ekitaldiaren izena';
$string['eventrecentactivityviewed'] = 'Duela gutxiko aktibitatea ikusi da';
$string['eventsearchindexed'] = 'Bilaketa-informazioa indexatu';
$string['eventsearchresultsviewed'] = 'Bilaketaren emaitzak ikusi dira';
$string['eventunknownlogged'] = 'Ekitaldi ezezaguna';
$string['eventusercreated'] = 'Erabiltzailea sortu da';
$string['eventuserdeleted'] = 'Erabiltzailea ezabatu da';
$string['eventuserfeedbackgiven'] = 'Feedback estekan klik egin da';
$string['eventuserfeedbackremind'] = 'Gogorarazi beranduago estekan klik egin da';
$string['eventuserinfocategorycreated'] = 'Erabiltzaile-profilaren eremuen kategoria sortu da';
$string['eventuserinfocategorydeleted'] = 'Erabiltzaile-profilaren eremuen kategoria ezabatu da';
$string['eventuserinfocategoryupdated'] = 'Erabiltzaile-profilaren eremuen kategoria eguneratu da';
$string['eventuserinfofieldcreated'] = 'Erabiltzaile-profilaren eremua sortu da';
$string['eventuserinfofielddeleted'] = 'Erabiltzaile-profilaren eremua ezabatu da';
$string['eventuserinfofieldupdated'] = 'Erabiltzaile-profilaren eremua eguneratu da';
$string['eventuserlistviewed'] = 'Erabiltzaile-zerrenda ikusi da';
$string['eventuserloggedout'] = 'Erabiltzaileak saioa amaitu du';
$string['eventuserpasswordpolicyfailed'] = 'Erabiltzailearen pasahitzak ez du pasahitzen politika betetzen';
$string['eventuserpasswordupdated'] = 'Erabiltzailearen pasahitza eguneratu da';
$string['eventuserprofileviewed'] = 'Erabiltzaile-profila ikusi da';
$string['eventuserupdated'] = 'Erabiltzailea eguneratu da';
$string['everybody'] = 'Denak';
$string['executeat'] = 'Noiz exekutatu:';
$string['existing'] = 'Badena';
$string['existingadmins'] = 'Dauden kudeatzaileak';
$string['existingcourse'] = 'Dauden ikastaroak';
$string['existingcourseadding'] = 'Ikastaroa badago, informazioa eransten';
$string['existingcoursedeleting'] = 'Ikastaroa badago, lehena ezabatzen';
$string['existingcreators'] = 'Sortzaileak badira';
$string['existingstudents'] = 'Izena emandako ikasleak';
$string['existingteachers'] = 'Dauden irakasleak';
$string['expand'] = 'Zabaldu';
$string['expandall'] = 'Zabaldu guztia';
$string['expandcategory'] = 'Zabaldu {$a}';
$string['explanation'] = 'Azalpena';
$string['explanationdigitalminor'] = 'Informazio hau beharrezkoa da zure adina onespen-adin digitaletik goragokoa dela egiaztatzeko. Adin honetara heltzean norbanakoek baldintzei onespena eman diezaiekete eta ondorioz euren datuak legalki gorde eta prozesatu daitezke.';
$string['extendperiod'] = 'Luzapen-epea';
$string['extendsession'] = 'Luzatu saioa';
$string['failedloginattempts'] = '{$a->attempts} azken sarreratik sarrera okerren kopurua';
$string['favourites'] = 'Nabarmendutakoak';
$string['feedback'] = 'Feedbacka';
$string['file'] = 'Fitxategia';
$string['fileexists'] = 'Dagoeneko badago {$a} izena duen fitxategi bat';
$string['filemissing'] = '{$a} falta da';
$string['filereaderror'] = 'Ezin izan da \'{$a}\' fitxategia irakurri. Mesedez egiaztatu fitxategi bat dela eta ez dela karpeta bat.';
$string['files'] = 'Fitxategiak';
$string['filesanduploads'] = 'Fitxategiak eta igoerak';
$string['filesfolders'] = 'Fitxategiak/karpetak';
$string['fileuploadwithcontent'] = 'Fitxategi-igoerek ez lukete izan beharko eduki-parametroa';
$string['filloutallfields'] = 'Mesedez, bete formulario honetako eremu guztiak';
$string['filter'] = 'Iragazi';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'Iragazkiak';
$string['findmorecourses'] = 'Bilatu ikastaro gehiago...';
$string['first'] = 'Lehena';
$string['firstaccess'] = 'Lehen sarrera';
$string['firstname'] = 'Izena';
$string['firstnamephonetic'] = 'Izena- fonetikoa';
$string['firstpage'] = 'Lehen orria';
$string['firstsiteaccess'] = 'Lehen sarrera gunera';
$string['firsttime'] = 'Hau al da zure lehen aldia hemen?';
$string['folder'] = 'Karpeta';
$string['folderclosed'] = 'Karpeta itxia';
$string['folderopened'] = 'Karpeta irekia';
$string['followingoptional'] = 'Hurrengo elementuak hautazkoak dira';
$string['followingrequired'] = 'Hurrengo elementuak beharrezkoak dira';
$string['for'] = 'Norentzat';
$string['force'] = 'Behartu';
$string['forcelanguage'] = 'Behartu hizkuntza';
$string['forceno'] = 'Ez behartu';
$string['forcepasswordchange'] = 'Behartu pasahitza aldatzera';
$string['forcepasswordchange_help'] = 'Laukitxoa markatuz gero, erabiltzaileari pasahitza aldatzeko proposatuko zaio sartzen den hurrengoan.';
$string['forcepasswordchangecheckfull'] = 'Ziur al zaude pasahitza aldatzea behartu nahi duzula {$a}-rentzat?';
$string['forcepasswordchangenot'] = '{$a} ezin da behartu pasahitza aldatzera';
$string['forcepasswordchangenotice'] = 'Jarraitzeko zure pasahitza aldatu behar duzu.';
$string['forcepasswordresetfailurenotice'] = 'Zure une honetako pasahitzak ez du oraingo pasahitzen politika betetzen. Jarri zaitez harremanetan zure Moodleko kudeatzailearekin laguntza eskuratzeko.
   {$a}';
$string['forcepasswordresetnotice'] = 'Zure une honetako pasahitzak ez du oraingo pasahitzen politika betetzen, saioa hasteko pasahitza berrezarri behar duzu.
   {$a}';
$string['forcetheme'] = 'Behartu azala';
$string['forgotaccount'] = 'Pasahitza galdu duzu?';
$string['forgotten'] = 'Zure erabiltzaile-izena edo pasahitza ahaztu duzu?';
$string['forgottenduplicate'] = 'Hainbat kontuk helbide elektroniko bera dute. Mesedez, erabili erabiltzaile-izena horren ordez.';
$string['forgotteninvalidurl'] = 'Pasahitzak ez du balio, URLa berrabiarazi';
$string['format'] = 'Formatua';
$string['format_help'] = 'Ikastaro-formatuak ikastaroaren hasiera-orriaren diseinua zehazten du.

* Jarduera bakarreko formatua - Ikastaroaren hasiera-orrian jarduera edo baliabide bakar bat erakusteko (galdetegi bat edo SCORM pakete bat adibidez)
* Foro-formatua -  Ikastaroaren hasiera-orrian foro bat erakusten da
* Gai-formatua - Ikastaroaren hasiera-orria gaika edo atalka dago antolatuta
* Aste-formatua - Ikastaroa asteka antolatuta dago, hasiera- eta amaiera-data zehatzak dituela';
$string['formathtml'] = 'HTML formatua';
$string['formatmarkdown'] = 'Markdown formatua';
$string['formatplain'] = 'Testu laua';
$string['formattext'] = 'Moodle formatu automatikoa';
$string['forumpreferences'] = 'Foroen hobespenak';
$string['framesetinfo'] = 'Dokumentu honek hau du:';
$string['from'] = 'Nondik';
$string['frontpagecategorycombo'] = 'Ikastaro eta kategorien zerrenda';
$string['frontpagecategorynames'] = 'Kategorien zerrenda';
$string['frontpagecourselist'] = 'Ikastaroen zerrenda';
$string['frontpagecoursesearch'] = 'Ikastaroen bilaketa kutxa';
$string['frontpagedescription'] = 'Hasiera-orriaren laburpena';
$string['frontpagedescriptionhelp'] = 'Laburpen hau hasiera-orrian ager daiteke ikastaro/guneko laburpen-blokea erabilita.';
$string['frontpageenrolledcourselist'] = 'Matrikulatutako ikastaroak';
$string['frontpageformat'] = 'Hasiera-orriaren formatua';
$string['frontpageformatloggedin'] = 'Hasiera-orriaren formatua saioa hasita egotean';
$string['frontpagenews'] = 'Albisteak';
$string['frontpagesettings'] = 'Hasiera-orriaren ezarpenak';
$string['fulllistofcourses'] = 'Ikastaro guztiak';
$string['fullname'] = 'Izen osoa';
$string['fullnamecourse'] = 'Ikastaroaren izen osoa';
$string['fullnamecourse_help'] = 'Ikastaroaren izen osoa ikastaroko orri bakoitzaren goiko aldean eta ikastaroen zerrendan  erakutsiko da.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Erabiltzailearen izen osoa';
$string['fullprofile'] = 'Profil osoa';
$string['fullsitename'] = 'Gunearen izen osoa';
$string['functiondisabled'] = 'Funtzionalitate hori desgaituta dago';
$string['general'] = 'Orokorra';
$string['geolocation'] = 'latitudea - longitudea';
$string['gettheselogs'] = 'Eskuratu erregistro hauek';
$string['go'] = 'Joan';
$string['gpl'] = 'Copyright (C) 1999tik aurrera Martin Dougiamas (https://moodle.com)

Programa hau doako softwarea da. Berriz banatu edo eta alda dezakezu, beti ere GNU General Public License lizentziaren arabera, The Free Software Foundation-en argitalpenaren arabera; baita 2. bertsioaren edo ondorengo baten arabera ere.

Aplikazioa erabilgarria izango zaizulakoan banatzen da, baina INOLAKO BERMERIK GABE; ezta MERKATAL-BANAKETA
edo ASMO PARTIKULAR BATEN EGOKITZAPENAren bermerik ere.

Ikusi Moodle Lizentziaren informazio orria xehetasunetarako: https://docs.moodle.org/eu/Lizentzia';
$string['gpl3'] = 'Copyright (C) 1999tik aurrera Martin Dougiamas (https://moodle.com)

Programa hau software librea da: banatu edota aldatu egin dezakezu Free Software Foundation-ek argitaratutako GNU Lizentzia Publiko Orokorraren (GPL) baldintzen arabera, Lizentziaren 3. bertsioaren baldintzetan edo edozein bertsio berriagorenetan (zeuk aukeratu).

Programa hau erabilgarri izateko helburuarekin baina INONGO BERMERIK GABE banatzen da, baita KOMERTZIALIZATU edo BESTE EDOZEIN HELBURU baterako BERMERIK GABE ere.

Ikusi Moodle Lizentziaren informazio-orria zehaztasun gehiagorako: https://docs.moodle.org/eu/Lizentzia';
$string['gpllicense'] = 'GPL Lizentzia';
$string['grade'] = 'Kalifikazioa';
$string['gradenoun'] = 'Kalifikazioa';
$string['grades'] = 'Kalifikazioak';
$string['gradeverb'] = 'Kalifikazioa';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatarra</a> gaitu da gune honetan. Profilerako irudia igotzen ez baduzu, Moodle saiatuko da irudi bat kargatzen zure Gravatar-etik.';
$string['group'] = 'Taldea';
$string['groupadd'] = 'Gehitu talde berria';
$string['groupaddusers'] = 'Gehitu aukeratutakoa(k) taldera';
$string['groupfor'] = 'taldearentzat';
$string['groupinfo'] = 'Aukeratutako taldeari buruzko informazioa';
$string['groupinfoedit'] = 'Editatu taldearen ezaugarriak';
$string['groupinfomembers'] = 'Aukeratutako partaideei buruzko informazioa';
$string['groupinfopeople'] = 'Aukeratutako pertsonei buruzko informazioa';
$string['groupmembers'] = 'Tadekideak';
$string['groupmemberssee'] = 'Ikusi taldekideak';
$string['groupmembersselected'] = 'Aukeratutako taldeko kideak';
$string['groupmode'] = 'Talde-modua';
$string['groupmodeforce'] = 'Behartu talde-modua';
$string['groupmy'] = 'Nire taldea';
$string['groupnonmembers'] = 'Taldean ez daudenak';
$string['groupnotamember'] = 'Sentitzen dugu,  baina ez zara talde horretako kide';
$string['grouprandomassign'] = 'Talde guztiei ausaz egokitu';
$string['groupremove'] = 'Ezabatu aukeratutako taldea';
$string['groupremovemembers'] = 'Ezabatu aukeratutako partaideak';
$string['groups'] = 'Taldeak';
$string['groupsnone'] = 'Talderik ez';
$string['groupsseparate'] = 'Taldeek ezin elkar ikusi';
$string['groupsvisible'] = 'Taldeek elkar ikusten dute';
$string['guest'] = 'Gonbidatua';
$string['guestdescription'] = 'Gonbidatuek oso baimen gutxi dute eta ezin dute ia inon idatzi.';
$string['guestskey'] = 'Baimendu gakoa duten gonbidatuak';
$string['guestsno'] = 'Gonbidatuei sarrera ukatu';
$string['guestsnotallowed'] = 'Sentitzen dugu, \'{$a}\' ikastaroak ez die gonbidatuei sartzen uzten.';
$string['guestsyes'] = 'Baimendu gako gabeko gonbidatuak';
$string['guestuser'] = 'Gonbidatua';
$string['guestuserinfo'] = 'Erabiltzaile hau berezia da eta ikastaro batzuetan soilik begiratzera sartzea uzten die.';
$string['help'] = 'Laguntza';
$string['helpprefix2'] = 'Laguntza {$a}-rekin';
$string['helpwiththis'] = 'Laguntza honekin:';
$string['hiddenassign'] = 'Ezkutatu esleipena';
$string['hiddenfromstudents'] = 'Ezkutuan ikasleentzat';
$string['hiddenoncoursepage'] = 'Eskuragarri baina ikastaro-orrian erakutsi gabe';
$string['hiddensections'] = 'Ezkutuko atalak';
$string['hiddensections_help'] = 'Ezkutuko atalak ikasleei ez eskuragarri gisa erakusten diren (astekako ikastaro batean oporrak adierazteko, adibidez) edo guztiz ezkutatzen diren.';
$string['hiddensectionscollapsed'] = 'Ezkutuko atalak ez eskuragarri gisa erakutsi';
$string['hiddensectionsinvisible'] = 'Ezkutuko atalak guztiz ezkutatu';
$string['hiddenwithbrackets'] = '(ezkutuan)';
$string['hide'] = 'Ezkutatu';
$string['hideadvancedsettings'] = 'Ezkutatu ezarpena aurreratuak';
$string['hidechartdata'] = 'Ezkutatu grafikoaren datuak';
$string['hidefromstudents'] = 'Ezkutatu ikastaro-orrian';
$string['hideoncoursepage'] = 'Jarri eskuragarri baina ez erakutsi ikastaro-orrian (jarduera sekretua)';
$string['hidepicture'] = 'Ezkutatu irudia';
$string['hidepopoverwindow'] = 'Ezkutatu popover leihoa';
$string['hidesection'] = 'Ezkutatu {$a} atala';
$string['hidesettings'] = 'Ezkutatu ezarpenak';
$string['hideshowblocks'] = 'Ezkutatu edo erakutsi blokeak';
$string['highlight'] = 'Nabarmendu';
$string['highlighted'] = 'Nabarmenduta';
$string['highlightoff'] = 'Ez nabarmendu';
$string['hits'] = 'Agerraldiak';
$string['hitsoncourse'] = '{$a->coursename} ikastaroan {$a->username}(e)k egindako agerraldiak';
$string['hitsoncoursetoday'] = 'Gaur {$a->coursename} ikastaroan {$a->username}(e)k egindako agerraldiak';
$string['home'] = 'Hasiera';
$string['homeheader'] = 'Hasiera-orriko menua';
$string['hour'] = 'ordu';
$string['hours'] = 'ordu';
$string['howtomakethemes'] = 'Nola sortu azal berriak';
$string['htmleditor'] = 'Erabili HTML editorea';
$string['htmleditoravailable'] = 'Richtext editorea eskuragarri dago';
$string['htmleditordisabled'] = 'Zure erabiltzaile profilean HTML editorea desgaitu duzu';
$string['htmleditordisabledadmin'] = 'Kudeatzaileak Richtext editorea desgaitu du gune honetan';
$string['htmleditordisabledbrowser'] = 'Richtext editorea ez dago eskuragarri ez duzulako Internet Explorer 5.5 edo berriagorik erabiltzen';
$string['htmlfilesonly'] = 'HTML fitxategiak baino ez';
$string['htmlformat'] = 'HTML formatua';
$string['icon'] = 'Ikonoa';
$string['icqnumber'] = 'ICQ zenbakia';
$string['idnumber'] = 'ID zenbakia';
$string['idnumbercourse'] = 'Ikastaroaren ID zenbakia';
$string['idnumbercourse_help'] = 'Ikastaro baten ID zenbakia ikastaro hori kanpo-sistema batekin erkatzen denean baino ez da erabiltzen - hau ez da inoiz Moodle barruan erakusten. Ikastaroak kode ofiziala baldin badu, hemen erabili; bestela, eremua hutsik utz dezakezu.';
$string['idnumbercoursecategory'] = 'Kategoriaren ID zenbakia';
$string['idnumbercoursecategory_help'] = 'Ikastaro kategoriaren ID zenbakia soilik kategoria parekatzeko kanpoko sistemetan erabiltzen da, eta gunean ez da inon erakusten. Kategoriak kode ofiziala badu, hemen sar dezakezu; bestela, eremua hutsik utz dezakezu.';
$string['idnumbergroup'] = 'Taldearen ID zenbakia';
$string['idnumbergroup_help'] = 'Soilik taldearen ID zenbakia erabiltzen da taldea parekatzeko kanpoko sistemetan, eta gunean ez da inon erakusten. Taldeak kode ofiziala badu, hemen sar dezakezu; bestela, eremua hutsik utz dezakezu.';
$string['idnumbergrouping'] = 'Talde-multzoaren ID zenbakia';
$string['idnumbergrouping_help'] = 'Soilik talde-multzoaren ID zenbakia erabiltzen da talde-multzoa parekatzeko kanpoko sistemetan, eta gunean ez da inon erakusten. Talde-multzoak kode ofiziala badu, hemen sar dezakezu; bestela, eremua hutsik utz dezakezu.';
$string['idnumbermod'] = 'ID zenbakia';
$string['idnumbermod_help'] = 'ID zenbaki bat ezarrita kalifikazioak kalkulatzean edo txosten pertsonalizatuetan jarduera identifikatzeko modua izango duzu. Gainerakoan, ID zenbakiaren eremua hutsik utzi daiteke.

Kalifikatu daitezkeen jardueren kasuan, ID zenbakia kalifikazio-liburuan ere zehaztu daiteke, nahiz eta jarduera eguneratzeko soilik orritik editatu ahal den.';
$string['idnumbertaken'] = 'ID zenbaki hau dagoeneko erabilita dago';
$string['imagealt'] = 'Irudiaren deskribapena';
$string['import'] = 'Inportatu';
$string['importdata'] = 'Inportatu ikastaroko datuak';
$string['importdataexported'] = 'Ikastaroko datuak ondo esportatu dira.<br />Zure ikastarora inportatzen jarraitu.';
$string['importdatafinished'] = 'Inportazioa ondo burutua da! Segi zure ikastarora!';
$string['importdatafrom'] = 'Bilatu ikastaro bat datuak inportatzeko hemendik:';
$string['inactive'] = 'Ez aktibo';
$string['include'] = 'Sartu';
$string['includeallusers'] = 'Sartu erabiltzaile guztiak';
$string['includecoursefiles'] = 'Sartu ikastaroko fitxategiak';
$string['includecourseusers'] = 'Sartu ikastaroko erabiltzaileak';
$string['included'] = 'Barne dago';
$string['includelogentries'] = 'Sartu erregistro-sarrerak';
$string['includemodules'] = 'Sartu moduluak';
$string['includemoduleuserdata'] = 'Sartu moduluaren erabiltzailearen datuak';
$string['includeneededusers'] = 'Sartu behar diren erabiltzaileak';
$string['includenoneusers'] = 'Ez sartu erabiltzailerik';
$string['includeroleassignments'] = 'Sartu rol-esleipenak';
$string['includesitefiles'] = 'Sartu ikastaro honetan erabilitako guneko fitxategiak';
$string['includeuserfiles'] = 'Sartu erabiltzaileen fitxategiak';
$string['increasesections'] = 'Handitu atal-kopurua';
$string['indicator:accessesafterend'] = 'Ikastaroa amaiera-dataren ostean ikusi da';
$string['indicator:accessesafterend_help'] = 'Adierazle honek ikasleek ikastaroaren amaiera-dataren ondoren ikastaroan sartu diren adierazten du.';
$string['indicator:accessesbeforestart'] = 'Ikastaroa hasiera-dataren aurretik ikusi da';
$string['indicator:accessesbeforestart_help'] = 'Adierazle honek ikasleek ikastaroaren hasiera-dataren aurretik ikastaroan sartu diren adierazten du.';
$string['indicator:activitiesdue'] = 'Programatutako jarduerak';
$string['indicator:activitiesdue_help'] = 'Erabiltzaileak programatutako jarduerak ditu';
$string['indicator:anycourseaccess'] = 'Sarbidea edozein ikastarotan';
$string['indicator:anycourseaccess_help'] = 'Adierazle honek erabiltzailea matrikulatuta dagoen edozein ikastarora egindako sarbideak erakusten ditu.';
$string['indicator:anywrite'] = 'Edozein idazketa-ekintza';
$string['indicator:anywrite_help'] = 'Adierazle honek ikasleek egindako edozein idazketa-ekintza (bidalketa) erakusten du.';
$string['indicator:anywriteincourse'] = 'Edozein idazketa-ekintza ikastaroan';
$string['indicator:anywriteincourse_help'] = 'Adierazle honek ikasleek ikastaroko edozein jardueretan egindako edozein idazketa-ekintza (bidalketa) erakusten du.';
$string['indicator:completeduserprofile'] = 'Erabiltzaile-profila osatu da';
$string['indicator:completeduserprofile_help'] = 'Adierazle honek ikasleak bere erabiltzaile-profila osatu duen erakusten du.';
$string['indicator:completeduserprofiledef'] = 'Erabiltzaile-profila osatuta dago';
$string['indicator:completeduserprofiledef_help'] = 'Erabiltzaileak guneko politikak onartu ditu eta hurrengo eremuak bete ditu: Erakundea, Departamentua, Helbidea, Hiria, Herrialdea, URLa.';
$string['indicator:completionenabled'] = 'Osaketaren jarraipena gaitu da';
$string['indicator:completionenabled_help'] = 'Adierazle honek ikastaro honetan osaketaren jarraipena gaitu den erakusten du.';
$string['indicator:nostudent'] = 'Ikasleen matrikulazioak';
$string['indicator:nostudent_help'] = 'Adierazle honek ikastaroak ikaslerik duen erakusten du.';
$string['indicator:noteacher'] = 'Irakaslea esleituta';
$string['indicator:noteacher_help'] = 'Adierazle honek ikastaroak irakaslerik duen erakusten du.';
$string['indicator:potentialcognitive'] = 'Gaitasun kognitiboa potentziala ikastaroan';
$string['indicator:potentialcognitive_help'] = 'Adierazle hau ikastaroaren aktibitateetan parte hartzen duen ikasle batek lor dezakeen sakonera kognitibo potentzialean oinarrituta dago.';
$string['indicator:potentialcognitivedef'] = 'Ikastaroaren sakonera kognitiboaren potentziala';
$string['indicator:potentialcognitivedef_help'] = 'Ikastaroak eskaintzen duen gaitasun kognitibo "sakonaren" maila; adibidez: feedbacka emateko lanen bidalketa, lana beste pertsona batzuk berrikusteko aukera edo lana berrikusi eta berriz bidaltzeko aukera.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Ikastaroaren zabalera sozial potentziala';
$string['indicator:potentialsocial_help'] = 'Adierazle hau ikastaroaren aktibitateetan parte hartzen duen ikasle batek lor dezakeen zabalera sozial potentzialean oinarrituta dago.';
$string['indicator:potentialsocialdef'] = 'Ikastaroaren zabalera sozialaren potentziala';
$string['indicator:potentialsocialdef_help'] = 'Ikastaroak eskaintzen duen gaitasun sozial "zabalaren" maila, beste partaideekin eta klasetik haratagoko praktika-komunitatearekin elkarrekintza izanda.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Irakurketa-ekintza kopurua';
$string['indicator:readactions_help'] = 'Adierazle honek ikasle batek egindako irakurketa-ekintza kopurua (ikusi) erakusten du.';
$string['indicator:userforumstracking'] = 'Erabiltzaileak foroetako irakurri gabeko mezuen jarraipena gaituta dauka';
$string['indicator:userforumstracking_help'] = 'Adierazle honek ikasleak foroetako irakurri gabeko mezuen jarraipena gaituta duen edo ez erakusten du.';
$string['info'] = 'Informazioa';
$string['inprogress'] = 'Abian';
$string['institution'] = 'Erakundea';
$string['instudentview'] = 'ikaslearen ikuspegian';
$string['interests'] = 'Interesguneak';
$string['interestslist'] = 'Interesgune-zerrenda';
$string['interestslist_help'] = 'Idatzi zure intereseko gaiak banaka, eta gai hauek etiketa formaz erakutsiko dira zure profil-orrian.';
$string['invalidemail'] = 'Helbide elektroniko baliogabea';
$string['invalidlogin'] = 'Saio-hasiera baliogabea, saiatu berriz, mesedez';
$string['invalidusername'] = 'Erabiltzaile-izenak soilik karaktere alfanumerikoak (letrak eta zenbakiak) minuskuletan, beheko gidoia (_), gidoia (-), puntua (.) eta a bildua (@) izan ditzake.';
$string['invalidusernameupload'] = 'Erabiltzaile-izen baliogabea';
$string['ip_address'] = 'IP helbidea';
$string['jump'] = 'Joan';
$string['jumpto'] = 'Joan hona...';
$string['keep'] = 'Mantendu';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Hizkuntzaren norabidea ezkerretik eskumara';
$string['langrtl'] = 'Hizkuntzaren norabidea eskumatik ezkerrera';
$string['language'] = 'Hizkuntza';
$string['languagegood'] = 'Hizkuntza pakete hau egunean dago! :-)';
$string['languageselector'] = 'Hizkuntza-hautatzailea';
$string['last'] = 'Azkena';
$string['lastaccess'] = 'Azken sarrera';
$string['lastcourseaccess'] = 'Azken sarrera ikastarora';
$string['lastedited'] = 'Azken edizioa';
$string['lastip'] = 'Azken IP helbidea';
$string['lastlogin'] = 'Azken saio-hasiera';
$string['lastmodified'] = 'Azken aldaketa';
$string['lastname'] = 'Abizena';
$string['lastnamephonetic'] = 'Abizena - fonetikoa';
$string['lastpage'] = 'Azken orria';
$string['lastsiteaccess'] = 'Azken sarrera gunera';
$string['lastyear'] = 'Azken urtea';
$string['latestlanguagepack'] = 'Bilatu hizkuntza-fitxategi berrienak moodle.org-en';
$string['layouttable'] = 'Diseinu-taula';
$string['leavetokeep'] = 'Hutsik utzi orain duzun pasahitza mantentzeko';
$string['legacylogginginuse'] = 'Gune honek une honetan heredatutako agerraldian idaztea gaituta dauka. Agerraldi-biltegi honetan idaztea baztertuta dago. Mesedez idatzi onartuta dagoen agerraldi-biltegi batean, hala nola "estandarra" edo "kanpokoa".';
$string['legacythemeinuse'] = 'Gunea era bateragarrian erakutsiko zaizu zure nabigatzailea zaharregia delako.';
$string['license'] = 'Lizentzia';
$string['licenses'] = 'Lizentziak';
$string['liketologin'] = 'Erabiltzaile-kontuarekin sartu nahi al duzu orain?';
$string['list'] = 'Zerrendatu';
$string['listfiles'] = 'Fitxategien zerrenda {$a}(e)an';
$string['listofallpeople'] = 'Partaide guztien zerrenda';
$string['listofcourses'] = 'Ikastaroen zerrenda';
$string['loading'] = 'Kargatzen';
$string['loadinghelp'] = 'Kargatzen...';
$string['local'] = 'Lokala';
$string['localplugins'] = 'Plugin lokalak';
$string['localpluginsmanage'] = 'Kudeatu plugin lokalak';
$string['location'] = 'Kokapena';
$string['locktimeout'] = 'Eragiketa huts egin du blokeo baten zai zegoela.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = '{$a} barruan da';
$string['loggedinasguest'] = 'Gonbidatu gisa ari zara';
$string['loggedinnot'] = 'Ez zara oraindik sartu.';
$string['login'] = 'Sartu';
$string['login_failure_logs'] = 'Sarrera okerren agerraldiak';
$string['loginactivity'] = 'Saio-hasieren jarduera';
$string['loginagain'] = 'Sartu berriro';
$string['loginalready'] = 'Dagoeneko saioa hasi duzu';
$string['loginas'] = 'Sartu erabiltzaile hau bezala';
$string['loginaspasswordexplain'] = '<p> "loginas password" berezia sartu behar duzu ezaugarri hau erabiltzeko.<br />Ez badakizu, galdetu zerbitzari-administratzaileari.</p>';
$string['loginguest'] = 'Sartu gonbidatu gisa';
$string['loginsite'] = 'Sartu gunean';
$string['loginsteps'] = 'Gune honetara sarbide osoa izateko, lehenik eta behin kontua sortu behar duzu.';
$string['loginstepsnone'] = '<p>Kaixo!</p>
<p>Ikastaroetan sarrera-eskubide osoa izateko zuretzat kontu bat sortu beharko duzu.</p>
<p>Egin behar duzun guztia erabiltzaile izen eta pasahitz bat sortzea da eta
formulario honetan jartzea!</p>
<p>Beste inork aukeratu badu dagoeneko zure erabiltzaile izena, beste izen bat erabiliz saiatu beharko duzu.</p>';
$string['loginto'] = 'Sartu {$a} gunean';
$string['logoof'] = '{$a}(r)en logoa';
$string['logout'] = 'Irten';
$string['logoutconfirm'] = 'Irten egin nahi al duzu benetan?';
$string['logs'] = 'Agerraldiak';
$string['logtoomanycourses'] = '[<a href="{$a->url}">gehiago</a> ]';
$string['logtoomanyusers'] = '[<a href="{$a->url}">gehiago</a> ]';
$string['lookback'] = 'Epea';
$string['mailadmins'] = 'Kudeatzaileei informatu';
$string['mailstudents'] = 'Ikasleei informatu';
$string['mailteachers'] = 'Irakasleei informatu';
$string['maincoursepage'] = 'Ikastaroaren hasiera-orria';
$string['makeafolder'] = 'Sortu karpeta';
$string['makeavailable'] = 'Jarri eskuragarri';
$string['makeeditable'] = '\'{$a}\' web-zerbitzariak (Apache-k adibidez) editatzeko modukoa bihurtzen baduzu, fitxategi hau zuzenean editatu ahal izango duzu orri honetatik.';
$string['makethismyhome'] = 'Markatu hau nire hasiera-orri gisa';
$string['makeunavailable'] = 'Jarri ez-eskuragarri';
$string['manageblocks'] = 'Blokeak';
$string['managecategories'] = 'Kudeatu ikastaro-kategoriak';
$string['managecategorythis'] = 'Kudeatu kategoria hau';
$string['managecombined'] = 'Kudeatu ikastaro-kategoriak eta ikastaroak';
$string['managecontentbanktypes'] = 'Kudeatu eduki-motak';
$string['managecourses'] = 'Kudeatu ikastaroak';
$string['managedatabase'] = 'Datu-basea';
$string['managedataformats'] = 'Kudeatu datu-formatuak';
$string['manageeditorfiles'] = 'Kudeatu editoreak erabilitako fitxategiak';
$string['managefilters'] = 'Iragazkiak';
$string['managemodules'] = 'Moduluak';
$string['manageroles'] = 'Rolak eta baimenak';
$string['markallread'] = 'Markatu guztiak irakurritako gisa';
$string['markedthistopic'] = 'Gai hau oraingo gisa dago nabarmendua';
$string['markthistopic'] = 'Gai hau oraingoa gisa nabarmendu';
$string['matchingsearchandrole'] = 'Aurkitutako \'{$a->search}\' kointzidentziak {$a->role} rolarekin';
$string['maxareabytesreached'] = 'Fitxategiaren tamaina (edo fitxategi guztien tamainen batura) atal honetan eskuragarri dagoena baino handiagoa da.';
$string['maxfilesize'] = 'Gehieneko tamaina fitxategi berrietarako: {$a}';
$string['maxfilesreached'] = '{$a} fitxategi erantsi ahal diozu elementu honi gehienez';
$string['maximumchars'] = '{$a} karaktere gehienez';
$string['maximumgrade'] = 'Gehieneko kalifikazioa';
$string['maximumgradex'] = 'Gehieneko kalifikazioa: {$a}';
$string['maximumshort'] = 'Gehienez';
$string['maximumupload'] = 'Fitxategiak igotzeko gehieneko tamaina';
$string['maximumupload_help'] = 'Ezarpen honek ikastaro honetara igo daitezkeen fitxategien gehieneko tamaina zehazten du, kudeatzaileak ezarritako gunearen gehieneko tamainak mugatuta. Jarduera-modulu bakoitzean agertzen diren aldagaien tamaina ere muga daiteke.';
$string['maxnumberweeks'] = 'Gehieneko atal-kopurua';
$string['maxnumberweeks_desc'] = 'Atal-kopuruaren menu zabalgarriaren gehieneko balioa (soilik ikastaro formatu jakin batzuetan aplikatzen da).';
$string['maxnumcoursesincombo'] = 'Arakatu <a href="{$a->link}">{$a->numberofcourses} courses</a>.';
$string['maxsectionslimit'] = 'Ezin da atal berri bat sortu horrek ikastaro honetan ({$a}) baimendutako gehieneko atal-kopurua gaindituko lukeelako.';
$string['maxsize'] = 'Gehieneko tamaina: {$a}';
$string['maxsizeandareasize'] = 'Fitxategi berrien gehieneko balio: {$a->size}, muga orokorra: {$a->areasize}';
$string['maxsizeandattachments'] = 'Fitxategientzako gehieneko tamaina: {$a->size}, gehieneko fitxategi-kopurua: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Fitxategientzako gehieneko tamaina: {$a->size}, gehieneko fitxategi-kopurua: {$a->attachments}, gehieneko tamaina guztira: {$a->areasize}';
$string['memberincourse'] = 'Ikastaroko pertsonak';
$string['menu'] = 'Menua';
$string['message'] = 'Mezua';
$string['messagebody'] = 'Mezuaren gorputza';
$string['messagedselectedusers'] = 'Aukeratutako erabiltzaileei mezua bidali zaie eta jasotzaileen zerrenda egokitu da.';
$string['messagedselectedusersfailed'] = 'Aukeratutako erabiltzaileei mezua bidaltzean zerbait gaizki joan da. Baliteke batzuek e-maila jaso izana.';
$string['messageprovider:asyncbackupnotification'] = 'Segurtasun-kopia/berreskuratze asinkronoen jakinarazpenak';
$string['messageprovider:availableupdate'] = 'Eskuragarri dauden eguneraketen jakinarazpenak';
$string['messageprovider:backup'] = 'Segurtasun-kopien jakinarazpenak';
$string['messageprovider:badgecreatornotice'] = 'Domina-sortzailearen jakinarazpenak';
$string['messageprovider:badgerecipientnotice'] = 'Domina-jasotzailearen jakinarazpenak';
$string['messageprovider:competencyplancomment'] = 'Iruzkina gehitu da ikasketa-planean';
$string['messageprovider:competencyusercompcomment'] = 'Iruzkina egin da konpetentzian';
$string['messageprovider:coursecompleted'] = 'Ikastaroa osatu da';
$string['messageprovider:coursecontentupdated'] = 'Ikastaroko edukien aldaketak';
$string['messageprovider:courserequestapproved'] = 'Ikastaroa sortzeko eskariaren onarpen-jakinarazpena';
$string['messageprovider:courserequested'] = 'Ikastaroa sortzeko eskaria ukatzeko jakinarazpena';
$string['messageprovider:courserequestrejected'] = 'Ikastaroa sortzeko eskaria onartu ez izanaren jakinarazpena';
$string['messageprovider:errors'] = 'Errore larriak gunean';
$string['messageprovider:errors_help'] = 'Hauek errore garrantzitsuak dira eta kudeatzaileak hauen berri izan beharko luke.';
$string['messageprovider:gradenotifications'] = 'Kalifikazio-jakinarazpenak';
$string['messageprovider:infected'] = 'Antibirusaren hutsegiteen jakinarazpenak.';
$string['messageprovider:insights'] = 'Predikzio-ereduek sortutako pertzepzioa';
$string['messageprovider:instantmessage'] = 'Erabiltzaileen arteko mezu pertsonalak';
$string['messageprovider:instantmessage_help'] = 'Atal honek zehazten du zer gertatuko den guneko beste erabiltzaile batzuk zuri zuzenean bidalitako mezuekin.';
$string['messageprovider:messagecontactrequests'] = 'Kontaktuak jakinarazpena behar du';
$string['messageprovider:newlogin'] = 'Saio-hasiera berrien jakinarazpenak';
$string['messageprovider:notices'] = 'Errore arinei buruzko oharrak';
$string['messageprovider:notices_help'] = 'Kudeatzaile batek ikusi nahiko lituzkeen oharrak dira hauek.';
$string['messageprovider:reportbuilderschedule'] = 'Txosten-eraikitzaile pertsonalizatuaren programazioak';
$string['messageselect'] = 'Aukeratu erabiltzaile hau mezuaren jasotzaile gisa';
$string['messageselectadd'] = 'Bidali mezua';
$string['middlename'] = 'Bigarren izena';
$string['migratinggrades'] = 'Kalifikazioak migratzen';
$string['min'] = 'minutu';
$string['mins'] = 'minutu';
$string['minute'] = 'minutua';
$string['minutes'] = 'minutu';
$string['miscellaneous'] = 'Bestelakoak';
$string['missingcategory'] = 'Kategoria bat aukeratu behar duzu';
$string['missingdescription'] = 'Deskribapena falta da';
$string['missingemail'] = 'Helbide elektronikoa falta da';
$string['missingfirstname'] = 'Izena falta da';
$string['missingfromdisk'] = 'Diskotik falta da';
$string['missingfullname'] = 'Izena eta abizena falta dira';
$string['missinglastname'] = 'Abizena falta da';
$string['missingname'] = 'Izena falta da';
$string['missingnewpassword'] = 'Pasahitz berria falta da';
$string['missingpassword'] = 'Pasahitza falta da';
$string['missingrecaptchachallengefield'] = 'reCAPTCHAk huts egin du, saiatu berriro.';
$string['missingreqreason'] = 'Arrazoia falta da';
$string['missingshortname'] = 'Izen laburra falta da';
$string['missingshortsitename'] = 'Gunearen izen laburra falta da';
$string['missingsitedescription'] = 'Gunearen deskribapena falta da';
$string['missingsitename'] = 'Gunearen izena falta da';
$string['missingstrings'] = 'Bilatu itzuli gabeko hitz edo esaldiak';
$string['missingstudent'] = 'Zerbait aukeratu behar duzu';
$string['missingsummary'] = 'Laburpena falta da';
$string['missingteacher'] = 'Zerbait aukeratu behar duzu';
$string['missingurl'] = 'URLa falta da';
$string['missingusername'] = 'Erabiltzailearen izena falta da';
$string['moddoesnotsupporttype'] = '{$a->modname} moduluak ez ditu onartzen {$a->type} motako igoerak';
$string['modhide'] = 'Ezkutatu';
$string['modified'] = 'Aldatuta';
$string['modshow'] = 'Erakutsi';
$string['moduleintro'] = 'Deskribapena';
$string['modulesetup'] = 'Moduluen taulak falta dira';
$string['modulesuccess'] = '{$a} taulak ondo ezarri dira';
$string['modulesused'] = 'Erabilitako moduluak';
$string['modvisible'] = 'Eskuragarritasuna';
$string['modvisible_help'] = '* Erakutsi ikastaro-orrian: Ikasleentzako eskuragarri (bestelako eskuragarritasun murrizketek baimentzen badute).
* Ezkutatu ikasleei: Ez eskuragarri ikasleentzat.';
$string['modvisiblehiddensection'] = 'Eskuragarritasuna';
$string['modvisiblehiddensection_help'] = '* Ezkutatu ikasleei: Ez eskuragarri ikasleentzat.
* Jarri eskuragarri baina ez erakutsi ikastaro-orrian (jarduera sekretua): Ikasleentzat eskuragarri nonbait esteka eskainiz gero. Jarduerek kalifikazio-txostenean eta bestelako txostenetan agertzen jarraituko dute.';
$string['modvisiblewithstealth'] = 'Eskuragarritasuna';
$string['modvisiblewithstealth_help'] = '* Erakutsi ikastaro-orrian: Ikasleentzako eskuragarri (bestelako eskuragarritasun murrizketek baimentzen badute).
* Ezkutatu ikasleei: Ez eskuragarri ikasleentzat.
* Jarri eskuragarri baina ez erakutsi ikastaro-orrian (jarduera sekretua): Ikasleentzat eskuragarri nonbait esteka eskainiz gero. Jarduerek kalifikazio-txostenean eta bestelako txostenetan agertzen jarraituko dute.';
$string['month'] = 'Hilabetea';
$string['months'] = 'Hilabeteak';
$string['moodledocs'] = 'Moodle Doc-ak';
$string['moodledocslink'] = 'Laguntza eta dokumentazioa';
$string['moodlelogo'] = 'Moodleren logoa';
$string['moodlerelease'] = 'Moodleren ezaugarriak';
$string['moodleservicesandsupport'] = 'Zerbitzuak eta laguntza';
$string['moodleversion'] = 'Moodle bertsioa';
$string['more'] = 'gehiago';
$string['moreactions'] = 'Ekintza gehiago';
$string['morehelp'] = 'Laguntza gehiago';
$string['morehelpaboutmodule'] = '{$a} jardueraren inguruko laguntza gehiago';
$string['moreinfo'] = 'Informazio gehiago';
$string['moreinformation'] = 'Informazio gehiago errore honi buruz';
$string['moremenu'] = 'Gehiago';
$string['morenavigationlinks'] = 'Gehiago...';
$string['moreprofileinfoneeded'] = 'Mesedez, esaguzu gehiago zuri buruz';
$string['mostrecently'] = 'azkenengoz';
$string['move'] = 'Mugitu';
$string['movecategoriessuccess'] = '{$a->count} kategoria(k) ondo mugitu d(ir)a \'{$a->to}\' kategoriara';
$string['movecategoriestotopsuccess'] = '{$a->count} kategoria(k) ondo mugitu d(ir)a goragoko mailara';
$string['movecategorycontentto'] = 'Mugitu hemen';
$string['movecategorysuccess'] = '\'{$a->moved}\' kategoria ondo mugitu da \'{$a->to}\' kategoriara';
$string['movecategoryto'] = 'Mugitu kategoria hona:';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' kategoria ondo mugitu da
goragoko mailara';
$string['movecontent'] = 'Mugitu {$a}';
$string['movecontentafter'] = '"{$a}"-ren ondoren';
$string['movecontentstoanothercategory'] = 'Mugitu edukiak beste kategoria batera';
$string['movecontenttothetop'] = 'Joan zerrendako lehen postura';
$string['movecoursemodule'] = 'Mugitu jarduera';
$string['movecoursesection'] = 'Mugitu atala';
$string['movecourseto'] = 'Mugitu ikastaroa hona:';
$string['movedown'] = 'Mugitu behera';
$string['movefilestohere'] = 'Mugitu fitxategiak hona';
$string['movefull'] = 'Mugitu {$a} hona';
$string['movehere'] = 'Mugitu hona';
$string['moveleft'] = 'Mugitu ezkerrera';
$string['moveright'] = 'Mugitu eskuinera';
$string['movesection'] = 'Mugitu {$a} atala';
$string['moveselectedcategoriesto'] = 'Mugitu aukeratutako kategoriak hona:';
$string['moveselectedcoursesto'] = 'Mugitu aukeratutako ikastaroak hona:';
$string['movetoanotherfolder'] = 'Mugitu beste karpeta batera';
$string['moveup'] = 'Mugitu gora';
$string['msnid'] = 'ID MSN';
$string['mustchangepassword'] = 'Pasahitz berriak eta zaharrak ezberdin izan behar dute.';
$string['mustconfirm'] = 'Zure kontua baieztatu behar dituzu';
$string['mycourses'] = 'Nire ikastaroak';
$string['myfiles'] = 'Nire fitxategi pribatuak';
$string['myfilesmanage'] = 'Kudeatu nire fitxategi pribatuak';
$string['myhome'] = 'Aginte-panela';
$string['mymoodledashboard'] = 'Nire Moodleko aginte-panela';
$string['myprofile'] = 'Nire profila';
$string['name'] = 'Izena';
$string['namedfiletoolarge'] = '\'{$a->filename}\' fitxategia handiegia da eta ezin izan da igo';
$string['nameforlink'] = 'Zein izen eman nahi diozu esteka honi?';
$string['nameforpage'] = 'Izena';
$string['navigation'] = 'Nabigazioa';
$string['needed'] = 'Beharrezkoa';
$string['networkdropped'] = 'Zure Interneterako konexioa ez dela fidagarria edo moztu egin dela antzeman dugu.<br />
Mesedez kontuan izan aldaketak ez gordetzea gerta daitekeela zure konexioa hobetu ezean.';
$string['never'] = 'Inoiz ez';
$string['neverdeletelogs'] = 'Ez ezabatu inoiz agerraldiak';
$string['new'] = 'Berria';
$string['newaccount'] = 'Kontu berria';
$string['newactivityname'] = '{$a} jarduerarako izen berria';
$string['newcourse'] = 'Ikastaro berria';
$string['newloginnotificationbodyfull'] = '<p>Kaixo {$a->userfullname},</p>
<p>Zure {$a->sitename} kontuak gailu berri batetik saioa hasi berri du.</p>
<ul>
<li>Zure kontua: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Gailua: {$a->logindevice}</li>
<li>IP helbidea: {$a->loginip}</li>
</ul>
<p>Zu izan bazara ez duzu ezer egin behar.</p>
<p>Jarduera honen berri ez baduzu, mesedez <a href="{$a->changepasswordlink}">zure pasahitza aldatu ezazu</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Zure {$a} kontuak gailu berri batetik saioa hasi berri du.';
$string['newloginnotificationtitle'] = 'Saio hasiera berria zure {$a} kontuan';
$string['newpassword'] = 'Pasahitz berria';
$string['newpassword_help'] = 'Idatzi paasahitz berri bat edo hutsik utzi oraingo pasahitza mantentzeko.';
$string['newpasswordfromlost'] = '<strong>OHARRA:</strong> Zure <strong>Oraingo zure pasahitza</strong> bi e-mailetatik <strong>bigarrengoan</strong> bidaliko zaizu galdutako pasahitzaren errekuperazio-prozesuan. Pantaila honekin jarraitu aurretik, ziurtatu ezazu pasahitza jaso duzula, mesedez.';
$string['newpasswordtext'] = 'Kaixo, {$a->firstname}:

Zure kontuaren pasahitza \'{$a->sitename}\' gunean berrezarri da eta behin behineko pasahitz berri bat ezarri dizugu.

Zure datu berriak ondorengoak dira:
 erabiltzaile-izena: {$a->username}
 pasahitza: {$a->newpassword}

Pasahitza aldatu nahi baduzu, mesedez hurrengo helbide honetara joan zaitez:
 {$a->link}

Posta elektronikoko programa gehienetan goiko helbidea esteka urdin gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan beharko zenuke. Horrela ez bada, helbidea kopiatu eta zure nabigatzailearen goialdean dagoen helbide-barran itsatsi ezazu.

Agur bero bat \'{$a->sitename}\' guneko kudeatzailearen partez,
{$a->signoff}';
$string['newpicture'] = 'Irudi berria';
$string['newpicture_help'] = 'Irudi berria gehitzeko, bilatu eta aukeratu irudia (JPG edo PNG formatuan) eta egin klik "Eguneratu profila" botoian. Irudia karratu bat bihurtzeko moztuko da eta 100x100 pixeleko tamainera egokituko da.';
$string['newpictureusernotsetup'] = 'Profilerako irudia gehitu aurretik beharrekoa den profileko informazioa gorde behar da.';
$string['newsectionname'] = '{$a} atalerako izen berria';
$string['newsitem'] = 'berri bat';
$string['newsitems'] = 'albisteak';
$string['newsitemsnumber'] = 'Albiste-kopurua';
$string['newsitemsnumber_help'] = 'Albisteen foroa ikastaroa sortzean sortzen den foro berezia da, modu lehenetsian behartutako harpidetza duena eta beharrezko baimenak dituzten erabiltzaileek soilik idatzi dezakete bertan (modu lehenetsian irakasleak).

Ezarpen honek ikastaroaren hasiera-orrian, azken albisteak blokean zenbat albiste agertuko diren zehazten du.

Ikastaroan albisteen foroa behar ez bada, ezarpen honetan zero jarri behar da.';
$string['newuser'] = 'Erabiltzaile berria';
$string['newusernewpasswordsubj'] = 'Erabiltzaile berriaren kontua';
$string['newusernewpasswordtext'] = 'Kaixo, {$a->firstname}:

Kontu berria ireki zaizu \'{$a->sitename}\'(e)n eta behin behineko pasahitza ezarri zaizu.

Sartzeko zure datuak ondorengoak dira:
   erabiltzaile-izena: {$a->username}
   pasahitza: {$a->newpassword}
             (pasahitza aldatu beharko duzu
             lehen aldiz sartzen zarenean)

\'{$a->sitename}\' erabiltzen hasteko, egin klik hemen: {$a->link}

Posta elektronikoko programa gehienetan goiko helbidea esteka urdin gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan beharko zenuke. Horrela ez bada, helbidea kopiatu eta zure nabigatzailearen goialdean dagoen helbide-barran itsatsi ezazu.

Agur bero bat \'{$a->sitename}\' guneko kudeatzailearen partez,
{$a->signoff}';
$string['newusers'] = 'Erabiltzaile berriak';
$string['newwindow'] = 'Leiho berria';
$string['next'] = 'Hurrengoa';
$string['nextpage'] = 'Hurrengo orria';
$string['nextsection'] = 'Hurrengo atala';
$string['no'] = 'Ez';
$string['noblockstoaddhere'] = 'Ez dago orri honetara gehi dezakezun blokerik.';
$string['nobody'] = 'Inor ez';
$string['nochange'] = 'Ez dago aldaketarik';
$string['nocomments'] = 'Iruzkinik ez';
$string['nocourses'] = 'Ez dago ikastarorik';
$string['nocoursesfound'] = '\'{$a}\' hitza duen ikastarorik ez dago';
$string['nocoursestarttime'] = 'Ikastaroak ez du hasiera-datarik.';
$string['nocoursesyet'] = 'Ez dago ikastarorik kategoria honetan';
$string['nodstpresets'] = 'Kudeatzaileak Daylight Savings Time aukera ez du indarrean jarri';
$string['nofilesselected'] = 'Berreskuratzeko fitxategirik aukeratu gabe';
$string['nofilesyet'] = 'Ez da fitxategirik igo zure ikastarora oraindik';
$string['nofiltersapplied'] = 'Ez da iragazkirik aplikatu';
$string['nograde'] = 'Kalifikaziorik ez';
$string['nohelpforactivityorresource'] = 'Une honetan ez dago baliabide edo jarduera horrekin lotutako laguntzarik';
$string['noimagesyet'] = 'Ez da irudirik igo zure ikastarora oraindik';
$string['nologsfound'] = 'Ez da erregistrorik aurkitu';
$string['nomatchingusers'] = 'Ez da \'{$a}\' erabiltzailerik aurkitu';
$string['nomorecourses'] = 'Ezin ikastaro gehiago aurkitu bilaketaren arabera';
$string['nomoreidnumber'] = 'ID zenbakirik ez da erabiltzen arazoak saihesteko';
$string['none'] = 'Bat ere ez';
$string['noneditingteacher'] = 'Edizio-baimenik gabeko irakaslea';
$string['noneditingteacherdescription'] = 'Editatzeko baimenik gabeko irakasleek ikastaroetan irakatsi dezakete eta ikasleak kalifikatu ditzakete, baina ezin dituzte jarduerak aldatu.';
$string['nonstandard'] = 'Ez-estandarra';
$string['nopendingcourses'] = 'Ez dago onartu gabeko ikastarorik';
$string['nopotentialadmins'] = 'Ez dago kudeatzaile posiblerik';
$string['nopotentialcreators'] = 'Ez dago ikastaro-sortzaile posiblerik';
$string['nopotentialstudents'] = 'Ez dago ikasle posiblerik';
$string['nopotentialteachers'] = 'Ez dago irakasle posiblerik';
$string['norecentactivity'] = 'Ez dago duela gutxiko aktibitaterik';
$string['noreplybouncemessage'] = '\'no-reply\' helbide elektroniko batera erantzun duzu. Foro bateko mezuari erantzuten saiatu bazara, mesedez, erantzun {$a} foroa erabiliz.

Hau da zure e-mailaren edukia:';
$string['noreplybouncesubject'] = '{$a} - hartzaileari itzulitako e-maila.';
$string['noreplyname'] = 'Ez erantzun e-mail honi';
$string['noresetrecord'] = 'Ez dago berrezartze eskari horretarako erregistrorik. Mesedez pasahitz berria bat lortzeko eskari berria hasi.';
$string['noresults'] = 'Emaitzarik ez';
$string['normal'] = 'Arrunta';
$string['normalfilter'] = 'Bilaketa arrunta';
$string['nosite'] = 'Ez da aurkitu gune mailako ikastarorik';
$string['nostudentsfound'] = 'Ez da {$a} aurkitu';
$string['nostudentsingroup'] = 'Ikaslerik ez oraindik talde honetan';
$string['nostudentsyet'] = 'Oraindik ez dago ikaslerik matrikulatuta ikastaro honetan.';
$string['nosuchemail'] = 'Ez dago horrelako helbide elektronikorik';
$string['notavailable'] = 'Ez dago eskuragarri';
$string['notavailablecourse'] = '{$a} ez dago eskuragarri';
$string['noteachersyet'] = 'Ez dago irakaslerik ikastaro honetan oraindik';
$string['noteachingupcomingcourses'] = 'Laster hasiko diren ikastaroek ez dute ikasle edo irakaslerik';
$string['notenrolled'] = '{$a} ez da ikastaro honetako partaide.';
$string['notenrolledprofile'] = 'Profil hau ez da eskuragarria erabiltzailea ez baitago ikastaro honetan matrikulatuta.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Oharra:</strong> Segurtasun-kopia hau berreskuratzean datak aldatzeko aukera desgaitu da behar den baimena ez duzulako.';
$string['noteuserschangednonetocourse'] = '<strong>Oharra:</strong>: Ikastaroko erabiltzaileen datuak berrezarritakoan ikastaroetako erabiltzaileak ere berrezarri beharra dago (ekintza, fitxategi edo mezuetan). Konfigurazio hau zuretzat aldatu da.';
$string['nothingnew'] = 'Ez dago duela gutxiko aktibitaterik';
$string['nothingtodisplay'] = 'Erakustekorik ez';
$string['notice'] = 'Abisua';
$string['noticenewerbackup'] = 'Segurtasun-kopia egin zeneko Moodleko bertsioa {$a->backuprelease} da, ({$a->backupversion}) eta bertsio hori instalatutako Moodle bertsioa baino berriagoa da {$a->serverrelease} ({$a->serverversion}). Honek arazoak sor litzake ezin delako bermatu segurtasun-kopien atzera begirako bateragarritasuna.';
$string['notifications'] = 'Jakinarazpenak';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Erabiltzailea: {$a->info}, Erabiltzailearen izen osoa: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Erregistro horiek ikusteko hona jo: {$a}';
$string['notifyloginfailuresmessagestart'] = '{$a} (e)n sarrera okerren zerrenda azken oharra bidali zitzaizunetik';
$string['notifyloginfailuressubject'] = '{$a} :: Sarrera okerren jakinarazpena';
$string['notincluded'] = 'Ez dago barne';
$string['notingroup'] = 'Sentitzen dugu, baina taldekide izan behar duzu orri hau ikusteko.';
$string['notpublic'] = 'Ez da publikoa!';
$string['nousersfound'] = 'Ez da erabiltzailerik aurkitu';
$string['nousersmatching'] = 'Ez da aurkitu \'{$a}\' duen erabiltzailerik';
$string['nousersyet'] = 'Ez dago erabiltzailerik oraindik';
$string['novalidcourses'] = 'Ez dago balio duen ikastarorik erakusteko';
$string['now'] = 'Orain';
$string['numattempts'] = '{$a} sarrera-saiakera oker';
$string['numberofcourses'] = 'Ikastaro-kopurua';
$string['numberweeks'] = 'Atal-kopurua';
$string['numday'] = '{$a} egun';
$string['numdays'] = '{$a} egun';
$string['numhours'] = '{$a} ordu';
$string['numletters'] = '{$a} letra';
$string['numminutes'] = '{$a} minutu';
$string['nummonth'] = '{$a} hilabete';
$string['nummonths'] = '{$a} hilabete';
$string['numseconds'] = '{$a} segundo';
$string['numviews'] = '{$a} ikuspen';
$string['numweek'] = '{$a} aste';
$string['numweeks'] = '{$a} aste';
$string['numwords'] = '{$a} hitz';
$string['numyear'] = '{$a} urte';
$string['numyears'] = '{$a} urte';
$string['ok'] = 'Ados';
$string['oldpassword'] = 'Oraingo pasahitza';
$string['olduserdirectory'] = 'Erabiltzaileen direktorio ZAHARRA da hau eta dagoeneko ez da beharrezkoa. Lasai ezaba dezakezu. Dituen fitxategiak erabiltzaile direktorio BERRIAn kopiatu dira.';
$string['opendrawerblocks'] = 'Zabaldu blokeen nabigazio-kutxa';
$string['opendrawerindex'] = 'Zabaldu ikastaroaren aurkibidea';
$string['opensinnewwindow'] = 'Leiho berri batean irekitzen da';
$string['optional'] = 'hautazkoa';
$string['options'] = 'aukerak';
$string['order'] = 'Ordena';
$string['originalpath'] = 'Jatorrizko bidea';
$string['orphanedactivitiesinsectionno'] = 'Jarduera umezurtzak ({$a} atala)';
$string['other'] = 'Besteak';
$string['outline'] = 'Laburpena';
$string['outlinereport'] = 'Laburpen-txostena';
$string['page'] = 'Orria';
$string['pagea'] = '{$a}. orria';
$string['pagedcontentnavigation'] = 'Orrien bidezko nabigazioa';
$string['pagedcontentnavigationactiveitem'] = 'Oraingo orria, {$a}. orria';
$string['pagedcontentnavigationitem'] = 'Joan {$a} orrira';
$string['pagedcontentpagingbaritemsperpage'] = 'Erakutsi {$a} elementu orriko';
$string['pageheaderconfigablock'] = 'Blokea hemen konfiguratzen: {$a->fullname}';
$string['pagepath'] = 'Orriaren bidea';
$string['pageshouldredirect'] = 'Orri hau automatikoki birbideratu da. Ezer ateratzen ez bada, mesedez, erabili beheko esteka aurrera egiteko.';
$string['parentcategory'] = 'Goragoko kategoria';
$string['parentcoursenotfound'] = 'Goragoko ikastaroa ez da aurkitu!';
$string['parentfolder'] = 'Goragoko karpeta';
$string['participants'] = 'Partaideak';
$string['participantscount'] = 'Partaide-kopurua: {$a}';
$string['participantslist'] = 'Partaideen zerrenda';
$string['participationratio'] = 'Partaidetza-ratioa';
$string['participationreport'] = 'Partaidetza-txostena';
$string['password'] = 'Pasahitza';
$string['passwordchanged'] = 'Pasahitza aldatu da';
$string['passwordconfirmchange'] = 'Baieztatu pasahitzaren aldaketa';
$string['passwordextlink'] = 'Esteka honek galdutako pasahitza errekuperatzeko balio du eta Moodletik ateratzen behartzen zaitu.';
$string['passwordforgotten'] = 'Ahaztutako pasahitza';
$string['passwordforgotteninstructions'] = 'Zure datuak lehenik erabiltzaileen datu-basean bilatu behar dira. Zure erabiltzaile-izena <strong>edo</strong> helbide elektronikoa dagokion lekuan idatzi, mesedez. Biak idaztea ez da beharrezkoa.';
$string['passwordforgotteninstructions2'] = 'Pasahitza berritzeko, zure erabiltzaile-izena edo helbide elektronikoa erabil ditzakezu. Datu-basean aurkitzen bazaitugu, plataformara berriro sartzeko argibideak helbide elektronikora bidaliko dizkizugu.';
$string['passwordnohelp'] = 'Ezin izan da galdu duzun pasahitza aurkitu. Moodleren kudeatzailearekin harremanetan jarri, mesedez.';
$string['passwordpolicynomatch'] = 'Zure une honetako pasahitzak ez du oraingo pasahitzen politika betetzen.
   {$a}';
$string['passwordrecovery'] = 'Bai, laguntza behar dut saioa hasteko';
$string['passwordsdiffer'] = 'Pasahitz hauek ez datoz bat';
$string['passwordsent'] = 'Pasahitza bidali da';
$string['passwordsenttext'] = '<p>E-mailu bat bidali da honako helbide honetara {$a->email}.</p>
<p><b>Mesedez begiratu zure posta elektronikoa pasahitz berria lortzeko</b></p>
<p>Pasahitz berria automatikoki sortu da eta agian <a href="{$a->link}">gogoratzeko errazagoa den batera aldatu</a> nahi duzu.</p>';
$string['passwordset'] = 'Zure pasahitza berrezarri da.';
$string['path'] = 'Bidea';
$string['pathnotexists'] = 'Zure zerbitzarian ez dago horrelako biderik!';
$string['pathslasherror'] = 'Bidea ezin da barraz amaitu!';
$string['paymentinstant'] = 'Erabili beheko botoia ordaindu eta minutu gutxitan matrikulatzeko!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> amaitu gabe</small>)';
$string['paymentrequired'] = 'Ikastaro hau ordainpekoa da';
$string['payments'] = 'Ordainketak';
$string['paymentsorry'] = 'Mila esker ordainketarengatik! Zoritxarrez zure ordainketa ez da guztiz prozesatu, eta "{$a->fullname}" ikastaroan ez zaude matrikulaturik. Segundo batzuk barru berriz sartu, mesedez. Arazoekin jarraitzen baduzu {$a->teacher} irakaslearekin edo gunearen kudeatzailearekin harremanetan jarri';
$string['paymentthanks'] = 'Mila esker ordainketarengatik! Ikastaro honetan matrikulatuta zaude:<br />"{$a}"';
$string['pendingrequests'] = 'Zain dauden eskariak';
$string['percents'] = '%{$a}';
$string['periodending'] = 'Epe-amaiera ({$a})';
$string['perpage'] = 'Orriko';
$string['perpagea'] = 'Orriko: {$a}';
$string['personal'] = 'Pertsonala';
$string['personalprofile'] = 'Norberaren profila';
$string['phone'] = 'Telefonoa';
$string['phone1'] = 'Telefonoa';
$string['phone2'] = 'Telefono mugikorra';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = '{$a}-ren irudia';
$string['pictureofuser'] = 'Erabiltzailearen irudia';
$string['pleaseclose'] = 'Mesedez, orain itxi leiho hau.';
$string['pleasesearchmore'] = 'Mesedez, bilatu berriz';
$string['pleaseusesearch'] = 'Mesedez, erabili bilaketa';
$string['plugin'] = 'Plugina';
$string['plugincheck'] = 'Pluginen egiaztatzea';
$string['plugindeletefiles'] = '\'{$a->name}\' pluginarekin lotutako datu guztiak ezabatu egin dira datu-basetik. Berriz ere plugina instalatzea ekiditeko, zure zerbitzaritik ondorengo direktorioa ezabatu beharko zenuke: {$a->directory}';
$string['pluginsetup'] = 'Plugin-taulak zehazten';
$string['policyaccept'] = 'Ulertu dut eta ados nago';
$string['policyagree'] = 'Gune hau erabiltzen jarraitu aurretik politika honi onespena eman behar diozu. Ados al zaude?';
$string['policyagreement'] = 'Guneko politiken onespena';
$string['policyagreementclick'] = 'Guneko politikak irakurtzeko esteka';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Ireki fitxategia leiho berrian';
$string['popupwindowname'] = 'Popup leihoa';
$string['post'] = 'Mezua';
$string['posts'] = 'Mezuak';
$string['potentialadmins'] = 'Balizko kudeatzaileak';
$string['potentialcreators'] = 'Balizko ikastaro-sortzaileak';
$string['potentialstudents'] = 'Balizko ikasleak';
$string['potentialteachers'] = 'Balizko irakasleak';
$string['poweredbymoodle'] = '<a href="https://moodle.com">Moodle</a>k garatua';
$string['preferences'] = 'Aukerak';
$string['preferredlanguage'] = 'Lehenetsitako hizkuntza';
$string['preferredtheme'] = 'Lehenetsitako azala';
$string['preprocessingbackupfile'] = 'Segurtasun-kopiaren fitxategia aurre-prozesatzen';
$string['prev'] = 'Aurrekoa';
$string['preview'] = 'Aurreikusi';
$string['previeworchoose'] = 'Aurreikusi edo aukeratu azal bat';
$string['previous'] = 'Aurrekoa';
$string['previouslyselectedusers'] = 'Lehenago aukeratutako erabiltzaileak eta \'{$a}\'-rekin bat ez datozenak';
$string['previouspage'] = 'Aurreko orria';
$string['previoussection'] = 'Aurreko atala';
$string['primaryadminsetup'] = 'Kudeatzailearen kontuaren ezarpenak';
$string['privacy:metadata:config_log'] = 'Konfigurazio-aldaketen erregistroa.';
$string['privacy:metadata:config_log:name'] = 'Konfigurazio-aldaketaren izena.';
$string['privacy:metadata:config_log:oldvalue'] = 'Ezarpenaren aurreko balioa.';
$string['privacy:metadata:config_log:plugin'] = 'Aldatutako plugina.';
$string['privacy:metadata:config_log:timemodified'] = 'Aldaketa egin zeneko unea.';
$string['privacy:metadata:config_log:userid'] = 'Aldaketa egin zuen erabiltzailea.';
$string['privacy:metadata:config_log:value'] = 'Ezarpenaren balio berria.';
$string['privacy:metadata:events_queue'] = 'Ilaran prozesatzeko zai dauden erabiltzaile-ekitaldiak.';
$string['privacy:metadata:events_queue:eventdata'] = 'Ekitaldian gordetako datuak.';
$string['privacy:metadata:events_queue:stackdump'] = 'Ekitaldi honen egoerarekin lotutako pilaren edozein arrasto.';
$string['privacy:metadata:events_queue:timecreated'] = 'Ekitaldi hau sortu zeneko unea.';
$string['privacy:metadata:events_queue:userid'] = 'Ekitaldi hau sortu zuen erabiltzailearen IDa';
$string['privacy:metadata:log'] = 'Igarotako ekitaldien bilduma';
$string['privacy:metadata:log:action'] = 'Ekintzaren deskribapena';
$string['privacy:metadata:log:cmid'] = 'Ikastaro-moduluaren IDa';
$string['privacy:metadata:log:course'] = 'Ikastaroa';
$string['privacy:metadata:log:info'] = 'Informazio gehigarria';
$string['privacy:metadata:log:ip'] = 'Ekitaldiaren unean erabilitako IP helbidea';
$string['privacy:metadata:log:module'] = 'Modulua';
$string['privacy:metadata:log:time'] = 'Ekintza gertatu zeneko unea';
$string['privacy:metadata:log:url'] = 'Ekitaldiarekin lotutako URLa';
$string['privacy:metadata:log:userid'] = 'Ekintza egin zuen erabiltzailearen IDa';
$string['privacy:metadata:oauth2_refresh_token'] = 'Freskatu OAuth 2.0 komunikazioan erabilitako tokena';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Tokenari dagokion erabiltzailearen IDa';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Tokenari dagokion erabiltzailearen IDa';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Tokena sortu zeneko unea';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Tokena eguneratu zeneko unea';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Dagozkion esparru eta erabiltzaileari dagokion freskatze-tokena';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Tokena dagokion erabiltzailearen IDa';
$string['privacy:metadata:task_adhoc'] = 'Ad hoc atazen egoera.';
$string['privacy:metadata:task_adhoc:component'] = 'Atazaren jabea den osagaia.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Ataza exekutatzeko lehenbiziko unea.';
$string['privacy:metadata:task_adhoc:userid'] = 'Ataza exekutatuko duen erabiltzailea.';
$string['privacy:metadata:task_log'] = 'Erregistro batentzako irteera';
$string['privacy:metadata:task_log:component'] = 'Atazaren jabea den osagaia.';
$string['privacy:metadata:task_log:userid'] = 'Atazari dagokion erabiltzailea.';
$string['privacy:metadata:upgrade_log'] = 'Eguneraketen erregistroa.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Eguneraketa-pauso honekin lotutako pilaren edozein arrasto.';
$string['privacy:metadata:upgrade_log:details'] = 'Eguneraketarekin lotutako informazio gehigarria.';
$string['privacy:metadata:upgrade_log:info'] = 'Eguneraketa-pauso honekin lotutako informazio nagusia.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Eguneratu den plugina.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Eguneratzeko bertsio berria.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Eguneraketa egin zen unea.';
$string['privacy:metadata:upgrade_log:type'] = 'Erregistroaren sarrera mota.';
$string['privacy:metadata:upgrade_log:userid'] = 'Eguneraketa egin zuen erabiltzailea.';
$string['privacy:metadata:upgrade_log:version'] = 'Pluginaren bertsio zaharra.';
$string['private_files_handler'] = 'E-mail bateko eranskinak erabiltzailearen gune pribatuan metatzen ditu.';
$string['private_files_handler_name'] = 'Bidali fitxategiak posta elektroniko bidez Gune Pribatura';
$string['privatefiles'] = 'Fitxategi pribatuak';
$string['privatefilesmanage'] = 'Kudeatu fitxategi pribatuak';
$string['proceed'] = 'Jarraitu';
$string['profile'] = 'Profila';
$string['profilenotshown'] = 'Profilaren deskribapena ez da erakutsiko harik eta pertsona hau gutxienez ikastaro batean matrikulatuta egon arte';
$string['publicprofile'] = 'Profil publikoa';
$string['publicsitefileswarning'] = 'Oharra: hemen kokatutako fitxategiak edonork ikus ditzake';
$string['publicsitefileswarning2'] = 'Oharra: Hemen kokatutako fitxategiak URLa ezagutzen duen (edo bisita dezakeen) edonoren esku egongo dira. Segurtasunagatik, gomendagarria da segurtasun-kopiaren fitxategiak berreskuratu ondoren berehala ezabatzea.';
$string['publicsitefileswarning3'] = 'Oharra: Hemen kokatutako fitxategiak URLa ezagutzen duen (edo bisita dezakeen) edonoren esku egongo dira. <br />Segurtasunagatik, segurtasun-kopiaren fitxategiak soilik backupdata karpetan gorde beharko lirateke.';
$string['question'] = 'Galdera';
$string['questionsinthequestionbank'] = 'Galderak galdera-bankuan';
$string['queued'] = 'Ilaran';
$string['quotausage'] = 'Une honetan {$a->used} erabili dituzu, eta zure muga {$a->total} da.';
$string['readinginfofrombackup'] = 'Informazioa irakurtzen segurtasun-kopiatik';
$string['readme'] = 'IrakHau';
$string['recentactivity'] = 'Duela gutxiko aktibitatea';
$string['recentactivityreport'] = 'Duela gutxiko aktibitatearen txosten osoa';
$string['recipientslist'] = 'Jasotzaileen zerrenda';
$string['recommended'] = 'Gomendatutakoak';
$string['recreatedcategory'] = 'Berrezarritako kategoria {$a}';
$string['redirect'] = 'Berbideratu';
$string['reducesections'] = 'Txikitu atal-kopurua';
$string['refresh'] = 'Freskatu';
$string['refreshingevents'] = 'Ekitaldiak freskatzen';
$string['registration'] = 'Moodle Erregistroa';
$string['registrationcontact'] = 'Publikoaren kontaktua';
$string['registrationcontactno'] = 'Ez, ez dut beste jenderik nirekin harremanetan jartzea';
$string['registrationcontactyes'] = 'Bai, beste Moodlezale batzuk nirekin harremanetan jar daitezen formulario bat egotea nahi dut';
$string['registrationemail'] = 'Posta elektroniko bidezko jakinarazpenak';
$string['registrationinfo'] = '<p>Orria honek zure webgunea moodle.org-en erregistratzea ahalbidetzen dizu.
Erregistroa doakoa da. Izango duzun etekina zure webgunea posta-zerrenda batean sartzea da, ohar garrantzitsu,
segurtasun-jakinarazpenak eta Moodleko eskaintzak jasotzeko.</p>
<p>Zure informazioa konfidentziala izango da, eta ez zaio inoiz inori salduko edo helaraziko. Informazio hau biltzeko
arrazoi bakarra zu lagundu eta Moodle komunitatearen koadro estatistikoa sortzea da.</p>
<p>Nahi izanez gero, zure webgunearen izenburua, herria eta URLa idatz ditzakezu Moodle erabiltzen duten guneen zerrenda agertzeko.</p>
<p>Erregistro guztiak eskuz egiaztatzen dira zerrendan azaldu aurretik, baina bertan daudenean (eta zure datuak zerrenda publikoan) formulario hau beteta edonoiz datuak alda ditzakezu.</p>';
$string['registrationinfotitle'] = 'Erregistroaren informazioa';
$string['registrationno'] = 'Ez, ez dut e-mailik jaso nahi';
$string['registrationsend'] = 'Bidali nire erregistro-informazioa moodle.org-era';
$string['registrationyes'] = 'Bai, Moodle bertsio berrien kaleratzeen, segurtasun-alerten eta bestelako berri garrantzitsuen jakinarazpenak jaso nahi ditut';
$string['reject'] = 'Ez onartu';
$string['rejectdots'] = 'Ez onartu...';
$string['relativedatesmode'] = 'Data-erlatiboen modua';
$string['relativedatesmode_help'] = 'Erakutsi ikastaroaren edo jardueren datak erabiltzailearen ikastaroaren hasirra-datarekiko erlatiboak.

Erabiltzailearen hasiera-data bere matrikulazio-data izango da ikastaroaren hasiera-data baino lehen matrikulatu ez bada, bestela ikastaroaren hasiera-data izango da.

OHARRA: Funtzio hau esperimentala da eta baliteke jarduera guztiek ez onartzea. Behin ikastaroa sortuta dagoenean, ezarpen hau ezin da aldatu.';
$string['relativedatesmode_warning'] = '<strong>Oharra:</strong> Data erlatiboen modua ezin da aldatu ikastaroa sortu ondoren.';
$string['reload'] = 'Berriz kargatu';
$string['remoteappuser'] = 'Urrutiko {$a} erabiltzailea';
$string['remove'] = 'Kendu';
$string['removeadmin'] = 'Kendu kudeatzailea';
$string['removecreator'] = 'Kendu Ikastaro-sortzailea';
$string['removestudent'] = 'Kendu ikaslea';
$string['removeteacher'] = 'Kendu irakaslea';
$string['rename'] = 'Aldatu izena';
$string['renamefileto'] = 'Aldatu <b>{$a}</b> izena honetara:';
$string['report'] = 'Txostena';
$string['reports'] = 'Txostenak';
$string['reporttype'] = 'Txosten-mota';
$string['repositories'] = 'Biltegiak';
$string['requestcourse'] = 'Eskatu ikastaro bat';
$string['requestedby'] = 'Honek eskatua:';
$string['requestedcourses'] = 'Eskatutako ikastaroak';
$string['requestreason'] = 'Ikastaroa eskatzeko arrazoia';
$string['requests'] = 'Eskariak';
$string['required'] = 'Beharrezkoa';
$string['requirespayment'] = 'Ikastaro hau ordainpekoa da';
$string['resendemail'] = 'Berriz bidali e-maila';
$string['reset'] = 'Berrabiarazi';
$string['resetcomponent'] = 'Osagaia';
$string['resetcourse'] = 'Berrabiarazi ikastaroa';
$string['resetinfo'] = 'Orri honek ikastaroa erabiltzaile-datuz husteko aukera ematen dizu, jarduerak eta beste ezarpen batzuk mantenduta. Mesedez, egin kontu beheragoko elementuak aukeratuta eta ikastaroa berrabiaraziz gero ikastaro honetatik aukeratutako elementuetako erabiltzaileen datuak behin betiko ezabatuko dituzula.';
$string['resetnotimplemented'] = 'Berrabiaraztea ez dago inplementatuta';
$string['resetrecordexpired'] = 'Pasahitza berrezartzeko erabili duzun esteka {$a} minutu baino zaharragoa da eta iraungita dago. Mesedez pasahitz berria bat lortzeko eskari berria hasi.';
$string['resetstartdate'] = 'Aldatu hasiera-data';
$string['resetstatus'] = 'Egoera';
$string['resettable'] = 'Berrabiarazi taularen hobespenak';
$string['resettask'] = 'Ataza';
$string['resettodefaults'] = 'Berrezarri berezko balioak';
$string['resortcourses'] = 'Ordenatu ikastaroak';
$string['resortsubcategoriesby'] = 'Ordenatu azpikategoriak {$a}(r)en arabera gorantz';
$string['resortsubcategoriesbyreverse'] = 'Ordenatu azpikategoriak {$a}(r)en arabera beherantz';
$string['resource'] = 'Baliabidea';
$string['resourcedisplayauto'] = 'Automatikoa';
$string['resourcedisplaydownload'] = 'Behartu jaistera';
$string['resourcedisplayembed'] = 'Enbotatu';
$string['resourcedisplayframe'] = 'Markoan';
$string['resourcedisplaynew'] = 'Leiho berria';
$string['resourcedisplayopen'] = 'Ireki';
$string['resourcedisplaypopup'] = 'Pop-up-ean';
$string['resources'] = 'Baliabideak';
$string['resources_help'] = 'Baliabideek ikastaroan ia edozein web-eduki txertatzea ahalbidetzen dute.';
$string['restore'] = 'Berreskuratu';
$string['restorecancelled'] = 'Berreskuraketa bertan behera';
$string['restorecannotassignroles'] = 'Berreskuratzeko rolek esleituta egon behar dute eta zuk ez duzu baimenik horretarako';
$string['restorecannotcreateorassignroles'] = 'Berreskuratzeko rolak sortu edo esleitu behar dira eta zuk ez duzu baimenik horretarako';
$string['restorecannotcreateuser'] = 'Berreskuratzeko \'{$a}\' erabiltzailea sortu behar da segurtasun-kopiaren fitxategitik eta zuk ez duzu horretarako baimenik';
$string['restorecannotoverrideperms'] = 'Berreskuratzeko baimenak baliogabetu behar dira eta zuk ez duzu horretarako baimenik';
$string['restorecoursenow'] = 'Berreskuratu ikastaroa orain!';
$string['restoredaccount'] = 'Berreskuratutako kontua';
$string['restoredaccountinfo'] = 'Kontu hau beste zerbitzari batetik inportatu zen eta pasahitza galdu egin da. Pasahitz berria posta elektroniko bidez ezartzeko, mesedez egin klik "Jarraitu" botoian';
$string['restorefinished'] = 'Berreskuraketa ondo egina';
$string['restoremnethostidmismatch'] = '\'{$a}\' erabiltzailearen MNet ostalari id-a ez dator bat MNet ostalari lokararekin.';
$string['restoreto'] = 'Berreskuratu hona:';
$string['restoretositeadding'] = 'Kontuz: gunearen hasiera-orria berreskuratzear zaude, datuak gehituz!';
$string['restoretositedeleting'] = 'Kontuz: gunearen hasiera-orria berreskuratzear zaude, lehenagoko informazioa ezabatuz!';
$string['restoreuserconflict'] = '\'{$a}\' erabiltzailea segurtasun-kopiaren fitxategitik berreskuratzeak gatazka sortuko du';
$string['restoreuserinfofailed'] = 'Berreskuratze-prozesua eten egin da zuk ez duzulako erabiltzaileen datuak berreskuratzeko baimenik.';
$string['restoreusersprecheck'] = 'Erabiltzaile-datuak egiaztatzen';
$string['restoreusersprecheckerror'] = 'Erabiltzaile-datuak egiaztatzean arazoak atzeman dira';
$string['restricted'] = 'Eskuragarritasun murriztua';
$string['resultsfound'] = '{$a} emaitza aurkitu dira';
$string['retry'] = 'Saiatu berriro';
$string['returningtosite'] = 'Izena emandako erabiltzaileak';
$string['returntooriginaluser'] = 'Itzuli hona: {$a}';
$string['revert'] = 'Itzuli lehengora';
$string['role'] = 'Rola';
$string['roleassignments'] = 'Rol-esleipenak';
$string['rolemappings'] = 'Rolen loturak';
$string['rolerenaming'] = 'Rolen berrizendaketa';
$string['rolerenaming_help'] = 'Ikastaroan erabiltzen diren rolei izena aldatzeko aukera emango dizu ezarpen honek. Soilik erakusten den izena aldatzen da, azpiko rol-baimenei ez die eragingo. Rolaren izen berria ikastaroko partaideen orrian agertuko da eta ikastaroko gainontzeko tokietan. Kudeatzaileak berrizendatutako rola ikastaroaren kudeatzaile-rola gisa aukeratutakoa bada, rolaren izen berria ikastaroen zerrendan ere agertuko da.';
$string['roles'] = 'Rolak';
$string['rss'] = 'RSS (jarioak)';
$string['rssarticles'] = 'RSS jario berrien kopurua';
$string['rsserror'] = 'Errorea jarioa irakurtzerakoan';
$string['rsserrorauth'] = 'Zure RSS estekak ez du autentifikazio-token baliagarririk.';
$string['rsserrorguest'] = 'Jario honek gonbidatu-sarbidea erabiltzen du datuetara iristeko, baina gonbidatuak ez du baimenik datuak irakurtzeko. Jario honen jatorrizko kokapenera joan (URL) erabiltzaile onargarri bat erabiliz eta RSS esteka berri bat lortu.';
$string['rsskeyshelp'] = '<p>Segurtasuna eta pribatutasuna bermatzeko, RSS jarioen URLek token berezi bat dute, nori bideratua den identifikatzeko. Horrela, beste erabiltzaileek ezin izango dute atzipenik RSS bidez sartu behar ez diren Moodle ataletara.</p><p>Token hau automatikoki sortzen da RSS jarioak sortzen duen atal batera sartzen zaren lehen aldian. Uste baduzu RSS jarioaren tokena norbaiten eskuetara iritsi dela, beste token bat eskatu dezakezu berrezarri botoian klik eginda. Kontuan izan hori eginez gero oraingo RSS jarioaren URLak ez duela gehiago balioko.</p>';
$string['rsstype'] = 'RSS jarioak jarduera honetan';
$string['save'] = 'Gorde';
$string['saveandnext'] = 'Gorde eta erakutsi hurrengoa';
$string['savechanges'] = 'Gorde aldaketak';
$string['savechangesanddisplay'] = 'Gorde eta erakutsi';
$string['savechangesandreturn'] = 'Gorde eta itzuli';
$string['savechangesandreturntocourse'] = 'Gorde eta itzuli ikastarora';
$string['savecomment'] = 'Gorde iruzkina';
$string['savedat'] = 'Hemen gordeta:';
$string['savepreferences'] = 'Gorde hobespenak';
$string['saveto'] = 'Non gorde';
$string['scale'] = 'Eskala';
$string['scale_help'] = 'Eskalak jarduera bat burutzeko gaitasuna ebaluatu edo puntuatzeko bidea eskaintzen du. Balio-zerrenda ordenatuak definitzen du, negatibotik positibora eta komaz banatuta. Adibidez: "Gutxiegi, Erdipurdi, Nahiko, Ongi, Oso ongi, Bikain".';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Eskalak';
$string['scalescustom'] = 'Eskala pertsonalizatuak';
$string['scalescustomcreate'] = 'Gehitu eskala berria';
$string['scalescustomno'] = 'Zeure eskalarik ez oraindik';
$string['scalesstandard'] = 'Eskala estandarrak';
$string['scalestandard'] = 'Eskala estandarra';
$string['scalestandard_help'] = 'Eskala estandarra gunean, ikastaro guztietan, erabil daiteke.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Zeure eskalak sortzeko erabili "Eskalak..." esteka zure ikastaroaren kudeaketa-menuan.';
$string['scalestip2'] = 'Pertsonalizatutako eskalak sortzeko, egin klik ikastaroaren kudeaketa menuko Kalifikazioak estekan eta aukeratu Editatu, Eskalak';
$string['schedule'] = 'Programazioa';
$string['screenshot'] = 'Pantaila-argazkia';
$string['search'] = 'Bilatu';
$string['search_help'] = 'Testuko edozein tokitan hitz bat edo biko oinarrizko bilaketetarako, idatzi horiek tarte bat utzita. Bi karaktere baino gehiagoko hitz guztiak erabiltzen dira.

Bilaketa aurreraturako, egin klik bilatu botoian bilaketarako kutxatxoan ezer idatzi gabe eta bilaketa aurreraturako formulariora joango zara.';
$string['searchactivities'] = 'Bilatu jarduerak izena edo deskribapenaren arabera';
$string['searchagain'] = 'Bilatu berriro';
$string['searchbyemail'] = 'Bilatu helbide elektronikoaren arabera';
$string['searchbyusername'] = 'Bilatu erabiltzaile-izenaren arabera';
$string['searchcoursecategories'] = 'Bilatu kategoriak';
$string['searchcourses'] = 'Bilatu Ikastaroak';
$string['searchoptions'] = 'Bilaketaren aukerak';
$string['searchresults'] = 'Bilaketaren emaitzak';
$string['sec'] = 'seg';
$string['seconds'] = 'segundo';
$string['secondsleft'] = '{$a} segundo';
$string['secondstotime172800'] = '2 egun';
$string['secondstotime259200'] = '3 egun';
$string['secondstotime345600'] = '4 egun';
$string['secondstotime432000'] = '5 egun';
$string['secondstotime518400'] = '6 egun';
$string['secondstotime604800'] = 'astebete';
$string['secondstotime86400'] = 'egun bat';
$string['secretalreadyused'] = 'Pasahitza aldatzeko berrespen-esteka erabilia izan da dagoeneko, pasahitza ez da aldatu.';
$string['secs'] = 'segundo';
$string['section'] = 'Atala';
$string['sectionactionnotsupported'] = 'Ez da "{$a}" atal-ekintza hemen onartzen';
$string['sectionname'] = 'Atalaren izena';
$string['sections'] = 'Atalak';
$string['seealsostats'] = 'Estatistikak ere ikusi';
$string['selctauser'] = 'Aukertu erabiltzaile bat';
$string['select'] = 'Aukeratu';
$string['selectacategory'] = 'Mesedez, aukeratu kategoria bat';
$string['selectacountry'] = 'Aukeratu herrialde bat';
$string['selectacourse'] = 'Aukeratu ikastaro bat';
$string['selectacoursesite'] = 'Aukeratu ikastaro edo gune bat';
$string['selectagroup'] = 'Aukeratu talde bat';
$string['selectall'] = 'Aukeratu guztiak';
$string['selectallusersonpage'] = 'Aukeratu erabiltzaile guztiak orri honetan';
$string['selectalluserswithcount'] = 'Aukeratu erabiltzaile guztiak ({$a})';
$string['selectamodule'] = 'Baliabide-moduluren bat aukeratu, mesedez';
$string['selectanaction'] = 'Aukeratu ekintza bat';
$string['selectanoptions'] = 'Hautatu aukera bat';
$string['selectaregion'] = 'Aukeratu lurralde bat';
$string['selectcategorysort'] = 'Zein kategoria ordenatu nahi duzu?';
$string['selectcategorysortby'] = 'Erabaki nola ordenatu nahi dituzun kategoriak';
$string['selectcoursesortby'] = 'Aukeratu nola ordenatu nahi dituzun ikastaroak';
$string['selectdefault'] = 'Aukeratu lehenetsitakoa';
$string['selectedcategories'] = 'Aukeratuko kategoriak';
$string['selectedfile'] = 'Aukeratutako fitxategia';
$string['selectednowmove'] = '{$a} fitxategi aukeratu duzu mugitzeko. Zoaz orain nahi duzun karpetara eta egin klik \'Mugitu fitxategiak hona\' botoian';
$string['selectfiles'] = 'Aukeratutako fitxategiak';
$string['selectitem'] = 'Aukeratu \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Aukeratu jarduera edo baliabide bat horren laguntza ikusteko.

Egin klik bikoitza aktibitate edo baliabide baten gainean modu azkarrean gehitzeko.';
$string['selectnos'] = 'Aukeratu \'Ez\' guztiak';
$string['selectperiod'] = 'Aukeratu epea';
$string['senddetails'] = 'Bidali nire xehetasunak posta elektroniko bidez';
$string['separate'] = 'Bereizi';
$string['separateandconnected'] = 'Jakintza-bide banatuak eta elkar lotuak';
$string['separateandconnectedinfo'] = 'Eskala hau banandutako eta konektatutako ezagutzen teorian oinarritzen da. Teoria honek ikusi eta entzuten ditugun gauzak ebaluatu eta ikasteko bi modu deskribatzen ditu.<ul><li><strong>Ikasle bereiziak</strong> ahal bezain objektibo mantentzen dira sentimenduak eta emozioak kontuan hartu gabe. Beste batzuekin eztabaidak izatean euren ideiak defendatzea gustatzen zaie, logika erabiliz aurkariaren logikan hutsuneak bilatzeko.</li><li><strong>Konektatutako ikasleek</strong> beste jendearekiko sentsibilitate handiagoa dute. Enpatia gaitasun handiagoa dute eta entzun eta galderak egiteko joera dute "bestearen ikuspuntutik gauzak ulertzeko" gai direla sentitu arte. Besteengan topatzen duten jakinduria lortzeko esperientziak trukatzen saiatuz ikasten dute.</li></ul>';
$string['servererror'] = 'Errorea gertatu da zerbitzariarekin komunikatzean';
$string['serverlocaltime'] = 'Zerbitzariaren ordu lokala';
$string['sessionforceclean'] = 'Segurtasuna dela-eta, saio honetan erabiltzaileek sortutako script-ak desgaitu dira.';
$string['sessiontimeoutsoon'] = 'Zure saioa iraungitzear dago. Zure oraingo saioa luzatu nahi al duzu?';
$string['setcategorytheme'] = 'Ezarri kategoriko azala';
$string['setmode'] = 'Ezarri modua';
$string['setpassword'] = 'Ezarri pasahitza';
$string['setpasswordinstructions'] = 'Mesedez sartu behean zure pasahitz berria, eta ondoren aldaketak gorde.';
$string['settings'] = 'Ezarpenak';
$string['shortname'] = 'Izen laburra';
$string['shortnamecollisionwarning'] = '[*] = Izen labur hau beste ikastaro batean erabiltzen ari da, eta onartu baino lehen aldatu egin behar da';
$string['shortnamecourse'] = 'Ikastaroaren izen laburra';
$string['shortnamecourse_help'] = 'Ikastaroaren izen laburra nabigazioan erakusten da eta ikastaroaren e-mailetako gaiaren lerroan erabiltzen da.';
$string['shortnametaken'] = 'Izen labur hau beste ikastaro batean erabili dute ({$a})';
$string['shortnameuser'] = 'Erabiltzailearen izen laburra';
$string['shortsitename'] = 'Gunearen izen laburra (adibidez hitz bakarra)';
$string['show'] = 'Erakutsi';
$string['showactions'] = 'Erakutsi ekintzak';
$string['showactivitydates'] = 'Erakutsi jardueraren datak';
$string['showactivitydates_help'] = 'Jardueraren datak beti erakusten dira jarduera-orrian. Ezarpen honek jardueraren datak  ikastaro-orriko jarduera-zerrendan ere jarduera bakoitzaren azpian erakutsiko diren zehazten du.';
$string['showadvancededitor'] = 'Aurreratua';
$string['showadvancedsettings'] = 'Erakutsi ezarpen aurreratuak';
$string['showall'] = 'Erakutsi denak: {$a}';
$string['showallcourses'] = 'Erakutsi ikastaro guztiak';
$string['showallusers'] = 'Erakutsi erabiltzaile guztiak';
$string['showblockcourse'] = 'Erakutsi blokea duten ikastaroen zerrenda';
$string['showcategory'] = 'Erakutsi {$a}';
$string['showchartdata'] = 'Erakutsi grafikoaren datuak';
$string['showcomments'] = 'Erakutsi/ezkutatu iruzkinak';
$string['showcommentsnonjs'] = 'Erakutsi iruzkinak';
$string['showdescription'] = 'Erakutsi deskribapena ikastaroaren orrian';
$string['showdescription_help'] = 'Gaituz gero goiko sarrera / deskribapena ikastaroaren hasiera-orrian agertuko da jarduera / baliabiderako estekaren azpian.';
$string['showgrades'] = 'Erakutsi kalifikazioak ikasleei';
$string['showgrades_help'] = 'Hainbat jarduerek kalifikazioak ezartzea baimentzen dute. Ezarpen honek ikasleak ikastaroko bere kalifikazio guztien zerrenda ikusi ahalko duen zehazten du.';
$string['showingacourses'] = 'Ikastaro guztiak ({$a} ) erakusten ari dira';
$string['showingxofycourses'] = 'Ikastaroak erakusten {$a->start}(e)tik {$a->end}-8e)ra. Denera {$a->total} ikastaro';
$string['showlistofcourses'] = 'Erakutsi ikastaroen zerrenda';
$string['showmodulecourse'] = 'Erakutsi jarduera duten ikastaroen zerrenda';
$string['showoncoursepage'] = 'Erakutsi ikastaro-orrian';
$string['showonly'] = 'Erakutsi soilik';
$string['showperpage'] = 'Erakutsi {$a} orrialdeko';
$string['showpopoverwindow'] = 'Erakutsi popover leihoa';
$string['showrecent'] = 'Erakutsi duela gutxiko aktibitatea';
$string['showreports'] = 'Erakutsi agerraldien txostena';
$string['showreports_help'] = 'Agerraldien txostena partaide bakoitzaren eskuragarri dago eta ikastaroan izan duten partaidetza erakusten du. Izan duten ekarpenen zerrenda modukoa da, foroetan idatzitakoa edo bidalitako zereginak, eta sarbideak ere agertzen dira. Ezarpen honek adierazten du ikasleak bere agerraldien txostena ikus dezakeen profil-orritik.';
$string['showsettings'] = 'Erakutsi ezarpenak';
$string['showtheselogs'] = 'Erakutsi agerraldi hauek';
$string['showthishelpinlanguage'] = 'Erakutsi laguntza hizkuntza honetan: {$a}';
$string['sidepanel'] = 'Alboko panela';
$string['signoutofotherservices'] = 'Deskonektatu guztietatik';
$string['signoutofotherservices_help'] = 'Markatuz gero, web-zerbitzuen bidez kontua erabiltzen dituzten gailu eta sistema guztiak deskonektatuko dira, esaterako mobile aplikazioa.';
$string['since'] = 'Noiztik';
$string['sincelast'] = 'azkeneko sarreratik';
$string['site'] = 'Gunea';
$string['sitedefault'] = 'Gunean lehenetsitakoa';
$string['sitedefaultspecified'] = 'Gunean lehenetsitakoa ({$a})';
$string['siteerrors'] = 'Guneko erroreak';
$string['sitefiles'] = 'Guneko fitxategiak';
$string['sitefilesused'] = 'Ikastaro honetan erabilitako guneko fitxategiak';
$string['sitehome'] = 'Hasiera';
$string['sitelegacyfiles'] = 'Heredatutako guneko fitxategiak';
$string['sitelogs'] = 'Gunearen agerraldiak';
$string['sitenews'] = 'Guneko albisteak';
$string['sitepages'] = 'Guneko orriak';
$string['sitepartlist'] = 'Ez dituzu partaide-zerrenda ikusteko behar diren baimenak';
$string['sitepartlist0'] = 'Partaideen zerrenda ikusteko, guneko irakaslea izan behar duzu';
$string['sitepartlist1'] = 'Partaideen zerrenda ikusteko, irakaslea izan behar duzu';
$string['sites'] = 'Guneak';
$string['sitesection'] = 'Gehitu gai batentzako atala';
$string['sitesettings'] = 'Gunearen ezarpenak';
$string['siteteachers'] = 'Guneko irakasleak';
$string['size'] = 'Tamaina';
$string['sizeb'] = 'byte';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Alde batera utzi da';
$string['skiptocategorylisting'] = 'Salto egin kategoria zerrendara';
$string['skiptocoursedetails'] = 'Salto egin ikastaroaren informazio zehatzera';
$string['skiptocourselisting'] = 'Salto egin ikastaroen zerrendara';
$string['skypeid'] = 'Skype-ren IDa';
$string['socialheadline'] = 'Foro irekia - gai berrienak';
$string['someallowguest'] = 'Ikastaro batzuetan gonbidatuak sar daitezke';
$string['someerrorswerefound'] = 'Daturen bat falta da edo ez da egokia. Zehaztasun gehiagora ikusi behean.';
$string['sort'] = 'Ordenatu';
$string['sortby'] = 'Ordenatze-irizpidea';
$string['sortbyx'] = 'Ordenatu {$a}-ren arabera behetik gora';
$string['sortbyxreverse'] = 'Ordenatu {$a}-ren arabera goitik behera';
$string['sorting'] = 'Ordenatzea';
$string['sourcerole'] = 'Jatorrizko rola';
$string['specifyname'] = 'Izena eman behar duzu derrigor.';
$string['standard'] = 'Estandarra';
$string['starpending'] = '([*] = ikastaroa onarpenaren zain dago)';
$string['startdate'] = 'Ikastaroaren hasiera-data';
$string['startdate_help'] = 'Ezarpen honek astekako ikastaroetan lehenbiziko astea zein izango den zehazten du. Era berean, ikastaroko jardueren agerraldiak noiztik aurrera izango diren eskuragarri zehazten du. Ikastaroa berrabiarazi eta hasiera-data aldatzen bada, ikastaroko data guztiak aldatuko dira hasiera-data berriaren arabera.';
$string['startingfrom'] = 'Matrikulazioaren hasiera-data';
$string['startsignup'] = 'Sortu kontu berri bat';
$string['state'] = 'Estatua / Herrialdea';
$string['statistics'] = 'Estatistikak';
$string['statisticsgraph'] = 'Estatistiken grafikoa';
$string['stats'] = 'Estatistikak';
$string['statslogins'] = 'Sarrerak';
$string['statsmodedetailed'] = 'Ikuspen zehatza (erabiltzailea)';
$string['statsmodegeneral'] = 'Ikuspen orokorra';
$string['statsnodata'] = 'Ez dago datu eskuragarririk ikastaro eta epe honetarako.';
$string['statsnodatauser'] = 'Ikastaro, erabiltzaile eta epe honetarako ez dago datu eskuragarririk.';
$string['statsoff'] = 'Estatistikak ez daude orain gaituta';
$string['statsreads'] = 'Ikuspenak';
$string['statsreport1'] = 'Sarrerak';
$string['statsreport10'] = 'Erabiltzailearen aktibitatea';
$string['statsreport11'] = 'Ikastaro aktiboenak';
$string['statsreport12'] = 'Ikastaro aktiboenak (ponderatuak)';
$string['statsreport13'] = 'Partaidetza handieneko ikastaroak (matrikulazioak)';
$string['statsreport14'] = 'Partaidetza handieneko ikastaroak (mezuak/ikuspenak)';
$string['statsreport2'] = 'Ikuspenak (rol guztiak)';
$string['statsreport3'] = 'Mezuak (rol guztiak)';
$string['statsreport4'] = 'Aktibitate osoa (rol guztiak)';
$string['statsreport5'] = 'Ikaslearen aktibitate osoa (ikuspenak eta mezuak)';
$string['statsreport7'] = 'Erabiltzailearen aktibitatea (ikuspenak eta mezuak)';
$string['statsreport8'] = 'Erabiltzailearen aktibitate osoa';
$string['statsreport9'] = 'Sarrerak (gune eta ikastaroa)';
$string['statsreportactivity'] = 'Aktibitate osoa (rol guztiak)';
$string['statsreportactivitybyrole'] = 'Aktibitate osoa (ikuspen eta mezuak)';
$string['statsreportforuser'] = 'norentzat';
$string['statsreportlogins'] = 'Sarrerak';
$string['statsreportreads'] = 'Ikuspenak (rol guztiak)';
$string['statsreporttype'] = 'Txosten mota';
$string['statsreportwrites'] = 'Mezuak (rol guztiak)';
$string['statsstudentactivity'] = 'Ikaslearen aktibitatea';
$string['statsstudentreads'] = 'Ikaslearen ikuspenak';
$string['statsstudentwrites'] = 'Ikaslearen mezuak';
$string['statsteacheractivity'] = 'Irakaslearen aktibitatea';
$string['statsteacherreads'] = 'Irakaslearen ikuspenak';
$string['statsteacherwrites'] = 'Irakaslearen mezuak';
$string['statstimeperiod'] = 'Denbora-epea - azkena:';
$string['statsuniquelogins'] = 'Sarrea bakarrak';
$string['statsuseractivity'] = 'Aktibitate osoa';
$string['statsuserlogins'] = 'Sarrerak';
$string['statsuserreads'] = 'Ikuspenak';
$string['statsuserwrites'] = 'Mezuak';
$string['statswrites'] = 'Mezuak';
$string['status'] = 'Egoera';
$string['statuscritical'] = 'Kritikoa';
$string['statuserror'] = 'Errorea';
$string['statusinfo'] = 'Informazioa';
$string['statusna'] = 'E/A';
$string['statusok'] = 'Ondo';
$string['statusunknown'] = 'Ezezaguna';
$string['statuswarning'] = 'Oharra';
$string['stringsnotset'] = 'Hurrengo kateak ez dira hemen definitu: {$a}';
$string['studentnotallowed'] = 'Sentitzen dugu, baina ezin duzu ikastaro hau \'{$a}\' gisa sartu';
$string['students'] = 'Ikasleak';
$string['studentsandteachers'] = 'Ikasleak eta irakasleak';
$string['subcategories'] = 'Azpikategoriak';
$string['subcategory'] = 'Azpikategoria';
$string['subcategoryof'] = '{$a}(r)en azpikategoria';
$string['subject'] = 'Gaia';
$string['submit'] = 'Bidali';
$string['success'] = 'Ondo';
$string['successduration'] = 'Ondo ({$a} segundo)';
$string['summary'] = 'Laburpena';
$string['summary_help'] = 'Irakasgaia testu motz batean laburtzearen asmoa da ikasleak prestatzea irakasgai (edo aste) horretan egingo diren jardueretarako.';
$string['summaryof'] = '{$a}-ren laburpena';
$string['supplyinfo'] = 'Xehetasun gehiago';
$string['suspended'] = 'Kontua etenda';
$string['suspendedusers'] = 'Kontua etenda duten erabiltzaileak';
$string['switchdevicedefault'] = 'Aldatu azal estandarrera';
$string['switchdevicerecommended'] = 'Aldatu zure gailurako gomendatzen den azalera';
$string['switchrolereturn'] = 'Itzuli nire ohiko rolera';
$string['switchroleto'] = 'Aldatu rola...';
$string['switchroleto_help'] = 'Aukeratu rol bat pertsona batek rol hori duenean ikastaroa nola ikusten duen jakiteko.

Kontuan izan ikuspegi hau ez dela perfektua (<a href="https://docs.moodle.org/en/Switch_roles">Ikusi xehetasunak eta alternatibak</a>)';
$string['tag'] = 'Etiketa';
$string['tagalready'] = 'Etiketa hori dagoeneko badago';
$string['tagmanagement'] = 'Gehitu/ezabatu etiketak...';
$string['tags'] = 'Etiketak';
$string['targetrole'] = 'Helburu-rola';
$string['teacheronly'] = '{$a}rentzat soilik';
$string['teacherroles'] = '{$a} (r)en rolak';
$string['teachers'] = 'Irakasleak';
$string['textcopiedtoclipboard'] = 'Testua arbelera kopiatu da';
$string['textediting'] = 'Testu-editorea';
$string['textediting_help'] = 'Atto edo TinyMCE moduko HTML editorea aukeratzen bada, testua sartzeko eremuek edukiak modu errazean gehitzeko botoiak dituen tresna-barra bat izango dute.

\'Testu lauko eremua\' aukeratzen bada testua sartzeko eremuentzako formatu bat aukeratu daiteke, HTML edo Markdown adibidez.

Aukeratu daitezkeen testu editoreen zerrenda gunearen kudeatzaileak zehazten du.';
$string['texteditor'] = 'Erabili web formulario estandarrak';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Testu arrunt formatua';
$string['thanks'] = 'Eskerrik asko';
$string['theme'] = 'Azala';
$string['themes'] = 'Azalak';
$string['themesaved'] = 'Azala berria gorde da';
$string['therearecourses'] = '{$a} ikastaro dago';
$string['thereareno'] = '{$a}  ez dago ikastaro honetan';
$string['thiscategory'] = 'Kategoria hau';
$string['thiscategorycontains'] = 'Kategoria honek ondokoa du';
$string['time'] = 'Ordua';
$string['timecreated'] = 'Sortze-unea';
$string['timecreatedcourse'] = 'Ikastaroaren sorrera unea';
$string['timesplitting:deciles'] = 'Azken hamarrena';
$string['timesplitting:deciles_help'] = 'Analisi-tarte honek ikastaroa hamarrenetan zatitzen du (berdinak diren 10 zati), iragarpen bakoitza soilik aurreko hamarreneko datuetan oinarrituta dagoelarik.';
$string['timesplitting:decilesaccum'] = 'Aurreko hamarren guztiak';
$string['timesplitting:decilesaccum_help'] = 'Analisi-tarte honek ikastaroa hamarrenetan zatitzen du (berdinak diren 10 zati), iragarpen bakoitza aurreko hamarrenetan pilatutako datuetan oinarrituta dagoelarik.';
$string['timesplitting:nosplitting'] = 'Denbora mugarik ez';
$string['timesplitting:nosplitting_help'] = 'Ez da analisi-tarterik zehaztu eredu honetarako.';
$string['timesplitting:onemonthafterstart'] = 'Hasi osteko hilabetea';
$string['timesplitting:onemonthafterstart_help'] = 'Analisi-tarte honek aurreikuspen bat sortzen du analisiaren hasiera-data baino hilabete bat beranduago.';
$string['timesplitting:oneweekafterstart'] = 'Hasi osteko astebetea';
$string['timesplitting:oneweekafterstart_help'] = 'Analisi-tarte honek aurreikuspen bat sortzen du analisiaren hasiera-data baino astebete beranduago.';
$string['timesplitting:past3days'] = 'Azken 3 egunak';
$string['timesplitting:past3days_help'] = 'Analisi-tarte honek aurreikuspenak 3 egunean behin sortzen ditu. Adierazlearen kalkuluak azken 3 egunetan oinarrituko dira.';
$string['timesplitting:pastmonth'] = 'Azken hilabetea';
$string['timesplitting:pastmonth_help'] = 'Analisi-tarte honek aurreikuspenak hilabetean behin sortzen ditu. Adierazlearen kalkuluak azken hilabetean oinarrituko dira.';
$string['timesplitting:pastweek'] = 'Azken astea';
$string['timesplitting:pastweek_help'] = 'Analisi-tarte honek aurreikuspenak astean behin sortzen ditu. Adierazlearen kalkuluak azken astean oinarrituko dira.';
$string['timesplitting:quarters'] = 'Azken laurdena';
$string['timesplitting:quarters_help'] = 'Analisi-tarte honek ikastaroa laurdenetan zatitzen du (berdinak diren 4 zati), iragarpen bakoitza soilik aurreko laurdeneko datuetan oinarrituta dagoelarik.';
$string['timesplitting:quartersaccum'] = 'Aurreko laurden guztiak';
$string['timesplitting:quartersaccum_help'] = 'Analisi-tarte honek ikastaroa laurdenetan zatitzen du (berdinak diren 4 zati), iragarpen bakoitza aurreko laurdenetan pilatutako datuetan oinarritutako dagoelarik.';
$string['timesplitting:singlerange'] = 'Hasieratik amaierara arte';
$string['timesplitting:singlerange_help'] = 'Analisi-tarte honek ikastaro osoa tarte bakar gisa hartzen du';
$string['timesplitting:tenpercentafterstart'] = 'Hasi osteko %10a';
$string['timesplitting:tenpercentafterstart_help'] = 'Analisi-tarte honek aurreikuspen bat sortzen du ikastaroaren %10a osatu ondoren.';
$string['timesplitting:upcoming3days'] = 'Hurrengo 3 egunak';
$string['timesplitting:upcoming3days_help'] = 'Analisi-tarte honek aurreikuspenak 3 egunean behin sortzen ditu. Adierazleen kalkuluak hurrengo 3 egunetan oinarrituko dira.';
$string['timesplitting:upcomingfortnight'] = 'Datorren hamabostaldia';
$string['timesplitting:upcomingfortnight_help'] = 'Analisi-tarte honek aurreikuspenak hamabostaldian behin sortzen ditu. Adierazleen kalkuluak hurrengo hamabostaldian  oinarrituko dira.';
$string['timesplitting:upcomingweek'] = 'Datorren astea';
$string['timesplitting:upcomingweek_help'] = 'Analisi-tarte honek aurreikuspenak astero sortzen ditu. Adierazleen kalkuluak hurrengo astean oinarrituko da.';
$string['timezone'] = 'Ordu eremua';
$string['to'] = 'Nora';
$string['tocontent'] = '"{$a}" elementuaren aurrera';
$string['tocreatenewaccount'] = 'Salto egin kontu berria sortzera';
$string['today'] = 'Gaur';
$string['todaylogs'] = 'Gaurko agerraldiak';
$string['toeveryone'] = 'guztiei';
$string['toggleemojipicker'] = 'Zabaldu/Tolestu emoji hautatzailea';
$string['togglesearch'] = 'Aldatu bilaketa-eremua';
$string['toomanybounces'] = 'Helbide elektroniko honetatik mezu asko bueltatu dira. Jarraitzeko <b>aldatu</b> behar duzu.';
$string['toomanytags'] = 'Bilaketa honek etiketa gehiegi ditu; batzuk ez dira kontuan hartuko.';
$string['toomanytoshow'] = 'Erabiltzaile gehiegi daude erakusteko';
$string['toomanyusersmatchsearch'] = 'Erabiltzaile gehiegi-k ({$a->count}) dute \'{$a->search}\'';
$string['toomanyuserstoshow'] = '({$a}) erabiltzaile gehiegi erakusteko';
$string['toonly'] = 'Honi soilik: {$a}';
$string['top'] = 'Goragokoa';
$string['topic'] = 'Gaia';
$string['topichide'] = 'Ezkutatu gai hau hemendik: {$a}';
$string['topicoutline'] = 'Ikastaroaren edukia';
$string['topicshow'] = 'Erakutsi gai hau {$a}(e)ri';
$string['toplevelcategory'] = 'Goragoko kategoria';
$string['total'] = 'Guztira';
$string['totopofsection'] = '"{$a}" atalaren goiko aldean';
$string['trackforums'] = 'Foroetako irakurri gabeko mezuen jarraipena';
$string['trackforumsno'] = 'Ez, ez egin irakurri gabeko mezuen jarraipena';
$string['trackforumsyes'] = 'Bai, nabarmendu mezu berriak';
$string['trysearching'] = 'Saiatu guneko bilaketa egiten.';
$string['turneditingoff'] = 'Desaktibatu edizioa';
$string['turneditingon'] = 'Aktibatu edizioa';
$string['unabletocopytoclipboard'] = 'Ezin izan da testua arbelera kopiatu';
$string['unauthorisedlogin'] = '"{$a}" erabiltzaile-kontua ez dago eskuragarri gune honetan';
$string['undecided'] = 'Erabaki gabe';
$string['unexistingcmid'] = 'Ikastaro-moduluaren IDa ez da aurkitu';
$string['unexistingsectionid'] = 'Ikastaro-gaiaren IDa ez da aurkitu';
$string['unfinished'] = 'Amaitu gabe';
$string['unknowncategory'] = 'Kategoria ezezaguna';
$string['unknownerror'] = 'Errore ezezaguna';
$string['unknownuser'] = 'Erabiltzaile ezezaguna';
$string['unlimited'] = 'Mugarik gabe';
$string['unpacking'] = '{$a} irekitzen';
$string['unsafepassword'] = 'Pasahitz ez ziurra - besteren bat erabili';
$string['untilcomplete'] = 'Osatu arte';
$string['unusedaccounts'] = '{$a} egun baino gehiagotan erabili ez diren kontuak automatikoki baja dira';
$string['unzip'] = 'Deskonprimatu';
$string['unzippingbackup'] = 'Segurtasun-kopia deskonprimatzen';
$string['up'] = 'Gora';
$string['update'] = 'Eguneratu';
$string['updated'] = '{$a} eguneratuta';
$string['updatemymoodleoff'] = 'Eten orri honen pertsonalizazioa';
$string['updatemymoodleon'] = 'Pertsonalizatu orri hau';
$string['updatemyprofile'] = 'Eguneratu profila';
$string['updatesevery'] = '{$a} segundoro eguneratzen da';
$string['updatethis'] = 'Eguneratu {$a} hau';
$string['updatethiscourse'] = 'Eguneratu ikastaro hau';
$string['updatinga'] = '{$a} eguneratzen';
$string['updatingain'] = '{$a->what} eguneratzen hemen: {$a->in}';
$string['upload'] = 'Igo';
$string['uploadafile'] = 'Igo fitxategi bat';
$string['uploadcantwrite'] = 'Errorea fitxategia diskoan idaztean';
$string['uploadedfile'] = 'Fitxategia ondo igo da';
$string['uploadedfileto'] = '{$a->file} fitxategia {$a->directory} direktoriora igota';
$string['uploadedfiletoobig'] = 'Sentitzen dugu, baina fitxategi hau handiegia da (gehienez {$a} izan dezake)';
$string['uploadextension'] = 'PHP hedapen batek fitxategiaren eguneratzea eten du';
$string['uploadfailednotrecovering'] = 'Errorea gertatu da igo nahi zenuen fitxategi honekin, {$a->name}.<br /> Hona hemen izandako arazoen log-a:<br />{$a->problem}<br />Not recovering.';
$string['uploadfilelog'] = '{$a} fitxategirako igoera-erregistroa';
$string['uploadformlimit'] = '{$a} fitxategiak formularioak ezartzen duen tamaina-muga gainditzen du';
$string['uploadlabel'] = 'Izenburua:';
$string['uploadlimitwithsize'] = '{$a->contextname}(e)n igotzeko gehieneko tamaina: ({$a->displaysize})';
$string['uploadnewfile'] = 'Igo beste fitxategi bat';
$string['uploadnofilefound'] = 'Ez da fitxategirik aurkitu. Ziur zaude igotzeko bat aukeratu duzula?';
$string['uploadnotallowed'] = 'Ezin da fitxategirik igo';
$string['uploadnotempdir'] = 'Aldi baterako karpeta falta da';
$string['uploadoldfilesdeleted'] = 'Igoera-eremuko fitxategi zaharrak ezabatu dira';
$string['uploadpartialfile'] = 'Fitxategia ez da osorik igo';
$string['uploadproblem'] = 'Errore ezezagun bat gertatu da \'{$a}\' fitxategia igotzerakoan (handiegia agian?)';
$string['uploadrenamedchars'] = 'Fitxategiari izena aldatu diogu (lehen {$a->oldname} ;orain {$a->newname}) erabili ezin diren karaktereak zituelako.';
$string['uploadrenamedcollision'] = 'Fitxategiari izena aldatu diogu (lehen {$a->oldname} ; orain {$a->newname}) izenen arteko arazoa zegoelako.';
$string['uploadserverlimit'] = 'Igotako fitxategiak zerbitzariko gehieneko fitxategi-tamaina gainditzen du';
$string['uploadthisfile'] = 'Igo fitxategi hau';
$string['url'] = 'URLa';
$string['used'] = 'Erabilia';
$string['usedinnplaces'] = '{$a} lekuetan erabilia';
$string['user'] = 'Erabiltzailea';
$string['useraccount'] = 'Erabiltzailearen kontua';
$string['useractivity'] = 'Jarduera';
$string['userconfirmed'] = '{$a} baieztatuta';
$string['userdata'] = 'Erabiltzaile-datuak';
$string['userdeleted'] = 'Erabiltzaile-kontu hau ezabatu da';
$string['userdescription'] = 'Aurkezpena';
$string['userdescription_help'] = 'Lauki honek aukera ematen dizu zuri buruzko eta gainontzekoek ikusi ahal izateko moduko testua sartzeko zure profil-orrian erakutsiko dena.';
$string['userdetails'] = 'Erabiltzaileen xehetasunak';
$string['userfiles'] = 'Erabiltzaile-fitxategiak';
$string['userfilterplaceholder'] = 'Bilatu hitz-gakoa edo aukeratu iragazkia';
$string['userlist'] = 'Erabiltzaileen zerrenda';
$string['usermenu'] = 'Erabiltzailearen menua';
$string['usermenugoback'] = 'Itzuli erabiltzaile-menura';
$string['username'] = 'Erabiltzaile-izena';
$string['usernameemail'] = 'Erabiltzaile-izena edo helbide elektronikoa';
$string['usernameemailmatch'] = 'Erabiltzaile-izena eta helbide elektronikoa ez dagozkie erabiltzaile berari';
$string['usernameexists'] = 'Erabiltzaile-izen hau badago aurretik, beste bat aukeratu';
$string['usernamelowercase'] = 'Letra xumeak baino ez dira onartzen';
$string['usernamenotfound'] = 'Erabiltzaile-izena ez da datu-basean aurkitu';
$string['usernameoremail'] = 'Sartu erabiltzaile-izena edo helbide elektronikoa';
$string['usernotconfirmed'] = 'Ezin izan da {$a} baieztatu';
$string['userpic'] = 'Erabiltzailearen irudia';
$string['userpreferences'] = 'Erabiltzailearen hobespenak';
$string['users'] = 'Erabiltzaileak';
$string['userselectorautoselectunique'] = 'Bilaketan erabiltzaile bakarra aurkitzen bada, aukeratu automatikoki';
$string['userselectorpreserveselected'] = 'Aukeratutako erabiltzaileak mantendu, bilaketarekin bat ez badatoz ere';
$string['userselectorsearchanywhere'] = 'Bilaketa-testuarekin bat datozenak erakutsitako eremuen edozein lekuetan bilatu';
$string['usersnew'] = 'Erabiltzaile berriak';
$string['usersnoaccesssince'] = 'Ez-aktibo tarte honetan baino gehiagoz';
$string['userswithfiles'] = 'Fitxategiak dituzten erabiltzaileak';
$string['useruploadtype'] = 'Erabiltzaileak igotze mota: {$a}';
$string['userzones'] = 'Erabiltzaileen ordu-zonaldeak';
$string['usetheme'] = 'Erabili azal hau';
$string['usingexistingcourse'] = 'Erabili dagoen ikastaroa';
$string['validatehtml'] = 'Egiaztatu HTMLa';
$string['valuealreadyused'] = 'Balio hau dagoeneko erabili izan da.';
$string['version'] = 'Bertsioa';
$string['view'] = 'Ikusi';
$string['viewallcourses'] = 'Ikusi ikastaro guztiak';
$string['viewallcoursescategories'] = 'Ikusi ikastaro eta kategoriak guztiak';
$string['viewallsubcategories'] = 'Ikusi azpikategoria guztiak';
$string['viewfileinpopup'] = 'Ikusi fitxategia popup leihoan';
$string['viewing'] = 'Ikusten:';
$string['viewmore'] = 'Ikusi gehiago';
$string['viewprofile'] = 'Ikusi profila';
$string['views'] = 'Ikuspenak';
$string['viewsolution'] = 'soluzioa ikusi';
$string['visible'] = 'Ikusgai';
$string['visible_help'] = 'Ezarpen honek adierazten du ikastaroa nola agertuko den ikastaroen zerrendan. Irakasle eta kudeatzaileez aparte, erabiltzaileek ez dute baimenik ikastaroan sartzeko.';
$string['visibletostudents'] = 'Ikusgai {$a}(r)entzat';
$string['warning'] = 'Kontuz';
$string['warningdeleteresource'] = 'Kontuz: baliabide batek {$a}-ri egiten dio erreferentzia. Baliabidea eguneratu nahi duzu?';
$string['wcagcheck'] = 'Web-Edukiaren Irisgarritasunaren Gidalerroak (Web Content Accessibility Guidelines - WCAG) egiaztapena';
$string['webpage'] = 'Web-orria';
$string['week'] = 'Astea';
$string['weekhide'] = 'Ezkutatu aste hau {$a}(e)ri';
$string['weeklyoutline'] = 'Astea hitz bitan';
$string['weeks'] = 'aste';
$string['weekshow'] = 'Erakutsi aste hau {$a}(e)ri';
$string['welcomeback'] = 'Kaixo berriz ere, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Ongi etorri {$a} gunera';
$string['welcometocoursetext'] = 'Ongi etorri {$a->coursename} ikastarora!

Nahi baduzu, zure erabiltzaile-profila
edita dezakezu beheko estekan klik eginda. Horrela geuk eta zure ikastaroko kideek zuri buruz gehiago jakingo dugu.

  {$a->profileurl}';
$string['welcometosite'] = 'Ongi etorri, {$a->firstname}! 👋';
$string['whatforlink'] = 'Zer egin nahi duzu estekarekin?';
$string['whatforpage'] = 'Zer egin nahi duzu testuarekin?';
$string['whatisyourage'] = 'Zein da zure adina?';
$string['whattocallzip'] = 'Nola izendatu nahi duzu zip fitxategia?';
$string['whattodo'] = 'Zer egin';
$string['wheredoyoulive'] = 'Zein herrialdetan bizi zara?';
$string['whyisthisrequired'] = 'Zergatik da hau beharrezkoa?';
$string['windowclosing'] = 'Leiho hau automatikoki itxiko da. Horrela ez bada, itxi orain.';
$string['withchosenfiles'] = 'Aukeratutako fitxategiak';
$string['withdisablednote'] = '{$a} (desgaituta)';
$string['withoutuserdata'] = 'erabiltzaileen daturik gabe';
$string['withselectedusers'] = 'Aukeratutako erabiltzaileekin...';
$string['withuserdata'] = 'Erabiltzaileen datuekin';
$string['wordforstudent'] = 'Ikaslea izendatzeko hitza';
$string['wordforstudenteg'] = 'Adibidez Ikaslea, Partaidea...';
$string['wordforstudents'] = 'Ikasleak izendatzeko hitza';
$string['wordforstudentseg'] = 'Adibidez, Ikasleak, Partaideak...';
$string['wordforteacher'] = 'Irakaslea izendatzeko hitza';
$string['wordforteachereg'] = 'Adibidez, Tutore, Irakasle, Laguntzaile...';
$string['wordforteachers'] = 'Irakasleak izendatzeko hitza';
$string['wordforteacherseg'] = 'Adibidez, Irakasleak, Tutoreak, Laguntzaileak...';
$string['writingblogsinfo'] = 'Blogen informazioa idazten';
$string['writingcategoriesandquestions'] = 'Kategoriak eta galderak idazten';
$string['writingcoursedata'] = 'Ikastaroaren informazioa idazten';
$string['writingeventsinfo'] = 'Ekitaldiaren informazioa idazten';
$string['writinggeneralinfo'] = 'Informazio orokorra idazten';
$string['writinggradebookinfo'] = 'Kalifikazio-liburuaren informazioa idazten';
$string['writinggroupingsgroupsinfo'] = 'Talde-multzoen eta taldeen informazioa idazten';
$string['writinggroupingsinfo'] = 'Talde-multzoen informazioa idazten';
$string['writinggroupsinfo'] = 'Taldeen informazioa idazten';
$string['writingheader'] = 'Izenburua idazten';
$string['writingloginfo'] = 'Erregistroen informazioa idazten';
$string['writingmessagesinfo'] = 'Mezuen informazioa idazten';
$string['writingmoduleinfo'] = 'Moduluaren informazioa idazten';
$string['writingscalesinfo'] = 'Eskalen informazioa idazten';
$string['writinguserinfo'] = 'Erabiltzaileen informazioa idazten';
$string['wrongpassword'] = 'Pasahitz ez da zuzena erabiltzaile izen honentzat';
$string['yahooid'] = 'ID Yahoo';
$string['year'] = 'urte';
$string['years'] = 'urte';
$string['yes'] = 'Bai';
$string['youareabouttocreatezip'] = 'Zip motako fitxategia sortzear zaude. Edukia:';
$string['youaregoingtorestorefrom'] = 'Berreskuratze-prozesua abiatzear zaude. Helburua:';
$string['youhaveupcomingactivitiesdue'] = 'Laster programatutako jarduerak izango dituzu';
$string['youhaveupcomingactivitiesdueinfo'] = 'Kaixo, {$a}:

<br/><br/>Amaiera-data laster duten jarduerak dituzu:';
$string['youneedtoenrol'] = 'Ekintza hau burutzeko ikastaroan matrikulatuta egon behar duzu.';
$string['yourlastlogin'] = 'Zure azken saioa:';
$string['yourself'] = 'Zu zeu';
$string['yourteacher'] = 'zure {$a}';
$string['yourwordforx'] = '\'{$a}\'-rako zure ordezko hitza';
$string['zippingbackup'] = 'Segurtasun-kopia zipeatzen';
