<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ro', version '4.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Navighează prin toate cursurile';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Nu te-ai înscris încă la niciun curs.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Navighează mai jos prin toate cursurile disponibile și începe învățarea.';
$string['addon.block_myoverview.noresult'] = 'Căutarea ta nu se potrivește cu vreun curs.';
$string['addon.block_myoverview.noresultdescription'] = 'Încearcă să ajustezi filtrele sau navighează mai jos prin toate cursurile.';
$string['addon.blog.errorloadentries'] = 'Eroare la încărcarea articolelor din blog.';
$string['addon.blog.showonlyyourentries'] = 'Arată doar articolele tale';
$string['addon.calendar.calendarevent'] = 'Eveniment calendar';
$string['addon.calendar.calendarevents'] = 'Evenimente calendar';
$string['addon.calendar.calendarreminders'] = 'Mementouri calendar';
$string['addon.calendar.currentmonth'] = 'Luna curentă';
$string['addon.calendar.defaultnotificationtime'] = 'Timp implicit de notificare';
$string['addon.calendar.errorloadevent'] = 'Eroare la încărcarea evenimentului.';
$string['addon.calendar.errorloadevents'] = 'Eroare la încărcarea evenimentelor.';
$string['addon.calendar.noevents'] = 'Nu există evenimente';
$string['addon.calendar.reminders'] = 'Remind-ere';
$string['addon.calendar.setnewreminder'] = 'Setează un reminder nou';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} înainte';
$string['addon.competency.errornocompetenciesfound'] = 'Nu s-au găsit competențe';
$string['addon.competency.nocompetencies'] = 'Fără competențe';
$string['addon.coursecompletion.complete'] = 'Terminat';
$string['addon.coursecompletion.couldnotloadreport'] = 'Nu am putut încărca raportul îndeplinirii cursului. Te rog să încerci mai târziu.';
$string['addon.enrol_self.confirmselfenrol'] = 'Ești sigur(ă) că vrei să te înscrii la acest curs?';
$string['addon.enrol_self.errorselfenrol'] = 'A apărut o eroare în timpul auto-înscrierii.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurează dispozitive';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Utilizatorii nu primesc notificări de pe acest site pe dispozitivele lor mobile. Activează notificările pe mobil în pagina Setări notificări.';
$string['addon.messages.contactlistempty'] = 'Lista de contacte este goală';
$string['addon.messages.contactname'] = 'Nume contact';
$string['addon.messages.deletemessage'] = 'Șterge mesaj';
$string['addon.messages.deletemessageconfirmation'] = 'Ești sigur că vrei să ștergi acest mesaj? Va fi șters doar din istoricul mesajelor tale, dar va fi încă vizibil de persoana care l-a trimis sau l-a primit.';
$string['addon.messages.errordeletemessage'] = 'Eroare în timpul ștergerii mesajului.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'A apărut o eroare la obținerea contactelor din server.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'A apărut o eroare la obținerea conversațiilor din server.';
$string['addon.messages.errorwhileretrievingmessages'] = 'A apărut o eroare la obținerea mesajelor din server.';
$string['addon.messages.errorwhileretrievingusers'] = 'A apărut o eroare la obținerea utilizatorilor din server.';
$string['addon.messages.messagenotsent'] = 'Mesajul nu a fost expediat. Te rog să încerci mai târziu.';
$string['addon.messages.newmessages'] = 'Mesaje noi';
$string['addon.messages.nousersfound'] = 'Nu au fost găsiți utilizatori';
$string['addon.messages.showdeletemessages'] = 'Arată mesajele șterse';
$string['addon.messages.type_blocked'] = 'Blocat';
$string['addon.messages.type_offline'] = 'Deconectat';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Caută rezultate';
$string['addon.messages.type_strangers'] = 'Alții';
$string['addon.messages.useentertosenddescdesktop'] = 'Dacă este dezactivat, poți apăsa Ctrl+Enter pentru a trimite mesajul.';
$string['addon.messages.useentertosenddescmac'] = 'Dacă este dezactivat, poți apăsa Ctrl+Enter pentru a trimite mesajul.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Nu am putut trimite mesajul (mesajele) către conversația {{user}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Nu am putut trimite mesajul (mesajele) către utilizatorul {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Vă rugăm să acceptați declarația de trimitere răspunsuri.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Detaliile sarcinii de lucru și formularul de răspuns vor fi disponibile de la <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Sarcina de lucru va accepta răspunsuri din <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Nu puteți adăuga sau edita o trimitere în aplicație, deoarece declarația de trimitere răspunsuri nu a putut fi preluată de pe site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Anumite metode de notare nu sunt încă acceptate de aplicație și nu pot fi modificate.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Nu puteți face o trimitere în aplicație, deoarece declarația de trimitere nu a putut fi preluată de pe site.';
$string['addon.mod_assign.duedateno'] = 'Fără dată limită';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Nu poți adăuga sau edita un răspuns în aplicație, deoarece pentru anumite plugin-uri nu se acceptă încă editarea.';
$string['addon.mod_assign.errorshowinginformation'] = 'Informațiile despre răspunsul trimis nu pot fi încă afișate.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Acest feedback nu este acceptat în aplicație și e posibil să nu conțină toate informațiile.';
$string['addon.mod_assign.gradenotsynced'] = 'Nivel nesincronizat';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Participanții care nu au trimis un răspuns nu sunt afișați.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Sunt {{count}} ciorne.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Sunt {{count}} participanți.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Sunt {{count}} expedieri care necesită clasificare.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Sunt {{count}} însărcinări expediate.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Sunt {{count}} echipe.';
$string['addon.mod_assign.submissionnotsupported'] = 'Răspunsul tău nu este acceptat de aplicație și e posibil să nu conțină toate informațiile.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'nota utilizatorului';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Nota pentru răspuns a fost modificată pe site.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Răspunsul trimis de către utilizator a fost modificat pe site.';
$string['addon.mod_chat.confirmloss'] = 'Ești sigur? Discuția se poate pierde.';
$string['addon.mod_chat.errorwhileconnecting'] = 'A apărut o eroare la conectarea în Camera de discuții.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'A apărut o eroare la obținerea de informații din Camera de discuții.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'A apărut o eroare la obținerea listei cu utilizatorii din Camera de discuții.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'A apărut o eroare la primirea mesajelor de pe server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'A apărut o eroare la trimiterea mesajului.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Trebuie să fiți online pentru a trimite mesaje';
$string['addon.mod_chat.nosessionsfound'] = 'Nu s-au găsit sesiuni';
$string['addon.mod_chat.showincompletesessions'] = 'Afișează sesiunile incomplete';
$string['addon.mod_choice.errorgetchoice'] = 'Eroare în obținerea de date pentru alegere.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% dintre utilizatori au ales opțiunea: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Ultimul tău răspuns trebuie să fie sincronizat înainte de a fi inclus în rezultate.';
$string['addon.mod_data.edittagsnotsupported'] = 'Ne pare rău, editarea etichetelor nu este acceptată în aplicație.';
$string['addon.mod_data.errorapproving'] = 'Eroare la aprobarea sau neaprobarea articolului.';
$string['addon.mod_data.errordeleting'] = 'Eroare la ștergerea articolului.';
$string['addon.mod_data.gettinglocation'] = 'Se obține locația';
$string['addon.mod_data.locationnotenabled'] = 'Locația nu este activată';
$string['addon.mod_data.locationpermissiondenied'] = 'Permisiunea de a accesa locația dumneavoastră a fost respinsă.';
$string['addon.mod_data.mylocation'] = 'Locația mea';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Ne pare rău, căutarea după etichete nu este acceptată în aplicație.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Feedback-ul cu CAPTCHA nu poate fi completat offline, sau dacă nu este configurat, sau dacă serverul nu este accesibil.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Sunt {{count}} răspunsuri trimise.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Feedback salvat pentru a fi trimis mai târziu.';
$string['addon.mod_feedback.questionscountdescription'] = 'Există {{count}} întrebări';
$string['addon.mod_folder.emptyfilelist'] = 'Nu există fișiere de afișat.';
$string['addon.mod_forum.errorgetforum'] = 'A apărut o eroare la obținerea datelor despre forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Eroare la obținerea setărilor pentru grup.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum nedisponibil în această ordine de sortare';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Încercați să schimbați ordinea de sortare sau să accesați online pentru a vedea acest forum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Nu se pot crea discuții noi în niciun grup.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Nu există încă discuții în acest forum.';
$string['addon.mod_forum.group'] = 'Grup';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discuții';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} răspunsuri';
$string['addon.mod_forum.postingroup'] = 'Se postează în grupul "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Reîmprospătează postările';
$string['addon.mod_glossary.browsemode'] = 'Navighează printre articole';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetic';
$string['addon.mod_glossary.byauthor'] = 'Grupați după autor';
$string['addon.mod_glossary.bycategory'] = 'Grupare după categorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Cele mai noi sunt afișate primele';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Actualizări recente';
$string['addon.mod_glossary.bysearch'] = 'Căutare';
$string['addon.mod_glossary.cannoteditentry'] = 'Nu se poate edita articolul';
$string['addon.mod_glossary.entriestobesynced'] = 'Articole care urmează să fie sincronizate';
$string['addon.mod_glossary.entrypendingapproval'] = 'Acest articol asteaptă aprobare.';
$string['addon.mod_glossary.errordeleting'] = 'Eroare la ștergeerea articolului.';
$string['addon.mod_glossary.errorloadingentries'] = 'A apărut o eroare la încărcarea articolelor.';
$string['addon.mod_glossary.errorloadingentry'] = 'A apărut o eroare la încărcarea articolului.';
$string['addon.mod_glossary.errorloadingglossary'] = 'A apărut o eroare la încărcarea glosarului.';
$string['addon.mod_glossary.noentriesfound'] = 'Nu au fost găsite articole.';
$string['addon.mod_glossary.searchquery'] = 'Interogare de căutare';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Descarcă fișierul H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Eroare la obținerea datelor despre activitatea H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Pachetul H5P nu este descărcat. Trebuie să-l descarci pentru a-l putea folosi.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Pachetul H5P a fost modificat de la următoarea descărcare. Trebuie să îl descarci din nou pentru a-l putea descărca.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Trebuie să fiți online pentru a vedea pachetul H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Vezi încercarea {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Afișează descrierea';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Această lecție conține o trecere la o pagină de conținut aleatoriu. Nu poate fi încercată în aplicație până când nu a fost pornită într-un browser web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Această încercare nu mai poate fi revizuită pentru că o altă încercare a fost finalizată.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Încercarea a fost finalizată offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'O încercare offline a fost sincronizată. Vrei să o revizuiești?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Încercarea a fost finalizată pe site.';
$string['addon.mod_lti.errorgetlti'] = 'A apărut o eroare la încărcarea modulului de date.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'URLul lansat nu este valid.';
$string['addon.mod_lti.launchactivity'] = 'Lansează activitatea';
$string['addon.mod_page.errorwhileloadingthepage'] = 'A apărut o eroare la încărcarea conținutului paginii.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Poți încerca acest test în aplicație, dar va trebui să trimiți  încercarea în browser din următoarele motive:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Încercarea la test nu poate fi trimisă din următoarele motive:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Această încercare nu a fost sincronizată din {{$a}}. Dacă de atunci ai continuat această încercare pe alt dispozitiv, este posibil să pierzi date.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'A apărut o eroare la salvarea răspunsurilor. Ești sigur că vrei să inchizi testul?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Acest test nu poate fi încercat în aplicație, deoarece funcționalitatea întrebării nu este acceptată de aplicație:';
$string['addon.mod_quiz.errordownloading'] = 'Eroare la descărcarea datelor solicitate.';
$string['addon.mod_quiz.errorgetattempt'] = 'Eroare la obținerea datelor despre încercare.';
$string['addon.mod_quiz.errorgetquestions'] = 'Eroare la obținerea întrebărilor.';
$string['addon.mod_quiz.errorgetquiz'] = 'Eroare la obținerea datelor din test.';
$string['addon.mod_quiz.errorparsequestions'] = 'A apărut o eroare la citirea întrebărilor. Te rugăm să deschizi acest test într-un browser web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Testul nu poate fi deschis în aplicație deoarece conține doar întrebări care nu sunt acceptate de aplicație:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Testul nu poate fi deschis în aplicație deoarece are reguli de acces neacceptate în aplicație:';
$string['addon.mod_quiz.errorsaveattempt'] = 'A apărut o eroare la salvarea datelor.';
$string['addon.mod_quiz.finishnotsynced'] = 'Încheiat, dar nesincronizat';
$string['addon.mod_quiz.opentoc'] = 'Deschide navigarea popover';
$string['addon.mod_quiz.warningattemptfinished'] = 'Încercarea offline a fost eliminată, deoarece a fost finalizată pe site sau nu a fost găsită.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Unele răspunsuri offline au fost eliminate deoarece întrebările au fost modificate online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Încercarea a fost neterminată, deoarece unele răspunsuri offline au fost eliminate. Te rugăm să revizuiești răspunsurile, apoi să trimiți din nou încercarea.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Testul conține întrebări care nu sunt acceptate de aplicație:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'A apărut o eroare la încărcarea conținutului.';
$string['addon.mod_resource.openthefile'] = 'Deschide';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Acest fișier s-a modificat de când l-ai deschis ultima dată.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Există o versiune nouă a acestui fișier. Pentru a o vedea, te rugăm să conectezi dispozitivul tău la internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Nota nu a putut fi calculată.';
$string['addon.mod_scorm.dataattemptshown'] = 'Aceste date aparțin încercării cu numărul {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'A apărut o eroare la crearea noii încercării offline. Te rugăm să încerci din nou.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Eroare la descărcarea SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Eroare la obținerea datelor SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Ne pare rău, aplicația acceptă doar SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Școala sau furnizorul dvs. de învățământ a dezactivat descărcarea pachetelor SCORM.';
$string['addon.mod_scorm.errornovalidsco'] = 'Acest pachet SCORM nu are un SCO vizibil pentru a fi încărcat.';
$string['addon.mod_scorm.errorpackagefile'] = 'Ne pare rău, aplicația acceptă doar pachete de tip ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'A apărut o eroare la sincronizare. Te rugăm să încerci din nou.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Această încercare conține date care nu au fost sincronizate.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Această încercare nu poate fi trimisă deoarece ai depășit numărul maxim de încercări.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Acest pachet SCORM nu a fost descărcat. Va fi descărcat automat când îl vei deschide.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Acest pachet SCORM a fost modificat de la ultima descărcare. Va fi descărcat automat când îl vei deschide.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Unele date ale încercării offline cu numărul {{number}} au fost șterse deoarece nu s-au putut considera ca fiind o nouă încercare.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Unele încercări nu au putut fi sincronizate cu site-ul, deoarece ultima încercare online nu a fost încă terminată. Te rugăm să închei mai întâi încercarea online.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'A apărut o eroare la trimiterea sondajului. Vă rugăm să reîncercați.';
$string['addon.mod_survey.errorgetsurvey'] = 'A apărut o eroare la obținerea datelor sondajului.';
$string['addon.mod_survey.results'] = 'Rezultate';
$string['addon.mod_url.accessurl'] = 'Accesați adresa URL';
$string['addon.mod_url.pointingtourl'] = 'Adresa URL la care duce resursa';
$string['addon.mod_wiki.errorloadingpage'] = 'A apărut o eroare la încărcarea paginii.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Acest wiki nu are conținut încă.';
$string['addon.mod_wiki.gowikihome'] = 'Mergeți la prima pagină wiki';
$string['addon.mod_wiki.subwiki'] = 'Sub-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Titlul nu poate fi necompletat';
$string['addon.mod_wiki.viewpage'] = 'Vezi pagina';
$string['addon.mod_wiki.wikipage'] = 'Pagină wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategia de evaluare {{$a}} neacceptată';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Trebuie să inserați un titlu';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Răspusul a fost modificat pe site.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Evaluarea a fost modificată în site.';
$string['addon.notes.warningnotenotsent'] = 'Nu s-au putut adăuga sau șterge notițe. {{error}}';
$string['addon.notifications.allownotifications'] = 'Permite notificări';
$string['addon.notifications.errorgetnotifications'] = 'A apărut o eroare la primirea notificărilor.';
$string['addon.notifications.notifications'] = 'Notificări';
$string['addon.notifications.playsound'] = 'Redă sunet';
$string['addon.notifications.therearentnotificationsyet'] = 'Nu există notificări';
$string['addon.notifications.typeofnotification'] = 'Tip de notificare';
$string['addon.privatefiles.couldnotloadfiles'] = 'Lista de fișiere nu a putut fi încărcată.';
$string['addon.privatefiles.emptyfilelist'] = 'Nu există fișiere de afișat.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Din păcate, în prezent, nu este posibil să încărcați fișiere pe site.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Șterge toate datele descărcate de pe site?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Ștergi datele descărcate din toare cursurile?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Șterge toate datele descărcate din \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Descărcări ale cursului';
$string['addon.storagemanager.courseinfo'] = 'Descarcă conținutul cursului pentru a lucra offline. Activitatea ta se va sincroniza automat când dispozitivul este din nou online.';
$string['addon.storagemanager.deleteallsitedata'] = 'Șterge toate datele descărcate din site';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Această acșiune va șterge toate datele descărcate din \'{{name}}\', inclusiv toate cursurile descărcate și date care îți permit să lucrezi offline.';
$string['addon.storagemanager.deletecourses'] = 'Șterge toate datele descărcate din toate cursurile';
$string['addon.storagemanager.deletedata'] = 'Șterge datele descărcate';
$string['addon.storagemanager.deletedatafrom'] = 'Șterge toate datele descărcate din \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Cursuri descărcate';
$string['addon.storagemanager.downloads'] = 'Descărcări';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Eroare la ștergerea datelor descărcate.';
$string['addon.storagemanager.managedownloads'] = 'Gestionează fișierele descărcate';
$string['addon.storagemanager.totaldownloads'] = 'Descărcări totale';
$string['addon.storagemanager.totalspaceusage'] = 'Spațiul total folosit';
$string['appstoredescription'] = 'NOTĂ: Aceasta este aplicația oficială Moodle pentru dispozitivele mobile și va funcționa numai cu siteurile Moodle care sunt setate să o accepte. Va rugăm să contactați administratorul siteului dacă aveți probleme la conectare.

Dacă siteul Moodle a fost configurat corect, veți putea utiliza această aplicație pentru a:

- accesa cursurile dumneavoastră chiar și în mod offline;
- primi notificări instant cu privire la mesajele primite sau alte tipuri de evenimente;
- găsi rapid și a contacta alți participanți la curs;
- încărca imagini, fișiere audio, video sau de alte tipuri, direct de pe dispozitivul mobil;
- vedea notele obținute;
- și multe altele!

Vă rugă șa verificați http://docs.moodle.org/en/Mobile_app pentru ultimile noutăți.

Vom aprecia recenziile cu privire la funcționalitatea aplicației precum și cu propuneri pentru viitoare funcționalități!

Aplicația necesită următoarele permisiuni:
Înregistrare audio - pentru înregistrarea fișierelor audio încărcate pe platforma Moodle
Citirea și modificarea conținutului memoriei SD - Fișierele descărcate prin aplicație vor fi stocate pe cardul de memorie pentru a putea fi consultate de dumneavoastră în mod offline
Acces la rețea - Pentru a se putea conecta la siteul dumneavoastră Moodle și pentru a vă verifica statusul pentru a trece în mod offline la nevoie (daca nu sunteți conectat la internet)
Rulare la pornire - Pentru a putea primi notificări chiar dacă aplicația rulează în fundal
Împiedicarea telefonului să intre în modul sleep - Pentru a putea primi notificări push în orice moment';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Prezentare Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Foaie de calcul Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Document Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive audio';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Fișier Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Folder Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive video';
$string['core.ajaxendpointnotfound'] = 'Punctul final AJAX nu a fost găsit. Acest lucru se poate întâmpla dacă site-ul Moodle este prea vechi sau blochează accesul la acest punct final. Aplicația Moodle acceptă numai sistemele Moodle începând cu {{$a}}.';
$string['core.browser'] = 'Browser';
$string['core.calculating'] = 'Se calculează';
$string['core.cannotconnect'] = 'Nu se poate conecta la site';
$string['core.cannotdownloadfiles'] = 'Școala ta sau furnizorul serviciului de elearning a dezactivat descărcarea fișierelor.';
$string['core.cannotinstallapk'] = 'Nu se poate instala .apk files';
$string['core.cannotinstallapkinfo'] = 'Din motive de securitate, nu poți instala aplicații necunoscute pe dispozitivul tău din această aplicație. Dacă totuși vrei să continui instalarea, trebuie să o deschizi într-un browser.';
$string['core.cannotlogoutpageblocks'] = 'Te rugăm să modifici sau să anulezi modificările înainte de a continua.';
$string['core.cannotopeninapp'] = 'Este posibil ca acest fișier să nu funcționeze conform așteptărilor pe acest dispozitiv. Vrei să-l deschizi oricum?';
$string['core.cannotopeninappdownload'] = 'Este posibil ca acest fișier să nu funcționeze conform așteptărilor pe acest dispozitiv. Vrei să-l descarci oricum?';
$string['core.captureaudio'] = 'Înregistrează audio';
$string['core.capturedimage'] = 'Poză făcută.';
$string['core.captureimage'] = 'Fă poză';
$string['core.capturevideo'] = 'Înregistrează video';
$string['core.certificaterror'] = 'Certificatul acestui site nu poate fi considerat de încredere de către dispozitivul tău {{details}}';
$string['core.clearsearch'] = 'Ștergeți căutările';
$string['core.clearstoreddata'] = 'Spațiu de depozitare liber {{$a}}';
$string['core.clicktoseefull'] = 'Apăsați pentru a vedea întregul conținut';
$string['core.comments.commentsnotworking'] = 'Comentariile nu pot fi recuperate';
$string['core.comments.warningcommentsnotsent'] = 'Nu se pot sincroniza comentariile. {{error}}';
$string['core.confirmcanceledit'] = 'Sigur vrei să pleci de pe această pagină? Toate modificările vor fi pierdute.';
$string['core.confirmleaveunknownchanges'] = 'Sigur vrei să părăsești această pagină? Dacă ai modificări pe care nu le-ai salvat, acestea se vor pierde.';
$string['core.confirmloss'] = 'Ești sigur? Toate modificările se vor pierde.';
$string['core.confirmopeninbrowser'] = 'Doriți să deschideți într-un browser web?';
$string['core.connectionlost'] = 'S-a pierdut conexiunea la site';
$string['core.contactsupport'] = 'Contactați suportul';
$string['core.contenteditingsynced'] = 'Conținutul pe care îl editezi a fost sincronizat.';
$string['core.contentlinks.chooseaccount'] = 'Alegeți contul';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Alege contul cu care să deschizi link-ul.';
$string['core.contentlinks.confirmurlothersite'] = 'Acest link aparține unui alt site. Doriți să îl deschideți?';
$string['core.contentlinks.errornoactions'] = 'Nu s-a putut găsi nicio acțiune de efectuat cu acest link.';
$string['core.contentlinks.errornosites'] = 'Nu a fost găsit niciun site pentru acest link.';
$string['core.contentlinks.errorredirectothersite'] = 'Adresa URL de redirecționare nu poate indica un alt site.';
$string['core.copiedtoclipboard'] = 'Text copiat în clipboard';
$string['core.copytoclipboard'] = 'Copiază în clipboard';
$string['core.course.activitydisabled'] = 'Organizația ta a dezactivat această activitate în aplicația mobilă.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Organizația ta a instalat un plugin care nu este încă acceptat.';
$string['core.course.allsections'] = 'Toate secțiunile';
$string['core.course.aria:sectionprogress'] = 'Progresul secțiunii:';
$string['core.course.availablespace'] = 'În prezent aveți aproximativ {{available}} spațiu liber.';
$string['core.course.cannotdeletewhiledownloading'] = 'Fișierele nu pot fi șterse în timp ce activitatea se descarcă. Te rugăm să aștepți ca descărcarea să se încheie.';
$string['core.course.confirmdownload'] = 'Urmează să descarci {{size}}.{{availableSpace}} Ești sigur ca vrei să continui?';
$string['core.course.confirmdownloadunknownsize'] = 'Nu se poate calcula dimensiunea fișierului pe care vrei să îl descarci.{{availableSpace}} Ești sigur că vrei să continui?';
$string['core.course.confirmdownloadzerosize'] = 'Urmează să descarci.{{availableSpace}} Ești sigur că dorești să continui?';
$string['core.course.confirmlimiteddownload'] = 'Nu ești conectat la o rețea Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Urmează să descarci <strong>cel puțin</strong> {{size}}.{{availableSpace}} Ești sigur că vrei să continui?';
$string['core.course.couldnotloadsectioncontent'] = 'Nu se poate încărca conținutul secțiunii. Te rugăm să încerci mai târziu.';
$string['core.course.couldnotloadsections'] = 'Nu se pot încărca secțiunile. Te rugăm să încerci mai târziu.';
$string['core.course.downloadcoursesprogressdescription'] = 'Se descarcă cursuri: descărcate {{count}} din {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Se descarcă secțiunea: descărcată {{count}} din {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Eroare la descărcarea cursului.';
$string['core.course.errordownloadingsection'] = 'A apărut o eroare la descărcarea secțiunii.';
$string['core.course.errorgetmodule'] = 'A apărut o eroare la obținerea modului de date.';
$string['core.course.insufficientavailablequota'] = 'Dispozitivul dvs. nu a putut aloca spațiu pentru a salva această descărcare. Este posibil să rezerve spațiu pentru actualizări de aplicații și de sistem. Vă rugăm să eliberați mai întâi puțin spațiu de stocare.';
$string['core.course.insufficientavailablespace'] = 'Încerci să descarci {{size}}. Din cauza aceasta, dispozitivul tău va avea spațiu insuficient pentru a funcționa normal. Te rugăm să eliberezi mai întâi spațiul de stocare.';
$string['core.course.lastaccessedactivity'] = 'Ultima activitate accesată';
$string['core.course.manualcompletionnotsynced'] = 'Completare manuală nesincronizată.';
$string['core.course.modulenotfound'] = 'Resursa sau activitatea nu a fost găsită, terugăm să vă asiguri că ești online și că activitatea sau resursa este încă disponibilă.';
$string['core.course.nextactivity'] = 'Următoarea activitate';
$string['core.course.nextactivitynotfound'] = 'Următoarea activitate nu a fost găsită. Este posibil să fi fost ascunsă sau ștearsă.';
$string['core.course.nocontentavailable'] = 'Pentru moment nu există conținut disponibil.';
$string['core.course.previousactivity'] = 'Activitate anterioară';
$string['core.course.previousactivitynotfound'] = 'Activitatea anterioară nu a fost găsită. Este posibil să fi fost ascunsă sau ștearsă.';
$string['core.course.refreshcourse'] = 'Actualizează cursul';
$string['core.course.useactivityonbrowser'] = 'Se poate folosi în continuare utilizând browser-ul web al dispozitivului tău.';
$string['core.course.warningmanualcompletionmodified'] = 'Finalizarea manuală a unei activități a fost modificată pe site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'O parte din finalizare manuală offline a cursului \'{{name}}\' a fost ștearsă. {{error}}';
$string['core.coursenogroups'] = 'Nu sunteți membru al niciunui grup din acest curs.';
$string['core.courses.browserenrolinstructions'] = 'Vă vom duce la browserul dispozitivului dvs. După ce ați finalizat înscrierea, vă rugăm să reveniți la această aplicație.';
$string['core.courses.cannotretrievemorecategories'] = 'Categoriile mai profunde decât nivelul {{$a}} nu pot fi preluate.';
$string['core.courses.completeenrolmentbrowser'] = 'Completează înscrierea în browser';
$string['core.courses.confirmselfenrol'] = 'Sunteți sigur/ă că doriți să vă înregistrați la acest curs?';
$string['core.courses.downloadcourses'] = 'Descarcă toate cursurile';
$string['core.courses.enrolme'] = 'Înregistrează-mă';
$string['core.courses.errorloadcategories'] = 'A apărut o eroare în timp ce se încărcau categoriile.';
$string['core.courses.errorloadcourses'] = 'A apărut o eroare la încărcarea cursurilor.';
$string['core.courses.errorloadplugins'] = 'Plugin-urile necesare în acest curs nu s-au încărcat corect. Te rugăm să reîncarci aplicația și să încerci din nou.';
$string['core.courses.errorsearching'] = 'A apărut o eroare în procesul de căutare.';
$string['core.courses.errorselfenrol'] = 'A apărut o eroare în procesul de auto-înregistrare.';
$string['core.courses.filtermycourses'] = 'Filtrează cursurile mele';
$string['core.courses.notenrollable'] = 'Nu vă puteți auto-înregistra la acest curs.';
$string['core.courses.otherenrolments'] = 'Alte înscrieri';
$string['core.courses.password'] = 'Cheie de înregistrare';
$string['core.courses.refreshcourses'] = 'Actualizează cursuri';
$string['core.courses.searchcoursesadvice'] = 'Puteți folosi butonul pentru căutarea cursurilor pentru a căuta și accesa ca vizitator sau pentru a vă auto-înregistra la acele cursuri care permit aceste opțiuni.';
$string['core.courses.selfenrolment'] = 'Auto-înregistrare';
$string['core.courses.showonlyenrolled'] = 'Afișează doar cursurile mele';
$string['core.courses.totalcoursesearchresults'] = 'Totalul cursurilor: {{$a}}';
$string['core.currentdevice'] = 'Dispozitivul actual';
$string['core.datastoredoffline'] = 'Date stocate în dispozitiv pentru că nu au putut fi trimise. Vor fi trimise automat mai târziu.';
$string['core.deletedoffline'] = 'Șters offline';
$string['core.deleting'] = 'Se șterge';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'LL-ZZ-AAAA';
$string['core.dfdayweekmonth'] = 'zzz, Z LLL';
$string['core.dffulldate'] = 'zzzz, Z LLLL AAAA h[:]mm A';
$string['core.dflastweekdate'] = 'zzz';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Renunță';
$string['core.dismiss'] = 'Respins';
$string['core.dontshowagain'] = 'Nu afișa din nou.';
$string['core.downloaded'] = 'Descărcat';
$string['core.downloading'] = 'Se descarcă';
$string['core.editor.hidetoolbar'] = 'Ascunde bara de instrumente';
$string['core.editor.toggle'] = 'Extindeți editorul';
$string['core.emptysplit'] = 'Această pagină va apărea goală dacă panoul din stânga este gol sau se încarcă.';
$string['core.endingtime'] = 'Ora de încheiere: {{$a}}';
$string['core.errorchangecompletion'] = 'A apărut o eroare în timpul schimbării nivelului de finallizare. Încearcă din nou!';
$string['core.errorcode'] = 'Cod eroare: {{errorCode}}';
$string['core.errordeletefile'] = 'Eroare la ștergeerea fișierului. Vă rugăm să încercați mai târziu.';
$string['core.errordetailshide'] = 'Ascunde informațiile despre eroare';
$string['core.errordetailsshow'] = 'Afișează informațiile despre eroare';
$string['core.errordownloading'] = 'A apărut o eroare la descărcarea fișierului.';
$string['core.errordownloadingsomefiles'] = 'A apărut o eroare la descărcarea fișierelor modulului. Unele fișiere pot lipsi.';
$string['core.errorfileexistssamename'] = 'Un fișier cu această denunire există deja.';
$string['core.errorinvalidform'] = 'Te rugăm să verifici dacă toate câmpurile obligatorii sunt completate și datele introduse sunt în formatul corect.';
$string['core.errorinvalidresponse'] = 'Răspuns neașteptat pentru {{method}} webservice.';
$string['core.errorloadingcontent'] = 'Eroare la încărcarea conținutului.';
$string['core.errorofflinedisabled'] = 'Navigarea offline este dezactivată pe site. Trebuie să fii conectat la internet pentru a utiliza aplicația.';
$string['core.erroropenfiledownloading'] = 'Eroare la deschiderea fișierului: trebuie să aștepti ca descărcarea să fie completă.';
$string['core.erroropenfilenoapp'] = 'A apărut o eroare la deschiderea fișierului: nu s-a găsit nicio aplicație pentru a deschide acest tip de fișier.';
$string['core.erroropenfilenoextension'] = 'A apărut o eroare la deschiderea fișierului: acest fișier nu are o extensie.';
$string['core.erroropenpopup'] = 'Această activitate încearcă să deschidă o fereastră popup. Acest lucru nu este permis în aplicație.';
$string['core.errorrenamefile'] = 'Eroare la redenumirea fișierului. Vă rugăm să încercați  mai târziu.';
$string['core.errorsitesupport'] = 'Dacă problema persistă, contactați administratorul platformei.';
$string['core.errorsomedatanotdownloaded'] = '';
$string['core.errorsomethingwrong'] = 'Ceva nu a funcționat. Te rugăm să încerci din nou.';
$string['core.errorsync'] = 'A apărut o eroare în timpul sincronizării. Te rugăm să încerci din nou.';
$string['core.errorsyncblocked'] = 'Acest {{$a}} nu poate fi sincronizat acum din cauza unui acțiuni aflate în desfășurare. Te rugăm să încerci din nou mai târziu. Dacă problema persistă, încearcă să repornești aplicația.';
$string['core.errorurlschemeinvalidscheme'] = 'Acest URL este destinat a fi folosit în alt app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL-ul axestui site nu poate fi deschis în această aplicație.';
$string['core.filenameexist'] = 'Denumirea fișierului există deja: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Camera';
$string['core.fileuploader.confirmuploadfile'] = 'Sunteți pe cale să încărcați {{size}}. Sunteți sigur ca doriți să continuați?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Nu s-a putut calcula dimensiunea fișierului încărcat. Esti sigur ca vrei sa continui?';
$string['core.fileuploader.discardrecording'] = 'Anulează înregistrarea';
$string['core.fileuploader.errorcapturingaudio'] = 'Eroare la înregistrarea audio.';
$string['core.fileuploader.errorcapturingimage'] = 'Eroare la realizarea capturii foto.';
$string['core.fileuploader.errorcapturingvideo'] = 'Eroare la înregistrarea video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Eroare la obținerea imaginii din album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Pentru a putea încărca fișiere trebuie să online.';
$string['core.fileuploader.errornoapp'] = 'Nu aveți instalată o aplicație dedicată realizării acestei operațiuni.';
$string['core.fileuploader.errorreadingfile'] = 'Eroare la citirea fișierului.';
$string['core.fileuploader.errorwhileuploading'] = 'A apărut o eroare în timpul încărcării fișierului.';
$string['core.fileuploader.file'] = 'Fișier';
$string['core.fileuploader.fileuploaded'] = 'Fișierul a fost încărcat cu succes.';
$string['core.fileuploader.maxbytesfile'] = 'Fișierul {{$a.file}} este prea mare. Dimensiunea maximă pe care o puteți încărca este {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Permisiunea de a accesa microfonul a fost refuzată.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Accesul la microfon este restricționat.';
$string['core.fileuploader.pauserecording'] = 'Pune înregistrarea pe pauză';
$string['core.fileuploader.photoalbums'] = 'Albume foto';
$string['core.fileuploader.readingfile'] = 'Se citește fișierul';
$string['core.fileuploader.readingfileperc'] = 'Se citește fișierul: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Reia înregistrarea';
$string['core.fileuploader.selectafile'] = 'Selectează un fișier';
$string['core.fileuploader.startrecordinginstructions'] = 'Tap pentru a începe înregistrarea';
$string['core.fileuploader.uploadafile'] = 'Încarcă un fișier';
$string['core.fileuploader.uploading'] = 'Se încarcă';
$string['core.fileuploader.uploadingperc'] = 'Se încarcă: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Mergi la {{$a}}';
$string['core.h5p.errorgetemail'] = 'Nu s-a putut obține email-ul utilizatorului. Te rugăm să verifici conexiunea și să încerci din nou.';
$string['core.h5p.offlinedisabled'] = 'Acest site nu permite descărcarea pachetelor H5P.';
$string['core.h5p.play'] = 'Afișați H5P';
$string['core.hasdatatosync'] = 'Acest {{$a}} are date offline de sincronizat.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Acest conținut nu poate fi vizualizat?';
$string['core.image'] = 'Imagine';
$string['core.imageviewer'] = 'Vizualizator pentru imagini';
$string['core.ioscookieshelp'] = 'Conținutul încorporat necesită cookies pentru a funcționa. Te rugăm să mergi la setările aplicației IOS, activează  \'Permite urmărirea utilizării în mai multe site-uri\' și încearcă din nou.';
$string['core.lastdownloaded'] = 'Ultima descărcare';
$string['core.lastsync'] = 'Ultima sincronizare';
$string['core.loadmore'] = 'Încarcă mai mult';
$string['core.login.authenticating'] = 'Autentificare';
$string['core.login.changepasswordbutton'] = 'Schimbă parola';
$string['core.login.changepasswordhelp'] = 'Dacă ai probleme la schimbarea parolei, încearcă din nou mai târziu sau contactează școala sau furnizorul de formare.';
$string['core.login.changepasswordinstructions'] = 'Nu îți poți schimba parola în aplicație. Te rugăm să dai click pe următorul buton pentru a deschide site-ul într-un browser web pentru a-ți schimba parola. Ia în considerare că trebuie să închizi browser-ul după schimbarea parolei, pentru că nu vei fi redirecționat către aplicație.';
$string['core.login.changepasswordlogoutinstructions'] = 'Dacă vrei să schimbi site-ul sau să te deconectezi, te rugăm să dai click pe următorul buton:';
$string['core.login.changepasswordreconnectinstructions'] = 'Dacă nu ți-ai schimbat corect parola, ți se va cere să o faci din nou.';
$string['core.login.changepasswordsupportsubject'] = 'Am nevoie de suport pentru schimbarea parolei';
$string['core.login.confirmdeletesite'] = 'Sunteți sigur că doriți sa ștergeți contul de pe site-ul {{sitename}}?';
$string['core.login.connect'] = 'Conectare!';
$string['core.login.connecttomoodle'] = 'Conectare la Moodle';
$string['core.login.connecttomoodleapp'] = 'Încerci să te conectezi la un site Moodle obișnuit. Te rugăm să descarci aplicația oficială Moodle pentru a accesa acest site.';
$string['core.login.connecttoworkplaceapp'] = 'Încerci să te conectezi la un site Moodle Workplace. Te rugăm să descarci aplicația Moodle Workplace pentru a accesa acest site.';
$string['core.login.contactyouradministrator'] = 'În continuare, contactează administratorul site-ului pentru suport.';
$string['core.login.contactyouradministratorissue'] = 'Te rugăm să contactezi administratorul site-ului pentru a verifica următoarea problemă: {{$a}}';
$string['core.login.credentialsdescription'] = 'Va rugăm să  introduceți userul și parola dumneavoastră pentru a vă conecta';
$string['core.login.credentialshelp'] = 'Dacă întâmpini probleme la logare, încearcă din nou mai târziu sau contactează-ți școala sau furnizorul de elearning.';
$string['core.login.credentialssupportsubject'] = 'Este nevoie de ajutor la logare';
$string['core.login.emailconfirmsentnoemail'] = '<p>Un email ar fi trebuit să fie trimis la adresa ta.</p><p>Conține instrucțiuni simple pentru a-ți finaliza înregistrarea.</p>';
$string['core.login.emailnotmatch'] = 'Email-urile nu corespund';
$string['core.login.erroraccesscontrolalloworigin'] = 'Apelul cu origini încrucișate pe care încercați să îl efectuați a fost respins. Vă rugăm să verificați https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'A apărut o eroare în timpul ștergerii acestui cont. Vă rugăm să încercați din nou!';
$string['core.login.errorexampleurl'] = 'URL-ul https://campus.example.edu este doar un exemplu de URL, nu este un site real.<strong>Te rugăm să folosești URL-ul site-ului școlii sau organizației tale</strong>';
$string['core.login.errorqrnoscheme'] = 'Acest URL nu este un URL valid pentru logare.';
$string['core.login.errorupdatesite'] = 'A apărut o eroare în timpul actualizării tokenului pentru acest site.';
$string['core.login.exceededloginattempts'] = 'Ai nevoie de ajutor pentru logare? Încearcă {{recoverPassword}} sau contactează asistența de pe site.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'recuperarea parolei tale';
$string['core.login.exceededloginattemptssupportsubject'] = 'Nu mă pot loga';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Ai nevoie de ajutor pentru logare? Contactează asisitența de pe site.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Ai nevoie de ajutor pentru logare? Încearcă {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Se pare că întâmpini probleme la accesarea contului tău. Poți să îți contactezi școala sau furnizorul de elearning și să încerci mai târziu.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Nu îmi pot reseta parola';
$string['core.login.faqcannotconnectanswer'] = 'Te rugăm, contactează administratorul site-ului tău.';
$string['core.login.faqcannotconnectquestion'] = 'Am tastat corect adresa site-ului meu, dar tot nu mă pot conecta.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Dacă ați încercat să căutați după adresa URL și tot nu puteți găsi site-ul dvs. Moodle, vă rugăm să luați legătura cu persoana care se ocupă de Moodle în școala sau organizația dvs.';
$string['core.login.faqcannotfindmysitequestion'] = 'Nu pot să găsesc site-ul pe baza adresei URL.';
$string['core.login.faqcantloginanswer'] = '<p>Odată ce v-ați conectat la site-ul dvs. Moodle, ar trebui să vă puteți conecta cu numele de utilizator și parola obișnuite.</p><br><p>Dacă v-ați uitat numele de utilizator sau parola, selectați opțiunea <strong >Ați uitat parola?</strong>. Dacă încă întâmpinați probleme la conectare sau nu vedeți nicio opțiune pentru a vă recupera numele de utilizator sau parola, vă rugăm să luați legătura cu persoana care se ocupă de Moodle în școala sau organizația dvs.</p>';
$string['core.login.faqcantloginquestion'] = 'Nu mă pot loga.';
$string['core.login.faqmore'] = 'Verifică <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">Întrebări și răspunsuri</a> pentru mai multe răspunsuri.';
$string['core.login.faqsetupsiteanswer'] = 'Vizitează {{$link}} pentru a verifica diferite opțiuni pe care le ai pentru crearea site-ului tău Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Începe.';
$string['core.login.faqsetupsitequestion'] = 'Vreau să îmi configurez site-ul Moodle.';
$string['core.login.faqtestappanswer'] = 'Pentru a testa aplicația pe un site demonstrativ Moodle, tastați „profesor” sau „student” în câmpul <strong>Site-ul dvs.</strong> și atingeți <strong>Conectați-vă la site-ul dvs.</strong>.';
$string['core.login.faqtestappquestion'] = 'Pot să testez aplicația pe un site demo?';
$string['core.login.faqwhatisurlanswer'] = '<p>Dacă nu vă puteți găsi site-ul după nume, încercați să căutați după adresa URL a site-ului dvs. Moodle (sau adresa web).</p><p>Pentru a găsi adresa site-ului dvs.:</p><ol>< li>Deschideți un browser web și accesați pagina de conectare a site-ului dvs. Moodle.</li><li>În partea de sus a paginii, în bara de adrese, veți vedea adresa URL a site-ului dvs. Moodle, de ex. „campus.example.edu”.<br>{{$image}}</li><li>Copiați adresa URL (nu copiați /login și nici ce urmează), inserați-o în <strong>site-ul dvs.< /strong> în aplicație, apoi atingeți <strong>Conectați-vă la site-ul dvs.</strong></li><li>Acum vă puteți conecta la site-ul dvs. cu numele de utilizator și parola.</li></ol>< p>Dacă ați încercat să căutați după adresa URL și tot nu puteți găsi site-ul dvs. Moodle, vă rugăm să luați legătura cu persoana care se ocupă de Moodle în școala sau organizația dvs.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Cum pot să găsesc site-ul meu?';
$string['core.login.faqwhereisqrcode'] = 'Unde pot să găsesc codul QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>If your school or learning provider has enabled it, you will find a QR code on the web site at the bottom of your user profile page.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Găsește site-ul tău';
$string['core.login.helpmelogin'] = '<p>Există multe mii de site-uri Moodle în întreaga lume. Această aplicație se poate conecta numai la site-urile Moodle care au activat în mod special accesul la aplicația mobilă</p><p>Dacă nu vă puteți conecta la site-ul dvs. Moodle, trebuie să contactați administratorul site-ului și să-i cereți să citească <a href= "http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p>
<p>Pentru a testa aplicația în un site demonstrativ Moodle tip <i>profesor</i> sau <i>student</i> în câmpul <i>Adresa site-ului</i> și faceți clic pe <b>butonul Conectare</b>.</p >';
$string['core.login.invalidaccount'] = 'Te rugăm să verifici datele de conectare și să încerci din nou.';
$string['core.login.invalidmoodleversion'] = 'Versiunea Moodle este invalidă. Versiunea minimă este {{$a}}.';
$string['core.login.invalidsite'] = 'URL-ul site-ului nu este valid.';
$string['core.login.invalidtime'] = 'Ora nu este validă';
$string['core.login.invalidvaluemax'] = 'Valoarea maximă este {{$a}}';
$string['core.login.invalidvaluemin'] = 'Valoarea minimă este  {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Trebuie să te autentifici din nou. Trebuie să te conectezi la site într-o fereastră a browser-ului.';
$string['core.login.loginbutton'] = 'Logat!';
$string['core.login.logininsiterequired'] = 'Trebuie sa te loghezi pe site într-o fereastră a browser-ului.';
$string['core.login.mobileservicesnotenabled'] = 'Serviciile mobile nu sunt activate pe site.';
$string['core.login.notloggedin'] = 'Trebuie să fii logat.';
$string['core.login.onboardingcreatemanagecourses'] = 'Creează-ți și administrează-ți cursurile';
$string['core.login.onboardingenrolmanagestudents'] = 'Înscrie și gestionează-ți cursanții';
$string['core.login.onboardinggetstarted'] = 'Începe cu Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Am deja o platformă Moodle';
$string['core.login.onboardingimalearner'] = 'Sunt cursant';
$string['core.login.onboardingimaneducator'] = 'Sunt un profesor';
$string['core.login.onboardingineedasite'] = 'Am nevoie de o platformă Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Oferă feedback în timp util';
$string['core.login.onboardingtoconnect'] = 'Pentru a te conecta la aplicația Moodle, vei avea nevoie de un site Moodle';
$string['core.login.onboardingwelcome'] = 'Bine ai venit la Moodle App!';
$string['core.login.or'] = 'Sau';
$string['core.login.passwordrequired'] = 'Este necesară introducerea parolei';
$string['core.login.policyacceptmandatory'] = 'Înțeleg și sunt de acord cu politicile obligatorii ale site-ului';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA challenge image';
$string['core.login.recaptchaexpired'] = 'Verificarea a expirat. Răspunde din nou la întrebarea de securitate.';
$string['core.login.recaptchaincorrect'] = 'Răspunsul la întrebarea de securitate este incorect.';
$string['core.login.reconnect'] = 'Reconectare';
$string['core.login.reconnecthelp'] = 'Dacă ai probleme la reconectare, încearcă din noi mai târziu sau contactează-ți școala sau furnizorul de elearning.';
$string['core.login.reconnectssodescription'] = 'Sesiunea ta a expirat. Te rugăm să te conectezi din nou într-o fereastră a browser-ului pentru a continua.';
$string['core.login.reconnectsupportsubject'] = 'Este nevoie de suport pentru reconectare';
$string['core.login.reconnecttosite'] = 'Reconectați-vă la site';
$string['core.login.removeaccount'] = 'Șterge cont';
$string['core.login.searchby'] = 'Caută după:';
$string['core.login.selectsite'] = 'Vă rugăm să selectați contul dumneavoastră:';
$string['core.login.signupplugindisabled'] = '{{$a}} nu este activat';
$string['core.login.signuprequiredfieldnotsupported'] = 'Formularul de înscriere conține un câmp personalizat obligatoriu care nu este acceptat în aplicație. Vă rugăm să vă creați contul folosind un browser web.';
$string['core.login.siteaddress'] = 'Site-ul tău';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Există {{count}} notificări necitite.';
$string['core.login.sitehasredirect'] = 'Site-ul dvs. conține cel puțin o redirecționare HTTP. Aplicația nu poate urmări redirecționările, aceasta ar putea fi problema care împiedică aplicația să se conecteze la site-ul dvs.';
$string['core.login.siteinmaintenance'] = 'Site-ul dumneavoastră se află în mentananță';
$string['core.login.sitenotallowed'] = 'Acest site nu mai este disponibil.';
$string['core.login.sitepolicynotagreederror'] = 'Politica site-ului nu este acceptată.';
$string['core.login.siteurl'] = 'Adresă URL';
$string['core.login.siteurlrequired'] = 'Este necesară adresa URL a site-ului, de exemplu <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Tot nu vă puteți conecta?';
$string['core.login.toggleremove'] = 'Editează lista de conturi';
$string['core.login.usernamerequired'] = 'Este necesar numele de utilizator';
$string['core.login.visitchangepassword'] = 'Vrei să accesezi site-ul pentru a schimba parola?';
$string['core.login.webservicesnotenabled'] = 'Serviciile web nu sunt activate pe site.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Te poți conecta în continuare la site prin nume de utilizator și parolă.';
$string['core.login.yourenteredsite'] = 'Conectează-te la site-ul tău';
$string['core.lostconnection'] = 'Sesiunea ta a expirat. Te rugăm să te autentifici din nou pentru a continua.';
$string['core.mainmenu.switchaccount'] = 'Schimbă contul';
$string['core.mainmenu.usermenutourdescription'] = 'Locul unde îți verifici notele, îți modifici setările sau te loghezi în alt cont.';
$string['core.mainmenu.usermenutourtitle'] = 'Explorează spațiul tău personal';
$string['core.needhelp'] = 'Ai nevoie de ajutor?';
$string['core.networkerroriframemsg'] = 'Acest conținut nu este disponibil offline. Te rugăm să te conectezi la internet și să încerci din nou.';
$string['core.networkerrormsg'] = 'A apărut o problemă la conectarea pe site. Te rugăm să verifici conexiunea și să încerci din nou.';
$string['core.nooptionavailable'] = 'Nicio opțiune disponibilă';
$string['core.nopasswordchangeforced'] = 'Nu poți continua fără a-ți schimba parola.';
$string['core.nopermissionerror'] = 'Ne pare rău, dar nu ai permisiunea pentru această acțiune';
$string['core.notapplicable'] = 'n/a';
$string['core.notdownloadable'] = 'Nu se descarcă';
$string['core.notsent'] = 'Nu a fost trimis';
$string['core.nummore'] = 'mai mult {{$a}}';
$string['core.openfile'] = 'Deshide fișier';
$string['core.openfullimage'] = 'Apasă aici pentru a vizualiza imaginea la dimensiunea întreagă';
$string['core.openinbrowser'] = 'Deschide în browser';
$string['core.openinbrowserdescription'] = 'Veți fi direcționați către un browser web';
$string['core.openmodinbrowser'] = 'Deschide {{$a}} în browser';
$string['core.opensecurityquestion'] = 'Deschide întrebarea de securitate';
$string['core.opensettings'] = 'Deschide setările';
$string['core.openwith'] = 'Deschide cu...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Afișează';
$string['core.pulltorefresh'] = 'Trage în jos pentru actualizare';
$string['core.qrscanner'] = 'Scanner QR';
$string['core.question.cannotdeterminestatus'] = 'Nu se poate determina status-ul';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Site-ul tău nu pemite încă atașarea de fișiere la răspunsuri.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Site-ul tău încă nu acceptă editarea fișierelor încorporate.';
$string['core.question.errorquestionnotsupported'] = 'Acest tip de întrebare nu este acceptată de aplicație: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tap pentru selectare, tap pentru drop.';
$string['core.question.questionmessage'] = 'Întrebare {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Vei fi redirecționat către site.';
$string['core.reminders.atthetime'] = 'La ora evenimentului';
$string['core.reminders.custom'] = 'Particularizare...';
$string['core.reminders.customreminder'] = 'Reminder personalizat';
$string['core.reminders.delete'] = 'Șterge reminder-ul';
$string['core.reminders.reminderset'] = 'Reminder setat pentru {{$a}}';
$string['core.reminders.reminderunset'] = 'Reminder șters';
$string['core.reminders.setareminder'] = 'Setază un reminder';
$string['core.reminders.setareminderfor'] = 'Setează un reminder pentru "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Setează reminder';
$string['core.reminders.timebefore'] = '{{value}} {{units}} înainte';
$string['core.reminders.value'] = 'Valoare';
$string['core.removefiles'] = 'Șterge fișierele {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Pot fi aplicate filtre pentru această vizualizare. Pentru a edita filtrele sau a schimba ordinea de sortare, <a href="{{$a}}">deschideți acest raport în browser.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Ascunde coloane';
$string['core.reportbuilder.showcolumns'] = 'Afișează coloane';
$string['core.requireduserdatamissing'] = 'Acest utilizator are unele date de profil obligatorii necompletate. Completați aceste date pe site și încercați din nou.<br>{{$a}}';
$string['core.resume'] = 'Reia';
$string['core.retry'] = 'Încearcă din nou';
$string['core.scanqr'] = 'Scanează codul  QR';
$string['core.scrollbackward'] = 'Scroll înapoi';
$string['core.scrollforward'] = 'Scroll înainte';
$string['core.search.allcategories'] = 'Toate categoriile';
$string['core.search.empty'] = 'Ce cauți?';
$string['core.search.filtercategories'] = 'Filtrează rezultatele după';
$string['core.search.filtercourses'] = 'Caută în';
$string['core.search.noresults'] = 'Nu s-au găsit rezultate pentru "{{$a}}"';
$string['core.search.noresultshelp'] = 'Verifică greselile de tastare sau încearcă să folosești cuvinte cheie diferite';
$string['core.search.resultby'] = 'De către {{$a}}';
$string['core.searching'] = 'Căutare';
$string['core.serverconnection'] = 'Eroare la conectarea la server: {{details}}';
$string['core.settings.about'] = 'Despre';
$string['core.settings.appsettings'] = 'Setări aplicație';
$string['core.settings.appversion'] = 'Versiune aplicație';
$string['core.settings.cannotsyncloggedout'] = 'Site-ul nu poate fi sincronizat pentru că te-ai delogat. Te rugăm să încerci din nou când ești logat pe site.';
$string['core.settings.cannotsyncoffline'] = 'Sincronizarea site-ului a eșuat deoarece dispozitivul tău nu este conectat la internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Dispozitivul tău mobil nu este conectat la Wi-Fi. Conectează-te la o rețea Wi-Fi sau dezactivează optimizarea transferului de date în setările aplicației.';
$string['core.settings.changelanguage'] = 'Schimbă în {{$a}}';
$string['core.settings.changelanguagealert'] = 'Schimbarea limbii va reporni aplicația.';
$string['core.settings.colorscheme'] = 'Schema de culori';
$string['core.settings.colorscheme-dark'] = 'Închis';
$string['core.settings.colorscheme-light'] = 'Deschis';
$string['core.settings.colorscheme-system'] = 'Modul implicit al sistemului';
$string['core.settings.colorscheme-system-notice'] = 'Modul implicit al sistemului va depinde de suportul dispozitivului dvs.';
$string['core.settings.compilationinfo'] = 'Informații de compilare';
$string['core.settings.connecttosync'] = 'Dispozitivul tău este offline. Conectează-te la internet pentru a sincroniza site-urile.';
$string['core.settings.connectwifitosync'] = 'Conectează-te la o rețea Wi-Fi sau dezactivează optimizarea transferului de date pentru sincronizarea site-urilor.';
$string['core.settings.copyinfo'] = 'Copiere informații despre dispozitiv în clipboard';
$string['core.settings.cordovadevicemodel'] = 'Model dispozitiv Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versiunea OS a Dispozitive Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Platforma Dispozitive Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID Dispozitive Cordova';
$string['core.settings.cordovaversion'] = 'Versiunea Cordova';
$string['core.settings.debugdisplaydescription'] = 'Dacă opțiunea este activată, fereastra modală va afișa mai multe informații despre eroare, dacă este posibil.';
$string['core.settings.developeroptions'] = 'Opțiuni pentru dezvoltator';
$string['core.settings.deviceinfo'] = 'Informații despre dispozitiv';
$string['core.settings.deviceos'] = 'Sistemul de operare al dispozitivului';
$string['core.settings.displayformat'] = 'Dimensiunea ecranului';
$string['core.settings.enableanalytics'] = 'Activează Analitice';
$string['core.settings.enableanalyticsdescription'] = 'Dacă această opțiune este activată, aplicația va colecta date anonime despre utilizare.';
$string['core.settings.enabledownloadsection'] = 'Activează secțiunile pentru descărcare';
$string['core.settings.enablefirebaseanalytics'] = 'Activează Firebase analytics';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Dacă este activată această opțiune, aplicația va colecta date anonime despre utilizarea datelor.';
$string['core.settings.enablerichtexteditor'] = 'Activează editorul text';
$string['core.settings.enablerichtexteditordescription'] = 'Dacă este activată această opțiune, un editor text va fi disponibil la inserarea de conținut.';
$string['core.settings.enablesyncwifi'] = 'Permiteți sincronizarea doar pe o conexiune Wi-Fi';
$string['core.settings.encryptedpushsupported'] = 'Notificări Push criptate suportate';
$string['core.settings.entriesincache'] = '{{$a}} postări în memoria cache';
$string['core.settings.errorsyncsite'] = 'Eroare la sincronizarea datelor de pe site. Te rugăm să verifici conexiunea la internet și să încerci din nou.';
$string['core.settings.estimatedfreespace'] = 'Spațiu liber estimat';
$string['core.settings.filesystemroot'] = 'Rădăcina sistemului de fișiere';
$string['core.settings.fontsize'] = 'Mărimea textului';
$string['core.settings.forcedsetting'] = 'Această setare a fost forțată de configurarea site-ului';
$string['core.settings.helpusimprove'] = 'Ajută-ne să îmbunătățim această aplicație';
$string['core.settings.ioscookies'] = 'Urmărirea utilizării în mai multe site-uri';
$string['core.settings.ioscookiesdescription'] = 'Conținutul încorporat din site necesită fișiere cookies utilizate în mai multe site-uri pentru a funcționa. Pentru a activa conținutul încorporat, te rugăm să mergi la setările aplicației IOS și să activezi \'Permite urmărirea utilizării în mai multe site-uri\'.';
$string['core.settings.legaldisclaimer'] = 'Declinare legală a răspunderii';
$string['core.settings.localnotifavailable'] = 'Notificările locale sunt disponibile';
$string['core.settings.locationhref'] = 'Web view URL';
$string['core.settings.logintosync'] = 'Loghează-te pentru a sincroniza';
$string['core.settings.navigatorlanguage'] = 'Limba navigatorului';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Starea conexiunii la Internet';
$string['core.settings.opensourcelicenses'] = 'Licențe Open Source';
$string['core.settings.privacypolicy'] = 'Politica de confidențialitate';
$string['core.settings.publisher'] = 'Editor';
$string['core.settings.pushid'] = 'Identificatorul notificărilor push';
$string['core.settings.reportinbackground'] = 'Erorile se raportează automat';
$string['core.settings.screen'] = 'Informații ecran';
$string['core.settings.showdownloadoptions'] = 'Afișează opțiunile de descărcare';
$string['core.settings.siteinfo'] = 'Informații despre site';
$string['core.settings.sitesyncfailed'] = 'Sincronizarea site-ului a eșuat';
$string['core.settings.spaceusage'] = 'Spațiu utilizat';
$string['core.settings.syncdatasaver'] = 'Optimizare transfer date: sincronizează numai când ești în rețea Wi-Fi';
$string['core.settings.synchronization'] = 'Sincronizare';
$string['core.settings.synchronizenow'] = 'Sincronizează acum';
$string['core.settings.synchronizenowhelp'] = 'Sincronizarea unui site va trimite modificările în așteptare și toată activitatea offline stocată în dispoztivul mobil și va sincroniza unele date precum mesaje și notificări.';
$string['core.settings.syncsettings'] = 'Setări sincronizare';
$string['core.settings.wificonnection'] = 'Conexiune WiFi';
$string['core.settings.youradev'] = 'Ești dezvoltator acum';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Alege un cont în care să stochezi fișiere.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Există deja un fișier cu acest nume. Vrei să înlocuiești fișierul existent sau să îl redenumești în"{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Nu există site-uri stocate. Te rugăm să adaugi un site înainte de a partaja un fișier prin aplicație.';
$string['core.sharedfiles.nosharedfiles'] = 'Nu există fișiere partajate stocate pe acest site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'You have no files to upload here. If you want to upload a file from another app, locate the file and click the \'Open in\' button.';
$string['core.sharedfiles.rename'] = 'Redenumire';
$string['core.sharedfiles.replace'] = 'Înlocuire';
$string['core.sharedfiles.sharedfiles'] = 'Fișiere partajate';
$string['core.sharedfiles.successstorefile'] = 'Fișierul a fost stocat cu succes. Selectează fișierul pentru a fi încărcat în fișierele tale private sau pentru a fi utilizat într-o activitate.';
$string['core.sitenotfound'] = 'Site-ul nu a fost găsit.';
$string['core.sitenotfoundhelp'] = 'Nu putem găsi site-ul pe care l-ați introdus. Verificați dacă există greșeli de scriere sau încercați din nou mai târziu. Dacă vedeți în continuare acest mesaj, contactați școala sau furnizorul de învățare.';
$string['core.siteunavailablehelp'] = 'Site-ul „{{site}}” nu este disponibil momentan. Încercați din nou mai târziu sau contactați școala sau furnizorul dvs. de învățământ.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Ne pare rău...';
$string['core.start'] = 'Începe';
$string['core.startingtime'] = 'Ora de începere: {{$a}}';
$string['core.storingfiles'] = 'Se stochează fișiere';
$string['core.swipenavigationtourdescription'] = 'Glisează în stânga și în dreapta pentru a putea naviga.';
$string['core.tablet'] = 'Tabletă';
$string['core.tag.errorareanotsupported'] = 'Această zonă de etichetare nu este acceptată de aplicație.';
$string['core.tag.tagareabadgedescription'] = 'Există {{count}} itemi.';
$string['core.tag.warningareasnotsupported'] = 'Unele zone de etichete nu sunt afișate deoarece nu sunt acceptate de aplicație.';
$string['core.thereisdatatosync'] = 'Există {{$a}} offline de sincronizat.';
$string['core.toggledelete'] = 'Comutați butoanele de ștergere';
$string['core.tryagain'] = 'Încercați din nou';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'A apărut o eroare neașteptată. Închideți și redeschideți aplicația pentru a încerca din nou';
$string['core.unicodenotsupported'] = 'Unele emoji nu sunt acceptate pe acest site și vor fi șterse când se trimite mesajul';
$string['core.unicodenotsupportedcleanerror'] = 'A fost găsit text gol la curățarea caracterelor Unicode.';
$string['core.unknown'] = 'Necunoscut';
$string['core.unzipping'] = 'Dezarhivare';
$string['core.updaterequired'] = 'Este necesară actualizarea aplicației';
$string['core.updaterequireddesc'] = 'Te rugăm să îți actualizezi aplicația la versiunea {{$a}}';
$string['core.user.completeprofile'] = 'Completați profilul';
$string['core.user.completeprofilehelp'] = 'Dacă întâmpinați probleme la completarea profilului, încercați din nou mai târziu sau contactați școala sau furnizorul de învățare.';
$string['core.user.completeprofilenotice'] = 'Înainte de a continua, te rugăm să completezi câmpurile obligatorii din profilul tău de utilizator.';
$string['core.user.completeprofilereconnectinstructions'] = 'Dacă nu ți-ai completat corect profilul, ți se va cere să completezi din nou.';
$string['core.user.completeprofilesupportsubject'] = 'Am nevoie de ajutor la completarea profilului';
$string['core.user.completeyourprofile'] = 'Completează-ți profilul';
$string['core.user.contact'] = 'Contact';
$string['core.user.detailsnotavailable'] = 'Detaliile acestui utilizator nu îți sunt disponibile.';
$string['core.user.errorloaduser'] = 'Eroare la încărcarea utilizatorului.';
$string['core.user.sendemail'] = 'Email';
$string['core.user.support'] = 'Contactează asistența de pe site';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Utilizator cu identificatorul {{id}}';
$string['core.usernologin'] = 'Autentificarea a fost anulată pentru acest cont';
$string['core.viewcode'] = 'Vizualizare cod';
$string['core.vieweditor'] = 'Vizualizare editor';
$string['core.viewembeddedcontent'] = 'Vizualizare conținut încorporat';
$string['core.wanttochangesite'] = 'Dorești să accesezi alt site sau să te deloghezi?';
$string['core.warningofflinedatadeleted'] = 'Modificări offline din {{component}} \'{{name}}\' au fost șterse. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Noi modificări în această activitate au fost făcute de pe un alt dispozitiv.';
$string['core.warnopeninbrowser'] = '<p>Urmează să părăsești aplicația pentru a deschide următorul URL în browser-ul dispozitivului tău.
Dorești să continui?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '„Administratorii site-ului” sunt persoanele care gestionează platforma Moodle la școala/universitatea/compania sau organizația ta. Dacă nu știți cum să-i contactați, vă rugăm să contactați profesorii/formatorii dumneavoastră.';
$string['core.whyisthishappening'] = 'De ce se întâmplă asta?';
$string['core.wsfunctionnotavailable'] = 'Această funcție Web nu este disponibilă.';
$string['core.youreoffline'] = 'Dispozitivul tău este offline';
$string['core.youreonline'] = 'Dispozitivul tău este din nou online';
$string['core.zoomin'] = 'Zoom in';
$string['core.zoomout'] = 'Zoom out';
$string['freemium.autologoutclosingtheapp'] = 'Imediat după ce închizi aplicația';
$string['freemium.autologoutcustomtime'] = 'Timp personalizat după părăsirea aplicației';
$string['freemium.autologoutdefault'] = 'Implicit';
$string['freemium.autologouttitle'] = 'Delogare automată de pe acest dispozitiv';
$string['freemium.biometriclogin'] = 'Logare biometrică';
$string['freemium.biometriclogindescription'] = 'Pune degetul în cititorul de amprente.';
$string['freemium.biometricloginenablefaceid'] = 'Activează FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Activează Fingerprint';
$string['freemium.biometricloginenabletouchid'] = 'Activează TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Autentificare cu FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Autentificare cu Fingerprint';
$string['freemium.biometricloginloginwithtouchid'] = 'Autentificare cu TouchID';
$string['freemium.biometricloginskip'] = 'Omite momentan';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} activată.';
$string['freemium.biometricloginturnoff'] = 'Poți activa și dezactiva oricând această funcție din setări.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID - recunoaștere facială';
$string['freemium.biometriclogintypefingerprint'] = 'Amprentă';
$string['freemium.biometriclogintypetouchid'] = 'TouchID - amprentă digitală';
$string['freemium.biometricloginwithfingerorface'] = 'Utilizează logarea biometrică prin amprenta digitală sau prin recunoaștere facială.';
$string['freemium.change'] = 'Modifică';
$string['freemium.coursesbatchdownloaddisabled'] = 'Descărcarea unui set cu mai multe cursuri nu este activată pe acest site.';
$string['freemium.coursesdownloadlimitreached'] = 'Limita de descărcare a cursurilor a fost atinsă! Poți avea doar {{limit}} cursuri descărcate, contactează administratorul pentru a mări această limită sau a șterge unele cursuri descărcate de pe dispozitiv.';
$string['freemium.downloadmainapplicationrequired'] = 'Puteți să vă conectați pe site doar folosind aplicația dedicată.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Site-ul la care încerci să te conectezi are și o aplicație dedicată pe care poți să o încerci.';
$string['freemium.feature_autologout'] = 'Delogare automată';
$string['freemium.feature_biometriclogin'] = 'Logare biometrică';
$string['freemium.feature_coursesdownload'] = 'Cursuri descărcate';
$string['freemium.feature_multimediapushnotifications'] = 'Push notifications multimedia';
$string['freemium.feature_pushnotificationsdevices'] = 'Dispozitive Push notifications';
$string['freemium.feature_qrlogin'] = 'Autentificare prin cod QR';
$string['freemium.feature_remotethemes'] = 'Teme de pe server';
$string['freemium.feature_sitelogo'] = 'Logo-ul site-ului';
$string['freemium.notallowed'] = 'Nu este permis';
$string['freemium.nottoday'] = 'Nu astăzi';
$string['freemium.qrlogindisabled'] = 'Autentificarea în aplicație utilizând un cod QR nu este acceptată în platformă:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'Codul QR a expirat. Te rugăm să actualizezi pagina cu codul QR și să o scanezi din nou.';
$string['freemium.qrloginipmismatch'] = 'Dispozitivul pe care îl utilizezi pentru a te conecta nu pare să fie în aceeași rețea cu dispozitivul care afișează codul QR. Asigură-te că ambele dispozitive sunt conectate la aceeași rețea (de exemplu, aceeași rețea WiFi).<br><br>Dacă eroarea persistă, te rugăm să contactezi administratorul site-ului.';
$string['freemium.ratetheapp'] = 'Îți place aplicația noastră?';
$string['freemium.ratetheapp_feedbackko'] = 'Spune-ne ce nu a funcționat';
$string['freemium.ratetheapp_feedbackmessage'] = 'Feedback-ul tău va fi anonim';
$string['freemium.ratetheapp_feedbackok'] = 'Trimite feedback';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Scrie ceva aici';
$string['freemium.ratetheapp_feedbacksent'] = 'Mulțumim! Feedback-ul a fost trimis cu succes';
$string['freemium.ratetheapp_sendtostore'] = 'Ai un moment să evaluezi aplicația noastra? Ne ajuți astfel la îmbunătățirea ei.';
$string['freemium.remindmelater'] = 'Amintește-mi mai târziu!';
$string['freemium.settingsoptions_autologout'] = 'Logare automată';
$string['freemium.settingsoptionsfacial'] = 'Activează logarea prin recunoaștere facială';
$string['freemium.settingsoptionsfingerprint'] = 'Activează logarea cu amprentă';
$string['freemium.subscription'] = 'Plan de abonament';
$string['freemium.subscriptiondetails'] = 'Detalii despre subscripție';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{overflowCount }} șiruri de limbă personalizate sunt ignorate';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{overflowCount}} elemente de meniu personalizate sunt ignorate';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{overflowCount}} funcțiile dezactivate configurate sunt încă activate';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Tema ta particularizată nu este aplicată';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Logo-ul site-ului tău nu este aplicat';
$string['freemium.subscriptionfeature_limited'] = 'Limitat la {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Nelimitat';
$string['freemium.subscriptionplan'] = 'Plan de abonament';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = 'expirat';
$string['freemium.subscriptionplan_free'] = 'Gratis';
$string['freemium.subscriptionplan_premium'] = 'Premium';
$string['freemium.subscriptionplan_pro'] = 'Pro';
$string['freemium.subscriptionplan_upgrade'] = 'Actualizează-ți planul';
$string['freemium.subscriptionplan_validuntil'] = 'valid până la {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Planurile abonamentului  indică ce restricție se aplică pentru acest site.';
$string['freemium.subscriptionplanlearnmore'] = 'Află mai multe';
$string['freemium.upsell_renewexpired'] = 'Abonamentul tău a expirat';
$string['freemium.upsell_renewexpiring'] = 'Abonamentul tău va expira în {{ days }} zile';
$string['freemium.upsell_renewtitle'] = 'Reînnoiește-ți abonamentul';
$string['freemium.upsell_upgradefreeaccept'] = 'Actualizează';
$string['freemium.upsell_upgradefreemessage'] = 'În prezent aveți planul gratis de abonament, faceți upgrade pentru a debloca mai multe opțiuni.';
$string['freemium.upsell_upgradefreepostpone'] = 'Mai târziu';
$string['freemium.upsell_upgradefreetitle'] = 'Actualizează-ți planul';
$string['pluginname'] = 'Șiruri de caractere de limbă pentru aplicația Moodle App';
$string['privacy_metadata'] = 'Acest plugin nu stochează date despre utilizatori.';
$string['workplace.teams.isoverdue'] = 'Are articole restante sau expirate';
