<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sl', version '4.0'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:submissionsdue'] = 'Rok za oddajo:';
$string['activitydate:submissionsopen'] = 'Se odpre:';
$string['activitydate:submissionsopened'] = 'Odprto:';
$string['activityoverview'] = 'Imate naloge za pregled';
$string['addattempt'] = 'Dovoli dodaten poskus';
$string['addnewattempt'] = 'Dodaj nov poskus';
$string['addnewattempt_help'] = 'S tem ukazom ustvarite nov prazen prispevek, ki ga lahko urejate.';
$string['addnewattemptfromprevious'] = 'Dodaj nov poskus glede na prejšnje prispevke';
$string['addnewattemptfromprevious_help'] = 'S tem ukazom kopirate vsebino prejšnjega prispevka v nov prispevek, ki ga lahko urejate.';
$string['addnewgroupoverride'] = 'Dodaj preglasitev skupine';
$string['addnewuseroverride'] = 'Dodaj preglasitev uporabnika';
$string['addsubmission'] = 'Dodaj prispevek';
$string['addsubmission_help'] = 'Niste še oddali prispevka';
$string['allocatedmarker'] = 'Dodeljeni ocenjevalec';
$string['allocatedmarker_help'] = 'Ocenjevalec, ki je dodeljen temu prispevku';
$string['allowsubmissions'] = 'Dovoli uporabnikom, da nadaljujejo z oddajo prispevkov v tej nalogi.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Podrobnosti naloge in obrazec za oddajo bosta na voljo od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Dovoli začetek oddaje od';
$string['allowsubmissionsfromdate_help'] = 'Če je omogočeno, udeleženci ne bodo mogli oddati nalog pred tem datumom, če pa je onemogočeno, jih lahko oddajo takoj.';
$string['allowsubmissionsfromdatesummary'] = 'Prispevke v nalogi lahko oddate od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Dovoli spreminjanje prispevka';
$string['alwaysshowdescription'] = 'Vedno prikaži opis';
$string['alwaysshowdescription_help'] = 'Če je onemogočeno, bo opis naloge viden udeležencem šele na datum začetka oddaje.';
$string['applytoteam'] = 'Uporabi ocene in pripombe za celotno skupino';
$string['assign:addinstance'] = 'Dodaj novo nalogo';
$string['assign:editothersubmission'] = 'Uredi oddani prispevek drugega udeleženca';
$string['assign:exportownsubmission'] = 'Izvozi svoj prispevek';
$string['assign:grade'] = 'Oceni nalogo';
$string['assign:grantextension'] = 'Odobri podaljšanje';
$string['assign:manageallocations'] = 'Upravljaj z ocenjevalci, ki so dodeljeni prispevkom';
$string['assign:managegrades'] = 'Preglej in objavi ocene';
$string['assign:manageoverrides'] = 'Upravljaj preglasitve nalog';
$string['assign:receivegradernotifications'] = 'Prejmi obvestila ocenjevalca glede oddanega prispevka';
$string['assign:releasegrades'] = 'Objavi ocene';
$string['assign:revealidentities'] = 'Razkrij identitete udeležencev';
$string['assign:reviewgrades'] = 'Preglej ocene';
$string['assign:showhiddengrader'] = 'Poglej identiteto skritega ocenjevalca';
$string['assign:submit'] = 'Oddaj nalogo';
$string['assign:view'] = 'Ogled naloge';
$string['assign:viewblinddetails'] = 'Poglej identitete udeležencev ob omogočenih anonimni prispevkih';
$string['assign:viewgrades'] = 'Poglej ocene';
$string['assign:viewownsubmissionsummary'] = 'Poglej povzetek svoje oddaje';
$string['assignfeedback'] = 'Vtičnik za pripombe';
$string['assignfeedbackpluginname'] = 'Vtičnik za pripombe';
$string['assignmentisdue'] = 'Rok za oddajo naloge se je iztekel';
$string['assignmentmail'] = '{$a->grader} je objavil/-a pripombo na vašo oddano nalogo ‚{$a->assignment}‘

Pripomba je dodana nalogi:

 {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} je objavil/a pripombo na vašo oddano nalogo\'‚<i>{$a->assignment}</i>\'.</p>
<p>Pripomba je dodana <a href="{$a->url}">nalogi</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} je objavil/-a komentar k vaši oddani nalogi \'{$a->assignment}\'. Komentar je dodan nalogi';
$string['assignmentname'] = 'Ime naloge';
$string['assignmentplugins'] = 'Vtičniki modula Naloga';
$string['assignmentsperpage'] = 'Število nalog na stran';
$string['assignsubmission'] = 'Vtičnik za oddajo prispevkov';
$string['assignsubmissionpluginname'] = 'Vtičnik za oddajo prispevkov';
$string['attemptheading'] = 'Poskus št. {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Prejšnji poskusi';
$string['attemptnumber'] = 'Številka poskusa';
$string['attemptreopenmethod'] = 'Poskusi ponovno odprti';
$string['attemptreopenmethod_help'] = 'Določa možnosti ponovne oddaje prispevka za udeležence. Možnosti so: <ul><li>Nikoli - Ponovna oddaja ni mogoča.</li><li>Ročno - izvajalec omogoči študentu ponovno oddajo.</li><li>Dokler ni uspešno opravil – Oddaja je omogočena dokler udeleženec ne doseže zahtevane ocene v redovalnici (področje Kategorije in postavke) za to nalogo.</li></ul>';
$string['attemptreopenmethod_manual'] = 'Ročno';
$string['attemptreopenmethod_none'] = 'Nikoli';
$string['attemptreopenmethod_untilpass'] = 'Samodejno, dokler ni uspešno opravljeno';
$string['attemptsettings'] = 'Nastavitve poskusa';
$string['availability'] = 'Razpoložljivost';
$string['backtoassignment'] = 'Nazaj na nalogo';
$string['batchoperationconfirmaddattempt'] = 'Želite dovoliti ponoven poskus za izbrane prispevke?';
$string['batchoperationconfirmdownloadselected'] = 'Ali želite prenesti izbrane prispevke?';
$string['batchoperationconfirmgrantextension'] = 'Želite podaljšati rok za izbrane prispevke?';
$string['batchoperationconfirmlock'] = 'Želite zakleniti vse izbrane prispevke?';
$string['batchoperationconfirmremovesubmission'] = 'Naj se izbrani prispevki odstranijo?';
$string['batchoperationconfirmreverttodraft'] = 'Želite vrniti izbrane prispevke v osnutke?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Želite nastaviti dodeljene ocenjevalce izbranim prispevkom?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Želite nastaviti ocenjevalni potek dela izbranim prispevkom?';
$string['batchoperationconfirmunlock'] = 'Želite odkleniti izbrane prispevke?';
$string['batchoperationlock'] = 'zakleni prispevke';
$string['batchoperationreverttodraft'] = 'vrni prispevke v osnutek';
$string['batchoperationsdescription'] = 'Z izbranimi ...';
$string['batchoperationunlock'] = 'odkleni oddajo prispevkov';
$string['batchsetallocatedmarker'] = 'Nastavi dodeljenega ocenjevalca za {$a} izbranih uporabnikov.';
$string['batchsetmarkingworkflowstateforusers'] = 'Nastavi stanje ocenjevalnega poteka dela za {$a} izbranih uporabnikov.';
$string['blindmarking'] = 'Anonimni prispevki';
$string['blindmarking_help'] = 'Anonimni prispevki skrijejo identiteto udeleženca pred ocenjevalcem. Nastavitev anonimnih prispevkov se bo zaklenila, ko bo za nalogo oddan prispevek ali dodeljena ocena.';
$string['blindmarkingenabledwarning'] = 'Za to dejavnost so omogočeni anonimni prispevki.';
$string['cachedef_overrides'] = 'Informacije o preglasitvi uporabnika in skupine';
$string['calendardue'] = 'Rok za {$a}';
$string['calendargradingdue'] = 'Rok za ocenjevanje {$a}';
$string['changefilters'] = 'Spremeni filtre';
$string['changeuser'] = 'Spremeni uporabnika';
$string['choosegradingaction'] = 'Postopek ocenjevanja';
$string['choosemarker'] = 'Izberi ...';
$string['chooseoperation'] = 'Izberi dejanje';
$string['clickexpandreviewpanel'] = 'Kliknite za razširitev podokna za pregled';
$string['collapsegradepanel'] = 'Skrči podokno za ocenjevanje';
$string['collapsereviewpanel'] = 'Skrči podokno za pregled';
$string['comment'] = 'Komentar';
$string['completiondetail:submit'] = 'Oddajte nalogo';
$string['completionsubmit'] = 'Udeleženec mora oddati prispevek';
$string['configshowrecentsubmissions'] = 'Vsak lahko vidi obvestila o prispevkih v poročilih o nedavnih dejavnostih.';
$string['confirmbatchgradingoperation'] = 'Ali ste prepričani, da želite {$a->operation} za {$a->count} udeležencev?';
$string['confirmsubmission'] = 'Ali želite dokončno oddati vašo nalogo v ocenjevanje? Kasnejše spremembe ne bodo več možne.';
$string['confirmsubmissionheading'] = 'Potrdi prispevek';
$string['conversionexception'] = 'Naloge ni mogoče pretvoriti. Izjema je bila: {$a}.';
$string['couldnotconvertgrade'] = 'Ocene naloge ni mogoče pretvoriti za uporabnika {$a}.';
$string['couldnotconvertsubmission'] = 'Oddane naloge ni mogoče pretvoriti za uporabnika {$a}.';
$string['couldnotcreatecoursemodule'] = 'Modula za predmet ni mogoče ustvariti.';
$string['couldnotcreatenewassignmentinstance'] = 'Novega elementa naloge ni bilo mogoče ustvariti.';
$string['couldnotfindassignmenttoupgrade'] = 'Ni mogoče najti starega elementa naloge, ki bi se ga lahko nadgradilo.';
$string['crontask'] = 'Modul za naloge se obdeluje v ozadju';
$string['currentassigngrade'] = 'Trenutna ocena naloge';
$string['currentattempt'] = 'To je vaš {$a} poskus.';
$string['currentattemptof'] = 'To je vaš {$a->attemptnumber}. poskus.
(Število dovoljenih poskusov: {$a->maxattempts}).';
$string['currentgrade'] = 'Trenutno ocena v redovalnici';
$string['cutoffdate'] = 'Zadnji možni rok za oddajo';
$string['cutoffdate_help'] = 'Če je nastavljeno, prispevka ne bo mogoče oddati po tem datumu, če ta ne bo podaljšan.';
$string['cutoffdatecolon'] = 'Zaključni rok: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Zadnji možni rok za oddajo mora biti za datumom za začetek oddaje.';
$string['cutoffdatevalidation'] = 'Zadnji možni rok za oddajo ne more biti pred rokom za oddajo.';
$string['defaultlayout'] = 'Obnovi privzeto postavitev';
$string['defaultsettings'] = 'Privzete nastavitve za nalogo';
$string['defaultsettings_help'] = 'Te privzete nastavitve veljajo za vse nove naloge.';
$string['defaultteam'] = 'Privzeta skupina';
$string['deleteallsubmissions'] = 'Izbriši vse prispevke';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogočeno';
$string['downloadall'] = 'Prenesi vse prispevke';
$string['downloadasfolders'] = 'Prenesi prispevke v mapah';
$string['downloadasfolders_help'] = 'V primeru, da prispevek obsega več kot eno datoteko, se lahko prenese v mapah. Vsak prispevek se shrani v ločeno mapo, pri čemer se struktura mape v primeru kakršnihkoli podmap ne spremeni in datoteke se ne preimenujejo.';
$string['downloadselectedsubmissions'] = 'Prenesi izbrane prispevke';
$string['duedate'] = 'Rok';
$string['duedate_help'] = 'Določa rok za oddajo naloge. Po tem datumu je oddaja še vedno dovoljena, a bo naloga označena kot zamujena.
Če želite preprečiti oddajo nalog po določenem datumu, nastavite zadnji možni rok za oddajo.';
$string['duedatecolon'] = 'Rok: {$a}';
$string['duedatereached'] = 'Rok za oddajo naloge se je iztekel';
$string['duedatevalidation'] = 'Rok za oddajo mora biti za datumom za začetek oddaje.';
$string['duplicateoverride'] = 'Dvojnik preglasitve';
$string['editaction'] = 'Ukazi ...';
$string['editattemptfeedback'] = 'Uredi oceno in pripombo odziv za poskus številka {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Urejate pripombo za prejšnji poskus. To je poskus številka {$a->attemptnumber} od {$a->totalattempts}.';
$string['editingstatus'] = 'Stanje urejanja';
$string['editonline'] = 'Uredi na spletu';
$string['editoverride'] = 'Uredi preglasitev';
$string['editsubmission'] = 'Uredi prispevek';
$string['editsubmission_help'] = 'Svoj prispevek lahko še vedno spremenite.';
$string['editsubmissionother'] = 'Uredi prispevek za {$a}';
$string['enabled'] = 'Omogočeno';
$string['errornosubmissions'] = 'Ni prispevkov za prenos';
$string['errorquickgradingvsadvancedgrading'] = 'Ocene niso bile shranjene, ker je za nalogo trenutno nastavljeno napredno ocenjevanje';
$string['errorrecordmodified'] = 'Ocene niso bile shranjene, ker je nekdo spremenil enega ali več zapisov, preden ste naložili stran.';
$string['eventallsubmissionsdownloaded'] = 'Vsi prispevki se prenašajo.';
$string['eventassessablesubmitted'] = 'Prispevek je oddan.';
$string['eventbatchsetmarkerallocationviewed'] = 'Prikazana je paketna dodelitev prispevkov v ocenjevanje';
$string['eventbatchsetworkflowstateviewed'] = 'Prikazano je stanje paketnega ocenjevanja.';
$string['eventextensiongranted'] = 'Podaljšanje roka je odobreno.';
$string['eventfeedbackupdated'] = 'Pripomba je posodobljena';
$string['eventfeedbackviewed'] = 'Pripomba ogledana';
$string['eventgradingformviewed'] = 'Ocenjevalni obrazec ogledan';
$string['eventgradingtableviewed'] = 'Ocenjevalna tabela ogledana';
$string['eventidentitiesrevealed'] = 'Identitete so razkrite.';
$string['eventmarkerupdated'] = 'Dodeljeni ocenjevalec je posodobljen.';
$string['eventoverridecreated'] = 'Preglasitev naloge ustvarjena';
$string['eventoverridedeleted'] = 'Preglasitev naloge izbrisana';
$string['eventoverrideupdated'] = 'Preglasitev naloge posodobljena';
$string['eventremovesubmissionformviewed'] = 'Ogledana potrditev odstranitve prispevka.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Prikazana je stran za potrditev razkritja identitete udeležencev.';
$string['eventstatementaccepted'] = 'Uporabnik je sprejel izjavo o prispevku.';
$string['eventsubmissionconfirmationformviewed'] = 'Prikazan je obrazec za potrditev prispevka.';
$string['eventsubmissioncreated'] = 'Prispevek je ustvarjen.';
$string['eventsubmissionduplicated'] = 'Uporabnik je podvojil prispevek.';
$string['eventsubmissionformviewed'] = 'Prikazan je obrazec za oddajo.';
$string['eventsubmissiongraded'] = 'Prispevek je ocenjen.';
$string['eventsubmissionlocked'] = 'Prispevki so za uporabnika zaklenjeni.';
$string['eventsubmissionstatusupdated'] = 'Stanje prispevka je posodobljeno.';
$string['eventsubmissionstatusviewed'] = 'Prikazano je stanje prispevka.';
$string['eventsubmissionunlocked'] = 'Prispevki so za uporabnika odklenjeni.';
$string['eventsubmissionupdated'] = 'Prispevek je posodobljen.';
$string['eventsubmissionviewed'] = 'Prispevek je prikazan.';
$string['eventworkflowstateupdated'] = 'Stanje poteka dela je posodobljeno.';
$string['expandreviewpanel'] = 'Razširi podokno za pregled';
$string['extensionduedate'] = 'Podaljšanje zapadlosti';
$string['extensionnotafterduedate'] = 'Podaljšani rok mora biti kasnejši od datuma oddaje';
$string['extensionnotafterfromdate'] = 'Rok za podaljšanje mora biti po datumu za začetek oddaje';
$string['feedback'] = 'Pripombe';
$string['feedbackavailableanonhtml'] = 'Imate novo pripombo glede vaše oddaje za nalogo \'<i>{$a->assignment}</i>\'<br /><br />
Lahko jo vidite pripeto k vaši <a href="{$a->url}">oddaji naloge</a>.';
$string['feedbackavailableanonsmall'] = 'Nova pripomba za nalogo {$a->assignment}';
$string['feedbackavailableanontext'] = 'Imate novo pripombo glede vaše
oddaje naloge za \'{$a->assignment}\'

Lahko jo vidite pripeto k vaši oddaji naloge:

    {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} je objavil/a pripombo na vašo oddano nalogo \'<i>{$a->assignment}</i>\'<br /><br />
Pripomba je dodana <a href="{$a->url}">nalogi</a>.';
$string['feedbackavailablesmall'] = '{$a->username} je dodal/a pripombo k vaši nalogi {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} je objavil/a pripombe na vašo oddano nalogo ‚{$a->assignment}‘.

Pripomba je dodana nalogi:

 {$a->url}';
$string['feedbackplugin'] = 'Vtičnik za pripombe';
$string['feedbackpluginforgradebook'] = 'Vtičnik za pripombe, ki potisne komentarje v redovalnico';
$string['feedbackpluginforgradebook_help'] = 'Samo en vtičnik za odziv na oddano nalogo lahko shrani pripombe v redovalnico.';
$string['feedbackplugins'] = 'Vtičniki za pripombe';
$string['feedbacksettings'] = 'Nastavitve pripomb';
$string['feedbacktypes'] = 'Tipi pripomb';
$string['filesubmissions'] = 'Oddaja datotek';
$string['filter'] = 'Filter';
$string['filtergrantedextension'] = 'Podaljšanje dovoljeno';
$string['filternone'] = 'Brez filtra';
$string['filternotsubmitted'] = 'Ni oddano';
$string['filterrequiregrading'] = 'Zahteva ocenjevanje';
$string['filtersubmitted'] = 'Oddano';
$string['fixrescalednullgrades'] = 'Naloga vsebuje nekaj napačnih ocen. Ocene lahko <a href=«{$a->link}«>samodejno popravite</a>. To lahko vpliva na skupne ocene pri predmetu.';
$string['fixrescalednullgradesconfirm'] = 'Ali ste prepričani, da želite popraviti napačne ocene? Vse napačne ocene bodo odstranjene, kar lahko vpliva na skupno oceno predmeta.';
$string['fixrescalednullgradesdone'] = 'Ocene popravljene.';
$string['gradeabovemaximum'] = 'Ocena mora biti nižja eli enaka {$a}.';
$string['gradebelowzero'] = 'Ocena mora biti višja ali enaka nič.';
$string['gradecanbechanged'] = 'Ocena se lahko spremeni';
$string['gradechangessaveddetail'] = 'Spremembe ocene in pripombe shranjene';
$string['graded'] = 'Ocenjeno';
$string['gradedby'] = 'Ocenil';
$string['gradedfollowupsubmit'] = 'Ocenjeno – prejet ponovni prispevek';
$string['gradedon'] = 'Ocenjeno v';
$string['gradeitem:submissions'] = 'Prispevki';
$string['gradelocked'] = 'Ta ocena je zaklenjena ali preglašena v redovalnici.';
$string['gradeoutof'] = 'Ocena od {$a}';
$string['gradeoutofhelp'] = 'Ocena';
$string['gradeoutofhelp_help'] = 'Vnesite oceno za prispevek udeleženca. Lahko uporabite decimalke.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} je posodobil/-a svojo oddano nalogo
<i>\'{$a->assignment}\'</i><br /><br />
Oddana naloga <a href="{$a->url}">je na voljo na spletnem mestu</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} je posodobil/a svojo oddano nalogo {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} je posodobil/-a svojo oddano nalogo \'{$a->assignment}\' ob {$a->timeupdated}

Na voljo je tu

 {$a->url}';
$string['gradestudent'] = 'Oceni udeleženca: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Oceni {$a}';
$string['grading'] = 'Ocenjevanje';
$string['gradingchangessaved'] = 'Spremembe ocen so bile shranjene';
$string['gradingduedate'] = 'Opomni me, da ocenim do';
$string['gradingduedate_help'] = 'Pričakovan datum, do katerega naj bi bilo končano ocenjevanje prispevkov. Datum se uporablja za prioritiziracijo obvestil na nadzorni plošči učiteljev.';
$string['gradingdueduedatevalidation'] = 'Datum za opomnik ne more biti pred datumom oddaje.';
$string['gradingduefromdatevalidation'] = 'Datum za opomnik ne more biti pred datumom, od katerega so oddaje dovoljene.';
$string['gradingmethodpreview'] = 'Ocenjevalni kriteriji';
$string['gradingoptions'] = 'Možnosti';
$string['gradingstatus'] = 'Stanje ocen';
$string['gradingstudent'] = 'Ocenjevanje udeleženca';
$string['gradingsummary'] = 'Povzetek ocenjevanja';
$string['grantextension'] = 'Odobri podaljšanje';
$string['grantextensionforusers'] = 'Odobri podaljšanje za toliko udeležencev: {$a}';
$string['groupoverrides'] = 'Preglasitve skupine';
$string['groupoverridesdeleted'] = 'Preglasitve skupine so izbrisane';
$string['groupsnone'] = 'Ne morete dostopati do skupin.';
$string['groupsubmissionsettings'] = 'Nastavitve skupinskih prispevkov';
$string['hiddenuser'] = 'Sodelujoči';
$string['hidegrader'] = 'Skrij identiteto ocenjevalca pred udeleženci';
$string['hidegrader_help'] = 'Če je omogočeno, bo identiteta vsakega uporabnika, ki oceni prispevek k nalogi, skrita, tako da udeleženci ne bodo mogli videti, kdo je ocenil njihovo delo.

Ta nastavitev nima učinka na okvir za komentarje na strani za ocenjevanje.';
$string['hideshow'] = 'Skrij/Prikaži';
$string['inactiveoverridehelp'] = '* Ta preglasitev je neaktivna, saj je uporabniku omejen dostop do dejavnosti. Morda ne pripada pravi skupini ali nima določene prave vloge, lahko pa je dostop omejen drugje, ali pa je dejavnost skrita.';
$string['indicator:cognitivedepth'] = 'Naloga kognitivno';
$string['indicator:cognitivedepth_help'] = 'Indikator temelji na oceni kognitivne širine, ki jo je udeleženec dosegel pri dejavnosti naloge.';
$string['indicator:cognitivedepthdef'] = 'Naloga kognitivno';
$string['indicator:cognitivedepthdef_help'] = 'Sodelujoči je v tem intervalu analize dosegel ta odstotek kognitivne angažiranosti, ki jo ponujajo aktivnosti v nalogi (Ravni = Brez ogleda, Ogled, Oddaja, Ogled pripomb, Komentiranje pripomb, Ponovna oddaja po ogledu pripomb)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Naloga družbeno';
$string['indicator:socialbreadth_help'] = 'Indikator temelji na oceni družbene širine, ki jo je udeleženec dosegel pri dejavnosti naloge.';
$string['indicator:socialbreadthdef'] = 'Naloga družbeno';
$string['indicator:socialbreadthdef_help'] = 'Sodelujoči je v tem intervalu analize dosegel ta odstotek družbene angažiranosti, ki jo ponujajo aktivnosti v nalogi (Ravni = Brez udeležbe, Samo sodelujoči, sodelujoči z drugimi)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Datoteka z navodili';
$string['introattachments'] = 'Dodatne datoteke';
$string['introattachments_help'] = 'Lahko naložite dodatne datoteke, ko so potrebne za izdelavo naloge (npr. predloge za odgovore). Povezave za prenos teh datotek bodo prikazane na strani naloge, pod opisom.';
$string['invalidfloatforgrade'] = 'Podana ocena ni razumljiva: {$a}';
$string['invalidgradeforscale'] = 'Podana ocena ni veljavna za trenutno merilo';
$string['invalidoverrideid'] = 'Neveljaven ID preglasitve';
$string['lastmodifiedgrade'] = 'Zadnja sprememba (ocene)';
$string['lastmodifiedsubmission'] = 'Zadnja sprememba (prispevka)';
$string['latesubmissions'] = 'Zamujeni prispevki';
$string['latesubmissionsaccepted'] = 'Oddaja dovoljena do {$a}';
$string['loading'] = 'Nalaganje ...';
$string['locksubmissionforstudent'] = 'Prepreči oddaje udeležencu: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Zakleni prispevke';
$string['manageassignfeedbackplugins'] = 'Upravljaj z vtičniki za pripombe k nalogam';
$string['manageassignsubmissionplugins'] = 'Upravljaj z vtičniki za prispevke';
$string['marker'] = 'Ocenjevalec';
$string['markerfilter'] = 'Filter ocenjevalcev';
$string['markerfilternomarker'] = 'Ni ocenjevalca';
$string['markingallocation'] = 'Uporabi dodeljeno ocenjevanje';
$string['markingallocation_help'] = 'Če je omogočeno skupaj z ocenjevalnim potekom dela, se lahko posameznim udeležencem dodeli ocenjevalca.';
$string['markingworkflow'] = 'Uporabi ocenjevalni potek dela';
$string['markingworkflow_help'] = 'Če je omogočeno, bodo šle točke prek več stopenj poteka dela, preden bodo na ogled udeležencem. To omogoči več krogov ocenjevanja in ocenjevalec lahko ocene vseh udeležencev objavi naenkrat.';
$string['markingworkflowstate'] = 'Stanje ocenjevalnega poteka dela';
$string['markingworkflowstate_help'] = 'Možna stanja ocenjevalnega poteka dela (glede na vaša dovoljenja) so:

* Ni ocenjeno – ocenjevalec še ni začel.
* Ocenjevanje v teku – ocenjevalec je začel z ocenjevanjem, a še ni končal.
* Ocenjevanje zaključeno – ocenjevalec je zaključil ocenjevanje, a so mogoči še popravki
* Pregled – ocena je trenutno pri učitelju, ki preverja kakovost.
* Pripravljeno za objavo – učitelj je zadovoljen z oceno, a še čaka, da bo udeležencem omogočil dostop do ocen.
* Objavljeno – udeleženci lahko dostopajo do ocen/pripomb';
$string['markingworkflowstateinmarking'] = 'Ocenjevanje v teku';
$string['markingworkflowstateinreview'] = 'V pregledu';
$string['markingworkflowstatenotmarked'] = 'Ni ocenjeno';
$string['markingworkflowstatereadyforrelease'] = 'Pripravljeno za objavo';
$string['markingworkflowstatereadyforreview'] = 'Ocenjevanje zaključeno';
$string['markingworkflowstatereleased'] = 'Objavljeno';
$string['maxattempts'] = 'Največje število poskusov';
$string['maxattempts_help'] = 'Največje število poskusov prispevkov, ki jih lahko opravi udeleženec. Ko je ta številka poskusov dosežena udeleženec ne more več ponovno oddati naloge.';
$string['maxgrade'] = 'Najvišja ocena';
$string['maxperpage'] = 'Največje število nalog na stran';
$string['maxperpage_help'] = 'Največje število nalog, ki jih lahko na strani za ocenjevanje prikaže ocenjevalec. Ta nastavitev je uporabna za preprečevanje časovnih omejitev pri predmetih z velikim številom sodelujočih.';
$string['messageprovider:assign_notification'] = 'Obvestila o nalogi';
$string['modulename'] = 'Naloga';
$string['modulename_help'] = 'Ta modul dejavnosti v nalogi omogoča učitelju, da udeležencem dodeli zadolžitve/domače naloge, jih zbere, oceni in poda odziv.

Udeleženci lahko oddajo nalogo v katerikoli elektronski obliki, npr.: besedilno datoteko, preglednico, sliko, zvočni/video posnetek. Naloga lahko zahteva tudi, da udeleženci vnesejo besedilo neposredno v urejevalnik besedila. Nalogo lahko oddajo skupinsko ali pa kot samostojen izdelek.

Pri pregledovanju in ocenjevanju naloge lahko učitelj poda komentarje tako, da naloži popravljen prispevek kot dokument, naloži avdio posnetek s komentarji ipd.

Ocena naloge je lahko v številčni ali drugi obliki (npr. opisno). Končna ocena je zapisana v redovalnico.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Naloge';
$string['moreusers'] = '{$a} več ...';
$string['multipleteams'] = 'Član več kot ene skupine';
$string['multipleteams_desc'] = 'Naloga zahteva oddajo v skupinah. Ker ste član več kot ene skupine, ne morete oddajati naloge. Za oddajo naloge morate biti včlanjeni v le eno skupino. Kontaktirajte svojega učitelja, da spremeni vaše članstvo v skupinah.';
$string['multipleteamsgrader'] = 'Član več kot ene skupine, zato oddaja ni možna.';
$string['newsubmissions'] = 'Oddane naloge';
$string['nextuser'] = 'Naslednji uporabnik';
$string['noattempt'] = 'Neoddano';
$string['noclose'] = 'Ni datuma zaključka';
$string['nofiles'] = 'Ni datotek.';
$string['nofilters'] = 'Brez filtrov';
$string['nograde'] = 'Brez ocene.';
$string['nomoresubmissionsaccepted'] = 'Dovoljeno le sodelujočim, ki jim je bil odobren podaljšani rok';
$string['none'] = 'Brez';
$string['noonlinesubmissions'] = 'Pri tej nalogi vam ni treba oddati ničesar';
$string['noopen'] = 'Ni datuma začetka';
$string['nooverridedata'] = 'Preglasiti morate vsaj eno nastavitev naloge.';
$string['nosavebutnext'] = 'Naprej';
$string['nosubmission'] = 'V tej nalogi še ni oddanih prispevkov';
$string['noteam'] = 'Niste član nobene skupine';
$string['noteam_desc'] = 'Naloga zahteva oddajo v skupinah. Ker niste član nobene skupine, ne morete oddajati naloge. Kontaktirajte svojega učitelja, da vas doda v skupino.';
$string['noteamgrader'] = 'Niste član nobene skupine, zato oddaja ni možna.';
$string['notgraded'] = 'Neocenjeno';
$string['notgradedyet'] = 'Še neocenjeno';
$string['notifications'] = 'Obvestila';
$string['nousers'] = 'Brez uporabnikov';
$string['nousersselected'] = 'Ni izbranih uporabnikov';
$string['numberofdraftsubmissions'] = 'Osnutki';
$string['numberofparticipants'] = 'Sodelujoči';
$string['numberofsubmissionsneedgrading'] = 'Čaka na ocenjevanje';
$string['numberofsubmittedassignments'] = 'Oddano';
$string['numberofteams'] = 'Skupine';
$string['offline'] = 'Spletna oddaja ni zahtevana';
$string['open'] = 'Odpri';
$string['outlinegrade'] = 'Ocena: {$a}';
$string['outof'] = '{$a->current} od {$a->total}';
$string['overdue'] = 'Rok za oddajo se je iztekel pred: {$a}';
$string['override'] = 'Preglasi';
$string['overridedeletegroupsure'] = 'Ali ste prepričani, da želite izbrisati preglasitev skupine {$a}?';
$string['overridedeleteusersure'] = 'Ali ste prepričani, da želite izbrisati preglasitev za uporabnika {$a}?';
$string['overridegroup'] = 'Preglasi skupino';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Preglasitve';
$string['overrideuser'] = 'Preglasi uporabnika';
$string['overrideusereventname'] = '{$a->assign} - Preglasitev';
$string['page-mod-assign-view'] = 'Glavna stran modula za naloge in prispevke';
$string['page-mod-assign-x'] = 'Vsaka stran modula nalog';
$string['paramtimeremaining'] = 'Število preostalih: {$a}';
$string['participant'] = 'Sodelujoči';
$string['pluginadministration'] = 'Skrbništvo nalog';
$string['pluginname'] = 'Naloga';
$string['preventsubmissionnotingroup'] = 'Zahteva skupino za oddajo nalog';
$string['preventsubmissionnotingroup_help'] = 'Če je to omogočeno, uporabniki, ki niso člani skupine, ne bodo mogli oddajati nalog.';
$string['preventsubmissions'] = 'Prepreči uporabniku oddajo naloge.';
$string['preventsubmissionsshort'] = 'Prepreči spreminjanje oddanih nalog';
$string['previous'] = 'Prejšnji';
$string['previoususer'] = 'Prejšnji uporabnik';
$string['privacy:attemptpath'] = 'poskus {$a}';
$string['privacy:blindmarkingidentifier'] = 'Identifikator za anonimne prispevke';
$string['privacy:gradepath'] = 'ocena';
$string['privacy:metadata:assigndownloadasfolders'] = 'Uporabniška nastavitev, s katero se različne oddaje datotek prenesejo v mape';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Podatki o pripombah k nalogi.';
$string['privacy:metadata:assignfilter'] = 'Možnosti filtriranja npr. po \'Oddano\', \'Ni oddano\', \'Čaka na ocenjevanje\' in \'Dovoljeno podaljšanje\'';
$string['privacy:metadata:assigngrades'] = 'Hrani ocene uporabnikov za nalogo';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtriraj povzetek naloge po določenem ocenjevalcu.';
$string['privacy:metadata:assignmentid'] = 'ID naloge';
$string['privacy:metadata:assignmessageexplanation'] = 'Udeležencem se sporočila pošiljajo prek sistema za sporočanje.';
$string['privacy:metadata:assignoverrides'] = 'Hrani podatke o preglasitvah za nalogo';
$string['privacy:metadata:assignperpage'] = 'Število prikazanih nalog na stran.';
$string['privacy:metadata:assignquickgrading'] = 'Nastavitev za vklop ali izklop hitrega ocenjevanja.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Hrani podatke o uporabniških prispevkih';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Podatki oddaje naloge.';
$string['privacy:metadata:assignuserflags'] = 'Hrani metapodatke uporabnikov, kot je čas podaljšanja';
$string['privacy:metadata:assignusermapping'] = 'Preslikava za anonimne prispevke';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtriraj po različnih stopnjah poteka dela.';
$string['privacy:metadata:grade'] = 'Številčna ocena za oddajo naloge. Lahko jo določijo merila/napredni obrazci za ocenjevanje ipd., vendar bo vedno pretvorjena v decimalno število.';
$string['privacy:metadata:grader'] = 'ID uporabnika, ki ocenjuje.';
$string['privacy:metadata:groupid'] = 'ID skupine, katere član je uporabnik.';
$string['privacy:metadata:latest'] = 'Olajša iskanje podatkov o zgolj zadnjem poskusu opravljanja naloge.';
$string['privacy:metadata:mailed'] = 'Ali je uporabniku že bilo poslano e-sporočilo?';
$string['privacy:metadata:timecreated'] = 'Ustvarjeno';
$string['privacy:metadata:userid'] = 'ID uporabnika';
$string['privacy:studentpath'] = 'študentove oddaje';
$string['privacy:submissionpath'] = 'prispevek';
$string['quickgrading'] = 'Hitro ocenjevanje';
$string['quickgrading_help'] = 'Hitro ocenjevanje omogoča dodelitev ocen neposredno v tabelo oddanih prispevkov (zgoraj). Hitro ocenjevanje ni združljivo z naprednim ocenjevanjem in ni priporočljivo, če ocenjuje več ocenjevalcev.';
$string['quickgradingchangessaved'] = 'Spremembe ocen so bile shranjene';
$string['quickgradingresult'] = 'Hitro ocenjevanje';
$string['recordid'] = 'Identifikator';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} po začetku predmeta';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} pred začetkom predmeta';
$string['relativedatessubmissiontimeleft'] = 'Izračunano za vsakega udeleženca';
$string['removeallgroupoverrides'] = 'Izbriši vse preglasitve skupine';
$string['removealluseroverrides'] = 'Izbriši vse preglasitve uporabnika';
$string['removesubmission'] = 'Odstrani prispevek';
$string['removesubmissionconfirm'] = 'Ali ste prepričani, da hočete odstraniti podatke prispevka?';
$string['removesubmissionconfirmforstudent'] = 'Ali ste prepričani, da hočete odstraniti podatke za udeleženca {$a}?';
$string['removesubmissionforstudent'] = 'Odstrani prispevek za udeleženca: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Možnost ponovnega odpiranja do uspešnega opravljanja ni združljiva z anonimnim oddajanjem, ker se ocene ne prikažejo v redovalnici, dokler so identitete udeležencev odkrite.';
$string['requireallteammemberssubmit'] = 'Vsi člani skupine morajo oddati';
$string['requireallteammemberssubmit_help'] = 'Če je omogočeno, mora vsak član v skupini udeležencev klikniti na gumb "Oddaj", preden je skupinska naloga oddana.
Če je onemogočeno, bo skupinska naloga oddana, ko kateri koli član skupine klikne na gumb "Oddaj".';
$string['requiresubmissionstatement'] = 'Udeleženec mora potrditi izjavo o izvirnosti svojih prispevkov';
$string['requiresubmissionstatement_help'] = 'Udeleženec mora potrditi izjavo o izvirnosti vseh prispevkov v tej nalogi.';
$string['revealidentities'] = 'Razkrij identitete udeležencev';
$string['revealidentitiesconfirm'] = 'Ali ste prepričani, da želite prikazati identiteto udeleženca za to nalogo? Tega dejanja potem ni več mogoče razveljaviti. Ko je identiteta udeleženca odkrita bodo točke prikazane v redovalnici.';
$string['reverttodefaults'] = 'Povrni na privzete nastavitve naloge';
$string['reverttodraft'] = 'Prispevek povrni v stanje osnutka.';
$string['reverttodraftforstudent'] = 'Prispevek vrni v osnutek za udeleženca: (id={a->id}, fullname={a->fullname}).';
$string['reverttodraftshort'] = 'Prispevek povrni v stanje osnutka';
$string['reviewed'] = 'Pregledano';
$string['save'] = 'Shrani';
$string['saveallquickgradingchanges'] = 'Shrani spremembe hitrega ocenjevanja';
$string['saveandcontinue'] = 'Shrani in nadaljuj';
$string['savechanges'] = 'Shrani spremembe';
$string['savegradingresult'] = 'Ocena';
$string['savenext'] = 'Shrani in prikaži naslednjo';
$string['saveoverrideandstay'] = 'Shrani in vnesi novo preglasitev';
$string['savingchanges'] = 'Shranjevanje sprememb …';
$string['scale'] = 'Lestvica';
$string['search:activity'] = 'Naloga – informacije o dejavnosti';
$string['selectedusers'] = 'Izbrani uporabniki';
$string['selectlink'] = 'Izberite ...';
$string['selectuser'] = 'Izberite {$a}';
$string['sendlatenotifications'] = 'Opozori ocenjevalce o zamujenih prispevkih';
$string['sendlatenotifications_help'] = 'Če je omogočeno, ocenjevalci (običajno učitelji) prejmejo sporočilo, ko udeleženec zamudi z oddajo naloge. Metode obveščanja je možno konfigurirati.';
$string['sendnotifications'] = 'Opozori ocenjevalce o prispevkih';
$string['sendnotifications_help'] = 'Če je omogočeno, ocenjevalci (običajno učitelji) prejmejo sporočilo, ko udeleženec oddajo naloge zamudi, jo pošlje pravočasno ali je zgoden. Metode obveščanja je možno konfigurirati.';
$string['sendstudentnotifications'] = 'Obvesti udeleženca';
$string['sendstudentnotifications_help'] = 'Odkljukaj to možnost za pošiljanje obvestila o spremembi ocene ali povratne informacije. Če naloga uporablja ocenjevalni delovni tok, ali so ocene v poročilu ocenjevalca skrite, obvestila ne bodo poslana dokler ocene ne bodo oddane.';
$string['sendstudentnotificationsdefault'] = 'Privzeto za "Obvesti udeleženca"';
$string['sendstudentnotificationsdefault_help'] = 'Ko ocenjujete posameznega študenta, naj bo možnost "Obvesti udeleženca" privzeto odkljukana?';
$string['sendsubmissionreceipts'] = 'Pošlji udeležencem potrdilo o oddaji prispevka';
$string['sendsubmissionreceipts_help'] = 'To omogoči pošiljanje obvestil o oddaji prispevka udeležencem, vsakič ko nalogo uspešno oddajo.';
$string['setmarkerallocationforlog'] = 'Nastavi dodeljeno ocenjevanje: (id={$a->id}, fullname={$a->fullname}, ocenjevalec={$a->marker}).';
$string['setmarkingallocation'] = 'Nastavi dodeljenega ocenjevalca';
$string['setmarkingworkflowstate'] = 'Nastavi stanje ocenjevalnega poteka dela';
$string['setmarkingworkflowstateforlog'] = 'Nastavi stanje ocenjevalnega poteka dela: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Nastavitve modula Naloga';
$string['showrecentsubmissions'] = 'Prikaži nedavno oddane prispevke';
$string['status'] = 'Stanje';
$string['studentnotificationworkflowstateerror'] = 'Stanje ocenjevalnega poteka dela mora biti "Objavi", da se opozori udeležence.';
$string['submission'] = 'Prispevek';
$string['submissioncopiedhtml'] = '<p>Naredili ste kopijo prejšnje
oddane naloge za \'<i>{$a->assignment}</i>\'.</p>
<p>Tu si lahko ogledate stanje svoje <a href="{$a->url}">oddane naloge</a>.</p>';
$string['submissioncopiedsmall'] = 'Kopirali ste prejšnjo oddano nalogo za {$a->assignment}';
$string['submissioncopiedtext'] = 'Naredili ste kopijo prejšnje
oddane naloge za \'{$a->assignment}\'

Tu si lahko ogledate stanje svoje oddane naloge:

 {$a->url}';
$string['submissiondrafts'] = 'Udeleženec mora klikniti gumb "Oddaj"';
$string['submissiondrafts_help'] = 'Če je omogočeno, morajo udeleženci klikniti na gumb "Oddaj" za dokončno oddajo prispevka. To jim omogoča, da obdržijo različico naloge v sistemu. Če nastavitev spremenite iz "Ne" v "Da", potem ko so nonaloge že oddali, bo oddaja veljala za dokončno.';
$string['submissioneditable'] = 'Udeleženec lahko ureja oddan prispevek';
$string['submissionempty'] = 'Nič ni bilo oddano';
$string['submissionlog'] = 'Udeleženec: {$a->fullname}, stanje: {$a->status}';
$string['submissionmodified'] = 'Imate obstoječe podatke o prispevku. Zapustite to stran in poskusite ponovno.';
$string['submissionmodifiedgroup'] = 'Prispevek je spremenil nekdo drug. Zapustite to stran in poskusite ponovno.';
$string['submissionnotcopiedinvalidstatus'] = 'Oddaje ni mogoče kopirati, saj je bila spremenjena, odkar je bila ponovno odprta.';
$string['submissionnoteditable'] = 'Udeleženec ne more urejati oddanega prispevka';
$string['submissionnotready'] = 'Ta naloga ni pripravljena na oddajo:';
$string['submissionplugins'] = 'Vtičniki za oddajo prispevkov';
$string['submissionreceipthtml'] = '<p>Oddali ste nalogo za <i>{$a->assignment}</i>.</p>
<p>Tu si lahko ogledate stanje svoje <a href="{$a->url}">oddane naloge </a>.</p>';
$string['submissionreceiptotherhtml'] = 'Vaš prispevek za \'<i>{$a->assignment}</i>\'
je bila oddana.<br /><br />
Ogledate si lahko stanje svoje <a href="{$a->url}">oddane naloge</a>.';
$string['submissionreceiptothersmall'] = 'Vaša naloga za {$a->assignment} je bila oddana.';
$string['submissionreceiptothertext'] = 'Vaš prispevek za
\'{$a->assignment}\' je bil oddan.

Tu si lahko ogledate stanje svoje oddane naloge:

 {$a->url}';
$string['submissionreceipts'] = 'Pošlji udeležencem potrdilo o prispevku';
$string['submissionreceiptsmall'] = 'Oddali ste nalogo za {$a->assignment}';
$string['submissionreceipttext'] = 'Oddali ste nalogo za
\'{$a->assignment}\'

Tu si lahko ogledate stanje svoje oddane naloge:

 {$a->url}';
$string['submissionsclosed'] = 'Oddajanje prispevkov je zaprto';
$string['submissionsettings'] = 'Nastavitve prispevkov';
$string['submissionslocked'] = 'Pri tej nalogi ne morete oddati prispevkov';
$string['submissionslockedshort'] = 'Ni dovoljeno spreminjati prispevka';
$string['submissionstatement'] = 'Izjava o oddaji prispevka';
$string['submissionstatement_help'] = 'Izjava o potrditvi oddaje prispevka';
$string['submissionstatementacceptedlog'] = 'Uporabnik {$a} je potrdil izjavo o oddaji prispevka';
$string['submissionstatementdefault'] = 'Ta prispevek je moje lastno delo, razen kjer citiram in navajam dela drugih avtorjev.';
$string['submissionstatementteamsubmission'] = 'Izjava za skupinske prispevke';
$string['submissionstatementteamsubmission_help'] = 'Izjava, ki jo mora sprejeti vsak udeleženec, da lahko odda nalogo svoje skupine.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Izjava o skupinskem prispevku, pri čemer prispevek oddajo vsi člani skupine';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Izjava, ki jo mora sprejeti vsak udeleženec, da lahko odda svojo nalogo kot član skupine.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Ta prispevek je moje delo kot del skupine, razen tam, kjer citiram dela drugih ljudi.';
$string['submissionstatementteamsubmissiondefault'] = 'Ta prispevek je delo moje skupine, razen tam, kjer citiramo dela drugih ljudi.';
$string['submissionstatus'] = 'Stanje oddaje prispevka';
$string['submissionstatus_'] = 'Ni prispevka';
$string['submissionstatus_draft'] = 'Osnutek (neoddano)';
$string['submissionstatus_marked'] = 'Ocenjeno';
$string['submissionstatus_new'] = 'Ni prispevka';
$string['submissionstatus_reopened'] = 'Ponovna oddaja omogočena';
$string['submissionstatus_submitted'] = 'Oddano v ocenjevanje';
$string['submissionstatusheading'] = 'Stanje oddaje prispevka';
$string['submissionsummary'] = '{$a->status}. Zadnja sprememba {$a->timemodified}';
$string['submissionteam'] = 'Skupina';
$string['submissiontypes'] = 'Tipi prispevkov';
$string['submitaction'] = 'Oddaj';
$string['submitassignment'] = 'Oddaj nalogo';
$string['submitassignment_help'] = 'Ko boste dokončno oddali nalogo, je ne boste mogli več popraviti.';
$string['submitforgrading'] = 'Oddaj v ocenjevanje';
$string['submitted'] = 'Oddano';
$string['submittedearly'] = 'Naloga je bila oddana {$a} prezgodaj';
$string['submittedlate'] = 'Naloga je bila oddana {$a} prepozno';
$string['submittedlateshort'] = '{$a} prepozno';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Vtičnik za pripombe';
$string['subplugintype_assignfeedback_plural'] = 'Vtičniki za pripombe';
$string['subplugintype_assignsubmission'] = 'Vtičnik za oddajo prispevkov';
$string['subplugintype_assignsubmission_plural'] = 'Vtičniki za oddajo prispevkov';
$string['teamname'] = 'Ekipa: {$a}';
$string['teamsubmission'] = 'Udeleženci oddajo v skupinah';
$string['teamsubmission_help'] = 'Če je omogočeno, bodo udeleženci razdeljeni v skupine, glede na privzete nabore skupin oz. skupke po meri. Skupinska oddaja je dostopna članom skupine, ki tudi vidijo spremembe, vnešene s strani posameznih članov skupine.';
$string['teamsubmissiongroupingid'] = 'Skupki skupin udeležencev';
$string['teamsubmissiongroupingid_help'] = 'Ta skupek bo uporabljen za skupine udeležencev, določenih v nalogi. Če ni nastavljeno, bo uporabljena privzeta skupina.';
$string['textinstructions'] = 'Navodila naloge';
$string['timemodified'] = 'Zadnja sprememba';
$string['timeremaining'] = 'Preostali čas';
$string['timeremainingcolon'] = 'Preostali čas: {$a}';
$string['togglezoom'] = 'Približaj/oddalji območje';
$string['ungroupedusers'] = 'Nastavitev \'Zahtevaj skupino za oddajanje prispevkov\' je omogočena in nekateri uporabniki bodisi niso člani nobene skupine bodisi so člani več kot ene skupine, zato ne morejo oddajati nalog.';
$string['ungroupedusersoptional'] = 'Nastavitev "Udeleženci oddajajo po skupinah" je omogočena. Če uporabnik ni član nobene skupine ali pa je član več kot ene skupine, bo oddal kot član "privzete skupine".';
$string['unlimitedattempts'] = 'Neomejeno';
$string['unlimitedattemptsallowed'] = 'Dovoljeno je neomejeno število poskusov.';
$string['unlimitedpages'] = 'Neomejeno';
$string['unlocksubmissionforstudent'] = 'Dovoli oddajo prispevka udeležencu: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Odkleni oddajo prispevkov';
$string['unsavedchanges'] = 'Neshranjene spremembe';
$string['unsavedchangesquestion'] = 'Obstajajo neshranjene spremembe ocen ali pripomb. Ali želite shraniti spremembe in nadaljevati?';
$string['updategrade'] = 'Posodobi oceno';
$string['updatetable'] = 'Shrani in posodbi tabelo';
$string['upgradenotimplemented'] = 'Nadgradnja ni vključena v vtičnik ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Privzete nastavitve naloge';
$string['userextensiondate'] = 'Rok podaljšan do: {$a}';
$string['usergrade'] = 'Ocena uporabnika';
$string['useridlistnotcached'] = 'Spremembe ocene NISO bile shranjene, saj ni bilo mogoče določiti, za kateri oddani prispevek so bile narejene.';
$string['useroverrides'] = 'Preglasitve uporabnika';
$string['useroverridesdeleted'] = 'Preglasitve uporabnika so izbrisane';
$string['usersnone'] = 'Do naloge nima dostopa noben udeleženec.';
$string['usersubmissioncannotberemoved'] = 'Oddaje prispevka za {$a} ni mogoče odstraniti.';
$string['userswhoneedtosubmit'] = 'Uporabniki, ki morajo še oddati nalogo: {$a}';
$string['validmarkingworkflowstates'] = 'Veljavna stanja ocenjevalnega potek dela';
$string['viewadifferentattempt'] = 'Poglej/oceni drug poskus';
$string['viewbatchmarkingallocation'] = 'Poglej nabor za paketno dodelitev prispevkov v ocenjevanje.';
$string['viewbatchsetmarkingworkflowstate'] = 'Poglej stran stanja ocenjevalnega poteka dela.';
$string['viewfeedback'] = 'Ogled pripomb';
$string['viewfeedbackforuser'] = 'Poglej pripombe za uporabnika: {$a}';
$string['viewfull'] = 'Poglej vse';
$string['viewfullgradingpage'] = 'Odprite celotno stran z ocenami, da dodate pripombe';
$string['viewgradebook'] = 'Poglej redovalnico';
$string['viewgrading'] = 'Ogled vseh prispevkov';
$string['viewgradingformforstudent'] = 'Poglej stran z ocenami za udeleženca: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Poglej lastno stran za oddajo naloge.';
$string['viewownsubmissionstatus'] = 'Poglej stran stanja svojih oddaj.';
$string['viewrevealidentitiesconfirm'] = 'Poglej stran za potrditev razkritja identitete udeležencev.';
$string['viewsubmission'] = 'Poglej prispevek';
$string['viewsubmissionforuser'] = 'Poglej prispevke uporabnika: {$a}';
$string['viewsubmissiongradingtable'] = 'Poglej ocenjevalno tabelo.';
$string['viewsummary'] = 'Poglej povzetek';
$string['workflowfilter'] = 'Filter poteka dela';
$string['xofy'] = '{$a->x} od {$a->y}';
