<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'pt', version '4.0'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Aceito os <a href=":url" target="_blank">termos de utilização</a>';
$string['accountdetailslinktext'] = 'aqui';
$string['action'] = 'Ação';
$string['add'] = 'Adicionar';
$string['addedandupdatedpp'] = 'Adicionadas {$a->%new} novas bibliotecas H5P e atualizadas {$a->%old} bibliotecas antigas.';
$string['addedandupdatedps'] = 'Adicionadas {$a->%new} novas bibliotecas H5P e atualizada {$a->%old} biblioteca antiga.';
$string['addedandupdatedsp'] = 'Adicionada {$a->%new} nova biblioteca H5P e atualizadas {$a->%old} bibliotecas antigas.';
$string['addedandupdatedss'] = 'Adicionada {$a->%new} nova biblioteca H5P e atualizada {$a->%old} biblioteca antiga.';
$string['addednewlibraries'] = 'Adicionadas {$a->%new} novas bibliotecas H5P.';
$string['addednewlibrary'] = 'Adicionada {$a->%new} nova biblioteca H5P.';
$string['additionalinfo'] = 'Informação adicional';
$string['additionallicenseinfo'] = 'Informações adicionais sobre a licença';
$string['addlibraries'] = 'Adicionar bibliotecas';
$string['address'] = 'Endereço';
$string['age'] = 'Idade';
$string['agedescription'] = 'O público-alvo deste conteúdo. Formatos de entrada possíveis separados por vírgulas: "1,34-45,-50,59-".';
$string['ajaxfailed'] = 'Falha ao carregar dados.';
$string['alttext'] = 'Texto alt';
$string['anunexpectedsave'] = 'Ocorreu um erro inesperado. Não foi possível guardar este conteúdo.';
$string['assistivetechnologieslabel'] = 'Etiqueta de tecnologias de apoio';
$string['attribution'] = 'Atribuição 4.0';
$string['attributionnc'] = 'Atribuição-NãoComercial 4.0';
$string['attributionncnd'] = 'Atribuição-NãoComercial-SemDerivações 4.0';
$string['attributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual 4.0';
$string['attributionnd'] = 'Atribuição-SemDerivações 4.0';
$string['attributionsa'] = 'Atribuição-CompartilhaIgual 4.0';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentários do autor';
$string['authorcommentsdescription'] = 'Comentários dirigidos ao editor do conteúdo (este texto não será publicado como parte da informação sobre direitos de autor)';
$string['authorname'] = 'Nome do autor';
$string['authorrole'] = 'Papel do autor';
$string['back'] = 'Voltar';
$string['by'] = 'por';
$string['cancel'] = 'Cancelar';
$string['cancellabel'] = 'Cancelar';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Não';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Sim';
$string['cancelpublishconfirmationdialogdescription'] = 'Tem a certeza de que pretende cancelar o processo de partilha?';
$string['cancelpublishconfirmationdialogtitle'] = 'Cancelar partilha';
$string['ccattribution'] = 'Atribuição (CC BY)';
$string['ccattributionnc'] = 'Atribuição-NãoComercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Atribuição-NãoComercial-SemDerivações (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atribuição-SemDerivações (CC BY-ND)';
$string['ccattributionsa'] = 'Atribuição-CompartilhaIgual (CC BY-SA)';
$string['ccpdd'] = 'Dedicação de Domínio Público (CC0)';
$string['ccpdm'] = 'Marca de Domínio Público (PDM)';
$string['changedby'] = 'Alterado por';
$string['changedescription'] = 'Descrição da alteração';
$string['changehasbeensubmitted'] = 'Foi submetida uma alteração para';
$string['changelog'] = 'Relatório de alterações';
$string['changeplaceholder'] = 'Foto recortada, texto modificado, etc.';
$string['city'] = 'Cidade';
$string['close'] = 'Fechar';
$string['completionpass'] = 'Requerer nota de aprovação';
$string['completionpass_help'] = 'Se ativar esta opção, esta atividade é considerada concluída quando o aluno obtiver a nota de aprovação (conforme especificado na secção Avaliação das configurações de atividade do H5P) ou superior.';
$string['completionpassdesc'] = 'O aluno deve obter a nota de aprovação para concluir esta atividade';
$string['confirmdialogbody'] = 'Por favor, confirme que pretende prosseguir. Esta ação é irreversível.';
$string['confirmdialogheader'] = 'Confirmar ação';
$string['confirmlabel'] = 'Confirmar';
$string['connectionlost'] = 'Ligação perdida. Os resultados serão armazenados e enviados quando a ligação for restabelecida.';
$string['connectionreestablished'] = 'Ligação restabelecida.';
$string['contactperson'] = 'Contacto';
$string['contactpersondescription'] = 'O H5P entrará em contacto com a pessoa responsável caso haja algum problema com o conteúdo partilhado pelo editor. O nome da pessoa de contacto ou outras informações não serão publicadas ou partilhadas com terceiros';
$string['contentavailable'] = 'Normalmente, o seu conteúdo estará disponível no Hub dentro de um dia útil.';
$string['contentchanged'] = 'Este conteúdo foi alterado desde que o usou pela última vez.';
$string['contentcopied'] = 'O conteúdo foi copiado para a área de transferência';
$string['contenthub:changesettings'] = 'Altere as configurações da conta <a href="{$a}">aqui</a>';
$string['contenthub:licenseagreementdescription'] = 'Leia as condições do acordo antes de prosseguir com o';
$string['contenthub:licenseagreementmaintext'] = 'AFAZER';
$string['contenthub:licenseagreementtitle'] = 'Contrato de licença de utilizador final (EULA)';
$string['contenthub:nopermissions'] = 'Não tem permissão para registar o site no Hub de conteúdos.';
$string['contenthub:register'] = 'Registe uma conta no <a href="{$a}">Hub H5P</a>';
$string['contenthub:settings:box'] = 'Conta do Hub de conteúdos';
$string['contenthub:settings:heading'] = 'Configurações da conta no Hub H5P';
$string['contenthubeditsharing'] = 'Editar informações da partilha';
$string['contenthuboptions'] = 'Opções do Hub H5P OER';
$string['contenthubshare'] = 'Partilhar no Hub H5P';
$string['contenthubsharinginprogress'] = 'A partilhar...';
$string['contenthubsyncchanges'] = 'Sincronizar alterações';
$string['contenthubunshare'] = 'Cancelar partilha';
$string['contentissyncing'] = 'O conteúdo está a ser sincronizado.';
$string['contentlicensetitle'] = 'Informações da licença do conteúdo';
$string['contentnotshared'] = 'O conteúdo não está partilhado no Hub.';
$string['contentstatefrequency'] = 'Guardar frequência do estado do conteúdo';
$string['contentstatefrequency_help'] = 'Intervalo de tempo em segundos que pretende que seja guardado automaticamente o progresso do utilizador. Aumente este número se tiver problemas com muitas solicitações AJAX';
$string['contenttype'] = 'Tipo de conteúdo';
$string['contenttypecacheheader'] = 'Cache do tipo de conteúdo';
$string['contentupdatesoon'] = 'O seu conteúdo será atualizado em breve';
$string['copyright'] = 'Direitos de autor';
$string['copyrightinfo'] = 'Informações sobre direitos de autor';
$string['copyrightstring'] = 'Direitos de autor';
$string['copyrighttitle'] = 'Visualizar informações sobre os direitos de autor referentes a este conteúdo.';
$string['copyrightwarning'] = 'Material protegido por direitos de autor não pode ser partilhado no Hub de conteúdo H5P. Se o conteúdo for licenciado com uma licença amigável OER (Open Educational Resources), como por exemplo, Creative Commons, escolha a licença apropriada. Caso contrário, este conteúdo não pode ser partilhado.';
$string['couldnotcopy'] = 'Não foi possível copiar o ficheiro.';
$string['couldnotparsejsonfromzip'] = 'Não foi possível analisar o JSON do pacote: %fileName';
$string['couldnotparsepostdata'] = 'Não foi possível analisar os dados da publicação.';
$string['couldnotreadfilefromzip'] = 'Não foi possível ler o ficheiro do pacote: %fileName';
$string['couldnotsave'] = 'Não foi possível guardar o ficheiro.';
$string['country'] = 'País';
$string['create'] = 'Criar';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Atualizar a cache do tipo de conteúdo';
$string['ctcacheconnectionfailed'] = 'Não foi possível comunicar com o Hub H5P. Por favor, tente novamente mais tarde.';
$string['ctcachedescription'] = 'Ao assegurar que a cache do tipo de conteúdo está atualizada permite que possa visualizar, descarregar e usar as bibliotecas mais recentes. Isto é diferente da atualização das próprias bibliotecas.';
$string['ctcachelastupdatelabel'] = 'Última atualização';
$string['ctcacheneverupdated'] = 'Nunca';
$string['ctcachenolibraries'] = 'Não foi recebido qualquer conteúdo do Hub H5P. Por favor, tente novamente mais tarde.';
$string['ctcachesuccess'] = 'A cache das bibliotecas foi atualizada com sucesso.';
$string['ctcachetaskname'] = 'Cache do tipo de conteúdo atualizada';
$string['currentpage'] = 'Página $current de $total';
$string['currentstep'] = 'Passo :step de :total';
$string['dataviewreportlabel'] = 'Visualizar as respostas';
$string['date'] = 'Data';
$string['description'] = 'Descrição';
$string['disablefileextensioncheck'] = 'Desativar a verificação da extensão dos ficheiros';
$string['disablefileextensioncheckwarning'] = 'Atenção! Desativar a verificação da extensão dos ficheiros pode ter implicações na segurança, uma vez que permite o carregamento de ficheiros PHP que, por sua vez, podem possibilitar a execução de código malicioso no seu site. Para sua segurança, verifique que sabe exatamente o que está a carregar.';
$string['disablefullscreen'] = 'Desativar o modo ecrã inteiro';
$string['disablehubconfirmationmsg'] = 'Ainda pretende ativar o Hub?';
$string['disablehubdescription'] = 'É fortemente sugerido manter esta opção ativada. O Hub H5P fornece uma interface fácil para obter novos tipos de conteúdo e manter os tipos de conteúdo existentes atualizados. No futuro, também facilitará a partilha e a reutilização dos conteúdos. Se esta opção estiver desativada, terá que instalar e atualizar os tipos de conteúdo através da página de carregamento dos ficheiros.';
$string['disciplinedescription'] = 'Pode selecionar várias disciplinas';
$string['disciplinelabel'] = 'Disciplinas';
$string['disciplinelimitreachedmessage'] = 'Pode selecionar até :numDisciplines disciplinas';
$string['disciplines'] = 'Disciplinas';
$string['displayoptionalwaysshow'] = 'Mostrar sempre';
$string['displayoptionauthoroff'] = 'Controlado pelo autor, não por predefinição';
$string['displayoptionauthoron'] = 'Controlado pelo autor, sim por predefinição';
$string['displayoptiondownloadalways'] = 'Sempre';
$string['displayoptiondownloadnever'] = 'Nunca';
$string['displayoptiondownloadpermission'] = 'Apenas para utilizadores com permissão para exportar H5P';
$string['displayoptionnevershow'] = 'Nunca mostrar';
$string['displayoptionpermissions'] = 'Mostrar apenas se o utilizar tiver permissões para exportar H5P';
$string['displayoptionpermissionsembed'] = 'Apenas para utilizadores com permissão para incorporar H5P';
$string['displayoptions'] = 'Mostrar opções';
$string['download'] = 'Descarregar';
$string['downloadfailed'] = 'Ocorreu um erro ao descarregar a biblioteca requerida.';
$string['downloadtitle'] = 'Descarregar este conteúdo como ficheiro H5P';
$string['dropdownbutton'] = 'Botão de contexto';
$string['editinfotitle'] = 'Editar informações de <strong>:title</strong>';
$string['editingfailed'] = 'Ocorreu um erro na edição.';
$string['editor'] = 'Editor';
$string['emailaddress'] = 'E-mail';
$string['emailaddressdescription'] = 'O endereço de e-mail será usado pelo H5P para entrar em contacto com o editor em caso de problemas com o conteúdo ou no caso do editor precisar recuperar a sua conta. Não será publicado ou partilhado com terceiros';
$string['emailconfirmbody'] = 'Olá {$a->username},

Obrigado por submeter as suas respostas em \'{$a->hvpname}\' na disciplina \'{$a->coursename}\'.

Esta mensagem confirma que as suas respostas foram guardadas.

Pode aceder a este H5P na página {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Obrigado por submeter as suas respostas no \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Confirmação da submissão: {$a->hvpname}';
$string['emailnotifybody'] = 'Olá {$a->username},

{$a->studentname} completou \'{$a->hvpname}\' ({$a->hvpurl}) na disciplina \'{$a->coursename}\'.

Pode rever esta tentativa na página {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} completou {$a->hvpname}. Consulte a página {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} completou {$a->hvpname}';
$string['embed'] = 'Incorporar';
$string['embedloginfailed'] = 'Não tem acesso a este conteúdo. Tente autenticar-se.';
$string['embedtitle'] = 'Visualizar o código para incorporar este conteúdo.';
$string['empty'] = 'Não existem resultados disponíveis';
$string['enableabout'] = 'Botão Sobre H5P';
$string['enablecopyright'] = 'Botão Direitos de autor';
$string['enabledlrscontenttypes'] = 'Ativar tipos de conteúdo dependentes de LRS';
$string['enabledlrscontenttypes_help'] = 'Permite utilizar tipos de conteúdo que dependem do funcionamento correto de Learning Record Store, como seja o tipo de conteúdo Questionnaire.';
$string['enabledownload'] = 'Permitir descarregar';
$string['enableembed'] = 'Botão Incorporar';
$string['enableframe'] = 'Exibir barra de ações';
$string['enablehublabel'] = 'Usar o Hub H5P';
$string['enablejavascript'] = 'Por favor, ative o JavaScript.';
$string['enablesavecontentstate'] = 'Guardar o estado do conteúdo';
$string['enablesavecontentstate_help'] = 'Guardar automaticamente o estado atual do conteúdo interativo para cada utilizador. Isto significa que o utilizador pode continuar de onde tinha parado anteriormente.';
$string['failedtodownloadh5p'] = 'Ocorreu um erro ao descarregar o H5P requerido.';
$string['fileexceedsmaxsize'] = 'Um dos ficheiros incluídos no pacote excede o tamanho máximo permitido. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Ficheiro não foi encontrado no servidor. Confira as configurações de carregamento de ficheiros.';
$string['filenotimage'] = 'O ficheiro não é uma imagem';
$string['filetypenotallowed'] = 'Tipo de ficheiro não permitido.';
$string['finished'] = 'Terminado';
$string['fullscreen'] = 'Ecrã inteiro';
$string['gpl'] = 'Licença Pública Geral v3';
$string['gradeheading'] = 'Resultados de {$a}';
$string['gradetopassmustbeset'] = 'A nota de aprovação não pode ser zero, uma vez que nesta atividade H5P está definido, nos critérios de conclusão, exigir nota de aprovação. Defina um valor diferente de zero.';
$string['gradetopassnotset'] = 'Esta atividade H5P ainda não tem definida a nota de aprovação. Pode ser definida na secção Avaliação das configurações da atividade H5P.';
$string['h5pfile'] = 'Ficheiro H5P';
$string['h5ptitle'] = 'Aceda a H5P.org para conhecer mais conteúdos.';
$string['helpchoosinglicense'] = 'Ajude-me a escolher uma licença';
$string['hide'] = 'Ocultar';
$string['hideadvanced'] = 'Ocultar avançado';
$string['hubcommunicationdisabled'] = 'A comunicação com o Hub H5P foi desativada porque falhou um ou mais requisitos do H5P.';
$string['hubisdisabled'] = 'O Hub está desativado. Pode reativá-lo nas configurações do H5P.';
$string['hubisdisableduploadlibraries'] = 'O Hub H5P estará desativado até que este problema seja resolvido. Pode continuar a carregar bibliotecas através da página "Bibliotecas H5P".';
$string['hubsettingsheader'] = 'Tipos de conteúdo';
$string['hvp:addinstance'] = 'Criar novas atividades H5P';
$string['hvp:contenthubregistration'] = 'Registar o site no Hub de conteúdo H5P';
$string['hvp:emailconfirmsubmission'] = 'Receber uma mensagem de confirmação ao submeter';
$string['hvp:emailnotifysubmission'] = 'Receber uma mensagem de notificação quando uma tentativa é submetida';
$string['hvp:getcachedassets'] = 'Necessário para visualizar atividades H5P';
$string['hvp:getembedcode'] = 'Visualizar código incorporado de H5P quando a opção \'Controlado por permissão\' estiver definida';
$string['hvp:getexport'] = 'Descarregar ficheiro .h5p quando a opção \'Controlado por permissão\' estiver definida';
$string['hvp:installrecommendedh5plibraries'] = 'Instalar novos tipos de conteúdo H5P seguros que são recomendados pelo site H5P.org';
$string['hvp:manage'] = 'Editar atividades H5P existentes';
$string['hvp:restrictlibraries'] = 'Restringir o acesso a certos tipos de conteúdo H5P';
$string['hvp:savecontentuserdata'] = 'Guardar o progresso dos utilizadores nas atividades do H5P';
$string['hvp:saveresults'] = 'Guardar os resultados das atividades H5P concluídas';
$string['hvp:share'] = 'Partilhar conteúdo no Hub H5P OER (Open Educational Resource)';
$string['hvp:updatelibraries'] = 'Instalar novos tipos de conteúdo H5P ou atualizar os já existentes';
$string['hvp:userestrictedlibraries'] = 'Usar tipos restritos de conteúdos H5P';
$string['hvp:view'] = 'Visualizar e interagir com as atividades H5P';
$string['hvp:viewallresults'] = 'Visualizar todos os resultados das atividades H5P concluídas';
$string['hvp:viewresults'] = 'Visualizar os próprios resultados das atividades H5P concluídas';
$string['icon'] = 'Ícone';
$string['icondescription'] = '640 x 480 píxeis. Se não for selecionado, o conteúdo usará o ícone da categoria';
$string['in'] = 'em';
$string['installdenied'] = 'Não tem permissão para instalar tipos de conteúdos. Contacte o administrador do site.';
$string['installedlibraries'] = 'Bibliotecas instaladas';
$string['intro'] = 'Introdução';
$string['invalidage'] = 'Formato de entrada inválido para público-alvo. Formatos de entrada possíveis separados por vírgulas: "1,34-45,-50,-59-".';
$string['invalidaudioformat'] = 'Formato de ficheiro áudio inválido. Use \'mp3\' ou \'wav\'.';
$string['invalidcontentfolder'] = 'Pasta de conteúdo inválida';
$string['invalidcontenttype'] = 'O tipo de conteúdo selecionado não é válido.';
$string['invalidfieldtype'] = 'Tipo de campo inválido.';
$string['invalidfile'] = 'O ficheiro "{$a->%filename}" não é permitido. Apenas ficheiros com as seguintes extensões são permitidos: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Não foi possível obter o H5P disponibilizado.';
$string['invalidhvp'] = 'Atividade H5P inválida';
$string['invalidimageformat'] = 'Formato de ficheiro de imagem inválido. Use \'jpg\', \'png\' ou \'gif\'.';
$string['invalidlanguagefile'] = 'Ficheiro de idioma inválido {$a->%file} na biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'O ficheiro de idioma inválido {$a->%languageFile} foi incluído na biblioteca {$a->%name}';
$string['invalidlibrary'] = 'Biblioteca inválida';
$string['invalidlibrarydata'] = 'Dados inválidos para {$a->%property} na biblioteca {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Dados inválidos para {$a->%property} na biblioteca {$a->%library}. Esperado valor booleano.';
$string['invalidlibraryname'] = 'Nome da biblioteca inválido: {$a->%name}';
$string['invalidlibrarynamed'] = 'A livraria H5P {$a->%library} usada neste conteúdo não é válida';
$string['invalidlibraryoption'] = 'Opção inválida {$a->%option} na biblioteca {$a->%library}';
$string['invalidlibraryproperty'] = 'Não é possível ler a propriedade {$a->%property} na biblioteca {$a->%library}';
$string['invalidmainjson'] = 'Não foi encontrado um ficheiro h5p.json válido';
$string['invalidmultiselectoption'] = 'Opção inválida selecionada na seleção múltipla.';
$string['invalidparameters'] = 'Parâmetros inválidos';
$string['invalidselectoption'] = 'Opção inválida selecionada na seleção.';
$string['invalidsemanticsjson'] = 'Um ficheiro \'semantics.json\' inválido foi incluído na biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'Erro interno do H5P: tipo de conteúdo desconhecido "{$a->@type}" na semântica. Conteúdo está ser removiso!';
$string['invalidstring'] = 'A cadeia de caracteres (string) fornecida não está de acordo com a semântica solicitada pela expressão regular. (value: \\"{$a->%value}\\", expressão regular: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'H5P recebeu um token inválido. Atualize a página e tente de novo.';
$string['invalidvideoformat'] = 'Ficheiro com formato de vídeo inválido. Use \'mp4\' ou \'webm\'.';
$string['invalidxapiresult'] = 'Não foram encontrados resultados xAPI para a combinação do conteúdo e o ID do utilizador';
$string['isnowsubmitted'] = 'Foi submetido para o Hub H5P';
$string['javascriptloading'] = 'A esperar pelo JavaScript...';
$string['keywordexists'] = 'Palavra-chave já existente!';
$string['keywords'] = 'Palavras-chave';
$string['keywordsdescription'] = 'Pode adicionar várias palavras-chave separadas por vírgulas. "Enter" ou "Adicionar" para confirmar as palavras-chave';
$string['keywordsexists'] = 'Palavras-chave já existentes!';
$string['keywordsplaceholder'] = 'Adicionar palavras-chave';
$string['language'] = 'Idioma';
$string['level'] = 'Nível';
$string['libraries'] = 'Bibliotecas H5P';
$string['librarydirectoryerror'] = 'O nome da diretoria das bibliotecas deve corresponder a \'machineName\' ou \'machineName-majorVersion.minorVersion\' (da library.json). (Diretoria: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Ações';
$string['librarylistinstancedependencies'] = 'Dependências da instância';
$string['librarylistinstances'] = 'Instâncias';
$string['librarylistlibrarydependencies'] = 'Dependências da biblioteca';
$string['librarylistrestricted'] = 'Restrito';
$string['librarylisttitle'] = 'Título';
$string['librarynotselected'] = 'Tem de selecionar um tipo de conteúdo.';
$string['license'] = 'Licença';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Dedicação ao Domínio Público';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = 'Atribuição 1.0 Genérica';
$string['licenseCC20'] = 'Atribuição 2.0 Genérica';
$string['licenseCC25'] = 'Atribuição 2.5 Genérica';
$string['licenseCC30'] = 'Atribuição 3.0 Não Adaptada';
$string['licenseCC40'] = 'Atribuição 4.0 Internacional';
$string['licenseGPL'] = 'Licença Pública Geral';
$string['licenseV1'] = 'Versão 1';
$string['licenseV2'] = 'Versão 2';
$string['licenseV3'] = 'Versão 3';
$string['licensedescription'] = 'Selecione uma licença para o seu conteúdo';
$string['licensedetails'] = 'Detalhes da licença';
$string['licensedialogdescription'] = 'Clique numa licença específica para obter informações sobre o uso adequado';
$string['licensee'] = 'Licenciados';
$string['licenseextras'] = 'Licença suplementar';
$string['licenseversion'] = 'Versão da licença';
$string['licenseversiondescription'] = 'Selecione a versão da licença';
$string['loadingdata'] = 'A carregar dados...';
$string['logouploadtext'] = 'Logótipo ou Avatar da organização';
$string['longdescription'] = 'Descrição alargada';
$string['longdescriptionplaceholder'] = 'Descrição alargada do seu conteúdo';
$string['lookforupdates'] = 'Pesquisar atualizações do H5P';
$string['maintitle'] = 'Partilhar <strong>:title</strong>';
$string['maximumgrade'] = 'Nota máxima';
$string['maximumgradeerror'] = 'Digite um inteiro positivo válido como pontos máximos disponíveis para esta atividade';
$string['maxlength'] = 'O número máximo de caracteres: :length';
$string['maxpostsizetoosmall'] = 'O tamanho máximo de publicação do PHP é bastante pequeno. A configuração atual não permite carregar ficheiros maiores do que {$a->%number} MB. Pode vir a ser um problema se tentar carregar ficheiros H5P, imagens e vídeos. Considere aumentá-lo para um valor superior a 5 MB.';
$string['maxscore'] = 'Pontuação máxima';
$string['maxuploadsizetoosmall'] = 'O tamanho máximo de carregamento do PHP é bastante pequeno. A configuração atual não permite carregar ficheiros maiores do que {$a->%number} MB. Pode vir a ser um problema se tentar carregar ficheiros H5P, imagens e vídeos. Considere aumentá-lo para um valor superior a 5 MB.';
$string['messageprovider:confirmation'] = 'Confirmação das suas submissões H5P';
$string['messageprovider:submission'] = 'Notificação de submissões H5P';
$string['missingcontentfolder'] = 'Não foi encontrado uma pasta com conteúdo válido';
$string['missingcontentuserdata'] = 'Erro: Não foi possível encontrar os dados do conteúdo do utilizador';
$string['missingcoreversion'] = 'O sistema não conseguiu instalar o componente "<em>{$a->%component}</em>" do pacote. É requerida uma versão mais atual do módulo H5P. Neste site está atualmente instalada a versão {$a->%current} e é requerida a versão {$a->%required} ou superior. Considere fazer a atualização e tentar novamente.';
$string['missingdependency'] = 'Dependência {$a->@dep} em falta e requerida por {$a->@lib}.';
$string['missinglibrary'] = 'Falta a biblioteca requerida {$a->@library}';
$string['missinglibraryfile'] = 'O ficheiro "{$a->%file}" está em falta na biblioteca: "{$a->%name}"';
$string['missinglibraryjson'] = 'Não foi possível encontrar o ficheiro library.json com formato JSON válido para a biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'A propriedade {$a->%property} necessária não foi encontrada em {$a->%library}';
$string['missingmbstring'] = 'A extensão mbstring do PHP não está carregada. Esta extensão é necessária para um correto funcionamento do H5P';
$string['missingparameters'] = 'Parâmetros em falta';
$string['missinguploadpermissions'] = 'Tenha em atenção que as bibliotecas podem existir no ficheiro enviado, mas não tem permissão para efetuar o carregamento de novas bibliotecas. Entre em contacto com o administrador do site.';
$string['modulename'] = 'Conteúdo interativo';
$string['modulename_help'] = 'O módulo de atividade H5P permite criar conteúdos interativos, tais como, vídeos interativos, conjuntos de perguntas, perguntas de arrastar e largar, perguntas de escolha múltipla, apresentações e muito mais.

Além de ser uma ferramenta de criação de conteúdos enriquecidos, o H5P permite importar e exportar ficheiros H5P, permitindo assim uma reutilização efetiva e partilha de conteúdos.

As interações e avaliações do utilizador são rastreadas usando o xAPI e estão disponíveis na pauta da respetiva disciplina.
Tenha em atenção que atualmente, é possível que utilizadores com conhecimentos de programação possam interferir nas interações do H5P e obter a pontuação máxima sem saberem as respostas corretas. Os conteúdos H5Ps não devem ser usados para exames ou similares.

Pode adicionar conteúdo interativo usando a ferramenta de autoria incorporada ou carregando ficheiros H5P de outros sites com H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Conteúdo Interativo';
$string['next'] = 'Seguinte';
$string['nextpage'] = 'Página seguinte';
$string['noanswersubmitted'] = 'Este utilizador ainda não enviou uma resposta para este H5P';
$string['nocontent'] = 'Não foi possível encontrar ou analisar o ficheiro content.json';
$string['nocontenttype'] = 'Não foi especificado o tipo de conteúdo.';
$string['nocopyright'] = 'Não existe informação sobre os direitos de autor deste conteúdo.';
$string['nodata'] = 'Não existem dados disponíveis que correspondam aos seus critérios.';
$string['noexport'] = 'Ficheiro de exportação em falta';
$string['noextension'] = 'O ficheiro enviado não é um pacote HTML5 válido (não tem a extensão .h5p)';
$string['noh5ps'] = 'Não existe conteúdo interativo H5P disponível para esta disciplina.';
$string['nohubregistration'] = 'Não está registado no Hub H5P';
$string['nojson'] = 'O ficheiro principal h5p.json não é válido';
$string['nombstringexteension'] = 'A extensão mbstring do PHP não está carregada. Esta extensão é necessária para um correto funcionamento do H5P';
$string['noparameters'] = 'Sem parâmetros';
$string['noparse'] = 'Não foi possível analisar o ficheiro principal h5p.json';
$string['nopermissiontogettranslations'] = 'Não tem permissões para obter traduções';
$string['nopermissiontorestrict'] = 'Não tem permissão para restringir bibliotecas.';
$string['nopermissiontosavecontentuserdata'] = 'Não tem permissão para guardar os dados do conteúdo do utilizador.';
$string['nopermissiontosaveresult'] = 'Não tem permissão para guardar resultados deste conteúdo.';
$string['nopermissiontoupgrade'] = 'Não tem permissão para atualizar as bibliotecas.';
$string['nopermissiontouploadcontent'] = 'Não tem permissão para carregar conteúdo aqui.';
$string['nopermissiontouploadfiles'] = 'Não tem permissão para carregar ficheiros aqui.';
$string['nopermissiontoviewcontenthubcache'] = 'Não tem permissão para visualizar os metadados do conteúdo do Hub.';
$string['nopermissiontoviewcontenttypes'] = 'Não tem permissão para ver os tipos de conteúdo.';
$string['nopermissiontoviewresult'] = 'Não tem permissão para ver os resultados deste conteúdo.';
$string['nosuchlibrary'] = 'Biblioteca inexistente';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'O ficheiro enviado não é um pacote HTML5 válido (não é possível descompactar)';
$string['noversionattribution'] = 'Atribuição';
$string['noversionattributionnc'] = 'Atribuição-NãoComercial';
$string['noversionattributionncnd'] = 'Atribuição-NãoComercial-SemDerivações';
$string['noversionattributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual';
$string['noversionattributionnd'] = 'Atribuição-SemDerivações';
$string['noversionattributionsa'] = 'Atribuição-CompartilhaIgual';
$string['nowriteaccess'] = 'Ocorreu um erro de escrita no servidor. Certifique-se de que a pasta de dados no seu servidor não é só de leitura.';
$string['noziparchive'] = 'A sua versão do PHP não suporta ZipArchive.';
$string['offlinedialogbody'] = 'Não foi possível enviar informações sobre a conclusão desta tarefa. Por favor, verifique a sua ligação à Internet.';
$string['offlinedialogheader'] = 'A sua ligação com o servidor foi perdida';
$string['offlinedialogretrybuttonlabel'] = 'Voltar a tentar agora';
$string['offlinedialogretrymessage'] = 'Voltar a tentar dentro de :num...';
$string['offlinesuccessfulsubmit'] = 'Resultados enviados com sucesso.';
$string['oldphpversion'] = 'A sua versão do PHP está desatualizada. O H5P requer a versão 5.2 para funcionar corretamente. Recomenda-se a versão 5.6 ou posterior.';
$string['olduploadoldcontent'] = 'Está a tentar enviar conteúdo de uma versão antiga do H5P. Atualize o conteúdo no servidor de origem e tente enviar novamente ou ative o Hub H5P para que o servidor atualize automaticamente.';
$string['onlyupdate'] = 'Atualizar apenas as bibliotecas existentes';
$string['optionalinfo'] = 'Info opcional';
$string['options'] = 'Opções';
$string['originator'] = 'Criador';
$string['pd'] = 'Domínio Público';
$string['pddl'] = 'Dedicação ao Domínio Público e Licença';
$string['pdm'] = 'Marca de Domínio Público';
$string['phone'] = 'Telefone';
$string['pleasewait'] = 'Por favor, aguarde...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'É necessária uma mensagem de publicação para aceder ao ponto final fornecido';
$string['previouspage'] = 'Página anterior';
$string['privacy:metadata:core_files'] = 'A atividade do H5P armazena ficheiros que foram carregados como parte do conteúdo do H5P.';
$string['privacy:metadata:core_grades'] = 'A atividade do H5P armazena notas de utilizadores que responderam ao conteúdo do H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Descreve o estado atual do conteúdo para o utilizador. Usado para restaurar o conteúdo para um estado anterior.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Dados do utilizador que foram armazenados.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identificador de tipo de dados.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Sinalizador que determina se os dados devem ser apagados quando o conteúdo for alterado.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID do conteúdo H5P ao qual os dados pertencem.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID da relação de dados do utilizador com o conteúdo.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Sinalizador que determina se os dados devem ser pré-carregados no conteúdo.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Subconteúdo do H5P, 0 se não for subconteúdo.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID do utilizador ao qual os dados pertencem.';
$string['privacy:metadata:hvp_events'] = 'Mantém o controlo do registo de eventos H5P.';
$string['privacy:metadata:hvp_events:content_id'] = 'ID do conteúdo em que a ação foi executada. 0 se novo ou nenhum conteúdo.';
$string['privacy:metadata:hvp_events:content_title'] = 'Título do conteúdo';
$string['privacy:metadata:hvp_events:created_at'] = 'Data/hora em que o evento foi criado.';
$string['privacy:metadata:hvp_events:id'] = 'ID exclusivo do evento.';
$string['privacy:metadata:hvp_events:library_name'] = 'A biblioteca do evento afetado.';
$string['privacy:metadata:hvp_events:library_version'] = 'A versão da biblioteca do evento afetado.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Subtipo do evento ou ação do evento.';
$string['privacy:metadata:hvp_events:type'] = 'O tipo de evento.';
$string['privacy:metadata:hvp_events:user_id'] = 'ID do utilizador que executou a ação.';
$string['privacy:metadata:hvp_xapi_results'] = 'Armazena eventos xAPI no conteúdo H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Informações adicionais que o H5P pode enviar.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID do conteúdo em que o evento foi realizado.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'O padrão de resposta correta.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'A descrição, tarefa ou pergunta do conteúdo em que a ação foi executada.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'ID exclusivo do evento xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Tipo de interação';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Pontuação máxima possível para o evento.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'O ID do ascendente do conteúdo em que este evento foi realizado. Nulo se não tiver ascendente.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Pontuação obtida no evento.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Resposta enviada pelo utilizador.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID do utilizador que executou a ação.';
$string['publisherdescription'] = 'Descrição do editor';
$string['publisherdescriptiontext'] = 'Será exibido em "Informações do editor" no conteúdo partilhado';
$string['publisherfielddescription'] = 'Será exibido como o "nome do editor" no conteúdo partilhado';
$string['publisherfieldtitle'] = 'Editor';
$string['question'] = 'Pergunta';
$string['registeronhub'] = 'Registar no Hub H5P';
$string['registrationfailed'] = 'Ocorreu um erro';
$string['registrationfaileddescription'] = 'De momento, não foi possível criar uma conta. Tente mais tarde.';
$string['registrationtitle'] = 'Registo no Hub H5P';
$string['remove'] = 'Remover';
$string['removechip'] = 'Remover :chip da lista';
$string['removeimage'] = 'Remover imagem';
$string['removeoldlogentries'] = 'Remover as entradas de registos (log) antigas do H5P';
$string['removeoldmobileauthentries'] = 'Remover entradas antigas de autenticação H5P em dispositivos móveis';
$string['removetmpfiles'] = 'Remover ficheiros temporários H5P antigos';
$string['reportingquestionsremaininglabel'] = 'perguntas por avaliar';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Nota na pauta:';
$string['reportingscoredelimiter'] = 'de';
$string['reportingscorelabel'] = 'Pontuação:';
$string['reportnotsupported'] = 'Não é suportado';
$string['reportsubmitgradelabel'] = 'Submeter nota';
$string['requiredinfo'] = 'Informação obrigatória';
$string['resizescript'] = 'Incluir este script no seu site se pretender um dimensionamento dinâmico do conteúdo incorporado:';
$string['resubmitscores'] = 'Tentativa de envio dos resultados armazenados.';
$string['reuse'] = 'Reutilizar';
$string['reusecontent'] = 'Reutilizar conteúdo';
$string['reusedescription'] = 'Reutilizar este conteúdo.';
$string['reveal'] = 'Revelar';
$string['reviewandsave'] = 'Rever & Guardar';
$string['reviewandshare'] = 'Rever & Partilhar';
$string['reviewinfo'] = 'Rever informação';
$string['reviewmessage'] = 'Reveja as informações abaixo antes de partilhar';
$string['reviseserversetupandretry'] = 'Quando aceder às configuração do seu servidor, pode reativar a comunicação do Hub H5P nas configurações do H5P.';
$string['savechanges'] = 'Guardar alterações';
$string['score'] = 'Pontuação';
$string['screenshots'] = 'Capturas de ecrã';
$string['screenshotsdescription'] = 'Adicione até cinco capturas de ecrã do seu conteúdo';
$string['search'] = 'Pesquisar';
$string['searchplaceholder'] = 'Digite para pesquisar disciplinas';
$string['sendusagestatistics'] = 'Estatísticas da utilização';
$string['sendusagestatistics_help'] = 'Os dados estatísticos da utilização serão automaticamente enviados para ajudar os programadores a entender melhor como o H5P é usado e a determinar áreas potenciais para melhorias. Para mais informações, verifique quais os <a {$a}>dados que são guardados</a> em h5p.org.';
$string['settings'] = 'Configurações H5P';
$string['share'] = 'Partilhar';
$string['shared'] = 'Partilhado';
$string['sharefailed'] = 'Ocorreu um erro ao partilhar.';
$string['sharetryagain'] = 'Ocorreu um erro. Tente partilhar novamente.';
$string['sharingnote'] = 'Todos os detalhes do conteúdo podem ser editados após a partilha';
$string['shortdescription'] = 'Descrição curta';
$string['shortdescriptionplaceholder'] = 'Pequena descrição do seu conteúdo';
$string['showadvanced'] = 'Mostrar avançado';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar mais';
$string['sitecouldnotberegistered'] = 'Não foi possível registar o site no Hub. Por favor, contacte o administrador do site.';
$string['sitekey'] = 'Chave do site';
$string['sitekeydescription'] = 'A chave secreta do site identifica de modo exclusivo este site no Hub.';
$string['sitekeyregistered'] = 'Recebeu uma chave exclusiva que o identifica com o Hub quando recebe novas atualizações. A chave está disponível para visualização na página "Configurações H5P".';
$string['size'] = 'Tamanho';
$string['somekeywordsexists'] = 'Algumas destas palavras-chave já existem';
$string['source'] = 'Fonte';
$string['sslnotenabled'] = 'O seu servidor não tem o SSL ativado. O SSL deve ser ativado para garantir uma ligação segura com o Hub H5P.';
$string['startingover'] = 'Recomeçar.';
$string['subcontentwarning'] = 'Os sub-conteúdos (imagens, perguntas, etc.) serão partilhados sob :license, a menos que especificado de outra forma na ferramenta de autor';
$string['sublevel'] = 'Subnível';
$string['submitted'] = 'Submitido!';
$string['successfullyregisteredwithhub'] = 'O seu site foi registado com sucesso no Hub H5P.';
$string['successfullyregistred'] = 'Registo com sucesso da sua conta no Hub H5P';
$string['successfullyregistreddescription'] = 'Os detalhes da sua conta podem ser alterados';
$string['successfullyupdated'] = 'As configurações da sua conta no Hub H5Pforam alteradas com sucesso';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['unabletocreatedir'] = 'Não é possível criar a diretoria.';
$string['unabletogetfieldtype'] = 'Não é possível obter o tipo de campo.';
$string['undisclosed'] = 'Desconhecido';
$string['unpackedfilesexceedsmaxsize'] = 'O tamanho total dos ficheiros descompactados excede o tamanho máximo permitido. (%used > %max)';
$string['updatedlibraries'] = 'Foram atualizadas {$a->%old} bibliotecas H5P.';
$string['updatedlibrary'] = 'Foi atualizada {$a->%old} biblioteca H5P.';
$string['updatelibraries'] = 'Atualizar todas as bibliotecas';
$string['updateregistrationonhub'] = 'Guardar as configurações da conta';
$string['upgrade'] = 'Atualizar H5P';
$string['upgradebuttonlabel'] = 'Atualizar';
$string['upgradedone'] = '{$a} instâncias de conteúdo roram atualizadas com sucesso.';
$string['upgradeerror'] = 'Ocorreu um erro durante o processamento dos parâmetros:';
$string['upgradeerrorcontent'] = 'Não foi possível atualizar o conteúdo %id:';
$string['upgradeerrordata'] = 'Não foi possível carregar dados para a biblioteca %lib.';
$string['upgradeerrormissinglibrary'] = 'Biblioteca obrigatória em falta %lib.';
$string['upgradeerrornotsupported'] = 'Os parâmetros contêm %used, o que não é suportado.';
$string['upgradeerrorparamsbroken'] = 'Os parâmetros estão corrompidos.';
$string['upgradeerrorscript'] = 'Não foi possível carregar o script de atualizações para %lib.';
$string['upgradeerrortoohighversion'] = 'Os parâmetros contêm %used mas apenas é suportado %supported ou mais recente.';
$string['upgradeheading'] = 'Atualizar o conteúdo {$a}';
$string['upgradeinprogress'] = 'A atualizar para %ver...';
$string['upgradeinvalidtoken'] = 'Erro: Token de segurança inválido!';
$string['upgradelibrarycontent'] = 'Atualizar o conteúdo da biblioteca';
$string['upgradelibrarymissing'] = 'Erro: Biblioteca não encontrada!';
$string['upgrademessage'] = 'Está prestes a atualizar {$a} instâncias de conteúdos. Por favor, selecione a versão de atualização.';
$string['upgradenoavailableupgrades'] = 'Não existem atualizações disponíveis para esta biblioteca.';
$string['upgradenothingtodo'] = 'Não existem instâncias de conteúdo para atualizar.';
$string['upgradereturn'] = 'Voltar';
$string['upload'] = 'Carregar';
$string['uploadlibraries'] = 'Carregar bibliotecas';
$string['uploadsizelargerthanpostsize'] = 'O tamanho máximo de carregamento do PHP é maior do que o tamanho máximo da publicação. Isto pode causar problemas em algumas instalações.';
$string['user'] = 'Utilizador';
$string['validatingh5pfailed'] = 'Falhou a validação do pacote h5p.';
$string['validationfailed'] = 'O H5P requerido não era válido';
$string['viewreportlabel'] = 'Relatório';
$string['welcomecommunity'] = 'Esperamos que goste do H5P e contribua para a crescente comunidade através dos nossos <a {$a->forums}>fóruns</a>.';
$string['welcomecontactus'] = 'Se tiver algum comentário, não hesite em <a {$a}>contactar-nos</a>. Levamos os seus comentários muito a sério e estamos dedicados a tornar o H5P melhor a cada dia que passa!';
$string['welcomegettingstarted'] = 'Para começar com o H5P e o Moodle, veja o nosso <a {$a->moodle_tutorial}>tutorial</a> e confira o <a {$a->example_content}>conteúdo exemplo</a> em h5p.org para obter inspiração.';
$string['welcomeheader'] = 'Bem-vindo(a) ao mundo do H5P!';
$string['wrongversion'] = 'A versão da biblioteca H5P {$a->%machineName} usada neste conteúdo não é válida. O conteúdo contém {$a->%contentLibrary} mas deveria ser {$a->%semanticsLibrary}.';
$string['year'] = 'Ano';
$string['years'] = 'Anos';
$string['yearsfrom'] = 'Anos (desde)';
$string['yearsto'] = 'Anos (até)';
$string['zip'] = 'ZIP';
