<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'ar', version '4.0'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'نبذة عنا';
$string['actingasrole'] = 'أنت حالياً تمثل دور مختلف';
$string['activatetemplateoverride'] = 'تفعيل تجاوز المظهر لـ \'{$a}\'';
$string['activebreadcrumb'] = 'لون خلفية مسار التنقل النشط';
$string['activebreadcrumbdesc'] = 'تعيين لون خلفية لون مسار التنقل النشط، وبقية شريط مسار التنقل النشط.';
$string['activitiesheading'] = 'الأنشطة';
$string['alertaccess'] = 'حالة إظهار التنبيه';
$string['alertaccessadmins'] = 'مرئي للمشرفين';
$string['alertaccessglobal'] = 'ظاهر للجميع';
$string['alertaccessusers'] = 'ظاهر للمستخدمين الذين سجلوا دخولهم للنظام';
$string['alertannounce'] = 'الاعلانات';
$string['alertannouncedesc'] = 'عَرض إعلان في مربع التنبيهات.';
$string['alertbackgroundcolorinfo'] = 'لون خلفية المعلومة';
$string['alertbackgroundcolorinfodesc'] = 'لون خلفية مربعات التنبيه من نوع معلومات.';
$string['alertbackgroundcolorsuccess'] = 'لون خلفية الإعلان';
$string['alertbackgroundcolorsuccessdesc'] = 'لون خلفية مربعات التنبيه لنوع الإعلان.';
$string['alertbackgroundcolorwarning'] = 'لون خلفية التحذير';
$string['alertbackgroundcolorwarningdesc'] = 'لون خلفية مربعات التنبيه من نوع تحذيرات.';
$string['alertbordercolorinfo'] = 'لون الإطار عند الإعلام';
$string['alertbordercolorinfodesc'] = 'لون إطار مربعات التنبيه من نوع الإعلام.';
$string['alertbordercolorsuccess'] = 'لون الإطار عند الإعلان';
$string['alertbordercolorsuccessdesc'] = 'لون إطار مربعات التنبيه من نوع الإعلان.';
$string['alertbordercolorwarning'] = 'لون الإطار عند التحذير';
$string['alertbordercolorwarningdesc'] = 'لون إطار مربعات التنبيه من نوع التحذير.';
$string['alertcolorsuccess'] = 'لون الإعلان';
$string['alertcolorwarning'] = 'لون التنبيه';
$string['alertcount'] = 'عدد التحذيرات';
$string['alerthiddencoursedesc'] = 'عَرض التنبيهات في صفحة المساق';
$string['alerticoninfo'] = 'أيقونة المعلومة';
$string['alerticonsuccess'] = 'أيقونة الإعلان';
$string['alerticonwarning'] = 'أيقونة التنبيه';
$string['alertprofilefield'] = 'اسم حقل الملف الشخصي المخصص=القيمة (إختياري)';
$string['alertsettingsheading'] = 'تخصيص مربع التنبيه العلوي. أنظر التخطيط <a href="./../theme/adaptable/pix/layout.png" target="_blank"> هنا</a>';
$string['analyticscount'] = 'عدد التحليلات';
$string['analyticscountdesc'] = 'عدد حقول التحليلات المراد إظهارها في منطقة التحرير أدناه.';
$string['analyticsprofilefield'] = 'اسم حقل الملف الشخصي المخصص=القيمة (إختياري)';
$string['analyticssettings'] = 'التحليلات';
$string['analyticssettingsdesc'] = 'يمكنك تنصيب عدة نصوص برمجية لتحليلات Google واستهدافها في حقول الملف الشخصي للمستخدم. أو يمكنك استعمال Matomo، التحليلات مفتوحة المصدر.';
$string['analyticssettingsheading'] = 'إعداد تحليلات Google و/أو Matomo';
$string['analyticstext'] = 'مُعرَّف التحليلات';
$string['analyticstextdesc'] = 'أدخل مُعرَّف تحليلات Google';
$string['anonymizegadesc'] = 'إخفاء عنوان IP للمستخدم المرسل إلى تحليلات Google.';
$string['backcolor'] = 'لون الخلفية';
$string['backcolordesc'] = 'تعيين  لون الخلفية.';
$string['blockbackgroundcolor'] = 'لون خلفية الكتلة';
$string['blockbackgroundcolordesc'] = 'تعيين لون الخلفية لكل الكُتل.';
$string['blockbordercolor'] = 'لون إطار الكتلة';
$string['blockbordercolordesc'] = 'تعيين لون إطار الكتلة.';
$string['blockheaderbackgroundcolor'] = 'لون خلفية عنوان الكتلة';
$string['blockheaderbackgroundcolordesc'] = 'تعيين لون خلفية العنوان لكل الكُتل.';
$string['blockheaderborderbottom'] = 'سُمك الحد السفلي لرأس الكتلة';
$string['blockheaderborderbottomdesc'] = 'يضبط سماكة الجانب السفلي من الإطار لرؤوس الكتل.';
$string['blockheaderborderleft'] = 'سُمك الحد الأيسر لرأس الكتلة';
$string['blockheaderborderleftdesc'] = 'يضبط سماكة الجانب الأيسر من الإطار لرؤوس الكتل.';
$string['blockheaderborderright'] = 'سُمك الحد الأيمن لرأس الكتلة';
$string['blockheaderborderrightdesc'] = 'يضبط سماكة الجانب الأيمن من الإطار لرؤوس الكتل.';
$string['blockheaderbordertop'] = 'سُمك الحد العلوي لرأس الكتلة';
$string['blockheaderbordertopdesc'] = 'يضبط سماكة الجانب العلوي من الإطار لرؤوس الكتل.';
$string['blockheaderbordertopstyle'] = 'نمط حدود رأس الكتلة';
$string['blockheaderbordertopstyledesc'] = 'يضبط نمط حدود الإطار لرؤوس الكتل.';
$string['blockheaderbottomradius'] = 'نصف قطر الجانب السفلي من الإطار لرأس الكتلة';
$string['blockheadercolor'] = 'لون خط عنوان الكتلة';
$string['blockheadercolordesc'] = 'تحديد لون الخط لعنوان الكتلة.';
$string['blockheadertopradius'] = 'نصف قطر الجانب العلوي من الإطار لرأس الكتلة';
$string['blockiconsdesc'] = 'قم بتعيينه لإظهار أيقونات الكتل في منطقة رأس الكتلة.';
$string['blockiconsheadersize'] = 'حجم أيقونة رؤوس الكُتل';
$string['blockiconsheadersizedesc'] = 'إختر حجم أيقونة الخط المستعمل في عناوين كتل مودل. إختر قيمة من القائمة.';
$string['blocklayoutbuilder'] = 'مناطق كتل صفحة الواجهة';
$string['blocklayoutbuilderdesc'] = 'أدناه يمكنك بناء تصميمك الخاص لمناطق الكتل في صفحة الواجهة.<br/>لإضافة المحتوى، هذه المناطق ستتطلب<strong> تشغيل وضع التحرير في صفحة الواجهة لمودل</strong>.<br/>عندها يمكنك البدء بسحب الكتل وإفلاتها في المناطق التي أنشأتها!';
$string['blocklayoutlayoutrowdesc'] = 'إضافة/تعيين صف تصميم منطقة الكتل في صفحة الواجهة.';
$string['blockmainborderbottom'] = 'سُمك إطار زر الكتلة الرئيسي';
$string['blockmainborderbottomdesc'] = 'يضبط سُمك إطار الزر للمنطقة الرئيسية في الكتلة.';
$string['blockmainborderleft'] = 'سُمك الحد الأيسر الرئيسي للكتلة';
$string['blockmainborderleftdesc'] = 'يضبط سُمك الجانب الأيسر من الإطار للمنطقة الرئيسية للكتلة.';
$string['blockmainborderright'] = 'سُمك الإطار الأيمن الرئيسي للكتلة';
$string['blockmainborderrightdesc'] = 'يضبط سُمك الجانب الأيمن من الإطار للمنطقة الرئيسية في الكتلة.';
$string['blockmainbordertop'] = 'سُمك الإطار العلوي الرئيسي للكتلة';
$string['blockmainbordertopdesc'] = 'يضبط  سُمك الإطار العلوي الرئيسي للكتلة للمنطقة الرئيسية في الكتلة.';
$string['blockmainbordertopstyle'] = 'نمط الإطار الرئيسي للكتلة';
$string['blockmainbottomradius'] = 'نصف القطر السفلي الرئيسي للكتلة';
$string['blockmainbottomradiusdesc'] = 'يضبط نصف القطر السفلي في المنطقة الرئيسية للكتلة لتحقيق تأثير دائري / منحني.';
$string['blockmaintopradius'] = 'نصف القطر العلوي الرئيسي للكتلة';
$string['blockmaintopradiusdesc'] = 'يضبط نصف القطر العلوي في المنطقة الرئيسية للكتلة لتحقيق تأثير دائري / منحني.';
$string['blockregionbackgrounddesc'] = 'لون خلفية الحاوية التي تضم تصميمات الكتل المخصصة في صفحة الواجهة.';
$string['blocksettings'] = 'إعدادات الكتلة';
$string['blockside'] = 'موضع الكتل';
$string['breadcrumbhome'] = 'الصفحة الرئيسية لـ Breadcrumb';
$string['breadcrumbhomedesc'] = 'عرض الصفحة الرئيسية لـ Breadcrumb بشكل أيقونة أم بشكل نص.';
$string['breadcrumbhomeicon'] = 'أيقونة';
$string['breadcrumbhometext'] = 'نص';
$string['bs4all'] = 'صغير جداً - كبير جداً';
$string['bs4small'] = 'صغير - كبير جداً';
$string['buttoncolordesc'] = 'لون الأزرار الرئيسية المستعملة في أرجاء الموقع.';
$string['buttoncolordesccancel'] = 'لون الخلفية لزر الإلغاء.<br /> إطبع كلمة transparent للحصول على الشفافية.';
$string['categoryhavecustomheaderdesc'] = 'حدد التصنيفات التي عند المرتبة العليا التي سيكون لديها عنوان مخصص. لتحديد أكثر من تصنيف أو إلغاء تحديده، استعمل مفتاح \'Ctrl\'. إحفظ الصفحة وأعد تنشيطها للتحديث.
ملاحظة: التصنيفات الفرعية لما ستحدده سترث قيم الإعدادات.';
$string['categoryheaderbgimage'] = 'صورة خلفية التصنيف \'{$a->name}\' ذي المُعرَّف \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'تعيين الصورة الخلفية للتصنيف الأعلى رتبة \'{$a->name}\' ذي المُعرَّف \'{$a->id}\' في موضع العنوان. الحجم الأدنى هو 1600 × 180 بكسل (الموصى به 1900 × 180 بكسل).';
$string['categoryheaderbgimagedescchildren'] = 'تعيين الصورة الخلفية للتصنيف الأعلى رتبة \'{$a->name}\' ذي المُعرَّف \'{$a->id}\' وتفرعاته \'{$a->children}\' في موضع العنوان. الحجم الأدنى هو 1600 × 180 بكسل (الموصى به 1900 × 180 بكسل). ستغطي الصورة كامل العنوان.';
$string['categoryheadercustomcssdesc'] = 'تعيين أنماط CSS للتصنيف الأعلى رتبة \'{$a->name}\' ذي المُعرَّف \'{$a->id}\'. هذا من شأنه توليد نصوص CSS لمحدد القوالب مسبوقة بـ \'.category-{$a->id}\'. إذا لم يبدُ على أنماط CSS بأنها مطبقة، تحقق من ملف وقوعات PHP.';
$string['categoryheadercustomcssdescchildren'] = 'تعيين أنماط CSS للتصنيف الأعلى رتبة \'{$a->name}\' ذي المُعرَّف \'{$a->id}\' وتفرعاته \'{$a->children}\'. هذا من شأنه توليد نصوص CSS لمحدد القوالب مسبوقة بـ \'.category-{$a->id}\' ولكل المُعرَّفات المتشعبة منه. إذا لم يبدُ على أنماط CSS بأنها مطبقة، تحقق من ملف سجلات PHP.';
$string['categoryheadercustomtitle'] = 'العنوان المخصص للتصنيف \'{$a->name}\' ذو المُعرَّف \'{$a->id}\'';
$string['categoryheaderlogo'] = 'شعار التصنيف \'{$a->name}\' ذي المُعرَّف \'{$a->id}\'';
$string['colorsettingsheading'] = 'يغير لون الأزرار الرئيسية المستعملة في أرجاء النمط.';
$string['coursepageblockactivitybottomenabled'] = 'تمكين منطقة الكتلة السفلية للنشاط في صفحة المساق.';
$string['coursepageblockactivitybottomenableddesc'] = 'تمكين هذه المنطقة في كل صفحات المساق.';
$string['coursepageblocklayoutbuilder'] = 'مناطق كتلة صفحة المساق';
$string['coursepageblocklayoutlayoutbottomrow'] = 'صف المنطقة السفلية لكتلة صفحة المساق';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'إضافة / تعيين تخطيط الصفحة لصف منطقة الكتلة في صفحة المساق.';
$string['coursepageblocklayoutlayouttoprow'] = 'صف المنطقة العلوية لكتلة صفحة المساق';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'إضافة / تعيين تخطيط الصفحة لصف منطقة الكتلة في صفحة المساق.';
$string['coursepageblockregionsettings'] = 'باني منطقة كتلة صفحة المساق';
$string['coursepageblocksenabled'] = 'تمكين مناطق الكتل المخصصة في صفحة المساق';
$string['coursepageblocksenableddesc'] = 'يمكنك تمكين/تعطيل مناطق الكتل المخصصة (العلوية والسفلية) في صفحة المساق. يمكنك عندها سحب الكتل وإفلاتها في المناطق التي أنشأتها.';
$string['coursepageblocksliderenabled'] = 'تمكين منطقة كتلة المنزلق المخصص في صفحة المساق';
$string['coursepageblocksliderenableddesc'] = 'تمكين هذه المنطقة في كل صفحات المساق.';
$string['coursepageheaderhidesitetitle'] = 'إخفاء عنوان الموقع في صفحات المقررات الدراسية';
$string['coursepagesidebarinfooterenabled'] = 'نقل الشريط الجانبي إلى التذييل في صفحة المساق';
$string['coursepagesidebarinfooterenableddesc'] = 'تخطيط صفحة المساق العريض عبر نقل الشريط الجانبي إلى التذييل.';
$string['coursesectionactivityassignbgcolor'] = 'لون الخلفية لنشاط الواجب';
$string['coursesectionactivityassignbgcolordesc'] = 'تعيين لون الخلفية لنشاط الواجب. إطبع كلمة <strong>transparent</strong> في المربع للحصول على الشفافية.';
$string['coursesectionactivityassignleftbordercolor'] = 'لون عرض الإطار الأيسر لنشاط الواجب';
$string['coursesectionactivityassignleftbordercolordesc'] = 'يضبط لون الإطار الأيسر.';
$string['coursesectionactivitybordercolor'] = 'لون الإطار السفلي لمقطع نشاط المساق';
$string['coursesectionactivityforumbgcolor'] = 'لون الخلفية لنشاط المنتدى';
$string['coursesectionactivityforumbgcolordesc'] = 'تعيين لون الخلفية لنشاط المنتدى. إطبع كلمة <strong>transparent</strong> في المربع للحصول على الشفافية.';
$string['coursesectionactivityforumleftbordercolor'] = 'لون عرض الإطار الأيسر لنشاط المنتدى';
$string['coursesectionactivityforumleftbordercolordesc'] = 'يضبط لون الإطار الأيسر.';
$string['coursesectionactivityleftborderwidth'] = 'عُرض الإطار الأيسر لنشاط مقطع المساق';
$string['coursesectionactivityleftborderwidthdesc'] = 'يضبط عُرض الإطار الذي يظهر على يسار نشاط مقطع المساق.';
$string['coursesectionactivityquizbgcolor'] = 'لون الخلفية لنشاط الاختبار';
$string['coursesectionactivityquizbgcolordesc'] = 'تعيين لون الخلفية لنشاط الاختبار. إطبع كلمة <strong>transparent</strong> في المربع للحصول على الشفافية.';
$string['coursesectionactivityquizleftbordercolor'] = 'لون عرض الإطار الأيسر لنشاط الاختبار';
$string['coursesectionactivityquizleftbordercolordesc'] = 'يضبط لون الإطار الأيسر.';
$string['coursesectionbgcolor'] = 'خلفية مقطع المساق';
$string['coursesectionbgcolordesc'] = 'تعيين لون الخلفية لمقطع المساق.';
$string['coursesectionbordercolor'] = 'لون إطار مقطع المساق';
$string['coursesectionbordercolordesc'] = 'تعيين لون إطار مقاطع المساق.';
$string['coursesectionheaderbgdesc'] = 'تعيين لون الخلفية لعناوين مقاطع المساق.';
$string['coursesectionheaderbordercolor'] = 'لون إطار عنوان مقطع المساق';
$string['coursesettingsdesc'] = 'تخصيص بعض تنسيقات المقررات الدراسية الأكثر استعمالاً في مودل لتتناسب مع التصميم الرئيسي.';
$string['coursetitlefullname'] = 'الاسم الكامل للمقرر الدراسي';
$string['coursetitlemaxwidth'] = 'أقصى طول لعنوان المساق';
$string['coursetitlemaxwidthdesc'] = 'تعيين العدد الأقصى من الحروف لمنطقة عنوان المساق.';
$string['covfontcolor'] = 'لون خط عنوان بلاط Coventry';
$string['covfontcolordesc'] = 'يحدد لون خط العنوان عند اختيار عرض بلاطات Coventry.';
$string['customcoursesubtitle'] = 'العنوان المخصص للمساق';
$string['customcoursesubtitledesc'] = 'اسم الحقل المخصص في الملف الشخصي لعنوان المساق.';
$string['customcoursetitle'] = 'العنوان المخصص للمساق';
$string['customcoursetitledesc'] = 'اسم الحقل المخصص في الملف الشخصي لعنوان المساق.';
$string['dangericoncolor'] = 'لون أيقونة التنبيه';
$string['dangericoncolordesc'] = 'يضبط لون أيقونة التحذير/الخطر المستعملة بشكل أساسي في الحقول الإجبارية.';
$string['dashblocklayoutbuilder'] = 'مناطق كتل لوحة التحكم';
$string['dashblocklayoutbuilderdesc'] = 'أدناه يمكنك بناء المخطط الخاص بك لمناطق الكتل في صفحة لوحة التحكم.<br/>لإضافة المحتوى إلى تلك المناطق ستحتاج إلى <strong>تشغيل التحرير في صفحة لوحة التحكم لمودل</strong>.<br/>عندها يمكنك البدء بسحب الكتل وإفلاتها في المناطق التي أنشأتها!';
$string['dashblocklayoutlayoutrow'] = 'صف منطقة كتل لوحة التحكم';
$string['dashblocklayoutlayoutrowdesc'] = 'إضافة / تعيين صف لمخطط منطقة الكتل في صفحة لوحة التحكم.';
$string['dashblocksabovecontent'] = 'الإظهار فوق المحتوى الرئيسي';
$string['dashblocksbelowcontent'] = 'الإظهار تحت المحتوى الرئيسي';
$string['dashblocksenabled'] = 'تمكين منطقة الكتل المخصصة في صفحة \'لوحة التحكم\'';
$string['dashblocksenableddesc'] = 'يمكنك تمكين/تعطيل مناطق مخصصة للكتل في صفحة \'لوحة التحكم\'. بعدها بوسعك سحب الكتل وإفلاتها في المناطق التي أنشأتها.';
$string['dashblocksposition'] = 'موضع المنطقة المخصصة للكتل';
$string['dashblockspositiondesc'] = 'عندما يتم تمكين المناطق المخصصة للكتل في صفحة لوحة التحكم، إختر الموضع.';
$string['dashboardblockregionsettings'] = 'باني مناطق كتل لوحة التحكم';
$string['disablemenuscoursepages'] = 'تعطيل القوائم في صفحات المقررات الدراسية';
$string['disablemenuscoursepagesdesc'] = 'تشغيل هذا الخيار سيحدد عرض القوائم العلوية بصفحات الموقع، الصفحة الرئيسية، ولوحة التحكم (\'صفحتي الرئيسية\') إلخ. ولن تظهر في أي من صفحات المساق.';
$string['dividingline2'] = 'تقسيم السطر في التذييل';
$string['dividingline2desc'] = 'لون الخط الفاصل الموجود في تذييل الصفحة.';
$string['editfont'] = 'تحرير وتخصيص لون الخط لزر هذه الصفحة';
$string['editfontdesc'] = 'يحدد لون الخط عند تحرير وتخصيص زر هذه الصفحة';
$string['editoffbk'] = 'تحرير وتخصيص خلفية زر \'الإيقاف\' لهذه الصفحة';
$string['editoffbkdesc'] = 'تعيين لون الخلفية لزر التحرير أو تخصيص هذه الصفحة في وضع \'الإطفاء\'.';
$string['editonbk'] = 'تحرير وتخصيص خلفية زر هذه الصفحة';
$string['editonbkdesc'] = 'تعيين لون الخلفية لزر التحرير أو تخصيص هذه الصفحة.';
$string['editsettingsbuttonshowbutton'] = 'إظهار زر التحرير فقط. أي زر "تمكين التحرير" في صفحة المساق.';
$string['enableaccesstooldesc'] = 'عرض رابط لصفحة تفضيلات "أداة تمكين الوصول" الخاصة بالمستخدمين - ملاحظة: هذا يتطلب <a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank">ملحق تمكين الوصول</a>';
$string['enableanalytics'] = 'تمكين تحليلات Google';
$string['enableanalyticsdesc'] = 'تمكين إعدادات تحليلات Google في موقع مودل الخاص بك';
$string['enableavailablecoursesdesc'] = 'عَرض عبارة "المقررات الدراسية المتاحة" في صفحة الواجهة.';
$string['enableblog'] = 'تمكين مدوناتي';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'تمكين رابط تحرير الملف الشخصي المبوب. ملاحظة: عن تمكينه، سيظهر فقط للمستخدمين الذين يمتلكون صلاحية تحرير الملف الشخصي.';
$string['enableeventsdesc'] = 'عَرض رابط إلى التقويم.';
$string['enablefeed'] = 'إفادتي';
$string['enablefeeddesc'] = 'عرض رابط لصفحة "إفادتي" الخاصة بالمستخدمين - ملاحظة: هذا يتطلب \'<a href="https://moodle.org/plugins/report_myfeedback" target="blank">ملحق إفادتي</a>\'.';
$string['enableheading'] = 'رأس عنوان المساق';
$string['enableheadingdesc'] = 'جعل النمط عارضًا لعنوان المساق في موضع العنوان عند تمكين العنوان الافتراضي لموقع مودل.';
$string['enablehelp'] = 'رابط المساعدة \'{$a->number}\'';
$string['enablehelpdesc'] = 'إضافة رابط المساعدة \'{$a->number}\' في شريط التنقل.';
$string['enablehomedesc'] = 'عرض رابط لصفحة الواجهة.';
$string['enablehomeredirect'] = 'تمكين redirect=0 للصفحة الرئيسية';
$string['enablehomeredirectdesc'] = 'تمكين redirect=0 في الصفحة الرئيسية. هذا لاستعماله في المواقع التي تكون فيها الصفحة الرئيسية هي الصفحة الرئيسية الافتراضية. هذا سيمنع المستخدم الذي ينقر على رابط الصفحة الرئيسية من أن تتم إعادة توجيهه إلى صفحتي الرئيسية / لوحة التحكم.';
$string['enablemyhomedesc'] = 'عرض رابط إلى {$a}';
$string['enablesavecanceloverlaydesc'] = 'عرض زري الحفظ/الإلغاء المتداخلين عند أعلى صفحة الإعدادات لتسهيل عملية حفظها.';
$string['enableshowhideblocks'] = 'تمكين إظهار/إخفاء الكتل';
$string['enableshowhideblocksdesc'] = 'يسمح للمستخدمين بإظهار/إخفاء كل الكتل.';
$string['enableshowhideblockstext'] = 'إظهار النص لإظهار الكُتل وإخفائها';
$string['events'] = 'الأحداث';
$string['favicon'] = 'الأيقونة المفضلة';
$string['favicondesc'] = 'إرفع الأيقونة المفضلة لتستعملها في موقعك،';
$string['fontblockheadercolor'] = 'لون خط عناوين الكتل';
$string['fontblockheadercolordesc'] = 'تعيين لون خط العنوان في كتل مودل، استعمل الترميز السداسي عشري لـ HTML. لاحظ أن ذلك يؤثر على ألوان الأيقونات أيضًا.';
$string['fontblockheadersize'] = 'حجم الخط في عناوين الكتل';
$string['fontblockheadersizedesc'] = 'إختر حجم الخط المستعمل في عناوين كتل مودل. إختر قيمة من القائمة.';
$string['fontblockheaderweight'] = 'وزن الخط في عناوين الكتل';
$string['fontblockheaderweightdesc'] = 'إختر وزن الخط المستعمل في عناوين كتل مودل. إختر قيمة تتراوح بين 100 إلى 900 اعتمادًا على الخط المحدد.';
$string['fontcolor'] = 'لون الخط الرئيسي';
$string['fontcolordesc'] = 'تعيين لون الخط في المظهر، استعمل الترميز السداسي عشري لـ HTML.';
$string['fontheadercolor'] = 'لون خط العناوين';
$string['fontheadercolordesc'] = 'تعيين لون خط العناوين في المظهر، استعمل الترميز السداسي عشري لـ HTML.';
$string['fontheadernamedesc'] = 'إختر الخط الافتراضي، \'sans-serif\'، أو <a href="https://www.google.com/fonts" target="_blank">خطوط Google</a> المستعمل في عناوين النصوص والكتل.';
$string['fontheaderweightdesc'] = 'وزن الخط المستعمل في عناوين الموقع. إختر قيمة تتراوح بين 100 إلى 900 اعتمادًا على الخط المحدد.';
$string['fontname'] = 'الخط الرئيسي';
$string['fontnamedesc'] = 'إختر الخط الافتراضي، \'sans-serif\'، أو <a href="https://www.google.com/fonts" target="_blank">خطوط Google</a> المستعمل في الموقع.';
$string['fontsize'] = 'حجم الخط الرئيسي';
$string['fontsizedesc'] = 'إختر حجم الخط الافتراضي المستعمل في عموم الموقع (كنسبة مئوية).';
$string['fonttitlecolor'] = 'لون خط عنوان الموقع / المساق';
$string['fonttitlecolorcourse'] = 'لون خط عنوان المساق';
$string['fonttitlecolorcoursedesc'] = 'تعيين لون خط عنوان المساق في المظهر، استعمل الترميز السداسي عشري لـ HTML.';
$string['fonttitlecolordesc'] = 'تعيين لون خط عنوان الموقع وعنوان المساق في المظهر، استعمل الترميز السداسي عشري لـ HTML.';
$string['fonttitlename'] = 'نوع خط عنوان الموقع / المساق';
$string['fonttitlenamedesc'] = 'إختر الخط الافتراضي، \'sans-serif\'، أو <a href="https://www.google.com/fonts" target="_blank">خطوط Google</a> المستعمل في عنوان الموقع وعناوين المقررات الدراسية.';
$string['fonttitlesize'] = 'حجم خط عنوان الموقع / المساق';
$string['fonttitlesizedesc'] = 'عنوان الموقع وحجم الخط في عنوان المساق المستعمل في الموقع. إختر قيمة من القائمة.';
$string['fonttitleweight'] = 'وزن خط عنوان الموقع / المساق';
$string['fonttitleweightdesc'] = 'إختر وزن الخط المستعمل في عناوين الموقع وعناوين المقررات الدراسية. إختر قيمة تتراوح بين 100 إلى 900 اعتمادًا على الخط المحدد.';
$string['fontweight'] = 'وزن الخط الرئيسي';
$string['fontweightdesc'] = 'وزن الخط المستعمل في الموقع. إختر قيمة تتراوح بين 100 إلى 900 اعتمادًا على الخط المحدد.';
$string['footerbkcolor'] = 'لون خلفية تذييل الصفحة';
$string['footerbkcolordesc'] = 'تعيين لون خلفية تذييل الصفحة.';
$string['footerblocksplacement'] = 'موضع كتل تذييل الصفحة';
$string['footerblocksplacementdesc'] = 'التحكم بموضع إظهار كتل تذييل الصفحة. الافتراضي هو على امتداد الموقع.';
$string['footercontent'] = 'مقطع محتوى التذييل';
$string['footercontentdesc'] = 'إضافة المحتوى إلى مقطع التذييل.';
$string['footerdesc'] = 'إضافة عنوان إلى مقطع التذييل.';
$string['footerheader'] = 'عنوان مقطع التذييل';
$string['footerlayoutrow'] = 'منشئ تخطيط التذييل';
$string['footerlayoutrowdesc'] = 'تصميم مخططك لمناطق كتلة التذييل.';
$string['footerlinkcolor'] = 'لون رابط كتل تذييل الصفحة';
$string['footerlinkcolordesc'] = 'لون رابط كتل تذييل الصفحة';
$string['footersettings'] = 'تذييل الصفحة';
$string['footersettingsheading'] = 'تعيين المحتوى الذي ينبغي أن يظهر في تذييل الصفحة. أنظر التصميم <a href="./../theme/adaptable/pix/layout.png" target="_blank">هنا</a>';
$string['footertextcolor'] = 'لون نص تذييل الصفحة';
$string['footertextcolor2'] = 'لون نص تذييل الصفحة السفلي';
$string['footertextcolor2desc'] = 'لون نص تذييل الصفحة السفلي.';
$string['footertextcolordesc'] = 'لون النص في تذييل الصفحة، استعمل الترميز السداسي عشري لـ HTML.';
$string['footnotedesc'] = 'إضافة نص إلى تذييل الصفحة.';
$string['forumbodybackgroundcolordesc'] = 'لون الخلفية لمنشور المنتدى.';
$string['forumheaderbackgroundcolordesc'] = 'لون الخلفية لمنشور المنتدى.';
$string['frnt-footer'] = 'الكُتل في هذه المنطقة ستكون مرئية للمشرفين فقط';
$string['frontpageblocksenabled'] = 'تمكين منطقة الكتلة المخصصة في صفحة الواجهة';
$string['frontpageblocksenableddesc'] = 'يمكنك تمكين/تعطيل مناطق الكتل المخصصة في صفحة الواجهة.
يمكنك عندها سحب الكتل وأفلاتها في المناطق التي أنشأتها.';
$string['frontpageblocksettings'] = 'كُتل التسويق';
$string['frontpagecoursesettings'] = 'قائمة مساقات صفحة الواجهة';
$string['frontpagedesc'] = 'تعيين طريقة تقديم مربعات المقررات الدراسية في صفحة الواجهة.';
$string['frontpagemarketenabled'] = 'تمكين كُتل التسويق';
$string['frontpagemarketenableddesc'] = 'تعيين كُتل التسويق في صفحة الواجهة.';
$string['frontpagemarketoption'] = 'إختر نمط كُتل التسويق';
$string['frontpagenumbertilesdesc'] = 'عدد بلاطات المقررات الدراسية المراد عرضها لكل صف في قائمة مقررات صفحة الواجهة.';
$string['frontpagerenderer'] = 'مربعات مساقات صفحة الواجهة';
$string['frontpagerendererdesc'] = 'التحكم بالطريقة التي يتم بها تقديم مربعات المقررات الدراسية في صفحة الواجهة.';
$string['frontpagesettingsheading'] = 'تقديم صفحة الواجهة';
$string['frontpageslidersettings'] = 'منزلق صفحة الواجهة';
$string['frontpagetickersettings'] = 'مؤشر صفحة الواجهة';
$string['gdprbuttondesc'] = 'عَرض زر ملخص الاحتفاظ بالبيانات في تذييل الصفحة.';
$string['googleanalyticssettings'] = 'تحليلات Google';
$string['googleanalyticssettingsdesc'] = 'يمكنك تنصيب عدة نصوص برمجية لتحليلات Google واستهدافها في حقول الملف الشخصي للمستخدم.';
$string['googleanalyticssettingsheading'] = 'إعداد تحليلات Google في موقعك';
$string['headerbgimage'] = 'الصورة الخلفية';
$string['headerbgimagedesc'] = 'تعيين صورة خلفية في رأس الصفحة. الحجم الأدنى هو 1600 × 180 بكسل (الموصى به هو 1900 × 180 بكسل). الصورة تغطي كل منطقة العنوان. يمكنك إضافة لون في \'لون خلفية المنطقة العليا للعنوان\' أو استعمال <i>transparent</i> لإظهار صورة الخلفية. في تلك الحالة، قم بتعديل لون النص ليُعرض بشكل صحيح فوق الصورة.';
$string['headerbkcolor'] = 'لون أعلى خلفية العنوان';
$string['headerbkcolor2'] = 'لون أسفل خلفية العنوان';
$string['headerbkcolor2desc'] = 'تعيين لون أسفل خلفية العنوان. لاحظ أن ذلك أيضًا يعين لون الخلفية في النمط الثاني للعنوان.';
$string['headerbkcolordesc'] = 'تعيين لون أعلى خلفية العنوان.';
$string['headerdesc'] = 'إرفع أيقونتك المفضلة، الشعار، تعيين نموذج تسجيل الدخول في رأس الصفحة، تعديل العناوين في رأس الصفحة. <br />يمكنك تعيين حجم الخط ونمطه للعناوين في صفحة \'<a href="./../admin/settings.php?section=theme_adaptable_font">الخطوط</a>\'';
$string['headernavbarhelpheading'] = 'روابط المساعدة وخياراتها';
$string['headertextcolordesc'] = 'تعيين نص الكتل العليا في العنوان ولون الروابط.';
$string['helplinkscount'] = 'عدد روابط المساعدة';
$string['helplinkscountdesc'] = 'يضبط عدد روابط المساعدة التي ترغب بإضافتها إلى شريط التنقل الرئيسي.';
$string['helplinktitle'] = 'عنوان رابط المساعدة \'{$a->number}\'';
$string['helplinktitledesc'] = 'عنوان رابط المساعدة \'{$a->number}\' في شريط التنقل. إذا كان خاليًا، فسيرجع إلى الافتراضي \'المساعدة {$a->number}\'.';
$string['helpprofilefield'] = 'رابط المساعدة لحقل الملف الشخصي المخصص \'{$a->number}\' (إختياري)';
$string['helpprofilefielddesc'] = 'إضافة قاعدة وصول لاستعمال رابط المساعدة \'{$a->number}\' لحقل الملف الشخصي المخصص، مثلاً: usertype=student.';
$string['helptargetdesc'] = 'هل تريد جعل رابط المساعدة يُفتح بنافذة جديدة؟';
$string['hideblocks'] = 'إخفاء الكتل';
$string['hidefootersocialdesc'] = 'إظهار أيقونات التواصل الاجتماعي في التذييل تحت الكتل.';
$string['home'] = 'الصفحة الرئيسية';
$string['homebk'] = 'صورة خلفية صفحة الواجهة';
$string['homebkdesc'] = 'إرفع صورة لتصير خلفية للصفحة الرئيسية';
$string['infobox'] = 'مربع معلومات صفحة الواجهة';
$string['infobox2'] = 'مربع المعلومات الثانوي لصفحة الواجهة';
$string['infobox2desc'] = 'مربع المعلومات الثانوي في صفحة الواجهة. يرجى النظر في مقطع \'README\' لتبويب \'المعلومات\' في الإعدادات لمزيد من المعلومات.<br><strong>ملاحظة: </strong><i>هذا العنصر مستعمل حصراً للتوافق مع BCU وستتم إزالته في الإصدارات القادمة.</i>';
$string['infoboxdesc'] = 'نصوص HTML لمربع المعلومات في صفحة الواجهة. يرجى النظر في مقطع \'README\' لتبويب \'المعلومات\' في الإعدادات لمزيد من المعلومات.<br><strong>ملاحظة: </strong><i>هذا العنصر مستعمل حصراً للتوافق مع BCU وستتم إزالته في الإصدارات القادمة.</i>';
$string['infoiconcolor'] = 'لون أيقونة المساعدة';
$string['introboxbackgroundcolor'] = 'لون خلفية مربع المقدمة';
$string['introboxbackgroundcolordesc'] = 'لون الخلفية لمربع المقدمة (يسلط الضوء على وصف النشاط) المستعمل في المنتديات وغيرها من النشاطات';
$string['jssectionrestricteddashboardonly'] = 'تضمين Javascript فقط في صفحة لوحة التحكم';
$string['jssectionrestricteddashboardonlydesc'] = 'إظهار javascript فقط في صفحة لوحة التحكم. بخلاف ذلك، سيظهر في عموم الموقع.';
$string['jssectionrestrictedprofilefielddesc'] = 'إظهار نصوص avascript أعلاه فقط عندما يطابق المستخدم قيمة حقل الملف الشخصي المخصص هذا، مثلاً، faculty=fbl.';
$string['layoutaddcontentdesc2'] = 'كُتل التسويق. إذا كنت راضيًا عن هذا التصميم، أضف المحتوى إلى الكُتل أدناه.<br/>إذا لم تكن راضيًا، استعمل منشئ التصميم أعلاه لإجراء التعديلات.';
$string['leftblocks'] = 'الجانب الأيسر';
$string['linkcolordesc'] = 'تعيين لون الروابط في المظهر، استعمل الترميز السداسي عشري لـ HTML.';
$string['linkhoverdesc'] = 'تعيين لون الروابط (عند تحريك الماوس) في المظهر، استعمل الترميز السداسي عشري لـ HTML.';
$string['loginbgimage'] = 'الصورة الخلفية';
$string['loginbgimagedesc'] = 'إضافة الصورة الخلفية إلى صفحة الحجم الكامل.';
$string['loginbgopacity'] = 'عنوان صفحة تسجيل الدخول، شريط التنقل، مربع الدخول وشفافية خلفية التذييل عندما تكون هناك صورة خلفية';
$string['loginbgopacitydesc'] = 'شفافية تسجيل الدخول لمنطقة العنوان، شريط التنقل، مربع الدخول والتذييل عندما تكون هناك صورة خلفية.';
$string['loginfooter'] = 'تذييل صفحة الدخول';
$string['loginfooterdesc'] = 'إظهار تذييل صفحة تسجيل الدخول.';
$string['logo'] = 'الشعار';
$string['maincolor'] = 'اللون الرئيسي';
$string['maincolordesc'] = 'اللون الرئيسي للكتل وتذييل الصفحة.';
$string['maincoursepage'] = 'الصفحة الرئيسية للمساق';
$string['market'] = 'كُتلة التسويق';
$string['marketblockbordercolor'] = 'لون إطار كتلة التسويق';
$string['marketblockbordercolordesc'] = 'تعيين لون إطار كتلة التسويق.';
$string['marketblocksbackgroundcolor'] = 'لون خلفية منطقة كُتل التسويق';
$string['marketblocksbackgroundcolordesc'] = 'تعيين لون خلفية منطقة كُتل التسويق.';
$string['marketdesc'] = 'إضافة نص html لكتلة التسويق (أنظر ملف <a href="./../theme/adaptable/README.txt" target="_blank">README</a> لمزيد من المعلومات والتلميحات).';
$string['marketingbuilderdesc'] = 'استعمل الأداة أدناه لتهيئة كتل التسويق الخاصة بك. بمجرد تعريفها، سيظهر المزيد من إعدادات الكتلة أسفل الصفحة.';
$string['marketingbuilderheading'] = 'منشئ تصميم كتلة التسويق';
$string['marketingsettings'] = 'كُتل التسويق';
$string['marketingsettingsheading'] = 'تخصيص كُتل التسويق التي تظهر في صفحة الواجهة. أنظر التصميم <a href="./../theme/adaptable/pix/layout.png" target="_blank">هنا</a>';
$string['marketlayoutrow'] = 'صف كتلة التسويق';
$string['marketlayoutrowdesc'] = 'إضافة/تعيين التصميم لصف كتلة التسويق في صفحة الواجهة';
$string['menubkcolor'] = 'لون خلفية القائمة الرئيسية';
$string['menubkcolordesc'] = 'يضبط لون خلفية القائمة الرئيسية.';
$string['menubordercolor'] = 'لون الإطار السفلي للقائمة الرئيسية';
$string['menubordercolordesc'] = 'يضبط لون إطار القائمة الرئيسية السفلي';
$string['menufontcolor'] = 'لون خط القائمة الرئيسية';
$string['menufontcolordesc'] = 'يضبط لون خط القائمة الرئيسية';
$string['menufontpaddingdesc'] = 'يضبط التبطين للعناصر في شريط التنقل الرئيسي.';
$string['menufontsize'] = 'حجم الخط في شريط التنقل';
$string['menufontsizedesc'] = 'يضبط حجم الخط المستعمل في شريط التنقل الرئيسي.';
$string['menuhovercolor'] = 'لون التحويم للقائمة الرئيسية';
$string['menuhovercolordesc'] = 'يضبط لون التحويم للقائمة الرئيسية';
$string['menuoverrideprofilefield'] = 'اسم حقل الملف الشخصي المخصص';
$string['menuoverrideprofilefielddesc'] = 'اسم حقل "القائمة" المخصص في الملف الشخصي المستعمل في تجاوز المستخدم.';
$string['menusheadingvisibility'] = 'الإعدادات العامة لرؤية القائمة العليا';
$string['menuslinkright'] = 'إظهار روابط القوائم في أعلى اليمين';
$string['menuslinkrightdesc'] = 'عند تأشيره، سيتم إظهار روابط القوائم في أعلى اليمين بجوار قوائم المراسلات';
$string['messagepopupbackground'] = 'لون خلفية الرسائل المنبثقة';
$string['messagepopupbackgrounddesc'] = 'تعيين لون الخلفية لعناوين الرسائل المنبثقة.';
$string['messagingbackgroundcolor'] = 'لون خلفية النافذة الرئيسية للرسائل';
$string['messagingbackgroundcolordesc'] = 'يضبط لون خلفية النافذة الرئيسية لرسائل المحادثات.';
$string['mobilemenubkcolor'] = 'لون خلفية قائمة الجوال';
$string['mobilemenubkcolordesc'] = 'يضبط لون خلفية قائمة التنقل الرئيسية في أجهزة الجوال (المطوية).';
$string['mobileslidebartabbkcolor'] = 'لون خلفية تبويب شريط التمرير الجانبي';
$string['mobileslidebartabbkcolordesc'] = 'لون خلفية شريط التمرير الجانبي في أجهزة الجوال (مطوي).';
$string['moodledocsdesc'] = 'عَرض رابط توثيقات مودل في تذييل الصفحة.';
$string['msgbadgecolor'] = 'لون خلفية بطاقة الرسالة';
$string['msgbadgecolordesc'] = 'تعيين لون الخلفية لبطاقة / فقاعة الرسائل في رأس الصفحة (التي تعرض عدد الرسائل غير المقروءة)';
$string['myblogs'] = 'مدوناتي';
$string['mysites'] = 'مقرراتي';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'إظهار العنوان الكامل للمساق والعنوان الكامل عند تحريك الماوس.';
$string['mysitesmenudisplayfullnamenohover'] = 'إظهار العنوان الكامل للمساق بدون نص عند تحريك الماوس.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'إظهار رمز الاختصار والاسم الكامل للمقرر الدراسي عند تحريك الماوس.';
$string['navbardisplayiconsdesc'] = 'عرض الأيقونات بجوار عناوين القائمة الرئيسية';
$string['navbardropdownhovercolor'] = 'لون خلفية القائمة المنسدلة عند تحريك الماوس';
$string['navbardropdownhovercolordesc'] = 'لون خلفية القائمة المنسدلة عند تحريك الماوس على عناصرها.';
$string['newmenufield'] = 'اسم حقل الملف الشخصي المخصص=القيمة (إختياري)';
$string['newmenutitle'] = 'عنوان القائمة العلوية';
$string['newmenutitledesc'] = 'عنوان القائمة المنسدلة الذي سيظهر عند رأس موقعك.';
$string['nextactivity'] = 'النشاط التالي';
$string['pageheaderheightdesc'] = 'يضبط إرتفاع منطقة العنوان الرئيسي (التي تضم الشعار والعناوين).';
$string['people'] = 'المشاركون';
$string['piwikenableddesc'] = 'تمكين تعقب Matomo لمودل.';
$string['piwiksettings'] = 'تحليلات Matomo (سابقًا Piwik)';
$string['piwiksettingsheading'] = 'تنصيب Matomo';
$string['piwiksiteurl'] = 'رابط Matomo';
$string['piwiksiteurldesc'] = 'أدخل رابط تحليلات Matomo بدون http(s) أو الشرطة المائلة اللاحقة.';
$string['previousactivity'] = 'النشاط السابق';
$string['printbodyfontsize'] = 'حجم خط المتن';
$string['printpageorientation'] = 'اتجاه الصفحة';
$string['printpageorientationdesc'] = 'ضبط اتجاه الصفحة إلى \'عمودي\' أو \'أفقي\'.';
$string['printsettings'] = 'طباعة';
$string['printsettingsheading'] = 'إعدادات الطباعة';
$string['propertiesvalue'] = 'القيمة';
$string['putpropertiesignorecti'] = 'تجاهل كل إعدادات صورة عناوين المقررات الدراسية.';
$string['region-course-bottom-a'] = 'المنطقة السفلية لصفحة المساق 5';
$string['region-course-bottom-b'] = 'المنطقة السفلية لصفحة المساق 6';
$string['region-course-bottom-c'] = 'المنطقة السفلية لصفحة المساق 7';
$string['region-course-bottom-d'] = 'المنطقة السفلية لصفحة المساق 8';
$string['region-course-tab-one-a'] = 'منطقة التبويب لصفحة المساق 1';
$string['region-course-tab-two-a'] = 'منطقة التبويب لصفحة المساق 2';
$string['region-course-top-a'] = 'المنطقة العلوية لصفحة المساق 1';
$string['region-course-top-b'] = 'المنطقة العلوية لصفحة المساق 2';
$string['region-course-top-c'] = 'المنطقة العلوية لصفحة المساق 3';
$string['region-course-top-d'] = 'المنطقة العلوية لصفحة المساق 4';
$string['region-frnt-footer'] = 'تذييل الصفحة';
$string['region-news-slider-a'] = 'منطقة المنزلق لصفحة المساق';
$string['regionmaincolor'] = 'لون المنطقة الرئيسية';
$string['regionmaincolordesc'] = 'تحديد لون الخلفية لمنطقة المحتوى الرئيسي.';
$string['rendereroverlayfontcolor'] = 'لون الخط المتراكب';
$string['responsivecoursetitle'] = 'عنوان المساق/الموقع';
$string['responsiveheader'] = 'العنوان الرئيسي';
$string['responsivelogo'] = 'الشعار';
$string['responsivepagefooter'] = 'تذييل الصفحة';
$string['responsivepagefooterdesc'] = 'بأي حجم للشاشة تريد للتذييل أن يُعرض؟';
$string['responsiveslider'] = 'منزلق صفحة الواجهة';
$string['responsivesliderdesc'] = 'ما هي الشاشات المحجمة التي ترغب بعرض منزلق صفحة الواجهة فيها؟';
$string['responsivesocialsize'] = 'تحديد حجم الخط لأيقونات التواصل الاجتماعي في الجوال';
$string['rightblocks'] = 'الجانب الأيمن';
$string['selectionbackground'] = 'لون خلفية التحديد';
$string['selectionbackgrounddesc'] = 'تعيين لون الخلفية عند تحديد نص في الشاشة.';
$string['settingsanalytics'] = 'التحليلات';
$string['settingsfootercolors'] = 'ألوان تذييل الصفحة';
$string['settingsmaincolors'] = 'الألوان الرئيسية';
$string['settingsmarketingcolors'] = 'ألوان كتلة التسويق';
$string['showblocks'] = 'إظهار الكتل';
$string['showfooterblocks'] = 'إظهار كتل تذييل الصفحة';
$string['showfooterblocksdesc'] = 'إظهار / إخفاء كتل تذييل الصفحة الأربعة القابلة للتخصيص.';
$string['shownavigationblockoncoursepage'] = 'إظهار كتلة التنقل في صفحة المساق';
$string['shownavigationblockoncoursepagedesc'] = 'تعيينه لإظهار كتلة التنقل في صفحة المساق.';
$string['side-post1'] = 'شريط التمرير الجانبي في التذييل';
$string['sitetitle'] = 'عَرض عنوان الموقع';
$string['sitetitlecoursesdisabled'] = 'مُعطَّل - فقط أظهر عناوين المقررات الدراسية في صفحاتها';
$string['sitetitlecoursesenabled'] = 'مُمَكَّن - أظهر عنوان الموقع وعناوين المقررات الدراسية في صفحات المقررات الدراسية';
$string['sitetitlecustom'] = 'استعمال عنوان مخصص للموقع (أدخله في خانة \'sitetitletext\' أدناه)';
$string['sitetitledefault'] = 'استعمال عنوان موقع مودل (اسم الموقع)';
$string['sitetitledesc'] = 'عَرض العنوان الافتراضي لموقع مودل من <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">إعدادات صفحة الواجهة</a> أو أدخل عنوان مخصص للموقع في مربع النص أدناه.';
$string['sitetitleoff'] = 'تعطيل عنوان الموقع';
$string['sitetitletext'] = 'عنوان الموقع';
$string['slider2h3bgcolordesc'] = 'إختر لون الخلفية الذي تريده لوسم H3 في المنزلق 2.';
$string['slider2h4bgcolordesc'] = 'إختر لون الخلفية الذي تريده لوسم H4 في المنزلق 2.';
$string['slidercountdesc'] = 'إختر عدد الشرائح التي تريد إضافتها <strong>ثم انقر حفظ</strong> لتحميل حقول الإدخال';
$string['slideroption2a'] = 'لون الخلفية لسهم الخيار الثاني من أنماط المنزلق';
$string['slideroption2adesc'] = 'تعيين لون الخلفية لسهم الخيار الثاني من أنماط المنزلق.';
$string['slideroption2colordesc'] = 'تعيين لون الخلفية لنص التسليم لخيار نمط المنزلق.';
$string['slideroption2submitcolordesc'] = 'تعيين لون الخلفية لنص التسليم لخيار نمط المنزلق الثاني.';
$string['slidersubmitbgcolordesc'] = 'إختر لون الخلفية لزر التسليم في المنزلق 1.';
$string['slideshowdesc'] = 'إرفع الصور، أضف الروابط والوصف للدوار الذي يظهر في صفحة الواجهة.';
$string['slideshowsettingsheading'] = 'تخصيص الدوار الذي يظهر في صفحة الواجهة. أنظر التصميم <a href="./../theme/adaptable/pix/layout.png" target="_blank">هنا</a>';
$string['socialiconlistdesc'] = 'أدخل قائمة مفصولة بمحددات لتهيئة الأيقونات الاجتماعية أو الروابط التي تريدها مستعملاً الصيغة: الرابط|العنوان|الأيقونة.';
$string['socialpaddingsidedesc'] = 'هذا سيكون فراغًا ما بين الأيقونة وعنصر آخر أو الفراغ ما بين أيقونتين. أي أن الحاشية في الأيقونة  ستكون هذه القيمة مقسومة على 2. القيمة الافتراضية تتبع إرشادات العلامة التجارية في الانستغرام.';
$string['socialsize'] = 'تحديد حجم الخط لأيقونات التواصل الاجتماعي';
$string['socialtitledesc'] = 'يمكنك تعطيل مربع البحث الذي على امتداد الموقع وتمكين أيقونات/روابط التواصل الاجتماعي بدلاً عنه.<br/>لتهيئة الأيقونات، أدخل قائمة منها مفصولة بمحدد في حقل "قائمة الأيقونات الاجتماعية" أدناه.<br/>هذا ينبغي أن يكون بالصيغة الآتية:

رابط|عنوان|أيقونة

على سبيل المثال:
<pre>
https://example.com/course/search.php|البحث في مودل|fa-search
https://facebook.com/|فيسبوك|fa-facebook-square
https://twitter.com/|تويتر|fa-twitter-square
https://instagram.com|الانستغرام|fa-instagram
https://example.com|موقعي|fa-globe
</pre>
كمرجع، يمكنك معاينة القائمة الكاملة من أيقونات Font Awesome \'<a href="https://fortawesome.github.io/Font-Awesome/icons/">هنا</a>\'.';
$string['socialwallbackgroundcolor'] = 'لون الخلفية';
$string['socialwallbackgroundcolordesc'] = 'لون الخلفية لمساق بتنسيق \'الحائط الاجتماعي\'.';
$string['socialwallbordercolor'] = 'لون الإطار';
$string['socialwallbordercolordesc'] = 'لون إطار مقاطع \'الوسائط الاجتماعية\'';
$string['stickynavbar'] = 'شريط التنقل الدبق في الأعلى';
$string['tabbedlayoutcoursepage'] = 'تخطيط التبويب لصفحة المساق';
$string['tabbedlayoutcoursepagelink'] = 'رابط المساق لتخطيط التبويب في صفحة المساق';
$string['tabbedlayoutcoursepagelinkdesc'] = 'ليكن لديك تبويب يربطك رجوعاً إلى صفحة المساق ضمن تبويباته.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'لون التبويب المحدد لصفحة المساق';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'لون التبويب غير المحدد لصفحة المساق';
$string['tabbedlayoutdashboard'] = 'المخطط المبوب لصفحة لوحة التحكم';
$string['tabbedlayoutdashboardtab1condition'] = 'تقييد حقل الملف الشخصي المخصص للتبويب 1 (إختياري)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'إضافة قاعدة الوصول لعرض التبويب 1 باستعمال حقل الملف الشخصي المخصص، مثل: showtab1=true';
$string['tabbedlayoutdashboardtab2condition'] = 'تقييد حقل الملف الشخصي المخصص للتبويب 2 (إختياري)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'إضافة قاعدة الوصول لعرض التبويب 2 باستعمال حقل الملف الشخصي المخصص، مثل: showtab2=true';
$string['tabbedlayoutdashboardtabcolorselected'] = 'إختر لون التبويب للوحة التحكم';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'إختر لون أي تبويب آخر';
$string['tabbedlayouttablabelcourse'] = 'محتويات المقرر الدراسي';
$string['tabbedlayouttablabeldashboard'] = 'محتوى لوحة التحكم';
$string['tabbedlayouttablabeldashboard1'] = 'التبويب 2';
$string['tabbedlayouttablabeldashboard2'] = 'التبويب 2';
$string['targetnewwindow'] = 'نافذة جديدة';
$string['targetsamewindow'] = 'نفس النافذة';
$string['tickerdesc'] = 'هنا يمكنك تعيين مبرق أخبار لتشغيله عبر صفحة الواجهة لموقع مودل الخاص بك.
هو مقصود ليكون بمثابة بديل أقل إقحاماً من المنزلق الذي يشغل حيزًا صغيرًا جدًا.
لتهيئة المبرق، أدخل ببساطة قائمة الفقرات واجعلها متضمنة لأي روابط تحتاجها في النص.
<strong>ملاحظة:</strong> إذا تعذر تحميل مبرقك بشكل صحيح، قد بالتبديل إلى معاينة HTML وتأكد من أنه توجد لديك وسوم p فقط:
  <pre>
  &lt;p&gt;فقرة الأخبار الأولى.....&lt;/p&gt;
  &lt;p&gt;فقرة الأخبار الثانية.....&lt;/p&gt;
  </pre>';
$string['tickersettingsheading'] = 'تهيئة مبرق الأخبار في صفحة الواجهة. أنظر التصميم <a href="./../theme/adaptable/pix/layout.png" target="_blank">هنا</a>';
$string['tickertextprofilefield'] = 'اسم حقل الملف الشخصي المخصص=القيمة (إختياري)';
$string['tilesbordercolor'] = 'لون إطار مربعات المقررات الدراسية';
$string['toolsmenu2desc'] = 'يمكنك إعداد الروابط التي تظهر تحت قائمة الأدوات. يتكون كل سطر من نص القائمة، رابط (اختياري)، تلميح شاشة (اختياري)، ورمز اللغة أو مجموعة رموز مفصولة بفاصلة (اختياري، لإظهار السطر للغات المخصصة فقط)، مفصولة بعلامة الأنبوب. يمكنك التحكم بهيكل عناصر القائمة باستعمال \'-\'. مثال:<br/><pre>
مجتمع مودل|https://moodle.org
-الدعم المجاني لنظام مودل|https://moodle.org/support
-تطوير مودل|https://moodle.org/development
--توثيقات مودل|https://docs.moodle.org|توثيقات مودل
--توثيقات مودل باللغة الألمانية|https://docs.moodle.org/de|Documentation in German|de
Moodle.com|https://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'إضافة قائمة منسدلة إلى شريط التنقل الرئيسي';
$string['toolsmenufield'] = 'اسم حقل الملف الشخصي المخصص=القيمة (إختياري)';
$string['toolsmenuscountdesc'] = 'يضبط عدد أدوات القوائم التي تريد إضافتها إلى شريط التنقل الرئيسي';
$string['toolsmenutitle'] = 'عنوان قائمة الأدوات';
$string['toolsmenutitledesc'] = 'إضافة عنوان القائمة التي ترغب بعرضها في شريط التنقل الرئيسي.';
$string['topmenufontsize'] = 'حجم خط القائمة العلوية';
$string['topmenufontsizedesc'] = 'تعديل حجم الخط للقوائم العلوية';
$string['usernameposition'] = 'موضع اسم المستخدم';
$string['usernodescription'] = 'لم يقم المستخدم برفع وصفه بعد.';
