<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'no', version '4.0'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'F';
$string['Afull'] = 'Fraværende';
$string['Eacronym'] = 'G';
$string['Efull'] = 'Gyldig fravær';
$string['Lacronym'] = 'FS';
$string['Lfull'] = 'Forsent';
$string['Pacronym'] = 'T';
$string['Pfull'] = 'Tilstede';
$string['absenteereport'] = 'Fraværsrapport';
$string['acronym'] = 'Akronym';
$string['add'] = 'Legg til';
$string['addmultiplesessions'] = 'Legg til flere sesjoner';
$string['addsession'] = 'Legg til sesjoner';
$string['adduser'] = 'Legg til bruker';
$string['addwarning'] = 'Legg til anmerkning';
$string['all'] = 'Alle';
$string['allcourses'] = 'Alle kurs';
$string['allpast'] = 'Alle tidligere';
$string['allsessions'] = 'Alle sesjoner';
$string['attendance:addinstance'] = 'Legg til en ny aktivitet med fremmøte';
$string['attendance:canbelisted'] = 'Vises i klasselisten';
$string['attendance:changeattendances'] = 'Endre fremmøter';
$string['attendance:changepreferences'] = 'Endre innstillinger';
$string['attendance:export'] = 'Eksporter rapporter';
$string['attendance:manageattendances'] = 'Administrer fremmøter';
$string['attendance:managetemporaryusers'] = 'Administrere midlertidige brukere';
$string['attendance:takeattendances'] = 'Registrere fremmøte';
$string['attendance:view'] = 'Ser på fremmøter';
$string['attendance:viewreports'] = 'Ser på rapporter';
$string['attendance:viewsummaryreports'] = 'Vis oversiktsrapport for kurset';
$string['attendance:warningemails'] = 'Kan bli abbonnert på via e-post til fraværende brukere';
$string['attendance_already_submitted'] = 'Du kan ikke egenregistrere når det allerede er gjort.';
$string['attendance_no_status'] = 'Ingen gyldig status tilgjengelig - du er trolig for sent til å registrere fremmøte.';
$string['attendancedata'] = 'Oppmøtedata';
$string['attendancegrade'] = 'Oppmøtekarakter';
$string['attendancenotset'] = 'Du må registrere din tilstedeværelse';
$string['attendancenotstarted'] = 'Fremmøteregistrering har ikke startet ennå for dette kurset.';
$string['attendancepercent'] = 'Oppmøteprosent';
$string['attendancereport'] = 'Fremmøterapport';
$string['attendanceslogged'] = 'Fremmøte logget';
$string['attendancestaken'] = 'Fremmøte registrert';
$string['attendancesuccess'] = 'Føring av fremmøting gikk bra';
$string['attendanceupdated'] = 'Vellykket oppdatering av fraværskjema';
$string['attforblockdirstillexists'] = 'Den gamle mod/attforblock-mappen eksisterer fortsatt. Du må slette denne mappen før du kan kjøre denne oppgraderingen.';
$string['attrecords'] = 'Oppmøteoppføringer';
$string['autoassignstatus'] = 'Velg automatisk høyeste tilgjengelige status';
$string['autoassignstatus_help'] = 'Hvis denne er valgt, vil studenten automatisk bli tildelt høyest tilgjengelige karakter';
$string['automark'] = 'Automatisk registrering';
$string['automark_help'] = 'Tillater automatisk registrering av fremmøte. Hvis "Ja" vil studentene automatisk bli registrert som møtt avhengig av første tilgang til kurset. Hvis "Angi som fraværende når timen utløper" vil alle studenter som ikke har satt tilstedeværelse i løpet av timen bli satt som fraværende.';
$string['automarkall'] = 'Ja';
$string['automarkclose'] = 'Angi som ikke avmerket ved slutten av sesjonen';
$string['automarktask'] = 'Sjekk for fremmøtesesjoner som krever autoregistrering';
$string['autorecorded'] = 'Autoregistrert av systemet';
$string['averageattendance'] = 'Gjennomsnittlig frammøte';
$string['averageattendancegraded'] = 'Gjennomsnittlig frammøte';
$string['below'] = 'Under {$a}%';
$string['calclose'] = 'Lukk';
$string['calendarevent'] = 'Lag en kalenderoppføring for sesjonen';
$string['calendarevent_help'] = 'Hvis aktivert, vil det bli opprettet en kalenderoppføring for denne sesjonen. Hvis deaktivert vil eksisterende kalenderoppføringer bli slettet.';
$string['caleventcreated'] = 'Kalenderoppføring for sesjonen var vellykket';
$string['caleventdeleted'] = 'Kalenderoppføring for sesjonen er slettet';
$string['calmonths'] = 'januar, februar, mars, april, mai, juni, juli, august, september, oktober, november, desember';
$string['calshow'] = 'Velg dato';
$string['calweekdays'] = 'søn, man, tirs, ons, tors, fre, lør';
$string['cannottakeforgroup'] = 'Du kan ikke registrere oppmøte for gruppe "{$a}"';
$string['cantaddstatus'] = 'Du må angi et akronym og en beskrivelse når du legger til en ny status.';
$string['categoryreport'] = 'Kurskategorirapport';
$string['changeattendance'] = 'Endre oppmøte';
$string['changeduration'] = 'Endre varighet';
$string['changesession'] = 'Endre sesjon';
$string['checkweekdays'] = 'Velg ukedager som er innenfor dine valgte datoer.';
$string['column'] = 'kolonne';
$string['columns'] = 'kolonner';
$string['commonsession'] = 'Vanlig';
$string['commonsessions'] = 'Vanlige';
$string['confirm'] = 'Bekreft';
$string['confirmcolumnmappings'] = 'Bekreft kolonne-mappinger';
$string['confirmdeletehiddensessions'] = 'Er du sikker på at du vil slette {$a->count} sesjoner som er planlagt før kursets startdato ({$a->date})?';
$string['confirmdeleteuser'] = 'Er du sikker på at du vil slette brukeren \'{$a->fullname}\' ({$a->email})?<br/>All frammøteregistrering for denne brukeren vil da bli permanent slettet.';
$string['copyfrom'] = 'Kopier oppmøtedata fra';
$string['countofselected'] = 'Antall valgte';
$string['course'] = 'Kurs';
$string['coursesummary'] = 'Oversiktsrapport for kurs';
$string['createmultiplesessions'] = 'Opprett flere sesjoner';
$string['createmultiplesessions_help'] = 'Denne funksjonen lar deg opprette flere sesjoner på en gang.

  * <strong>Sesjonens startdato</strong>: Velg startdato for kurset ditt (den første dagen med oppmøte)
  * <strong>Sesjonens sluttdato</strong>: Velg sluttdato for kurset ditt (den siste dagen med oppmøte)
  * <strong>Dager</strong>: Velg hvilke ukedager kurset vil gå (f.eks. mandag/onsdag/fredag)
  * <strong>Frekvens</strong>: Denne innstillingen setter for ofte klassen vil møtes. Dersom det er hver uke, velg 1; dersom det er annenhver uke, velg 2; hver tredje uke, velg 3, osv.';
$string['createonesession'] = 'Opprett en sesjon for kurset';
$string['csvdelimiter'] = 'CSV skilletegn';
$string['date'] = 'Dato';
$string['days'] = 'Dag';
$string['defaultdisplaymode'] = 'Standard visningsmodus';
$string['defaults'] = 'Standarder';
$string['defaultsessionsettings'] = 'Standard sesjonsinnstillinger';
$string['defaultsessionsettings_help'] = 'Disse innstillingene definerer standardverdier for alle nye sesjoner';
$string['defaultsettings'] = 'Standard fremmøte-innstillinger';
$string['defaultsettings_help'] = 'Disse innstillingene definerer standardverdier for alle nye fremmøteregistreringer';
$string['defaultstatus'] = 'Standard status angitt';
$string['defaultsubnet'] = 'Standard ip-subnett';
$string['defaultsubnet_help'] = 'Registrering av fremmøte kan begrenses til bestemte ip-subnett. Du angir dem som en kommaseparert liste med delvis eller fulle ip-adresser. Dette er standardverdiene som brukes når nye sesjoner opprettes.';
$string['defaultview'] = 'Standardvisning ved innlogging';
$string['defaultview_desc'] = 'Dette er standardvisning for lærere ved første innlogging';
$string['defaultwarnings'] = 'Standardinnstillinger for varslinger er angitt';
$string['defaultwarningsettings'] = 'Standardinnstillinger for varslinger';
$string['defaultwarningsettings_help'] = 'Angir standardinnstillinger for alle nye varslinger';
$string['delete'] = 'Slett';
$string['deletedgroup'] = 'Gruppen som er koblet til denne sesjonen er slettet';
$string['deletehiddensessions'] = 'Vis alle skjulte sesjoner';
$string['deletelogs'] = 'Slett oppmøtedata';
$string['deleteselected'] = 'Slett valgte';
$string['deletesession'] = 'Slett sesjon';
$string['deletesessions'] = 'Slett alle sesjoner';
$string['deleteuser'] = 'Slett bruker';
$string['deletewarningconfirm'] = 'Er du sikker på at du vil slette denne varslingen?';
$string['deletingsession'] = 'Sletter sesjon i kurset';
$string['deletingstatus'] = 'Sletter status for kurset';
$string['description'] = 'Beskrivelse';
$string['display'] = 'Vis';
$string['displaymode'] = 'Visningsmodus';
$string['donotusepaging'] = 'Ikke bruk oppdeling i flere sider';
$string['downloadexcel'] = 'Last ned i Excel-format';
$string['downloadooo'] = 'Last ned i OpenOffice-format';
$string['downloadtext'] = 'Last ned i tekstformat';
$string['duration'] = 'Varighet';
$string['editsession'] = 'Endre sesjon';
$string['edituser'] = 'Rediger bruker';
$string['emailcontent'] = 'E-post innhold';
$string['emailsubject'] = 'E-post emnefelt';
$string['emailsubject_default'] = 'Fraværsvarsel';
$string['emailsubject_help'] = 'Når et varsel blir sendt til en student, vil den ta emneteksten fra dette feltet.';
$string['emailuser'] = 'Send e-post til bruker';
$string['emailuser_help'] = 'Hvis avmerket, vil et varsel bli sendt til studenten';
$string['emptyacronym'] = 'Tomme akronymer er ikke tillatt. Statusoppføringen er ikke oppdatert.';
$string['emptydescription'] = 'Tomme beskrivelser er ikke tillatt. Statusoppføringen er ikke oppdatert.';
$string['enablecalendar'] = 'Opprett kalenderoppføringer';
$string['endofperiod'] = 'Periodeslutt';
$string['endtime'] = 'Sesjonens avsluttes';
$string['enrolmentend'] = 'Brukerinnmeldinger slutter {$a}';
$string['enrolmentstart'] = 'Brukerinnmeldinger starter {$a}';
$string['enrolmentsuspended'] = 'Innmeldinger deaktiveres';
$string['errorgroupsnotselected'] = 'Velg en eller flere grupper';
$string['errorinaddingsession'] = 'Det skjedde en feil når du prøvde å legge til sesjoner';
$string['erroringeneratingsessions'] = 'Det skjedde en feil under genereringen av sesjoner';
$string['eventdurationupdated'] = 'Sesjonslengden er oppdatert';
$string['eventreportviewed'] = 'Fremmøterapport er vist';
$string['eventsessionadded'] = 'Sesjon lagt til';
$string['eventsessiondeleted'] = 'Sesjon slettet';
$string['eventsessionupdated'] = 'Sesjon oppdatert';
$string['eventstatusadded'] = 'Status lagt til';
$string['eventstatusupdated'] = 'Status oppdatert';
$string['eventtaken'] = 'Tilstedeværelse satt';
$string['eventtakenbystudent'] = 'Tilstedeværelse satt av studenten';
$string['export'] = 'Eksport';
$string['extrarestrictions'] = 'Ekstra restriksjoner';
$string['from'] = 'fra:';
$string['gradebookexplanation'] = 'Karakter i karakterbok';
$string['gradebookexplanation_help'] = 'Oppmøtemodulen viser din foreløpige oppmøtekarakter basert på antall poeng du har oppnådd sålangt og antall poeng som kunne oppnås. Den inkluderer ikke fremtidige sesjoner. I karakterboka vises oppmøtekarakteren din basert på oppmøteprosent og antall poeng som kan tjenes basert på hele perioden. Altså vil ikke oppmøtekarakteren din i karakterboka og i oppmøtemodulen vise samme poengsum, men de vil vise samme oppmøteprosent.

Hvis du for eksempel har fått 8 av 10 (80%) oppmøtepoeng så langt, og oppmøtet for hele kurset er verdt 50 poeng. Da vil oppmøtemodulen vise 8/10 og karakterboka 40/50. Du har ikke tjent 40 poeng ennå, men 40 er den tilsvarende verdien til din nåværende oppmøteprosent på 80%. Poengene som vises i oppmøtemodulen kan aldri synke siden de er basert på faktisk oppmøte, men poengene som vises i karakterboka kan synke avhengig av fremtidig fremmøte.';
$string['gridcolumns'] = 'Kolonner i rutenettet';
$string['groupsession'] = 'Gruppe';
$string['hiddensessions'] = 'Skjulte sesjoner';
$string['hiddensessions_help'] = 'Sesjoner skjules hvis de er eldre enn kursets startdato. Endre kursets startdato, og skjulte sesjoner vil vises.

Du kan bruke denne funksjonen for å skjule gamle sesjoner istedenfor å slette dem. Husk at det bare er synlige sesjoner som telles med i karakterboka.';
$string['hiddensessionsdeleted'] = 'Alle skjulte sesjoner er slettet';
$string['hidensessiondetails'] = 'Skjul sesjonsdetaljer';
$string['identifyby'] = 'Identifiser student ved';
$string['includeall'] = 'Velg alle sesjoner';
$string['includenottaken'] = 'Inkluder sesjoner uten oppmøte';
$string['includeremarks'] = 'Inkludér bemerkninger';
$string['incorrectpassword'] = 'Du har skrevet inn et ugyldig passord og tilstedeværelsen er ikke registrert. Vennligst bruk korrekt passord.';
$string['indetail'] = 'I detalj...';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Du må velge en handling';
$string['invalidsessionenddate'] = 'Denne datoen kan ikke være FØR sesjonsdatoen';
$string['invalidsessionendtime'] = 'Slutt-tiden må være senere enn start-tiden';
$string['invalidstatus'] = 'Du har valgt en ugyldig status, vennligst forsøk igjen';
$string['jumpto'] = 'Hopp til';
$string['maxpossible'] = 'Høyeste mulige';
$string['maxpossible_help'] = 'Viser skåringen for hver bruker hvis de får maks skår i hver av de gjenstående sesjonene (foregående og fremtidige):
    <ul>
    <li><strong>Poeng</strong>: Maksimum antall poeng hver bruker kan få over alle sesjonene.</li>
    <li><strong>Prosentandel</strong>: Maksimum prosentandel hver bruker kan få over alle sesjonene.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Maksimum mulige prosentandel';
$string['maxpossiblepoints'] = 'Maksimum mulige poeng';
$string['mergeuser'] = 'Slå sammen bruker';
$string['modulename'] = 'Oppmøte';
$string['modulename_help'] = 'Oppmøtemodulen lar læreren registrere fremmøte og lar eleven sjekke deres eget fravær.

Læreren kan opprette flere sesjoner og kan føre fremmøte som "Tilstede", "Fravær", "For sent", "Gyldig fravær" eller endre statusene for å passe deres behov.

Rapporter er tilgjengelige for hele klasser og individulle elever';
$string['modulenameplural'] = 'Oppmøtte';
$string['months'] = 'Måneder';
$string['moreattendance'] = 'Fremmøteregistreringen var vellykket for denne siden';
$string['moveleft'] = 'Flytt mot venstre';
$string['moveright'] = 'Flytt mot høyre';
$string['mustselectusers'] = 'Må velge brukere som skal eksporteres';
$string['newdate'] = 'Ny dato';
$string['newduration'] = 'Ny varighet';
$string['newstatusset'] = 'Nytt sett av statuser';
$string['noattendanceusers'] = 'Det er ikke mulig å eksportere noe data siden det ikke finnes studenter i dette kurset.';
$string['noattforuser'] = 'Intet oppmøte er registrert for brukeren';
$string['nodescription'] = 'Vanlig sesjon';
$string['nogroups'] = 'Du kan ikke legge til gruppesesjoner. Det fins ingen grupper i kurset.';
$string['noguest'] = 'Gjester kan ikke se fraværsskjemaet.';
$string['noofdaysabsent'] = 'Antall fraværsdager';
$string['noofdaysexcused'] = 'Antall meldte fraværsdager';
$string['noofdayslate'] = 'Antall forsentkomninger';
$string['noofdayspresent'] = 'Antall dager med oppmøte';
$string['nosessiondayselected'] = 'Ikke valgt noen dag for sesjonen';
$string['nosessionexists'] = 'Det fins ingen sesjoner for dette kurset';
$string['nosessionsselected'] = 'Ingen sesjoner valgt';
$string['notfound'] = 'Ingen oppmøteaktiviteter funnet i dette kurset';
$string['notmember'] = 'ikke&nbsp;medlem';
$string['noupgradefromthisversion'] = 'Oppmøtemodulen kan ikke oppdateres fra version for attforblock du har installert. - Vennligst slett attforblock eller oppdater den til den siste versjonen før du installerer den nye oppmøtemodulen';
$string['olddate'] = 'Gammel dato';
$string['onlyselectedusers'] = 'Eksportér bestemte brukere';
$string['overallsessions'] = 'Over alle sesjoner';
$string['overallsessions_help'] = 'Vis statistikk for alle sesjoner inkludert de som ikke er gjennomført ennå (foregående og fremtidige):
    <ul>
    <li><strong>Sesjoner</strong>: Totalt antall sesjoner.</li>
    <li><strong>Poeng</strong>: Poeng tildelt basert på gjennomførte sesjoner.</li>
    <li><strong>Prosentandel</strong>: Prosentandel av poeng tildelt over maksimum mulige poeng om alle sesjoner var tatt.</li>
    </ul>';
$string['oversessionstaken'] = 'Over gjennomførte sesjoner';
$string['oversessionstaken_help'] = 'Viser statistikk for sesjoner hvor fremmøteregistrering er gjort:
    <ul>
    <li><strong>Sesjoner</strong>: Antall gjennomførte sesjoner.</li>
    <li><strong>Poeng</strong>: Poeng tildelt på gjennomførte sesjoner.</li>
    <li><strong>Prosentandel</strong>: Prosentandel av poeng opp mot maksimum mulige poeng over alle gjennomførte sesjoner.</li>
    </ul>';
$string['participant'] = 'Deltaker';
$string['password'] = 'Passord';
$string['passwordgrp'] = 'Studentpassord';
$string['passwordgrp_help'] = 'Hvis angitt må studenter skrive inn dette passordet før de kan registrere eget fremmøte for sesjonen. Hvis tom, kreves det ikke noe passord.';
$string['passwordrequired'] = 'Du må skrive inn sesjonspassordet før du kan registrere ditt fremmøte';
$string['percentage'] = 'Prosentandel';
$string['percentageallsessions'] = 'Prosentandel over alle sesjoner';
$string['percentagesessionscompleted'] = 'Prosentandel over gjennomførte sesjoner';
$string['pluginadministration'] = 'Administrer fremmøte';
$string['pluginname'] = 'Fremmøte';
$string['points'] = 'Poeng';
$string['pointsallsessions'] = 'Poeng over alle sesjoner';
$string['pointssessionscompleted'] = 'Poeng over alle gjennomførte sesjoner';
$string['priorto'] = 'Sesjonsdatoen er før kursets startdato ({$a}), og sesjonsdatoer angitt før kursets startdato vil automatisk bli skjult og ikke tilgjengelig. Du kan endre kursets startdato når som helst (Se i kursets innstillinger) for å få tilgang til slike skjulte sesjoner. <br><br>Vennligst endre sesjonsdatoen eller klikk på "Legg til sesjon" en gang til for å bekrefte?';
$string['randompassword'] = 'Tilfeldig passord';
$string['remark'] = 'Bemerkning for: {$a}';
$string['remarks'] = 'Merknader';
$string['repeatasfollows'] = 'Gjenta sesjonen over som følger';
$string['repeatevery'] = 'Gjenta hver';
$string['repeaton'] = 'Gjenta på';
$string['repeatuntil'] = 'Gjenta inntil';
$string['report'] = 'Rapporter';
$string['required'] = 'Påkrevd*';
$string['requiredentries'] = 'Midlertidige oppføringer overskriver deltakernes fremmøteregistreringer';
$string['requiredentry'] = 'HJelp-guide for sammenslåing av midlertidige brukere';
$string['requiredentry_help'] = '<p align="center"><b>Fremmøte</b></p>
<p align="left"><strong>Slå sammen kontoer</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle-bruker</th>
<th>Midlertidig bruker</th>
<th>Handling</th>
</tr>
<tr>
<td>Fremmøtedata</td>
<td>Fremmøtedata</td>
<td>Midlertidig bruker vil overskrive Moodle-bruker</td>
</tr>
<tr>
<td>Ingen fremmøtedata</td>
<td>Fremmøtedata</td>
<td>Midlertidig brukers fremmøte vil bli overført til Moodlebruker</td>
</tr>
<tr>
<td>Fremmøtedata</td>
<td>Ingen fremmøtedata</td>
<td>Midlertidig bruker vil bli slettet</td>
</tr>
<tr>
<td>Ingen fremmøtedata</td>
<td>Ingen fremmøtedata</td>
<td>Midlertidig bruker vil bli slettet</td>
</tr>
</table>

</p>
<p align="left"><strong>Midlertidig bruker vil bli slettet i alle tilfeller etter at sammenslåingen er fullført.</strong></p>';
$string['requiresubnet'] = 'Studenter kan bare registrere eget fremmøte fra disse datamaskinene.';
$string['requiresubnet_help'] = 'Fremmøteregistrering kan avgrenses til bestemte ip-subnett som angis som en kommaseparert liste med enten delvise eller fulle ip-adresser.';
$string['resetdescription'] = 'Husk at sletting av fraværsdata vil slette informasjon fra databasen. Du kan skjule gamle sesjoner ved å endre kursets startdato';
$string['resetstatuses'] = 'Gjenopprett statusene til standard';
$string['restoredefaults'] = 'Gjenopprett standarder';
$string['resultsperpage'] = 'Resultater pr. side';
$string['resultsperpage_desc'] = 'Antall studenter pr. side';
$string['save'] = 'Lagre oppmøte';
$string['search:activity'] = 'Fremmøteregistrering - aktivitetsinformasjon';
$string['session'] = 'Sesjon';
$string['session_help'] = 'Sesjon';
$string['sessionadded'] = 'Sesjonen ble lagt til';
$string['sessionalreadyexists'] = 'Det fins allerede en sesjon for denne datoen';
$string['sessiondate'] = 'Sesjonsdato';
$string['sessiondays'] = 'Sesjonsdager';
$string['sessiondeleted'] = 'Sesjonen ble slettet';
$string['sessionexist'] = 'Sesjonen ble ikke lagt til (den fins allerede)';
$string['sessiongenerated'] = 'Genereringen av sesjonen var vellykket';
$string['sessions'] = 'Sesjoner';
$string['sessionscompleted'] = 'Gjennomførte sesjoner';
$string['sessionsgenerated'] = 'Genereringen av sesjoner var vellykket';
$string['sessionsids'] = 'SesjonsID:';
$string['sessionsnotfound'] = 'Det er ingen sesjoner i det valgte tidsrommet';
$string['sessionstartdate'] = 'Sesjonens startdato';
$string['sessionstotal'] = 'Totalt antall sesjoner';
$string['sessiontype'] = 'Sesjonstype';
$string['sessiontype_help'] = 'Det er to typer sesjoner: vanlige og grupper. Muligheten for å legge til de ulike typene avhenger av aktivitetens gruppeinnstilling.

* I gruppemodus "Ingen grupper" kan du bare legge til vanlige sesjoner.
* I gruppemodus "Synlige grupper" kan du legge til både vanlige og gruppesesjoner
* I gruppemodus "Separate grupper" kan du bare legge til gruppesesjoner.';
$string['sessiontypeshort'] = 'Type';
$string['sessionupdated'] = 'Sesjonen ble oppdatert';
$string['set_by_student'] = 'Egenregistrert';
$string['setallstatuses'] = 'Angi status for alle brukere';
$string['setallstatusesto'] = 'Set status for alle brukere til "{$a}"';
$string['settings'] = 'Innstillinger';
$string['showdefaults'] = 'Vis standarder';
$string['showduration'] = 'Vis varighet';
$string['showsessiondetails'] = 'Vis sesjonsdetaljer';
$string['somedisabledstatus'] = '(Noen valg kan være fjernet siden sesjonen har startet.)';
$string['sortedgrid'] = 'Sortert rutenett';
$string['sortedlist'] = 'Sortert liste';
$string['startofperiod'] = 'Periodestart';
$string['status'] = 'Status';
$string['statusdeleted'] = 'Status slettet';
$string['statuses'] = 'Statuser';
$string['statusset'] = 'Status satt {$a}';
$string['statussetsettings'] = 'Status satt';
$string['strftimedm'] = '%d.%m.';
$string['strftimedmy'] = '%d.%m.%Y';
$string['strftimedmyhm'] = '%d.%m.%Y %H.%M';
$string['strftimedmyw'] = '%d.%m.%y (%a)';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%H:%M';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentavailability'] = 'Tilgjengelig for studenter (i minutter)';
$string['studentavailability_help'] = 'Når studenter registrerer eget fremmøte, er dette antall minutter som registrering er mulig etter at sesjonen har startet.
<br />Hvis tom, vil statusen alltid være tilgjengelig. Hvis angitt som -0- vil den alltid være skjult for studenter.';
$string['studentid'] = 'Student ID';
$string['studentpassword'] = 'Studentpassord';
$string['studentscanmark'] = 'Tillat at studentene registrerer eget fremmøte';
$string['studentscanmark_desc'] = 'Hvis avmerket, vil lærere kunne tillate at studenter registrerer eget fremmøte.';
$string['studentscanmark_help'] = 'Hvis avmerket, vil studenter kunne endre egen fremmøtestatus for sesjonen.';
$string['studentscanmarksessiontime'] = 'Studenter kan registrere fremmøte mens sesjonen pågår';
$string['studentscanmarksessiontime_desc'] = 'Hvis avmerket vil studenter bare kunne registrere fremmøte mens sesjonen pågår.';
$string['studentscanmarksessiontimeend'] = 'Sesjonsvarighet (i minutter)';
$string['studentscanmarksessiontimeend_desc'] = 'Hvis sesjonen ikke har noen angitt slutt-tid, hvor lenge skal sesjonen være tilgjengelig slik at studentene kan registrere eget fremmøte.';
$string['submitattendance'] = 'Send inn fremmøte';
$string['subnetwrong'] = 'Fremmøte kan bare registreres fra bestemte lokasjoner, og denne datamaskinen står ikke på tillatt-lista.';
$string['summary'] = 'Oppsummering';
$string['tablerenamefailed'] = 'Forsøket på å gi nytt navn til den gamle attforblock tabellen mislyktes';
$string['tactions'] = 'Handling';
$string['takeattendance'] = 'Bli med';
$string['takensessions'] = 'Gjennomførte sesjoner';
$string['tcreated'] = 'Opprettet';
$string['tempaddform'] = 'Legg til midlertidig bruker';
$string['tempexists'] = 'Det finnes allerede en midlertidig bruker med denne e-postadressen';
$string['temptable'] = 'Liste over midlertidige brukere';
$string['tempuser'] = 'Midlertidig bruker';
$string['tempusermerge'] = 'Slå sammen midlertidig bruker';
$string['tempusers'] = 'Midlertidige brukere';
$string['tempusersedit'] = 'Endre midlertidig bruker';
$string['tempuserslist'] = 'Midlertidige brukere';
$string['thiscourse'] = 'Dette kurset';
$string['time'] = 'Tid';
$string['timeahead'] = 'Multiple sesjoner som går utover ett år kan ikke opprettes. Vennligst juster start- og sluttdatoer.';
$string['to'] = 'til:';
$string['tuseremail'] = 'E-post';
$string['tusername'] = 'Fullt navn';
$string['unknowngroup'] = 'Ukjent gruppe';
$string['update'] = 'Oppdater';
$string['userexists'] = 'Det er allerede en virkelig brukerkonto med denne e-postadressen';
$string['users'] = 'Brukere som skal eksporteres';
$string['usestatusset'] = 'Status angitt';
$string['variable'] = 'variabel';
$string['variablesupdated'] = 'Variablene ble oppdatert';
$string['versionforprinting'] = 'Utskriftsversjon';
$string['viewmode'] = 'Visningsmodus';
$string['week'] = 'uke(r)';
$string['weeks'] = 'Uker';
$string['youcantdo'] = 'Du kan ikke gjøre noe som helst';
