<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'sk', version '4.0'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Riadenie prístupu';
$string['actionaftercorrectanswer'] = 'Činnosť po správnej odpovedi';
$string['actionaftercorrectanswer_help'] = 'Po správnom zodpovedaní otázky existujú 3 možnosti pre nasledujúcu stránku:

* Normálna- postupujte podľa lekcie
* Zobraziť nevidenú stránku - stránky sa zobrazujú v náhodnom poradí a žiadna stránka sa nezobrazí dvakrát
* Zobraziť nezodpovedanú stránku - stránky sa zobrazujú v náhodnom poradí a znova sa zobrazia stránky s nezodpovedanými otázkami';
$string['actions'] = 'Činnosti';
$string['activitylink'] = 'Odkaz na ďalšiu aktivitu';
$string['activitylink_help'] = 'Ak chcete na konci lekcie uviesť odkaz na inú aktivitu v kurze, vyberte aktivitu z rozbaľovacej ponuky.';
$string['activitylinkname'] = 'Prejsť na {$a}';
$string['activityoverview'] = 'Máte prednášky, ktoré majú byť ukončené';
$string['addabranchtable'] = 'Pridajte stránku s obsahom';
$string['addanendofbranch'] = 'Pridajte koniec vetvenia.';
$string['addanewpage'] = 'Pridať novú stranu.';
$string['addaquestionpage'] = 'Pridať stránku s otázkami.';
$string['addaquestionpagehere'] = 'Pridať stránku s otázkami sem.';
$string['addbranchtable'] = 'Pridať stránku s obsahom.';
$string['addcluster'] = 'Pridať skupinu.';
$string['addedabranchtable'] = 'Pridaná stránka s obsahom';
$string['addedanendofbranch'] = 'Pridaný koniec časti';
$string['addedaquestionpage'] = 'Pridaná stránka s otázkami';
$string['addedcluster'] = 'Bolo pridané zoskupenie stránok';
$string['addedendofcluster'] = 'Bol pridaný koniec zoskupenia stránok';
$string['addendofbranch'] = 'Pridať koniec vetvenia';
$string['addendofcluster'] = 'Pridať koniec zoskupenia stránok';
$string['addessay'] = 'Vytvoriť stránku pre otázku Esej';
$string['addmatching'] = 'Vytvoriť stránku pre otázku Párovanie (angl. Matching)';
$string['addmultichoice'] = 'Vytvoriť stránku pre otázku Viaceré možnosti';
$string['addnewgroupoverride'] = 'Pridať prednastavenie skupiny';
$string['addnewuseroverride'] = 'Pridať prednastavenie používateľa';
$string['addnumerical'] = 'Vytvoriť stránku pre Numerickú otázku';
$string['addpage'] = 'Pridať stránku';
$string['addshortanswer'] = 'Vytvoriť stránku pre otázku Krátka odpoveď';
$string['addtruefalse'] = 'Vytvoriť stránku pre otázku Pravda/Nepravda';
$string['allotheranswers'] = 'Všetky ostatné odpovede';
$string['allotheranswersjump'] = 'Skoky všetkých ostatných odpovedí';
$string['allotheranswersscore'] = 'Bodové hodnotenie všetkých ostatných odpovedí';
$string['allowofflineattempts'] = 'Povoliť absolvovanie prednášky offline pomocou mobilnej aplikácie';
$string['allowofflineattempts_help'] = 'Ak je táto možnosť povolená, používateľ mobilnej aplikácie si môže stiahnuť lekciu a pokúsiť sa ju urobiť offline. Všetky možné odpovede a správne odpovede budú taktiež stiahnuté. Poznámka: Nie je možné prejsť lekciu offline, ak má nastavený časový limit.';
$string['anchortitle'] = 'Začiatok obsahu stránky';
$string['and'] = 'A';
$string['answer'] = 'Odpoveď';
$string['answeredcorrectly'] = 'zodpovedaná správne.';
$string['answersfornumerical'] = 'Odpovede na numerické otázky by mali spĺňať podmienku dvojice minimálnych a maximálnych hodnôt';
$string['arrangebuttonshorizontally'] = 'Usporiadať tlačidlá obsahu vodorovne?';
$string['attempt'] = 'Pokus: {$a}';
$string['attemptheader'] = 'Pokus';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Pokusy';
$string['attemptsdeleted'] = 'Vymazané pokusy';
$string['attemptsremaining'] = 'Zbývajúci počet pokusov: {$a}';
$string['available'] = 'Dostupné od';
$string['averagescore'] = 'Priemerné skóre';
$string['averagetime'] = 'Priemerný čas';
$string['branch'] = 'Obsah';
$string['branchtable'] = 'Obsah';
$string['cachedef_overrides'] = 'Informácie o prenastavení používateľa a skupiny';
$string['cancel'] = 'Zrušiť';
$string['cannotfindanswer'] = 'Chyba: nie je možné nájsť odpoveď';
$string['cannotfindattempt'] = 'Chyba: nie je možné nájsť pokus';
$string['cannotfindessay'] = 'Chyba: nie je možné nájsť esej';
$string['cannotfindfirstgrade'] = 'Chyba: Nedá sa nájsť hodnotenie';
$string['cannotfindfirstpage'] = 'Nie je možné nájsť prvú stranu';
$string['cannotfindgrade'] = 'Chyba: Nedá sa nájsť hodnotenie';
$string['cannotfindnewestgrade'] = 'Chyba: Nedá sa nájsť najnovšie hodnotenie';
$string['cannotfindnextpage'] = 'Zálohovanie prednášky : Ďalšia stránka sa nenašla!';
$string['cannotfindpagerecord'] = 'Pridajte koniec vetvy: Záznam stránky nebol nájdený';
$string['cannotfindpages'] = 'Nepodarilo sa nájsť stránky prednášky';
$string['cannotfindpagetitle'] = 'Potvrdiť odstránenie: názov stránky sa nenašiel';
$string['cannotfindpreattempt'] = 'Predchádzajúci záznam o pokuse sa nepodarilo nájsť!';
$string['cannotfindrecords'] = 'Chyba: Nedajú sa nájsť záznamy prednášky';
$string['cannotfindtimer'] = 'Chyba: Nedajú sa nájsť záznamy časomier prednášky';
$string['cannotfinduser'] = 'Chyba: Nedajú sa nájsť používatelia';
$string['canretake'] = '{$a}  môže absolvovať prednášku znovu';
$string['casesensitive'] = 'Použite stále výrazy';
$string['casesensitive_help'] = 'Ak chcete použiť regulárne výrazy pre analýzu reakcií, začiarknite toto políčko .';
$string['checkbranchtable'] = 'Skontrolovať stránku s obsahom';
$string['checkedthisone'] = 'Skontrolované toto.';
$string['checknavigation'] = 'Kontrola navigácie';
$string['checkquestion'] = 'Kontrolná otázka';
$string['classstats'] = 'Štatistika triedy';
$string['clicktodownload'] = 'Kliknite na nasledovný link pre stiahnutie súboru.';
$string['closebeforeopen'] = 'Túto prednášku nie je možné aktualizovať. Určili ste skorší dátum uzavretia, ako je dátum otvorenia.';
$string['cluster'] = 'Zoskupenie';
$string['clusterjump'] = 'Neprezretá otázka v rámci zoskupenia';
$string['clustertitle'] = 'Zoskupenie';
$string['collapsed'] = 'Zoznam stránok';
$string['comments'] = 'Vaše komentáre';
$string['completed'] = 'Dokončené';
$string['completederror'] = 'Dokončite prednášku';
$string['completethefollowingconditions'] = 'Ak chcete pokračovať, musíte najprv splniť nasledujúcu/e podmienku/-y u prednášky <b>{$a}</b>:';
$string['completiondetail:reachend'] = 'Prejsť aktivitou až do konca';
$string['completiondetail:timespent'] = 'V tejto aktivite musíte stráviť aspoň {$a}';
$string['completionendreached'] = 'Vyžadovať dokončenie';
$string['completionendreached_desc'] = 'Študent musí dôjsť na koniec stránky s prednáškou, aby splnil túto aktivitu.';
$string['completiontimespent'] = 'Študent musí vykonať túto aktivitu aspoň na';
$string['completiontimespentdesc'] = 'študent musí robiť aktivitu aspoň {$a}';
$string['completiontimespentgroup'] = 'Vyžadovať čas strávený štúdiom';
$string['conditionsfordependency'] = 'Kritériá pre závislosti';
$string['configintro'] = 'Tu nastavené hodnoty definujú predvolené hodnoty, ktoré sa používajú vo formulári nastavení pri vytváraní novej prednášky. Nastavenia zadané ako rozšírené sa zobrazia iba po kliknutí na odkaz „Zobraziť viac ...“.';
$string['configmaxanswers'] = 'Predvolený maximálny počet odpovedí na stránku';
$string['configmediaclose'] = 'Zobrazuje tlačidlo Zavrieť ako časť vyskakovacieho okna vytvoreného pre odkazovaný mediálny súbor';
$string['configmediaheight'] = 'Nastavuje výšku vyskakovacieho okna pre odkazovaný mediálny súbor';
$string['configmediawidth'] = 'Nastavuje šírku vyskakovacieho okna pre odkazovaný mediálny súbor';
$string['configpassword_desc'] = 'Či je pre prístup k prednáške potrebné heslo.';
$string['configslideshowbgcolor'] = 'Farba pozadia pre prezentácie, ak sú povolené';
$string['configslideshowheight'] = 'Nastavuje výšku pre prezentáciu, ak je povolená';
$string['configslideshowwidth'] = 'Nastavuje šírku pre prezentáciu, ak je povolená';
$string['configtimelimit_desc'] = 'Ak je nastavený časový limit, na začiatku prednášky sa zobrazí varovanie a odpočítavacie hodiny. Ak je nastavená na nulu, potom neexistuje žiadny časový limit.';
$string['confirmdelete'] = 'Odstrániť stránku';
$string['confirmdeletionofthispage'] = 'Potvrdiť vymazanie tejto stránky';
$string['congratulations'] = 'Blahoželáme - dosiahli ste koniec prednášky';
$string['continue'] = 'Pokračovať';
$string['continuetoanswer'] = 'Pokračovať pre zmenu odpovedí.';
$string['continuetonextpage'] = 'Pokračovať na ďalšiu stránku.';
$string['correctanswerjump'] = 'Skon na správnu odpoveď';
$string['correctanswerscore'] = 'Skóre správnych otázok';
$string['correctresponse'] = 'Správna odpoveď';
$string['createaquestionpage'] = 'Vytvoriť stránku s otázkou';
$string['credit'] = 'Kredit';
$string['customscoring'] = 'Používateľské bodovanie';
$string['customscoring_help'] = 'Ak je povolené, potom každá odpoveď môže byť daná číselnou bodovou hodnotou (kladnou alebo zápornou).';
$string['deadline'] = 'Uzávierka (najneskorší termín)';
$string['defaultessayresponse'] = 'Vaša úloha (esej) bude oznámkovaná inštruktorom kurzu.';
$string['deleteallattempts'] = 'Vymazať všetky pokusy v prednáškach';
$string['deletedefaults'] = 'Odstránené východzie nastavenia prednášky (počet odstránených nastavení: {$a})';
$string['deletedpage'] = 'Odstránená stránka';
$string['deletepagenamed'] = 'Vymazať stránku: {$a}';
$string['deleting'] = 'Odstraňuje sa';
$string['deletingpage'] = 'Odstraňuje sa stránka: {$a}';
$string['dependencyon'] = 'Závisí na';
$string['dependencyon_help'] = 'Toto nastavenie povoľuje, aby prístup k tejto prednáške závisel od výkonu študenta v inej prednáške v tomto kurze. Môže byť použitá ľubovoľná kombinácia stráveného času, absolvovania, hodnotenia "viac ako".';
$string['description'] = 'Opis';
$string['deselectallattempts'] = 'Zrušte výber všetkých pokusov';
$string['detailedstats'] = 'Detailná štatistika';
$string['didnotanswerquestion'] = 'Neodpovedal(a) na túto otázku';
$string['didnotreceivecredit'] = 'Odpoveď nezapočítaná ako správna';
$string['disabled'] = 'Zakázaná';
$string['displaydefaultfeedback'] = 'Zobraziť východziu reakciu';
$string['displaydefaultfeedback_help'] = 'Ak je toto povolené, potom keď študent neodpovie na zadanú otázku, bude vo východzom nastavení odpoveď "Toto je správna odpoveď" alebo "Toto je nesprávna odpoveď".';
$string['displayinleftmenu'] = 'Zobraziť v menu?';
$string['displayleftif'] = 'Zobraziť menu iba iba ak má skóre vyššie ako:';
$string['displayleftif_help'] = 'Nastavenie určuje, či študent musí získať určité hodnotenie predtým, ako si môže prezrieť ponuku prednášok. Nastavenie prinúti študenta prejsť celou prednáškou na prvý pokus a potom po získaní požadovaného hodnotenia si môže prezrieť (ďalšiu) ponuku.';
$string['displayleftmenu'] = 'Zobraziť menu';
$string['displayleftmenu_help'] = 'Ak je povolená, zobrazí sa ponuka umožňujúca používateľom prechádzať zoznamom stránok.';
$string['displayofgrade'] = 'Zobrazenie známok (len pre študentov)';
$string['displayreview'] = 'Zobraziť tlačidlo pre opätovný pokus';
$string['displayreview_help'] = 'Ak je táto možnosť povolená, študentovi sa pri nesprávnej odpovedi na otázku poskytne možnosť vyskúšať si ju znova bez bodového kreditu alebo pokračovať v prednáške. Ak študent klikne a prejde na inú otázku, bude nasledovať vybraná (nesprávna) odpoveď. V predvolenom nastavení sú skoky s nesprávnou odpoveďou nastavené na „túto stránku“ a majú skóre 0, preto sa odporúča nastaviť skok so nesprávnou odpoveďou na inú stránku, aby nedošlo k zámene so študentmi.';
$string['displayscorewithessays'] = 'Dosiahli ste {$a->score} z {$a->tempmaxgrade} v automaticky známkovaných otázkach.<br>Vaše {$a->essayquestions} otázky typu esej budú oznámkované a pridané <br />do Vášho celkového skóre neskôr.<br /><br />Vaša aktuálna známka bez otázok typu esej k úlohe je {$a->score} z {$a->grade}';
$string['displayscorewithoutessays'] = 'Vaše skóre je {$a->score} (z {$a->grade}).';
$string['duplicatepagenamed'] = 'Zduplikuj stránku : {$a}';
$string['edit'] = 'Upraviť';
$string['editbranchtable'] = 'Edituj stránku s obsahom';
$string['editcluster'] = 'Edituj zoskupenie';
$string['editendofbranch'] = 'Edituj koniec rozvetvenej stránky';
$string['editendofcluster'] = 'Edituj koniec zoskupenia';
$string['editessay'] = 'Edituj stránku otázky typu esej';
$string['editinglesson'] = 'Úpravy prednášky';
$string['editingquestionpage'] = 'Úprava {$a} stránky otázky';
$string['editlesson'] = 'Upraviť prednášku';
$string['editlessonsettings'] = 'Upraviť nastavenia prednášky';
$string['editmatching'] = 'Editovanie stránky s otázkou Párovanie';
$string['editmultichoice'] = 'Editovanie stránky s otázkou Viaceré možnosti';
$string['editnumerical'] = 'Editovanie stránky s numerickou otázkou';
$string['editoverride'] = 'Editovať prestavenie';
$string['editpage'] = 'Upraviť obsah stránky';
$string['editpagecontent'] = 'Upraviť obsahy stránky';
$string['editquestion'] = 'Editovanie stránky s otázkou';
$string['editshortanswer'] = 'Editovanie stránky s otázkou typu krátka odpoveď';
$string['edittruefalse'] = 'Editovanie stránky s otázkou Áno/nie';
$string['email'] = 'Poslať emailom';
$string['emailallgradedessays'] = 'Poslať emailom VŠETKY oznámkované úlohy';
$string['emailgradedessays'] = 'Poslať emailom oznámkované úlohy';
$string['emailsuccess'] = 'Odoslanie emailov bolo úspešné';
$string['emptypassword'] = 'Heslo nemôže byť prázdne';
$string['enabled'] = 'Povolená';
$string['endofbranch'] = 'Koniec rozvetvenia';
$string['endofcluster'] = 'Koniec zoskupenia';
$string['endofclustertitle'] = 'Koniec zoskupenia';
$string['endoflesson'] = 'Koniec prednášky';
$string['enteredthis'] = 'vložil toto.';
$string['enterpassword'] = 'Prosím, vložte svoje heslo:';
$string['eolstudentoutoftime'] = 'Upozornenie: Prekročili ste čas určený pre túto prednášku. Vaša posledná odpoveď nemusela byť započítaná, ak bola zodpovedaná až po vypršaní časového limitu.';
$string['eolstudentoutoftimenoanswers'] = 'Nezodpovedali ste žiadne otázky. Za túto prednášku teda nezískavate žiaden bod.';
$string['essay'] = 'Úloha';
$string['essayemailmessage2'] = '<p>Výzva na odovzdanie eseje:<blockquote>{$a->question}</blockquote></p><p>Vaša odpoveď:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentáre hodnotiteľa:<blockquote><em>{$a->comment}</em></blockquote></p><p>Dostali ste {$a->earned} bodov z {$a->outof} za túto esej.</p><p>Vaše hodnotenie za prednášku sa zmenilo na {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Získali ste  {$a->earned} z {$a->outof} ta túto otázku typu esej.</p><p> Vaše hodnotenie za prednášku {$a->lesson} sa zmenilo na {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Známka za otázku prednášky';
$string['essaynotgradedyet'] = 'Esej ešte nebola oznámkovaná';
$string['essayresponses'] = 'Odpovede na esej';
$string['essays'] = 'Úlohy';
$string['essayscore'] = 'Skóre za úlohu';
$string['eventcontentpageviewed'] = 'Zobrazená stránka obsahu';
$string['eventessayassessed'] = 'Esej hodnotená';
$string['eventessayattemptviewed'] = 'Pokus o vytvorenie eseje prezeraný';
$string['eventhighscoreadded'] = 'Najvyšší počet bodov prednášky pridaný';
$string['eventhighscoresviewed'] = 'Najvyššie počty bodov prednášky prezerané';
$string['eventlessonended'] = 'Prednáška ukončená';
$string['eventlessonrestarted'] = 'Prednáška reštartovaná';
$string['eventlessonresumed'] = 'Lekcia pokračuje';
$string['eventlessonstarted'] = 'Prednáška začatá';
$string['eventoverridecreated'] = 'Vytvorené prednastavenie lekcie';
$string['eventoverridedeleted'] = 'Odstránené prednastavenie lekcie';
$string['eventoverrideupdated'] = 'Aktualizované prednastavenie lekcie';
$string['eventpagecreated'] = 'Stránka vytvorená';
$string['eventpagedeleted'] = 'Stránka vymazaná';
$string['eventpagemoved'] = 'Stránka presunutá';
$string['eventpageupdated'] = 'Stránka aktualizovaná';
$string['eventquestionanswered'] = 'Otázka zodpovedaná';
$string['eventquestionviewed'] = 'Otázka prezretá';
$string['false'] = 'Nie';
$string['fileformat'] = 'Formát súboru';
$string['finalwrong'] = 'Nie úplne.';
$string['finish'] = 'Skončiť';
$string['firstanswershould'] = 'Prvá odpoveď by mala skočiť na "Správnu stránku"';
$string['firstwrong'] = 'Bohužiaľ, keďže Vaša odpoveď nebola správna, nezískavate žiaden bod. Chcete sa ešte pokúsiť odhadnúť odpoveď, ale už len zo svojej vlastnej iniciatívy (nie pre získanie bodov)?';
$string['flowcontrol'] = 'Kontrola prechodu stránok';
$string['fractionsaddwrong'] = 'Kladné známky, ktoré ste uviedli nemajú súčet 100% <br />ale ich súčet je {$a}% <br />Chcete ísť späť a opraviť túto otázku?';
$string['fractionsnomax'] = 'Jedna z odpovedí musí byť 100%, aby bolo <br />možné získať plný počet za túto otázku. <br />Chcete ísť späť a opraviť túto otázku?';
$string['full'] = 'Obsah stránok';
$string['general'] = 'Všeobecný';
$string['gotoendoflesson'] = 'Ísť na koniec prednášky';
$string['grade'] = 'Známkovať';
$string['gradebetterthan'] = 'Známka lepšia ako (&#37;)';
$string['gradebetterthanerror'] = 'Dosiahnuť viac ako {$a} percent z celkovej známky';
$string['graded'] = 'Hodnotené';
$string['gradeessay'] = 'Známkovať otázky k úlohe ({$a->notgradedcount} neoznámkované a {$a->notsentcount} neodoslané)';
$string['gradeis'] = 'Známka je {$a}';
$string['gradeoptions'] = 'Možnosti známkovania';
$string['groupoverrides'] = 'Prestavenia skupín';
$string['groupoverridesdeleted'] = 'Prestavenia skupín boli odstránené';
$string['groupsnone'] = 'V tomto kurze nie sú žiadne skupiny, ku ktorým máte prístup.';
$string['handlingofretakes'] = 'Spracovanie opakovaného prechodu';
$string['handlingofretakes_help'] = 'Ak sú povolené opakované pokusy, toto nastavenie špecifikuje, či je hodnotenie za prednášku priemer alebo maximum zo všetkých pokusov.';
$string['havenotgradedyet'] = 'Ešte nebolo oznámkované';
$string['here'] = 'tu';
$string['highscore'] = 'Najvyššie skóre';
$string['hightime'] = 'Najlepší čas';
$string['importcount'] = 'Importujem {$a} otázok';
$string['importquestions'] = 'Importovať otázky';
$string['importquestions_help'] = 'Táto črta povolí importovanie otázok v rozličných formátoch pomocou textového súboru.';
$string['inactiveoverridehelp'] = '* Toto prepísanie je neaktívne, pretože prístup používateľa k aktivite je obmedzený. Dôvodom môže byť priradenie skupín alebo rolí, iné obmedzenia prístupu alebo skrytá aktivita.';
$string['indicator:cognitivedepth'] = 'Kognitívna prednáška';
$string['indicator:cognitivedepth_help'] = 'Tento ukazovateľ je založený na kognitívnej hĺbke dosiahnutej študentom v lekcii.';
$string['indicator:cognitivedepthdef'] = 'Kognitívna prednáška';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy účastník dosiahol toto percento kognitívnej angažovanosti ponúknutej aktivitami Lekcie (Úrovne = Žiadny pohľad, Zobraziť, Odoslať, Zobraziť spätnú väzbu, Komentár k spätnej väzbe, Znovu odoslať po prečítaní spätnej väzby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociálna prednáška';
$string['indicator:socialbreadth_help'] = 'Tento ukazovateľ je založený na sociálnom rozsahu dosiahnutom študentom v prednáške.';
$string['indicator:socialbreadthdef'] = 'Sociálna prednáška';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník percentuálny podiel sociálnej angažovanosti ponúkanej aktivitami lekcie (úrovne = žiadna účasť, účastník sám, účastník s ostatnými)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Vložená stránka';
$string['invalidfile'] = 'Neplatný súbor';
$string['invalidid'] = 'Žiadny identifikátor kurzu alebo prednášky nebol predaný';
$string['invalidlessonid'] = 'Identifikátor prednášky bol nesprávny';
$string['invalidoverrideid'] = 'Neplatné ID prednastavenia';
$string['invalidpageid'] = 'Neplatný identifikátor stránky';
$string['jump'] = 'Ísť na';
$string['jumps'] = 'Skok';
$string['jumps_help'] = 'Každá odpoveď (na otázky) alebo opis (pre obsahové stránky) má priradený príslušný odskok. Tento odskok môže byť relatívny, ako je napríklad "táto stránka" alebo "nasledujúca stránka", alebo absolútny, ktorý špecifikuje ľubovoľnú inú stránku v prednáške.';
$string['jumpsto'] = 'Skok na <em>{$a}</em>';
$string['leftduringtimed'] = 'Opustili ste prednášku s časovým limitom.<br />Ak chcete prednášku začať znova, kliknite na tlačidlo Pokračovať.';
$string['leftduringtimednoretake'] = 'Opustili ste prednášku s časovým limitom a nie je <br />Vám dovolené opätovne pokračovať alebo znova začať prednášku.';
$string['leftduringtimedsession'] = 'Opustili ste prednášku s časovým obmedzením.';
$string['lesson:addinstance'] = 'Pridať novú prednášku';
$string['lesson:edit'] = 'Upravovať prednášku';
$string['lesson:grade'] = 'Ohodnotiť (oznámkovať) otázky-eseje';
$string['lesson:manage'] = 'Administrovať prednášku';
$string['lesson:manageoverrides'] = 'Administrácia prestavení prednášky';
$string['lesson:view'] = 'Náhľad činnosti v prednáške';
$string['lesson:viewreports'] = 'Prezerať štatistiky prednášky';
$string['lessonbeingpreviewed'] = 'V súčasnosti sa zobrazuje ukážka prednášky.';
$string['lessonclosed'] = 'Táto prednáška sa uzatvára {$a}.';
$string['lessoncloses'] = 'Prednáška sa uzatvára';
$string['lessoneventcloses'] = '{$a} zatvorená';
$string['lessoneventopens'] = '{$a} otvorená';
$string['lessonformating'] = 'Formátovanie prednášky';
$string['lessonmenu'] = 'Menu prednášky';
$string['lessonnotready'] = 'Táto prednáška ešte nie je pripravená pre študentov. Obráťte sa na {$a}.';
$string['lessonnotready2'] = 'Táto prednáška nie je ešte pripravená pre študentov';
$string['lessonopen'] = 'Táto prednáška bude otvorená a sprístupnená  {$a}.';
$string['lessonopens'] = 'Prednáška sa otvára';
$string['lessonpagelinkingbroken'] = 'Nenájdená prvá stránka prednášky. Vnútorné odkazy medzi stránkami sú zrejme porušené. Obráťte sa na učiteľov v kurze, ktorí môžu editovať prednášku.';
$string['lessonstats'] = 'Štatistika prednášky';
$string['linkedmedia'] = 'Odkaz na média';
$string['loginfail'] = 'Vaše prihlásenie zlyhalo, prosím skúste sa prihlásiť znova...';
$string['lowscore'] = 'Nízke skóre';
$string['lowtime'] = 'Najhorší čas';
$string['manualgrading'] = 'Hodnotiť eseje';
$string['matchesanswer'] = 'Zodpovedá odpovedi';
$string['matching'] = 'Zhodné';
$string['matchingpair'] = 'Zhodný pár {$a}';
$string['maxgrade'] = 'Maximálne hodnotenie';
$string['maxgrade_help'] = 'Toto nastavenie určuje maximálnu známku v prednáškach. Ak je nastavené na nulu, známky z prednášky sa nezobrazujú vo výkaze známok.';
$string['maximumnumberofanswersbranches'] = 'Maximálny počet odpovedí';
$string['maximumnumberofanswersbranches_help'] = 'Toto nastavenie určuje maximálny počet odpovedí, ktoré je možné použiť v prednáške. Ak sú použité iba otázky typu Pravda/Nepravda, môže byť nastavená hodnota 2. Toto nastavenie je možné kedykoľvek zmeniť, pretože ovplyvňuje len to, čo vidí učiteľ, ale žiadne dáta.';
$string['maximumnumberofattempts'] = 'Maximálny počet pokusov na osobu';
$string['maximumnumberofattempts_help'] = 'Toto nastavenie určuje maximálny počet pokusov o zodpovedanie nejakej otázky. Ak opakovane odpovedá nesprávne, pri dosiahnutí maximálneho počtu pokusov sa zobrazí nasledujúca stránka prednášky.';
$string['maximumnumberofattemptsreached'] = 'Vyčerpali ste maximálny počet pokusov – nasleduje ďalšia stránka prednášky';
$string['mediaclose'] = 'Zobraziť tlačidlo na zatváranie';
$string['mediafile'] = 'Odkaz na mediálny obsah';
$string['mediafile_help'] = 'Mediálny súbor možno nahrať pre použitie v prednáške. Odkaz „Kliknutím sem zobrazíte“ sa potom zobrazí v bloku s názvom „Prepojené médiá“ na každej stránke prednášky.';
$string['mediafilepopup'] = 'Kliknite sem pre zobrazenie súboru';
$string['mediaheight'] = 'Výška vyskakovacieho okna:';
$string['mediawidth'] = 'Šírka vyskakovacieho okna:';
$string['messageprovider:graded_essay'] = 'Oznámenie ohodnotenia úlohy';
$string['minimumnumberofquestions'] = 'Minimálny počet otázok';
$string['minimumnumberofquestions_help'] = 'Toto nastavenie určuje minimálny počet otázok, ktoré sa použije na výpočet hodnotenia za aktivitu.';
$string['missingname'] = 'Prosím zadajte prezývku';
$string['modattempts'] = 'Povoliť študentom revíziu';
$string['modattempts_help'] = 'Ak je povolené, môžu študenti prechádzať prednášku znovu od začiatku.';
$string['modattemptsnoteacher'] = 'Revízia funguje len študentom';
$string['modulename'] = 'Prednáška';
$string['modulename_help'] = 'Modul Prednáška umožňuje učiteľovi dodávať obsah a/alebo precvičovacie aktivity zaujímavými a flexibilnými spôsobmi. Učiteľ môže prednášku použiť na vytvorenie postupnosti rozcestníkov alebo vyučovacích aktivít, ktoré ponúkajú množstvo ciest alebo možností pre študujúceho. V každom prípade si učiteľia môžu vybrať zvýšenie zapojenia študentov a presvedčiť sa o ich pochopení problematiky zahrnutím množstva typov otázok, ako je viacnásobná voľba, porovnávanie a krátka odpoveď. V závislosti od voľby odpovede študenta a toho, ako učiteľ prednášku rozvíja, študenti môžu postúpiť na nasledujúcu stránku, byť vrátení na predchádzajúcu stránku alebo presmerovaní na úplne inú cestu. Prednáška môže byť hodnotená, s hodnotením zaznamenaným do hodnotiaceho záznamu.

Prednášky je možné využiť
* na samoštúdium nových tém
* na scenáre alebo cvičenia na simulácie/ rozhodovanie sa
* na diferencované previerky, s rôznymi sadami previerkových otázok v závislosti od odpovedí daných na úvodné otázky';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Prednášky';
$string['move'] = 'Presunúť stránku';
$string['movedpage'] = 'Presunutá stránka';
$string['movepagehere'] = 'Presunúť stránku sem';
$string['movepagenamed'] = 'Presunúť stránku: {$a}';
$string['moving'] = 'Presúva sa stránka : {$a}';
$string['multianswer'] = 'Viacnásobná odpoveď';
$string['multianswer_help'] = 'Začiarknite políčko keď viac ako jedna odpoveď je správna.';
$string['multichoice'] = 'Viacero možností';
$string['multipleanswer'] = 'Viaceré odpovede';
$string['nameapproved'] = 'Názov bol schválený';
$string['namereject'] = 'Prepáčte, ale Váš názov bol odmietnutý filtrom.<br />Prosím, skúste iný názov.';
$string['new'] = 'Nové';
$string['nextpage'] = 'Ďalšia strana';
$string['noanswer'] = 'Jedna alebo viacej otázok nemajú vloženú odpoveď. Prosím, vráťte sa späť a napíšte odpoveď.';
$string['noattemptrecordsfound'] = 'Neboli nájdené žiadne záznamy o pokusoch: nebola pridelená žiadna známka';
$string['nobranchtablefound'] = 'Nebola nájdená stránka s obsahom';
$string['noclose'] = 'Žiadny dátum uzavretia';
$string['nocommentyet'] = 'Zatiaľ žiaden komentár.';
$string['nocoursemods'] = 'Nenájdené žiadne činnosti';
$string['nocredit'] = 'Bez kreditu';
$string['nodeadline'] = 'Žiadna uzávierka';
$string['noessayquestionsfound'] = 'Neboli nájdené žiadne otázky typu tvorená odpoveď';
$string['nohighscores'] = 'Žiadne zoznamy najvyšších skóre.';
$string['nolessonattempts'] = 'Nikto ešte neskúsil prejsť túto prednášku';
$string['nolessonattemptsgroup'] = '{$a} členov skupiny sa ešte nepokúsilo o absolvovanie tejto prednášky.';
$string['none'] = 'Nikto';
$string['nooneansweredcorrectly'] = 'Nikto nezodpovedal správne.';
$string['nooneansweredthisquestion'] = 'Nikto nezodpovedal túto otázku.';
$string['noonecheckedthis'] = 'Nikto toto neskontroloval.';
$string['nooneenteredthis'] = 'Toto nikto nevložil.';
$string['noonehasanswered'] = 'Nikto ešte nevložil tvorenú odpoveď.';
$string['noonehasansweredgroup'] = 'Nikto z {$a} ešte neodpovedal na otázku typu esej.';
$string['noopen'] = 'Žiadny dátum otvorenia';
$string['nooverridecreated'] = 'Nevytvorili sa žiadne prepísania.';
$string['nooverridedata'] = 'Musíte prepísať aspoň jedno z nastavení prednášky.';
$string['noretake'] = 'Nie je Vám dovolené opakovať túto prednášku.';
$string['normal'] = 'Normálne - nasleduj plán prednášky';
$string['notcompleted'] = 'Neukončené';
$string['notcompletedwithdate'] = 'Nedokončená  ({$a})';
$string['notdefined'] = 'Nie je definované';
$string['notenoughsubquestions'] = 'Nebolo definovaných dosť podotázok (možností) !';
$string['notenoughtimespent'] = 'Prednášku ste dokončili za {$a->timespent}, čo je menej ako požadovaný čas {$a->timerequired}. Možno budete musieť absolvovať prednášku znovu.';
$string['notgraded'] = 'Nehodnotené';
$string['notitle'] = 'Žiaden nadpis';
$string['notyetcompleted'] = 'Prednáška bola začatá, ale ešte nie je dokončená';
$string['numberofcorrectanswers'] = 'Počet správnych odpovedí: {$a}';
$string['numberofcorrectanswersheader'] = 'Počet správnych odpovedí';
$string['numberofcorrectmatches'] = 'Počet správnych priradení: {$a}';
$string['numberofpagestoshow'] = 'Počet stránok na zobrazenie';
$string['numberofpagestoshow_help'] = 'Toto nastavenie určuje počet stránok, zobrazovaných v prednáške. Používa sa iba u prednášok s náhodnou voľbou zobrazovania stránok (Keď je "Akcia po správnej odpovedi" nastavená na "Ukázať nevidenú stránku" alebo "Ukázať nezodpovedanú stránku"). Ak je nastavené na hodnotu nula, potom sa zobrazujú všetky stránky.';
$string['numberofpagesviewed'] = 'Počet prehliadnutých stránok: {$a}';
$string['numberofpagesviewedheader'] = 'Počet zodpovedaných otázok';
$string['numberofpagesviewednotice'] = 'Máte {$a->nquestions} zodpovedaných otázok; (Máte ich zodpovedať aspoň: {$a->minquestions})';
$string['numerical'] = 'Numerické';
$string['numericanswer'] = 'Numerická odpoveď';
$string['numericanswer_help'] = 'Pomocou dvojbodky môžete určiť jedno číslo alebo rozsah čísiel. Napríklad 2: 5 znamená, že akákoľvek odpoveď medzi 2 a 5, včítane 2 a 5, je správna.';
$string['offlinedatamessage'] = 'Na tomto pokuse ste pracovali pomocou mobilného zariadenia. Údaje boli na túto stránku naposledy uložené pred {$a}. Skontrolujte, či nemáte žiadne neuložené práce.';
$string['ongoing'] = 'Zobrazovať priebežné skóre';
$string['ongoing_help'] = 'Ak je táto možnosť aktivovaná, každá stránka zobrazí aktuálny počet z celkového možného počtu bodov, ktoré študent doteraz získal.';
$string['ongoingcustom'] = 'V tejto prednáške ste zatiaľ dosiahli {$a->score} bodov z {$a->currenthigh} bodov.';
$string['ongoingnormal'] = 'Zodpovedali ste {$a->correct} otázok správne z {$a->viewed} otázok.';
$string['onpostperpage'] = 'Iba jeden pokus je povolený pre jednotlivé hodnotenie';
$string['openafterclose'] = 'Zadali ste dátum otvorenia po dátume zatvorenia';
$string['options'] = 'Možnosti';
$string['or'] = 'ALEBO';
$string['ordered'] = 'Zoradené';
$string['other'] = 'Iné';
$string['outof'] = 'Z {$a}';
$string['override'] = 'Prednastavenia';
$string['overridedeletegroupsure'] = 'Skutočne si želáte odstrániť prednastavenie pre skupinu {$a}?';
$string['overridedeleteusersure'] = 'Skutočne si želáte odstrániť prednastavenie pre používateľa {$a}?';
$string['overridegroup'] = 'Prednastaviť skupinu';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Prestavenia';
$string['overrideuser'] = 'Prednastaviť používateľa';
$string['overrideusereventname'] = '{$a->lesson} - Prestavenie';
$string['overview'] = 'Prehľad';
$string['overview_help'] = 'Prednáška sa skladá z určitého počtu stránok a prípadne voliteľne aj z obsahových stránok. Stránka obsahuje nejaký obsah a obyčajne končí otázkou. S každou odpoveďou na otázku je spojený odskok. Tento odskok môže byť relatívny, ako je napríklad "táto stránka" alebo "nasledujúca stránka", alebo absolútny, ktorý špecifikuje ľubovoľnú inú stránku v prednáške. Rozcestník je stránka, ktorá obsahuje súbor odkazov na iné stránky v prednáške, napr. tabuľka obsahu.';
$string['page'] = 'Stránka: {$a}';
$string['page-mod-lesson-edit'] = 'Upraviť stránku prednášky';
$string['page-mod-lesson-view'] = 'Prezeranie alebo náhľad stránky prednášky';
$string['page-mod-lesson-x'] = 'Ľubovoľná stránka modulu prednáška';
$string['pageanswers'] = 'Stránka odpovedí';
$string['pagecontents'] = 'Obsah stránky';
$string['pageresponses'] = 'Stránka reakcií';
$string['pages'] = 'Stránky';
$string['pagetitle'] = 'Názov stránky';
$string['password'] = 'Heslo';
$string['passwordprotectedlesson'] = '{$a} je heslom chránená prednáška.';
$string['pleasecheckoneanswer'] = 'Prosím, zvoľte jednu odpoveď';
$string['pleasecheckoneormoreanswers'] = 'Prosím, zvoľte jednu alebo viac odpovedí';
$string['pleaseenteryouranswerinthebox'] = 'Prosím, vložte Vašu odpoveď';
$string['pleasematchtheabovepairs'] = 'Prosím, priraďte odpovedajúce páry';
$string['pluginadministration'] = 'Administratíva prednášky';
$string['pluginname'] = 'Prednáška';
$string['pointsearned'] = 'Počet získaných bodov';
$string['postprocesserror'] = 'Došlo k chybe počas post-spracovania !';
$string['postsuccess'] = 'Príspevok bol úspešne uverejnený';
$string['practice'] = 'Cvičná prednáška';
$string['practice_help'] = 'Hodnotenie testovacej prednášky sa nezobrazí vo známkovom výkaze.';
$string['preprocesserror'] = 'Nastala chyba pri pred-spracovaní !';
$string['prerequisiteisobsolete'] = 'Možnosť prerekvizitnej prednášky bude odstránená. Prosím, použite namiesto toho obmedzenie prístupu.';
$string['prerequisitelesson'] = 'Prerekvizitná prednáška';
$string['preview'] = 'Náhľad';
$string['previewlesson'] = 'Náhľad  {$a}';
$string['previewpagenamed'] = 'Náhľad stránky: {$a}';
$string['previouspage'] = 'Predchádzajúca strana';
$string['privacy:metadata:attempts'] = 'Zoznam pokusov na stránke';
$string['privacy:metadata:attempts:answerid'] = 'Identifikátor odpovede';
$string['privacy:metadata:attempts:correct'] = 'Či bol pokus správny';
$string['privacy:metadata:attempts:pageid'] = 'Identifikátor stránky';
$string['privacy:metadata:attempts:retry'] = 'Číslo pokusu';
$string['privacy:metadata:attempts:timeseen'] = 'Čas, kedy bol pokus urobený';
$string['privacy:metadata:attempts:useranswer'] = 'Podrobnosti o odpovedi používateľa';
$string['privacy:metadata:attempts:userid'] = 'Identifikátor užívateľa';
$string['privacy:metadata:branch'] = 'Záznam zobrazených stránok';
$string['privacy:metadata:branch:flag'] = 'Či bola ďalšia stránka vypočítaná náhodne';
$string['privacy:metadata:branch:nextpageid'] = 'Identifikátor nasledujúcej stránky';
$string['privacy:metadata:branch:pageid'] = 'Idnetifikátor stránky';
$string['privacy:metadata:branch:retry'] = 'Číslo pokusu';
$string['privacy:metadata:branch:timeseen'] = 'Čas zobrazenia stránky';
$string['privacy:metadata:branch:userid'] = 'Identifikátor používateľa';
$string['privacy:metadata:grades'] = 'Záznam o známkach pre každú prednášku';
$string['privacy:metadata:grades:completed'] = 'Dátum udelenia hodnotenia';
$string['privacy:metadata:grades:grade'] = 'Udelené hodnotenie';
$string['privacy:metadata:grades:userid'] = 'Identifikátor používateľa';
$string['privacy:metadata:overrides'] = 'Záznam o prepísaniach  prednášky';
$string['privacy:metadata:overrides:available'] = 'Čas, kedy je možné prednášku vyskúšať';
$string['privacy:metadata:overrides:deadline'] = 'Termín na dokončenie prednášky.';
$string['privacy:metadata:overrides:maxattempts'] = 'Maximálny počet pokusov';
$string['privacy:metadata:overrides:password'] = 'Heslo pre prístup k prednáške';
$string['privacy:metadata:overrides:retake'] = 'Či sú povolené opakovania';
$string['privacy:metadata:overrides:review'] = 'Či je opakovanie otázky povolené';
$string['privacy:metadata:overrides:timelimit'] = 'Časový limit na dokončenie prednášky, v sekundách.';
$string['privacy:metadata:overrides:userid'] = 'Identifikátor používateľa';
$string['privacy:metadata:timer'] = 'Záznam pokusu o prednášku';
$string['privacy:metadata:timer:completed'] = 'Či je pokus dokončený';
$string['privacy:metadata:timer:lessontime'] = 'Posledná chvíľa, keď sme zaznamenali aktivitu';
$string['privacy:metadata:timer:starttime'] = 'Dátum začiatku pokusu';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Posledná chvíľa, keď sme zaznamenali aktivitu z mobilnej aplikácie';
$string['privacy:metadata:timer:userid'] = 'Identifikátor používateľa';
$string['privacy:metadata:userpref:lessonview'] = 'Preferovaný režim zobrazenia pri úprave prednášok';
$string['privacy:path:essayanswers'] = 'Zodpovedania otázok typu Eseje';
$string['privacy:path:essayresponses'] = 'Odpovede na otázky Esej';
$string['privacy:path:pages'] = 'Strany';
$string['processerror'] = 'Došlo k chybe pri spracovaní!';
$string['progressbar'] = 'Zobraziť ukazovateľ postupu';
$string['progressbar_help'] = 'Ak je povolené, naspodku prednášky je zobrazovaný pás s približným percentom ukončenia.';
$string['progressbarteacherwarning'] = 'Ukazovateľ postupu prednáškou sa nezobrazuje pre {$a}';
$string['progressbarteacherwarning2'] = 'Neuvidíte pokrok, pretože máte možnosť úprav v tejto prednáške';
$string['progresscompleted'] = 'Dokončili ste {$a}% z prednášky';
$string['qtype'] = 'Typ stránky';
$string['question'] = 'Otázka';
$string['questionoption'] = 'Rozšírené nastavenie otázky';
$string['questiontype'] = 'Typ otázky';
$string['randombranch'] = 'Stránka s náhodným obsahom';
$string['randompageinbranch'] = 'Náhodná otázka v rámci stránky s obsahom';
$string['rank'] = 'Úroveň';
$string['rawgrade'] = 'Hrubá známka';
$string['receivedcredit'] = 'Odpoveď započítaná ako správna';
$string['redisplaypage'] = 'Znovuzobraziť stránku';
$string['removeallgroupoverrides'] = 'Odstrániť všetky prestavenia skupiny';
$string['removealluseroverrides'] = 'Odstrániť všetky prestavenia používateľov';
$string['report'] = 'Správa';
$string['reports'] = 'Správy';
$string['response'] = 'Odozva';
$string['retakesallowed'] = 'Je povolený opätovný pokus';
$string['retakesallowed_help'] = 'Ak je povolené, majú študenti možnosť viacerých pokusov.';
$string['returnto'] = 'Návrat na {$a}';
$string['returntocourse'] = 'Vrátiť sa do kurzu';
$string['reverttodefaults'] = 'Vrátiť sa k štandardným nastaveniam prednášky';
$string['review'] = 'Revízia';
$string['reviewlesson'] = 'Revízia prednášky';
$string['reviewquestionback'] = 'Áno, chcel by som skúsiť ešte raz';
$string['reviewquestioncontinue'] = 'Nie, chcem prejsť k ďalšej otázke';
$string['sanitycheckfailed'] = 'Zlyhala kontrola: tento pokus bol odstránený';
$string['save'] = 'Uložiť';
$string['savechanges'] = 'Uložiť zmeny';
$string['savechangesandeol'] = 'Uložiť všetky zmeny a ísť na koniec prednášky.';
$string['saveoverrideandstay'] = 'Uložiť a vložiť ďalšie prestavenie';
$string['savepage'] = 'Uložiť stránku';
$string['score'] = 'Skóre';
$string['score_help'] = 'Skóre sa používa iba vtedy, ak je aktivované vlastné bodovanie. Každá odpoveď môže mať potom číselnú bodovú hodnotu (kladnú alebo zápornú).';
$string['scores'] = 'Skóre';
$string['search:activity'] = 'Prednáška - informácie o činnosti';
$string['secondpluswrong'] = 'Nie úplne. Chcete sa pokúsiť ešte raz?';
$string['selectallattempts'] = 'Vyberte všetky pokusy';
$string['selectaqtype'] = 'Vyberte typ otázky';
$string['sent'] = 'Odoslané';
$string['shortanswer'] = 'Krátka odpoveď';
$string['showanunansweredpage'] = 'Zobraziť nezodpovedanú stránku';
$string['showanunseenpage'] = 'Zobraziť nevidenú stránku';
$string['singleanswer'] = 'Jediná odpoveď';
$string['skip'] = 'Preskočiť navigáciu';
$string['slideshow'] = 'Prezentácia';
$string['slideshow_help'] = 'Ak je povolené, prednáška sa zobrazí ako slideshow s pevnou šírkou a výškou.';
$string['slideshowbgcolor'] = 'Farba pozadia prezentácie';
$string['slideshowheight'] = 'Výška prezentácie';
$string['slideshowwidth'] = 'Šírka prezentácie';
$string['startlesson'] = 'Začať prednášku';
$string['studentattemptlesson'] = 'Pokus číslo {$a->attempt} používateľa {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} -  Meno';
$string['studentoneminwarning'] = 'Varovanie: Máte jednu minútu alebo menej na dokončenie prednášky.';
$string['studentoutoftimeforreview'] = 'Upozornenie: Minuli ste určený čas na prehliadku tejto prednášky';
$string['studentresponse'] = 'Odpoveď - {$a}';
$string['submit'] = 'Odoslať';
$string['submitname'] = 'Odoslať názov';
$string['teacherjumpwarning'] = 'Táto prednáška obsahuje prechody typu {$a->cluster} alebo {$a->unseen}. Namiesto toho bude použitý prechod  na ďalšiu stránku. Ak chcete otestovať tento prechod, prihláste sa ako študent.';
$string['teacherongoingwarning'] = 'Priebežné skóre sa zobrazuje len študentom. Ak chcete otestovať správnosť priebežného skóre, prihláste sa ako študent.';
$string['teachertimerwarning'] = 'Časomiera funguje len študentom. Otestujte časomieru prihlásením sa ako študent.';
$string['thatsthecorrectanswer'] = 'Táto odpoveď je správna';
$string['thatsthewronganswer'] = 'Táto odpoveď je nesprávna';
$string['thefollowingpagesjumptothispage'] = 'Nasledujúce stránky smerujú na túto stránku';
$string['thispage'] = 'Táto strana';
$string['timeisup'] = 'Čas vypršal';
$string['timelimit'] = 'Časový limit';
$string['timelimit_help'] = 'Ak je povolené, na začiatku prednášky sa zobrazí varovanie o časovom limite a odpočítavací časovač. Odpovede podané po uplynutí času sa nehodnotia.';
$string['timelimitwarning'] = 'Na dokončenie prednášky máte {$a}.';
$string['timeremaining'] = 'Zostávajúci čas';
$string['timespenterror'] = 'Stráviť prechádzaním prednášky viac než {$a} minút';
$string['timespentminutes'] = 'Strávený čas (v min.)';
$string['timetaken'] = 'Uplynutý čas';
$string['totalpagesviewedheader'] = 'Počet zobrazených stránok';
$string['true'] = 'Áno';
$string['truefalse'] = 'Pravda/Nepravda';
$string['unabledtosavefile'] = 'Nahraný súbor nemôže byť uložený';
$string['unknownqtypesnotimported'] = '{$a} otázok s nepodporovaným typom otázok neboli importované';
$string['unseenpageinbranch'] = 'Neprehliadnuté otázky v rámci stránky s obsahom';
$string['unsupportedqtype'] = 'Nepodporovaný typ otázky ({$a})!';
$string['updatedpage'] = 'Aktualizovaná stránka';
$string['updatefailed'] = 'Aktualizácia zlyhala';
$string['updatepagenamed'] = 'Aktualizovať stránku: {$a}';
$string['usemaximum'] = 'Použite maximum';
$string['usemean'] = 'Použite priemer';
$string['usepassword'] = 'Prednáška chránená heslom';
$string['usepassword_help'] = 'Ak je povolené, je heslo potrebné pre prístup k prednáške.';
$string['useroverrides'] = 'Používateľské prestavenia';
$string['useroverridesdeleted'] = 'Používateľské prestavenia boli odstránené';
$string['usersnone'] = 'K tejto prednáške nemajú prístup žiadni študenti';
$string['viewessayanswers'] = 'Zobraziť odpovede na eseje';
$string['viewgrades'] = 'Prezrieť známky';
$string['viewreports'] = 'Prezrieť {$a->attempts} dokončených pokusov';
$string['viewreports2'] = 'Zobraziť {$a} úspešné pokusy';
$string['warning'] = 'Varovanie';
$string['welldone'] = 'Dobrá práca! Výborne!';
$string['whatdofirst'] = 'Čo by ste chceli urobiť ako prvé?';
$string['withselectedattempts'] = 'S vybranými pokusmi ...';
$string['wronganswerjump'] = 'Prechod pri nesprávnej odpovedi';
$string['wronganswerscore'] = 'Skóre za nesprávnu odpoveď';
$string['wrongresponse'] = 'Nesprávna odpoveď';
$string['youhaveseen'] = 'Už ste si prezreli viac, ako jednu stránku z tejto prednášky.<br />Chcete pokračovať na tej stránke, ktorú ste si naposledy prezerali?';
$string['youranswer'] = 'Vaša odpoveď';
$string['yourcurrentgradeis'] = 'Vaša aktuálna známka je {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaša známka je teraz {$a->grade} z možných {$a->total}';
$string['youshouldview'] = 'Mali by ste zodpovedať prinajmenšom: {$a} otázok';
