<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_xmldb', language 'sk', version '4.0'.
 *
 * @package     tool_xmldb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actual'] = 'Súčasný';
$string['addpersistent'] = 'Pridať povinné trvalé polia';
$string['aftertable'] = 'Za tabuľkou:';
$string['back'] = 'Späť';
$string['backtomainview'] = 'Späť na hlavnú stránku';
$string['cannotuseidfield'] = 'Nemožno vložiť pole "id", jeho hodnota sa priraďuje automaticky';
$string['change'] = 'Zmeniť';
$string['charincorrectlength'] = 'Nesprávna dĺžka znakového poľa';
$string['check_bigints'] = 'Hľadať nesprávne DB integer polia';
$string['check_defaults'] = 'Hľadať nekonzistentné východzie hodnoty';
$string['check_foreign_keys'] = 'Vyhľadať porušovanie cudzích kľúčov';
$string['check_indexes'] = 'Hľadať chýbajúce DB indexy';
$string['check_oracle_semantics'] = 'Vyhľadať nesprávne dĺžky sémantiky';
$string['checkbigints'] = 'Kontrola celých čísiel';
$string['checkdefaults'] = 'Kontrola východzích hodnôt';
$string['checkforeignkeys'] = 'Skontrolovať cudzie kľúče';
$string['checkindexes'] = 'Skontrolovať indexy';
$string['checkoraclesemantics'] = 'Skontrolovať sémantiku';
$string['completelogbelow'] = '(viď kompletný log vyhľadávania nižšie)';
$string['confirmcheckbigints'] = 'Táto funkcia vyhľadá <a href="https://tracker.moodle.org/browse/MDL-11038">potenciálne nesprávne celočíselné polia</a> na vašom serveri Moodle a automaticky vygeneruje (ale nespustí!) potrebné SQL príkazy, aby boli všetky celé čísla vo vašej databáze správne definované.

Po vygenerovaní môžete takéto príkazy skopírovať a bezpečne vykonať pomocou vášho obľúbeného rozhrania SQL (nezabudnite si pred tým zálohovať údaje).

Dôrazne sa odporúča, aby ste mali spustenú najnovšiu (+ verziu) dostupnú pre vaše vydanie Moodle pred spustením vyhľadávania nesprávnych celých čísel.

Táto funkcionalita nevykonáva žiadnu akciu proti DB (len z nej číta), takže môže byť bezpečne vykonaná kedykoľvek.';
$string['confirmcheckdefaults'] = 'Táto funkcia vyhľadá na vašom serveri Moodle nekonzistentné predvolené hodnoty a vygeneruje (ale nevykoná!) potrebné príkazy SQL, aby boli všetky predvolené hodnoty správne definované.

Po vygenerovaní môžete takéto príkazy skopírovať a bezpečne vykonať pomocou vášho obľúbeného rozhrania SQL (nezabudnite si pred tým zálohovať údaje).

Dôrazne sa odporúča, aby ste pred spustením vyhľadávania nekonzistentných predvolených hodnôt používali najnovšiu (+ verziu) dostupnú pre vaše vydanie Moodle.

Táto funkcionalita nevykonáva žiadnu akciu proti DB (len z nej číta), takže môže byť bezpečne vykonaná kedykoľvek.';
$string['confirmcheckforeignkeys'] = 'Táto funkcia bude hľadať potenciálne porušenia externých kľúčov definovaných v definíciách súboru install.xml (Moodle momentálne negeneruje žiadne externé kľúče v databáze, preto sa môžu vyskytovať neplatné dáta.)

Veľmi sa odporúča, aby ste používali najnovšiu dostupnú (+verziu)  vášho vydania Moodle predtým, ako spustíte vyhľadávanie chýbajúcich indexov.

Táto funkcia nevykonáva žiadnu činnosť na databáze (iba z nej číta), takže ju možno bezpečne spustiť kedykoľvek.';
$string['confirmcheckindexes'] = 'Táto funkcia vyhľadá potenciálne chýbajúce indexy na vašom serveri Moodle a automaticky vygeneruje (nie však vykoná!) potrebné príkazy SQL, aby bolo všetko aktualizované.

Po vygenerovaní môžete takéto príkazy skopírovať a bezpečne vykonať pomocou vášho obľúbeného rozhrania SQL (nezabudnite si pred tým zálohovať údaje).

Dôrazne sa odporúča, aby ste pred spustením vyhľadávania chýbajúcich indexov mali spustenú najnovšiu (+ verziu) dostupnú pre vaše vydanie Moodle.

Táto funkcionalita nevykonáva žiadnu akciu proti DB (len z nej číta), takže môže byť bezpečne vykonaná kedykoľvek.';
$string['confirmcheckoraclesemantics'] = 'Táto funkcia bude hľadať <a href="http://tracker.moodle.org/browse/MDL-29322">Oracle varchar2 stĺpce, ktoré používajú BYTE sémantiku</a> vo vašom Moodle serveri, vytvárajúc (ale nevykonávajúc!) automaticky potrebné SQL príkazy na konverziu všetkých stĺpcov tak, aby namiesto toho používali CHAR sémantiku (lepšie pre medzidatabázovú kompatibilitu a zvýšený obsah maximálnej dĺžky).

Len čo sú vytvorené, môžete takéto príkazy kopírovať a spustiť ich bezpečne vo vašom obľúbenom SQL rozhraní (nezabudnite predtým urobiť zálohu vašich dát).

Veľmi sa odporúča, aby ste používali najnovšiu dostupnú (+verziu)  vášho vydania Moodlu predtým, ako spustíte vyhľadávanie BYTE sémantiky.

Táto funkcia nevykonáva žiadnu činnosť na databáze (iba z nej číta), takže ju možno bezpečne spustiť kedykoľvek.';
$string['confirmdeletefield'] = 'Ste si úplne istí, že chcete odstrániť pole:';
$string['confirmdeleteindex'] = 'Ste si úplne istí, že chcete odstrániť index:';
$string['confirmdeletekey'] = 'Ste si úplne istí, že chcete odstrániť kľúč:';
$string['confirmdeletetable'] = 'Ste si úplne istí, že chcete odstrániť tabuľku:';
$string['confirmdeletexmlfile'] = 'Ste si úplne istí, že chcete odstrániť súbor:';
$string['confirmrevertchanges'] = 'Ste si úplne istí, že chcete vrátiť vykonané zmeny:';
$string['create'] = 'Vytvoriť';
$string['createtable'] = 'Vytvoriť tabuľku:';
$string['defaultincorrect'] = 'Nesprávna východzia hodnota:';
$string['delete'] = 'Odstrániť';
$string['delete_field'] = 'Odstrániť pole';
$string['delete_index'] = 'Odstrániť index';
$string['delete_key'] = 'Odstrániť kľúč';
$string['delete_table'] = 'Odstrániť tabuľku';
$string['delete_xml_file'] = 'Odstrániť XML súbor';
$string['doc'] = 'Dokumentácia';
$string['docindex'] = 'Index dokumentácie:';
$string['documentationintro'] = 'Dokumentácia je automaticky generovaná z definície XMLDB databázy. Je dostupná iba v angličtine.';
$string['down'] = 'Dolu';
$string['duplicate'] = 'Duplikovať';
$string['duplicatefieldname'] = 'Už existuje pole s týmto názvom';
$string['duplicatefieldsused'] = 'Použité duplicitné polia';
$string['duplicateindexname'] = 'Duplicitný názov indexu';
$string['duplicatekeyname'] = 'Už existuje kľúč s týmto názvom';
$string['duplicatetablename'] = 'Existuje iná tabuľka s týmto názvom';
$string['edit'] = 'Upraviť';
$string['edit_field'] = 'Upraviť pole';
$string['edit_field_save'] = 'Uložiť pole';
$string['edit_index'] = 'Upraviť index';
$string['edit_index_save'] = 'Uložiť index';
$string['edit_key'] = 'Upraviť kľúč';
$string['edit_key_save'] = 'Uložiť kľúč';
$string['edit_table'] = 'Upraviť tabuľku';
$string['edit_table_save'] = 'Uložiť tabuľku';
$string['edit_xml_file'] = 'Upraviť XML súbor';
$string['enumvaluesincorrect'] = 'Nesprávne hodnoty pre enum pole';
$string['expected'] = 'Očakávaný';
$string['extensionrequired'] = 'Ľutujeme - na túto činnosť je potrebné rozšírenie PHP \'{$a}\'. Ak túto vlastnosť potrebujete, nainštalujte dané rozšírenie.';
$string['extraindexesfound'] = 'Boli nájdené ďalšie indexy';
$string['field'] = 'Pole';
$string['fieldnameempty'] = 'Prázdny názov poľa';
$string['fields'] = 'Polia';
$string['fieldsnotintable'] = 'Pole v tabuľke neexistuje';
$string['fieldsusedinindex'] = 'Toto pole je použité ako index';
$string['fieldsusedinkey'] = 'Toto pole je použité ako kľúč.';
$string['filemodifiedoutfromeditor'] = 'UPOZORNENIE: Súbor bol lokálne zmenený použitím XMLDB editora. Uloženie prepíše lokálne zmeny.';
$string['filenotwriteable'] = 'Do poľa nemožno zapisovať';
$string['fkunknownfield'] = 'Externý kľúč {$a->keyname} v tabuľke {$a->tablename} ukazuje na neexistujúce pole {$a->reffield} v tabuľke odkazov {$a->reftable}.';
$string['fkunknowntable'] = 'Externý kľúč {$a->keyname} v tabuľke {$a->tablename} ukazuje na neexistujúcu tabuľku {$a->reftable}.';
$string['fkviolationdetails'] = 'Cudzí kľúč {$a->keyname} v tabuľke {$a->tablename} je porušený v počte {$a->numviolations} z celkového počtu riadkov: {$a->numrows} rows.';
$string['float2numbernote'] = 'Poznámka: Hoci polia typu "float" sú podporované na  100% cez XMLDB, odporúčame ich zmeniť na polia typu "number".';
$string['floatincorrectdecimals'] = 'Nesprávny počet desatinných čísel v poli s plávajúcou desatinnou čiarkou';
$string['floatincorrectlength'] = 'Nesprávna dĺžka poľa s plávajúcou desatinnou čiarkou';
$string['generate_all_documentation'] = 'Celá dokumentácia';
$string['generate_documentation'] = 'Dokumentácia';
$string['gotolastused'] = 'Ísť na posledne použitý súbor';
$string['incorrectfieldname'] = 'Nesprávny názov';
$string['incorrectindexname'] = 'Nesprávny názov indexu';
$string['incorrectkeyname'] = 'Nesprávny názov kľúča';
$string['incorrecttablename'] = 'Nesprávny názov tabuľky';
$string['index'] = 'Index';
$string['indexes'] = 'Indexy';
$string['indexnameempty'] = 'Pole Názov indexu je prázdne';
$string['integerincorrectlength'] = 'Nesprávna dĺžka celočíselného poľa';
$string['key'] = 'Kľúč';
$string['keynameempty'] = 'Pole Názov kľúča nemôže byť prázdne';
$string['keys'] = 'Kľúče';
$string['listreservedwords'] = 'Zoznam rezervovaných slov<br />(používa sa k aktualizácii stránky <a href="http://docs.moodle.org/en/XMLDB_reserved_words" target="_blank">XMLDB_reserved_words</a>)';
$string['load'] = 'Nahrať';
$string['main_view'] = 'Hlavný pohľad';
$string['masterprimaryuniqueordernomatch'] = 'Polia vo vašom cudzom kľúči musia byť uvedené v rovnakom poradí, v akom sú v UNIQUE KEY v uvádzanej tabuľke.';
$string['missing'] = 'Chýbajúci';
$string['missingindexes'] = 'Nájdené chýbajúce indexy';
$string['mustselectonefield'] = 'Musíte vybrať jedno pole, aby ste videli súvisiace akcie.';
$string['mustselectoneindex'] = 'Musíte vybrať jeden index, aby ste videli súvisiace akcie.';
$string['mustselectonekey'] = 'Musíte vybrať kľúč, aby ste videli súvisiace akcie.';
$string['new_table_from_mysql'] = 'Nová tabuľka z MySQL';
$string['newfield'] = 'Nové pole';
$string['newindex'] = 'Nový index';
$string['newkey'] = 'Nový kľúč';
$string['newtable'] = 'Nová tabuľka';
$string['newtablefrommysql'] = 'Nová tabuľka z MySQL';
$string['nofieldsspecified'] = 'Neboli určené žiadne polia';
$string['nomasterprimaryuniquefound'] = 'Stĺpce s odkazmi externých kľúčov musia byť obsiahnuté v primárnom alebo jedinečnom kľúči KEY v tabuľke odkazov. Poznámka: Stĺpec, ktorý je v indexe UNIQUE INDEX, nie je dosť dobrý.';
$string['nomissingorextraindexesfound'] = 'Nenašli sa žiadne chýbajúce alebo nadbytočné indexy, takže nie sú potrebné žiadne ďalšie kroky.';
$string['noreffieldsspecified'] = 'Nie sú určené žiadne polia odkazov';
$string['noreftablespecified'] = 'Určená tabuľka odkazov sa nenašla';
$string['noviolatedforeignkeysfound'] = 'Neboli nájdené žiadne porušené cudzie kľúče';
$string['nowrongdefaultsfound'] = 'Neboli nájdené žiadne nekonzistentné definície východzích hodnôt. Ďalšie opravy databázy nie sú potrebné.';
$string['nowrongintsfound'] = 'Neboli nájdené žiadne nesprávne premenné typu integer, vaša databáza je v poriadku.';
$string['nowrongoraclesemanticsfound'] = 'Žiadne Oracle stĺpce s využitím BYTE sémantiky sa nenašli, vaša databáza nepotrebuje žiadne ďalšie akcie.';
$string['numberincorrectdecimals'] = 'Nesprávny počet desatinných čísel v číselnom poli';
$string['numberincorrectlength'] = 'Nesprávna dĺžka číselného poľa';
$string['numberincorrectwholepart'] = 'Príliš veľké celé číslo pre pole čísiel';
$string['pendingchanges'] = 'Poznámka: v tomto súbore ste vykonali zmeny. Môžete ho kedykoľvek uložiť.';
$string['pendingchangescannotbesaved'] = 'V tomto súbore boli vykonané zmeny, ale nemôžete ho uložiť. Skontrolujte adresár a v ňom súbor install.xml, či má oprávnenia pre zápis web serverom.';
$string['pendingchangescannotbesavedreload'] = 'Zmeny v tomto súbore nemohli byť uložené! Prosím, overte, že aj adresár, aj súbor "install.xml" vnútri neho majú oprávnenie na zapisovanie pre tento webový server. Potom znovu nahrajte túto stránku a malo by sa vám podariť tieto zmeny uložiť.';
$string['persistentfieldscomplete'] = 'Boli pridané nasledujúce polia:';
$string['persistentfieldsconfirm'] = 'Chcete pridať nasledujúce polia:';
$string['persistentfieldsexist'] = 'Nasledujúce polia už existujú';
$string['pluginname'] = 'XMLDB editor';
$string['primarykeyonlyallownotnullfields'] = 'Primárne kľúče nemôžu byť nulové';
$string['privacy:metadata'] = 'Modul Editor XMLDB neukladá žiadne osobné údaje';
$string['reconcile_files'] = 'Vyhľadajte súbory XMLDB, ktoré je potrebné zosúladiť';
$string['reconcile_files_intro'] = 'Táto funkcia prezerá obsah všetkých súborov XMLDB, aby overila, či sa zhodujú s výsledkami ich generovania z editora XMLDB.

Zobrazí sa zoznam súborov, ktoré je potrebné zosúladiť (regenerovať), a na ich opravu je možné použiť editor XMLDB.';
$string['reconcile_files_no'] = 'Všetky súbory sú v poriadku. Nie je potrebné žiadne zosúladenie.';
$string['reconcile_files_yes'] = 'Nájdené súbory na zosúladenie:';
$string['reconcilefiles'] = 'Zosúladiť súbory XMLDB';
$string['reserved'] = 'Rezervované';
$string['reservedwords'] = 'Rezervované slová';
$string['revert'] = 'Vrátiť';
$string['revert_changes'] = 'Vrátiť zmeny';
$string['save'] = 'Uložiť';
$string['searchresults'] = 'Výsledky hľadania';
$string['selectaction'] = 'Výber akcie:';
$string['selectdb'] = 'Výber databázy:';
$string['selectfieldkeyindex'] = 'Výber poľa/kľúča/indexu:';
$string['selectonecommand'] = 'Vyberte jednu z akcií zo zoznamu k zobrazeniu kódu PHP';
$string['selectonefieldkeyindex'] = 'Vyberte jedno z polí/kľúčov/indexov zo zoznamu k zobrazeniu kódu PHP';
$string['selecttable'] = 'Výber tabuľky:';
$string['table'] = 'Tabuľka';
$string['tablenameempty'] = 'Pole Názov tabuľky nemôže byť prázdne';
$string['tables'] = 'Tabuľky';
$string['unknownfield'] = 'Odkazuje na neznáme pole';
$string['unknowntable'] = 'Odkazuje na neznámu tabuľku';
$string['unload'] = 'Zavrieť';
$string['up'] = 'Nahor';
$string['view'] = 'Zobraziť';
$string['view_reserved_words'] = 'Zobraziť rezervované slová';
$string['view_structure_php'] = 'Zobraziť štruktúru PHP';
$string['view_structure_sql'] = 'Zobraziť štruktúru SQL';
$string['view_table_php'] = 'Zobraziť tabuľku PHP';
$string['view_table_sql'] = 'Zobraziť tabuľku SQL';
$string['viewedited'] = 'Zobraziť upravenú';
$string['vieworiginal'] = 'Zobraziť originálnu';
$string['viewphpcode'] = 'Zobraziť kód PHP';
$string['viewsqlcode'] = 'Zobraziť kód SQL';
$string['viewxml'] = 'XML';
$string['violatedforeignkeys'] = 'Poškodené cudzie kľúče';
$string['violatedforeignkeysfound'] = 'Boli nájdené poškodené cudzie kľúče';
$string['violations'] = 'Poškodenia';
$string['wrong'] = 'Nesprávny';
$string['wrongdefaults'] = 'Nájdené chybné východzie hodnoty';
$string['wrongints'] = 'Boli nájdené nesprávne polia typu integer';
$string['wronglengthforenum'] = 'Nesprávna dĺžka enum poľa';
$string['wrongnumberofreffields'] = 'Zlý počet polí odkazov';
$string['wrongoraclesemantics'] = 'Bola nájdená zlá Oracle BYTE sémantika';
$string['wrongreservedwords'] = 'Súčasné rezervované slová<br />(názvy tabuliek nehrajú rolu, ak používate $CFG->prefix)';
$string['yesextraindexesfound'] = 'Boli nájdené nasledujúce ďalšie indexy.';
$string['yesmissingindexesfound'] = 'Niektoré chýbajúce indexy boli nájdené vo vašej DB. Tu sú podrobnosti a potrebné SQL príkazy na vykonanie s vašim obľúbeným SQL rozhraním na ich vytvorenie. (pred ich vykonaní si uložte databázu)<br /><br /> Po vykonaní je vysoko doporučované spustiť tento skript znova na skontrolovanie, či nebudú nájdené žiadne ďalšie chýbajúce indexy.';
$string['yeswrongdefaultsfound'] = 'Vo vašej databáze boli nájdené nesprávne typy niektorých celočíselných atribútov. Nasledujú bližšie informácie a potrebné SQL príkazy ku korektnej definícii vašich tabuliek. Pred spustením týchto príkazov vo vašom obľúbenom SQL klientovi si nezabudnite vytvoriť zálohu celej databázy.<br /><br />Pre istotu odporúčame, aby ste po spustení uvedených SQL príkazov spustili túto kontrolu znovu.';
$string['yeswrongintsfound'] = 'Niektoré chýbajúce premenné typu integer boli nájdené vo vašej DB. Tu sú podrobnosti a potrebné SQL príkazy na vykonanie s vašim obľúbeným SQL rozhraním na ich vytvorenie (nezabudnite predtým zálohovať vaše údaje). <br /><br /> Po vykonaní je vysoko doporučované spustiť tento skript znova na skontrolovanie, či nebudú nájdené žiadne ďalšie chýbajúce indexy.';
$string['yeswrongoraclesemanticsfound'] = '<p>Niektoré Oracle stĺpce používajúce BYTE sémantiku boli nájdené vo vašej databáze. Tu sú ich podrobnosti a potrebné SQL príkazy, ktoré majú byť spustené vo vašom obľúbenom SQL rozhraní, aby ich bolo možné vytvoriť. Nezabudnite najprv urobiť zálohu vašich dát!</p>
<p>Po zálohovaní sa odporúča spustiť túto utilitu znovu, aby sa overilo, že sa nenašla žiadna ďalšia nenáležitá sémantika.</p>';
