<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'it', version '4.0'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Il backup è stato completato';
$string['asyncbackupcompletebutton'] = 'Prosegui';
$string['asyncbackupcompletedetail'] = 'Il processo di backup è stato completato correttamente.<br/> È possibile visualizzare il backup <a href="{$a}">nella pagina di ripristino</a>.';
$string['asyncbackuperror'] = 'Il backup non è andato a buon fine';
$string['asyncbackuperrordetail'] = 'Il backup non è andato a buon fine. Per favore contatta l\'amministratore.';
$string['asyncbackuppending'] = 'Il backup è in attesa';
$string['asyncbackupprocessing'] = 'Il backup è in svolgimento';
$string['asyncbadexecution'] = 'Errata elaborazione del controller di backup. Risulta {$a} invece di 2.';
$string['asynccheckprogress'] = 'È possibile seguire l\'avanzamento <a href="{$a}">nella pagina di ripristino</a>.';
$string['asyncemailenable'] = 'Abilita notifiche';
$string['asyncemailenabledetail'] = 'Gli utenti saranno avvisati tramite messaggio quando il backup/ripristino asincrono sarà stato completato.';
$string['asyncgeneralsettings'] = 'Backup/ripristino asincrono';
$string['asyncmessagebody'] = 'Messaggio';
$string['asyncmessagebodydefault'] = '{operation} (ID: {backupid}) è stato completato correttamente. Per accedere: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Messaggio da inviare quando il backup/ripristino asincrono sarà stato completato:';
$string['asyncmessagesubject'] = 'Oggetto';
$string['asyncmessagesubjectdefault'] = '{operation} Moodle è stata completata correttamente';
$string['asyncmessagesubjectdetail'] = 'Ogetto del messaggio';
$string['asyncnowait'] = 'Non è necessario attendere, l\'elaborazione proseguirà in background.';
$string['asyncprocesspending'] = 'Processo in attesa';
$string['asyncrestorecomplete'] = 'Il processo di ripristino è stato completato.';
$string['asyncrestorecompletebutton'] = 'Prosegui';
$string['asyncrestorecompletedetail'] = 'Il processo di ripristino è stato completato correttamente. Cliccando su prosegui è posisbile accedere al <a href="{$a}">corso con l\'elemento ripristinato.</a>';
$string['asyncrestoreerror'] = 'Il ripristino non è andato a buon fine';
$string['asyncrestoreerrordetail'] = 'Il ripristino non è andato a buon fine. Per favore contatta l\'amministratore.';
$string['asyncrestoreinprogress'] = 'Il ripristino è in svolgimento';
$string['asyncrestoreinprogress_help'] = 'I ripristini asincroni che sono in svolgimento sono visualizzati di seguito.';
$string['asyncrestorepending'] = 'Il ripristino è in attesa';
$string['asyncrestoreprocessing'] = 'Il ripristino è in svolgimento';
$string['asyncreturn'] = 'Torna al corso';
$string['autoactivedescription'] = 'È possibile scegliere come impostare i backup automatici. Selezionando \'Manuale\' i backup automatici saranno eseguiti esclusivamente tramite lo script CLI di backup che può essere eseguito manualmente oppure tramite il cron.';
$string['autoactivedisabled'] = 'Disabilitato';
$string['autoactiveenabled'] = 'Abilitato';
$string['autoactivemanual'] = 'Manuale';
$string['automatedbackupschedule'] = 'Pianificazione';
$string['automatedbackupschedulehelp'] = 'I giorni della settimana nei quali effettuare i backup automatici.';
$string['automatedbackupsinactive'] = 'I backup automatici non sono stati abilitati dall\'amministratore del sito.';
$string['automatedbackupstatus'] = 'Stato backup automatico';
$string['automateddeletedays'] = 'Elimina backup più vecchi di';
$string['automatedmaxkept'] = 'Numero massimo di backup da mantenere';
$string['automatedmaxkepthelp'] = 'Il numero massimo di backup automatici di corsi da mantenere. I backup più vecchi saranno eliminati automaticamente.';
$string['automatedminkept'] = 'Numero minimo di backup da mantenere';
$string['automatedminkepthelp'] = 'Se è stata impostata l\'eliminazione di backup più vecchi di un dato numero di giorni, potrebbe succedere che vengano eliminati tutti i backup di un corso non attivo. Per evitare questo problema, è possibile impostare il numero minimo di backup da mantenere.';
$string['automatedsettings'] = 'Impostazioni backup automatico';
$string['automatedsetup'] = 'Impostazioni backup automatico';
$string['automatedstorage'] = 'Archivio backup automatico';
$string['automatedstoragehelp'] = 'La posizione dove memorizzare i backup automatici';
$string['backupactivity'] = 'Backup attività: {$a}';
$string['backupautoactivitiesdescription'] = 'Imposta il default dell\'inclusione delle attività nei backup. Affinché il cestino funzioni, questa impostazione deve essere abilitata.';
$string['backupcourse'] = 'Backup corso: {$a}';
$string['backupcoursedetails'] = 'Dettagli corso';
$string['backupcoursesection'] = 'Sezione: {$a}';
$string['backupcoursesections'] = 'Sezioni corso';
$string['backupdate'] = 'Data backup';
$string['backupdetails'] = 'Dettagli backup';
$string['backupdetailsnonstandardinfo'] = 'Il file selezionato non è un file di backup Moodle standard. Il processo di ripristino tenterà di convertire il file di backup al formato standard per poi ripristinarlo. ';
$string['backupformat'] = 'Formato';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Formato sconosciuto';
$string['backuplog'] = 'Informazioni tecniche ed avvertenze';
$string['backupmode'] = 'Modalità';
$string['backupmode10'] = 'Generale';
$string['backupmode20'] = 'Importa';
$string['backupmode30'] = 'Hub';
$string['backupmode40'] = 'Stesso sito';
$string['backupmode50'] = 'Automatico';
$string['backupmode60'] = 'Convertito';
$string['backupmode70'] = 'Asincrono';
$string['backupsection'] = 'Backup sezione corso: {$a}';
$string['backupsettings'] = 'Impostazioni backup';
$string['backupsitedetails'] = 'Dettagli sito';
$string['backupstage16action'] = 'Prosegui';
$string['backupstage1action'] = 'Avanti';
$string['backupstage2action'] = 'Avanti';
$string['backupstage4action'] = 'Esegui backup';
$string['backupstage8action'] = 'Prosegui';
$string['backuptype'] = 'Tipo';
$string['backuptypeactivity'] = 'Attività';
$string['backuptypecourse'] = 'Corso';
$string['backuptypesection'] = 'Sezione';
$string['backupversion'] = 'Versione backup';
$string['cannotfindassignablerole'] = 'Il ruolo {$a} presente nel file di backup non può essere mappato su nessuno dei ruoli che sei autorizzato ad assegnare.';
$string['choosefilefromactivitybackup'] = 'Area backup attività';
$string['choosefilefromactivitybackup_help'] = 'Se si effettua un backup delle attività con le impostazioni di default, i file di backup saranno salvati qui.';
$string['choosefilefromautomatedbackup'] = 'Backup automatici';
$string['choosefilefromautomatedbackup_help'] = 'Contiene i backup generati automaticamente';
$string['choosefilefromcoursebackup'] = 'Area backup corso';
$string['choosefilefromcoursebackup_help'] = 'I backup dei corsi eseguiti con le impostazioni di default sono memorizzati nell\'area di backup del corso.';
$string['choosefilefromuserbackup'] = 'Area backup personali';
$string['choosefilefromuserbackup_help'] = 'I backup dei corsi eseguiti con l\'opzione "Rendi anonimi i dati utente" sono memorizzati nei file personali.';
$string['config_keep_groups_and_groupings'] = 'Imposta il default per il mantenimento dei gruppi e raggruppamenti esistenti.';
$string['config_keep_roles_and_enrolments'] = 'Imposta il default per il mantenimento dei ruoli e iscrizioni esistenti.';
$string['config_overwrite_conf'] = 'Consente agli utenti di sovrascrivere la configurazione del corso';
$string['config_overwrite_course_fullname'] = 'Se "Sovrascrivi la configurazione del corso" è abilitato e se l\'utente ha il privilegio moodle/course:changefullname per modificare il nome del corso, di default il nome del corso di back up verrà sovrascritto nel corso di destinazione.';
$string['config_overwrite_course_shortname'] = 'Se "Sovrascrivi la configurazione del corso" è abilitato e se l\'utente ha il privilegiomoodle/course:changeshortname per modificare il titolo del corso, di default il titolo del corso di back up verrà sovrascritto nel corso di destinazione.';
$string['config_overwrite_course_startdate'] = 'Se "Sovrascrivi la configurazione del corso" è abilitato e se l\'utente ha il privilegio moodle/restore:rolldates per modificare le date nel ripristino del corso, di default la data di inizio del corso di back up viene sovrascritta nel corso di destinazione.';
$string['configgeneralactivities'] = 'Imposta il default per l\'inclusione delle attività nei backup.';
$string['configgeneralanonymize'] = 'Imposta il default per rendere anonime le informazioni degli utenti nei backup.';
$string['configgeneralbadges'] = 'Imposta il default per l\'inclusione dei badge nei backup.';
$string['configgeneralblocks'] = 'Imposta il default per l\'inclusione dei blocchi nei backup.';
$string['configgeneralcalendarevents'] = 'Imposta il default per l\'inclusione degli eventi di calendario nei backup.';
$string['configgeneralcomments'] = 'Imposta il default per l\'inclusione dei commenti nei backup.';
$string['configgeneralcompetencies'] = 'Imposta il default per l\'inclusione delle competenze nei backup.';
$string['configgeneralcontentbankcontent'] = 'Imposta il default per l\'inclusione del deposito dei contenuti nei backup';
$string['configgeneralfiles'] = 'Il default per l\'inclusione dei file nei backup. Nota: disabilitando  l\'impostazione, i backup conterranno solo i riferimenti ai file, cosa che non è un problema se il backup verrà ripristinato nello stesso sito purché i file non siano stati eliminati in accordo all\'impostazione \'Elimina file del cestino\' (filescleanupperiod).';
$string['configgeneralfilters'] = 'Imposta il default per l\'inclusione dei filtri nei backup.';
$string['configgeneralgroups'] = 'Imposta il default per l\'inclusione nei backup di gruppi e raggruppamenti.';
$string['configgeneralhistories'] = 'Imposta il default per l\'inclusione dello storico degli utenti nei backup.';
$string['configgenerallogs'] = 'Imposta il default per l\'inclusione dei log nei backup.';
$string['configgeneralpermissions'] = 'Consente di importare i privilegi del ruolo. L\'operazione sovrascriverà i privilegi esistenti degli utenti iscritti.';
$string['configgeneralquestionbank'] = 'Include di default il deposito delle domande nei backup. NOTA: disabilitando questa impostazione saranno disabilitati i backup delle attività che usano il deposito delle domande, come ad esempio i quiz.';
$string['configgeneralroleassignments'] = 'Imposta il default per l\'inclusione delle assegnazioni di ruolo nei backup.';
$string['configgeneralusers'] = 'Imposta il default per l\'inclusione degli utenti nei backup.';
$string['configgeneraluserscompletion'] = 'Imposta il default per l\'inclusione delle informazioni di completamento nei backup.';
$string['configlegacyfiles'] = 'Consente di non includere i file legacy del corso';
$string['configloglifetime'] = 'Imposta la finestra temporale di conservazione dei log di backup. I log antecedenti la finestra temporale saranno eliminati automaticamente. Si suggerisce di impostare un valore basso, la quantità di informazioni dei logo può essere molto grande.';
$string['configrestoreactivities'] = 'Imposta il default per il ripristino delle attività.';
$string['configrestorebadges'] = 'Imposta il default per il ripristino dei badge.';
$string['configrestoreblocks'] = 'Imposta il default per il ripristino dei blocchi.';
$string['configrestorecalendarevents'] = 'Imposta il default per il ripristino degli evento do calendario.';
$string['configrestorecomments'] = 'Imposta il default per il ripristino dei commenti.';
$string['configrestorecompetencies'] = 'Imposta il default per il ripristino delle competenze.';
$string['configrestorecontentbankcontent'] = 'Il default per lil ripristino del deposito dei contenuti.';
$string['configrestoreenrolments'] = 'Imposta il default per il ripristino dei metodi di iscrizione.';
$string['configrestorefilters'] = 'Imposta il default per il ripristino dei filtri.';
$string['configrestoregroups'] = 'Imposta il default per il ripristino dei gruppi e dei raggruppamenti, se inclusi nel backup.';
$string['configrestorehistories'] = 'Imposta il default per il ripristino dello storico degli utenti, se incluso nel backup.';
$string['configrestorelogs'] = 'Imposta il default per il ripristino dei log degli utenti, se presenti nel backup.';
$string['configrestorepermissions'] = 'Consente di ripristinare i privilegi del ruolo. L\'operazione sovrascriverà i privilegi esistenti degli utenti iscritti.';
$string['configrestoreroleassignments'] = 'Imposta il default per il ripristino delle assegnazioni di ruolo se presenti nei backup.';
$string['configrestoreusers'] = 'Imposta il default per il ripristino degli utenti, se presenti nel backup.';
$string['configrestoreuserscompletion'] = 'Imposta il default per il ripristino delle informazioni di completamento degli utenti, se presenti nel backup.';
$string['confirmcancel'] = 'Annulla backup';
$string['confirmcancelimport'] = 'Annulla importazione';
$string['confirmcancelno'] = 'Non annullare';
$string['confirmcancelquestion'] = 'Sei sicuro di voler annullare? Le informazioni inserite saranno perdute.';
$string['confirmcancelrestore'] = 'Annulla ripristino';
$string['confirmcancelyes'] = 'Annulla backup';
$string['confirmnewcoursecontinue'] = 'Avviso: nuovo corso';
$string['confirmnewcoursecontinuequestion'] = 'Il processo di ripristino creerà un nuovo corso nascosto. Per interrompere il processo, fare click su annulla. Non chiudere il browser durante il processo di ripristino.';
$string['copiesinprogress'] = 'Son in svolgimento copie del corso. <a href="{$a}">Visualizza stato delle copie.</a>';
$string['copycoursedesc'] = 'Il corso verrà duplicato e inserito nella categoria selezionata.';
$string['copycourseheading'] = 'Copia corso';
$string['copycoursetitle'] = 'Copia corso: {$a}';
$string['copydest'] = 'Destinazione';
$string['copyfieldnotfound'] = 'Mancano i seguenti campi obbligatori: {$a}';
$string['copyformfail'] = 'L\'invio AJAX della copia del corso non è andata a buon fine.';
$string['copyingcourse'] = 'La copia del corso è in svolgimento';
$string['copyingcourseshortname'] = 'copia in corso';
$string['copyop'] = 'Operazione in corso';
$string['copyprogressheading'] = 'Copia in corso';
$string['copyprogressheading_help'] = 'La tabella visualizza lo stato di tutte le copie non completate.';
$string['copyprogresstitle'] = 'Stato della copia del corso';
$string['copyreturn'] = 'Copia e ritorna al corso';
$string['copysource'] = 'Fonte';
$string['copyview'] = 'Copia e visualizza';
$string['coursecategory'] = 'Categoria dove ripristinare il corso';
$string['courseid'] = 'ID Originale';
$string['coursesettings'] = 'Impostazioni corso';
$string['coursetitle'] = 'Titolo';
$string['currentstage1'] = 'Impostazioni iniziali';
$string['currentstage16'] = 'Fine';
$string['currentstage2'] = 'Impostazione struttura';
$string['currentstage4'] = 'Revisione e conferma';
$string['currentstage8'] = 'Esecuzione backup';
$string['enableasyncbackup'] = 'Abilita backup asincroni';
$string['enableasyncbackup_help'] = 'Le operazioni di backup e ripristino saranno asincrone, consentendo all\'utente di svolgere altre attività. L\'impostazione non ha influenza su importazioni ed esportazioni.';
$string['enterasearch'] = 'Inserisci una ricerca';
$string['error_block_for_module_not_found'] = 'È stata trovata una istanza orfana  di blocco (id: {$a->bid}) nel corso (id: {$a->mid}). Questo blocco non sarà incluso nel backup.';
$string['error_course_module_not_found'] = 'È stato trovato un modulo orfano (id: {$a}) nel corso. Questo modulo non sarà incluso nel backup.';
$string['errorcopyingbackupfile'] = 'Non è andata a buon fine la copia del file di backup nella cartella temporanea per il ripristino.';
$string['errorfilenamemustbezip'] = 'Il nome del file inserito deve essere un file ZIP e deve avere l\'estensione .mbz.';
$string['errorfilenamerequired'] = 'Devi inserire un nome valido per il file di backup. ';
$string['errorfilenametoolong'] = 'Il nome del file deve essere lungo meno di 255 caratteri.';
$string['errorinvalidformat'] = 'Formato backup sconosciuto';
$string['errorinvalidformatinfo'] = 'Il file selezionato non è un file di backup Moodle valido e non può essere ripristinato.';
$string['errorminbackup20version'] = 'Questo file di backup è stato creato con una versione di sviluppo del backup di Moodle ({$a->backup}). La versione minima dalla quale è possibile ripristinare è la {$a->min}.';
$string['errorrestorefrontpagebackup'] = 'I backup della pagina home del sito possono essere ripristinati solamente nella pagina home del sito.';
$string['executionsuccess'] = 'Il file di backup è stato creato correttamente. ';
$string['extractingbackupfileto'] = 'Estrazione del file di backup su: {$a}';
$string['failed'] = 'Il backup non è andato a buon fine';
$string['filealiasesrestorefailures'] = 'Errori nel ripristino di alias';
$string['filealiasesrestorefailures_help'] = 'Gli alias sono link simbolici a file, tra cui i file memorizzati in repository esterni. In alcuni casi Moodle non può ripristinarli, ad esempio nel caso in cui si tenti di ripristinare backup provenienti da altri siti oppure quando il file collegato non esiste.

Per maggiori informazioni sugli errori consultare il log di ripristino.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Non è stato possibile ripristinare alcuni alias presenti nel file di backup. L\'elenco che segue presenta le sorgenti dei file ai quali si riferivano gli alias nel sito di origine.';
$string['filename'] = 'Nome file';
$string['filereferencesincluded'] = 'Il backup contiene file collegati a contenuti esterni. I file collegati non funzioneranno se si ripristina il backup in altri siti.';
$string['filereferencesnotsamesite'] = 'Il backup proviene da un altro sito, i file collegati non possono essere ripristinati.';
$string['filereferencessamesite'] = 'Il backup proviene dallo stesso sito, i file collegati possono essere ripristinati.';
$string['generalactivities'] = 'Includi attività e risorse';
$string['generalanonymize'] = 'Rendi anonime le informazioni';
$string['generalbackdefaults'] = 'Impostazioni di default';
$string['generalbadges'] = 'Includi badge';
$string['generalblocks'] = 'Includi blocchi';
$string['generalcalendarevents'] = 'Includi eventi di calendario';
$string['generalcomments'] = 'Includi commenti';
$string['generalcompetencies'] = 'Includi competenze';
$string['generalcontentbankcontent'] = 'Includi il deposito dei contenuti';
$string['generalenrolments'] = 'Includi metodi di iscrizione';
$string['generalfiles'] = 'Includi i file';
$string['generalfilters'] = 'Includi filtri';
$string['generalgradehistories'] = 'Includi storie';
$string['generalgroups'] = 'Includi gruppi e raggruppamenti';
$string['generalhistories'] = 'Includi storico';
$string['generallegacyfiles'] = 'Includi file legacy del corso';
$string['generallogs'] = 'Includi log';
$string['generalpermissions'] = 'Includi sovrascrittura dei privilegi';
$string['generalquestionbank'] = 'Includi deposito delle domande';
$string['generalrestoredefaults'] = 'Impostazioni di ripristino di default';
$string['generalrestoresettings'] = 'Impostazioni generali di ripristino';
$string['generalroleassignments'] = 'Includi assegnazioni di ruolo';
$string['generalsettings'] = 'Impostazioni generali del backup';
$string['generalusers'] = 'Includi utenti';
$string['generaluserscompletion'] = 'Includi completamento dell\'utente';
$string['hidetypes'] = 'Nascondi le opzioni di tipo';
$string['importbackupstage16action'] = 'Prosegui';
$string['importbackupstage1action'] = 'Avanti';
$string['importbackupstage2action'] = 'Avanti';
$string['importbackupstage4action'] = 'Esegui importazione';
$string['importbackupstage8action'] = 'Prosegui';
$string['importcurrentstage0'] = 'Scelta corso';
$string['importcurrentstage1'] = 'Impostazioni iniziali';
$string['importcurrentstage16'] = 'Fine';
$string['importcurrentstage2'] = 'Impostazioni schema';
$string['importcurrentstage4'] = 'Verifica e conferma';
$string['importcurrentstage8'] = 'Esegui importazione';
$string['importfile'] = 'Importa un file di backup';
$string['importgeneralduplicateadminallowed'] = 'Consenti risoluzione conflitti admin';
$string['importgeneralduplicateadminallowed_desc'] = 'Se il sito ha già un account con username \'admin\', il ripristino di backup contenenti username \'admin\' provocheranno conflitti. Abilitando questa impostazione il conflitto sarà risolto modificando lo username presente nel backup in \'admin_xyz\'.';
$string['importgeneralmaxresults'] = 'Numero massimo di corsi elencati durante l\'importazione';
$string['importgeneralmaxresults_desc'] = 'Imposta il numero massimo di corsi elencati durante il primo passo del processo di importazione';
$string['importgeneralsettings'] = 'Default generali per l\'importazione';
$string['importrootsettings'] = 'Impostazioni importazione';
$string['importsettings'] = 'Impostazioni generali d\'importazione';
$string['importsuccess'] = 'Importazione completata. Fai click sul pulsante Continua per ritornare al corso.';
$string['includeactivities'] = 'Includi:';
$string['includeditems'] = 'Elementi inclusi:';
$string['includefilereferences'] = 'File collegati a contenuti esterni';
$string['includesection'] = 'Sezione {$a}';
$string['includeuserinfo'] = 'Dati utente';
$string['inprogress'] = 'Il backup è in svolgimento';
$string['jumptofinalstep'] = 'Salta al passo finale';
$string['keep'] = 'Mantieni';
$string['keptroles'] = 'Includi iscrizioni con ruolo';
$string['keptroles_help'] = 'Gli utenti con i ruoli selezionati verranno iscritti nel corso. Se  non è abilitato "Includi dati degli utenti", i dati degli utenti non saranno copiati.';
$string['locked'] = 'Bloccato';
$string['lockedbyconfig'] = 'L\' impostazione è bloccata dalle impostazioni di default';
$string['lockedbyhierarchy'] = 'Bloccato da dipendenze';
$string['lockedbypermission'] = 'Non hai i privilegi necessari per cambiare questa impostazione';
$string['loglifetime'] = 'Conserva i log per';
$string['managefiles'] = 'Gestione file di backup';
$string['mergerestoredefaults'] = 'Default per il ripristino quando si accorpa in un altro corso';
$string['missingfilesinpool'] = 'Non è stati possibile salvare alcuni file nel backup e pertanto non sarà possibile ripristinarli.';
$string['module'] = 'Modulo';
$string['moodleversion'] = 'Versione Moodle';
$string['morecoursesearchresults'] = 'Sono stati trovati più di {$a} corsi. Vengono visualizzati i primi {$a} risultati';
$string['moreresults'] = 'La ricerca ha prodotto troppi risultati. Prova a restringere la ricerca.';
$string['nomatchingcourses'] = 'Non ci sono corsi da visualizzare';
$string['norestoreoptions'] = 'Non ci sono categorie né corsi dove ripristinare.';
$string['originalwwwroot'] = 'URL del backup';
$string['overwrite'] = 'Sovrascrivi';
$string['pendingasyncdeletedetail'] = 'Il corso ha un backup asincrono in attesa. <br/> Non è possibile eliminare corso finché il backup non sarà stato effettuato.';
$string['pendingasyncdetail'] = 'Un utente può avere solo un backup asincrono per la medesima risorsa.<br/>Non è possibile accodare backup asincroni della medesima risorsa perché si rischierebbe di avere tanti backup dello stesso contenuto.';
$string['pendingasyncedit'] = 'Il corso ha un backup o copia asincrono in attesa. Per favore non modificare il corso finché il backup non sarà stato effettuato.';
$string['pendingasyncerror'] = 'La risorsa ha un backup in attesa';
$string['preparingdata'] = 'Preparazione dati';
$string['preparingui'] = 'Preparazione visualizzazione della pagina';
$string['previousstage'] = 'Indietro';
$string['privacy:metadata:backup:detailsofarchive'] = 'Archivio che può contenere dati degli utenti relativi a un corso, come valutazioni, iscrizioni e dati sulle attività.';
$string['privacy:metadata:backup:externalpurpose'] = 'Scopo dell\'archivio è conservare informazioni sul corso in modo che possano essere ripristinate successivamente.';
$string['privacy:metadata:backup_controllers'] = 'Elenco delle operazioni di backup';
$string['privacy:metadata:backup_controllers:itemid'] = 'ID del corso';
$string['privacy:metadata:backup_controllers:operation'] = 'Operazione effettuata, ad esempio, ripristino.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Data di creazione dell\'azione';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Data di modifica dell\'azione';
$string['privacy:metadata:backup_controllers:type'] = 'Tipo di elemento su cui si sta lavorando, ad esempio un\'attività.';
$string['qcategory2coursefallback'] = 'La categoria di domande "{$a->name}", presente nel backup e proveniente contesto della categoria system/course, sarà ripristinata nel contesto del corso.';
$string['qcategorycannotberestored'] = 'Il ripristino non può creare la categoria di domande "{$a->name}"';
$string['question2coursefallback'] = 'La categoria di domande "{$a->name}", presente nel backup e proveniente contesto della categoria system/course, sarà ripristinata nel contesto del corso.';
$string['questionegorycannotberestored'] = 'Il ripristino non può creare le domande "{$a->name}"';
$string['recyclebin_desc'] = 'Da notare che le stesse impostazioni saranno applicate anche al cestino.';
$string['replacerestoredefaults'] = 'Default per il ripristino quando si ripristina in un altro corso eliminando i contenuti';
$string['restoreactivity'] = 'Ripristina attività';
$string['restorecourse'] = 'Ripristina corso';
$string['restorecoursesettings'] = 'Impostazioni corso';
$string['restoredcourseid'] = 'ID del corso ripristinato: {$a}';
$string['restoreexecutionsuccess'] = 'Il corso è stato ripristinato correttamente.';
$string['restorefileweremissing'] = 'Alcuni file non sono stati ripristinati poiché non erano presenti nel backup.';
$string['restorenewcoursefullname'] = 'Nuovo titolo del corso';
$string['restorenewcourseshortname'] = 'Nuovo titolo abbreviato del corso';
$string['restorenewcoursestartdate'] = 'Nuova data di inizio';
$string['restorerolemappings'] = 'Ripristina mappatura ruoli';
$string['restorerootsettings'] = 'Impostazioni ripristino';
$string['restoresection'] = 'Ripristina sezioni';
$string['restorestage1'] = 'Conferma';
$string['restorestage16'] = 'Revisione';
$string['restorestage16action'] = 'Esegui ripristino';
$string['restorestage1action'] = 'Avanti';
$string['restorestage2'] = 'Destinazione';
$string['restorestage2action'] = 'Avanti';
$string['restorestage32'] = 'Esecuzione';
$string['restorestage32action'] = 'Prosegui';
$string['restorestage4'] = 'Impostazioni';
$string['restorestage4action'] = 'Avanti';
$string['restorestage64'] = 'Fine';
$string['restorestage64action'] = 'Prosegui';
$string['restorestage8'] = 'Schema';
$string['restorestage8action'] = 'Avanti';
$string['restoretarget'] = 'Destinazione del ripristino';
$string['restoretocourse'] = 'Ripristina nel corso:';
$string['restoretocurrentcourse'] = 'Ripristino in questo corso';
$string['restoretocurrentcourseadding'] = 'Aggiungi il contenuto del backup a questo corso';
$string['restoretocurrentcoursedeleting'] = 'Elimina il contenuto di questo corso e poi ripristina';
$string['restoretoexistingcourse'] = 'Ripristino in un corso esistente';
$string['restoretoexistingcourseadding'] = 'Aggiungi il backup nel corso esistente';
$string['restoretoexistingcoursedeleting'] = 'Elimina il contenuto del corso esistente e poi ripristina';
$string['restoretonewcourse'] = 'Ripristino in un corso nuovo';
$string['restoringcourse'] = 'Ripristino in esecuzione';
$string['restoringcourseshortname'] = 'ripristino in corso';
$string['rootenrolmanual'] = 'Ripristina come iscrizioni manuali';
$string['rootsettingactivities'] = 'Includi attività e risorse';
$string['rootsettinganonymize'] = 'Rendi anonimi i dati utente';
$string['rootsettingbadges'] = 'Includi badge';
$string['rootsettingblocks'] = 'Includi blocchi';
$string['rootsettingcalendarevents'] = 'Includi eventi del calendario';
$string['rootsettingcomments'] = 'Includi commenti';
$string['rootsettingcompetencies'] = 'Includi competenze';
$string['rootsettingcontentbankcontent'] = 'Includi il deposito dei contenuti';
$string['rootsettingcustomfield'] = 'Includi campi personalizzati';
$string['rootsettingenrolments'] = 'Includi metodi di iscrizione';
$string['rootsettingenrolments_always'] = 'Si, sempre';
$string['rootsettingenrolments_never'] = 'No, ripristina gli utenti iscrivendoli con iscrizione manuale';
$string['rootsettingenrolments_withusers'] = 'Sì, ma soltanto se gli utenti sono inclusi';
$string['rootsettingfiles'] = 'Includi i file';
$string['rootsettingfilters'] = 'Includi filtri';
$string['rootsettinggradehistories'] = 'Includi storico valutazioni';
$string['rootsettinggroups'] = 'Includi gruppi e raggruppamenti';
$string['rootsettingimscc1'] = 'Converti a IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Converti a IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Includi file legacy del corso';
$string['rootsettinglogs'] = 'Includi log del corso';
$string['rootsettingpermissions'] = 'Includi sovrascrittura dei privilegi';
$string['rootsettingquestionbank'] = 'Includi deposito delle domande';
$string['rootsettingroleassignments'] = 'Includi assegnazioni di ruolo';
$string['rootsettings'] = 'Impostazioni backup';
$string['rootsettingusers'] = 'Includi utenti iscritti';
$string['rootsettinguserscompletion'] = 'Includi dati completamento utente';
$string['samesitenotification'] = 'Il backup è stato creato con i riferimenti ai file e pertanto non li contiene. Il ripristino è possibile solo su questo sito.';
$string['sectionactivities'] = 'Attività';
$string['sectioninc'] = 'Inclusi nel backup (senza dati utente)';
$string['sectionincanduser'] = 'Inclusi nel backup con i dati utente';
$string['selectacategory'] = 'Scegli una categoria';
$string['selectacourse'] = 'Scegli un corso';
$string['setting_course_fullname'] = 'Titolo del corso';
$string['setting_course_shortname'] = 'Titolo abbreviato del corso';
$string['setting_course_startdate'] = 'Data di inizio del corso';
$string['setting_keep_groups_and_groupings'] = 'Mantieni gruppi e raggruppamenti esistenti';
$string['setting_keep_roles_and_enrolments'] = 'Mantieni ruoli ed iscrizioni esistenti';
$string['setting_overwrite_conf'] = 'Sovrascrivi la configurazione del corso';
$string['setting_overwrite_course_fullname'] = 'Sovrascrivi il titolo del corso';
$string['setting_overwrite_course_shortname'] = 'Sovrascrivi il titolo abbreviato del corso';
$string['setting_overwrite_course_startdate'] = 'Sovrascrivi la data di inizio del corso';
$string['showtypes'] = 'Visualizza le opzioni di tipo';
$string['sitecourseformatwarning'] = 'Questo è un backup della pagina home del sito, è possibile ripristinarlo solamente nella pagina home del sito.';
$string['skiphidden'] = 'Salta i corsi nascosti';
$string['skiphiddenhelp'] = 'Consente di escludere dal backup i corsi nascosti';
$string['skipmodifdays'] = 'Salta i corsi non modificati per';
$string['skipmodifdayshelp'] = 'Consente di escludere dal backup i corsi non modificati per un dato numero di giorni.';
$string['skipmodifprev'] = 'Salta i corsi non modificati dall\'ultimo backup';
$string['skipmodifprevhelp'] = 'Consente di escludere dal backup i corsi non modificati dalla data del backup più recente. Richiede l\'abilitazione del logging.';
$string['status'] = 'Stato';
$string['storagecourseandexternal'] = 'Area backup del corso e una cartella specifica';
$string['storagecourseonly'] = 'Area backup del corso';
$string['storageexternalonly'] = 'Una cartella specifica, dove salvare i backup automatici';
$string['successful'] = 'Backup completato correttamente';
$string['successfulcopy'] = 'Copia completata correttamente';
$string['successfulrestore'] = 'Ripristino completato correttamente';
$string['timetaken'] = 'Tempo impiegato';
$string['title'] = 'Titolo';
$string['totalcategorysearchresults'] = 'Totale categorie: {$a}';
$string['totalcoursesearchresults'] = 'Totale corsi: {$a}';
$string['undefinedrolemapping'] = 'L\'archetipo \'{$a}\'  ha una mappatura non definita del ruolo.';
$string['unnamedsection'] = 'Sezione senza nome';
$string['userdata'] = 'Includi dati degli utenti';
$string['userdata_help'] = 'Se abilitato, i dati come gli interventi nei forum, consegne dei compiti etc., verranno copiati nel nuovo corso per tutti gli utenti con il ruolo selezionato in "Includi iscrizioni con ruolo".';
$string['userinfo'] = 'Informazioni utente';
