<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'pt', version '4.0'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'O processo da cópia de segurança está concluído';
$string['asyncbackupcompletebutton'] = 'Continuar';
$string['asyncbackupcompletedetail'] = 'O processo da cópia de segurança foi concluído com sucesso.<br/>Pode aceder à cópia de segurança na <a href="{$a}">página de restauro</a>.';
$string['asyncbackuperror'] = 'Ocorreu um erro no processo da cópia de segurança';
$string['asyncbackuperrordetail'] = 'Ocorreu um erro no processo da cópia de segurança. Por favor, contacte o administrador do sistema.';
$string['asyncbackuppending'] = 'O processo da cópia de segurança está pendente';
$string['asyncbackupprocessing'] = 'A cópia de segurança está em andamento';
$string['asyncbadexecution'] = 'Execução incorreta do controlador da cópia de segurança. É {$a} mas devia ser 2.';
$string['asynccheckprogress'] = 'A qualquer instante, poderá acompanhar o progresso na <a href="{$a}">página de restauro</a>.';
$string['asyncemailenable'] = 'Ativar mensagem de notificações';
$string['asyncemailenabledetail'] = 'Se ativar esta opção, os utilizadores receberão uma mensagem quando um restauro/cópia de segurança assíncrona for concluído.';
$string['asyncgeneralsettings'] = 'Restauro/cópia de segurança assíncrona';
$string['asyncmessagebody'] = 'Mensagem';
$string['asyncmessagebodydefault'] = 'A sua operação \'{operation}\' (ID: {backupid}) foi concluída com sucesso! Pode consultar os detalhes aqui: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Mensagem a enviar quando um restauro/cópia de segurança assíncrona for concluída.';
$string['asyncmessagesubject'] = 'Assunto';
$string['asyncmessagesubjectdefault'] = '\'{operation}\' Moodle concluída com sucesso';
$string['asyncmessagesubjectdetail'] = 'Assunto da mensagem';
$string['asyncnowait'] = 'Não precisa de aguardar. O processo irá continuar em segundo plano.';
$string['asyncprocesspending'] = 'Processo pendente';
$string['asyncrestorecomplete'] = 'O processo de restauro está concluído';
$string['asyncrestorecompletebutton'] = 'Continuar';
$string['asyncrestorecompletedetail'] = 'O processo de restauro foi concluído com sucesso. Clique em Continuar para ir para a <a href="{$a}">disciplina do item restaurado</a>.';
$string['asyncrestoreerror'] = 'Ocorreu um erro no processo de restauro';
$string['asyncrestoreerrordetail'] = 'Ocorreu um erro no processo de restauro. Por favor, contacte o administrador do sistema.';
$string['asyncrestoreinprogress'] = 'Restauros em andamento';
$string['asyncrestoreinprogress_help'] = 'Os restauros assíncronos de disciplinas que estão em andamento são mostradas aqui.';
$string['asyncrestorepending'] = 'O processo de restauro está pendente';
$string['asyncrestoreprocessing'] = 'Restauro em andamento';
$string['asyncreturn'] = 'Voltar à disciplina';
$string['autoactivedescription'] = 'Indique se pretende realizar cópias de segurança automáticas. Se escolher "Manual", apenas será possível realizar cópias de segurança automáticas através de script CLI. Isto pode ser feito manualmente na linha de comandos ou via cron.';
$string['autoactivedisabled'] = 'Desativado';
$string['autoactiveenabled'] = 'Ativado';
$string['autoactivemanual'] = 'Manual';
$string['automatedbackupschedule'] = 'Agendamento';
$string['automatedbackupschedulehelp'] = 'Escolha os dias da semana em que serão feitas as cópias de segurança automáticas.';
$string['automatedbackupsinactive'] = 'As cópias de segurança automáticas não foram ativadas pelo administrador do site';
$string['automatedbackupstatus'] = 'Estado das cópias de segurança automáticas';
$string['automateddeletedays'] = 'Apagar as cópias de segurança com mais de';
$string['automatedmaxkept'] = 'Número máximo de cópias de segurança guardadas';
$string['automatedmaxkepthelp'] = 'Especifica o número máximo de cópias de segurança automáticas recentes a serem mantidas em cada disciplina. As cópias de segurança mais antigas serão apagadas automaticamente.';
$string['automatedminkept'] = 'Número mínimo de cópias de segurança guardadas';
$string['automatedminkepthelp'] = 'Caso as cópias de segurança com mais do que um determinado período de tempo sejam apagadas, poderão ocorrer casos de disciplinas que se encontram inativas ficarem sem cópias de segurança. Para prevenir isto, deverá definir qual o número mínimo de cópias de segurança a manter.';
$string['automatedsettings'] = 'Configurações das cópias de segurança automáticas';
$string['automatedsetup'] = 'Configuração das cópias de segurança automáticas';
$string['automatedstorage'] = 'Armazenamento das cópias de segurança automáticas';
$string['automatedstoragehelp'] = 'Escolha a localização dos ficheiros das cópias de segurança automáticas';
$string['backupactivity'] = 'Cópia de segurança da atividade: {$a}';
$string['backupautoactivitiesdescription'] = 'Define o valor predefinido da inclusão de atividades nas cópias de segurança. Para que a Reciclagem funcione, esta configuração tem de estar ativada.';
$string['backupcourse'] = 'Cópia de segurança da disciplina: {$a}';
$string['backupcoursedetails'] = 'Detalhes da disciplina';
$string['backupcoursesection'] = 'Secção: {$a}';
$string['backupcoursesections'] = 'Secções da disciplina';
$string['backupdate'] = 'Data da realização';
$string['backupdetails'] = 'Detalhes da cópia de segurança';
$string['backupdetailsnonstandardinfo'] = 'O ficheiro selecionado não é um ficheiro de cópia de segurança padrão do Moodle. O processo de restauro vai tentar converter o ficheiro para o formato padrão e, em seguida, restaurá-lo.';
$string['backupformat'] = 'Formato';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Formato desconhecido';
$string['backuplog'] = 'Informação técnica e avisos';
$string['backupmode'] = 'Modo';
$string['backupmode10'] = 'Geral';
$string['backupmode20'] = 'Importar';
$string['backupmode30'] = 'Hub';
$string['backupmode40'] = 'Mesmo site';
$string['backupmode50'] = 'Automatizado';
$string['backupmode60'] = 'Convertido';
$string['backupmode70'] = 'Assíncrona';
$string['backupsection'] = 'Secção da disciplina da cópia de segurança: {$a}';
$string['backupsettings'] = 'Configurações da cópia de segurança';
$string['backupsitedetails'] = 'Detalhes do site';
$string['backupstage16action'] = 'Continuar';
$string['backupstage1action'] = 'Seguinte';
$string['backupstage2action'] = 'Seguinte';
$string['backupstage4action'] = 'Processar';
$string['backupstage8action'] = 'Continuar';
$string['backuptype'] = 'Tipo';
$string['backuptypeactivity'] = 'Atividade';
$string['backuptypecourse'] = 'Disciplina';
$string['backuptypesection'] = 'Tópico';
$string['backupversion'] = 'Versão da cópia de segurança';
$string['cannotfindassignablerole'] = 'O papel {$a} no ficheiro da cópia de segurança não pode ser mapeado para nenhum dos papéis para os quais tem permissão para atribuir.';
$string['choosefilefromactivitybackup'] = 'Área das cópias de segurança da atividade';
$string['choosefilefromactivitybackup_help'] = 'As cópias de segurança de atividades utilizando os valores predefinidos são guardadas neste local.';
$string['choosefilefromautomatedbackup'] = 'Cópias de segurança automáticas';
$string['choosefilefromautomatedbackup_help'] = 'Contém cópias de segurança realizadas automaticamente';
$string['choosefilefromcoursebackup'] = 'Cópias de segurança de disciplina';
$string['choosefilefromcoursebackup_help'] = 'As cópias de segurança de disciplinas utilizando os valores predefinidos são guardadas neste local.';
$string['choosefilefromuserbackup'] = 'Área de cópias de segurança privadas';
$string['choosefilefromuserbackup_help'] = 'Os ficheiros de cópia de segurança com a opção "Tornar informação dos utilizadores anónima" ativada são guardados neste local.';
$string['config_keep_groups_and_groupings'] = 'Por predefinição, manter os grupos e agrupamentos.';
$string['config_keep_roles_and_enrolments'] = 'Por predefinição, manter os papéis e inscrições atuais.';
$string['config_overwrite_conf'] = 'Permite que o utilizador substitua a configuração atual da disciplina.';
$string['config_overwrite_course_fullname'] = 'Por predefinição, substituir o nome completo da disciplina pelo que está no ficheiro da cópia de segurança. Isto requer que "Substituir configurações da disciplina" esteja ativado e o utilizador atual tenha a permissão de alterar o nome completo da disciplina (moodle/course:changefullname).';
$string['config_overwrite_course_shortname'] = 'Por predefinição, substituir o nome curto da disciplina pelo que está no ficheiro da cópia de segurança. Isto requer que "Substituir configurações da disciplina" esteja ativado e o utilizador atual tenha a permissão de alterar o nome curto da disciplina (moodle/course:changeshortname).';
$string['config_overwrite_course_startdate'] = 'Por predefinição, substituir a data de início da disciplina pela data do ficheiro da cópia de segurança. Isto requer que "Substituir configurações da disciplina" esteja ativado e o utilizador atual tenha a permissão de alterar as datas da disciplina no restauro (moodle/restore:rolldates).';
$string['configgeneralactivities'] = 'Se ativar esta opção, as atividades serão incluídas nas cópias de segurança.';
$string['configgeneralanonymize'] = 'Se ativar esta opção, toda a informação dos utilizadores será tornada anónima.';
$string['configgeneralbadges'] = 'Se ativar esta opção, as medalhas serão incluídas na cópia de segurança.';
$string['configgeneralblocks'] = 'Se ativar esta opção, os blocos serão incluídos nas cópias de segurança.';
$string['configgeneralcalendarevents'] = 'Se ativar esta opção, os eventos de calendário serão incluídos nas cópias de segurança.';
$string['configgeneralcomments'] = 'Se ativar esta opção, os comentários serão incluídos nas cópias de segurança.';
$string['configgeneralcompetencies'] = 'Se ativar esta opção, as competências serão incluídas nas cópias de segurança.';
$string['configgeneralcontentbankcontent'] = 'Se ativar esta opção, o conteúdo do banco de conteúdos será incluído nas cópia de segurança.';
$string['configgeneralfiles'] = 'Define a predefinição para a opção de inclusão de ficheiros na cópia de segurança. Nota: desativar esta configuração resultará numa cópia de segurança que inclui apenas referências a ficheiros. Isto não é um problema se a cópia de segurança for restaurada no mesmo site e os ficheiros não tiverem sido apagados, de acordo com a configuração \'Limpar repositório de ficheiros de lixo\' (filescleanupperiod).';
$string['configgeneralfilters'] = 'Se ativar esta opção, os filtros serão incluídos nas cópias de segurança';
$string['configgeneralgroups'] = 'Se ativar esta opção, os grupos e agrupamentos serão incluídos nas cópia de segurança.';
$string['configgeneralhistories'] = 'Se ativar esta opção, o histórico dos utilizadores será incluído nas cópias de segurança.';
$string['configgenerallogs'] = 'Se ativar esta opção, os registos de atividade (logs) serão incluídos nas cópias de segurança.';
$string['configgeneralpermissions'] = 'Se ativar esta opção, as permissões dos papéis serão importadas. Isto pode substituir as permissões já existentes dos utilizadores inscritos.';
$string['configgeneralquestionbank'] = 'Se ativar esta opção, a base de dados de perguntas será incluída nas cópias de segurança por predefinição. <strong>Atenção</strong>: Desativar esta configuração irá desativar a cópia de segurança das atividades que usam a base de dados de perguntas, como por exemplo, o Teste.';
$string['configgeneralroleassignments'] = 'Se ativar esta opção, as atribuições de papéis serão incluídas nas cópias de segurança.';
$string['configgeneralusers'] = 'Se ativar esta opção, a informação dos utilizadores será incluída nas cópias de segurança.';
$string['configgeneraluserscompletion'] = 'Se ativar esta opção, a informação sobre a conclusão da disciplina pelos utilizadores será incluída nas cópias de segurança.';
$string['configlegacyfiles'] = 'Se por predefinição, deve incluir, ou não, os ficheiros antigos da disciplina na cópia de segurança. Os ficheiros antigos da disciplina são de versões do Moodle anteriores a 2.0.';
$string['configloglifetime'] = 'Período de tempo em que pretende manter os registos de atividade (logs) das cópias de segurança. Os registos mais antigos do que o definido são automaticamente apagados. Recomenda-se manter este valor baixo porque a quantidade de registos de atividade relativos às cópias pode ser enorme.';
$string['configrestoreactivities'] = 'Define o valor predefinido para o restauro das atividades';
$string['configrestorebadges'] = 'Define o valor predefinido para o restauro das medalhas.';
$string['configrestoreblocks'] = 'Define o valor predefinido para o restauro dos blocos.';
$string['configrestorecalendarevents'] = 'Define o valor predefinido para o restauro dos eventos de calendário.';
$string['configrestorecomments'] = 'Define o valor predefinido para o restauro dos comentários.';
$string['configrestorecompetencies'] = 'Define o valor predefinido para o restauro das competências.';
$string['configrestorecontentbankcontent'] = 'Define os valores predefinidos para restaurar o conteúdo do banco de conteúdos.';
$string['configrestoreenrolments'] = 'Define o valor predefinido para o restauro dos métodos de inscrição.';
$string['configrestorefilters'] = 'Define o valor predefinido para o restauro dos filtros.';
$string['configrestoregroups'] = 'Define o valor predefinido para o restauro de grupos e agrupamentos se estiverem incluídos na cópia de segurança.';
$string['configrestorehistories'] = 'Define o valor predefinido para o restauro do utilizador se estiver incluído na cópia de segurança.';
$string['configrestorelogs'] = 'Se ativar esta opção, os registos serão restaurados se estiverem incluídos na cópia de segurança.';
$string['configrestorepermissions'] = 'Se ativar esta opção, as permissões dos papéis serão restauradas. Isto pode substituir as permissões já existentes dos utilizadores inscritos.';
$string['configrestoreroleassignments'] = 'Se ativar esta opção, as atribuições dos papéis serão restauradas se estiverem incluídas na cópia de segurança.';
$string['configrestoreusers'] = 'Define o valor predefinido para o restauro dos utilizadores se estiverem incluídos na cópia de segurança.';
$string['configrestoreuserscompletion'] = 'Se ativar esta opção, as informações de conclusão do utilizador serão restauradas por predefinição se estiverem incluídas na cópia de segurança.';
$string['confirmcancel'] = 'Cancelar cópia de segurança';
$string['confirmcancelimport'] = 'Cancelar importação';
$string['confirmcancelno'] = 'Não cancelar';
$string['confirmcancelquestion'] = 'Tem a certeza de que pretende cancelar?
Toda a informação que tiver inserido será perdida.';
$string['confirmcancelrestore'] = 'Cancelar restauro';
$string['confirmcancelyes'] = 'Cancelar cópia de segurança';
$string['confirmnewcoursecontinue'] = 'Novo aviso da disciplina';
$string['confirmnewcoursecontinuequestion'] = 'Uma disciplina temporária (oculta) será criada no processo de restauro. Para cancelar o restauro clique em Cancelar. Não feche a janela do navegador durante o restauro.';
$string['copiesinprogress'] = 'Esta disciplina tem cópias em execução. <a href="{$a}">Visualizar progresso das cópias</a>.';
$string['copycoursedesc'] = 'Esta disciplina será duplicada e colocada na categoria de disciplinas selecionada.';
$string['copycourseheading'] = 'Copiar uma disciplina';
$string['copycoursetitle'] = 'Copiar a disciplina: {$a}';
$string['copydest'] = 'Destino';
$string['copyfieldnotfound'] = 'Os dados obrigatórios não foram encontrados para o(s) campo(s): {$a}';
$string['copyformfail'] = 'Ocorreu um erro na submissão AJAX do formulário da cópia da disciplina.';
$string['copyingcourse'] = 'Cópia da disciplina em execução';
$string['copyingcourseshortname'] = 'a copiar';
$string['copyop'] = 'Operação atual';
$string['copyprogressheading'] = 'Cópias de disciplina em execução';
$string['copyprogressheading_help'] = 'Esta tabela mostra o estado de todas as suas cópias de disciplinas não terminadas.';
$string['copyprogresstitle'] = 'Progresso da cópia da disciplina';
$string['copyreturn'] = 'Copiar e voltar';
$string['copysource'] = 'Origem';
$string['copyview'] = 'Copiar e visualizar';
$string['coursecategory'] = 'Categoria para a qual a disciplina será restaurada';
$string['courseid'] = 'ID original';
$string['coursesettings'] = 'Configurações da disciplina';
$string['coursetitle'] = 'Título';
$string['currentstage1'] = 'Configuração inicial';
$string['currentstage16'] = 'Conclusão';
$string['currentstage2'] = 'Configuração da estrutura';
$string['currentstage4'] = 'Revisão';
$string['currentstage8'] = 'Processamento';
$string['enableasyncbackup'] = 'Ativar cópias de segurança';
$string['enableasyncbackup_help'] = 'Se ativar esta opção, todas as operações de cópia de segurança e de restauro serão executadas de forma assíncrona. Isto não afeta importações e exportações. Cópias de segurança e restauros assíncronos permitem que os utilizadores executem outras operações enquanto uma cópia de segurança ou um restauro está em andamento.';
$string['enterasearch'] = 'Insira uma pesquisa';
$string['error_block_for_module_not_found'] = 'Foi encontrada uma instância para bloco (id: {$a->bid}) para a disciplina (id: {$a->mid}). Este bloco não pode ser incluído.';
$string['error_course_module_not_found'] = 'Foi encontrada a disciplina órfã (id: {$a}). Esta não pode ser guardada na cópia de segurança.';
$string['errorcopyingbackupfile'] = 'Erro ao copiar o ficheiro da cópia de segurança para a pasta temporária antes de proceder ao restauro.';
$string['errorfilenamemustbezip'] = 'O ficheiro inserido tem de ser do tipo Zip com a extensão .mbz';
$string['errorfilenamerequired'] = 'Tem de inserir um nome de ficheiro válido para esta cópia de segurança';
$string['errorfilenametoolong'] = 'O comprimento do nome do ficheiro tem de ser menor que 255 caracteres';
$string['errorinvalidformat'] = 'O formato da cópia de segurança é desconhecido.';
$string['errorinvalidformatinfo'] = 'O ficheiro selecionado não é um ficheiro de cópia de segurança Moodle válido e não pode ser restaurado.';
$string['errorminbackup20version'] = 'Esta cópia de segurança foi criada com uma versão de desenvolvimento do Moodle ({$a->backup}). A versão mínima necessária é {$a->min}. O restauro não pode continuar.';
$string['errorrestorefrontpagebackup'] = 'Apenas pode restaurar cópias de segurança da página principal a partir da página principal';
$string['executionsuccess'] = 'O ficheiro da cópia de segurança foi criado com sucesso.';
$string['extractingbackupfileto'] = 'A extrair ficheiro de cópia de segurança para: {$a}';
$string['failed'] = 'Ocorreu um erro na cópia de segurança';
$string['filealiasesrestorefailures'] = 'Não foi possível restaurar os atalhos';
$string['filealiasesrestorefailures_help'] = 'Atalhos são ligações a outros ficheiros, incluindo os que se encontram em repositórios externos. Em alguns casos, o Moodle não consegue restaurá-los, como acontece ao fazer o restauro a partir de outro site ou quando os ficheiros ligados não existem.

Mais informações e o atual motivo do problema poderão ser consultadas no ficheiro de registo do restauro.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Alguns atalhos incluídos no ficheiro da cópia de segurança não puderam ser restaurados. A lista seguinte contém a sua localização e o ficheiro de origem, tal como são referidos no site original.';
$string['filename'] = 'Nome do ficheiro';
$string['filereferencesincluded'] = 'As referências nos ficheiros para conteúdos externos estão incluídas no ficheiro da cópia de segurança. Pode não funcionar se o restauro for feito em outros sites.';
$string['filereferencesnotsamesite'] = 'O ficheiro da cópia de segurança é de outro site, por isso, as referências a ficheiros não podem ser restauradas.';
$string['filereferencessamesite'] = 'O ficheiro da cópia de segurança é deste site, por isso, as referências a ficheiros podem ser restauradas.';
$string['generalactivities'] = 'Incluir atividades e recursos';
$string['generalanonymize'] = 'Tornar a informação anónima';
$string['generalbackdefaults'] = 'Configuração das cópias de segurança';
$string['generalbadges'] = 'Incluir medalhas';
$string['generalblocks'] = 'Incluir blocos';
$string['generalcalendarevents'] = 'Incluir eventos de calendário';
$string['generalcomments'] = 'Incluir comentários';
$string['generalcompetencies'] = 'Incluir competências';
$string['generalcontentbankcontent'] = 'Incluir conteúdo do banco de conteúdos';
$string['generalenrolments'] = 'Incluir os métodos de inscrição';
$string['generalfiles'] = 'Incluir ficheiros';
$string['generalfilters'] = 'Incluir filtros';
$string['generalgradehistories'] = 'Incluir históricos';
$string['generalgroups'] = 'Incluir grupos e agrupamentos';
$string['generalhistories'] = 'Incluir históricos';
$string['generallegacyfiles'] = 'Incluir ficheiros antigos da disciplina';
$string['generallogs'] = 'Incluir registos de atividade';
$string['generalpermissions'] = 'Incluir substituições de permissões';
$string['generalquestionbank'] = 'Incluir base de dados de perguntas';
$string['generalrestoredefaults'] = 'Predefinições gerais do restauro';
$string['generalrestoresettings'] = 'Configurações gerais do restauro';
$string['generalroleassignments'] = 'Incluir atribuições de papéis';
$string['generalsettings'] = 'Configurações gerais da cópia de segurança';
$string['generalusers'] = 'Incluir utilizadores';
$string['generaluserscompletion'] = 'Incluir informação de conclusão dos utilizadores';
$string['hidetypes'] = 'Ocultar opções de tipo';
$string['importbackupstage16action'] = 'Continuar';
$string['importbackupstage1action'] = 'Seguinte';
$string['importbackupstage2action'] = 'Seguinte';
$string['importbackupstage4action'] = 'Realizar importação';
$string['importbackupstage8action'] = 'Continuar';
$string['importcurrentstage0'] = 'Escolha de disciplinas';
$string['importcurrentstage1'] = 'Configuração inicial';
$string['importcurrentstage16'] = 'Conclusão';
$string['importcurrentstage2'] = 'Configuração da estrutura';
$string['importcurrentstage4'] = 'Revisão';
$string['importcurrentstage8'] = 'Realizar importação';
$string['importfile'] = 'Importar um ficheiro de cópia de segurança';
$string['importgeneralduplicateadminallowed'] = 'Permitir a resolução de conflitos de administração';
$string['importgeneralduplicateadminallowed_desc'] = 'Se o site tem uma conta com nome de utilizador \'admin\', pode causar conflitos ao tentar restaurar de um ficheiro de cópia de segurança contendo uma conta com nome de utilizador \'admin\'. Se ativar esta opção, o conflito será resolvido alterando o nome de utilizador no ficheiro de cópia de segurança para \'admin_xyz\'.';
$string['importgeneralmaxresults'] = 'Número máximo de disciplinas listadas para importação';
$string['importgeneralmaxresults_desc'] = 'Isto controla o número de disciplinas que são listadas durante o primeiro passo do processo de importação';
$string['importgeneralsettings'] = 'Configurações predefinidas de importação';
$string['importrootsettings'] = 'Importar configurações';
$string['importsettings'] = 'Configurações gerais de importação';
$string['importsuccess'] = 'A importação foi concluída. Clique para prosseguir para a disciplina.';
$string['includeactivities'] = 'Incluir:';
$string['includeditems'] = 'Itens incluídos:';
$string['includefilereferences'] = 'Referências a conteúdos externos';
$string['includesection'] = 'Secção {$a}';
$string['includeuserinfo'] = 'Informação do utilizador';
$string['inprogress'] = 'Cópia de segurança em andamento';
$string['jumptofinalstep'] = 'Ir para etapa final';
$string['keep'] = 'Manter';
$string['keptroles'] = 'Incluir inscrições dos papéis';
$string['keptroles_help'] = 'Os utilizadores com os papéis selecionados serão inscritos na nova disciplina. Nenhum dado do utilizador será copiado, a menos que a opção \'Incluir dados do utilizador\' esteja ativada.';
$string['locked'] = 'Bloqueado(a)';
$string['lockedbyconfig'] = 'Este parâmetro foi bloqueado por predefinição na configuração da cópia de segurança';
$string['lockedbyhierarchy'] = 'Bloqueado pelas dependências';
$string['lockedbypermission'] = 'Não tem permissões para mudar este parâmetro';
$string['loglifetime'] = 'Manter registos de atividade durante';
$string['managefiles'] = 'Gerir ficheiros de cópias de segurança';
$string['mergerestoredefaults'] = 'Repor predefinições quando restaurar o conteúdo noutra disciplina';
$string['missingfilesinpool'] = 'Não foi possível guardar alguns ficheiros durante a cópia de segurança e por isso não será possível restaurá-los.';
$string['module'] = 'Módulo';
$string['moodleversion'] = 'Versão do Moodle';
$string['morecoursesearchresults'] = 'Foram encontradas mais do que {$a} disciplinas. A exibir os primeiros {$a} resultados';
$string['moreresults'] = 'Existem demasiados resultados. Proceda a uma pesquisa mais específica.';
$string['nomatchingcourses'] = 'Não existem disciplina para mostrar';
$string['norestoreoptions'] = 'Não existem categorias ou disciplinas para onde possa restaurar.';
$string['originalwwwroot'] = 'URL da cópia de segurança';
$string['overwrite'] = 'Substituir';
$string['pendingasyncdeletedetail'] = 'Esta disciplina tem uma cópia de segurança assíncrona pendente.<br/> As disciplinas não podem ser apagadas até que esta cópia de segurança seja concluída.';
$string['pendingasyncdetail'] = 'As cópias de segurança assíncronas permitem que apenas um utilizador tenha uma cópia de segurança pendente para um recurso de cada vez.<br/>Várias cópias de segurança assíncronas do mesmo recurso não podem ser colocadas em fila de espera, uma vez que provavelmente resultaria em várias cópias de segurança com o mesmo conteúdo.';
$string['pendingasyncedit'] = 'Existe uma cópia de segurança assíncrona pendente para esta disciplina. Não edite esta disciplina até que a cópia de segurança esteja concluída.';
$string['pendingasyncerror'] = 'Cópia de segurança pendente para este recurso';
$string['preparingdata'] = 'A preparar dados';
$string['preparingui'] = 'A preparar a exibição da página';
$string['previousstage'] = 'Anterior';
$string['privacy:metadata:backup:detailsofarchive'] = 'Este arquivo pode conter vários dados de utilizador relacionadas com uma disciplina, tais como avaliação, autenticações  do utilizador e dados de atividade.';
$string['privacy:metadata:backup:externalpurpose'] = 'O propósito deste arquivo é armazenar informação relacionada com uma disciplina que pode ser restaurada no futuro.';
$string['privacy:metadata:backup_controllers'] = 'A lista de operações da cópia de segurança';
$string['privacy:metadata:backup_controllers:itemid'] = 'O ID da disciplina';
$string['privacy:metadata:backup_controllers:operation'] = 'A operação que foi executada, ex. Restauro.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Data e hora em que a ação foi criada';
$string['privacy:metadata:backup_controllers:timemodified'] = 'A data e hora em que a ação foi modificada.';
$string['privacy:metadata:backup_controllers:type'] = 'O tipo de item a ser executado, ex. Atividade.';
$string['qcategory2coursefallback'] = 'A categoria de perguntas "{$a->name}", originalmente no contexto da categoria sistema/disciplina no ficheiro da cópia de segurança, vai ser criado no contexto da disciplina aquando do restauro';
$string['qcategorycannotberestored'] = 'A categoria de perguntas "{$a->name}" não pode ser criada através do restauro';
$string['question2coursefallback'] = 'A categoria de perguntas "{$a->name}", originalmente no contexto da categoria sistema/disciplina no ficheiro da cópia de segurança, vai ser criado no contexto da disciplina aquando do restauro';
$string['questionegorycannotberestored'] = 'As perguntas "{$a->name}" não podem ser criadas por restauro';
$string['recyclebin_desc'] = 'Tenha em atenção que estas configurações também serão aplicadas à reciclagem.';
$string['replacerestoredefaults'] = 'Repor predefinições quando restaurar noutra disciplina apagando o conteúdo';
$string['restoreactivity'] = 'Restaurar atividade';
$string['restorecourse'] = 'Restaurar disciplina';
$string['restorecoursesettings'] = 'Configurações da disciplina';
$string['restoredcourseid'] = 'ID da disciplina restaurada: {$a}';
$string['restoreexecutionsuccess'] = 'A disciplina foi restaurada com sucesso.';
$string['restorefileweremissing'] = 'Não foi possível restaurar alguns ficheiros pois estavam em falta no ficheiro da cópia de segurança.';
$string['restorenewcoursefullname'] = 'Nome da nova disciplina';
$string['restorenewcourseshortname'] = 'Nome curto da nova disciplina';
$string['restorenewcoursestartdate'] = 'Nova data de início';
$string['restorerolemappings'] = 'Restaurar mapeamento dos papéis';
$string['restorerootsettings'] = 'Restaurar configurações';
$string['restoresection'] = 'Restaurar secção';
$string['restorestage1'] = 'Confirmar';
$string['restorestage16'] = 'Rever';
$string['restorestage16action'] = 'Realizar restauro';
$string['restorestage1action'] = 'Seguinte';
$string['restorestage2'] = 'Destino';
$string['restorestage2action'] = 'Seguinte';
$string['restorestage32'] = 'Processar';
$string['restorestage32action'] = 'Continuar';
$string['restorestage4'] = 'Configurações';
$string['restorestage4action'] = 'Seguinte';
$string['restorestage64'] = 'Conclusão';
$string['restorestage64action'] = 'Continuar';
$string['restorestage8'] = 'Estrutura';
$string['restorestage8action'] = 'Seguinte';
$string['restoretarget'] = 'Destino do restauro';
$string['restoretocourse'] = 'Restaurar na disciplina:&nbsp;';
$string['restoretocurrentcourse'] = 'Restaurar nesta disciplina';
$string['restoretocurrentcourseadding'] = 'Inserir o conteúdo desta cópia de segurança nesta disciplina';
$string['restoretocurrentcoursedeleting'] = 'Apagar o conteúdo desta disciplina e depois restaurar';
$string['restoretoexistingcourse'] = 'Restaurar numa disciplina já existente';
$string['restoretoexistingcourseadding'] = 'Inserir o conteúdo desta cópia de segurança numa disciplina já existente';
$string['restoretoexistingcoursedeleting'] = 'Apagar o conteúdo de uma disciplina já existente e depois restaurar';
$string['restoretonewcourse'] = 'Restaurar como uma nova disciplina';
$string['restoringcourse'] = 'Restauro de disciplina a decorrer';
$string['restoringcourseshortname'] = 'a restaurar';
$string['rootenrolmanual'] = 'Restaurar como inscrições manuais.';
$string['rootsettingactivities'] = 'Incluir atividades e recursos';
$string['rootsettinganonymize'] = 'Tornar informação dos utilizadores anónima';
$string['rootsettingbadges'] = 'Incluir medalhas';
$string['rootsettingblocks'] = 'Incluir blocos';
$string['rootsettingcalendarevents'] = 'Incluir eventos de calendário';
$string['rootsettingcomments'] = 'Incluir comentários';
$string['rootsettingcompetencies'] = 'Incluir competências';
$string['rootsettingcontentbankcontent'] = 'Incluir conteúdo do banco de conteúdos';
$string['rootsettingcustomfield'] = 'Incluir campos personalizados';
$string['rootsettingenrolments'] = 'Incluir os métodos de inscrição';
$string['rootsettingenrolments_always'] = 'Sim, sempre';
$string['rootsettingenrolments_never'] = 'Não, restaurar os utilizadores como inscrições manuais';
$string['rootsettingenrolments_withusers'] = 'Sim, mas apenas se os utilizadores estão incluídos';
$string['rootsettingfiles'] = 'Incluir ficheiros';
$string['rootsettingfilters'] = 'Incluir filtros';
$string['rootsettinggradehistories'] = 'Incluir histórico das notas';
$string['rootsettinggroups'] = 'Incluir grupos e agrupamentos';
$string['rootsettingimscc1'] = 'Converter para IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Converter para Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Incluir ficheiros antigos da disciplina';
$string['rootsettinglogs'] = 'Incluir relatórios de atividade da disciplina';
$string['rootsettingpermissions'] = 'Incluir substituições de permissões';
$string['rootsettingquestionbank'] = 'Incluir base de dados de perguntas';
$string['rootsettingroleassignments'] = 'Incluir atribuições de papéis';
$string['rootsettings'] = 'Configuração inicial';
$string['rootsettingusers'] = 'Incluir utilizadores inscritos';
$string['rootsettinguserscompletion'] = 'Incluir detalhes da conclusão dos utilizadores';
$string['samesitenotification'] = 'Esta cópia de segurança foi criada apenas com referências a ficheiros, não os ficheiros em si. O restauro da cópia apenas funcionará neste site.';
$string['sectionactivities'] = 'Atividades';
$string['sectioninc'] = 'Incluído na cópia de segurança (sem informação de utilizadores)';
$string['sectionincanduser'] = 'Incluído na cópia de segurança juntamente com a informação dos utilizadores';
$string['selectacategory'] = 'Selecionar uma categoria';
$string['selectacourse'] = 'Selecione uma disciplina';
$string['setting_course_fullname'] = 'Nome da disciplina';
$string['setting_course_shortname'] = 'Nome curto da disciplina';
$string['setting_course_startdate'] = 'Data de início da disciplina';
$string['setting_keep_groups_and_groupings'] = 'Manter os grupos e agrupamentos atuais';
$string['setting_keep_roles_and_enrolments'] = 'Manter inscrições atuais';
$string['setting_overwrite_conf'] = 'Substituir configurações da disciplina';
$string['setting_overwrite_course_fullname'] = 'Substituir o nome completo da disciplina';
$string['setting_overwrite_course_shortname'] = 'Substituir nome curto da disciplina';
$string['setting_overwrite_course_startdate'] = 'Substituir data de início da disciplina';
$string['showtypes'] = 'Mostrar opções de tipo';
$string['sitecourseformatwarning'] = 'Isto é uma cópia de segurança da página principal. Tenha em atenção que estas cópias apenas podem ser restauradas a partir da mesma';
$string['skiphidden'] = 'Ignorar disciplinas ocultas';
$string['skiphiddenhelp'] = 'Determina se as disciplinas ocultas devem, ou não, ser ignoradas';
$string['skipmodifdays'] = 'Ignorar disciplinas que não foram modificadas há';
$string['skipmodifdayshelp'] = 'Determina se são ignoradas as disciplinas que não foram modificadas há um determinado número de dias.';
$string['skipmodifprev'] = 'Ignorar disciplinas que não foram modificadas desde a cópia de segurança anterior';
$string['skipmodifprevhelp'] = 'Se ativar esta opção, as disciplinas que não foram modificadas desde a última cópia de segurança serão ignoradas. Esta ação requer a ativação do registo de atividade.';
$string['status'] = 'Estado';
$string['storagecourseandexternal'] = 'Área de ficheiros de cópias de segurança de disciplina e pasta escolhida';
$string['storagecourseonly'] = 'Área de ficheiros de cópias de segurança de disciplina';
$string['storageexternalonly'] = 'Pasta escolhida para as cópias de segurança automáticas';
$string['successful'] = 'Cópia de segurança criada com sucesso';
$string['successfulcopy'] = 'Cópia efetuada com sucesso';
$string['successfulrestore'] = 'Restauro efetuado com sucesso';
$string['timetaken'] = 'Tempo gasto';
$string['title'] = 'Título';
$string['totalcategorysearchresults'] = 'Total de categorias: {$a}';
$string['totalcoursesearchresults'] = 'Total de disciplinas: {$a}';
$string['undefinedrolemapping'] = 'Mapeamento de papel indefinido para o arquétipo \'{$a}\'.';
$string['unnamedsection'] = 'Secção sem nome';
$string['userdata'] = 'Incluir dados do utilizador';
$string['userdata_help'] = 'Esta configuração determina se dados, tais como publicações no fórum, submissões de trabalhos, etc. serão copiados para a nova disciplina para qualquer utilizador com o papel selecionado em \'Incluir inscrições dos papéis\'.';
$string['userinfo'] = 'Informação do utilizador';
