<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sr_lt', version '4.0'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Prilozi aktivnosti Zadatak';
$string['activitydate:submissionsdue'] = 'Rok:';
$string['activitydate:submissionsopen'] = 'Otvara se:';
$string['activitydate:submissionsopened'] = 'Otvoreno:';
$string['activityeditor'] = 'Uputstva za zadatak';
$string['activityeditor_help'] = 'Postupci koje želite da polaznik uradi za ovaj zadatak. Ovo je prikazano samo na stranici za predaju rada, na kojoj polaznik uređuje i predaje svoj zadatak.';
$string['activityoverview'] = 'Imate zadatke na koje treba obratiti pažnju';
$string['addattempt'] = 'Dozvoli drugi pokušaj';
$string['addnewattempt'] = 'Dodaj novi pokušaj';
$string['addnewattempt_help'] = 'Ovo će kreirati novi prazan rad kako biste mogli da radite na njemu';
$string['addnewattemptfromprevious'] = 'Dodaj novi pokušaj na osnovu prethodno predatog rada';
$string['addnewattemptfromprevious_help'] = 'Ovo će kopirati sadržaj vašeg prethodnog rada u novi kako biste mogli da radite na njemu.';
$string['addnewgroupoverride'] = 'Dodaj izmenu podešavanja za grupu';
$string['addnewuseroverride'] = 'Dodaj izmenu podešavanja za korisnika';
$string['addsubmission'] = 'Dodaj rad';
$string['addsubmission_help'] = 'Još uvek niste predali svoj rad.';
$string['allocatedmarker'] = 'Dodeljeni ocenjivač';
$string['allocatedmarker_help'] = 'Ocenjivač koji je dodeljen za ovaj rad.';
$string['allowsubmissions'] = 'Dozvoli korisniku da nastavi  predaju radova na ovaj zadatak';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Detaljnije informacije o zadatku i obrazac za predaju rada biće dostupni od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Dozvoli predaju od';
$string['allowsubmissionsfromdate_help'] = 'Ako je ova opcija omogućena polaznici neće moći da predaju rad pre ovog datuma. Ako je onemogućena, polaznici će odmah moći da predaju rad.';
$string['allowsubmissionsfromdatesummary'] = 'Ovaj zadatak će prihvatiti predaju radova od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Dozvoli promene predatog rada';
$string['alwaysshowdescription'] = 'Uvek prikaži opis';
$string['alwaysshowdescription_help'] = 'Ako je ova opcija onemogućena, \'Opis zadatka\' će postati vidljiv polaznicima tek od datuma navedenog za podešavanje "Dozvoli predaju od".';
$string['applytoteam'] = 'Primenite ocene i povratne informacije na celu grupu';
$string['assign:addinstance'] = 'Dodavanje novog zadatka';
$string['assign:editothersubmission'] = 'Uredi drugi rad polaznika';
$string['assign:exportownsubmission'] = 'Izvoz sopstvenog rada';
$string['assign:grade'] = 'Ocenjivanje zadatka';
$string['assign:grantextension'] = 'Odobri produžetak';
$string['assign:manageallocations'] = 'Upravljanje ocenjivačima dodeljenim predatim radovima';
$string['assign:managegrades'] = 'Pregledaj i objavi ocene';
$string['assign:manageoverrides'] = 'Upravljanje izmenama podešavanja zadatka';
$string['assign:receivegradernotifications'] = 'Primaj obaveštenja o dodeljenim ocenama';
$string['assign:releasegrades'] = 'Objavi ocene';
$string['assign:revealidentities'] = 'Otkrij identitet polaznika';
$string['assign:reviewgrades'] = 'Pregledaj ocene';
$string['assign:showhiddengrader'] = 'Pogledajte identitet skrivenog ocenjivača';
$string['assign:submit'] = 'Predaj zadatak';
$string['assign:view'] = 'Prikaz zadatka';
$string['assign:viewblinddetails'] = 'Prikaz identiteta polaznika kada je anonimno ocenjivanje omogućeno';
$string['assign:viewgrades'] = 'Prikaz ocena';
$string['assign:viewownsubmissionsummary'] = 'Prikaz sažetka sopstvenog predatog rada';
$string['assignfeedback'] = 'Dodatak za povratne informacije';
$string['assignfeedbackpluginname'] = 'Dodatak za povratne informacije';
$string['assignmentisdue'] = 'Krajnji rok za predaju je istekao';
$string['assignmentmail'] = '{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'

Povratne informacije su pridružene vašem radu i možete ih pogledati  na:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'<i>{$a->assignment}</i>\'.</p>
<p>Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">radu</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\' . Povratne informacije možete pogledati pridružene vašem radu.';
$string['assignmentname'] = 'Naziv zadatka';
$string['assignmentplugins'] = 'Dodaci za zadatak';
$string['assignmentsperpage'] = 'Zadaci po stranici';
$string['assignsubmission'] = 'Dodatak za predaju rada';
$string['assignsubmissionpluginname'] = 'Dodatak za predaju rada';
$string['assigntimeleft'] = 'Preostalo vreme';
$string['attemptheading'] = 'Pokušaj {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Prethodni pokušaji';
$string['attemptnumber'] = 'Broj pokušaja';
$string['attemptreopenmethod'] = 'Dodatni pokušaji';
$string['attemptreopenmethod_help'] = 'Ovo podešavanje određuje da li polaznik može dodatno da pokuša da pošalje svoj rad. Za svaki pokušaj čuvaju se ocena i povratne informacije, a predavač i polaznik ih mogu pregledati. Dostupne su sledeće opcije:

* Nikad - moguć je samo jedan pokušaj.
* Ručno - predavač može dozvoliti dodatne pokušaje.
* Automatski dok ne dobije prelaznu ocenu - dodatni pokušaji za predaju rada su automatski dozvoljeni sve dok polaznik, za ovaj zadatak, ne postigne prelaznu ocenu koja je podešena u knjizi ocena.';
$string['attemptreopenmethod_manual'] = 'Ručno';
$string['attemptreopenmethod_none'] = 'Nikad';
$string['attemptreopenmethod_untilpass'] = 'Automatski dok ne dobije prelaznu ocenu';
$string['attemptsettings'] = 'Podešavanja pokušaja';
$string['availability'] = 'Dostupnost';
$string['back'] = 'Nazad';
$string['backtoassignment'] = 'Povratak na zadatak';
$string['batchoperationconfirmaddattempt'] = 'Dozvolite još jedan pokušaj za izabrane radove?';
$string['batchoperationconfirmdownloadselected'] = 'Želite da  preuzmete izabrane radove?';
$string['batchoperationconfirmgrantextension'] = 'Odobriti produženje roka svim izabranim radovima?';
$string['batchoperationconfirmlock'] = 'Zaključajte sve izabrane predate radove?';
$string['batchoperationconfirmremovesubmission'] = 'Da li želite da uklonite izabrane predate radove?';
$string['batchoperationconfirmreverttodraft'] = 'Vratite izabrane radove u status nacrta?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Želite li da podesite dodelu ocenjivača za sve izabrane predate radove?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Podesiti stanje toka ocenjivanja za sve izabrane radove?';
$string['batchoperationconfirmunlock'] = 'Odključajte sve izabrane predate radove?';
$string['batchoperationlock'] = 'zaključaj predate radove';
$string['batchoperationreverttodraft'] = 'vratite predate radove u status nacrta';
$string['batchoperationsdescription'] = 'Sa izabranima...';
$string['batchoperationunlock'] = 'otključaj predate radove';
$string['batchsetallocatedmarker'] = 'Dodeli ocenjivača za sledeći broj izabranih korisnika: {$a} .';
$string['batchsetmarkingworkflowstateforusers'] = 'Podesi stanje toka ocenjivanja za sledeći broj izabranih korisnika: {$a}.';
$string['beginassignment'] = 'Započnite zadatak';
$string['blindmarking'] = 'Anonimna predaja radova';
$string['blindmarking_help'] = 'Opcija \'Anonimna predaja radova\' skriva od ocenjivača identitet polaznika. Podešavanja za anonimno predati rad biće zaključana onog trenutka kada rad bude predat ili kada bude ocenjen.';
$string['blindmarkingenabledwarning'] = 'Anonimna predaja radova je omogućena za ovu aktivnosti. Ocene se neće biti dodata u knjigu ocena sve dok se ne otkrije identitet učenika preko menija za ocenjivanje.';
$string['cachedef_overrides'] = 'Informacije o izmenama podešavanja za korisnika i grupu';
$string['calendardue'] = 'Ističe krajnji rok za predaju {$a}';
$string['calendargradingdue'] = '{$a} treba da bude ocenjen';
$string['caneditsubmission'] = 'Možete da uredite svoj rad i predate ga nakon isteka vremenskog roka, ali će to biti označeno kao predaja zadatka sa zakašnjenjem.';
$string['changefilters'] = 'Promeni filtere';
$string['changeuser'] = 'Promeni korisnika';
$string['choosegradingaction'] = 'Akcija ocenjivanja';
$string['choosemarker'] = 'Izaberi...';
$string['chooseoperation'] = 'Izaberite operaciju';
$string['clickexpandreviewpanel'] = 'Klikni za proširenje panela za pregled';
$string['collapsegradepanel'] = 'Skupi panel za ocenjivanje';
$string['collapsereviewpanel'] = 'Skupi panel za pregled';
$string['comment'] = 'Komentar';
$string['completiondetail:submit'] = 'Predajte rad';
$string['completionsubmit'] = 'Polaznik mora da preda zadatak';
$string['configshowrecentsubmissions'] = 'Svi mogu da vide obaveštenje o predatim radovima u izveštaju o skorašnjim aktivnostima.';
$string['confirmbatchgradingoperation'] = 'Da li ste sigurni da želite da {$a->operation}  za {$a->count} polaznika?';
$string['confirmstart'] = 'Za završetak ovog zadatka imate {$a} . Kada počnete, tajmer će početi da odbrojava i ne može se pauzirati.';
$string['confirmsubmission'] = 'Da li ste sigurni da želite da  predate svoj rad na ocenjivanje? Više nećete moći da ga menjate.';
$string['confirmsubmissionheading'] = 'Potvrdi predaju';
$string['conversionexception'] = 'Nije moguće konvertovati rad. Izuzetak je glasio: {$a}.';
$string['couldnotconvertgrade'] = 'Nije moguće konvertovati ocenu zadatka za korisnika {$a}.';
$string['couldnotconvertsubmission'] = 'Nije moguće konvertovati predati rad za korisnika {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nije moguće kreirati modul kursa';
$string['couldnotcreatenewassignmentinstance'] = 'Nije moguće kreirati novu instancu zadatka';
$string['couldnotfindassignmenttoupgrade'] = 'Nije moguće naći staru instancu zadatka za nadogradnju';
$string['crontask'] = 'Pozadinska obrada za modul \'Zadatak\'';
$string['currentassigngrade'] = 'Trenutna ocena za zadatak';
$string['currentattempt'] = 'Ovo je pokušaj {$a}.';
$string['currentattemptof'] = 'Ovo je pokušaj {$a->attemptnumber} ( {$a->maxattempts} dozvoljena/ih pokušaja ).';
$string['currentgrade'] = 'Trenutna ocena u knjizi ocena';
$string['cutoffdate'] = 'Definitivni rok';
$string['cutoffdate_help'] = 'Ако је подешен овај датум, након њега неће бити могуће предати рад без продужетка рока за предају.';
$string['cutoffdatecolon'] = 'Definitivni rok: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Definitivni rok za predaju ne može biti pre datuma od kog je dozvoljena predaja rada.';
$string['cutoffdatevalidation'] = 'Definitivni rok ne može biti pre krajnjeg roka za predaju rada.';
$string['defaultlayout'] = 'Restauriraj podrazumevani raspored';
$string['defaultsettings'] = 'Podrazumevana podešavanja zadatka';
$string['defaultsettings_help'] = 'Ova podešavanja definišu podrazmevane vrednosti za sve nove zadatke';
$string['defaultteam'] = 'Podrazumevana grupa';
$string['deleteallsubmissions'] = 'Obriši sve predate radove';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogućeno';
$string['downloadall'] = 'Preuzmi sve predate radove';
$string['downloadasfolders'] = 'Preuzmi radove kao direktorijume';
$string['downloadasfolders_help'] = 'Predati radovi se mogu preuzeti u direktorijumima. Svaki predati rad se smešta u zaseban direktorijum, sa očuvavanjem strukture direktorijuma sa eventualnim poddirektorijumima, a datotekama se ne menjaju nazivi.';
$string['downloadselectedsubmissions'] = 'Preuzmi izabrane radove';
$string['duedate'] = 'Krajnji rok';
$string['duedate_help'] = 'Ovaj datum predstavlja krajnji rok za predaju zadatka. Predaja nakon ovog datuma će i dalje biti dozvoljena, ali će svi radovi predati nakon ovog datuma biti obeleženi kao zakasneli. Da biste sprečili predaju radova nakon određenog datuma podesite definitivni rok za predaju rada.';
$string['duedatecolon'] = 'Krajnji rok: {$a}';
$string['duedatereached'] = 'Krajnji rok za ovaj zadatak je sada istekao';
$string['duedatevalidation'] = 'Krajnji rok za predaju ne može biti pre datuma od kojeg je dozvoljena predaja.';
$string['duplicateoverride'] = 'Kreiraj kopiju izmene';
$string['editaction'] = 'Akcije...';
$string['editattemptfeedback'] = 'Uredi ocenu i povratne informacije za pokušaj broj {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Uređujete povratne informacije za prethodni pokušaj. Ovo je pokušaj {$a->attemptnumber} od ukupno {$a->totalattempts}.';
$string['editingstatus'] = 'Status uređivanja';
$string['editonline'] = 'Uredi onlajn';
$string['editoverride'] = 'Uredi izmenu';
$string['editsubmission'] = 'Uredi rad';
$string['editsubmission_help'] = 'Još uvek možete da napravite promene u svom radu.';
$string['editsubmissionother'] = 'Uredi rad za {$a}';
$string['enabled'] = 'Omogućeno';
$string['enabletimelimit'] = 'Omogući vremenski ograničene zadatke';
$string['enabletimelimit_help'] = 'Ako je ova opcija omogućena, možete podesiti vremensko ograničenje na stranici za podešavanja zadatka.';
$string['errornosubmissions'] = 'Nema predatih radova za preuzimanje';
$string['errorquickgradingvsadvancedgrading'] = 'Ocene nisu sačuvane zato što ovaj zadatak trenutno koristi napredno ocenjivanje';
$string['errorrecordmodified'] = 'Ocene nisu sačuvane zato što je neko izmenio jedan ili više zapisa nakon što ste učitali stranicu';
$string['eventallsubmissionsdownloaded'] = 'Svi predati radovi se preuzimaju.';
$string['eventassessablesubmitted'] = 'Rad je predat.';
$string['eventbatchsetmarkerallocationviewed'] = 'Grupna dodela ocenjivača prikazana';
$string['eventbatchsetworkflowstateviewed'] = 'Grupno podešavanje stanja toka ocenjivanja prikazano';
$string['eventextensiongranted'] = 'Produžetak je odobren.';
$string['eventfeedbackupdated'] = 'Povratne informacije ažurirane';
$string['eventfeedbackviewed'] = 'Povratne informacije prikazane';
$string['eventgradingformviewed'] = 'Obrazac za ocenjivanje prikazan';
$string['eventgradingtableviewed'] = 'Tabela za ocenjivanja prikazana';
$string['eventidentitiesrevealed'] = 'Identiteti su otkriveni.';
$string['eventmarkerupdated'] = 'Dodeljeni ocenjivač je ažuriran.';
$string['eventoverridecreated'] = 'Izmena podešavanja zadatka kreirana';
$string['eventoverridedeleted'] = 'Izmena podešavanja zadatka obrisana';
$string['eventoverrideupdated'] = 'Izmena podešavanja zadatka ažurirana';
$string['eventremovesubmissionformviewed'] = 'Potvrda za uklanjanje poslatog rada prikazana.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Stranica za potvrdu otkrivanja identiteta prikazana';
$string['eventstatementaccepted'] = 'Korisnik je prihvatio izjavu o predaji rada.';
$string['eventsubmissionconfirmationformviewed'] = 'Obrazac za potvrdu o predaji rada prikazan.';
$string['eventsubmissioncreated'] = 'Predati rad kreiran';
$string['eventsubmissionduplicated'] = 'Korisnik je predao duplikat svog rada.';
$string['eventsubmissionformviewed'] = 'Obrazac za predaju rada prikazan';
$string['eventsubmissiongraded'] = 'Predati rad je ocenjen.';
$string['eventsubmissionlocked'] = 'Predati radovi su zaključani za korisnika.';
$string['eventsubmissionremoved'] = 'Predati rad je uklonjen.';
$string['eventsubmissionstatusupdated'] = 'Status predatog rada je ažuriran.';
$string['eventsubmissionstatusviewed'] = 'Status predatog rada je prikazan.';
$string['eventsubmissionunlocked'] = 'Predati radovi su otključani za korisnika.';
$string['eventsubmissionupdated'] = 'Predati rad ažuriran';
$string['eventsubmissionviewed'] = 'Predati rad prikazan';
$string['eventworkflowstateupdated'] = 'Stanje toka ocenjivanja je ažurirano.';
$string['expandreviewpanel'] = 'Raširi panel za pregled';
$string['extensionduedate'] = 'Produženi rok';
$string['extensionnotafterduedate'] = 'Produženi rok mora biti nakon krajnjeg roka za predaju rada.';
$string['extensionnotafterfromdate'] = 'Produženi rok mora biti nakon datuma od kog je dozvoljena predaja rešenja.';
$string['feedback'] = 'Povratne informacije';
$string['feedbackavailableanonhtml'] = 'Imate nove povratne na
rad koji ste predali za zadatak \'<i>{$a->assignment}</i>\'<br /><br />
Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">radu</a>.';
$string['feedbackavailableanonsmall'] = 'Nove povratne informacije za zadatak  {$a->assignment}';
$string['feedbackavailableanontext'] = 'Imate nove povratne na
rad koji ste predali za zadatak \'{$a->assignment}\'

Povratne informacije su pridružene vašem radu i možete ih pogledati na:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} je poslao/la povratne informacije na rad koji ste predali za zadatak  \'<i>{$a->assignment}</i>\'<br /><br /> Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">predatom radu</a>.';
$string['feedbackavailablesmall'] = '{$a->username} je dao/la povratne informacije za zadatak {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'

Povratne informacije su pridružene vašem radu i možete ih pogledati  na:

{$a->url}';
$string['feedbackplugin'] = 'Dodatak za povratne informacije';
$string['feedbackpluginforgradebook'] = 'Dodatak za povratne informacije koji će prebacivati komentare u knjigu ocena';
$string['feedbackpluginforgradebook_help'] = 'Samo jedan dodatak za povratne informacije zadatka može da prebaci povratne informacije u knjigu ocena.';
$string['feedbackplugins'] = 'Dodaci za povratne informacije';
$string['feedbacksettings'] = 'Podešavanja povratnih informacija';
$string['feedbacktypes'] = 'Vrste povratnih informacija';
$string['filesubmissions'] = 'Predaja datoteka';
$string['filter'] = 'Filter';
$string['filterdraft'] = 'Radna verzija';
$string['filtergrantedextension'] = 'Odobren produžetak';
$string['filternone'] = 'Nema filtera';
$string['filternotsubmitted'] = 'Nije predato';
$string['filterrequiregrading'] = 'Zahteva ocenjivanje';
$string['filtersubmitted'] = 'Predato';
$string['fixrescalednullgrades'] = 'Ovaj zadatak sadrži neke pogrešne ocene. Možete <a href="{$a->link}">automatski popraviti ove ocene</a>. Ovo može uticati na ukupnu ocenu.';
$string['fixrescalednullgradesconfirm'] = 'Da li ste sigurni da želite popraviti pogrešne ocene? Sve pogrešne ocene će biti uklonjene. Ovo može uticati na ukupnu ocenu.';
$string['fixrescalednullgradesdone'] = 'Ocene popravljene.';
$string['gradeabovemaximum'] = 'Ocena mora da bude manja od ili jednaka {$a}';
$string['gradebelowzero'] = 'Ocena mora biti veća od ili jednaka nuli';
$string['gradebreakdown'] = 'Razvrstavanje ocena';
$string['gradecanbechanged'] = 'Ocena može biti promenjena';
$string['gradechangessaveddetail'] = 'Promene ocena i povratnih informacija su sačuvane';
$string['graded'] = 'Ocenjeno';
$string['gradedby'] = 'Ocenio/la';
$string['gradedfollowupsubmit'] = 'Ocenjeno - primljen naknadno dostavljen rad';
$string['gradedon'] = 'Ocenjeno';
$string['gradeitem:submissions'] = 'Predati radovi';
$string['gradelocked'] = 'Ova ocena je zaključana ili izmenjena u knjizi ocena.';
$string['gradeoutof'] = 'Ocena od {$a}';
$string['gradeoutofhelp'] = 'Ocena';
$string['gradeoutofhelp_help'] = 'Ovde unesite ocenu za rad polaznika. Možete uključiti decimale.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} je ažurirao/la svoje rešenje zadatka <i>\'{$a->assignment}\' u  {$a->timeupdated}</i><br /><br />
Rešenje je <a href="{$a->url}">dostupno na veb sajtu</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} je ažurirao/la svoj rad za zadatak za zadatak {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} je ažurirao/la svoj rad za zadatak \'{$a->assignment}\' u  {$a->timeupdated}

Rad je dostupno na sledećoj adresi:

{$a->url}';
$string['gradestudent'] = 'Oceni polaznika: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['gradeuser'] = 'Ocena {$a}';
$string['grading'] = 'Ocenjivanje';
$string['gradingchangessaved'] = 'Promene ocena su sačuvane';
$string['gradingduedate'] = 'Podseti me da ocenim do';
$string['gradingduedate_help'] = 'Datum do kog treba da bude završeno ocenjivanje predatih radova. Ovaj datum se koristi kako bi se odredio prioritet obaveštenja koja se pojavljuju na kontrolnom panelu predavača.';
$string['gradingdueduedatevalidation'] = 'Datum do kada radovi treba da budu ocenjeni ne može biti pre datuma kada ističe krajnji rok za njihovu predaju.';
$string['gradingduefromdatevalidation'] = 'Datum do kada radovi treba da budu ocenjeni ne može biti pre datuma od kog je dozvoljena njihova predaja.';
$string['gradingmethodpreview'] = 'Kriterijumi ocenjivanja';
$string['gradingoptions'] = 'Opcije';
$string['gradingstatus'] = 'Status ocenjivanja';
$string['gradingstudent'] = 'Ocenjivanje polaznika';
$string['gradingsummary'] = 'Rezime ocenjivanja';
$string['grantextension'] = 'Odobri produžetak';
$string['grantextensionforusers'] = 'Odobri produžetak za {$a} polaznika';
$string['groupoverrides'] = 'Izmene podešavanja za grupe';
$string['groupoverridesdeleted'] = 'Izmene podešavanja za grupe obrisane';
$string['groupsnone'] = 'Ne postoje grupe kojima možete pristupiti.';
$string['groupsubmissionsettings'] = 'Podešavanja za grupnu predaju rada';
$string['hiddenuser'] = 'Učesnik';
$string['hidegrader'] = 'Sakrijte identitet ocenjivača od polaznika';
$string['hidegrader_help'] = 'Ako je omogućena ova opcija, identitet bilo kog korisnika koji ocenjuje predate radove se ne prikazuje, tako da studenti ne mogu da vide ko je ocenio njihov rad.

Imajte u vidu da ovo podešavanje nema uticaja na polje za komentare na stranici za ocenjivanje.';
$string['hideshow'] = 'Sakrij/Prikaži';
$string['inactiveoverridehelp'] = '* Ova izmena je neaktivna, jer je pristup korisnika aktivnosti ograničen. To može biti zbog grupe ili uloge koji su korisnima dodeljeni, zbog  drugih ograničenja pristupa ili zbog toga što je aktivnost skrivena.';
$string['indicator:cognitivedepth'] = 'Zadatak - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'Zadatak\'.';
$string['indicator:cognitivedepthdef'] = 'Zadatak - kognitivni aspekt';
$string['indicator:cognitivedepthdef_help'] = 'Učesnik je postigao ovaj procenat kognitivnog angažmana koji nude aktivnosti Zadatak tokom ovog intervala analize (Nivoi = Bez pregleda, Pregled, Predaja rada, Pregled povratnih informacija, Komentar na povratne informacije, Ponovna predaja rada nakon pregleda povratnih informacija)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Zadatak - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'Zadatak\'.';
$string['indicator:socialbreadthdef'] = 'Zadatak - socijalni aspekt';
$string['indicator:socialbreadthdef_help'] = 'Učesnik je postigao ovaj procenat socijalnog angažmana koji nude aktivnosti Zadatak tokom ovog intervala analize (Nivoi = Bez učešća, Učesnik sâm, Učesnik sa drugima)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Datoteke sa instrukcijama';
$string['introattachments'] = 'Dodatne datoteke';
$string['introattachments_help'] = 'Dodatne datoteke u zadatku, kao što su šabloni odgovora, mogu da se dodaju.';
$string['invalidfloatforgrade'] = 'Nije moguće razumeti ocenu koja je data: {$a}';
$string['invalidgradeforscale'] = 'Ocena koja je data nije ispravna za tekuću skalu';
$string['invalidoverrideid'] = 'Neispravna ID oznaka izmene';
$string['lastmodifiedgrade'] = 'Poslednje izmene (ocena)';
$string['lastmodifiedsubmission'] = 'Poslednje izmene (predati rad)';
$string['latesubmissions'] = 'Kasno predati radovi';
$string['latesubmissionsaccepted'] = 'Dozvoljeno do {$a}';
$string['loading'] = 'Učitavanje...';
$string['locksubmissionforstudent'] = 'Spreči dalju predaju radova za polaznika: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['locksubmissions'] = 'Zaključaj predate radove';
$string['manageassignfeedbackplugins'] = 'Upravljanje dodacima za povratne informacije';
$string['manageassignsubmissionplugins'] = 'Upravljanje dodacima za predaju radova';
$string['marker'] = 'Ocenjivač';
$string['markerfilter'] = 'Filter ocenjivača';
$string['markerfilternomarker'] = 'Nema ocenjivača';
$string['markingallocation'] = 'Koristi dodelu ocenjivača';
$string['markingallocation_help'] = 'Ako je ovo podešavanje omogućeno, zajedno sa tokom ocenjivanja, ocenjivači mogu biti dodeljeni određenim polaznicima.';
$string['markingworkflow'] = 'Koristi tok ocenjivanja';
$string['markingworkflow_help'] = 'Ako je ovo podešavanje omogućeno, ocene će proći kroz niz faza u procesu ocenjivanja pre nego što budu objavljene polaznicima. Ovo omogućava više krugova ocenjivanja, kao i da ocene budu objavljene polaznicima istovremeno.';
$string['markingworkflowstate'] = 'Stanje toka ocenjivanja';
$string['markingworkflowstate_help'] = 'Moguća stanja toka ocenjivanja mogu da uključe (zavisno od vaših ovlašćenja):

* Neocenjeno - ocenjivač još nije započeo ocenjivanje
* Ocenjuje se - ocenjivač je započeo ocenjivanje ali ga još nije završio
* Ocenjivanje završeno . ocenjivač je završio ocenjivanje,  ali je možda potrebno da se vrati zbog provere/ispravki
* Na pregledu - ocenjivanje je sada kod nadležnog nastavnika odgovornog za proveru kvaliteta
* Spremno za objavljivanje - nadležni nastavnik je zadovoljan sa ocenjivanjem ali može da sačeka pre nego što polaznicima dozvoli pristup ocenama
* Objavljeno - polaznici mogu da pristupe ocenama/povratnim informacijama';
$string['markingworkflowstateinmarking'] = 'Ocenjuje se';
$string['markingworkflowstateinreview'] = 'Na pregledu';
$string['markingworkflowstatenotmarked'] = 'Nije ocenjeno';
$string['markingworkflowstatereadyforrelease'] = 'Spremno za objavu';
$string['markingworkflowstatereadyforreview'] = 'Ocenjivanje završeno';
$string['markingworkflowstatereleased'] = 'Objavljeno';
$string['maxattempts'] = 'Maksimalan broj pokušaja';
$string['maxattempts_help'] = 'Maksimalan broj dozvoljenih pokušaja predaje rada od strane polaznika. Nakon ovog broja pokušaja rad polaznika više ne može biti ponovo otvoren.';
$string['maxgrade'] = 'Maksimalna ocena';
$string['maxperpage'] = 'Maksimalna broj zadataka po stranici';
$string['maxperpage_help'] = 'Maksimalan broj zadataka koji ocenjivač može da prikaže na stranici za ocenjivanje. Ovo podešavanje je korisno kako bi se sprečila vremenska ograničenja na kursevima sa velikim brojem upisanih polaznika.';
$string['messageprovider:assign_notification'] = 'Obaveštenje o zadatku';
$string['modulename'] = 'Zadatak';
$string['modulename_help'] = 'Modul aktivnosti "Zadatak"  pruža mogućnost nastavniku da polaznicima  zadaje zadatke, prikuplja njihove radove, ocenjuje ih, kao i da im  šalje povratne informacije.

Polaznici, kao svoj rad, mogu da predaju različite digitalne sadržaje (datoteke), kao što su tekstualni dokumenti, proračunske tabele, slike, prezentacije ili audio i video klipovi. Alternativno, ili kao dodatak prethodnom, zadatak može da traži od polaznika da tekst unesu direktno u tekst editor. Zadatak, takođe, može da se koristi kao podsetnik polaznicima za „stvarni“ zadatak koji moraju da urade „oflajn“, van sajta, poput  recimo nekog umetničkog rada, crteža itd, a da se pri tome od njih ne zahteva slanje bilo kakvog digitalnog sadržaja. Polaznici mogu da predaju rad individualno ili kao članovi grupe.

Prilikom pregledanja zadataka, nastavnici mogu da ostavljaju komentare, povratne informacije i postavljaju datoteke, kao što su pregledani i  obeleženi radovi polaznika sa komentarima, zasebni dokumenati sa komentarima ili povratne informacije u govornom tj. audio formatu. Zadaci se ocenjuje brojčanom,  ili namenski prilagođenom, skalom za ocenjivanje, ili, korišćenjem naprednih metoda ocenjivanja kao što su rubrike. Završne ocene se zapisuju u knjigu ocena.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Zadaci';
$string['moreusers'] = 'još {$a}...';
$string['multipleteams'] = 'Član više od jedne grupe';
$string['multipleteams_desc'] = 'Ovaj zadatak traži grupnu predaju rada. Član ste više od jedne grupe. Da biste mogli da predate rad morate da budete član samo jedne grupe. Kontaktirajte svog predavača kako bi promenio vaše članstvo u grupi.';
$string['multipleteamsgrader'] = 'Član više od jedne grupe, tako da ne može da preda rad.';
$string['newsubmissions'] = 'Zadaci su predati';
$string['nextuser'] = 'Sledeći korisnik';
$string['noattempt'] = 'Nema pokušaja';
$string['noclose'] = 'Nema datuma zatvaranja zadatka';
$string['nofiles'] = 'Nema datoteka';
$string['nofilters'] = 'Nema filtera';
$string['nograde'] = 'Nema ocene';
$string['nogroupoverrides'] = 'Trenutno nema izmena podešavanja za grupe.';
$string['nomoresubmissionsaccepted'] = 'Dozvoljeno samo polaznicima kojima je odobren produžetak';
$string['none'] = 'Nijedna';
$string['noonlinesubmissions'] = 'Ovaj zadatak ne traži od vas da bilo šta predate  onlajn';
$string['noopen'] = 'Nema datuma otvaranja zadatka';
$string['nooverridedata'] = 'Morate da izmenite barem jedno od podešavanja zadatka.';
$string['nosavebutnext'] = 'Sledeći';
$string['nosubmission'] = 'Za ovaj zadatak još ništa nije predato';
$string['nosubmissionyet'] = 'Nije predat još nijedan rad';
$string['noteam'] = 'Nije član nijedne grupe.';
$string['noteam_desc'] = 'Ovaj zadatak traži grupnu predaju rada. Niste član nijedne grupe, tako da ne možete da predate rad. Kontaktirajte svog predavača kako bi vas dodao u grupu.';
$string['noteamgrader'] = 'Nije član nijedne grupe, tako da ne može da preda rad.';
$string['notgraded'] = 'Nije ocenjeno';
$string['notgradedyet'] = 'Još nije ocenjeno';
$string['notifications'] = 'Obaveštenja';
$string['nouseroverrides'] = 'Trenutno nema izmena podešavanja za korisnike.';
$string['nousers'] = 'Nema korisnika';
$string['nousersselected'] = 'Nije izabran nijedan polaznik';
$string['numberofdraftsubmissions'] = 'Radne verzije';
$string['numberofparticipants'] = 'Učesnici';
$string['numberofsubmissionsneedgrading'] = 'Traži ocenjivanje';
$string['numberofsubmissionsneedgradinglabel'] = 'Potrebno je ocenjivanje: {$a}';
$string['numberofsubmittedassignments'] = 'Predato';
$string['numberofteams'] = 'Grupe';
$string['offline'] = 'Ne traži se onlajn predaja rada';
$string['open'] = 'Otvoreno';
$string['opensubmissionexists'] = 'Otvorena predaja rada već postoji';
$string['outlinegrade'] = 'Ocena: {$a}';
$string['outof'] = '{$a->current} od {$a->total}';
$string['overdue'] = 'Krajnji rok za predaju rada je istekao pre: {$a}';
$string['override'] = 'Izmena';
$string['overridedeletegroupsure'] = 'Da li ste sigurni da želite da izbrišete izmenu podešavanja za grupu {$a}?';
$string['overridedeleteusersure'] = 'Da li ste sigurni da želite da izbrišete izmenu podešavanja za korisnika {$a}?';
$string['overridegroup'] = 'Izmeni podešavanja za grupu';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Izmene';
$string['overrideuser'] = 'Izmeni podešavanja za korisnika';
$string['overrideusereventname'] = '{$a->assign} - Izmena';
$string['page-mod-assign-view'] = 'Glavna stranica modula \'Zadatak\' i stranica za predaju rada';
$string['page-mod-assign-x'] = 'Bilo koja stranica modula \'Zadatak\'';
$string['paramtimeremaining'] = 'Preostalo vreme: {$a}';
$string['participant'] = 'Učesnik';
$string['pluginadministration'] = 'Administracija zadataka';
$string['pluginname'] = 'Zadatak';
$string['preventsubmissionnotingroup'] = 'Neophodna je grupa za predaju rada';
$string['preventsubmissionnotingroup_help'] = 'Ako je ova opcija omogućena, korisnici koji nisu članovi grupe neće moći da predaju radove.';
$string['preventsubmissions'] = 'Spreči korisnika da više ne predaje svoje radove za ovaj zadatak.';
$string['preventsubmissionsshort'] = 'Spreči izmene predatih radova';
$string['previous'] = 'Prethodni';
$string['previoususer'] = 'Prethodni korisnik';
$string['privacy:attemptpath'] = 'pokušaj {$a}';
$string['privacy:blindmarkingidentifier'] = 'Identifikator koji se koristi za anonimno predate radove';
$string['privacy:gradepath'] = 'ocena';
$string['privacy:metadata:assigndownloadasfolders'] = 'Korisnička preferencija vezana za to da li da se više predatih dokumenata preuzme u direktorijume';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Povratne informacije za zadatak.';
$string['privacy:metadata:assignfilter'] = 'Opcije za filtriranje kao što su \'Predato\', \'Nije predato\', \'Zahteva ocenjivanje\', and \'Odobren produžetak\'';
$string['privacy:metadata:assigngrades'] = 'Čuva korisničke ocene za zadatak';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtriraj sažetak zadatka prema dodeljenom ocenjivaču.';
$string['privacy:metadata:assignmentid'] = 'Identifikator zadatka';
$string['privacy:metadata:assignmessageexplanation'] = 'Poruke se polaznicima šalju kroz interni sistem za slanje poruka.';
$string['privacy:metadata:assignoverrides'] = 'Čuva informacije o izmenjenim podešavanjima vezanim za zadatak';
$string['privacy:metadata:assignperpage'] = 'Broj zadataka koji se prikazuju po stranici.';
$string['privacy:metadata:assignquickgrading'] = 'Preferencija vezana za to da li se koristi brzo ocenjivanje ili ne.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Čuva podatke o predatim radovima korisnika';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Podaci o predatim zadacima.';
$string['privacy:metadata:assignuserflags'] = 'Čuva meta podatke korisnika kao što su datumi produžetaka';
$string['privacy:metadata:assignusermapping'] = 'Mapiranje za anonimno predate radova';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtriraj prema različitim stadijumima toka rada.';
$string['privacy:metadata:grade'] = 'Numerička ocena za predati rad. Može se odrediti na osnovu podešavanja skala, naprednih formi za ocenjivanje i sl. ali će uvek biti konvertovana u realni broj.';
$string['privacy:metadata:grader'] = 'Identifikator korisnika koji ocenjuje.';
$string['privacy:metadata:groupid'] = 'Identifikator grupe čiji je korisnik član.';
$string['privacy:metadata:latest'] = 'Prilično pojednostavljuje upite vezane za dobijanje informacija samo o najfriškijem pokušaju.';
$string['privacy:metadata:mailed'] = 'Da li je ovom korisniku već poslata elektronska poruka?';
$string['privacy:metadata:timecreated'] = 'Vreme kreiranja';
$string['privacy:metadata:timestarted'] = 'Započeto';
$string['privacy:metadata:userid'] = 'ID oznaka korisnika';
$string['privacy:studentpath'] = 'radovi polaznika';
$string['privacy:submissionpath'] = 'rad';
$string['quickgrading'] = 'Brzo ocenjivanja';
$string['quickgrading_help'] = 'Brzo ocenjivanje vam dozvoljava da dodelite ocene (i ishode) direktno u tabeli predatih zadataka. Brzo ocenjivanje nije kompatibilno sa naprednim ocenjivanjem i ne preporučuje se kada postoji više ocenjivača.';
$string['quickgradingchangessaved'] = 'Promene ocena su sačuvane';
$string['quickgradingresult'] = 'Brzo ocenjivanje';
$string['recordid'] = 'Indetifikator';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} nakon početka kursa';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} pre početka kursa';
$string['relativedatessubmissiontimeleft'] = 'Izračunato za svakog studenta';
$string['removeallgroupoverrides'] = 'Obriši sve izmene za grupe';
$string['removealluseroverrides'] = 'Obriši sve izmene za korisnike';
$string['removesubmission'] = 'Ukloni predati rad';
$string['removesubmissionconfirm'] = 'Da li ste sigurni da želite da uklonite svoj predati rad?';
$string['removesubmissionconfirmforstudent'] = 'Da li ste sigurni da želite da uklonite predati rad za polaznika {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Da li stvarno želite da uklonite predati rad za {$a}? Imajte na umu da ovim nećete resetovati vremensko ograničenje u podešavanjima. Možete dati više vremena tako što ćete izmeniti podešavanje za korisnike koje se odnosi na vremensko ograničenje.';
$string['removesubmissionconfirmwithtimelimit'] = 'Da li ste sigurni da želite da uklonite svoj predati rad? Imajte na umu da ovo neće resetovati vaše vremensko ograničenje.';
$string['removesubmissionforstudent'] = 'Uklonite predati rad za polaznika: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Držite otvorenim sve dok je opcije za prelaznu ocenu nekompatibilna sa anonimnom predajom radova, pošto se ocene ne šalju u dnevnik ocena sve dok se ne otkrije identitet polaznika.';
$string['requireallteammemberssubmit'] = 'Neophodna je predaja rada od strane svih članova grupe';
$string['requireallteammemberssubmit_help'] = 'Ako je ova opcija omogućena svi članovi grupe polaznika će morati da kliknu na dugme \'Predaj\' za ovaj zadatak, pre nego što grupni rad bude mogao da se smatra predatim. Ako je opcija onemogućena, grupni rad će se smatrati predatim onog momenta kada bilo ko od članova grupe klikne na dugme \'Predaj\'.';
$string['requiresubmissionstatement'] = 'Zahtevaj da polaznici prihvate izjavu o predaji rada';
$string['requiresubmissionstatement_help'] = 'Zahtevaj da polaznici prihvate izjavu o predaji rada za sve predate radove za ovaj zadatak.';
$string['revealidentities'] = 'Otkrij identitet polaznika';
$string['revealidentitiesconfirm'] = 'Da li ste sigurni da želite da otkrijete identitet polaznika za ovaj zadatak? Ova operacija ne može biti poništena, Jednom kada se identitet polaznika otkrije ocene će biti objavljene u knjizi ocena.';
$string['reverttodefaults'] = 'Vrati zadatak na standardna podešavanja';
$string['reverttodraft'] = 'Vrati rad u status nacrta';
$string['reverttodraftforgroup'] = 'Vrati predati rad u status nacrta za grupu {$a}.';
$string['reverttodraftforstudent'] = 'Vrati rad u status nacrta za polaznika: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['reverttodraftshort'] = 'Vrati rad u status nacrta';
$string['reviewed'] = 'Pregledano';
$string['save'] = 'Sačuvaj';
$string['saveallquickgradingchanges'] = 'Sačuvaj sve promene brzog ocenjivanja';
$string['saveandcontinue'] = 'Sačuvaj i nastavi';
$string['savechanges'] = 'Sačuvaj promene';
$string['savegradingresult'] = 'Ocena';
$string['savenext'] = 'Sačuvaj i prikaži sledeći';
$string['saveoverrideandstay'] = 'Sačuvaj i unesi drugu izmenu';
$string['savingchanges'] = 'Čuvanje promena...';
$string['scale'] = 'Skala';
$string['search:activity'] = 'Zadatak - informacije o aktivnosti';
$string['selectedusers'] = 'Odabrani korisnici';
$string['selectlink'] = 'Izaberi...';
$string['selectuser'] = 'Izaberi {$a}';
$string['sendlatenotifications'] = 'Obavesti ocenjivače o radovima koji su predati sa zakašnjenjem';
$string['sendlatenotifications_help'] = 'Ako je ova opcija omogućena, ocenjivači (obično predavači) će dobiti poruku kad god polaznik rad preda sa zakašnjenjem. Način slanja poruke se može podesiti.';
$string['sendnotifications'] = 'Obavesti ocenjivače o predatim radovima';
$string['sendnotifications_help'] = 'Ako je ova opcija omogućena, ocenjivači (obično predavači) će dobiti poruku kad god polaznik rad preda ranije, na vreme i sa zakašnjenjem. Način slanja poruke se može podesiti.';
$string['sendstudentnotifications'] = 'Obavesti polaznika';
$string['sendstudentnotifications_help'] = 'Označite ovo polje kako biste poslali obaveštenje o ažuriranoj oceni ili povratnim informacijama. Ako je u ovom zadatku omogućeno praćenje toka ocenjivanja ili su ocene sakrivene u izveštaju ocenjivača, onda obaveštenje neće biti poslato sve dok se ocena ne objavi.';
$string['sendstudentnotificationsdefault'] = 'Podrazumevano podešavanje za \'Obavesti polaznika\'';
$string['sendstudentnotificationsdefault_help'] = 'Prilikom ocenjivanja svakog polaznika, treba li standardno  označiti opciju \'Obavesti polaznika\'?';
$string['sendsubmissionreceipts'] = 'Pošalji polaznicima potvrdu o predatom radu';
$string['sendsubmissionreceipts_help'] = 'Ovo omogućava slanje potvrdu o predatom radu. Polaznici će primiti obaveštenje svaki put kada uspešno predaju rad.';
$string['setmarkerallocationforlog'] = 'Podesi dodelu ocenjivanja : (id={$a->id}, ime i prezime={$a->fullname}, ocenjivač={$a->marker}).';
$string['setmarkingallocation'] = 'Podesi dodeljenog ocenjivača';
$string['setmarkingworkflowstate'] = 'Podesi stanje toka ocenjivanja';
$string['setmarkingworkflowstateforlog'] = 'Podesi stanje toka ocenjivanja : (id={$a->id}, ime i prezime={$a->fullname}, stanje={$a->state}).';
$string['settings'] = 'Podešavanja zadatka';
$string['showrecentsubmissions'] = 'Prikaži nedavno predate radove';
$string['status'] = 'Status';
$string['studentnotificationworkflowstateerror'] = 'Tok ocenjivanja mora biti u statusu "Objavljeno" da bi se polaznici kursa obavestili o ocenama.';
$string['submission'] = 'Predati rad';
$string['submissionattachments'] = 'Prikaži datoteke samo tokom slanja';
$string['submissionattachments_help'] = 'Označite polje kako bi na stranici za predaju rada bili prikazane samo datoteka. U suprotnom, datoteke će biti prikazane i na stranici zadatka i na stranici za predaju rada.';
$string['submissioncopiedhtml'] = '<p>Napravili ste kopiju svog prethodnog rada za zadatak \'<i>{$a->assignment}</i>\'.</p>
<p>Možete videti status svog <a href="{$a->url}">predatog rada</a>.</p>';
$string['submissioncopiedsmall'] = 'Kopirali ste svoj prethodni rad za zadatak {$a->assignment}';
$string['submissioncopiedtext'] = 'Napravili ste kopiju svog prethodnog rada za zadatak \'{$a->assignment}\'

Možete videti status svog predatog rada:

    {$a->url}';
$string['submissiondrafts'] = 'Zahtevaj da polaznici kliknu na dugme "Predaj\'';
$string['submissiondrafts_help'] = 'Ako je ova opcija omogućena, polaznici će morati da kliknu na dugme \'Predaj\' kako bi svoj rad proglasili konačnim. Ovo omogućava polaznicima da unutar sistema čuvaju verziju nacrta svog rada. Ako se ovo podešavanje sa "Ne" promeni na "Da" nakon što su polaznici predali svoje radove te verzije njihovih radove će biti smatrane konačnim.';
$string['submissioneditable'] = 'Polaznici mogu da uređuju ovaj zadatak';
$string['submissionempty'] = 'Ništa nije predato';
$string['submissionlog'] = 'Polaznik: {$a->fullname}, Status: {$a->status}';
$string['submissionmodified'] = 'Već imate predate radove. Molim vas, napustite ovu stranicu i pokušajte ponovo.';
$string['submissionmodifiedgroup'] = 'Neko drugi je izmenio predati rad. Molim vas, napustite ovu stranicu i pokušajte ponovo.';
$string['submissionnotcopiedinvalidstatus'] = 'Rad nije kopiran zato što je promenjen od momenta kada je ponovo otvoren.';
$string['submissionnoteditable'] = 'Polaznici ne mogu da uređuju ovaj zadatak';
$string['submissionnotopen'] = 'Ovaj zadatak nije otvoren za predaju radova';
$string['submissionnotready'] = 'Ovaj zadatak nije spreman za predaju radova:';
$string['submissionplugins'] = 'Dodaci za predaju radova';
$string['submissionreceipthtml'] = '<p>Predali ste svoj rad za zadatak \'<i>{$a->assignment}</i>\' </p>
<p>Možete videti status svog <a href="{$a->url}">predatog rada</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Vaš rad za zadatak
\'<i>{$a->assignment}</i>\' je predat.<br /><br />
Možete da vidite status vašeg <a href="{$a->url}">predatog rada</a>.';
$string['submissionreceiptothersmall'] = 'Vaš rad za zadatak {$a->assignment} je predat.';
$string['submissionreceiptothertext'] = 'Vaš rad za zadatak
\'<i>{$a->assignment}</i>\' je predat.

Možete da vidite status vašeg predatog rada:

   {$a->url}';
$string['submissionreceipts'] = 'Pošalji potvrdu o predatom radu';
$string['submissionreceiptsmall'] = 'Predali ste svoj rad za zadatak {$a->assignment}';
$string['submissionreceipttext'] = 'Predali ste svoj rad za zadatak \'{$a->assignment}</i>\'

Možete videti status svog rada na sledećoj adresi:

   {$a->url}';
$string['submissionsclosed'] = 'Predaja radova je zatvorena';
$string['submissionsettings'] = 'Podešavanja za predaju rada';
$string['submissionslocked'] = 'Ovaj zadatak ne prihvata predaju radova';
$string['submissionslockedshort'] = 'Promene predatih radova nisu dozvoljene';
$string['submissionstatement'] = 'Izjava o predaji rada';
$string['submissionstatement_help'] = 'Izjava koju svaki polaznik mora da prihvati kako bi predao svoj rad.';
$string['submissionstatementacceptedlog'] = 'Korisnik {$a} je prihvatio/la izjavu o predaji rada';
$string['submissionstatementdefault'] = 'Ovaj rad je moj, osim tamo gde sam priznao/la da su korišćena dela drugih ljudi.';
$string['submissionstatementteamsubmission'] = 'Izjava o predaji grupnog rada';
$string['submissionstatementteamsubmission_help'] = 'Izjava koju svaki polaznik mora da prihvati kako bi predao rad svoje grupe.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Izjava o predaji grupnog rad gde svi članovi grupe predaju rad';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Izjava koju svaki polaznik mora da prihvati kako bi predao svoj rad kao član grupe';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Ovaj rad je moj, kao člana grupa, osim tamo gde sam priznao/la da su korišćena dela drugih ljudi.';
$string['submissionstatementteamsubmissiondefault'] = 'Ovo je rad moje grupe, osim tamo gde smo priznali da su korišćena dela drugih ljudi.';
$string['submissionstatus'] = 'Status predatog rada';
$string['submissionstatus_'] = 'Nema predatih radova';
$string['submissionstatus_draft'] = 'Radna verzija (nije predata)';
$string['submissionstatus_marked'] = 'Ocenjeno';
$string['submissionstatus_new'] = 'Nema predatih radova';
$string['submissionstatus_reopened'] = 'Ponovo otvoreno';
$string['submissionstatus_submitted'] = 'Predato za ocenjivanje';
$string['submissionstatusheading'] = 'Status predatog rada';
$string['submissionsummary'] = '{$a->status}. Poslednji put promenjeno {$a->timemodified}';
$string['submissionteam'] = 'Grupa';
$string['submissiontypes'] = 'Vrsta predatog rada';
$string['submitaction'] = 'Predaj';
$string['submitassignment'] = 'Predaj rad';
$string['submitassignment_help'] = 'Kada se ovaj rad preda, više nećete moći da ga menjate.';
$string['submitforgrading'] = 'Predaj na ocenjivanje';
$string['submitted'] = 'Predato';
$string['submittedearly'] = 'Zadatak je predat {$a} ranije';
$string['submittedlate'] = 'Zadatak je predat {$a} kasnije';
$string['submittedlateshort'] = '{$a} kasnije';
$string['submittedovertime'] = 'Rad je predat {$a} nakon isteka vremenskog ograničenja';
$string['submittedundertime'] = 'Rad je predat {$a} pre isteka vremenskog ograničenja';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Dodatak za povratne informacije';
$string['subplugintype_assignfeedback_plural'] = 'Dodaci za povratne informacija';
$string['subplugintype_assignsubmission'] = 'Dodatak za predaju rada';
$string['subplugintype_assignsubmission_plural'] = 'Dodaci za predaju rada';
$string['teamname'] = 'Tim: {$a}';
$string['teamsubmission'] = 'Polaznici predaju radove u grupama';
$string['teamsubmission_help'] = 'Ako je ova opcija omogućena, polaznici će biti podeljeni u grupe na osnovu podrazumevanog skupa grupa ili namenski prilagođenog grupisanja. Grupni rad će biti deljen između članova grupe i svi članovi grupe će videti promene u radu koje budu uneli drugi članovi grupe.';
$string['teamsubmissiongroupingid'] = 'Grupisanje za grupe polaznika';
$string['teamsubmissiongroupingid_help'] = 'Ovo je grupisanje koje će Zadatak koristiti kako bi pronašao grupe za grupe polaznika. Ukoliko nije podešeno koristiće se podrazumevana podešavanja za grupe.';
$string['textinstructions'] = 'Uputstva za zadatak';
$string['timelimit'] = 'Vremensko ograničenje';
$string['timelimit_help'] = 'Ako je ova opcija omogućena, vremensko ograničenje je navedeno na stranici zadatka i tajmer je prikazan tokom zadatka.';
$string['timelimitnotenabled'] = 'Vremensko ograničenje nije omogućeno za zadatak.';
$string['timelimitpassed'] = 'Rok je istekao';
$string['timemodified'] = 'Poslednje izmene';
$string['timeremaining'] = 'Preostalo vreme';
$string['timeremainingcolon'] = 'Preostalo vreme: {$a}';
$string['togglezoom'] = 'Uvećaj/umanji region';
$string['ungroupedusers'] = 'Podešavanje \'Neophodna je grupa za predaju rada\' je omogućeno, ali neki korisnici nisu članovi nijedne grupe, ili su članovi više od jedne grupe, tako da ne mogu da predaju rad.';
$string['ungroupedusersoptional'] = 'Podešavanje "Polaznici predaju u grupama" je omogućeno a neki korisnici ili nisu članovi nijedne grupe ili su članovi više grupa. Molimo uzmite u obzir da će ti polaznici predati rešenje zadatka kao članovi "Podrazumevane grupe".';
$string['unlimitedattempts'] = 'Neograničeno';
$string['unlimitedattemptsallowed'] = 'Neograničen broj pokušaja';
$string['unlimitedpages'] = 'Neograničeno';
$string['unlocksubmissionforstudent'] = 'Dozvoli predaju radova za polaznika: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['unlocksubmissions'] = 'Otključaj predate radove';
$string['unsavedchanges'] = 'Nesačuvane promene';
$string['unsavedchangesquestion'] = 'Postoje promene ocena ili povratnih informacija koje nisu sačuvane. Da li želite da sačuvate promene i nastavite dalje?';
$string['updategrade'] = 'Ažuriraj ocenu';
$string['updatetable'] = 'Sačuvaj i ažuriraj tabelu';
$string['upgradenotimplemented'] = 'Nadogradnja nije implementirana u dodatku ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Podrazumevana podešavanja korisničkog zadatka';
$string['userextensiondate'] = 'Produžetak je odobren do: {$a}';
$string['usergrade'] = 'Vodič za korisnike';
$string['useridlistnotcached'] = 'Izmene ocena NISU sačuvane jer sistem nije mogao da utvrdi na koji predati rad su se odnosile.';
$string['useroverrides'] = 'Izmene podešavanja za korisnike';
$string['useroverridesdeleted'] = 'Izmene podešavanja za korisnike obrisane';
$string['usersnone'] = 'Nijedan polaznik nema pristup ovom zadatku';
$string['usersubmissioncannotberemoved'] = 'Rad koji je predao/la {$a} ne može biti uklonjen.';
$string['userswhoneedtosubmit'] = 'Korisnici koji treba da predaju rešenje: {$a}';
$string['validmarkingworkflowstates'] = 'Ispravna stanja toka ocenjivanja';
$string['viewadifferentattempt'] = 'Pogledaj drugi pokušaj';
$string['viewbatchmarkingallocation'] = 'Pogledaj stranicu za grupnu dodelu ocenjivača.';
$string['viewbatchsetmarkingworkflowstate'] = 'Pogledaj stranicu za grupno podešavanje toka ocenjivanja.';
$string['viewfeedback'] = 'Pogledajte povratne informacije';
$string['viewfeedbackforuser'] = 'Pogledajte povratne informacije za korisnika {$a}';
$string['viewfull'] = 'Prikaži sve';
$string['viewfullgradingpage'] = 'Otvorite stranicu za ocenjivanje u punom formatu kako biste dali povratne informacije';
$string['viewgradebook'] = 'Pogledaj knjigu ocena';
$string['viewgrading'] = 'Pogledaj sve predate radove';
$string['viewgradingformforstudent'] = 'Pogledajte stranicu za ocenjivanje za  polaznika: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Pogledajte stranicu za predaju sopstvenog rada';
$string['viewownsubmissionstatus'] = 'Pogledajte stranicu statusa sopstvenog rada';
$string['viewrevealidentitiesconfirm'] = 'Pogledajte stranicu sa potvrdom za otkrivanje identiteta polaznika';
$string['viewsubmission'] = 'Pogledaj predati rad';
$string['viewsubmissionforuser'] = 'Pogledaj predati rad za korisnika: {$a}';
$string['viewsubmissiongradingtable'] = 'Pogledaj tabelu za ocenjivanje predatih radova';
$string['viewsummary'] = 'Prikaži sažetak';
$string['workflowfilter'] = 'Filter toka ocenjivanja';
$string['xofy'] = '{$a->x} od {$a->y}';
