<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'it', version '4.0'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'La♭ maggiore';
$string['abminor'] = 'La♭ minore';
$string['acc_b'] = '♭';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '♮';
$string['acc_sharp'] = '♯';
$string['acc_x'] = 'x';
$string['alto'] = 'Contralto';
$string['altoclef'] = 'Chiave di contralto';
$string['anmajor'] = 'La maggiore';
$string['anminor'] = 'La  minore';
$string['answerlbl'] = 'Risposta';
$string['asharpminor'] = 'La♯ minore';
$string['aug10'] = '10ma eccedente';
$string['aug11'] = '11ma eccedente';
$string['aug12'] = '12ma eccedente';
$string['aug13'] = '13ma eccedente';
$string['aug2'] = '2a eccedente';
$string['aug3'] = '3a eccedente';
$string['aug4'] = '4a eccedente';
$string['aug5'] = '5a eccedente';
$string['aug6'] = '6a eccedente';
$string['aug6thfr'] = '6a eccedente francese';
$string['aug6thgr'] = '6a eccedente tedesca';
$string['aug6thit'] = '6a eccedente italiana';
$string['aug7'] = '7ma eccedente';
$string['aug8'] = '8va eccedente';
$string['aug9'] = '9a eccedente';
$string['augmented'] = 'Eccedente';
$string['bass'] = 'Basso';
$string['bassclef'] = 'Chiave di basso';
$string['bbmajor'] = 'Si♭ maggiore';
$string['bbminor'] = 'Si♭ minore';
$string['bnmajor'] = 'Si maggiore';
$string['bnminor'] = 'Si minore';
$string['cbmajor'] = 'Do♭ maggiore';
$string['chordquality'] = 'Tipo di accordo';
$string['chordquality-random'] = 'Tipi possibili di accordo';
$string['chordquality_write_questionastext'] = 'Risposta tipo di accordo';
$string['chordquality_write_questionastext_help'] = '<p>Scrivi un elenco di note separate da virgola, senza spazi, usando la seguente sintassi:</p><p>[Nome della nota in maiuscolo][Alterazione
("n" = naturale, "#" = diesis, "b" = bemolle, "x" = doppio-diesis, "bb" = doppio-bemolle)]4, ... </p>
<p>Ad esempio: <b>risposta=>Don4,Min4,Sol#4</b></p>';
$string['chordquality_write_questionasui'] = 'Risposta funzione armonica';
$string['chordquality_write_questionasui_help'] = '<p>Scrivi le note cliccando sul pentagramma dopo aver selezionato il tipo di alterazione nella barra degli strumenti a destra. Per cancellare una nota clicca di nuovo su di essa.</p>';
$string['chordroot'] = 'Fondamentale dell\'accordo';
$string['clef'] = 'Chiave';
$string['clef-random'] = 'Chiavi possibili';
$string['cnmajor'] = 'Do maggiore';
$string['cnminor'] = 'Do minore';
$string['considerregister'] = 'Registro incluso';
$string['considerregister_help'] = 'Indica se il registro di una nota deve essere incluso come parte della domanda';
$string['correctansweris'] = 'La risposta corretta è:';
$string['correctansweris_morethanone'] = 'Una possibile risposta corretta è';
$string['csharpmajor'] = 'Do♯ maggiore';
$string['csharpminor'] = 'Do♯ minore';
$string['dbmajor'] = 'Re♭ maggiore';
$string['dim10'] = '10ma diminuita';
$string['dim11'] = '11ma diminuita';
$string['dim12'] = '12ma diminuita';
$string['dim13'] = '13ma diminuita';
$string['dim2'] = '2a diminuita';
$string['dim3'] = '3a diminuita';
$string['dim4'] = '4a diminuita';
$string['dim5'] = '5a diminuita';
$string['dim6'] = '6a diminuita';
$string['dim7'] = '7ma diminuita';
$string['dim8'] = '8va diminuita';
$string['dim9'] = '9a diminuita';
$string['diminished'] = 'Diminuita';
$string['dirasc'] = 'Sopra la nota';
$string['dirdesc'] = 'Sotto la nota';
$string['direction'] = 'Direzione';
$string['displaykeysignature'] = 'Mostra l\'armatura in chiave';
$string['dnmajor'] = 'Re maggiore';
$string['dnminor'] = 'Re minore';
$string['dsharpminor'] = 'Re♯ minore';
$string['ebmajor'] = 'MI♭ maggiore';
$string['ebminor'] = 'Mi♭ minore';
$string['emptykeysignature'] = 'Armatura in chiave vuota';
$string['enmajor'] = 'Mi maggiore';
$string['enminor'] = 'Mi minore';
$string['fnmajor'] = 'Fa maggiore';
$string['fnminor'] = 'Fa minore';
$string['fsharpmajor'] = 'Fa♯ maggiore';
$string['fsharpminor'] = 'Fa♯ minore';
$string['gbmajor'] = 'Sol♭ maggiore';
$string['givennoteelementgroup'] = 'La nota data';
$string['gnmajor'] = 'Sol maggiore';
$string['gnminor'] = 'Sol minore';
$string['grandstaff'] = 'Pentagramma doppio';
$string['gsharpminor'] = 'Sol♯ minore';
$string['harmonicfunction_write_questionastext'] = 'Risposta funzione armonica';
$string['harmonicfunction_write_questionastext_help'] = '<p>Scrivi un elenco di note separate da virgola, senza spazi, usando la seguente sintassi:</p><p>[Nome della nota in maiuscolo][Alterazione
("n" = naturale, "#" = diesis, "b" = bemolle, "x" = doppio-diesis, "bb" = doppio-bemolle)]4, ... </p>
<p>Ad esempio: <b>risposta=>Don4,Min4,Sol#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Risposta funzione armonica';
$string['harmonicfunction_write_questionasui_help'] = '<p>Scrivi le note cliccando sul pentagramma dopo aver selezionato il tipo di alterazione nella toolbar a destra. Per cancellare una nota clicca di nuovo su di essa.</p>';
$string['harmonicfunctiontype-random'] = 'Funzioni armoniche possibili';
$string['hfidentifyresponsetypes'] = 'Funzoni armoniche possibili in risposta';
$string['hftype_aug6th'] = '6a eccedente';
$string['hftype_diatonictriad'] = 'Triade diatonica';
$string['hftype_dom7th'] = 'Settima di dominante';
$string['hftype_extendeddom'] = 'Dominante estesa (9, 11 o 13)';
$string['hftype_leadingtone7thfullydim'] = 'Settima di sensibile (diminuita)';
$string['hftype_leadingtone7thhalfdim'] = 'Settima di sensibile (semidiminuita)';
$string['hftype_neapolitan'] = 'Napoletana';
$string['hftype_nondom7th'] = 'Settima non dominante';
$string['hftype_secdom7th'] = 'Dominante secondaria (settima)';
$string['hftype_secdomtriad'] = 'Dominante secondaria (triade)';
$string['hftype_secltfullydim'] = 'Settima di sensibile secondaria (diminuita)';
$string['hftype_seclthalfdim'] = 'Settima di sensibile secondaria (semidiminuita)';
$string['hftype_seclttriad'] = 'Sensibile secondaria (triade)';
$string['hftype_secnondom7th'] = 'Settima secondaria non dominante';
$string['hftype_secnondomtriad'] = 'Triade secondaria non dominante';
$string['includealterations'] = 'Include le alterazioni';
$string['includealterations_help'] = 'Indica se le alterazioni devono essere incluse come parte della domanda';
$string['includestaticnote'] = 'Inclusa la nota';
$string['interval_write_questionastext'] = 'Risposta intervallo inserita';
$string['interval_write_questionastext_help'] = '<p>Scrivi la nota senza spazi usando la seguente sintassi:</p><p>[Nome della nota in maiuscolo] [Alterazione ("n" = naturale, "#" = diesis,
"b" = bemolle, "x" = doppio-diesis, "bb" = doppio-bemolle)] [Registro (una cifra compresa fra 1 and 6, seguendo
la notazione scientifica delle altezze)]</p><p>Esempi:
</p><ul><li><b>Soln5</b></li><li><b>La#4</b></li><li><b>Mibb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Risposta intervallo inserita';
$string['interval_write_questionasui_help'] = '<p>Scrivi la nota cliccando sul pentagramma dopo aver selezionato il tipo di alterazione nella toolbar a destra. Per cancellare una nota clicca di nuovo su di essa.</p>';
$string['javascriptrequired'] = 'Il testo deve essere sostituito da un\'interfaccia grafica che richiede l\'abilitazione di javascript sul tuo browser';
$string['keyboard_input_questionasui'] = 'Risposta input sulla tastiera inserita';
$string['keyboard_input_questionasui_help'] = '<p>Scrivi le note cliccando sulla tastiera. Per cancellare una nota clicca di nuovo su di essa.</p>';
$string['keymode'] = 'Tonalità';
$string['keysignature_write_questionastext'] = 'Risposta alterazioni in tonalità inserita';
$string['keysignature_write_questionastext_help'] = '<p>Scrivi una lista di alterazioni (tra 1 e 7) separate da una virgola, senza spazi, utilizzando la seguente sintassi:</p><p>[Nome della nota in maiuscolo]
[Alterazione ("#" = diesis, "b" = bemolle)] [Registro (una cifra compresa tra 2 e 5, seguendo la notazione scientifica delle altezze)], ... </p><p>Esempio: <b>La#4,Fa#4,Sol#4</b></p>';
$string['keysignature_write_questionasui'] = 'Risposta alterazioni in tonalità inserita';
$string['keysignature_write_questionasui_help'] = '<p>Scrivi le alterazioni cliccando sul pentagramma dopo aver selezionato il tipo di alterazione nella toolbar a destra. Per cancellare una alterazione clicca di nuovo su di essa.</p>';
$string['lbl_harmonicfunction'] = 'Funzione armonica';
$string['maj10'] = '10ma maggiore';
$string['maj13'] = '13ma maggiore';
$string['maj2'] = '2a maggiore';
$string['maj3'] = '3a maggiore';
$string['maj6'] = '6a maggiore';
$string['maj7'] = '7ma maggiore';
$string['maj9'] = '9a maggiore';
$string['major'] = 'Maggiore';
$string['min10'] = '10ma minore';
$string['min13'] = '31ma minore';
$string['min2'] = '2a minore';
$string['min3'] = '3a minore';
$string['min6'] = '6a minore';
$string['min7'] = '7a minore';
$string['min9'] = '9a minore';
$string['minor'] = 'Minore';
$string['mode-random'] = 'Modi possibili';
$string['musicqtype'] = 'Tipo di domanda musicale';
$string['musictheory_gradingstrategy'] = 'Metodo di valutazione';
$string['musictheory_gradingstrategy_help'] = '<p>Il metododi valutazione specifica come verrà valutata una risposta.</p>
<p><b>Tutto o niente</b>: La risposta data viene confrontata con la risposta corretta. Se la risposta data è corretta, viene assegnata la valutazione piena. Se la risposta è sbagliata viene assegnato uno zero.</p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Metodo di valutazione';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>Il metodo di valutazione specifica come verrà valutata una risposta.</p>
<p><b>Tutto o niente</b>: La risposta data viene confrontata con la risposta corretta. Se la risposta data è corretta, viene assegnata la valutazione piena. Se la risposta è sbagliata viene assegnato uno zero.</p>
<p><b>Credito parziale per ogni nota corretta</b>:
Un metodo di valutazione che suddivide equamente il risultato per il numero di note della scala che l\'utente deve scrivere, e assegna il punteggio parziale per ciascuna nota corretta.</p>';
$string['musictheory_intervalelementgroup'] = 'Intervallo';
$string['musictheory_intervalelementgroup_help'] = 'Indica il tipo di intervallo';
$string['musictheory_intervalelementgroup_random'] = 'Possibili intervalli';
$string['nosectonic'] = '[Nessuna tonica secondaria]';
$string['note_write_questionastext'] = 'Nota inserita in risposta';
$string['note_write_questionastext_help'] = '<p>Scrivi la nota senza spazi usando la seguente sintassi:</p><p>[Nome della nota in maiuscolo] [Alterazione ("n" = naturale, "#" = diesis,
"b" = bemolle, "x" = doppio-diesis, "bb" = doppio-bemolle)] [Registro (una cifra compresa fra 1 and 6, seguendo
la notazione scientifica delle altezze)]</p><p>Esempi:
</p><ul><li><b>Soln5</b></li><li><b>La#4</b></li><li><b>Mibb3</b></li></ul>';
$string['note_write_questionasui'] = 'Risposta nota inserita';
$string['note_write_questionasui_help'] = '<p>Scrivi la nota cliccando sul pentagramma dopo aver selezionato il tipo di alterazione nella toolbar a destra. Per cancellare una nota clicca di nuovo su di essa.</p>';
$string['notea'] = 'La';
$string['noteb'] = 'Si';
$string['notec'] = 'Do';
$string['noted'] = 'Re';
$string['notee'] = 'Mi';
$string['notef'] = 'Fa';
$string['noteg'] = 'Sol';
$string['notelbl'] = 'Nota';
$string['per11'] = '11ma giusta';
$string['per12'] = '12ma giusta';
$string['per4'] = '4a giusta';
$string['per5'] = '5a giusta';
$string['per8'] = 'Ottava giusta';
$string['perfect'] = 'Giusta';
$string['pluginname'] = 'Teoria Musicale';
$string['pluginname_help'] = 'Questo genere di domanda abilita la creazione di diversi tipi di esercizi di teoria musicale utilizzando una interfaccia grafica.';
$string['pluginname_link'] = 'question/type/musictheory';
$string['pluginnameadding'] = 'Aggiunta di una domanda di teoria musicale';
$string['pluginnameediting'] = 'Modifica di una domanda di teoria musicale';
$string['pluginnamesummary'] = 'Abilita la creazione di diversi tipi di esercizi di teoria musicale';
$string['possiblescalesinresponse'] = 'Possibili tipi di scale in risposta';
$string['qtype_chordquality-identify'] = 'Identificazione del tipo di accordo';
$string['qtype_chordquality-identify-random'] = 'Identificazione del tipo di accordo (casuale)';
$string['qtype_chordquality-write'] = 'Scrittura del tipo di accordo';
$string['qtype_chordquality-write-random'] = 'Scrittura del tipo di accordo (casuale)';
$string['qtype_harmonicfunction-identify'] = 'Identificazione della funzione armonica';
$string['qtype_harmonicfunction-identify-random'] = 'Identificazione della funzione armonica (casuale)';
$string['qtype_harmonicfunction-write'] = 'Scrittura della funzione armonica';
$string['qtype_harmonicfunction-write-random'] = 'Scrittura della funzione armonica (casuale)';
$string['qtype_interval-identify'] = 'Identificazione degli intervalli';
$string['qtype_interval-identify-random'] = 'Identificazione degli intervalli (casuale)';
$string['qtype_interval-write'] = 'Scrittura degli intervalli';
$string['qtype_interval-write-random'] = 'Scrittura degli intervalli (casuale)';
$string['qtype_keyboard-input'] = 'Tastiera';
$string['qtype_keysignature-identify'] = 'Identificazione delle alterazioni in chiave';
$string['qtype_keysignature-identify-random'] = 'Identificazione delle alterazioni in chiave (casuale)';
$string['qtype_keysignature-write'] = 'Scrittura delle alterazioni in chiave';
$string['qtype_keysignature-write-random'] = 'Scrittura delle alterazioni in chiave (casuale)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Tutto o niente';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Tutto o niente';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Tutto o niente';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Tutto o niente';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Tutto o niente';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Tutto o niente';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Credito parziale per ciascuna nota corretta';
$string['qtype_note-identify'] = 'Identificazione note';
$string['qtype_note-identify-random'] = 'Identificazione note (casuale)';
$string['qtype_note-write'] = 'Scrittura note';
$string['qtype_note-write-random'] = 'Scrittura note (casuale)';
$string['qtype_scale-identify'] = 'Identificazione scale';
$string['qtype_scale-identify-random'] = 'Identificazione scale (casuale)';
$string['qtype_scale-write'] = 'Scrittura scale';
$string['qtype_scale-write-random'] = 'Scrittura scale (cas)';
$string['quality-random'] = 'Tipi possibili';
$string['qualityaug'] = 'Eccedente';
$string['qualitydim'] = 'Diminuito/a';
$string['qualitymaj'] = 'Maggiore';
$string['qualitymin'] = 'Minore';
$string['qualityper'] = 'Giusto';
$string['questionoptions'] = 'Opzioni della domanda';
$string['questiontext'] = 'Testo della domanda';
$string['questiontext_chordquality_identify'] = 'Identifica la fondamentale e il tipo di accordo';
$string['questiontext_chordquality_write'] = 'Scrivi il seguente accordo';
$string['questiontext_harmonicfunction_identify'] = 'Identifica la funzione armonica';
$string['questiontext_harmonicfunction_write'] = 'Scrivi la seguente funzione armonica';
$string['questiontext_help'] = 'Questo campo non è richiesto. Se lasciato vuoto, comparirà una domanda appropriata all\'interno dell\'attività. Se scrivi all\'interno del campo rimpazzerà la domanda automaticamente generata.';
$string['questiontext_interval_identify'] = 'Identifica l\'intervallo';
$string['questiontext_interval_write_above'] = 'Scrivi il seguente intervallo <b>sopra</b> la nota';
$string['questiontext_interval_write_below'] = 'Scrivi il seguente intervallo <b>sotto</b> la nota';
$string['questiontext_keyboard_input'] = 'Suona la seguente nota sulla tastiera';
$string['questiontext_keysignature_identify_major'] = 'Identifica la tonalità maggiore rappresentata dalla seguente armatura in chiave';
$string['questiontext_keysignature_identify_minor'] = 'Identifica la tonalità minore rappresentata dalla seguente armatura in chiave';
$string['questiontext_keysignature_write'] = 'Scrivi l\'armatura in chiave della seguente tonalità';
$string['questiontext_note_identify'] = 'Identifica la seguente nota';
$string['questiontext_note_write'] = 'Scrivi la seguente nota';
$string['questiontext_scale_identify'] = 'Identifica la seguente scala';
$string['questiontext_scale_write'] = 'Scrivi la seguente scala in direzione ascendente';
$string['questiontext_scale_write_melodic'] = 'Scrivi la seguente scala in entrambe le direzioni ascendente e discendente';
$string['rootposition'] = '[fondamentale]';
$string['scale_write_questionastext'] = 'Risposta scala inserita';
$string['scale_write_questionastext_help'] = '<p>Scrivi un elenco di note separate da una virgola, inclusa la tonica specificata, senza spazi, usando la seguente sintassi:</p><p>[Nome della nota in maiuscolo]
[Alterazione ("n" = naturale, "#" = diesis, "b" = bemolle, "x" = doppio-diesis, "bb" = doppio-bemolle)]
[Registro (una cifra fra 2 e 6, seguendo la notazione scientifica delle altezze)], ... </p>
<p>Esempio: <b>Tonica = Lan4 risposta=>Lan4,Sib4,Do#5,Re#5,Mi#5,Fa#5,Sol#5,Lan5</b></p>';
$string['scale_write_questionasui'] = 'Risposta scala inserita';
$string['scale_write_questionasui_help'] = '<p>Scrivi la nota cliccando sul pentagamma, dopo aver selezionato il tipo di alterazione nella toolbar a destra. Per cancellare una nota clicca di nuovo su di essa.</p>
<p>Nota che le alterazoni hanno effetto sulle note successive.</p>';
$string['scaletype'] = 'Tipo di scala';
$string['scaletype-random'] = 'Tipi di scale possibili';
$string['scaletype_harmonic'] = 'Minore armonica';
$string['scaletype_major'] = 'Maggiore';
$string['scaletype_melodic'] = 'Minore melodica';
$string['scaletype_natural'] = 'Minore naturale';
$string['selectakey'] = 'Seleziona una tonalità';
$string['selectanoption'] = 'Seleziona';
$string['selectaquality'] = 'Seleziona un tipo';
$string['selectasize'] = 'Seleziona una grandezza';
$string['size-random'] = 'Grandezze possibili';
$string['size10'] = '10ma';
$string['size11'] = '11ma';
$string['size12'] = '12ma';
$string['size13'] = '13ma';
$string['size2'] = '2a';
$string['size3'] = '3a';
$string['size4'] = '4a';
$string['size5'] = '5a';
$string['size6'] = '6a';
$string['size7'] = '7ma';
$string['size8'] = '8va';
$string['size9'] = '9a';
$string['tenor'] = 'Tenore';
$string['tenorclef'] = 'Chiave di tenore';
$string['tonic'] = 'Tonica';
$string['treble'] = 'Soprano';
$string['trebleclef'] = 'Chiave di soprano';
$string['updatemusicqtype'] = 'Aggorna le opzioni';
$string['validation_harmonicfunctionnotsupported'] = 'Questa funzione armonica non è supportata o è invalida.';
$string['validation_harmonicfunctiontypenotselected'] = 'Il tipo di funzione per la specificata funzione armonica deve essere selezionata.';
$string['validation_interval_novalidcombo'] = 'Il tipo e la grandezza selezionati non producono alcun intervallo valido.';
$string['validation_intervaloutsidestaff'] = 'Il registro della nota produce un intervallo che non rientra nel pentagramma nella chiave data.';
$string['validation_invalidchordquality'] = 'Questo tipo di accordo non può essere costruito sulla fondamentale specificata.';
$string['validation_invalidinterval_above'] = 'Questo intervallo non può essere scritto sopra la nota data.';
$string['validation_invalidinterval_below'] = 'Questo intervallo non può essere scritto sotto la nota data.';
$string['validation_noteoutsidekeyboard'] = 'Questa nota è fuori dall\'estensione della tastiera del pianoforte.';
$string['validation_noteoutsidestaff'] = 'Il registro della nota non rientra nel pentagramma nella chiave specificata.';
$string['validation_possiblescaletypenotselected'] = 'Il tipo di scala deve essere selezionato.';
$string['validation_possiblescaletypesnotselected_random'] = 'I possibili tipi di scale nella risposta devono includere tutti i possibili tipi di scala nella domanda.';
$string['validation_qualitymismatch'] = 'Questa combinazione di tipo e grandezza dell\'intervallo non è valida.';
$string['validation_samestaticandgivennote'] = 'La nota data e la risposta non corrispondono allo stesso tasto sulla tastiera.';
$string['validation_scale_invalidtonic'] = 'Tonica non valida per il tipo di scala specificato.';
$string['validation_scaleoutsidestaff'] = 'Il registro della tonica produce una scala che non rientra nel pentagramma nella chiave data.';
$string['validationerror_chordquality_identify'] = 'Risposta incompleta. Devi selezionare il nome, l\'alterazione e il tipo di accordo.';
$string['validationerror_empty'] = 'Non è stata data alcuna risposta';
$string['validationerror_harmonicfunction_identify'] = 'Risposta incompleta. Tutti i menù a discesa devono essere selezionati';
$string['validationerror_incompletechordquality'] = 'Risposta incompleta. Numero delle note in questo accordo';
$string['validationerror_incompleteharmonicfunction'] = 'Risposta incompleta. Numero delle note in questa funzione armonica';
$string['validationerror_interval_identify'] = 'Risposta incompleta. Sia il tipo che la grandezza devono essere selezionati';
$string['validationerror_invalidsyntax'] = 'Sintassi della risposta non valida.';
$string['validationerror_note_identify'] = 'Risposta incompleta. Il nome l\'alterazione e il registro devono essere selezionati.';
$string['validationerror_note_identify_ltr_acc'] = 'Risposta incompleta. Sia il nome che l\'alterazione devono essere selezionati.';
$string['validationerror_note_identify_ltr_reg'] = 'Risposta incompleta. Sia il nome che il registro devono essere selezionati.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Sono state immesse due note. Immetterne una sola.';
$string['validationerror_scale_identify'] = 'Risposta incompleta. Tutti i menù a discesa devono essere selezionati.';
$string['validationerror_scale_incomplete'] = 'Risposta incompleta. Sono richiesta 8 note inclusa la tonica.';
$string['validationerror_scale_incomplete_melodic'] = 'Risposta incompleta. Sono richiesta 15 note inclusa la tonica.';
$string['validationerror_whitespace'] = 'Sintassi della risposta non valida: rimuovi tutti gli spazi dalla risposta.';
