<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'it', version '4.0'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Accessibilità';
$string['accessibilitydisabled'] = 'Il toolkit di accessibilità Brickfield non è abilitato. Contattare l\'amministratore del sito per richiedere l\'abilitazione.';
$string['accessibilityreport'] = 'Kit di strumenti per l\'accessibilità';
$string['accessibilitytool'] = 'Strumento di accessibilità Brickfield';
$string['accessibilitytools'] = 'Strumenti di accessibilità Brickfield';
$string['activate'] = 'Attiva';
$string['activated'] = 'Il plugin è attivo e pronto all\'uso';
$string['activationform'] = 'Registrazione Brickfield';
$string['activationheader'] = 'Attivazione Brickfield';
$string['activationinfo'] = '<p>Per utilizzare questo plugin, è necessario fornire chiavi valide per il sito.</p><p>Per favore <a href="{$a}" data-action="send_info" target=" _blank">registrarsi al portale Brickfield (si apre in una nuova finestra)</a> per ricevere le chiavi se non si possiedono. </p><p>Una volta attivate, le chiavi verranno convalidate tramite elaborazione pianificata.</p>';
$string['activityresults:pluginname'] = 'Report dello strumento di accessibilità con suddivisione delle attività';
$string['activityresults:toolname'] = 'Riepilogo della suddivisione delle attività';
$string['activityresults:toolshortname'] = 'Suddivisione delle attività';
$string['advanced:pluginname'] = 'Report avanzato dello strumento di accessibilità';
$string['advanced:toolname'] = 'Riepilogo avanzato';
$string['advanced:toolshortname'] = 'Avanzato';
$string['allcourses'] = 'Tutti i corsi esaminati ({$a})';
$string['allcoursescat'] = 'Tutti i corsi esaminati nella categoria {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Su richiesta';
$string['analysis:disabled'] = 'Disabilitato';
$string['analysistype'] = 'Abilita richieste di analisi';
$string['analysistype_desc'] = 'Consenti richieste di analisi di accessibilità del contenuto';
$string['analysistypedisabled'] = 'L\'analisi del contenuto è disabilitata';
$string['bannercontentone'] = 'L\'Enterprise Accessibility Toolkit fornisce una serie completa di funzionalità per aiutare l\'organizzazione a migliorare l\'accessibilità dei corsi. <a href="{$a}">Contattare Brickfield Education Labs</a> per prenotare una demo gratuita delle funzionalità avanzate.';
$string['bannercontenttwo'] = 'Costruisci una piattaforma di insegnamento e apprendimento efficace e inclusiva trovando contenuti che non soddisfano le linee guida, risolvendo i problemi e rendendo a prova di futuro il contenuto del corso Moodle tramite file accessibili, editor e funzionalità avanzate.';
$string['bannerheadingone'] = 'Upgrade a Enterprise Accessibility Toolkit';
$string['batch'] = 'Limite di quantità';
$string['brickfield'] = 'Kit di strumenti Brickfield';
$string['brickfield:viewcoursetools'] = 'Visualizza i report per corso';
$string['brickfield:viewsystemtools'] = 'Visualizza i report di tutti i corsi';
$string['bulkprocesscaches'] = 'Elaborazione in massa delle cache';
$string['bulkprocesscourses'] = 'Elaborazione in massa dell\'analisi dell\'accessibilità';
$string['buttonone'] = 'Ottieni una demo gratuita';
$string['cachepending'] = 'I dati riassuntivi sono in fase di compilazione';
$string['checkdesc:alinksdontopennewwindow'] = 'I collegamenti che si aprono in una nuova finestra devono avvisare gli utenti in anticipo.';
$string['checkdesc:amustcontaintext'] = 'Un collegamento deve contenere del testo per essere percepibile.';
$string['checkdesc:areadontopennewwindow'] = 'Le aree presenti nelle mappe immagine e che si aprono in una nuova finestra devono avvertire gli utenti in anticipo.';
$string['checkdesc:areahasaltvalue'] = 'Le aree presenti nelle mappe immagini devono avere il testo alt (alternativo), come per le immagini.';
$string['checkdesc:asuspiciouslinktext'] = 'Il testo del collegamento deve essere descrittivo e fornire un contesto della destinazione.';
$string['checkdesc:basefontisnotused'] = 'Gli elementi Basefont (tradizionalmente utilizzati per la formattazione) non sono accessibili e non devono essere utilizzati.';
$string['checkdesc:blinkisnotused'] = 'Gli elementi lampeggianti che si accendono e si spengono non sono accessibili e non devono essere utilizzati.';
$string['checkdesc:boldisnotused'] = 'Gli elementi Grassetto (b) non devono essere utilizzati; al suo posto utilizzare "strong".';
$string['checkdesc:contenttoolong'] = 'La lunghezza complessiva del contenuto della pagina non deve superare le 500 parole.';
$string['checkdesc:csstexthascontrast'] = 'Il contrasto di colore tra il testo e lo sfondo è insufficiente.';
$string['checkdesc:embedhasassociatednoembed'] = 'Gli elementi incorporati (per incorporare contenuti multimediali) devono avere i corrispondenti elementi "noembed".';
$string['checkdesc:headerh3'] = 'Le intestazioni che seguono le intestazioni H3 (l\'opzione dell\'intestazione grande dell\'editor) non devono interrompere la gerarchia delle intestazioni di pagina.';
$string['checkdesc:headershavetext'] = 'Un\'intestazione deve contenere del testo per essere percepibile.';
$string['checkdesc:iisnotused'] = 'Gli elementi Corsivo (i) non devono essere utilizzati; al suo posto utilizzare "em".';
$string['checkdesc:imgaltisdifferent'] = 'Il testo alt (alternativo) dell\'immagine non deve coincidere con il nome del file dell\'immagine.';
$string['checkdesc:imgaltistoolong'] = 'Il testo alt (alternativo) dell\'immagine non deve superare il massimo consentito di 125 caratteri.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Il testo alt (alternativo) dell\'immagine non deve essere vuoto, soprattutto quando l\'immagine ha un collegamento che va altrove.';
$string['checkdesc:imgaltnotplaceholder'] = 'Il testo alt (alternativo) dell\'immagine non deve essere un semplice testo segnaposto, come "immagine".';
$string['checkdesc:imghasalt'] = 'Il testo alt (alternativo) dell\'immagine deve essere presente negli elementi immagine, a meno che non sia puramente decorativo senza significato.';
$string['checkdesc:imgwithmaphasusemap'] = 'Le mappe immagine con aree cliccabili devono avere gli elementi "usemap" e "map" corrispondenti.';
$string['checkdesc:legendtextnotempty'] = 'Gli elementi della legenda, utilizzati per sottotitolare gli elementi del set di campi, devono contenere del testo.';
$string['checkdesc:marqueeisnotused'] = 'Gli elementi di selezione (scorrimento automatico) non sono accessibili e non devono essere utilizzati.';
$string['checkdesc:noheadings'] = 'L\'assenza di intestazioni rende il contenuto meno strutturato e più difficile da leggere.';
$string['checkdesc:objectmusthaveembed'] = 'Gli elementi Object (per l\'incorporamento di risorse esterne) devono avere il corrispondente elemento "embed".';
$string['checkdesc:objectmusthavetitle'] = 'Gli elementi Object (per l\'incorporamento di risorse esterne) devono avere la descrizione "title".';
$string['checkdesc:objectmusthavevalidtitle'] = 'Gli elementi Object (per incorporare risorse esterne) devono i avere "titoli" con del testo.';
$string['checkdesc:strikeisnotused'] = 'Gli elementi barrati (strike-through) non devono essere utilizzati. Al suo posto utilizzare "del"';
$string['checkdesc:tabledatashouldhaveth'] = 'Le tabelle idealmente dovrebbero avere le intestazioni.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'I riepiloghi e le didascalie delle tabelle non devono essere identici.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Le tabelle idealmente dovrebbero avere celle unite.';
$string['checkdesc:tablethshouldhavescope'] = 'Gli ambiti di riga o colonna della tabella (utilizzati per mappare riga colonna su ciascuna cella) devono essere dichiarati.';
$string['checkidvalidation'] = 'Elaborazione per la verifica di checkid non validi';
$string['checkscompleted'] = 'Controlli completati: {$a}';
$string['checktype'] = 'Controllo gruppo';
$string['checktype:form'] = 'Scheda';
$string['checktype:image'] = 'Immagine';
$string['checktype:layout'] = 'Impaginazione';
$string['checktype:link'] = 'Collegamento';
$string['checktype:media'] = 'Media';
$string['checktype:table'] = 'Tabella';
$string['checktype:text'] = 'Testo';
$string['checktyperesults:pluginname'] = 'Report dello strumento di accessibilità dei tipi di contenuto';
$string['checktyperesults:toolname'] = 'Riepilogo dei tipi di contenuto';
$string['checktyperesults:toolshortname'] = 'Tipi di contenuto';
$string['cmpercent'] = 'Percentuale complessiva di attività';
$string['cmpercenterrors'] = 'Percentuale complessiva di errori';
$string['cmpercenttitle'] = 'Ripartizione % complessiva delle attività rispetto agli errori';
$string['confirmationmessage'] = 'Il corso è stato programmato per l\'analisi. L\'analisi sarà completata al più presto di {$a}. Ricontrollare in seguito.';
$string['contactadmin'] = 'Contattare l\'amministratore per completare la registrazione.';
$string['contactus'] = 'Contattaci';
$string['contentfive'] = 'Correggi automaticamente i tag HTML obsoleti.';
$string['contentfour'] = 'Identifica le attività che presentano i maggiori problemi di accessibilità per dare priorità alle correzioni.';
$string['contentone'] = 'Valuta automaticamente il contenuto del corso e verifica i problemi di accessibilità.';
$string['contentsix'] = 'Fornisci agli insegnanti suggerimenti "just in time" per creare contenuti migliori.';
$string['contentthree'] = 'Fornisci agli studenti contenuti in formati accessibili tra cui Audio, ePub e Braille elettronico.';
$string['contenttwo'] = 'Aggiornamento in blocco di testo non chiaro o mancante per collegamenti Web, descrizioni di immagini e sottotitoli video.';
$string['contenttypeerrors'] = 'Risultati totali dei test sui contenuti delle attività per corso e per tipo di contenuto.';
$string['contentyperesults'] = 'Totale superato/non superato per le aree di contenuto per corso.';
$string['contextid'] = 'Contextid';
$string['core_course'] = 'Corso';
$string['core_question'] = 'Deposito delle domande';
$string['count'] = 'Conteggio';
$string['country'] = 'Nazione';
$string['country_help'] = 'Nazione del sito';
$string['coursecount'] = 'Numero di corsi';
$string['deletehistoricaldata'] = 'Elimina i risultati dei controlli storici';
$string['dependency'] = 'Dipendente da';
$string['emptycategory'] = 'Nessun corso è stato trovato nella categoria {$a}';
$string['emptytagcourses'] = 'Nessun risultato è stato trovato per i corsi con i tag configurati';
$string['enableaccessibilitytools'] = 'Abilita gli strumenti di accessibilità';
$string['enableaccessibilitytools_desc'] = 'Il kit di strumenti dell\'accessibilità aiuta a identificare i problemi di accessibilità nei corsi.';
$string['error:nocoursespecified'] = 'Il report riassuntivo richiede un ID valido di un corso. Accedere al kit di strumenti dell\'accessibilità da un corso.';
$string['errorlink'] = 'Modifica istanza di errore di {$a}';
$string['errors'] = 'Errori: {$a}';
$string['errors:pluginname'] = 'Elenco degli errori dello strumento di accessibilità';
$string['errors:toolname'] = 'Riepilogo dell\'elenco degli errori';
$string['errors:toolshortname'] = 'Elenco errori';
$string['eventanalysis_requested'] = 'Richiesta di analisi del contenuto';
$string['eventanalysis_requesteddesc'] = 'Richiesta di analisi del contenuto del corso {$a}.';
$string['eventreport_downloaded'] = 'Scaricamento riepilogo accessibilità';
$string['eventreport_downloadeddesc'] = 'Scaricamento Il riepilogo dell\'accessibilità è stato  del corso ID {$a}.';
$string['eventreport_viewed'] = 'Visualizzazione report dell\'accessibilità';
$string['eventreport_vieweddesc'] = 'Visualizzazione report dell\'accessibilità del corso id {$a->course}, categoria id {$a->category}, scheda {$a->tab}.';
$string['failed'] = 'Non andato a buon fine';
$string['failedcount'] = 'Non andato a buon fine: {$a}';
$string['footerheading'] = 'Sezione piè di pagina';
$string['fullcachedone'] = 'Disabilita per rieseguire la memorizzazione nella cache';
$string['hashcorrect'] = 'Il codice inserito è corretto.';
$string['hashincorrect'] = 'Il codice inserito non è corretto.';
$string['headingfive'] = 'Correzioni HTML';
$string['headingfour'] = 'Dove focalizzarsi';
$string['headingone'] = 'Valuta il contenuto';
$string['headingsix'] = 'Supporto alle prestazioni';
$string['headingthree'] = 'Formati di file accessibili';
$string['headingtwo'] = 'Soluzione';
$string['hideshow'] = 'Nascondi/visualizza';
$string['icon:analytics-custom'] = 'Icona dell\'analitica';
$string['icon:file-edit-custom'] = 'Icona della modifica file';
$string['icon:search-plus-custom'] = 'Icona della ricerca';
$string['icon:tools-custom'] = 'Icona degli strumenti';
$string['icon:wand-magic-custom'] = 'Icona della bacchetta magica';
$string['inactive'] = 'Il plugin non è attivo e non può essere utilizzato. Si prega di inserire chiavi di registrazione valide e premere "Attiva".';
$string['innercontextid'] = 'ID contesto interno';
$string['installed'] = 'Plugin installato';
$string['installedcli'] = 'Plugin installato tramite riga di comando';
$string['installeddescription'] = 'Il plugin è stato installato, reindirizzamento al modulo di attivazione.';
$string['invalidaccessibilitytool'] = 'È stato richiesto un subplugin di accessibilità non valido.';
$string['invalidcategoryid'] = 'Categoria non valida, per favore controllare i dati inseriti';
$string['invalidcourseid'] = 'Corso non valido, per favore controllare i dati inseriti';
$string['invalidlinkphrases'] = 'clicca|clicca qui|qui|altro|altro qui|info|info qui|informazioni|informazioni qui|leggi di più|leggi di più qui|ulteriori informazioni|ulteriori informazioni qui|ulteriori dettagli|ulteriori dettagli qui';
$string['language'] = 'Lingua';
$string['language_help'] = 'Lingua del sito';
$string['messageprovider:warningcheckid'] = 'Avviso di checkid non validi';
$string['mobileservice'] = 'Servizi mobile abilitati ({$a})';
$string['module'] = 'Modulo';
$string['modulename'] = 'Nome';
$string['moreinfo'] = 'Ulteriori informazioni';
$string['noerrorsfound'] = 'Non sono stati trovati errori di accessibilità utilizzando i parametri di ricerca impostati. Congratulazioni!';
$string['norecords'] = 'Non sono stati trovati record rilevanti utilizzando i parametri di ricerca impostati.';
$string['notregistered'] = 'Il toolkit per l\'accessibilità deve essere registrato.';
$string['notvalidated'] = 'Il toolkit per l\'accessibilità sarà funzionante durante la convalida.';
$string['numcourses'] = 'Numero di corsi ({$a})';
$string['numfactivities'] = 'Numero di attività ({$a})';
$string['numfiles'] = 'Numero di file ({$a})';
$string['numinstances'] = 'Numero di istanze';
$string['numusers'] = 'Numero di utenti ({$a})';
$string['pagedesc:checktype'] = '<p>Per riassumere e analizzare i risultati dei vari controlli effettuati, i controlli sono raggruppati secondo diversi tipi di contenuto. Tutti i risultati del controllo dell\'accessibilità relativi alle immagini si trovaeranno nel gruppo relativo al tipo di contenuto "Immagine", tutti i risultati del controllo dell\'accessibilità relativi all\'impaginazione si troveranno nel gruppo relativo al tipo di contenuto "Impaginazione" e così via.</p><p>Le attività sono incluse come attività, risorse o aree di contenuto relative ai corsi stessi.</p><p>La pagina del grafico del tipo di contenuto visualizza la suddivisione degli errori per gruppo di tipi di contenuto: Immagine, Impaginazione, Collegamento, Media, Tabella e Testo.</ p>';
$string['pagedesc:pertarget'] = '<p>Al fine di riassumere e analizzare i risultati del controllo delle attività, i risultati verranno raggruppati in funzione delle attività rilevate.</p><p>Nelle attività sono incluse attività, risorse o altre aree di contenuto relative ai corsi stessi. Le attività prive di errori vengono considerate validate, mentre le attività che presentano uno o più errori vengono considerate come non validate. Verrà quindi visualizzato il rapporto tra attività validate e non validate.</p><p>La pagina del grafico di suddivisione delle attività visualizza il rapporto totale tra le istanze validate e non validate per ciascuna attività, come compito, corso, etichetta, ecc.</p>';
$string['pagedesctitle:checktype'] = 'Spiegazione dei tipi di contenuto';
$string['pagedesctitle:pertarget'] = 'Spiegazione della suddivisione delle attività';
$string['passed'] = 'Validato';
$string['passedcount'] = 'Validato: {$a}';
$string['passrate'] = 'Punteggio validazione: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Numero di test specifici ed errori per controllo e  per corso.';
$string['perpage'] = 'Elementi da visualizzare in ciascuna pagina';
$string['pluginname'] = 'Kit di strumenti per l\'accessibilità';
$string['printable:downloadpdf'] = 'Scarica PDF';
$string['printable:pluginname'] = 'Report riassuntivo dell\'accessibilità';
$string['printable:printreport'] = 'Report stampabile';
$string['printable:toolname'] = 'Report riassuntivo';
$string['printable:toolshortname'] = 'Report riassuntivo';
$string['privacy:metadata'] = 'Il plugin dreport dei controlli di accessibilità non memorizza dati personale.';
$string['processanalysisrequests'] = 'Elabora le richieste di analisi del contenuto';
$string['registernow'] = 'Si prega di registrarsi ora.';
$string['registration'] = 'Modulo di registrazione';
$string['registrationinfo'] = '<p>Il processo di registrazione consente di utilizzare la versione base del toolkit di accessibilità Brickfield nei siti Moodle registrati.</p><p>L\'utilizzo del tool è soggetto al <a href="{$a}" target="_blank">Termini e condizioni di Brickfield Education Labs (si apre in una nuova finestra)</a>, condizioni che si intendo accetatte utilizzando lo strumento.</p>';
$string['release'] = 'Release di Moodle ({$a})';
$string['remaining'] = '({$a} errori rimanenti)';
$string['response:0'] = 'L\'URL non punta da nessuna parte';
$string['response:404'] = 'La pagina dell\'URL non è stata trovata';
$string['schedule:blocknotscheduled'] = '<p>Il corso non è stato ancora schedulato per l\'analisi dei problemi di accessibilità.</p>';
$string['schedule:notscheduled'] = '<p>Il corso non è stato ancora schedulato per l\'analisi dei problemi di accessibilità.</p><p>Cliccando sul pulsante "Invia per l\'analisi", si conferma di voler di volere schedulare il corso per l\'analisi di tutti i contenuti HTML, come descrizioni delle sezioni del corso, descrizioni delle attività, domande, pagine e altro ancora.</p><p>L\'analisi svolgerà controlli sui problemi di di accessibilità del contenuto HTML del corso e tali risultati verranno visualizzati sulle pagine dei report del toolkit. L\'analisi verrà eseguita in background tramite elaborazione pianificata, quindi la  velocità di completamento dipenderà dai tempi delle attività e dalle pianificazioni di elaborazione delle attività.</p>';
$string['schedule:requestanalysis'] = 'Invia per l\'analisi';
$string['schedule:scheduled'] = 'Il corso è stato schedulato per l\'analisi.';
$string['schedule:sitenotscheduled'] = '<p>Il contenuto globale (indipendente dal corso) non è ancora stato programmato per l\'analisi per indivduare problemi comuni di accessibilità.</p><p>Facendo clic sul pulsante "Invia per l\'analisi", si conferma che si desidera che tutto il contenuto globale (indipendente dal corso) venga programmato per l\'analisi.</p><p>Questa analisi eseguirà più controlli comuni di accessibilità su questo contenuto e i risultati verranno visualizzati su queste pagine di report del toolkit di accessibilità. L\'analisi verrà elaborata in background, da attelaborazioni pianificate, quindi la sua velocità di completamento dipenderà dalle tempistiche e dagli orari di esecuzione delle attività.';
$string['schedule:sitescheduled'] = 'Il contenuto globale (indipendente dal corso) è stato schedulato per l\'analisi.';
$string['secretkey'] = 'Chiave API';
$string['secretkey_help'] = 'Il codice verrà ricevuto via e-mail dopo la registrazione.';
$string['sendfollowinginfo'] = '<p>Le seguenti informazioni verranno inviate periodicamente solo per contribuire alle statistiche generali. Non sarà reso pubblico in nessun elenco centrale.</p> {$a}';
$string['settings'] = 'Impostazioni del toolkit di accessibilità';
$string['sitehash'] = 'Chiave segreta';
$string['sitehash_help'] = 'Il codice verrà ricevuto via e-mail dopo la registrazione.';
$string['taberrors'] = 'Controlla errori';
$string['targetavetitle'] = 'Media errori per attività';
$string['targetpercentage'] = 'Percentuale di istanze validate/non validate per attività';
$string['targetratio'] = 'Rapporto di attività validate';
$string['tblcheck'] = 'Verifica';
$string['tblcheckexample'] = 'Esempio';
$string['tblcheckfailed'] = 'Verifica non andata a buon fine';
$string['tblchecksummary'] = 'Sommario';
$string['tbledit'] = 'Modifica';
$string['tblerrorcount'] = 'Errori';
$string['tblhtmlcode'] = 'Codice HTML esistente';
$string['tblinstance'] = 'Istanza';
$string['tblline'] = 'Linea';
$string['tbloverallpercentage'] = '% complessiva errori';
$string['tblpercentage'] = 'Percentuale';
$string['tblpreview'] = 'Anteprima';
$string['tbltarget'] = 'Attività';
$string['tblupdateto'] = 'Aggiorna a';
$string['titleactivityresultsall'] = 'Risultati per attività: tutti i corsi controllati ({$a->count} corsi)';
$string['titleactivityresultspartial'] = 'Risultati per attività: corso {$a->name}';
$string['titleall'] = 'corsi)';
$string['titlechecktyperesultsall'] = 'Risultati per tipo di contenuto: tutti i corsi controllati ({$a->count} corsi)';
$string['titlechecktyperesultspartial'] = 'Risultati per tipo di contenuto: corso {$a->name}';
$string['titleerrorsall'] = 'Dettagli errore: tutti i corsi recensiti ({$a->count} corsi)';
$string['titleerrorscount'] = 'Dettagli errore: (visualizza i primi {$a} errori)';
$string['titleerrorspartial'] = 'Dettagli errore: corso {$a->name}';
$string['titlepartial'] = 'Dettagli errore: corso {$a->name}';
$string['titleprintableall'] = 'Corso {$a->name}';
$string['titleprintablepartial'] = 'Corso {$a->name}';
$string['tools'] = 'Report';
$string['toperrors'] = 'Errori più gravi';
$string['toptargets'] = 'Attività non validate';
$string['totalactivities'] = 'Attività totali';
$string['totalactivitiescount'] = 'Attività totali: {$a}';
$string['totalareas'] = 'Totale aree';
$string['totalerrors'] = 'Errori totali';
$string['totalgrouperrors'] = 'Errori totali (somma) per tipo di contenuto';
$string['updatesummarydata'] = 'Aggiorna i dati di riepilogo del sito';
$string['usersmobileregistered'] = 'Numero di utenti con dispositivi mobili registrati ({$a})';
$string['warningcheckidsubject'] = 'Avviso checkID Brickfield Toolkit';
