<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'af', version '4.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Aksies';
$string['activate'] = 'Ontsper toegang';
$string['activatesuccess'] = 'Toegang tot die kentekens is suksesvol ontsper.';
$string['addalignment'] = 'Voeg eksterne vaardigheid of standaard by';
$string['addbackpack'] = 'Voeg rugsak by';
$string['addbadge'] = 'Voeg kentekens by';
$string['addbadge_help'] = 'Selekteer alle kentekens wat tot hierdie kenteken vereiste gevoeg moet word. Hou CTRL sleutel in om veelvuldige items te selekteer.';
$string['addbadgecriteria'] = 'Voeg kenteken kriteria by';
$string['addcohort'] = 'Voeg kohort by';
$string['addcohort_help'] = 'Selekteer alle kohorte wat tot hierdie kenteken vereiste gevoeg moet word. Hou CTRL sleutel in om veelvuldige items te selekteer.';
$string['addcompetency'] = 'Voeg bekwaamheid by';
$string['addcompetency_help'] = 'Selekteer alle bekwaamhede wat tot hierdie kenteken vereiste gevoeg moet word. Hou CTRL sleutel in om veelvuldige items te selekteer.';
$string['addcourse'] = 'Voeg kursusse by';
$string['addcourse_help'] = 'Selekteer alle kursusse wat tot hierdie kenteken vereiste gevoeg moet word. Hou CTRL sleutel in om veelvuldige items te selekteer.';
$string['addcriteria'] = 'Voeg kriteria by';
$string['addcriteriatext'] = 'Om kriteria te begin byvoeg, selekteer asseblief een van die opsies vanaf die aftrek kieslys.';
$string['addedtobackpack'] = 'Kenteken is by rugsak gevoeg';
$string['addrelated'] = 'Voeg verwante kenteken by';
$string['addtobackpack'] = 'Voeg by rugsak';
$string['adminonly'] = 'Hierdie bladsy is beperk tot slegs webwerf administrateurs.';
$string['after'] = 'na die datum van uitreik.';
$string['aggregationmethod'] = 'Samevoeging metode';
$string['alignment'] = 'Lyninstelling';
$string['all'] = 'Alle';
$string['allmethod'] = 'Daar word voldoen aan al die geselekteerde voorwaardes';
$string['allmethodactivity'] = 'Al die geselekteerde aktiwiteite is voltooi';
$string['allmethodbadges'] = 'Al die geselekteerde kentekens is verdien';
$string['allmethodcohort'] = 'Lidmaatskap in al die geselekteerde kohorte';
$string['allmethodcompetencies'] = 'Al die geselekteerde bekwaamhede is voltooi';
$string['allmethodcourseset'] = 'Al die geselekteerde kursusse is voltooi';
$string['allmethodmanual'] = 'Al die geselekteerde rolle ken die kenteken toe';
$string['allmethodprofile'] = 'Al die geselekteerde profiel velde is voltooi';
$string['allowcoursebadges'] = 'Ontsper kursus kentekens';
$string['allowcoursebadges_desc'] = 'Laat toe dat kentekens in die kursus konteks geskep en toegeken word.';
$string['allowexternalbackpack'] = 'Eksterne rugsak konneksie';
$string['allowexternalbackpack_desc'] = 'Indien ontsper kan gebruikers na \'n eksterne rugsak konnekteer en hul kentekens van hierdie webwerf met ander deel. Gebruikers kan ook kies om enige publieke kenteken versamelings van hul eksterne rugsak op hul profiel op hierdie webwerf te vertoon. Dit word voorgestel om hierdie opsie versper te laat indien jou webwerf nie vanaf die internet toeganklik is nie.';
$string['any'] = 'Enige';
$string['anymethod'] = 'Enige van die geselekteerde voorwaardes is aan voldoen';
$string['anymethodactivity'] = 'Enige van die geselekteerde aktiwiteite is voltooi';
$string['anymethodbadges'] = 'Enige van die geselekteerde kentekens is verdien';
$string['anymethodcohort'] = 'Lidmaatskap in enige van die geselekteerde kohorte';
$string['anymethodcompetencies'] = 'Enige van die geselekteerde bekwaamhede is voltooi';
$string['anymethodcourseset'] = 'Enige van die geselekteerde kursusse is voltooi';
$string['anymethodmanual'] = 'Enige van die geselekteerde rolle ken die kenteken toe';
$string['anymethodprofile'] = 'Enige van die geselekteerde profiel velde is voltooi';
$string['apiversion'] = 'API weergawe word ondersteun';
$string['archivebadge'] = 'Wil jy kenteken \'{$a}\' uitwis, maar bestaande kentekens wat reeds uitgereik is, hou?';
$string['archiveconfirm'] = 'Wis uit en hou bestaande uitgereikte kentekens';
$string['archivehelp'] = '<p>Hierdie opsie beteken dat die kenteken as "afgetree" gemerk gaan word. Dit sal nie meer in die lys van kentekens verskyn nie. Gebruikers gaan nie meer in staat wees om hierdie kenteken te verdien nie, maar bestaande gebruikers wat reeds hierdie kenteken ontvang het sal steeds in staat wees om hierdie kenteken op hul profiel bladsy te vertoon en dit na hul eksterne rugsakke te stoot.<p>
<p>As jy wil hê dat jou gebruikers toegang tot die kentekens wat hulle verdien het moet kan behou, is dit belangrik om hierdie opsie te selekteer voordat jy kentekens ten volle uitwis.<p>';
$string['attachment'] = 'Heg kenteken aan boodskap';
$string['attachment_help'] = 'Indien ontsper sal \'n uitgereikte kenteken aan die ontvanger se e-pos geheg word, waarna die ontvanger dit kan aflaai. (Aanhegsels moet in die Webwerf administrasie / Bediener / E-pos/ Uitgaande e-pos konfigurasie ontsper wees om hierdie opsie te gerbruik.)';
$string['award'] = 'Ken kenteken toe';
$string['awardedtoyou'] = 'Aan my uitgereik';
$string['awardoncron'] = 'Toegang tot die kentekens is suksesvol ontsper. Te veel gebruikers kan oombliklik hierdie kenteken verdien. Om webwerf werksverrigting te verseker, sal hierdie aksie \'n redelike tydjie vat om te prosesseer.';
$string['awards'] = 'Ontvangers';
$string['backpackapiurl'] = 'Rugsak API URL';
$string['backpackavailability'] = 'Eksterne kenteken verifikasie';
$string['backpackavailability_help'] = '\'n Eksterne rugsak diens moet in staat wees om toegang tot jou webwerf te verkry en die kentekens wat daarvan af uitgereik is, te verifieer. Hierdie is sodat kenteken ontvangers kan bewys dat hulle hul kentekens van jou af verdien het. Dit wil voorkom dat jou webwerf nie tans toeganklik is nie. Dus kan kentekens wat jy reeds uitgegee of nog gaan uitgee nie geverifieer word nie.

**Waarom sien ek hierdie boodskap?**

Dit kan wees dat jou brandmuur verhoed dat gebruikers buite jou netwerk toegang verkry of jou webwerf word beskerm deur \'n wagwoord, of jy hardloop die webwerf op \'n rekenaar wat nie vanaf die internet beskikbaar is nie (byvoorbeeld \'n plaaslike ontwikkelingsmasjien).

**Is hierdie \'n probleem?**

Jy behoort hierdie probleem op enige lewendige webwerf waar jy beplan om kentekens toe te ken reg te maak, anders gaan die ontvanger nie kan bewys dat hulle hul kentekens van jou af verdien het nie. As jou webwerf nog nie lewendig is nie kan jy kentekens skep en toetse kentekens uitreik, so lank die webwerf toeganklik is voordat jy lewendig gaan.

**Wat gebeur as ek nie my hele webwerf tot die publiek toeganklik kan maak nie?**

Die enigste URL wat vir verifikasie vereis word is [jou-webwerf-url]/badges/assertion.php, so as jy in staat is om jou brandmuur te verander sodat daar toegang tot daardie lêer verkry kan word, sal die kenteken verifikasie steeds werk.';
$string['backpackbadgessettings'] = 'Verander rugsak instellings';
$string['backpackbadgessummary'] = 'Jy het {$a->totalbadges} kenteken(s) wat vertoon vanuit {$a->totalcollections} versameling(s).';
$string['backpackcannotsendverification'] = 'Kan nie verifikasie e-pos stuur nie';
$string['backpackconnected'] = 'Rugsak is gekonnekteer';
$string['backpackconnection'] = 'Rugsak konneksie';
$string['backpackconnection_help'] = 'Deur aan \'n rugsak te konnekteer kan jy jou kentekens van hierdie webwerf met ander deel. Jy kan ook publieke kenteken versamelings vanuit jou rugsak op jou profiel bladsy op hierdie webwerf vertoon.';
$string['backpackconnectioncancelattempt'] = 'Konnekteer deur \'n ander e-pos adres te gebruik';
$string['backpackconnectionconnect'] = 'Konnekteer aan rugsak';
$string['backpackconnectionnottested'] = 'Hierdie konneksie kan nie getoets word vir hierdie rugsak nie omdat slegs Open Badges v2.0 dit ondersteun.';
$string['backpackconnectionok'] = 'Rugsak konneksie is suksesvol tot stand gebring';
$string['backpackconnectionresendemail'] = 'Stuur verifikasie e-pos weer';
$string['backpackconnectionunexpectedmessage'] = 'Die rugsak het die volgende fout teruggestuur: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Daar was \'n probleem tydens die poging om aan jou rugsak te konnekteer. Gaan asseblief die getuigskrifte na en probeer weer.';
$string['backpackdetails'] = 'Rugsak instellings';
$string['backpackdisconnected'] = 'Rugsak is ontkoppel';
$string['backpackemail'] = 'E-posadres';
$string['backpackemail_help'] = 'Die e-posadres wat met jou rugsak geassosieer word. Terwyl jy gekonnekteer is, sal enige kentekens wat jy op hierdie webwerf verdien met heirdie e-posadres geassosieer word.';
$string['backpackemailverificationpending'] = 'Verifikasie afwagtend';
$string['backpackemailverifyemailbody'] = 'Haai

\'n Nuwe konneksie met jou kentekens rugsak is vanaf  \'{$a->sitename}\' aangevra deur jou e-posadres te gebruik.

Om te bevestig en die konneksie met jou rugsakte aktiveer, gaan asseblief na

{$a->link}

In meeste e-posprogramme behoort hierdie as \'n blou skakel te vertoon waarop jy net kan klik. Indien dit nie werk nie, sny en plak die adres in die adreslyn aan die bokant van jou webblaaier.

As jy hulp nodig het, kontak asseblief die webwerf adminsitrateur,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Kentekens rugsak e-pos verifikasie';
$string['backpackemailverifypending'] = '\'n Verifikasie e-pos is na <strong>{$a}</strong> gestuur. Klik op die verifikasie skakel in die e-pos om jou Rugsak konneksie te aktiveer.';
$string['backpackemailverifysuccess'] = 'Dankie dat jy jou e-posadres geverifieer het. Jy is nou aan jou rugsak gekonnekteer.';
$string['backpackemailverifytokenmismatch'] = 'Die teken in die skakel waarop jy geklik het pas nie by die gestoorde item nie. Maak seker dat jy die skakel in die mees onlangse e-pos wat jy ontvang het, geklik het.';
$string['backpackexporterror'] = 'Kan nie die kenteken na die rugsak uitvoer nie';
$string['backpackimport'] = 'Kenteken invoer instellings';
$string['backpackimport_help'] = 'Nadat die rugsak konneksie suksesvol tot stand gebring is, kan kentekens vanuit jou rugsak op jou kentekens bladsy en op jou profiel bladsy vertoon word.

In hierdie area kan jy versamelings kentekens vanuit jou rugsak wat jy in jou profiel wil vertoon, selekteer.';
$string['backpackneedsupdate'] = 'Die rugsak wat aan hierdie profiel gekonnekteer is, pas nie by die rugsak vir die webwerf nie. Jy moet ontkoppel en die rugsak weer konnekteer.';
$string['backpackprovider'] = 'Rugsak verskaffer';
$string['backpacksettings'] = 'Rugsak instellings';
$string['backpackweburl'] = 'Rugsak URL';
$string['badgedetails'] = 'Kenteken besonderhede';
$string['badgeimage'] = 'Beeld';
$string['badgeimage_help'] = 'Hierdie is \'n beeld wat gebruik gaan word wanneer hierdie kenteken uitgereik word.

Om \'n nuwe beeld by te voeg, blaai rond en kies \'n beeld (in JPG of PNG formaat). Klik dan \'Stoor veranderinge\'. Die beeld sal tot \'n vierkant geknip en die grootte sal aangepas word om aan die kenteken beeld vereistes te voldoen.';
$string['badgeprivacysetting'] = 'Kenteken privaatheid instellings';
$string['badgeprivacysetting_help'] = 'Kentekens wat jy verdien kan op jou rekening se profiel bladsy vertoon word. Hierdie instelling laat jou toe om outomaties die sigbaarheid van die nuut verdiende kentekens te stel.

Jy kan nogsteeds individuele kenteken privaatheid instellings op jou kentekens bladsy beheer.';
$string['badgeprivacysetting_str'] = 'Vertoon outomaties kentekens wat ek verdien op my profiel bladsy';
$string['badges'] = 'Kentekens';
$string['badgesalt'] = 'Kriptografiese lukrake data (\'salt\') om die ontvanger se e-pos adres mee te huts';
$string['badgesalt_desc'] = 'Die gebruik van \'n huts laat rugsak dienste toe om die kenteken ontvanger te bevestig sonder om hul e-pos adres bloot te stel. Hierdie instelling moet slegs nommers en letters gebruik.

Nota: Vir die doeleindes van ontvanger verifikasie, moet asseblief nie hierdie instelling verander wanneer jy begin om kentekens uit te gee nie.';
$string['badgesdisabled'] = 'Kentekens is nie ontsper op hierdie webwerf nie.';
$string['badgesearned'] = 'Aantal kentekens verdien: {$a}';
$string['badgesettings'] = 'Kentekens instellings';
$string['badgestatus_0'] = 'Nie beskikbaar nie';
$string['badgestatus_1'] = 'Beskikbaar';
$string['badgestatus_2'] = 'Nie beskikbaar (kriteria gesluit)';
$string['badgestatus_3'] = 'Beskikbaar (kriteria gesluit)';
$string['badgestatus_4'] = 'Geargiveer';
$string['badgestoearn'] = 'Aantal kentekens beskikbaar: {$a}';
$string['badgesview'] = 'Kursus kentekens';
$string['badgeurl'] = 'Uitgereikte kenteken skakel';
$string['balignment'] = 'Inlynstellings ({$a})';
$string['bawards'] = 'Ontvangers ({$a})';
$string['bcriteria'] = 'Kriteria';
$string['bdetails'] = 'Redigeer besonderhede';
$string['bendorsement'] = 'Bekragtiging';
$string['bmessage'] = 'Boodskap';
$string['boverview'] = 'Oorsig';
$string['brelated'] = 'Verwante kentekens ({$a})';
$string['bydate'] = 'voltooi teen';
$string['claim'] = 'Eis';
$string['claimcomment'] = 'Bekragtiging kommentaar';
$string['claimid'] = 'Eis URL';
$string['clearsettings'] = 'Maak instellings skoon';
$string['completioninfo'] = 'Hierdie kenteken is uitgereik vir die voltooiing van:';
$string['completionnotenabled'] = 'Kursus voltooiing is nie vir hierdie kursus ontsper nie, dus kan dit nie in die kenteken kriteria ingesluit word nie. Kursus voltooiing kan in die kursus instellings ontpser word.';
$string['configenablebadges'] = 'Indien ontsper laat hierdie eienskap jou toe om kentekens te skep en hulle aan webwerf gebruikers toe te ken.';
$string['configuremessage'] = 'Kenteken boodskap';
$string['connect'] = 'Konnekteer';
$string['connected'] = 'Gekonnekteer';
$string['connecting'] = 'Besig om te konnekteer...';
$string['contact'] = 'Kontak';
$string['contact_help'] = '\'n E-posadres wat met die kenteken uitgewer geassosieer word.';
$string['copyof'] = 'Kopie van {$a}';
$string['coursebadges'] = 'Kentekens';
$string['coursebadgesdisabled'] = 'Kursus kentekens is nie op hierdie webwerf ontsper nie.';
$string['coursecompletion'] = 'Gebruikers moet hierdie kursus voltooi.';
$string['create'] = 'Nuwe kenteken';
$string['createbutton'] = 'Skep kenteken';
$string['creatorbody'] = '<p>{$a->user} het al die kenteken vereistes voltooi en is die kenteken toegeken. Besigitig die uitgereikte kenteken by {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' is toegeken!';
$string['criteria_0'] = 'Hierdie kenteken word toegeken wanneer...';
$string['criteria_1'] = 'Aktiwiteit voltooiing';
$string['criteria_1_help'] = 'Laat toe dat \'n kenteken aan gebruikers toegeken word, gebaseer op die voltooiing van \'n stel aktiwiteite binne \'n kursus.';
$string['criteria_2'] = 'Met die hand uitgee per rol';
$string['criteria_2_help'] = 'Laat toe dat \'n kenteken met die hand deur gebruikers, wat \'n sekere rol binne die webwerf of kursus het, uitgegee kan word.';
$string['criteria_3'] = 'Sosiale deelname';
$string['criteria_3_help'] = 'Sosiaal';
$string['criteria_4'] = 'Kursus voltooiing';
$string['criteria_4_help'] = 'Laat toe dat \'n kenteken aan gebruikers wat die kursus voltooi het, uitgegee kan word. Hierdie kriterium kan addisionele beperkinge hê, soos minimum punt en datum van kursus voltooiing.';
$string['criteria_5'] = 'Voltooiing van \'n stel kursusse';
$string['criteria_5_help'] = 'Laat toe dat \'n kenteken aan gebruikers wat \'n stel kursusse voltooi het, uitgegee kan word. Elke kursus kan addisionele beperkinge hê, soos minimum punt en datum van kursus voltooiing.';
$string['criteria_6'] = 'Profiel voltooiing';
$string['criteria_6_help'] = 'Laat toe dat \'n kenteken aan gebruikers wat sekere velde in hul profiel voltooi het, uitgegee kan word. Jy kan kies van verstek en doelgemaakte profiel velde wat vir gebruikers beskikbaar is.';
$string['criteria_7'] = 'Toegekende kentekens';
$string['criteria_7_help'] = 'Laat toe dat \'n kenteken, gebaseer op ander kentekens wat hulle verdien het, aan gebruikers toegeken word.';
$string['criteria_8'] = 'Kohort lidmaatskap';
$string['criteria_8_help'] = 'Laat toe dat \'n kenteken, gebaseer op kohort lidmaatskap, aan gebruikers toegeken word.';
$string['criteria_9'] = 'Bekwaamhede';
$string['criteria_9_help'] = 'Laat toe dat \'n kenteken, gebaseer op bekwaamhede wat hulle voltooi het, aan gebruikers toegeken word.';
$string['criteria_descr'] = 'Gebruikers word hierdie kenteken toegeken wanneer hulle aan die voglende vereiste voldoen:';
$string['criteria_descr_0'] = 'Gebruikers word hierdie kenteken toegeken wanneer hulle <strong>{$a}</strong> van die gelyste vereistes voltooi.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> van die volgende aktiwiteite is voltooi:';
$string['criteria_descr_2'] = 'Hierdie kenteken moet aan gebruikers met <strong>{$a}</strong> van die volgende rolle toegeken word:';
$string['criteria_descr_4'] = 'Gebruikers moet hierdie kursus voltooi';
$string['criteria_descr_5'] = '<strong>{$a}</strong> van die volgende kursusse moet voltooi word:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> van die volgende gebruiker profiel velde moet voltooi word:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> van die volgende kentekens moet verdien word:';
$string['criteria_descr_8'] = 'Lidmaatskap in <strong>{$a}</strong> van die volgende kohorts is vereis:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> van die volgende bekwaamhede moet voltooi word:';
$string['criteria_descr_bydate'] = 'teen <em>{$a}</em>';
$string['criteria_descr_grade'] = 'met \'n minimum punt van <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Voltooi <strong>{$a}</strong> van:';
$string['criteria_descr_short1'] = 'Voltooi <strong>{$a}</strong> van:';
$string['criteria_descr_short2'] = 'Toegeken deur <strong>{$a}</strong> van:';
$string['criteria_descr_short4'] = 'Voltooi die kursus';
$string['criteria_descr_short5'] = 'Voltooi <strong>{$a}</strong> van:';
$string['criteria_descr_short6'] = 'Voltooi <strong>{$a}</strong> van:';
$string['criteria_descr_short7'] = 'Voltooi <strong>{$a}</strong> van:';
$string['criteria_descr_short8'] = 'Kohort lidmaatskap in <strong>{$a}</strong> van:';
$string['criteria_descr_short9'] = 'Voltooi <strong>{$a}</strong> van:';
$string['criteria_descr_single_1'] = 'Die volgende aktiwiteit moet voltooi word:';
$string['criteria_descr_single_2'] = 'Die kenteken moet deur \'n gebruiker met die volgende rol toegeken word:';
$string['criteria_descr_single_4'] = 'Gebruikers moet die kursus voltooi';
$string['criteria_descr_single_5'] = 'Die volgende kursus moet voltooi word:';
$string['criteria_descr_single_6'] = 'Die volgende profiel veld moet voltooi word:';
$string['criteria_descr_single_7'] = 'Die volgende kenteken moet verdien word:';
$string['criteria_descr_single_8'] = 'Lidmaatskap aan die volgende kohort word vereis:';
$string['criteria_descr_single_9'] = 'Die volgende bekwaamhede moet voltooi word:';
$string['criteria_descr_single_short1'] = 'Voltooi:';
$string['criteria_descr_single_short2'] = 'Toegeken deur:';
$string['criteria_descr_single_short4'] = 'Voltooi die kursus';
$string['criteria_descr_single_short5'] = 'Voltooi:';
$string['criteria_descr_single_short6'] = 'Voltooi:';
$string['criteria_descr_single_short7'] = 'Voltooi:';
$string['criteria_descr_single_short8'] = 'Lidmaatskap aan:';
$string['criteria_descr_single_short9'] = 'Voltooi:';
$string['criteriacreated'] = 'Kenteken kriteria is suksesvol geskep';
$string['criteriadeleted'] = 'Kenteken kriteria is suksesvol uitgewis';
$string['criteriasummary'] = 'Kriteria opsomming';
$string['criteriaupdated'] = 'Kenteken kriteria is suksesvol opgedateer';
$string['criterror'] = 'Huidige beperkings probleme';
$string['criterror_help'] = 'Hierdie veldstel vertoon alle beperkings wat oorspronklik tot hierdie kenteken vereiste gevoeg is, maar nie meer beskikbaar is nie. Dit word voorgestel dat jy sulke beperkinge ontkies om seker te maak dat gebruikers hierdie kenteken in die toekoms kan verdien.';
$string['currentimage'] = 'Huidige beeld';
$string['currentstatus'] = 'Huidige status:';
$string['dateawarded'] = 'Datum uitgegee';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Dag/Dae';
$string['deactivate'] = 'Versper toegang';
$string['deactivatesuccess'] = 'Toegang tot die kentekens is susksesvol versper.';
$string['defaultissuercontact'] = 'Kenteken uitgewer e-posadres';
$string['defaultissuercontact_desc'] = '\'n E-posadres wat met die kenteken uitgewer geassosieer word. Vir \'n Open Badges v2.0 rugsak word hierdie vir verifikasie gebruik wanneer kentekens na \'n rugsak gepubliseer word.';
$string['defaultissuername'] = 'Kenteken uitgewer naam';
$string['defaultissuername_desc'] = 'Naam van die uitgewer agent of gesaghebber';
$string['defaultissuerpassword'] = 'Kenteken uitgewer wagwoord';
$string['defaultissuerpassword_help'] = '\'n Rekening word op die rugsak webwerf vereis met die e-posadres soos gespesifiseer in die kenteken uitgewer e-posadres instelling in Webwerf administrasie / kentekens / Kentekens instellings. Die wagwoord vir die rekening moet hier ingevoer word.';
$string['delbadge'] = 'Wil jy kenteken \'{$a}\' uitwis en alle bestaande kentekens wat uitgegee is verwyder?';
$string['delconfirm'] = 'Wis uit en verwyder bestaande kentekens wat uitgegee is';
$string['delcritconfirm'] = 'Is jy seker jy wil hierdie kriterium uitwis?';
$string['deletehelp'] = '<p>Deur \'n kenteken ten volle uit te wis beteken dat al sy informasie en kriteria rekords permanent verwyder gaan word. Gebruikers wat hierdie kenteken verdien het gaan nie meer toegang daartoe hê en dit op hul profiel bladsye kan vertoon nie.<p>
<p>Nota: Gebruikers wat hierdie kenteken verdien en dit reeds na hul eksterne rugsak gestoot het, sal hierdie kenteken steeds in hul eksterne rugsak hê. Hulle sal egter nie toegang hê tot kriteria en bewys bladsye wat terug na hierdie webwerf skakel nie.<p>';
$string['delexternalbackpack'] = 'Wis webwerf rugsak uit';
$string['delexternalbackpackconfirm'] = 'Wis webwerf rugsak uit \'{$a}\'?';
$string['delparamconfirm'] = 'Is jy seker dat jy hierdie beperking wil uitwis?';
$string['description'] = 'Beskrywing';
$string['disconnect'] = 'Ontkoppel';
$string['donotaward'] = 'Hierdie kenteken is nie tans aktief nie, so dit kan nie aan gebruikers toegeken word nie. As jy hierdie kenteken wil toeken, stel asseblief die status na aktief.';
$string['editsettings'] = 'Redigeer instellings';
$string['enablebadges'] = 'Ontsper kentekens';
$string['endorsement'] = 'Bekragtiging';
$string['error:backpackdatainvalid'] = 'Die data terugkeer vanaf die rugsak was ongeldig.';
$string['error:backpackemailnotfound'] = 'Die e-posadres \'{$a}\' is nie met \'n rugsak geassosieer nie. Jy moet <a href="http://backpack.openbadges.org">skep \'n rugsak</a> vir daardie rekening of inteken met \'n ander e-posadres.';
$string['error:backpacknotavailable'] = 'Jou webwerf is nie vanaf die internet toeganklik nie, so enige kentekens wat vanaf hierdie webwerf toegeken word, kan nie deur eksterne rugsak dienste geverifieer word nie.';
$string['error:backpackproblem'] = 'Daar was \'n probleem in die poging om aan jou rugsak diensverskaffer te konnekteer. Probeer asseblief weer later.';
$string['error:badgeawardnotfound'] = 'Kan nie hierdie toegekende kenteken verifieer nie. Hierdie kenteken is moontlik herroep.';
$string['error:badgenotfound'] = 'Kenteken nie gevind nie';
$string['error:cannotact'] = 'Kan nie die kenteken aktiveer nie.';
$string['error:cannotawardbadge'] = 'Kan nie kenteken aan \'n gebruiker toeken nie.';
$string['error:cannotdeletecriterion'] = 'Hierdie kriterium kan nie uitgewis word nie.';
$string['error:cannotrevokebadge'] = 'Kan nie kenteken vanaf \'n gebruiker herroep nie.';
$string['error:clone'] = 'Kan nie die kenteken kloon nie.';
$string['error:connectionunknownreason'] = 'Die konneksie was onsuksesvol, maar geen rede is verskaf nie.';
$string['error:duplicatename'] = 'Kenteken met hierdie naam bestaan reeds in die stelsel.';
$string['error:externalbadgedoesntexist'] = 'Kenteken nie gevind nie';
$string['error:guestuseraccess'] = 'Jy gebruik tans gaste toegang. Om kentekens te kan sien moet jy met jou gebruikersrekening inteken.';
$string['error:invalidcriteriatype'] = 'Ongeldige kriteria tipe';
$string['error:invalidexpiredate'] = 'Vervaldatum moet in die toekoms wees.';
$string['error:invalidexpireperiod'] = 'Vervalperiode kan nie negatief of gelyk aan 0 wees nie.';
$string['error:invalidparambadge'] = 'Kenteken bestaan nie.';
$string['error:invalidparamcohort'] = 'Kohort bestaan nie.';
$string['error:noactivities'] = 'Daar is geen aktiwiteite met voltooiingskriteria in hierdie kursus ontsper nie.';
$string['error:nobadges'] = 'Daar is tans geen kentekens met toegang ontsper wat as kriteria bygevoeg kan word nie. \'n Webwerf kenteken kan slegs ander webwerf kentekens as kriteria hê. \'n Kursus kenteken kan ander kursus kentekens of webwerf kentekens as kriteria hê.';
$string['error:nocohorts'] = 'Geen kohorte';
$string['error:nocourses'] = 'Kursu voltooiing is nie ontsper vir enige van die kursusse op hierdie webwerf nie, so geen kan vertoon word nie. Kursus voltooiing kan in die kursus instellings ontsper word.';
$string['error:nogroupslink'] = '<p>Slegs publieke versamelings word vertoon. <a href="{$a}" target="_blank" rel="nofollow">Gaan na jou rugsak</a> om \'n paar publieke versamelings te skep.</p>';
$string['error:nogroupssummary'] = '<p>Daar is geen publieke kenteken versamelings in jou rugsak beskikbaar nie. </p>';
$string['error:nopermissiontoview'] = 'Jy het geen toetstemmings om kenteken ontvangers te besigtig nie';
$string['error:nosuchbadge'] = 'Kenteken met id {$a} bestaan nie.';
$string['error:nosuchcohort'] = 'Waarskuwing: Hierdie kohort is nie meer beskikbaar nie.';
$string['error:nosuchcourse'] = 'Waarskuwing: Hierdie kursus is nie meer beskikbaar nie.';
$string['error:nosuchfield'] = 'Waarskuwing: Hierdie gebruiker profiel veld is nie meer beskikbaar nie.';
$string['error:nosuchmod'] = 'Waarskuwing: Hierdie aktiwiteit is nie meer beskikbaar nie.';
$string['error:nosuchrole'] = 'Waarskuwing: Hierdie rol is nie meer beskikbaar nie.';
$string['error:nosuchuser'] = 'Gebruiker met hierdie e-posadres het nie \'n rekening by die die huidige rugsak verskaffer nie.';
$string['error:notifycoursedate'] = 'Waarskuwing: Kentekens wat met kursus en aktiwiteit voltooiings geassosieer word gaan nie uitgegee word tot die kursus begin datum nie.';
$string['error:parameter'] = 'Waarskuwing: Ten minste een beperking moet geselekteer word om korrekte kenteken toekenning werksvloei te verseker.';
$string['error:relatedbadgedoesntexist'] = 'Daar is geen publieke kenteken met hierdie identifiseerder nie';
$string['error:requesterror'] = 'Die konneksie aanvraag het misluk (fout kode {$a}).';
$string['error:requesttimeout'] = 'Die konneksie aanvraag het uit tyd uit gehardloop voordat dit kon voltooi.';
$string['error:save'] = 'Kan nie die kenteken stoor nie.';
$string['error:userdeleted'] = '{$a->user} (Hierdie gebruiker bestaan nie meer in {$a->site})';
$string['eventbadgearchived'] = 'Kenteken geargiveer';
$string['eventbadgeawarded'] = 'Kenteken toegeken';
$string['eventbadgecreated'] = 'Kenteken geskep';
$string['eventbadgecriteriacreated'] = 'Kenteken kriteria geskep';
$string['eventbadgecriteriadeleted'] = 'Kenteken kriteria uitgewis';
$string['eventbadgecriteriaupdated'] = 'Kenteken kriteria opgedateer';
$string['eventbadgedeleted'] = 'Kenteken uitgewis';
$string['eventbadgedisabled'] = 'Kenteken versper';
$string['eventbadgeduplicated'] = 'Kenteken gedupliseer';
$string['eventbadgeenabled'] = 'Kenteken ontsper';
$string['eventbadgelistingviewed'] = 'Kenteken lys besigitig';
$string['eventbadgerevoked'] = 'Kenteken herroep';
$string['eventbadgeupdated'] = 'Kenteken opgedateer';
$string['eventbadgeviewed'] = 'Kenteken besigitig';
$string['evidence'] = 'Bewyse';
$string['existingrecipients'] = 'Bestaande kenteken ontvangers';
$string['existsinbackpack'] = 'Kenteken bestaan alreeds in rugsak';
$string['expired'] = 'Verval';
$string['expiredate'] = 'Hierdie kenteken verval op {$a}.';
$string['expireddate'] = 'Hierdie kenteken het op {$a} verval.';
$string['expireperiod'] = 'Hierdie kenteken verval {$a} dag/dae nadat dit uitgereik is.';
$string['expireperiodh'] = 'Hierdie kenteken verval {$a} uur/ure nadat dit uitgereik is.';
$string['expireperiodm'] = 'Hierdie kenteken verval {$a} minuut/minute nadat dit uitgereik is.';
$string['expireperiods'] = 'Hierdie kenteken verval {$a} sekonde(s) nadat dit uitgereik is.';
$string['expirydate'] = 'Vervaldatum';
$string['expirydate_help'] = 'Opsioneel kan kentekens op \'n spesifieke datum verval, of die datum kan, gebaseer op die datum wanneer die kenteken aan die gebruiker toegeken is, bereken word.';
$string['externalbadges'] = 'My kentekens van ander webwerwe';
$string['externalbadges_help'] = 'Hierdie area vertoon kentekens van jou ekterne rugsak.';
$string['externalbadgesp'] = 'Kentekens van ander webwerwe:';
$string['externalconnectto'] = 'Om eksterne kentekens te vertoon moet jy <a href="{$a}">caan \'n rugsak konnekteer</a>.';
$string['fixed'] = 'Vaste datum';
$string['hidden'] = 'Versteek';
$string['hiddenbadge'] = 'Ongelukkig het die kenteken eienaar nie hierdie inligting beskikbaar gestel nie.';
$string['imageauthoremail'] = 'Beeld outeur se e-posadres uit';
$string['imageauthoremail_help'] = 'Indien gespesifiseer, word die e-posadres van die kenteken beeld outeur op die kenteken bladsy vertoon.';
$string['imageauthorname'] = 'Beeld outeur se naam uit';
$string['imageauthorname_help'] = 'Indien gespesifiseer, word die naam van die kenteken beeld outeur op die kenteken bladsy vertoon.';
$string['imageauthorurl'] = 'Beeld outeur se URL uit';
$string['imageauthorurl_help'] = 'Indien gespesifiseer, word \'n skakel na die kenteken beeld outeur se webwerf op die kenteken bladsy vertoon. Die URL moet \'n prefiks http:// of https:// hê.';
$string['imagecaption'] = 'Uitbeelding byskrif';
$string['imagecaption_help'] = 'Indien gespesifeer, word \'n uitbeelding byskrif op die kenteken bladsy vertoon.';
$string['includeauthdetails'] = 'Sluit verifikasie besonderhede met die rugsak in';
$string['invalidurl'] = 'Ongeldige URL';
$string['issuancedetails'] = 'Kenteken vervaldatum';
$string['issuedbadge'] = 'Toegekende kenteken inligting';
$string['issuerdetails'] = 'Uitgewer besonderhede';
$string['issueremail'] = 'E-pos';
$string['issueremail_help'] = '\'n Kontak e-posadres van die organisasie wat die bekragtiging uitgee';
$string['issuername'] = 'Uitgewer naam';
$string['issuername_endorsement'] = 'Bekragtiger naam';
$string['issuername_endorsement_help'] = 'Die naam van die bekragtiger.';
$string['issuername_help'] = 'Naam van die toekenningsagent of gesag.';
$string['issuerurl'] = 'Uitgewer URL';
$string['issuerurl_help'] = 'Die webwerf van die organisasie wat die bekragtiging uitgee. Die URL moet \'n prefiks http:// of https:// hê.';
$string['language'] = 'Taal';
$string['language_help'] = 'Die taal wat op die kenteken bladsy gebruik word.';
$string['listbackpacks'] = 'Lys van rugsakke';
$string['localbadges'] = 'My kentekens vanaf {$a} webwerf';
$string['localbadgesh'] = 'My kentekens vanaf hierdie webwerf';
$string['localbadgesh_help'] = 'Alle kentekens wat binne hierdie webwerf verdien kan word deur kursusse of kursus aktiwiteite te voltooi, of aan ander vereistes te voldoen.

Jy kan jou kentekens hier bestuur deur hulle publiek of privaat vir jou profiel bladsy te maak.

Jy kan al jou kentekens saam of apart aflaai en hulle op jou rekenaar stoor. Afgelaaide kentekens kan tot jou eksterne rugsak diens gevoeg word.';
$string['localbadgesp'] = 'Kentekens vanaf {$a}:';
$string['localconnectto'] = 'Om hierdie kentekens buite hierdie webwerf te deel, moet jy <a href="{$a}">aan \'n rugsak konnekteer</a>.';
$string['makeprivate'] = 'Maak privaat';
$string['makepublic'] = 'Maak publiek';
$string['managebackpacks'] = 'Bestuur rugsakke';
$string['managebadges'] = 'Bestuur kentekens';
$string['message'] = 'Boodskap liggaam';
$string['messagebody'] = '<p>Jy is die kenteken "%badgename%" toegeken!</p>
<p>Jy kan meer inligting oor hierdie kenteken op die %badgelink% kenteken inligting bladsy verkry.</p>
<p>Jy kan die kenteken vanaf jou {$a} bladsy bestuur en aflaai.</p>';
$string['messagesubject'] = 'Veels geluk! Jy het sopas \'n kenteken verwerf!';
$string['method'] = 'Die kriterium is volledig wanneer...';
$string['mingrade'] = 'Minimum punt vereis';
$string['month'] = 'Maand(e)';
$string['mybackpack'] = 'My rugsak instellings';
$string['mybadges'] = 'My kentekens';
$string['never'] = 'Nooit';
$string['newbackpack'] = 'Voeg \'n nuwe rugsak by';
$string['newbadge'] = 'Voeg \'n nuwe kenteken by';
$string['newimage'] = 'Nuwe beeld';
$string['noalignment'] = 'Hierdie kenteken het nie enige eksterne vaardighede of standaarde gespesifiseer nie.';
$string['noawards'] = 'Hierdie kenteken is nog nie verdien nie.';
$string['nobackpack'] = 'Daar is geen rugsak diens aan hierdie rekening gekonnekteer nie.<br/>';
$string['nobackpackbadgessummary'] = 'Daar is geen kentekens in die versamelings wat jy geselekteer het nie.';
$string['nobackpackcollectionssummary'] = 'Geen kenteken versamelings is geselekteer nie.';
$string['nobackpacks'] = 'Daar is geen rugsakke beskikbaar nie';
$string['nobadges'] = 'Daar geen kentekens beskikbaar nie.';
$string['nocompetencies'] = 'Geen bekwaamhede is geselekteer nie.';
$string['nocriteria'] = 'Kriteria vir hierdie kenteken is nog nie opgestel nie.';
$string['noendorsement'] = 'Hierdie kenteken het nie \'n bekragtiging nie.';
$string['noexpiry'] = 'Hierdie kenteken het nie \'n vervaldatum nie.';
$string['noparamstoadd'] = 'Daar is geen addisionele beperkinge beskikbaar wat tot hierdie kenteken vereiste gevoeg kan word nie,';
$string['norelated'] = 'Hierdie kenteken het nie enige verwante kentekens nie.';
$string['notacceptedrole'] = 'Jou huidige rol toekenning val nie onder die rolle wat hierdie kenteken met die hand kan uitgee nie.<br/> Indien jy gebruikers wil sien wat reeds hierdie kenteken verdien het, kan jy {$a} bladsy besigtig.';
$string['notconnected'] = 'Nie gekonnekteer nie';
$string['notealignment'] = 'Eksterne vaardighede of standaarde wat in ooreenstemming met die kenteken is, kan gespesifiseer word. Enige eksterne vaardighede of standaarde word op die kenteken bladsy vertoon.';
$string['noteendorsement'] = '\'n Bekragtiging vanaf \'n derde party kan gebruik word om waarde tot die kenteken te voeg. \'n Kenteken wat deur \'n onderwyser uitgegee word kan byvoorbeeld deur die skool bekragtig word, of \'n kenteken wat deur \'n plaaslike toekenningsliggaam uitgegee word kan deur die nasionale toekenningsliggaam bekragtig word.';
$string['noterelated'] = 'Kentekens met \'n konneksie kan as \'verwant\' gemerk word. Kentekens met dieselfde kriteria, wat in verskillende tale vertoon word, kan byvoorbeeld as \'verwant\' gemerk word. Enige verwante kentekens word op die kenteken bladsy vertoon.';
$string['nothingtoadd'] = 'Daar is geen beskikbare kriteria om by te voeg nie.';
$string['notification'] = 'Stel kenteken skepper in kennis';
$string['notification_help'] = 'Hierdie instelling bestuur kennisgewings wat na \'n kenteken skepper gestuur word om hulle in kennis te stel dat \'n kenteken uitgegee is.

Die volgende opsies is beskikbaar:

* **NOOIT** - Moet nie kennisgewings stuur nie.

* **ELKE KEER** - Stuur \'n kennisgewing elke keer wanneer hierdie kenteken uitgegee word.

* **DAAGLIKS** - Stuur kennisgewings een keer per dag.

* **WEEKLIKS** - Stuur kennisgewings een keer per week.

* **MAANDELIKS** - Stuur kennisgewings een keer per maand.';
$string['notifydaily'] = 'Daagliks';
$string['notifyevery'] = 'Elke keer';
$string['notifymonthly'] = 'Maandeliks';
$string['notifyweekly'] = 'Weekliks';
$string['numawards'] = 'Hierdie kenteken is al aan <a href="{$a->link}">{$a->count}</a> gebruiker(s) uitgegee.';
$string['numawardstat'] = 'Hierdie kenteken is al aan {$a} gebruiker(s) uitgegee.';
$string['oauth2issuer'] = 'OAuth 2 dienste';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['overallcrit'] = 'van die geselekteerde kriteria is voltooi.';
$string['potentialrecipients'] = 'Potensiële kenteken ontvangers';
$string['preferences'] = 'Kenteken voorkeure';
$string['privacy:metadata:backpack'] = '\'n Rekord van die gebruiker se rugsakke';
$string['privacy:metadata:backpack:backpackuid'] = 'Die rugsak se unieke idenitfiseerder';
$string['privacy:metadata:backpack:email'] = 'Die e-posadres wat met die rugsak geassosieer word';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Die ID van die rugsak';
$string['privacy:metadata:backpack:userid'] = 'Die ID van die gebruiker wie se rugsak dit is';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2 inligting wanneer die gebruiker aan \'n eksterne rugsak konnekteer';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2 diens ID';
$string['privacy:metadata:backpackoauth2:scope'] = 'Lys omvang van rugsak konneksie';
$string['privacy:metadata:backpackoauth2:token'] = 'Rugsak konneksie teken';
$string['privacy:metadata:backpackoauth2:userid'] = 'Die ID van die gebruiker konneksie tot rugsak';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Die ID van die gebruiker veranderde konneksie';
$string['privacy:metadata:badge'] = '\'n Versameling van kentekens';
$string['privacy:metadata:badge:timecreated'] = 'Die tyd waarop die kenteken geskep is';
$string['privacy:metadata:badge:timemodified'] = 'Die tyd waarop die kenteken die laaste keer verander is';
$string['privacy:metadata:badge:usercreated'] = 'Die ID van die gebruiker wat die kenteken geskep het';
$string['privacy:metadata:badge:usermodified'] = 'Die ID van die gebruiker wat die kenteken verander het';
$string['privacy:metadata:criteriamet'] = '\'n Versameling van kriteria waaraan voldoen is';
$string['privacy:metadata:criteriamet:datemet'] = 'Die datum waarop daar aan die kriteria voldoen is';
$string['privacy:metadata:criteriamet:userid'] = 'Die ID van die gebruiker wat aan die kriteria voldoen het';
$string['privacy:metadata:external:backpacks'] = 'Inligting wat gedeel word wanneer gebruikers hul kentekens tot \'n eksterne rugsak voeg';
$string['privacy:metadata:external:backpacks:badge'] = 'Die naam van die kenteken';
$string['privacy:metadata:external:backpacks:description'] = 'Die beskrywing van die kenteken';
$string['privacy:metadata:external:backpacks:image'] = 'Die beeld van die kenteken';
$string['privacy:metadata:external:backpacks:issuer'] = 'Sekere inligting  oor die uitgewer';
$string['privacy:metadata:external:backpacks:url'] = 'Die Moodle URL waar die toegekende kenteken inligting gesien kan word';
$string['privacy:metadata:issued'] = '\'n Rekord van toegekende kentekens';
$string['privacy:metadata:issued:dateexpire'] = 'Die datum waarop die keteken verval';
$string['privacy:metadata:issued:dateissued'] = 'Die datum van toekennig';
$string['privacy:metadata:issued:userid'] = 'Die ID van die gebruiker wat \'n kenteken uitgegee het';
$string['privacy:metadata:manualaward'] = '\'n Rekord van kentekens wat met die hand uitgegee is';
$string['privacy:metadata:manualaward:datemet'] = 'Die datum waarop die gebruiker die kenteken toegeken is';
$string['privacy:metadata:manualaward:issuerid'] = 'Die ID van die gebruiker wat die kenteken toegeken het';
$string['privacy:metadata:manualaward:issuerrole'] = 'Die rol van die gebruiker wat die kenteken uitgegee het';
$string['privacy:metadata:manualaward:recipientid'] = 'Die ID van die gebruiker wat die kenteken met die hand ontvang het';
$string['recipientdetails'] = 'Ontvanger besonderhede';
$string['recipientidentificationproblem'] = 'Kan nie \'n ontvanger van hierdie kenteken onder die bestaande gebruikers vind nie.';
$string['recipients'] = 'Kenteken ontvangers';
$string['recipientvalidationproblem'] = 'Huidige gebruiker kan nie as \'n ontvanger van hierdie kenteken geverifieer word nie.';
$string['relatedbages'] = 'Verwante kentekens';
$string['relative'] = 'Betrokke datum';
$string['requiredbadge'] = 'Ten minste een kenteken moet tot die kenteken kriterium gevoeg word.';
$string['requiredcohort'] = 'Ten minste een kohort moet tot die kohort kriterium gevoeg word.';
$string['requiredcompetency'] = 'Ten minste een bekwaamheid moet tot die bekwaamheid kriterium gevoeg word.';
$string['requiredcourse'] = 'Ten minste een kursus moet tot die kursusstel kriterium gevoeg word.';
$string['reviewbadge'] = 'Veranderinge in kenteken toegang';
$string['reviewconfirm'] = '<p>Hierdie gaan jou kenteken aan gebruikers sigbaar maak en hulle toelaat om begin om dit te verdien.<p>

<p>Dit is moontlik dat sommige gebruikers alreeds aan die vereistes vir hierdie kenteken voldoen. Hierdie kenteken sal aan hulle toegeken word sodra jy dit ontsper.<p>

<p>Wanneer \'n kenteken uitgegee is word dit <strong>gesluit</strong>. Sekere instellings, insluitend die kriteria en vervaldatum instellings, gaan nie meer verander kan word nie.<p>

<p>Is jy seker dat jy toegang tot hierdie kenteken\'{$a}\' wil ontsper?<p?';
$string['revoke'] = 'Herroep kenteken';
$string['save'] = 'Stoor';
$string['searchname'] = 'Soek volgens naam';
$string['selectaward'] = 'Selekteer assblief die rol wat jy wil gebruik om hierdie kenteken toe te ken:';
$string['selectgroup_end'] = 'Slegs publieke versamelings word vertoon.  <a href="{$a}">Gaan na jou rugsak</a> om meer publieke versamelings te skep.';
$string['selectgroup_start'] = 'Selekteer versamelings vanuit jou rugsak om op hierdie webwerf te vertoon:';
$string['selecting'] = 'Met geselekteerde kentekens...';
$string['setup'] = 'Stel konneksie op';
$string['sitebackpack'] = 'Aktiewe eksterne rugsak';
$string['sitebackpack_help'] = 'Die eksterne rugsak waaraan gebruikers vanaf hierdie webwerf kan konnekteer. Let daarop dat, indien hierdie instelling verander word nadat gebruikers hul rugsakke gekonnekteer het, elke gebruiker na hul rugsak instellings bladsy sal moet teruggaan en van daar af ontkoppel en dan weer konnekteer.';
$string['sitebackpackdeleted'] = 'Die webwerf rugsak is uitgewis.';
$string['sitebackpacknotdeleted'] = 'Hierdie rugsak kon nie uitgewis word nie, omdat dit huidig die webwerf verstek is.';
$string['sitebackpackverify'] = 'Rugsak konneksie';
$string['sitebackpackwarning'] = 'Kon nie aan rugsak konnekteer nie. <br/><br/>Maak seker dat die "Kenteken uitgewer e-posadres" admin instelling die geldige e-posadres vir \'n rekening op die rugsak webwerf is.  <br/><br/> Maak seker dat die "Kenteken uitgewer wagwoord" op die <a href="{$a->url}">webwerf rugsak instellings bladsy</a> die korrekte wagwoord vir die rekening op die rugsak webwerf is.  <br/><br/>Die rugsak het teruggestuur: "{$a->warning}"';
$string['sitebadges'] = 'Webwerf kentekens';
$string['sitebadges_help'] = 'Webwerf kentekens kan slegs aan gebruikers vir webwerf-verwante aktiwiteite toegeken word. Hierdie sluit in om \'n stel kursusse of gedeeltes van gebruikers se profiele te voltooi, in. Webwerf kentekens kan ook met die hand deur \'n gebruiker aan \'n ander toegeken word.

Kentekens vir kursus-verwante aktiwiteite moet op kursusvlak geskep word. Kursus kentekens kan onder Kursus Administrasie > Kentekens gevind word.';
$string['status'] = 'Kenteken status';
$string['status_help'] = '\'n Kenteken se status bepaal sy gedrag in die sisteem:

* **BESKIKBAAR** - Beteken dat hierdie kenteken deur gebruikers verdien kan word. Terwyl \'n kenteken aan gebruikers beskikbaar is kan die kriteria van daardie kenteken nie verander word nie.

As \'n kenteken eers aan ten minste een gebruiker toegeken is, word dit outomaties **GESLUIT**. Geslote kentekens kan steeds deur gebruiekrs verdien word, maar die kriteria van daardie kentekens kan nie meer verander word nie. Indien dit nodig is om besonderhede of kriteria van \'n geslote kenteken te verander, kan jy daardie kenteken dupliseer en die vereiste veranderinge daarop maak.

*Waarom sluit ons kentekens?*

Ons wil seker maak dat alle gebruikers aan dieselfde vereistes moet voldoen om \'n kenteken te verdien. Dit is tans nie moontlik om kentekens te herroep nie. Indien ons sou toelaat dat vereistes die hele tyd verander kan word, sal dit heel moontlik veroorsaak dat gebruikers dieselfde kenteken verdien met totaal en al verskillende vereistes.';
$string['statusmessage_0'] = 'Hierdie kenteken is tans nie aan gebruikers beskikbaar nie. Ontsper toegang indien jy dit wil moontlik maak dat gebruikers hierdie kenteken verdien.';
$string['statusmessage_1'] = 'Hierdie kenteken is tans aan gebruikers beskikbaar. Versper toegang indien jy enige veranderinge wil maak.';
$string['statusmessage_2'] = 'Hierdie kenteken is tans nie aan gebruikers beskikbaar nie en die kriteria daarvan is gesluit. Ontsper toegang indien jy dit wil moontlik maak dat gebruikers hierdie kenteken verdien.';
$string['statusmessage_3'] = 'Hierdie kenteken is tans aan gebruikers beskikbaar en die kriteria daarvan is gesluit.';
$string['statusmessage_4'] = 'Hierdie kenteken is tans geargiveer.';
$string['subject'] = 'Boodskap onderwerp';
$string['targetcode'] = 'Kode';
$string['targetcode_help'] = '\'n Unieke string identifiseerder waarna die eksterne vaardigheid of standaard binne sy raamwerk verwys kan word.';
$string['targetdescription'] = 'Beskrywing';
$string['targetdescription_help'] = 'Kort beskrywing van die eksterne vaardigheid of standaard.';
$string['targetframework'] = 'Raamwerk';
$string['targetframework_help'] = 'Naam van die eksterne vaardigheid of standaard.';
$string['targetname'] = 'Naam';
$string['targetname_help'] = 'Die eksterne vaardigheid of standaard waarmee die kenteken ooreen stem.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = '\'n Skakel na \'n bladsy met \'n beskrywing van die eksterne vaardigheid of standaard. Die URL moet \'n prefiks http:// of https:// hê.';
$string['testbackpack'] = 'Toets rugsak \'{$a}\'';
$string['testsettings'] = 'Toets instellings';
$string['type'] = 'Tipe';
$string['variablesubstitution'] = 'Veranderlike plaasvervanging in boodskappe.';
$string['variablesubstitution_help'] = 'In \'n kenteken boodskap kan sekere veranderlikes in die onderwerp en/of liggaam van \'n boodskap geplaas word, sodat hulle met regte waardes vervang word wanneer die boodskap gestuur word. Die veranderlikes moet, presies soos hier onder gewys, in die teks verskyn. Die volgende veranderlikes kan gebruik word:

%badgename%
: Hierdie sal met die kenteken se volle naam vervang word.

%username%
: Hierdie sal met die ontvanger se volle naam vervang word.

%badgelink%
: Hierdie sal met die publieke URL, met inligting oor die toegekende kenteken, vervang word.';
$string['version'] = 'Weergawe';
$string['version_help'] = 'Hierdie weergawe veld kan gebruik word om te kyk hoe die kenteken ontwikkel. Indien gespesifiseer word die weergawe op die kenteken bladsy vertoon.';
$string['viewbadge'] = 'Besigtig uitgereikte kenteken';
$string['visible'] = 'Sigbaar';
$string['warnexpired'] = '(Hierdie kenteken het verval!)';
$string['year'] = 'Jaar/Jare';
