<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'af', version '4.0'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Jy kan \'n voorskou van die vasvra sien, maar indien hierdie \'n egte poging was, sou jy geblok gewees het omrede:';
$string['action'] = 'Aksie';
$string['activityoverview'] = 'Jy het vasvrae wat verskuldig is';
$string['adaptive'] = 'Aanpasbare modus';
$string['adaptive_help'] = 'Indien geaktiveer, word verskeie antwoorde op \'n vraag binne dieselfde vasvrapoging toegelaat. As \'n antwoord byvoorbeeld as verkeerd gemerk is, mag die student onmiddellik weer probeer. Afhangend van die instelling "Pas boetes toe", sal \'n student gewoonlik vir elke verkeerde poging gepenaliseer word.';
$string['add'] = 'Voeg by';
$string['addaquestion'] = '\'n nuwe vraag';
$string['addarandomquestion'] = '\'n ewekansige vraag';
$string['addarandomquestion_help'] = 'Wanneer \'n ewekansige vraag bygevoeg word, lei dit tot \'n lukraak gekose vraag uit die kategorie wat in die vasvra ingevoeg word. Dit beteken dat verskillende studente waarskynlik \'n ander stel vrae sal kry, en wanneer \'n vasvra verskeie pogings toelaat, sal elke poging waarskynlik \'n nuwe vraagstel bevat.';
$string['addarandomselectedquestion'] = 'Voeg \'n ewekansig verkose vraag by...';
$string['addasection'] = '\'n nuwe afdelingsopskrif';
$string['adddescriptionlabel'] = 'Voeg \'n beskrywende item by';
$string['addingquestion'] = 'Voeg \'n vraag by';
$string['addingquestions'] = '<p> Aan hierdie kant van die bladsy bestuur jy jou vraagdatabasis. Vrae word in kategorieë gestoor om hul georganiseerd te hou, en kan gebruik word deur enige vasvrae in jou kursus of selfs ander kursusse as jy verkies om dit te \'publiseer\'.</p> Nadat jy \'n vraagkategorie gekies of geskep het, kan jy vrae skep of wysig. Jy kan enige van hierdie vrae kies om by jou vasvra aan die ander kant van hierdie bladsy by te voeg. </p>';
$string['addmoreoverallfeedbacks'] = 'Voeg {geen} meer terugvoerlêers by nie';
$string['addnewgroupoverride'] = 'Voeg groepoorskryding by';
$string['addnewpagesafterselected'] = 'Voeg nuwe bladsye na verkose vrae by';
$string['addnewquestionsqbank'] = 'Voeg vrae by die kategorie {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Voeg gebruikeroorskryding by';
$string['addpagebreak'] = 'Voeg bladsybreuk by';
$string['addpagehere'] = 'Voeg bladsy hier in';
$string['addquestion'] = 'Voeg vraag by';
$string['addquestionfrombankatend'] = 'Voeg by vanaf die vraagbank teen die einde';
$string['addquestionfrombanktopage'] = 'Voeg vanaf die vraagbank vrae by bladsy {$a} by';
$string['addquestions'] = 'Voeg vrae by';
$string['addquestionstoquiz'] = 'Voeg vrae tot by huidige vasvra';
$string['addrandom'] = 'Voeg {$a} ewekansige vrae by';
$string['addrandom1'] = '<< Voeg by';
$string['addrandom2'] = 'ewekansige vrae';
$string['addrandomfromcategory'] = 'Voeg ewekansige vrae vanaf kategorie by:';
$string['addrandomquestion'] = 'Voeg ewekansige vraag by';
$string['addrandomquestionatend'] = 'Voeg ewekansige vraag aan die einde by';
$string['addrandomquestiontopage'] = 'Voeg \'n ewekansige vraag by bladsy {$a} by';
$string['addrandomquestiontoquiz'] = 'Voeg \'n ewekansige vraag by die vasvra {$a} by';
$string['addselectedquestionstoquiz'] = 'Voeg verkose vrae by die vasvra by';
$string['addselectedtoquiz'] = 'Voeg geselekteerdes by die vasvra';
$string['addtoquiz'] = 'Voeg by tot vasvra';
$string['affectedstudents'] = 'Geaffekteerde {$a}';
$string['aftereachquestion'] = 'Nadat elke vraag gelees is';
$string['afternquestions'] = 'Nadat {$a} questions bygevoeg is';
$string['age'] = 'ouderdom';
$string['allattempts'] = 'Alle pogings';
$string['allinone'] = 'Onbeperk';
$string['allowreview'] = 'Laat hersiening toe';
$string['alreadysubmitted'] = 'Jy het waarskynlik reeds hierdie poging ingedien';
$string['alternativeunits'] = 'Alternatiewe eenhede';
$string['alwaysavailable'] = 'Altyd beskikbaar';
$string['analysisoptions'] = 'Analiseringsopsies';
$string['analysistitle'] = 'Itemanalisetabel';
$string['answer'] = 'Antwoord';
$string['answered'] = 'Beantwoord';
$string['answerhowmany'] = 'Een of meer antwoorde?';
$string['answers'] = 'Antwoorde';
$string['answersingleno'] = 'Meervoudige antwoorde toegelaat';
$string['answersingleyes'] = 'Slegs een antwoord';
$string['answertoolong'] = 'Antwoord te lank na lyn {$a} (255 char. max)';
$string['anytags'] = 'Enige merkers';
$string['aon'] = 'AON formaat';
$string['areyousureremoveselected'] = 'Is jy seker dat jy al die verkose vrae wil verwyder?';
$string['asshownoneditscreen'] = 'Soos gewys op die redigeer skerm';
$string['attempt'] = 'Poging {$a}';
$string['attemptalreadyclosed'] = 'Jou poging is reeds voltooi.';
$string['attemptclosed'] = 'Poging nog nie gesluit nie';
$string['attemptduration'] = 'Tyd geneem';
$string['attemptedon'] = 'Gepoog op';
$string['attempterror'] = 'Jy word nie toegelaat om die vasvra op hierdie stadium aan te pak nie, omdat: {$a}';
$string['attempterrorcontentchange'] = 'Hierdie vasvravoorskou bestaan nie meer nie. (Wanneer \'n vasvra geredigeer word, word enige voorskoue wat aan die gang is, outomaties uitgevee.)';
$string['attempterrorcontentchangeforuser'] = 'Die vasvrapoging bestaan nie meer nie.';
$string['attempterrorinvalid'] = 'Ongeldige vasvrapoging ID';
$string['attemptfirst'] = 'Eerste poging';
$string['attemptincomplete'] = 'Die poging (deur{$a}) is steeds nie voltooi nie.';
$string['attemptlast'] = 'Laaste poging';
$string['attemptnumber'] = 'Poging';
$string['attemptquiz'] = 'Doen vasvra';
$string['attemptquiznow'] = 'Probeer vasvra nou';
$string['attemptreviewtitle'] = '{$a}: Vasvra hersiening';
$string['attemptreviewtitlepaged'] = '{$a->name}: Poging hiersiening (page {$a->currentpage} van {$a->totalpages})';
$string['attempts'] = 'Pogings';
$string['attempts_help'] = 'Totale aantal pogings toegelaat (nie die totale aantal ekstra pogings nie).';
$string['attemptsallowed'] = 'Pogings toegelaat';
$string['attemptsdeleted'] = 'Vasvra pogings uitgevee';
$string['attemptselection'] = 'Kies watter pogings jy wil analiseer per gebruiker:';
$string['attemptsexist'] = 'Jy kan nie meer vrae by voeg of verwyder nie.';
$string['attemptsnum'] = 'Pogings: {$a}';
$string['attemptsnumthisgroup'] = 'Pogings: {$a->total} ({$a->group} van hierdie groep)';
$string['attemptsnumyourgroups'] = 'Pogings: {$a->total} ({$a->group} van jou groepe)';
$string['attemptsonly'] = 'Wys alleenlik studente met pogings';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Poging steeds aan die gang';
$string['attemptsummarytitle'] = '{$a}: Poging opsomming';
$string['attemptsunlimited'] = 'Onbeperkte pogings';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (bladys {$a->currentpage} van {$a->totalpages})';
$string['autosaveperiod'] = 'Outostoor vertraging';
$string['autosaveperiod_desc'] = 'Antwoorde kan outomaties gestoor word tydens vasvra-pogings. Die antwoorde word gestoor wanneer een verander word en dan na vertragings. Daar is \'n kompromie: \'n korter vertraging verhoog die bedienerbelasting, maar verminder die kans dat studente hul werk verloor. As jy hierdie vertraging baie korter gaan maak, moet jy die waarde geleidelik verander en die bedienerlading dophou. As die las te hoog word, moet jy die vertraging weer langer maak. As jy die vertraging op 0 stel, word outobesparing uitgeskakel.';
$string['back'] = 'Terug na vorige vraag';
$string['backtocourse'] = 'Terug na die kursus';
$string['backtoquestionlist'] = 'Terug na vraaglys';
$string['backtoquiz'] = 'Terug na vasvra-redigering';
$string['basicideasofquiz'] = 'Die basiese idees van vasvra skep';
$string['bestgrade'] = 'Beste punt';
$string['bothattempts'] = 'Wys studente met of sonder pogings';
$string['browsersecurity'] = 'Webblaaier sekuriteit';
$string['browsersecurity_help'] = 'Indien "Volledige skerm pop-up met \'n sekere JavaScript-sekuriteit" gekies is,

* sal die vasvra slegs begin as die student \'n webblaaier met JavaScript het.
* sal die vasvra verskyn in \'n volskermvenster sonder enige navigasiekontroles
* sal studente sover moontlik verhinder word om funksies soos knip en plak te gebruik';
$string['cachedef_overrides'] = 'Inligting oor gebruiker- en groepoorheersing';
$string['calculated'] = 'Berekend';
$string['calculatedquestion'] = 'Berekende vrae word nie ondersteun by lyn {$a}. Hierdie vraag sal ignoreer word';
$string['cannotcreatepath'] = 'Pad kan nie geskep word nie ({$a})';
$string['cannoteditafterattempts'] = 'Jy kan nie vrae by voeg of wegneem nie, omdat pogings reeds op hierdie vasvra plaasgevind het. ({$a})';
$string['cannotfindprevattempt'] = 'Kan nie vorige pogings vind om op voort te bou nie.';
$string['cannotfindquestionregard'] = 'Pogings om vrae vir hermerk op te spoor het misluk!';
$string['cannotinsert'] = 'Kan nie vraag invoeg nie';
$string['cannotinsertrandomquestion'] = 'Kon nie \'n nuwe ewekansige vraag invoeg nie!';
$string['cannotloadquestion'] = 'Kon nie vraagopsies laai nie';
$string['cannotloadtypeinfo'] = 'Kan nie spesifieke vrae van die vraagtipe laai nie';
$string['cannotopen'] = 'Kan nie uitvoerlêer oopmaak nie ({$a})';
$string['cannotremoveallsectionslots'] = 'Jy het al die vrae onder die \'{$a}\' afdelingsopskrif gekies. Dit word nie toegelaat om alle vrae onder \'n spesifieke afdeling te verwyder nie.';
$string['cannotremoveslots'] = 'Kannie alle vrae verwyder nie';
$string['cannotrestore'] = 'Kan nie vraagsessies herstel nie';
$string['cannotreviewopen'] = 'Kan kan nie hierdie poging hersien nie, want dit is steeds oop.';
$string['cannotsavelayout'] = 'Kan nie aansig stoor nie';
$string['cannotsavenumberofquestion'] = 'Kan nie aantal vrae per bladsy stoor nie';
$string['cannotsavequestion'] = 'Kan nie vraaglys stoor nie';
$string['cannotsetgrade'] = 'Kon nie \'n nuwe maksimumpunt vir die vasvra stel nie';
$string['cannotsetsumgrades'] = 'Somtotaalinstelling het misluk';
$string['cannotstartgradesmismatch'] = 'Kan nie met \'n poging tot hierdie vasvra begin nie. Die vasvra sal uit {$ a-> graad} gemerk word, maar geen van die vrae in die vasvra het \'n punt nie. Dit kan reggestel word op die \'Wysig vasvra\'-bladsy.';
$string['cannotstartmissingquestion'] = 'Kan nie met \'n poging tot hierdie vasvra begin nie. Die vasvradefinisie bevat \'n vraag wat nie bestaan nie.';
$string['cannotstartnoquestions'] = 'Kan nie met \'n poging tot hierdie vasvra begin nie. Die vasvra is nog nie opgestel nie. Geen vrae is bygevoeg nie.';
$string['cannotwrite'] = 'Het nie skryftoegang tot uitvoerlêer nie ({$a})';
$string['canredoquestions'] = 'Laat oordoen binne \'n poging toe';
$string['canredoquestions_desc'] = 'Indien geaktiveer, word die knoppie \'Probeer \'n ander vraag soos hierdie\' na afloop van \'n vraag vertoon. Hierdeur kan \'n soortgelyke vraag (lukraak gekies) gepoog word, of dieselfde vraag weer gedoen word, sonder dat die hele vasvra-poging ingedien moet word en \'n ander poging begin.

Hierdie opsie is handig vir oefenvrae. Hierdie instelling beïnvloed slegs vrae en gedrag (soos onmiddellike terugvoer of interaktief met verskeie probeerslae) waar dit moontlik is om \'n vraag af te handel voordat die poging ingedien word.';
$string['canredoquestions_help'] = 'Indien geaktiveer, word die knoppie \'Probeer \'n ander vraag soos hierdie\' na afloop van \'n vraag vertoon. Hierdeur kan \'n soortgelyke vraag (lukraak gekies) gepoog word, of dieselfde vraag weer gedoen word, sonder dat die hele vasvra-poging ingedien moet word en \'n ander poging begin.

Hierdie opsie is handig vir oefenvrae. Hierdie instelling beïnvloed slegs vrae en gedrag (soos onmiddellike terugvoer of interaktief met verskeie probeerslae) waar dit moontlik is om \'n vraag af te handel voordat die poging ingedien word.';
$string['canredoquestionsyes'] = 'Ja, verskaf die opsie om \'n ander vraag te probeer';
$string['caseno'] = 'Nee, hooflettergevoeligheid is onbelangrik';
$string['casesensitive'] = 'Hooflettergevoelig';
$string['caseyes'] = 'Ja, hooflettergevoeligheid is belangrik';
$string['categoryadded'] = 'Die kategorie \'{$a}\' was bygevoeg';
$string['categorydeleted'] = 'Die kategorie \'{$a}\' was uitgevee';
$string['categorynoedit'] = 'Jy besit nie redigeringsvoorregte vir hierdie kategorie nie \'{$a}\'.';
$string['categoryupdated'] = 'Die kategorie was suksesvol opdateer';
$string['close'] = 'Sluit venster';
$string['closebeforeopen'] = 'Jy kan nie die vasvra opdateer nie. Jy het \'n sluitingsdatum voor die begindatum spesifiseer.';
$string['closed'] = 'Gesluit';
$string['closepreview'] = 'Sluit voorskou';
$string['closereview'] = 'Sluit voorskou';
$string['comment'] = 'Kommentaar';
$string['commentorgrade'] = 'Maak kommentaar of pas punt aan';
$string['comments'] = 'Kommentaar';
$string['completedon'] = 'Voltooi op';
$string['completionattemptsexhausted'] = 'Of alle beskikbare pogings voltooi';
$string['completionattemptsexhausted_help'] = 'Merk vasvra volledig wanneer die student die maksimum aantal probeerslae uitgeput het.';
$string['completionattemptsexhausteddesc'] = 'Voltooi indien die beskikbare probeerslae uitgeput is';
$string['completiondetail:minattempts'] = 'Maak pogings: {$a}';
$string['completiondetail:passgrade'] = 'Behaal \'n slaagpunt';
$string['completiondetail:passorexhaust'] = 'Behaal \'n slaagpunt of voltooi alle beskikbare pogings';
$string['completionminattempts'] = 'Minimum aantal probeerslae:';
$string['completionminattemptsdesc'] = 'Minimum getal pogings verlang: {$a}';
$string['completionminattemptserror'] = 'Minimum aantal probeerslae moet laer of gelyk aan toegelate pogings wees.';
$string['completionminattemptsgroup'] = 'Vereis pogings';
$string['completionpass'] = 'Vereis slaagpunt';
$string['completionpass_help'] = 'Indien geaktiveer, word hierdie aktiwiteit wanneer die student \'n slaagsyfer (soos gespesifiseer in die Punte-afdeling van die vasvra-instellings) of hoër ontvang, as voltooi beskou.';
$string['completionpassdesc'] = 'Studente moet \'n slaagsyfer bereik ten einde hierdie aktiwiteit te voltooi.';
$string['completionpassorattemptsexhausteddesc'] = 'Student moet \'n slaagpunt behaal, of alle beskikbare pogings vir voltooiing van hierdie aktiwiteit opgebruik.';
$string['configadaptive'] = 'Indien jy, Ja kies vir hierdie opsie, sal die student verskeie antwoorde op \'n vraag kry, selfs binne dieselfde vasvrapoging.';
$string['configattemptsallowed'] = 'Beperkings op die aantal pogings wat toegelaat word is van toepassing by die vasvra.';
$string['configdecimaldigits'] = 'Aantal syfers wat na die desimale punt gewys moet word wanneer punte vertoon word.';
$string['configdecimalplaces'] = 'Aantal syfers wat na die desimale punt gewys moet word wanneer punte vir die vasvra vertoon word.';
$string['configdecimalplacesquestion'] = 'Aantal syfers wat na die desimale punt gewys moet word wanneer individuele punte vertoon word.';
$string['configdelay1'] = 'Indien jy \'n tydvertraging stel, moet \'n student wag vir die tydperk wat jy ingestel het, voordat hulle weer \'n vasvra kan probeer na die eerste poging.';
$string['configdelay1st2nd'] = 'Indien jy \'n tydvertraging stel, kan die student nie hul tweede poging begin tot hierdie hoeveelheid tyd verbygegaan het na hul eerste poging nie.';
$string['configdelay2'] = 'Indien jy \'n tydsvertraging hier instel, moet \'n student wag vir hierdie tyd om verby te gaan, voordat hulle derde of verdere pogings aanwend.';
$string['configdelaylater'] = 'Indien jy \'n tydsvertraging hier stel, kan die student nie hul derde, vierde,... pogings begin tot hierdie hoeveelheid tyd verbygegaan het sedert hul laaste poging nie.';
$string['configeachattemptbuildsonthelast'] = 'Indien verskeie pogings toegelaat word dan bevat elke nuwe poging die resultaat van die vorige poging.';
$string['configgrademethod'] = 'Watter van die volgende metodes moet gebruik word om studente se finale vasvrapunt uit te werk, wanneer daar van verskeie pogings gebruik gemaak word.';
$string['configintro'] = 'Die waardes wat jy hier stel, definieer die standaardwaardes wat in die instellingsvorm gebruik word wanneer jy \'n nuwe vasvra skep. Jy kan ook instel watter vasvra-instellings as gevorderd beskou behoort te word.';
$string['configmaximumgrade'] = 'Die verstekpunt wat die vasvrapunt uit bestaan.';
$string['confignavmethod'] = 'In Vrye navigasie, kan vrae in enige orde beantwoord word mbv. navigasie. In Volgordelik, moet vrae volgens \'n streng orde beantwoord word.';
$string['confignewpageevery'] = 'Wanneer jy vrae by die vasvra voeg, sal bladsybreuke outomaties ingevoeg word volgens die instelling wat jy hier verkies.';
$string['configoutcomesadvanced'] = 'Indien hierdie opsie aangeskakel word, sal die Uitkomstes op die vasvraredigeringform gevorderde instellings wees.';
$string['configpenaltyscheme'] = 'Strafpunte vir elke verkeerde antwoord in die aanpasbare modus';
$string['configpopup'] = 'Dwing die poging om in \'n venstertjie oop te maak, en gebruik JavaScript-truuks om kopiëring en plak, ens. te probeer beperk tydens vasvra-pogings.';
$string['configrequirepassword'] = 'Studente moet hul wagwoord insleutel voor hul die vasvra kan aanpak.';
$string['configrequiresubnet'] = 'Studente kan slegs die vasvra van hierdie rekenaars aanpak.';
$string['configreviewoptions'] = 'Hierdie opsies bepaal watter inligting gebruikers kan sien wanneer hulle \'n vasvra-poging hersien of na die vasvraverslae kyk.';
$string['configshowblocks'] = 'Wys blokke tydens vasvrapoging.';
$string['configshowuserpicture'] = 'Wys die gebruiker se foto op die skerm tydens pogings.';
$string['configshufflewithin'] = 'Indien jy hierdie opsie aktiveer, sal die dele waaruit die individuele vrae bestaan, willekeurig geskommel word elke keer as \'n student \'n poging aanwend om hierdie vasvra te doen, mits die opsie ook in die vraaginstellings geaktiveer is.';
$string['configtimelimit'] = 'Verstektydsbeperking vir vasvrae in minute. 0 beteken geen tydbeperking.';
$string['configtimelimitsec'] = 'Verstektydsbeperking vir vasvrae in sekondes. 0 beteken geen tydbeperking.';
$string['configurerandomquestion'] = 'Stel vraag op';
$string['confirmclose'] = 'Sodra jy ingedien het, sal jy nie meer instaat wees om jou antwoorde vir hierdie poging te verander nie.';
$string['confirmremovequestion'] = 'Is jy seker dat jy hierdie {$a} vraag wil verwyder?';
$string['confirmremovesectionheading'] = 'Is jy seker dat jy hierdie {$a} afdelingsopskrif wil verwyder?';
$string['confirmserverdelete'] = 'Is jy seker dat jy hierdie bediener <b>{$a}</b> van die lys wil verwyder?';
$string['connectionerror'] = 'Netwerkverbinding verloor. (Outo-stoor het misluk).

Maak \'n aantekening van die antwoorde wat die afgelope paar minute op hierdie bladsy ingevoer is, en probeer dan om weer om te konnekteer.

Sodra die verbinding weer tot stand gebring is, moet jou antwoorde gestoor word en sal hierdie boodskap sal verdwyn.';
$string['connectionok'] = 'Netwerkverbinding is herstel. Jy kan nou veilig voortgaan.';
$string['containercategorycreated'] = 'Hierdie kategorie is geskep om al die oorspronklike kategorieë wat na webbladvlak geskuif is te stoor op grond van die oorsake hieronder aangedui.';
$string['continueattemptquiz'] = 'Gaan voort met laaste poging';
$string['continuepreview'] = 'Gaan voort met laaste voorskou';
$string['copyingfrom'] = 'Skep \'n kopie van die vraag \'{$a}\'';
$string['copyingquestion'] = 'Kopieer \'n vraag';
$string['correct'] = 'Reg';
$string['correctanswer'] = 'Regte antwoord';
$string['correctanswerformula'] = 'Regte antwoordformule';
$string['correctansweris'] = 'Regte antwoord: {$a}';
$string['correctanswerlength'] = 'Beduidende syfers';
$string['correctanswers'] = 'Regte antwoorde';
$string['correctanswershows'] = 'Regte antwoord wys';
$string['corrresp'] = 'Regte reaksie';
$string['countdown'] = 'Aftel';
$string['countdownfinished'] = 'Die vasvra is besig om toe te maak, jy moet jou antwoorde nou indien.';
$string['countdowntenminutes'] = 'Die vasvra sal in tien minute sluit.';
$string['coursetestmanager'] = 'Kursus Toetsbestuurder formaat';
$string['createcategoryandaddrandomquestion'] = 'Skep kategorie en voeg ewekansige vraag by';
$string['createfirst'] = 'Jy moet \'n paar kortantwoord vrae eers skep.';
$string['createmultiple'] = 'Voeg verskeie ewekansige vra by vasvra by.';
$string['createnewquestion'] = 'Skep nuwe vraag';
$string['createquestionandadd'] = 'Skep \'n nuwe vraag en voeg dit tot die vasvra by.';
$string['custom'] = 'Pasgemaakte formaat';
$string['dataitemneed'] = 'Jy moet ten minste een stel van data item kry om \'n geldige vraag te verkry';
$string['datasetdefinitions'] = 'Herbruikbare definisies vir datastelle vir kategorie {$a}';
$string['datasetnumber'] = 'Getal';
$string['daysavailable'] = 'Dae beskikbaar';
$string['decimaldigits'] = 'Desimale syfers in punte';
$string['decimalplaces'] = 'Desimale plekke in punte';
$string['decimalplaces_help'] = 'Hierdie instelling spesifiseer die aantal syfers wat na die desimale punt getoon word wanneer punte vertoon word. Dit beïnvloed slegs die vertoning van punte, nie die grade wat in die databasis gestoor word nie, en ook nie die interne berekeninge wat met volle akkuraatheid uitgevoer word nie.';
$string['decimalplacesquestion'] = 'Desimale plekke in vraagpunte';
$string['decimalplacesquestion_help'] = 'Hierdie instelling spesifiseer die aantal syfers wat na die desimale punt vertoon word wanneer die punte vir individuele vrae vertoon word.';
$string['decimalpoints'] = 'Desimale plekke';
$string['default'] = 'Verstek';
$string['defaultgrade'] = 'Verstek vraagpunte';
$string['defaultinfo'] = 'Die standaardkategorie vir vrae.';
$string['delay1'] = 'Tydsvertraging tussen eerste en tweede poging';
$string['delay1st2nd'] = 'Gedwonge vertraging tussen 1ste en 2de pogings';
$string['delay1st2nd_help'] = 'Indien aktiveer, moet \'n student wag vir die gespesifiseerde tyd om verby te gaan voordat die vasvra vir \'n tweede keer gedoen kan word.';
$string['delay2'] = 'Tydsvertraging tussen verdere pogings.';
$string['delaylater'] = 'Gedwone vertraging tussen verdere pogings.';
$string['delaylater_help'] = 'Indien aktiveer, moet \'n student wag vir die gespesifiseerde tyd om verby te gaan voordat die vasvra vir \'n derde en verdere kere gedoen kan word.';
$string['deleteattemptcheck'] = 'Is jy heeltemal seker dat jy hierdie pogings wil verwyder?';
$string['deleteselected'] = 'Skrap geselekteerdes';
$string['deletingquestionattempts'] = 'Skrap vraag pogings';
$string['description'] = 'Beskrywing';
$string['disabled'] = 'Deaktiveer';
$string['displayoptions'] = 'Vertoonopsies';
$string['donotuseautosave'] = 'Moenie outostoor gebruik nie';
$string['download'] = 'Klik om die uitgevoerde kategorielêer af te laai';
$string['downloadextra'] = '(lêer word ook gestoor in die kursuslêers in die /backupdata/quiz folder)';
$string['dragtoafter'] = 'Na {$a}';
$string['dragtostart'] = 'Na die begin';
$string['duplicateresponse'] = 'Hierdie inhandiging is geïgnoreer omdat jy vroeër \'n ekwivalente antwoord gegee het.';
$string['eachattemptbuildsonthelast'] = 'Elke poging bou op die vorige voort';
$string['eachattemptbuildsonthelast_help'] = 'Indien verskeie pogings toegelaat word en hierdie instelling geaktiveer is, sal elke nuwe vasvra-poging die resultate van die vorige poging bevat. Dit laat toe \'n vasvra toe om oor verskeie pogings voltooi word.';
$string['editcategories'] = 'Redigeer kategorieë';
$string['editcategory'] = 'Redigeer kategorie';
$string['editcatquestions'] = 'Redigeer kategorievrae';
$string['editingquestion'] = 'Redigeer \'n vraag';
$string['editingquiz'] = 'Redigeer vasvra';
$string['editingquiz_help'] = 'Wanneer \'n vasvra geskep word, is die hoofkonsepte:
* Die vasvra, wat vrae oor een of meer bladsye bevat
* Die vraagbank, wat afskrifte van alle vrae in kategorieë organiseer en bewaar
* Willekeurige vrae - \'n Student kry verskillende vrae elke keer as hulle die toets doen en verskillende studente kan verskillende vrae kry';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Redigeer vraag: {$a}';
$string['editmaxmark'] = 'Redigeer maksimumpunt';
$string['editoverride'] = 'Redigeer oorskryding';
$string['editqcats'] = 'Redigeer vraag kategorieë';
$string['editquestion'] = 'Redigeer vraag';
$string['editquestions'] = 'Redigeer vrae';
$string['editquiz'] = 'Redigeer vasvra';
$string['editquizquestions'] = 'Redigeer vasvravrae';
$string['emailconfirmbody'] = 'Haai {$a->username},

Dankie dat jy jou antwoorde ingedien het vir \'{$a->quizname}\' in kursus \'{$a->coursename}\' teen {$a->submissiontime}.

Hierdie boodskap bevestig dat jou antwoorde gestoor is.

Jy kan toegang tot hierdie vasvra kry by {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Dankie dat jy jou antwoorde ingedien het vir \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bevestiging van inhandiging: {$a->quizname}';
$string['emailnotifybody'] = 'Haai {$a->username},

{$a->studentname} het \'{$a->quizname}\' voltooi ({$a->quizurl}) in kursus \'{$a->coursename}\'.

Jy kan die poging hersien by {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} het {$a->quizname} voltooi. Sien {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} het {$a->quizname} voltooi';
$string['emailoverduebody'] = 'Haai {$a->studentname},

Jy het \'n vasvrapoging by \'{$a->quizname}\' in kursus \'{$a->coursename}\' begin, maar jy het dit nooit ingedien nie. Dit moes ingedien gewees het teen {$a->attemptduedate}.

Indien jy hierdie poging wil indien, gaan asb. na {$a->attemptsummaryurl} en klik die handig in knoppie. Jy moet dit doen voor {$a->attemptgraceend} andersins sal jou poging nie in aanmerking geneem word nie.';
$string['emailoverduesmall'] = 'Jy het nie jou vasvrapoging {$a->quizname} ingedien nie . Gaan asb. na {$a->attemptsummaryurl} voor {$a->attemptgraceend} indien jy steeds jou poging wil indien.';
$string['emailoverduesubject'] = 'Poging nou agterstallig: {$a->quizname}';
$string['empty'] = 'Leeg';
$string['enabled'] = 'Aktiveer';
$string['endtest'] = 'Voltooi poging...';
$string['erroraccessingreport'] = 'Jy kan nie toegang tot hierdie verslag verkry nie';
$string['errorinquestion'] = 'Fout in vraag';
$string['errormissingquestion'] = 'Fout: Die sisteem vermis die vraag met id {$a}';
$string['errornotnumbers'] = 'Fout - antwoord moet numeries wees';
$string['errorunexpectedevent'] = 'Onverwagde gebeurekode {$a->event} gevind vir vraag {$a->questionid} in poging {$a->attemptid}.';
$string['essay'] = 'Opstel';
$string['essayquestions'] = 'Vrae';
$string['eventattemptdeleted'] = 'Vasvrapoging uitgevee';
$string['eventattemptpreviewstarted'] = 'Vasvrapoging voorskou begin';
$string['eventattemptreviewed'] = 'Vasvrapoging hersien';
$string['eventattemptsummaryviewed'] = 'Vasvrapoging opsomming beskou';
$string['eventattemptviewed'] = 'Vasvrapoging beskou';
$string['eventeditpageviewed'] = 'Vasvra-redigeer bladsy beskou';
$string['eventoverridecreated'] = 'Vasvra-oorskryding geskep';
$string['eventoverridedeleted'] = 'Vasvra-oorskryding verwyder';
$string['eventoverrideupdated'] = 'Vasvra-oorskryding opdateer';
$string['eventquestionmanuallygraded'] = 'Vrae handmatig bepunt';
$string['eventquizattemptabandoned'] = 'Vasvra-poging laat vaar';
$string['eventquizattemptregraded'] = 'Vasvrapoging hermerk';
$string['eventquizattemptstarted'] = 'Vasvrapoging begin';
$string['eventquizattemptsubmitted'] = 'Vasvrapoging ingedien';
$string['eventquizattempttimelimitexceeded'] = 'Tydperk vir vasvrapoging oorskry';
$string['eventreportviewed'] = 'Vasvrarapport beskou';
$string['everynquestions'] = 'Elke {$a} vrae';
$string['everyquestion'] = 'Elke vraag';
$string['everythingon'] = 'Alles aan';
$string['existingcategory'] = 'Bestaande kategorie';
$string['exportcategory'] = 'Voer kategorie uit';
$string['exporterror'] = '\'n Fout het plaasgevind tydens prosessering';
$string['exportingquestions'] = 'Vrae word uitevoer na \'n lêer';
$string['exportname'] = 'Lêernaam';
$string['exportquestions'] = 'Voer vrae na lêer uit';
$string['extraattemptrestrictions'] = 'Ekstra beperkings op pogings';
$string['false'] = 'Vals';
$string['feedback'] = 'Terugvoer';
$string['feedbackerrorboundaryformat'] = 'Terugvoer puntgrense moet of \'n persentasie of \'n getal wees. Die waarde wat jy in puntgrens {$a} ingelees het, word nie herken nie.';
$string['feedbackerrorboundaryoutofrange'] = 'Terugvoer puntgrense moet tussen 0% en 100% wees. Die waarde wat jy in puntgrens {$a} ingelees het is buite die raamwerk.';
$string['feedbackerrorjunkinboundary'] = 'Jy moet die terugvoer puntgrensbokse invul sonder om enige gapings te los.';
$string['feedbackerrorjunkinfeedback'] = 'Jy moet die terugveorbokse invul sonder om enige gapings te laat.';
$string['feedbackerrororder'] = 'Terugvoer puntgrense moet in orde wees, hoogste eerste. Die waarde wat jy in puntgrens {$a} ingevul het, voldoen nie hieraan nie.';
$string['file'] = 'Lêer';
$string['fileformat'] = 'Lêer formaat';
$string['fillcorrect'] = 'Vul met regte';
$string['filloutnumericalanswer'] = 'Jy gee ten minste een moontlike antwoord en toleransie. Die eerste antwoord sal gebruik word om die punt en terugvoer te bepaal. As jy aan die einde \'n antwoord gee, sal dit aan studente gewys word wie se antwoorde nie met enige van die ander antwoorde ooreenstem nie.';
$string['filloutoneanswer'] = 'Jy moet ten minste een moontlike antwoord verskaf. Antwoorde wat leeg gelaat word, sal nie gebruik word nie. \'*\' kan gebruik word as \'n wisselkarakter om by enige karakters te pas. Die eerste antwoord sal gebruik word om die punt en terugvoer te bepaal.';
$string['filloutthreequestions'] = 'Jy moet ten minste drie vrae verskaf wat ooreenstem met die antwoorde. Jy kan ekstra verkeerde antwoorde verskaf deur \'n leë antwoord te gee. Inskrywings waar beide die vraag en die antwoord leeg is, sal geïgnoreer word.';
$string['fillouttwochoices'] = 'Jy moet ten minste twee keuses invul. Keuses wat leeg gelaat word sal nie gebruik word nie.';
$string['finishattemptdots'] = 'Voltooi poging...';
$string['finishreview'] = 'Voltooi hersiening';
$string['forceregeneration'] = 'forseer hergenerasie';
$string['formatnotfound'] = 'Invoer/uitvoerformaat {$a} nie gevind nie';
$string['formulaerror'] = 'Formulefoute!';
$string['fractionsaddwrong'] = 'Die positiewe punte wat jy het tel nie op tot 100%<br /> nie. In plaas daarvan, tel hul op tot {$a}%<br />Wil jy teruggaan en hierdie vrae regmaak?';
$string['fractionsnomax'] = 'Een van die antwoorde moet 100% wees, sodat dit moontlik is <br />om volpunte vir hierdie vraag te kry.<br />Wil jy teruggaan en hierdie vraag regmaak?';
$string['fromfile'] = 'vanaf lêer:';
$string['functiondisabledbysecuremode'] = 'Die funksie is tans gedeaktiveer';
$string['generalfeedback'] = 'Algemene terugvoer';
$string['generalfeedback_help'] = 'Algemene terugvoer is teks wat getoon word nadat \'n vraag probeer is. Anders as terugvoering vir \'n spesifieke vraag wat afhang van die antwoord, word dieselfde algemene terugvoer altyd getoon.';
$string['graceperiod'] = 'Inhandigings grasietydperk';
$string['graceperiod_desc'] = 'Indien wat om te doen wanneer die tyd verstryk, ingestel is op \'Daar is \'n grasietydperk ...\', dan is dit die standaard ekstra tyd wat toegelaat word.';
$string['graceperiod_help'] = 'Indien wat om te doen wanneer die tyd verstryk, ingestel is op \'Daar is \'n grasietydperk ...\', dan is dit die standaard ekstra tyd wat toegelaat word.';
$string['graceperiodmin'] = 'Laaste inhandiging grasietydperk';
$string['graceperiodmin_desc'] = 'Aan die einde van die vasvra is daar \'n moontlike probleem. Enersyds wil ons studente tot die laaste sekonde laat aanhou werk - met behulp van die stophorlosie wat die vasvra outomaties indien wanneer die tyd min is. Aan die ander kant kan die bediener dan oorlaai word, en dit sal dit \'n tydjie neem om die antwoorde te verwerk. Daarom sal ons antwoorde tot hiertoe aanvaar na verloop van tyd, sodat dit nie gepenaliseer word nie omdat die bediener stadig is. Die student kon egter kul en soveel sekondes kry om die vasvra te beantwoord. Jy moet \'n besluit maak op grond van hoeveel jy die prestasie van jou bediener tydens vasvrae vertrou.';
$string['graceperiodtoosmall'] = 'Die grasietydperk moet meer wees as {$a}.';
$string['grade'] = 'Punte';
$string['gradeall'] = 'Merk alles';
$string['gradeaverage'] = 'Gemiddelde punt';
$string['gradeboundary'] = 'Puntgrens';
$string['gradeessays'] = 'Merk opstelle';
$string['gradehighest'] = 'Hoogste punt';
$string['grademethod'] = 'Nasienmetode';
$string['grademethod_help'] = 'Wanneer veelvuldige pogings toegelaat word, is die volgende metodes beskikbaar vir die berekening van die finale vasvra-punt:

* Hoogste punt van alle pogings
* Gemiddelde (gemiddelde) punt van alle pogings
* Eerste poging (alle ander pogings word geïgnoreer)
* Laaste poging (alle ander pogings word geïgnoreer)';
$string['gradesdeleted'] = 'Vasvrapunte uitgevee';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Punt om te slaag kan nie nul wees nie, aangesien hierdie voltooiingsmetode ingestel is om \'n slaagpunt te vereis. Stel \'n waarde in wat nie gelyk aan nul is nie.';
$string['gradetopassnotset'] = 'Hierdie vasvra het nog nie \'n slaagpunt ingestel nie. Dit kan verstel word in die Nasien afdeling van die vasvrainstellings.';
$string['gradetopassoutof'] = 'Punt om te slaag: {$a->grade} uit {$a->maxgrade}';
$string['gradingdetails'] = 'Punte vir hierdie inhandiging: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Met vorige strafpunte gee dit <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Hierdie inhandiging het \'n strafpunt van {$a}.';
$string['gradingdetailszeropenalty'] = 'Jy was nie vir hierdie inhandiging gepenaliseer nie.';
$string['gradingmethod'] = 'Nasienmetode: {$a}';
$string['groupoverrides'] = 'Groepoorskryding';
$string['groupoverridesdeleted'] = 'Groepoorskryding uitgevee';
$string['groupsnone'] = 'Geen groepe waartoe jy toegang het nie.';
$string['guestsno'] = 'Jammer, gaste kan nie vasvrae sien of probeer nie.';
$string['hidebreaks'] = 'Versteek bladsybreeke';
$string['hidereordertool'] = 'Versteek die herordeningsinstrument';
$string['history'] = 'Geskiedenis van reaksies:';
$string['howquestionsbehave_desc'] = 'Verstekinstellings van gedragsinstellings van vrae in \'n vasvra.';
$string['imagedisplay'] = 'Beeld om te vertoon';
$string['import_help'] = 'Met hierdie funksie kan jy vrae invoer van eksterne tekslêers.

As jy lêer nie ascii-karakters bevat nie, moet UTF-8-kodering gebruik word. Wees veral versigtig met lêers wat deur Microsoft Office-toepassings gegenereer word, aangesien dit gewoonlik spesiale kodering gebruik wat nie korrek hanteer sal word nie.

Invoer- en uitvoerformate is \'n inpropbare hulpbron. Ander opsionele formate is moontlik in die Modules and Inprop-databasis beskikbaar.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'invoer kategorie';
$string['importerror'] = '\'n Fout het voorgekom tydens invoerproses';
$string['importfilearea'] = 'Lêerinvoer reeds in kursuslêers...';
$string['importfileupload'] = 'Invoer van lêeroplaai...';
$string['importfromthisfile'] = 'Invoer van hierdie lêer';
$string['importingquestions'] = 'Voer {$a} vrae van lêer in';
$string['importmax10error'] = 'Daar is \'n fout in die vraag. Jy kan nie meer as tien antwoorde hê nie';
$string['importmaxerror'] = 'Daar is \'n fout in die vraag. Jy het teveel antwoorde.';
$string['importquestions'] = 'Voer vrae vanaf lêer in';
$string['inactiveoverridehelp'] = '* Hierdie oorskryding is onaktief omdat die gebruiker se toegang tot die aktiwiteit beperk is. Dit kan te wyte wees aan groep- of roltoewysings, ander toegangsbeperkings of die verborge aktiwiteit.';
$string['incorrect'] = 'Verkeerd';
$string['indicator:cognitivedepth'] = 'Vasvra kognitief';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanwyser is gebaseer op die kognitiewe diepte wat die student in \'n vasvraaktiwiteit bereik het.';
$string['indicator:cognitivedepthdef'] = 'Vasvra kognitief';
$string['indicator:cognitivedepthdef_help'] = 'Die deelnemer het hierdie persentasie bereik van die kognitiewe betrokkenheid wat deur die vasvra-aktiwiteite aangebied word gedurende hierdie ontledingsinterval (Vlakke = Geen aansig, Bekyk, Stuur, Bekyk terugvoer, Kommentaar op terugvoer, Dien weer in na terugvoer beskou is)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Vasvra sosiaal';
$string['indicator:socialbreadth_help'] = 'Hierdie aanwyser is gebaseer op die sosiale diepte wat die student in \'n vasvraaktiwiteit bereik het.';
$string['indicator:socialbreadthdef'] = 'Vasvra sosiaal';
$string['indicator:socialbreadthdef_help'] = 'Die deelnemer het hierdie persentasie bereik van die sosiale betrokkenheid wat deur die vasvra-aktiwiteite aangebied word gedurende hierdie ontledingsinterval (Vlakke = Geen deelname, Deelnemer alleen, Deelnemer saam met ander)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Individuele antwoorde op elke item';
$string['info'] = 'Informasie';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Aanvanklike getal van oorhoofse terugvoervelde';
$string['initialnumfeedbacks_desc'] = 'Indien jy \'n nuwe vasvra skep, moet jy hierdie hoeveelheid leë algehele terugvoerblokkies verskaf. Nadat die vasvra geskep is, wys die vorm die aantal velde wat benodig word vir die aantal terugvoerings in die vasvra. Die instelling moet ten minste 1 wees.';
$string['inprogress'] = 'Aan die gang';
$string['introduction'] = 'Beskrywing';
$string['invalidattemptid'] = 'Geen so tipe ID bestaan nie';
$string['invalidcategory'] = 'Kategorie ID is ongeldig';
$string['invalidoverrideid'] = 'Ongeldige oorskrydings ID';
$string['invalidquestionid'] = 'Ongeldige vraag ID';
$string['invalidquizid'] = 'Ongeldige vasvra ID';
$string['invalidrandomslot'] = 'Ongeldige willekeurige vraaggleuf id.';
$string['invalidsource'] = 'Die bron word nie as geldig aanvaar nie.';
$string['invalidsourcetype'] = 'Ongeldige brontipe.';
$string['invalidstateid'] = 'Ongeldige status id';
$string['lastanswer'] = 'Jou laaste antwoord was';
$string['layout'] = 'Uitleg';
$string['layoutasshown'] = 'Bladsyuitleg soos getoon.';
$string['layoutasshownwithpages'] = 'Bladsyuitleg soos gewys. <small>(Outomaties \'n nuwe bladsy elke {$a} vrae.)</small>';
$string['layoutshuffledandpaged'] = 'Vrae word willekeurig met {$a} vrae per bladsy geskommel.';
$string['layoutshuffledsinglepage'] = 'Vrae word willekeurig geskommel, almal op een bladsy.';
$string['legacyquizaccessrulescron'] = 'Nalatenskap cron vasvra toegangsreëls';
$string['legacyquizreportscron'] = 'Nalatenskap cron vasvra rapporte';
$string['link'] = 'Skakel';
$string['listitems'] = 'Lys van vasvraitems';
$string['literal'] = 'Letterlik';
$string['loadingquestionsfailed'] = 'Laai van vrae het misluk: {$a}';
$string['makecopy'] = 'Stoor as nuwe vraag';
$string['managetypes'] = 'Bestuur vraagtipe en bedieners';
$string['manualgradequestion'] = 'Handmatige merk van vraag {$a->question} in {$a->quiz} van {$a->user}';
$string['manualgrading'] = 'Nasien';
$string['mark'] = 'Indien';
$string['markall'] = 'Indien bladsy';
$string['marks'] = 'Punte';
$string['marks_help'] = 'Die syferpunte vir elke vraag en die algehele pogingtelling.';
$string['match'] = 'Passende';
$string['matchanswer'] = 'Passende antwoord';
$string['matchanswerno'] = 'Passende antwoord {$a}';
$string['max'] = 'Maks';
$string['maxmark'] = 'Maksimum punt';
$string['messageprovider:attempt_overdue'] = 'Waarskuwing wanneer jou vasvrapoging agterstallig raak';
$string['messageprovider:confirmation'] = 'Bevestiging van jou eie vasvra inhandigings';
$string['messageprovider:submission'] = 'Kennisgewing van vasvra inhandigings';
$string['min'] = 'Min';
$string['minutes'] = 'Minute';
$string['missingcorrectanswer'] = 'Korrekte antwoord moet gespesifiseer word';
$string['missingitemtypename'] = 'Naam ontbreek';
$string['missingquestion'] = 'Die vraag blyk nie meer te bestaan nie';
$string['modulename'] = 'Vasvra';
$string['modulename_help'] = 'Die vasvra-aktiwiteit stel \'n onderwyser in staat om vasvrae te skep met verskillende soorte vrae,  insluitend meerkeuse, pasvrae, kort antwoord en numeries.

Die onderwyser kan toelaat dat die vasvra verskeie kere gedoen word, met die vrae geskommel of willekeurig uit die vraagbank gekies. \'n Tydsbeperking kan ook bepaal word.

Elke poging word outomaties nagesien, met die uitsondering van opstelvrae. Punte word in die punteboek aangeteken.

Die onderwyser kan kies wanneer en of wenke, terugvoer en regte antwoorde aan studente gewys word.

Vasvrae kan gebruik word

* As kursuseksamens
* As mini-toetse vir leesopdragte of aan die einde van \'n onderwerp
* As eksamenoefening deur vrae uit vorige eksamens te gebruik
* Om onmiddellike terugvoer oor prestasie te lewer
* Vir selfassessering';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Vasvrae';
$string['moveselectedonpage'] = 'Beweeg spesifieke vrae na bladsy: {$a}';
$string['multichoice'] = 'Meervoudige keuse';
$string['multipleanswers'] = 'Kies ten minste een antwoord.';
$string['mustbesubmittedby'] = 'Hierdie poging moet ingedien word teen {$a}.';
$string['name'] = 'Naam';
$string['navigatenext'] = 'Volgende bladsy';
$string['navigateprevious'] = 'Vorige bladsy';
$string['navmethod'] = 'Navigasie metode';
$string['navmethod_free'] = 'Vry';
$string['navmethod_help'] = 'Wanneer opeenvolgende navigasie geaktiveer is, moet \'n student in volgorde deur die vasvra vorder en mag hy nie na vorige bladsye terugkeer nie en ook nie voortgaan nie.';
$string['navmethod_seq'] = 'Opeenvolgend';
$string['navnojswarning'] = 'Waarskuwing: hierdie skakels sal nie jou antwoorde stoor nie. Gebruik die volgende knoppie onder op die bladsy.';
$string['neverallononepage'] = 'Nooit, alle vrae op een bladsy.';
$string['newattemptfail'] = 'Fout: Kon nie \'n nuwe vasvrapoging begin nie';
$string['newcategory'] = 'Nuwe kategorie';
$string['newpage'] = 'Nuwe bladsy';
$string['newpage_help'] = 'Vir langer vasvrae is dit sinvol om die vasvra oor verskeie bladsye te strek deur die aantal vrae per bladsy te beperk. As jy vrae by die vasvra voeg, sal bladsybrekings outomaties volgens hierdie instelling ingevoeg word. Bladsybreke kan egter later handmatig op die redigeringsbladsy geskuif word.';
$string['newpageevery'] = 'Begin \'n nuwe bladsy outomaties';
$string['newsectionheading'] = 'Nuwe opskrif';
$string['noanswers'] = 'Geen antwoorde is verkies nie!';
$string['noattempts'] = 'Geen pogings is op hierdie vasvra aangewend nie';
$string['noattemptsfound'] = 'Geen pogings gevind nie.';
$string['noattemptstoshow'] = 'Daar is geen pogings om te wys nie';
$string['nocategory'] = 'Verkeerde of geen kategorie gespesifiseer nie';
$string['noclose'] = 'Geen sluitingsdatum';
$string['nocommentsyet'] = 'Nog geen kommentaar nie.';
$string['noconnection'] = 'Daar is tans geen verbinding met \'n webdiens wat hierdie vraag kan verwerk nie. Kontak jou administrateur asb.';
$string['nodataset'] = 'niks - dit is nie \'n wisselkaart nie';
$string['nodatasubmitted'] = 'Geen data was ingedien nie';
$string['noessayquestionsfound'] = 'Geen handmatige gemerkte vrae gevind nie';
$string['nogradewarning'] = 'Hierdie vasvra is nie nagesien nie, dus kan jy nie algehele terugvoer opstel wat volgens punte verskil nie.';
$string['nomoreattempts'] = 'Geen verdere pogings word toegelaat nie';
$string['none'] = 'Niks';
$string['noopen'] = 'Geen oop datum';
$string['nooverridedata'] = 'Jy moet ten minste een van die vasvrainstelling ignoreer.';
$string['nopossibledatasets'] = 'Geen moontlike datastelle nie';
$string['noquestionintext'] = 'Die vraagteks bevat geen ingebedde vrae nie';
$string['noquestions'] = 'Geen vrae is tot op hede bygevoeg nie';
$string['noquestionsfound'] = 'Gee vrae is gevind nie';
$string['noquestionsinquiz'] = 'Daar is geen vrae in hierdie vasvra nie.';
$string['noquestionsnotinuse'] = 'Hierdie ewekansige vraag word nie gebruik nie, aangesien die kategorie leeg is.';
$string['noquestionsonpage'] = 'Leë bladsy';
$string['noresponse'] = 'Geen antwoord';
$string['noreview'] = 'Jy word nie toegelaat om hierdie vasvra te hersien nie';
$string['noreviewattempt'] = 'Jy word nie toegelaat om hierdie poging te hersien nie.';
$string['noreviewshort'] = 'Nie toegelaat nie';
$string['noreviewuntil'] = 'Jy mag nie hierdie vasvra hiersien tot {$a}';
$string['noreviewuntilshort'] = 'Beskikbaar {$a}';
$string['noscript'] = 'JavaScript moet aktiveer word om voort te gaan.';
$string['notavailabletostudents'] = 'Nota: Hierdie vasvra is nie tans beskikbaar vir jou studente nie';
$string['notenoughrandomquestions'] = 'Daar is nie genoeg vrae in kategorie {$a->category} om hierdie vraag {$a->name} ({$a->id}) te skep nie.';
$string['notenoughsubquestions'] = 'Onvoldoende subvrae is gedefinieer!<br />Wil jy teruggaan en hierdie fout regmaak?';
$string['notimedependentitems'] = 'Tydafhanklike items word nie tans deur die vasvra-module ondersteun nie. Stel \'n tydsbeperking vir die hele vasvra as \'n oplossing. Wil jy \'n ander item kies (of ongeag die huidige item)?';
$string['notyetgraded'] = 'Nog nie nagesien nie';
$string['notyetviewed'] = 'Nog nie gesien nie';
$string['notyourattempt'] = 'Hierdie is nie jou poging nie!';
$string['noview'] = 'Ingetekende gebruiker word nie toegelaat om hierdie vasvra te sien nie';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} het {$a->attemptnum} pogings gemaak';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeries';
$string['numquestionsx'] = 'Vrae: {$a}';
$string['oneminute'] = '1 minuut';
$string['onlyteachersexport'] = 'Slegs onderwysers kan vrae uitvoer';
$string['onlyteachersimport'] = 'Slegs onderwysers met redigeringsregte kan vrae invoer';
$string['onthispage'] = 'Hierdie bladsy';
$string['open'] = 'Onbeantwoord';
$string['openafterclose'] = 'Kon nie vasvra voltooi nie. Jy het \'n begindatum voor die sluitingsdatum gekies.';
$string['openclosedatesupdated'] = 'Vasvra oopmaak en sluitingsdatums opdateer';
$string['optional'] = 'optioneel';
$string['orderandpaging'] = 'Orde en bladsyuitleg';
$string['orderandpaging_help'] = 'Die getalle 10, 20, 30, ... teenoor elke vraag dui die volgorde van die vrae aan. Die getalle neem toe in stappe van 10 om ruimte te laat vir ektra vrae. Om die vrae te herrangskik, verander die getalle en klik dan op die knoppie "Vrae herrangskik".

Om bladsye na spesifieke vrae by te voeg, merk die kiesboksies langs die vrae en klik dan op die knoppie "Voeg nuwe bladsye na geselekteerde vrae by".

Om die vrae oor \'n aantal bladsye te rangskik, klik op die Herrangskik-knoppie en kies die gewenste aantal vrae per bladsy.';
$string['orderingquiz'] = 'Orde en bladsye';
$string['orderingquizx'] = 'Orde en bladsye: {$a}';
$string['outcomesadvanced'] = 'Uitkomstes is gevorderde instellings';
$string['outof'] = '{$a->grade} uit {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} uit {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Algehele terugvoer';
$string['overallfeedback_help'] = 'Algehele terugvoer is teks wat vertoon word nadat \'n vasvra aangepak is. Deur addisionele puntgrense (as persentasie of as getal) te spesifiseer, kan die getoonde teks afhang van die punt wat behaal is.';
$string['overdue'] = 'Agtestallig';
$string['overduehandling'] = 'Wanneer die tyd vertreke is';
$string['overduehandling_desc'] = 'Verstekhandeling indien \'n student nie die vasvra indien voor die tyd verstreke is nie.';
$string['overduehandling_help'] = 'Hierdie instelling bepaal wat gebeur as \'n student nie sy vasvrapoging indien voordat die tyd verstreke is nie. Indien die student tans aktief aan die vasvra werk, sal die afteller altyd die poging vir hulle indien, maar as hulle afgemeld het, dan bepaal hierdie instelling wat gebeur.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Pogings moet ingedien word voordat tyd verstryk, of hul word nie getel nie.';
$string['overduehandlingautosubmit'] = 'Oop pogings word outomaties ingedien';
$string['overduehandlinggraceperiod'] = 'Daar is \'n grasietydperk vir oop pogings om ingedien te word, maar verdere vrae kan nie beantwoord word nie.';
$string['overduemustbesubmittedby'] = 'Hierdie poging is nou agterstallig. Dit moes reeds ingedien gewees het. As jy wil hê dat hierdie vasvra gemerk moet word, moet jy dit teen {$a} indien. Indien jy dit nog nie ingedien het nie, sal geen punte van hierdie poging tel nie.';
$string['override'] = 'Oorskryding';
$string['overridedeletegroupsure'] = 'Is jy seker jy wil die oorskryding vir groep {$a} uitvee?';
$string['overridedeleteusersure'] = 'Is jy seker jy wil die oorskryding vir gebruiker {$a} uitvee?';
$string['overridegroup'] = 'Groepoorskryding';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Oorskryding';
$string['overridesforquiz'] = 'Oorskryding instellings: {$a}';
$string['overridesnoneforgroups'] = 'Geen groepinstellings oorskrydings is vir hierdie vasvra geskep nie.';
$string['overridesnoneforusers'] = 'Geen gebruikerinstellings oorskrydings is vir hierdie vasvra geskep nie.';
$string['overridessummary'] = 'Instellings oorskrydings bestaan ({$a})';
$string['overridessummarygroup'] = 'Groepe: {$a}';
$string['overridessummarythisgroup'] = 'Groepoorskryding instellings bestaan ({$a}) vir hierdie groep';
$string['overridessummaryuser'] = 'Gebruikers: {$a}';
$string['overridessummaryyourgroups'] = 'Groepoorskryding instellings bestaan ({$a}) vir hierdie groep';
$string['overrideuser'] = 'Gebruikeroorskryding';
$string['overrideusereventname'] = '{$a->quiz} - Override';
$string['page-mod-quiz-attempt'] = 'Vasvrapoging bladsy';
$string['page-mod-quiz-edit'] = 'Redigeer vasvra bladsy';
$string['page-mod-quiz-report'] = 'Enige vasvra rapport bladsy';
$string['page-mod-quiz-review'] = 'Hersien vasvrapoging bladsy';
$string['page-mod-quiz-summary'] = 'Vasvrapoging opsomming bladsy';
$string['page-mod-quiz-view'] = 'Vasvra informasie bladsy';
$string['page-mod-quiz-x'] = 'Enige vasvra module bladsy';
$string['pageshort'] = 'Bl.';
$string['pagesize'] = 'Bladsy grote';
$string['parent'] = 'Ouer';
$string['parentcategory'] = 'Ouer kategorie';
$string['parsingquestions'] = 'Ontleed vrae uit invoerlêer.';
$string['partiallycorrect'] = 'Gedeeltelik reg';
$string['penalty'] = 'Strafpunt';
$string['penaltyscheme'] = 'Pas strafmaatreëls toe';
$string['penaltyscheme_help'] = 'Indien geaktiveer, word \'n strafpunt van die finale punt afgetrek vir verkeerde antwoorde. Die grote van die strafpunt word in die vraaginstellings gespesifiseer. Hierdie instelling is slegs van toepassing as die aanpasbare modus geaktiveer is.';
$string['percentcorrect'] = 'Persentasie reg';
$string['pleaseclose'] = 'Jou versoek is verwerk. Jy kan nou die venster toemaak.';
$string['pluginadministration'] = 'Vasvra administrasie';
$string['pluginname'] = 'Vasvra';
$string['popup'] = 'Vertoon vasvra in \'n \'veilige\' venster';
$string['popupblockerwarning'] = 'Hierdie afdeling van die toets is in veilige modus, dit beteken dat jy nodig het om die toets te neem in \'n veilige venster. Skakel jou oppop blokkeerder af. Baie Dankie.';
$string['popupnotice'] = 'Studente sal hierdie vasvra in \'n veilige venster sien';
$string['preprocesserror'] = 'Fout het voorgekom tydens vooraf-verwerking!';
$string['preview'] = 'Voorskou';
$string['previewquestion'] = 'Voorskou vraag';
$string['previewquiz'] = 'Voorskou {$a}';
$string['previewquiznow'] = 'Vasvra voorskou nou';
$string['previewquizstart'] = 'Voorskou van vasvrae';
$string['previous'] = 'Vorige status';
$string['privacy:metadata:core_question'] = 'Die vasvraaktiwiteit stoor inligting oor die gebruik van vrae in die kernvraag substelsel.';
$string['privacy:metadata:quiz'] = 'Die vasvraaktiwiteit maak gebruik van vasvraverslae.';
$string['privacy:metadata:quiz_attempts'] = 'Besonderhede van elke vasvrapoging.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Poging nommer.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Die huidige bladsy waarop die gebruiker is.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Of hierdie \'n voorskou van die vasvra is.';
$string['privacy:metadata:quiz_attempts:state'] = 'Huidige status van die poging.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Die somtotaal van punte van die poging.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Wanneer die status bekyk was.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Wanneer die poging voltooi was.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Wanneer die poging opdateer was.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Wanneer die poging opdateer was deur middel van \'n vanlyn opdatering.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Wanneer die poging begin is.';
$string['privacy:metadata:quiz_grades'] = 'Besonderhede van die algehele punt vir hierdie vasvra.';
$string['privacy:metadata:quiz_grades:grade'] = 'Die algehele punt vir hierdie vasvra.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Die vasvra was gemerk.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Wanneer die punt verander was.';
$string['privacy:metadata:quiz_grades:userid'] = 'Die gebruiker wie nagesien was.';
$string['privacy:metadata:quiz_overrides'] = 'Besonderhede van oorskrydings van hierdie vasvra';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Die vasvra met oorskrydingsinformasie';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Die nuwe sluitingsdatum vir vasvra';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Die nuwe tydsbeperking vir vasvra.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Die nuwe begintyd van die vasvra.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Die gebruiker wie oorskry word';
$string['privacy:metadata:quizaccess'] = 'Die vasvraaktiwiteit maak gebruik van vasvratoegangreëls.';
$string['publish'] = 'Publiseer';
$string['publishedit'] = 'Jy moet toestemming hê vir die publikasiekursus om vrae in hierdie kategorie by te voeg of te wysig';
$string['qbrief'] = 'V. {$a}';
$string['qname'] = 'naam';
$string['qti'] = 'IMS QTI formaat';
$string['qtypename'] = 'tipe, naam';
$string['question'] = 'Vraag';
$string['questionbank'] = 'vanaf vraagbank';
$string['questionbankmanagement'] = 'Vraagbank bestuur';
$string['questionbehaviour'] = 'Vraaggedrag';
$string['questioncats'] = 'Vraagkategorieë';
$string['questiondeleted'] = 'Die vraag is uitgevee. Kontak asb. jou onderwyser.';
$string['questiondependencyadd'] = 'Geen beperkings op wanneer vraag {$a->thisq} aangepak kan word nie. • Klik om te verander';
$string['questiondependencyfree'] = 'Geen beperkings op hierdie vraag';
$string['questiondependencyremove'] = 'Vrae {$a->thisq} kan nie aangepak word totdat die vorige vraag {$a->previousq} voltooi is nie • Klik om te verander';
$string['questiondependsonprevious'] = 'Hierdie vraag kan nie begin word totdat die vorige vraag voltooi is nie.';
$string['questioninuse'] = 'Die vraag \'{$a->questionname}\' word tans gebruik in: <br />{$a->quiznames}<br />Die vraag sal nie uitgevee word van hierdie vasvrae nie, maar wel van die kategorielys.';
$string['questionmissing'] = 'Vraag vir hierdie sessie ontbreek';
$string['questionname'] = 'Vraagnaam';
$string['questionnonav'] = '<span class="accesshide">Question </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Vraag {$a} is nie gelaai van die databasis nie';
$string['questionorder'] = 'Vraagorde';
$string['questionposition'] = 'Nuwe volgorde vir vrae {$a}';
$string['questions'] = 'Vrae';
$string['questionsetpreview'] = 'Vraagstel voorskou';
$string['questionsinclhidden'] = 'Vrae (insluitend versteekte)';
$string['questionsinthisquiz'] = 'Vrae in hierdie vasvra';
$string['questionsmatchingfilter'] = 'Vrae wat by hierdie filter pas: {$a}';
$string['questionsperpage'] = 'Vrae per bladsy';
$string['questionsperpageselected'] = 'Vrae per bladsy is gestel sodat die bladsyuitleg tans vas is. Op grond hiervan is die bladsykontroles uitgeskakel. Jy kan dit in {$a} verander.';
$string['questionsperpagex'] = 'Vrae per bladsy: {$a}';
$string['questiontext'] = 'Vraagteks';
$string['questiontextisempty'] = '[Leë vraagteks]';
$string['questiontype'] = 'Vraagtipe {$a}';
$string['questiontypesetupoptions'] = 'Instelling opsies vir vraagtipes:';
$string['quiz:addinstance'] = 'Voeg \'n nuwe vasvra by';
$string['quiz:attempt'] = 'Poog vasvrae';
$string['quiz:deleteattempts'] = 'Vee vasvrapogings uit';
$string['quiz:emailconfirmsubmission'] = 'Kry \'n bevestigingsboodskap met indiening';
$string['quiz:emailnotifysubmission'] = 'Kry \'n kennisgewingboodskap wanneer \'n poging ingedien is';
$string['quiz:emailwarnoverdue'] = 'Kry \'n kennisgewingboodskap wanneer \'n poging agterstallig raak en ingehandig moet word.';
$string['quiz:grade'] = 'Merk vasvrae handmatig';
$string['quiz:ignoretimelimits'] = 'Ignoreer vasvra tydbeperking';
$string['quiz:manage'] = 'Bestuur vasvrae';
$string['quiz:manageoverrides'] = 'Bestuur vasvrainstelling oorskrydings';
$string['quiz:preview'] = 'Voorskou vasvrae';
$string['quiz:regrade'] = 'Hermerk vasvrapogings';
$string['quiz:reviewmyattempts'] = 'Hersien jou eie pogings';
$string['quiz:view'] = 'Beskou vasvra informasie';
$string['quiz:viewoverrides'] = 'Beskou vasvra instellingoorskrydings';
$string['quiz:viewreports'] = 'Beskou vasvraverslae';
$string['quizavailable'] = 'Die vasvra is beskikbaar tot: {$a}';
$string['quizclose'] = 'Sluit die vasvra';
$string['quizclosed'] = 'Die vasvra het gesluit op {$a}';
$string['quizcloses'] = 'Vasvra sluit';
$string['quizcloseson'] = 'Hierdie vasvra sal sluit op {$a}.';
$string['quizeventcloses'] = '{$a} sluit';
$string['quizeventopens'] = '{$a} maak oop';
$string['quizisclosed'] = 'Die vasvra is gesluit';
$string['quizisclosedwillopen'] = 'Vasvra gesluit (maak oop {$a})';
$string['quizisopen'] = 'Die vasvra is oop';
$string['quizisopenwillclose'] = 'Vasvrae maak oop (sluit {$a})';
$string['quiznavigation'] = 'Vasvra navigasie';
$string['quizopen'] = 'Maak vasvra oop';
$string['quizopenclose'] = 'Oopmaak- en sluitingsdatum';
$string['quizopenclose_help'] = 'Studente kan eers met die poging(s) na die oopmaak tyd begin en hulle moet hul pogings voor die sluitingstyd voltooi.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Die vasvra is oop.';
$string['quizopenedon'] = 'Die vasvra het oopgemaak op {$a}';
$string['quizopens'] = 'Vasvra oomaaktyd';
$string['quizopenwillclose'] = 'Die vasvra is oop, en sal sluit op {$a} teen';
$string['quizordernotrandom'] = 'Orde van vasvra ongeskommel';
$string['quizorderrandom'] = '* Orde van vasvra geskommel';
$string['quizreport'] = 'Vasvraverslag';
$string['quizsettings'] = 'Vasvra instellings';
$string['quiztimer'] = 'Vasvra afteller';
$string['quizwillopen'] = 'Die vasvra sal oopmaak teen {$a}';
$string['random'] = 'Ewekansige vraag';
$string['randomcreate'] = 'Skep ewekansige vraag';
$string['randomediting'] = 'Redigeer \'n ewekansige vraag';
$string['randomfromcategory'] = 'Ewekansige vraag vanaf kategorie:';
$string['randomfromexistingcategory'] = 'Ewekansige vraag vanaf \'n bestaande kategorie';
$string['randomfromunavailabletag'] = '{$a} (onbeskikbaar)';
$string['randomnosubcat'] = 'Slegs vrae van hierdie kategorie, nie eers van die subkategorieë nie.';
$string['randomnumber'] = 'Aantal ewekansige vrae';
$string['randomquestion'] = 'Ewekansige vraag';
$string['randomquestion_help'] = '\'n Ewekansige vraag is \'n metode om \'n lukraak gekose vraag vanuit \'n bepaalde kategorie of met \'n spesifieke merker by \'n aktiwiteit te voeg.';
$string['randomquestiontags'] = 'Merkerks';
$string['randomquestiontags_help'] = 'Jy kan die seleksiekriteria verder beperk deur \'n paar vraagmerkers hier te gee. Die "ewekansige" vrae sal gekies word uit die vrae met al hierdie etikette.';
$string['randomquestionusinganewcategory'] = 'Ewekansige vrae wat \'n nuwe kategorie gebruik';
$string['randomwithsubcat'] = 'Vrae van hierdie kategorie en subkategorieë';
$string['readytosend'] = 'Jy is tans besig om jou hele vasvra te stuur om gemerk te word. Is jy seker jy wil hiermee voortgaan?';
$string['reattemptquiz'] = 'Probeer vasvra weer';
$string['recentlyaddedquestion'] = 'Onlangs bygevoegde vraag!';
$string['recurse'] = 'Sluit vrae vanuit subkategorieë ook in';
$string['redoesofthisquestion'] = 'Ander vrae word hier aangepak: {$a}';
$string['redoquestion'] = 'Probeer ander vrae soos hierdie een';
$string['regrade'] = 'Hermerk alle pogings';
$string['regradecomplete'] = 'Alle pogings is hermerk';
$string['regradecount'] = '{$a->changed} van {$a->attempt} punte was verander';
$string['regradedisplayexplanation'] = 'Pogings wat verander tydens hermerk word as hiperskakels by hersieningsvenster vertoon.';
$string['regradenotallowed'] = 'Jy het nie toestemming om hierdie vasvra te hermerk nie';
$string['regradingquestion'] = 'Hermerk "{$a}".';
$string['regradingquiz'] = 'Hermerk vasvra "{$a}"';
$string['remove'] = 'Verwyder';
$string['removeallgroupoverrides'] = 'Vee alle groepoorskrydings uit';
$string['removeallquizattempts'] = 'Vee alle vasvrapogings uit';
$string['removealluseroverrides'] = 'Vee alle gebruikersoorskrydings uit';
$string['removeemptypage'] = 'Vee leë bladsy uit';
$string['removepagebreak'] = 'Vee bladsybreek uit';
$string['removeselected'] = 'Verwyder verkose';
$string['rename'] = 'Herbenoem';
$string['renderingserverconnectfailed'] = 'Die bediener {$a} het misluk om \'n RQP request te verwerk. Maak seker dat die URL reg is.';
$string['reorderquestions'] = 'Herorden vrae';
$string['reordertool'] = 'Wys die herorden instrument';
$string['repaginate'] = 'Herorden bladsye met {$a} vrae per bladsy';
$string['repaginatecommand'] = 'Herorden bladsye';
$string['repaginatenow'] = 'Herorden nou';
$string['replace'] = 'Vervang';
$string['replacementoptions'] = 'Vervangingsopsies';
$string['report'] = 'Verslae';
$string['reportanalysis'] = 'Item analise';
$string['reportattemptsfrom'] = 'Pogings vanaf';
$string['reportattemptsthatare'] = 'Pogings wat';
$string['reportdisplayoptions'] = 'Vertoonopsies';
$string['reportfullstat'] = 'Gedetaileerde statistieke';
$string['reportmulti_percent'] = 'Veelvoudige persentasies';
$string['reportmulti_q_x_student'] = 'Veelvoudige studentekeuses';
$string['reportmulti_resp'] = 'Individuele antwoorde';
$string['reportmustselectstate'] = 'Jy moet ten minste een status kies';
$string['reportnotfound'] = 'Verslag onbekend ({$a})';
$string['reportoverview'] = 'Oorsig';
$string['reportregrade'] = 'Hermerk pogings';
$string['reportresponses'] = 'Gedetaileerde antwoord';
$string['reports'] = 'Verslae';
$string['reportshowonly'] = 'Wys slegs pogings';
$string['reportshowonlyfinished'] = 'Wys hoogstens een voltooide poging per gebruiker ({$a})';
$string['reportsimplestat'] = 'Eenvoudige statistiek';
$string['reportusersall'] = 'alle gebruikers wie die vasvra probeer het';
$string['reportuserswith'] = 'ingetekende gebruikers wie die vasvra probeer het';
$string['reportuserswithorwithout'] = 'ingetekende gebruikers wie die vasvra probeer het, of nie probeer het nie.';
$string['reportuserswithout'] = 'ingetekende gebruikers wie nie die vasvra probeer het nie';
$string['reportwhattoinclude'] = 'Wat ingesluit moet word in die verslag';
$string['requirepassword'] = 'Vereis wagwoord';
$string['requirepassword_help'] = 'Indien \'n wagwoord gespesifiseer word, moet \'n student dit invoer sodat hul toegang kan verkry tot \'n vasvrapoging.';
$string['requiresubnet'] = 'Vereis netwerktoegang';
$string['requiresubnet_help'] = 'Toegang tot vasvrae kan beperk word tot bepaalde subnette op die LAN of internet deur \'n komma-geskeide lys met gedeeltelike of volledige IP-adresnommers op te gee. Dit kan nuttig wees vir \'n gemoniteerde (toesighoudende) vasvra om te verseker dat slegs mense op \'n sekere plek toegang tot die vasvra het.';
$string['response'] = 'Antwoord';
$string['responses'] = 'Antwoorde';
$string['results'] = 'Uitslae';
$string['returnattempt'] = 'Terug na poging';
$string['reuseifpossible'] = 'hergebruik voorheen geskrapte';
$string['reverttodefaults'] = 'Keer terug na verstekvasvra';
$string['review'] = 'Hersien';
$string['reviewafter'] = 'Laat hersiening toe na vasvra gesluit het';
$string['reviewalways'] = 'Laat hersiening enige tyd toe';
$string['reviewattempt'] = 'Hersien poging';
$string['reviewbefore'] = 'Laat hersiening toe terwyl vasvra oop is';
$string['reviewclosed'] = 'Na die vasvra gesluit het';
$string['reviewduring'] = 'Tydens die poging';
$string['reviewimmediately'] = 'Onmiddelik na die poging';
$string['reviewnever'] = 'Laat nooit hersiening toe nie';
$string['reviewofquestion'] = 'Hersiening van vraag {$a->question} in {$a->quiz} deur {$a->user}';
$string['reviewopen'] = 'Later, terwyl die vasvra steeds oop is';
$string['reviewoptions'] = 'Studente kan hersien';
$string['reviewoptionsheading'] = 'Hersien opsies';
$string['reviewoptionsheading_help'] = 'Hierdie opsies bepaal watter inligting studente kan sien wanneer hulle \'n vasvrapoging hersien of na die vasvraverslae kyk.

 ** Tydens die poging ** instellings is slegs relevant vir sommige gedragsinstellings, soos \'interaktief met verskeie probeerslae\', wat tydens die poging terugvoer kan gee.

** Onmiddellik na die poging ** geld die instellings vir die eerste twee minute nadat daar op \'Stuur alles en voltooi\' geklik is.

** Later, terwyl die vasvra nog oop is, geld die instellings hierna en voor die sluitingsdatum vir die vasvra.

** Nadat die vasvra gesluit is, is die instellings van toepassing nadat die vasvra-sluitingsdatum verby is. As die vasvra nie \'n sluitingsdatum het nie, word hierdie toestand nooit bereik nie.';
$string['reviewoverallfeedback'] = 'Algehele terugvoer';
$string['reviewoverallfeedback_help'] = 'Die terugvoer wat aan die einde van die poging gegee word, afhangende van die student se totale punt.';
$string['reviewresponse'] = 'Hersien antwoorde';
$string['reviewresponsetoq'] = 'Hersien antwoorde (vraag {$a})';
$string['reviewthisattempt'] = 'Hersien jou antwoorde vir hierdie poging';
$string['rqp'] = 'Afgeleë vraag';
$string['rqps'] = 'Afgeleë vrae';
$string['sameasoverall'] = 'Dieselfde as algehele punte';
$string['save'] = 'Stoor';
$string['saveandedit'] = 'Stoor veranderinge en redigeer vrae';
$string['saveattemptfailed'] = 'Het misluk om die teenswoordige vasvrapogings te stoor.';
$string['savedfromdeletedcourse'] = 'Gestoor uit kursus "{$a}" wat uitgevee is';
$string['savegrades'] = 'Stoor punte';
$string['savemyanswers'] = 'Stoor my antwoorde';
$string['savenosubmit'] = 'Stoor sonder om in te handig';
$string['saveoverrideandstay'] = 'Stoor en voeg nog \'n oorskryding by';
$string['savequiz'] = 'Stoor die hele vasvra';
$string['saving'] = 'Besig om te stoor';
$string['savingnewgradeforquestion'] = 'Stoor nuwe punt vir vraag id {$a}.';
$string['savingnewmaximumgrade'] = 'Stoor nuwe maksimumpunt';
$string['score'] = 'Rou telling';
$string['scores'] = 'Tellings';
$string['search:activity'] = 'Vasvra - aktiwiteit informasie';
$string['sectionheadingedit'] = 'Redigeer hoofopskrif \'{$a}\'';
$string['sectionheadingremove'] = 'Verwyder hoofopskrif \'{$a}\'';
$string['seequestions'] = '(Vertoon vrae)';
$string['select'] = 'Kies';
$string['selectall'] = 'Kies almal';
$string['selectattempt'] = 'Sien poging';
$string['selectcategory'] = 'Kies kategorie';
$string['selectedattempts'] = 'Verkose pogings...';
$string['selectmultipleitems'] = 'Sien verskeie items';
$string['selectmultipletoolbar'] = 'Kies veelvoudige werkbalk';
$string['selectnone'] = 'Ontkies alles';
$string['selectquestiontype'] = '-- Kies vraagtipe --';
$string['serveradded'] = 'Bediener bygevoeg';
$string['serveridentifier'] = 'Identifiseerder';
$string['serverinfo'] = 'Bediener informasie';
$string['servers'] = 'Bedieners';
$string['serverurl'] = 'Bediener URL';
$string['shortanswer'] = 'Kort antwoord';
$string['show'] = 'Wys';
$string['showall'] = 'Wys alle vrae op een bladsy';
$string['showblocks'] = 'Wys blokke tydens vasvrapoging';
$string['showblocks_help'] = 'Indien gestel tot \'ja\' sal normale blokke tydens vasvrapogings gewys word';
$string['showbreaks'] = 'Wys bladsybreke';
$string['showcategorycontents'] = 'Wys kategorie inhoud {$a->arrow}';
$string['showcorrectanswer'] = 'Wys die regte antwoorde tydens terugvoer?';
$string['showdetailedmarks'] = 'Wys punt besonderhede';
$string['showeachpage'] = 'Wys een bladsy op \'n slag';
$string['showfeedback'] = 'Wys terugvoer na beantwoording?';
$string['showinsecurepopup'] = 'Wys \'n \'veilige\' opblaasvenstertjie vir pogings.';
$string['showlargeimage'] = 'Groot beeld';
$string['shownoattempts'] = 'Wys studente met geen pogings';
$string['shownoattemptsonly'] = 'Wys net studente sonder enige pogings';
$string['shownoimage'] = 'Geen beeld';
$string['showreport'] = 'Wys verslae';
$string['showsmallimage'] = 'Klein beeld';
$string['showteacherattempts'] = 'Wys onderwyser pogings';
$string['showuserpicture'] = 'Wys die gebruikersprent';
$string['showuserpicture_help'] = 'Indien dit aangeskakel is, sal die student se naam en prentjie tydens die poging op die skerm en op die hersieningsskerm vertoon word, wat dit makliker maak om te kontroleer of die student aangemeld is as hulself in \'n toesighoudende (gemoniteerde) eksamen.';
$string['shuffle'] = 'Skommel';
$string['shuffleanswers'] = 'Skommel antwoorde';
$string['shuffledrandomly'] = 'Ewekansig geskommel';
$string['shufflequestions'] = 'Geskommel';
$string['shufflequestions_help'] = 'Indien dit aangeskakel is, sal die volgorde van die vrae in hierdie afdeling elke keer in \'n ander ewekansige volgorde geskuif word elke keer as die vasvra aangepak word.

Dit kan dit moeiliker maak vir studente om antwoorde te deel, maar dit maak dit ook moeiliker vir studente om \'n spesifieke vraag met die onderwyser te bespreek.';
$string['shufflewithin'] = 'Skommel binne vrae';
$string['shufflewithin_help'] = 'Indien dit geaktiveer is, sal die onderdele waaruit elke vraag bestaan, willekeurig geskommel word elke keer as \'n student die vasvra probeer, mits die opsie ook in die vraaginstellings geaktiveer is. Hierdie instelling is slegs van toepassing op vrae met verskeie dele, soos meerkeusevrae of pasvrae.';
$string['singleanswer'] = 'Kies een antwoord.';
$string['sortage'] = 'Sorteer volgens ouderdom';
$string['sortalpha'] = 'Sorteer volgens naam';
$string['sortquestionsbyx'] = 'Sorteer vrae volgens: {$a}';
$string['sortsubmit'] = 'Sorteer vrae';
$string['sorttypealpha'] = 'Sorteer volgens tipe, naam';
$string['specificapathnotonquestion'] = 'Die gespesifiseerde lêerpad is nie op die gespesifiseerde vraag nie';
$string['specificquestionnotonquiz'] = 'Spesifieke vraag is nie deel van spesifieke vasvra nie';
$string['startagain'] = 'Begin oor';
$string['startattempt'] = 'Begin poging';
$string['startedon'] = 'Begin teen';
$string['startnewpreview'] = 'Begin \'n nuwe voorskou';
$string['stateabandoned'] = 'Nooit ingedien nie';
$string['statefinished'] = 'Klaar';
$string['statefinisheddetails'] = 'Ingedien {$a}';
$string['stateinprogress'] = 'Aan die gang';
$string['statenotloaded'] = 'Die status vir vraag {$a} is nie uit die databasis gelaai nie';
$string['stateoverdue'] = 'Agterstallig';
$string['stateoverduedetails'] = 'Moet ingedien word deur {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stop met fout';
$string['submitallandfinish'] = 'Handig alles in en maak klaar';
$string['subneterror'] = 'Jammer, hierdie vasvra is gesluit sodat dit slegs vanaf sekere liggings toeganklik is. Jou rekenaar is tans nie een van die wat hierdie vasvra mag gebruik nie.';
$string['subnetnotice'] = 'Hierdie vasvra is gesluit sodat dit slegs vanaf sekere plekke toeganklik is. Jou rekenaar is nie op \'n toegelate subnet nie. As onderwyser mag jy in elk geval \'n voorskou hê.';
$string['subplugintype_quiz'] = 'Verslag';
$string['subplugintype_quiz_plural'] = 'Verslae';
$string['subplugintype_quizaccess'] = 'Toegangsreël';
$string['subplugintype_quizaccess_plural'] = 'Toegangsreëls';
$string['substitutedby'] = 'sal vervang word deur';
$string['summaryofattempt'] = 'Opsomming van pogings';
$string['summaryofattempts'] = 'Opsomming van vorige pogings';
$string['temporaryblocked'] = 'Jy mag tydelik nie weer die vasvra probeer nie. <br /> Jy kan weer probeer om:';
$string['theattempt'] = 'Die poging';
$string['theattempt_help'] = 'Of die student die poging enigsins mag aanpak.';
$string['time'] = 'Tyd';
$string['timecompleted'] = 'Voltooi';
$string['timedelay'] = 'Jy mag nie die vasvra doen nie, aangesien die vertraagde tyd eers verby moet wees voordat jy \'n ander vasvra poging probeer';
$string['timeleft'] = 'Tyd oor';
$string['timelimit'] = 'Tydsbeperking';
$string['timelimit_help'] = 'Indien geaktiveer, word die tydsbeperking op die aanvanklike vasvrabladsy aangedui en \'n afteller word in die navigasieblok vir vasvrae vertoon.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Jammer! Vasvratyd is verstreke!';
$string['timestr'] = '%H:%M:%S op %d/%m/%y';
$string['timesup'] = 'Tyd is verstreke!';
$string['timetaken'] = 'Tyd geneem';
$string['timing'] = 'Tydsberekening';
$string['tofile'] = 'na lêer';
$string['tolerance'] = 'Speling';
$string['toomanyrandom'] = 'Die aantal vereiste ewekansige vrae is meer as wat nog beskikbaar is in die kategorie!';
$string['top'] = 'Bo';
$string['totalmarksx'] = 'Totale punte: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Totaal van {$a} vrae in kategorie.';
$string['true'] = 'Waar';
$string['truefalse'] = 'Waar/Vals';
$string['type'] = 'Tipe';
$string['unfinished'] = 'oop';
$string['ungraded'] = 'Ongemerk';
$string['unit'] = 'Eenheid';
$string['unknowntype'] = 'Vraagtipe word nie by lyn {$a} ondersteun nie. Die vraag sal geïgnoreer word';
$string['updateoverdueattemptstask'] = 'Opdatering van agterstallige vasvrapogings';
$string['updatequizslotswithrandomxofy'] = 'Opdatering van vasvra-gleuwe met "ewekansige" vraagdata ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Dateer vasvrainstelling op';
$string['updatingatttemptgrades'] = 'Dateer pogingpunt op.';
$string['updatingfinalgrades'] = 'Dateer finale punte op.';
$string['updatingthegradebook'] = 'Dateer punteboek op.';
$string['upgradesure'] = '<div> In die besonder sal die vasvra-module \'n uitgebreide verandering aan die vasvra-tabelle uitvoer en hierdie opgradering is nog nie voldoende getoets nie. Jy word baie sterk versoek om jou databasis-tabelle te rugsteun voor jy verder gaan. </div>';
$string['upgradingquizattempts'] = 'Opgradering van vasvrapogings: vasvra {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Opgradering van stokoue vasvrapoings: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Hierdie kategorie is bewaar en na die webwerfvlak geskuif omdat dit \'n gepubliseerde kategorie is wat steeds deur ander kursusse gebruik word.';
$string['useroverrides'] = 'Gebruiker oorskrydings';
$string['useroverridesdeleted'] = 'Gebruiker oorskrydings uitgevee';
$string['usersnone'] = 'Geen studente het toegang tot hierdie vasvra nie';
$string['validate'] = 'Bevestig';
$string['viewallanswers'] = 'Beskou {$a} vasvrapogings';
$string['viewallreports'] = 'Beskou verslae vir {$a} pogings';
$string['viewed'] = 'Beskou';
$string['warningmissingtype'] = '<b> Hierdie vraagtipe is nog nie op jou Moodle geïnstalleer nie. <br /> Stel jou Moodle-administrateur in kennis. </b>';
$string['wheregrade'] = 'Waar is my punt?';
$string['wildcard'] = 'Wisselkaart';
$string['windowclosing'] = 'Die venster sal binnekort sluit.';
$string['withsummary'] = 'met omsommende statistieke';
$string['wronguse'] = 'Jy kan nie \'n bladsy soos dit gebruik nie';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Jy moet in hierdie kursus inskryf voor jy hierdie vasvra kan probeer';
$string['yourfinalgradeis'] = 'Jou finale punt vir hierdie vasvra is {$a}.';
