<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'zh_cn', version '4.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = '即将开始安装';
$string['accept'] = '接受';
$string['action'] = '行动';
$string['actionchoice'] = '您想怎么处理文件“{$a}”？';
$string['actions'] = '设置';
$string['actionsfor'] = '为{$a}采取行动';
$string['actionsmenu'] = '行动菜单';
$string['active'] = '激活';
$string['activeusers'] = '活跃用户';
$string['activities'] = '活动';
$string['activities_help'] = '各种活动，例如讨论区、测验和Wiki，开启课程诸多互动内容。';
$string['activity'] = '活动';
$string['activityclipboard'] = '移动此活动：{$a}';
$string['activityheader'] = '活动菜单';
$string['activityiscurrentlyhidden'] = '很抱歉！此活动目前处于隐藏状态';
$string['activitymodule'] = '活动模块';
$string['activitymodules'] = '活动模块';
$string['activityreport'] = '活动报表';
$string['activityreports'] = '活动报表';
$string['activityselect'] = '选择把此活动移动到其它地方';
$string['activitysince'] = '活动始于{$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = '每个用户的活动';
$string['add'] = '添加';
$string['addactivity'] = '添加活动...';
$string['addactivitytosection'] = '添加一个活动到小节“ {$a}”';
$string['addadmin'] = '添加网站管理员';
$string['addblock'] = '添加一个版块';
$string['addcomment'] = '添加一条评论...';
$string['addcountertousername'] = '向用户名添加数字来建立用户';
$string['addcreator'] = '添加课程管理员';
$string['adddots'] = '添加...';
$string['added'] = '已添加{$a}';
$string['addedtogroup'] = '已加入到组“{$a}”';
$string['addedtogroupnot'] = '未加入到组“{$a}”';
$string['addedtogroupnotenrolled'] = '未加入组“{$a}”，因为未选课';
$string['addfilehere'] = '将文件拖拽到此处以添加到此小节底部';
$string['addinganew'] = '添加一个新{$a}';
$string['addinganewto'] = '向{$a->to}添加一个新{$a->what}';
$string['addingdatatoexisting'] = '加入数据到现有的';
$string['additionalcustomnav'] = '添加自定义导航';
$string['additionalnames'] = '附加名称';
$string['addlinkhere'] = '向此处添加链接';
$string['addnew'] = '添加新 {$a}';
$string['addnewcategory'] = '添加新类别';
$string['addnewcourse'] = '添加新课程';
$string['addnewuser'] = '添加用户';
$string['addnousersrecip'] = '把还没有进入这个{$a}的用户添加到收件人名单中';
$string['addpagehere'] = '此处添加页面文字';
$string['addresource'] = '添加资源...';
$string['addresourceoractivity'] = '添加一项活动或资源';
$string['addresourcetosection'] = '新增一个资源到小节 {$a}';
$string['address'] = '地址';
$string['addsections'] = '添加小节';
$string['addstudent'] = '添加学生';
$string['addsubcategory'] = '添加子类';
$string['addteacher'] = '添加教师';
$string['admin'] = '管理';
$string['adminhelpaddnewuser'] = '手动创建一个新用户帐号';
$string['adminhelpassignadmins'] = '网站管理员可以做任何操作，可以访问站点内的任何地方';
$string['adminhelpassigncreators'] = '课程创建者可以创建新课程';
$string['adminhelpassignsiteroles'] = '分配已定义的站点角色给特定用户';
$string['adminhelpassignstudents'] = '进入一门课程，然后在管理菜单中添加学生';
$string['adminhelpauthentication'] = '可以使用内部网络帐户或者外部数据库';
$string['adminhelpbackup'] = '设定自动备份和备份日程';
$string['adminhelpconfiguration'] = '设定网站外观及工作参数';
$string['adminhelpconfigvariables'] = '设定影响网站一般操作的变量';
$string['adminhelpcourses'] = '定义课程及类别，指派用户，编辑申请中的课程';
$string['adminhelpeditorsettings'] = '为HTML编辑器设定基本属性';
$string['adminhelpedituser'] = '浏览用户列表，并可编辑';
$string['adminhelpenvironment'] = '检查您的服务器是否满足当前和未来的安装要求';
$string['adminhelpfailurelogs'] = '浏览登录失败的日志';
$string['adminhelplanguage'] = '检查和编辑当前的语言包';
$string['adminhelplogs'] = '浏览此站点上的所有活动日志';
$string['adminhelpmanageblocks'] = '管理已安装的版块和设置';
$string['adminhelpmanagedatabase'] = '直接访问数据库（小心！）';
$string['adminhelpmanagefilters'] = '选择文本过滤器和相关的设置';
$string['adminhelpmanagemodules'] = '管理已安装的模块和设置';
$string['adminhelpmanageroles'] = '创建和定义可分配给用户的角色';
$string['adminhelpmymoodle'] = '为用户配置“我的moodle”版块';
$string['adminhelpreports'] = '站点级报表';
$string['adminhelpsitefiles'] = '发布普通文件或者上传外部备份';
$string['adminhelpsitesettings'] = '自定义站点首页';
$string['adminhelpstickyblocks'] = '配置Moodle全站的粘性版块';
$string['adminhelpthemes'] = '选择网站的外观(颜色、字体等)';
$string['adminhelpuploadusers'] = '从文本文件导入新的用户帐号';
$string['adminhelpusers'] = '定义用户并设定验证';
$string['adminhelpxmldbeditor'] = '编辑XMLDB文件。仅限开发者。';
$string['administration'] = '课程管理';
$string['administrationsite'] = '站点管理';
$string['administrator'] = '管理员';
$string['administratordescription'] = '管理员可操作站点内的任何课程。';
$string['administrators'] = '管理员';
$string['administratorsall'] = '全部管理员';
$string['administratorsandteachers'] = '管理员和教师';
$string['advanced'] = '高级';
$string['advancedfilter'] = '高级搜索';
$string['advancedsettings'] = '高级设置';
$string['afterresource'] = '在资源“ {$a} "之后';
$string['aftersection'] = '在小节” {$a} “之后';
$string['again'] = '再一次';
$string['agelocationverification'] = '核实年龄及地点';
$string['aimid'] = 'AIM号码';
$string['ajaxuse'] = 'AJAX和JavaScript';
$string['all'] = '所有';
$string['allactions'] = '全部设置';
$string['allactivities'] = '所有活动';
$string['allcategories'] = '所有类别';
$string['allchanges'] = '所有改变';
$string['alldays'] = '所有日期';
$string['allfiles'] = '所有文件';
$string['allgroups'] = '所有小组';
$string['alllogs'] = '所有日志';
$string['allmods'] = '所有{$a}';
$string['allow'] = '允许';
$string['allowinternal'] = '也允许内部方法';
$string['allownone'] = '全部禁止';
$string['allownot'] = '不允许';
$string['allowstealthmodules'] = '允许隐形活动';
$string['allowstealthmodules_help'] = '如果启用了，可以使用活动，但不显示在课程页面的可见部分中。如果是这样的话，必须从其他地方提供链接，比如从页面资源。隐形活动仍然在成绩单和其他报告中列出来。';
$string['allparticipants'] = '所有参与人';
$string['allteachers'] = '所有教师';
$string['alphanumerical'] = '只能包含字母、数字、横线（-）或小数点（.）';
$string['alreadyconfirmed'] = '您的注册已经确认了';
$string['alternatename'] = '别名';
$string['always'] = '始终';
$string['and'] = '{$a->one} 和 {$a->two}';
$string['answer'] = '回答';
$string['any'] = '任意';
$string['appearance'] = '外观';
$string['approve'] = '批准';
$string['areyousure'] = '您确定吗？';
$string['areyousuretorestorethis'] = '您确定要继续吗?';
$string['areyousuretorestorethisinfo'] = '稍后，您要选择把此备份添加到一门现有课程中，还是创建一门新课程。';
$string['asc'] = '升序';
$string['assessment'] = '评价';
$string['assignadmins'] = '任命网站管理员';
$string['assigncreators'] = '任命课程管理员';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = '指派网站范围的角色';
$string['authenticateduser'] = '已认证用户';
$string['authenticateduserdescription'] = '所有已登录用户。';
$string['authentication'] = '身份认证';
$string['authenticationplugins'] = '身份认证插件';
$string['autosubscribe'] = '讨论区自动订阅';
$string['autosubscribeno'] = '不：不要自动为我订阅讨论区';
$string['autosubscribeyes'] = '是：发帖后为我订阅该讨论区';
$string['availability'] = '有效性';
$string['availablecourses'] = '可用的课程';
$string['back'] = '返回';
$string['backto'] = '回到“{$a}”';
$string['backtocourselisting'] = '返回课程列表';
$string['backtohome'] = '返回网站首页';
$string['backtopageyouwereon'] = '回到刚才的页面';
$string['backup'] = '备份';
$string['backupactivehelp'] = '选择是否进行自动备份。';
$string['backupadhocpending'] = '课程备份临时任务挂起';
$string['backupcancelled'] = '备份被取消';
$string['backupcoursefileshelp'] = '如果允许，那么课程文件将会被包含在自动备份中';
$string['backupdate'] = '备份日期';
$string['backupdatenew'] = '{$a->TAG}现在是{$a->year}{$a->month}{$a->mday}，{$a->weekday}<br />';
$string['backupdateold'] = '{$a->TAG}曾是{$a->year}{$a->month}{$a->mday}，{$a->weekday}<br />';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = '备份细节';
$string['backuperrorinvaliddestination'] = '备份存放文件夹不存在或不可写入。';
$string['backupexecuteathelp'] = '选择需要运行自动备份的时间';
$string['backupfailed'] = '您的一些课程尚未保存!!';
$string['backupfilename'] = '备份';
$string['backupfinished'] = '备份圆满成功';
$string['backupfromthissite'] = '此站已经备份过了吗？';
$string['backupgradebookhistoryhelp'] = '如果启用，成绩单的历史会被包含在自动备份中。注意，如果想使用这个功能，成绩历史就一定不能在服务器设置（disablegradehistory）中被禁用';
$string['backupincludemoduleshelp'] = '在自动备份中，选择是否希望包含带有或不带有用户数据的课程模块';
$string['backupincludemoduleuserdatahelp'] = '选择是否希望在自动备份中包含模块用户的数据。';
$string['backuplogdetailed'] = '详细的运行日志';
$string['backuploglaststatus'] = '最后的运行日志';
$string['backupmissinguserinfoperms'] = '注意：本次备份不包含用户数据。“练习”模块和“工作室”模块与此种备份不兼容，所以它们完全不被备份。';
$string['backupnext'] = '下一次备份';
$string['backupnonisowarning'] = '警告：此备份来自Moodle的非Unicode的版本（1.6版以前）。如果此备份包含任何非ISO-8859-1文本，那么当试图把此备份恢复到Moodle的Unicode版本时，他们可能被破坏。请参考<a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>获取更多关于正确恢复备份的方法。';
$string['backupnotyetrun'] = '自动备份暂停';
$string['backuporiginalname'] = '备份名称';
$string['backuproleassignments'] = '备份这些角色的角色分配';
$string['backupsavetohelp'] = '存放备份文件的文件夹的完整路径';
$string['backupsitefileshelp'] = '如果启用，那么课程中使用的网站文件将自动包含在备份文件中。';
$string['backuptakealook'] = '请看一下如下目录中的备份日志：
{$a}';
$string['backupuserfileshelp'] = '选择是否在自动备份中包含用户文件(如用户头像)';
$string['backupversion'] = '备份版本';
$string['badges'] = '勋章';
$string['block'] = '版块';
$string['blockconfiga'] = '配置{$a}版块';
$string['blockconfigbad'] = '由于此版块未正确实现，因此无法显示配置界面。';
$string['blocks'] = '版块';
$string['blocksaddedit'] = '添加/修改版块';
$string['blockseditoff'] = '版块编辑关';
$string['blocksediton'] = '版块编辑开';
$string['blocksetup'] = '设定版块表格';
$string['blocksuccess'] = '{$a}表格已经正确设置了';
$string['brief'] = '简报';
$string['bulkactions'] = '批量设置';
$string['bulkactionselect'] = '{$a} 批量操作选择';
$string['bulkmovecoursessuccess'] = '已成功移动{$a->courses}课程到{$a->category}';
$string['bycourseorder'] = '按课程顺序';
$string['byname'] = '由“{$a}”';
$string['bypassed'] = '忽视';
$string['cachecontrols'] = '缓存控制';
$string['calltofeedback'] = '本软件的创建者希望得到您的反馈。';
$string['calltofeedback_give'] = '提供有关此软件的反馈';
$string['calltofeedback_remind'] = '稍后提醒我';
$string['cancel'] = '取消';
$string['cancelled'] = '取消';
$string['categories'] = '课程类别';
$string['categoriesandcourses'] = '课程类别和课程';
$string['category'] = '类别';
$string['categoryadded'] = '已经添加类别‘{$a}’';
$string['categorybulkaction'] = '对选定类别的批量设置';
$string['categorycontents'] = '课程子目录和课程';
$string['categorycurrentcontents'] = '{$a}的内容';
$string['categorydeleted'] = '已经删除类别‘{$a}’';
$string['categoryduplicate'] = '“{$a}”类别已经存在!';
$string['categoryheader'] = '分类目录';
$string['categoryhidden'] = '(隐藏的)';
$string['categorymodifiedcancel'] = '课程目录被编辑，请取消后重试。';
$string['categoryname'] = '类别名称';
$string['categorypath'] = '分类路径';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory}的子类别';
$string['categoryupdated'] = '‘{$a}’已经更新';
$string['changedpassword'] = '新密码';
$string['changepassword'] = '更改密码';
$string['changesmade'] = '产生的修改';
$string['changesmadereallygoaway'] = '您做出了改动。您确定要离开并放弃所有改动吗？';
$string['changessaved'] = '更改已经保存';
$string['check'] = '检查';
$string['checkactual'] = '实际上';
$string['checkall'] = '检查全部';
$string['checkexpected'] = '预期的';
$string['checkingbackup'] = '检查备份';
$string['checkingcourse'] = '检查课程';
$string['checkingforbbexport'] = '检查BlackBoard的输出';
$string['checkinginstances'] = '检查实例';
$string['checkingsections'] = '检查小节';
$string['checklanguage'] = '校对语言';
$string['checknone'] = '不检查';
$string['checks'] = '检查项';
$string['checksok'] = '所有\'{$a}\'检查通过';
$string['childcoursenotfound'] = '未发现子课程！';
$string['childcourses'] = '子课程';
$string['choose'] = '选择';
$string['choosecourse'] = '选择一个课程';
$string['choosedots'] = '选择...';
$string['chooselivelogs'] = '或者查看当前活动';
$string['chooselogs'] = '选择您要看的日志';
$string['choosereportfilter'] = '为报表选择一个筛选条件';
$string['choosetheme'] = '选择主题风格';
$string['chooseuser'] = '选择一个用户';
$string['city'] = '市/县';
$string['cleaningtempdata'] = '清空临时数据';
$string['clear'] = '清空';
$string['clearsearch'] = '清除搜索输入';
$string['clickhelpiconformoreinfo'] = '...继续...点击帮助图标阅读全文';
$string['clickhere'] = '点击这里...';
$string['clicktochangeinbrackets'] = '{$a}(点击修改)';
$string['clicktohideshow'] = '单击以展开或折叠';
$string['closeblockdrawer'] = '关闭块抽屉';
$string['closebuttontitle'] = '关闭';
$string['closecourseindex'] = '关闭课程索引';
$string['closedrawer'] = '关闭抽屉';
$string['closewindow'] = '关闭窗口';
$string['collapse'] = '折叠';
$string['collapseall'] = '全部折叠';
$string['collapsecategory'] = '折叠 {$a}';
$string['commentincontext'] = '在场景中查找此条评论';
$string['comments'] = '评论';
$string['commentscount'] = '评论({$a})';
$string['commentsnotenabled'] = '未启用评论功能';
$string['commentsrequirelogin'] = '查看评论，需要你登录。';
$string['comparelanguage'] = '比较并编辑当前语言';
$string['complete'] = '完全';
$string['completed'] = '完成';
$string['completereport'] = '完整报表';
$string['configuration'] = '设置';
$string['confirm'] = '确认';
$string['confirmcheckfull'] = '您真的确认{$a}？';
$string['confirmcoursemove'] = '你确定要移动这一课程({$a->course})到这一类别({$a->category})?';
$string['confirmdeletesection'] = '你确信想要完全删除 "{$a}"小节以及里面的全部活动？';
$string['confirmed'] = '您的注册已经得到确认';
$string['confirmednot'] = '您的注册尚未得到确认，请检查你的邮箱是否有确认邮件。';
$string['considereddigitalminor'] = '您太小了，不能在这个站点上注册账号。';
$string['content'] = '内容';
$string['contentbank'] = '内容库';
$string['contentexport_aboutthiscourse'] = '课程总结';
$string['contentexport_coursesummary'] = '从<a href="{$a->courselink}">{$a->coursename}</a>下载内容文件。';
$string['contentexport_footersummary'] = '从<a href="{$a->courselink}">{$a->coursename}</a>下载{$a->maxfilesize}上关于 {$a->userfullname}的文件';
$string['contentexport_modulesummary'] = '从<a href="{$a->modulelink}">{$a->modulename}</a>下载关于{$a->date}的文件。注意：请注意，某些内容和任何大于{$a->maxfilesize}的文件都不会被下载。';
$string['contentexport_viewfilename'] = '观看文件 {$a}';
$string['continue'] = '继续';
$string['continuetocourse'] = '点击这里进入您的课程';
$string['convertingwikitomarkdown'] = '把Wiki转为Markdown';
$string['cookiesenabled'] = '您浏览器的 cookies 设置必须打开';
$string['cookiesenabled_help'] = '本站使用两个cookie：

最基本的是会话cookie，通常叫做 MoodleSession。您必须在浏览器里接受这个 cookie以提供连续性，并在浏览网站时保持登录状态。当您登出或关闭浏览器，这个 cookie 在浏览器和服务器里都会被删除。

另一个 cookie 纯粹是为了方便，通常被叫做类似 MOODLEID 之类的名字。它只用来在浏览器里记住您的用户名。这意味着当您再次回到本站，登录页面里的用户名已经替您填好了。拒绝此 cookie 是安全的，只不过每次登录都要重新输入用户名而已。';
$string['cookiesenabled_help_html'] = '本网站使用了两种Cookie。<br/><br/>

最重要的是被称为MoodleSession的会话Cookie。你必须在浏览器中允许这个Cookie以保持在线和保证你在浏览网站时保持登录状态。当你登出或者关闭浏览器，这个Cookie会被销毁（在你的浏览器和服务器都会销毁）。.<br/><br/>

另一种Cookie纯粹是为了方便，通常叫做MOODLEID或者类似的名称。它的作用仅是在浏览器中记住你的用户名。这意味着当你返回此网站时，用户名将会为你自动填充。拒绝这种Cookie是安全的，你只需要在每次登录时重新填写用户名。';
$string['cookiesenabledonlysession'] = '您浏览器的 cookies 设置必须打开';
$string['cookiesenabledonlysession_help'] = '这个站点使用一个会话cookie，通常叫做 MoodleSession。您必须在浏览器里接受这个 cookie才能使您的登录在页与页之间连续有效。当您退出或关闭浏览器，这个cookie在浏览器和服务器里都会被删除。';
$string['cookiesnotenabled'] = '很不幸，您的浏览器目前并未开启对 cookie 的支持';
$string['cookiesnotice'] = 'Cookie通告';
$string['copy'] = '复制';
$string['copyasnoun'] = '复制';
$string['copycourse'] = '复制课程';
$string['copyingcoursefiles'] = '复制课程文件';
$string['copyingsitefiles'] = '复制课程中使用的站点文件';
$string['copyinguserfiles'] = '复制用户文件';
$string['copyingzipfile'] = '复制zip文件';
$string['copyrightnotice'] = '版权声明';
$string['coresystem'] = '系统';
$string['cost'] = '课程费用';
$string['costdefault'] = '缺省费用';
$string['counteditems'] = '{$a->count}{$a->items}';
$string['country'] = '国家或地区';
$string['course'] = '课程';
$string['courseadministration'] = '课程管理';
$string['courseapprovedemail'] = '您申请的课程《{$a->name}》已经被批准了，并且您已经是该课程的{$a->teacher}。要访问您的新课程，请点击 {$a->url}。';
$string['courseapprovedemail2'] = '您申请的课程，{$a->name}，已经被批准。访问您的新课程，请到 {$a->url}';
$string['courseapprovedfailed'] = '‎未能将课程保存为已批准！';
$string['courseapprovedsubject'] = '您的课程已经通过';
$string['courseavailable'] = '该课程允许学生学习';
$string['courseavailablenot'] = '该课程不允许学生学习';
$string['coursebackup'] = '课程备份';
$string['coursebulkaction'] = '对选定课程的批量设置';
$string['coursecategories'] = '课程类别';
$string['coursecategory'] = '课程类别';
$string['coursecategory_help'] = '<p align="center"><b>课程类别</b></p>

<p>您的 Moodle 管理员可能已经设立了几个课程分类。</p>

<p>例如，“自然科学”，“人文科学”，“公共卫生”等。</p>

<p>选择一个最适合用于您的课程的。这个选择将影响到您的课程在课程列表上的显示，也会更容易的让学生们找到您的课程。</p>';
$string['coursecategorydeleted'] = '已删除课程类别 {$a}';
$string['coursecatmanagement'] = '课程和类别管理';
$string['coursecompletion'] = '修完课程';
$string['coursecompletions'] = '修完课程';
$string['coursecreators'] = '课程创建者';
$string['coursecreatorsdescription'] = '课程创建者可以创建新课程。';
$string['coursedeleted'] = '已删除课程 {$a}';
$string['coursedetails'] = '课程详情';
$string['coursedisplay'] = '课程布局';
$string['coursedisplay_help'] = '此设置决定整个课程是在一页显示或是分几页显示。';
$string['coursedisplay_multi'] = '在每页显示一个小节';
$string['coursedisplay_single'] = '在一页显示所有小节';
$string['courseduration'] = '课程持续时间';
$string['courseduration_desc'] = '课程持续时间用于计算默认课程结束日期。 课程结束日期用于确定这个课程是否会出现在用户的课程列表中，也可以在自定义报告中使用。 用户仍然可以在结束日期后加入课程。';
$string['courseenddateenabled'] = '默认启用课程结束日期';
$string['courseenddateenabled_desc'] = '此设置决定对新课程是否启用课程结束日期，同时以课程课时设定结束日期。';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = '从旧版继承的课程文件';
$string['coursefilesedit'] = '编辑课程文件';
$string['coursefileswarning'] = '课程文件已被废弃';
$string['coursefileswarning_help'] = 'Moodle 2.0之后，课程文件将不再存在。请尽可能使用外部容器。';
$string['courseformatdata'] = '课程格式数据';
$string['courseformatoptions'] = '{$a} 格式化选项';
$string['courseformats'] = '课程格式';
$string['courseformatudpate'] = '更新格式';
$string['coursegrades'] = '课程成绩';
$string['courseheader'] = '课程菜单';
$string['coursehelpcategory'] = '调整课程在课程列表中的位置可以让学生更容易发现它。';
$string['coursehelpforce'] = '强制课程中的所有活动都使用课程的组模式。';
$string['coursehelpformat'] = '课程主页会用这里指定的格式显示。';
$string['coursehelphiddensections'] = '课程中隐藏的小节如何向学生显示。';
$string['coursehelpmaximumupload'] = '定义课程中上传文件的最大大小。会受到全站设置的影响。';
$string['coursehelpnewsitemsnumber'] = '课程页面上最新通告栏中出现的最近通告数量。如果设置为零，则不会创建新闻通告论坛。';
$string['coursehelpnumberweeks'] = '课程中的小节数量（仅适用于某些课程格式）。';
$string['coursehelpshowgrades'] = '打开成绩单的显示。此设置不会影响每个活动中成绩的显示。';
$string['coursehidden'] = '此课程目前并不对学生开放';
$string['courseinfo'] = '课程信息';
$string['courselegacyfiles'] = '课程文件';
$string['courselegacyfiles_help'] = '“课程文件”用来与Moodle 1.9及更早的版本兼容。存放于此的文件可被课程所有成员访问，无论您是否加了指向它们的链接。并且您不会知道这些文件都被用在Moodle的哪里。

如果您在这里保存课程文件，将会遇到一些关于隐私和安全的问题。在备份、课程导入、内容共享或复用时，有可能遇到文件丢失的情况。因此，建议您不用使用此存储区，除非您很清楚您正在做什么。';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = '传统的课程文件：{$a}';
$string['coursenotaccessible'] = '这个课程未对公众开放';
$string['courseoverview'] = '课程总览';
$string['courseoverviewfiles'] = '课程镜像文件';
$string['courseoverviewfiles_help'] = '课程摘要文件(图像)显示在个人主页的课程概览中。站点管理员可以启用其他可接受的文件类型和多个文件。如果是，这些文件将显示在课程列表页面的课程简介旁边。';
$string['courseoverviewfilesext'] = '课程摘要文件类型';
$string['courseoverviewfileslimit'] = '课程摘要文件限制';
$string['courseoverviewgraph'] = '课程概述图';
$string['coursepreferences'] = '课程设置';
$string['courseprofiles'] = '课程档案';
$string['coursereasonforrejecting'] = '拒绝此申请的理由';
$string['coursereasonforrejectingemail'] = '会通过email发给请求人';
$string['coursereject'] = '拒绝课程申请';
$string['courserejected'] = '已经拒绝了课程申请并通知了申请人。';
$string['courserejectemail'] = '很抱歉，您提交的课程申请已经被拒绝了。下面是原因：
{$a}';
$string['courserejectreason'] = '请简要说明拒绝这个课程的理由<br />（系统会将它发送给申请人）';
$string['courserejectsubject'] = '您的课程申请已经被拒绝';
$string['coursereport'] = '课程报告';
$string['coursereports'] = '课程报表';
$string['courserequest'] = '课程申请';
$string['courserequestdetails'] = '您正申请的课程的详细信息';
$string['courserequestfailed'] = '由于某些原因，无法保存您的课程申请。';
$string['courserequestintro'] = '通过下面的表单可以申请创建一个新课程。<br />请尽量仔细填写以便管理员了解您有多需要这门课。';
$string['courserequestreason'] = '申请此课程的原因';
$string['courserequestsuccess'] = '已经保存了您的课程申请。到时会有 Email 告知您此申请是否得到批准。';
$string['courserequestsupport'] = '一些额外的信息，帮助管理员来评估您的请求';
$string['courserequestwarning'] = '允许用户自助选课请求并分配 {$a}角色。';
$string['courserestore'] = '课程恢复';
$string['coursereuse'] = '重新使用课程';
$string['courses'] = '课程';
$string['coursesearch'] = '搜索课程';
$string['coursesearch_help'] = '您可以一次使用多关键字搜索，并按照下面的方式重新定义你的搜索:

*word: 搜索任何包含该关键字的内容
*+word: 严格匹配
*-word: 结果中不含该关键词';
$string['coursesectionsummaries'] = '课程小节概述';
$string['coursesectiontitle'] = '课程： {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = '课程缺省设置';
$string['coursesmovedout'] = '课程已从 {$a} 中移出';
$string['coursespending'] = '待审批的课程';
$string['coursestart'] = '课程开始';
$string['coursesummary'] = '课程概要';
$string['coursesummary_help'] = '课程简介会显示在课程列表中。搜索课程时会同时搜索课程名和课程简介。';
$string['coursetitle'] = '课程： {$a->course}';
$string['courseupdates'] = '课程更新';
$string['coursevisibility'] = '课程可见性';
$string['coursevisibility_help'] = '该设置决定本课程是否出现在课程列表上，以及学生是否能够访问。如果设成隐藏，那么仅限有权查看隐藏文件的用户查看（比如老师）。';
$string['create'] = '创建';
$string['createaccount'] = '注册我的新帐号';
$string['createcategory'] = '创建课程分类';
$string['createfolder'] = '在{$a}创建一个文件夹';
$string['createnew'] = '建立新的';
$string['createnewcategory'] = '建立新类别';
$string['createnewcourse'] = '建立新课程';
$string['createnewsubcategory'] = '建立新的子类别';
$string['createsubcategoryof'] = '建立 {$a} 的子类别';
$string['createuser'] = '创建用户';
$string['createuserandpass'] = '选择您的用户名和密码';
$string['createziparchive'] = '创建zip压缩文件';
$string['creatingblocks'] = '创建版块';
$string['creatingblocksroles'] = '创建版块级角色分配和覆盖';
$string['creatingblogsinfo'] = '创建博客信息';
$string['creatingcategoriesandquestions'] = '创建类别和题目';
$string['creatingcoursemodules'] = '创建课程模块';
$string['creatingcourseroles'] = '创建课程级角色分配和覆盖';
$string['creatingevents'] = '创建事件';
$string['creatinggradebook'] = '创建成绩单';
$string['creatinggroupings'] = '正在创建大组';
$string['creatinggroupingsgroups'] = '正在把小组加入大组中';
$string['creatinggroups'] = '创建组';
$string['creatinglogentries'] = '创建日志';
$string['creatingmessagesinfo'] = '创建消息信息';
$string['creatingmodroles'] = '创建模块级角色分配和覆盖';
$string['creatingnewcourse'] = '创建新课程';
$string['creatingrolesdefinitions'] = '创建角色定义';
$string['creatingscales'] = '创建量表';
$string['creatingsections'] = '创建小节';
$string['creatingtemporarystructures'] = '创建临时组织';
$string['creatinguserroles'] = '创建用户级角色分配和覆盖';
$string['creatingusers'] = '创建用户';
$string['creatingxmlfile'] = '创建XML文件';
$string['currency'] = '货币';
$string['currentcourse'] = '当前课程';
$string['currentcourseadding'] = '当前课程，向其中添加数据';
$string['currentcoursedeleting'] = '当前课程，先删除它';
$string['currentlanguage'] = '当前语言';
$string['currentlocaltime'] = '您的当地时间';
$string['currentpicture'] = '当前图片';
$string['currentrelease'] = '当前发行版信息';
$string['currentversion'] = '当前版本';
$string['databasechecking'] = '把Moodle数据库从{$a->oldversion}升级到{$a->newversion}';
$string['databaseperformance'] = '数据库选项';
$string['databasesetup'] = '正在安装数据库';
$string['databasesuccess'] = '数据库升级成功';
$string['databaseupgradebackups'] = '现在的备份版本是{$a}';
$string['databaseupgradeblocks'] = '现在的版块版本是{$a}';
$string['databaseupgradegroups'] = '现在组的版本是{$a}';
$string['databaseupgradelocal'] = '现在的本地数据库版本是{$a}';
$string['databaseupgrades'] = '升级数据库';
$string['dataformats'] = '数据格式';
$string['date'] = '日期';
$string['datechanged'] = '日期已变更';
$string['datemostrecentfirst'] = '日期 - 近的在前';
$string['datemostrecentlast'] = '日期 - 最近的在后';
$string['day'] = '天';
$string['days'] = '天';
$string['decodinginternallinks'] = '解码内部链接';
$string['default'] = '缺省';
$string['defaultcategoryname'] = '分类甲';
$string['defaultcompetencescale'] = '默认能力量表';
$string['defaultcompetencescaledesc'] = '除了某人是否已经表现出熟练程度以外，二进制评分表不提供进一步的信息。';
$string['defaultcompetencescalenotproficient'] = '尚无该能力';
$string['defaultcompetencescaleproficient'] = '具备该能力';
$string['defaultcoursestudent'] = '学生';
$string['defaultcoursestudentdescription'] = '学生在课程中通常拥有较少的特权。';
$string['defaultcoursestudents'] = '学生';
$string['defaultcoursesummary'] = '写一段简明有趣的文字介绍一下该课程';
$string['defaultcourseteacher'] = '教师';
$string['defaultcourseteacherdescription'] = '教师可以在负责的课程中做任何事，包括更改活动和为学生评分。';
$string['defaultcourseteachers'] = '教师';
$string['defaulteditor'] = '默认编辑器';
$string['defaulthomepageuser'] = '起始页';
$string['defaulthomepageuser_help'] = '在登录后跳转到哪个页面？';
$string['delete'] = '删除';
$string['deleteablock'] = '删除一个版块';
$string['deleteall'] = '全部删除';
$string['deleteallcannotundo'] = '全部删除（不能撤销）';
$string['deleteallcomments'] = '删除所有评论';
$string['deleteallratings'] = '删除所有评分';
$string['deletecategory'] = '删除课程类别：{$a}';
$string['deletecategorycheck'] = '您确定要完全删除类别<b>“{$a}”</b>么?<br />此类别中的所有课程将会被移动到父类别或类别“五花八门”中。';
$string['deletecategorycheck2'] = '如果删除此课程类别，您必须选择该类别下的课程和子类别的处理办法。';
$string['deletecategoryempty'] = '此分类为空';
$string['deletecheck'] = '删除{$a}吗?';
$string['deletecheckfiles'] = '您真的确定要彻底删除这些文件?';
$string['deletecheckfull'] = '您真的确定要彻底删除{$a}吗，包括其注册信息，活动，以及其他用户信息？';
$string['deletechecktype'] = '您确定要删除{$a->type}？';
$string['deletechecktypename'] = '您确定要删除{$a->type}“{$a->name}”吗？';
$string['deletecheckwarning'] = '您打算删除这些文件';
$string['deletecommentbyon'] = '删除{$a->user}在{$a->time}发表的评论';
$string['deletecompletely'] = '彻底删除';
$string['deletecourse'] = '删除一个课程';
$string['deletecoursecheck'] = '您真的确定要彻底删除该课程及其所有文件资料吗?';
$string['deleted'] = '已经删除';
$string['deletedactivity'] = '已经删除{$a}';
$string['deletedcourse'] = '{$a}已经被彻底删除';
$string['deletednot'] = '无法删除{$a}!';
$string['deletepicture'] = '删除图片';
$string['deletesection'] = '删除小节';
$string['deleteselected'] = '删除选定的项';
$string['deleteselectedkey'] = '删除选定的key';
$string['deletingcourse'] = '正在删除{$a}';
$string['deletingexistingcoursedata'] = '删除已存在的课程数据';
$string['deletingolddata'] = '删除旧数据';
$string['department'] = '系别';
$string['deprecatedeventname'] = '{$a} （不再使用）';
$string['desc'] = '降序';
$string['description'] = '描述';
$string['descriptiona'] = '描述: {$a}';
$string['deselectall'] = '全不选';
$string['deselectnos'] = '取消全不选';
$string['detailedless'] = '少些细节';
$string['detailedmore'] = '多些细节';
$string['details'] = '详情';
$string['digitalminor'] = '未达到数字承诺年龄';
$string['digitalminor_desc'] = '请让您的父母/监护人联系:';
$string['directory'] = '字典';
$string['disable'] = '禁用';
$string['disabledcomments'] = '评论被禁止';
$string['dismissnotification'] = '‎关闭此通知‎';
$string['displayingfirst'] = '只显示第一个{$a->count} {$a->things}';
$string['displayingrecords'] = '显示{$a}条记录';
$string['displayingusers'] = '从{$a->start}到{$a->end}显示用户';
$string['displayonpage'] = '在页面显示';
$string['dndcourse'] = '你可以用拖动这一课程来改变它的排列顺序，或是把它移到另一个类别中。';
$string['dndenabled_inbox'] = '您可以通过拖放文件到此处来添加文件。';
$string['dndnotsupported'] = '不支持拖曳';
$string['dndnotsupported_help'] = '你的浏览器不支持以拖曳方式上传文件。这一功能在所有当前版本的Chrome，Firefox 和 Safari，以及 Internet Explorer v10 以上都可以使用。';
$string['dndnotsupported_insentence'] = '不支持拖曳';
$string['dnduploadwithoutcontent'] = '没有上传任何内容';
$string['dndworkingfile'] = '通过拖放文件到课程小节进行上传';
$string['dndworkingfilelink'] = '通过拖放文件或链接到课程小节进行上传';
$string['dndworkingfiletext'] = '通过拖放文件或文本到课程小节进行上传';
$string['dndworkingfiletextlink'] = '通过拖放文件，文本或链接到课程小节进行上传';
$string['dndworkinglink'] = '通过拖放链接到课程小节进行上传';
$string['dndworkingtext'] = '通过拖放文本到课程小节进行上传';
$string['dndworkingtextlink'] = '通过拖放文本或链接到课程小节进行上传';
$string['documentation'] = 'Moodle文档';
$string['dontsortcategories'] = '不要将类别排序';
$string['dontsortcourses'] = '不要将课程排序';
$string['down'] = '向下';
$string['download'] = '下载';
$string['downloadall'] = '全部下载';
$string['downloadexcel'] = '以Excel文件格式下载';
$string['downloadfile'] = '下载文件';
$string['downloadods'] = '以ODS格式下载';
$string['downloadtext'] = '以纯文本格式下载';
$string['doyouagree'] = '您已经阅读并理解了这些条件吗?';
$string['droptoupload'] = '拖放文件到此处进行上传';
$string['duplicate'] = '复制';
$string['duplicatedmodule'] = '{$a} (复制)';
$string['edhelpaspellpath'] = '要在编辑器中使用拼写检查功能，您必须在服务器上安装<strong>aspell 0.50</strong>或其更高版本，并且还要正确地指定aspell程序的路径。在Unix/Linux系统上通常是<strong>/usr/bin/aspell</strong>，当然也可能是其它地方。';
$string['edhelpbgcolor'] = '定义可编辑区域的背景颜色。<br />可以使用如下合法的值: #ffffff 或 white';
$string['edhelpcleanword'] = '这个项目激活或关闭Word相关的格式过滤。';
$string['edhelpenablespelling'] = '激活或关闭拼写检查。当激活时，服务器上必须已经安装了<strong>aspell</strong>。第二个参数是<strong>缺省字典</strong>。它将会在aspell没有用户所用语言的字典时使用。';
$string['edhelpfontfamily'] = '字体属性是一系列具体的或通用字体名称的列表。字体名称必须以半角逗号分隔。';
$string['edhelpfontlist'] = '定义在编辑器的下拉菜单中使用的字体。';
$string['edhelpfontsize'] = '缺省的字号设定了字体的大小。<br />合法的值如下: medium、large、smaller、lager、10pt、11px。';
$string['edit'] = '编辑';
$string['edita'] = '编辑{$a}';
$string['editcategorysettings'] = '编辑类别设置';
$string['editcategorythis'] = '编辑该类别';
$string['editcoursesettings'] = '编辑课程设定';
$string['editfiles'] = '编辑文件';
$string['editgroupprofile'] = '编辑组';
$string['editinga'] = '编辑{$a}';
$string['editingteachershort'] = '编辑器';
$string['editlock'] = '不能修改这个值!';
$string['editmode'] = '编辑模式';
$string['editmyprofile'] = '编辑个人资料';
$string['editorbgcolor'] = '背景颜色';
$string['editorcleanonpaste'] = '在粘贴时净化Word HTML';
$string['editorcommonsettings'] = '一般设置';
$string['editordefaultfont'] = '缺省字体';
$string['editorenablespelling'] = '激活拼写检查';
$string['editorfontlist'] = '字体列表';
$string['editorfontsize'] = '缺省字号';
$string['editorpreferences'] = '编辑器选项';
$string['editorresettodefaults'] = '重设为缺省设置';
$string['editorsettings'] = '编辑器设置';
$string['editorshortcutkeys'] = '编辑器快捷键';
$string['editsection'] = '编辑区';
$string['editsectionname'] = '编辑章节名称';
$string['editsettings'] = '更改设置';
$string['editsummary'] = '编辑概要';
$string['editthisactivity'] = '编辑这个活动项目';
$string['editthiscategory'] = '编辑该类别';
$string['edittitle'] = '编辑标题';
$string['edittitleinstructions'] = '按 Esc 键取消，完成请按回车键';
$string['edituser'] = '编辑用户帐号';
$string['edulevel'] = '所有活动';
$string['edulevel_help'] = '* 教学 - 由教师执行的动作，例如 更新资源
* 参与 - 学生执行的动作，例如 在论坛中发帖
* 其他 - 由具有非教师或学生角色的用户执行的操作';
$string['edulevelother'] = '其它';
$string['edulevelparticipating'] = '参加';
$string['edulevelteacher'] = '授课';
$string['email'] = '电子邮件地址';
$string['emailactive'] = 'Email已激活';
$string['emailagain'] = '电子邮件(重复)';
$string['emailalreadysent'] = '一封重置密码的邮件已经发出。请检查您的邮箱。';
$string['emailcharset'] = 'Email字符集';
$string['emailconfirm'] = '确认您的帐号';
$string['emailconfirmation'] = '您好：

刚才您用您的电子邮箱地址在“{$a->sitename}”上申请了一个新帐号。

如果要确认您的新帐号，请点击以下链接：

{$a->link}

在多数的邮件软件中，这个地址应该显示为蓝色的链接，可以直接点击。如果不是这样，请将以上地址复制粘贴到网页浏览器窗口上部的地址栏中，打开这个网页。

如果您需要帮助，请联系网站管理员，{$a->admin}';
$string['emailconfirmationresend'] = '重新发送确认电子邮件';
$string['emailconfirmationsubject'] = '{$a}: 帐号确认';
$string['emailconfirmsent'] = '<p>一封邮件已经发送到您的地址 <b>{$a}</b>。</p>
<p>这封邮件简要说明了您如何完成注册。</p>
<p>如果您还遇到什么困难，请和站点管理员联系。</p>';
$string['emailconfirmsentfailure'] = '确认邮件发送失败';
$string['emailconfirmsentsuccess'] = '确认邮件发送成功';
$string['emaildigest'] = 'Email摘要类型';
$string['emaildigest_help'] = '这是论坛默认使用的每日摘要设置。

* 没有摘要 - 你将会收到每个论坛帖子所对应的一封邮件。
* 摘要 - 完整的帖子 - 你将会每天收到一封摘要邮件，里面包含每个论坛帖子的完整内容；
* 摘要 - 只包含主题 - 你将会每天收到一封摘要邮件，里面只包含每个论坛帖子的主题。

如果你愿意，你也可以为每一个论坛选择不同的设置。';
$string['emaildigestcomplete'] = '完整的(每天一封，包含完整内容)';
$string['emaildigestoff'] = '无摘要(每个帖子发送一封Email)';
$string['emaildigestsubjects'] = '主题(每天一封，只包含主题)';
$string['emaildisable'] = '这个email地址已禁用';
$string['emaildisableclick'] = '点击此处不再向此地址发送任何邮件';
$string['emaildisplay'] = '显示Email';
$string['emaildisplay_help'] = '特权用户（例如教师或管理员）将看到您的邮箱地址。';
$string['emaildisplaycourse'] = '仅允许其他课程参与者查看我的电子邮件地址';
$string['emaildisplaycoursemembersonly'] = '(对课程其它参与者可见)';
$string['emaildisplayeveryone'] = '(对所有人可见)';
$string['emaildisplayhide'] = '(对所有非特权用户隐藏)';
$string['emaildisplayno'] = '对无权限用户隐藏我的电子邮件地址';
$string['emaildisplayyes'] = '允许所有人看到我的email地址';
$string['emailenable'] = '该email地址已激活';
$string['emailenableclick'] = '点击此处重新允许向此地址发送email';
$string['emailexists'] = '该email地址已经注册过了。';
$string['emailexistshintlink'] = '找回忘记的用户名或密码';
$string['emailexistssignuphint'] = '您可能之前已创建过账号？{$a}';
$string['emailformat'] = 'Email格式';
$string['emailmustbereal'] = '注意：您的Email地址必须是真实的';
$string['emailnotallowed'] = '禁止使用如下域名的Email地址：({$a})';
$string['emailnotfound'] = '数据库中未找到此Email';
$string['emailonlyallowed'] = '此Email不在允许的域名中: ({$a})';
$string['emailpasswordchangeinfo'] = '{$a->firstname}，您好:

有人(一般情况下是您自己)为您在“{$a->sitename}”上的帐号  \'{$a->username}\' 申请了新的密码。

要修改密码，请访问以下链接：

{$a->link}

在大多数的邮件程序中，此地址应该显示为蓝色的链接，可以直接点击。如果不是这样，请将以上地址复制粘贴到网页浏览器窗口上部的地址栏中，打开这个网页。

如果您需要帮助，请联系网站管理员，{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = '{$a->firstname}您好：

有人（可能是您本人）从\'{$a->sitename}\'请求获得密码。

但是很抱歉您的帐号已被禁用并且无法重置。请与管理员{$a->admin}联系。';
$string['emailpasswordchangeinfofail'] = '{$a->firstname}，您好，

有人（可能是您本人）为您在“{$a->sitename}”的账号请求换个新密码。

但很遗憾，此网站上的密码不能重置。如果您需要其他帮助，请联系网站管理员，
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}：确定改变密码';
$string['emailpasswordconfirmation'] = '{$a->firstname}，您好:

有人(一般情况下是您自己)为您在“{$a->sitename}”上的帐号申请了新的密码。

如果您确认这是您做的，并想通过email获得新密码，请点击以下链接:

{$a->link}

在多数的邮件软件中，这个地址应该显示为蓝色的链接，可以直接点击。如果不是这样，请将以上地址复制粘贴到网页浏览器窗口上部的地址栏中，打开这个网页。

如果您需要帮助，请联系网站管理员，{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: 确认修改密码';
$string['emailpasswordconfirmmaybesent'] = '<p>如果您提供了正确的用户名或没有重复的电子邮件地址，那么一封电子邮件已经发送给您。</p>
<p>它指导您如何确认和完成对密码的修改，这个过程很简单。如果您还是遇到了困难，请联系网站管理员。</p>';
$string['emailpasswordconfirmnoemail'] = '<p>您指定的用户帐号没有登记电子邮件地址。</p>
<p>请联系网站管理员</p>';
$string['emailpasswordconfirmnotsent'] = '<p>您所提供的用户资料，无法对应到一个现有的用户帐号。</p>
<p>请检查您输入的资料，然后再试一次。若您还是有困难，请联系网站管理员。</p>';
$string['emailpasswordconfirmsent'] = '一封Email已经发往您的地址<b>{$a}</b>。
<br />其中有关于如何确认并完成本次密码更改的简单说明。
如果您还是遇到困难，请联系网站管理员。';
$string['emailpasswordsent'] = '谢谢，您已经确认了密码更改。
一封包含新密码的邮件已经发往您的邮箱<br /><b>{$a->email}</b>。<br />
这个新密码是自动生成的――您可能会想将它<a href="{$a->link}">更改<a>为一个更容易记住的密码。';
$string['emailresetconfirmation'] = '嗨 {$a->firstname}，您好！

我们收到您在 {$a->sitename}的\'{$a->username}\' 账号的重置密码的请求。

为了确认这个请求，并为您的账号设定一个新密码，请访问下面的网址：

{$a->link}
(此链接只有在提交重置密码请求后 {$a->resetminutes} 分钟之内有效)

假如这次密码重置请求不是您提交的，请不要做任何动作。

若您需要帮助请与管理员联系：{$a->admin}。';
$string['emailresetconfirmationsubject'] = '{$a}:重置密码请求';
$string['emailresetconfirmsent'] = '一封电子邮件已经发送到您的邮箱： <b>{$a}</b>。
<br />它包含一些简单的指引以便确认并完成密码的修改。
若您仍然有困难，请与站点管理员联系。';
$string['emailstop'] = '禁用通知';
$string['emailtoprivatefiles'] = '你也能把文件作为附件直接用电子邮件发送到你的私人文件空间。只需在电子邮件内附上文件并发送到 {$a}';
$string['emailtoprivatefilesdenied'] = '用电子邮件上传你的私人文件这一选项已被管理员禁止。';
$string['emailvia'] = '{$a->name} (通过 {$a->siteshortname})';
$string['emojicategoryactivities'] = '活动';
$string['emojicategoryanimalsnature'] = '动物 & 自然';
$string['emojicategoryflags'] = '标志';
$string['emojicategoryfooddrink'] = '食物 & 饮料';
$string['emojicategoryobjects'] = '物体';
$string['emojicategorypeoplebody'] = '人与身体';
$string['emojicategoryrecent'] = '最近';
$string['emojicategorysmileysemotion'] = '微笑与情感';
$string['emojicategorysymbols'] = '符号';
$string['emojicategorytravelplaces'] = '旅行 & 地点';
$string['emptycmids'] = '空白的课程模块编号';
$string['emptydragdropregion'] = '空白区域';
$string['emptysectionids'] = '空白的小节编号';
$string['enable'] = '使用';
$string['encryptedcode'] = '加密代码';
$string['enddate'] = '课程结束日期';
$string['enddate_help'] = '课程结束日期用于确定是否将该课程加入到用户课程表中。当课程结束日期已过，该课程不会在导航栏中列出，同时会在课程概览中列为历史课程。课程结束日期也可用于定制报表。 用户仍然可在课程结束日期后进入课程，即结束日期并不限制用户访问。';
$string['english'] = '英语';
$string['enrolmentmethods'] = '选修方法';
$string['entercourse'] = '点击进入该课程';
$string['enteremail'] = '输入您的 Email 地址';
$string['enteremailaddress'] = '输入您的Email地址以重设密码，新密码将送到您的信箱中。';
$string['enterusername'] = '输入您的用户名';
$string['entries'] = '条目';
$string['error'] = '错误';
$string['errorcreatingactivity'] = '无法创建活动“{$a}”的实例';
$string['errorfiletoobig'] = '此文件大于 {$a} 字节的尺寸限制';
$string['errornouploadrepo'] = '此网站没有启用上传容器';
$string['errorwhenconfirming'] = '因为发生错误，您的身份还未被确认。如果您是通过点击email中的一个链接来到的这里，请确认您email里的链接没有损坏或被自动换行。您可以通过拷贝和粘贴来重构正确的链接。';
$string['eventcommentcreated'] = '评论已创建';
$string['eventcommentdeleted'] = '评论已删除';
$string['eventcommentsviewed'] = '查看了评论';
$string['eventconfiglogcreated'] = '创建了配置日志';
$string['eventcontentviewed'] = '浏览了内容';
$string['eventcoursebackupcreated'] = '创建了课程备份';
$string['eventcoursecategorycreated'] = '创建了类别';
$string['eventcoursecategorydeleted'] = '删除了类别';
$string['eventcoursecategoryupdated'] = '更新了类别';
$string['eventcoursecategoryviewed'] = '查看了类别';
$string['eventcoursecontentdeleted'] = '删除了课程内容';
$string['eventcoursecreated'] = '建立了课程';
$string['eventcoursedeleted'] = '删除了课程';
$string['eventcourseinformationviewed'] = '查看了课程简介';
$string['eventcoursemodulecreated'] = '建立了课程模块';
$string['eventcoursemoduledeleted'] = '删除了课程模块';
$string['eventcoursemoduleinstancelistviewed'] = '查看了课程模块实例列表';
$string['eventcoursemoduleupdated'] = '更新了课程模块';
$string['eventcoursemoduleviewed'] = '查看了课程模块';
$string['eventcourseresetended'] = '结束了课程重置';
$string['eventcourseresetstarted'] = '开始了课程重置';
$string['eventcourserestored'] = '恢复了课程';
$string['eventcoursesectioncreated'] = '创建了课程小节';
$string['eventcoursesectiondeleted'] = '删除了课程小节';
$string['eventcoursesectionupdated'] = '更新了课程小节';
$string['eventcoursessearched'] = '搜索了课程';
$string['eventcourseupdated'] = '更新了课程';
$string['eventcourseuserreportviewed'] = '查看了课程用户报告';
$string['eventcourseviewed'] = '查看了课程';
$string['eventdashboardreset'] = '重置了仪表盘';
$string['eventdashboardsreset'] = '重置了仪表盘';
$string['eventdashboardviewed'] = '查看了仪表盘';
$string['eventdatabasetextfieldcontentreplaced'] = '数据库全局搜索和替换';
$string['eventemailfailed'] = '邮件发送失败';
$string['eventmycoursesviewed'] = '我浏览过的课程';
$string['eventname'] = '事件名称';
$string['eventrecentactivityviewed'] = '查看了最近活动';
$string['eventsearchindexed'] = '索引了搜索数据';
$string['eventsearchresultsviewed'] = '查看了搜索结果';
$string['eventunknownlogged'] = '未知事件';
$string['eventusercreated'] = '建立了用户';
$string['eventuserdeleted'] = '删除了用户';
$string['eventuserfeedbackgiven'] = '单击反馈链接';
$string['eventuserfeedbackremind'] = '单击稍后提醒反馈连接';
$string['eventuserinfocategorycreated'] = '创建了用户个人档案字段类别';
$string['eventuserinfocategorydeleted'] = '删除了用户个人档案字段类别';
$string['eventuserinfocategoryupdated'] = '更新了用户个人档案字段类别';
$string['eventuserinfofieldcreated'] = '创建了用户个人档案字段';
$string['eventuserinfofielddeleted'] = '删除了用户个人档案字段';
$string['eventuserinfofieldupdated'] = '更新了用户个人档案字段';
$string['eventuserlistviewed'] = '查看用户列表';
$string['eventuserloggedout'] = '用户退出了';
$string['eventuserpasswordpolicyfailed'] = '用户密码失效策略';
$string['eventuserpasswordupdated'] = '修改了用户密码';
$string['eventuserprofileviewed'] = '浏览了用户个人档案';
$string['eventuserupdated'] = '更新了用户';
$string['everybody'] = '所有人';
$string['executeat'] = '执行';
$string['existing'] = '已有';
$string['existingadmins'] = '现有网站管理员';
$string['existingcourse'] = '现有课程';
$string['existingcourseadding'] = '现有课程，向其中添加数据';
$string['existingcoursedeleting'] = '现有课程，先删除它';
$string['existingcreators'] = '现有课程管理员';
$string['existingstudents'] = '已选课学生';
$string['existingteachers'] = '现有教师';
$string['expand'] = '展开';
$string['expandall'] = '展开全部';
$string['expandcategory'] = '展开 {$a}';
$string['explanation'] = '解释';
$string['explanationdigitalminor'] = '需要此信息来确定您的年龄是否达到数字承诺年龄。这是个人可以同意条款和条件及其数据被合法存储和处理的年龄。';
$string['extendperiod'] = '延长选课';
$string['extendsession'] = '延长会话';
$string['failedloginattempts'] = '从您上次登录后共有{$a->attempts}次失败的登录尝试。';
$string['favourites'] = '标星的';
$string['feedback'] = '反馈';
$string['file'] = '文件';
$string['fileexists'] = '已经有名为 {$a} 的文件';
$string['filemissing'] = '找不到文件 {$a}';
$string['filereaderror'] = '无法读取文件  \'{$a}\'。请检查它确实是文件而非文件夹。';
$string['files'] = '文件';
$string['filesanduploads'] = '文件上传';
$string['filesfolders'] = '文件/文件夹';
$string['fileuploadwithcontent'] = '不能在文件上传中包含内容参数';
$string['filloutallfields'] = '请填完这个表单的所有空格';
$string['filter'] = '过滤';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = '筛选条件';
$string['findmorecourses'] = '查询更多课程...';
$string['first'] = '首次';
$string['firstaccess'] = '首次访问';
$string['firstname'] = '名';
$string['firstnamephonetic'] = '名（拼音）';
$string['firstpage'] = '首页';
$string['firstsiteaccess'] = '首次站点访问';
$string['firsttime'] = '这是您第一次来这里吗?';
$string['folder'] = '文件夹';
$string['folderclosed'] = '关闭文件夹';
$string['folderopened'] = '打开文件夹';
$string['followingoptional'] = '以下为可选项';
$string['followingrequired'] = '以下项目是必需的';
$string['for'] = '为';
$string['force'] = '强制';
$string['forcelanguage'] = '指定课程语言类型';
$string['forceno'] = '不强制';
$string['forcepasswordchange'] = '强制修改密码';
$string['forcepasswordchange_help'] = '如果此复选框被勾选，那么用户在下次登录时会被要求修改密码';
$string['forcepasswordchangecheckfull'] = '您十分确定要将密码强行改为 {$a} 吗？';
$string['forcepasswordchangenot'] = '不能强制将密码改为 {$a}';
$string['forcepasswordchangenotice'] = '您必须更改密码才能继续。';
$string['forcepasswordresetfailurenotice'] = '你当前的密码不符合密码设置策略。请联系Moodle管理员以获取帮助。
 {$a}';
$string['forcepasswordresetnotice'] = '你当前的密码不符合密码设置策略，你必须重置密码才能登录。
 {$a}';
$string['forcetheme'] = '强制使用主题';
$string['forgotaccount'] = '忘记了密码？';
$string['forgotten'] = '忘记用户名或密码了?';
$string['forgottenduplicate'] = '该邮件地址已被几个账户使用了，请键入用户名来代替。';
$string['forgotteninvalidurl'] = '无效的重置密码链接';
$string['format'] = '格式';
$string['format_help'] = '课程格式确定了课程页面的布局。

* 单一活动格式 - 用于在课程页面上显示单个活动或资源（例如测验或SCORM包）
* 社交格式 - 论坛显示在课程页面上
* 主题格式 - 课程页面按主题部分组织
* 每周格式 - 课程页面按每周部分组织，第一周从课程开始日期开始';
$string['formathtml'] = 'HTML格式';
$string['formatmarkdown'] = 'Markdown格式';
$string['formatplain'] = '纯文本格式';
$string['formattext'] = 'Moodle自动格式';
$string['forumpreferences'] = '讨论区选项';
$string['framesetinfo'] = '本框架文档包括';
$string['from'] = '开始时间';
$string['frontpagecategorycombo'] = '组合列表';
$string['frontpagecategorynames'] = '显示类别列表';
$string['frontpagecourselist'] = '显示课程列表';
$string['frontpagecoursesearch'] = '课程搜索';
$string['frontpagedescription'] = '首页描述';
$string['frontpagedescriptionhelp'] = '此描述将显示在课程或站点描述区域的首页。';
$string['frontpageenrolledcourselist'] = '已参与的课程';
$string['frontpageformat'] = '首页格式';
$string['frontpageformatloggedin'] = '登录后的首页格式';
$string['frontpagenews'] = '新闻公告';
$string['frontpagesettings'] = '首页设置';
$string['fulllistofcourses'] = '所有课程';
$string['fullname'] = '全名';
$string['fullnamecourse'] = '课程全称';
$string['fullnamecourse_help'] = '课程全称会显示在课程的页面顶端和课程列表中。';
$string['fullnamedisplay'] = '{$a->lastname}{$a->firstname}';
$string['fullnameuser'] = '用户全名';
$string['fullprofile'] = '个人详细资料';
$string['fullsitename'] = '网站全称';
$string['functiondisabled'] = '那个功能现在是关闭的';
$string['general'] = '常规项';
$string['geolocation'] = '维度—经度';
$string['gettheselogs'] = '获取这些日志';
$string['go'] = '继续';
$string['gpl'] = '版权所有 (C) 1999及以后  Martin Dougiamas  (http://moodle.com)

该系统是自由软件；您可以按照自由软件基金会所公布的GNU通用公共许可证(GPL)进行修改或重新发布；许可证可以是第2版或（由您决定）更新的版本。

发布该软件是希望它有用有益，但不提供任何形式的担保，不论是明确的还是隐含的，包括但不限于可销售和适合特定用途的隐含保证。

查看Moodle许可证信息页了解详情：http://docs.moodle.org/en/License';
$string['gpl3'] = '版权所有 (C) 1999及以后  Martin Dougiamas  (http://moodle.com)

该系统是自由软件；您可以按照自由软件基金会所公布的GNU通用公共许可证(GPL)进行修改或重新发布；许可证可以是第3版或（由您决定）更新的版本。

发布该软件是希望它有用有益，但不提供任何形式的担保，不论是明确的还是隐含的，包括但不限于可销售和适合特定用途的隐含保证。

查看Moodle许可证信息页了解详情：http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL许可证';
$string['grade'] = '成绩';
$string['gradenoun'] = '成绩';
$string['grades'] = '成绩';
$string['gradeverb'] = '成绩';
$string['gravatarenabled'] = '本站支持<a href="http://www.gravatar.com/">Gravatar</a> 。如果您不上传头像，Moodle将会尝试从Gravatar加载头像。';
$string['group'] = '小组';
$string['groupadd'] = '添加新组';
$string['groupaddusers'] = '添加所选的到组';
$string['groupfor'] = '为组';
$string['groupinfo'] = '所选组信息';
$string['groupinfoedit'] = '修改组设置';
$string['groupinfomembers'] = '所选成员信息';
$string['groupinfopeople'] = '所选人信息';
$string['groupmembers'] = '组员';
$string['groupmemberssee'] = '查看组员';
$string['groupmembersselected'] = '选定的组的成员';
$string['groupmode'] = '小组模式';
$string['groupmodeforce'] = '强制小组模式';
$string['groupmy'] = '我的组';
$string['groupnonmembers'] = '不属于某组的用户';
$string['groupnotamember'] = '很抱歉，您不是那个组的成员';
$string['grouprandomassign'] = '随机分配所有人到组';
$string['groupremove'] = '删除选定的组';
$string['groupremovemembers'] = '删除选定的成员';
$string['groups'] = '小组';
$string['groupsnone'] = '无小组';
$string['groupsseparate'] = '分隔小组';
$string['groupsvisible'] = '可视小组';
$string['guest'] = '访客';
$string['guestdescription'] = '访客拥有最小的权限，而且通常不能在任何地方输入文本。';
$string['guestskey'] = '允许有密钥的访客进入';
$string['guestsno'] = '不允许访客进入';
$string['guestsnotallowed'] = '很抱歉，“{$a}”不允许访客进入。';
$string['guestsyes'] = '允许没有密钥的访客进入';
$string['guestuser'] = '访客用户';
$string['guestuserinfo'] = '该用户是个特殊用户，允许以只读方式参观一些课程。';
$string['help'] = '帮助';
$string['helpprefix2'] = '关于“{$a}”的帮助';
$string['helpwiththis'] = '帮助';
$string['hiddenassign'] = '隐藏作业';
$string['hiddenfromstudents'] = '对学生隐藏';
$string['hiddenoncoursepage'] = '可用，但不显示在课程页面';
$string['hiddensections'] = '隐藏小节';
$string['hiddensections_help'] = '隐藏的小节是向学生折叠显示（比如在星期格式的课程中表示假期）还是完全隐藏。';
$string['hiddensectionscollapsed'] = '隐藏的小节会显示为不可用';
$string['hiddensectionsinvisible'] = '完全不显示隐藏的小节';
$string['hiddenwithbrackets'] = '(隐藏的)';
$string['hide'] = '隐藏';
$string['hideadvancedsettings'] = '隐藏高级设置';
$string['hidechartdata'] = '隐藏图表数据';
$string['hidefromstudents'] = '对学生隐藏';
$string['hideoncoursepage'] = '标记为可用但不在课程页面显示';
$string['hidepicture'] = '隐藏图片';
$string['hidepopoverwindow'] = '隐藏弹窗';
$string['hidesection'] = '隐藏小节{$a}';
$string['hidesettings'] = '隐藏设置';
$string['hideshowblocks'] = '隐藏或显示版块';
$string['highlight'] = '高亮显示当前主题';
$string['highlighted'] = '高亮';
$string['highlightoff'] = '取消高亮显示';
$string['hits'] = '点击次数';
$string['hitsoncourse'] = '用户{$a->username}浏览了{$a->coursename}';
$string['hitsoncoursetoday'] = '今天用户{$a->username}浏览了{$a->coursename}';
$string['home'] = '首页';
$string['homeheader'] = '主页目录';
$string['hour'] = '小时';
$string['hours'] = '小时';
$string['howtomakethemes'] = '如何创建新的主题风格';
$string['htmleditor'] = '使用 HTML 编辑器';
$string['htmleditoravailable'] = 'HTML编辑器可用';
$string['htmleditordisabled'] = '您在个人资料项里关闭了HTML编辑器';
$string['htmleditordisabledadmin'] = '网站管理员已将本站的文本格式编辑器关闭了';
$string['htmleditordisabledbrowser'] = 'HTML编辑器不可用，因为您的浏览器不能支持它。';
$string['htmlfilesonly'] = '仅HTML文件';
$string['htmlformat'] = '美化的HTML格式';
$string['icon'] = '图标';
$string['icqnumber'] = 'ICQ号码';
$string['idnumber'] = '学号';
$string['idnumbercourse'] = '课程编号';
$string['idnumbercourse_help'] = '课程的编号用于和外部系统匹配——它从不显示于Moodle的内部。如果您的课程有一个正式的编号，可以在这里使用它，否则您可以空着它。';
$string['idnumbercoursecategory'] = '分类ID';
$string['idnumbercoursecategory_help'] = '课程分类的ID号只用来和外部系统匹配，不会在网站的任何地方显示。如果此分类有官方编号，可以在此输入，否则可以留空。';
$string['idnumbergroup'] = '小组 ID 编号';
$string['idnumbergroup_help'] = '一个小组的ID编号只是用来和外部系统对应，不会在网站的任何地方显示。如果此小组有公共编号的话，可以在此输入，否则此处留空。';
$string['idnumbergrouping'] = '大组 ID 编号';
$string['idnumbergrouping_help'] = '一个大组的ID编号只是用来和外部系统对应，不会在网站的任何地方显示。如果此大组有公共编号的话，可以在此输入，否则此处留空。';
$string['idnumbermod'] = 'ID号';
$string['idnumbermod_help'] = '设置一个ID号标识活动或资源，可用于成绩计算或自定义报表。如不需要可以留空。

对于可评分的活动，成绩册中也可设置ID号，但只可以在活动设置页面进行编辑。';
$string['idnumbertaken'] = '该ID已使用';
$string['imagealt'] = '图片描述';
$string['import'] = '导入';
$string['importdata'] = '导入课程数据';
$string['importdataexported'] = '从“源”课程成功导出数据。<br />继续向“目标”课程导入。';
$string['importdatafinished'] = '导入完成! 继续您的课程';
$string['importdatafrom'] = '找到一个做为导入源的课程：';
$string['inactive'] = '不活跃的';
$string['include'] = '包括';
$string['includeallusers'] = '包含所有用户';
$string['includecoursefiles'] = '包含课程文件';
$string['includecourseusers'] = '包含课程用户';
$string['included'] = '被包括';
$string['includelogentries'] = '包含日志条目';
$string['includemodules'] = '包含模块';
$string['includemoduleuserdata'] = '包括模块用户数据';
$string['includeneededusers'] = '包含需要的用户';
$string['includenoneusers'] = '不包含任何用户';
$string['includeroleassignments'] = '包含角色分配';
$string['includesitefiles'] = '包含课程中使用的站点文件';
$string['includeuserfiles'] = '包含用户文件';
$string['increasesections'] = '增加小节的数量';
$string['indicator:accessesafterend'] = '课程结束后访问课程';
$string['indicator:accessesafterend_help'] = '这个指标反映学生是否在课程结束日期之后访问了该课程。';
$string['indicator:accessesbeforestart'] = '课程开始前访问课程';
$string['indicator:accessesbeforestart_help'] = '这个指标反映了学生是否在课程开始日期之前就访问了该课程。';
$string['indicator:activitiesdue'] = '活动到期';
$string['indicator:activitiesdue_help'] = '用户有活动到期。';
$string['indicator:anycourseaccess'] = '任何课程访问';
$string['indicator:anycourseaccess_help'] = '‎此指标反映用户对已加入的任何课程的访问。 ‎';
$string['indicator:anywrite'] = '任何写操作';
$string['indicator:anywrite_help'] = '此指标表示学生采取的任何写(提交)操作。';
$string['indicator:anywriteincourse'] = '课程中的任何写操作';
$string['indicator:anywriteincourse_help'] = '此指标表示学生在任何课程活动中采取的任何写(提交)操作。';
$string['indicator:completeduserprofile'] = '用户档案已完善';
$string['indicator:completeduserprofile_help'] = '这个指标表示学生已完善了其用户个人档案。';
$string['indicator:completeduserprofiledef'] = '用户完善了个人档案';
$string['indicator:completeduserprofiledef_help'] = '已同意网站政策，用户已填写以下字段：机构、部门、地址、城市、国家、URL。';
$string['indicator:completionenabled'] = '‎已启用进度跟踪‎';
$string['indicator:completionenabled_help'] = '这个指标表示这门课程已经启用了进度跟踪。';
$string['indicator:nostudent'] = '学生选课';
$string['indicator:nostudent_help'] = '该指标反映了课程中学生的可选择性。';
$string['indicator:noteacher'] = '可选教师';
$string['indicator:noteacher_help'] = '这个指标反映了这门课教师的可选择性。';
$string['indicator:potentialcognitive'] = '课程潜在的认知深度';
$string['indicator:potentialcognitive_help'] = '这一指标是基于学生参与课程活动所能达到的潜在认知深度。';
$string['indicator:potentialcognitivedef'] = '课程潜在认知深度';
$string['indicator:potentialcognitivedef_help'] = '课程提供“深度”认知参与的程度，例如提交工作以获得反馈、有机会回顾他人的工作、有机会修改和重新提交工作。';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = '课程潜在的社会广度';
$string['indicator:potentialsocial_help'] = '这一指标是基于学生参与课程活动所能达到的潜在社会广度。';
$string['indicator:potentialsocialdef'] = '课程潜在的社会广度';
$string['indicator:potentialsocialdef_help'] = '课程提供“广泛”社会参与的程度，与其他成员和课外实践社区互动。';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = '读操作数量';
$string['indicator:readactions_help'] = '这个指标表示学生执行读(浏览)操作的数量。';
$string['indicator:userforumstracking'] = '用户正在跟踪论坛';
$string['indicator:userforumstracking_help'] = '该指标表示该学生是否在讨论区中打开了跟踪功能。';
$string['info'] = '信息';
$string['inprogress'] = '进行中';
$string['institution'] = '机构';
$string['instudentview'] = '在学生视图中';
$string['interests'] = '兴趣';
$string['interestslist'] = '兴趣列表';
$string['interestslist_help'] = '逐一输入您的兴趣，它们将作为标签显示在您的个人资料页面上。';
$string['invalidemail'] = '无效的电子邮件地址';
$string['invalidlogin'] = '登录无效，请重试';
$string['invalidusername'] = '用户名只能包含数字、小写字母、下划线（_）、横线（-）、小数点（.）或艾特符号（@）';
$string['invalidusernameupload'] = '无效的用户名';
$string['ip_address'] = 'IP地址';
$string['jump'] = '跳';
$string['jumpto'] = '跳至...';
$string['keep'] = '保持';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = '文字书写方向从左到右';
$string['langrtl'] = '文字书写方向从右到左';
$string['language'] = '语言';
$string['languagegood'] = '该语言包是最新的! :-)';
$string['languageselector'] = '语言选择器';
$string['last'] = '最近';
$string['lastaccess'] = '上次访问';
$string['lastcourseaccess'] = '最近课程访问';
$string['lastedited'] = '最近编辑';
$string['lastip'] = '上一回IP地址';
$string['lastlogin'] = '最近登录';
$string['lastmodified'] = '最后修改';
$string['lastname'] = '姓氏';
$string['lastnamephonetic'] = '姓（拼音）';
$string['lastpage'] = '最后一页';
$string['lastsiteaccess'] = '最近站点访问';
$string['lastyear'] = '去年';
$string['latestlanguagepack'] = '从moodle.org检查有无最新的语言包';
$string['layouttable'] = '布局表';
$string['leavetokeep'] = '留空以保留现有密码';
$string['legacylogginginuse'] = '这个站点当前正在使用遗留的日志存储，这种日志存储方式已经被抛弃，请将日志写入受支持的日志存储中，比如：标准（standard）或者外部（external）。';
$string['legacythemeinuse'] = '因为您的浏览器版本太老了，所以本站将在兼容模型下显示。';
$string['license'] = '许可证';
$string['licenses'] = '许可证';
$string['liketologin'] = '您希望现在以注册用户帐号登录么？';
$string['list'] = '列表';
$string['listfiles'] = '{$a} 中的文件列表';
$string['listofallpeople'] = '成员列表';
$string['listofcourses'] = '课程列表';
$string['loading'] = '载入中';
$string['loadinghelp'] = '载入中……';
$string['local'] = '本地';
$string['localplugins'] = '本地插件';
$string['localpluginsmanage'] = '管理本地插件';
$string['location'] = '地点';
$string['locktimeout'] = '在等待锁定时操作超时';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = '您以{$a}登录';
$string['loggedinasguest'] = '您正在用访客帐号访问';
$string['loggedinnot'] = '您尚未登录。';
$string['login'] = '登录';
$string['login_failure_logs'] = '登录失败日志';
$string['loginactivity'] = '登录活动';
$string['loginagain'] = '再次登录';
$string['loginalready'] = '您已经登录';
$string['loginas'] = '登录为';
$string['loginaspasswordexplain'] = '<p>要使用此功能，您需要特别的“登录为密码”。<br />如果您没有，请和服务器管理员联系。</p>';
$string['loginguest'] = '以访客身份登录';
$string['loginsite'] = '登录本网站';
$string['loginsteps'] = '要完全访问此站点，您首先需要注册一个帐号。';
$string['loginstepsnone'] = '<p>嗨! </p>
<p>为了完全访问课程您必须申请一个新帐号。</p>
<p>您所需要做的是创建一个用户名和密码，并在本页面中使用。</p>
<p>如果别人已经申请了相同的用户名，只好请您委屈一下用别的用户名重试。</p>';
$string['loginto'] = '登录到{$a}';
$string['logoof'] = '{$a}的Logo图标';
$string['logout'] = '退出登录';
$string['logoutconfirm'] = '您真的要退出吗？';
$string['logs'] = '日志';
$string['logtoomanycourses'] = '[<a href="{$a->url}">更多</a>]';
$string['logtoomanyusers'] = '[<a href="{$a->url}">更多</a>]';
$string['lookback'] = '回顾';
$string['mailadmins'] = '通知管理员';
$string['mailstudents'] = '通知学生';
$string['mailteachers'] = '通知教师';
$string['maincoursepage'] = '课程主页面';
$string['makeafolder'] = '新建文件夹';
$string['makeavailable'] = '标记为可用';
$string['makeeditable'] = '如果您设置“{$a}”为Web服务器进程(例如apache)可写，那么您可以在此页中直接编辑该文件';
$string['makethismyhome'] = '将此页设为我的个人主页';
$string['makeunavailable'] = '标记为不可用';
$string['manageblocks'] = '版块';
$string['managecategories'] = '管理课程分类';
$string['managecategorythis'] = '管理这一类别';
$string['managecombined'] = '管理课程分类和课程';
$string['managecontentbanktypes'] = '管理内容类型';
$string['managecourses'] = '课程管理';
$string['managedatabase'] = '管理数据库';
$string['managedataformats'] = '管理数据格式';
$string['manageeditorfiles'] = '管理编辑器使用的文件';
$string['managefilters'] = '筛选条件';
$string['managemodules'] = '模块';
$string['manageroles'] = '角色和权限';
$string['markallread'] = '全部标记为已读';
$string['markedthistopic'] = '该主题作为当前主题突出显示';
$string['markthistopic'] = '标记该主题为当前主题';
$string['matchingsearchandrole'] = '与“{$a->search}”匹配的{$a->role}';
$string['maxareabytesreached'] = '这个文件（或几个文件的总和）的大小超过了预留的空间';
$string['maxfilesize'] = '新上传文件的最大体积：{$a}';
$string['maxfilesreached'] = '此项允许您最多附加 {$a} 个文件';
$string['maximumchars'] = '最多{$a}个字符';
$string['maximumgrade'] = '最高分';
$string['maximumgradex'] = '最高分：{$a}';
$string['maximumshort'] = '最大';
$string['maximumupload'] = '最大上传文件';
$string['maximumupload_help'] = '<p align="center"><b>课程上传大小</b></p> <p>此设置定义在课程中学生可以上传的最大的文件大小。它受到管理员设置的全站设置的限制。</p> <p>每个活动模块里的设置也可以进一步地限制它。</p>';
$string['maxnumberweeks'] = '最大小节数';
$string['maxnumberweeks_desc'] = '下拉菜单中小节数量的最大值（仅适用于特定课程格式）。';
$string['maxnumcoursesincombo'] = '浏览<a href="{$a->link}">{$a->numberofcourses}门课程</a>。';
$string['maxsectionslimit'] = '无法创建新小节，因为它将超过本课程允许的最大小节数({$a})。';
$string['maxsize'] = '大小限制: {$a}';
$string['maxsizeandareasize'] = '新文件的最大大小：{$a->size}，总限额：{$a->areasize}';
$string['maxsizeandattachments'] = '最大文件大小:{$a->size}，最大文件数量:{$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = '新文件的最大大小：{$a->size}，最大附件数：{$a->attachments}，总限额：{$a->areasize}';
$string['memberincourse'] = '课程成员';
$string['menu'] = '菜单';
$string['message'] = '消息';
$string['messagebody'] = '消息正文';
$string['messagedselectedusers'] = '选定的用户已收到消息，收件人列表已重置。';
$string['messagedselectedusersfailed'] = '给选中用户发送信息时出错。一些用户可能收到了邮件。';
$string['messageprovider:asyncbackupnotification'] = '异步备份/恢复通知';
$string['messageprovider:availableupdate'] = '可用的更新通知';
$string['messageprovider:backup'] = '备份通知';
$string['messageprovider:badgecreatornotice'] = '勋章创建者的通知';
$string['messageprovider:badgerecipientnotice'] = '勋章获得者的通知';
$string['messageprovider:competencyplancomment'] = '发表在学习计划上的评论';
$string['messageprovider:competencyusercompcomment'] = '发表在能力上的评论';
$string['messageprovider:coursecompleted'] = '课程完成';
$string['messageprovider:coursecontentupdated'] = '课程内容的变化';
$string['messageprovider:courserequestapproved'] = '课程创建申请批准通知';
$string['messageprovider:courserequested'] = '课程创建申请通知';
$string['messageprovider:courserequestrejected'] = '课程创建申请拒绝通知';
$string['messageprovider:errors'] = '本站的严重错误';
$string['messageprovider:errors_help'] = '有管理员必须知晓的严重的错误。';
$string['messageprovider:gradenotifications'] = '成绩通知';
$string['messageprovider:infected'] = '防病毒失败通知';
$string['messageprovider:insights'] = '预测模型生成的洞察';
$string['messageprovider:instantmessage'] = '用户之间的个人消息';
$string['messageprovider:instantmessage_help'] = '此小节配置在收到本站其他用户直接发给您的消息后，该如何处理。';
$string['messageprovider:messagecontactrequests'] = '消息联系请求通知';
$string['messageprovider:newlogin'] = '新登录通知';
$string['messageprovider:notices'] = '关于某些小问题的通知';
$string['messageprovider:notices_help'] = '管理员可能会感兴趣的通知';
$string['messageprovider:reportbuilderschedule'] = '自定义报告构建器规划';
$string['messageselect'] = '选择此用户作为消息接收者';
$string['messageselectadd'] = '发消息';
$string['middlename'] = '中间名字';
$string['migratinggrades'] = '迁移成绩';
$string['min'] = '分钟';
$string['mins'] = '分钟';
$string['minute'] = '分';
$string['minutes'] = '分钟';
$string['miscellaneous'] = '其他';
$string['missingcategory'] = '您必需选择一个类别';
$string['missingdescription'] = '自述没填';
$string['missingemail'] = '电子邮件地址没填';
$string['missingfirstname'] = '名没填';
$string['missingfromdisk'] = '磁盘中缺少';
$string['missingfullname'] = '全称没填';
$string['missinglastname'] = '姓氏没填';
$string['missingname'] = '名没填';
$string['missingnewpassword'] = '新密码没填';
$string['missingpassword'] = '密码没填';
$string['missingrecaptchachallengefield'] = '验证码服务系统(reCAPTCHA)验证失败，请重试。';
$string['missingreqreason'] = '原因没填';
$string['missingshortname'] = '简称没填';
$string['missingshortsitename'] = '站名简称没填';
$string['missingsitedescription'] = '站点描述没填';
$string['missingsitename'] = '站名没填';
$string['missingstrings'] = '检查未翻译的字串';
$string['missingstudent'] = '必须选个东西';
$string['missingsummary'] = '概况没填';
$string['missingteacher'] = '必须选个东西';
$string['missingurl'] = '遗漏了URL';
$string['missingusername'] = '用户名没填';
$string['moddoesnotsupporttype'] = '模块 {$a->modname} 不支持上传 {$a->type} 类型文件';
$string['modhide'] = '隐藏';
$string['modified'] = '修改时间';
$string['modshow'] = '显示';
$string['moduleintro'] = '描述';
$string['modulesetup'] = '安装模组表';
$string['modulesuccess'] = '{$a} 表已经正确安装';
$string['modulesused'] = '已使用模块';
$string['modvisible'] = '可见性';
$string['modvisible_help'] = '如果可见性设为“在课程页面显示”，学生就可以访问活动或资源（也可以添加其他访问限制）。

如果可见性设为“对学生隐藏”，只有拥有特定权限的用户才可以查看隐藏的活动或资源（默认情况下指的是教师或无编辑权教师角色的用户）。';
$string['modvisiblehiddensection'] = '可见性';
$string['modvisiblehiddensection_help'] = '如果可见性设为“对学生隐藏”，只有拥有特定权限的用户才可以查看隐藏的活动或资源（默认情况下指的是教师或无编辑权教师角色的用户）。

如果课程包含许多活动或资源，可以通过“不在课程页面显示但仍可用”将课程页面简化。这种情况下，必须提供一个指向活动或资源的链接，否则将无法访问。活动仍会被列在成绩册和其他报表中。';
$string['modvisiblewithstealth'] = '可见性';
$string['modvisiblewithstealth_help'] = '如果可见性设为“在课程页面显示”，学生就可以访问活动或资源（也可以添加其他访问限制）。

如果可见性设为“对学生隐藏”，只有拥有特定权限的用户才可以查看隐藏的活动或资源（默认情况下指的是教师或无编辑权教师角色的用户）。

如果课程包含许多活动或资源，可以通过“不在课程页面显示但仍可用”将课程页面简化。这种情况下，必须提供一个指向活动或资源的链接，否则将无法访问。活动仍会被列在成绩册和其他报表中。';
$string['month'] = '月';
$string['months'] = '月';
$string['moodledocs'] = 'Moodle文档';
$string['moodledocslink'] = '帮助和文档';
$string['moodlelogo'] = 'Moodle图标';
$string['moodlerelease'] = 'Moodle发行版';
$string['moodleservicesandsupport'] = '服务和支持';
$string['moodleversion'] = 'Moodle版本';
$string['more'] = '更多';
$string['moreactions'] = '更多操作';
$string['morehelp'] = '更多帮助';
$string['morehelpaboutmodule'] = '关于 {$a} 活动的更多帮助';
$string['moreinfo'] = '更多信息';
$string['moreinformation'] = '关于这个错误的更多信息';
$string['moremenu'] = '更多';
$string['morenavigationlinks'] = '更多……';
$string['moreprofileinfoneeded'] = '请告诉我们关于您的更多信息';
$string['mostrecently'] = '最近';
$string['move'] = '移动';
$string['movecategoriessuccess'] = '已顺利移动类别{$a->count}到类别\'{$a->to}\'';
$string['movecategoriestotopsuccess'] = '成功移动{$a->count}个类别到置顶';
$string['movecategorycontentto'] = '移至';
$string['movecategorysuccess'] = '已顺利移动类别{$a->count}到类别\'{$a->to}\'';
$string['movecategoryto'] = '移动类别到:';
$string['movecategorytotopsuccess'] = '成功移动类别\'{$a->moved}\'到置顶';
$string['movecontent'] = '移动 {$a}';
$string['movecontentafter'] = '在 "{$a}"之后';
$string['movecontentstoanothercategory'] = '移动内容到另一个类别';
$string['movecontenttothetop'] = '排在第一位';
$string['movecoursemodule'] = '移动资源';
$string['movecoursesection'] = '移动小节';
$string['movecourseto'] = '移动课程到:';
$string['movedown'] = '下移';
$string['movefilestohere'] = '移动文件到这里';
$string['movefull'] = '移动{$a}到这个位置';
$string['movehere'] = '移到这里';
$string['moveleft'] = '左移';
$string['moveright'] = '右移';
$string['movesection'] = '移动小节{$a}';
$string['moveselectedcategoriesto'] = '移动选定的类别到';
$string['moveselectedcoursesto'] = '移动选定的课程到';
$string['movetoanotherfolder'] = '移动至另一文件夹';
$string['moveup'] = '上移';
$string['msnid'] = 'MSN号码';
$string['mustchangepassword'] = '新的密码必须和当前的不同';
$string['mustconfirm'] = '您需要确认您的账号';
$string['mycourses'] = '我的课程';
$string['myfiles'] = '我的私人文件';
$string['myfilesmanage'] = '管理我的私人文件';
$string['myhome'] = '个人主页';
$string['mymoodledashboard'] = '我的Moodle个人主页';
$string['myprofile'] = '个人资料';
$string['name'] = '名称';
$string['namedfiletoolarge'] = '文件\'{$a->filename}\'太大，无法上传';
$string['nameforlink'] = '您想怎么命名这个链接？';
$string['nameforpage'] = '名称';
$string['navigation'] = '导航';
$string['needed'] = '需要的';
$string['networkdropped'] = '我们检测到你的网络不稳定或者已中断。<br/>注意如果不改善你的网络状况，你所作的更改可能没有保存。';
$string['never'] = '从未';
$string['neverdeletelogs'] = '从不删除日志';
$string['new'] = '新';
$string['newaccount'] = '新帐号';
$string['newactivityname'] = '活动{$a}的新名字';
$string['newcourse'] = '新课程';
$string['newloginnotificationbodyfull'] = '<p>{$a->userfullname}：</p>
<p>您好！</p>
<p>您的{$a->sitename}帐号刚刚在一台新设备上登录。</p>
<ul>
<li>您的帐号：{$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>设备：{$a->logindevice}</li>
<li>IP地址：{$a->loginip}</li>
</ul>
<p>如果这是您本人，您无需进行任何操作，</p>
<p>如果您不认可这个活动，请立即<a href="{$a->changepasswordlink}">修改密码</a>。</p>';
$string['newloginnotificationbodysmall'] = '您的{$a}帐号刚刚从一台新设备登录。';
$string['newloginnotificationtitle'] = '您的{$a}帐号有新活动';
$string['newpassword'] = '新密码';
$string['newpassword_help'] = '输入一个新密码或留空以保留当前密码。';
$string['newpasswordfromlost'] = '<strong>注意：</strong>您的<strong>当前密码</strong> 将在两封email的<strong>第二</strong>封里发送给您。这是恢复丢失密码流程的一部分。在从此屏幕继续之前，请确认您收到了新的密码。';
$string['newpasswordtext'] = '{$a->firstname}，您好：

您在“{$a->sitename}”上的帐号密码已被重设为一个新生成的临时密码。

现在您的登录信息是：
 用户名：{$a->username}
 密码：{$a->newpassword}

请到这里更改您的密码：
 {$a->link}

在多数的邮件程序中，这个地址应该显示为蓝色的链接，可以直接点击。如果不是这样，请将以上地址复制粘贴到网页浏览器窗口上部的地址栏中，打开这个网页。

此致
敬礼！
{$a->signoff}';
$string['newpicture'] = '新照片';
$string['newpicture_help'] = '要添加新头像，先浏览和选择一个JPG或PNG格式的图片，然后点击“更新个人档案”。图片会被剪裁为正方形，尺寸修改为100x100像素。';
$string['newpictureusernotsetup'] = '只有在保存了所有必需的个人信息后，才能添加个人图片。';
$string['newsectionname'] = '小节{$a}的新名字';
$string['newsitem'] = '新闻条目';
$string['newsitems'] = '新闻通告';
$string['newsitemsnumber'] = '显示的新闻通告数';
$string['newsitemsnumber_help'] = '新闻公告讨论区为自动创建在课程中的特殊讨论区，默认为强制订阅，只能拥有适当权限的用户(默认为老师) 可以发贴。

此设置决定在最新公告区显示多少条最新公告。

如果课程中不需要公告讨论区，此项应设置为零。';
$string['newuser'] = '新用户';
$string['newusernewpasswordsubj'] = '新用户账号';
$string['newusernewpasswordtext'] = '{$a->firstname}，您好，

已经为您在“{$a->sitename}”创建了一个新账号，并同时为您生成了一个临时密码。

您现在的登录信息是：

  用户名：{$a->username}
  密码：{$a->newpassword}

（在首次登录时您会被要求更改密码）

请点击 {$a->link} 并登录，开始使用“{$a->sitename}”。

在大多数邮件程序中，上面的链接将呈现为蓝色可点击的链接。如果链接不能点击，请复制它，然后粘贴到浏览器上方的地址栏内。

祝您使用愉快！
“{$a->sitename}”管理员
{$a->signoff}';
$string['newusers'] = '新用户';
$string['newwindow'] = '新窗口';
$string['next'] = '下一个';
$string['nextpage'] = '下一页';
$string['nextsection'] = '下一步';
$string['no'] = '否';
$string['noblockstoaddhere'] = '没有可以添加到此页的版块';
$string['nobody'] = '没人';
$string['nochange'] = '无变化';
$string['nocomments'] = '无评论';
$string['nocourses'] = '没有课程';
$string['nocoursesfound'] = '没有含关键词“{$a}”的课程';
$string['nocoursestarttime'] = '该课程无开始日期';
$string['nocoursesyet'] = '此类中无课程';
$string['nodstpresets'] = '管理员未开启本站的夏时制功能';
$string['nofilesselected'] = '没有选择要恢复的文件';
$string['nofilesyet'] = '您的课程尚未上传任何文件';
$string['nofiltersapplied'] = '未筛选';
$string['nograde'] = '没有成绩';
$string['nohelpforactivityorresource'] = '暂时没有和此资源或活动相关的帮助';
$string['noimagesyet'] = '您的课程尚未上传任何图片';
$string['nologsfound'] = '未发现日志';
$string['nomatchingusers'] = '没有用户与“{$a}”匹配';
$string['nomorecourses'] = '没有匹配的课程';
$string['nomoreidnumber'] = '并未使用ID号避免冲突';
$string['none'] = '无';
$string['noneditingteacher'] = '无编辑权教师';
$string['noneditingteacherdescription'] = '无编辑权教师可以授课和评价学生，但是不能更改活动。';
$string['nonstandard'] = '非标准';
$string['nopendingcourses'] = '没有待审批课程';
$string['nopotentialadmins'] = '没有候选网站管理员';
$string['nopotentialcreators'] = '没有候选课程管理员';
$string['nopotentialstudents'] = '没有候选的学生';
$string['nopotentialteachers'] = '没有候选教师';
$string['norecentactivity'] = '最近没有活动';
$string['noreplybouncemessage'] = '您已经回复了一个”不可回复“的电子邮件地址。如果您想要回复讨论区帖子，请使用{$a}讨论区进行回复。以下是您的邮件内容：';
$string['noreplybouncesubject'] = '{$a}-退信。';
$string['noreplyname'] = '不要回复此邮件';
$string['noresetrecord'] = '无相关的重置密码请求的记录。请重新发起一个重置密码请求。';
$string['noresults'] = '没有结果';
$string['normal'] = '正常';
$string['normalfilter'] = '常规过滤器';
$string['nosite'] = '找不到网站级别的课程';
$string['nostudentsfound'] = '未找到{$a}';
$string['nostudentsingroup'] = '在这个组中尚未有学生';
$string['nostudentsyet'] = '尚无学生参与此课程';
$string['nosuchemail'] = '没有这样的email地址';
$string['notavailable'] = '不可用';
$string['notavailablecourse'] = '{$a} 不可用';
$string['noteachersyet'] = '此课程尚无教师';
$string['noteachingupcomingcourses'] = '即将开始的课程没有老师和学生';
$string['notenrolled'] = '{$a}没有选修该课程。';
$string['notenrolledprofile'] = '此个人档案不可用，因为此用户没有加入此课程。';
$string['noteusercannotrolldatesoncontext'] = '<strong>注意：</strong>因为您缺少必需的权限，在恢复备份时不能回滚日期。';
$string['noteuserschangednonetocourse'] = '<strong>注意：</strong>恢复用户数据（活动中的数据、文件或消息）时用户资料也要恢复。此项设置已经替您更改。';
$string['nothingnew'] = '自从您上次登录以来尚无新活动';
$string['nothingtodisplay'] = '没有可显示内容';
$string['notice'] = '注意';
$string['noticenewerbackup'] = '这个备份文件是使用Moodle {$a->backuprelease}({$a->backupversion})创建的，它比您正在使用的Moodle {$a->serverrelease}({$a->serverversion})新。由于备份文件的向后兼容无法保证，这可能会导致恢复的内容和备份时不一致。';
$string['notifications'] = '通告';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, 用户: {$a->info}, 用户全名: {$a->name}';
$string['notifyloginfailuresmessageend'] = '您可以在 {$a} 查看这些日志。';
$string['notifyloginfailuresmessagestart'] = '这是自您上次于{$a}登录后的失败登录尝试';
$string['notifyloginfailuressubject'] = '{$a}::失败登录通知';
$string['notincluded'] = '不包括的';
$string['notingroup'] = '抱歉，您需要加入小组才能看此页面。';
$string['notpublic'] = '非公开';
$string['nousersfound'] = '未找到用户';
$string['nousersmatching'] = '没找到与“{$a}”相匹配的用户';
$string['nousersyet'] = '尚无用户';
$string['novalidcourses'] = '没有可利用的课程';
$string['now'] = '现在';
$string['numattempts'] = '{$a}次失败登录';
$string['numberofcourses'] = '课程编号';
$string['numberweeks'] = '章节的数目';
$string['numday'] = '{$a}天';
$string['numdays'] = '{$a}天';
$string['numhours'] = '{$a}小时';
$string['numletters'] = '{$a}字';
$string['numminutes'] = '{$a}分钟';
$string['nummonth'] = '{$a}月';
$string['nummonths'] = '{$a}个月';
$string['numseconds'] = '{$a}秒';
$string['numviews'] = '阅读{$a}次';
$string['numweek'] = '{$a}周';
$string['numweeks'] = '{$a}星期';
$string['numwords'] = '{$a}字';
$string['numyear'] = '{$a}年';
$string['numyears'] = '{$a}年';
$string['ok'] = '确定';
$string['oldpassword'] = '当前密码';
$string['olduserdirectory'] = '这是OLD用户目录，现在不再需要。您可以安全的删除它，该文件已经包含在新的用户目录中。';
$string['opendrawerblocks'] = '打开块抽屉';
$string['opendrawerindex'] = '打开课程索引';
$string['opensinnewwindow'] = '在新窗口中打开';
$string['optional'] = '可选的';
$string['options'] = '选项';
$string['order'] = '次序';
$string['originalpath'] = '初始路径';
$string['orphanedactivitiesinsectionno'] = '孤立的活动（小节{$a}）';
$string['other'] = '其它';
$string['outline'] = '概要';
$string['outlinereport'] = '概要报表';
$string['page'] = '页';
$string['pagea'] = '页 {$a}';
$string['pagedcontentnavigation'] = '分页导航';
$string['pagedcontentnavigationactiveitem'] = '当前页，页{$a}';
$string['pagedcontentnavigationitem'] = '转到页{$a}';
$string['pagedcontentpagingbaritemsperpage'] = '每页显示{$a}项';
$string['pageheaderconfigablock'] = '配置 {$a->fullname}中的版块';
$string['pagepath'] = '页面路径';
$string['pageshouldredirect'] = '本页会被自动重定向。如果什么都没发生，请点击下面的“继续”链接。';
$string['parentcategory'] = '父类别';
$string['parentcoursenotfound'] = '父课程未找到!';
$string['parentfolder'] = '父文件夹';
$string['participants'] = '参与人';
$string['participantscount'] = '成员人数： {$a}';
$string['participantslist'] = '成员列表';
$string['participationratio'] = '参与比例';
$string['participationreport'] = '成员报表';
$string['password'] = '密码';
$string['passwordchanged'] = '密码已被更改';
$string['passwordconfirmchange'] = '确认密码更改';
$string['passwordextlink'] = '下面的链接提供恢复您忘记的密码。您将会退出Moodle.';
$string['passwordforgotten'] = '忘记了密码';
$string['passwordforgotteninstructions'] = '必须先在用户数据库中找到您的详细信息。请将您的用户名<strong>或</strong>注册时使用的email地址输入到相应的文本框中。两者不用都输入。';
$string['passwordforgotteninstructions2'] = '要重设密码，请在下面提交您的用户名或电子邮件地址。如果我们能在数据库中找到您，我们将发送电子邮件到您的电子邮件地址，并说明如何再次访问。';
$string['passwordnohelp'] = '无法找到您丢失的密码。请联系您的moodle管理员';
$string['passwordpolicynomatch'] = '你当前的密码不符合密码设置策略
 {$a}';
$string['passwordrecovery'] = '是的，请帮我登录';
$string['passwordsdiffer'] = '这些密码不对';
$string['passwordsent'] = '密码已被发送';
$string['passwordsenttext'] = '<p>一封Email已经发往您的邮箱{$a->email}。</p>
<p><b>请查收您的Email以获取密码。</b></p>
<p>这个新密码是自动生成的，所以您可能需要点击<a href="{$a->link}">这里</a>改成您自己容易记住的密码。</p>';
$string['passwordset'] = '您的密码已经被成功设定。';
$string['path'] = '路径';
$string['pathnotexists'] = '该路径在您的服务器上并不存在!';
$string['pathslasherror'] = '路径不能以斜线符号结束!!';
$string['paymentinstant'] = '点击下面的按钮便可以快速付费并加入课程!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> 挂起</small>)';
$string['paymentrequired'] = '此课程需要付费才能进入。';
$string['payments'] = '付费';
$string['paymentsorry'] = '谢谢您付费! 您的付费手续尚未处理完毕，您还不能加入课程“{$a->fullname}”。请过几分钟后再试，但如果您始终有问题，请告知{$a->teacher}或站点管理员。';
$string['paymentthanks'] = '谢谢您付费! 现在您已经可以加入如下课程了: <br />“{$a}”';
$string['pendingrequests'] = '待批申请';
$string['percents'] = '{$a}%';
$string['periodending'] = '结束时间({$a})';
$string['perpage'] = '每页';
$string['perpagea'] = '每页：{$a}';
$string['personal'] = '个人';
$string['personalprofile'] = '个人信息';
$string['phone'] = '电话';
$string['phone1'] = '电话';
$string['phone2'] = '手机';
$string['phpinfo'] = 'PHP 信息';
$string['pictureof'] = '{$a}的头像';
$string['pictureofuser'] = '用户头像';
$string['pleaseclose'] = '现在，请关闭此窗口。';
$string['pleasesearchmore'] = '请多搜一些关键词';
$string['pleaseusesearch'] = '请使用搜索功能';
$string['plugin'] = '插件';
$string['plugincheck'] = '检查插件';
$string['plugindeletefiles'] = '与插件“{$a->name}”相关的所有数据都已经从数据库删除。为了阻止插件被重新安装，您现在就应该从服务器删除此目录：{$a->directory}
';
$string['pluginsetup'] = '创建插件表格';
$string['policyaccept'] = '我理解并同意';
$string['policyagree'] = '如果要继续使用此站点，您必须同意此政策。您同意么?';
$string['policyagreement'] = '站点政策协议';
$string['policyagreementclick'] = '链接到站点政策协议';
$string['popup'] = '弹出';
$string['popupwindow'] = '在新窗口中打开文件';
$string['popupwindowname'] = '弹出窗口';
$string['post'] = '发布';
$string['posts'] = '发布';
$string['potentialadmins'] = '候选网站管理员';
$string['potentialcreators'] = '候选课程管理员';
$string['potentialstudents'] = '候选学生';
$string['potentialteachers'] = '候选教师';
$string['poweredbymoodle'] = '本网站基于<a href="https://moodle.com">Moodle</a>';
$string['preferences'] = '偏好';
$string['preferredlanguage'] = '偏爱的语言';
$string['preferredtheme'] = '偏爱的主题风格';
$string['preprocessingbackupfile'] = '预处理备份文件';
$string['prev'] = '前一个';
$string['preview'] = '预览';
$string['previeworchoose'] = '预览或选取一个主题风格';
$string['previous'] = '上一个';
$string['previouslyselectedusers'] = '之前选择的用户不符合“{$a}”';
$string['previouspage'] = '上一页';
$string['previoussection'] = '上一步';
$string['primaryadminsetup'] = '设置管理员帐号';
$string['privacy:metadata:config_log'] = '配置修改记录。';
$string['privacy:metadata:config_log:name'] = '设置修改的名称。';
$string['privacy:metadata:config_log:oldvalue'] = '此配置项之前的值。';
$string['privacy:metadata:config_log:plugin'] = '插件已被修改。';
$string['privacy:metadata:config_log:timemodified'] = '修改时间。';
$string['privacy:metadata:config_log:userid'] = '修改人。';
$string['privacy:metadata:config_log:value'] = '此配置项的新值。';
$string['privacy:metadata:events_queue'] = '待处理用户事件队列。';
$string['privacy:metadata:events_queue:eventdata'] = '事件中存储的数据。';
$string['privacy:metadata:events_queue:stackdump'] = '任何与此事件有关的堆栈踪迹。';
$string['privacy:metadata:events_queue:timecreated'] = '此事件创建的时间。';
$string['privacy:metadata:events_queue:userid'] = '与此事件关联的用户ID';
$string['privacy:metadata:log'] = '过往事件的集合';
$string['privacy:metadata:log:action'] = '此操作的描述';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = '课程';
$string['privacy:metadata:log:info'] = '附加信息';
$string['privacy:metadata:log:ip'] = '事件发发生时所用的IP地址';
$string['privacy:metadata:log:module'] = '模块';
$string['privacy:metadata:log:time'] = '此操作发生的时间';
$string['privacy:metadata:log:url'] = '与此事件相关的网页链接URL';
$string['privacy:metadata:log:userid'] = '进行此操作的用户ID';
$string['privacy:metadata:oauth2_refresh_token'] = '刷新OAuth2.0通信令牌';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = '令牌对应的颁发者ID';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = '令牌对应的用户ID';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = '令牌创建时间';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = '令牌最近更新时间';
$string['privacy:metadata:oauth2_refresh_token:token'] = '为各作用域和用户刷新令牌';
$string['privacy:metadata:oauth2_refresh_token:userid'] = '令牌对应的用户ID';
$string['privacy:metadata:task_adhoc'] = 'Ad hoc任务状态。';
$string['privacy:metadata:task_adhoc:component'] = '拥有此事件的组件。';
$string['privacy:metadata:task_adhoc:nextruntime'] = '此任务的最早运行时间。';
$string['privacy:metadata:task_adhoc:userid'] = '运行此任务的用户。';
$string['privacy:metadata:task_log'] = '日志输出';
$string['privacy:metadata:task_log:component'] = '拥有任务的组件。';
$string['privacy:metadata:task_log:userid'] = '任务所属的用户。';
$string['privacy:metadata:upgrade_log'] = '升级记录。';
$string['privacy:metadata:upgrade_log:backtrace'] = '任何与此升级步骤有关的回溯。';
$string['privacy:metadata:upgrade_log:details'] = '与升级相关的额外信息。';
$string['privacy:metadata:upgrade_log:info'] = '此升级步骤的主信息。';
$string['privacy:metadata:upgrade_log:plugin'] = '被升级的插件。';
$string['privacy:metadata:upgrade_log:targetversion'] = '将升级至的新版本。';
$string['privacy:metadata:upgrade_log:timemodified'] = '升级发生的时间。';
$string['privacy:metadata:upgrade_log:type'] = '事件记录项类型。';
$string['privacy:metadata:upgrade_log:userid'] = '运行升级的用户。';
$string['privacy:metadata:upgrade_log:version'] = '插件的旧版本。';
$string['private_files_handler'] = '保存附件到电子邮件的私人文件存储空间。';
$string['private_files_handler_name'] = '发送电子邮件到私人文件';
$string['privatefiles'] = '私人文件';
$string['privatefilesmanage'] = '管理私人文件';
$string['proceed'] = '继续';
$string['profile'] = '个人档案';
$string['profilenotshown'] = '选了至少一门课以后，才能显示此人的个人描述。';
$string['publicprofile'] = '公开的个人资料';
$string['publicsitefileswarning'] = '注意:存放于此的文件任何人都能访问';
$string['publicsitefileswarning2'] = '注意：这里的文件可以被任何知道（或猜到）URL的人访问，建议将所有备份文件在恢复后立即删除。';
$string['publicsitefileswarning3'] = '注意：放在这里的文件可以被任何知道（或猜到）URL的人访问。<br />出于安全考虑，备份文件应该只保存到安全的backupdate文件夹。';
$string['question'] = '试题';
$string['questionsinthequestionbank'] = '题库中的题目';
$string['queued'] = '列队';
$string['quotausage'] = '您当前使用了{$a->used}/{$a->total} 的限额';
$string['readinginfofrombackup'] = '读取备份信息';
$string['readme'] = '说明';
$string['recentactivity'] = '最近活动';
$string['recentactivityreport'] = '最近活动的完整报表...';
$string['recipientslist'] = '收件人名单';
$string['recommended'] = '推荐';
$string['recreatedcategory'] = '重创建的类{$a}';
$string['redirect'] = '重定向';
$string['reducesections'] = '减少小节的数量';
$string['refresh'] = '刷新';
$string['refreshingevents'] = '刷新事件';
$string['registration'] = '注册Moodle';
$string['registrationcontact'] = '允许从公众网络访问';
$string['registrationcontactno'] = '否，我不愿意别人联系我。';
$string['registrationcontactyes'] = '是，提供表单供其它 Moodle 用户联系我。';
$string['registrationemail'] = 'Email通知';
$string['registrationinfo'] = '<p>您可以在本页面中到moodle.org注册您的站。这个过程是免费的。注册的主要好处是您会被加入一个mailing list，它只发送一些重要的提醒信息，比如安全警告和Moodle的版本更新。</P>
<p>缺省情况，您的信息是被保密的，永远不会被出售或转让给它人。收集信息的目的仅仅是出于客户服务的目的，同时也用来建一个Moodle社区的统计图。</p>
<p>如果您愿意，那么可以把您的站名、国家和URL放到Moodle官方网站的公用列表中。</p>
<p>所有的新注册在加入列表之前都会被人工验证。不过一旦您被加入列表中，那么您可以随时通过提交这个表单来更新您的注册信息（公用列表也会更新）。</p>';
$string['registrationinfotitle'] = '注册信息';
$string['registrationno'] = '否，我不想接收任何电子邮件';
$string['registrationsend'] = '发送注册信息到moodle.org';
$string['registrationyes'] = '是，通知我新的Moodle版本，安全警告和其他重要信息';
$string['reject'] = '拒绝';
$string['rejectdots'] = '拒绝...';
$string['relativedatesmode'] = '相对日期模式';
$string['relativedatesmode_help'] = '‎显示课程或活动日期相对于用户在课程中的开始日期。‎用户的课程开始日期将是他们加入课程的开始日期，除非他们是在课程开始前加入课程的，在这种情况下，他们的开始日期将是课程开始日期。<strong>警告：</strong>这是一个实验性的特性，并不是所有的活动都支持它。一旦课程被创建，这个课程设置就不能再被改变了。';
$string['relativedatesmode_warning'] = '<strong>警告：</strong> 创建课程后，无法更改相对日期模式。';
$string['reload'] = '重新载入';
$string['remoteappuser'] = '远程{$a}用户';
$string['remove'] = '移除';
$string['removeadmin'] = '免除网站管理员';
$string['removecreator'] = '免除课程管理员';
$string['removestudent'] = '开除学生';
$string['removeteacher'] = '免除教师';
$string['rename'] = '重命名';
$string['renamefileto'] = '将<b>{$a}</b>重命名为';
$string['report'] = '报表';
$string['reports'] = '报表';
$string['reporttype'] = '报告类型';
$string['repositories'] = '容器';
$string['requestcourse'] = '申请新建一门课程';
$string['requestedby'] = '申请人';
$string['requestedcourses'] = '申请的课程';
$string['requestreason'] = '申请理由';
$string['requests'] = '申请';
$string['required'] = '必需的';
$string['requirespayment'] = '此课程需要付费才能访问';
$string['resendemail'] = '重新发送电子邮件';
$string['reset'] = '重置';
$string['resetcomponent'] = '组件';
$string['resetcourse'] = '重置课程';
$string['resetinfo'] = '在此页面，您可以清空课程的用户数据，并保留所有活动和其它设置。但请注意，选择下面的选项并提交本页面后，将永远从课程删除您所选择的用户数据！';
$string['resetnotimplemented'] = '‎未实现重置';
$string['resetrecordexpired'] = '您使用的密码重置链接已经超过了{$a}分钟，目前已经失效了。请重新发起一次重置密码请求。';
$string['resetstartdate'] = '重置开始时间';
$string['resetstatus'] = '状态';
$string['resettable'] = '重置表格样式';
$string['resettask'] = '任务';
$string['resettodefaults'] = '重置为缺省';
$string['resortcourses'] = '课程重新排列';
$string['resortsubcategoriesby'] = '根据{$a}对子类别升序排序';
$string['resortsubcategoriesbyreverse'] = '根据{$a}对子类别降序排序';
$string['resource'] = '资源';
$string['resourcedisplayauto'] = '自动';
$string['resourcedisplaydownload'] = '强制下载';
$string['resourcedisplayembed'] = '嵌入';
$string['resourcedisplayframe'] = '在框架中';
$string['resourcedisplaynew'] = '新窗口';
$string['resourcedisplayopen'] = '打开';
$string['resourcedisplaypopup'] = '在弹出窗口中';
$string['resources'] = '资源';
$string['resources_help'] = '利用资源类型，几乎可以把任意类型的web资源插入到课程中';
$string['restore'] = '恢复';
$string['restorecancelled'] = '恢复被取消的';
$string['restorecannotassignroles'] = '恢复课程的过程需要分配角色，但是您没有相应的权限';
$string['restorecannotcreateorassignroles'] = '恢复课程的过程需要新建或分配角色，但是您没有相应的权限';
$string['restorecannotcreateuser'] = '恢复课程需要从备份文件创建用户“{$a}”，但是您没有相应的权限';
$string['restorecannotoverrideperms'] = '恢复课程的过程需要覆盖角色，但是您没有相应的权限';
$string['restorecoursenow'] = '恢复课程';
$string['restoredaccount'] = '已恢复帐号';
$string['restoredaccountinfo'] = '此帐号系从其它服务器导入，密码已丢失。要通过email设置新密码，请点击“继续”';
$string['restorefinished'] = '恢复成功';
$string['restoremnethostidmismatch'] = '用户\'{$a}\'的MNet主机号与本地MNet主机号不匹配。';
$string['restoreto'] = '恢复到';
$string['restoretositeadding'] = '警告：您正要恢复站点的首页，向它添加数据！';
$string['restoretositedeleting'] = '警告：您正要恢复站点的首页，并且会先删除数据！';
$string['restoreuserconflict'] = '从备份文件恢复用户\'{$a}\'会引起冲突';
$string['restoreuserinfofailed'] = '恢复过程已经终止，因为您没有恢复用户数据的权限。';
$string['restoreusersprecheck'] = '检查用户数据';
$string['restoreusersprecheckerror'] = '检查用户数据时发现一些问题';
$string['restricted'] = '受限的';
$string['resultsfound'] = '找到 {$a} 结果';
$string['retry'] = '重试';
$string['returningtosite'] = '再次访问本站？';
$string['returntooriginaluser'] = '返回到{$a}';
$string['revert'] = '重置';
$string['role'] = '角色';
$string['roleassignments'] = '角色分配';
$string['rolemappings'] = '角色映射';
$string['rolerenaming'] = '重命名角色';
$string['rolerenaming_help'] = '这项设置允许修改角色在课程中显示的名称。只有显示的名称可被修改，角色的权限不会受到影响。 新的角色名称会显示在课程成员页面上和课程内的其他地方。 如果这个重命名了的角色已经被网站管理员指定为课程管理者，这个新的角色名称也会作为课程列表的一部分显示出来。';
$string['roles'] = '角色';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'RSS最新文章数目';
$string['rsserror'] = '读取RSS数据错误';
$string['rsserrorauth'] = '您的RSS链接不包含有效的身份验证令牌。';
$string['rsserrorguest'] = '这个种子(feed)使用访客身份访问数据，但是访客没有读取数据的权限。请以一个有效的用户访问这个种子(feed)的原始地址(URL)，并取得一个新的 RSS 链接。';
$string['rsskeyshelp'] = '为保证安全和私密，RSS消息的URL中包含一个特殊的令牌，用来标明它们属于哪个用户。这可以阻止其他用户从RSS消息获取他们不应该访问到的信息。</p><p>在您第一次访问会生成RSS消息的Moodle页面时，此令牌会自动创建。如果您担心您的RSS消息令牌已经被泄露，您可以点击这里的重置链接再请求一个新的。但请注意，您当前的RSS消息URL将会失效。';
$string['rsstype'] = '此活动的RSS种子';
$string['save'] = '保存';
$string['saveandnext'] = '保存并显示下一个';
$string['savechanges'] = '保存更改';
$string['savechangesanddisplay'] = '保存并预览';
$string['savechangesandreturn'] = '保存并返回';
$string['savechangesandreturntocourse'] = '保存并返回课程';
$string['savecomment'] = '保存评论';
$string['savedat'] = '保存在：';
$string['savepreferences'] = '保存使用偏好';
$string['saveto'] = '保存到';
$string['scale'] = '量表';
$string['scale_help'] = '<p align="center"><b>量表</b></p> <p>教师可以在课程中为任意可评价的活动新建自定义的量表。</p> <p>量表的名字应是一个可以清晰地分辨它的短语：它将出现在量表选择列表，也会出现在即时帮助按钮上。</p> <p>量表由一列按由负到正的次序排好的值定义，用逗号分隔。例如：</p> “令人失望,不够好,平均水平,好,很好,优秀！”<p>量表应该也包含一个良好的描述来说明它是什么和应该如何被使用。此描述会出现在教师与学生的帮助页内。</p> <p>最后，这里有一个或多个“标准”量表由系统管理员在网站上定义。它们可以在所有的课程里使用。</p>';
$string['scale_link'] = 'grade/scale';
$string['scales'] = '量表';
$string['scalescustom'] = '自定义量表';
$string['scalescustomcreate'] = '添加量表';
$string['scalescustomno'] = '未创建自定义量表';
$string['scalesstandard'] = '标准量表';
$string['scalestandard'] = '标准量表';
$string['scalestandard_help'] = '标准量表在全站的所有课程中都可用。';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = '使用课程管理菜单的“量表...”链接建立自定义量表';
$string['scalestip2'] = '要建立自定义量表，请点击课程管理菜单里的“成绩”链接，然后选择编辑，量表。';
$string['schedule'] = '时间表';
$string['screenshot'] = '抓屏';
$string['search'] = '搜索';
$string['search_help'] = '基本搜索可以在文本中查找一个或多个词。词之间用空格分隔。只有一个字母的单词会被忽略。

如要进行高级搜索，直接点击搜索按钮，搜索框中什么都不要输入，便可访问高级搜索表单。';
$string['searchactivities'] = '按名称或描述搜索活动';
$string['searchagain'] = '再次搜索';
$string['searchbyemail'] = '用email地址搜索';
$string['searchbyusername'] = '用用户名搜索';
$string['searchcoursecategories'] = '搜索类别';
$string['searchcourses'] = '搜索课程';
$string['searchoptions'] = '搜索选项';
$string['searchresults'] = '搜索结果';
$string['sec'] = '秒';
$string['seconds'] = '秒';
$string['secondsleft'] = '{$a}秒';
$string['secondstotime172800'] = '2天';
$string['secondstotime259200'] = '3天';
$string['secondstotime345600'] = '4天';
$string['secondstotime432000'] = '5天';
$string['secondstotime518400'] = '6天';
$string['secondstotime604800'] = '1周';
$string['secondstotime86400'] = '1天';
$string['secretalreadyused'] = '更改密码确认链接已使用，密码未更改。';
$string['secs'] = '秒';
$string['section'] = '小节';
$string['sectionactionnotsupported'] = '这里不支持小节活动 "{$a}"';
$string['sectionname'] = '小节名';
$string['sections'] = '小节';
$string['seealsostats'] = '请参阅：统计';
$string['selctauser'] = '选择一个用户';
$string['select'] = '选择';
$string['selectacategory'] = '请选择一个类别';
$string['selectacountry'] = '选择一个国家或地区';
$string['selectacourse'] = '选择一门课程';
$string['selectacoursesite'] = '选择一个课程或网站';
$string['selectagroup'] = '选择一个小组';
$string['selectall'] = '全选';
$string['selectallusersonpage'] = '全选本页用户';
$string['selectalluserswithcount'] = '选择所有{$a} 个用户';
$string['selectamodule'] = '请选择一个活动模块';
$string['selectanaction'] = '选择一个动作';
$string['selectanoptions'] = '选择一个选项';
$string['selectaregion'] = '选择一个地区';
$string['selectcategorysort'] = '您希望对哪些类别排序?';
$string['selectcategorysortby'] = '选择您希望如何对类别排序';
$string['selectcoursesortby'] = '选择您希望如何对课程排序';
$string['selectdefault'] = '选择默认值';
$string['selectedcategories'] = '选定的类别';
$string['selectedfile'] = '已选文件';
$string['selectednowmove'] = '{$a}个文件要被移动位置。现在请前往目的地址点击“移动文件到这里”';
$string['selectfiles'] = '选择文件';
$string['selectitem'] = '选择“{$a}”';
$string['selectmoduletoviewhelp'] = '选择一个活动或资源来查看其帮助。
在活动或资源名称上双击可以快速添加。';
$string['selectnos'] = '全选“不”';
$string['selectperiod'] = '选择时间';
$string['senddetails'] = '用Email发送我的详细资料';
$string['separate'] = '分离';
$string['separateandconnected'] = '独立型和情景型学习方式';
$string['separateandconnectedinfo'] = '此量表基于独立型和情景型认知理论。此理论描述了我们了解和评价所见所闻事物的两种不同方法。<ul><li><strong>独立型的人</strong>总是尽量保持客观，避免受感觉和情绪的影响。在与其他人讨论时，他们喜欢维护自己的观点，用逻辑找出对手观点中的漏洞。</li><li><strong>情景型的人</strong>比其他人更敏感。 他们善于换位思考，喜欢倾听和提问，直到他们觉得自己能从别人的角度理解事物。他们通过分享从他人身上获得知识的经验来学习。</li></ul>';
$string['servererror'] = '与服务器通信发生错误';
$string['serverlocaltime'] = '服务器的当地时间';
$string['sessionforceclean'] = '‎作为安全预防措施，用户生成的脚本已在此会话中禁用。‎';
$string['sessiontimeoutsoon'] = '您的会话即将超时。是否要延长当前会话?';
$string['setcategorytheme'] = '设置分类主题';
$string['setmode'] = '设定模式';
$string['setpassword'] = '设定密码';
$string['setpasswordinstructions'] = '请在下面输入您的新密码，然后保存设置。';
$string['settings'] = '设置';
$string['shortname'] = '简称';
$string['shortnamecollisionwarning'] = '[*]=这个简称已经被某个课程所使用，需要改变它以获得批准。';
$string['shortnamecourse'] = '课程简称';
$string['shortnamecourse_help'] = '课程简称将在导航中显示，并且会被用在课程email的主题行中。';
$string['shortnametaken'] = '这个简称已用于另一个课程({$a})';
$string['shortnameuser'] = '用户简称';
$string['shortsitename'] = '网站简称';
$string['show'] = '显示';
$string['showactions'] = '显示动作';
$string['showactivitydates'] = '显示活动日期';
$string['showactivitydates_help'] = '活动日期始终显示在活动页面上。此设置确定活动日期是否也显示在课程页面上每个活动的下方。';
$string['showadvancededitor'] = '高级';
$string['showadvancedsettings'] = '显示高级设置';
$string['showall'] = '显示所有（{$a}）';
$string['showallcourses'] = '显示所有课程';
$string['showallusers'] = '显示所有用户';
$string['showblockcourse'] = '显示包含版块的课程列表';
$string['showcategory'] = '显示{$a}';
$string['showchartdata'] = '显示图表数据';
$string['showcomments'] = '显示/隐藏评论';
$string['showcommentsnonjs'] = '显示评论';
$string['showdescription'] = '在课程页面显示简介';
$string['showdescription_help'] = '如果启用，上述简介将显示在活动或资源链接下方的课程页面上。';
$string['showgrades'] = '向学生显示成绩单';
$string['showgrades_help'] = '课程中的许多活动允许设定成绩。此设置确定学生是否可以查看课程的所有成绩的列表。';
$string['showingacourses'] = '显示所有{$a}课程';
$string['showingxofycourses'] = '显示全部{$a->total}个课程的{$a->start}到{$a->end}。';
$string['showlistofcourses'] = '显示课程列表';
$string['showmodulecourse'] = '显示包含活动的课程列表';
$string['showoncoursepage'] = '在课程页面上显示';
$string['showonly'] = '只显示';
$string['showperpage'] = '每页显示{$a}';
$string['showpopoverwindow'] = '显示弹窗';
$string['showrecent'] = '显示最近的活动';
$string['showreports'] = '是否显示活动报表';
$string['showreports_help'] = '活动报表提供给每个参与者，以显示他们在课程中的活动。除了他们的贡献列表，如论坛帖子或任务提交，这些报表还包括访问日志。此设置确定学生是否可以通过其个人档案页查看自己的活动报表。';
$string['showsettings'] = '显示设置';
$string['showtheselogs'] = '显示这些日志';
$string['showthishelpinlanguage'] = '显示本帮助的{$a}版本';
$string['sidepanel'] = '停靠面板';
$string['signoutofotherservices'] = '全部退出';
$string['signoutofotherservices_help'] = '如果勾选，该帐户将会退出使用网络服务的所有设备和系统，例如移动应用。';
$string['since'] = '开始时间';
$string['sincelast'] = '最后登录';
$string['site'] = '站点';
$string['sitedefault'] = '网站缺省';
$string['sitedefaultspecified'] = '站点默认 ({$a})';
$string['siteerrors'] = '本站错误';
$string['sitefiles'] = '站点文件';
$string['sitefilesused'] = '在该课程中使用的站点文件';
$string['sitehome'] = '站点首页';
$string['sitelegacyfiles'] = '继承的网站文件';
$string['sitelogs'] = '本站日志';
$string['sitenews'] = '站点新闻通告';
$string['sitepages'] = '网站页面';
$string['sitepartlist'] = '您没有查看成员名单所需的权限';
$string['sitepartlist0'] = '您必须是网站的教师才能看到网站成员名单';
$string['sitepartlist1'] = '您必须是一名教师，才能看到网站成员名单';
$string['sites'] = '站点';
$string['sitesection'] = '包含一个主题节';
$string['sitesettings'] = '本站设置';
$string['siteteachers'] = '本站教师';
$string['size'] = '大小';
$string['sizeb'] = '字节';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = '跳过';
$string['skiptocategorylisting'] = '跳到类别列表';
$string['skiptocoursedetails'] = '跳到详细的课程信息';
$string['skiptocourselisting'] = '跳到课程列表';
$string['skypeid'] = 'Skype号码';
$string['socialheadline'] = '社区论坛――最新话题';
$string['someallowguest'] = '有些课程可能允许访客浏览';
$string['someerrorswerefound'] = '有些信息缺失或有误。详细情况请看下面。';
$string['sort'] = '排序';
$string['sortby'] = '排序方式';
$string['sortbyx'] = '按{$a}升序排序';
$string['sortbyxreverse'] = '按{$a}降序排序';
$string['sorting'] = '排序';
$string['sourcerole'] = '源角色';
$string['specifyname'] = '您必须指定一个名称';
$string['standard'] = '标准';
$string['starpending'] = '([*] = 待审批的课程)';
$string['startdate'] = '课程开始日期';
$string['startdate_help'] = '此设置确定星期格式课程的第一周开始时间。它还确定了课程活动日志可用的最早日期。如果课程被重置，并且课程开始日期被更改，那么课程中的所有日期都将根据新的开始日期进行移动。';
$string['startingfrom'] = '开始时间';
$string['startsignup'] = '注册新帐号';
$string['state'] = '省/直辖市';
$string['statistics'] = '统计';
$string['statisticsgraph'] = '统计图';
$string['stats'] = '统计';
$string['statslogins'] = '登录';
$string['statsmodedetailed'] = '详细（用户）信息';
$string['statsmodegeneral'] = '一般信息';
$string['statsnodata'] = '没有关于课程和时间段组合的可用数据。';
$string['statsnodatauser'] = '课程，用户和学时没有提供可使用的数据。';
$string['statsoff'] = '当前统计没有激活。';
$string['statsreads'] = '浏览';
$string['statsreport1'] = '登录';
$string['statsreport10'] = '用户活跃度';
$string['statsreport11'] = '最活跃课程';
$string['statsreport12'] = '最活跃课程（加权）';
$string['statsreport13'] = '最具参与性课程（学生）';
$string['statsreport14'] = '最具参与性的课程(发布/浏览）';
$string['statsreport2'] = '浏览（全部角色）';
$string['statsreport3'] = '发布（全部角色）';
$string['statsreport4'] = '所有活动（全部角色）';
$string['statsreport5'] = '所有活动（浏览和发布）';
$string['statsreport7'] = '用户活动（浏览和发布）';
$string['statsreport8'] = '所有用户活动';
$string['statsreport9'] = '登录（网站课程）';
$string['statsreportactivity'] = '所有活动（全部角色）';
$string['statsreportactivitybyrole'] = '所有活动（浏览和发布）';
$string['statsreportforuser'] = '为';
$string['statsreportlogins'] = '登录';
$string['statsreportreads'] = '浏览（所有角色）';
$string['statsreporttype'] = '报表类型';
$string['statsreportwrites'] = '发布（所有角色）';
$string['statsstudentactivity'] = '学生活动';
$string['statsstudentreads'] = '学生浏览';
$string['statsstudentwrites'] = '学生发布';
$string['statsteacheractivity'] = '教师活动';
$string['statsteacherreads'] = '教师浏览';
$string['statsteacherwrites'] = '教师发布';
$string['statstimeperiod'] = '时间段——过去的：';
$string['statsuniquelogins'] = '唯一登录';
$string['statsuseractivity'] = '所有活动';
$string['statsuserlogins'] = '登录';
$string['statsuserreads'] = '浏览';
$string['statsuserwrites'] = '发布';
$string['statswrites'] = '发布';
$string['status'] = '状态';
$string['statuscritical'] = '关键';
$string['statuserror'] = '错误';
$string['statusinfo'] = '信息';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = '未知';
$string['statuswarning'] = '警告';
$string['stringsnotset'] = '以下字串{$a}中没有定义';
$string['studentnotallowed'] = '抱歉，您不能以“{$a}”进入本课程';
$string['students'] = '学生';
$string['studentsandteachers'] = '学生和教师';
$string['subcategories'] = '子类别';
$string['subcategory'] = '子类别';
$string['subcategoryof'] = '{$a}的子类别';
$string['subject'] = '主题';
$string['submit'] = '提交';
$string['success'] = '成功';
$string['successduration'] = '成功 (用时 {$a} 秒)';
$string['summary'] = '概要';
$string['summary_help'] = '概要是一小段文字，向学生简介该主题或星期内的活动。这段文字会显示在课程页面中小节名的后面。';
$string['summaryof'] = '{$a}的概要';
$string['supplyinfo'] = '更多细节';
$string['suspended'] = '已停用';
$string['suspendedusers'] = '已被停用的用户';
$string['switchdevicedefault'] = '切换到标准主题';
$string['switchdevicerecommended'] = '切换到建议您的设备使用的主题';
$string['switchrolereturn'] = '切换回我正常的角色';
$string['switchroleto'] = '切换角色到...';
$string['switchroleto_help'] = '选择一个角色，了解具有该角色的人将如何看到此课程。

请注意此种查看效果可能不完美(<a href="https://docs.moodle.org/en/Switch_roles">查看详细信息和替代方法</a>)。';
$string['tag'] = '标签';
$string['tagalready'] = '该标签已经存在';
$string['tagmanagement'] = '添加/删除标签';
$string['tags'] = '标签';
$string['targetrole'] = '目标角色';
$string['teacheronly'] = '{$a}专用';
$string['teacherroles'] = '{$a}角色';
$string['teachers'] = '教师';
$string['textcopiedtoclipboard'] = '文字已拷贝到剪切板';
$string['textediting'] = '文本编辑器';
$string['textediting_help'] = '如果一个HTML编辑器，如Atto或者TinyMCE被选中，文本输入框处会显示一个带按钮的工具栏，用来方便地输入内容。

如果‘普通文本框’被选中，文本输入框的格式如HTML或者Markdown可以被选中。

可用的本文编辑器列表由站点管理员决定。';
$string['texteditor'] = '使用标准网页形式';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = '纯文本格式';
$string['thanks'] = '感谢';
$string['theme'] = '主题风格';
$string['themes'] = '主题风格';
$string['themesaved'] = '新主题风格已保存';
$string['therearecourses'] = '这里有 {$a} 门课';
$string['thereareno'] = '该课程中没有{$a}';
$string['thiscategory'] = '这一类别';
$string['thiscategorycontains'] = '此类别包含';
$string['time'] = '时间';
$string['timecreated'] = '创建的时间';
$string['timecreatedcourse'] = '课程创建时间';
$string['timesplitting:deciles'] = '十分法';
$string['timesplitting:deciles_help'] = '此分析间隔将这门课程时间分成了十个十分之一(10个相等的部分)，每个预测都是基于最近的上一个十分之一的数据。';
$string['timesplitting:decilesaccum'] = '十分累计法';
$string['timesplitting:decilesaccum_help'] = '此分析间隔将这门课程时间分成了十个十分之一(10个相等的部分)，每个预测都是基于之前所有的十分之一累计的数据。';
$string['timesplitting:nosplitting'] = '没有时间限制';
$string['timesplitting:nosplitting_help'] = '该模型没有定义分析间隔。';
$string['timesplitting:onemonthafterstart'] = '开始后一个月';
$string['timesplitting:onemonthafterstart_help'] = '此分析间隔在分析开始1个月后生成预测。';
$string['timesplitting:oneweekafterstart'] = '开始后一周';
$string['timesplitting:oneweekafterstart_help'] = '‎此分析间隔在分析开始1周后生成预测。';
$string['timesplitting:past3days'] = '过去的3天';
$string['timesplitting:past3days_help'] = '‎此分析间隔每3天生成一次预测。指标计算将基于过去3天。';
$string['timesplitting:pastmonth'] = '上个月';
$string['timesplitting:pastmonth_help'] = '‎此分析间隔每月生成预测。指标计算将基于上个月。';
$string['timesplitting:pastweek'] = '过去的一周';
$string['timesplitting:pastweek_help'] = '‎此分析间隔每周生成预测。指标计算将基于过去一周。';
$string['timesplitting:quarters'] = '四分法';
$string['timesplitting:quarters_help'] = '此分析间隔将这门课程时间分为四个四分之一(4个相等的部分)，每个预测都基于最近的上一个四分之一的数据。';
$string['timesplitting:quartersaccum'] = '四分累计法';
$string['timesplitting:quartersaccum_help'] = '此分析间隔将这门课程时间分为四个四分之一(4个相等的部分)，每个预测都基于之前所有的四分之一累计的数据。';
$string['timesplitting:singlerange'] = '从开始到结束';
$string['timesplitting:singlerange_help'] = '此分析间隔将整个课程视为一个整体。';
$string['timesplitting:tenpercentafterstart'] = '开始后10%';
$string['timesplitting:tenpercentafterstart_help'] = '‎此分析间隔在课程完成 10% 后生成预测。';
$string['timesplitting:upcoming3days'] = '未来3天';
$string['timesplitting:upcoming3days_help'] = '‎此分析间隔每3天生成一次预测。指标计算将基于未来3天。';
$string['timesplitting:upcomingfortnight'] = '未来两周';
$string['timesplitting:upcomingfortnight_help'] = '‎此分析间隔每两周生成一次预测。指标计算将基于未来两周。';
$string['timesplitting:upcomingweek'] = '未来一周';
$string['timesplitting:upcomingweek_help'] = '此分析间隔每周生成预测。指标的计算将基于未来一周。';
$string['timezone'] = '时区';
$string['to'] = '截止时间';
$string['tocontent'] = '到项目"{$a}"';
$string['tocreatenewaccount'] = '直接跳到建立新帐号';
$string['today'] = '今天';
$string['todaylogs'] = '今日日志';
$string['toeveryone'] = '给每个人';
$string['toggleemojipicker'] = '切换表情选择器';
$string['togglesearch'] = '切换搜索输入';
$string['toomanybounces'] = '那个email地址已经有太多的退信。在继续前您<b>必须</b>修改它。';
$string['toomanytags'] = '此次搜索关键词包含太多的标签，某些标签可能会被忽略。';
$string['toomanytoshow'] = '要显示的用户太多';
$string['toomanyusersmatchsearch'] = '太多用户（{$a->count}个）匹配“{$a->search}”';
$string['toomanyuserstoshow'] = '太多用户（{$a}个）要显示';
$string['toonly'] = '只给{$a}';
$string['top'] = '置顶';
$string['topic'] = '主题';
$string['topichide'] = '向{$a}隐藏该主题';
$string['topicoutline'] = '主题目录';
$string['topicshow'] = '显示该主题于{$a}';
$string['toplevelcategory'] = '置顶类别';
$string['total'] = '总计';
$string['totopofsection'] = '到小节"{$a}"的上方';
$string['trackforums'] = '跟踪讨论区';
$string['trackforumsno'] = '不：不要跟踪我看过的帖子';
$string['trackforumsyes'] = '对：把新帖子突出显示给我';
$string['trysearching'] = '试试搜索';
$string['turneditingoff'] = '关闭编辑功能';
$string['turneditingon'] = '打开编辑功能';
$string['unabletocopytoclipboard'] = '无法将文字拷贝到剪切板';
$string['unauthorisedlogin'] = '用户帐号"{$a}" 无效';
$string['undecided'] = '未定';
$string['unexistingcmid'] = '未找到课程模块编号';
$string['unexistingsectionid'] = '未找到课程小节编号';
$string['unfinished'] = '未完';
$string['unknowncategory'] = '未知类别';
$string['unknownerror'] = '末知错误';
$string['unknownuser'] = '未知用户';
$string['unlimited'] = '无限制';
$string['unpacking'] = '对{$a}解包';
$string['unsafepassword'] = '不安全的密码――试试别的吧';
$string['untilcomplete'] = '直到完成';
$string['unusedaccounts'] = '超过{$a}天未使用的帐户将自动注销';
$string['unzip'] = '解压';
$string['unzippingbackup'] = '解压备份文件';
$string['up'] = '向上';
$string['update'] = '更新';
$string['updated'] = '已更改的{$a}';
$string['updatemymoodleoff'] = '停止自定义此页';
$string['updatemymoodleon'] = '自定义此页';
$string['updatemyprofile'] = '更新个人资料
';
$string['updatesevery'] = '每隔{$a}秒刷新一次';
$string['updatethis'] = '更改这个{$a}';
$string['updatethiscourse'] = '更改该课程';
$string['updatinga'] = '正在更改{$a}';
$string['updatingain'] = '正在更改{$a->in}中的{$a->what}';
$string['upload'] = '上传';
$string['uploadafile'] = '上传一个文件';
$string['uploadcantwrite'] = '向磁盘写入文件失败';
$string['uploadedfile'] = '文件上传成功';
$string['uploadedfileto'] = '上传{$a->file}到{$a->directory}';
$string['uploadedfiletoobig'] = '很抱歉，那个文件太大了(限制为{$a}字节)';
$string['uploadextension'] = '某个 PHP 扩展中止了文件上传';
$string['uploadfailednotrecovering'] = '您上传文件的操作并没有成功，在上传下列文件之一时有问题: {$a->name}。<br />此处是错误日志: <br />{$a->problem}<br />没有恢复。';
$string['uploadfilelog'] = '文件{$a}的上传日志';
$string['uploadformlimit'] = '上传的文件 {$a} 大小超过了表单中设置的最大尺寸限制';
$string['uploadlabel'] = '标题:';
$string['uploadlimitwithsize'] = '{$a->contextname} 上传限制 ({$a->displaysize})';
$string['uploadnewfile'] = '上传新文件';
$string['uploadnofilefound'] = '找不到文件――您能确定已经选择了一个文件上传吗?';
$string['uploadnotallowed'] = '不允许上传';
$string['uploadnotempdir'] = '没有临时文件夹';
$string['uploadoldfilesdeleted'] = '您的上传区中的旧文件已经删除了';
$string['uploadpartialfile'] = '文件只部分地上传了';
$string['uploadproblem'] = '上传文件“{$a}”时有一个未知错误发生(也许是它太大?)';
$string['uploadrenamedchars'] = '由于无效字符，文件{$a->oldname}已经更名为{$a->newname}。';
$string['uploadrenamedcollision'] = '由于存在同名文件，文件{$a->oldname}已经更名为{$a->newname}。';
$string['uploadserverlimit'] = '上传文件的大小超过了服务器设定的最大尺寸。';
$string['uploadthisfile'] = '上传这个文件';
$string['url'] = '网页地址';
$string['used'] = '已使用';
$string['usedinnplaces'] = '在{$a}处使用';
$string['user'] = '用户';
$string['useraccount'] = '用户帐号';
$string['useractivity'] = '活动';
$string['userconfirmed'] = '确认{$a}';
$string['userdata'] = '用户数据';
$string['userdeleted'] = '此用户帐号已删除';
$string['userdescription'] = '自述';
$string['userdescription_help'] = '可以在此框中输入一些关于您自己的文字。它们会在您的个人资料页中显示给其他人。';
$string['userdetails'] = '用户细节';
$string['userfiles'] = '用户文件';
$string['userfilterplaceholder'] = '选择关键词或选择筛选条件';
$string['userlist'] = '用户列表';
$string['usermenu'] = '用户菜单';
$string['usermenugoback'] = '返回用户目录';
$string['username'] = '用户名';
$string['usernameemail'] = '用户名或邮箱';
$string['usernameemailmatch'] = '用户名和 Email 地址不属于同一个用户';
$string['usernameexists'] = '这个用户名已经存在，用别的吧';
$string['usernamelowercase'] = '只允许小写字母';
$string['usernamenotfound'] = '在数据库中找不到这个用户名';
$string['usernameoremail'] = '输入用户名或电子邮件地址';
$string['usernotconfirmed'] = '不能确认{$a}';
$string['userpic'] = '用户头像';
$string['userpreferences'] = '用户偏好';
$string['users'] = '用户';
$string['userselectorautoselectunique'] = '如果只搜到一个符合的用户，就自动选择他';
$string['userselectorpreserveselected'] = '保留被选择的用户，即使他们不再符合搜索条件';
$string['userselectorsearchanywhere'] = '在显示的任意区域匹配搜索关键词';
$string['usersnew'] = '新用户';
$string['usersnoaccesssince'] = '未活动超过';
$string['userswithfiles'] = '有文件的用户';
$string['useruploadtype'] = '用户上传类型：{$a}';
$string['userzones'] = '用户区';
$string['usetheme'] = '使用此主题';
$string['usingexistingcourse'] = '使用现有课程';
$string['validatehtml'] = '验证HTML';
$string['valuealreadyused'] = '此值已被使用';
$string['version'] = '版本';
$string['view'] = '查看';
$string['viewallcourses'] = '查看所有课程';
$string['viewallcoursescategories'] = '查看所有课程和类别';
$string['viewallsubcategories'] = '浏览所有子类别';
$string['viewfileinpopup'] = '在弹出窗口中查看文件';
$string['viewing'] = '浏览';
$string['viewmore'] = '查看更多';
$string['viewprofile'] = '查看个人档案';
$string['views'] = '浏览';
$string['viewsolution'] = '查看解决方案';
$string['visible'] = '可见';
$string['visible_help'] = '这个设置决定课程是否出现在课程列表中。教师和管理员以外的其他用户都不能进入此课程。';
$string['visibletostudents'] = '对{$a}可见';
$string['warning'] = '警告';
$string['warningdeleteresource'] = '警告：在某个资源中引用了{$a}。您要更新相应的资源吗？';
$string['wcagcheck'] = 'Web内容可访问性指南（WCAG）检查';
$string['webpage'] = '网页';
$string['week'] = '教学周';
$string['weekhide'] = '从{$a}隐藏这个星期';
$string['weeklyoutline'] = '每周概要';
$string['weeks'] = '周';
$string['weekshow'] = '显示这个星期于{$a}';
$string['welcomeback'] = '欢迎回来，{$a->firstname}！👋';
$string['welcometocourse'] = '欢迎加入{$a}';
$string['welcometocoursetext'] = '欢迎您加入{$a->coursename}！如果您还没有这样做，您应该编辑您的个人档案页，以便我们可以更多地了解您： {$a->profileurl}';
$string['welcometosite'] = '欢迎，{$a->firstname}！👋';
$string['whatforlink'] = '你要如何处理这一链接？';
$string['whatforpage'] = '你要如何处理这段文字？';
$string['whatisyourage'] = '您的年龄？';
$string['whattocallzip'] = '如何命名该zip文件?';
$string['whattodo'] = '怎么处理';
$string['wheredoyoulive'] = '您的国籍？';
$string['whyisthisrequired'] = '为什么要这样做？';
$string['windowclosing'] = '本窗口会被自动关闭。如果没自动关闭，请现在关闭它。';
$string['withchosenfiles'] = '将选中的文件...';
$string['withdisablednote'] = '{$a} (停用)';
$string['withoutuserdata'] = '且不含用户资料';
$string['withselectedusers'] = '对选中的用户...';
$string['withuserdata'] = '且包含用户资料';
$string['wordforstudent'] = '您用于称呼学生的字词';
$string['wordforstudenteg'] = '例如学生、成员等等';
$string['wordforstudents'] = '您用于称呼多个学生的字词';
$string['wordforstudentseg'] = '例如学生们、成员们';
$string['wordforteacher'] = '您用于称呼教师的字词';
$string['wordforteachereg'] = '例如教师、导师、老师和教员等';
$string['wordforteachers'] = '您用于称呼多个教师的字词';
$string['wordforteacherseg'] = '例如教师们、导师们、老师们和教员们等';
$string['writingblogsinfo'] = '撰写Blog信息';
$string['writingcategoriesandquestions'] = '写入类别及题目';
$string['writingcoursedata'] = '写入课程数据';
$string['writingeventsinfo'] = '写入事件信息';
$string['writinggeneralinfo'] = '写入常规信息';
$string['writinggradebookinfo'] = '写入成绩单信息';
$string['writinggroupingsgroupsinfo'] = '正在写入大组-小组信息';
$string['writinggroupingsinfo'] = '正在写入大组信息';
$string['writinggroupsinfo'] = '写入组信息';
$string['writingheader'] = '写入标题';
$string['writingloginfo'] = '写入日志信息';
$string['writingmessagesinfo'] = '写入消息信息';
$string['writingmoduleinfo'] = '写入模块信息';
$string['writingscalesinfo'] = '写入量表信息';
$string['writinguserinfo'] = '写入用户信息';
$string['wrongpassword'] = '该用户的密码错误';
$string['yahooid'] = 'Yahoo号码';
$string['year'] = '年';
$string['years'] = '年';
$string['yes'] = '是的';
$string['youareabouttocreatezip'] = '您打算创建一个zip文件包';
$string['youaregoingtorestorefrom'] = '您即将启动恢复过程';
$string['youhaveupcomingactivitiesdue'] = '您有即将到期的活动';
$string['youhaveupcomingactivitiesdueinfo'] = '您好{$a}， <br/><br/>您有即将到期的活动：';
$string['youneedtoenrol'] = '‎要执行该操作，您需要加入本课程。‎';
$string['yourlastlogin'] = '您上次登录是在';
$string['yourself'] = '您自己';
$string['yourteacher'] = '您的{$a}';
$string['yourwordforx'] = '您称呼“{$a}”为';
$string['zippingbackup'] = '压缩备份文件';
