<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'cs', version '4.1'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Přidat';
$string['addarandomquestion'] = 'úlohy náhodně';
$string['addarandomquestion_help'] = 'Moodle přidává náhodný výběr úloh s více volbami (nebo úlohy s možností výběru více nebo více možností) do aktuální skupiny offline testu. Lze nastavit počet přidaných úloh. Úlohy jsou vybírány z aktuální kategorie úloh (a pokud jsou vybrány její podkategorie).';
$string['addarandomselectedquestion'] = 'Přidat náhodnou vybranou úlohu ...';
$string['addlist'] = 'Přidat prezenční listinu';
$string['addnewpagesafterselected'] = 'Přidat konce stránek po vybraných úlohách';
$string['addnewquestion'] = 'nová úloha';
$string['addnewquestionsqbank'] = 'Přidejte úlohu do kategorie {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Přidat přepsání uživatele';
$string['addpagebreak'] = 'Přidat konec stránky';
$string['addpagehere'] = 'Přidat stránku zde';
$string['addparts'] = 'Přidat účastníky';
$string['addquestionfrombankatend'] = 'Přidejte z banky úloh na konec';
$string['addquestionfrombanktopage'] = 'Přidat z banky úloh na stránku {$a}';
$string['addrandom'] = 'Náhodně přidejte úlohu(y) výběru z více možností {$a}';
$string['addrandomfromcategory'] = 'úlohy náhodně';
$string['addrandomquestion'] = 'úlohy náhodně';
$string['addrandomquestiontoofflinequiz'] = 'Přidávání úloh do offlinequiz {$a->name} (group {$a->group})';
$string['addrandomquestiontopage'] = 'Přidat náhodnou úlohu na stránku {$a}';
$string['addtoofflinequiz'] = 'Přidat do offline testu';
$string['addtoqueue'] = 'Přidat do fronty';
$string['allinone'] = 'Neomezený';
$string['alllists'] = 'Všechny seznamy';
$string['allornothing'] = 'Všechno nebo nic';
$string['allresults'] = 'Zobrazit všechny výsledky';
$string['allstudents'] = 'Zobrazit všechny studenty';
$string['alwaysavailable'] = 'Vždy dostupné';
$string['analysis'] = 'Analýza položek';
$string['answerform'] = 'Formulář pro odpovědi';
$string['answerformforgroup'] = 'Formulář odpovědí pro skupinu {$a}';
$string['answerforms'] = 'Formuláře odpovědí';
$string['answerpdfxy'] = 'Formulář pro odpovědi ({$a}->maxquestions questions / {$a}->maxanswers options)';
$string['areyousureremoveselected'] = 'Opravdu chcete odstranit všechny vybrané úlohy?';
$string['attemptexists'] = 'Pokus existuje';
$string['attemptsexist'] = 'Úlohy již nemůžete přidávat ani odstraňovat.';
$string['attemptsnum'] = 'Výsledky: {$a}';
$string['attemptsonly'] = 'Ukázat studenty pouze s výsledky';
$string['attendanceoverview'] = 'Účast';
$string['attendances'] = 'Presence';
$string['attendancesheadline'] = 'Docházky';
$string['backtopreview'] = 'Zobrazit Náhled';
$string['basicideasofofflinequiz'] = 'Základní myšlenky tvorby offline testu';
$string['blackwhitethreshold'] = 'Černobílý práh.';
$string['bulksavegrades'] = 'Uložit Známky';
$string['calibratescanner'] = 'Kalibrace skeneru';
$string['cannoteditafterattempts'] = 'Nelze přidávat ani odebírat úlohy, protože již existují ukončené výsledky. ({$a})';
$string['category'] = 'Kategorie';
$string['changed'] = 'Výsledek byl změněn.';
$string['changeevaluationmode'] = 'Změňte způsob, jakým se provádí hodnocení. Možné pouze tehdy, pokud to povolí správce.';
$string['checkparts'] = 'Označit vybrané účastníky jako přítomné';
$string['checkuserid'] = 'Zkontrolovat ID skupiny/uživatele';
$string['chooseagroup'] = 'Vyberte skupinu ...';
$string['closebeforeopen'] = 'Offline test nelze aktualizovat. Zadali jste datum ukončení před otevřeným datem.';
$string['closestudentview'] = 'Zavřít zobrazení studenta';
$string['closewindow'] = 'Zavřít okno';
$string['cmmissing'] = 'Chybí modul kurzu pro Offline test s ID {$a}';
$string['completiondetail:passgrade'] = 'Získat známku pro úspěšné splnění';
$string['completionpass'] = 'Splnit pro dokončení';
$string['completionpass_help'] = 'Studenti vyplní tento offline test pouze v případě, že dosáhnou vyšší nebo stejné známky, jako je známka stanovená v možnostech hodnocení';
$string['configblackwhitethreshold'] = 'Nastavuje práh pro převod černé a bílé mezi 1-99 - Čím vyšší musí být bílý importovaný pixel, aby byl rozpoznán jako bílý. Jakákoli jiná hodnota nevede k žádné černobílé konverzi vůbec.';
$string['configdecimalplaces'] = 'Počet číslic, které by měly být zobrazeny za desetinnou čárkou při zobrazování známek pro Offline test.';
$string['configdisableimgnewlines'] = 'Tato volba zakáže nové řádky před a po obrázcích v PDF  formulářích úloh. Varování: Může to vést k problémům s formátováním.';
$string['configexperimentalevaluation'] = 'Experimentální vyhodnocení formulářů s odpověďmi';
$string['configexperimentalevaluationdesc'] = 'NEPOUŽÍVEJTE K PRODUKTIVNÍMU POUŽITÍ!  Tato volba se používá pro alfa testy nového vyhodnocovacího algoritmu. Pokud je tato možnost nastavena na ano, můžete ji zapnout v možnostech instance offline kvízu. Tuto možnost důrazně nedoporučujeme používat. Pro ztracená data kvůli zapnutí této možnosti neexistuje vůbec žádná podpora.';
$string['configintro'] = 'Zde nastavené hodnoty se používají jako výchozí hodnoty pro nastavení nových Offline testů.';
$string['configkeepfilesfordays'] = 'Zajišťuje, kolik dní jsou nahrané obrázky uchovávány v dočasném úložišti. Během této doby jsou obrázky k dispozici v sestavě správce Offline testů.';
$string['configonlylocalcategories'] = 'Nejsou povoleny žádné kategorie sdílených úloh.';
$string['configpapergray'] = 'hodnota bělosti papíru, který se používá k vyhodnocení formulářů s odpověďmi';
$string['configshuffleanswers'] = 'Zamíchat odpovědi';
$string['configshufflequestions'] = 'Pokud tuto možnost povolíte, bude pořadí otázek ve skupinách Offline testů náhodně zamícháno při každém novém vytvoření náhledu na kartě „Vytvořit formuláře“.';
$string['configshufflewithin'] = 'Pokud tuto možnost povolíte, budou při vytváření formulářů úloh a odpovědí náhodně zamíchány části tvořící jednotlivé úlohy.';
$string['configuseridentification'] = 'Vzorec popisující identifikaci uživatele. Tento vzorec se používá k přiřazení formulářů odpovědí uživatelům v systému. Pravá strana rovnice musí označovat pole v uživatelské tabulce Moodle.';
$string['confirmremovequestion'] = 'Opravdu chcete odebrat tuto úlohu {$a}?';
$string['copy'] = 'Kopírovat';
$string['copyright'] = '<strong> Upozornění: Texty na této stránce slouží pouze pro vaše osobní informace. Stejně jako jiné texty jsou tyto úlohy chráněny autorskými právy. Není dovoleno je kopírovat nebo ukazovat jiným lidem! </strong>';
$string['copyselectedtogroup'] = 'Přidat vybrané úlohy do skupiny: {$a}';
$string['copytogroup'] = 'Přidat všechny úlohy do skupiny: {$a}';
$string['correct'] = 'opravit';
$string['correcterror'] = 'řešit';
$string['correctforgroup'] = 'Správné odpovědi pro skupinu {$a}';
$string['correctheader'] = 'Nutná oprava:';
$string['correctionerrors'] = 'Formuláře s opravnými chybami:';
$string['correctionform'] = 'Oprava';
$string['correctionforms'] = 'Opravné formuláře';
$string['correctionoptionsheading'] = 'Možnosti oprav';
$string['correctupdated'] = 'Aktualizovaný opravný formulář pro skupinu {$a}.';
$string['couldnotgrab'] = 'Nepodařilo se získat obrázek {$a}';
$string['couldnotregister'] = 'Nelze zaregistrovat uživatele {$a}';
$string['createcategoryandaddrandomquestion'] = 'Vytvořit kategorii a přidat náhodnou úlohu';
$string['createlistfirst'] = 'Přidat účastníky';
$string['createofflinequiz'] = 'Vytvořit formuláře';
$string['createpartpdferror'] = 'PDF formulář pro seznam účastníků {$a} nelze vytvořit. Seznam je možná prázdný.';
$string['createpdf'] = 'Formulář';
$string['createpdferror'] = 'Formulář pro skupinu {$a} nelze vytvořit. Možná ve skupině nejsou žádné úlohy.';
$string['createpdffirst'] = 'Nejprve vytvořte seznam PDF';
$string['createpdfforms'] = 'Vytvořit formuláře';
$string['createpdfs'] = 'Formuláře';
$string['createpdfsparticipants'] = 'Formuláře';
$string['createquestionandadd'] = 'Vytvořte novou úlohu a přidejte ji do testu.';
$string['createquiz'] = 'Vytvořit formuláře';
$string['csvfile'] = 'Soubor CSV';
$string['csvformat'] = 'Textový soubor hodnot oddělených čárkami (CSV)';
$string['csvplus1format'] = 'Textový soubor se surovými daty (CSV)';
$string['csvpluspointsformat'] = 'Textový soubor s tečkami (CSV)';
$string['darkgray'] = 'Tmavěšedá';
$string['datanotsaved'] = 'Nastavení se nepodařilo uložit';
$string['decimalplaces'] = 'Desetinná místa';
$string['decimalplaces_help'] = 'Počet číslic, které by měly být zobrazeny za desetinnou čárkou při zobrazování známek pro offline test.';
$string['defaultparticipantsusage'] = 'Záznam účasti';
$string['defaultparticipantsusagedesc'] = 'Určuje, zda se má docházka standardně zaznamenávat s prezenční listinou.';
$string['deletelistcheck'] = 'Opravdu chcete smazat vybraný seznam a všechny jeho účastníky?';
$string['deletepagecheck'] = 'Opravdu chcete smazat vybrané stránky?';
$string['deletepagesafterselected'] = 'Odstranit konce stránek po vybraných úlohách';
$string['deletepartcheck'] = 'Opravdu chcete vybrané účastníky smazat?';
$string['deleteparticipantslist'] = 'Smazat seznam účastníků';
$string['deletepdfs'] = 'Smazat dokumenty';
$string['deleteresultcheck'] = 'Opravdu chcete smazat vybrané výsledky?';
$string['deleteselectedpart'] = 'Smazat vybrané účastníky';
$string['deleteselectedresults'] = 'Smazat vybrané výsledky';
$string['deletethislist'] = 'Smazat tento seznam';
$string['deleteupdatepdf'] = 'Smazat a aktualizovat formuláře PDF';
$string['difficultytitle'] = 'Obtížnost';
$string['difficultytitlea'] = 'Obtížnost A';
$string['difficultytitleb'] = 'Obtížnost B';
$string['difficultytitlediff'] = 'Rozdíl';
$string['disableimgnewlines'] = 'Zakázat nové řádky před a po obrázcích';
$string['disableimgnewlines_help'] = 'Tato volba zakáže nové řádky před a po obrázcích v otázkách při tisku do PDF. Varování: Může to vést k problémům s formátováním.';
$string['displayoptions'] = 'Volby zobrazení';
$string['documentschanged'] = 'Od vytvoření dokumentů byla/byla změněna jedna nebo více úloh v offline testu.<br>Budoucí výsledky budou během hodnocení automaticky přeřazeny na aktuální verzi zde vybraných úloh. V dokumentech je stále uvedena původní verze úlohy (úloh).';
$string['documentschangedwithresults'] = 'Od vytvoření dokumentů byla/byla změněna jedna nebo více úloh v offline testu.<br>Stávající výsledky byly automaticky přeřazeny na aktuální verzi zde vybraných úloh. V dokumentech je stále uvedena původní verze úlohy (úloh).';
$string['done'] = 'hotovo';
$string['downloadallzip'] = 'Stáhnout všechny soubory jako ZIP';
$string['downloadpartpdf'] = 'Stáhnout soubor PDF pro seznam "{$a}"';
$string['downloadpdfs'] = 'Formuláře';
$string['downloadresultsas'] = 'Stáhnout výsledky jako:';
$string['dragtoafter'] = 'Po {$a}';
$string['dragtostart'] = 'Na začátku';
$string['editgroupquestions'] = 'Upravit úlohy skupiny';
$string['editgroups'] = 'Upravit skupiny offline';
$string['editingofflinequiz'] = 'Úprava otázek skupiny';
$string['editingofflinequiz_help'] = 'Při vytváření offline testu jsou hlavní myšlenky:
<ul> <li> Offline test obsahuje otázky na jedné nebo více stránkách </li>
<li> Banka otázek, kde jsou uloženy kopie všech otázek, je uspořádána do kategorií </li> </ul>';
$string['editingofflinequizx'] = 'Úlohy';
$string['editlist'] = 'Upravit seznam';
$string['editlists'] = 'Prezenční listiny';
$string['editmaxmark'] = 'Upravit maximální známku';
$string['editofflinequiz'] = 'Upravit  offline test';
$string['editofflinesettings'] = 'Upravit nastavení offline testu';
$string['editorder'] = 'Upravit pořadí';
$string['editparticipants'] = 'Upravit účastníky';
$string['editquestion'] = 'Upravit úlohu';
$string['editquestionlistitem'] = '{$a}';
$string['editquestions'] = 'Úlohy';
$string['editscannedform'] = 'Upravit naskenovaný formulář';
$string['editthislist'] = 'Upravit tento seznam';
$string['emptygroups'] = 'Některé skupiny offline testu jsou prázdné. Přidejte prosím několik úloh.';
$string['enroluser'] = 'Zapsat uživatele';
$string['erroraccessingreport'] = 'Nemáte oprávnění zobrazit tento přehled.';
$string['errormultiuserinlist'] = 'Uživatel je uveden vícekrát v prezenční listině!';
$string['errorreport'] = 'Hlášení o chybách importu';
$string['evaluated'] = 'Vyhodnoceno:';
$string['evaluation'] = '2. Hodnocení';
$string['eventattemptdeleted'] = 'Pokus o offline test byl smazán';
$string['eventattemptpreviewstarted'] = 'Náhled pokusu o offline test byl spuštěn';
$string['eventattemptreviewed'] = 'Pokus o offline test byl zkontrolován';
$string['eventattemptsummaryviewed'] = 'Zobrazen souhrn pokusu o offline test';
$string['eventattemptviewed'] = 'Pokus o offline test byl zobrazen';
$string['eventdocscreated'] = 'Byly vytvořeny formuláře úloh a odpovědí offline';
$string['eventdocsdeleted'] = 'Formuláře úloh a odpovědí offline byly odstraněny';
$string['eventeditpageviewed'] = 'Zobrazena stránka úprav offline testu';
$string['eventofflinequizattemptsubmitted'] = 'Odeslán pokus o offline test';
$string['eventoverridecreated'] = 'Bylo vytvořeno přepsání offline testu';
$string['eventoverridedeleted'] = 'Přepsání offline testu odstraněno';
$string['eventoverrideupdated'] = 'Přepsání offline testu aktualizováno';
$string['eventparticipantmarked'] = 'Účastník offline testu označen ručně';
$string['eventquestionmanuallygraded'] = 'Úlohy byly ručně známkovány';
$string['eventreportviewed'] = 'Zobrazena sestava offline testu';
$string['eventresultsregraded'] = 'Výsledky offline testu byly přeznámkovány';
$string['everythingon'] = 'povoleno';
$string['excelformat'] = 'tabulka Excel (XLSX)';
$string['experimentalevaluation'] = 'Experimentální vyhodnocení formulářů s odpověďmi';
$string['experimentalevaluation_help'] = 'Experimentální vyhodnocení formulářů s odpověďmi';
$string['fileformat'] = 'Formát pro dotazníky';
$string['fileformat_help'] = 'Zvolte, zda si přejete formuláře úloh ve formátu PDF, DOCX nebo TEX. Formuláře odpovědí a korekční listy budou vždy generovány ve formátu PDF.';
$string['fileprefixanswer'] = 'answer_form';
$string['fileprefixcorrection'] = 'correction_form';
$string['fileprefixform'] = 'question_form';
$string['fileprefixparticipants'] = 'participants_list';
$string['filesizetolarge'] = 'Některé z vašich obrazových souborů jsou velmi velké. Během interpretace budou rozměry změněny. Zkuste skenovat s rozlišením mezi 200 a 300 dpi a v černobílém režimu. To příště urychlí interpretaci.';
$string['filterbytags'] = 'Filtrovat podle štítků ...';
$string['fontsize'] = 'Velikost fontu';
$string['forautoanalysis'] = 'Pro automatickou analýzu';
$string['formforcorrection'] = 'Formulář oprav pro skupinu {$a}';
$string['formforgroup'] = 'Formulář úloh pro skupinu {$a}';
$string['formforgroupdocx'] = 'Formulář úloh pro skupinu {$a} (DOCX)';
$string['formforgrouplatex'] = 'Formulář úloh pro skupinu {$a} (LATEX)';
$string['forms'] = 'Formuláře';
$string['formsexist'] = 'Formuláře již byly vytvořeny.';
$string['formsexistx'] = 'Formuláře již byly vytvořeny (<a href="{$a}">Stáhnout formuláře</a>)';
$string['formsheetsettings'] = 'Nastavení formuláře';
$string['formspreview'] = 'Náhled';
$string['formwarning'] = 'Není definován žádný formulář odpovědí. Obraťte se na svého správce.';
$string['fromquestionbank'] = 'z banky úloh';
$string['functiondisabledbysecuremode'] = 'Tato funkce je v současné době zakázána';
$string['generalfeedback'] = 'Obecná zpětná vazba';
$string['generalfeedback_help'] = 'Obecná zpětná vazba je text, který se zobrazí po pokusu úlohy. Na rozdíl od zpětné vazby pro konkrétní úlohu, která závisí na dané odpovědi, je vždy zobrazena stejná obecná zpětná vazba.';
$string['generatepdfform'] = 'Vygenerovat formulář PDF';
$string['grade'] = 'Známka';
$string['gradedon'] = 'Hodnoceno';
$string['gradedscannedform'] = 'Naskenované formuláře se známkami';
$string['gradeiszero'] = 'Poznámka: Maximální známka pro tento offline kvíz je 0 bodů!';
$string['gradeswarning'] = 'Známky úloh musí být čísla!';
$string['gradewarning'] = 'Známkování úloh musí být číslo!';
$string['gradingofflinequiz'] = 'Známky';
$string['gradingofflinequizx'] = 'Známky';
$string['gradingoptionsheading'] = 'Možnosti známkování';
$string['greeniscross'] = 'se počítá jako propojení';
$string['group'] = 'Skupina';
$string['groupoutofrange'] = 'Skupina byla mimo rozsah a nahrazena skupinou A.';
$string['hasresult'] = 'Výsledek existuje';
$string['hotspotdeletiontask'] = 'Odstranění hotspotů';
$string['html'] = 'HTML';
$string['idnumber'] = 'Identifikátor účastníka';
$string['imagefile'] = 'Soubor obrázku';
$string['imagenotfound'] = 'Soubor obrázku {$a} nebyl nalezen!';
$string['imagenotjpg'] = 'Obrázek není jpg nebo png: {$a}';
$string['imagickwarning'] = 'Chybějící imagemagick: Požádejte správce systému, aby nainstaloval knihovnu imagemagick a zkontrolujte cestu k binárnímu převodu v nastavení filtru notace TeX. Nelze importovat soubory TIF bez imagemagick!';
$string['import'] = 'Vyhodnotit';
$string['importedon'] = 'Vyhodnoceno dne';
$string['importerror11'] = 'Existuje jiný výsledek';
$string['importerror12'] = 'Uživatel není registrován';
$string['importerror13'] = 'Žádné údaje skupiny';
$string['importerror14'] = 'Nelze zachytit';
$string['importerror15'] = 'Nejasná označení';
$string['importerror16'] = 'Chyba stránky';
$string['importerror17'] = 'Neúplné stránky';
$string['importerror21'] = 'Nelze zachytit';
$string['importerror22'] = 'Nejasná označení';
$string['importerror23'] = 'Uživatel není v seznamu';
$string['importerror24'] = 'Seznam nebyl detekován';
$string['importforms'] = 'Nahrát formuláře odpovědí';
$string['importfromto'] = 'Vyhodnocení {$a->from} do {$a->to} z {$a->total}.';
$string['importisfinished'] = 'Vyhodnocení offline testu {$a} je dokončen.';
$string['importlinkresults'] = 'Odkaz na výsledky: {$a}';
$string['importlinkverify'] = 'Odkaz na ověření: {$a}';
$string['importmailsubject'] = 'Oznámení o importu offline testu';
$string['importnew'] = 'Vyhodnotit';
$string['importnew_help'] = '<p>
Do archivu ZIP můžete importovat jednotlivé soubory naskenovaných obrázků nebo několik souborů s naskenovanými obrázky.  Modul offline testu zpracuje obrazové soubory na pozadí. Názvy souborů nejsou relevantní, ale neměly by obsahovat speciální znaky, jako jsou háčky a čárky. Obrázky by měly být GIF, PNG nebo TIF. Doporučuje se rozlišení mezi 200 a 300 dpi. </p>';
$string['importnumberexisting'] = 'Počet dvojitých formulářů: {$a}';
$string['importnumberpages'] = 'Počet úspěšně importovaných stránek: {$a}';
$string['importnumberresults'] = 'Počet importovaných: {$a}';
$string['importnumberverify'] = 'Počet formulářů, které je třeba ověřit: {$a}';
$string['importtimefinish'] = 'Proces dokončen: {$a}';
$string['importtimestart'] = 'Proces byl zahájen: {$a}';
$string['inconsistentdata'] = 'Nekonzistentní údaje: {$a}';
$string['info'] = 'informace';
$string['infoshort'] = 'i';
$string['insecuremarkings'] = 'Nejasná označení vyžadují ruční opravy';
$string['insecuremarkingsforquestion'] = 'Nejasná označení vyžadují ruční opravu úlohy';
$string['insertnumber'] = 'Vložte správné identifikační číslo označené modrým rámečkem.';
$string['instruction1'] = 'Tento formulář odpovědí bude naskenován automaticky. Prosím, neohýbejte ani nešpiňte. Pole označte černým nebo modrým perem:';
$string['instruction2'] = 'Pouze jasná označení mohou být interpretována správně! Pokud chcete opravit označení, vyplňte pole zcela barvou. Toto pole bude interpretováno jako prázdné pole:';
$string['instruction3'] = 'Opravené rámečky nelze znovu označit. Nepište prosím nic mimo rámeček.';
$string['introduction'] = 'Úvod';
$string['invalidformula'] = 'Neplatný vzorec pro identifikaci uživatele. Vzorec musí mít tvar <prefix>[<#digits>]<suffix>=<db-field&>.';
$string['invalidnumberofdigits'] = 'Neplatný počet použitých číslic. Povoleno je pouze 1 až 9 číslic.';
$string['invaliduserfield'] = 'Neplatné pole použité uživatelské tabulky.';
$string['invigilator'] = 'Autor';
$string['ischecked'] = 'Účast je zkontrolována';
$string['isnotchecked'] = 'Účast není zkontrolována';
$string['itemdata'] = 'Položka dat';
$string['keepfilesfordays'] = 'Uchovávat soubory několik dní';
$string['legend'] = 'Legenda';
$string['legenddone'] = 'Krok byl úspěšně proveden (není vyžadována žádná další akce).';
$string['legendnextitem'] = 'Je vyžadována akce v dalším pracovním postupu (možná závislost na předchozích krocích).';
$string['legendnoaction'] = 'Není požadovaná žádná akce.';
$string['legendwarning'] = 'Je vyžadována okamžitá akce.';
$string['letter'] = 'Písmeno';
$string['lightgray'] = 'Světle šedá';
$string['linktoscannedform'] = 'Zobrazit naskenovaný formulář';
$string['listnotdetected'] = 'Nelze zjistit čárový kód pro seznam!';
$string['logdeleted'] = 'Záznam v protokolu {$a} byl smazán.';
$string['logourl'] = 'URL loga';
$string['logourldesc'] = 'URL obrazového souboru, který je zobrazen v pravém horním rohu formulářů odpovědí, tj. <b>http://www.yoursite.tld/mylogo.png</b> nebo <b>../path/to/your/logo.png</b>.  Maximální povolená velikost je 520x140 pixelů. Formuláře s odpověďmi nelze vyhodnotit, pokud obrázek přesahuje maximální velikost!';
$string['lowertrigger'] = 'Dolní druhá hranice';
$string['lowertriggerzero'] = 'Dolní druhá hranice je nula';
$string['lowerwarning'] = 'Dolní první hranice';
$string['lowerwarningzero'] = 'Dolní první hranice je nula';
$string['marginwarning'] = 'Vytiskněte prosím následující soubory PDF bez dalších okrajů! <br /> Vyhněte se předávání fotokopií studentům.';
$string['marks'] = 'Známky';
$string['matrikel'] = 'číslo studenta';
$string['maxgradewarning'] = 'Maximální známka musí být číslo!';
$string['maxmark'] = 'Maximální známka';
$string['membersinplist'] = '{$a->count} účastníků v <a href="{$a->url}">{$a->name}</a>';
$string['missingimagefile'] = 'Chybí soubor obrázku';
$string['missingitemdata'] = 'Chybějící odpovědi uživatele {$a}';
$string['missinglogdata'] = 'Chybějící protokol pro existující výsledek.';
$string['missingquestion'] = 'Zdá se, že tato otázka již neexistuje';
$string['missinguserid'] = 'Chybí identifikační číslo uživatele! Nelze číst čárový kód!';
$string['modulename'] = 'Offline test';
$string['modulename_help'] = 'Tento modul umožňuje učiteli navrhovat offline testy skládající se z úloh s možností výběru z více možností.
Tyto úlohy jsou uchovávány v bance úloh Moodle a mohou být znovu použity v kurzech a dokonce i mezi kurzy.
Offline testy lze stáhnout jako soubory PDF, DOCX nebo LaTeX. Studenti označí své odpovědi na formulářích. Formuláře se skenují a odpovědi se importují do systému.';
$string['modulenameplural'] = 'Offline testy';
$string['moodleprocessing'] = 'Nechte Moodle zpracovat data';
$string['movecorners'] = 'Nejprve změňte polohu rohových značek. Použijte drag and drop.';
$string['moveselectedonpage'] = 'Přesunout vybrané otázky na stránku: {$a}';
$string['multianswersforsingle'] = 'Více odpovědí na jednu otázku';
$string['multichoice'] = 'Více možností';
$string['multipleanswers'] = 'Vyberte alespoň jednu odpověď.';
$string['name'] = 'Název offline testu';
$string['neededcorrection'] = '<strong> Pozor: Některá z vašich značek potřebovala ruční opravu. Podívejte se na červené čtverečky na následujícím obrázku.<br /> To implikovalo manuální zásah učitele a zpozdilo zveřejňování výsledků offline testu! </strong>';
$string['newgrade'] = 'Známkováno';
$string['newpage'] = 'Nová stránka';
$string['noattemptexists'] = 'Neexistuje žádný výsledek';
$string['noattempts'] = 'Nebyly importovány žádné výsledky!';
$string['noattemptsonly'] = 'Zobrazit pouze studenty bez výsledků';
$string['nocourse'] = 'Kurz s id {$a->course} , do kterého patří offline kvíz s ID {$a->offlinequiz}, chybí.';
$string['nogradesseelater'] = 'Tento test ještě nebyl pro {$a} hodnocen. Výsledky budou zveřejněny zde.';
$string['nogroupdata'] = 'Pro uživatele {$a} nejsou žádná data skupiny';
$string['nomcquestions'] = 'Ve skupině {$a} nejsou žádné otázky s více možnostmi výběru!';
$string['noofflinequiz'] = 'Neexistuje žádný offline test s ID {$a}!';
$string['nopages'] = 'Nebyly importovány žádné stránky';
$string['noparticipantsfound'] = 'Nebyli nalezeni žádní účastníci';
$string['nopdfscreated'] = 'Nebyly vytvořeny žádné dokumenty!';
$string['noquestions'] = 'Některé skupiny offline testu jsou prázdné. Přidejte prosím několik úloh.';
$string['noquestionselected'] = 'Nejsou vybrány žádné otázky!';
$string['noquestionsfound'] = 'Ve skupině nejsou žádné otázky {$a}!';
$string['noquestionsonpage'] = 'Prázdná stránka';
$string['noresults'] = 'Nejsou žádné výsledky.';
$string['noreview'] = 'Nemáte povoleno tento offline test zkontrolovat';
$string['noscannedpage'] = 'Neexistuje žádná naskenovaná stránka s ID {$a}!';
$string['notagselected'] = 'Nebyl vybrán žádný štítek';
$string['nothingtodo'] = 'Není co dělat!';
$string['notonattendancelist'] = 'Není na prezenční listině:';
$string['notxtfile'] = 'Žádný soubor TXT';
$string['notyetgraded'] = 'Doposud neznámkováno';
$string['nozipfile'] = 'Žádný soubor ZIP';
$string['numattempts'] = 'Počet importovaných výsledků: {$a}';
$string['numattemptsqueue'] = 'Do fronty byly přidány formuláře odpovědí {$a}. Po zpracování dat bude na vaši adresu zaslán e-mail.';
$string['numattemptsverify'] = 'Naskenované formuláře čekající na opravu: {$a}';
$string['numberformat'] = 'Hodnota musí být číslo s {$a} číslicemi!';
$string['numbergroups'] = 'Počet skupin';
$string['numpages'] = 'Importováno {$a} stránek';
$string['numquestionsx'] = 'Úlohy: {$a}';
$string['numusersadded'] = 'Přidáno {$a} účastníků';
$string['odsformat'] = 'OpenDocument spreadsheet (ODS)';
$string['offlineimplementationfor'] = 'Implementace offline pro';
$string['offlinequiz:addinstance'] = 'Přidat offline test';
$string['offlinequiz:attempt'] = 'Pokus testů';
$string['offlinequiz:changeevaluationmode'] = 'Umožňují změnit režim hodnocení. VAROVÁNÍ: NEPOUŽÍVEJTE V PRODUKČNÍM SYSTÉMu!';
$string['offlinequiz:createofflinequiz'] = 'Vytvořit offline testové formuláře';
$string['offlinequiz:deleteattempts'] = 'Odstranit výsledky offline testu';
$string['offlinequiz:grade'] = 'Manuální známkování offline testu';
$string['offlinequiz:manage'] = 'Správa offline testů';
$string['offlinequiz:preview'] = 'Náhled offline testů';
$string['offlinequiz:view'] = 'Zobrazit informace o offline testu';
$string['offlinequiz:viewreports'] = 'Zobrazit sestavy offline testu';
$string['offlinequizcloses'] = 'Offline test se zavře';
$string['offlinequizcloseson'] = 'Revize tohoto offline testu bude ukončena v {$a}';
$string['offlinequizcontent'] = 'Obsah offline testu';
$string['offlinequizisclosed'] = 'Offline test byl uzavřen';
$string['offlinequizisclosedwillopen'] = 'Offline test byl uzavřen (otevře se {$a})';
$string['offlinequizisopen'] = 'Tento offline test je otevřený';
$string['offlinequizisopenwillclose'] = 'Offline test otevřen (uzavře se {$a})';
$string['offlinequizopenedon'] = 'Tento offline test byl otevřen v {$a}';
$string['offlinequizopens'] = 'Otevře se offline test';
$string['offlinequizsettings'] = 'Nastavení offline';
$string['offlinequizwillopen'] = 'Offline test se otevře {$a}';
$string['oneclickenrol'] = 'Zápis 1-klik';
$string['oneclickenroldesc'] = 'Pokud je tato možnost aktivována, mají učitelé možnost zaregistrovat uživatele jedním kliknutím při opravě formulářů odpovědí (chyba „Uživatel není v kurzu“).';
$string['oneclickrole'] = 'Role pro Zápis 1-klik';
$string['oneclickroledesc'] = 'Vybrat roli používanou pro registraci jedním kliknutím. Lze vybrat pouze role s archetypem „student“.';
$string['onlylocalcategories'] = 'Pouze lokální kategorie úloh';
$string['orderandpaging'] = 'Řazení a stránkování';
$string['orderandpaging_help'] = 'Čísla 10, 20, 30, ... oproti každé otázce označují pořadí otázek. Čísla se zvyšují v krocích po 10 a ponechávají tak prostor pro další otázky.Chcete-li změnit pořadí otázek, změňte čísla a klikněte na tlačítko „Změnit pořadí otázek“.

Chcete-li přidat konce stránek po konkrétních otázkách, zaškrtněte políčka vedle otázek a klikněte na tlačítko „Přidat konce stránek po vybraných otázkách“.

Chcete-li uspořádat otázky na více stránek, klikněte na tlačítko Přeformátovat a vyberte požadovaný počet otázek na stránku.';
$string['orderingofflinequiz'] = 'Řazení a stránkování';
$string['otherresultexists'] = 'Již existuje Jiný výsledek pro {$a} , import ignorován! Nejprve smažte výsledek.';
$string['outof'] = '{$a->grade} z maxima {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Celková zpětná vazba';
$string['overview'] = 'Informace o testu';
$string['overviewdownload_help'] = 'Stáhnout Přehled';
$string['page-mod-offlinequiz-edit'] = 'Upravit stránku offline testu';
$string['page-mod-offlinequiz-x'] = 'Libovolná stránka offline testu';
$string['pagecorrected'] = 'Byl importován opravený list seznamu účastníků';
$string['pageevaluationtask'] = 'Vyhodnocení listu s odpověďmi pro doplněk offlinequiz';
$string['pageimported'] = 'List se seznamem účastníků byl importován';
$string['pagenotdetected'] = 'Pro stránku nelze zjistit čárový kód!';
$string['pagenumberimported'] = 'Byl importován list {$a} seznamu účastníků';
$string['pagenumberupdate'] = 'Aktualizace čísla stránky';
$string['pagesinprocessing'] = 'Ve zpracování:';
$string['pagesizeparts'] = 'Účastníků na stránce:';
$string['papergray'] = 'Bílá hodnota papíru';
$string['papergray_help'] = 'Pokud jsou bílé části naskenovaných formulářů odpovědí velmi tmavé, můžete to napravit nastavením této hodnoty na tmavě šedou.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">{$a->count} kontrolovaní účastníci bez výsledku</a>';
$string['partcheckedwithresult'] = '{$a} kontrolovaní účastníci bez výsledku';
$string['partial'] = 'částečně';
$string['participants'] = 'Účastníci';
$string['participants_help'] = '<p> Seznamy účastníků jsou určeny pro velké offline testy s mnoha účastníky. Pomáhají učiteli zkontrolovat, kteří studenti se testu zúčastnili a zda byly všechny výsledky importovány správně.
Můžete přidat uživatele do různých seznamů. Každý seznam může například obsahovat účastníky v konkrétní místnosti. Účastníci mohou být členy zvláštní skupiny. K vytvoření těchto skupin lze použít nástroj pro registraci skupin.
Seznamy účastníků lze stáhnout jako dokumenty PDF, vytisknout a označit křížky, stejně jako formuláře odpovědí offline testů. Poté je lze nahrát a označení studenti budou označeni jako přítomní v databázi.
Vyhněte se místům na čárových kódech, protože se používají k identifikaci studentů. </p>';
$string['participantsinlists'] = 'Účastníci';
$string['participantslist'] = 'Seznam účastníků';
$string['participantslists'] = 'Účastníci';
$string['participantsusage'] = 'Záznam účasti';
$string['participantsusage_help'] = 'Tato volba určuje, zda můžete evidovat docházku účastníků s prezenční listinou. Prezenční listiny jsou určeny pro velké offline testy s mnoha účastníky. Pomocí nich lze zkontrolovat, kteří studenti se testu zúčastnili a zda byly všechny výsledky vyhodnoceny správně.';
$string['partimportnew'] = 'Nahrávání seznamů účastníků';
$string['partimportnew_help'] = '<p>
Na této kartě můžete nahrát  a vyhodnotit vyplněné seznamy účastníků. Do ZIP archivu můžete nahrát jeden naskenovaný obrazový soubor nebo několik naskenovaných obrazových souborů. Modul offline testu zpracuje obrazové soubory na pozadí.
Názvy souborů nejsou relevantní, ale neměly by obsahovat speciální znaky, jako jsou háčky a čárky.
Obrázky by měly být GIF, PNG nebo TIF. Doporučuje se rozlišení mezi 200 a 300 dpi. </p>';
$string['partuncheckedwithoutresult'] = '{$a} nekontrolovaní účastníci bez výsledku';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">{$a->count} nekontrolovaní účastníci bez výsledku</a>';
$string['pdfdeletedforgroup'] = 'Formulář pro skupinu {$a} byl smazán';
$string['pdfintro'] = 'Dodatečné informace';
$string['pdfintro_help'] = 'Tyto informace budou vytištěny na první stránce dotazníku a měly by obsahovat obecné informace o tom, jak vyplnit formulář odpovědí.';
$string['pdfintrotext'] = '<b> Jak správně vyplnit? </b> <br />Tento formulář odpovědí bude naskenován automaticky. Prosím, neohýbejte ani nešpiňte. Pole označte černým nebo modrým perem. Pokud chcete opravit označení, zcela vyplňte pole barvou. Toto pole bude interpretováno jako prázdné pole. <br />';
$string['pdfintrotoolarge'] = 'Úvod je příliš dlouhý (max. 2 000 znaků).';
$string['pdfscreated'] = 'Byly vytvořeny formuláře PDF';
$string['pdfsdeletedforgroup'] = 'Formuláře pro skupinu {$a} byly smazány';
$string['pearlywhite'] = 'Perleťově bílá';
$string['pluginadministration'] = 'Správa offline testu';
$string['pluginname'] = 'Offline testu';
$string['point'] = 'bod';
$string['preparation'] = '1. Příprava';
$string['present'] = 'přítomný';
$string['preventsamequestion'] = 'Zamezit vícenásobnému použití stejné otázky v různých skupinách';
$string['preview'] = 'Náhled';
$string['previewforgroup'] = 'Skupina {$a}';
$string['previewquestion'] = 'Náhled úlohy';
$string['printstudycodefield'] = 'Vytiskněte pole se studijním kódem na dotazníku';
$string['printstudycodefield_help'] = 'Pokud je zaškrtnuto, pole studijní kód bude vytištěn na první stránce dotazníku.';
$string['privacy:data_folder_name'] = 'Data offline testu';
$string['privacy:metadata:core_files'] = 'Offline test používá souborové API k ukládání vygenerovaných dotazů a odpovědí a vyplněných odpovědních listů.';
$string['privacy:metadata:core_question'] = 'Offline test používá API otázky pro ukládání otázek pro nabídky.';
$string['privacy:metadata:offlinequiz'] = 'Tabulka offlinequiz ukládá všechny informace specifické pro instanci Offline testu.';
$string['privacy:metadata:offlinequiz:course'] = 'Sloupec "course" v tabulce offlinequiz ukládá, v jakém kurzu je tento offline test uložen.';
$string['privacy:metadata:offlinequiz:decimalpoints'] = 'Počet desetinných míst, které se mají pro známky vypočítat.';
$string['privacy:metadata:offlinequiz:disableimgnewlines'] = 'Měly by zakázat nové řádky před a po obrázcích.';
$string['privacy:metadata:offlinequiz:docscreated'] = 'Pokud byly dokumenty vytvořeny, je toto pole nastaveno na 1, jinak jeho 0.';
$string['privacy:metadata:offlinequiz:fileformat'] = 'Formát souboru, který se používá k tisku dotazníků, 0 pro pdf, 1 pro docx, 2 pro LaTeX.';
$string['privacy:metadata:offlinequiz:fontsize'] = 'Velikost písma v otázkách.';
$string['privacy:metadata:offlinequiz:grade'] = 'Hodnocení ukazuje maximální počet bodů, které lze získat v tomto offline testu.';
$string['privacy:metadata:offlinequiz:id_digits'] = 'Uloží množství číslic, které mělo identifikační číslo při vytváření odpovědních listů. To je nezbytné pro zpětnou kompatibilitu, pokud je hodnota zvýšena mezi vytvořením a importem odpovědních listů.';
$string['privacy:metadata:offlinequiz:introformat'] = 'Toto pole se nepoužívá.';
$string['privacy:metadata:offlinequiz:name'] = 'Sloupec „name“ ukládá název offline testu.';
$string['privacy:metadata:offlinequiz:numgroups'] = 'Tento offline test má množství skupin.';
$string['privacy:metadata:offlinequiz:papergray'] = 'Hodnota bílé tohoto offline testu';
$string['privacy:metadata:offlinequiz:pdfintro'] = 'Další informace, které jsou vloženy do listů otázek na začátku.';
$string['privacy:metadata:offlinequiz:printstudycodefield'] = 'Předvolba, pokud má být studijní kód  vytištěn na formuláři otázek. 1 pro pravdu, 0 jinak.';
$string['privacy:metadata:offlinequiz:review'] = 'Tento sloupec ukládá informace o tom, jak se kontrola provádí.';
$string['privacy:metadata:offlinequiz:showgrades'] = 'Uloží, pokud by měl být počet bodů za otázku vytištěn na dotazníku.';
$string['privacy:metadata:offlinequiz:showquestioninfo'] = 'Uloží, pokud by se měla zobrazit informace o otázkách, 0 pro ne, 1 pro informaci o typu otázky, 2 pro otázku o množství správných odpovědí.';
$string['privacy:metadata:offlinequiz:showtutorial'] = 'Uloží, pokud by měli být studenti požádáni, aby provedli offline test.';
$string['privacy:metadata:offlinequiz:shufflequestions'] = 'Preference, pokud mají být otázky při vytváření testu zamíchány. 1 pro míchání, 0 jinak.';
$string['privacy:metadata:offlinequiz:time'] = 'Sloupec Čas uloží datum offline testu.';
$string['privacy:metadata:offlinequiz:timeclose'] = 'Sloupec timeclose se uloží, když byl / bude offline test uzavřen.';
$string['privacy:metadata:offlinequiz:timecreated'] = 'Sloupec timecreated uloží čas vytvoření offline testu.';
$string['privacy:metadata:offlinequiz:timemodified'] = 'Sloupec timemodified ukládá čas, kdy byl offline test naposledy změněn.';
$string['privacy:metadata:offlinequiz:timeopen'] = 'Sloupec timeopen se uloží, když byl / bude offline test otevřen.';
$string['privacy:metadata:offlinequiz_choices'] = 'Tato tabulka obsahuje informace o všech propojeních pro všechny naskenované stránky. Informace jsou potřebné pro pozdější vytvoření výsledků na základě propojení.';
$string['privacy:metadata:offlinequiz_choices:choicenumber'] = 'Číslo volby pro tuto otázku.';
$string['privacy:metadata:offlinequiz_choices:scannedpageid'] = 'Naskenovaná stránka, na kterou se volba vztahuje.';
$string['privacy:metadata:offlinequiz_choices:slotnumber'] = 'Místo této volby u otázky.';
$string['privacy:metadata:offlinequiz_choices:value'] = 'Je volba považována za propojení. 0 pro ne, 1 pro ano, -1 pro nejistotu.';
$string['privacy:metadata:offlinequiz_group_questions'] = 'Tato tabulka ukládá všechny otázky pro všechny skupiny offline testů.';
$string['privacy:metadata:offlinequiz_group_questions:maxmark'] = 'Maximální počet bodů, které lze za tuto otázku dosáhnout.';
$string['privacy:metadata:offlinequiz_group_questions:offlinegroupid'] = 'Skupina offline testu, ke které se tato skupina týká.';
$string['privacy:metadata:offlinequiz_group_questions:offlinequizid'] = 'Offline test id, ke které se tato otázka skupiny vztahuje.';
$string['privacy:metadata:offlinequiz_group_questions:page'] = 'Stránka, na které je tato otázka vytištěna v odpovědních listech.';
$string['privacy:metadata:offlinequiz_group_questions:position'] = 'Pozice v tomto offline testu.';
$string['privacy:metadata:offlinequiz_group_questions:questionid'] = 'ID vybrané otázky.';
$string['privacy:metadata:offlinequiz_group_questions:slot'] = 'Slot na otázku v testu.';
$string['privacy:metadata:offlinequiz_groups'] = 'Tabulka pro skupiny, kterých se offline testů účastní.';
$string['privacy:metadata:offlinequiz_groups:answerfilename'] = 'Název souboru, který byl použit k uložení souboru odpovědí.';
$string['privacy:metadata:offlinequiz_groups:correctionfilename'] = 'Soubor, který byl použit k uložení revidovaného souboru.';
$string['privacy:metadata:offlinequiz_groups:number'] = 'Číslo skupiny pro tento offline test, 1 pro skupinu A, 2 skupinu B atd.';
$string['privacy:metadata:offlinequiz_groups:numberofpages'] = 'Množství stránek, na které je třeba odpovědi vytisknout.';
$string['privacy:metadata:offlinequiz_groups:offlinequizid'] = 'ID offline testu, do kterého offline test patří.';
$string['privacy:metadata:offlinequiz_groups:questionfilename'] = 'Název souboru, který byl použit k uložení souboru otázek.';
$string['privacy:metadata:offlinequiz_groups:sumgrades'] = 'Součet všech známek pro všechny otázky v této skupině.';
$string['privacy:metadata:offlinequiz_groups:templateusageid'] = 'ID použití šablony, které se používá k vytvoření výsledku v testovém rozhraní API.';
$string['privacy:metadata:offlinequiz_hotspots'] = 'Tato tabulka ukládá všechny pozice polí a pokud jsou úspěšně vyhodnocena.';
$string['privacy:metadata:offlinequiz_hotspots:blank'] = 'Pokud je hotspot úspěšně analyzován.';
$string['privacy:metadata:offlinequiz_hotspots:name'] = 'Typ hotspotu, např. u%number pro hotspot uživatele, a-0-0 pro otázku 1 odpověď 1 atd.';
$string['privacy:metadata:offlinequiz_hotspots:scannedpageid'] = 'Naskenovaná stránka, na které je aktivní bod (hotspot).';
$string['privacy:metadata:offlinequiz_hotspots:time'] = 'Poslední čas aktualizace tohoto aktivního bodu (hotspotu).';
$string['privacy:metadata:offlinequiz_hotspots:x'] = 'Hodnota x aktivního bodu (hotspotu).';
$string['privacy:metadata:offlinequiz_hotspots:y'] = 'Hodnota y aktivního bodu (hotspotu).';
$string['privacy:metadata:offlinequiz_p_choices'] = 'Tato tabulka ukládá všechny propojení pro seznamy účastníků.';
$string['privacy:metadata:offlinequiz_p_choices:scannedpageid'] = 'Naskenovaná stránka, na kterou se tato volba vztahuje.';
$string['privacy:metadata:offlinequiz_p_choices:userid'] = 'ID uživatele, kterého se tato volba týká.';
$string['privacy:metadata:offlinequiz_p_choices:value'] = 'Pokud je propojení vyplněno nebo ne (0 pro nevyplněné, 1 pro vyplněné, -1 pro nezabezpečené).';
$string['privacy:metadata:offlinequiz_p_lists'] = 'Tato tabulka ukládá informace o seznamech účastníků, kde mohou učitelé zaškrtnout, pokud tam student byl nebo ne.';
$string['privacy:metadata:offlinequiz_p_lists:filename'] = 'Název souboru seznamu.';
$string['privacy:metadata:offlinequiz_p_lists:name'] = 'Název seznamu účastníků.';
$string['privacy:metadata:offlinequiz_p_lists:number'] = 'Číslo seznamu v offline testu.';
$string['privacy:metadata:offlinequiz_p_lists:offlinequizid'] = 'Offline test patřící tomuto seznamu.';
$string['privacy:metadata:offlinequiz_page_corners'] = 'Tato tabulka ukládá všechny rohy pro každou naskenovanou stránku, aby ji bylo možné rychleji vyhodnotit pro další vyhodnocení nebo revizi.';
$string['privacy:metadata:offlinequiz_page_corners:position'] = 'Informace, zda je tento roh nahoře nebo dole a vpravo nebo vlevo.';
$string['privacy:metadata:offlinequiz_page_corners:scannedpageid'] = 'Naskenovaná stránka, v níž je tento roh.';
$string['privacy:metadata:offlinequiz_page_corners:x'] = 'Hodnota x rohu.';
$string['privacy:metadata:offlinequiz_page_corners:y'] = 'Hodnota y rohu.';
$string['privacy:metadata:offlinequiz_participants'] = 'Tabulka účastníků uloží, zda se uživatel offline testu zúčastnil nebo ne.';
$string['privacy:metadata:offlinequiz_participants:checked'] = 'Informace o tom, zda byl tento uživatel v seznamu účastníků zkontrolován.';
$string['privacy:metadata:offlinequiz_participants:listid'] = 'ID seznamu, na kterém je tento účastník aktivní.';
$string['privacy:metadata:offlinequiz_participants:userid'] = 'Userid uživatele.';
$string['privacy:metadata:offlinequiz_queue'] = 'Tato tabulka ukládá frontu nahrávání. Pro každé nahrání je v této tabulce vlastní objekt.';
$string['privacy:metadata:offlinequiz_queue:importuserid'] = 'Userid učitele, který soubory nahrál.';
$string['privacy:metadata:offlinequiz_queue:offlinequizid'] = 'ID offline testu fronty.';
$string['privacy:metadata:offlinequiz_queue:status'] = 'Stav potřebné fronty.';
$string['privacy:metadata:offlinequiz_queue:timecreated'] = 'Čas, kdy byly tyto offline testy importovány.';
$string['privacy:metadata:offlinequiz_queue:timefinish'] = 'Čas ukončení hodnocení fronty.';
$string['privacy:metadata:offlinequiz_queue:timestart'] = 'Čas zahájení hodnocení fronty.';
$string['privacy:metadata:offlinequiz_queue_data'] = 'Tato tabulka ukládá data pro frontu, protože každý soubor ve frontě získá datový objekt fronty.';
$string['privacy:metadata:offlinequiz_queue_data:error'] = 'Pokud je stav chybný, zobrazí se zde podrobnější chybová zpráva.';
$string['privacy:metadata:offlinequiz_queue_data:filename'] = 'Název souboru, kterým tento objekt datové fronty.';
$string['privacy:metadata:offlinequiz_queue_data:queueid'] = 'Fronta, do které tato data patří.';
$string['privacy:metadata:offlinequiz_queue_data:status'] = 'Stav dat fronty.';
$string['privacy:metadata:offlinequiz_results'] = 'Tato tabulka ukládá všechna výsledná data, která nelze uložit v testovém rozhraní API.';
$string['privacy:metadata:offlinequiz_results:offlinegroupid'] = 'Skupina offline testu, do které tento výsledek patří.';
$string['privacy:metadata:offlinequiz_results:offlinequizid'] = 'Offline testu, do kterého tento výsledek patří.';
$string['privacy:metadata:offlinequiz_results:status'] = 'Stav výsledku (neúplný nebo úplný).';
$string['privacy:metadata:offlinequiz_results:sumgrades'] = 'Součet všech známek pro tento výsledek.';
$string['privacy:metadata:offlinequiz_results:teacherid'] = 'Učitel, který výsledek nahrál.';
$string['privacy:metadata:offlinequiz_results:timefinish'] = 'Čas ukončení prvního vložení výsledku.';
$string['privacy:metadata:offlinequiz_results:timemodified'] = 'Datum úpravy výsledku.';
$string['privacy:metadata:offlinequiz_results:timestart'] = 'Počáteční čas  prvního vložení výsledku.';
$string['privacy:metadata:offlinequiz_results:usageid'] = 'ID použití šablony testu API, kde je tento výsledek uložen.';
$string['privacy:metadata:offlinequiz_results:userid'] = 'Uživatel, kterému tento výsledek patří.';
$string['privacy:metadata:offlinequiz_scanned_p_pages'] = 'Tato tabulka ukládá stránky účastníků a jejich obecné informace.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:error'] = 'Chyba (pokud existuje), kterou tato stránka spustila při zpracování.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:filename'] = 'Název souboru pro naskenovanou stránku.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:listnumber'] = 'Číslo listu.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:offlinequizid'] = 'Offline test, do kterého tato stránka účastníků patří.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:status'] = 'Stav této naskenované stránky.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:time'] = 'Čas zpracování této stránky.';
$string['privacy:metadata:offlinequiz_scanned_pages'] = 'Tabulka ukládá informace o naskenované stránce offline testu.';
$string['privacy:metadata:offlinequiz_scanned_pages:error'] = 'Podrobná chyba na této stránce (pokud existuje).';
$string['privacy:metadata:offlinequiz_scanned_pages:filename'] = 'Název naskenované stránky.';
$string['privacy:metadata:offlinequiz_scanned_pages:groupnumber'] = 'Číslo skupiny, do které tento offline test patří.';
$string['privacy:metadata:offlinequiz_scanned_pages:offlinequizid'] = 'Offline test naskenované stránky.';
$string['privacy:metadata:offlinequiz_scanned_pages:pagenumber'] = 'Číslo této stránky.';
$string['privacy:metadata:offlinequiz_scanned_pages:resultid'] = 'Výsledek týkající se této stránky.';
$string['privacy:metadata:offlinequiz_scanned_pages:status'] = 'Stav této stránky.';
$string['privacy:metadata:offlinequiz_scanned_pages:time'] = 'Čas zpracování stránky.';
$string['privacy:metadata:offlinequiz_scanned_pages:userkey'] = 'Klíč uživatele (ne userid) propojeného uživatele na stránce.';
$string['privacy:metadata:offlinequiz_scanned_pages:warningfilename'] = 'Název souboru, který je vytvořen při nesprávně vyplněném testu, je opraven a uživatel o tom obdrží varování.';
$string['questionanalysis'] = 'Analýza úloh';
$string['questionanalysistitle'] = 'Tabulka analýzy úloh';
$string['questionandansweranalysis'] = 'Analýza úloh a odpovědí';
$string['questionbankcontents'] = 'Obsah banky úloh';
$string['questionforms'] = 'Formuláře úloh';
$string['questioninfoanswers'] = 'Počet správných odpovědí';
$string['questioninfocorrectanswer'] = 'správná odpověď';
$string['questioninfocorrectanswers'] = 'správné odpovědi';
$string['questioninfonone'] = 'Nic';
$string['questioninfoqtype'] = 'Typ úlohy';
$string['questionname'] = 'Název úlohy';
$string['questionpage'] = 'Stránka';
$string['questionsheet'] = 'Seznam úloh';
$string['questionsin'] = 'Úlohy v';
$string['questionsingroup'] = 'Skupina';
$string['questionsinthisofflinequiz'] = 'Úlohy v tomto offline testu';
$string['questiontextisempty'] = '[Prázdný text úlohy]';
$string['quizdate'] = 'Datum offline testu';
$string['quizopenclose'] = 'Datum zahájení a ukončení';
$string['quizopenclose_help'] = 'Online recenze může být omezena na určité časové období. Kliknutím na „Zobrazit“ změníte nastavení data a času.

**Upozornění:** Pokud není aktivováno žádné časové období pro online recenzi, je recenze neomezená, dokud je offline test pro účastníky viditelný.

Ve všech případech se zobrazí pouze možnosti zaškrtnuté pod "Recenze zahrnuje".';
$string['qversioncannotupdate'] = 'Verze úlohy nelze aktualizovat';
$string['qversionnumbersdiffer'] = 'Počet odpovědí se mezi starou a novou verzí liší. To by vedlo k nesrovnalostem.';
$string['qversionupdated'] = 'Verze úlohy se změnila';
$string['qversionupdatedwarning'] = 'Formuláře již byly vytvořeny.<br>Pokud existují výsledky, byly automaticky přeřazeny na aktuální verzi zde vybrané změněné úlohy. V dokumentech je stále uvedena původní verze úlohy.';
$string['qversionupdateerror'] = 'Při aktualizaci verze úlohy došlo k chybě.';
$string['randomfromexistingcategory'] = 'Náhodná otázka z existující kategorie';
$string['randomnumber'] = 'Počet náhodných otázek';
$string['randomquestionusinganewcategory'] = 'Náhodná otázka s použitím nové kategorie';
$string['readjust'] = 'Přizpůsobit';
$string['reallydeletepdfs'] = 'Opravdu chcete odstranit soubory formuláře?';
$string['reallydeleteupdatepdf'] = 'Opravdu chcete odstranit a aktualizovat seznam účastníků?';
$string['recordupdateanddocscreated'] = 'Úlohy byly aktualizovány, ale protože formuláře jsou již vytvořeny, předchozí verze úlohy je stále aktivní. Chcete-li přejít na novější verzi, smažte formuláře a změňte verzi ručně.';
$string['recordupdateanddocscreatedversion'] = 'Úlohy byly aktualizovány, ale formuláře jsou již vytvořeny. Zkontrolujte prosím, zda změny nezanesly nějaké změny, které by ovlivnily hodnocení.';
$string['recreatepdfs'] = 'Znovu vytvořit soubory PDF';
$string['recurse'] = 'Zahrnout také otázky z podkategorií';
$string['rediswrong'] = 'špatný propojení nebo chybějící propojení';
$string['refreshpreview'] = 'Obnovit náhled';
$string['regrade'] = 'Přeznámkování';
$string['regradedisplayexplanation'] = '<b> Pozor: </b> Změna známek nezmění známky, které byly přepsány ručně!';
$string['regradinginfo'] = 'Pokud v otázce změníte skóre, musíte aktualizovat offline test a aktualizovat výsledky účastníků.';
$string['regradingquiz'] = 'Přeznámkování';
$string['regradingresult'] = 'Změna známky pro uživatele {$a}...';
$string['reloadpreview'] = 'Znovu načíst náhled';
$string['reloadquestionlist'] = 'Znovu načíst seznam úloh';
$string['remove'] = 'Odstranit';
$string['removeemptypage'] = 'Odstranit prázdné stránky';
$string['removepagebreak'] = 'Odstranit zalomení stránky';
$string['removeselected'] = 'Odstranit vybrané';
$string['reordergroupquestions'] = 'Změnit pořadí skupin';
$string['reorderquestions'] = 'Změna pořadí otázek';
$string['reordertool'] = 'Zobrazit nástroj pro přeskupování';
$string['repaginate'] = 'Přestránkujte s {$a} otázkami na stránku';
$string['repaginatecommand'] = 'Přestránkovat';
$string['repaginatenow'] = 'Přestránkovat nyní';
$string['reportends'] = 'Kontrola výsledků končí';
$string['reportoverview'] = 'Přehled';
$string['reportstarts'] = 'Kontrola výsledků začíná';
$string['resetofflinequizzes'] = 'Obnovit data offline testu';
$string['resultexists'] = 'Stejný výsledek {$a} již existuje, import je ignorován';
$string['resultimport'] = 'Nahrát';
$string['results'] = 'Výsledek';
$string['resultsavailable'] = 'Množství dostupných výsledků:';
$string['review'] = 'Revidovat';
$string['reviewbefore'] = 'Povolit kontrolu při otevřeném kvízu testu';
$string['reviewclosed'] = 'Po ukončení offline testu';
$string['reviewcloses'] = 'Revize se uzavře';
$string['reviewimmediately'] = 'Ihned po pokusu';
$string['reviewincludes'] = 'Revize zahrnuje';
$string['reviewofresult'] = 'Revize výsledku';
$string['reviewopens'] = 'Otevře se revize';
$string['reviewoptions'] = 'Studenti si mohou prohlédnout';
$string['reviewoptions_help'] = 'Pomocí těchto možností můžete ovládat, co se studenti po importu výsledků mohou zobrazit.
Můžete také definovat počáteční a konečný čas pro zobrazení sestavy výsledků.

Zaškrtávací políčka znamenají:

**Pokus** - Text otázek a odpovědí se zobrazí studentům. Uvidí, jaké odpovědi zvolili, ale správné odpovědi nebudou uvedeny.

**Zda  jsou správné** – Tuto možnost lze aktivovat, pouze pokud je aktivována možnost „Pokus“. Pokud je aktivována, studenti uvidí, které z vybraných odpovědí jsou správné (zelené pozadí) nebo nesprávné (červené pozadí).

**Známky** – Zobrazí se skupina (např. B), skóre (dosažená známka, celková známka za otázky, dosažené v procentech, např. 40/80 (50)) a známka (např. 50 z maxima 100) . Navíc, pokud je vybráno "Pokus", zobrazí se u každé otázky dosažený počet bodů a maximální počet bodů.

**Konkrétní zpětná vazba** – Zpětná vazba, která závisí na odpovědi, kterou student vybral.

**Obecná zpětná vazba** – Po importu výsledků se studentovi zobrazí Obecná zpětná vazba. Na rozdíl od konkrétní zpětné vazby, která závisí na typu otázky a odpovědi studenta, se všem studentům zobrazuje stejný obecný text zpětné vazby. Obecnou zpětnou vazbu můžete využít k tomu, abyste studentům poskytli plně zpracovanou odpověď a možná i odkaz na další informace, které mohou použít, pokud otázkám nerozuměli.

**Správné odpovědi** – Zobrazí se, které odpovědi jsou správné nebo špatné. Tato možnost je k dispozici pouze v případě, že je nastaveno "Pokus".

**Naskenovaný formulář** – Zobrazí se naskenované formuláře odpovědí. Zaškrtnutá políčka jsou označena zelenými čtverečky.

**Naskenovaný formulář se známkami** – Zobrazí se naskenované formuláře odpovědí. Zaškrtnutá políčka jsou označena zelenými čtverečky.  Jsou zvýrazněny chybné a chybějící odpovědi. Tabulka dále zobrazuje maximální a dosaženou známku pro každou otázku.';
$string['reviewoptionsheading'] = 'Možnosti kontroly';
$string['rimport'] = 'Nahrát';
$string['rotate'] = 'Otočit';
$string['rotatingsheet'] = 'List je otočený ...';
$string['save'] = 'Uložit';
$string['saveandshow'] = 'Uložit a zobrazit změny studentovi';
$string['savescannersettings'] = 'Uložit nastavení skeneru';
$string['scannedform'] = 'Naskenovaný formulář';
$string['scannerformfortype'] = 'Formulář pro typ {$a}';
$string['scanneroptions'] = 'Nastavení skeneru';
$string['scannerpdfs'] = 'Prázdné formuláře';
$string['scannerpdfstext'] = 'Pokud chcete použít svůj vlastní software skeneru, stáhněte si následující prázdné formuláře.';
$string['scanningoptionsheading'] = 'Možnosti skenování';
$string['score'] = 'Skóre';
$string['search:activity'] = 'Offline test - informace o činnosti';
$string['select'] = 'Vybrat';
$string['selectagroup'] = 'Vybrat skupinu';
$string['selectall'] = 'Vybrat vše';
$string['selectcategory'] = 'Vybrat kategorii';
$string['selectdifferentgroup'] = 'Vyberte jinou skupinu!';
$string['selectedattempts'] = 'Vybrané pokusy ...';
$string['selectformat'] = 'Vybrat formát ...';
$string['selectgroup'] = 'Vybrat skupinu';
$string['selectlist'] = 'Vyberte seznam nebo zkuste znovu upravit formulář:';
$string['selectmultipletoolbar'] = 'Vyberte násobný panel nástrojů';
$string['selectnone'] = 'Odebrat vše';
$string['selectpage'] = 'Vyberte číslo stránky nebo zkuste znovu upravit formulář:';
$string['selectquestiontype'] = '- Vyberte typ úlohy -';
$string['showallparts'] = 'Zobrazit všechny účastníky {$a}';
$string['showcopyright'] = 'Zobrazit prohlášení o autorských právech';
$string['showcopyrightdesc'] = 'Pokud tuto možnost povolíte, na stránce s recenzemi výsledků studentů se zobrazí prohlášení o autorských právech.';
$string['showgrades'] = 'Tisk známek u úloh';
$string['showgrades_help'] = 'Tato možnost určuje, zda se mají na formuláři vytisknout maximální známky úlohy offline testu.';
$string['showmissingattemptonly'] = 'Zobrazit všechny zatržené účastníky bez výsledku';
$string['showmissingcheckonly'] = 'Zobrazit všechny nezatržené účastníky bez výsledku';
$string['shownumpartsperpage'] = 'Zobrazit {$a} účastníků na stránku';
$string['showquestioninfo'] = 'Tisk informace o odpovědích';
$string['showquestioninfo_help'] = 'Pomocí této možnosti můžete určit, které další informace o úloze se vytisknou na formuláři.
Můžete si vybrat jednu z těchto možností:
<ul>
<li> Nic
<li> Typ úlohy - V závislosti na typu úlohy budou vytištěny volby s jednou odpovědí, s více možnostmi, s výběrem všeho nebo nic.
<li> Počet správných odpovědí - Vytiskne se počet správných odpovědí
</ul>';
$string['showstudentview'] = 'Zobrazit pohled studenta';
$string['showtutorial'] = 'Ukažte studentům tutoriál offline testu.';
$string['showtutorial_help'] = 'Tato volba určuje, zda mohou studenti vidět výuku o základech offline testů. Výukový program poskytuje informace o tom, jak zacházet s různými typy dokumentů v offline testech. V interaktivní části se naučí, jak správně označit své studentské ID. <br /> <b> Upozornění: </b> <br />
Pokud nastavíte tuto možnost na „Ano“, ale skryjete offline test, nebude odkaz na tutoriál viditelný. V tomto případě můžete přidat odkaz na tutoriál na stránce kurzu.';
$string['showtutorialdescription'] = 'Odkaz na výukový tutoriál můžete přidat na stránku kurzu pomocí následující adresy URL:';
$string['shuffleanswers'] = 'Zamíchat odpovědi';
$string['shufflequestions'] = 'Zamíchat úlohy';
$string['shufflequestionsanswers'] = 'Zamíchat úlohy a odpovědi';
$string['shufflequestionsselected'] = 'Byly nastaveny náhodné úlohy, takže některé akce týkající se stránek nejsou k dispozici. Chcete-li změnit možnost náhodného výběru, {$a}.';
$string['shufflewithin'] = 'Zamíchat v rámci úloh';
$string['shufflewithin_help'] = 'Pokud je tato možnost povolena, budou součásti, které tvoří každou otázku, náhodně zamíchány při každém stisknutí tlačítka znovu načíst v náhledu formuláře. POZNÁMKA: Toto nastavení se vztahuje pouze na otázky, které mají aktivovanou možnost míchání.';
$string['signature'] = 'Podpis';
$string['singlechoice'] = 'Volba s jednou odpovědí,';
$string['standard'] = 'Standard';
$string['starttutorial'] = 'Zahájit tutoriál o zkoušce';
$string['statistics'] = 'Statistiky';
$string['statisticsplural'] = 'Statistiky';
$string['statisticsviewheader'] = '3. Statistika';
$string['statsoverview'] = 'Přehled statistik';
$string['studycode'] = 'Studijní kód';
$string['subplugintype_offlinequiz_plural'] = 'Sestavy Offline testu';
$string['tabattendances'] = 'Prezence';
$string['tabattendancesoverview'] = 'Účast';
$string['tabdownloadparticipantsforms'] = 'Formuláře';
$string['tabdownloadquizforms'] = 'Formuláře';
$string['tabeditgrades'] = 'Známky';
$string['tabeditgroupquestions'] = 'Úlohy';
$string['tabeditparticipants'] = 'Účastníci';
$string['tabofflinequizcontent'] = 'Příprava';
$string['tabofflinequizcorrect'] = 'Opravit';
$string['tabofflinequizupload'] = 'Nahrát';
$string['tabparticipantlists'] = 'Prezenční listiny';
$string['tabparticipantscorrect'] = 'Opravit';
$string['tabparticipantsupload'] = 'Nahrát';
$string['tabpreview'] = 'Formuláře';
$string['tabquestionandanswerstats'] = 'Analýza úloh a odpovědí';
$string['tabquestionstats'] = 'Analýza úloh';
$string['tabregrade'] = 'Přeznámkování';
$string['tabresults'] = 'Výsledky';
$string['tabresultsoverview'] = 'Výsledek';
$string['tabstatistics'] = 'Statistika';
$string['tabstatsoverview'] = 'Informace testu';
$string['temporaryfiledeletiontask'] = 'Odstranit dočasné soubory';
$string['theattempt'] = 'Pokus';
$string['timesup'] = 'Končíme!';
$string['totalmarksx'] = 'Celkem známek: {$a}';
$string['totalpointsx'] = 'Celkem známek: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Celkem {$a} otázek v kategorii.';
$string['trigger'] = 'dolní/horní hranice';
$string['tutorial'] = 'Výukový tutoriál pro offline testy';
$string['type'] = 'Typ';
$string['uncheckparts'] = 'Označte vybrané účastníky jako nepřítomné';
$string['updatedsumgrades'] = 'Součet všech známek skupiny {$a->letter} byl přepočítán na {$a->grade}.';
$string['upgradingfilenames'] = 'Aktualizace názvů dokumentů: offline test  {$a->done}/{$a->outof} (Offline test ID {$a->info})';
$string['upgradingilogs'] = 'Aktualizace naskenovaných stránek: naskenovaná stránka  {$a->done}/{$a->outof} <br/>(Offline test ID {$a->info})';
$string['upgradingofflinequizattempts'] = 'Aktualizace pokusů offline testu: offline test  {$a->done}/{$a->outof} <br/>(Offline test ID {$a->info})';
$string['upload'] = 'Nahrát';
$string['uploadpart'] = 'Nahrát';
$string['uppertrigger'] = 'Vyšší druhá hranice';
$string['uppertriggerzero'] = 'Vyšší druhá hranice je nula';
$string['upperwarning'] = 'Vyšší první hranice';
$string['upperwarningzero'] = 'Vyšší první hranice je nula';
$string['useradded'] = 'Uživatel {$a} byl přidán';
$string['userdoesnotexist'] = 'Uživatel {$a} v systému neexistuje';
$string['useridentification'] = 'Identifikace uživatele';
$string['useridviolation'] = 'Nalezeno více uživatelů';
$string['userimported'] = 'Uživatel {$a} byl importován a klasifikován';
$string['usernotincourse'] = 'Uživatel {$a} není v kurzu.';
$string['usernotinlist'] = 'Uživatel není v seznamu zaregistrován!';
$string['usernotregistered'] = 'Uživatel {$a} nebyl zaregistrován v kurzu';
$string['userpageimported'] = 'Pro uživatele {$a} byla importována jedna stránka';
$string['valuezero'] = 'Hodnota by neměla být nula';
$string['viewresults'] = 'Zobrazit výsledky';
$string['white'] = 'Bílý';
$string['withselected'] = 'S vybranými ...';
$string['zerogradewarning'] = 'Upozornění: Vaše známka online testu je 0,0!';
$string['zipfile'] = 'Soubor ZIP';
$string['zipok'] = 'Soubor ZIP byl importován';
