<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'treasurehunt', language 'af', version '4.1'.
 *
 * @package     treasurehunt
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitytoend'] = 'Voltooi geselekteerde aktiwiteit voor';
$string['activitytoend_help'] = 'Die geselekteerde aktiwiteit moet voltooi word voordat die huidige wenk vertoon word.
Om die aktiwiteite van die kursuse in die lys te vertoon, moet die voltooiingsaktiwiteit in
Moodle se konfigurasie ontsper wees, in die kursus en die aktiwiteit self.';
$string['activitytoendovercome'] = 'Aktiwiteit \'<strong>{$a}</strong>\' oorkom';
$string['activitytoendwarning'] = 'Jy moet die eerste aktiwiteit voltooi om op te los';
$string['actnotavailableyet'] = 'Die aktiwiteit is nog nie beskikbaar nie';
$string['add'] = 'Voeg by';
$string['addingroad'] = 'Pad word bygevoeg';
$string['addingstage'] = 'Fase word bygevoeg';
$string['addroad_tour'] = 'Voeg een of meer paaie by vir jou studente om te volg.';
$string['addsimplequestion'] = 'Voeg eenvoudige vraag by';
$string['addsimplequestion_help'] = 'Voeg \'n eenvoudige vraag by voordat die wenk van hierdie fase vertoon word';
$string['addstage_tour'] = 'Elke pad moet twee of meer fases hê. Elke fase bied \'n wenk om die volgende te kan vind.';
$string['aerialmap'] = 'Lug';
$string['aerialview'] = 'Lug';
$string['allowattemptsfromdate'] = 'Laat pogings toe vanaf';
$string['allowattemptsfromdate_help'] = 'Indien ontsper, sal studente nie voor hierdie datum kan speel nie.
Indien versper, sal studente dadelik kan begin speel.';
$string['alwaysshowdescription'] = 'Vertoon altyd beskrywing';
$string['alwaysshowdescription_help'] = 'Indien versper, sal die Skattejagbeskrywing hierbo slegs aan studente sigbaar raak
vanaf die "Laat pogings toe vanaf" datum.';
$string['answerwarning'] = 'Jy moet eers die vraag beantwoord';
$string['areyousure'] = 'Is jy seker?';
$string['attempt'] = 'Poging';
$string['attempthistory'] = 'Poginggeskiedenis';
$string['attemptsdeleted'] = 'Skattejagpogings uitgewis';
$string['autolocate_tour'] = 'Vertoon jou <b>huidige ligging</b>.<br>(verskaf toestemming om "ligging" te gebruik wanneer versoek word)';
$string['availability'] = 'Beskikbaarheid';
$string['availableplayerstyles'] = 'Speletjieskermstyle beskikbaar';
$string['back'] = 'Terug';
$string['backtocourse'] = 'Terug na die kursus';
$string['baselayers'] = 'Basislae';
$string['basemaps'] = 'Basiskaarte';
$string['bigbutton_play_tour'] = 'Hierdie is jou beste vriend.<br>\'n Kliek en daar word <b>uitdagings</b> of waardevolle <b>wenke</b> aan jou vertoon.';
$string['browsemode'] = 'Blaai';
$string['cancel'] = 'Kanselleer';
$string['changecamera'] = 'Verander kamera';
$string['changetogroupmode'] = 'Die speletjiemodus het na groepspel verander';
$string['changetoindividualmode'] = 'Die speletjiemodus het na individuele spel verander';
$string['changetoplaywithmove'] = 'Die speletjiemodus het na dinamiese spel verander';
$string['changetoplaywithoutmoving'] = 'Die speletjiemodus het na statiese spel verander';
$string['cleartreasurehunt'] = 'Stel die Skattejag terug';
$string['cleartreasurehunt_done'] = 'Die aktiwiteit is teruggestel. Alle aktiwiteit van die deelnemers is uitgewis.';
$string['cleartreasurehuntconfirm'] = 'Pasop vir hierdie aksie. Alle aangetekende aktiwiteit sal uitgewis word as jy voortgaan. Hierdie aksie is gewoonlik net nodig as jy die aantal paaie of fases moet verander, maar die aktiwiteit is geblok omdat iemand die spel begin speel het.';
$string['clue'] = 'Wenk';
$string['completionfinish'] = 'Vereis om pad te voltooi.';
$string['completionfinish_help'] = 'Voltooi wanneer gebruiker al die fases in \'n pad slaag.';
$string['configintro'] = 'Die waardes wat jy hier stel, sal die verstek waardes wat in die verstellingsvorm gebruik word wanneer jy
\'n nuwe skattejag skep.';
$string['configmaximumgrade'] = 'Die verstek punt waarvoor die skattejag se punte bepaal is.';
$string['confirm'] = 'Bevestig';
$string['confirmdeletestage'] = 'Die fase is suksesvol verwyder';
$string['continue'] = 'Gaan voort';
$string['correctanswer'] = 'Korrekte antwoord.';
$string['customlayername'] = 'Laagtitel';
$string['customlayername_help'] = 'As jy \'n doelgemaakte laag gebruik, is \'n titel nodig om dit op die kaarte van jou gebruikers te vertoon. As die titel leeg is, word die doelgemaakte laag heeltemal versper.';
$string['customlayertype'] = 'Laagtipe';
$string['customlayertype_help'] = 'Die laag kan net in die agtergrond sigbaar wees, of kan bokant die standaard basiskaarte gelaag word.';
$string['customlayerwms'] = 'WMS-diens';
$string['customlayerwms_help'] = 'Gebruik \'n kaartlaag van \'n OGC WMS-diens. (Byvoorbeeld: EUNIS Forest Ecosystems WMS kan gekonfigureer word deur: WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code> PARAMS: <code>LAYERS=4</code>)';
$string['custommapbaselayer'] = 'Hierdie prent word as ADDISIONELE kaartagtergrondopsie vertoon';
$string['custommapimageerror'] = 'Kan nie doelgemaakte prent laai nie. Kontroleer aktiwiteitverstellings.';
$string['custommapimagefile'] = 'Doelgemaakte prent vir kaart';
$string['custommapimagefile_help'] = 'Laai \'n prent met genoeg resolusie op en vul die volgende 4 velde met die projeksiekoördinate bokant die grond';
$string['custommapmaxlat'] = 'Noordelike breedtegraad';
$string['custommapmaxlat_help'] = 'Noordelike breedtegraad van die prent. Gebruik "." as desimale punt. Laer as 85 grade en meer as suidelike breedtegraad.';
$string['custommapmaxlon'] = 'Oostelike lengtegraad';
$string['custommapmaxlon_help'] = 'Oostelike lengtegraad van die prent. Gebruik "." as desimale punt. Minder as 180 grade en meer as westelike lengtegraad.';
$string['custommapminlat'] = 'Suidelike breedtegraad';
$string['custommapminlat_help'] = 'Suidelike breedtegraad van die prent. Gebruik "." as desimale punt. Meer as -85 grade en laer as noordelike breedtegraad.';
$string['custommapminlon'] = 'Westelike lengtegraad';
$string['custommapminlon_help'] = 'Westelike lengtegraad van die prent. Gebruik "." as desimale punt. Meer as -180 grade en laer as oostelike lengtegraad.';
$string['custommapnongeographic'] = 'Die prent is nie geografies nie';
$string['custommaponlybaselayer'] = 'Die prent word vertoon as die ENIGSTE kaartagtergrondopsie';
$string['custommapoverlaylayer'] = 'Die prent is bokant die standaard kaart uitgebeeld';
$string['custommapping'] = 'Doelgemaakte kaart';
$string['customwmsparams'] = 'WMS-parameters';
$string['customwmsparams_help'] = 'Hierdie parameters definieer die voorkoms van die kaart. Die formaat volg die volgende formaat: "LAYERS=background,streets&STYLES=blue,default" (Byvoorbeeld EUNIS Forest Ecosystems WMS kan gekonfigureer word deur: WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code> PARAMS: <code>LAYERS=4</code>)';
$string['cutoffdate'] = 'Afsnydatum';
$string['cutoffdate_help'] = 'Indien gestel, sal die skattejag nie pogings ná hierdie datum aanvaar sonder \'n verlenging nie.';
$string['cutoffdatefromdatevalidation'] = 'Afsnydatum moet wees ná die \'laat indienings toe ná\'-datum.';
$string['defaultplayerstyle'] = 'Verstek speletjieskermstyl';
$string['discoveredlocation'] = 'Ontdekte ligging';
$string['donetutorial'] = 'Einde';
$string['drawmode'] = 'Teken';
$string['editactivity_help'] = 'Jy kan \'n stap-vir-stap tutoriaal oor die skep van skattejagaktiwiteite op <a href="http://juacas.github.io/moodle-mod_treasurehunt/create_activity.html"> hierdie bladsy</a> vind.';
$string['editend_tour'] = 'Geniet dit om opwindende speletjies vir jou studente te skep!';
$string['editingroad'] = 'Pad word gewysig';
$string['editingstage'] = 'Fase word gewysig';
$string['editingtreasurehunt'] = 'Skattejag word gewysig';
$string['edition'] = 'Wysigingspaneel';
$string['edition_help'] = 'Om die uitlegskepping en die knoppies in die wysigingspaneel te ontsper, moet die fase wat jy wil wysig, geselekteer wees';
$string['editmode'] = 'Wysig';
$string['editroad'] = 'Wysig pad';
$string['editstage'] = 'Wysig fase';
$string['edittreasurehunt'] = 'Verander paaie en fases';
$string['errcorrectanswers'] = 'Jy moet \'n korrekte antwoord kies';
$string['errcorrectsetanswerblank'] = 'Korrekte antwoord is gestel, maar die antwoord is leeg';
$string['erremptystage'] = 'Alle fases moet minstens een uitleg hê, sodat die pad geldig is';
$string['errnocorrectanswers'] = 'Daar moet minstens een korrekte antwoord wees';
$string['errnumeric'] = 'Jy moet \'n geldige desimale getal invoer';
$string['error'] = 'Fout';
$string['errpenalizationexceed'] = 'Die straftoekenning kan nie meer as 100 wees nie';
$string['errpenalizationfall'] = 'Die straftoekenning kan nie minder as 0 wees nie';
$string['errsendinganswer'] = 'Die pad is bygewerk terwyl jy die antwoord probeer stuur het. Probeer weer.';
$string['errsendinglocation'] = 'Die pad is bygewerk terwyl jy die ligging probeer stuur het. Probeer weer.';
$string['errvalidroad'] = 'Daar moet minstens twee fases wees wat minstens een uitleg het, sodat die pad geldig is';
$string['eventattemptsubmitted'] = 'Poging ingedien';
$string['eventattemptsucceded'] = 'Fase deurgekom';
$string['eventhuntsucceded'] = 'Skattejag is suksesvol voltooi';
$string['eventplayerentered'] = 'Speler het begin';
$string['eventroadcreated'] = 'Pad is geskep';
$string['eventroaddeleted'] = 'Pad is uitgewis';
$string['eventroadupdated'] = 'Pad is bygewerk';
$string['eventstagecreated'] = 'Fase is geskep';
$string['eventstagedeleted'] = 'Fase is uitgewis';
$string['eventstageupdated'] = 'Fase is bygewerk';
$string['exit'] = 'Terug na Kursus';
$string['failedlocation'] = 'Mislukte ligging';
$string['faillocation'] = 'Dit is nie die regte plek nie';
$string['findplace'] = 'Vind \'n plek';
$string['gamemode'] = 'Speletjiemodus';
$string['gamemodeinfo'] = 'Speletjiemodus: {$a}';
$string['gameupdatetime'] = 'Speletjiebywerktyd';
$string['gameupdatetime_help'] = 'Tydinterval in sekondes tussen \'n gebruiker se speletjiebywerking en \'n ander.
Hoe groter dit is, hoe minder bywerkversoeke behoort gemaak te word, maar meer tyd verloop om \'n moontlike verandering te rapporteer.
Dit moet meer as 0 sekondes wees, maar die tyd sal by verstek gestel word.';
$string['geolocation_needed'] = 'Jou geoligging is nodig om hierdie speletjie te kan speel.
<p>Om dit te aktiveer, gaan na jou blaaier: Verstellings->Werfverstellings->Ligging en verwyder die uitsetting vir hierdie werf.
<p>Herlaai asseblief hierdie bladsy en antwoord "JA" wanneer jou blaaier vra of jy jou ligging wil deel.
<p>Om die GPS te gebruik om hierdie toestel gedurende die Skattejag op te spoor, moet die bediener deur veilige HTTPS URL\'e binnegegaan word.
In ander gevalle kan "Speel sonder om te beweeg"-modus gebruik word en moet die spelers per hand na elke fase op die kaart wys.
Kontak asseblief jou administrateur as jy nie hierdie probleem kan oplos nie.';
$string['geolocation_needed_title'] = 'Hierdie toepassing benodig geoligging.';
$string['grade_explaination_fromabsolutetime'] = '{$a->rawscore}-{$a->penalization}%: Jy het die jag ná {$a->yourtime} beëindig. Die beste tyd was om {$a->besttime}. Jou penalisering was {$a->penalization}% weens {$a->nolocationsfailed} verkeerde plekke en {$a->noanswersfailed} weens verkeerde antwoorde.';
$string['grade_explaination_fromposition'] = '{$a->rawscore}-{$a->penalization}%: Jy het {$a->nosuccessfulstages} fases in {$a->position} ontdek. Jou penalisering was {$a->penalization}% weens {$a->nolocationsfailed} verkeerde plekke en {$a->noanswersfailed} weens verkeerde antwoorde.';
$string['grade_explaination_fromstages'] = '{$a->rawscore}-{$a->penalization}%: Jy het {$a->nosuccessfulstages} uit {$a->nostages} fases ontdek. Jou penalisering was {$a->penalization}% weens {$a->nolocationsfailed} verkeerde plekke en {$a->noanswersfailed} weens verkeerde antwoorde.';
$string['grade_explaination_fromtime'] = '{$a->rawscore}-{$a->penalization}%: Jy het {$a->yourtime} nodig gehad om die jag te voltooi. Die beste tyd was {$a->besttime}. Jou penalisering was {$a->penalization}% weens {$a->nolocationsfailed} verkeerde plekke en {$a->noanswersfailed} weens verkeerde antwoorde.';
$string['grade_explaination_temporary'] = 'Onvoltooide jag, ontvang 50% van punt uit fases: {$a->rawscore}-{$a->penalization}%: Jy het {$a->nosuccessfulstages} uit {$a->nostages} fases ontdek. Jou penalisering was {$a->penalization}% weens {$a->nolocationsfailed} verkeerde plekke en {$a->noanswersfailed} weens verkeerde antwoorde.';
$string['gradefromabsolutetime'] = 'Punt uit tydsduur van die jag';
$string['gradefromposition'] = 'Punt uit posisie';
$string['gradefromstages'] = 'Punt uit fases';
$string['gradefromtime'] = 'Punt uit klaarmaaktyd';
$string['grademethod'] = 'Graderingsmetode';
$string['grademethod_help'] = '<p><b>Punt uit fases</b></p>
<p>Elke speler (of span) behaal proporsioneel volgens die aantal fases opgelos, met 100% wanneer \'n pad heeltemal opgelos is en 0% wanneer geen fase opgelos is nie.</p>
<p><b>Punt uit tydsduur van die jag</b></p>
<p>Die jagter wat die pad in die minste tyd voltooi, wen die jag en teken die beste tyd aan.
Die tyd word gemeet vanaf die oomblik wat die beginfase van die pad ontsluit word.
Dit beteken dat die deelnemers op verskillende tye kan speel.
Die punt word bereken deur 50% die klaarmaaktyd van die jag
en 100% die beste klaarmaaktyd te interpoleer. Die spelers wat nie die jag klaargemaak het nie, ontvang \'n punt onder 50, bereken deur slegs die aantal fases wat opgelos is.</p>
<p><b>Punt uit klaarmaaktyd</></p>
<p>Die jagter wat eerste klaarmaak, is die wenner van die jag.
Daar word aanvaar dat elke jagter tegelykertyd speel.
Die punt word bereken deur 50% die klaarmaaktyd van die jag
en 100% die beste klaarmaaktyd te interpoleer. Die spelers wat nie die jag klaargemaak het nie, ontvang \'n punt onder 50, bereken deur slegs die aantal fases wat opgelos is.</p>
<p><b>Punt uit posisie</b></p>
<p>Die punt word bereken deur die posisie in die rangorde, 100% van die punt van die eerste speler en 50% van die laaste speler te interpoleer.
Die spelers wat nie die jag voltooi het nie, ontvang \'n punt onder 50%, bereken deur slegs die aantal fases wat opgelos is.';
$string['grademethodinfo'] = 'Graderingsmetode: {$a->type}. Liggingpenalisering: {$a->gradepenlocation}%. Antwoordpenalisering: {$a->gradepenanswer}%';
$string['gradepenanswer'] = 'Penalisering vir mislukking in antwoord';
$string['gradepenlocation'] = 'Penalisering vir mislukking in ligging';
$string['gradepenlocation_help'] = 'Penalisering word in % van die punt uitgedruk.
Byvoorbeeld: as penalisering 5,4 is, sal \'n speler met 3 mislukkings sy
punt met 16,2% penaliseer, d.w.s. hy ontvang 83,8% van die punt wat deur die res van sy kriteria bereken is.';
$string['gradesdeleted'] = 'Skattejagpunte is uitgewis';
$string['gradingsummary'] = 'Nasien opsomming';
$string['group'] = 'Groep';
$string['groupactivityovercome'] = 'Aktiwiteit vir fase {$a->position} is suksesvol voltooi deur {$a->user}  {$a->date}';
$string['groupid'] = 'Groep aan die pad toegewys';
$string['groupid_help'] = 'Gebruikers in hierdie groep word aan hierdie pad toegewys wanneer die speletjie begin.
As daar net een pad is en die gekose opsie "geen" is, sal alle deelnemers aan die aktiwiteit daarvoor kompeteer.';
$string['groupingid'] = 'Groep aan die pad toegeken';
$string['groupingid_help'] = 'Groepe in hierdie groepering word aan hierdie pad toegeken wanneer die speletjie begin';
$string['groupinvalidroad'] = '{$a} het \'n ongeldige pad toegeken';
$string['grouplocationfailed'] = '<b>Mislukte "fase {$a->position}" ligging</b> deur {$a->user} {$a->date}';
$string['grouplocationovercome'] = '<b>Suksesvolle fase {$a->position}" ligging</b> deur {$a->user} {$a->date}';
$string['groupmode'] = 'Studente speel in groepe';
$string['groupmode_help'] = 'Indien ontsper, sal studente in groepe verdeel word gebaseer op die konfigurasie van kursusgroepe.
Elke spanlid kan die huidige fase oplos en die vordering is algemeen aan elke lid.<br/>
Dit laat toe dat die jag "paralleliseer" en meer grondgebied kan dek. Die deelnemers sien dieselfde inligting, maar spangeoriënteer.';
$string['groupmultipleroads'] = '{$a} het meer as een pad toegewys.';
$string['groupquestionfailed'] = '<b>Mislukte fase {$a->position} antwoord </b> deur {$a->user}  {$a->date}';
$string['groupquestionovercome'] = '<b>Suksesvolle fase {$a->position} antwoord </b> deur {$a->user}  {$a->date}';
$string['groups'] = 'Groepe';
$string['groupstageovercome'] = '<b>Fase {$a->position} baasgeraak </b> deur {$a->user} {$a->date}';
$string['hello'] = 'Hallo';
$string['history'] = 'Geskiedenis';
$string['huntcompleted'] = 'Jy het reeds hierdie skattejag voltooi';
$string['incorrectanswer'] = 'Verkeerde antwoord.';
$string['info'] = 'Inligting';
$string['infovalidatelocation'] = 'Valideer ligging van hierdie fase';
$string['invalidassignedroad'] = 'Toegekende pad is nie gevalideer nie';
$string['invalroadid'] = 'Die pad is nie gevalideer nie';
$string['lastsuccessfulstage_tour'] = 'In hierdie paneel kan jy jou laaste suksesvolle fase vind. Dit kan jou of jou groep se suksesvolle fase wees.';
$string['layers'] = 'Lae';
$string['loading'] = 'Laai';
$string['lockedaclue'] = 'Jy moet die aktiwiteit \'<strong>{$a}</strong>\' uitvoer om die wenk oop te sluit';
$string['lockedaqclue'] = 'Jy moet die aktiwiteit \'<strong>{$a}</strong>\' uitvoer en die volgende vraag korrek
beantwoord om die wenk oop te sluit';
$string['lockedclue'] = 'Geslote wenk';
$string['lockedqclue'] = 'Jy moet die volgende vraag korrek beantwoord om die wenk oop te sluit';
$string['locktimeediting'] = 'Sluit tydredigering';
$string['locktimeediting_help'] = 'Tyd in sekondes waarvoor \'n gebruiker \'n eksemplaar kan wysig sonder om die sluiting te hernu.
Die groter, minder versoeke vir hernuwingsluiting moet gemaak word, maar meer tyd word gesluit die wysigingsblad sodra die gebruiker klaargemaak het.
Dit moet meer as 5 sekondes wees, maar die tyd sal by verstek gestel word.';
$string['map_tour'] = 'In hierdie kaart kan jy al die komponente van \'n snaakse, geoliggingspeletjie bestuur!';
$string['mapplay_tour'] = 'Die <b>kaart</b> vertoon al jou pogings!<br>Suksesvolles: <img src="pix/success_mark.png" width="28"/><br>Misluktes: <img src="pix/failure_mark.png" width="28"/>';
$string['mapplaymobile_tour'] = 'Die <b>kaart</b> toon al jou pogings!<br>Suksesvolles: <img src="{$a->successurl}" width="28"/><br>Misluktes: <img src="{$a->failureurl}" width="28"/>';
$string['mapview'] = 'Kaartbeskouing';
$string['modify'] = 'Wysig';
$string['modulename'] = 'Skattejag';
$string['modulename_help'] = 'Hierdie module sal gebruik word om \'n aktiwiteit geoligging uit te voer.
Buitenshuise, binnenshuise en virtuele-kaart jagte met geoligging en QR-kodes.
Hierdie module vir Moodle laat toe dat buitenshuise ernstige speletjies met jou studente gespeel word.
Skattejag implementeer \'n blaaier-gebaseerde speeltoepassing (nie nodig om enige boorling-app te installeer nie) en \'n geografiese wysiger om die fases van die spel te enkodeer.
Die speletjie kan met \'n reeks opsies gekonfigureer word, wat die module baie buigbaar en nuttig in baie situasies maak: individueel/span, bewegend/werkskerm-merk, punte uit tyd, posisie, voltooiing, ens.
<p><b><a href = "https://juacas.github.io/moodle-mod_treasurehunt/index.html">Meer inligting en stap-vir-stap tutoriaal in hierdie aanlyn aanbieding.</a></b></p>';
$string['modulenameplural'] = 'Skattejagte';
$string['movingplay'] = 'Bewegende spel';
$string['multiplegroupingsplay'] = 'Jou groep het meer as een pad toegeken, dus kan jy nie die aktiwiteit uitvoer nie.';
$string['multiplegroupsplay'] = 'Jy het meer as een pad toegeken, dus kan jy nie die aktiwiteit uitvoer nie.';
$string['multiplegroupssameroadplay'] = 'Jy behoort aan meer as een groep wat aan dieselfde pad toegeken is, dus kan jy nie die aktiwiteit uitvoer nie.';
$string['multipleteamsplay'] = 'Lid van meer as een groep, dus kan die aktiwiteit nie gemaak word nie.';
$string['mustanswerquestion'] = 'Jy moet die vraag korrek beantwoord voordat jy verder gaan';
$string['mustcompleteactivity'] = 'Jy moet die aktiwiteit baasraak om te voltooi voor jy voortgaan';
$string['mustcompleteboth'] = 'Jy moet die vraag korrek beantwoord en die aktiwiteit baasraak om te voltooi voor jy voortgaan';
$string['nextcamera'] = 'Verander kamera';
$string['nextstep'] = 'Volgende';
$string['noanswerselected'] = 'Jy moet \'n antwoord kies';
$string['noattempts'] = 'Jy het geen poging aangewend nie';
$string['noexsitsstage'] = 'Daar is geen fasenommer {$a} in die databasis nie. Herlaai die bladsy';
$string['nogroupassigned'] = 'Geen groep is aan hierdie pad toegeken nie';
$string['nogroupingplay'] = 'Jy het geen groep aan \'n pad toegeken nie, dus kan jy nie die aktiwiteit speel nie.';
$string['nogroupplay'] = 'Jy het geen pad toegeken nie, dus kan jy nie die aktiwiteit speel nie.';
$string['nogrouproad'] = '{$a} het geen pad toegeken nie';
$string['nomarks'] = 'Merk eerste die verlangde punt op die kaart. Plaas die <img src="pix/my_location.png" width="28"/>';
$string['nomarksmobile'] = 'Merk eerste die verlangde punt op die kaart.';
$string['noresults'] = 'Geen resultate gevind nie.';
$string['noroads'] = 'Geen paaie is sover bygevoeg nie';
$string['notchangeorderstage'] = 'Jy kan nie die volgorde van fases verander nadat pogings in die pad aangewend is nie';
$string['notcreatestage'] = 'Pogings is reeds in hierdie pad aangewend, jy kan nie meer fases byvoeg nie';
$string['notdeletestage'] = 'Pogings is reeds in hierdie pad aangewend, jy kan geen fases uitwis nie';
$string['noteam'] = 'Nie \'n lid van enige groep nie';
$string['notreasurehunts'] = 'Daar is geen skattejag in hierdie kursus nie';
$string['nouserassigned'] = 'Geen gebruiker is aan hierdie pad toegeken nie';
$string['nouserattempts'] = '{$a} het geen poging aangewend nie';
$string['nouserroad'] = '{$a} het geen pad toegeken nie.';
$string['nousersprogress'] = 'Geen gebruiker/groep het vordering op hierdie pad nie.';
$string['outoftime'] = 'Tyd is verby';
$string['overcomefirststage'] = 'Om die eerste fase te ontdek, moet jy van die gemerkte area op die kaart begin';
$string['overlaylayers'] = 'Oorlegginglae';
$string['pegmanlabel'] = 'Kyk rond op StreetView';
$string['play'] = 'Speel';
$string['playend_tour'] = '<span style="font-size: 1.5em; font-weight: bold">Geniet jou Skattejag</span><br>saam met jou vriende!';
$string['playerbootstrap'] = 'Bootstrap';
$string['playerclassic'] = 'Klassiek';
$string['playerfancy'] = 'Spoggerig';
$string['playerhelp_tour'] = 'Hierdie toer kan enige tyd wat jy wil, besigtig word.';
$string['playerstyle'] = 'Speletjieskermstyl';
$string['playerstyle_help'] = 'Daar is etlike style van die speletjieskerm waaruit onderwysers kan kies.';
$string['playstagewithoutmoving'] = 'Ontdek fase sonder om te beweeg';
$string['playstagewithoutmoving_help'] = 'As hierdie opsie ontsper is, kan studente hierdie fase ontdek sonder om na enige plek te beweeg.
Om dit te doen word \'n punt geskep elke keer as die student eenvoudig op die kaart kliek, wat die vorige (indien enige) uitvee, en die laaste punt aandui. Met voltooiing van die fase sal die speletjie na die verstek
verstellings van die aktiwiteit verander.';
$string['playstagewithqr'] = 'Ontdek fase deur hierdie QR-teks te lees';
$string['playstagewithqr_help'] = 'As hierdie opsie \'n waarde het, kan studente hierdie fase ontdek deur \'n QR-kode te skandeer wat op daardie plek beskikbaar is.';
$string['playwithoutmoving'] = 'Speel sonder om te beweeg';
$string['playwithoutmoving_help'] = 'As hierdie opsie ontsper is, kan studente vanaf hul rekenaars speel sonder om van plek te verander. Om dit te doen word \'n punt geskep elke keer as die student eenvoudig op die kaart kliek, wat die vorige (indien enige) uitvee, en die laaste punt aandui.';
$string['pluginadministration'] = 'Skattejagadministrasie';
$string['pluginname'] = 'Skattejag';
$string['prevstep'] = 'Vorige';
$string['privacy:metadata_treasurehunt_attempts'] = 'Die skattejag berg die tipe, tyd en plek van die pogings, suksesse en mislukkings van die gebruikers tydens die aktiwiteit.';
$string['privacy:metadata_treasurehunt_attempts_groupid'] = 'Die groep waarin die gebruiker die aktiwiteit gespeel het.';
$string['privacy:metadata_treasurehunt_attempts_stageid'] = 'Die fase-ID wat die gebruiker probeer oplos het.';
$string['privacy:metadata_treasurehunt_attempts_timecreated'] = 'Die tydstip waarop die gebruiker \'n poging aangewend het.';
$string['privacy:metadata_treasurehunt_attempts_userid'] = 'Die ID van die gebruiker wat \'n poging aangewend het.';
$string['privacy:metadata_treasurehunt_track'] = 'Die skattejag berg die volgorde van plekke wat deur \'n gebruiker tydens die aktiwiteit gevolg is.';
$string['privacy:metadata_treasurehunt_track_location'] = 'Die ligging van die gebruiker op \'n spesifieke tydstip.';
$string['privacy:metadata_treasurehunt_track_timestamp'] = 'Die tydstip waarop die gebruiker gespoor word.';
$string['privacy:metadata_treasurehunt_track_treasurehuntid'] = 'Die ID van die Skattejag waarin die gebruiker speel.';
$string['privacy:metadata_treasurehunt_track_userid'] = 'Die ID van die gebruiker wat gespoor word.';
$string['qrreaded'] = 'QR-kode gelees:';
$string['question'] = 'Vraag:';
$string['remove'] = 'Wis uit';
$string['remove_tour'] = 'Jy kan dele van die ligging-uitlegte uitwis. Kies net \'n poligoon en kliek dan hierdie knoppie.';
$string['removealltreasurehuntattempts'] = 'Wis alle pogings tot skattejag uit.';
$string['removedactivitytoend'] = 'Aktiwiteit om te voltooi, is verwyder';
$string['removedquestion'] = 'Die vraag is verwyder';
$string['removeroadwarning'] = 'As jy die pad verwyder, is alle geassosieerde fases verwyder en kan jy dit nie weer herwin nie';
$string['removewarning'] = 'As jy dit verwyder, kan jy dit nie herwin nie';
$string['restrictionsdiscoverstage'] = 'Beperkings tot ontdekking van fase';
$string['reviewofplay'] = 'Oorsig oor spel';
$string['road'] = 'Pad';
$string['roadended'] = 'Hierdie pad is voltooi. Geluk! Jy het die skattejag gedoen. Jy kan jou geskiedenis in die kaart nagaan.';
$string['roadmap'] = 'Pad';
$string['roadname'] = 'Pad se naam';
$string['roads_tour'] = 'In hierdie area sal jy die verskillende paaie van jou speletjie vind. Kies een daarvan om die fases te wysig.';
$string['roadview'] = 'Pad';
$string['save'] = 'Berg';
$string['save_tour'] = 'Nadat jy jou liggings geteken het, onthou om jou veranderinge te berg.';
$string['saveemptyridle'] = 'Alle gewysigde fases moet uitleg hê voor berging.';
$string['savewarning'] = 'Jy het nie veranderinge geberg nie.';
$string['scanQR_generatebutton'] = 'Genereer \'n QR-kode';
$string['scanQR_scanbutton'] = 'Skandeer QR-kode';
$string['search'] = 'Soek';
$string['searching'] = 'Daar word gesoek';
$string['searchlocation'] = 'Soek ligging';
$string['searchlocation_tour'] = 'Met hierdie soekarea kan jy jou pad vinnig vind.';
$string['send'] = 'Stuur';
$string['sendlocationcontent'] = 'Hierdie aksie kan nie ongedaan gemaak word nie.';
$string['sendlocationtitle'] = 'Is jy seker jy wil hierdie ligging stuur?';
$string['showclue'] = 'Vertoon wenk';
$string['skiptutorial'] = 'Verlaat';
$string['stage'] = 'Fase';
$string['stageclue'] = 'Wenk om die volgende fase op te spoor';
$string['stageclue_help'] = 'Hier behoort jy die wenk te beskryf om die volgende ligging te bereik.
In die geval dat dit die laaste fase is, moet daar \'n terugvoerboodskap gelos word, wat aandui dat die skattejag geëindig het.';
$string['stagename'] = 'Fase se naam';
$string['stageovercome'] = 'Fase baasgeraak';
$string['stages'] = 'Fases';
$string['stages_tour'] = 'In hierdie area sal jy die fases van die gekose pad vind. Kies elke fase om na die werklike ligging op die kaart te zoem en begin die uitlegte wysig deur daarop te kliek en ook op die Wysig/Teken-knoppies daarbo.';
$string['start'] = 'Begin';
$string['startfromhere'] = 'Jy kan slegs van hier begin';
$string['state'] = 'Toestand';
$string['successlocation'] = 'Dit is die regte plek!';
$string['timeago'] = '{$a->shortduration} gelede';
$string['timeagolong'] = '{$a->shortduration} gelede ({$a->date})';
$string['timeat'] = 'op {$a->date}';
$string['timeexceeded'] = 'Jy het die tydsbeperking van die aktiwiteit oorskry. Hierdie skerm dien slegs om die speletjie te hersien';
$string['timetocome'] = 'in {$a->shortduration}';
$string['timetocomelong'] = 'in {$a->shortduration} ({$a->date})';
$string['totalprogress'] = 'Totale vordering';
$string['totaltime'] = 'Totale tyd';
$string['trackusers'] = 'Spoor bane';
$string['trackusers_help'] = 'Registreer die paaie wat deur die gebruikers gemaak is. Dit kan in die "Spoor aanskouer" skerm besigtig word.<br/>
Die gebruikerposisies word tussen validasiepogings (met elke stemversoek) gelog.<br/>
As die gebruiker se GPS versper is, is die enigste ligging wat hy kan rapporteer, dié van die geskandeerde QR-kodes.<br/>
As hierdie opsie <b>versper</b> is, is die enigste liggings wat aangeteken is, dié van die validasiepogings.';
$string['trackviewer'] = 'Spoor Aanskouer';
$string['trackviewerrefreshtracks'] = 'Verfris spore elke {$a} sekondes.';
$string['treasurehunt'] = 'Skattejag';
$string['treasurehunt:addinstance'] = 'Voeg \'n nuwe skattejag by';
$string['treasurehunt:addroad'] = 'Voeg pad by';
$string['treasurehunt:addstage'] = 'Voeg fase by';
$string['treasurehunt:editroad'] = 'Wysig pad';
$string['treasurehunt:editstage'] = 'Wysig fase';
$string['treasurehunt:managetreasure'] = 'Bestuur skattejag';
$string['treasurehunt:managetreasurehunt'] = 'Bestuur skattejag';
$string['treasurehunt:play'] = 'Speel';
$string['treasurehunt:view'] = 'Besigtig skattejag';
$string['treasurehunt:viewusershistoricalattempts'] = 'Besigtig geskiedenis van gebruikerpogings';
$string['treasurehuntclosed'] = 'Hierdie skattejag het {$a} gesluit';
$string['treasurehuntcloses'] = 'Skattejag sluit';
$string['treasurehuntcloseson'] = 'Hierdie skattejag sal {$a} sluit';
$string['treasurehuntislocked'] = '{$a} wysig tans hierdie skattejag. Probeer oor \'n paar minute om dit te wysig.';
$string['treasurehuntname'] = 'Skattejag se naam';
$string['treasurehuntnotavailable'] = 'Die skattejag sal {$a} beskikbaar wees';
$string['treasurehuntopenedon'] = 'Die skattejag het {$a} oopgemaak';
$string['treasurehuntopens'] = 'Skattejag maak oop';
$string['updates'] = 'Bywerkings';
$string['updatetimes'] = 'Werk tye by';
$string['user'] = 'Gebruiker';
$string['useractivityovercome'] = '<b>Moodle-aktiwiteit vir "fase {$a->position}" is suksesvol voltooi</b> {$a->date}';
$string['userattempthistory'] = 'Pogingsgeskiedenis van {$a}';
$string['userinvalidroad'] = '{$a} het \'n ongeldige pad toegewys';
$string['userlocationfailed'] = '<b> Mislukte "fase {$a->position}" ligging</b> {$a->date}';
$string['userlocationovercome'] = '<b>Suksesvolle "fase {$a->position}" ligging</b> {$a->date}';
$string['usermultipleroads'] = '{$a} het meer as een pad toegewys.';
$string['usermultiplesameroad'] = '{$a} behoort aan meer as een groep wat aan dieselfde pad toegeken is.';
$string['userprogress'] = 'Gebruikervordering is suksesvol bygewerk';
$string['userquestionfailed'] = '<b>Mislukte "fase {$a->position}" antwoord</b> {$a->date}';
$string['userquestionovercome'] = '<b>Suksesvolle "fase {$a->position}" antwoord</b> {$a->date}';
$string['usersprogress'] = 'Gebruikervordering';
$string['usersprogress_help'] = 'Dui die vordering van die fases van elke student/groep volgens die kleure:
<p>Die kleur <b>groen</b> dui aan dat die fase sonder mislukkings baasgeraak is.</p>
<p>Die kleur <b>geel</b> dui aan dat die fase met mislukkings baasgeraak is.</p>
<p>Die kleur <b>rooi</b> dui aan dat die fase nie baasgeraak is nie en mislukkings voorgekom het.<p>
<p>Die kleur <b>grys</b> dui aan dat die fase nie baasgeraak is nie en dat geen mislukkings voorgekom het nie.</p>';
$string['userstageovercome'] = '<b>Fase {$a->position} baasgeraak</b>: {$a->date}';
$string['validatelocation'] = 'Valideer ligging';
$string['validatelocation_tour'] = 'Oortuig van die ligging van \'n fase?<br><b>Dien jou posisie in</b> en ontdek of jy korrek is.';
$string['validateqr'] = 'Skandeer QR';
$string['warmatchanswer'] = 'Die antwoord stem nie met die vraag ooreen nie';
$string['warnqrscanner'] = '<table><tr><td> Hierdie Skattejag sluit {$a} fases met QR-kodes in.
Verseker asseblief dat jou toestel jou toestel kodes van die webblaaier kan skandeer. \'n Beskouing van jou kamera behoort hieronder te verskyn. Probeer om enige QR-kode soos volg te lees.</td><td> <a href="pix/qr.png">
 <img src="pix/qr.png" align="top" width="100"></a></td></tr></table>';
$string['warnqrscannererror'] = 'Hierdie Skattejag sluit {$a} fases met QR-kodes in.
Dit lyk asof jou toestel nie die kamera met hierdie toepassing kan gebruik nie. Verskaf asseblief toestemming om toegang tot die kamera te verkry.
As jy nie die kamera geaktiveer kry nie, is hierdie toestel moontlik nie geskik om Skattejag te speel nie.';
$string['warnqrscannersuccess'] = 'Hierdie Skattejag sluit {$a} fases met QR-kodes in.
Dit lyk asof jy \'n QR-toets met hierdie toestel geslaag het.';
$string['warnunsecuregeolocation'] = 'Geoligging sal dalk nie in jou bediener werk nie. Dit is \'n <b>ERNSTIGE miskonfigurasie</b> wat deur jou
bedienerkonfigurasie veroorsaak is. Geoligging is verbode vir onveilige bedieners wat HTTP in plaas van HTTPS gebruik. Om die GPS te kan gebruik
om die studente tydens die Skattejag op te spoor, moet die bediener deur veilige HTTPS URL\'e ingegaan word. Anders kan slegs "Speel sonder om te beweeg"-modus gebruik word en moet spelers per hand na elke fase op die kaart wys.
Kontak asseblief jou administrateur.
(Verwysings <a href="https://www.chromestatus.com/feature/5636088701911040">Chrome</a>, <a href="https://blog.mozilla.org/security/2015/04/30/deprecating-non-secure-http/">Firefox</a>)';
$string['warnusersgroup'] = 'Die volgende gebruikers behoort aan meer as een groep: {$a}, en kan dus nie aan die aktiwiteit deelneem nie.';
$string['warnusersgrouping'] = 'Die volgende groepe behoort aan meer as een groepering: {$a}, en kan dus nie aan die aktiwiteit deelneem nie.';
$string['warnusersoutside'] = 'Die volgende gebruikers behoort nie aan enige groep/groepering nie: {$a}, en kan dus nie aan die aktiwiteit deelneem nie.';
$string['welcome_edit_tour'] = 'Welkom by die outeurblad van Skattejag.';
$string['welcome_play_tour'] = '<span style="font-size: 1.5em; font-weight: bold">Welkom by jou Skattejag!</span><br>Hierdie kaart en die wenke sal jou gids wees.';
