<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'sr_cr', version '4.1'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'О мени';
$string['actingasrole'] = 'Тренутно имате другу улогу';
$string['activatetemplateoverride'] = 'Активирајте измену шаблона за \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'Када је означено, вредност у подешавању \'{$a->setting}\' ће се користити као шаблон \'{$a->template}\' ако садржи текст.';
$string['activebreadcrumb'] = 'Боја позадине активне ставке навигационе путање';
$string['activebreadcrumbdesc'] = 'Подесите боју позадине тренутно активне ставке у навигационој путањи, као и остатка траке навигационе путање.';
$string['activitiesheading'] = 'Активности';
$string['alertaccess'] = 'Видљивост важног обавештења';
$string['alertaccessadmins'] = 'Видљиво администраторима';
$string['alertaccessdesc'] = 'Подесите тип ограничења приступа за видљивост оквира са важним обавештењем. Напомена: ако користите опцију ”Додај ограничење везано за прилагођено поље профила” мораћете да унесете вредности за поља профила у доње поље.';
$string['alertaccessglobal'] = 'Видљиво свима';
$string['alertaccessprofile'] = 'Додај ограничење везано за прилагођено поље профила';
$string['alertaccessusers'] = 'Видљиво пријављеним корисницима';
$string['alertannounce'] = 'Оглас';
$string['alertannouncedesc'] = 'Приказује оглас у оквиру за важна обавештења.';
$string['alertbackgroundcolorinfo'] = 'Информација - боја позадине';
$string['alertbackgroundcolorinfodesc'] = 'Боја позадине оквира за важна обавештења типа "Информација"';
$string['alertbackgroundcolorsuccess'] = 'Оглас - боја позадине';
$string['alertbackgroundcolorsuccessdesc'] = 'Боја позадине оквира за важна обавештења типа "Оглас"';
$string['alertbackgroundcolorwarning'] = 'Упозорење - боја позадине';
$string['alertbackgroundcolorwarningdesc'] = 'Боја позадине оквира за важна обавештења типа "Упозорење"';
$string['alertbordercolorinfo'] = 'Информација - боја бордуре';
$string['alertbordercolorinfodesc'] = 'Боја бордуре оквира за важна обавештења типа "Информација"';
$string['alertbordercolorsuccess'] = 'Оглас - боја бордуре';
$string['alertbordercolorsuccessdesc'] = 'Боја бордуре оквира за важна обавештења типа "Оглас"';
$string['alertbordercolorwarning'] = 'Упозорење - боја бордуре';
$string['alertbordercolorwarningdesc'] = 'Боја бордуре оквира за важна обавештења типа "Упозорење"';
$string['alertcolorinfo'] = 'Информација - боја иконице';
$string['alertcolorinfodesc'] = 'Боја иконице оквира за важна обавештења типа "Информација"';
$string['alertcolorsheading'] = 'Прилагодите оквире са важним обавештењем на врху странице';
$string['alertcolorsuccess'] = 'Оглас - боја иконице';
$string['alertcolorsuccessdesc'] = 'Боја иконице оквира за важна обавештења типа "Оглас"';
$string['alertcolorwarning'] = 'Упозорење - боја иконице';
$string['alertcolorwarningdesc'] = 'Боја иконице оквира за важна обавештења типа "Упозорење"';
$string['alertcount'] = 'Број важних обавештења';
$string['alertcountdesc'] = 'Број важних обавештење који се приказује у наставку ове странице за уређивање.';
$string['alertdesc'] = 'Унесите и прилагодите текст који ће бити приказан на врху сајта као важно обавештење. Могуће је подесити више од једног важног обавештења, тако да свако буде намењено различитим типовима корисника. Такође, имате могућност да обавештења прикажете на читавом сајту или само на насловној страници. <br /><br /><strong>Напомена:</strong> Сада је могуће приказати важно обавештење на страницама курса како бисте упозорили предаваче да су курсеви скривени.';
$string['alertdisabled'] = 'Онемогућено';
$string['alertdisabledesc'] = 'Онемогући ово важно обавештење.';
$string['alerthiddencourse'] = 'Упозорење о скривеном курсу';
$string['alerthiddencoursedesc'] = 'Приказује важно обавештење на страници курса ако је курс скривен';
$string['alerthiddencoursetext-end'] = '.';
$string['alerthiddencoursetext-link'] = 'кликните овде како бисте ажурирали подешавања';
$string['alerthiddencoursetext-start'] = 'Овај курс је скривен и полазници не могу да му приступе.';
$string['alerticoninfo'] = 'Иконица "Информација"';
$string['alerticoninfodesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome иконицу</a> која ће се користити за важна обавештења типа "Информација". Унесите назив иконице без префикса fa-.';
$string['alerticonsuccess'] = 'Иконица "Оглас"';
$string['alerticonsuccessdesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome иконицу</a> која ће се користити за важна обавештења типа "Оглас". Унесите назив иконице без префикса fa-.';
$string['alerticonwarning'] = 'Иконица "Упозорење"';
$string['alerticonwarningdesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome иконицу</a> која ће се користити за важна обавештења типа "Уозорење". Унесите назив иконице без префикса fa-.';
$string['alertinfo'] = 'Информација';
$string['alertinfodesc'] = 'Приказује информацију у оквиру за важна обавештења.';
$string['alertkeyvalue'] = 'Кључ важног обавештења';
$string['alertkeyvalue_details'] = 'Кључ који разликује ово важно обавештење од претходних. Ако промените овај кључ, сви корисници који су претходно одбацили обавештење, видеће га поново. Ако измените обавештење, вероватно ћете хтети да промените и кључ како бисте били сигурни да ће корисници видети обавештење.';
$string['alertprofilefield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['alertprofilefielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: usertype=student.';
$string['alertsettings'] = 'Оквир са важним обавештењем {$a}';
$string['alertsettingscourse'] = 'Подешавања важних обавештења на курсу';
$string['alertsettingsgeneral'] = 'Општа подешавања важних обавештења';
$string['alertsettingsheading'] = 'Прилагодите оквир са важним обавештењем на врху странице. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['alerttext'] = 'Текст важног обавештења';
$string['alerttextdesc'] = 'Унети текст који ће бити приказан у оквиру са важним обавештењем.';
$string['alerttype'] = 'Тип оквира са важним обавештењем';
$string['alerttypedesc'] = 'Изаберите тип обавештења: информација (плаво), упозорење (жуто) или оглас (зелено).';
$string['alertwarning'] = 'Упозорење';
$string['alertwarningdesc'] = 'Приказује упозорење у оквиру за важна обавештења.';
$string['analyticscount'] = 'Број поља аналитике';
$string['analyticscountdesc'] = 'Број поља аналитике који се приказује у наставку ове странице за уређивање.';
$string['analyticsprofilefield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['analyticsprofilefielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: usertype=student.';
$string['analyticssettings'] = 'Аналитика';
$string['analyticssettingsdesc'] = 'Можете да подесите више кôдова за Google Analytics и повежете их са пољима корисничких профила. Такође можете да користите Matomo, алат за аналитику, отвореног кôда.';
$string['analyticssettingsheading'] = 'Подешавање за Google Analytics и/или Matomo';
$string['analyticstext'] = 'ID ознака за Google Analytics';
$string['analyticstextdesc'] = 'Унесите ID ознаку за Google Analytics.';
$string['anonymizega'] = 'Сакриј корисничку IP адресу';
$string['anonymizegadesc'] = 'Сакриј корисничку IP адресу пре слања података за Google Analytics.';
$string['backcolor'] = 'Боја позадине';
$string['backcolordesc'] = 'Подесите боју позадине.';
$string['bcustyle'] = 'BCU стил';
$string['blockbackgroundcolor'] = 'Боја позадине блока';
$string['blockbackgroundcolordesc'] = 'Подесите боју позадине за све блокове.';
$string['blockbordercolor'] = 'Боја бордуре блока';
$string['blockbordercolordesc'] = 'Подесите боју бордуре блока.';
$string['blockheaderbackgroundcolor'] = 'Боја позадине наслова блока';
$string['blockheaderbackgroundcolordesc'] = 'Подесите боју позадине наслова за све блокове.';
$string['blockheaderborderbottom'] = 'Дебљина доње бордуре заглавља блока';
$string['blockheaderborderbottomdesc'] = 'Подесите дебљину доње бордуре заглавља блокова.';
$string['blockheaderborderleft'] = 'Дебљина леве бордуре заглавља блока';
$string['blockheaderborderleftdesc'] = 'Подесите дебљину леве бордуре заглавља блокова.';
$string['blockheaderborderright'] = 'Дебљина десне бордуре заглавља блока';
$string['blockheaderborderrightdesc'] = 'Подесите дебљину десне бордуре заглавља блокова.';
$string['blockheaderbordertop'] = 'Дебљина горње бордуре заглавља блока';
$string['blockheaderbordertopdesc'] = 'Подесите дебљину горње бордуре заглавља блокова.';
$string['blockheaderbordertopstyle'] = 'Стил бордура заглавља блокова';
$string['blockheaderbordertopstyledesc'] = 'Подесите стил бордура заглавља блокова.';
$string['blockheaderbottomradius'] = 'Доњи полупречник заглавља блока';
$string['blockheaderbottomradiusdesc'] = 'Подесите доњи полупречник блока заглавља како бисте постигли ефекат закривљености/заобљености.';
$string['blockheadercolor'] = 'Боја текста заглавља блока';
$string['blockheadercolordesc'] = 'Подесите боју текста заглавља блока.';
$string['blockheadertopradius'] = 'Горњи полупречник заглавља блока';
$string['blockheadertopradiusdesc'] = 'Подесите горњи полупречник заглавља блока како бисте постигли ефекат закривљености/заобљености.';
$string['blockicons'] = 'Иконице блокова';
$string['blockiconsdesc'] = 'Подесите ово како би иконице блокова биле приказане у заглављу блока.';
$string['blockiconsheadersize'] = 'Величина иконица у заглављу блокова';
$string['blockiconsheadersizedesc'] = 'Подесите величину иконице фонта која се користи у заглављу moodle блокова. Изаберите вредност са листе.';
$string['blocklayoutbuilder'] = 'Региони насловне странице са блоковима';
$string['blocklayoutbuilderdesc'] = 'Испод можете да направите свој распоред региона са блоковима на насловној страници. <br/>Да бисте додали садржај у ове регионе мораћете да <strong> укључите уређивање на насловној страници вашег Moodle сајта</strong>.<br/>Након тога можете почети да превлачите и спуштате блокове у регионе које сте креирали!';
$string['blocklayoutlayoutcheck'] = 'Проверите свој распоред блокова';
$string['blocklayoutlayoutcheckdesc'] = 'Употребите алат у наставку како бисте проверили број блокова које користите и видели како изгледа ваш нови распоред блокова.';
$string['blocklayoutlayoutcount1'] = 'Можете да подесите највише';
$string['blocklayoutlayoutcount2'] = 'регион/a са блоковима. Тренутно користите:';
$string['blocklayoutlayoutrow'] = 'Ред региона са блоковима';
$string['blocklayoutlayoutrowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на насловној страници.';
$string['blockmainborderbottom'] = 'Дебљина доње бордуре тела блока';
$string['blockmainborderbottomdesc'] = 'Подесите дебљину доње бордуре тела блока.';
$string['blockmainborderleft'] = 'Дебљина леве бордуре тела блока';
$string['blockmainborderleftdesc'] = 'Подесите дебљину леве бордуре тела блока.';
$string['blockmainborderright'] = 'Дебљина десне бордуре тела блока';
$string['blockmainborderrightdesc'] = 'Подесите дебљину десне бордуре тела блока.';
$string['blockmainbordertop'] = 'Дебљина горње бордуре тела блока';
$string['blockmainbordertopdesc'] = 'Подесите дебљину горње бордуре тела блока.';
$string['blockmainbordertopstyle'] = 'Стил бордура тела блока';
$string['blockmainbordertopstyledesc'] = 'Подесите стил бордура тела блока';
$string['blockmainbottomradius'] = 'Доњи полупречник тела блока';
$string['blockmainbottomradiusdesc'] = 'Подесите доњи полупречник тела блока како бисте постигли ефекат закривљености/заобљености.';
$string['blockmaintopradius'] = 'Горњи полупречник тела блока';
$string['blockmaintopradiusdesc'] = 'Подесите горњи полупречник тела блока како бисте постигли ефекат закривљености/заобљености.';
$string['blockregionbackground'] = 'Боја позадине региона блокова';
$string['blockregionbackgrounddesc'] = 'Боја позадине контејнера који садржи прилагођени распоред блокова на насловној страници.';
$string['blockregioneditingtitleshown'] = 'Прикажите наслов региона са блоковима приликом уређивања';
$string['blockregioneditingtitleshowndesc'] = 'Можете приказати / сакрити наслов региона са блоковима приликом уређивања.';
$string['blockside'] = 'Позиција блокова';
$string['blocksidedesc'] = 'Контролише да ли се блокови на страници појављују лево или десно.';
$string['breadcrumb'] = 'Навигациона путања';
$string['breadcrumbbackgroundcolor'] = 'Боја позадине навигационе траке';
$string['breadcrumbbackgroundcolordesc'] = 'Подесите боју позадине навигационе траке.';
$string['breadcrumbdisplay'] = 'Приказ навигационе путање';
$string['breadcrumbdisplaydesc'] = 'Подесите приказ онога што би требало да буде у региону навигационе путање.';
$string['breadcrumbhome'] = 'Ознака почетне странице у навигационој путањи';
$string['breadcrumbhomedesc'] = 'Прикажите ознаку за почетну страницу у навигационој путањи као иконицу или као текст.';
$string['breadcrumbhomeicon'] = 'Иконица';
$string['breadcrumbhomeoff'] = 'Искључено';
$string['breadcrumbhometext'] = 'Текст';
$string['breadcrumbseparator'] = 'Граничник навигационе путање';
$string['breadcrumbseparatordesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome иконицу</a> која ће се користити као граничник у навигационој траци. Унесите назив иконице без префикса fa-.';
$string['breadcrumbtextcolor'] = 'Боја текста навигационе путање';
$string['breadcrumbtextcolordesc'] = 'Подесите боју текста навигационе путање.';
$string['breadcrumbtitle'] = 'Назив курса у навигационој путањи';
$string['breadcrumbtitledesc'] = 'Подесите начин на који ће назив курса бити приказан у навигационој путањи.';
$string['bs4all'] = 'Екстра мали - Екстра велики';
$string['bs4extralarge'] = 'Само екстра велики';
$string['bs4large'] = 'Велики - Екстра велики';
$string['bs4medium'] = 'Средњи - Екстра велики';
$string['bs4none'] = 'Ниједан';
$string['bs4small'] = 'Мали - Екстра велики';
$string['buttoncolor'] = 'Боја дугмета';
$string['buttoncolorcancel'] = 'Боја дугмета \'Откажи\'';
$string['buttoncolordesc'] = 'Боја главне дугмади која се користе на читавом сајту.';
$string['buttoncolordesccancel'] = 'Боја позадине дугмета \'Откажи\'<br />Унесите <strong>transparent</strong> у оквир за транспарентност.';
$string['buttoncolordescscnd'] = 'Боја секундарних дугмади која се користе на читавом веб сајту.';
$string['buttoncolorscnd'] = 'Боја секундарног дугмета';
$string['buttondesc'] = 'Промените изглед дугмади која се користе у овој теми.';
$string['buttondropshadow'] = 'Декорација у форми сенке на дну дугмета';
$string['buttondropshadowdesc'] = 'Прикажите сенку (сенчење) на дну дугмета.';
$string['buttonfocuscolour'] = 'Боја позадине приликом фокусирања дугмета';
$string['buttonfocuscolourdesc'] = 'Боја коју дугме користи када се нађе у фокусу.';
$string['buttonhovercolor'] = 'Лебдећа боја дугмета';
$string['buttonhovercolorcancel'] = 'Лебдећа боја дугмета \'Откажи\'';
$string['buttonhovercolordesc'] = 'Боја дугмета када се мишем пређе преко њега';
$string['buttonhovercolordesccancel'] = 'Боја у коју се мења дугме \'Откажи\' када пређете мишем преко дугмета. <br />Упишите <strong>transparent</strong> у оквир за транспарентност.';
$string['buttonhovercolordescscnd'] = 'Боја у коју се мења секундарно дугме када пређете мишем преко дугмета.';
$string['buttonhovercolorscnd'] = 'Лебдећа боја секундарног дугмета';
$string['buttonlogincolor'] = 'Боја дугмета за пријаву';
$string['buttonlogincolordesc'] = 'Боја дугмета за пријаву на систем.';
$string['buttonloginheight'] = 'Подеси висину дугмета за пријаву';
$string['buttonloginheightdesc'] = 'Ово подешавање има ефекта само ако се користи образац за пријаву на систем у горњем заглављу.';
$string['buttonloginhovercolor'] = 'Лебдећа боја дугмета за пријаву';
$string['buttonloginhovercolordesc'] = 'Боја дугмета за пријаву на систем када се мишем пређе преко њега';
$string['buttonloginmargintop'] = 'Подесите горњу маргину дугмета за пријаву';
$string['buttonloginmargintopdesc'] = 'Омогућава да растојање дугмета за пријаву од горње ивице, односно његово позиција буде промењена.';
$string['buttonloginpadding'] = 'Подеси размак између ивице и текста дугмета за пријаву';
$string['buttonloginpaddingdesc'] = 'Већи број = веће дугме.';
$string['buttonlogintextcolor'] = 'Боја текста дугмета за пријаву';
$string['buttonlogintextcolordesc'] = 'Боја текста који се користи на дугмету за пријаву на систем.';
$string['buttonradius'] = 'Подеси полупречник дугмета';
$string['buttonradiusdesc'] = 'Већи полупречник = закривљена дугмад, мањи полупречник = четвртаста дугмад.';
$string['buttonsettings'] = 'Дугмад';
$string['buttonsettingsheading'] = 'Подесите дугмад у овој теми';
$string['buttontextcolor'] = 'Боја текста дугмета';
$string['buttontextcolorcancel'] = 'Боја текста на дугмету \'Откажи\'';
$string['buttontextcolordesc'] = 'Боја текста који се користи на дугмадима.';
$string['buttontextcolordesccancel'] = 'Боја текста која се користи на дугмадима за отказивање.';
$string['buttontextcolordescscnd'] = 'Боја текста која се користи на секундарним дугмадима.';
$string['buttontextcolorscnd'] = 'Боја текста секундарних дугмади';
$string['buttontextfocuscolour'] = 'Боја текста приликом фокусирања дугмета';
$string['buttontextfocuscolourdesc'] = 'Боја текста коју дугме користи када се нађе у фокусу.';
$string['buttontexthovercolor'] = 'Лебдећа боја текста на дугмету';
$string['buttontexthovercolordesc'] = 'Боја у коју се мења текст дугмета када пређете мишем преко дугмета.';
$string['cachedef_adaptablefontawesomeiconmapping'] = 'Кешира Font Awesome иконице';
$string['categoryhavecustomheader'] = 'Прилагођено заглавље категорије';
$string['categoryhavecustomheaderdesc'] = 'Изаберите категорије највишег нивоа које ће имати прилагођено заглавље. Да бисте изабрали више од једне или поништили избор категорије, користите тастер \'Ctrl\'. Сачувајте и освежите страницу како бисте је ажурирали. Напомена: поткатегорије изабраних категорије ће наследити вредности подешавања.';
$string['categoryheaderbgimage'] = 'Позадинска слика категорије \'{$a->name}\' са ID ознаком id \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Подесите позадинску слику за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' у заглављу. Минимална величина је 1600x180 пиксела (препоручују се 1900x180 пиксела). Слика ће покрити цело заглавље.';
$string['categoryheaderbgimagedescchildren'] = 'Подесите позадинску слику за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' и њене поткатегорије \'{$a->children}\' у заглављу. Минимална величина је 1600x180 пиксела (препоручују се 1900x180 пиксела). Слика ће покрити цело заглавље.';
$string['categoryheaderbgimagetextcolour'] = 'Боја текста на позадинској слици категорије \'{$a->name}\' са ID ознаком id \'{$a->id}\'';
$string['categoryheaderbgimagetextcolourdesc'] = 'Подесите боју текста слике на позадинској слици за категорију највишег нивоа \'{$a->name}\' са ID ознаком id \'{$a->id}\' у заглављу.';
$string['categoryheaderbgimagetextcolourdescchildren'] = 'Подесите боју текста на позадинској слици за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' и њене поткатегорије \'{$a->children}\' у заглављу.';
$string['categoryheadercustomcss'] = 'Прилагођени SCSS категорије \'{$a->name}\' са ID ознаком \'{$a->id}\'';
$string['categoryheadercustomcssdesc'] = 'Подесите прилагођени SCSS за категорију највишег нивоа \'{$a->name}\' са ID ознаком id \'{$a->id}\'. Ово ће генерисати SCSS за селектор теме са префиксом \'.category-{$a->id}\'. Ако се вам се учини да SCSS није примењен, онда употребите алате за развој веб читача како бисте утврдили шта се догодило. Такође, проверите PHP датотеку записа.';
$string['categoryheadercustomcssdescchildren'] = 'Подесите прилагођени SCSS за категорију највишег нивоа \'{$a->name}\' са ID ознаком id \'{$a->id}\' и све њене поткатегорије \'{$a->children}\'. Ово ће генерисати SCSS за селектор теме са префиксом \'.category-{$a->id}\' и за све ID ознаке поткатегорија. Ако се вам се учини да SCSS није примењен, онда употребите алате за развој веб читача како бисте утврдили шта се догодило. Такође, проверите PHP датотеку записа.';
$string['categoryheadercustomtitle'] = 'Прилагођени наслов категорије \'{$a->name}\' са ID ознаком \'{$a->id}\'';
$string['categoryheadercustomtitledesc'] = 'Подесите прилагођени наслов за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' у заглављу. Ако је празно, биће вам приказано са оним што је конфигурисано подешавањима \'sitetitle\' и \'sitetitletext\' на страницама које нису повезане са курсом или на страницама курса када је подешавање \'enableheading\' конфигурисано на \'off\'. Када се попуни на страницама које нису повезане са категоријама курсева, ово ће заменити наслов сајта. Када се попуни на страницама курса, појавиће се изнад наслова као што је постављено подешавањем \'enableheading\'. Али на мобилним уређајима сваки \'title\' ће се појавити само у зависности од подешавања \'responsivecoursetitle\'.';
$string['categoryheadercustomtitledescchildren'] = 'Подесите прилагођени наслов за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' и њене поткатегорије  \'{$a->children}\' у заглављу. Ако је празно, биће вам приказано са оним што је конфигурисано подешавањима \'sitetitle\' и \'sitetitletext\' на страницама које нису повезане са курсом или на страницама курса када је подешавање \'enableheading\' конфигурисано на \'off\'. Када се попуни на страницама које нису повезане са категоријама курсева, ово ће заменити наслов сајта. Када се попуни на страницама курса, појавиће се изнад наслова као што је постављено подешавањем \'enableheading\'. Али на мобилним уређајима сваки \'title\' ће се појавити само у зависности од подешавања \'responsivecoursetitle\'.';
$string['categoryheaderheader'] = 'Подешавања за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Конфигуришите подешавање за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Конфигуришите подешавање за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' и све њене поткатегорије \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Логотип категорије \'{$a->name}\' са ID ознаком \'{$a->id}\'';
$string['categoryheaderlogodesc'] = 'Подесите лого за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' у заглављу. Препоручена величина је 200 са 80 пиксела.';
$string['categoryheaderlogodescchildren'] = 'Подесите лого за категорију највишег нивоа \'{$a->name}\' са ID ознаком \'{$a->id}\' и њене поткатегорије \'{$a->children}\' у заглављу. Препоручена величина је 200 са 80 пиксела.';
$string['categoryheaderssettings'] = 'Заглавља категорија';
$string['categoryheaderssettingsdesc'] = 'Конфигуришите подешавања за заглавља унутар категорије.';
$string['categoryheaderssettingsheading'] = 'Промените заглавље за једну или више категорија највишег нивоа и поткатегоријa.';
$string['cdefaulticon'] = 'Стандардна иконица за \'Моји курсеви\'';
$string['cdefaulticondesc'] = 'Font Awesome иконица без префикса \'fa-\' која се користи за курсеве када већ немају иконицу. Ако је поље празно, користиће се стандардна иконица.';
$string['cfrozenicon'] = 'Иконица за замрзнуте \'Моје курсеве\'';
$string['cfrozenicondesc'] = 'Font Awesome иконица без префикса \'fa-\' која се користи за замрзнуте курсеве. Ако је поље празно, користиће се стандардна иконица.';
$string['chiddenicon'] = 'Иконица за скривене \'Моје курсеве\'';
$string['chiddenicondesc'] = 'Font Awesome иконица без префикса \'fa-\' која се користи за скривене курсеве. Ако је поље празно, користиће се стандардна иконица.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h2>Заслуге</h2>
<h3>О теми</h3>
<p>Adaptable је Moodle прилагодљива тема са два ступца, и са великим бројем опција за прилагођавање. Тема се базира на популарној BCU теми.</p>
<p>Ова тема је објављена под GPL  лиценцом (GNU General Public License). Комплетну копију лиценце можете наћи на: http://www.gnu.org/licenses/</p>
<p>Мењајте је / Унапређујте / Делите</p>
<br>
<p>Ову тему су развили:<br>
Jeremy Hopkins (Coventry University)<br>
Fernando Acedo (3-bits.com)<br>
</p>
<br>
 <p>и многи други програмери, тестери, преводиоци и волонтери (See <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<h3>Извештај о грешкама</h3>
<p>Грешке можете пријавити (и молимо вас, <b>САМО</b> грешке) на нашем <a href="https://bitbucket.org/covuni/moodle-theme_adaptable/issues" target="_blank">Bitbucket репозиторијуму</a></p>
<br>
<h3>Техничка подршка</h3>
<p>Можете постављати своја питања и недоумице, и делити своје савете на Moodle форуму:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Документација</h3>
<p>Ускоро</p>
<br>
<h3>Демо</h3>
<p>Демо верзију теме можете видети <a href="http://3-bits.com/demo/adaptable" target="_blank">ОВДЕ</a></p>
<br>
</div>
</div>';
$string['cneveraccessedicon'] = 'Иконица за \'Моје курсеве\' којима корисници нису приступили';
$string['cneveraccessedicondesc'] = 'Font Awesome иконица без префикса \'fa-\' која се користи за курсеве на које су корисници уписани али им нису приступали. Ако је поље празно, користиће се стандардна иконица.';
$string['collapsedtopicscoloursenabled'] = 'Подешавања боја предњег плана и позадине прекидача формата курса \'Скупљене теме\'';
$string['collapsedtopicscoloursenableddesc'] = 'Користите подешавања боје предњег плана и позадине прекидача формата курса \'Скупљене теме\', уместо подешавања \'sectionheadingcolor\' и \'coursesectionheaderbg\' теме Adaptable.';
$string['colordesc'] = 'Можете да изаберете боје које желите да користите у оквиру ове теме. Користите хексадецималну или било коју другу стандардну нотацију. Алтернативно, можете да користите вредности "transparent" или "inherited"';
$string['colorsettings'] = 'Боје';
$string['colorsettingsheading'] = 'Измените главне боје које се користе у овој теми.';
$string['configtabtitle'] = 'Подешавања';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Курс';
$string['courseactivitynavigationenabled'] = 'Навигација активности';
$string['courseactivitynavigationenableddesc'] = 'Навигација активности омогућена.';
$string['courseindexenabled'] = 'Омогућено';
$string['courseindexenableddesc'] = 'Омогућите или онемогућите \'Индекс курса\'.';
$string['courseindexitemcolor'] = 'Боја ставке';
$string['courseindexitemcolordesc'] = 'Боја ставке у \'Индексу курса\'.';
$string['courseindexitemhovercolor'] = 'Лебдећа боја ставке';
$string['courseindexitemhovercolordesc'] = 'Лебдећа боја ставке у \'Индексу курса\'.';
$string['courseindexpageitembgcolor'] = 'Боја позадине активне ставке';
$string['courseindexpageitembgcolordesc'] = 'Боја позадине активне ставке у \'Индексу курса\'.';
$string['courseindexpageitemcolor'] = 'Боја активне ставке';
$string['courseindexpageitemcolordesc'] = 'Боја активне ставке у \'Индексу курса\'';
$string['courseindexsettings'] = 'Индекс курса';
$string['courseindexsettingsdesc'] = 'Прилагодите индекс курса.';
$string['courseindexsettingsheading'] = 'Подешавања индекса курса';
$string['coursepageactivitybottomblockregionheading'] = 'Прилагођени доњи регион са блоковима на страници активности';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Прилагођени регион са блоковима који се појављује након завршетка активности.';
$string['coursepageblockactivitybottomenabled'] = 'Омогућите доњи регион са блоковима унутар страница активности, на свим страницама курса';
$string['coursepageblockactivitybottomenableddesc'] = 'Омогућите овај регион на свим страницама курса.';
$string['coursepageblocklayoutbuilder'] = 'Региони блокова на страници курса';
$string['coursepageblocklayoutbuilderdesc'] = 'Испод можете да направите свој распоред региона са блоковима на страници курса.<br/>Да бисте додали садржај у ове регионе мораћете да <strong> укључите уређивање на страници курса вашег Moodle сајта</strong>.<br/>Након тога можете почети да превлачите и спуштате блокове у регионе које сте креирали!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Ред региона са блоковима на дну странице курса';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на страници курса.';
$string['coursepageblocklayoutlayouttoprow'] = 'Ред региона са блоковима на врху странице курса';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на страници курса.';
$string['coursepageblockregionsettings'] = 'Алат за креирање региона блокова на страници курса';
$string['coursepageblocksenabled'] = 'Омогући прилагођене регионе са блоковима на страници курса';
$string['coursepageblocksenableddesc'] = 'Можете да омогућите / онемогућите прилагођене регионе са блоковима (горњи и доњи) на страници курса. Након тога можете да превучете и спустите блокове у регионе које сте креирали.';
$string['coursepageblocksliderenabled'] = 'Омогућите прилагођени регион са блоком \'Слајд-шоу са вестима\'';
$string['coursepageblocksliderenableddesc'] = 'Омогућите овај регион на свим страницама курса.';
$string['coursepageheaderhidesitetitle'] = 'Сакриј назив сајта на страницама курса';
$string['coursepageheaderhidesitetitledesc'] = 'Сакријте назив сајта, лого и поље за претрагу на страницама курса. Користите ово заједно са подешавањем висине заглавља странице како бисте приказали мање заглавље на страницама курса.';
$string['coursepageheaderhidetitle'] = 'Сакриј наслов заглавља на страницама курса';
$string['coursepageheaderhidetitledesc'] = 'Сакријте наслов заглавља, логотип и траку за претрагу на страницама курса. Користите ово заједно са подешавањем висине заглавља странице како бисте приказали мање заглавље на страницама које су повезане са курсом.';
$string['coursepagenewssliderblockregionheading'] = 'Прилагођени регион са блоком \'Слајд-шоу са вестима\'';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Прилагођени регион са блоком дизајнираним да се користи као слајд-шоу са вестима који је део Adaptable UI.  Овај регион се појављује изнад активности на страници курса.  Да бисте додали блок који приказује слајд-шоу са вестима, прво инсталирајте <strong><a href="{$a}" target="_blank">Adaptable UI слајд-шоу са вестима</a></strong> и конфигуришите га тако да се појављује у региону "регион за слајд-шоу странице курса" на свим страницама курса.';
$string['coursepagesidebarinfooterenabled'] = 'Премести бочни стубац са блоковима у подножје странице курса';
$string['coursepagesidebarinfooterenableddesc'] = 'Премештањем бочног ступца са блоковима у подножје странице, део странице курса са секцијама ће се проширити.';
$string['coursepagesidebarinfooterenabledsection'] = 'Уобичајена подешавања';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Уобичајена подешавања за већину формата курсева.';
$string['courses'] = 'Курсеви';
$string['coursesearch'] = 'Претрага курсева';
$string['coursesectionactivityassignbgcolor'] = 'Боја позадине \'Задатка\'';
$string['coursesectionactivityassignbgcolordesc'] = 'Подесите боју позадине за активност \'Задатак\'. Унесите <strong>transparent</strong> у поље за транспарентност.';
$string['coursesectionactivityassignleftbordercolor'] = 'Боја приказа леве бордуре активности \'Задатак\'';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Подесите боју леве бордуре.';
$string['coursesectionactivitybordercolor'] = 'Боја доње бордуре активности унутар секције курса';
$string['coursesectionactivitybordercolordesc'] = 'Подесите боју доње бордуре активности унутар секције курса.';
$string['coursesectionactivityborderstyle'] = 'Стил доње бордуре активности унутар секције курса';
$string['coursesectionactivityborderstyledesc'] = 'Подесите стил доње бордуре активности унутар секције курса.';
$string['coursesectionactivityborderwidth'] = 'Ширина доње бордуре активности унутар секције курса';
$string['coursesectionactivityborderwidthdesc'] = 'Подесите ширину бордуре која се појављује на дну активности унутар секције курса.';
$string['coursesectionactivitycolors'] = 'Подешавања активности унутар секције курса';
$string['coursesectionactivityforumbgcolor'] = 'Боја позадине \'Форума\'';
$string['coursesectionactivityforumbgcolordesc'] = 'Подесите боју позадине за активност \'Форум\'. Унесите <strong>transparent</strong> у поље за транспарентност.';
$string['coursesectionactivityforumleftbordercolor'] = 'Боја приказа леве бордуре активности \'Форум\'';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Подесите боју леве бордуре.';
$string['coursesectionactivityheadingcolour'] = 'Боја наслова секције унутар секције курса';
$string['coursesectionactivityheadingcolourdesc'] = 'Боја за активности на које се може кликнути, приказана на почетној страници курса.';
$string['coursesectionactivityiconsize'] = 'Величина иконица активности унутар секције курса';
$string['coursesectionactivityiconsizedesc'] = 'Подесите величину иконица за активности / ресурсе (нпр. вредност 16px ће подесити димензије иконица на величину 16 x 16 пиксела).';
$string['coursesectionactivityleftborderwidth'] = 'Ширина леве бордуре активности унутар секције курса';
$string['coursesectionactivityleftborderwidthdesc'] = 'Подесите ширину бордуре која се појављује са леве стране активности унутар секције курса';
$string['coursesectionactivitymarginbottom'] = 'Доња маргина размака између активности.';
$string['coursesectionactivitymarginbottomdesc'] = 'Доња маргина размака између активности.';
$string['coursesectionactivitymargintop'] = 'Горња маргина размака између активности.';
$string['coursesectionactivitymargintopdesc'] = 'Горња маргина размака између активности.';
$string['coursesectionactivityquizbgcolor'] = 'Боја позадине \'Теста\'';
$string['coursesectionactivityquizbgcolordesc'] = 'Подесите боју позадине за активност \'Тест\'. Унесите <strong>transparent</strong> у поље за транспарентност.';
$string['coursesectionactivityquizleftbordercolor'] = 'Боја приказа леве бордуре активности \'Тест\'';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Подесите боју леве бордуре.';
$string['coursesectionbgcolor'] = 'Позадина секције курса';
$string['coursesectionbgcolordesc'] = 'Подесите боју позадине секције курса.';
$string['coursesectionbordercolor'] = 'Боја бордура секције курса';
$string['coursesectionbordercolordesc'] = 'Подесите боју бордура секција курса';
$string['coursesectionborderradius'] = 'Полупречник бордура секције';
$string['coursesectionborderradiusdesc'] = 'Подесите полупречник бордура секције курса (заобљени углови).';
$string['coursesectionborderstyle'] = 'Стил бордура секције';
$string['coursesectionborderstyledesc'] = 'Подесите стил бордура секције курса.';
$string['coursesectionborderwidth'] = 'Ширина бордура секције';
$string['coursesectionborderwidthdesc'] = 'Подесите ширину бордура секција курса.';
$string['coursesectionheaderbg'] = 'Позадина заглавља секције';
$string['coursesectionheaderbgdesc'] = 'Подесите боју позадине заглавља секције курса.';
$string['coursesectionheaderbordercolor'] = 'Боја бордуре заглавља секције';
$string['coursesectionheaderbordercolordesc'] = 'Подесите боју бордуре заглавља секције (користи се само доња бордура пошто спољашњи контејнер има бордуру).';
$string['coursesectionheaderborderradiusbottom'] = 'Доњи полупречник бордуре заглавља секције';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Подесите доњи полупречник бордуре заглавља секције (заобљени углови).';
$string['coursesectionheaderborderradiustop'] = 'Горњи полупречник бордуре заглавља секције';
$string['coursesectionheaderborderradiustopdesc'] = 'Подесите горњи полупречник бордура заглавља секције (заобљени углови).';
$string['coursesectionheaderborderstyle'] = 'Стил бордуре заглавља секције курса';
$string['coursesectionheaderborderstyledesc'] = 'Подесите стил бордуре заглавља секције курса (само доња бордура се користи пошто спољашњи контејнер такође име бордуру).';
$string['coursesectionheaderborderwidth'] = 'Ширина бордуре заглавља секције курса';
$string['coursesectionheaderborderwidthdesc'] = 'Подесите ширину бордуре заглавља секције курса (само доња бордура се користи пошто спољашњи контејнер такође име бордуру).';
$string['coursesections'] = 'Секције курса';
$string['coursesettings'] = 'Формати курса';
$string['coursesettingsdesc'] = 'Прилагодите неке од најчешће коришћених формата Moodle курсева како би одговарали главном дизајну.';
$string['coursesettingsheading'] = 'Подешавања формата курса';
$string['coursetitlefullname'] = 'Пун назив курса';
$string['coursetitlemaxwidth'] = 'Максимална дужина наслова курса';
$string['coursetitlemaxwidthdesc'] = 'Подесите максималан број знакова региона са насловом курса';
$string['coursetitleshortname'] = 'Скраћени назив курса / кôд';
$string['covbkcolor'] = 'Боја позадине наслова на Ковентри плочицама';
$string['covbkcolordesc'] = 'Подесите боју позадине наслова када су изабране Ковентри плочице';
$string['coventrystyle'] = 'Ковентри стил';
$string['covfontcolor'] = 'Боја слова наслова на Ковентри плочицама';
$string['covfontcolordesc'] = 'Подесите боју слова наслова када су изабране Ковентри плочице';
$string['covhidebutton'] = 'Дугме курса на Ковентри плочицама';
$string['covhidebuttondesc'] = 'Подесите ову опцију како бисте сакрили дугме за курс када су изабрана Ковентри плочице.';
$string['currentcolor'] = 'Боја наглашавања текуће секције курса';
$string['currentcolordesc'] = 'Подесите боју којом ће бити наглашена текућа секција курса';
$string['customcoursesubtitle'] = 'Прилагођени поднаслов курса';
$string['customcoursesubtitledesc'] = 'Назив прилагођеног поља корисничког профила за поднаслов курса.';
$string['customcoursetitle'] = 'Прилагођени наслов курса';
$string['customcoursetitledesc'] = 'Назив прилагођеног поља корисничког профила за наслов курса.';
$string['customcss'] = 'Прилагођени CSS';
$string['customcssdesc'] = 'CSS правила која додате у ово поље за текст одразиће се на изглед свих страница, што олакшава прилагођавање ове теме.';
$string['customcssjssettingsheading'] = 'Примените сопствене модификације';
$string['customcsssettings'] = 'Прилагођени CSS';
$string['customcsssettingsdescription'] = 'Овде можете пронаћи различита подешавања за додавање сопственог CSS кôда у тему.';
$string['customjs'] = 'Прилагођени JavaScript';
$string['customjsdesc'] = 'Додајте JavaScript на сајт.';
$string['customjsfiles'] = 'Прилагођене JavaScript датотеке';
$string['customjsfilesdesc'] = 'Додајте JavaScript датотеке на сајт.';
$string['customjsrestricted'] = 'Условни JavaScript';
$string['customjsrestricteddesc'] = 'Додајте JavaScript на сајт условно на основу прилагођеног поља профила. Овај JavaScript ће се појавити само ако је испуњен овај услов.';
$string['customjssettings'] = 'Прилагођени JS';
$string['customjssettingsdescription'] = 'Овде можете пронаћи различита подешавања за додавање сопственог JavaScripta у тему. Напомена: JavaScript oзнаке се аутоматски додају, немојте их сами додавати.';
$string['custommenu'] = 'Прилагођени мени';
$string['custommenuitemscoredesc'] = 'Овде се може конфигурисати прилагођени мени. Унесите сваку ставку менија у нови ред. Редови који почињу цртицом појавиће се као ставке унутар подменија ставке која је вишег нивоа. Ставке у менију могу се раздвојити додавањем реда са једним или више знакова #.';
$string['custommenutitle'] = 'Наслов прилагођеног менија';
$string['custommenutitledesc'] = 'Подесите наслов прилагођеног менија који ће садржати све прилагођене меније на навигационој траци. Ако је поље празно, онда ће сваки унети наслов (менија) највишег нивоа креирати засебан мени на навигационој траци.';
$string['customusermenuitemscoredesc'] = 'Можете да конфигуришете садржај корисничког менија (са изузетком линка за одјаву који се аутоматски додаје). Сваки ред је одвојен вертикалним цртама | и састоји се од 1) стринга у облику "langstringname, componentname" (или као обичан текст), 2) URL адресе и 3) назива Font Awesome иконице или CSS класа (опционо). Тамо где је потребно може се користити разделник додавањем реда са једним или више знакова #. Како бисте пронашли бесплатне FontAwesome класе за иконицу коју желите да користите, идите на <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome (бесплатна верзија)</a> и потражите иконицу. Можете користити назив, као нпр \'graduation-cap\' или комплетан списак класа \'fa-solid fa-graduation-cap\'. На пример:
<pre>
messages,message|/message/index.php|fa-regular fa-comment
privatefiles,moodle|/user/files.php|folder-tree
</pre>
Напомена: стандардна основна вредност може да садржи дупликате, прилагодите по жељи.';
$string['dangericoncolor'] = 'Боја иконице за упозорења';
$string['dangericoncolordesc'] = 'Подесите боју иконице за упозорење/опасност која се углавном користи у обавезним пољима.';
$string['dashblocklayoutbuilder'] = 'Региони са блоковима на страници \'Контролни панел\'';
$string['dashblocklayoutbuilderdesc'] = 'Испод можете да направите свој распоред региона са блоковима на страници \'Контролни панел\'.<br/>Да бисте додали садржај у ове регионе мораћете да <strong> укључите уређивање на страници \'Контролни панел\' вашег Moodle сајта</strong>.
<br/>Након тога можете почети да превлачите и спуштате блокове у регионе које сте креирали!';
$string['dashblocklayoutlayoutrow'] = 'Ред региона са блоковима на контролном панелу';
$string['dashblocklayoutlayoutrowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на страници "Контролни панел".';
$string['dashblocksabovecontent'] = 'Прикажи изнад главног садржаја';
$string['dashblocksbelowcontent'] = 'Прикажи испод главног садржаја';
$string['dashblocksenabled'] = 'Омогући прилагођени регион са блоковима на страници "Контролни панел".';
$string['dashblocksenableddesc'] = 'Можете да омогућите / онемогућите прилагођени регион са блоковима на страници \'Контролни панел\'. Затим можете да превучете и спустите блокове у регионе које сте креирали.';
$string['dashblocksposition'] = 'Позиција прилагођеног региона са блоковима';
$string['dashblockspositiondesc'] = 'Када су прилагођени региони блокова омогућени за страницу \'Контролне панел\', изаберите позицију.';
$string['dashboardblockregionsettings'] = 'Алат за креирање региона блокова на контролном панелу';
$string['dashed'] = 'Испрекидана ивица';
$string['defaultzoom'] = 'Подразумевано зумирање (величина екрана)';
$string['defaultzoomdesc'] = 'Подразумевана величина екрана када је опција за укључивање зумирања искључена или када корисник није изабрао жељену опцију. Изаберите између приказа преко целог екрана и фиксне ширине.';
$string['dimmedtextcolor'] = 'Бледа боја текста';
$string['dimmedtextcolordesc'] = 'CSS класа бледог текста (бледи текст) се користи у Moodleu како би се означило када нешто (нека опција) није омогућена / није видљива. Да бисте подесили ту боју у графичкој теми, користите HTML  хексадецимални кôд.';
$string['disablecustommenu'] = 'Онемогући Moodle прилагођени мени';
$string['disablecustommenudesc'] = 'Ово ће онемогућити Moodle прилагођени мени у навигационој траци (мени ће и даље бити видљив у другим темама које сте инсталирали).';
$string['disabled'] = 'Онемогућено';
$string['disablemenuscoursepages'] = 'Онемогући меније на страницама курса';
$string['disablemenuscoursepagesdesc'] = 'Укључивање ове опције ће ограничити приказ горњих менија на странице сајта, почетну страницу и контролни панел (\'Моја почетна страница\') итд. Истовремено, ови менији неће бити приказани на било којој страници курса.';
$string['discardbuttontext'] = 'Откажи';
$string['displayeditingbuttontext'] = 'Текст на дугмету за уређивање';
$string['displayeditingbuttontextdesc'] = 'Прикажите или сакријте текст на дугмету за уређивање. Напомена: Односи се само на дугме за уређивање курса.';
$string['displaygrades'] = 'Прикажи оцене';
$string['displaygradesdesc'] = 'Прикажите оцене у менију.';
$string['displaylogin'] = 'Прикажи образац за пријаве на сајт';
$string['displayloginbox'] = 'Поља за пријаву';
$string['displayloginbutton'] = 'Дугме';
$string['displaylogindesc'] = 'Изаберите како да се прикаже поље за пријава у заглављу';
$string['displayloginno'] = 'Без поља за пријаву';
$string['displayparticipants'] = 'Прикажи учеснике';
$string['displayparticipantsdesc'] = 'Прикажите учесника у менију.';
$string['dividingline'] = 'Линија раздвајања у заглављу';
$string['dividingline2'] = 'Линија раздвајања у подножју';
$string['dividingline2desc'] = 'Боја за линију раздвајања која се налази у подножју странице.';
$string['dividinglinedesc'] = 'Боја за линију раздвајања која се налази у заглављу странице.';
$string['dotted'] = 'Тачкаста ивица';
$string['double'] = 'Двострука ивица';
$string['editcognocourseupdate'] = 'Покажите зупчаник корисницима који не ажурирају курс';
$string['editcognocourseupdatedesc'] = 'Покажите зупчаник корисницима који немају могућност \'moodle/course:update\', тј. улогу ’Предавач без уређивачких права’.';
$string['editfont'] = 'Боја фонта дугмета \'Уреди и прилагоди ову страницу\'';
$string['editfontdesc'] = 'Подесите боју фонта на дугмету \'Уреди и прилагоди ову страницу\'';
$string['edithorizontalpadding'] = 'Подеси хоризонтални размак између ивице и текста дугмади за уређивање';
$string['editoffbk'] = 'Позадина дугмета за искључивање \'Уреди и прилагоди ову страницу\'';
$string['editoffbkdesc'] = 'Подесите боју фонта на дугмету за искључивање режима \'Уреди и прилагоди ову страницу\'.';
$string['editonbk'] = 'Боја позадине дугмета ”Уреди и прилагоди ову страницу”';
$string['editonbkdesc'] = 'Подесите боју позадине дугмета \'Уреди и прилагоди ову страницу\'.';
$string['editsettingsbutton'] = 'Уредите подешавања и приказ дугмади';
$string['editsettingsbuttondesc'] = 'Овде конфигуришите шта треба да се појави у навигационој траци за уређивање подешавања. Имајте на уму да се ове опције не примењују на оним страницама за које не постоје повезана подешавања, као што је то, нпр, страница \'Контролни панел\'.';
$string['editsettingsbuttonshowbutton'] = 'Прикажи само дугме за уређивање. Нпр. дугме "Укључи уређивање" на страници курса.';
$string['editsettingsbuttonshowcog'] = 'Прикажи само иконицу за уређивање подешавања (иконица зупчаника).';
$string['editsettingsbuttonshowcogandbutton'] = 'Прикажи дугме за уређивање и зупчаник. Имајте на уму да ово заузима више простора у навигационој траци.';
$string['emoticonsize'] = 'Величина емотикона';
$string['emoticonsizedesc'] = 'Подесите висину и ширину Moodle емотикона.';
$string['enableaccesstool'] = 'Алат за приступачност';
$string['enableaccesstooldesc'] = 'Прикажите линк ка страници са подешавањима корисника "Алатка за приступачност" - напомена: ово захтева да је инсталиран \'<a href="{$a}" target="_blank">додатак "Алатка за приступачност"</a>\'.';
$string['enablealert'] = 'Омогући оквир са важним обавештењем {$a}';
$string['enablealertdesc'] = 'Омогући оквир са важним обавештењем {$a}';
$string['enablealerts'] = 'Омогући / онемогући важна обавештења';
$string['enablealertsdesc'] = 'Омогућите / онемогућите важна обавештења на вашем сајту (не на страницама курсева). Погледајте подешавање \'alerthiddencourse\'.';
$string['enablealertstriptags'] = 'Уклони аутоматски html ознаке из обавештења';
$string['enablealertstriptagsdesc'] = 'Ако омогућите ову опцију важна обавештења ће аутоматски бити очишћена и искључена како би вам пружила могућност да употребите HTML / линкове у порукама, али ћете морати ручно да их очистите у HTML приказу.';
$string['enableanalytics'] = 'Омогући Google Analytics';
$string['enableanalyticsdesc'] = 'Омогућите  подешавања за Google Analytics на свом Moodle сајту';
$string['enableavailablecourses'] = 'Прикажи "Доступни курсеви"';
$string['enableavailablecoursesdesc'] = 'Прикажите натпис ”Доступни курсеви” на насловној страници.';
$string['enablebadges'] = 'Беџеви';
$string['enablebadgesdesc'] = 'Прикажите линк ка беџевима корисника.';
$string['enableblog'] = 'Омогући моје блогове';
$string['enableblogdesc'] = 'Прикажите линк ка страницама блогова корисника.';
$string['enablecalendar'] = 'Кориснички календар';
$string['enablecalendardesc'] = 'Прикажите линк ка календару корисника.';
$string['enablecompetencieslink'] = 'Линк ка компетенцијама';
$string['enablecompetencieslinkdesc'] = 'Прикажите линк као компетенцијама у менију \'Овај курс\'. Напомена: подешавање \'\'core_competency|enabled\'\' треба да буде укључено.';
$string['enablecoursesectionsdesc'] = 'Прикажите подмени, у менију \'Овај курс\', који садржи линкове ка свакој приказаној секцији.';
$string['enablecoursetitle'] = 'Назив курса';
$string['enablecoursetitledesc'] = 'Подесите начин на који ће назив курса бити приказан.';
$string['enabledtabbedprofileeditprofilelink'] = 'Омогући картицу за уређивање профила';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Омогућите картицу за уређивање профила на страници профила са картицама. Напомена: када је ово омогућено, приказаће се само уколико корисник који прегледа профил има дозволу да га уређује.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Омогући картицу за подешавања параметара';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Омогућите картицу за корисничка подешавања параметара на страници профила са картицама.';
$string['enableeditprofile'] = 'Уреди профил';
$string['enableeditprofiledesc'] = 'Прикажите линк за уређивање профила корисника.';
$string['enableeventsdesc'] = 'Прикажите линк ка календару.';
$string['enablefeed'] = 'Моје повратне информације';
$string['enablefeeddesc'] = 'Приказује линк ка страници корисника ”Моје повратне информације” - напомена: ово захтева <a href="https://moodle.org/plugins/report_myfeedback" target="blank">додатак ”Моје повратне информације”</a>';
$string['enablegrades'] = 'Оцене';
$string['enablegradesdesc'] = 'Прикажите линк ка оценама корисника';
$string['enableheading'] = 'Заглавље са насловом курса';
$string['enableheadingdesc'] = 'Подесите режим за приказ наслова курса у заглављу када је омогућен подразумеван наслов Moodle сајта.';
$string['enablehelp'] = 'Линк за помоћ \'{$a->number}\'';
$string['enablehelpdesc'] = 'Додајте линк за помоћ \'{$a->number}\' у навигациону траку.';
$string['enablehomedesc'] = 'Прикажите линк ка насловној страници.';
$string['enablehomeredirect'] = 'Омогући редирекцију (redirect=0) ка насловној страници';
$string['enablehomeredirectdesc'] = 'Омогућите редирекцију (redirect=0) ка насловној страници. Ово се користи на сајтовима на којима је као подразумевана почетна страница постављена \'Моја почетна страница / Контролни панел\'. Ово ће спречити да корисник, када кликне на линк \'Почетна страница\', буде преусмерен на \'Моја почетна страница / Контролни панел\'.';
$string['enablemenus'] = 'Омогући меније';
$string['enablemenusdesc'] = 'Препоручује се да ово оставите искључено, ако се менији не користе због перформанси система.';
$string['enablemy'] = 'Контролни панел';
$string['enablemydesc'] = 'Прикажите линк ка страници \'Контролни панел\'';
$string['enablemysitesdesc'] = 'Прикажите падајући мени са курсевима корисника';
$string['enablemysitesrestriction'] = 'Ограничите падајући мени са курсевима корисника на прилагођено поље профила';
$string['enablemysitesrestrictiondesc'] = 'Ограничите падајући мени са курсевима корисника према прилагођеном пољу профила. Нпр. usertype=staff.';
$string['enablenavbarwhenloggedout'] = 'Омогућите навигациону траку када сте одјављени';
$string['enablenavbarwhenloggedoutdesc'] = 'Приказује навигациону траку чак и када сте одјављени. Ограничено само на помоћ и мени алата.';
$string['enablenote'] = 'Моја обавештења';
$string['enablenotedesc'] = 'Прикажите линк ка страници са обавештењима за корисника';
$string['enableposts'] = 'Моји постови';
$string['enablepostsdesc'] = 'Прикажите линк ка страници са мојим постовима';
$string['enablepref'] = 'Моја подешавања';
$string['enableprefdesc'] = 'Прикажите линк ка страници са подешавањима корисника';
$string['enableprivatefiles'] = 'Приватне датотеке';
$string['enableprivatefilesdesc'] = 'Прикажите линк ка ка приватним датотекама корисника.';
$string['enableprofile'] = 'Кориснички профил';
$string['enableprofiledesc'] = 'Прикажите линк ка профилу корисника.';
$string['enablesavecanceloverlay'] = 'Омогућите прекривајући слој са дугмадима \'Сачувај\' / \'Откажи\'на страницама са подешавањима';
$string['enablesavecanceloverlaydesc'] = 'Прикажите прекривајући слој са дугмадима \'Сачувај\' / \'Откажи\' на врху странице са подешавањима како бисте лакше сачували подешавања.';
$string['enablesavecanceloverlayresetconfirm'] = 'Ово ресетује све промене направљене од учитавања ове странице. Јесте ли сигурни?';
$string['enableshowhideblocks'] = 'Омогући прекидач ”Прикажи/Сакриј блокове”';
$string['enableshowhideblocksdesc'] = 'Омогућава корисницима да прикажу/сакрију све блокове.';
$string['enableshowhideblockstext'] = 'Прикажи текст за \'Прикажи сакриј блокове\'';
$string['enableshowhideblockstextdesc'] = 'Приказује текст поред дугмета.';
$string['enabletabbedprofile'] = 'Омогући картични приказ странице профила';
$string['enabletabbedprofiledesc'] = 'Омогућите функцију приказа странице профила са картицама.';
$string['enablethiscoursedesc'] = 'Прикажите падајући мени са активностима из текућег курса.';
$string['enableticker'] = 'Омогући покретну траку са вестима на почетној страници';
$string['enabletickerc'] = 'Омогући покретну траку са вестима на интерним страницама';
$string['enabletickercdesc'] = 'Означите ово како бисте омогућили покретну траку са вестима на интерним страницама.';
$string['enabletickerdesc'] = 'Означите ово како бисте омогућили покретну траку са вестима на почетној страници.';
$string['enabletickermy'] = 'Да ли омогућити покретну траку са вестима?';
$string['enabletickermydesc'] = 'Означите ово како бисте омогућили покретну траку са вестима на страницама \'Моја почетна страница\' / \'Контролни панел\'.';
$string['enabletoolsmenus'] = 'Омогући меније \'Алати\'';
$string['enabletoolsmenusdesc'] = 'Препоручује се да ово оставите искључено, ако се менији не користе, због перформанси система.';
$string['enablezoom'] = 'Омогући зумирање';
$string['enablezoomdesc'] = 'Дозвољава корисницима да мењају приказ странице (између приказа преко целог екрана и приказа фиксне ширине).';
$string['enablezoomshowtext'] = 'Прикажи текст за \'Омогући зумирање\'';
$string['enablezoomshowtextdesc'] = 'Приказује текст поред дугмета.';
$string['events'] = 'Догађаји';
$string['expandable'] = 'Прошириво';
$string['fa6name'] = 'FontAwesome 6 Бесплатна верзија за графичке теме';
$string['faiv'] = 'FontAwesome Free v4 shims';
$string['faivdesc'] = 'Када користите FontAwesome 6 Бесплатну верзију (за графичке теме) за иконице додајте подршку за називе класа иконица верзије 4.';
$string['fav'] = 'FontAwesome 6 Бесплатна верзија';
$string['favdesc'] = 'Користите FontAwesome 6 Бесплатну верзију за иконице. Напомена: Молимо погледајте лиценцу у директоријуму фонтова теме.';
$string['favicon'] = 'Фавиконица';
$string['favicondesc'] = 'Поставите фавиконицу која ће се користити на вашем сајту користећи основно подешавање \'core_admin | favicon\' на страници \'Администрација сајта\' -> \'Изглед\' -> \'Логотипи\'.';
$string['favoff'] = 'Основна FontAwesome 6 Бесплатна верзија';
$string['flexibleblocksoverflow'] = 'Флексибилан број блокова';
$string['fontawesomesettingdesc'] = 'Формат сваког реда је \'text|url|title|langs|fontawesome classes|capability to check\'. Унесите само оно што вам је потребно. Ако вам нешто од наведног није потрено, али вам је потребна нешто друго, оставите то што је непотребно празно, али и даље користите знак за раздвајање \'|\'. На пример: \'text|url|||fontawesome classes\'. Да бисте пронашли FontAwesome (бесплатне) класе за иконицу коју желите да користите, идите на <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome (бесплатна верзија)</a> и потражите иконицу. Можете користити назив, као што је \'graduation-cap\' или комплетни списак \'fa-solid fa-graduation-cap\'. На пример:<pre>
Курсеви
-Сви курсеви|/course/
-Претрага курсева|/course/search.php
-###
-FAQ|https://example.org/faq
-Испитни сат|https://mysite.localhost|Exam Clock|en|clock
-Испитни сат|https://mysite.localhost|Clock arholiad|cy|clock
-Предавачи|https://mysite.localhost|Educators only|en|graduation-cap|moodle/course:manageactivities
</pre>';
$string['fontblockheadercolor'] = 'Боја фонта заглавља блокова';
$string['fontblockheadercolordesc'] = 'Подесите боју фонта заглавља у Moodle блоковима, користећи html хексадецимални кôд. Имајте на уму да ово утиче и на боју иконица.';
$string['fontblockheadersize'] = 'Величина фонта заглавља блокова';
$string['fontblockheadersizedesc'] = 'Подесите величину фонта који се користи у заглављу Moodle блокова. Изаберите вредност са списка.';
$string['fontblockheaderweight'] = 'Дебљина фонта заглавља блокова';
$string['fontblockheaderweightdesc'] = 'Подесите дебљину фонта који се користи у заглављу Moodle блокова. Изаберите вредност од 100 до 900 у зависности од изабраног фонта.';
$string['fontcolor'] = 'Боја главног фонта';
$string['fontcolordesc'] = 'Подесите боју фонта у теми, користећи html хексадецимални кôд.';
$string['fontdefault'] = 'Подразумевани фонтови';
$string['fontdesc'] = 'Можете да изаберете фонтове које желите да користите у оквиру теме.';
$string['fontheadercolor'] = 'Боја фонта заглавља';
$string['fontheadercolordesc'] = 'Подесите боју фонта заглавља у теми, користећи html хексадецимални кôд.';
$string['fontheadername'] = 'Фонт заглавља';
$string['fontheadernamedesc'] = 'Изаберите фонт који ће се користити у тексту и у заглављима блокова.';
$string['fontheaderweight'] = 'Дебљина фонта заглавља';
$string['fontheaderweightdesc'] = 'Дебљина фонта заглавља који се користе на сајту. Изаберите вредност до 100 до 900, зависно од изабраног фонта.';
$string['fontname'] = 'Главни фонт';
$string['fontnamedesc'] = 'Изаберите главни фонт за сајт.';
$string['fontsettings'] = 'Фонтови';
$string['fontsettingsheading'] = 'Измените фонтове који се користе у оквиру теме.';
$string['fontsize'] = 'Величина главног фонта';
$string['fontsizedesc'] = 'Изаберите подразумевану величину фонта (у процентима) која се користи на читавом сајту.';
$string['fontsubset'] = 'Подскуп Google фонтова';
$string['fontsubsetdesc'] = 'Изаберите који ће се други подскуп карактера, поред латиничног, примењивати на све фонтове. Латинични подскуп је стандардно већ укључен.';
$string['fonttitlecolor'] = 'Боја фонта наслова сајта /курса';
$string['fonttitlecolorcourse'] = 'Боја фонта наслова курса';
$string['fonttitlecolorcoursedesc'] = 'Подесите боју фонта наслова курса у теми, користећи html хексадецимални кôд.';
$string['fonttitlecolordesc'] = 'Подесите боју фонта наслова сајта и наслова курса у теми, користећи html хексадецимални кôд.';
$string['fonttitlename'] = 'Фонт наслова сајта / курса';
$string['fonttitlenamedesc'] = 'Изаберите фонт који ће се користити за наслов сајта и наслове курсева.';
$string['fonttitlesize'] = 'Величина фонта наслова сајта / курса';
$string['fonttitlesizedesc'] = 'Величина фонта наслова сајта и наслова курса који се користи на сајту. Изаберите вредност са списка.';
$string['fonttitleweight'] = 'Дебљина фонта наслова сајта / курса';
$string['fonttitleweightdesc'] = 'Подесите дебљину фонта који се користи за наслов сајта и наслове курсева. Изаберите вредност до 100 до 900, зависно од изабраног фонта.';
$string['fontweight'] = 'Дебљина главног фонта';
$string['fontweightdesc'] = 'Подесите дебљину фонта који се користи се на сајту. Изаберите вредност до 100 до 900, зависно од изабраног фонта.';
$string['footerbkcolor'] = 'Боја позадине подножја';
$string['footerbkcolordesc'] = 'Подесите боју позадине у подножју странице.';
$string['footerblocksplacement'] = 'Појављивање блокова подножја';
$string['footerblocksplacement1'] = 'На читавом сајту';
$string['footerblocksplacement2'] = 'Само почетна страница';
$string['footerblocksplacement3'] = 'Нигде';
$string['footerblocksplacementdesc'] = 'Ово подешавање контролише где ће се приказивати горњи блокови подножја. Подразумевана вредност је \'На читавом сајту\'.';
$string['footerbuilderdesc'] = 'Употребите алат у наставку како бисте подесили своје блокове у подножју странице. Једном дефинисани блокови ће бити распоређени како је овде подешено, када је уређивање искључено, а прозор шири од 575 пиксела. Увек ће у једном реду бити четири блока.';
$string['footerbuilderheading'] = 'Алат за креирање распореда блокова у подножју';
$string['footercontent'] = 'Секција подножја са садржајем';
$string['footercontentdesc'] = 'Додајте садржај у секцију подножја странице.';
$string['footerdesc'] = 'Додајте наслов за секцију подножја.';
$string['footerheader'] = 'Наслов секције подножја';
$string['footerlayoutrow'] = 'Алат за креирање изгледа подножја странице';
$string['footerlayoutrowdesc'] = 'Дизајнирајте распоред блокова за регион подножја странице са блоковима.';
$string['footerlinkcolor'] = 'Боја линка у блоковима подножја';
$string['footerlinkcolordesc'] = 'Боја линка у блоковима подножја странице.';
$string['footersettings'] = 'Подножје';
$string['footersettingsheading'] = 'Подесите садржај који треба да се појави у подножју странице.';
$string['footertextcolor'] = 'Боја текста подножја';
$string['footertextcolor2'] = 'Боја текста доњег подножја';
$string['footertextcolor2desc'] = 'Боја текста у доњем делу подножја странице.';
$string['footertextcolordesc'] = 'Подесите боју текста у подножју странице, користећи html хексадецимални кôд.';
$string['footnote'] = 'Фуснота';
$string['footnotedesc'] = 'Додаје текст у подножје.';
$string['forumbodybackgroundcolor'] = 'Позадина тела поста на форуму';
$string['forumbodybackgroundcolordesc'] = 'Боја позадине тела поста на форуму.';
$string['forumheaderbackgroundcolor'] = 'Позадина заглавља поста на форуму';
$string['forumheaderbackgroundcolordesc'] = 'Боја позадине заглавља поста на форуму';
$string['frnt-footer'] = 'Блокови у овом региону биће видљиви само администраторима.';
$string['frontpageblocksenabled'] = 'Омогући прилагођени регион са блоковима на насловној страници';
$string['frontpageblocksenableddesc'] = 'Можете да омогућите / онемогућите прилагођене регионе са блоковима на насловној страници. Након тога, можете да превлачите и спуштате блокове у регионе које сте креирали.';
$string['frontpageblocksettings'] = 'Промотивни блокови';
$string['frontpagecoursesettings'] = 'Списак курсева на насловној страници';
$string['frontpagedesc'] = 'Конфигуришите начин на који се приказују блокови са курсевима на насловној страници.';
$string['frontpagemarketenabled'] = 'Омогући промотивне блокове';
$string['frontpagemarketenableddesc'] = 'Подесите промотивне блокове на насловној страници.';
$string['frontpagemarketoption'] = 'Изаберите стил за промотивне блокове';
$string['frontpagemarketoptiondesc'] = 'Можете да примените различите стилове на промотивне блокове. Напомена: BCU стил је дизајниран тако да ради са сликама на врху блока.';
$string['frontpagenumbertiles'] = 'Број плочица курсева по једном реду';
$string['frontpagenumbertilesdesc'] = 'Број плочица курсева који ће бити приказан у једном реду на списку курсева на насловној страници.';
$string['frontpagerenderer'] = 'Блокови курсева на насловној страници';
$string['frontpagerendererdefaultimage'] = 'Подразумевана слика курса';
$string['frontpagerendererdefaultimagedesc'] = 'Подразумевана слика курса која ће се користити када не постоји слика курса (примењиво само за опцију \'Плочице са прекривачем\').';
$string['frontpagerendererdesc'] = 'Контролише начин на који се приказују блокови курсева на насловној страници.';
$string['frontpagerendereroption1'] = 'Плочице';
$string['frontpagerendereroption2'] = 'Плочице са прекривачем';
$string['frontpagerendereroption3'] = 'Moodle стандардно';
$string['frontpagerendereroption4'] = 'Ковентри плочице';
$string['frontpagesettingsheading'] = 'Приказ насловне странице';
$string['frontpageslidersettings'] = 'Слајд-шоу на насловној страници';
$string['frontpagetiles1'] = 'Једна плочице';
$string['frontpagetiles2'] = 'Две плочице';
$string['frontpagetiles3'] = 'Три плочице';
$string['frontpagetiles4'] = 'Четири плочице';
$string['frontpagetiles6'] = 'Шест плочица';
$string['frontpageuserblocksenabled'] = 'Омогући бочни регион блокова на насловној страници за кориснике';
$string['frontpageuserblocksenableddesc'] = 'Можете да омогућите/онемогућите бочни регион блокова на насловној страници за кориснике. Напомена: под \'Корисници\' овде се мисли на госте и кориснике чији је идентитет потврђен. Администратори ће увек видети регион.';
$string['fullscreen'] = 'Приказ преко целог екрана';
$string['fullscreenwidth'] = 'Ширина приказа преко целог екрана';
$string['fullscreenwidthdesc'] = 'Подесите максималну ширину теме када је у режиму приказа преко целог екрана / зумирања.';
$string['future'] = 'Будући';
$string['gdprbutton'] = 'Дугме за резиме о задржавању података';
$string['gdprbuttondesc'] = 'Прикажите дугме за резиме о задржавања података у подножју.';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Можете да подесите више кôдова за Google Analytics и повежете их са пољима корисничких профила.';
$string['googleanalyticssettingsheading'] = 'Google Analytics подешавања за ваш сајт';
$string['googlefonts'] = 'Google фонтови';
$string['googlefontsdesc'] = 'Укључите <a href="{$a}" target="_blank">Google Фонтове</a> тако што ћете изабрати њихове називе, осим \'Подразумеваног фонта\'.  Када су Google фонтови \'искључени\', имате прилику да их сами обезбедите путем модификација CSS-а, односно теме или тако што ћете их инсталирате на уређајима корисника.  Када су Google фонтови \'укључени\' изаберите потребан подскуп фонтова (латиница је увек укључена) и унесите праву дебљину фонта или се фонт неће приказати.  <b>НАПОМЕНА: Тема Adaptable је лиценцирана под GPLv3 лиценцом и може садржати грешке. Проверите сами да се Google фонтови не користе када су искључени!</b>';
$string['headerbgimage'] = 'Позадинска слика';
$string['headerbgimagedesc'] = 'Подесите позадинску слику у заглављу. Минимална величина је 1600 x 180 пиксела (препоручује се 1900 x 180 пиксела). Слика покрива читаво заглавље. Можете да додате боју у \'Боја позадине горњег заглавља\' или да користите опцију <i>transparent</i> како бисте приказали позадинску слику. У том случају, како би текст исправно био приказан преко слике, модификујте његову боју.';
$string['headerbgimagetextcolour'] = 'Боја текста на позадинској слици';
$string['headerbgimagetextcolourdesc'] = 'Ако имате слику у позадини, користите ово подешавање како бисте подесили боју текста који се налази на њој.';
$string['headerbkcolor'] = 'Боја позадине горњег заглавља';
$string['headerbkcolor2'] = 'Боја позадине доњег заглавља';
$string['headerbkcolor2desc'] = 'Подесите боју позадине доњег заглавља. Имајте на уму да ово такође поставља боју за позадину у стилу Заглавља 2.';
$string['headerbkcolordesc'] = 'Подесите боју позадине горњег заглавља';
$string['headerdesc'] = 'Поставите свој лого, подесите образац за пријаву у заглављу, као и наслове у заглављу.<br />
Величину фонта и стилове за наслове можете да подесите на страници за подешавање \'<a href="./../admin/settings.php?section=theme_adaptable_font">фонтова</a>\'.';
$string['headernavbarcustommenucoreempty'] = 'Подешавање \'<small>{$a}</small>\' је празно.';
$string['headernavbarcustommenucoreheading'] = 'Основна подешавања';
$string['headernavbarcustommenucoreheadingdesc'] = 'Дуплирано ради погодности.';
$string['headernavbarcustommenucorenotempty'] = 'Подешавање \'<small>{$a}</small>\' је:<br><br>';
$string['headernavbarcustommenuheading'] = 'Прилагођени мени';
$string['headernavbarcustommenuheadingdesc'] = 'Прилагођени мени подешен до стране основног custommenuitems\' подешавања, дуплиран у наставку.';
$string['headernavbarhelpheading'] = 'Линкови за помоћ и опције';
$string['headernavbarhelpheadingdesc'] = 'Опције за линкове менија помоћи.';
$string['headernavbarmycoursesheading'] = 'Мени \'Моји курсеви\'';
$string['headernavbarmycoursesheadingdesc'] = 'Све опције за опцију менија \'Моји курсеви\' (\'Моји сајтови\') која приказује списак курсева тренутног корисника.';
$string['headernavbarthiscourseheading'] = 'Мени овог курса';
$string['headernavbarthiscourseheadingdesc'] = 'У овом менију полазник може директно да приступи свим активностима на курсу и списку учесника и њиховим оценама.';
$string['headersearchandsocial'] = 'Претрага и иконице друштвених мрежа у заглављу';
$string['headersearchandsocialdesc'] = 'Подесите позицију оквира за претрагу и иконица друштвених мрежа у заглављу за стил заглавља један.<br />
Иконице друштвених мрежа можете подесити на страници за подешавање <a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Заглавље - друштвене мреже</a>.';
$string['headersearchandsocialnone'] = 'Ништа';
$string['headersearchandsocialsearchheader'] = 'Оквир за претрагу у заглављу';
$string['headersearchandsocialsearchmobilenav'] = 'Оквир за претрагу у заглављу и навигациона трака за мобилне уређаје';
$string['headersearchandsocialsearchnavbar'] = 'Оквир за претрагу у навигационој траци';
$string['headersearchandsocialsearchnavbarsocialheader'] = 'Оквир за претрагу у навигационој траци, иконице друштвених мрежа у заглављу';
$string['headersearchandsocialsocialheader'] = 'Иконице друштвених мрежа у заглављу';
$string['headersettings'] = 'Заглавље';
$string['headersettingsheading'] = 'Прилагодите заглавље ове теме.';
$string['headerstyle'] = 'Стил заглавља';
$string['headerstyle1'] = 'Заглавље један (оригинално заглавље у три реда)';
$string['headerstyle2'] = 'Заглавље два (заглавље у два реда)';
$string['headerstyledesc'] = 'Изаберите стил заглавља. Заглавље један се односи на оригинално Adaptable заглавље у три реда. Заглавље два је минимално заглавље у два реда са пољем за претрагу.';
$string['headerstyleheading'] = 'Подешавања стила заглавља';
$string['headerstyleheadingdesc'] = 'Adaptable подржава два стила заглавља, оригинално заглавље, у три реда и новије, поједностављено заглавље у два реда.<br/>Имајте на уму да ако пређете на новије заглавље у два реда <strong>НЕЋЕТЕ</strong> моћи да:<br /><ol><li>прикажите у заглављу иконице друштвених мрежа.</li><li>прикажите лого сајта на мобилним уређајима.</li></ol>';
$string['headertextcolor'] = 'Боја текста и линка горњег заглавља';
$string['headertextcolor2'] = 'Боја текста и линка доњег заглавља';
$string['headertextcolor2desc'] = 'Подесите боју текста и линка доњег заглавља';
$string['headertextcolordesc'] = 'Подесите боју текста и линка горњег заглавља';
$string['help'] = 'Помоћ';
$string['helplinkscount'] = 'Број линкова за помоћ';
$string['helplinkscountdesc'] = 'Подесите број линкова за помоћ које желите да додате у главну навигациону траку.';
$string['helplinktitle'] = 'Наслов линка за помоћ \'{$a->number}\'';
$string['helplinktitledesc'] = 'Наслов линк за помоћ \'{$a->number}\' у навигационој траци.  Ако је поље празно користиће се подразумевани наслов \'Помоћ {$a->number}\'.';
$string['helpprofilefield'] = 'Прилагођено поље профила (опционо) линка за помоћ \'{$a->number}\'';
$string['helpprofilefielddesc'] = 'Додајте правило за приступ линку за помоћ \'{$a->number}\' користећи прилагођено поље профила нпр: usertype=student';
$string['helptarget'] = 'Прозор у којем се приказује помоћ';
$string['helptargetdesc'] = 'Да ли желите да се линк за помоћ отвори у новом прозору?';
$string['helptitle'] = 'Помоћ {$a->number}';
$string['hiddencourses'] = 'Сакривени курсеви';
$string['hiddenfromview'] = 'Сaкривено од приказа';
$string['hide'] = 'Сакриј';
$string['hidefootersocial'] = 'Прикажи иконице друштвених мрежа';
$string['hidefootersocialdesc'] = 'Прикажите иконице друштвених мрежа у подножју испод блокова.';
$string['hideinforum'] = 'Сакриј \'Помоћ\' и мени \'Алати\' у форумима';
$string['hideinforumdesc'] = 'Када се користи приказ фиксне ширине и све опције менија, поље за претрагу форума може склизнути у ред испод. Укључивање ове опције ће сакрити \'Помоћ\' и мени \'Алати\' у форумима, што ће омогућити да страница форума буду исправно приказана.';
$string['home'] = 'Почетна страница';
$string['homebk'] = 'Позадинска слика насловне странице';
$string['homebkdesc'] = 'Поставите слику која ће бити позадинска слика на почетној страници.';
$string['hvpcustomcss'] = 'H5P прилагођени CSS';
$string['hvpcustomcssdesc'] = 'Прилагођени CSS за H5P модул.';
$string['infobox'] = 'Инфо-блок насловне странице';
$string['infobox2'] = 'Секундарни инфо-блок насловне странице';
$string['infobox2desc'] = 'Секундарни инфо-блок насловне странице. Молимо, погледајте одељак \'Readme\' на картици за подешавања \'Информације\' за додатне информације.<br><strong>Напомена: </strong><i>Овај елемент се користи само за компатибилност са графичком темом BCU и биће уклоњен у наредним верзијама.</i>';
$string['infoboxdesc'] = 'Инфо-блок насловне странице HTML. Молимо, погледајте одељак \'Readme\' на картици за подешавања \'Информације\' за додатне информације.<br><strong>Напомена: </strong><i>Овај елемент се користи само за компатибилност са графичком темом BCU и биће уклоњен у наредним верзијама.</i>';
$string['infoboxfullscreen'] = 'Инфо-блок преко целог екрана';
$string['infoboxfullscreendesc'] = 'Ако укључите ову опцију садржај инфо-блока биће приказан читавом ширином екрана.';
$string['infoiconcolor'] = 'Боја иконице за помоћ';
$string['infoiconcolordesc'] = 'Подесите боју иконице за информације/помоћ коју користе описи алата.';
$string['informationblocksbuilderdesc'] = 'Употребите алат у наставку како бисте подесили своје информационе блокове. Једном дефинисани блокови ће бити распоређени како је овде подешено, када је уређивање искључено.';
$string['informationblocksbuilderheading'] = 'Алат за креирање распореда информационих блокова';
$string['informationblocksenabled'] = 'Омогућите информационе блокове';
$string['informationblocksenableddesc'] = 'Подесите информационе блокове на насловној страници.';
$string['informationblocksettings'] = 'Информациони блокови';
$string['informationblockslayoutrow'] = 'Ред са информационим блоковима';
$string['informationblockslayoutrowdesc'] = 'Додајте/подесите изглед овог ред са информационим блоковима на насловној страници.';
$string['informationblocksvisible'] = 'Прикажите информационе блокове када';
$string['informationblocksvisibledesc'] = 'Прикажите информационе блокове када су корисници \'Одјављени\', \'Пријављени\' или \'Пријављени или одјављени\'.';
$string['informationblocksvisibleloggedin'] = 'Пријављени';
$string['informationblocksvisibleloggedinout'] = 'Пријављени или одјављени';
$string['informationblocksvisibleloggedout'] = 'Одјављени';
$string['informationsettingsdesc'] = 'Постоји алат за креирање распореда блокова који вам омогућава да одлучите колико блокова вам је потребно и тако дефинишете изглед странице. <br>За додатне информације молимо погледајте одељак \'Readme\' (Прочитај ме) на картици подешавања \'Информације\'.';
$string['informationsettingsheading'] = 'Прилагодите регион са информационим блоковима који се појављује на насловној страници.';
$string['inprogress'] = 'У току';
$string['inputbuttonfocuscolour'] = 'Боја дугмета за улазне податке приликом фокусирања';
$string['inputbuttonfocuscolourdesc'] = 'Боја коју дугме за улазне податке користи када се  нађе у фокусу';
$string['inputbuttonfocuscolouropacity'] = 'Непрозирност боје дугмета за улазне податке приликом фокусирања';
$string['inputbuttonfocuscolouropacitydesc'] = 'Непрозирност које дугме за улазне податке користи када се нађе у фокусу';
$string['introboxbackgroundcolor'] = 'Боја позадине уводног блока';
$string['introboxbackgroundcolordesc'] = 'Боја позадине за уводни блок (истиче описе активности) који се користи у форумима и другим активностима';
$string['invalidcategorygeneratedscss'] = 'Неисправна категорија прилагођенo генерисаног SCSS: \'{$a->scss}\'.';
$string['invalidcategoryscss'] = 'Неисправна категорија прилагођенoг SCSS за категорију \'{$a->topcatname}\' са ID ознаком \'{$a->topcatid}\': \'{$a->scss}\'.';
$string['jssection'] = 'Javascript секција';
$string['jssectiondesc'] = 'Додајте javascript кôд на сајт.';
$string['jssectionrestricted'] = 'Секција условног javascripta';
$string['jssectionrestricteddashboardonly'] = 'Укључи javascript само на страници \'Контролни панел\'';
$string['jssectionrestricteddashboardonlydesc'] = 'Прикажите javascript само на страницу \'Контролни панел\'. У супротном, биће приказано на целом сајту.';
$string['jssectionrestricteddesc'] = 'ЗАСТАРЕЛО, уместо тога користите \'customjsrestricted\' .';
$string['jssectionrestrictedprofilefield'] = 'Вредност прилагођеног поља профила за приказ Javascript секције';
$string['jssectionrestrictedprofilefielddesc'] = 'Прикажи javascript изнад САМО када корисник одговара овој вредности прилагођеног поља профила, нпр: faculty=fbl.';
$string['jumpto'] = 'Иди на...';
$string['landscape'] = 'Пејзажна оријентација';
$string['layoutaddcontent'] = 'Задовољни сте са својим распоредом блокова? Сада додајте садржај у ваше блокове:';
$string['layoutaddcontentdesc1'] = 'Конфигурисали сте';
$string['layoutaddcontentdesc2'] = 'промотивне блокове. Ако сте задовољни са овим распоредом додајте у наставку странице садржај у блокове.<br>Ако нисте задовољни употребите горњи алат за креирање распореда блокова како бисте направили промене.';
$string['layoutcheck'] = 'Проверите свој распоред блокова';
$string['layoutcheckdesc'] = 'Употребите алат у наставку како бисте проверили број блокова које користите и видели како изгледа ваш нови распоред блокова.';
$string['layoutcount1'] = 'Можете да подесите највише';
$string['layoutcount2'] = 'регион/a са блоковима. Тренутно користите:';
$string['layoutdesc'] = 'Подесите подразумевани распоред блокова који корисници виде.';
$string['layoutsettings'] = 'Изглед сајта';
$string['layoutsettingsheading'] = 'Контролни аспекти изгледа сајта';
$string['leftblocks'] = 'Лева страна';
$string['linkcolor'] = 'Боја линка';
$string['linkcolordesc'] = 'Подесите боју линкова у теми, користећи html хексадецимални кôд.';
$string['linkhover'] = 'Лебдећа боја линка';
$string['linkhoverdesc'] = 'Подесите боју линкова у теми (када се мишем пређе преко њих), користећи html хексадецимални кôд.';
$string['linksmenu'] = 'Мени линкова';
$string['loadingcolor'] = 'Боја учитавања';
$string['loadingcolordesc'] = 'Боја траке учитавања на врху странице.';
$string['loginbgimage'] = 'Позадинска слика';
$string['loginbgimagedesc'] = 'Додајте позадинску слику преко целе странице';
$string['loginbgopacity'] = 'Непрозирност заглавља странице за пријаву, навигационе траке, оквира за пријаву и позадине подножја када постоји позадинска слика';
$string['loginbgopacitydesc'] = 'Непрозирност позадине странице за пријаву за заглавље, навигациону траку, оквир за пријаву и подножје када постоји позадинска слика.';
$string['loginbgstyle'] = 'Стил позадине странице за пријаву';
$string['loginbgstyledesc'] = 'Изаберите стил за постављену слику.';
$string['logindesc'] = 'Прилагодите страницу за пријаву додавањем позадинске слике и текста изнад и испод поља за пријаву.';
$string['loginfooter'] = 'Подножје странице за пријаву';
$string['loginfooterdesc'] = 'Прикажи подножје странице за пријаву.';
$string['loginheader'] = 'Заглавље странице за пријаву';
$string['loginheaderdesc'] = 'Прикажи заглавље странице за пријаву.';
$string['loginplaceholder'] = 'Корисничко име';
$string['loginsettings'] = 'Страница за пријаву';
$string['loginsettingsheading'] = 'Прилагодите страницу за пријаву.';
$string['logintextboxbottom'] = 'Текстуални оквир на дну странице за пријаву';
$string['logintextboxbottomdesc'] = 'Додајте прилагођени текст испод поља за пријаву на сајт.';
$string['logintextboxtop'] = 'Текстуални оквир на врху странице за пријаву';
$string['logintextboxtopdesc'] = 'Додајте прилагођени текст изнад поља за пријаву на сајт.';
$string['logintextbutton'] = 'Пријави се';
$string['logintextbuttonwhenoidc'] = 'Пријава гостију/Ручна пријава';
$string['logintextmanualbutton'] = 'Пријава са тестним налогом';
$string['logo'] = 'Лого';
$string['logoalt'] = 'Опис логотипа';
$string['logoaltdesc'] = 'Наведите опис свог логотипа због приступачности. Вишејезична компатибилност.';
$string['logodesc'] = 'Поставите лого који ће се користити на вашем сајту. Препоручена величина је 200 x 80 пиксела.';
$string['maincolor'] = 'Главна боја';
$string['maincolordesc'] = 'Главна боја за блокове и подножје странице.';
$string['maincoursepage'] = 'Главна страница курса';
$string['market'] = 'Промотивни блок';
$string['marketblockbordercolor'] = 'Боја бордуре промотивног блока';
$string['marketblockbordercolordesc'] = 'Подесите боју бордуре промотивног блока.';
$string['marketblocksbackgroundcolor'] = 'Боја позадине региона са промотивним блоковима';
$string['marketblocksbackgroundcolordesc'] = 'Подесите боју позадине региона са промотивним блоковима.';
$string['marketdesc'] = 'Додајте HTML за промотивни блок. Молимо, погледајте одељак \'Readme\' на картици за подешавања \'Информације\' за додатне информације.';
$string['marketingbuilderdesc'] = 'Употребите алат у наставку како бисте подесили своје промотивне блокове. Једном када овде дефинишите број блокова у доњем делу странице појавиће се подешавања за сваки од њих.';
$string['marketingbuilderheading'] = 'Алат за распоред промотивних блокова';
$string['marketingdeprecated'] = 'Промотивни блокови су застарели, пређите на коришћење региона са Информационим блоковима.';
$string['marketingdesc'] = 'Постоје два инфо-блока пуне ширине са различитим стиловима које можете да користите.<br>Поред тога постоји и алат за креирање распореда блокова који вам даје могућност да одлучите колико блокова вам је потребно и да дефинишете свој распоред блокова.<br>Молимо, погледајте одељак \'Readme\' на картици за подешавања \'Информације\' за додатне информације.';
$string['marketingsettings'] = 'Промотивни блокови';
$string['marketingsettingsheading'] = 'Прилагодите промотивне блокове који се појављују на насловној страници.';
$string['marketingvisible'] = 'Прикажите промотивне блокове када';
$string['marketingvisibledesc'] = 'Прикажите промотивне блокове када сте \'Одјављени\', \'Пријављени\' или \'Пријављени или одјављени\'.';
$string['marketingvisibleloggedin'] = 'Logged in';
$string['marketingvisibleloggedinout'] = 'Пријављени или одјављени';
$string['marketingvisibleloggedout'] = 'Одјављени';
$string['marketlayoutrow'] = 'Ред промотивних блокова';
$string['marketlayoutrowdesc'] = 'Додајте / подесите изглед реда са промотивним блоковима на насловној страници';
$string['menubkcolor'] = 'Боја позадине главног менија';
$string['menubkcolordesc'] = 'Подесите боју позадине главног менија';
$string['menubkhovercolor'] = 'Лебдећа боја позадине главног менија';
$string['menubkhovercolordesc'] = 'Подесите лебдећу боју позадине главног менија';
$string['menubordercolor'] = 'Боја доње бордуре главног менија';
$string['menubordercolordesc'] = 'Подесите боју доње бордуре главног менија.';
$string['menufontcolor'] = 'Боја фонта главног менија';
$string['menufontcolordesc'] = 'Подесите боју фонта главног менија.';
$string['menufonthovercolor'] = 'Лебдећа боја главног менија';
$string['menufonthovercolordesc'] = 'Подесите лебдећу боју главног менија';
$string['menufontpadding'] = 'Размак између ставки навигације';
$string['menufontpaddingdesc'] = 'Подесите размак између ставки у главној навигационој траци.';
$string['menufontsize'] = 'Величина фонта за навигациону траку';
$string['menufontsizedesc'] = 'Подесите величину фонта који се користи у главној навигационој траци.';
$string['menuoverrideprofilefield'] = 'Назив прилагођеног поља профила';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'Назив прилагођеног поља профила (у формату ”списка”) које се користе за корисничке измене.';
$string['menusdesc'] = '';
$string['menusession'] = 'Сачувај детаље о приступу у сесији корисника';
$string['menusessiondesc'] = 'Због перформанси система сугерише се да укључите ову опцију. Можда ћете желети да је онемогућити приликом тестирања.';
$string['menusessionttl'] = 'Време чувања правила приступа у сесији корисника';
$string['menusessionttldesc'] = 'Временски период (број минута) након ког се правила за приступ менију освежавају у сесији корисника.';
$string['menusettings'] = 'Менији заглавља';
$string['menusettingsheading'] = 'Прилагодите меније у горњем заглављу ове теме.';
$string['menusheading'] = 'Конфигуришите навигацију за линкове менија у горњем заглављу';
$string['menusheadingvisibility'] = 'Општа подешавања за видљивост менија на врху странице';
$string['menusheadingvisibilitydesc'] = 'Следећа подешавања омогућавају да контролишете где се појављују менији и опционо омогућавају корисницима да прилагоде своја подешавања';
$string['menuslinkicon'] = 'Иконица линкова у менију';
$string['menuslinkicondesc'] = 'Изаберите прилагођену Font Awesome иконицу';
$string['menuslinkright'] = 'Прикажи мени линкова горе десно';
$string['menuslinkrightdesc'] = 'Ако је означено, мени са линковима се приказује у горњем десном углу одмах поред менија са порукама.';
$string['menustitledesc'] = 'Менији \'Алати\' (у навигационој траци) и Горњи менији (у горњем заглављу) се могу ограничити на основу прилагођених поља у профилу корисника (опционо). Да бисте додали ограничење унесите назив поља профила и очекивану вредност. Структура менија следи уобичајени Moodle формат:
<br/>
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Дозволи измене од стране корисника';
$string['menuuseroverridedesc'] = 'Ово подешавање може да се користи како би се, путем прилагођеног поља профила, корисницима дала контрола над појављивањем менија. За коришћење ове опције биће потребно да креирате прилагођено поље профила у формату ”списка” са вредностима поређаним одговарајућим редоследом:
<br/>
<pre>1. На читавом сајту (прва вредност на списку биће за видљивост менија на читавом сајту)
2. Само почетне странице (друга вредност на списку ограничиће видљивост менија само на сајту / почетно страници)
3. Сакривено (трећа вредност на списку ће сакрити меније у потпуности)</pre>
НЕМОЈТЕ користити опцију ”Онемогући меније на страницама курса” заједно са подешавањима поља профила. Уместо тога, када подешавате ваш списак поља профила, користите као подразумевану вредност ”Само почетне странице”.

Напомена: да би ова промена ступила на снагу, корисници ће морати да се одјаве са сајта и поново пријаве. Било би добро да у прилагођено поље профила додате напомену која ово објашњава.';
$string['messagepopupbackground'] = 'Боја позадине искачућег прозора са порукама';
$string['messagepopupbackgrounddesc'] = 'Подесите боју позадине заглавља искачућег прозора са порукама.';
$string['messagepopupcolor'] = 'Боја текста искачућег прозора са порукама';
$string['messagepopupcolordesc'] = 'Подесите боју текста заглавља искачућег прозора са порукама.';
$string['messagingbackgroundcolor'] = 'Боја позадине главног прозора приватне поруке';
$string['messagingbackgroundcolordesc'] = 'Подесите боју позадине главног прозора приватних порука.';
$string['mobilemenubkcolor'] = 'Боја позадине менија на мобилним уређајима';
$string['mobilemenubkcolordesc'] = 'Подесите боју позадине главног менија на мобилним уређајима (скупљено).';
$string['mobileprimarynav'] = 'Примарна навигација на мобилним уређајима';
$string['mobileprimarynavdesc'] = 'Омогућите или онемогућите. Напомена: Ово је мени који контролише иконица хамбургера';
$string['moodledocs'] = 'Линк ка Moodle документацији';
$string['moodledocsdesc'] = 'Прикажите линк ка Moodle документацији у подножју странице.';
$string['more'] = 'Више';
$string['myblogs'] = 'Моји блогови';
$string['mycoursesmenulimit'] = 'Ограничење менија \'Моји курсеви\'';
$string['mycoursesmenulimitdesc'] = 'Подесите максималан број курсева који се појављују у падајућем менију "Моји курсеви". 0 ће приказати све курсеве.';
$string['mysites'] = 'Моји курсеви';
$string['mysitesdisabled'] = 'Онемогући';
$string['mysitesexclude'] = 'Омогући искључивање сакривених курсева';
$string['mysitesinclude'] = 'Омогући укључивање сакривених курсева';
$string['mysitesmaxlength'] = 'Максимална дужина назива мојих курсева';
$string['mysitesmaxlengthdesc'] = 'Подесите максималну дужину назива курсева у падајућем менију ”Моји курсеви”.';
$string['mysitesmenudisplay'] = 'Приказ менија \'Моји курсеви\'';
$string['mysitesmenudisplaydesc'] = 'Изаберите који текст желите да прикажете за ставку менија и приликом преласка мишем преко ставке.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Прикажи пуни назив курса и пуни наслов приликом преласка миша.';
$string['mysitesmenudisplayfullnamenohover'] = 'Прикажи пуни назив курса и никакав текст приликом преласка миша.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Прикажи кратак кôд и пуни назив курса приликом преласка миша.';
$string['mysitesmenudisplayshortcodenohover'] = 'Прикажи кратак кôд без текста приликом преласка миша.';
$string['mysitessortoverride'] = 'Омогући прилагођено сортирање у менију \'Моји курсеви\'';
$string['mysitessortoverridedesc'] = 'Употребите прилагођена поља профила или генеричке стрингове (година итд) како бисте скупили протекле курсеве у подменију.';
$string['mysitessortoverridefield'] = 'Прилагођена поља профила или стрингови за мени ”Моји курсеви”';
$string['mysitessortoverridefielddesc'] = 'Списак поља профила или стрингова, раздвојених зарезима, за проверу у кратким кôдовим курсева.';
$string['mysitessortoverridelast'] = 'Време последњег приступа или време почетка уписа на курс ако се курсу никада није приступило';
$string['mysitessortoverridemyoverview'] = 'Преузмите списак са \'Преглед мојих курсева\'';
$string['mysitessortoverrideoff'] = 'Прикажи све уписане курсеве као обичан списак';
$string['mysitessortoverrideprofilefields'] = 'Прикажи курсеве пронађене у пољима профила у првом списку, остале у подменију';
$string['mysitessortoverrideprofilefieldscohort'] = 'Прикажи курсеве пронађене у пољима профила и кохортама у првом списку, остале у подменију';
$string['mysitessortoverridestrings'] = 'Прикажи уписане курсеве који садрже стрингове у првом списку, остале у подменију';
$string['navbarcachetime'] = 'Време кеширања навигационе траке';
$string['navbarcachetimedesc'] = 'Број минута током којих се кешира навигациона трака.';
$string['navbardesc'] = 'Омогућава вам да контролишете све елементе који се појављују у навигационој траци.';
$string['navbardisplayicons'] = 'Прикажи иконице';
$string['navbardisplayiconsdesc'] = 'Прикажите иконице поред наслова главног менија';
$string['navbardisplaymenuarrow'] = 'Прикажи стрелицу менија';
$string['navbardisplaymenuarrowdesc'] = 'Прикажите стрелицу менија (окренуту надоле) за наслов менија.';
$string['navbardisplaytitles'] = 'Прикажи наслове';
$string['navbardisplaytitlesdesc'] = 'Прикажите наслов менија. Напомене: игнорише се када опција \'navbardisplayicons\' није подешена, а такође се игнорише и када опција \'custommenutitle\' није подешена за прилагођени мени.';
$string['navbardropdownborderradius'] = 'Полупречник бордуре падајућег менија';
$string['navbardropdownborderradiusdesc'] = 'Контролише полупречник бордуре падајућих менија (нпр. заобљени углови)';
$string['navbardropdownhovercolor'] = 'Лебдећа боја позадине падајућег менија';
$string['navbardropdownhovercolordesc'] = 'Боја позадине падајућег менија када пређете мишем преко ставки менија.';
$string['navbardropdowntextcolor'] = 'Боја текста падајућег менија';
$string['navbardropdowntextcolordesc'] = 'Боја текста ставке падајућег менија.';
$string['navbardropdowntexthovercolor'] = 'Лебдећа боја текста у падајућем менију';
$string['navbardropdowntexthovercolordesc'] = 'Боја текста падајућег менија када пређете мишем преко ставки менија.';
$string['navbardropdowntransitiontime'] = 'Време транзиције навигационе траке';
$string['navbardropdowntransitiontimedesc'] = 'Време транзиционог ефекта навигационе траке, у секундама. Обезбеђује анимациони ефекат постепеног појављивања када се мишем пређе преко менија који има подменије.';
$string['navbarlinksettingsdesc'] = 'Омогућава вам да контролишете линкове које се појављују на траци за навигацију.';
$string['navbarlinksettingsheading'] = 'Прилагодите линкове на траци за навигацију';
$string['navbarlinkssettings'] = 'Линкови навигационе траке';
$string['navbarmycourses'] = 'Мени \'Моји курсеви\' у навигационој траци';
$string['navbarsettings'] = 'Навигациона трака';
$string['navbarsettingsheading'] = 'Прилагодите навигациону траку';
$string['navbarstyles'] = 'Стилови навигационе траке';
$string['navbarstylesdesc'] = 'Омогућава вам да контролишете стилове елемената који се појављују на траци за навигацију.';
$string['navbarstylesheading'] = 'Прилагодите стилове навигационе траке';
$string['newmenu'] = 'Падајући мени на врху странице';
$string['newmenudesc'] = 'Конфигуришите линкови који ће бити приказани у менију горњег заглавља.';
$string['newmenufield'] = 'Назив прилагођеног поља профила=Вредност (опционо)';
$string['newmenufielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: usertype=student.';
$string['newmenuheading'] = 'Мени на врху странице';
$string['newmenurequirelogin'] = 'Захтева пријаву на систем';
$string['newmenurequirelogindesc'] = 'Ако је подешавање омогућено, овај мени ће видети само пријављени корисници.';
$string['newmenutitle'] = 'Наслов менија на врху странице';
$string['newmenutitledefault'] = 'Мени';
$string['newmenutitledesc'] = 'Наслов падајућег менија који се појављује у заглављу вашег сајта.';
$string['newstickercount'] = 'Број секција покретне траке са вестима';
$string['newstickercountdesc'] = 'Дефинишите више секција покретне траке са вестима, заједно са правилима приступа како бисте таргетирали различиту публику.';
$string['newstickersettings'] = 'Покретна трака са вестима';
$string['nextactivity'] = 'Следећа активност';
$string['nextsection'] = 'Следећа секција';
$string['noenrolments'] = 'Није пронађен ниједан упис на курс.';
$string['none'] = 'Без сенке';
$string['normal'] = 'Фиксна ширина';
$string['nostyle'] = 'Без стила';
$string['notbadgebackgroundcolour'] = 'Боја позадине обавештења о беџевима';
$string['notbadgebackgroundcolourdesc'] = 'Подесите боју позадине за обавештења о беџевима / облачић у заглављу (приказује број непрочитаних обавештења)';
$string['notbadgecolour'] = 'Боја обавештења о беџевима';
$string['notbadgecolourdesc'] = 'Подесите боју за обавештења о беџевима / облачић у заглављу (приказује број непрочитаних обавештења)';
$string['onetopicactivetabbackgroundcolor'] = 'Боја позадине активне картице';
$string['onetopicactivetabbackgroundcolordesc'] = 'Боја позадине активне картице на курсу у формату једнотематских картица';
$string['onetopicactivetabtextcolor'] = 'Боја текста активне картице';
$string['onetopicactivetabtextcolordesc'] = 'Боја текста активне картице на курсу у формату једнотематских картица';
$string['onetopicdesc'] = 'Прилагодите изглед \'<a href="{$a}" target="_blank">Курса у формату једнотематских картица</a>\' (ако се користи на вашем сајту).';
$string['onetopicheading'] = 'Формат једнотематских картица';
$string['originaltemplatepreview'] = 'Преглед оригиналне / замењене датотеке теме';
$string['originaltemplatesource'] = 'Изворни кôд оригиналне / замењене датотеке теме';
$string['orphanedblock'] = '<em>НАПУШТЕНИ БЛОК - Оригинално се приказује у: <strong>{$a}</strong></em>';
$string['overriddentemplate'] = 'Замењени шаблон: {$a}';
$string['overriddentemplatedesc'] = 'Ако је подешено, овде унет текст ће се користити као шаблон \'{$a}\'. Да би се осигурало да преглед функционише, мора постојати стандардни пример контекста у JSON формату.';
$string['overriddentemplatenopreview'] = 'Нема прегледа јер недостаје JSON пример';
$string['overriddentemplatepreview'] = 'Преглед измењених подешавања';
$string['overridetemplate'] = 'Замени шаблон: {$a}';
$string['pageheaderalternative'] = 'Алтернатива';
$string['pageheaderheight'] = 'Висина заглавља странице';
$string['pageheaderheightdesc'] = 'Подесите висину региона главног заглавља (који садржи лого и наслове).';
$string['pageheaderlayout'] = 'Заглавље један, изглед заглавља странице';
$string['pageheaderlayoutdesc'] = 'Изглед заглавља странице за стил заглавља један';
$string['pageheaderlayouttwo'] = 'Заглавље два, изглед заглавља странице';
$string['pageheaderlayouttwodesc'] = 'Изглед заглавља странице за стил заглавља два';
$string['pageheadernosearch'] = 'Без оквира за претрагу';
$string['pageheaderoriginal'] = 'Оригинал';
$string['pageloadingprogress'] = 'Напредак учитавања странице';
$string['pageloadingprogressdesc'] = 'Прикажите напредак при учитавању странице.';
$string['pageloadingprogresstheme'] = 'Тема за учитавање странице';
$string['pageloadingprogressthemebarbershop'] = 'Берберница';
$string['pageloadingprogressthemebigcounter'] = 'Велики бројач';
$string['pageloadingprogressthemebounce'] = 'Лоптица скочица';
$string['pageloadingprogressthemecenteratom'] = 'Атом у центру';
$string['pageloadingprogressthemecentercircle'] = 'Круг у центру';
$string['pageloadingprogressthemecenterradar'] = 'Радар у центру';
$string['pageloadingprogressthemecornerindicator'] = 'Индикатор у углу';
$string['pageloadingprogressthemedesc'] = 'Подесите тему за учитавање странице.';
$string['pageloadingprogressthemeflash'] = 'Флеш';
$string['pageloadingprogressthemeloadingbar'] = 'Трака за учитавање';
$string['pageloadingprogressthememacosx'] = 'Mac OSX';
$string['pageloadingprogressthememinimal'] = 'Минимално';
$string['passwordplaceholder'] = 'Лозинка';
$string['past'] = 'Прошли';
$string['pastcourses'] = 'Протекли курсеви';
$string['people'] = 'Учесници';
$string['piwikenabled'] = 'Омогућено';
$string['piwikenableddesc'] = 'Омогућите Matomo праћење података за Moodle.';
$string['piwikimagetrack'] = 'Праћење слика';
$string['piwikimagetrackdesc'] = 'Омогућите праћење слике на Moodle сајту за веб читаче код којих је искључен JavaScript.';
$string['piwiksettings'] = 'Matomo (некадашњи Piwik) Analytics';
$string['piwiksettingsdesc'] = 'Генерише прочишћену URL адресу за напредно праћење.';
$string['piwiksettingsheading'] = 'Matomo подешавања';
$string['piwiksiteid'] = 'ID ознака сајта';
$string['piwiksiteiddesc'] = 'Унесите ID ознаку вашег сајта';
$string['piwiksiteurl'] = 'Matomo URL адреса';
$string['piwiksiteurldesc'] = 'Унесите URL адресу за Matomo Analytics  без http(s) и пратећих косих црта';
$string['piwiktrackadmin'] = 'Праћење администратора';
$string['piwiktrackadmindesc'] = 'Омогућите праћење администратора (не препоручује се)';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Портретна оријентација';
$string['previousactivity'] = 'Претходна активност';
$string['previoussection'] = 'Претходна секција';
$string['primarycolour'] = 'Примарна боја';
$string['primarycolourdesc'] = 'Подесите примарну боју. Ово је Bootstrap \'примарна\' боја која се користи унутар SCSS-а.';
$string['printbodyfontsize'] = 'Величина основног фонта';
$string['printbodyfontsizedesc'] = 'Подесите величину основног фонта';
$string['printlineheight'] = 'Висина реда';
$string['printlineheightdesc'] = 'Подесите висину реда.';
$string['printmargin'] = 'Маргина';
$string['printmargindesc'] = 'Подесите маргине.';
$string['printpageorientation'] = 'Оријентација странице';
$string['printpageorientationdesc'] = 'Подесите оријентацију странице на \'Портретна оријентација\' или \'Пејзажна оријентација\'.';
$string['printsettings'] = 'Штампа';
$string['printsettingsdesc'] = 'Конфигуришите подешавања за штампање.';
$string['printsettingsheading'] = 'Подешавања штампања';
$string['privacy:closed'] = 'Затворено';
$string['privacy:metadata:preference:collapseblock'] = 'Статус блокова на страници.';
$string['privacy:metadata:preference:draweropenblock'] = 'Статус фиоке са блоковима.';
$string['privacy:metadata:preference:draweropenindex'] = 'Статус фиоке са индексом курса';
$string['privacy:metadata:preference:themeadaptablealertkey'] = 'Дато важно обавештење.';
$string['privacy:metadata:preference:themeadaptablefull'] = 'Статус приказа преко целог екрана';
$string['privacy:metadata:preference:themeadaptablezoom'] = 'Статус зумирања';
$string['privacy:note'] = 'Напомена: графичка тема Adaptable има подешавања која се тичу њене конфигурацију. Специфична корисничка подешавања описана у \'Регистру приватности додатака\' важе и за Adaptable локални додатак (када се инсталира). За остала подешавања, на вама лежи одговорност да обезбедите да се не уносе подаци о корисницима у било које текстуално поље додатка. Подаци о инсталирању и подешавању додатка биће записани у основном Moodle систему за евидентирање догађаја, заједно са подацима о кориснику који је промене направио. Ово је изван контроле графичке тема. Молимо вас, погледајте основни систем за евиденцију догађаја ради усклађености са приватношћу. Када постављате слике, требало би да избегавате постављање  слика, код којих су укључени подаци о локацији (EXIF GPS) или други слични приватни подаци (из таквих слика се могу издвојити подаци о месту где је слика настала, као и слични приватни подаци). Пажљиво прегледајте кôд како бисте били сигурни да је он у потпуности складу са вашом интерпретацијом закона о приватности који важе у вашој земљи. Ја нисам правник и моја анализа се заснива на мом тумачењу. Ако имате било какву сумњу, одмах уклоните тему.';
$string['privacy:open'] = 'Отворено';
$string['privacy:request:preference:collapseblock'] = 'Параметар корисника "{$a->name}" за ID ознаку блока "{$a->blockid}" има вредност "{$a->value}" што представља "{$a->decoded}" за статус блока.';
$string['privacy:request:preference:draweropenblock'] = 'Параметар корисника "{$a->name}" има вредност "{$a->value}" што представља "{$a->decoded}" за статус фиоке са блоковима.';
$string['privacy:request:preference:draweropenindex'] = 'Параметар корисника "{$a->name}" има вредност "{$a->value}" што представља "{$a->decoded}" за статус фиоке са индексом курса.';
$string['privacy:request:preference:themeadaptablealertkey'] = 'Параметар корисника "{$a->name}" за ID ознаку важног обавештења  "{$a->alertid}" има вредност "{$a->value}" за дато важно обавештење, \'undismissable\' или било који други \'alertkey\' што представља да је важно обавештење већ постојало за корисника.';
$string['privacy:request:preference:themeadaptablefull'] = 'Параметар корисника "{$a->name}" има вредност "{$a->value}" што представља "{$a->decoded}" за статус зумирања.';
$string['privacy:request:preference:themeadaptablezoom'] = 'Параметар корисника "{$a->name}" има вредност "{$a->value}" што представља "{$a->decoded}" за статус зумирања.';
$string['properties'] = 'Увоз/извоз подешавања';
$string['propertiesdesc'] = 'У овом одељку можете да увезете/извезете тренутна подешавања Adaptable теме (својства) у JSON формату. Такође можете видети сва тренутна подешавања у овој Moodle инсталацији.';
$string['propertiesexport'] = 'Извезите параметре као JSON стринг';
$string['propertiesexportfilestoo'] = 'Извезите параметре са датотетекама<br>као JSON стринг';
$string['propertiesexportfilestoofile'] = 'Извезите параметре са датотетекама<br>као JSON датотеку';
$string['propertiesexportfilestoofilefail'] = 'Достигнут је максималан број параметара са датотекама, као JSON датотека. Обришите један или више њих.';
$string['propertiesexportfilestoofilehelp'] = 'Након експортовања, преузмите генерисану JSON датотеку са данашњим датумом и временом из подешавања \'propertyfiles\' и поставите је у подешавање \'fileputprops\' на одредишној инсталацији и кликните на дугме \'Сачувај промене\'. Извештај ће затим бити генерисан и постављен у подешавање \'putprops\' \'.';
$string['propertiesexportfilestoofilesuccess'] = 'Својства са датотекама као JSON датотека извезена као {$a}.';
$string['propertiesexportfilestoohelp'] = 'Након експортовања, копирајте JSON са екрана у подешавање \'putprops\' (након што га обришете) на одредишној инсталацији и кликните на дугме \'Сачувај промене\'. Извештај ће затим бити генерисан и постављен у подешавање \'putprops\' \'.';
$string['propertiesexporthelp'] = 'Након експортовања, копирајте JSON са екрана у подешавање \'putprops\' (након што га обришете) на одредишној инсталацији и кликните на дугме \'Сачувај промене\'. Извештај ће затим бити генерисан и постављен у подешавање \'putprops\' \'. У извештају ће бити приказана сва подешавања за које је потребно да њихове датотеке (са тим подешавањима) буду ручно пренете.';
$string['propertiesproperty'] = 'Параметар';
$string['propertiesreturn'] = 'Повратак';
$string['propertiessub'] = 'Тренутна подешавања теме';
$string['propertiesvalue'] = 'Вредност';
$string['propertyfileadded'] = 'Датотека \'{$a->filename}\' је додата у подешавање \'{$a->settingname}\'.';
$string['propertyfileremoved'] = 'Датотека \'{$a->filename}\' је уклоњена из подешавања \'{$a->settingname}\'.';
$string['propertyfiles'] = 'Датотека са својствима';
$string['propertyfilesdesc'] = 'Када се достигне максималан број датотека, нове неће бити додаване све док се једна или више датотека не обрише.';
$string['putpropertiesadded'] = 'Додато:';
$string['putpropertieschanged'] = 'Промењено:';
$string['putpropertiesdesc'] = 'Налепите JSON стринг и кликните на дугме \'Сачувај промене\'. Пажња! Не проверава вредности подешавања нити извршава команду \'Очистите све кеш меморије\'';
$string['putpropertiesfiledesc'] = 'Превуците и спустите JSON датотеку или је поставите и кликните на дугме \'Сачувај промене\'. Пажња! Не проверава вредности подешавања нити извршава команду \'Очистите све кеш меморије\'';
$string['putpropertiesfilename'] = 'Увезите својства из датотеке';
$string['putpropertiesfrom'] = 'од';
$string['putpropertiesheading'] = 'Увезите подешавања теме';
$string['putpropertiesignorecti'] = 'Игнорисање свих подешавања насловних слика курса.';
$string['putpropertiesignored'] = 'Игнорисано:';
$string['putpropertiesname'] = 'Увоз параметара';
$string['putpropertiesreportfiles'] = 'Не заборавите да поставите следеће датотеке у њихова подешавања:';
$string['putpropertiesreportfileschanged'] = 'Промењене датотеке:';
$string['putpropertiessettingsreport'] = 'Извештај о подешавањима:';
$string['putpropertiesunchanged'] = 'Непромењено:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyproperties'] = 'Параметри';
$string['putpropertyreport'] = 'Извештај:';
$string['putpropertyversion'] = 'верзија:';
$string['region-content'] = 'Садржај';
$string['region-course-bottom-a'] = 'Дно странице курса - регион пет';
$string['region-course-bottom-b'] = 'Дно странице курса - регион шест';
$string['region-course-bottom-c'] = 'Дно странице курса - регион седам';
$string['region-course-bottom-d'] = 'Дно странице курса - регион осам';
$string['region-course-section-a'] = 'Доњи регион на крају странице активности';
$string['region-course-tab-one-a'] = 'Картица странице курса - регион блокова један';
$string['region-course-tab-two-a'] = 'Картица странице курса - регион блокова два';
$string['region-course-top-a'] = 'Врх странице курса - регион један';
$string['region-course-top-b'] = 'Врх странице курса - регион два';
$string['region-course-top-c'] = 'Врх странице курса - регион три';
$string['region-course-top-d'] = 'Врх странице курса - регион четири';
$string['region-frnt-footer'] = 'Подножје';
$string['region-frnt-market-a'] = 'Регион странице један';
$string['region-frnt-market-b'] = 'Регион странице два';
$string['region-frnt-market-c'] = 'Регион странице три';
$string['region-frnt-market-d'] = 'Регион странице четири';
$string['region-frnt-market-e'] = 'Регион странице пет';
$string['region-frnt-market-f'] = 'Регион странице шест';
$string['region-frnt-market-g'] = 'Регион странице седам';
$string['region-frnt-market-h'] = 'Регион странице осам';
$string['region-frnt-market-i'] = 'Регион странице девет';
$string['region-frnt-market-j'] = 'Регион странице десет';
$string['region-frnt-market-k'] = 'Регион странице једанаест';
$string['region-frnt-market-l'] = 'Регион странице дванаест';
$string['region-frnt-market-m'] = 'Регион странице тринаест';
$string['region-frnt-market-n'] = 'Регион странице четрнаест';
$string['region-frnt-market-o'] = 'Регион странице петнаест';
$string['region-frnt-market-p'] = 'Регион странице шеснаест';
$string['region-frnt-market-q'] = 'Регион странице седамнаест';
$string['region-frnt-market-r'] = 'Регион странице осамнаест';
$string['region-frnt-market-s'] = 'Регион странице деветнаест';
$string['region-frnt-market-t'] = 'Регион странице двадесет';
$string['region-information'] = 'Информације';
$string['region-my-tab-one-a'] = 'Картица \'Контролног панела\' - регион један';
$string['region-my-tab-two-a'] = 'Картица \'Контролног панела\' - регион два';
$string['region-news-slider-a'] = 'Регион странице курса за слајд-шоу';
$string['region-side-post'] = 'Десно';
$string['region-side-pre'] = 'Лево';
$string['regionmaincolor'] = 'Боја главног региона';
$string['regionmaincolordesc'] = 'Подесите боју позадине за регион са главним садржајем.';
$string['regionmaintextcolor'] = 'Боја текста главног региона';
$string['regionmaintextcolordesc'] = 'Подесите боју текста за регион са главним садржајем.';
$string['rendereroverlaycolor'] = 'Боја прекривајућег слоја';
$string['rendereroverlaycolordesc'] = 'Боја прекривајућег слоја, када је изабрана опција приказа \'Плочице са прекривајућим слојем\'.';
$string['rendereroverlayfontcolor'] = 'Боја фонта прекривајућег слоја';
$string['rendereroverlayfontcolordesc'] = 'Боја фонта када се мишем пређе преко поља курса (у ситуацији када је омогућена опција приказа \'Плочице са прекривајућим слојем\').';
$string['responsivebreadcrumb'] = 'Навигација с путањом';
$string['responsivebreadcrumbdesc'] = 'На екранима које величине желите да се приказује навигација с путањом?';
$string['responsivecoursetitle'] = 'Назив курса / сајта';
$string['responsivecoursetitledesc'] = 'ЗАСТАРЕЛО, уместо тога користите \'responsivesitetitle\' .';
$string['responsiveheader'] = 'Главно заглавље';
$string['responsiveheaderdesc'] = 'На екранима које величине желите да се приказује главно заглавље?
<br/>Потпуно уклањање заглавља такође ће уклонити све елементе који се налазе у њему:<br/><ul><li>Иконице друштвених мрежа</li><li>Лого</li><li>Наслов сајта / курса</li></ul>';
$string['responsiveheadertitle'] = 'Наслов заглавља';
$string['responsiveheadertitledesc'] = 'На екранима које величине желите да се приказује наслов заглавља?';
$string['responsivelogo'] = 'Лого';
$string['responsivelogodesc'] = 'На екранима које величине желите да се приказује лого?';
$string['responsivepagefooter'] = 'Подножје';
$string['responsivepagefooterdesc'] = 'На екранима које величине желите да се приказује подножје?';
$string['responsivesectionnav'] = 'Навигација кроз активност / секције';
$string['responsivesectionnavdesc'] = 'Прикажите/сакријте <strong>текстуалну навигацију</стронг> за "претходну" односно "следећу" активност/секцију на малим екранима. Подразумевано, овај текст је сакривен на мањим екранима тако да се приказују само иконице за линкове <prev> <next>, а не пун назив секције/активности.';
$string['responsivesettings'] = 'Прилагодљив распоред елемената';
$string['responsivesettingsdesc'] = 'Овде можете да контролишете одзивно понашање вашег веб сајта (који се елементи појављују на екранима различитих величина). Стандардно, већина небитних ставки је скривена на мобилним уређајима и подешена да се приказује само на већим екранима. Можете да учините да се елементи појављују на мањим екранима тако што ћете изабрати да их прикажете на "Изузетно малим" или "Малим екранима". Да бисте боље разумели како ова подешавања функционишу, погледајте Bootstrap документацију о \'<a href="{$a}" target="_blank">Својствима приказа</а>\'.';
$string['responsivesettingsheading'] = 'Контролишите како се ваш веб сајт понаша на различитим величинама екрана';
$string['responsivesitetitle'] = 'Наслов сајта';
$string['responsivesitetitledesc'] = 'ЗАСТАРЕЛО, уместо тога користите \'responsiveheadertitle\' .';
$string['responsiveslider'] = 'Слајд-шоу на насловној страници';
$string['responsivesliderdesc'] = 'На екранима које величине желите да се приказује слајд-шоу на насловној страници?';
$string['responsivesocial'] = 'Иконице друштвених мрежа';
$string['responsivesocialdesc'] = 'На екранима које величине желите да се приказују иконице друштвених мрежа?';
$string['responsivesocialsize'] = 'Подеси величину фонта иконица друштвених мрежа на мобилним уређајима';
$string['responsivesocialsizedesc'] = 'Да би приказ био бољи, величина треба да буде 5 пиксела већа од жељене.';
$string['responsiveticker'] = 'Покретна трака са вестима';
$string['responsivetickerdesc'] = 'На екранима које величине желите да се приказује покретна трака са вестима?';
$string['rightblocks'] = 'Десна страна';
$string['savebuttontext'] = 'Сачувај промене';
$string['searchboxpadding'] = 'Слободан простор око поља за претрагу';
$string['searchboxpaddingdesc'] = 'Подесите удаљеност поља за претрагу од ивица странице (ако се ово поље користи уместо иконица друштвених мрежа) <br />Нпр. 5px 10px 5px 10px (горе, десно, доле, лево).<br> Иконице друштвених мрежа можете подесити на страници за подешавање <a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Заглавље - друштвене мреже</a>.';
$string['secondarycolour'] = 'Секундарна боја';
$string['secondarycolourdesc'] = 'Подесите секундарну боју. Ово је Bootstrap \'секундарна\' боја која се користи унутар SCSS-а.';
$string['sectionheadingcolor'] = 'Боја текста наслова секције';
$string['sectionheadingcolordesc'] = 'Подесите боју за текст наслова секције';
$string['sections'] = 'Секције';
$string['selectionbackground'] = 'Боја позадине изабраног текста';
$string['selectionbackgrounddesc'] = 'Подесите боју позадине текста који је изабран на екрану.';
$string['selectiontext'] = 'Боја изабраног текста';
$string['selectiontextdesc'] = 'Подесите боју текста који је изабран на екрану.';
$string['settingsalertbox'] = 'Оквир са важним обавештењем';
$string['settingsanalytics'] = 'Аналитика';
$string['settingsblockicons'] = 'Иконице';
$string['settingsblocksconfiguration'] = 'Конфигурација';
$string['settingsborders'] = 'Бордуре';
$string['settingsbreadcrumbcolors'] = 'Боје навигационе путање';
$string['settingscolors'] = 'Боје';
$string['settingscourses'] = 'Курсеви';
$string['settingsfonts'] = 'Фонтови';
$string['settingsfootercolors'] = 'Боје подножја';
$string['settingsforumheading'] = 'Форум';
$string['settingsheadercolors'] = 'Боје заглавља';
$string['settingsinfoboxcolors'] = 'Боје инфо-блока';
$string['settingsinformation'] = 'Информације';
$string['settingsmaincolors'] = 'Главне боје';
$string['settingsmarketingcolors'] = 'Боје промотивних блокова';
$string['settingsmessagescolors'] = 'Боје искачућег прозора са порукама';
$string['settingsmobilecolors'] = 'Боје на мобилним уређајима';
$string['settingsnavbarcolors'] = 'Боје навигационе траке';
$string['settingsoverlaycolors'] = 'Боје плочица прекривајућег слоја';
$string['settingspagealertsettings'] = 'Важна обавештења';
$string['settingspageblocksettings'] = 'Блокови';
$string['settingspagefrontpageblockregionsettings'] = 'Алат за креирање распореда блокова на насловнојн страници';
$string['settingspagegeneralsettings'] = 'Општа подешавања';
$string['settingssecondinfoboxcolors'] = 'Боје секундарног инфо-блока';
$string['settingstopicsweeks'] = 'Теме/Седмице';
$string['show'] = 'Прикажи';
$string['showfooterblocks'] = 'Прикажи блокове подножја';
$string['showfooterblocksdesc'] = 'Прикажи/сакриј четири подесива блока у подножју странице.';
$string['shownavigationblockoncoursepage'] = 'Прикажи блок за навигацију на страници курса';
$string['shownavigationblockoncoursepagedesc'] = 'Подесите ово како бисте приказали блок за навигацију на страници курса.';
$string['showusername'] = 'Прикажи корисничко име';
$string['showusernamedesc'] = 'Прикажите корисничко име у корисничком менију на навигационој траци.';
$string['side-post1'] = 'Бочни стубац са блоковима у подножју';
$string['sidebaricon'] = 'Прикажи / сакриј бочни стубац са блоковима';
$string['sitelinkslabel'] = 'Линкови сајта';
$string['sitetitle'] = 'Прикажи наслов сајта';
$string['sitetitlecoursesdisabled'] = 'Онемогућено - прикажи само наслове курсева на страницама курсева';
$string['sitetitlecoursesenabled'] = 'Омогућено - прикажи наслов сајта и наслове курсева на страницама курсева';
$string['sitetitlecustom'] = 'Користите прилагођени наслов сајта (унесите га у доње текстуално поље \'sitetitletext\' )';
$string['sitetitledefault'] = 'Користи наслов Moodle сајта (назив сајта)';
$string['sitetitledesc'] = 'Прикажите подразумевани наслов Moodle сајта преузет из <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Подешавања насловне странице</a> или унесите у доње поље прилагођени назив сајта.';
$string['sitetitleoff'] = 'Онемогући наслов сајта';
$string['sitetitletext'] = 'Наслов сајта';
$string['sitetitletextdesc'] = 'Наслов сајта који се приказује у заглављу. Можете да користите било коју HTML ознаку и применити уметнуте стилове. Препоручује се да користите HTML ознаку H1 око наслова, уместо ознаке P која се додаје као подразумевана када унесете нешто у ово поље.';
$string['skipblock'] = 'Прескочи блок {$a}';
$string['slider2h3bgcolor'] = 'Слајд-шоу два - боја позадине H3 ознаке';
$string['slider2h3bgcolordesc'] = 'Изаберите боју позадине коју желите за ознаку H3 (за слајд-шоу стил два)';
$string['slider2h3color'] = 'Слајд-шоу два - боја текста ознаке H3';
$string['slider2h3colordesc'] = 'Изаберите боју текста коју желите за ознаку H3 (за слајд-шоу стил два)';
$string['slider2h4bgcolor'] = 'Слајд-шоу два - боја позадине H4 ознаке';
$string['slider2h4bgcolordesc'] = 'Изаберите боју позадине коју желите за ознаку H4 (за слајд-шоу стил два)';
$string['slider2h4color'] = 'Слајд-шоу два - боја текста ознаке H4';
$string['slider2h4colordesc'] = 'Изаберите боју текста коју желите за ознаку H4 (за слајд-шоу стил два)';
$string['slidercaption'] = 'Натпис на слајду';
$string['slidercaptiondesc'] = 'Додајте натпис за ваш слајд';
$string['slidercount'] = 'Број слајдова';
$string['slidercountdesc'] = 'Изаберите колико слајдова желите да додате, а <strong>онда кликните на дугме \'САЧУВАЈ\'</strong> како би се учитала поља за унос подешавања.';
$string['sliderenabled'] = 'Омогући слајд-шоу';
$string['sliderenableddesc'] = 'Омогућите слајд-шоу на врху ваше почетне странице.';
$string['sliderfullscreen'] = 'Слајд-шоу преко целог екрана';
$string['sliderfullscreendesc'] = 'Означите ово поље како би слајд-шоу био приказан преко целог екрана (100% ширине).';
$string['sliderh3color'] = 'Слајд-шоу један - боја H3 ознаке';
$string['sliderh3colordesc'] = 'Изаберите боју коју желите за ознаку H3 (за слајд-шоу стил један)';
$string['sliderh4color'] = 'Слајд-шоу један - боја H4 ознаке';
$string['sliderh4colordesc'] = 'Изаберите боју коју желите за ознаку H4 (за слајд-шоу стил један)';
$string['sliderimage'] = 'Слика слајда';
$string['sliderimagedesc'] = 'Додајте слику за ваш слајд. Препоручена величина је 1600 x 400 пиксела или већа.';
$string['slidermarginbottom'] = 'Слајд-шоу - доња маргина';
$string['slidermarginbottomdesc'] = 'Подесите величину маргине испод слајд-шоу презентације.';
$string['slidermargintop'] = 'Слајд-шоу - горња маргина';
$string['slidermargintopdesc'] = 'Подесите величину маргине изнад слајд-шоу презентације';
$string['slideroption2'] = 'Изабери тип слајд-шоу презентације';
$string['slideroption2a'] = 'Боја позадине стрелице (слајд-шоу стил два)';
$string['slideroption2adesc'] = 'Подесите боју позадине стрелице (за слајд-шоу стил два).';
$string['slideroption2color'] = 'Слајд-шоу два - позадина дугмета';
$string['slideroption2colordesc'] = 'Подесите боју позадине дугмета (за слајд-шоу стил два)';
$string['slideroption2desc'] = 'Изаберите тип слајд-шоу презентације, а <strong>онда кликните на дугме САЧУВАЈ</strong> како бисте видела подешавања боја за изабрани тип презентације.';
$string['slideroption2submitcolor'] = 'Слајд-шоу два - текст дугмета';
$string['slideroption2submitcolordesc'] = 'Подесите боју текста на дугмету (за слајд-шоу стил два)';
$string['sliderstyle1'] = 'Слајд-шоу - стил један';
$string['sliderstyle2'] = 'Слајд-шоу - стил два';
$string['slidersubmitbgcolor'] = 'Слајд-шоу један - позадина дугмета';
$string['slidersubmitbgcolordesc'] = 'Изаберите боју позадине дугмета (за слајд-шоу стил један)';
$string['slidersubmitcolor'] = 'Слајд-шоу један - текст дугмета';
$string['slidersubmitcolordesc'] = 'Изаберите боју текста на дугмету (за слајд-шоу стил један)';
$string['sliderurl'] = 'URL адреса линка слајда';
$string['sliderurldesc'] = 'Додајте URL адресу са којом ће ваш слајд бити повезан када се кликне на њега.';
$string['slidervisible'] = 'Прикажи слајд-шоу када је корисник';
$string['slidervisibledesc'] = 'Слајд-шоу ће битиприказан када је корисник \'Одјављен\', \'Пријављен\' или \'Пријављен или одјављен\'.';
$string['slidervisibleloggedin'] = 'Пријављен';
$string['slidervisibleloggedinout'] = 'Пријављен или одјављен';
$string['slidervisibleloggedout'] = 'Одјављен';
$string['slideshowdesc'] = 'Поставите слике, додајте линкове и опис за карусел слајдова на насловној страници.';
$string['slideshowsettings'] = 'Слајд-шоу';
$string['slideshowsettingsheading'] = 'Прилагодите карусел слајдова на насловној страници.';
$string['slight'] = 'Блага сенка';
$string['socialheading'] = 'Подешавање иконица друштвених мрежа';
$string['socialicondesc'] = 'Подесите Font Awesome иконицу, на пример: fa-facebook.';
$string['socialiconlist'] = 'Списак иконица друштвених мрежа';
$string['socialiconlistdesc'] = 'Унесите списак са граничницима, како бисте подесили иконице друштвених мрежа / линкове који су вам потребни, користећи формат: url|title|icon.';
$string['socialpaddingside'] = 'Подесите размак са стране иконица друштвених мрежа';
$string['socialpaddingsidedesc'] = 'Ово ће бити размак између иконице и другог елемента или међупростор између две иконице. тј. додатни простор око иконице ће бити ова вредносат подељена са два. Подразумевана вредност прати смернице за брендирање Instagrama.';
$string['socialpaddingtop'] = 'Подесите размак изнад иконица друштвених мрежа (мења вертикални положај)';
$string['socialpaddingtopdesc'] = 'Ово ће бити минимум од 15 пиксела (подешено коришћењем маргине) плус ова вредност.';
$string['socialsearchicon'] = 'Претражи Moodle';
$string['socialsearchicondesc'] = 'Ово подешавање омогућава да се постави поље за претрагу упоредо са иконицама друштвених мрежа (пошто њихово коришћење онемогућава поље за претрагу на читавом сајту).';
$string['socialsettings'] = 'Заглавље - друштвене мреже';
$string['socialsize'] = 'Подеси величину фонта за иконице друштвених мрежа';
$string['socialsizedesc'] = 'За бољи приказ, величина треба да буде 5 пиксела већа од жељене величине.';
$string['socialtarget'] = 'Одредиште линкова друштвених мрежа';
$string['socialtargetdesc'] = 'Како желите да се линкови друштвених мрежа отварају (у истом или новом прозору).';
$string['socialtitledesc'] = 'Можете да онемогућите поље за претрагу на читавом сајту и уместо њега омогућите иконице / линкове друштвених мрежа.
Да бисте подесили иконице друштвених мрежа унесите списак са граничницима у доње поље "Списак иконица друштвених мрежа".
Списак треба да буде у формату:

url|title|icon

На пример:
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|My Web|fa-globe
</pre>
Комплетан списак Font Awesome иконица можете наћи <a href="https://fortawesome.github.io/Font-Awesome/icons/">овде</a>.';
$string['solid'] = 'Пуна ивица';
$string['standard'] = 'Стандардна сенка';
$string['standardscreenwidth'] = 'Стандардна ширина екрана.';
$string['standardscreenwidthdesc'] = 'Подесите ширину екрана када се приказ пребаци на "стандардни" приказ (такође погледајте повезана подешавања enablezoom и defaultzoom).';
$string['standardview'] = 'Стандардни приказ';
$string['stickynavbar'] = 'Лепљива навигациона трака на врху';
$string['stickynavbardesc'] = 'Фиксирајте навигациону траку за врх екрана приликом премотавања садржаја странице.';
$string['stylecover'] = 'Насловна слика';
$string['stylestretch'] = 'Развучена слика';
$string['tabbedlayoutcoursepage'] = 'Изглед странице курса са картицама';
$string['tabbedlayoutcoursepagedesc'] = 'Употребите картични изглед за почетну страницу курс. Ово приказују сав садржај унутар картица. У оквиру картице \'Садржај курса\' налази се садржај почетне странице курса, док садржај преостале две картице (Картица један, Картица два) можете прилагодити својим потребама. Користите ово подешавање како бисте конфигурисали редослед картица.';
$string['tabbedlayoutcoursepagelink'] = 'Картица за повратак на курс на страници курса са картицама';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Додајте међу картице курса картицу за повратак на страницу курса.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Боја изабране картице на страници курса';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Изаберите боју за тренутно изабрану картицу.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Боја неизабране картице на страници курса';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Изаберите боју за било коју другу картицу.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Време трајања картице на почетној страници курса';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'Почетна страница курса опстаје на изабраној картици када долази до освежавања након одређеног периода неактивности. Овде подесите период неактивности. На пример, подесите ово на 30 тако да прва картица буде изабрана након 30 минута неактивности.';
$string['tabbedlayoutdashboard'] = 'Картични изглед \'Контролног панела\'';
$string['tabbedlayoutdashboarddesc'] = 'Употребите картични изглед странице \'Контролни панел\'. Ово приказује сав садржај унутар картица. У оквиру картице \'Садржај контролног панела\' налази се садржај истоимена страница, док садржај преостале две картице (Картица један, Картица два) можете прилагодити својим потребама. Користите ово подешавање како бисте конфигурисали редослед картица.';
$string['tabbedlayoutdashboardtab1condition'] = 'Ограничење приказа Картице 1 на основу прилагођеног поље профила (опционо)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Додајте правило приступа за приказ Картице 1 користећи прилагођено поље профила нпр: showtab1=true.';
$string['tabbedlayoutdashboardtab2condition'] = 'Ограничење приказа Картице 2 на основу прилагођеног поље профила (опционо)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Додајте правило приступа за приказ Картице 2 користећи прилагођено поље профила нпр: showtab2=true.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Боја изабране картице на Контролном панелу';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Изаберите боју за тренутно изабрану картицу.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Боја неизабрана картице на Контролном панелу';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Изаберите боју за било коју другу картицу.';
$string['tabbedlayoutheading'] = 'Adaptable страница са картицама';
$string['tabbedlayouttablabelcourse'] = 'Садржај курса';
$string['tabbedlayouttablabelcourse1'] = 'Картица један';
$string['tabbedlayouttablabelcourse2'] = 'Картица два';
$string['tabbedlayouttablabeldashboard'] = 'Садржај \'Контролног панела\'';
$string['tabbedlayouttablabeldashboard1'] = 'Картица један';
$string['tabbedlayouttablabeldashboard2'] = 'Картица два';
$string['targetnewwindow'] = 'Нови прозор';
$string['targetsamewindow'] = 'Исти прозор';
$string['templatesheading'] = 'Подешавања шаблона';
$string['templatesheadingdesc'] = 'Замените шаблоне.';
$string['templatessel'] = 'Шаблони које треба заменити';
$string['templatesseldesc'] = 'Изаберите шаблоне које желите да замените, а затим ће сваки бити приказан на сопственој страници. Ако овде није изабран, шаблон неће бити замењен чак и ако је омогућен. Уколико желите да не изаберете ниједан шбалон, употребите тастер \'Ctrl\'.';
$string['templatessettings'] = 'Шаблони';
$string['themechanges'] = 'Промене';
$string['themereadme'] = 'Readme упутство';
$string['themesupportsponsorship'] = 'Подршка и спонзорство';
$string['thiscourse'] = 'Овај курс';
$string['ticker'] = 'Најаве';
$string['tickerconstainerbackgroundcolour'] = 'Боја позадине покретне траке са вестима';
$string['tickerconstainerbackgroundcolourdesc'] = 'Подесите боју позадине покретне траке са вестима.';
$string['tickerconstainertextcolour'] = 'Боја текста на покретној траци са вестима';
$string['tickerconstainertextcolourdesc'] = 'Подесите боју текста на покретној траци са вестима';
$string['tickerdefault'] = 'Нема нових вести за приказ';
$string['tickerdesc'] = 'Овде можете подесити покретну траку са вестима која се креће преко насловне странице вашег Moodle сајта.
Њена намена је да буде мање наметљива алтернатива за слајд-шоу, с обзиром да заузима врло мало простора.
Да бисте подесили покретну траку са вестима једноставно унесите списак  вести, заједно са  хиперлинковима који су вам потребни у тексту вести.
<strong>Напомена:</strong> Ако се ваша покретна трака са вестима не учитава исправно пребаците се на HTML приказ и проверите да имате само &lt;p&gt; ознаке:
<pre>
&lt;p&gt;Прва вест.....&lt;/p&gt;
&lt;p&gt; Друга вест.....&lt;/p&gt;
</pre>';
$string['tickerfullscreen'] = 'Приказ преко целог екрана';
$string['tickerheaderbackgroundcolour'] = 'Боја позадине заглавља покретне траке са вестима';
$string['tickerheaderbackgroundcolourdesc'] = 'Подесите боју позадине заглавља покретне траке са вестима';
$string['tickerheadertextcolour'] = 'Боја текста заглавља на покретној траци са вестима';
$string['tickerheadertextcolourdesc'] = 'Подесите боју теста заглавља на покретној траци са вестима';
$string['tickersettings'] = 'Покретна трака са вестима';
$string['tickersettingsheading'] = 'Прилагодите покретну траку са вестима на насловној страници. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['tickertext'] = 'Текст покретне траке са вестима';
$string['tickertextdesc'] = 'Додајте текст за покретну траку са вестима у формату списка. Погледајте readme.txt датотеку за више информација.';
$string['tickertextprofilefield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['tickertextprofilefielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: usertype=student.';
$string['tickerwidth'] = 'Фиксна ширина';
$string['tickerwidthdesc'] = 'Можете користити ово подешавање како бисте фиксирали покретну траку са  вестима на 100% ширине.';
$string['tilesbordercolor'] = 'Боја бордуре плочица оквира курса';
$string['tilesbordercolordesc'] = 'Подесите боју бордуре плочица оквира курса.';
$string['tilescontactstitle'] = 'Прикажи улоге контакт особа';
$string['tilescontactstitledesc'] = 'Прикажите / сакријте улогу контакт особа на курсу. Ако није приказана улога, биће приказана слика поред сваке контакт особе.';
$string['tilesshowallcontacts'] = 'Прикажи све контакт особе';
$string['tilesshowallcontactsdesc'] = 'Прикажите све контакт особе на курсу или само једну.';
$string['tilesshowcontacts'] = 'Прикажи особе на курсу задужене за контакт';
$string['tilesshowcontactsdesc'] = 'Прикажи / сакриј особа на курсу задужене за контакт.';
$string['togglenavigation'] = 'Укључи/искључи навигацију';
$string['toolsmenu'] = 'Падајући мени \'Алати\'';
$string['toolsmenudesc'] = 'Додајте падајући мени у главну навигациону траку';
$string['toolsmenufield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['toolsmenufielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: usertype=student.';
$string['toolsmenuheading'] = 'Мени \'Алати\'';
$string['toolsmenuheadingdesc'] = 'Можете да конфигуришете линкове у оквиру менија \'Алати\' (у главној навигационој траци. Формат је сличан оном који се користи за Moodle прилагођене меније, али вам омогућава да уз ставке менија додате Font Awesome иконице:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenuheadingindex'] = 'Мени \'Алати\' {$a}';
$string['toolsmenuscount'] = 'Број менија \'Алати\'';
$string['toolsmenuscountdesc'] = 'Подесите број менија \'Алати\' које желите да додате у главну навигациону траку';
$string['toolsmenutitle'] = 'Наслов менија \'Алати\'';
$string['toolsmenutitledefault'] = 'Алати';
$string['toolsmenutitledesc'] = 'Додајте наслов менија који желите да прикажете на главној навигацијионој траци.';
$string['topicsweeks'] = 'Тематски/Седмични формат курса';
$string['topicsweeksdesc'] = 'Подесите стилове за Тематски/Седмични формат курса';
$string['topmenufontsize'] = 'Величина фонта менија на врху странице';
$string['topmenufontsizedesc'] = 'Подесите величину фонта менија на врху странице.';
$string['topmenuscount'] = 'Број менија на врху странице';
$string['topmenuscountdesc'] = 'Подесите број менија на врху странице које желите да додате у навигациону траку.';
$string['turngradereditingoff'] = 'Искључите уређивање оцењивача';
$string['turngradereditingon'] = 'Укључите уређивање оцењивача';
$string['usermenu'] = 'Кориснички мени';
$string['usernameposition'] = 'Позиција корисничког имена';
$string['usernamepositiondesc'] = 'Подесите позицију корисничког имена, \'Лево\' или \'Десно\'.';
$string['usernav'] = 'Заглавље - кориснички мени';
$string['usernavdesc'] = 'Омогућава вам да контролишете све елементе који се појављују у корисничком падајућем менију.';
$string['usernavheading'] = 'Прилагодите кориснички падајући мени за навигацију';
$string['usernodescription'] = 'Корисник још није ажурирао свој опис.';
$string['usernointerests'] = 'Корисник још увек није ажурирао своја интересовања.';
$string['usersettings'] = 'Кориснички профил';
$string['usersettingsdesc'] = 'Конфигуришите подешавања за кориснички профил.';
$string['usersettingsheading'] = 'Подешавања корисничког профила';
$string['versionalpha'] = 'Алфа верзија - готово сигурно садржи грешке. Ово је развојна верзија само за програмере! Немојте ни помишљати на инсталирање на продукционом серверу!';
$string['versionbeta'] = 'Бета верзија – вероватно садржи грешке. Спремно за тестирање од стране администратора само на тест серверу.';
$string['versioninfo'] = 'Издање {$a->release}, верзија {$a->version} на Moodleu {$a->moodle}';
$string['versionrc'] = 'RC (Release candidate) верзија - може да садржи грешке. Проверите на тест серверу пре него што додатак инсталирате на свом продукционом серверу.';
$string['versionstable'] = 'Стабилна верзија – може да садржи грешке јер у универзуму није остало довољно времена да све буду пронађене. Проверите прво на тест серверу, пре него што тему инсталирате на свом продукциони сервер, озбиљно! Нећете пожалити и моћи ћете све да прилагодите док не будете задовољни, а затим употребите функцију \'Увоз/извоз подешавања\' како бисте пренели сва подешавања.';
$string['wide'] = 'Приказ преко целог екрана';
