<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'sr_cr', version '4.1'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Садржај странице \'О нама\'';
$string['aboutuscontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници \'О нама\'';
$string['aboutusdisabled'] = 'Страница \'О нама\' је онемогућена на овом сајту. Овде нема шта да се види.';
$string['aboutusheading'] = 'О нама\'';
$string['aboutuslinkpositionboth'] = 'Додајте линк ка страници \'О нама\' у фусноту и на иконицу у подножју странице (знак питања)';
$string['aboutuslinkpositionfooter'] = 'Додајте линк ка страници \'О нама\' на иконицу у подножју странице (знак питања)';
$string['aboutuslinkpositionfootnote'] = 'Додајте линк ка страници \'О нама\' у фусноту';
$string['aboutuslinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници \'О нама\'';
$string['aboutuslinkpositionsetting'] = 'Позиција линка \'О нама\'';
$string['aboutuslinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници \'О нама\' аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['aboutuspagetitledefault'] = 'О нама';
$string['aboutuspagetitlesetting'] = 'Наслов странице \'О нама\'';
$string['aboutuspagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице \'О нама\'. Овај текст ће се користити и као текст линка ка страници \'О нама\' ако у складу с тим конфигуришете подешавање Позицијa линка \'О нама\'.';
$string['accessibilitydeclarationcontentsetting'] = 'Садржај странице са декларацијом о приступачности';
$string['accessibilitydeclarationcontentsetting_desc'] = 'У овом подешавању можете да додате обогаћени текстуални садржај који ће бити приказан на страници са декларацијом о приступачности.';
$string['accessibilitydeclarationdisabled'] = 'Страница декларације са информацијама о доступности је онемогућена за овај сајт. Овде нема шта да се види.';
$string['accessibilitydeclarationheading'] = 'Декларација о приступачности';
$string['accessibilitydeclarationlinkpositionboth'] = 'Додајте линк ка страници са декларацијом о приступачности у фусноту и на иконицу у подножју странице (знак питања)';
$string['accessibilitydeclarationlinkpositionfooter'] = 'Додајте линк ка страници са декларацијом о приступачности на иконицу у подножју странице (знак питања)';
$string['accessibilitydeclarationlinkpositionfootnote'] = 'Додајте линк ка страници са декларацијом о приступачности у фусноту';
$string['accessibilitydeclarationlinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници са декларацијом о приступачности';
$string['accessibilitydeclarationlinkpositionsetting'] = 'Позиција линка ка страници са декларацијом о приступачности';
$string['accessibilitydeclarationlinkpositionsetting_desc'] = 'У овом подешавању можете конфигурисати да ли линк ка страници са деклерацијом о приступачности треба да буде аутоматски додат на Moodle страницу. Уколико не желите да линк аутоматски буде приказан, можете ручно додати линк ка {$a->url} било где унутар Moodlea.';
$string['accessibilitydeclarationpagetitledefault'] = 'Декларација о приступачности';
$string['accessibilitydeclarationpagetitlesetting'] = 'Наслов странице декларације о приступачности';
$string['accessibilitydeclarationpagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице са декларацијом о приступачности. Овај текст ће се такође користити као текст линка ка страници са декларацијом о приступачности ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници са декларацијом о приступачности\'.';
$string['accessibilitydeclarationtab'] = 'Декларација';
$string['accessibilitysupportanonymouscheckbox'] = 'Радије бих да свој захтев за подршку приступачности пошаљем анонимно';
$string['accessibilitysupportanonymousemail'] = 'anonymous@email.invalid';
$string['accessibilitysupportanonymoususer'] = 'Анонимни корисник';
$string['accessibilitysupportcontentdefault'] = '<p>Уколико имате повратне информације о приступачности или желите да пријавите препреку у приступу, искористите образац у наставку.</p><p>Да ли користите неку асистивну алатку као што су читачи екрана, лупе, контрола гласа или софтвер за препознавање говора? Ако је одговор потврдан, наведите коју од асистивних алатки тачно користите. Да бисте нам помогли да обрадимо ваш захтев, можете дозволити да образац аутоматски заједно са вашом поруком пошаље следеће информације: URL адреса на којој сте били када сте отворили овај образац за подршку (ово се зове \'референтна страница\' - \'referrer\'), као и информације о вашем веб читачу.</p>';
$string['accessibilitysupportcontentsetting'] = 'Садржај странице за подршку приступачности';
$string['accessibilitysupportcontentsetting_desc'] = 'У овом подешавању можете да додате обогаћени текстуални садржај који ће бити приказан на страници за подршку приступачности, заједно са обрасцем за слање повратних информација о приступачности или за пријаву ограничења у приступачности.';
$string['accessibilitysupportdefaultsubject'] = 'Повратне информације о приступачности';
$string['accessibilitysupportdisabled'] = 'Страница за подршку приступачности је онемогућена за овај сајт. Овде нема шта да се види.';
$string['accessibilitysupportheading'] = 'Страница за подршку приступачности';
$string['accessibilitysupportlinkpositionboth'] = 'Додајте линк ка страници за подршку приступачности у фусноту и на иконицу у подножју странице (знак питања)';
$string['accessibilitysupportlinkpositionfooter'] = 'Додајте линк ка страници за подршку приступачности на иконицу у подножју странице (знак питања)';
$string['accessibilitysupportlinkpositionfootnote'] = 'Додајте линк ка страници за подршку приступачности у фусноту';
$string['accessibilitysupportlinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници за подршку приступачности';
$string['accessibilitysupportlinkpositionsetting'] = 'Позиција линк ка страници за подршку приступачности';
$string['accessibilitysupportlinkpositionsetting_desc'] = 'У овом подешавању можете конфигурисати да ли линк ка страници за подршку приступачности треба да буде аутоматски додат на Moodle страницу. Уколико не желите да линк аутоматски буде приказан, можете ручно додати линк ка {$a->url} било где унутар Moodlea.';
$string['accessibilitysupportmessagenotsent'] = 'Нажалост, ваш захтев за подршку приступачности није могао бити послат.';
$string['accessibilitysupportmessagesent'] = 'Ваш захтев за подршку приступачности је послат.';
$string['accessibilitysupportmessagetryagain'] = 'Покушајте поново касније.';
$string['accessibilitysupportmessagetryalternative'] = 'Покушајте поново касније или пошаљите е-поруку директно на <a href="mailto:{$a}">{$a}</a>.';
$string['accessibilitysupportpagesrlinktitledefault'] = 'Пошаљите захтев за подршку приступачности';
$string['accessibilitysupportpagesrlinktitlesetting'] = 'Наслов линка за читач екрана странице за подршку приступачности';
$string['accessibilitysupportpagesrlinktitlesetting_desc'] = 'У овом подешавању можете дефинисати линк ка читачу екрана странице за подршку приступачности. Овај текст ће се такође користити као текст линка који се приказује само читачима екрана.';
$string['accessibilitysupportpagetitledefault'] = 'Подршка за приступачност';
$string['accessibilitysupportpagetitlesetting'] = 'Наслов странице за подршку приступачности';
$string['accessibilitysupportpagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице за подршку приступачности. Овај текст ће се такође користити као текст линка ка страници са информацијама о подршци за приступачност ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници за подршку приступачности\'.';
$string['accessibilitysupportrecaptcha'] = 'Додајте reCAPTCHA упит на страницу за подршку приступачности';
$string['accessibilitysupportrecaptcha_desc'] = 'Помоћу овог подешавања контролишете да ли ће reCAPTCHA упит бити додат на страницу за подршку приступачности. Сврха овога је да се спречи нежељена пошта и злоупотреба обрасца за подршку приступачности, баш као што се то ради унутар <a href="{$a->support}">Moodle основног обрасца за подршку</a>. Међутим, додавање reCAPTCHA упита представља додатну препреку приступачности за кориснике који користе читаче екрана или друге помоћне технологије, што би у овом случају могло да буде контрапродуктивно. Зато вас молимо да будете опрезни уколико желите да омогућите ово подешавање. Такође, имајте на уму да, чак и ако је ово подешавање омогућено, reCAPTCHA упит неће бити приказан док не унесете неопходне <a href="{$a->settings}">API кључеве у подешавањима за проверу идентитета</a>.';
$string['accessibilitysupportsentforanonymoususer'] = 'Корисник је затражио да анонимно пошаље ове повратне информације о приступачности.';
$string['accessibilitysupporttab'] = 'Страница за подршку';
$string['accessibilitysupporttechinfo'] = 'Техничке информације';
$string['accessibilitysupporttechinfocheckbox'] = 'Слажем се да заједно са поруком пошаљем и следеће техничке информације';
$string['accessibilitysupporttechinfolabel'] = 'Техничке информације које се шаљу са поруком';
$string['accessibilitysupporttechinforeferrer'] = 'Референтна страница (\'referrer\')';
$string['accessibilitysupporttechinfosysinfo'] = 'Информације о систему';
$string['accessibilitysupportuserfirstname'] = 'Приступачност';
$string['accessibilitysupportuserlastname'] = 'подршка';
$string['accessibilitysupportusermail'] = 'Адреса е-поште за подршку приступачности';
$string['accessibilitysupportusermail_desc'] = 'Овде дефинишете адресу е-поште на коју треба да се шаљу захтеви за подршку приступачности. Ако ово поље оставите празно, захтеви ће бити послати на <a href="{$a->url}">конфигурисани контакт за подршку сајта</a>.';
$string['accessibilitysupportusermailsubject'] = 'Захтев за подршку приступачности';
$string['activitybrandingtab'] = 'Брендирање активности';
$string['activityiconcoloradministrationsetting'] = 'Боја иконице активности за ”Администрација”';
$string['activityiconcoloradministrationsetting_desc'] = 'Боја иконице активности за ”Администрација”';
$string['activityiconcolorassessmentsetting'] = 'Боја иконице активности за ”Процена”';
$string['activityiconcolorassessmentsetting_desc'] = 'Боја иконице активности за ”Процена”';
$string['activityiconcolorcollaborationsetting'] = 'Боја иконице активности за ”Сарадња”';
$string['activityiconcolorcollaborationsetting_desc'] = 'Боја иконице активности за ”Сарадња”';
$string['activityiconcolorcommunicationsetting'] = 'Боја иконице активности за ”Комуникација”';
$string['activityiconcolorcommunicationsetting_desc'] = 'Боја иконице активности за ”Комуникација”';
$string['activityiconcolorcontentsetting'] = 'Боја иконице активности за ”Садржај”';
$string['activityiconcolorcontentsetting_desc'] = 'Боја иконице активности за ”Садржај”';
$string['activityiconcolorinterfacesetting'] = 'Боја иконице активности за ”Интерфејс”';
$string['activityiconcolorinterfacesetting_desc'] = 'Боја иконице активности за ”Интерфејс”';
$string['activityiconcolorsheading'] = 'Боје иконица активности';
$string['activitynavigationsetting'] = 'Елементи навигације кроз активности';
$string['activitynavigationsetting_desc'] = 'Са овим подешавање елементи за прелазак на претходну и следећу активност/ресурс, као и падајући мени за прелазак на одређену активност/ресурс ће бити приказани. Овакви елементи корисничког интерфејса су већ постојали у Boost теми у основној инсталацији Moodlea све до верзије Moodle 3.11, али су уклоњени у верзији 4.0. Са темом Boost Union, можете вратити ове елементе.';
$string['activitypurposeadministration'] = 'Администрација';
$string['activitypurposeassessment'] = 'Процена';
$string['activitypurposecollaboration'] = 'Сарадња';
$string['activitypurposecommunication'] = 'Комуникација';
$string['activitypurposecontent'] = 'Садржај';
$string['activitypurposeheading'] = 'Намена иконица активности';
$string['activitypurposeheading_desc'] = 'Са овим подешавањима, можете заменити боју позадине иконице активности која је дефинисана њеном наменом (боја је, иначе, дефинисана у самом кôду сваке активности).';
$string['activitypurposeheadingtechnote'] = 'Техничка напомена: због начина на који основна инсталација Moodlea имплементира намене активности и њихове боје, оне се могу изменити само путем CSS-a од стране Boost Union графичке теме. Тренутно, све области у Moodle основној инсталацији које приказују обојене иконице активности треба да буду покривене. Ако приметите било коју област или нестандардни додатак који наставља да приказује непромењене боје намене активности, пријавите на {$a}.';
$string['activitypurposeinterface'] = 'Интерфејс';
$string['activitypurposeother'] = 'Друго';
$string['additionalresourcesfileurlpersistent'] = 'URL адреса (трајна)';
$string['additionalresourcesfileurlrevisioned'] = 'URL адреса (ревидирана)';
$string['additionalresourcesheading'] = 'Додатни ресурси';
$string['additionalresourceslistsetting'] = 'Списак додатних ресурса';
$string['additionalresourceslistsetting_desc'] = 'Ово је списак датотека које сте поставили у поље за датотеке додатних ресурса. Наведене URL адресе се могу користити како бисте линкове као овим датотекама употребили у свом прилагођеном CSS опису стилова, у фусноти или где год је потребно да користите постављене датотеке, а где директно постављање датотека није могуће.';
$string['additionalresourcessetting'] = 'Додатни ресурси';
$string['additionalresourcessetting_desc'] = 'Са овим подешавањем можете да поставите додатне ресурсе у тему. Предност постављање датотека у ову поље за датотека је у томе што се оне могу испоручити без провере да ли је корисник пријављен. То је и разлог зашто треба да додајете само датотеке које нису критичне. Свима треба да буде дозвољен приступ који  не треба да буде заштићен валидном пријавом. Чим поставите барем једну датотеку у овај простор за датотеке и сачувате подешавања, у наставку ове странице ће се појавити списак који ће вам дати URL адресу коју можете користити за повезивање са одговарајућом датотеком.';
$string['addpreferredlangsetting'] = 'Додајте у језички мени линк за преферирани језик';
$string['addpreferredlangsetting_desc'] = 'Помоћу овог подешавања можете да додате подешавање \'Подеси преферирани језик\' у језички мени у оквиру корисничког менија. Разумљиво, ово подешавање се обрађује само ако је подешавање <a href="{$a->url1}">Прикажи језички мени</a> омогућено, и ако је барем <a href="{$a->url2}">инсталиран други језички пакет</a>, <a href="{$a->url3}">понуђен за избор</a>.';
$string['administrationtab'] = 'Администрација';
$string['allowaccessibilitysupportwithoutlogin'] = 'Дозволите приступ страници за подршку приступачности без пријаве на систем';
$string['allowaccessibilitysupportwithoutlogin_desc'] = 'Ако је ово подешавање омогућено, страница за подршку приступачности ће бити приказана и корисницима који нису пријављени. Ако је ово подешавање онемогућено, само ће корисницима, који су пријављени на систем, бити дозвољен приступ страници за подршку приступачности.';
$string['allowanonymoussubmitssetting'] = 'Омогућите слање повратних информација о приступачности';
$string['allowanonymoussubmitssetting_desc'] = 'Помоћу овог подешавања можете дозволити кориснику да анонимно пошаље повратне информације о приступачности преко странице за подршку приступачности. Корисници тада могу одлучити да ли желе да пошаљу повратне информације анонимно (без слања корисничког имена и адресе е-поште) или не.';
$string['allowsendtechinfoalongsetting'] = 'Дозволите слање техничких информација';
$string['allowsendtechinfoalongsetting_desc'] = 'Помоћу овог подешавања можете дозволити кориснику да шаље техничке информације на страници за подршку приступачности. Корисници тада могу одлучити да ли желе да пошаљу техничке информације или не.';
$string['alternativelogolinkurlsetting'] = 'Алтернативна URL адреса/линк логотипа';
$string['alternativelogolinkurlsetting_desc'] = 'Са овим подешавањем, можете поставити алтернативну URL адресу која ће се користити као линк логотипа у навигационој траци. Можете да користите ово подешавање како бисте, на пример, повезали лого са веб сајтом ваше институције уместо са насловном страницом Moodlea. На тај начин бисте имали уједначену навигацију на свим сајтовима ваше институције.';
$string['always'] = 'Увек';
$string['backgroundimagepositionsetting'] = 'Позиција позадинске слике';
$string['backgroundimagepositionsetting_desc'] = 'Са овим подешавањем контролишете позиционирање позадинске слике унутар прозора веб читача. Прва вредност је хоризонтални, друга вертикални положај.';
$string['backgroundimagesetting'] = 'Позадинска слика';
$string['backgroundimagesetting_desc'] = 'Овде можете да поставите прилагођену слику која ће бити приказана као позадина сајта. Позадинска слика коју овде поставите ће заменити позадинску слику у вашим датотекама  са предефинисаним подешавањима теме.';
$string['backgroundimagesheading'] = 'Опште позадинске слике';
$string['backtotop'] = 'Повратак на врх';
$string['backtotopbuttonsetting'] = 'Дугме \'Повратак на врх\'';
$string['backtotopbuttonsetting_desc'] = 'Са овим подешавањем, дугме за повратак на врх ће се појавити у доњем десном углу странице чим корисник скролује страницу надоле. Овакво дугме је већ постојало у Boost графичкој теми у Moodle основној инсталацији све до верзије Moodle 3.11, али је уклоњено у верзији 4.0. Са темом Boost Union, можете повратити ово дугме.';
$string['blockdrawerwidthsetting'] = 'Ширина фиоке са блоковима';
$string['blockdrawerwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину фиоке са блоковима без ручних модификација SCSS стилова. Стандардно, Moodle користи средњу максималну ширину од 315 пиксела. Можете унети и друге вредности, које се такође изражавају у пикселима, као што је нпр. 400 пиксела, али и вредности у другим јединицама, као што су проценти, или вредност за viewport-width неће функционисати.';
$string['blockregionfooterwidth'] = 'Ширина региона блокова за регион \'Подножје\'.';
$string['blockregionfooterwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Подножје\'. Можете бирати између пуне ширине, ширине садржаја курса и ширине читавог екрана.';
$string['blockregionoutsidebottomwidth'] = 'Ширина региона блокова за регион \'Споља (доле)\'.';
$string['blockregionoutsidebottomwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (доле)\' који се приказује испод главног садржаја. Можете бирати између пуне ширине, ширине садржаја курса и ширине читавог екрана.';
$string['blockregionoutsideleftwidth'] = 'Ширина региона блокова за регион \'Споља (лево)\'.';
$string['blockregionoutsideleftwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (лево)\'. који се приказају лево од главног садржаја. Подразумевано, Boost Union користи ширину од 300 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 10% или вредност ширине оквира за приказ (viewport) као што је 10vw.';
$string['blockregionoutsiderightwidth'] = 'Ширина региона блокова за регион \'Споља (десно)\'.';
$string['blockregionoutsiderightwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (десно)\'. који се приказају десно од главног садржаја. Подразумевано, Boost Union користи ширину од 300 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 10% или вредност ширине оквира за приказ (viewport) као што је 10vw.';
$string['blockregionoutsidetopwidth'] = 'Ширина региона блокова за регион \'Споља (горе)\'.';
$string['blockregionoutsidetopwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (горе)\' који се приказује на самом врху странице. Можете бирати између пуне ширине, ширине садржаја курса и ширине читавог екрана.';
$string['blockregionsforlayout'] = 'Додатни региони блокова за страницу типа \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Са овим подешавањем можете да омогућите додатне регионе блокова за страницу типа \'{$a}\'';
$string['blockregionsheading'] = 'Додатни региони блокова';
$string['blockregionsheading_desc'] = '<p>Boost Union пружа велики број додатних региона за блокове који се могу користити за додавање и приказивање блокова на читавој Moodle страници:</p>
<ul><li><em>Спољни региони блокова</em> постављени су на све четири стране Moodle странице. Могу се користити за приказивање блокова који прате приказану Moodle страницу, али директно не припадају главном садржају.</li>
<li><em>Регион блокова заглавља</em> се налази између региона Споља (горе) и главног садржаја странице. Може се користити за приказивање блока као информације у заглављу курса.</li>
<li><em>Региони блокова садржаја</em> се постављају директно изнад и испод главног садржаја у региону главног садржаја. Могу се користити за додавање блокова у сам ток садржаја курса.</li>
<li><em>Региони блокова подножја</em> налазе се на дну странице између региона Споља (доле) и фусноте. Имате на располагању три региона подножја за прављење стубаца са блоковима ако је потребно.</li>
<li>The <em>Регион блокова ”Ван странице”</em> је нека врста  специјалног региона јер се приказује преко целе Moodle странице као фиока. Фиока се отвара помоћу специјалне иконице од 9 тачака (три реда са по три тачкице) смештене у самом горњем десном углу навигационе траке. На располагању су вам три оваква региона за креирање стубаца са блоковима уколико је то потребно</li></ul>
<p>Молимо вас да обратите пажњу:</p>
<ul><li>Стандардно, сви додатни региони блокова су онемогућени. Омогућите поједине регионе блокова на одређеним врстама страница у складу са својим потребама. Покушајте да будете што је могуће више фокусирани – превише региона блокова може довести до непотребне дистракције крајњих корисника.</li>
<li>Чим се омогући додатни регион блокова, он постаје видљив свим ауторизованим корисницима, а могу га уређивати предавачи и менаџери (наравно, у зависности од чињенице да ли је одређеном кориснику дозвољено да уређује одређену Moodle страницу). Али постоје и могућности  theme/learnr:viewregion* и theme/learnr:editregion* који вам омогућавају да фино подесите употребу сваког региона са блоковима зависно од ваших потреба.</li>
<li>Региони блокова Споља (лево), Споља (десно), Садржај (горњи), Садржај (доњи) и Заглавље нису доступни за све врсте страница.</li></ul>';
$string['blockregionsheading_experimental'] = 'Имајте на уму: <em>региони блокова Споља (лево) и Споља (десно) </em> у потпуности функционишу у тренутном стању имплементације, али се морају <em>сматрати као експериментални</em> пошто се још увек не приказују правилно на екранима средње ширине. Имајући ово у виду, користите их пажљиво. Овај проблем ће бити решен у наредној верзији графичке теме.';
$string['blocksgeneralheading'] = 'Општи блокови';
$string['blockstab'] = 'Блокови';
$string['boost_union:configure'] = 'Способност да се тема конфигуриша као не-администратор';
$string['boost_union:editregioncontentlower'] = 'Способност да се уређује регион блокова Садржај (доњи)';
$string['boost_union:editregioncontentupper'] = 'Способност да се уређује регион блокова Садржај (горњи)';
$string['boost_union:editregionfootercenter'] = 'Способност да се уреди регион блокова Подножје (центар)';
$string['boost_union:editregionfooterleft'] = 'Способност да се уреди регион блокова Подножје (лево)';
$string['boost_union:editregionfooterright'] = 'Способност да се уреди регион блокова Подножје (десно)';
$string['boost_union:editregionheader'] = 'Способност да се уреди региона блокова Заглавља';
$string['boost_union:editregionoffcanvascenter'] = 'Способност да се уреди регион блокова Ван-странице (центар)';
$string['boost_union:editregionoffcanvasleft'] = 'Способност да се уреди регион блокова Ван-странице (десно)';
$string['boost_union:editregionoffcanvasright'] = 'Способност да се уреди регион блокова Ван-странице (десно)';
$string['boost_union:editregionoutsidebottom'] = 'Способност да се уреди регион блокова Споља (доле)';
$string['boost_union:editregionoutsideleft'] = 'Способност да се уреди регион блокова Споља (лево)';
$string['boost_union:editregionoutsideright'] = 'Способност да се уреди регион блокова Споља (десно)';
$string['boost_union:editregionoutsidetop'] = 'Способност да се уреди регион блокова Споља (горе)';
$string['boost_union:viewhintcourseselfenrol'] = 'Способност да се види савет за неограничени самостални упис на видљивим курсевима.';
$string['boost_union:viewhintinhiddencourse'] = 'Способност да се види савет у сакривеним активностима';
$string['boost_union:viewregioncontentlower'] = 'Способност да се види регион блокова Садржај (доњи)';
$string['boost_union:viewregioncontentupper'] = 'Способност да се види регион блокова Садржај (горњи)';
$string['boost_union:viewregionfootercenter'] = 'Способност да се види регион блокова Подножје (центар)';
$string['boost_union:viewregionfooterleft'] = 'Способност да се види регион блокова Подножје (лево)';
$string['boost_union:viewregionfooterright'] = 'Способност да се види регион блокова Подножје (десно)';
$string['boost_union:viewregionheader'] = 'Способност да се види регион блокова Заглавље';
$string['boost_union:viewregionoffcanvascenter'] = 'Способност да се види регион блокова Ван-странице (центар)';
$string['boost_union:viewregionoffcanvasleft'] = 'Способност да се види регион блокова Ван-странице (лево)';
$string['boost_union:viewregionoffcanvasright'] = 'Способност да се види регион блокова Ван-странице (десно)';
$string['boost_union:viewregionoutsidebottom'] = 'Способност да се види регион блокова Споља (доле)';
$string['boost_union:viewregionoutsideleft'] = 'Способност да се види регион блокова Споља (лево)';
$string['boost_union:viewregionoutsideright'] = 'Способност да се види регион блокова Споља (десно)';
$string['boost_union:viewregionoutsidetop'] = 'Способност да се види регион блокова Споља (горе)';
$string['bootstrapcolordangersetting'] = 'Bootstrap боја за "Опасност"';
$string['bootstrapcolordangersetting_desc'] = 'Bootstrap боја за "Опасност"';
$string['bootstrapcolorinfosetting'] = 'Bootstrap боја за "Инфо"';
$string['bootstrapcolorinfosetting_desc'] = 'Bootstrap боја за "Инфо"';
$string['bootstrapcolorsheading'] = 'Bootstrap боје';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap боја за "Успех"';
$string['bootstrapcolorsuccesssetting_desc'] = 'Bootstrap боја за "Успех"';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap боја за "Упозорење"';
$string['bootstrapcolorwarningsetting_desc'] = 'Bootstrap боја за "Упозорење"';
$string['bootstrapdangercolor'] = 'Боја опасности';
$string['bootstrapdarkcolor'] = 'Тамна боја';
$string['bootstrapinfocolor'] = 'Инфо боја';
$string['bootstraplightcolor'] = 'Светла боја';
$string['bootstrapnone'] = 'Без Bootstrap боје';
$string['bootstrapprimarycolor'] = 'Примарна боја';
$string['bootstrapsecondarycolor'] = 'Секундарна боја';
$string['bootstrapsuccesscolor'] = 'Боја успеха';
$string['bootstrapwarningcolor'] = 'Боја упозорења';
$string['brandcolorsheading'] = 'Боје бренда';
$string['breadcrumbsheading'] = 'Навигација са путањом';
$string['cachedef_flavours'] = 'Визуелни идентитети који се примењују на дату ID ознаку категорије странице за тренутног корисника';
$string['cachedef_smartmenu_items'] = 'Ставке у паметном менију';
$string['cachedef_smartmenus'] = 'Паметни менији';
$string['cachedef_touchiconsios'] = 'Датотека иконица осетљивих на додир за iOS';
$string['categorybreadcrumbs'] = 'Прикажите категорију у навигационој путањи у заглављу курса';
$string['categorybreadcrumbs_desc'] = 'Стандарно, категорије курсева се не приказују као чворови у навигационој траци у заглављу курса. Са овим подешавањем, можете приказати категорију курса у навигационој траци изнад назива курса.';
$string['choosereadme'] = '<p>Графичка тема Boost Union представља унапређену верзију изворне Boost теме која има за циљ, с једне стране, да учини Boost тему једноставнијом за подешавање, а са друге стране, да пружи администраторима, предавачима и полазницима корисне додатне функције за свакодневни рад у Moodleu администратора, наставника и ученика.</p><p>Boost Union одржава<br />Moodle an Hochschulen e.V.,</p><p>у сарадњи са<br />lern.link GmbH</p><p>заједно са<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Затвори фиоку ”Ван странице”';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Приступачност';
$string['configtitlecontent'] = 'Садржај';
$string['configtitlefeel'] = 'Навигација & Блокови';
$string['configtitleflavours'] = 'Визуелни идентитети';
$string['configtitlefunctionality'] = 'Функционалност';
$string['configtitlelook'] = 'Изглед';
$string['contactcontentsetting'] = 'Садржај странице за контакт';
$string['contactcontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници за (што није исто што и стандардна Moodle страница \'Контактирајте подршку сајта\').';
$string['contactdisabled'] = 'Страница за контакт је онемогућена на овом сајту. Овде нема шта да се види.';
$string['contactheading'] = 'Контакт';
$string['contactlinkpositionboth'] = 'Додајте линк ка страници за контакт у фусноту и на иконицу у подножју странице (знак питања)';
$string['contactlinkpositionfooter'] = 'Додајте линк ка страници за контакт на иконицу у подножју странице (знак питања)';
$string['contactlinkpositionfootnote'] = 'Додајте линк ка страници за контакт у фусноту';
$string['contactlinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници за контакт';
$string['contactlinkpositionsetting'] = 'Позиција линк ка страници за контакт';
$string['contactlinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници за контакт аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['contactpagetitledefault'] = 'Контакт';
$string['contactpagetitlesetting'] = 'Наслов странице за контакт';
$string['contactpagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице за контакт. Овај текст ће се такође користити као текст линка ка страници за контакт ако у складу са тим конфигуришете подешавање \'Позиција линка ка страници за контакт\'.';
$string['contentwidthheading'] = 'Ширина садржаја';
$string['coursecontentmaxwidthsetting'] = 'Максимална ширина садржаја курса';
$string['coursecontentmaxwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину садржаја Moodle курса без ручних модификација SCSS стилова. Ова ширина се користи као ширина странице на страницама курса и у оквиру неколико активности. Стандардно, Moodle користи максималну ширину садржаја курса од 830 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 1200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 100% или вредност ширине оквира за приказ (viewport) као што је 90vw.';
$string['courseheaderheading'] = 'Заглавље курса';
$string['courseheaderimageenabled'] = 'Прикажите слику курса у заглављу курса';
$string['courseheaderimageenabled_desc'] = 'Када је омогућена ова опција, слика курса (која се може поставити у подешавањима курса) је приказана, како у заглављу курса, исто тако и на страници \'Моји курсеви\' где су увек слике курсева и приказају.';
$string['courseheaderimagefallback'] = 'Резервна слика заглавља курса';
$string['courseheaderimagefallback_desc'] = 'Ако поставите слику у овом подешавању, она ће се користи као резервна слика и биће приказана се у заглављу курса ако слика курса није постављена у подешавањима неког курса. Ако пак овде не поставите слику, слика заглавља курса ће бити приказана само у одређеном курсу уколико је слика курса учитана у подешавањима овог конкретног курса.';
$string['courseheaderimageheight'] = 'Висина слике заглавља курса';
$string['courseheaderimageheight_desc'] = 'Са овим подешавањем контролишете висину приказане слике заглавља курса.';
$string['courseheaderimagelayout'] = 'Изглед слике заглавља курса';
$string['courseheaderimagelayout_desc'] = 'Са овим подешавањем контролишете изглед слике заглавља курса и наслова курса.';
$string['courseheaderimagelayoutheadingabove'] = 'Наслов курса изнад слике курса';
$string['courseheaderimagelayoutstackeddark'] = 'Наслов курса преко слике курса (бела боја фонта за тамне позадинске слике)';
$string['courseheaderimagelayoutstackedlight'] = 'Наслов курса преко слике курса (црна боја фонта за светле позадинске слике)';
$string['courseheaderimageposition'] = 'Позиција слике заглавља курса';
$string['courseheaderimageposition_desc'] = 'Са овим подешавањем контролишете позиционирање слике унутар контејнера слике заглавља курса. Прва вредност је хоризонтални а друга вертикални положај.';
$string['courseindexcompletioninfoposition'] = 'Позиција индикатора завршетка активности';
$string['courseindexcompletioninfoposition_desc'] = 'Изаберите позицију на којој ће бити приказан индикатор завршетка активности. <em>Крај реда</em> приказује стандардни индикатор завршетка на крају реда у индексу курса (тј. на крају назива активности чији се завршетак прати). <em>Почетак реда</em> приказује стандардни индикатор завршетка на  почетку реда у индексу курса (тј. пре назива активности чији се завршетак прати). <em>Боја иконице</em> не приказује стандардни индикатор завршетка, али кодира информације о завршетку као позадину иконице модула курса.';
$string['courseindexcompletioninfopositionendofline'] = 'Крај реда';
$string['courseindexcompletioninfopositioniconcolor'] = 'Боја иконице';
$string['courseindexcompletioninfopositionstartofline'] = 'Почетак реда';
$string['courseindexdrawerwidthsetting'] = 'Ширина фиоке са индексом курса';
$string['courseindexdrawerwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину фиоке са индексом курса без ручних модификација SCSS стилова. Стандардно, Moodle користи ширину фиоке са индексом курса од 285 пиксела. Можете унети и друге вредности, које се такође изражавају у пикселима, као што је 320 пиксела, али и вредности у другим јединицама, као што су проценти, или вредност за viewport-width неће функционисати.';
$string['courseindexheading'] = 'Индекс курса';
$string['courseindexmodiconenabled'] = 'Прикажите иконице типа активности у индексу курса';
$string['courseindexmodiconenabled_desc'] = 'Када је ова опција омогућено, одговарајућа иконица типа активности се приказује на почетку реда у индексу курса са насловом активности. При томе, тип активности или замењује индикатор завршетка који се помера са почетка на крај реда у индексу курса, или је обојен бојом статуса завршетка.';
$string['coursemanagementheading'] = 'Управљање курсом';
$string['courseoverviewheading'] = 'Блок - Преглед курсева';
$string['courseoverviewshowcourseimagessetting'] = 'Прикажи слике курса';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Са овим подешавањем можете да контролишете да ли је слика курса видљива унутар блока за преглед курсева или није. Могуће је изабрати другачије подешавање за картични приказ, приказ резимеа и приказ списка.';
$string['courseoverviewshowprogresssetting'] = 'Прикажите напредак у завршетку курса';
$string['courseoverviewshowprogresssetting_desc'] = 'Са овим подешавањем можете да контролишете да ли је напредак у завршетку курса видљиво унутар блока ѕа преглед курсева или није';
$string['courserelatedhintsheading'] = 'Савети везани за курс';
$string['coursestab'] = 'Курсеви';
$string['coursetab'] = 'Курс';
$string['cssh5pheading'] = 'Необрађени CSS за H5P';
$string['cssh5psetting'] = 'Необрађени CSS за H5P';
$string['cssh5psetting_desc'] = 'Користите ово поље како бисте навели CSS кôд који ће модули mod_h5p и mod_hvp применити на приказ H5P садржаја. Прегледајте H5P типове садржаја како бисте пронашли потребне CSS селекторе.';
$string['customfontsfileurlpersistent'] = 'URL адреса (трајна)';
$string['customfontsfileurlrevisioned'] = 'URL адреса (ревидирана)';
$string['customfontsheading'] = 'Прилагођени фонтови';
$string['customfontslistsetting'] = 'Списак прилагођених фонтова';
$string['customfontslistsetting_desc'] = 'Ово је списак фонтова које сте поставили у простор за датотеке прилагођених фонтова. Дати CSS одломци кôда се могу користити за додавање ових фонтова у ваш прилагођени SCSS. Имајте на уму да ћете за сада морати сами да водите рачуна о вредности формата фонта, као и о CSS својствима породице фонтова, стила фонта и тежине фонта јер Boost Union још увек није у стању да анализира синтаксу датотеке фонтова.';
$string['customfontssetting'] = 'Прилагођени фонтови';
$string['customfontssetting_desc'] = 'Са овим подешавањем можете да поставите прилагођене фонтове у тему. Предност постављања фонтова у овај простор за датотеке је у томе што се ти фонтови могу испоручити без провере да ли је корисник пријављен и могу се користити као локално инсталирани фонтови свуда на сајту. Чим поставите барем један фонт у овај простор за датотека и сачувате подешавања, испод ће се појавити списак која ће вам дати CSS одломке кôда које можете користити као шаблон за референцирање одређених фонтова у вашем прилагођеном SCSS-у.';
$string['dashboardtab'] = 'Контролни панел / Моји курсеви';
$string['dontchange'] = 'Не мењајте ништа';
$string['drawerwidthheading'] = 'Ширина фиоке';
$string['emailbrandinghtmldemobody'] = '<p>Тело е-поруке почиње овде.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Тело е-поруке се завршава овде.</p>';
$string['emailbrandinghtmlheading'] = 'Преглед е-поруке у HTML формату';
$string['emailbrandinghtmlintro'] = 'Ово је преглед е-поште у HTML формату заснован на префиксима и суфиксима брендирања који су тренутно подешени у језичком пакету.';
$string['emailbrandinghtmlnopreview'] = 'До сада, е-поруке у HTML формату нису биле прилагођаване у оквиру ове функције. Е-поруке ће бити састављане и слате уобичајено.';
$string['emailbrandinginstruction'] = 'Како да';
$string['emailbrandinginstruction0'] = 'Са овом Boost Union функцијом, можете применити брендирање на сву е-пошту коју Moodle шаље.';
$string['emailbrandinginstructionli1'] = 'Идите на <a href="{$a->url}" target="_blank">страницу за прилагођавања језика</а> како бисте отворили <em>{$a->lang}</em> језички пакет за уређивање.';
$string['emailbrandinginstructionli2'] = 'Потражите и измените ове стрингове у <code>theme_boost_union</code> језичком пакету:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Овај исечак кôда ће бити додат <em>на почетак / пре тела</em> свих <em>е-порука у HTML формату</em> које Moodle шаље.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Овај исечак кôда ће бити додат   <em>на крај / након тела</em> свих <em>е-порука у HTML формату</em> које Moodle шаље.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Овај исечак кôда ће бити додат <em>на почетак / пре тела</em> свих <em> е-порука у формату обичног текста </em> које Moodle шаље.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Овај исечак кôда ће бити додат <em>на крај / након тела</em> свих <em> е-порука у формату обичног текста</em> које Moodle шаље.';
$string['emailbrandinginstructionli3'] = 'Сачувајте промене језичког пакета.';
$string['emailbrandinginstructionli4'] = 'Вратите се на ову страницу и погледајте прегледе е-поште у наставку ове странице.';
$string['emailbrandingintroheading'] = 'Увод';
$string['emailbrandingintronote'] = 'Имајте на уму: ово је напредна функционалност која користи нека заобилазна решења како би се обезбедиле опција за брендирање е-поште. Молимо вас да пажљиво пратите упутства.';
$string['emailbrandingpitfalls'] = 'Замке';
$string['emailbrandingpitfalls0'] = 'Користећи ову функцију, постоје неке замке којих бисте требали бити свесни:';
$string['emailbrandingpitfallsli1'] = 'Обавезно је да измените стрингове језичког пакета <em>тренутног подразумеваног језика</em> на овом сајту. Чак и ако имате инсталирано више језичких пакета, само ће промене подразумеваног језика имати ефекта.';
$string['emailbrandingpitfallsli2'] = 'Уважавање језика примаоца није могуће. Због тога, требало би да користите језички неутралне термине у оквиру исечака за брендирања е-поште.';
$string['emailbrandingpitfallsli3'] = 'Ако икада промените подразумевани језик сајта у будућности, мораћете да мигрирате измењене стрингове језичког пакета у нови подразумевани језички пакет.';
$string['emailbrandingpitfallsli4'] = 'Код е-порука у формату обичног текста, постоји прелом реда и празан ред који се аутоматски додаје после префикса, као и празан ред који се аутоматски додаје испред исечка кôда суфикса. Ово је због тога да би се осигурало да се суфикс и префикс не лепе директно на тело е-поште.';
$string['emailbrandingpitfallsli5'] = 'У е-порукама у HTML формату, префикс и суфикс се директно додају испред и изнад тела е-поруке. Ово је због тога како би се обезбедило да можете лако да радите са HTML ознакама. Међутим, мораћете сами да водите рачуна о свим размацима око тела поруке.';
$string['emailbrandingpitfallsli6'] = 'У е-порукама у HTML формату, можете отворити HTML ознаку у исечку кôда префикса, и без проблема затворите  HTML ознаку у исечку кôда суфикса. Само водите рачуна да креирате исправан HTML.';
$string['emailbrandingtab'] = 'Брендирање е-поште';
$string['emailbrandingtextdemobody'] = 'Тело е-поруке почиње овде.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Тело е-поруке се завршава овде.';
$string['emailbrandingtextheading'] = 'Преглед е-поруке у формату обичног текста';
$string['emailbrandingtextintro'] = 'Ово је преглед е-поруке у формату обичног текста, креиране на основу брендирајућих префикса и суфикса, која је тренутно подешена у језичком пакету.';
$string['emailbrandingtextnopreview'] = 'До сада, е-поруке у формату обичног текста текста нису били прилагођени у оквиру ове функције. Е-поруке ће бити састављане и слате нормално.';
$string['enableaboutussetting'] = 'Омогући страницу \'О нама\'';
$string['enableaccessibilitydeclarationsetting'] = 'Омогућите страницу са декларацијом о приступачности';
$string['enableaccessibilitydeclarationsetting_desc'] = 'Помоћу овог подешавања можете да омогућите страницу са декларацијом о приступачности. Понашаће се баш као <a href="{$a->url}">друге статичне странице</a> у теми Boost Union.';
$string['enableaccessibilitysupportfooterbuttonsetting'] = 'Омогућите дугме у подножју за приступ страници за подршку приступачности';
$string['enableaccessibilitysupportfooterbuttonsetting_desc'] = 'Помоћу овог подешавања можете да додате линк ка страници за подршку приступачности као плутајућу иконицу за приступачност изнад иконице у подножју странице (знак питања).';
$string['enableaccessibilitysupportsetting'] = 'Омогућите страницу за подршку приступачности';
$string['enableaccessibilitysupportsetting_desc'] = 'Помоћу овог подешавања можете да омогућите страницу за подршку приступачности. Понашаће се баш као <a href="{$a->url}">Moodle основна страница за подршку</a> у теми Boost Union.';
$string['enablecontactsetting'] = 'Омогући страницу за контакт';
$string['enablefooterbutton'] = 'Омогући ”подножје странице”';
$string['enablefooterbuttonboth'] = 'Омогући на стоном рачунару, таблету и мобилном телефону';
$string['enablefooterbuttondesktop'] = 'Омогући само на стоном рачунару и таблету, сакриј на мобилном телефону (непромењено, као у иницијалној Moodle инсталација)';
$string['enablefooterbuttonhidden'] = 'Сакриј на свим уређајима';
$string['enablefooterbuttonmobile'] = 'Омогући само на мобилном телефону, сакриј на стоном рачунару и таблету';
$string['enablehelpsetting'] = 'Омогући страницу за помоћ';
$string['enableimprintsetting'] = 'Омогући импресум';
$string['enablemaintenancesetting'] = 'Омогући страницу са информацијама о одржавању';
$string['enableofferssetting'] = 'Омогући страницу са понудама';
$string['enablepage1setting'] = 'Омогући генеричку страницу 1';
$string['enablepage2setting'] = 'Омогући генеричку страницу 2';
$string['enablepage3setting'] = 'Омогући генеричку страницу 3';
$string['error:infobannerdismissnonotdismissible'] = 'Дати инфо банер се не може одбацити';
$string['error:infobannerdismissnonotvalid'] = 'Наведени број инфо банера није исправан';
$string['error:smartmenusmenuitemnotfound'] = 'Ставка у паметном менију није пронађена';
$string['error:smartmenusmenunotfound'] = 'Паметни мени није пронађен';
$string['extscssgithubfilepath_example'] = 'Пример: ако можете да видите датотеку на свом Github налогу на https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/master/extscss.scss, путања датотеке ће бити <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Путања екстерне Post SCSS Github датотеке';
$string['extscssgithubpostfilepath_desc'] = 'Путања унутар приватног Github репозиторијума где се налази Post SCSS датотека.';
$string['extscssgithubprefilepath'] = 'Путања екстерне Pre SCSS Github датотеке';
$string['extscssgithubprefilepath_desc'] = 'Путања унутар приватног Github репозиторијума где се налази Pre SCSS датотека.';
$string['extscssgithubrepo'] = 'Екстерни SCSS Github API репозиторијум';
$string['extscssgithubrepo_desc'] = 'Приватни Github репозиторијум где се наалзе SCSS датотеке';
$string['extscssgithubrepo_example'] = 'Пример: ако можете да видите датотеку на свом Github налогу на https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/master/extscss.scss, репозиторијумће бити <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'Екстерни SCSS Github API токен';
$string['extscssgithubtoken_desc'] = 'Github API токен који ће се користити за преузимање SCSS кôда из датог приватног Github репозиторијума.';
$string['extscssgithubtoken_docs'] = 'Идите на <a href="https://github.com/settings/tokens">подешавања Github токена</а> како бисте генерисали API токен и видели званичну документацију.';
$string['extscssgithubuser'] = 'Екстерни корисник SCSS Github API-ја';
$string['extscssgithubuser_desc'] = 'Корисник Github API-ја или организација која поседује приватнои Github репозиторијум.';
$string['extscssgithubuser_example'] = 'Пример: ако можете да видите датотеку на свом Github налогу на https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/master/extscss.scss, корисник ће бити <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'Екстерни SCSS';
$string['extscssheading_desc'] = 'Поред горе наведених подешавања необрађеног SCSS-а, Boost Union може учитати SCSS из екстерног извора. Укључен је пре SCSS кода који је горе дефинисан што значи да можете управљати централизованом екстерном SCSS библиотеком и још увек је можете мењати локалним SCSS додацима.';
$string['extscssheading_drop'] = 'Ако Boost Union не може да преузме екстерну SCSS датотеку из било ког разлога или ако је преузети екстерни SCSS кôд неисправан, тема ће једноставно игнорисати екстерну SCSS датотеку како би се избегли сви потенцијални проблеми.';
$string['extscssheading_instr'] = 'Упутства:';
$string['extscssheading_prepost'] = 'Баш као и горња подешавања необрађеног SCSS-а, екстерни SCSS је подељен на два дела: Pre и Post SCSS. Pre SCSS може се користити за иницијализацију SCSS променљивих, Post SCSS се користи за ваш тренутни SCSS кôд.';
$string['extscssheading_sources'] = 'Можете да конфигуришете Boost Union да преузима екстерну SCSS датотеку или са јавне URL адресу за преузимање (којој ће се приступити и преузети помоћу cURL захтева без аутентификације) или из приватног Github репозиторијум (коме ће се приступати и датотека преузети помоћу Github API токена).';
$string['extscssheading_structure'] = 'Екстерни SCSS мора бити у формату датотеке обичног текста, без икаквих заглавља или подножја, која садржи само SCSS кôд.';
$string['extscssheading_task'] = 'Постоји <a href="{$a}">планирани задатак theme_boost_union\\task\\purge_cache</a> који је стандардно онемогућен, али који можете да омогућите ако желите да Boost Union повремено преузима и компајлира екстерни SCSS код.';
$string['extscsssource'] = 'Екстерни SCSS извор';
$string['extscsssource_desc'] = 'Изаберите тип извора одакле желите да преузмете екстерни SCSS.';
$string['extscsssourcedownload'] = 'Јавна URL адреса за преузимање';
$string['extscsssourcegithub'] = 'Приватни Github репозиторијум';
$string['extscsssourcenone'] = 'Ниједан';
$string['extscssurlpost'] = 'URL адреса за преузимање екстерне Post SCSS датотеке';
$string['extscssurlpost_desc'] = 'Јавна URL адреса за преузимање са које треба преузети екстерну Post SCSS датотеку';
$string['extscssurlpre'] = 'URL адреса за преузимање екстерне Pre SCSS датотеке';
$string['extscssurlpre_desc'] = 'Јавна URL адреса за преузимање са које треба преузети екстерну Pre SCSS датотеку';
$string['extscssvalidationsetting'] = 'Валидација екстерног SCSS кôда';
$string['extscssvalidationsetting_desc'] = 'Ако је овo подeшавање омогућенo, проверава се исправност екстерног SCSS кôда тј. да ли се исти може компајлирати пре него што буде додат у SCSS стек. Екстерни SCSS кôд који не може да се компајлира прећутно ће бити игнорисан и неће се користити. Ипак, провера исправности се изводи искључиво на екстерном SCSS кôду, тј. исправност се неће проверавати када се ради о комбинованом SCSS стеку који је резултат интеграције екстерног SCSS кôда. Другим речима, све док користите SCSS променљиве из основне Moodle инсталације или Bootstrapa у свом екстерном SCSS кôду, морате да искључите проверу исправности  и да се сами уверите да је SCSS кôд исправан.';
$string['faviconheading'] = 'Фавиконица';
$string['faviconheading_desc'] = 'Имајте на уму: Boost Union има сопствено поље за постављање фавиконице и не користи фавиконицу из <a href="{$a}">подешавања фавиконице основне инсталације Moodlea</a>.<br />Boost Union вам посебно омогућава да заобиђете постављену фавиконицу у оквиру његових визуелних идентитета .';
$string['faviconsetting'] = 'Фавиконица';
$string['faviconsetting_desc'] = 'Овде можете да поставите прилагођену слику (у .ico или .png формату) коју ће веб читач приказати као фавиконицу вашег Moodle сајта. Ако не поставите своју прилагођену фавиконицу, користиће се стандардна Moodle фавиконица.';
$string['flavoursactivityiconcoloradministration'] = 'Боја иконице активности за ”Администрација”';
$string['flavoursactivityiconcoloradministration_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју иконице активности "Администрација" која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursactivityiconcolorassessment'] = 'Боја иконице активности за ”Процена”';
$string['flavoursactivityiconcolorassessment_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју иконице активности "Процена" која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursactivityiconcolorcollaboration'] = 'Боја иконице активности за ”Сарадња”';
$string['flavoursactivityiconcolorcollaboration_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју иконице активности "Сарадња" која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursactivityiconcolorcommunication'] = 'Боја иконице активности за ”Комуникација”';
$string['flavoursactivityiconcolorcommunication_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју иконице активности "Комуникација" која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursactivityiconcolorcontent'] = 'Боја иконице активности за ”Садржај”';
$string['flavoursactivityiconcolorcontent_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју иконице активности "Садржај" која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursactivityiconcolorinteractivecontent'] = 'Боја иконице активности за "Интерактивни садржај"';
$string['flavoursactivityiconcolorinteractivecontent_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју иконице активности "Интерактивни садржај" која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursactivityiconcolorinterface'] = 'Боја иконице активности за ”Интерфејс”';
$string['flavoursactivityiconcolorinterface_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју иконице активности "Интерфејс" која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursappliesto'] = 'Примењује се на';
$string['flavoursapplytocategories'] = 'Примените на категорије курсева';
$string['flavoursapplytocategories_help'] = 'Овде дефинишете да ли овај визуелни идентитет треба применити на категорије курсева.';
$string['flavoursapplytocategories_ids'] = 'Категорије курсева';
$string['flavoursapplytocategories_ids_help'] = 'Овде дефинишете једну или више засебних категорија курсева на које треба применити овај визуелни идентитет. Чим се приказана Moodle страница налази унутар једне од конфигурисаних категорија курса, визуелни идентитет ће бити примењен.';
$string['flavoursapplytocohorts'] = 'Примените на кохорте';
$string['flavoursapplytocohorts_help'] = 'Овде дефинишете да ли овај визуелни идентитет треба применити на кохорте.';
$string['flavoursapplytocohorts_ids'] = 'Кохорте';
$string['flavoursapplytocohorts_ids_help'] = 'Овде дефинишете једну или више засебних кохорти на које треба применити овај визуелни идентитет. Чим је корисник члан једне од конфигурисаних кохорти, визуелни идентитет ће бити примењен.<br /><br />Имајте у виду да, ако дефинишете више од једне кохорте, нема потребе да корисник буде члан свих кохорти у исто време.<br /><br />Такође, имајте на уму да се у тренутном стању имплементације кохорте третирају као да су системске.';
$string['flavoursbackgroundimage'] = 'Позадинска слика';
$string['flavoursbackgroundimage_help'] = 'Са овим подешавањем визуелни идентитет ће заменити позадинску слику која је конфигурисана у подешавањима изгледа теме Boost Union.';
$string['flavoursbackgroundimageposition'] = 'Положај позадинске слике';
$string['flavoursbackgroundimageposition_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити положај позадинсke слике који је конфигурисан у подешавањима изгледа Boost Union теме.';
$string['flavoursbacktooverview'] = 'Назад на преглед визуелних идентитета';
$string['flavoursbootstrapcolordanger'] = 'Bootstrap боја за "Опасност"';
$string['flavoursbootstrapcolordanger_help'] = 'Са овим подешавањима визуелни идентитет ће заменити Bootstrap боју ”Опасност” која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursbootstrapcolorinfo'] = 'Bootstrap боја за "Инфо"';
$string['flavoursbootstrapcolorinfo_help'] = 'Са овим подешавањима визуелни идентитет ће заменити Bootstrap боју ”Инфо” која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursbootstrapcolorsuccess'] = 'Bootstrap боја за "Успех"';
$string['flavoursbootstrapcolorsuccess_help'] = 'Са овим подешавањима визуелни идентитет ће заменити Bootstrap боју ”Успех” која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursbootstrapcolorwarning'] = 'Bootstrap боја за "Упозорење"';
$string['flavoursbootstrapcolorwarning_help'] = 'Са овим подешавањима визуелни идентитет ће заменити Bootstrap боју ”упозорење” која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursbrandcolor'] = 'Боја бренда';
$string['flavoursbrandcolor_help'] = 'Са овим подешавањима визуелни идентитет ће заменити боју бренда која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavourscreateflavour'] = 'Креирај визуелни идентитет';
$string['flavourscustomscss'] = 'Необрађени SCSS';
$string['flavourscustomscss_help'] = 'Са овим подешавањем, можете написати прилагођени SCSS за визуелни идентитет. Он ће бити придодат CSS кôду који се шаље претраживачу чим се визуелни идентитет примени.';
$string['flavourscustomscsspre'] = 'Необрађени почетни SCSS';
$string['flavourscustomscsspre_help'] = 'Са овим подешавањем, можете написати прилагођени почетни SCSS за визуелни идентитет. Он ће се користити приликом креирања CSS кôда који се шаље претраживачу чим се визуелни идентитет примени.';
$string['flavoursdelete'] = 'Обриши';
$string['flavoursdeleteconfirmation'] = 'Да ли заиста желите да обришете визуелни идентитет <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Обриши визуелни идентитет';
$string['flavoursdescription'] = 'Опис';
$string['flavoursdescription_help'] = 'Опис визуелног идентитета користи се интерно само како би вам омогућио да идентификујете одређени визуелни идентитет на списку.';
$string['flavoursedit'] = 'Уреди';
$string['flavourseditflavour'] = 'Уреди визуелни идентитет';
$string['flavoursfavicon'] = 'Фавиконица';
$string['flavoursfavicon_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити фавиконицу која је конфигурисана у подешавањима изгледа Boost Union теме.';
$string['flavoursflavours'] = 'Визуелни идентитети';
$string['flavoursgeneralsettings'] = 'Општа подешавања';
$string['flavoursincludesubcategories'] = 'Укључите поткатегорије';
$string['flavoursincludesubcategories_help'] = 'Ако је означено, визуелни идентитет ће бити примењен и на поткатегорије изабраних категорија.';
$string['flavourslogo'] = 'Лого';
$string['flavourslogo_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити логотип који је конфигурисан у подешавањима изгледа теме Boost Union.';
$string['flavourslogocompact'] = 'Компактан лого';
$string['flavourslogocompact_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити логотип који је конфигурисан у подешавањима изгледа теме Boost Union.';
$string['flavoursnavbarcolor'] = 'Боја навигационе траке';
$string['flavoursnavbarcolor_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити боју навигационе траке која је конфигурисана у подешавањима изгледа теме Boost Union.';
$string['flavoursnothingtodisplay'] = 'Још увек није креиран ниједан визуелни идентитет. Молимо вас да направите свој први визуелни идентитет како бисте покренули ствари.';
$string['flavoursnotificationcreated'] = 'Визуелни идентитет је успешно креиран';
$string['flavoursnotificationdeleted'] = 'Визуелни идентитет је успешно обрисан';
$string['flavoursnotificationedited'] = 'Визуелни идентитет је успешно едитован';
$string['flavoursoverview_desc'] = '<p>Визуелни идентитети Boost Union тема нуде могућност да измените  поједина подешавања изгледа Moodlea у одређеним контекстима. На овој страници можете креирати визуелне идентитете и управљати њима.</p><p>Унутар сваког идентитета дефинишете да ли га треба применити на одређене категорије курсева или одређене кохорте. Након тога, током сваког приказивања Moodle странице, Boost Union проверава да ли је визуелни идентитет применљив. Имајте на уму да се за свако приказивање Moodle странице примењује само први одговарајући визуелни идентитет са списка, а преостали се занемарују. Стога је редослед визуелних идентитета на овој страници кључан.</p><p>Такође имајте на уму да се након сваке промене коју направите у скупу визуелних идентитета, кеш теме чисти. Ово је неопходно како бисте били сигурни да су веб читачу сва подешавања испоручена прописно и ажурно.</p>';
$string['flavourspreview'] = 'Преглед';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Преглед визуелног идентитета';
$string['flavourstitle'] = 'Наслов';
$string['flavourstitle_help'] = 'Назив визуелног идентитета се користи само интерно, како би вам омогућио да га документујете на списку визуелних идентитета.';
$string['fontawesomecheck-fa6free-fallback-description'] = 'Новије FontAwesome верзије користе идентификаторе старијих иконица како би их ремапирали на новије иконице (или, како би неке од њих одстранили). Ако видите мапу иконице хомогеног (солидног) изгледа на левој страни, ваша FontAwesome верзија 6 исправно приказује ремапиране иконице из FontAwesome верзије 4.';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'FontAwesome 6 иконице';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Ово је додатна CSS датотека која додаје фонт за FontAwesome бренд иконице на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Ово је главна CSS датотека која додаје све доступне FontAwesome глифове на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Ово је додатна CSS датотека која додаје фонт за FontAwesome обичне иконице на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Ово је додатна CSS датотека која додаје фонт за FontAwesome иконице хомогеног (солидног) изгледа на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Ово је CSS датотека која осигурава да се FontAwesome 4 иконице и даље правилно приказују у Moodleu.';
$string['footerheading'] = 'Подножје';
$string['footersuppresscontactsetting'] = 'Потисните линк \'Контактирајте подршку сајта\'';
$string['footersuppresscontactsetting_desc'] = 'Са овим подешавањем, можете у потпуности да спречите да се линк \'Контактирајте подршку сајта\' појављује у подножју странице. У супротном, он ће се појавити ако је подешен <a href="{$a->url}">линк \'Контактирајте подршку сајта\'</а>.';
$string['footersuppressfeedbacksetting'] = 'Потисните линк \'Пошаљите повратне информације о овом софтверу\'';
$string['footersuppressfeedbacksetting_desc'] = 'Са овим подешавањем, можете у потпуности да спречите да се линк \'Пошаљите повратне информације о овом софтверу\' појављује у подножју странице. У супротном, он ће се појавити ако је подешен <a href="{$a->url}">линк \'Пошаљите повратне информације о овом софтверу\'</а>.';
$string['footersuppressiconssetting'] = 'Спречите појаву иконица испред линкова у подножју странице';
$string['footersuppressiconssetting_desc'] = 'Са овим подешавање можете потпуно спречити да се у подножју странице појављују иконице испред линкова. Линк \'Документација за ову страницу\' има иконицуу књиге, док линк \'Сервиси и подршка\' има иконицу појаса за спасавање итд.';
$string['footersuppresslogininfosetting'] = 'Потисните информације о пријављеном кориснику';
$string['footersuppresslogininfosetting_desc'] = 'Са овим подешавањем, можете у потпуности да спречите да се информације о пријављеном кориснику појављује у подножју странице. У супротном, ове информације ће приказати линк ка корисниковом профилу и ка страници за одјаву.';
$string['footersuppresspoweredsetting'] = 'Потисните линк \'Покреће Moodle\'';
$string['footersuppresspoweredsetting_desc'] = 'Са овим подешавањем, можете у потпуности да спречите да се линк \'Покреће Moodle\' појављује у подножју странице. У супротном, он ће приказати информацију да овај сајт покреће Moodle, као и линк ка Moodle HQ.';
$string['footersuppressservicessetting'] = 'Потисните линк \'Сервиси и подршка\'';
$string['footersuppressservicessetting_desc'] = 'Са овим подешавањем, можете у потпуности да спречите да се линк \'Сервиси и подршка\' појављује у подножју странице. У супротном, администраторима ће бити приказан <a href="{$a->url}">линк \'Сервиси и подршка\'</а>.';
$string['footersuppressstandardfooter'] = 'Потисните испис у подножју од стране додатка \'{$a}\'';
$string['footersuppressstandardfooter_desc'] = 'Са овим подешавањем, можете у потпуности да спречите да се у подножју странице појављује испис додатка \'{$a}\' (чак и стандардни додаци, који су део основне Moodle инсталацији) могу приказати додатни садржај у подножје применом посебне функције. Овај додатак је имплементирао ову функцију и може додати садржај у подножје странице у одређеним околностима.';
$string['footersuppressthemeswitchsetting'] = 'Потисните линкове за промену графичке теме';
$string['footersuppressusertoursetting'] = 'Потисните линк \'Ресетујте кориснички водич на овој страници\'';
$string['footersuppressusertoursetting_desc'] = 'Са овим подешавањем, можете у потпуности да спречите да се линк \'Ресетујте кориснички водич на овој страници\' појављује у подножју странице. У супротном линк ће дати могућност да се ресетује корисинички водич на одређеној страници.';
$string['footertab'] = 'Подножје';
$string['footnoteheading'] = 'Фуснота';
$string['footnotesetting'] = 'Фуснота';
$string['footnotesetting_desc'] = 'Шта год да додате у ово текстуално поље, садржај ће бити приказан на крају странице, у подножју (не у плутајућем подножју) на свакој страници која користи распореде "drawers", "columns2" или "login". Садржај у овом поље могу бити, на пример ауторска права, услови коришћења или назив ваше организације.<br/> Ако желите поново да уклоните фусноту, само обришите садржај текстуалног поља.';
$string['forguestsonly'] = 'Само за госте и непријављене кориснике';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github issues</a>';
$string['h5pcontentmaxwidthsetting'] = 'Максимална ширина H5P банке садржаја';
$string['h5pcontentmaxwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину Moodle H5P банке садржаја курса без ручних модификација SCSS стилова. Ова ширина се користи за H5P едитор унутар банке садржаја. Она се <em>не</em> користи за ширину H5P активности. Стандардно, Moodle користи максималну ширину H5P банке садржаја од 960 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 1200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 100% или вредност ширине оквира за приказ (viewport) као што је 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Садржај странице за помоћ';
$string['helpcontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници за помоћ';
$string['helpdisabled'] = 'Страница за помоћ је онемогућена на овом сајту. Овде нема шта да се види.';
$string['helpheading'] = 'Помоћ';
$string['helplinkpositionboth'] = 'Додајте линк ка страници за помоћ у фусноту и на иконицу у подножју странице (знак питања)';
$string['helplinkpositionfooter'] = 'Додајте линк ка страници за помоћ на иконицу у подножју странице (знак питања)';
$string['helplinkpositionfootnote'] = 'Додајте линк ка страници за помоћ у фусноту';
$string['helplinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници за помоћ';
$string['helplinkpositionsetting'] = 'Позиција линка ка страници за помоћ';
$string['helplinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници за помоћ аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['helppagetitledefault'] = 'Помоћ';
$string['helppagetitlesetting'] = 'Наслов странице за помоћ';
$string['helppagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице за помоћ. Овај текст ће се користити и као текст линка ка страници за помоћи ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници за помоћ\'.';
$string['hidenodesprimarynavigationsetting'] = 'Сакриј чворове у примарној навигацији';
$string['hidenodesprimarynavigationsetting_desc'] = 'Са овим подешавањем можете да сакријете један или више чворова из примарне навигације.<br /><br />
Имајте на уму: овде можете једноставно уклонити навигационе чворове. Али ако желите да додате прилагођене навигационе чворове, размислите о коришћењу <a href="{$a->url}">Boost Union\'s smart menu functionality</a>.';
$string['imprintcontentsetting'] = 'Садржај импресума';
$string['imprintcontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници са импресумом.';
$string['imprintdisabled'] = 'Страница са импресумом је онемогућена на овом сајту. Овде нема шта да се види.';
$string['imprintheading'] = 'Импресум';
$string['imprintlinkpositionboth'] = 'Додајте линк ка страници са импресумом у фусноту и на иконицу у подножју странице (знак питања)';
$string['imprintlinkpositionfooter'] = 'Додајте линк ка страници са импресумом на иконицу у подножју странице  (знак питања)';
$string['imprintlinkpositionfootnote'] = 'Додајте линк ка страници са импресумом у фусноту';
$string['imprintlinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници са импресумом';
$string['imprintlinkpositionsetting'] = 'Позиција линка ка страници са импресумом';
$string['imprintlinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници са импресумом аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['imprintpagetitledefault'] = 'Импресум';
$string['imprintpagetitlesetting'] = 'Наслов странице са импресумом';
$string['imprintpagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице са импресумом. Овај текст ће се користити и као текст линка ка страници са импресумом ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници са импресумом\'.';
$string['infobannerbsclasssetting'] = 'Bootstrap класа инфо банера {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Са овим подешавањем, можете да изаберете Bootstrap стил са којим ће инфо банер {$a->no} бити приказан. Ако изаберете опцију \'Без Bootstrap боје\', инфо банер ће бити приказан без било какве Bootstrap боје, што вам даје слободу да сами стилизујете банер у едитору текста.';
$string['infobannerclose'] = 'Затвори';
$string['infobannercontentsetting'] = 'Садржај инфо банера {$a->no}';
$string['infobannercontentsetting_desc'] = 'Овде уносите информације које треба да буду приказане у инфо банеру {$a->no}.';
$string['infobannerdismissconfirm'] = 'Да ли заиста желите да ресетујете видљивост инфо банера {$a->no} и да га поново прикажете свим корисницима који су га претходно одбацили?';
$string['infobannerdismissfail'] = 'Ресетовање видљивости инфо банера {$a->no} није успело за најмање једног корисника';
$string['infobannerdismissiblesetting'] = 'Инфо банер {$a->no} се може одбацити';
$string['infobannerdismissiblesetting_desc'] = 'Са овим подешавањем можете учинити да инфо банер {$a->no} може да се одбаци. Ако корисник кликне на дугме  X у инфо банеру, банер ће за овог корисника бити трајно сакривен. Видљивост се никако не ресетује аутоматски, чак и ако промените садржај инфо банера. Ако желите да ресетујете видљивост инфо банера, кликните на дугме \'Ресетуј видљивост\'.';
$string['infobannerdismissreset'] = 'Ресетуј видљивост одбаченог инфо банера';
$string['infobannerdismissresetbutton'] = 'Ресетуј видљивост инфо банера {$a->no}';
$string['infobannerdismisssuccess'] = 'Видљивост инфо банера {$a->no} је ресетована';
$string['infobannerenabledsetting'] = 'Омогући инфо банер {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Са овим подешавањем можете омогућити инфо банер {$a->no}.';
$string['infobannerendsetting'] = 'Време завршетка приказивања инфо банера {$a->no}';
$string['infobannerendsetting_desc'] = 'Са овим подешавањем можете да дефинишете до када треба да буде приказан инфо банер {$a->no}. Конфигурисано време се третира као време сервера, а не као време корисника.';
$string['infobannerheading'] = 'Инфо банер {$a->no}';
$string['infobannermodeperpetual'] = 'Трајно';
$string['infobannermodesetting'] = 'Режим приказа инфо банера {$a->no}';
$string['infobannermodesetting_desc'] = 'Са овим подешавањем можете да дефинишете да ли инфо банер {$a->no} треба да буде трајни (који се увек приказује) или временски ограничени банер (који се приказује само у конфигурисаном временском интервалу)';
$string['infobannermodetimebased'] = 'Временски контролисано';
$string['infobannerordersetting'] = 'Позиција а инфо банера {$a->no}';
$string['infobannerordersetting_desc'] = 'Са овим подешавањем дефинишете позицију инфо банера {$a->no}. Стандардно, инфо банери су поређани одозго према доле, као што их видите на овој страници са подешавањима. Међутим, са овим подешавањем можете инфо банеру да доделите другу позицију. Ако доделите исту позицију за два или више инфо банера, они ће бити поново поређани према редоследу на овој страници са подешавањима.';
$string['infobannerpageloginpage'] = 'Страница за пријаву';
$string['infobannerpagessetting'] = 'Врсте страница за приказ банера са информацијама {$a->no}';
$string['infobannerpagessetting_desc'] = 'Са овим подешавањем, можете да изаберете врсте страница на којима инфо банер {$а->но} треба да буде приказан.';
$string['infobannerstartsetting'] = 'Време почетка приказивања инфо банера {$a->no}';
$string['infobannerstartsetting_desc'] = 'Са овим подешавањем, можете да дефинишете од када треба да буде приказан инфо банер {$a->no}. Конфигурисано време се третира као време сервера, а не као време корисника.';
$string['infobannertab'] = 'Инфо банер';
$string['invalidurl'] = 'Дата URL адреса је неисправна';
$string['javascriptdisabledhint'] = 'Савет ако је JavaScript онемогућен';
$string['javascriptdisabledhint_desc'] = 'Са овим подешавањем на врху Moodle странице ће се појавити савет ако JavaScript није омогућен. Ово је посебно корисно јер неколико Moodle функција не ради без JavaScripta.';
$string['javascriptdisabledhinttext'] = 'JavaScript је онемогућен у вашем веб читачу.<br />Многе функције Moodlea неће бити употребљиве или ће изгледати као да нису исправне.<бр />Молимо вас да омогућите JavaScript да бисте користили све функције Moodlea.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Линкови';
$string['loginbackgroundimage'] = 'Позадинске слике странице за пријаву';
$string['loginbackgroundimage_desc'] = 'Слике која ће бити приказана као позадина странице за пријаву. Једна од ових слика ће бити насумично изабрана и приказана када корисник приступи страници за пријаву. Проверите да се у називу датотеке не користе знакови који нису ASCII, уколико желите да прикажете текст за позадинске слике странице за пријаву.';
$string['loginbackgroundimagepositionsetting'] = 'Позиција позадинске слике странице за пријаву';
$string['loginbackgroundimagepositionsetting_desc'] = 'Са овим подешавањем контролишете положај позадинске слике странице за пријаву у прозору веб читача. Прва вредност је хоризонтална, а друга вертикална позиција.';
$string['loginbackgroundimagesheading'] = 'Позадинске слике странице за пријаву';
$string['loginbackgroundimagetextsetting'] = 'Прикажи текст за позадинске слике странице за пријаву';
$string['loginbackgroundimagetextsetting_desc'] = 'Са овим опционим подешавањем можете додати текст, нпр. обавештење о ауторским правима на позадинске слике које сте поставили. Овај текст ће се појавити на врху подножја странице за пријаву. Међутим, због величине екрана, текст се приказује само на екранима већих величина.<br/>
Сваки ред се састоји од идентификатора датотеке (назив датотеке), текста који треба да се прикаже и боје текста (елементи у реду су одвојени вертикалном цртом |). Сваку појединачни ставку у овом подешавању треба написати у новом реду. <br/>
На пример:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
Као боју текста можете користити вредности "тамно" или "светло".<бр />
Можете дефинисати текстове за произвољан број ваших постављених позадинских слика странице за пријаву. Текстови ће бити додати само оним сликама које одговарају њиховом називу датотеке са идентификатором наведеним у овом подешавању.';
$string['loginformheading'] = 'Образац за пријаву';
$string['loginformpositionsetting'] = 'Позиција обрасца за пријаву';
$string['loginformpositionsetting_center'] = 'У центру';
$string['loginformpositionsetting_desc'] = 'Са овим подешавањем можете оптимизовати образац за пријаву тако да одговара већем броју позадинских слика. Стандардно, образац за пријаву се приказује у центру странице за пријаву. Алтернативно, можете да га померите лево или десно на страници за пријаву како би се остали делови позадинске слике јасно видели. Наравно, ово подешавање можете променити и ако позадинска слика уопште није постављена.';
$string['loginformpositionsetting_left'] = 'Лево';
$string['loginformpositionsetting_right'] = 'Десно';
$string['loginformtransparencysetting'] = 'Транспарентност обрасца за пријаву';
$string['loginformtransparencysetting_desc'] = 'Са овим подешавањем, можете учинити да образац за пријаву буде мало провидан како би се позадинска слика јасније видела.';
$string['loginidpshowintrosetting'] = 'Уводна информација за пријаву путем IDP (провајдера идентитета)';
$string['loginidpshowintrosetting_desc'] = 'Са овим подешавањем контролишете да ли се уводна информација <em>\'{$a}\'</em> приказује изнад IDP дугмади за пријаву или не. Стандардно, уводна информација се приказује и корисници ће бити брзо обавештени о томе чему IDP дугмад служе. Ако онемогућите ово подешавање, IDP уводна информација је сакривена. Ово вам омогућава да обезбедите једноставан интерфејс за пријаву корисника ако користите само спољне провајдере идентитета као што су OAuth2 или OIDC.';
$string['loginlocalintro'] = 'Пријавите се са својим Moodle налогом';
$string['loginlocalloginenablesetting'] = 'Локална пријава';
$string['loginlocalloginenablesetting_desc'] = 'Са овим подешавањем контролишете да ли се образац за локалну пријаву приказује на страници за пријаву или не. Стандардно, образац за локалну пријаву се приказује и корисници се пријављују на сајт као и обично. Ако онемогућите ово подешавање, образац за локалну пријаву је сакривен. Ово вам омогућава да обезбедите само дугмад за пријаву корисника за спољне провајдере идентитета као што су OAuth2 или OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Имајте на уму - чим сакријете локални образац за пријаву, ризикујете да се администратори више не могу пријавити са локалним налогом ако постоји проблем са спољним провајдером идентитета. Да бисте ипак дозволили локалну пријаву у таквим случајевима, обезбеђена је <a href="{$a->url}">помоћна страница за локалну пријаву</a>. На тој страници важе и све Moodle безбедносне мере за пријаву.';
$string['loginlocalloginformhead'] = 'Локална пријава';
$string['loginlocalloginlocalnotdisabled'] = 'Локална пријава је омогућена на стандардном обрасцу за пријаву. Нема потребе да се пријављујете на систем овде на овој локалној страници за пријаву. За пријаву користите <a href="{$a->url}">стандардна страница за пријаву</a>.';
$string['loginlocalshowintrosetting'] = 'Уводна информација за локалну пријаву';
$string['loginlocalshowintrosetting_desc'] = 'Са овим подешавањем контролишете да ли се уводна информација за <em>\'{$a}\'</em> приказује изнад обрасца за локалну пријаву или не. Стандардно, уводна информација се не приказује. Али, ако омогућите ово подешавање, уводна информација може помоћи корисницима да схвате које креденцијале (корисничко име и лозинку) треба да користе у обрасцу за локалну пријаву, посебно ако им омогућите да се пријаве на више начина или ако промените редослед метода пријављивања.';
$string['loginorderfirsttimesignupsetting'] = 'Информације за посетиоце који први пут приступају сајту и саморегистрацију';
$string['loginorderguestsetting'] = 'Пријава гостију';
$string['loginorderheading'] = 'Редослед метода пријављивања';
$string['loginorderheading_desc'] = 'Са овим подешавањима можете да контролишете редослед метода пријављивања у обрасцу за пријаву. Приказани редослед биће дефинисан од најнижег до највишег редног броја, прескачући све методе пријављивања и елементе обрасца за пријаву који су онемогућени у Moodleu.';
$string['loginorderheading_note'] = 'Техничка напомена: представљени редослед метода пријављивања биће реализован помоћу CSS flexbox редоследа, а не преуређивањем виџета за пријаву у HTML DOM. Ово би требало да буде у реду на свим модерним, али можда неће радити на заиста старим веб читачима.';
$string['loginorderidpsetting'] = 'IDP пријава';
$string['loginorderlocalsetting'] = 'Локална пријава';
$string['loginpagetab'] = 'Страница за пријаву';
$string['loginprovidersheading'] = 'Провајдери за пријаву';
$string['logocompactsetting'] = 'Компактан лого';
$string['logocompactsetting_desc'] = 'Овде можете да поставите компактну верзију истог логотипа као што је горњи, као што је амблем, штит или иконица. Ова слика се посебно користи у траци за навигацију на врху сваке Moodle странице. Слика треба да буде јасна чак и при малим величинама.';
$string['logosetting'] = 'Лого';
$string['logosetting_desc'] = 'Овде можете да поставите лого који ће се користити као декорација. Ова слика се посебно користи на страници за пријаву и може бити прилично високе резолуције јер ће бити смањена за употребу.';
$string['logosheading'] = 'Логотипи';
$string['logosheading_desc'] = 'Имајте на уму: Boost Union има сопствено поље за постављање логотипа и не користи лого из <a href="{$a}">подешавања логотипа основне инсталације Moodlea</a>.<br />Boost Union вам посебно омогућава да поставите више формата слика него што нуди основна инсталација Moodlea. Такође вам даје могућност да измените постављене логотипе у оквиру његових визуелних идентитета.';
$string['maintenancecontentsetting'] = 'Садржај странице са информацијама о одржавању';
$string['maintenancecontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници са информацијама о одржавању (што није исто што и стандардна Moodle страница са режимом одржавања).';
$string['maintenancedisabled'] = 'Страница са информацијама о одржавању је онемогућена на овом сајту. Овде нема шта да се види.';
$string['maintenanceheading'] = 'Одржавање';
$string['maintenancelinkpositionboth'] = 'Додајте линк ка страници са информацијама о одржавању у фусноту и на иконицу у подножју странице (знак питања)';
$string['maintenancelinkpositionfooter'] = 'Додајте линк ка страници са информацијама о одржавању на иконицу у подножју странице  (знак питања)';
$string['maintenancelinkpositionfootnote'] = 'Додајте линк ка страници са информацијама о одржавању у фусноту';
$string['maintenancelinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници са са информацијама о одржавању';
$string['maintenancelinkpositionsetting'] = 'Позиција линка ка страници са информацијама о одржавању';
$string['maintenancelinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници са информацијама о одржавању аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['maintenancepagetitledefault'] = 'Одржавање';
$string['maintenancepagetitlesetting'] = 'Наслов странице са информацијама о одржавању';
$string['maintenancepagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице са информацијама о одржавању. Овај текст ће се користити и као текст линка ка страници са са информацијама о одржавању ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници са информацијама о одржавању\'.';
$string['markbrokenlinkssetting'] = 'Означите неисправне линкове';
$string['markbrokenlinkssetting_desc'] = 'Додаје иконицу ”прекинутог ланца“ поред неисправних линкова (који воде до постављених драфт верзија датотека које нису правилно обрађене) и означава линк bootstrap бојом за ”опасност“. За разлику од подешавања ”Означите екстерне линкове“ и „Означите mailto линкове“, не постоји могућност да се ограничи обим овог подешавања јер означавање неисправних линкова је показатељ да је нешто не функционише и да се мора ручно поправити.';
$string['markexternallinksscopesetting'] = 'Опсег обележавања екстерних линкова';
$string['markexternallinksscopesetting_desc'] = 'Са овим подешавањем контролишете опсег у коме Boost Union треба да означи екстерне линкове. Boost Union стандардно обележава екстерне линкове на целој Moodle страници и даје све од себе да покрије и неке екстремне случајеве где додавање иконице за екстерни линк нема баш много смисла. Међутим, можете, такође, да ограничите опсег како бисте избегли те екстремне случајеве.';
$string['markexternallinkssetting'] = 'Означите екстерне линкове';
$string['markexternallinkssetting_desc'] = 'Додаје иконицу ”екстерни линк“ после екстерних линкова (који воде корисника до одредишта изван Moodlea).';
$string['marklinksscopesetting_coursemain'] = 'Искључиво на главним страница курса и то унутар поља са главним садржајем';
$string['marklinksscopesetting_wholepage'] = 'На целој страници';
$string['markmailtolinksscopesetting'] = 'Опсег обележавања mailto линкова';
$string['markmailtolinksscopesetting_desc'] = 'Са овим подешавањем контролишете опсег у коме Boost Union треба да означи <em>mailto</em> линкове. Boost Union стандардно обележава <em>mailto</em> линкове на целој Moodle страници. Међутим, можете, такође, да ограничите опсег како бисте избегли те екстремне случајеве.';
$string['markmailtolinkssetting'] = 'Означите mailto линкове';
$string['markmailtolinkssetting_desc'] = 'Додаје иконицу ”коверте“ поред mailto линкова.';
$string['mediumcontentmaxwidthsetting'] = 'Максимална ширина средишњег садржаја';
$string['mediumcontentmaxwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину средишњег садржаја Moodleа без ручних модификација SCSS стилова. Ова ширина странице се користи у одређеним активностима као што је то активност \'База података\'. Стандардно, Moodle користи максималну ширину средишњег садржаја од 1120 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 1200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 100% или вредност ширине оквира за приказ (viewport) као што је 90vw.';
$string['misctab'] = 'Разно';
$string['mobileappearanceheading'] = 'Изглед на мобилним уређајима';
$string['mobileappheading'] = 'Апликација за мобилне уређаје';
$string['mobilecss'] = 'Додатни CSS за мобилну апликацију';
$string['mobilecss_desc'] = 'Са овим подешавањем можете унети прилагођени CSS кôд како бисте прилагодили интерфејс своје мобилне апликације. CSS кôд ће бити додат само у приказ мобилне апликације ове Moodle инстанце, и неће бити приказан у верзији за веб читач. Прочитајте више о овој функцији на href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Moodle развојни документи</a>';
$string['mobilecss_donotchange'] = 'Овај корак је неопходан како би се послао CSS кôд у апликацију за мобилне уређаје. Не мењајте URL адресу тамо осим ако заиста не желите да поново уклоните CSS кôд из апликације за мобилне уређаје.';
$string['mobilecss_overwrite'] = 'Чим додате било који CSS кôд у ово подешавање и сачувате га, <a href="{$a->url}">Moodle основно подешавање <em>mobilecssurl</em></a> ће аутоматски бити замењено URL адресом Boost Union  theme. Тренутно је ово подешавање постављено на  <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Чим додате било који CSS кôд у ово подешавање и сачувате га, <a href="{$a->url}">Moodle основно подешавање <em>mobilecssurl</em></a> ће аутоматски бити постављено на URL адресу Boost Union теме.';
$string['mobiletab'] = 'Мобилни';
$string['modiconactivity'] = 'Активност';
$string['modiconactivityunknown'] = 'Непознатo';
$string['modicongtmoodle4'] = 'Moodle 4 иконица';
$string['modiconlistsetting'] = 'Списак датотека са прилагођеним иконама';
$string['modiconlistsetting_desc'] = 'Ово је списак прилагођених датотека иконица које сте поставили у горњи простор за прилагођене датотека иконица. Овде су наведене све валидне датотеке иконица. Поред тога, приказане су и друге датотеке (које сте можда поставили, али које нису валидне датотеке иконица). Оне су приказане као неисправне датотеке.';
$string['modiconltmoodle311'] = 'Moodle 3 наслеђена иконица';
$string['modiconnamefail'] = 'Ова датотека је постављена у одговарајући директоријум за активност <em>{$a}</em> али назив датотеке није исправан. Молимо вас да промените назив датотеке у <em>monologo.svg</em> / <em>monologo.png</em> (за Moodle 4 иконице) или <em>icon.svg</em> / <em>icon.png</em> (за Moodle 3 наслеђене иконице).';
$string['modiconnotexist'] = 'Ова датотека је постављена на неодговарајуће место, јер из путање датотеке <em>{$a}</em> није било могуће закључити о којој се  конкретној активности  ради.';
$string['modiconsenablesetting'] = 'Омогући прилагођене иконице за активности и ресурсе';
$string['modiconsenablesetting_desc'] = 'Са овим подешавањем, можете да мењате иконице за активности и ресурсе које користи Moodle на страницама курса и у бирачу активности.';
$string['modiconserrorcreatingpath'] = 'Поддиректоријум pix_plugins/mod није могао да буде креиран у вашем Moodledata директоријуму.<br />Порука о грешци гласила је:{$a}.';
$string['modiconsfiles'] = 'Датотеке прилагођених иконица';
$string['modiconsfiles_desc'] = 'Овде можете да поставите прилагођене иконице за све или само неке модуле активности инсталиране у овој инстанци Moodlea.';
$string['modiconsfileshowto'] = 'Да бисте поставили одређену прилагођену иконицу активности, прво креирајте директоријума са интерним називом активности, нпр. <em>assign</em> за активност Задатак (assigment). У овај директоријум постављате иконицу као SVG датотеку (monologo.svg) и, ако је могуће, као резервну PNG датотеку (monologo.png). Ако желите да прилагодите иконице у боји које су биле у употреби до Moodle 3 верзије и које још увек могу да користе старији додаци, такође их можете поставити као icon.svg и icon.png датотеке. Међутим, ако је могуће, ипак се држите монохроматских SVG иконица. На крају, сачувајте страницу са подешавањима. Чим сачувате подешавање са најмање једном датотеком, испод ће се појавити списак датотека која вам помаже да проверите да ли су прилагођене иконице исправно постављене.';
$string['modiconsfilestech'] = 'Техничка напомена: након што сачувате подешавање, структура постављеног директоријума и датотеке иконица биће копиране у директоријум pix_plugins/mod, унутар вашег Moodledata директоријума. Ово је место где Moodle претражује прилагођене иконице активности. Све датотеке иконица које можда већ постоје у овом директоријуму биће замењене (тј. обрисане), када сачувате ово подешавање.';
$string['modiconsheading'] = 'Иконице активности';
$string['modiconsuccess3x'] = 'Ова иконица ће се користити за активност <em>{$a}</em> као Moodle 3 наслеђена иконица.';
$string['modiconsuccess4x'] = 'Ова иконица ће се користити за активност <em>{$a}</em> као Moodle 4 иконица.';
$string['modiconversion'] = 'Верзија иконице';
$string['navbarcolorsetting'] = 'Боја навигационе траке';
$string['navbarcolorsetting_dark'] = 'Тамна навигациона трака са светлом бојом фонта';
$string['navbarcolorsetting_desc'] = 'Са овим подешавањем можете променити боју навигационе траке из подразумеване светле у тамну или обојену навигациону траку.';
$string['navbarcolorsetting_light'] = 'Светла навигациона трака са тамном бојом фонта (неизмењено, онако како је изворно подешено у основној Moodle инсталацији)';
$string['navbarcolorsetting_primarydark'] = 'Примарна боја навигационе трака са светлом бојом фонта';
$string['navbarcolorsetting_primarylight'] = 'Примарна боја навигационе траке са тамном бојом фонта';
$string['navbarheading'] = 'Навигациона трака';
$string['navigationheading'] = 'Навигација';
$string['navigationtab'] = 'Навигација';
$string['never'] = 'Никад';
$string['nochange'] = 'Нема промене';
$string['offerscontentsetting'] = 'Садржај странице са понудама';
$string['offerscontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници са понудама.';
$string['offersdisabled'] = 'Страница са понудама је онемогућена на овом сајту. Овде нема шта да се види.';
$string['offersheading'] = 'Понуде';
$string['offerslinkpositionboth'] = 'Додајте линк ка страници са понудама у фусноту и на иконицу у подножју странице (знак питања)';
$string['offerslinkpositionfooter'] = 'Додајте линк ка страници са понудама на иконицу у подножју странице  (знак питања)';
$string['offerslinkpositionfootnote'] = 'Додајте линк ка страници са понудама у фусноту';
$string['offerslinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници са понудама';
$string['offerslinkpositionsetting'] = 'Позиција линка ка страници са понудама';
$string['offerslinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници са понудама аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['offerspagetitledefault'] = 'Понуде';
$string['offerspagetitlesetting'] = 'Наслов странице са понудама';
$string['offerspagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице са понудама. Овај текст ће се користити и као текст линка ка страници са понудам ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници са понудама\'.';
$string['openoffcanvas'] = 'Отвори фиоку ”Ван странице”';
$string['outsideregionsheading'] = 'Спољни региони';
$string['outsideregionsheading_desc'] = 'Спољни региони, не само да се могу укључити помоћу горњих подешавања, већ се њихов изглед такође може прилагодити.';
$string['outsideregionsplacement'] = 'Хоризонтални положај спољних региона';
$string['outsideregionsplacement_desc'] = 'Са овим подешавањем можете да контролишете да ли на већим екранима, региони блокова \'Споља (лево)\' и \'Споља (десно)\' треба да буду постављени близу главног садржаја странице или близу ивица екрана.';
$string['outsideregionsplacementnearwindowedges'] = 'Прикажите регионе \'Споља (лево)\' и \'Споља (десно)\' близу ивица екрана';
$string['outsideregionsplacementnextmaincontent'] = 'Прикажите регионе \'Споља (лево)\' и \'Споља (десно)\' поред главног садржаја странице';
$string['outsideregionswidthcoursecontentwidth'] = 'Ширина садржаја курса';
$string['outsideregionswidthfullwidth'] = 'Пуна ширина';
$string['outsideregionswidthherowidth'] = 'Херо ширина';
$string['page1contentsetting'] = 'Садржај генеричке странице 1';
$string['page1contentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на генеричкој страници 1';
$string['page1disabled'] = 'Генеричка страница 1 је онемогућена на овом сајту. Овде нема шта да се види.';
$string['page1heading'] = 'Генеричка страница 1';
$string['page1linkpositionboth'] = 'Додајте линк ка генеричкој страници 1 у фусноту и на иконицу у подножју странице (знак питања)';
$string['page1linkpositionfooter'] = 'Додајте линк ка генеричкој страници 1 на иконицу у подножју странице  (знак питања)';
$string['page1linkpositionfootnote'] = 'Додајте линк ка генеричкој страници 1 у фусноту';
$string['page1linkpositionnone'] = 'Немојте аутоматски приказивати линк ка генеричкој страници 1';
$string['page1linkpositionsetting'] = 'Позиција линка ка генеричкој страници 1';
$string['page1linkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка генеричкој страници 1 аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['page1pagetitledefault'] = 'Генеричка страница 1';
$string['page1pagetitlesetting'] = 'Наслов генеричке странице 1';
$string['page1pagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов генеричке странице 1. Овај текст ће се користити и као текст линка ка генеричкој страници 1 ако у складу с тим конфигуришете подешавање \'Позиција линка ка генеричкој страници 1\'.';
$string['page2contentsetting'] = 'Садржај генеричке странице 2';
$string['page2contentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на генеричкој страници 2';
$string['page2disabled'] = 'Генеричка страница 2 је онемогућена на овом сајту. Овде нема шта да се види.';
$string['page2heading'] = 'Генеричка страница 2';
$string['page2linkpositionboth'] = 'Додајте линк ка генеричкој страници 2 у фусноту и на иконицу у подножју странице (знак питања)';
$string['page2linkpositionfooter'] = 'Додајте линк ка генеричкој страници 2 на иконицу у подножју странице  (знак питања)';
$string['page2linkpositionfootnote'] = 'Додајте линк ка генеричкој страници 2 у фусноту';
$string['page2linkpositionnone'] = 'Немојте аутоматски приказивати линк ка генеричкој страници 2';
$string['page2linkpositionsetting'] = 'Позиција линка ка генеричкој страници 2';
$string['page2linkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка генеричкој страници 2 аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['page2pagetitledefault'] = 'Генеричка страница 2';
$string['page2pagetitlesetting'] = 'Наслов генеричке странице 2';
$string['page2pagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов генеричке странице 2. Овај текст ће се користити и као текст линка ка генеричкој страници 2 ако у складу с тим конфигуришете подешавање \'Позиција линка ка генеричкој страници 2\'.';
$string['page3contentsetting'] = 'Садржај генеричке странице 3';
$string['page3contentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на генеричкој страници 3';
$string['page3disabled'] = 'Генеричка страница 3 је онемогућена на овом сајту. Овде нема шта да се види.';
$string['page3heading'] = 'Генеричка страница 3';
$string['page3linkpositionboth'] = 'Додајте линк ка генеричкој страници 3 у фусноту и на иконицу у подножју странице (знак питања)';
$string['page3linkpositionfooter'] = 'Додајте линк ка генеричкој страници 13 на иконицу у подножју странице  (знак питања)';
$string['page3linkpositionfootnote'] = 'Додајте линк ка генеричкој страници 3 у фусноту';
$string['page3linkpositionnone'] = 'Немојте аутоматски приказивати линк ка генеричкој страници 3';
$string['page3linkpositionsetting'] = 'Позиција линка ка генеричкој страници 3';
$string['page3linkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка генеричкој страници 3 аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['page3pagetitledefault'] = 'Генеричка страница 3';
$string['page3pagetitlesetting'] = 'Наслов генеричке странице 3';
$string['page3pagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов генеричке странице 3. Овај текст ће се користити и као текст линка ка генеричкој страници 3 ако у складу с тим конфигуришете подешавање \'Позиција линка ка генеричкој страници 3\'.';
$string['pagelayoutstab'] = 'Изгледи страница';
$string['pagetab'] = 'Страница';
$string['pagewidthheading'] = 'Ширина странице';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Правила коришћења сајта';
$string['policyoverviewnavigationsetting'] = 'Прикажи навигацију на страници са прегледом правила коришћења';
$string['policyoverviewnavigationsetting_desc'] = 'Стандардно, страница са прегледом правила коришћења сајта (која даје tool_policy) не приказује мени за навигацију или подножје. Помоћу овог подешавања можете да прикажете примарну навигацију и подножје на тој страници.';
$string['presetbutton'] = 'Подесите предефинисана подешавања теме у графичкој теми Boost';
$string['presetheading'] = 'Предефинисана подешавања графичке теме';
$string['presetheading_desc'] = 'Предефинисана подешавања графичке теме могу се користити за драматичну промену изгледа теме. Boost Union тема не примењује предефинисана подешавања, али их наслеђује од теме Boost. Дакле, уколико желите да користите предефинисана подешавања графичке теме, подесите их директно у теми Boost. Boost Union ће наследити и користити конфигурисана предефинисана подешавања графичке теме.';
$string['primarynavigationheading'] = 'Примарна навигација';
$string['privacy:metadata'] = 'Тема Boost Union не чува никакве личне податке о било ком кориснику.';
$string['region-content-lower'] = 'Садржај (доњи)';
$string['region-content-upper'] = 'Садржај (горњи)';
$string['region-footer-center'] = 'Подножје (центар)';
$string['region-footer-left'] = 'Подножје (лево)';
$string['region-footer-right'] = 'Подножје (десно)';
$string['region-header'] = 'Заглавље';
$string['region-none'] = 'Ниједан';
$string['region-offcanvas-center'] = 'Ван-странице (центар)';
$string['region-offcanvas-left'] = 'Ван странице (лево)';
$string['region-offcanvas-right'] = 'Ван странице (десно)';
$string['region-outside-bottom'] = 'Споља (доле)';
$string['region-outside-left'] = 'Споља (лево)';
$string['region-outside-right'] = 'Споља (десно)';
$string['region-outside-top'] = 'Споља (горе)';
$string['resourcescachecontrolnote'] = 'Имајте на уму да се датотеке шаљу веб читачу са подешеним заглављем \'Cache-Control\' које веб читачу говори да кешира датотеку. Уколико сте сигурни да датотеку нећете променити  у блиској будућности, можете да користите трајну URL адресу за повезивање са датотеком. Међутим, ако планирате да, с времена на време, измените датотеку, и да притом задржите њен назив, боље би било да користите ревидирану URL адресу и поново повежете датотеку коју сте користили, сваки пут када је ажурирате, како бисте избегли да веб читачи приказују кеширане застареле верзије датотеке.';
$string['resourcestab'] = 'Ресурси';
$string['scrollspysetting'] = 'Чувар позиције клизне траке';
$string['scrollspysetting_desc'] = 'Са овим подешавањем, након укључивања/искључивања прекидача режима уређивање, позиција клизне траке у веб читачу (тј. место на којем је корисник био у тренутку када је укључио режим уређивање) биће сачувана.';
$string['scssheading'] = 'Необрађени SCSS';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Подесите преферирани језик';
$string['settingsoverview'] = 'Преглед подешавања';
$string['settingsoverview_accessibility_desc'] = 'Подешавања за функционалност у вези са приступачношћу вашем Moodle сајту се налазе овде.';
$string['settingsoverview_all'] = 'Сва подешавања на једној страници';
$string['settingsoverview_all_desc'] = 'Овде можете да отворите стандардну страницу подешавања Moodle категорија за Boost Union графичку тему која приказује сва подешавања на једној страници. Али водите рачуна, страница је препуна бројних  подешавања.';
$string['settingsoverview_content_desc'] = 'Подешавања за глобални садржај вашег Moodle сајта се налазе овде: подножје, статичне странице, инфо банери, рекламне плочице и слајд презентације.';
$string['settingsoverview_feel_desc'] = 'Подешавања за целокупно понашање вашег Moodle сајта се налазе овде: ставке за навигацију, помоћници за навигацију, блокови и линкови.';
$string['settingsoverview_flavours_desc'] = 'Помоћу визуелних идентитета можете учинити различитим изглед вашег Moodle сајта за кохорте и/или категорије курсева.';
$string['settingsoverview_functionality_desc'] = 'Овде се налазе подешавања за додатне корисне глобалне функционалности или оне које односе на појединачне курсеве на вашем Moodle сајту.';
$string['settingsoverview_look_desc'] = 'Подешавања за брендирање вашег Moodle сајта се налазе овде: боје, иконiце, слике, величине и, наравно, прилагођени SCSS.';
$string['settingsoverview_smartmenus_desc'] = 'Са паметним менијима можете проширити ставке за навигацију на свом Moodle сајту у региону главног и корисничког меније, као и да додате мени на дну или врху странице.';
$string['settingsoverview_title'] = 'Преглед Boost Union подешавања';
$string['showfullnameinusermenussetting'] = 'Прикажи пуно име у корисничком менију';
$string['showfullnameinusermenussetting_desc'] = 'Са овим подешавањем, можете приказати пуно име пријављеног корисника на врху корисничког менија. Ово може бити посебно корисно у случају испита када предавачи морају да потврде да је корисник пријављен са сопственим налогом, али може бити од помоћи и самом кориснику. За разлику од Classic графичке теме која приказује пуно име корисника у траци за навигацију поред аватара, ово подешавање не захтева никакав додатни простор у навигационој траци.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Пријављени сте као:';
$string['showhintcourseguestaccessgeneral'] = 'Тренутно посматрате овај курс као <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Да бисте имали пун приступ курсу, можете <a href="{$a->url}">самостално да се упишете на овај курс</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Са овим подешавањем, када корисник приступа курсу у улози госта,  у заглављу курса ће се појавити савет. Ако курс даје могућност за самостални упис, кориснику ће такође бити приказан линк до странице за упис.';
$string['showhintcoursehiddengeneral'] = 'Овај курс је тренутно <strong>сакривен</strong>. Само уписани предавачи могу приступити овом курсу када је сакривен.';
$string['showhintcoursehiddensetting'] = 'Прикажи савет у сакривеним курсевима';
$string['showhintcoursehiddensetting_desc'] = 'Са овим подешавањем, савет ће се појавити у заглављу курса све док је курс сакривен. Ово помаже да се одмах, на први поглед идентификује статус видљивости курса, без потребе да се она проверава у подешавањима курса.';
$string['showhintcoursehiddensettingslink'] = 'Видљивост можете променити у <a href="{$a->url}">подешавањима курс</a>.';
$string['showhintcourseselfenrolfrom'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис од {$a->from} па надаље.';
$string['showhintcourseselfenrolfromuntil'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис од {$a->from} до {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Ако не желите да било који корисник Moodlea има слободан приступ овом курсу, молимо вас да ограничите подешавања самосталног уписа.';
$string['showhintcourseselfenrolsetting'] = 'Прикажи савет за самостални упис без лозинке за упис';
$string['showhintcourseselfenrolsetting_desc'] = 'Са овим подешавањем, у заглављу курса ће се појавити савет ако је курс видљив и ако је, тренутно, могућ упис без лозинке за упис.';
$string['showhintcourseselfenrolsince'] = 'Инстанца уписа <strong>{$a->name}</strong> тренутно дозвољава неограничени самостални упис.';
$string['showhintcourseselfenrolsinceuntil'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис до {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Овај курс је тренутно видљив свима и могућ је <strong>самостални упис без лозинке за упис<strong>.';
$string['showhintcourseselfenrolstartfuture'] = 'Овај курс је тренутно видљив свима и планирано је да <strong>самостални упис без лозинке за упис<strong> постане могућ.';
$string['showhintcourseselfenrolunlimited'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис на неодређено време.';
$string['showhintcourseselfenroluntil'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис до {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Прикажи савет корисницима који приступају као гости';
$string['showhintforumnotifications'] = 'Овај курс је тренутно <strong>сакривен</strong>. То значи да <strong>полазници неће добијати обавештења</strong> било онлајн или е-поштом о новим порукама које су објављене на овом форуму.';
$string['showhintforumnotificationssetting'] = 'Прикажи савет за обавештења форума у скривеним курсевима';
$string['showhintforumnotificationssetting_desc'] = 'Са овим подешавањем, савет се ће појавити не само у заглављу курса већ и на форумима све док је курс сакривен од полазника. Да појаснимо, обавештења о новим порукама у оквиру форума на сакривеном курсу се не шаљу полазницима, па ова опција служи да помогне предавачима да схвате ову околност, тј. да је полазници не могу да виде курс.';
$string['shownavbarstarredcourses_config'] = 'Подесите курсеве означене звездицом на страници \'Моји курсеви\'';
$string['shownavbarstarredcourses_label'] = 'Курсеви означени звездицом';
$string['shownavbarstarredcoursessetting'] = 'Прикажи падајући мени са курсевима означеним звездицом на траци за навигацију';
$string['shownavbarstarredcoursessetting_desc'] = 'Помоћу овог подешавања можете да прикажете падајући мени са линковима ка курсевима означеним звездицом поред менија за поруке и обавештења.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Прикажи фиоку са блоковима са десне стране почетне странице сајта приликом прве пријаве на систем';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Са овим подешавањем, фиока са блоковима са десне стране почетне странице сајта стандарно ће бити приказана. Ово се односи само на кориснике који се пријављују по први пут и не мења статус приказа (односно сакривености) фиоке за сваког појединачног корисника.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Прикажи фиоку са блоковима са десне стране почетне странице сајта приликом пријаве госта';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Са овим подешавањем, фиока са блоковима са десне стране почетне странице сајта стандардно ће бити приказана (у свом проширеном облику). Ово се односи само на кориснике који се пријављују као гости.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Прикажите фиоку са блоковима са десне стране почетне странице приликом посете';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Са овим подешавањем, фиока са блоковима са десне стране почетне странице сајта стандардно ће бити приказана (у свом проширеном облику). Ово се односи само на кориснике који нису пријављени и не мења статус приказа (односно сакривености) фиоке за сваког појединачног корисника.';
$string['showswitchedroleincoursesetting'] = 'Прикажи савет за измењену улогу';
$string['showswitchedroleincoursesetting_desc'] = 'Са овим подешавањем, у заглављу курса ће се појавити савет уколико је корисник променио улогу на курсу. Стандардно, ове информације се приказују само у близини слике корисника у корисничком менију. Ако омогућите ову опцију, можете такође да прикажете ове информације - заједно са линком \'Повратак на моју уобичајену улогу\' - и на самој страници курса.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Стандардно, на <a href="{$a}">страници за управљање курсом</a>, Moodle захтева  или да отворите детаљне податке о курсу или да прођете кроз подешавања курса, пре него што будете могли да кликнете на додатни елемент корисничког интерфејса како бисте видели курс. Ако омогућите ово подешавање, можете да додате иконицу \'Прикажи курс\' на страници за управљање курсом.';
$string['showviewcourseiconincoursemgntsetting'] = 'Прикажи иконицу за приказ курса';
$string['sitebrandingtab'] = 'Брендирање сајта';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Десна фиока са блоковима на почетној страници';
$string['slidebackgroundimagealtsetting'] = 'Атрибут alt позадинске слике слајда {$a->no}';
$string['slidebackgroundimagealtsetting_desc'] = 'Овде можете подесите атрибут alt за слику слајда {$a->no}. Ово је опционо подешавање, слајд ће бити приказан чак и ако не поставите атрибут alt. Имајте на уму да изостављање атрибута alt смањује приступачност сајта.';
$string['slidebackgroundimagesetting'] = 'Позадинска слика слајда {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Овде можете да поставите датотеку слике која ће бити приказана као позадинска слика иза садржаја слајда {$a->no}. Молимо вас, проверите да ли је садржај на позадинској слици и даље читљив . Такође, покушајте да се уверите да је однос ширине и висине свих позадинских слика на свим слајдовима једнак (пошто однос ширине и висине слике у позадини контролише висину слајда, па бисте тако избегли треперење приликом промене слајдова). Ово је обавезно подешавање - слајд неће бити приказан ако не поставите позадинску слику.';
$string['slidecaptionsetting'] = 'Наслов слајда {$a->no}';
$string['slidecaptionsetting_desc'] = 'Овде уносите наслов који треба да буде приказан на слајду {$a->no}. Наслов се приказује на дну, у средини слајда. Ово је опционо подешавање, слајд ће бити приказан чак и ако не поставите наслов.';
$string['slidecontentsetting'] = 'Садржај слајда {$a->no}';
$string['slidecontentsetting_desc'] = 'Овде уносите садржај који треба да буде приказан на слајду  {$a->no}. Садржај се приказује на дну, у средини слајда. Ако је натпис постављен, садржај се приказује испод наслова. Имајте на уму да едитор текст стандардно поравнава уз леву ивицу, али ћете можда пожелети да текст другачије поравнате. Такође, суздржите се од стављања превише текста на слајд, и обавезно тестирајте изглед слајда на малим уређајима, јер ће садржај који прелази ивице слајда једноставно бити сакривен. Ово је опционо подешавање, слајд ће бити приказан чак и ако не поставите никакав садржај.';
$string['slidecontentstylesetting'] = 'Стил садржаја слајда {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Тамно (црна боја фонта за светле позадинске слике)';
$string['slidecontentstylesetting_darkshadow'] = 'Тамно са сенком (црна боја фонта са светлом сенком за светле позадинске слике)';
$string['slidecontentstylesetting_desc'] = 'Овде можете да измените стил садржаја слајда {$a->no}. Стандардно, стил садржаја је бела боја фонта за тамне позадинске слике. Међутим, да бисте омогућили доследан и једноставан стил на свим врстама позадинских слика, овде га можете изменити. Имајте на уму да ће ово подешавање у сваком случају поништити боју фонта коју сте поставили у горњем едитору текста.';
$string['slidecontentstylesetting_light'] = 'Светло (бела боја фонта за тамне позадинске слике)';
$string['slidecontentstylesetting_lightshadow'] = 'Светло са сенком (бела боја фонта са тамном сенком за тамне позадинске слике)';
$string['slideenabledsetting'] = 'Омогући слајд {$a->no}';
$string['slideenabledsetting_desc'] = 'Помоћу овог подешавања можете омогућити слајд {$a->no}.';
$string['slideheading'] = 'Слајд {$a->no}';
$string['slidelinksetting'] = 'URL адреса линка за слајд {$a->no}';
$string['slidelinksetting_desc'] = 'Овде можете подесити (Moodle, интерну или екстерну) URL адресу са којом ће бити повезан садржај слајда {$a->no}. Ово је опционо подешавање, слајд ће бити приказан чак и ако не поставите URL линк.';
$string['slidelinksourcesetting'] = 'Елементи слајда {$a->no} за линковање';
$string['slidelinksourcesetting_both'] = 'Позадинска слика и елементи текста';
$string['slidelinksourcesetting_desc'] = 'Овде можете да контролишете који елементи слајда су повезани са наведеном URL адресом. Можете бирати између повезивања само позадинске слике, повезивања само текстуалних елемената слајда (наслова и садржаја) или повезивања и позадинске слике и текста.';
$string['slidelinksourcesetting_image'] = 'Само позадинска слика';
$string['slidelinksourcesetting_text'] = 'Само текстуални елементи';
$string['slidelinktargetsetting'] = 'Одредиште линка слајда {$a->no}';
$string['slidelinktargetsetting_desc'] = 'Овде можете да подесите одредиште линка, који је подешен за линк слајда чим је подешен URL линк на слајду {$a->no}.';
$string['slidelinktargetsetting_newtab'] = 'Нови прозор';
$string['slidelinktargetsetting_samewindow'] = 'Исти прозор';
$string['slidelinktitlesetting'] = 'Наслов линка слајда {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Овде можете подесите наслов линка који се приказује као кратак опис линка када корисник пређе мишем преко слајда {$a->no}. Ово је опционо подешавање, слајд ће бити повезан чак и ако не подесите наслов линка. Имајте на уму да ненавођење наслова везе смањује приступачност.';
$string['slideordersetting'] = 'Позиција слајда {$a->no}';
$string['slideordersetting_desc'] = 'Са овим подешавањем дефинишете положај тј. редослед слајда {$a->no}. Стандардно, слајдови су поређани онако како их видите на овој страници за подешавања. Међутим, уколико желите можете слајду да доделите другу позицију поможу овог подешавања. Ако, грешком, доделите исту позицију за два или више слајдова, они ће на крају бити поређани према редоследу на овој страници за подешавање слајдова.';
$string['slideranimationsetting'] = 'Слајд шоу - тип анимације';
$string['slideranimationsetting_desc'] = 'Са овим подешавањем контролишете начин приказивања слајдова. Опција \'Слајд\' примењује клизну анимацију, \'Замрачивање\' примењује постепено појављивање и нестајање слајдова, док опција \'Без анимације\' уклања све анимационе ефекте.';
$string['slideranimationsetting_fade'] = 'Замрачивање';
$string['slideranimationsetting_none'] = 'Без анимације';
$string['slideranimationsetting_slide'] = 'Слајд';
$string['sliderarrownavsetting'] = 'Омогући навигацију са стрелицама';
$string['sliderarrownavsetting_desc'] = 'Са овим подешавањем можете додати стрелице за навигацију на обе стране слајд презентације.';
$string['sliderfrontpagepositionsetting'] = 'Положај слајд презентације на почетној страници сајта';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Након садржаја насловне странице сајта (и након рекламних плочица)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Након садржаја насловне странице сајта (али пре рекламних плочица)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Пре садржаја насловне странице сајта (и након рекламних плочица)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Пре садржаја насловне странице сајта (али пре рекламних плочица)';
$string['sliderfrontpagepositionsetting_desc'] = 'Слајд-шоу се приказају само на почетној страници сајта. Помоћу овог подешавања контролишете да ли ће слајд-шоу бити приказан пре или после садржаја почетне странице сајта. Ако желите да на почетној страници сајта прикажете само слајд-шоу и ништа друго, сав остали садржај почетне странице сајта можете уклонити променом <a href="{$a->url}">подешавања почетне странице сајта</a>.';
$string['slidergeneralheading'] = 'Слајд-шоу - општа подешавања';
$string['sliderindicatornavsetting'] = 'Омогућите индикатор навигације за слајд-шоу';
$string['sliderindicatornavsetting_desc'] = 'Са овим подешавањем можете додати индикаторе навигације на слајд-шоу, при његовом дну.';
$string['sliderintervalsetting'] = 'Временски интервал приказивања слајда';
$string['sliderintervalsetting_desc'] = 'Са овим подешавањем контролишете колико дуго ће слајд дуго бити приказан, у милисекундама. Минимална вредност је 1000 (једна секунда), а максимална вредност је 10000 (10 секунди).';
$string['sliderkeyboardsetting'] = 'Дозволи интеракцију тастатуре са слајдовима';
$string['sliderkeyboardsetting_desc'] = 'Са овим подешавањем омогућавате да слајд-шоу може да се контролише путем тастатуре (тастери са стрелицама). Имајте на уму да ће уколико онемогућите ову опцију,  бити смањена приступачност сајту.';
$string['sliderpausesetting'] = 'Паузирајте слајд-шоу при преласку миша преко слајда';
$string['sliderpausesetting_desc'] = 'Са овим подешавањем спречавате слајд-шоу да кружи кроз слајдове када корисник пређе мишем преко слајда. Имајте на уму да ће уколико онемогућите ову опцију,  бити смањена приступачност сајту.';
$string['sliderridesetting'] = 'Циклично понаваљање слајдова';
$string['sliderridesetting_afterinteraction'] = 'Након интеракције';
$string['sliderridesetting_desc'] = 'Са овим подешавањем контролишете циклично понављање слајд-шоу презентације. \'При учитавању странице\' - слајд-шоу почиње да кружи кроз слајдове након што се заврши учитавање странице, \'Након интеракције\' - слајд-шоу почиње да кружи кроз слајдове након што корисник ступи у интеракцију са слајдом. \'Никад\' - ова опција потпуно онемогућава аутоматски циклично понављање слајдова.';
$string['sliderridesetting_never'] = 'Никад';
$string['sliderridesetting_onpageload'] = 'При учитавању странице';
$string['slidertab'] = 'Слајд-шоу';
$string['sliderwrapsetting'] = 'Непрекидно кружење кроз све слајдове';
$string['sliderwrapsetting_desc'] = 'Са овим подешавањем, слајд-шоу кружи кроз све слајдове. Ако ово онемогућите, слајд-шоу ће престати на последњем слајду.';
$string['smartmenus'] = 'Паметни менији';
$string['smartmenus_desc'] = '<p>Паметни менији омогућавају администраторима сајта да креирају прилагодљиве меније који се могу поставити на различите места на сајту, као што су главни мени сајта, покретни мени на дну странице и кориснички мени. Менији се могу конфигурисати тако да приказују различите типове садржаја, укључујући линкове ка другим страницама или ресурсима, линкове ка категоријама или линкове ка корисничким профилима.</p><p>Администратори сајта могу да креирају нови мени, да одреде ставке у њему, као и да подесе како ће мени бити приказан. Администратор такође може да изабере где ће мени бити приказан на сајту и да ли треба да буде видљив свим корисницима или само одређеним корисничким улогама.</p>';
$string['smartmenusbyadmin'] = 'Ко види паметне меније';
$string['smartmenusbyadmin_admins'] = 'Само администратори сајта';
$string['smartmenusbyadmin_all'] = 'Сви корисници';
$string['smartmenusbyadmin_help'] = 'Ограничите видљивост на основу чињенице да ли је корисник администратор сајта или не.';
$string['smartmenusbyadmin_nonadmins'] = 'Само не-администратори';
$string['smartmenusbycohort'] = 'Према кохорти';
$string['smartmenusbycohort_help'] = 'Ограничите видљивост на основу кохорте корисника.';
$string['smartmenusbydate'] = 'Према датуму';
$string['smartmenusbydate_help'] = 'Ограничите видљивост на основу датума';
$string['smartmenusbydatefrom'] = 'Од';
$string['smartmenusbydatefrom_help'] = 'Ограничите видљивост на период од овде наведеног датума';
$string['smartmenusbydateuntil'] = 'До';
$string['smartmenusbydateuntil_help'] = 'Ограничите видљивост на период до овде наведеног датума';
$string['smartmenusbylanguage'] = 'Према језику';
$string['smartmenusbylanguage_help'] = 'Ограничите видљивост на основу језика корисника';
$string['smartmenusbyrole'] = 'Према улози';
$string['smartmenusbyrole_help'] = 'Ограничите видљивост на основу улога корисника.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Статус завршетка';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'Списак ставки у менију динамичких курсева ће садржати све курсеве корисника који одговарају изабраном статусу завршетка. На пример, ако изаберете опцију  \'У току\' као статус завршетка, списак ставки у менију динамичких курсева ће садржати само оне курсеве на које корисник тренутно уписан.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Завршен';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Уписан';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'У току';
$string['smartmenusdynamiccoursescoursecategory'] = 'Категорија курсева';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'Динамички мени са списком курсева ће садржати све курсеве из изабраних категорије курсева.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Укључите поткатегорије';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Ако је ова опција означено, мени динамичких курсева ће такође садржати све курсеве из поткатегорија изабраних категорија курсева.';
$string['smartmenusdynamiccoursesdaterange'] = 'Временски период';
$string['smartmenusdynamiccoursesdaterange_help'] = 'Динамички мени са списком курсева ће садржавати све курсеве које спадају у изабрани временски период.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Будући';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Прошли';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Текући';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Улога на уписаном курсу';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'Динамички мени са списком курсева ће садржавати све курсеве у којима је корисник уписан са изабраном улогом.';
$string['smartmenusexperimental'] = 'Напомена: функција паметних менија се у потпуности може користити у тренутном стању имплементације, али се мора <em>сматрати као експериментална </em> због великог броја комбинација подешавања, која и даље могу изазвати неочекиване проблеме. Имајући ово у виду, молимо вас да детаљно и пажљиво тестирате своје паметне меније са свим њиховим појединачним подешавањима. Ако наиђете на било какве проблеме са паметним менијима, молимо вас да их пријавите на <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> са јасно описаним корацима, како би програмери могли да репродукују пријављени проблем.';
$string['smartmenusgeneralsectionheader'] = 'Општа подешавања';
$string['smartmenusmenuaddnewitem'] = 'Додајте ставку менија';
$string['smartmenusmenucardform'] = 'Облик картице';
$string['smartmenusmenucardform_help'] = 'Изаберите облик картице за меније у стилу картице, бирајући између квадрата, портретретне/пејзажне оријентације или пуне ширине.';
$string['smartmenusmenucardformfullwidth'] = 'Пуна ширина';
$string['smartmenusmenucardformlandscape'] = 'Пејзажна оријентација';
$string['smartmenusmenucardformportrait'] = 'Портретна оријентација';
$string['smartmenusmenucardformsquare'] = 'Квадрат';
$string['smartmenusmenucardoverflowbehavior'] = 'Понашање картице код предугих ставки';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Изаберите како да се понаша мени када дужина назива ставки превазилази ширину менија, бирајући између приказивања хоризонталне клизне траке или преламања назива ставки.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Без преламања';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Преламање назива ставки';
$string['smartmenusmenucardsize'] = 'Величина картице';
$string['smartmenusmenucardsize_help'] = 'Изаберите величину картице за меније у стилу картице, бирајући између веома мале (50 пиксела), мале (100), средње (150) или велике картице (200).';
$string['smartmenusmenucardsizelarge'] = 'Велика';
$string['smartmenusmenucardsizemedium'] = 'Средња';
$string['smartmenusmenucardsizesmall'] = 'Мала';
$string['smartmenusmenucardsizetiny'] = 'Веома мала';
$string['smartmenusmenucreate'] = 'Креирајте мени';
$string['smartmenusmenucreatesuccess'] = 'Паметни мени је успешно креиран';
$string['smartmenusmenucssclass'] = 'CSS класа';
$string['smartmenusmenucssclass_help'] = 'Унесите CSS класу за мени. Ово се може користити за примену прилагођеног стила на мени.';
$string['smartmenusmenudeleteconfirm'] = 'Да ли сте сигурни да желите да обришете овај мени из паметних менија?';
$string['smartmenusmenudeletesuccess'] = 'Паметни мени је успешно обрисан';
$string['smartmenusmenudescription'] = 'Опис';
$string['smartmenusmenudescription_help'] = 'Опис менија. Ово ће се првенствено користити као интерна документација, али га можете приказати и у менију помоћу опције \'Прикажи опис\'.';
$string['smartmenusmenuduplicate'] = 'Дуплирајте мени и његове ставке';
$string['smartmenusmenuduplicatesuccess'] = 'Мени и његове ставке су успешно дуплиране';
$string['smartmenusmenuedit'] = 'Уреди мени';
$string['smartmenusmenueditsuccess'] = 'Паметни мени је успешно ажуриран';
$string['smartmenusmenuitemcardappearanceheader'] = 'Изглед картице';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Позадинска боја картице';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Изаберите позадинску боју за картицу ставке у менију';
$string['smartmenusmenuitemcardimage'] = 'Слика картице';
$string['smartmenusmenuitemcardimage_help'] = 'Изаберите слику која ће бити приказана поред наслова ставке у менију на картици.';
$string['smartmenusmenuitemcardimagealt'] = 'Алтернативни текст слике картице';
$string['smartmenusmenuitemcardtextcolor'] = 'Боја текста на картици';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Изаберите боју за картицу ставке у менију.';
$string['smartmenusmenuitemcreate'] = 'Креирајте ставку у менију';
$string['smartmenusmenuitemcreatesuccess'] = 'Ставка у паметном менију је успешно креирана';
$string['smartmenusmenuitemcssclass'] = 'CSS класа';
$string['smartmenusmenuitemcssclass_help'] = 'Унесите CSS класу за ставку у менију. Ово се може користити за примену прилагођеног стила на ставку у менију.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Да ли сте сигурни да желите да обришете ову ставку менија из паметног менија?';
$string['smartmenusmenuitemdeletesuccess'] = 'Ставка у паметном менију је успешно обрисана';
$string['smartmenusmenuitemdisplayfield'] = 'Приказ назива курса';
$string['smartmenusmenuitemdisplayfield_help'] = 'Назив курса који ће се користити као наслов ставки у динамичком менија курсева. Изаберите између пуног и скраћеног назива курса';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Пун назив курса';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Скраћени назив курса';
$string['smartmenusmenuitemdisplayoptions'] = 'Приказ наслова ставке';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Изаберите како желите да буде приказан наслов ставке у менију.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Сакријте текст наслова и прикажите само иконицу (на свим уређајима)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Сакријте текст наслова и прикажите само иконицу (мобилни уређаји)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Прикажи текст и иконицу као наслов';
$string['smartmenusmenuitemduplicate'] = 'Дуплирајте ставку у менију';
$string['smartmenusmenuitemduplicatesuccess'] = 'Ставка у менију је успешно дуплирана';
$string['smartmenusmenuitemedit'] = 'Уреди ставку у менију';
$string['smartmenusmenuitemeditsuccess'] = 'Ставка у паметном менију је успешно ажурирана';
$string['smartmenusmenuitemicon'] = 'Иконица';
$string['smartmenusmenuitemicon_help'] = 'Иконица која се приказује поред наслова ставке у менију.';
$string['smartmenusmenuitemlinktarget'] = 'Одредиште линка';
$string['smartmenusmenuitemlinktarget_help'] = 'Одредиште линка ставке у менију. Линк ће се отворити у овом одредишту када се кликне на њега (тј. у истом или у новом прозору).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Нови прозор';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Исти прозор';
$string['smartmenusmenuitemlistsort'] = 'Сортирање списка курсева';
$string['smartmenusmenuitemlistsort_help'] = 'Списак курсева биће сортиран према изабраним критеријумима и редоследу сортирања. Изаберите између пуног назив, скраћеног назива, ID ознаке курса и ID броја курса као критеријума у комбинацији са растућим и опадајућим редоследом сортирања.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'ID ознака курса растућим редоследом';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'ID ознака курса опадајућим редоследом';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'ID број курса растућим редоследом';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'ID број курса опадајућим редоследом';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Пун назив курса растућим редоследом';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Пун назив курса опадајућим редоследом';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Скраћени назив курса растућим редоследом';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Скраћени назив курса опадајућим редоследом';
$string['smartmenusmenuitemmode'] = 'Режим приказа ставке у менију';
$string['smartmenusmenuitemmode_help'] = '<p>Изаберите начин на који ће ставке бити приказана у оквиру самог менија.</p><ul><li>Директно: Ставка се приказује као обична ставка у оквиру менија. Ово је подразумевана опција.<li><li>Подмени: ставка се приказује као ставка у подменију, која се може проширити или скупити кликом на надређену ставку. Овај режим је користан за формирање трећег нивоа навигације, као и за ставке у менију динамичких курсева, где спискови курсева могу бити приказани као ставке у подменију ове ставке у (главном) менију. Наслов ове ставке у менију се користи као текст за ставку у  подменију.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Још увек није додата ниједна ставка у овај паметни мени. Молимо додајте ставку у овај мени.';
$string['smartmenusmenuitemorder'] = 'Редослед';
$string['smartmenusmenuitemorder_help'] = 'Промените положај ставке ако је потребно. Све ставке у менију биће поређане на основу ове вредности за редослед.';
$string['smartmenusmenuitempresentationheader'] = 'Приказ ставки у менију';
$string['smartmenusmenuitemresponsive'] = 'Прилагодљиво скривање ставки у менију';
$string['smartmenusmenuitemresponsive_help'] = 'Ако означите било које од ових поља за потврду, ставка у менију ће бити скривена на уређајима са датом величином екрана, односно уређајима које сте овде означили.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Стони рачунар';
$string['smartmenusmenuitemresponsivemobile'] = 'Мобилни телефон';
$string['smartmenusmenuitemresponsivetablet'] = 'Таблет';
$string['smartmenusmenuitemrestriction'] = 'Правила приступа';
$string['smartmenusmenuitems'] = 'Ставке у менију';
$string['smartmenusmenuitemstructureheader'] = 'Структура менија';
$string['smartmenusmenuitemtextcount'] = 'Број речи';
$string['smartmenusmenuitemtextcount_help'] = 'Одредите максималан број речи које ће бити приказан као наслов у ставкама у менију динамичких курсева. Ако оставите ово поље празно, наслов ће бити приказан у пуној дужини.';
$string['smartmenusmenuitemtextposition'] = 'Позиција текста на картици';
$string['smartmenusmenuitemtextposition_help'] = '<p>Изаберите позицију текста ставке у менију у односу на слику картице, бирајући између опција: испод слике, преклапајући натпис на врху односно на дну.</p><ul><li>Преклапајући натпис на врху: приказује наслов ставке у менију као транспарентни преклапајући прозор на врху картице.</li><li>Преклапајући натпис на дну: приказује наслов ставке у менију као транспарентни преклапајући прозор на дну картице.</li><li>Испод слике: приказује наслов ставке у менију испод слике картице.</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Испод слике';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Преклапајући натпис на дну';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Преклапајући натпис на врху';
$string['smartmenusmenuitemtitle'] = 'Наслов';
$string['smartmenusmenuitemtitle_help'] = 'Наслов менија. Ово ће се користити као натпис ове ставке у менију. Ако желите да прикажете сепаратор у менију, изаберите Наслов као тип ставке и користите хеш знакове (###) као наслов.';
$string['smartmenusmenuitemtooltip'] = 'Кратак опис ставке';
$string['smartmenusmenuitemtooltip_help'] = 'Кратак опис ставке који ће бити приказан када корисник пређе мишем преко ставке у менију.';
$string['smartmenusmenuitemtype'] = 'Тип ставке у менију';
$string['smartmenusmenuitemtype_help'] = '<p>Изаберите тип ставке у менију коју желите да креирате, бирајући између статичке ставке, наслова и динамичких курсева.</p><ul><li>Статичка ставка: ово је једноставан линк ка фиксној URL адреси која се не мења.</li><li>Наслов: овај тип ставке у менију се користи за груписање сродних, повезаних ставки под заједничким насловом. Овај тип нема линк и на њега се не може кликнути.</li><li>Динамички курсеви: овај тип ставке се користи за приказ списка курсева на основу одређених критеријума, као што су категорија курса, улога на уписаном курсу, статус завршетка курса или временски период. Садржај приказан у овом типу менија ће се аутоматски ажурирати како се критеријуми мењају.</li></ul>';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Динамички курсеви';
$string['smartmenusmenuitemtypeheading'] = 'Наслов';
$string['smartmenusmenuitemtypestatic'] = 'Статичка ставка';
$string['smartmenusmenuitemurl'] = 'URL адреса ставке у менију';
$string['smartmenusmenuitemurl_help'] = 'Статичка URL адреса ставке у менију. Ово је линк ка страници која ће се отворити када се кликне на ставку у менију.';
$string['smartmenusmenulocation'] = 'Позиција(е) менија';
$string['smartmenusmenulocation_help'] = '<p>Изаберите позицију(е) на којој желите да се мени појави на страници:</p><ul><li>Главна навигација је на врху странице где се већ налазе ставке навигације \'Почетна страница\', \'Контролни панел\', \'Моји курсеви\' и \'Администрација сајта\'.</li><li>Трака менија се налази изнад главне навигације, на врху странице.<li><li>Корисничком менију се може приступити кликом на аватар корисника на траци за навигацију.</li><li>Доња трака се налази на дну екрана и веома је корисна за навигацију на мобилним телефонима јер се помоћу палца може лако приступ важним пољима на страници, као што су контролни панел, страници \'Моји курсеви\' или почетној страници.</li></ul><p>Имајте на уму да ће након што омогућите доњу траку, иконица хамбургера бити замењена логотипом вашег сајта, јер корисници могу да дођу до главне навигације помоћу доње траке.</p>';
$string['smartmenusmenulocationbottom'] = 'Доња трака';
$string['smartmenusmenulocationmain'] = 'Главна навигација';
$string['smartmenusmenulocationmenu'] = 'Трака менија';
$string['smartmenusmenulocationuser'] = 'Кориснички мени';
$string['smartmenusmenumode'] = 'Режим менија';
$string['smartmenusmenumode_help'] = '<p>Изаберите начин на који ће ставке у менију бити приказане.</p><ul><li>Подмени: ставке у менију се приказују као подмени са насловом менија као надређеним чвором. Ово је подразумевана опција.</li><li>Директно: Ставке у менију се приказују директно у навигацији, једна за другом. Имајте на уму да ова опција није подржана за меније типа картице.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Понашање додатних менија';
$string['smartmenusmenumoremenubehavior_help'] = '<p> Изаберите шта би требало да се деси ако има превише менија који би могли да се уклопе у позицију(е) менија, коју(е) сте изабрали.</p><ul><li>Не мењајте ништа: Неће се примењивати никакво посебно понашање, вишак менија ће аутоматски бити премештен у мени \'Више\'.</li><li>Пребаците мени обавезно у мени \'Више\': Овај режим премешта мени директно у мени \'Више\', чак и ако још увек има довољно места.</li><li>Држите мени изван менија \'Више\': овај режим држи мени изван менија \'Више\' што је дуже могуће.</li></ul>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Пребаците мени обавезно у мени \'Више\'';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Држите мени изван менија \'Више\'';
$string['smartmenusmenunothingtodisplay'] = 'Још увек није креиран ниједан паметан мени. Креирајте свој први паметни мени како бисте га покренули.';
$string['smartmenusmenupresentationheader'] = 'Приказ менија';
$string['smartmenusmenushowdescription'] = 'Прикажи опис';
$string['smartmenusmenushowdescription_help'] = '<p>Изаберите да ли и како опис треба да буде приказан у менију, бирајући између следећих опција: Никад, Изнад, Испод и Помоћ.</p><ul><li>Никад: не приказујте опис у менију и користите га само за интерне сврхе. Ово је подразумевана опција.</li><li>Изнад: прикажи опис на врху списка ставки у менију.</li><li>Испод: прикажи опис на крају списка ставки у менију.</li><li>Помоћ: покажи опис као иконицу за помоћ у близини списка ставки у менију.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Изнад';
$string['smartmenusmenushowdescriptionbelow'] = 'Испод';
$string['smartmenusmenushowdescriptionhelp'] = 'Помоћ';
$string['smartmenusmenushowdescriptionnever'] = 'Никада';
$string['smartmenusmenustructureheader'] = 'Структура менија';
$string['smartmenusmenutitle'] = 'Наслов';
$string['smartmenusmenutitle_help'] = 'Наслов менија. Ово ће се користити као натпис надређеног чвора овог менија.';
$string['smartmenusmenutype'] = 'Тип приказа менија';
$string['smartmenusmenutype_help'] = '<p>Изаберите тип приказа менија, бирајући између списка и картице.</p><ul><li>Списак: мени се састоји од списка једноставних текстуалних линкова. Ово је подразумевана опција.</li><li>Картица: мени се састоји од картица.</li></ul>';
$string['smartmenusmenutypecard'] = 'Картица';
$string['smartmenusmenutypelist'] = 'Списак';
$string['smartmenusmodeinline'] = 'Директно';
$string['smartmenusmodesubmenu'] = 'Подмени';
$string['smartmenusnorestrict'] = 'Није ограничено';
$string['smartmenusoperator'] = 'Логички оператор';
$string['smartmenusoperator_help'] = 'Изаберите оператор за услов кохорте (било који или сви)';
$string['smartmenusrestrictbyadminheader'] = 'Ограничите видљивост према статусу администратора сајта';
$string['smartmenusrestrictbycohortsheader'] = 'Ограничите видљивост према кохортама';
$string['smartmenusrestrictbydateheader'] = 'Ограничите видљивост према датуму';
$string['smartmenusrestrictbylanguageheader'] = 'Ограничите видљивост према језику';
$string['smartmenusrestrictbyrolesheader'] = 'Ограничите видљивост према улогама';
$string['smartmenusrolecontext'] = 'Контекст';
$string['smartmenusrolecontext_help'] = 'Изаберите контекст за који треба проверити улогу корисника (било који контекст или само у контексту система)';
$string['smartmenussavechangesandconfigure'] = 'Сачувајте и конфигуришите ставке';
$string['smartmenussettings'] = 'Подешавања паметног менија';
$string['speciallinksmarkupheading'] = 'Означавање специјалних линкова';
$string['staticpagestab'] = 'Статичне странице';
$string['switchedroleto'] = 'Тренутно посматрате овај курс са улогом: <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Очистите кеш теме';
$string['templateemailhtmlprefix'] = '';
$string['templateemailhtmlsuffix'] = '';
$string['templateemailtextprefix'] = '';
$string['templateemailtextsuffix'] = '';
$string['tilebackgroundimagepositionsetting'] = 'Позиција позадинске слике рекламне плочице {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Са овим подешавањем контролишете позиционирање позадинске слике унутар контејнера рекламне плочице  {$a->no}. Прва вредност је хоризонтални, друга вертикални положај.';
$string['tilebackgroundimagesetting'] = 'Позадинска слика рекламне плочице {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Овде можете да поставите датотеку слике која ће бити приказана као позадинска слика иза садржаја рекламне плочице {$a->no}. Проверите да ли је садржај и даље читљив на позадинској слици. Ово је опционо подешавање, рекламна плочица ће бити приказана чак и ако не поставите позадинску слику.';
$string['tilecolumnssetting'] = 'Број колона рекламних плочица по реду';
$string['tilecolumnssetting_desc'] = 'Овде дефинишете број колона по реду у приказаној мрежи рекламних плочица. Имајте на уму да се овај број колона односи на десктоп/веће екране. На мањим екранима и мобилним екранима, колоне рекламних плочица се аутоматски пакују.';
$string['tilecontentsetting'] = 'Садржај рекламне плочице {$a->no}';
$string['tilecontentsetting_desc'] = 'Овде уносите садржај који треба да буде приказан у рекламној плочици {$a->no}. Садржај се приказује у средини плочице. Ово је опционо подешавање, рекламна плочица ће бити приказана чак и ако не поставите никакав садржај.';
$string['tilecontentstylesetting'] = 'Стил садржаја рекламне плочице {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Тамно (црна боја фонта за светле позадинске слике)';
$string['tilecontentstylesetting_darkshadow'] = 'Тамно са сенком (црна боја фонта са светлом сенком за светле позадинске слике)';
$string['tilecontentstylesetting_desc'] = 'Овде можете да измените стил садржаја рекламне плочице {$a->no}. Стандардно, стил садржаја је под контролом стила који сте подесили у едитору текста изнад. Међутим, да бисте омогућили доследан и лак стил, посебно када користите текст на позадинским сликама, овде можете изменити стил.';
$string['tilecontentstylesetting_light'] = 'Светло (бела боја фонта за тамне позадинске слике)';
$string['tilecontentstylesetting_lightshadow'] = 'Светло са сенком (бела боја фонта са тамном сенком за тамне позадинске слике)';
$string['tilecontentstylesetting_nochange'] = 'Без промена (контролишите све стилове у едитору текста)';
$string['tileenabledsetting'] = 'Омогућите рекламну плочицу {$a->no}';
$string['tileenabledsetting_desc'] = 'Са овим подешавањем можете омогућити рекламну плочицу {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Позиција рекламних плочица на насловној страници';
$string['tilefrontpagepositionsetting_after'] = 'Након садржаја насловне странице';
$string['tilefrontpagepositionsetting_before'] = 'Пре садржаја насловне странице';
$string['tilefrontpagepositionsetting_desc'] = 'Рекламне плочице се приказују само на насловној страници сајта. Са овим подешавањем контролишете да ли се рекламне плочице приказују пре или после садржаја насловне странице. Ако на насловној страници сајта желите да прикажете само рекламне плочице  и ништа друго, сав остали садржај насловне странице можете уклонити променом <a href="{$a->url}">подешавања насловне странице</a>.';
$string['tileheading'] = 'Рекламна плочица {$a->no}';
$string['tileheightsetting'] = 'Висина рекламних плочица';
$string['tileheightsetting_desc'] = 'Са овим подешавање контролишете висину рекламних плочица. Конфигурисана висина је минимална висина сваке плочице. Ако је садржај плочице већи од ове висине, цео ред плочица биће аутоматски увећан по потреби.';
$string['tilelinksetting'] = 'URL адреса линка рекламне плочице {$a->no}';
$string['tilelinksetting_desc'] = 'Овде можете подесити (Moodle-интерну или екстерну) URL адресу која ће бити понуђена као линк за дугме за на дну рекламне плочице {$a->no}. Ово је опционо подешавање, рекламне плочице ће бити приказана чак и ако не подесите URL адресу линка.';
$string['tilelinktargetsetting'] = 'Одредиште линка рекламне плочице {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Овде можете да подесите одредиште линка који је постављен као линк дугмета чим поставите URL адресу линка у рекламној плочици {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Нови прозор';
$string['tilelinktargetsetting_samewindow'] = 'Исти прозор';
$string['tilelinktitlefallback'] = 'Линк';
$string['tilelinktitlesetting'] = 'Наслов линка рекламне плочице {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Овде можете подесити наслов линка, који се користи као натпис на дугмета линка чим унесете URL адресе линка у рекламну плочицу {$a->no}. Имајте на уму да уколико унесете URL адресу, али не и наслов линка, дугме линка биће означено натписом \'Линк\'';
$string['tileordersetting'] = 'Позиција рекламне плочице {$a->no}';
$string['tileordersetting_desc'] = 'Са овим подешавањем дефинишете позицију рекламне плочице {$a->no}. Стандардно, рекламне плочице су поређане одозго према доле и са лева на десно, као што их видите на овој страници са подешавањима. Међутим, са овим подешавањем можете рекламној плочици да доделите другу позицију. Ако доделите исту позицију за две или више рекламних плочица, оне ће бити поново поређане према редоследу на овој страници са подешавањима.';
$string['tilesgeneralheading'] = 'Општа подешавања рекламних плочица';
$string['tilestab'] = 'Рекламне плочице';
$string['tiletitlesetting'] = 'Наслов рекламне плочице {$a->no}';
$string['tiletitlesetting_desc'] = 'Овде уносите наслов који треба да буде приказан у рекламној плочици {$a->no}. Ово је опционо подешавање, рекламна плочица ће бити приказана чак и ако не унесете њен наслов.';
$string['touchiconfilesios'] = 'Датотека иконица осетљивих на додир за iOS';
$string['touchiconfilesios_desc'] = 'У оквиру овог подешавања, можете да поставите датотеке које се користе као иконице на почетном екрану чим се Moodle сајт дода на iOS почетни екран.';
$string['touchiconfilesios_example'] = 'Пример назива датотеке: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Препоручене датотеке имају одговарајућу величину за приказ на тренутним iOS уређајима те би их требало обезбедити. Опционе датотеке јесу (или су раније биле) подржане и на iOS уређајима, али их заиста треба сматрати опционим осим ако немате одређене застареле уређаје које треба подржати.';
$string['touchiconfilesios_optional'] = 'Опционе датотеке за iOS:';
$string['touchiconfilesios_recommended'] = 'Препоручене датотеке за iOS:';
$string['touchiconfilesioslist'] = 'Списак датотека иконица осетљивих на додир за iOS';
$string['touchiconfilesioslist_desc'] = 'Ово је списак датотека које сте поставили у простор за датотеке међу датотеке иконица осетљивих на додир за iOS.';
$string['touchiconlistiosoptionalmissing'] = 'Ово је опциона датотека, која се користи као иконица осетљива на додир на iOS уређајима, и која није постављена.';
$string['touchiconlistiosoptionaluploaded'] = 'Ово је опциона датотека, која се користи као иконица осетљива на додир на iOS уређајима, и која је постављена.';
$string['touchiconlistiosrecommendedmissing'] = 'Ово је препоручена датотека, која се користи као иконица осетљива на додир на iOS уређајима, и која није правилно постављена.';
$string['touchiconlistiosrecommendeduploaded'] = 'Ово је препоручена датотека, која се користи као иконица осетљива на додир на iOS уређајима, и која је постављена.';
$string['upgradenotice_2022080922'] = 'Од ове верзије, Boost Union има сопствени лого и подешавања компактног логотипа, и више не користи ове датотеке из основних подешавања Moodlea.';
$string['upgradenotice_2022080922_copied'] = 'Постојеће подешавање <strong>{$a}</strong> копирано је из основних подешавања Moodlea у Boost Union подешавање {$a} током ове надоградње. Молимо вас да још једном проверите резултат.';
$string['upgradenotice_2022080922_logo'] = 'лого';
$string['upgradenotice_2022080922_logocompact'] = 'компактан лого';
$string['upgradenotice_2022080922_notcopied'] = 'Подешавање <strong>{$a}</strong> у оквиру теме LearnR је сада празно. Ако од сада желите да користите {$а} у оквиру теме LearnR, само га касније поставите у Boost Union подешавање {$a}.';
$string['usermenuheading'] = 'Кориснички мени';
$string['warningslashargumentsdisabled'] = 'Упозорење: <a href="{$a->url}">подешавање аргумената са косом цртом</a> је онемогућено у вашој тренутној Moodle конфигурацији. Међутим, ово подешавање је потребно за исправан рад следећег Boost Union подешавања. Молимо вас да омогућите аргументе са косом цртом, иначе следеће Boost Union подешавање неће имати ефекта.';
