<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'pt_br', version '4.1'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acesso negado';
$string['accounts'] = 'Contas';
$string['addcategory'] = 'Adicionar uma categoria';
$string['additionalhtml'] = 'Código HTML adicional';
$string['additionalhtml_desc'] = 'Essas configurações permitem especificar o HTML que você deseja adicionar a cada página. Você pode definir o HTML que será adicionado dentro da tag HEAD para a página, imediatamente após a tag BODY ter sido aberta ou imediatamente antes que a tag body seja fechada.<br/>Fazendo isso, você pode adicionar cabeçalhos ou rodapés personalizados em cada página, ou adicionar suporte para serviços como o Google Analytics com muita facilidade, independentemente do tema escolhido.';
$string['additionalhtml_heading'] = 'HTML adicional a ser incluído em cada página.';
$string['additionalhtmlfooter'] = 'Antes da tag BODY ser fechada';
$string['additionalhtmlfooter_desc'] = 'Este conteúdo será adicionado em cada página antes da tag body ser fechada.';
$string['additionalhtmlhead'] = 'Dentro da tag HEAD';
$string['additionalhtmlhead_desc'] = 'Este conteúdo será adicionado na parte inferior da tag HEAD de cada página.';
$string['additionalhtmltopofbody'] = 'Quando a tag BODY está aberta';
$string['additionalhtmltopofbody_desc'] = 'Este conteúdo será adicionado em cada página imediatamente depois da abertura da tag BODY.';
$string['admincategory'] = 'Categoria: {$a}';
$string['adminseesall'] = 'Administradores veem tudo';
$string['adminseesallevents'] = 'Os administradores veem todos os eventos';
$string['adminseesownevents'] = 'Os administradores são como os outros usuários';
$string['advancedfeatures'] = 'Recursos avançados';
$string['agedigitalconsentverification'] = 'Verificação da Idade legal para autorização';
$string['agedigitalconsentverification_desc'] = 'Habilita a verificação da idade legal para autorização antes de disponibilizar a página de cadastro para o  auto registro dos usuários. Isto protege o seu domínio de menores registrarem-se sem consentimento dos pais ou responsável legal.  Para ajuda e maiores detalhes <a target="_blank" href="{$a}">contate o suporte</a> .';
$string['ageofdigitalconsentmap'] = 'Idade legal para autorização';
$string['ageofdigitalconsentmap_desc'] = 'A idade padrão legal para autorização, e a idade em qualquer país onde isto difere do padrão, pode ser especificada aqui. Forneça cada idade em uma nova linha com o formato: código do país, idade (separados por virgula). O idade padrão é indicada por * em lugar do código do país. Códigos dos países são especificados de acordo com a ISO 3166-2.';
$string['allcountrycodes'] = 'Todos os códigos de países';
$string['allowattachments'] = 'Permitir anexos em mensagens de e-mail';
$string['allowbeforeblock'] = 'A lista de permissões será processada primeiro';
$string['allowbeforeblockdesc'] = 'Por padrão, as entradas na lista de IPs bloqueados são processadas primeiro. Se essa opção for ativada, as entradas na lista de IPs permitidos são processadas antes da lista de bloqueados.';
$string['allowcategorythemes'] = 'Permitir temas de categorias';
$string['allowcohortthemes'] = 'Permitir temas por coorte';
$string['allowcoursethemes'] = 'Permitir temas de cursos';
$string['allowedemaildomains'] = 'Domínios de e-mail permitidos';
$string['allowediplist'] = 'Lista de IP permitidos';
$string['allowemailaddresses'] = 'Domínios de email permitidos';
$string['allowemojipicker'] = 'Seletor de emojis';
$string['allowframembedding'] = 'Permitir incorporação (embed) de frames';
$string['allowframembedding_help'] = 'Se ativado, este site pode ser incorporado em um frame em um sistema remoto, como recomendado se estiver utilizando plugin de inscrição \'Publicar como ferramenta LTI\'. Caso contrário, recomenda-se a deixar a incorporação de frame  desativada por motivos de segurança. Por favor, observe também que, para o aplicativo móvel essa configuração é ignorada e incorporar frame é sempre permitido.';
$string['allowguestmymoodle'] = 'Permitir acesso de convidado ao Painel';
$string['allowindexing'] = 'Permitir indexação pelos motores de busca';
$string['allowindexing_desc'] = 'Determina se os mecanismos de busca podem indexar seu site. "Em todos os lugares" permitirá aos motores de busca pesquisem em todos os lugares, incluindo páginas de login e cadastro. Para evitar o risco de spam envolvendo a página de cadastro, utilize "Em toda parte, exceto páginas de login e cadastro". "Lugar nenhum" dirá aos motores de busca para não indexar nenhuma página. Note que isto é apenas uma tag no cabeçalho do site. Cabe ao motor de busca respeitar ou não a tag.';
$string['allowindexingeverywhere'] = 'Em toda parte';
$string['allowindexingexceptlogin'] = 'Em toda parte exceto páginas de login e cadastro';
$string['allowindexingnowhere'] = 'Lugar nenhum';
$string['allowobjectembed'] = 'Permitir tags EMBED e OBJECT';
$string['allowthemechangeonurl'] = 'Permitir mudanças de tema na URL';
$string['allowuserblockhiding'] = 'Permitir que usuários ocultem blocos';
$string['allowusermailcharset'] = 'Permitir que usuários escolham set de caracteres';
$string['allowuserswitchrolestheycantassign'] = 'Permitir que usuários sem a permissão de atribuir papel troquem de papel';
$string['allowuserthemes'] = 'Permitir temas de usuários';
$string['alternativefullnameformat'] = 'Formato de nome completo alternativo';
$string['alternativefullnameformat_desc'] = 'Esta opção define como os nomes são exibidos para usuários com a capacidade viewfullnames (por padrão, os usuários com o papel de gestor, professor ou professor-não-editor). Placeholders que podem ser utilizados são os mesmos da configuração de "formato de nome completo".';
$string['always'] = 'Sempre';
$string['appearance'] = 'Aparência';
$string['aspellpath'] = 'Caminho para o aspell';
$string['asyncbackupdisabled'] = 'Seu site está atualmente configurado para usar backups síncronos. Os backups assíncronos proporcionam uma melhor experiência do usuário.
Os backups assíncronos serão habilitados para todos os sites do Moodle LMS 4.5 LTS.
Os backups síncronos serão removidos do Moodle LMS na versão posterior à 4.5 LTS';
$string['authentication'] = 'Autenticação';
$string['authpreventaccountcreation'] = 'Impedir a criação de conta ao autenticar';
$string['authpreventaccountcreation_help'] = 'Quando um usuário se autentica, uma conta no site é automaticamente criada caso ainda não exista. Se um banco de dados externo, como o LDAP, for utilizado para autenticação, mas você deseja restringir o acesso ao site somente para os usuários que já possuam conta, então essa opção deverá ser ativada. Neste caso, novas contas terão de ser criadas manualmente ou por meio do recurso  de upload de usuários. Note que esta definição não se aplica à autenticação MNet.';
$string['authsettings'] = 'Gerenciar autenticação';
$string['autolang'] = 'Detecção automática de idioma';
$string['autolangusercreation'] = 'Na criação da conta, definir o idioma do navegador do usuário como seu idioma preferido';
$string['autologinguests'] = 'Fazer login automático de visitantes';
$string['availableto'] = 'Disponível para';
$string['availabletoanyone'] = 'Disponível para qualquer pessoa que visite o site';
$string['availabletoauthenticated'] = 'Limitado aos usuários autenticados';
$string['backgroundcolour'] = 'Cor transparente';
$string['backup_shortname'] = 'Usar nome do curso no nome do arquivo de backup';
$string['backup_shortnamehelp'] = 'Use o nome do curso como parte do nome do arquivo de backup.';
$string['backups'] = 'Backups';
$string['badwordsconfig'] = 'Insira a sua lista de palavrões separados por vírgulas.';
$string['badwordsdefault'] = 'Se a lista personalizada estiver vazia, a lista padrão do idioma correspondente será utilizada.';
$string['badwordslist'] = 'Lista personalizada de palavrões';
$string['blockediplist'] = 'Lista de IPs bloqueados';
$string['blockinstances'] = 'Instâncias';
$string['blockmultiple'] = 'Múltiplos';
$string['blockprotect'] = 'Proteger instâncias';
$string['blockprotect_help'] = 'Se você bloquear um determinado tipo de bloco, então ninguém será capaz de adicionar ou excluir instâncias. (Você pode, claro, desbloquear novamente se você precisar editar instâncias.)

Esse recurso tem o objetivo de proteger blocos, como a navegação, e configurações que são muito difíceis de se recuperar caso apagado acidentalmente.';
$string['blocksettings'] = 'Gerenciar blocos';
$string['blockunprotect'] = 'Desproteger';
$string['bloglevel'] = 'Visibilidade do blog';
$string['bookmarkadded'] = 'Favorito incluído.';
$string['bookmarkalreadyexists'] = 'Você já favoritou esta página.';
$string['bookmarkdeleted'] = 'Favorito excluído.';
$string['bookmarkthispage'] = 'Favoritar essa página';
$string['cacheapplication'] = 'Cache da aplicação';
$string['cacheapplicationhelp'] = 'Itens armazenados em cache são compartilhados entre todos usuários e expiram após um determinado tempo de vida (TTL).';
$string['cachejs'] = 'Fazer cache do Javascript';
$string['cachejs_help'] = 'As operações de "caching" e compressão do Javascript melhoram muito o desempenho do carregamento de páginas. Isso é altamente recomendável para sites de produção. Desenvolvedores provavelmente preferirão desabilitar esta opção.';
$string['cacherequest'] = 'Requisição cache';
$string['cacherequesthelp'] = 'Cache de usuário específico expira quando a requisição é concluída. Projetado para substituir áreas aonde nós estamos usando caches estáticos.';
$string['cachesession'] = 'Cache da sessão';
$string['cachesessionhelp'] = 'Cache específico de usuário que expira quando a sessão do usuário é finalizadas. Projetado para aliviar a tensão/sobrecarga na sessão.';
$string['cachesettings'] = 'Configurações de cache';
$string['cachetemplates'] = 'Cache de Templates';
$string['cachetemplates_help'] = 'O cache de template melhora o desempenho do carregamento da página e é altamente recomendado para sites de produção. Os desenvolvedores provavelmente optam por desativar esta funcionalidade.';
$string['caching'] = 'Caching';
$string['calendar_weekend'] = 'Dias de fim de semana';
$string['calendarexportsalt'] = 'Sal para exportação do calendário';
$string['calendarsettings'] = 'Calendário';
$string['calendartype'] = 'Tipo de calendário';
$string['calendartype_desc'] = 'Escolha um tipo de calendário padrão para todo o site. Esta configuração pode ser sobrescrita nas configurações do curso ou pelos usuários em seu perfil pessoal.';
$string['campaign'] = 'Campanha';
$string['cannotdeletemodfilter'] = 'Você não pode desinstalar o \'{$a->filter}\' porque ele é parte do módulo \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} não pode ser desinstalado.';
$string['categoryemail'] = 'E-mail';
$string['cfgwwwrootslashwarning'] = 'O valor de $CFG->wwwroot está definido incorretamente no seu arquivo config.php. Você incluiu um caractere \'/\' no final que deve ser removido.';
$string['cfgwwwrootwarning'] = 'O valor de $CFG->wwwroot está definido incorretamente no seu arquivo config.php. Ele deve corresponder ao URL que você está utilizando para acessar esta página.';
$string['change'] = 'mudar';
$string['checkboxno'] = 'Não';
$string['checkboxyes'] = 'Sim';
$string['checkupgradepending'] = 'Atualizações';
$string['choosefiletoedit'] = 'Escolha o arquivo a ser editado';
$string['cleanup'] = 'Limpar';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliexitgraceful'] = 'Saindo normalmente, por favor aguarde ...';
$string['cliexitnow'] = 'Saindo agora mesmo';
$string['cliincorrectvalueerror'] = 'Erro, valor incorreto "{$a->value}" para "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valor incorreto, por favor tente novamente';
$string['clistatusdisabled'] = 'Estado: desabilitado';
$string['clistatusenabled'] = 'Estado: habilitado';
$string['clistatusenabledlater'] = 'estado: modo de manutenção CLI será habilitado em {$a}';
$string['clitypevalue'] = 'digite o valor';
$string['clitypevaluedefault'] = 'digite o valor, pressione Enter para utilizar o valor padrão ({$a})';
$string['cliunknowoption'] = 'Opções não reconhecidas:
  {$a}
Por favor use a opção --help.';
$string['cliupgradedefault'] = 'Nova configuração: {$a}';
$string['cliupgradedefaultheading'] = 'Definindo novos valores padrão';
$string['cliupgradedefaultverbose'] = 'Nova configuração: {$a->name}, Valor padrão: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Atualização via linha de comando de {$a->oldversion} até {$a->newversion} completada com sucesso.';
$string['cliupgradenoneed'] = 'Nenhuma atualização necessária para a versão instalada {$a}. Obrigado por nos visitar de qualquer forma!';
$string['cliupgradepending'] = 'Uma atualização está pendente';
$string['cliyesnoprompt'] = 'digite s (sim) ou n (não)';
$string['close'] = 'Fechar';
$string['commentsperpage'] = 'Comentários exibidos por página';
$string['commonactivitysettings'] = 'Configurações comuns das atividades';
$string['commonfiltersettings'] = 'Configurações de filtro comum';
$string['commonsettings'] = 'Configurações padrão';
$string['componentinstalled'] = 'Componente instalado';
$string['computedfromlogs'] = 'Processados dos logs desde {$a}.';
$string['condifmodeditdefaults'] = 'Valores padrão são utilizados no formulário de configurações quando criando uma nova atividade ou recurso.';
$string['confeditorhidebuttons'] = 'Selecione os botões que devem ser escondidos no editor de HTML.';
$string['configallcountrycodes'] = 'Esta é a lista de países que podem ser selecionados em vários lugares, por exemplo no perfil de um usuário. Se estiver em branco (o padrão), a lista do countries.php no pacote de idioma padrão Inglês será usada. Essa é a lista da ISO 3166-1. Caso contrário, você pode especificar uma lista de códigos separados por vírgulas, por exemplo, \'GB,FR,ES\'. Se você adicionar novos códigos fora do padrão, você precisará adicioná-los ao countries.php em \'en\' e em seu próprio pacote de idioma.';
$string['configallowassign'] = 'Selecionar quais os papéis que cada papel na coluna da esquerda pode atribuir aos outros usuários.';
$string['configallowattachments'] = 'Se habilitado, emails enviados pelo site podem ter anexos, como "emblemas".';
$string['configallowcategorythemes'] = 'Habilitando esta opção, os temas poderão ser escolhidos a nível de categoria. Isso irá afetar todas as categorias e cursos filhos, a não ser que eles tenham seus próprios temas. AVISO: Habilitar temas de categorias pode afetar a performance.';
$string['configallowcohortthemes'] = 'Se você habilitar isto, então temas poderão ser definidos em nível de blocos. Isto é afetará todos os usuários com somente um bloco ou mais de um contudoo mesmo tema.';
$string['configallowcoursethemes'] = 'Se habilitado, os cursos podem ter seus próprios temas. Os temas do curso sobrepõem todas as outras escolhas de tema (tema de site, usuário, categoria, coorte ou definido por URL).';
$string['configallowedemaildomains'] = 'Lista domínio de email que são permitidos serem divulgados no campo "De" dos emails enviados. O padrão de "Vazio" usará o endereço de no-reply para todos os emails enviados. O uso de coringas é permitido, por exemplo: *.exemplo.com permitirá emails enviados de qualquer subdomínio de exemplo.com, mas não o próprio exemplo.com. Para isso será necessária uma entrada separada.';
$string['configallowemailaddresses'] = 'Para restringir novos endereços de emails para domínios particulares, liste-os aqui separados por espaços. Qualquer outro domínio será rejeitado. Para permitir subdomínios, escreva o domínio precedido por \'.\'. Para permitir um domínio raiz junto com seus domínios, adicione o domínio duas vezes - uma vez precedido de \'.\' e outra sem. Por exemplo: .nossafaculdade.edu.br nossafaculdade.edu.br.';
$string['configallowemojipicker'] = 'O seletor de emoticons permite que os usuários selecionem emojis, como smilies, para adicionar a mensagens e outras áreas de texto através de um botão do seletor de emoticons na barra de ferramentas Atto.';
$string['configallowemojipickerincompatible'] = 'A configuração atual do seu banco de dados não oferece suporte para emoticons. Para habillitar o seletor de emoticons, será preciso <a href="https://docs.moodle.org/37/en/MySQL_full_unicode_support">atualizar seu banco de dados para suporte unicode completo</a>.';
$string['configallowguestmymoodle'] = 'Se habilitado, os visitantes poderão acessar o Painel, caso contrário, serão redirecionados para a página principal do site.';
$string['configallowobjectembed'] = 'Como medida padrão de segurança, os usuários em geral não podem incluir multimídia (como Flash) em seus textos usando explicitamente as tags EMBED e OBJECT no seu HTMLv(embora seja possível o procedimento seguro usando o filtro mediaplugins). Se você deseja permitir essas tags, então habilite esta opção.';
$string['configallowoverride'] = 'Voce pode permitir que os papéis do lado esquerdo sobreponham alguns dos papéis na coluna';
$string['configallowoverride2'] = 'Selecionar quais papéis podem ser sobrepostos por cada papel na coluna da esquerda.<br />Esta configuração é aplicada apenas aos usuários que tem permissões emmoodle/role:override ou moodle/role:safeoverride.';
$string['configallowswitch'] = 'Para cada papel na coluna da esquerda, selecione quais papéis eles podem assumir.<br />Os usuários também devem ter o recurso moodle/role:switchroles. Os usuários também devem ter permissões em moodle/role:switchroles para poder mudar de papel.<br />Note que só é possível mudar para papéis que têm a permissão em moodle/course:view e que não têm a permissão em moodle/site:doanything, portanto algumas colunas desta tabela estão desabilitadas.';
$string['configallowthemechangeonurl'] = 'Se habilitado, o tema pode ser mudado acrescentando: <br />?theme=nomedotema a qualquer URL no Moodle (ex: meumoodle.com.br/?theme=nomedotema ) ou <br/>&theme=nomedotema a qualquer URL interna do Moodle (ex: meumoodle.com.br/course/view.php?id=2&theme=nomedotema).';
$string['configallowuserblockhiding'] = 'Permitir que os usuários escondam ou mostrem os blocos laterais deste site? Esta funcionalidade usa Javascript e cookies para lembrar que o estado de cada bloco afeta apenas o formato de visualização do próprio usuário.';
$string['configallowusermailcharset'] = 'Ativando isto cada usuário do site poderá escolher o próprio conjunto de caracteres para o email.';
$string['configallowuserswitchrolestheycantassign'] = 'Por padrão, moodle/role:assign é necessário para que os usuários troquem de papel. Habilitar esta configuração remove esta necessidade e faz com que os papéis disponíveis no menu "Mudar papel para..." sejam determinadas apenas pelas configurações na tabela "Permitir atribuir papéis". É recomendado que as configurações da tabela "Permitir atribuir papéis" não permitam que um usuário mude para um papel com mais permissões que o atual.';
$string['configallowuserthemes'] = 'Se esta opção estiver habilitada, os usuários poderão escolher seus próprios temas. Os temas do usuário se sobrepõem aos da plataforma (mas não aos temas do curso).';
$string['configallowview'] = 'Para cada papel da coluna esquerda, selecione quais papéis este papel pode ver, pesquisar e filtrar.';
$string['configallusersaresitestudents'] = 'Em atividades da página inicial da instalação, todos os usuários devem ser considerados estudantes? Se a resposta for "Sim", qualquer usuário cadastrado poderá participar como estudante nestas atividades. Se a resposta for "Não", só os usuários que já participam em pelo menos um curso poderão participar destas atividades. Apenas os administradores e os professores especialmente designados podem atuar como professores nestas atividades da página inicial.';
$string['configauthenticationplugins'] = 'Por favor escolha os plugins de autenticação que quer usar e organize-os na ordem para uso.';
$string['configautolang'] = 'Detectar idioma a ser usado a partir da configuração do browser, se desabilitada usar o idioma predefinido.';
$string['configautolangusercreation'] = 'Se habilitado, quando a conta de um usuário é criada automaticamente no primeiro login (por exemplo, usando autenticação LDAP ou OAuth 2), o idioma do navegador do usuário é definido como seu idioma preferido. Caso contrário, o idioma padrão do site é definido como o idioma preferido do usuário.';
$string['configautologinguests'] = 'Os visitantes devem entrar como visitantes automaticamente quando entram em cursos com acesso livre?';
$string['configbloglevel'] = 'Esta opção permite a restrição do nível de acesso aos blogs deste site. Isto é aplicado ao contexto do usuário que ACESSA, mas não modifica as opções de autoria ou os tipos de texto publicados no blog. É possível também desabilitar totalmente o sistema de blogs do site.';
$string['configcalendarcustomexport'] = 'Ativar exportação personalizada data de faixa do calendário';
$string['configcalendarexportsalt'] = 'Este texto aleatório é utilizado para aumentar a segurança dos tokens de autenticação utilizados para exportar os calendários. Por favor, note que todos os tokens atuais serão invalidados se você alterar este sal.';
$string['configcookiehttponly'] = 'Habilita o novo aspecto do PHP 5.2.0 - navegadores são instruídos para mandar apenas cookies com verdadeiros pedidos http e os cookies não devem ser acessados por linguagens de script. Nem todos os navegadores suportam essa configuração, que pode não ser totalmente compatível com o código atual. Ajuda a prevenir alguns tipos de ataques XSS.';
$string['configcookiesecure'] = 'Se o servidor estiver aceitando apenas conexões https, é recomendável ativar o envio de cookies seguros. Se ativado, verifique se o servidor web não está aceitando http:// ou configure o redirecionamento permanente para o endereço https:// e, idealmente, envie cabeçalhos HSTS. Quando o endereço <em>wwwroot</em> não é iniciado com https:// esta configuração é ignorada.';
$string['configcountry'] = 'O país definido aqui será o padrão para novas contas de usuários. Para forçar os usuários a escolher um país, deixe esta opção vazia.';
$string['configcoursegraceperiodafter'] = 'Classifica os cursos encerrados como em andamento por até esta quantidade de dias após a data final do curso.';
$string['configcoursegraceperiodbefore'] = 'Classifica os cursos não iniciados como em andamento por até esta quantidade de dias anterior a data de início do curso.';
$string['configcourseoverviewfilesext'] = 'Uma lista de extensões permitidas de imagens de cursos em um formato separado por vírgulas.';
$string['configcourseoverviewfileslimit'] = 'O número máximo de arquivos que podem ser anexados ao sumário do curso na página de lista de cursos. A primeira imagem adicionada é usada na visão geral no Painel do Usuário; qualquer arquivo adicional é mostrado somente na página de lista de cursos.';
$string['configcourserequestnotify'] = 'Informe o usuário a ser notificado quando um novo curso for solicitado.';
$string['configcourserequestnotify2'] = 'Usuários que serão notificados quando um curso for solicitado. Apenas usuários que podem aprovar solicitações de curso são listados aqui.';
$string['configcoursesperpage'] = 'Digite o número de cursos a serem exibidos por página em uma lista de cursos.';
$string['configcourseswithsummarieslimit'] = 'O número máximo de cursos listados incluindo resumos antes de voltar para listagem simples.';
$string['configcronclionly'] = 'Executando o cron de um navegador web pode expor informações privilegiadas para usuários anônimos. Assim, recomenda-se executar apenas o cron a partir da linha de comando ou definir uma senha cron para acesso remoto.';
$string['configcronremotepassword'] = 'Isto significa que o script cron.php não pode ser executado de um navegador web sem fornecer a senha usando a seguinte forma de URL:<pre> http://site.example.com/admin/cron.php?password=opensesame </pre> Se for deixado vazio, nenhuma senha será requisitada.';
$string['configcurlcache'] = 'Tempo de vida (TTL) para o cache do cURL, em segundos.';
$string['configcustommenuitems'] = 'Um menu personalizado pode ser configurado aqui. Insira cada item de menu em uma nova linha no formato: texto do menu, URL do link (opcional, não para um item de menu superior com subitens), título da dica de ferramenta (opcional) e um código de idioma ou lista de códigos separados por vírgula (opcional, para exibir a linha apenas para usuários do idioma especificado), separados por caracteres de barra vertical. Linhas que começam com um hífen aparecerão como itens de menu no menu superior anterior e ### cria uma divisória. Por exemplo:
<pre>
Cursos
-Todos os cursos|/curso/
-Busca de cursos|/curso/busca.php
-###
-FAQ|https://exemplo.org/faq
-Perguntas frequentes|https://exemplo.org/pmf||es
Aplicativo móvel|https://exemplo.org/app|Baixe nosso aplicativo
</pre>';
$string['configcustomusermenuitems'] = 'Você pode configurar o conteúdo do menu do usuário (com exceção do link de logout, que é adicionado automaticamente). Cada linha é separada por barras verticais e consiste em 1) uma string no formato "langstringname, componentname" ou como texto simples e 2) uma URL. Os divisores podem ser usados adicionando uma linha de um ou mais # caracteres onde desejado.';
$string['configdbsessions'] = 'Se habilitado, o Moodle irá utilizar o banco de dados para guardar informações sobre as sessões atuais. Perceba que mudar esta opção agora irá desconectar todos os usuários (incluindo você). Se você está utilizando o MySQL, por favor, tenha certeza que a configuração "max_allowed_packet" no arquivo my.cnf está definida com pelo menos 4M. Outros drivers de sessão podem ser configurados diretamente no config.php, veja o arquivo config-dist.php para mais informações. Esta opção desaparecerá se você especificar um driver diferente no arquivo config.php.';
$string['configdebug'] = 'Esta opção aumenta a informação sobre erros de PHP, imprimindo mais advertências. Ela só é útil para desenvolvedores.';
$string['configdebugdisplay'] = 'Se esta opção for habilitada, o relatório de erro irá para página HTML. Isto é prático mas atrapalha XHTML, JS, cookies e cabeçalhos HTTP em geral. Se não habilitada, enviará a saída para os logs do seu servidor, permitindo um melhor debug. A configuração error_log_controls do PHP controla para qual log será enviado.';
$string['configdebugpageinfo'] = 'Habilite se você quiser informações sobre a página impressa no rodapé da página.';
$string['configdebugvalidators'] = 'Habilite esta opção se você quiser ter links para servidores de validação externa no rodapé da página. Pode ser que você precise criar um novo usuário com "username"  <em>w3cvalidator</em> e permitir o acesso a visitantes. Estas alterações poderão resultar em acesso não autorizado ao servidor, não habilite em sites de produção!';
$string['configdefaulthomepage'] = 'Para qual página os usuários devem ser redirecionados após logarem no site? Essa configuração também determina o primeiro link na navegação para usuários em temas com base no Classic.';
$string['configdefaultrequestcategory'] = 'Os cursos solicitados pelos usuários que tem permissão para solicitar novos cursos no contexto do sistema serão colocados nessa categoria, a menos que os usuários possam selecionar uma categoria diferente.';
$string['configdefaultrequestedcategory'] = 'Categoria padrão para novos cursos aprovados.';
$string['configdefaultuserroleid'] = 'Todos os usuários autenticados terão os privilégios do papel especificado aqui, em nível global, em ADIÇÃO a quaisquer outros papéis que eles possuam. O padrão é o papel Autenticado (ou Visitante em versões mais antigas). Note que isso não causará conflito com os outros papéis atuais do usuário a menos que você proiba certos privilégios, este recurso só garante que todos os usuários tenham privilégios que não podem ser atribuídos em nível de curso (ex.: posts em blog, gerenciamento de calendário, etc.).';
$string['configdeleteincompleteusers'] = 'Depois deste período, qualquer conta sem o nome, sobrenome ou campo email preenchidos serão excluídas.';
$string['configdeleteunconfirmed'] = 'Para alguns métodos de autenticação, como o autoinscrição por e-mail, os usuários devem confirmar sua conta dentro de um determinado período de tempo. Após esse período, todas as contas antigas não confirmadas são excluídas.';
$string['configdenyemailaddresses'] = 'Para recusar endereços de domínios específicos, inclua a lista deles aqui como a anterior. Todos os demais domínios serão aceitos. Para recusar subdomínios, adicione o domínio precedido por um ponto. Por exemplo <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Desativar a capacidade de usuários mudarem imagens de perfil de usuário.';
$string['configdisplayloginfailures'] = 'Isto irá mostrar informações para os usuários sobre falhas de logins anteriores.';
$string['configdndallowtextandlinks'] = 'Habilita ou desabilita a funcionalidade de arrastar e soltar texto e links nas seções do curso. Note que arrastar e soltar texto no Firefox ou entre diferentes navegadores é pouco confiável e pode resultar em nenhum dado sendo enviado ou texto corrompido sendo enviado.';
$string['configdoclang'] = 'Este idioma será utilizado em links para as páginas de documentação.';
$string['configdocroot'] = 'Define o caminho para o Moodle Docs para fornecer documentação específica para o contexto através dos links \'Ajuda e documentação\' no rodapé de cada página. Se o campo for deixado em branco, os links não serão exibidos.';
$string['configdoctonewwindow'] = 'Se você habilitado, os links para o Moodle Docs serão mostrados uma nova janela.';
$string['configeditordictionary'] = 'Este valor será usado se o programa aspell não tiver dicionário para o idioma dos usuários.';
$string['configeditorfontlist'] = 'Selecionar as fontes de caracteres que devem aparecer na lista que desce no editor.';
$string['configemailchangeconfirmation'] = 'Exigir confirmação por email quando os usuários mudam o endereço email no perfil.';
$string['configemaildkimselector'] = 'O seletor DKIM é arbitrário e seus registros DNS devem corresponder a ele.';
$string['configemailfromvia'] = 'Adiciona a informação "via" no campo "De" dos emails enviados. Isso informa o destinatário de onde este email veio e também ajuda a prevenir destinatários de responder endereços de email no-reply.';
$string['configemailheaders'] = 'Cabeçalhos de e-mail brutos a serem adicionados literalmente a todos os e-mails de saída.';
$string['configemailsubjectprefix'] = 'Texto a ser prefixado na linha de assunto de todos os emails de saída.';
$string['configenableactivitychooser'] = 'O seletor de atividade é uma caixa de diálogo com uma breve descrição de cada atividade e recurso. Se desabilitado, menus separados de recurso e atividade são fornecidos como alternativa.';
$string['configenableanalytics'] = 'Os modelos de análise, tal como \'Estudantes em risco de desistência\' ou \'Próximas atividades vencidas\', podem gerar previsões, enviar notificações de insight e oferecer ações adicionais, como mensagens para usuários.';
$string['configenableblogs'] = 'Esta opção oferece a todos os usuários do site o seu próprio blog.';
$string['configenablecalendarexport'] = 'Habilitar exportação ou assinatura de calendários.';
$string['configenablecomments'] = 'Habilitar comentários';
$string['configenablecourserequests'] = 'Se habilitado, os usuários com permissão de solicitar novos cursos (moodle/course:request) terão a opção de solicitar um curso. Essa recurso não é permitido para nenhum dos papéis padrão. Pode ser aplicado no contexto do sistema ou categoria.';
$string['configenabledevicedetection'] = 'Habilitar a detecção de dispositivos móveis, smartphones, tablets ou computadores (computador de mesa, notebooks, etc.) para a aplicação de temas visuais e outros recursos.';
$string['configenablemobilewebservice'] = 'Habilitar o serviço móvel para a aplicação Moodle oficial ou outro aplicativo que o solicite. Para mais informações, leia o {$a}';
$string['configenablerssfeeds'] = 'Se habilitado, alimentadores de RSS serão gerados em todas as sessões do site, como blogs, fóruns, atividades de banco de dados e glossários. Perceba que os alimentadores de RSS devem ser habilitados também no painel de configuração de cada módulo, que podem ser acessados na página de administração do site.';
$string['configenablerssfeedsdisabled'] = 'Não está disponível porque os alimentadores RSS estão desabilitados neste site. Para habilitá-los, vá à configuração de Variáveis dentro no painel de Administração.';
$string['configenablerssfeedsdisabled2'] = 'Feeds RSS estão desabilitados no site. Podem ser habilitados na Administração do site em Opções avançadas.';
$string['configenablestats'] = 'Escolhendo \'sim\', o cronjob de Moodle processa os logs e as estatísticas. Dependendo do tráfego do seu site, isto pode ser uma operação demorada. Esta opção permite a consulta de gráficos e estatísticas interessantes relativas a cada curso e ao site.';
$string['configenabletrusttext'] = 'Por padrão, o Moodle sempre tentará limpar os textos que vêm do usuário, para remover códigos indesejados, mídia, etc, que poderiam ser um risco de segurança. O sistema de Conteúdo Confiável é um modo de dar a usuários particulares a habilidade de incluir esses recursos mais avançados sem interferência por parte do site.
Para ativar esse sistema você precisa ativar essa configuração e então atribuir a permissão de Conteúdo Confiável a um papel específico. Textos criados e enviados por esses usuários serão marcados como confiáveis e não serão limpos antes da exibidos.';
$string['configenablewebservices'] = 'Os webservices permitem que outros sistemas, como o aplicativo Moodle, efetuem login no site e realizem operações. Para aumentar a segurança, a configuração deve ser desabilitada se você não estiver usando o aplicativo ou uma ferramenta/serviço externo que exija integração por meio de webservices.';
$string['configenablewsdocumentation'] = 'Permite a geração automática de documentação de serviços web (Web Services). Um usuário pode acessar a sua própria documentação em sua página de chaves de segurança {$a}. Somente será mostrada a documentação para protocolos habilitados.';
$string['configerrorlevel'] = 'Escolha o nível de advertências do PHP a serem exibidas. A escolha mais comum é Normal.';
$string['configexportlookahead'] = 'Dias a considerar para frente durante a exportação';
$string['configexportlookback'] = 'Dias a considerar para trás durante a exportação';
$string['configextendedusernamechars'] = 'Se habilitado, a identificação de usuário (username) poderá conter qualquer caractere exceto letras maiúsculas. Caso contrário, apenas caracteres alfa-numéricos com letras minúsculas, sublinhado (_), hífen (-), ponto (.) ou arroba (@) são permitidos.';
$string['configextramemorylimit'] = 'Alguns scripts como a busca, backup/restauração e o cron necessitam de mais memória. Defina valores altos para grandes sites.';
$string['configfilterall'] = 'Filtra todas as expressões, inclusive cabeçalhos, títulos e barras de navegação. Esta opção é útil apenas quando o filtro multi-idioma está ativado. Em outros casos irá simplesmente aumentar a carga de operações do sistema.';
$string['configfiltermatchoneperpage'] = 'Os filtros para criação automática de links se aplicam apenas à primeira expressão correspondente presente em uma página. Todas as outras são ignoradas.';
$string['configfiltermatchonepertext'] = 'Os filtros de vinculação automática geram apenas um único link para a primeira ocorrência de texto correspondente encontrada em cada item de texto na página. Todos as outras são ignoradas. Essa configuração não tem efeito se a opção \'Correspondência de filtro uma vez por página\' estiver habilitada.';
$string['configfilternavigationwithsystemcontext'] = 'Normalmente o uso de filtros é ligado a um contexto (e.g. o contexto de um curso), mas para a navegação do site, marcar explicitamente  tudo para ser filtrado com o contexto do site pode melhorar a performance quando usando o filtro em "conteúdo e cabeçalhos".';
$string['configfilteruploadedfiles'] = 'Habilitar esta opção para que o Moodle filtre todos os arquivos com formato Texto e HTML antes de mostrá-los.';
$string['configforcelogin'] = 'Normalmente a página inicial da instalação e a lista de cursos (mas não os cursos) podem ser vistos por quem não logou no site. Se você quiser forçar as pessoas a logar antes de fazer QUALQUER coisa no site, então você deve habilitar essa configuração.';
$string['configforceloginforprofiles'] = 'Esta configuração força as pessoas a iniciar sessão como uma conta real (não-visitantes) antes de ver o perfil de qualquer usuário. Se você desabilitar essa configuração, você pode achar que alguns usuários postar publicidade (spam) ou outro conteúdo impróprio em seus perfis, que é então visível para o mundo todo.';
$string['configfrontpage'] = 'Os itens selecionados acima serão exibidos na página principal do site.';
$string['configfrontpagecourselimit'] = 'Número máximo de cursos';
$string['configfrontpagecourselimithelp'] = 'Número máximo de cursos a serem exibidos na página principal do site na listagem de cursos.';
$string['configfrontpageloggedin'] = 'O ítens selecionados acima serão exibidos na página inicial quando um usuário estiver logado.';
$string['configfullnamedisplay'] = 'Isto define como serão mostrados os nomes completos.  O valor padrão, "idioma", deixa que a string "fullnamedisplay" do pacote de idioma em uso defina o formato. Alguns idiomas tem diferentes formatos para exibir os nomes.

Para a maior parte dos sites com um único idioma, a configuração mais eficiente é "firstname lastname", mas você pode querer esconder os últimos nomes por completo. Os valores que podem ser utilizados aqui são:  firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, e alternatename.';
$string['configgeoipfile'] = 'Caminho do arquivo binário de dados do GeoLite2 City. Ele não faz parte da distribuição do Moodle e pode ser obtido separadamento da <a href="http://www.maxmind.com/">MaxMind</a>.
Você pode comprar uma versão comercial ou usar a versão livre. Você precisará se registrar para baixar o arquivo de banco de dados da cidade, o que pode ser feito em <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/">https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Depois de registrado e tendo baixado o arquivo, extraia-o no diretório "{$a}" do seu servidor.';
$string['configgetremoteaddrconf'] = 'Se o seu servidor estiver atrás de um proxy reverso, você pode usar esta configuração para especificar quais cabeçalhos HTTP contendo o endereço IP remoto são confiáveis. Os cabeçalhos são lidos em ordem, usando o primeiro disponível.';
$string['configgradebookroles'] = 'Esta configuração permite o controle do que é visível no livro de notas. Os usuários devem ter um dos seguintes papéis no curso para que sejam incluídos no livro de notas.';
$string['configgradeexport'] = 'Escolha quais formatos de exportação de livro de notas são seus métodos principais para exportar notas. Plugins escolhidos irão configurar e usar um campo "último exportado" para cada nota. Por exemplo, isto pode resultar em registros exportados sendo identificados como "novo" ou "atualizado". Se você não está certo sobre isto, então deixe tudo em branco.';
$string['confighiddenuserfields'] = 'Selecione os campos de informação de usuários que você quer esconder de outros usuários que não professores/administradores. Isto aumenta a privacidade dos estudantes. Mantenha pressionada a tecla CTRL para selecionar multiplos campos.';
$string['configidnumber'] = 'Esta opção especifica se (a) Não será pedido um ID aos usuários, (b) Será pedido um ID aos usuários, mas eles podem deixar em branco, ou (c) Será pedido um ID e o campo não pode ser deixado em branco. O código ID é mostrado no Perfil do usuário.';
$string['configintro'] = 'Nesta página você pode especificar algumas variáveis de configuração que ajudam o Moodle a funcionar corretamente em seu servidor. Não se preocupe demasiadamente com isto, o padrão normalmente funciona bem e você pode voltar a esta página posteriormente para mudar as configurações.';
$string['configintroadmin'] = 'Nesta página deve ser configurada a conta do administrador principal, que tem controle completo sobre a instalação. Escolha nome e senha seguros e utilize um endereço de correio eletrônico válido. Mais tarde você pode criar outras contas de administrador.';
$string['configintrosite'] = 'Esta página permite configurar a página inicial e o nome deste novo site. Você pode voltar aqui mais tarde para alterar essas configurações a qualquer momento usando os menus de Administração.';
$string['configiplookup'] = 'Quando você clica um endereço IP, como 34.12.222.93, nos logs, o mapa visualizado tenta adivinhar a localização do IP. Você pode escolher plugins com características diferentes entre eles para esta funcionalidade.';
$string['configkeeptagnamecase'] = 'Marque isso se desejar que os nomes das tags mantenham a caixa original conforme digitada pelos usuários que as criaram';
$string['configlang'] = 'Escolha um idioma padrão para todo o site. Os usuários podem sobrescrever esta configuração usando o menu de idiomas ou a configuração em seu perfil pessoal.';
$string['configlanglist'] = 'Se deixado em branco, todos os idiomas instalados no site serão exibidos no menu de idiomas. Como alternativa, o menu de idiomas pode ser abreviado digitando uma lista de códigos de idiomas separados por vírgulas, por exemplo: en,es_es,fr,it,pt_br,pt. Se desejar um nome diferente para idioma, o nome do pacote de idiomas pode ser especificado usando o seguinte formato: código do idioma | nome do idioma, por exemplo: en_kids | English, de_kids | Deutsch.';
$string['configlangmenu'] = 'Escolha se o menu geral de idioma deve aparecer na página inicial, na página de login, etc. Isto não impede o usuário de escolher seu idioma preferido em seu perfil.';
$string['configlangstringcache'] = 'Fazer cache de todas as strings de idiomas em arquivos compilados no diretório de dados. Se você estiver traduzindo o Moodle ou alterando strings no código-fonte do Moodle você vai querer que isto esteja desligado. Caso contrário, deixe-a ativada para melhorar o desempenho.';
$string['configlatinexcelexport'] = 'Escolha a codificação dos relatórios em Excel.';
$string['configlocale'] = 'Escolha o \'locale\' da instalação - isto afeta o formato e o idioma das datas em todos os pacotes de idioma (apesar de os nomes dos dias no calendário não serem afetados). Você deve ter este \'locale\' instalado em seu sistema operacional (por exemplo, para linux en_US.UTF-8 ou  pt_BR.UTF-8). Na maior parte dos casos este campo deve ser deixado em branco.';
$string['configlockrequestcategory'] = 'Se ativado, os usuários com a capacidade de solicitar novos cursos no contexto do sistema não poderão selecionar uma categoria na solicitação de um novo formulário de curso. Uma maneira alternativa de restringir os usuários a solicitar um novo curso em apenas uma categoria é aplicar a permissão de solicitar novos cursos no contexto da categoria.';
$string['configloglifetime'] = 'Isto define durante quanto tempo os logs das atividades dos usuários serão mantidos. Os logs que forem mais velhos que esta idade serão automaticamente excluídos. É melhor manter os logs tanto quanto possível, caso você precise deles, mas se você tem um servidor muito ocupado e está encontrando problemas de performance, então você pode querer diminuir o tempo de vida dos logs. Valores menores que 30 não são recomendados pois as estatísticas podem não funcionar corretamente.';
$string['configlookahead'] = 'Dias no futuro a considerar';
$string['configmailnewline'] = 'Caracteres de nova linha utilizados em mensagens de email. CRLF é obrigatório de acordo como RFC822bis, alguns servidores de email fazem a conversão automática de LF para CRLF, outros servidores de email fazem a conversão incorreta de CRLF para CRCRLF, e outros ainda rejeitam emails só com LF (qmail por exemplo). Tente mudar esta configuração caso você esteja tendo problemas com emails não enviados ou linhas em branco a mais.';
$string['configmaxbytes'] = 'Isto define o tamanho máximo que os arquivos enviados podem ter em todo o site. Esta configuração é limitada pelas configurações post_max_size e upload_max_filesize do PHP, e também pela configuração do Apache LimitRequestBody. Por sua vez, maxbytes limita o intervalo de valores que podem ser escolhidos no nível de curso ou atividade. Se "Limite do servidor" for escolhido, o valor máximo permitido será utilizado.';
$string['configmaxconsecutiveidentchars'] = 'As senhas não devem ter mais que este número de caracteres idênticos consecutivos. Use 0 para desconsiderar esta condição.';
$string['configmaxeditingtime'] = 'Especifica o tempo que os usuários tem para modificar as mensagens nos fóruns, feedbacks, etc. 30 minutos é um valor razoável.';
$string['configmaxevents'] = 'Eventos futuros considerados';
$string['configmaxusersperpage'] = 'O número máximo de usuários exibidos dentro do seletor de usuário em curso, grupo de coorte, webservice etc';
$string['configmessaging'] = 'Se habilitado, os usuários poderão enviar mensagens para outros  usuários no site.';
$string['configmessagingallowemailoverride'] = 'Permite que usuários que encaminhem notificações de mensagens por email para outro email além do email que consta no perfil.';
$string['configmessagingallusers'] = 'Se for habilitado, os usuários poderão ver a lista de todos os usuários do site quando selecionarem alguém para escrever, e suas preferências de mensagems incluem a opção para aceitar mensagens de qualquer um do site.
Se for desabilitado, os usuários poderão apenas ver a lista de usuários dos seus cursos, e eles terão apenas duas opções nas preferências de mensagens: para aceitar mensagens dos seus contatos apenas, ou de seus contatos e qualquer pessoa dos seus cursos.';
$string['configmessagingdefaultpressenter'] = 'Se \'Utilizar enter para enviar\' é habilitado por padrão nas configurações de mensagens dos usuários.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Notificações lidas e não lidas podem ser excluídas para economizar espaço. Quanto tempo após a criação da notificação ela pode ser excluída?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Notificações já lidas podem ser excluídas para economizar espaço. Quanto tempo após a sua leitura uma notificação pode ser excluída?';
$string['configminpassworddigits'] = 'Senhas devem ter no mínimo esta quantidade de dígitos.';
$string['configminpasswordlength'] = 'Senhas devem ter no mínimo esta quantidade de caracteres.';
$string['configminpasswordlower'] = 'Senhas devem ter no mínimo esta quantidade de caracteres minúsculos.';
$string['configminpasswordnonalphanum'] = 'Senhas devem ter no mínimo estes caracteres que não são alfa-numéricos.';
$string['configminpasswordupper'] = 'Senhas devem ter no mínimo estas letras maiúsculas.';
$string['configmodchooserdefault'] = 'O seletor de atividades deve ser apresentado aos usuários por padrão?';
$string['configmycoursesperpage'] = 'Número máximo de cursos a ser mostrado em qualquer lista dos cursos de um usuário.';
$string['configmymoodleredirect'] = 'Esta opção força o redirecionamento para /my na hora do login para quem não é admin e substitui o aspecto do site principal por aquele do /my';
$string['configmypagelocked'] = 'Esta configuração impede que a página padrão seja editada por usuários não  administradores.';
$string['confignavcourselimit'] = 'Limita o número de cursos mostrados ao usuário no bloco Navegação.';
$string['confignavshowallcourses'] = 'Esta configuração define se os usuários inscritos em cursos podem ver Cursos (uma lista com todos os cursos) na navegação, além de Meus cursos (lista de cursos que estão inscritos).';
$string['confignavshowcategories'] = 'Mostra categorias de cursos na barra de navegação e blocos de navegação. Isso não ocorre com os cursos em que o usuário está inscrito; eles ainda serão listados abaixo de Meus cursos sem categorias.';
$string['confignoreplyaddress'] = 'Mensagens de correio eletrônico são às vezes enviadas em nome de um usuário (por exemplo, as mensagens dos fóruns). O endereço fornecido aqui será usado no campo "De" nos casos em que os destinatários não devam responder diretamente ao usuário (por exemplo, quando o usuário optar por manter seu endereço privado).';
$string['confignotifyloginfailures'] = 'Enviar mensagens de notificação de falha de login para os usuários selecionados. Isso requer uma logstore interna (por exemplo Logstore padrão) para ser ativado.';
$string['confignotifyloginthreshold'] = 'Se as notificações sobre falhas de acesso estiverem ativas, quantas tentativas frustradas de acesso de um mesmo usuário ou endereço IP devem ser contadas para gerar notificação?';
$string['confignotloggedinroleid'] = 'Usuários que não estão conectados ao site serão tratados como se tivessem este papel que lhes é concedido em âmbito local. Você deve preferir quase sempre que o usuário tenha papel de visitante, mas talvez você queira criar papéis que são menos ou mais restritivos. Com a criação de posts pode-se exigir que o usuário se autentique adequadamente.';
$string['configopentowebcrawlers'] = 'Se habilitar esta opção, o Google poderá entrar neste site como \'visitante\'. Além disto, as pessoas que chegarem no site através de uma busca no Google, serão automaticamente registradas como \'visitantes\'. Note que o acesso será possível somente nos cursos que já permitem o acesso de visitantes.';
$string['configoverride'] = 'Definido no arquivo config.php';
$string['configpasswordpolicy'] = 'Se habilitada, as senhas dos usuários serão comparadas com a política de senhas, conforme definido nas configurações abaixo. A ativação da política de senha não afetará os usuários existentes até que eles decidam ou sejam obrigados a alterar suas senhas ou a configuração \'Verificar senha no login\' estiver habilitada.';
$string['configpasswordpolicycheckonlogin'] = 'Se habilitada, as senhas dos usuários serão comparadas com a política de senha sempre que os usuários fizerem login. Se a verificação falhar, o usuário precisará alterar sua senha antes de continuar.
É útil habilitar essa configuração depois de atualizar a política de senha.';
$string['configpasswordresettime'] = 'Isso especifica a quantidade de tempo que as pessoas têm de validar um pedido de redefinição de senha antes que ela expire. Geralmente 30 minutos é um bom valor.';
$string['configpathtodu'] = 'Caminho para o du. Algo como /usr/bin/du. Configurando esta opção, as páginas que mostram conteúdos de diretórios serão mais velozes.';
$string['configpathtophp'] = 'Caminho para o PHP CLI. Provavelmente algo como /usr/bin/php. Se você digitar isso, os scripts cron podem ser executados a partir da interface web de administração.';
$string['configperfdebug'] = 'Ativando esta opção, um indicador de performance será visualizado no fim da página no tema padrão.';
$string['configprofileroles'] = 'Lista dos papéis visíveis nos perfis de usuário e na página de participantes.';
$string['configprofilesforenrolledusersonly'] = 'Para previnir o mal uso por spammers, as descrições dos perfis de usuários que ainda não estão inscritos em nenhum curso são escondidas. Novos usuários devem se inscrever em pelo menos um curso para poderem adicionar uma descrição no perfil.';
$string['configprotectusernames'] = 'Se for habilitado, o formulário "esqueci a senha" não exibirá nenhuma dica que possa  permitir que nomes de usuários ou e-mails sejam advinhados.';
$string['configproxybypass'] = 'Lista separada por vírgulas (parcial) de hostnames ou endereços IP que devem ignorar o proxy (por exemplo, 192.168.,  .meudominio.com)';
$string['configproxyfixunsafe_help'] = 'Isso tenta corrigir chamadas internas que não passam pelo proxy adicionando o MoodleBot User Agent e usando o proxy.';
$string['configproxyhost'] = 'Se este <b>servidor</b> precisar usar um proxy (por exemplo, um firewall) para acessar a Internet, indique o hostname do proxy aqui. Caso contrário, deixe em branco.';
$string['configproxylogunsafe_help'] = 'Isso tenta registrar chamadas internas que não passam pelo proxy e deveriam.';
$string['configproxypassword'] = 'Senha necessária para acessar internet através de proxy, se exigido. Deixar vazio caso não seja exigido (extensão PHP cURL exigida).';
$string['configproxyport'] = 'Se esse servidor precisa usar um computador de proxy, então forneça a porta proxy aqui.';
$string['configproxytype'] = 'Tipo de proxy web (PHP5 e a extensão cURL são necessários para suporte do SOCKS5).';
$string['configproxyuser'] = 'Usuário necessário para acessar a internet através de proxy, se exigido. Deixar vazio caso não seja exigido (extensão PHP cURL exigida)';
$string['configrecaptchaprivatekey'] = 'Cadeia de caracteres (chave secreta) utilizada para comunicação entre seu servidor Moodle e o servidor recaptcha. As chaves reCAPTCHA podem ser obtidas em <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Sequência de caracteres (chave do site) usada para exibir o elemento reCAPTCHA no formulário de inscrição e no formulário de suporte do site. As chaves do ReCAPTCHA podem ser obtidas no <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Palavra para definir o estudante, usada em pedidos de cursos.';
$string['configrequestedstudentsname'] = 'Palavra para definir os estudantes, usada em pedidos de cursos.';
$string['configrequestedteachername'] = 'Palavra para definir o professor, usada em pedidos de cursos.';
$string['configrequestedteachersname'] = 'Palavra para definir os professores, usada em pedidos de cursos.';
$string['configreverseproxyignore'] = 'Se seu servidor estiver atrás de vários proxies reversos que adicionam o cabeçalho X-Forwarded-For, será necessário especificar uma lista separada por vírgula de endereços IP ou sub-redes dos proxies reversos a serem ignorados para encontrar o endereço IP correto dos usuários.';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Manutenção';
$string['configsectionmisc'] = 'Miscelânea';
$string['configsectionoperatingsystem'] = 'Sistema operacional';
$string['configsectionpermissions'] = 'Permissões';
$string['configsectionrequestedcourse'] = 'Solicitações de curso';
$string['configsectionsecurity'] = 'Segurança';
$string['configsectionstats'] = 'Estatísticas';
$string['configsectionuser'] = 'Usuário';
$string['configsecureforms'] = 'O Moodle pode usar um nível de segurança extra quando aceita dados de um formulário HTML. Se esta opção estiver habilitada, a variável HTTP_REFERER do navegador é verificada em relação ao endereço atual do formulário. Em alguns poucos casos isto pode causar problemas se o usuário utilizar um firewall (por exemplo, Zonealarm) configurado para eliminar o HTTP_REFERER do tráfego na rede. O sintoma típico é o bloqueio do navegador na página de um formulário. Se seus usuários estão tendo problemas com a página de login, por exemplo, você pode querer desabilitar esta opção, embora isto possa deixar o seu site mais vulnerável a ataques relacionados a senhas. Em caso de dúvida escolha a opção \'Sim\'.';
$string['configsessioncookie'] = 'Esta opção personaliza o nome do \'cookie\' usado nas sessões deste Moodle. Isto é opcional e só é útil quando houver mais de uma instalação do Moodle no mesmo endereço.';
$string['configsessioncookiedomain'] = 'Isto permite que você altere o domínio do qual os cookies do Moodle estão disponíveis. Isto é útil para personalizações do Moodle (por exemplo, plugins de autenticação ou inscrição) que precisam compartilhar informações da sessão Moodle com uma aplicação web em outro sub-domínio. <strong>ATENÇÃO: é altamente recomendável deixar esta configuração com o valor padrão (vazio) - um valor incorreto pode impedir todos os logins ao site.</strong>';
$string['configsessioncookiepath'] = 'Se você precisar mudar o endereço de emissão dos Cookies de Moodle, indique o sub-diretório do seu site web. Em caso contrário, o padrão \'/\' deve ser adequado.';
$string['configsessiontimeout'] = 'Se as pessoas que fizeram o login neste site ficarem inativas por um longo tempo (sem navegar), serão automaticamente desconectadas (a sessão é terminada). Esta variável determina a duração deste período de tempo.';
$string['configsessiontimeoutwarning'] = 'Se as pessoas logadas neste site ficarem inativas por muito tempo (sem carregar páginas), serão avisadas de que sua sessão está prestes a terminar. Esta variável especifica qual o tempo máximo de inatividade.';
$string['configsessiontimeoutwarningcheck'] = 'O aviso de tempo limite de sessão deve ser menor que o tempo limite de sessão';
$string['configshowcommentscount'] = 'Mostrar a quantidade de comentários, isto vai custar uma consulta extra quando mostrando links para comentários';
$string['configshowicalsource'] = 'Mostrar informações da fonte dos eventos do iCal.';
$string['configshowsiteparticipantslist'] = 'Todos os estudantes e professores do site serão incluídos na lista de participantes. Quem pode consultar esta lista de participantes?';
$string['configsitedefaultlicense'] = 'Licença padrão do ambiente';
$string['configsitedefaultlicensehelp'] = 'A licença padrão para publicação de conteúdo neste site';
$string['configsitemailcharset'] = 'Todos os emails criados pelo site utilizarão o conjunto de caracteres aqui definido. Para que os usuários possam personalizar esta configuração é necessário ativar a próxima opção.';
$string['configsitemaxcategorydepth'] = 'Profundidade máxima de categorias';
$string['configsitemaxcategorydepthhelp'] = 'Especifica a profundidade máxima de subcategorias a serem exibidas quando mostrar a lista de categorias ou lista de combinação. Categorias de níveis mais profundos irão aparecer como links e os usuários poderão expandi-las requisitando através de AJAX.';
$string['configslasharguments'] = '\'Slash arguments\' (using <em>PATH_INFO</em>)
é necessária para pacotes SCORM e recursos de múltiplos arquivos para exibir corretamente. Se o seu servidor web não suporta \'argumentos barra\' e não é possível configurá-lo, essa configuração pode ser desativada, embora ele irá resultar em coisas não funcionando <br/> Nota:. O uso de \'Slash arguments\' será obrigatório em futuras versões do Moodle.';
$string['configsmartpix'] = 'Quando ativo, os ícones são mostrados através de um script PHP que busca no tema atual, depois nos níveis superiores da hierarquia, e então na pasta /pix do Moodle. Isso reduz a necessidade de duplicar arquivos de imagens dos temas, mas produz um custo um pouco maior de performance.';
$string['configsmtpauthtype'] = 'Isso define o tipo de autenticação a ser usado no servidor SMTP.';
$string['configsmtphosts'] = 'Indicar o endereço completo de um ou mais servidores SMTP locais que o Moodle deve utilizar para o envio de correio eletrônico (por exemplo: \'mail.a.com\' or \'mail.a.com;mail.b.com\'). Se deixar em branco, o Moodle usará o método PHP padrão de envio de email.';
$string['configsmtpmaxbulk'] = 'Número máximo de mensagens enviadas por sessão SMTP. Agrupar mensagens pode acelerar o envio de emails. Valores inferiores a 2 forçam a criação de uma nova sessão SMTP para cada email.';
$string['configsmtpoauthservice'] = 'Selecione o serviço OAuth 2 que está configurado para se comunicar com o servidor SMTP. Se o serviço ainda não existir, você precisará criá-lo. Observe que você precisa definir o tipo de autenticação SMTP como XOAUTH2.';
$string['configsmtpsecure'] = 'Se o servidor SMTP requer conexão segura, especifique o tipo correto de protocolo.';
$string['configsmtpuser'] = 'Se você especificou um servidor SMTP acima e o servidor requer autenticação, inserira aqui o usuário e a senha.';
$string['configstartwday'] = 'Início da semana';
$string['configstatsfirstrun'] = 'Isto define o período, em relação ao passado, que o processamento dos logs deve considerar a partir da primeira vez que o cronjob fizer esta operação. Se você tem muito tráfego e é hospedado em servidor compartilhado, evite incluir um longo período de tempo, porque isto pode demorar muito e consumir muitos recursos do servidor. (Observe que para esta opção 1 mês = 28 dias. Nos gráficos e relatórios gerados, 1 mês = 1 mês do calendário.)';
$string['configstatsmaxruntime'] = 'O processamento das estatísticas pode ser bastante intensivo, use este campo junto com o próximo para definir quando será executado e por quanto tempo.';
$string['configstatsmaxruntime2'] = 'O processamento das estatísticas pode ser bastante intensivo, especifique o tempo máximo que será permitido para a coleta de estatísticas de um dia. O número máximo de dias processados em uma execução do cron é 31.';
$string['configstatsmaxruntime3'] = 'Especifica o tempo máximo permitido para calcular as estatísticas para cada dia, tendo em mente que o processamento estatístico pode colocar uma grande carga sobre o servidor. O número máximo de dias transformados em um cron pode ser especificado abaixo.';
$string['configstatsruntimedays'] = 'Esta configuração especifica o número máximo de dias a serem processados em cada execução das estatísticas. Quando as estatísticas estiverem atualizadas, apenas um dia será processado, então ajuste este valor conforme a carga de seu servidor, reduzindo-o caso seja necessário encurtar as execuções do cron.';
$string['configstatsruntimestart'] = 'A que horas o cronjob que processa as estatísticas deve iniciar? É recomendável especificar tempos diferentes se você tiver múltiplos Moodles no mesmo servidor físico.';
$string['configstatsuserthreshold'] = 'Esta configuração define o número mínimo de usuários inscritos em um curso para ele ser incluído nos cálculos de estatísticas.';
$string['configstrictformsrequired'] = 'Se ativado, os usuários são impedidos de inserir espaço em branco ou quebra de linha em campos obrigatórios dos formulários.';
$string['configstripalltitletags'] = 'Desmarcar esta opção para permitir tags HTML nos nomes das atividades e dos recursos.';
$string['configsupportavailability'] = 'Determina quem tem acesso ao contato do suporte do site no rodapé.';
$string['configsupportemail'] = 'Se o SMTP está configurado neste site a uma página de suporte não está definida, esse endereço de email irá receber mensagens enviadas através do formulário de suporte. Se o envio falhar, esse endereço de email será exibido aos usuários logados.';
$string['configsupportname'] = 'O nome da pessoa ou outra entidade que oferece suporte através do formulário de suporte ou da página de suporte.';
$string['configsupportpage'] = 'Inserir o link da página de suporte ou deixar em branco para que um link para um formulário de contato seja fornecido. O link é exibido no rodapé do site.';
$string['configtempdatafoldercleanup'] = 'Remover arquivos de dados temporários da pasta de dados que são mais velhos do que o tempo selecionado.';
$string['configthemedesignermode'] = 'Normalmente, todas as imagens de temas e as folhas de estilo (CSS) são armazenados em cache nos navegadores e no servidor por um longo tempo bem, para melhorar o desempenho. Se você estiver criando temas ou desenvolvendo código, então provavelmente você querer esta configuração habilitada para não receber versões do cache. Atenção: isto irá tornar seu site mais lento para todos os usuários! Alternativamente, você também pode esvaziar os caches do tema manualmente a partir da página de seleção do tema.';
$string['configthemelist'] = 'Deixe em branco para permitir que qualquer tema válido seja usado. Se você quiser encurtar o menu de temas, você pode especificar uma lista de nomes separados por vírgula aqui (Não utilize espaços!). Por exemplo: standard,orangewhite.';
$string['configtimezone'] = 'Este é o fuso horário padrão para a exibição de datas - cada usuário pode substituir essa configuração no seu perfil.

Tarefas agendadas e outras configurações do servidor são especificados neste fuso horário. Você deve alterar esta definição se mostrar "fuso horário inválido"';
$string['configuseblogassociations'] = 'Os usuários devem ser capazes de organizar seus blogs associando entradas com cursos e módulos de cursos?';
$string['configuseexternalyui'] = 'Ao invés de usar arquivos locais, usar aquivos online disponíveis nos servidores do Yahoo!. AVISO: Isto requer uma conexão com a Internet, ou o AJAX não irá funcionar em seu site. Esta configuração não é compatível com sites usando https.';
$string['configusesitenameforsitepages'] = 'Se habilitado, o nome breve do site será usado para as páginas do site na barra de navegação ao invés da string \'Páginas do site\' .';
$string['configusetags'] = 'A funcionalidade de tags deve ser habilitada em todo o site?';
$string['configvariables'] = 'Variáveis';
$string['configverifychangedemail'] = 'Habilita a verificação de endereços de emails alterados utilizando as configurações de domínios autorizados e proibidos. Se esta configuração for desabilitada, esta restrição será aplicada apenas na criação de novos usuários';
$string['configvisiblecourses'] = 'Mostre cursos em categorias ocultas';
$string['configwarning'] = 'Tenha cuidado ao modificar estas configurações. Valores estranhos podem causar problemas.';
$string['configyuicomboloading'] = 'Esta opção permite a otimização da carga de arquivos para bibliotecas YUI. Essa configuração deve ser ativada em sites de produção por motivos de desempenho.';
$string['confirmation'] = 'Confirmação';
$string['confirmcontextlock'] = '{$a->contextname} está atualmente desbloqueado. O Bloqueio fará com que seja somente leitura e impede que os usuários façam alterações. Tem certeza que deseja continuar?';
$string['confirmcontextunlock'] = '{$a->contextname} está atualmente bloqueado. O desbloqueio permitirá que os usuários façam alterações. Tem certeza que deseja continuar?';
$string['confirmdeletecomments'] = 'Você está prestes a excluir comentários, tem certeza?';
$string['confirmed'] = 'Confirmado';
$string['contactsitesupport'] = 'Contate o suporte do site';
$string['contenttypeuninstalling'] = 'Há {$a->count} conteúdos mantidos por {$a->type}. Eles serão
 excluídos. Você tem certeza que quer proceder?';
$string['contextlockappliestoadmin'] = 'Bloqueio de contexto se aplica a administradores';
$string['contextlockappliestoadmin_desc'] = 'Se desativado, os administradores permanecem com acesso de gravação a qualquer contexto bloqueado.';
$string['contextlocking'] = 'Bloqueio de Contexto';
$string['contextlocking_desc'] = 'Essa configuração permite que o acesso somente leitura seja definido para categorias, cursos, atividades ou blocos selecionados.';
$string['cookiehttponly'] = 'Somente http cookies';
$string['cookiesecure'] = 'Somente cookies seguros';
$string['country'] = 'País predefinido';
$string['course_customfield'] = 'Campos personalizados de curso';
$string['coursecolor'] = 'Cor {$a}';
$string['coursecolorheading_desc'] = 'Todos os cursos que não tem uma imagem definida nas configurações do curso, são exibidos no Painel com um cartão de curso padronizado. As cores utilizadas nesse padrão podem ser especificadas abaixo.';
$string['coursecolorsettings'] = 'Cores do cartão do curso.';
$string['coursecontact'] = 'Administradores de curso';
$string['coursecontact_desc'] = 'Esta opção permite que você controle quem aparece na descrição do curso. Usuários precisarão ter pelo menos um desses papéis em um curso para serem mostrados na descrição deste curso.';
$string['coursecontactduplicates'] = 'Exibir todos os papéis do contato do curso';
$string['coursecontactduplicates_desc'] = 'Se ativado, os usuários com mais de um papel de contato do curso selecionado serão exibidos na descrição do curso com todos esses papéis. Caso contrário, eles serão exibidos apenas com um papel (o que estiver listado mais alto em \'Definir papéis\' na administração do Site).';
$string['coursegraceperiodafter'] = 'Período de carência para cursos anteriores';
$string['coursegraceperiodbefore'] = 'Período de carência para cursos futuros';
$string['courselistshortnames'] = 'Mostrar nomes estendidos dos cursos';
$string['courselistshortnames_desc'] = 'Se habilitado, o nome breve dos cursos serão mostrados juntamente com os nomes completos nas listas de cursos. Se necessário, os nomes estendidos dos cursos podem ser personalizados editando a string  \'courseextendednamedisplay\' pelo o recurso de personalização de idioma.';
$string['coursemgmt'] = 'Gerenciar cursos e categorias';
$string['courseoverview'] = 'Sumário do curso';
$string['coursepage'] = 'Página do Curso';
$string['courserequestnotify'] = 'Aviso de solicitação de curso';
$string['courserequestnotifyemail'] = 'O usuário {$a->user} solicitou um novo curso <a href="{$a->link}">{$a->link}</a>';
$string['courserequests'] = 'Solicitações de curso';
$string['courserequestspending'] = 'Solicitações de cursos pendentes';
$string['courses'] = 'Cursos';
$string['coursesperpage'] = 'Cursos por página';
$string['courseswithsummarieslimit'] = 'Limite para cursos com sumário';
$string['creatornewroleid'] = 'Papel do criador em cursos novos';
$string['creatornewroleid_help'] = 'Se o usuário não tiver permissão para gerenciar o novo curso, o usuário é automaticamente inscrito com este perfil de usuàrio.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Habilitar o cron';
$string['cron_enabled_desc'] = 'O Cron normalmente deve ser habilitado, no entanto, esta configuração permite que ele seja desabilitado temporariamente, por exemplo, antes de reiniciar o servidor. Se desabilitado, o sistema é impedido de iniciar novas tarefas em segundo plano. Observe que o cron não deve ser desabilitado por muito tempo, pois isso impedirá que funcionalidades importantes funcionem.';
$string['cron_help'] = 'O script cron.php executa várias tarefas em diferentes intervalos agendados, como o envio de e-mails de notificação de postagem no fórum. O script deve ser executado regularmente - preferencialmente a cada minuto.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Execução do Cron somente pela linha de comando';
$string['cronerrorclionly'] = 'Desculpe, o acesso a essa página foi desativado pelo administrador.';
$string['cronerrorpassword'] = 'Desculpe, você não forneceu uma senha válida para acessar essa página.';
$string['croninfrequent'] = 'O tempo entre as duas últimas execuções do script de manutenção cron ultrapassou {$a->actual}  e ele deve ser executado a cada {$a->expected}. Recomendamos configurá-lo para ser executado com maior frequência.';
$string['cronremotepassword'] = 'Senha do Cron para acesso remoto';
$string['cronwarning'] = 'O <a href="{$a->url}">script admin/cron.php</a> não é executado há {$a->actual} e deveria ser executado a cada {$a->expected}.';
$string['cronwarningcli'] = 'O <code>admin/cli/cron.php</code> deve ser executado a cada {$a->expected}, e não é executado há {$a->actual} .';
$string['cronwarningnever'] = 'O <code>admin/cli/cron.php</code> deve ser executado a cada {$a->expected}, e nunca foi executado.';
$string['cronwarningneverweb'] = 'O <a href="{$a->url}">script admin/cron.php</a> nunca foi executado e deveria ser executado a cada {$a->expected}.';
$string['ctyperequired'] = 'A extensão ctype do PHP é necessária para melhorar a performance e a compatibilidade com funcionalidades multi-idioma.';
$string['curlcache'] = 'TTL do cache do cURL';
$string['curlrequired'] = 'A extensão  cURL PHP é agora requerida pelo Moodle, a fim de se comunicar com os repositórios Moodle.';
$string['curlsecurityallowedport'] = 'Lista de portas permitidas do cURL';
$string['curlsecurityallowedportsyntax'] = 'Lista de números de porta com os quais o cURL pode se conectar. Entradas válidas são apenas números inteiros. Coloque cada entrada em uma nova linha. Se ficar vazio, então todas as portas são permitidas. Se definido, em quase todos os casos, tanto 443 como 80 devem ser especificados para cURL para se conectar a portas padrão HTTPS e HTTP.';
$string['curlsecurityblockedhosts'] = 'Lista de servidores bloqueados do cURL';
$string['curlsecurityblockedhostssyntax'] = 'Coloque cada entrada em uma nova linha. As entradas válidas são endereços IPv4 ou IPv6 completos (como 192.168.10.1, 0: 0: 0: 0: 0: 0: 1, :: 1, fe80: :) que correspondem a um único host; Ou notação CIDR (tal como 231.54.211.0/20 ou fe80 :: / 64); Ou um intervalo de endereços IP (como 231.3.56.10-20 ou fe80 :: 1111-bbbb) onde o intervalo se aplica ao último grupo do endereço; Ou nomes de domínio (como localhost ou example.com); Ou nomes de domínio curinga (como * .example.com ou * .sub.example.com). As linhas em branco não são permitidas.';
$string['curlsecurityurlblocked'] = 'Esta URL está bloqueada.';
$string['curltimeoutkbitrate'] = 'Velocidade a utilizar nos cálculos de tempo limite do cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Esta configuração é usada para calcular o limite de tempo apropriado durante grandes requisições do cURL. Como parte deste cálculo é realizado uma solitação HTTP HEAD para determinar o tamanho do conteúdo. Configurando esta opção com o valor 0 esta solicitação é desabilitada.';
$string['currenttheme'] = 'Tema corrente.';
$string['customcheck'] = 'Outras verificações';
$string['custommenu'] = 'Menu personalizado';
$string['custommenuitems'] = 'Ítens do menu personalizado';
$string['customusermenuitems'] = 'Itens do menu do usuário';
$string['datarootsecurityerror'] = '<p><strong>AVISO DE SEGURANÇA!</strong></p><p>O seu diretório raiz dataroot está em uma posição errada acessível via web. Todo mundo pode acessar os arquivos e crackers podem obter acessos como administradores do site!</p>
<p><em>Mude</em> o diretório raiz dataroot ({$a}) para uma posição protegida e atualize a configuração de <code>$CFG->dataroot</code> no config.php .</p>';
$string['datarootsecuritywarning'] = 'A configuração do seu site pode não ser segura. Por favor, certifique-se de que o seu diretório dataroot ({$a}) não é diretamente acessível via web.';
$string['dbprefixtoolong'] = 'O prefixo do banco de dados do seu site ($CFG->prefix) é muito longo ({$a->current} caracteres). O número máximo de caracteres permitido é {$a->maximum}.';
$string['dbsessions'] = 'Use o banco de dados para informações da sessão';
$string['debug'] = 'Mensagens de debug';
$string['debugall'] = 'TODAS: Mostrar todas as mensagens de debug do PHP';
$string['debugdeveloper'] = 'DESENVOLVEDOR: mensagens extras de debug do Moodle para desenvolvedores';
$string['debugdisplay'] = 'Mostre mensagens de debug';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MÍNIMO: Mostrar apenas erros fatais.';
$string['debugnone'] = 'NENHUM: Não mostre erros ou alertas.';
$string['debugnormal'] = 'NORMAL: Mostrar erros, avisos e notícias';
$string['debugpageinfo'] = 'Mostrar informações da página';
$string['debugsqltrace'] = 'Mostrar origem das chamadas SQL';
$string['debugsqltrace1'] = 'Mostrar somente uma única linha de chamada';
$string['debugsqltrace100'] = 'Mostrar rastreamento de pilha completo';
$string['debugsqltrace2'] = 'Mostrar duas linhas de rastreamento de pilha';
$string['debugsqltrace_desc'] = 'Se habilitado, adiciona o rastramento de pilha parcial ou completo do PHP ao SQL como um comentário';
$string['debugstringids'] = 'Mostrar origem das strings de idiomas.';
$string['debugstringids_desc'] = 'Se habilitada, o nome do componente e o identificador da string no pacote de idioma serão exibidos quando for adicionar a URL da página ?strings=1 ou &strings=1.';
$string['debugvalidators'] = 'Mostra links do validador';
$string['defaultcity'] = 'Cidade padrão';
$string['defaultcity_help'] = 'A cidade inserida aqui será a cidade padrão na criação de novas contas de usuários.';
$string['defaultformatnotset'] = 'Erro determinando o padrão de formato de curso. Por favor verifique as configurações do site.';
$string['defaulthomepage'] = 'Página inicial padrão para os usuários';
$string['defaultrequestcategory'] = 'Categoria padrão para requisição de curso';
$string['defaultsettinginfo'] = 'Padrão: {$a}';
$string['defaultuserroleid'] = 'Papel padrão para todos usuários';
$string['deleteincompleteusers'] = 'Excluir usuários incompletos depois de';
$string['deleteunconfirmed'] = 'Excluir usuários não confirmados depois de';
$string['deleteuser'] = 'Excluir usuário';
$string['density'] = 'Densidade';
$string['denyemailaddresses'] = 'Domínios de emails proibidos';
$string['development'] = 'Desenvolvimento';
$string['devicedetectregex'] = 'Expressões regulares para detecção de dispositivos';
$string['devicedetectregex_desc'] = '<p>Por padrão, o Moodle pode detectar computadores (computadores de mesa, notebooks, etc.), dispositivos móveis (telefones e smartphones), tablets (iPads, tablets Android) e navegadores antigos (usuários do Internet Explorer 6). O seletor de temas pode ser usado para aplicar temas distintos para todos eles. Esta configuração permite que as expressões regulares adicionais que permitem a identificação do tipo de dispositivo (estas expressões regulares têm precedência sobre os tipos padrões).</p>
<p>Por exemplo, você pode entrar a expressão regular \'/(MIDP-1.0|Maemo|Windows CE)/\' para detectar alguns smartphones comuns e incluir o valor de retorno \'featurephone\'. Isto adiciona \'featurephone\' no seletor de temas que permite incluir um tema que seria usado nestes dispositivos. Os demais telefones continuariam a utilizar o tema definido para o tipo de dispositivo móvel.</p>';
$string['devicedetectregexexpression'] = 'Expressão regular';
$string['devicedetectregexvalue'] = 'Valor de retorno';
$string['devicetype'] = 'Tipo de dispositivo';
$string['devlibdirpresent'] = 'Diretórios com bibliotecas de desenvolvimento, especialmente <em>/vendor</em> e <em>/node_modules</em>, não devem estar presentes em sites públicos. Veja o <a href="{$a->moreinfourl}">relatório geral de segurança</a> para mais detalhes.';
$string['disabled'] = 'Desabilitado';
$string['disableuserimages'] = 'Desabilitar imagens de perfil de usuário';
$string['displayerrorswarning'] = 'Desabilitar a opção PHP <em>display_errors</em> para evitar que dados sensíveis sejam revelados. Isto serve apenas em sites de teste para revisão de código.';
$string['displayloginfailures'] = 'Mostrar falhas de login';
$string['divertallemails'] = 'Desvio de emails';
$string['divertallemailsdetail'] = 'Usado como proteção em ambientes de desenvolvimento ao testar emails e não deve ser usado na produção.';
$string['divertallemailsexcept'] = 'Exceções de desvio de emails';
$string['divertallemailsexcept_desc'] = 'Uma lista de regras de exceção de e-mail separadas por vírgulas ou novas linhas. Cada regra é interpretada como uma expressão regular, por exemplo,
<pre>simone@acme.com
.*@acme.com
fred (\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Redirecionar todos os emails';
$string['divertallemailsto_desc'] = 'Se ativado, todos os emails serão redirecionados para este único endereço de email.';
$string['dndallowtextandlinks'] = 'Upload arrastando e soltando textos/links';
$string['doclang'] = 'Idioma para documentação';
$string['docroot'] = 'Diretório raiz do Moodle Docs';
$string['doctonewwindow'] = 'Abrir em uma nova janela';
$string['doesnotfit'] = 'Configuração de exibição de email';
$string['doesnotfitdetail'] = 'Configurações de exibição para e-mail saindo do Moodle.';
$string['download'] = 'Download';
$string['downloadcoursecontentallowed'] = 'Disponibilizar a funcionalidade de baixar o conteúdo do curso';
$string['downloadcoursecontentallowed_desc'] = 'Se a funcionalidade de baixar o conteúdo do curso fica disponível para os cursos. Quando disponível, o download do conteúdo do curso pode ser habilitado/desabilitado usando a configuração "Habilitar download do conteúdo do curso" no menu de edição do curso (o padrão para isso pode ser definido em <a href={$a} target="_blank">Configurações padrão do curso</a>).';
$string['durationunits'] = 'unidades de duração';
$string['edithelpdocs'] = 'Editar documentos de ajuda';
$string['editlang'] = '<b>Editar</b>';
$string['editorbackgroundcolor'] = 'Cor de fundo';
$string['editordictionary'] = 'Dicionário';
$string['editorfontfamily'] = 'Família da fonte';
$string['editorfontlist'] = 'Lista de fontes';
$string['editorfontsize'] = 'Tamanho da fonte';
$string['editorhidebuttons'] = 'Botões ocultos';
$string['editorkillword'] = 'Filtro de formatação Word';
$string['editorspelling'] = 'Editor de controle ortográfico';
$string['editorspellinghelp'] = 'Habilitar ou desabilitar o controle ortográfico. Funciona apenas se <strong>aspell</strong> for instalado no servidor.';
$string['editstrings'] = 'Editar as palavras ou frases';
$string['emailchangeconfirmation'] = 'Confirmação de mudança de email';
$string['emaildkim'] = 'Assinatura de emails com DomainKeys Identified Mail (DKIM)';
$string['emaildkiminfo'] = 'Se o seletor DKIM for definido e um arquivo de certificado privado for encontrado que corresponda ao domínio do endereço "From" do e-mail em $CFG->dataroot/dkim/[domínio]/[seletor].private, o e-mail será assinado. Na maioria dos casos (por exemplo, se allowedemaildomains estiver vazio), apenas um único certificado é necessário em <pre>{$a->path}</pre>. Para obter mais detalhes de configuração, consulte a documentação <a href="{$a->docs} ">Configuração de correio</a>.';
$string['emaildkimselector'] = 'Seletor DKIM';
$string['emailfromvia'] = 'Informações via Email';
$string['emailheaders'] = 'Cabeçalhos de email';
$string['emailsubjectprefix'] = 'Prefixo do texto do assunto do email';
$string['emoticonalt'] = 'Texto alternativo';
$string['emoticoncomponent'] = 'Componente de imagem';
$string['emoticonimagename'] = 'Nome de imagem';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Este formulário define os emoticons (ou smileys) utilizados em seu site. Para remover uma linha da tabela, salve o formulário com um valor vazio em qualquer dos campos requeridos. Para registrar um novo emoticon, preencha os campos na última linha em branco. Para retornar todos os campos para valores padrão, siga o link acima.

* Texto (obrigatório) - Este texto será substituído com a imagem do emoticon. Deve ter pelo menos dois caracteres.
* Nome da imagem (necessário) - O nome do arquivo de imagem do emoticon, sem a extensão, relativo ao diretório do componente pix.
* Componente da imagem (obrigatório) - O componente que fornece o ícone.
* Texto alternativo (opcional) - Identificador da string e do componente do texto alternativo para o emoticon.';
$string['emoticonsreset'] = 'Retornar a configuração de emoticons para os valores padrão';
$string['emoticontext'] = 'Texto';
$string['emptysettingvalue'] = 'Vazio';
$string['enableactivitychooser'] = 'Ativar seletor de atividade';
$string['enableanalytics'] = 'Análise de aprendizagem';
$string['enableblogs'] = 'Ativar blogs';
$string['enablecalendarexport'] = 'Habilitar exportação do calendário';
$string['enablecomments'] = 'Habilitar comentários';
$string['enablecourserelativedates'] = 'Habilitar datas relativas no curso';
$string['enablecourserelativedates_desc'] = 'Permitir que os cursos sejam configurados para exibir as datas relativas para a data de início do usuário no curso.';
$string['enablecourserequests'] = 'Habilitar solicitação de curso';
$string['enabled'] = 'Habilitado';
$string['enabledashboard'] = 'Habilitar Painel';
$string['enabledashboard_help'] = 'Por padrão, o Painel mostra Linha de tempo, Calendário e Itens acessados recentemente. Você pode configurar um Painel diferente para todos e permitir aos usuários customizar seu próprio Painel. Se desabilitado, você precisa definir a "Página inicial para os usuários" para um valor diferente de Painel.';
$string['enabledevicedetection'] = 'Habilitar detecção de dispositivo';
$string['enableglobalsearch'] = 'Habilitar busca global';
$string['enableglobalsearch_desc'] = 'Se habilitado, os dados serão indexados e sincronizados por uma tarefa agendada.';
$string['enablegravatar'] = 'Habilitar Gravatar';
$string['enablegravatar_help'] = 'Se habilitado, o Moodle tentará buscar uma foto do perfil do usuário do Gravatar caso o usuário não envie uma imagem.';
$string['enablemobilewebservice'] = 'Habilitar web service para dispositivos móveis';
$string['enablerecordcache'] = 'Habilitar cache de gravação';
$string['enablerssfeeds'] = 'Habilitar alimentadores RSS';
$string['enablesearchareas'] = 'Habilitar busca em áreas';
$string['enablestats'] = 'Habilitar estatísticas';
$string['enabletrusttext'] = 'Habilitar conteúdo confiável';
$string['enableuserfeedback'] = 'Habilitar feedback sobre este software';
$string['enableuserfeedback_desc'] = 'Se habilitado, um link \'Dê um feedback sobre este software\' é exibido no rodapé para usuários fornecerem feedback sobre o software Moodle para o Moodle HQ. Se a opção \'Próximo lembrete de feedback\' estiver marcada, um lembrete também é mostrado ao usuário no Painel, no intervalo definido. Definir \'Próximo lembrete de feedback\' como \'Nunca\' desabilita o lembrete no Painel, deixando o link \'Dê um feedback sobre este software\' no rodapé.';
$string['enablewebservices'] = 'Habilitar serviços web (web services)';
$string['enablewsdocumentation'] = 'Documentação de serviços web';
$string['encryptedpassword_edit'] = 'Digite novo valor';
$string['encryptedpassword_set'] = '(Definido e criptografado)';
$string['enroladminnewcourse'] = 'Inscrever automaticamente o administrador em novos cursos';
$string['enroladminnewcourse_help'] = 'Quando um administrador adiciona um novo curso, ele deve ser automaticamente inscrito e associado ao papel de criador em novos cursos?';
$string['enrolinstancedefaults'] = 'Padrões da instância de inscrição';
$string['enrolinstancedefaults_desc'] = 'Configurações padrão de inscrição em novos cursos.';
$string['enrolmultipleusers'] = 'Inscrever os usuários';
$string['ensureauroraversion'] = 'Seu site está sendo executado no mecanismo de banco de dados Amazon Aurora. Certifique-se de que a versão do MySQL no Amazon Aurora seja compatível com a versão do Moodle que você está instalando ou atualizando. Você pode verificar a compatibilidade em <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/AuroraMySQL.Updates.30Updates.html" target="_blank">Atualizações do mecanismo de banco de dados para o Amazon Aurora MySQL versão 3</a>.';
$string['entitytasklog'] = 'Task log';
$string['environment'] = 'Ambiente';
$string['environmenterrortodo'] = 'Você deve resolver os problemas indicados acima antes de instalar esta versão de Moodle.';
$string['environmenterrorupgrade'] = 'Aviso: você deve solucionar todos os problemas (erros) de ambiente encontrados acima antes de proceder na atualização desta versão do Moodle! Atualizar sem consertar esses requisitos pode causar problemas como perda de dados. Você está certo de que quer continuar com a atualização?';
$string['environmentmariadbwrongdbtype'] = 'Erro $CFG->dbtype: você precisa alterar no seu arquivo config.php, de \'mysql\' para \'mariadb\'.';
$string['environmentmustfixsetting'] = 'Configuração do PHP deve ser alterada.';
$string['environmentok'] = 'O ambiente do seu servidor reúne todos os requisitos mínimos.';
$string['environmentrecommendcustomcheck'] = 'Se esse teste falhar, será indício de um possível problema';
$string['environmentrecommendinstall'] = 'recomendado como instalado/habilitado';
$string['environmentrecommendversion'] = 'a versão {$a->needed} é recomendada e você está usando a versão {$a->current}';
$string['environmentrequirecustomcheck'] = 'Este teste deve funcionar';
$string['environmentrequireinstall'] = 'deve ser instalado e habilitado';
$string['environmentrequireversion'] = 'a versão {$a->needed} é necessária e você está usando a versão {$a->current}';
$string['environmentsettingok'] = 'configuração recomendada detectada';
$string['environmentshouldfixcustomcheck'] = 'deve ser ativado para obter melhores resultados';
$string['environmentshouldfixsetting'] = 'Configuração do PHP pode ser alterada.';
$string['environmentxmlerror'] = 'Erro de leitura dos dados do ambiente ({$a->error_code})';
$string['errordeletingconfig'] = 'Ocorreu um erro ao excluir os registros de configuração do plugin \'{$a}\'.';
$string['errorsetting'] = 'Configuração não foi salva:';
$string['errorwithsettings'] = 'Algumas configurações não mudaram devido a um erro.';
$string['eventshandlersinuse'] = 'Os seguintes plugins em seu sistema estão usando manipuladores obsoletos da API Events 1: \'{$a}\'. Por favor, atualize-os para usar a API Events 2. Consulte https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Todos que podem "{$a}"';
$string['exceptions'] = 'exceções';
$string['execpathnotallowed'] = 'Definição do caminho executável e local desabilitados no config.php';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Configurações experimentais';
$string['extendedusernamechars'] = 'Permitir caracteres estendidos em "usernames"';
$string['extramemorylimit'] = 'Limite extra de memória para o PHP';
$string['fatalsessionautostart'] = '<p>Erros graves de configuração foram detectados, por favor notifique o administrador do servidor.</p><p>Para funcionar adequadamente, o Moodle precisa que o administrador modifique as configurações do PHP.</p><p><code>session.auto_start</code> deve ser definido como <code>off</code>.</p><p>Esta configuração é controlada editando o <code>php.ini</code>, a configuração do Apache/IIS<br/> ou o arquivo <code>.htaccess</code> no servidor.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'O favicon é exibido ao lado do título da página na guia do navegador. Um favicon do Moodle é exibido se nenhum favicon personalizado for fornecido.';
$string['feedbacksettings'] = 'Configurações de Feedback';
$string['fileconversioncleanuptask'] = 'Limpeza de registros temporários de conversões de arquivos.';
$string['filecreated'] = 'Novo arquivo criado';
$string['filescleanupperiod'] = 'Limpar arquivos armazenados na lixeira';
$string['filescleanupperiod_help'] = 'Com que frequência os arquivos são excluídos da lixeira. São arquivos que estão associados a um contexto que não existe mais, como por exemplo quando um curso é excluído. Note: Esta configuração pode resultar na perda de arquivos de um curso que foi feito backup, excluído e depois restaurado, se a configuração \'Incluir arquivos\' (backup_auto_files) em \'Configurações do backup automático\' estiver desabilitada.';
$string['filesizeunits'] = 'unidades de tamanho de arquivo';
$string['filestoredin'] = 'Salvar arquivo na pasta:';
$string['filestoredinhelp'] = 'Onde o arquivo será armazenado';
$string['filterall'] = 'Filtrar todas as expressões';
$string['filtermatchoneperpage'] = 'Uma única expressão por página';
$string['filtermatchonepertext'] = 'Uma única expressão por texto';
$string['filternavigationwithsystemcontext'] = 'Filtrar navegação com o contexto do sistema';
$string['filters'] = 'Filtros';
$string['filtersettings'] = 'Gerenciar filtros';
$string['filtersettingsgeneral'] = 'Configuração geral de filtros';
$string['filteruploadedfiles'] = 'Filtrar arquivos enviados ao servidor';
$string['forceclean'] = 'Limpar conteúdo em todos os lugares';
$string['forceclean_desc'] = 'O conteúdo adicionado ao site é normalmente limpo antes de ser exibido, para remover qualquer coisa que possa ser uma ameaça à segurança. No entanto, o conteúdo não é limpo em determinados locais, como descrições de atividades, recursos de páginas ou blocos HTML para permitir que scripts, mídia, quadros embutidos etc. sejam adicionados. Se essa configuração estiver habilitada, TODO o conteúdo será limpo. Isso pode fazer com que o conteúdo existente não seja exibido corretamente.';
$string['forcelogin'] = 'Forçar usuários a autenticar';
$string['forceloginforprofileimage'] = 'Forçar usuários a autenticar para ver imagens de usuários';
$string['forceloginforprofileimage_help'] = 'Se habilitado, os usuários devem efetuar login, a fim de ver o perfil de usuário fotos e a imagem do usuário padrão será usado em todos os e-mails de notificação.';
$string['forceloginforprofiles'] = 'Forçar usuários a autenticar para perfil';
$string['forcetimezone'] = 'Forçar fuso horário';
$string['formatuninstallwithcourses'] = 'Existem {$a->count} cursos usando {$a->format}. Seu formato será alterado para {$a->defaultformat} (formato padrão para este site). Alguns dados específicos do formato podem ser perdidos. Você tem certeza de que deseja continuar?';
$string['frontpage'] = 'Página principal';
$string['frontpagebackup'] = 'Backup da página principal';
$string['frontpagedefaultrole'] = 'Papel padrão da página principal';
$string['frontpagefilters'] = 'Filtros da página principal';
$string['frontpageloggedin'] = 'Itens da página principal quando logado';
$string['frontpageoverrides'] = 'Sobreposições de permissões da página principal';
$string['frontpagequestions'] = 'Questões da página principal';
$string['frontpagerestore'] = 'Restaurar a página principal';
$string['frontpageroles'] = 'Papéis da página principal';
$string['frontpagesettings'] = 'Configurações da página principal';
$string['fullnamedisplay'] = 'Formato de nome completo';
$string['fullnamedisplayprivate'] = 'Formato do nome completo - privado';
$string['gdrequired'] = 'A extensão GD é obrigatória por Moodle para conversão de imagem.';
$string['generalsettings'] = 'Configurações gerais';
$string['geoipfile'] = 'Arquivo GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Origem dos endereços IP registrados nos logs';
$string['globalsearch'] = 'Busca global';
$string['globalsearchmanage'] = 'Gerenciar busca global';
$string['googlemapkey3'] = 'Chave da API do Google Maps V3';
$string['googlemapkey3_help'] = 'Você precisa inserir uma chave especial para usar o Google Maps para a visualização do endereço IP de pesquisa. Você pode obter a chave gratuitamente em <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial # api_key</a>';
$string['gotofirst'] = 'Vá para a primeira expressão não traduzida';
$string['gradebook'] = 'Livro de notas';
$string['gradebookroles'] = 'Papéis que são avaliados';
$string['gradeexport'] = 'Métodos de exportação da avaliação primária';
$string['gravatardefaulturl'] = 'URL da imagem padrão gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar precisa de uma imagem padrão para exibir se ele é incapaz de encontrar uma imagem para um determinado usuário. Fornecer uma URL completa de uma imagem. Se você deixar esta opção vazia, Moodle tentará usar a imagem padrão mais adequado para a página que você está vendo. Note-se também que Gravatar tem uma série de códigos que podem ser utilizados para <a href="https://en.gravatar.com/site/implement/images/#default-image">gerar imagens padrão</a> .';
$string['groupenrolmentkeypolicy'] = 'Política de chave para inscrição em grupo';
$string['groupenrolmentkeypolicy_desc'] = 'Se habilitado, as chaves de inscrição de grupo serão verificadas em relação à política de senha, conforme especificado nas configurações acima.';
$string['guestroleid'] = 'Papel para convidados';
$string['guestroleid_help'] = 'Este papel é atribuído automaticamente para o usuário convidado (guest). É também atribuído temporariamente a usuários não inscritos, que entram no curso através do plugin de inscrição de convidados. ';
$string['h5pgetcontenttypestask'] = 'Baixar os tipos de conteúdo H5P disponíveis em h5p.org';
$string['helpadminseesall'] = 'No calendário do site, os administradores veem e filtram eventos dos calendários de todos os cursos ou apenas dos cursos em que estão inscritos? Independente da opção escolhida, os administradores sempre poderão gerenciar eventos de cada calendário de curso, primeiramente navegando até o curso, e em seguida acessando diretamente o calendário.';
$string['helpcalendarcustomexport'] = 'Ativar opção de exportação de faixa customizada na exportação de calendário. Exportação de calendários precisam ser hablitadas antes que isso seja efetivo.';
$string['helpexportlookahead'] = 'Quantos dias no futuro é que o calendário de eventos durante a olhar para exportação para a opção de exportação personalizado?';
$string['helpexportlookback'] = 'Quantos dias no passado é que o calendário de eventos durante a olhar para exportação para a opção de exportação personalizada?';
$string['helpforcetimezone'] = 'Você pode permitir que os usuários selecionem seus fusos horários ou deseja forçar um único fuso horário para todos.';
$string['helpshowicalsource'] = 'Se habilitado, mostrará o nome de assinatura e o link ao importar os eventos do iCal.';
$string['helpsitemaintenance'] = 'Ativar durante a atualização ou manutenção do sistema.';
$string['helpstartofweek'] = 'Qual é o primeiro dia da semana no calendário?';
$string['helpupcominglookahead'] = 'Quantos dias consecutivos compõem o arco de tempo a ser considerado para a indicação dos Próximos Eventos?';
$string['helpupcomingmaxevents'] = 'Qual é o número máximo de eventos a serem mostrados ao usuário?';
$string['helpweekenddays'] = 'Quais dias da semana são considerados "fim de semana" e mostrados com cor diferente?';
$string['hiddenuserfields'] = 'Ocultar campos de usuários';
$string['hidefromall'] = 'Ocultar de todos os usuários';
$string['hidefromnone'] = 'Não ocultar';
$string['hidefromstudents'] = 'Ocultar dos estudantes';
$string['hostname'] = 'Host name';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Configurações do editor HTML';
$string['htmlsettings'] = 'Configurações HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Segurança HTTP';
$string['iconvrequired'] = 'Instalar a extensão ICONV é obrigatório.';
$string['igbinary322buggyversion'] = 'A extensão php-igbinary instalada no site pode levar a problemas ao executar com PHP 7.2. Recomenda-se que você atualize para o php-igbinary 3.2.5 ou posterior ou, alternativamente, atualize para o PHP 7.3 ou posterior.';
$string['ignore'] = 'Ignorar';
$string['includemoduleuserdata'] = 'Incluir dados de usuário do módulo';
$string['incompatibleblocks'] = 'Blocos incompatíveis';
$string['incompleteunicodesupport'] = 'A configuração atual do MySQL ou MariaDB utiliza \'utf8\'. Esta definição de caracteres não suporta caracteres de quatro byte que incluem alguns emoji. Se tentar usar estes caracteres resultará em erro ao atualizar um registo e qualquer informação que esteja a ser enviada para a base de dados será perdida. Considere alterar as suas configurações para \'utf8mb4\'. Consulte a documentação para obter mais detalhes.';
$string['indexdata'] = 'os dados do índice';
$string['indexinginfo'] = 'A maneira recomendada de indexar o conteúdo do seu site é usando a tarefa agendada de "indexação de pesquisa global".';
$string['installhijacked'] = 'Desculpe, mas a instalação deve ser concluída a partir do endereço IP original.';
$string['installsessionerror'] = 'A sessão PHP não pôde ser iniciada. Por favor verifique se o seu navegador aceita cookies.';
$string['intlrecommended'] = 'A extensão Intl é utilizada para melhorar o suporte à internacionalização, como a ordenação de informações de forma adequada.';
$string['intlrequired'] = 'A extensão Intl é utilizada para melhorar o suporte à internacionalização, como a ordenação de informações locais e  nomes de domínio internacionais.';
$string['invalidagedigitalconsent'] = 'A idade digital do consentimento não é válida: {$a}';
$string['invalidforgottenpasswordurl'] = 'A URL da senha esquecida não é uma URL válida.';
$string['invalidsection'] = 'Seção inválida.';
$string['invalidthemepreset'] = 'O arquivo preset escolhido não é compatível com este tema. O erro de compilação do SCSS foi: "{$a}"';
$string['invaliduserchangeme'] = 'O usuário "changeme" é reservado - você não criar uma conta com ele.';
$string['ipblocked'] = 'Este site está indisponível no momento.';
$string['ipblocker'] = 'Bloqueador de IP';
$string['ipblockersyntax'] = 'Coloque cada entrada em uma nova linha. As entradas válidas são o endereço IP completo (como <strong>192.168.10.1</strong>) que corresponde a um único host; ou parcial (como <strong>192.168</strong>) que corresponda a qualquer endereço que comece com esses números; ou notação CIDR (como <strong>231.54.211.0/20</strong>); Ou um intervalo de endereços IP (como <strong>231.3.56.10-20</strong>) onde o intervalo se aplica à última parte do endereço. Os nomes de domínio de texto (como \'example.com\') não são suportados. As linhas em branco e texto após o caractere "#" são ignorados.';
$string['iplookup'] = 'Procurar endereço IP';
$string['iplookupgeoplugin'] = 'O serviço <a href="http://www.geoplugin.com">geoPlugin</a> está atualmente sendo usado para buscar informações geográficas. Para obter resultados mais precisos recomendamos a instalação de uma cópia local da base de dados MaxMind GeoLite.';
$string['iplookupinfo'] = 'O servidor online gratuito NetGeo é usado para procurar localizações de endereços IP. O banco de dados não é mais mantido e pode retornar dados incorretos. Recomenda-se a instalação de uma cópia local do banco de dados gratuito GeoLite2 City da MaxMind.<br />
Se uma chave Google Maps API V3 for fornecida, a localização do endereço IP será exibida usando o Google Maps. Você precisa de uma conta do Google e solicitar uma chave de API do Google Maps. Se nenhuma chave Google Maps API V3 for fornecida, a localização do endereço IP será exibida usando o OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Esse produto inclue dados GeoLite2 criados por MaxMind, disponível em <a href="http://www.maxmind.com">https://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'Foi detectado que seu site está usando um diretório de administração personalizado. Este recurso não é mais compatível e será removido após o Moodle 4.2.';
$string['ishttpswarning'] = 'Foi detectado que seu site não está seguro porque não utiliza HTTPS. É altamente recomendável migrar seu site para  HTTPS para aumentar a segurança e melhorar a integração com outros sistemas.';
$string['keeptagnamecase'] = 'Mantenha formato de letra do nome da tag';
$string['lang'] = 'Idioma predefinido';
$string['langcache'] = 'Memória temporária da lista de idiomas';
$string['langcache_desc'] = 'Cache o menu de idiomas. Se ativado, a lista de traduções disponíveis fica em cache. O cache é atualizado automaticamente quando você instalar ou excluir um pacote de idiomas através da ferramenta de gerenciamento de idiomas. Se você instalar um novo pacote de idiomas manualmente, você deverá utilizar o recurso de limpeza de todos os caches para atualizar a lista de idiomas disponíveis.';
$string['langlist'] = 'Idiomas presentes na lista';
$string['langmenu'] = 'Mostrar lista de idiomas';
$string['langmenuinsecurelayout'] = 'Exibir menu de idioma em layout seguro';
$string['langmenuinsecurelayout_desc'] = 'Se habilitado, um usuário poderá alterar seu idioma durante uma tentativa no  questionário ou outra atividade, usando o layout seguro.';
$string['langpackwillbeupdated'] = 'NOTA: O Moodle tentará fazer download de atualizações de seus pacotes de idioma durante esta atualização.';
$string['langstringcache'] = 'Colocar todas as strings de idioma em cache ';
$string['languagesettings'] = 'Configurações de idiomas';
$string['latinexcelexport'] = 'Codificação Excel';
$string['legacyfilesaddallowed'] = 'Permitir a adição de arquivos do curso legados';
$string['legacyfilesaddallowed_help'] = 'Se um curso tem arquivos do curso de legado, permitir que novos arquivos e pastas a serem adicionados a ele.';
$string['legacyfilesinnewcourses'] = 'Arquivos de cursos legados em novos cursos';
$string['legacyfilesinnewcourses_help'] = 'Por padrão, as áreas de arquivos de cursos legados estão disponíveis apenas em cursos atualizados. Por favor, observe que algumas coisas, como backup e restauração de uma única atividade, não são compatíveis com essa configuração.';
$string['libcurlwarning'] = 'Foi detetado que o libcurl não tem suporte para o CURLOPT_PROTOCOL. Recomenda-se a instalação atualizada do libcurl por razões de segurança.';
$string['licensesettings'] = 'Configurações de licenciamento';
$string['linkadmincategories'] = 'Link para categorias do admin';
$string['linkadmincategories_help'] = 'Caso habilitado categorias de configurações administrativas serão exibidas como links na navegação e irão levar para as páginas de categorias administrativas';
$string['linkcoursesections'] = 'Sempre linkar seções do curso';
$string['linkcoursesections_help'] = 'Sempre tentar fornecer um link para seções do curso. Seções do curso são geralmente mostradas como links se o formato do curso apresentar uma única seção por página. Se essa configuração estiver habilitada sempre será fornecido um link.';
$string['loading'] = 'Carregando';
$string['localetext'] = 'locale do site';
$string['localstringcustomization'] = 'Edição de versão local';
$string['location'] = 'Local';
$string['locationsettings'] = 'Parametrização de local';
$string['locked'] = 'Travado';
$string['lockoutduration'] = 'Duração do bloqueio de conta';
$string['lockoutduration_desc'] = 'Contas bloqueadas são automaticamente desbloqueadas após este período.';
$string['lockoutemailbody'] = 'Sua conta com nome de usuário {$a->username} em &quot;{$a->sitename}&quot; foi bloqueada após várias tentativas de login inválidas.

Para desbloquear a conta, vá para o seguinte endereço

{$a->link}

Na maioria dos programas de e-mail, esta deve aparecer como um link azul que você pode simplesmente clicar. Se isso não funcionar, copie e cole o endereço na barra de endereços no topo da janela do seu navegador. Se precisar de ajuda, por favor, entre em contato com o administrador do site,

{$a->admin}';
$string['lockoutemailsubject'] = 'Sua conta no {$a} foi bloqueada';
$string['lockouterrorunlock'] = 'Informações de desbloqueio inválido conta fornecida.';
$string['lockoutthreshold'] = 'Limite de bloqueio de conta';
$string['lockoutthreshold_desc'] = 'Selecione o número de falhas de login que resultam em bloqueio de conta. Este recurso pode ser utilizado em ataques de negação de serviço.';
$string['lockoutwindow'] = 'Conta janela de observação de bloqueio';
$string['lockoutwindow_desc'] = 'Tempo de observação para limite de bloqueio, se não houver tentativas fracassadas o contador limite é reposto após este tempo.';
$string['lockrequestcategory'] = 'Impedir a seleção de categoria';
$string['log'] = 'Logs';
$string['logguests'] = 'Registrar log de acesso de visitantes (guest)';
$string['logguests_help'] = 'Esta configuração permite o registro (log) de ações da conta de visitante (guest)  e usuários não autenticados. Sites muito utilizados  podem querer desativar este log por razões de desempenho. Recomenda-se manter esta opção habilitada nos sites de produção.';
$string['logininfoinsecurelayout'] = 'Mostrar usuário logado em layout seguro';
$string['logininfoinsecurelayout_desc'] = 'Se habilitado, o nome completo do usuário logado será mostrado na barra de navegação durante uma tentativa de questionário ou outra atividade, usando o layout seguro.';
$string['loginpageautofocus'] = 'Focar automaticamente o formulário da página de login';
$string['loginpageautofocus_help'] = 'Ativar esta opção melhora a usabilidade da página de login, mas os campos com foco automatico podem causar problemas de  acessibilidade.';
$string['loglifetime'] = 'Manter logs por';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Um logotipo maior para ser usado como decoração por alguns temas (como temas padrão). Essa imagem pode ter uma resolução bastante alta porque será reduzida para uso (e armazenada em cache para desempenho). Logotipos que são mais largos do que altos geralmente dão melhores resultados.';
$string['logocompact'] = 'Logo pequeno';
$string['logocompact_desc'] = 'Uma versão compacta do mesmo logotipo acima, como um emblema, escudo ou ícone. A imagem deve ser nítida mesmo em tamanhos menores.';
$string['logossettings'] = 'Logos';
$string['logstorenotrequired'] = 'Armazenamento de log não obrigatório';
$string['logstoressupported'] = 'Armazenagens de log que suportam esse relatório';
$string['longtimewarning'] = '<b>Por favor, note que esse processo pode levar um longo tempo.</b>';
$string['mailnewline'] = 'Caracteres de nova linha no email';
$string['maintenancemode'] = 'Em modo de manutenção';
$string['maintenancemodeisscheduled'] = 'Este site entrará no modo de manutenção em {$a->min} minutos e {$a->sec} segundos';
$string['maintenancemodeisscheduledlong'] = 'Este site irá entrar em modo de manutenção em {$a->hour} horas, {$a->min} minutos e {$a->sec} segundos';
$string['maintfileopenerror'] = 'Erro de abertura dos arquivos de manutenção!';
$string['maintinprogress'] = 'Progresso da manutenção...';
$string['managecontextlock'] = 'Bloquear este contexto';
$string['managecontextlocklocked'] = '{$a->contextname} e quaisquer contextos inferiores estão bloqueados agora.';
$string['managecontextlockunlocked'] = '{$a->contextname} e quaisquer contextos inferiores estão desbloqueados agora.';
$string['managecontextunlock'] = 'Desbloquear este contexto';
$string['managecustomfields'] = 'Gerenciar tipos de campo personalizados';
$string['manageformats'] = 'Gerenciar formatos de curso';
$string['manageformatsgotosettings'] = 'Formato padrão pode ser modificado em {$a}';
$string['managelang'] = 'Gerenciar';
$string['manageqbanks'] = 'Gerenciar plugins de banco de questões';
$string['manageqbehaviours'] = 'Gerenciar comportamentos de questão';
$string['manageqtypes'] = 'Gerenciar tipos de questões';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Candidato a lançamento';
$string['maturity200'] = 'Versão estável';
$string['maturity50'] = 'Versão Alfa';
$string['maturityallowunstable'] = 'Dica: Você pode rodar esse script com a opção --allow-unstable';
$string['maturitycoreinfo'] = 'Seu site está atualmente rodando uma versão instável "{$a}" de desenvolvimento.';
$string['maturitycorewarning'] = 'A versão do Moodle que você está prestes a instalar ou atualizar contém código de desenvolvimento instável "{$a}" que não é adequada para uso em sites de maior porte em ambiente de produção. Se esta atualização não é o que você deseja, então você deve se certifidar que está atualizando a partir da distribuição STABLE do Moodle. Consulte o Moodle Docs para maiores detalhes.';
$string['maxbytes'] = 'Tamanho máximo de arquivo transmitido';
$string['maxconsecutiveidentchars'] = 'Caracteres consecutivos idênticos';
$string['maxeditingtime'] = 'Tempo máximo para editar postagens';
$string['maxsizeperdownloadcoursefile'] = 'Tamanho máximo por arquivo';
$string['maxsizeperdownloadcoursefile_desc'] = 'O tamanho máximo de cada arquivo ao baixar o conteúdo do curso. Arquivos que excedam esse tamanho serão omitidos do download.';
$string['maxtimelimit'] = 'Tempo limite máximo';
$string['maxtimelimit_desc'] = 'Para restringir o tempo máximo de execução PHP que Moodle permitirá, sem qualquer saída que está sendo exibido, digite um valor em segundos aqui. 0 significa que as restrições padrão do Moodle são usados. Se você tem um servidor de front-end com o seu próprio limite de tempo, definir esse valor mais baixo para receber erros do PHP em lotes. Não se aplica aos scripts CLI.';
$string['maxusersperpage'] = 'Máximo de usuários por página';
$string['mbstringrecommended'] = 'A instalação da biblioteca MBSTRING é altamente recomendável para melhorar a performance do site, especialmente se o seu site tem suporte a idiomas não-latinos.';
$string['mbstringrequired'] = 'É necessário instalar a biblioteca MBSTRING para melhorar o desempenho do site, principalmente se o seu site oferece suporte a idiomas não latinos.';
$string['mediapluginavi'] = 'Ativar filtro .avi';
$string['mediapluginflv'] = 'Ativar filtro .flv';
$string['mediapluginimg'] = 'Habilitar "auto-embedding" de links para imagens';
$string['mediapluginmov'] = 'Ativar filtro .mov';
$string['mediapluginmp3'] = 'Ativar filtro .mp3';
$string['mediapluginmpg'] = 'Ativar filtro .mpg';
$string['mediapluginogg'] = 'Habilitar filtro .ogg';
$string['mediapluginogv'] = 'Habilitar filtro .ogv';
$string['mediapluginram'] = 'Ativar filtro .ram';
$string['mediapluginrm'] = 'Ativar filtro .rm';
$string['mediapluginrpm'] = 'Ativar filtro .rpm';
$string['mediapluginswf'] = 'Ativar filtro .swf';
$string['mediapluginswfnote'] = 'Como uma medida padrão de segurança, usuários normais não tem permissão para colocar arquivos swf de flash.';
$string['mediapluginwmv'] = 'Ativar filtro .wmv';
$string['mediapluginyoutube'] = 'Habilitar filtro de links ao YouTube';
$string['messaging'] = 'Habilitar sistema de mensagens';
$string['messagingallowemailoverride'] = 'Sobreescreve notificações por email';
$string['messagingallusers'] = 'Permitir mensagens em todo o site';
$string['messagingcategory'] = 'Mensagens';
$string['messagingdefaultpressenter'] = 'Utilizar enter para enviar habilitado por padrão';
$string['messagingdeleteallnotificationsdelay'] = 'Excluir todas as notificações';
$string['messagingdeletereadnotificationsdelay'] = 'Excluir notificações já lidas';
$string['messagingssettings'] = 'Configurações de mensagens';
$string['minpassworddigits'] = 'Números';
$string['minpasswordlength'] = 'Tamanho da senha';
$string['minpasswordlower'] = 'Letras minúsculas';
$string['minpasswordnonalphanum'] = 'Caracteres não alfanuméricos';
$string['minpasswordupper'] = 'Letras maiúsculas';
$string['misc'] = 'Diversidade';
$string['mlbackendsettings'] = 'Configurações de Backend do aprendizado de máquina (Machine Learning).';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> Este arquivo de backup contém contas de usuários remotos do Moodle em Rede';
$string['mnetrestore_extusers_admin'] = '<strong>Nota:</strong> Este arquivo de backup aparentemente foi gerado em outra instalaçao do Moodle e contém contas de usuários remotos da Rede Moodle. O processo de restauração tentará casar os hosts da Rede Moodle para todos os usuário criados. Aqueles que não casarem serão automaticamente alterados para autenticação interna (ao invés de mnet). O log da restauração vai informá-lo sobre isso.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Este arquivo de backup aparentemente foi gerado em outra instalação do Moodle e possui contas de usuários remotos da Rede Moodle que podem falhar ao retaurar. Esta operação não é aceita. Se você está certo de que este arquivo foi criado nesta instalação do Moodle, ou você pode assegurar que todos os hosts da Rede Moodle necessários estão configurados, você pode querer ainda tentar restaurá-los.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Nota:</strong> Este arquivo de backup aparentemente foi gerado em outra instalaçao do Moodle e contém contas de usuários remotos da Rede Moodle. Você não tem autorização para executar este tipo de restauração. Contate o administrador do site ou, alternativamente, restaurar este curso sem informações de usuários (módulos, arquivos...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Usuário da Rede Moodle Remota {$a->username} (proveniente de {$a->mnethosturl}) mudou para usuário {$a->auth} autenticado localmente.';
$string['mobilenotconfiguredwarning'] = 'O aplicativo Moodle não está habilitado.';
$string['modassignmentinuse'] = 'Seu site ainda está usando o plugin Tarefa 2.2. Antes de atualizar, você deve 1) fazer backup de todas as atividades Tarefa 2.2 que deseja manter e restaurá-las como atividades Tarefa e 2) excluir todos os dados Tarefa 2.2 do banco de dados.';
$string['modassignmentsubpluginsexist'] = 'Tarefa 2.2. subplugins podem estar presentes. A pasta mod/assignment e todos os seus subplugins precisam ser removidos antes da atualização.';
$string['modchooserdefault'] = 'Padrão para seletor de atividades';
$string['modeditdefaults'] = 'Valores padrão para configurações de atividade';
$string['modsettings'] = 'Gerenciar atividades';
$string['modulesecurity'] = 'Módulo de segurança';
$string['moodleapp'] = 'Aplicativo Moodle';
$string['moodleapp_help'] = '<p>O Aplicativo Moodle gratuito permite que os usuários acessem seus cursos nos dispitivos móveis. Mais funcionalidades do aplicativo estão disponíveis nos planos Pro ou Premium do aplicativo. </p><a href="https://moodle.com/mobile-app">Baixe o aplicativo Moodle</a><a href="https://apps.moodle.com">Moodle Apps Portal</a>';
$string['moodlebrandedapp'] = 'Aplicativo Moodle Personalizado';
$string['moodlebrandedapp_help'] = '<p>O aplicativo Moodle Personalizado tem todas as funcionalidades do nosso aplicativo móvel gratuito para o Moodle, combinado com sua própria marca personalizada.</p>
<a href="https://moodle.com/branded-app">Sobre o aplicativo Moodle Personalizado</a>';
$string['moodlebrandedappreference'] = 'Como alternativa, obtenha um <a href="https://moodle.com/branded-app/"> aplicativo do Moodle Personalizado</a> com sua própria marca.';
$string['moodlepartners'] = 'Parceiros Moodle';
$string['moodlepartners_help'] = '<p>Parceiros Moodle são provedores de serviços que são certificados pelo Moodle HQ para fornecer serviços Moodle de alta qualidade para o ambiente de aprendizagem on-line da sua organização.</p>
<a href="https://moodle.com/about-partners/">Sobre nossos parceiros</a><br/>
<a href="https://moodle.com/partners">Encontre um parceiro</a>';
$string['moodleservices'] = 'Serviços Moodle';
$string['moodleservices_help'] = 'Certifique-se de obter o melhor do seu ambiente de aprendizado Moodle usando estes serviços Moodle:';
$string['multilangforceold'] = 'Forçar a sintaxe antiga de multi-idioma:&lt;span&gt; sem a classe="multilang" e &lt;lang&gt;';
$string['mustenablestats'] = 'As estatísticas ainda não foram habilitadas neste site.';
$string['mycourses'] = 'Meus cursos';
$string['mycoursesperpage'] = 'Número máximo de cursos';
$string['mydashboard'] = 'Painel padrão do sistema';
$string['mymoodle'] = 'Painel';
$string['mymoodleredirect'] = 'Forçar usuários a usar Meu Moodle';
$string['mypage'] = 'Página Painel padrão';
$string['mypagelocked'] = 'Bloquear página padrão';
$string['myprofile'] = 'Página padrão de perfil';
$string['navadduserpostslinks'] = 'Adicionar links para exibir mensagens dos usuários';
$string['navadduserpostslinks_help'] = 'Se habilitado, dois links serão adicionados para cada usuário na navegação, um para ver as discussões que o usuário tenha iniciado e outro para as mensagens o usuário postou em fóruns  do site ou em cursos específicos.';
$string['navcourselimit'] = 'Limite de curso';
$string['navigationupgrade'] = 'Essa atualização introduz dois novos blocos de navegação que irão substituir os seguintes blocos: Administração, Cursos, Atividades e Participantes. Se você definiu alguma permissão especial nestes blocos, você deve se certificar de que tudo está se comportando como você gostaria.';
$string['navshowallcourses'] = 'Mostrar todos os cursos';
$string['navshowcategories'] = 'Mostrar categorias de cursos';
$string['navshowfrontpagemods'] = 'Mostrar atividades da página principal na navegação';
$string['navshowfrontpagemods_help'] = 'Se habilitado, as atividades da página principal serão exibidas na navegação abaixo das páginas do site. Esta configuração se aplica somente a temas baseados no Classic.';
$string['navshowfullcoursenames'] = 'Mostrar os nomes completos do curso';
$string['navshowfullcoursenames_help'] = 'Se habilitado, os nomes completos dos cursos serão exibidos na navegação ao invés do nome curto.';
$string['navshowmycoursecategories'] = 'Exibir categorias em Meus cursos';
$string['navshowmycoursecategories_help'] = 'Se habilitado, os cursos no grupo "meus cursos" do usuário serão mostrados em categorias no bloco de navegação (só para temas baseados no tema Classic).';
$string['navsortmycourseshiddenlast'] = 'Ordenar meus cursos ocultos por último';
$string['navsortmycourseshiddenlast_help'] = 'Se habilitado, todos os cursos ocultos serão listados após os cursos visíveis (para usuários que possam ver cursos ocultos). Caso contrário, todos os cursos serão listados de acordo com as configuração de \'Ordenar meus cursos\' .';
$string['navsortmycoursessort'] = 'Ordem dos cursos no bloco de navegação';
$string['navsortmycoursessort_help'] = 'Os cursos devem ser listados na ordem de classificação definida em Administração do site > Cursos > Gerenciar cursos e categorias, ou em ordem alfabética por configuração do curso? Esta configuração se aplica apenas a temas baseados no Classic.';
$string['never'] = 'Nunca';
$string['neverdeleteruns'] = 'Nunca excluir execuções';
$string['newestdocindexed'] = 'O mais recente documento indexado';
$string['nobookmarksforuser'] = 'Você não tem nenhum marcador de página.';
$string['nodatabase'] = 'Sem banco de dados';
$string['nohttpsformobilewarning'] = 'É recomendável habilitar o HTTPS com um certificado válido. O aplicativo Moodle irá sempre tentar primeiro utilizar uma conexão segura.';
$string['nomissingstrings'] = 'Não faltam expressões';
$string['none'] = 'Nenhum';
$string['nonewsettings'] = 'Nenhuma configuração nova foi adicionada durante esta atualização.';
$string['nonexistentbookmark'] = 'A marca de leitura que você solicitou não existe.';
$string['noreplyaddress'] = 'Endereço de No-reply';
$string['noreplydomain'] = 'Endereço de no-reply';
$string['noreplydomaindetail'] = 'Configurações para envio de e-mail de não-responda (no-reply)';
$string['noresults'] = 'Nenhum resultado encontrado.';
$string['noroles'] = 'Sem papéis';
$string['nosupportedlogstore'] = 'Nenhum armazenamento de logs (logstore) encontrado';
$string['noteunneededblocks'] = 'Note: se blocos são especificados na configuração do tema \'blocos desnecessários\', não serão mostrados no menu \'Adicionar um bloco\'.';
$string['notifications'] = 'Notificações';
$string['notifyloginfailures'] = 'Email de falhas de login';
$string['notifyloginthreshold'] = 'Limite de notificações por email';
$string['notloggedinroleid'] = 'Papel para visitantes';
$string['numberofmissingstrings'] = 'Número de expressões não traduzidas: {$a}';
$string['numberofstrings'] = 'Número total de expressões: {$a->strings}<br />Faltando: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'O token de atualização para um dos serviços OAuth {$a->issuer} no seu site {$a->siteurl} expirou. Isto irá limitar a funcionalidade de qualquer plugin que utilize este serviço. Para consertar o problema, visite a página de configuração de Serviços OAuth 2 e clique no ícone "Conectar conta do sistema" na linha da tabela deste serviço. Tenha certeza de sempre logar utilizando a mesma conta de serviço para o sistema OAuth.';
$string['oauthrefreshtokenexpiredshort'] = 'O token de atualização OAuth expirou para {$a->issuer} no seu site {$a->siteurl}.';
$string['onlynoreply'] = 'Somente a partir do endereço de "no-reply"';
$string['opcacherecommended'] = 'PHP cache opcode melhora o desempenho e reduz os requisitos de memória, extensão OPcache é recomendado e totalmente suportado.';
$string['opensslrecommended'] = 'É altamente recomendável a instalação da biblioteca OpenSSL, que é opcional, isto permite a funcionalidade Moodle em Rede.';
$string['opensslrequired'] = 'A extensão OpenSSL do PHP agora é exigida pelo Moodle para fornecer serviços de criptografia mais robustos.';
$string['opentowebcrawlers'] = 'Aberto para o Google';
$string['optionalmaintenancemessage'] = 'Mensagem opcional de manutenção';
$string['oracledatabaseinuse'] = 'Estamos alterando o suporte ao Oracle DB no Moodle LMS. A versão do Moodle 4.5 será a última versão que suportará o Oracle como arquitetura de banco de dados. Mais informações podem ser encontradas <a href="https://moodle.org/mod/forum/discuss.php?d=456122" target="_blank">aqui</a>.';
$string['order1'] = 'Primeiro';
$string['order2'] = 'Segundo';
$string['order3'] = 'Terceiro';
$string['order4'] = 'Quarto';
$string['outgoingmailconfig'] = 'Configuração de saída de e-mail';
$string['overridetossl'] = 'HTTPS para logins está obsoleto. Esta instância agora está forçada a utilizar SSL. Para evitar este aviso mude seu wwwroot em config.php para https://';
$string['pageinfodebugsummary'] = 'Esta página é: {$a}';
$string['passwordchangelogout'] = 'Sair após alteração de senha';
$string['passwordchangelogout_desc'] = 'Se habilitado, quando uma senha é alterada, todas as sessões do navegador são terminadas, além daquela em que a nova senha seja especificada. (Esta definição não afeta as alterações de senha através de upload em massa do usuário.)';
$string['passwordchangetokendeletion'] = 'Remover tokens de acesso ao webservice após a mudança de senha';
$string['passwordchangetokendeletion_desc'] = 'Se ativar esta opção, sempre que uma senha é alterada, todos os tokens de acesso ao web service do utilizador são apagados.';
$string['passwordpolicy'] = 'Política de senha';
$string['passwordpolicycheckonlogin'] = 'Verificar senha no login';
$string['passwordresettime'] = 'O tempo máximo para validar o pedido de redefinição de senha';
$string['passwordreuselimit'] = 'Limite de alternância de senha';
$string['passwordreuselimit_desc'] = 'Número de vezes que um usuário deve alterar sua senha antes de ser autorizado a reutilizar uma senha. Erros das senhas usadas anteriormente são armazenados na tabela de banco de dados local. Esse recurso pode não ser compatível com alguns plugins de autenticação externa.';
$string['pathtodot'] = 'Caminho para o dot.';
$string['pathtodot_help'] = 'Caminho para o dot. Para ser possível gerar gráficos a partir de arquivos DOT, você deve ter instalado o executável dot e apontá-lo aqui. Normalmente o executável é encontrado no Linux em: /usr/bin/dot; No Windows em: C:\\Arquivos de Programas (x86)\\Graphviz2.38\\bin\\dot.exe; e no Mac em: /opt/local/bin/.  Em algums distribuições Linux, este aplicativo é fornecido pelo pacote graphviz.';
$string['pathtodu'] = 'Caminho para du';
$string['pathtogs'] = 'Caminho para o ghostscript';
$string['pathtogs_help'] = 'Na maioria das instalações Linux, isso pode ser deixado como \'/usr/bin/gs\'. No Windows será algo como \'c:\\gs\\bin\\gswin32c.exe\' (certifique-se de que não há espaços no caminho - se necessário copiar os arquivos \'gswin32c.exe\' e \'gsdll32.dll\' para uma nova pasta sem um espaço no caminho)';
$string['pathtopdftoppm'] = 'Caminho para pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> é uma biblioteca de renderização de PDF que inclui a ferramenta pdftoppm para converter arquivos PDF em PNG. O desempenho geralmente é melhor do que o Ghostscript, especialmente para arquivos grandes. Se disponível, o pdftoppm será usado em preferencialmente ao Ghostscript. Na maioria das instalações do Linux, o caminho pode ser deixado como /usr/bin/pdftoppm. Caso contrário, você precisa instalar o pacote poppler-utils ou poppler, dependendo da sua distribuição Linux. No Windows, é fornecido pelas instalações do Cygwin.';
$string['pathtopgdump'] = 'Caminho do pg_dump';
$string['pathtopgdumpdesc'] = 'Isto é necessário apenas se você tiver mais de um pg_dump no seu sistema (por exemplo, quando diversas versões de postgresql estão instaladas)';
$string['pathtopgdumpinvalid'] = 'Caminho do pg_dump não válido - caminho errado ou não executável';
$string['pathtophp'] = 'Caminho para o PHP CLI';
$string['pathtopsql'] = 'Caminho do psql';
$string['pathtopsqldesc'] = 'Isto é necessário apenas se você tiver mais de um psql no seu sistema (por exemplo, quando diversas versões de postgresql estão instaladas)';
$string['pathtopsqlinvalid'] = 'Caminho do psql não válido - caminho errado ou não executável';
$string['pathtopython'] = 'Caminho para o Python';
$string['pathtopythondesc'] = 'Caminho para o seu executável binário Python (são aceitos Python 2 e Python 3).';
$string['pathtosassc'] = 'Caminho para SassC';
$string['pathtosassc_help'] = 'Especificar a localização do binário SassC mudará o compilador SASS da implementação PHP do Moodle para o SassC. Veja https://github.com/sass/sassc para mais informações.';
$string['pcreunicodewarning'] = 'è altamente recomendado a utilização PCRE PHP que é compatível com caracteres Unicode.';
$string['perfdebug'] = 'Informação de performance';
$string['performance'] = 'Performance';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'PostgreSQL version/cluster parameter
for command line operations.
If you only have one postgresql
on your system or you are not
sure what this is, leave this blank.';
$string['phpfloatproblem'] = 'Foi detectado um erro inesperado ao manipular números de ponto flutuante no PHP - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Seu site está registrado. Última atualização em {$a}.<br/>A tarefa agendada "Registro do site" mantém atualizado automaticamente seu registro. Você também pode atualizar manualmente o seu registro a qualquer momento.';
$string['pleaserefreshregistrationnewdata'] = 'As informações de registro foram modificadas. Por favor confirme-as utilizando o botão \'Atualizar registro\'.';
$string['pleaserefreshregistrationunknown'] = 'Seu site foi registrado, mas a data de registro é desconhecida. Por favor, atualize seu cadastro usando o botão \'Atualizar cadastro\' ou certifique-se que a tarefa agendada "Registo do site" esteja habilitada para que o seu registro seja atualizado automaticamente.';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Verificação de dependência de plugins';
$string['pluginscheckfailed'] = 'A verificação de dependência falhou para {$a->pluginslist}';
$string['pluginschecktodo'] = 'Você deve resolver todas as requisições de plugin antes de prosseguir com a instalação esta versão do Moodle!';
$string['pluginsoverview'] = 'Visão geral dos Plugins';
$string['pluginsoverviewsee'] = 'Veja a página de <a href="{$a->url}">visão geral de plugins</a> para maiores detalhes.';
$string['policysettings'] = 'Configurações de Política';
$string['privacy:metadata'] = 'O Plugin Administração não armazena nehum dado pessoal.';
$string['privacyandpolicies'] = 'Privacidade e Políticas';
$string['privacysettings'] = 'Configurações de Privacidade';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nome da categoria (deve ser único)';
$string['profilecategorynamenotunique'] = 'O nome desta categoria já foi utilizado';
$string['profilecommonsettings'] = 'Configurações comuns';
$string['profileconfirmcategorydeletion'] = 'Há {$a} campo(s) nessa categoria, que será(ão) movido(s) para a categoria acima (ou abaixo se estiver na categoria mais elevada).<br /> Você ainda deseja excluir essa categoria?';
$string['profileconfirmfielddeletion'] = 'Há {$a} registro(s) de usuários para este campo, que será(ão) excluído(s).<br /> Você ainda deseja excluir este campo?';
$string['profilecreatecategory'] = 'Criar uma nova categoria de perfil';
$string['profilecreatefield'] = 'Criar um novo campo de perfil';
$string['profilecreatenewcategory'] = 'Criando uma nova categoria';
$string['profilecreatenewfield'] = 'Criando uma nova \'{$a}\' campo de perfil';
$string['profiledefaultcategory'] = 'Outros campos';
$string['profiledefaultchecked'] = 'Selecionado por padrão';
$string['profiledefaultdata'] = 'Valor padrão';
$string['profiledeletecategory'] = 'Removendo uma categoria';
$string['profiledeletefield'] = 'Removendo um campo \'{$a}\'';
$string['profiledescription'] = 'Descrição do campo';
$string['profiledscript'] = 'Este script foi colocado no Perfil.';
$string['profiledscriptview'] = 'Exibir informações de perfil para este script';
$string['profileeditcategory'] = 'Editando categoria: {$a}';
$string['profileeditfield'] = 'Editando campo do perfil:{$a}';
$string['profilefield'] = 'Campo de perfil';
$string['profilefieldcolumns'] = 'Colunas';
$string['profilefieldispassword'] = 'Este campo é de senha?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Para transformar o texto em um link, digite uma URL contendo $$, onde $$ será substituído pelo texto. Por exemplo, para transformar um ID do Twitter em um link, digite http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Destino do link';
$string['profilefieldmaxlength'] = 'Limite de caracteres';
$string['profilefieldmaxlength_help'] = 'Para usar este campo na configuração "Mostrar identidade de usuário", o limite deve ser de 255 caracteres ou menos.';
$string['profilefieldrows'] = 'Colunas';
$string['profilefields'] = 'Campos de perfil do usuário';
$string['profilefieldsize'] = 'Tamanho de apresentação';
$string['profileforceunique'] = 'A informação deve ser única?';
$string['profileinvaliddata'] = 'Valor inválido';
$string['profilelocked'] = 'Este campo está trancado?';
$string['profilemenudefaultnotinoptions'] = 'O valor padrão não é uma das opções';
$string['profilemenunooptions'] = 'Nenhum menu de opções foi fornecido';
$string['profilemenuoptions'] = 'Menu de opções (um por linha)';
$string['profilemenutoofewoptions'] = 'Você deve fornecer pelo menos 2 opções';
$string['profilename'] = 'Nome';
$string['profilenofieldsdefined'] = 'Nenhum campo foi definido';
$string['profilerequired'] = 'Este campo é obrigatório?';
$string['profileroles'] = 'Papéis visíveis do perfil';
$string['profilesforenrolledusersonly'] = 'Perfís apenas para usuários inscritos';
$string['profileshortname'] = 'Nome breve (deve ser único)';
$string['profileshortnameinvalid'] = 'Este nome breve pode conter somente caracteres alfanuméricos (letras e números) ou sublinhado (_).';
$string['profileshortnamenotunique'] = 'Este nome breve já está em uso.';
$string['profilesignup'] = 'Mostrar na página de cadastro?';
$string['profilespecificsettings'] = 'Configurações específicas';
$string['profilevisible'] = 'Quem pode ver este campo?';
$string['profilevisible_help'] = '* Não visível - Para dados privados visíveis apenas para os administradores e gerentes
* Visível para o usuário - Para dados privados visíveis apenas para o usuário e administradores
* Visível para o usuário, professores e administradores - Para dados privados visíveis somente para o usuário, administradores e professores (no perfil no contexto do curso)
* Visível para todos';
$string['profilevisibleall'] = 'Visível para todos';
$string['profilevisiblenone'] = 'Não visível';
$string['profilevisibleprivate'] = 'Visível para o usuário';
$string['profilevisibleteachers'] = 'Visivel para o usuário, professores e administradores';
$string['profiling'] = 'Agregação ao perfil.';
$string['profilingallowall'] = 'Agregação contínua ao perfil.';
$string['profilingallowall_help'] = 'Se você habilitar essa opção, então, a qualquer momento, você poderá usar o parâmetro PROFILEALL em qualquer lugar (PGC) para permitir a agregação de todos os scripts executados  durante a sessão Moodle aos perfis. Analogamente, você pode usar o parâmetro PROFILEALLSTOP para pará-lo.';
$string['profilingallowme'] = 'Agregação seletiva ao perfil';
$string['profilingallowme_help'] = 'Se você habilitar essa opção, então poderá, seletivamente, usar o parâmetro PROFILEME em qualquer lugar (PGC) e o script será agregado ao perfil. Analogamente, você pode usar o parâmetro DONTPROFILEME para evitar que isso aconteça.';
$string['profilingautofrec'] = 'Agregação automática ao perfil.';
$string['profilingautofrec_help'] = 'Ao definir essa configuração, alguma solicitação (aleatoriamente, com base na frequência especificada - 1 de N) será selecionada e automaticamente criada com perfil, armazenando os resultados para análises posteriores. Note que esse modo de criação de perfil observa as configurações de inclusão/exclusão. Defina como 0 para desativar a criação de perfil automática.';
$string['profilingenabled'] = 'Habilitar agregação aos perfis';
$string['profilingenabled_help'] = 'Se você habilitar essa opção, então a agregação aos perfis estará disponível neste site e você será capaz de definir seu comportamento através da configuração das opções a seguir.';
$string['profilingexcluded'] = 'Excluir agregação ao perfil';
$string['profilingexcluded_help'] = 'Lista de URLs a que serão excluídas da criação de perfil (separadas por vírgula ou nova linha, ignorando o wwwroot absoluto, que possam ser acessadas), de acordo com a configuração “Profile These”.';
$string['profilingimportprefix'] = 'Prefixo de importação de profiling';
$string['profilingimportprefix_desc'] = 'Para a detecção mais fácil, todas as execuções de profiling importados serão prefixados com o valor especificado aqui.';
$string['profilingincluded'] = 'Agregar estas ao perfil
';
$string['profilingincluded_help'] = 'Lista de URLs que serão automaticamente agregadas ao perfil (separadas por vírgula ou nova linha, ignorando o wwwroot absoluto, que possam ser acessadas). Exemplos: /index.php, /course/view.php. Também aceita o caracter curinga * em qualquer posição. Exemplos: /mod/forum/* , /mod/*/view.php.';
$string['profilinglifetime'] = 'Manter a agregação a perfis em execução';
$string['profilinglifetime_help'] = 'Especifica o tempo que se deseja manter informações sobre a execução de perfis antigos. As mais velhas serão excluidas periodicamente. Observe que isso exclui qualquer execução de perfis marcados como “execução de referência”.';
$string['profilingslow'] = 'Páginas lentas do perfil';
$string['profilingslow_help'] = 'Definindo um tempo mínimo em segundo todas as páginas lentas serão perfilada. Somente perfis mais lentos que um perfil existente para o mesmo script serão mantidos. Defina como 0 para desativar. Note que isso observa as configurações de exclusão.';
$string['protectusernames'] = 'Proteger "usernames"';
$string['proxybypass'] = 'Ignorar hosts proxy
';
$string['proxyfixunsafe'] = 'Corrigir chamadas sem proxy';
$string['proxyhost'] = 'Servidor de Proxy';
$string['proxylogunsafe'] = 'Log de chamadas sem proxy';
$string['proxypassword'] = 'Senha de Proxy';
$string['proxyport'] = 'Porta de Proxy';
$string['proxytype'] = 'Tipo de Proxy';
$string['proxyuser'] = 'Usuário do Proxy';
$string['purgecaches'] = 'Limpar todos os caches';
$string['purgecachesconfirm'] = 'O Moodle pode armazenar em cache temas, javascript, strings de idioma, textos filtrados, feeds RSS e muitas outras partes de dados calculados. Excluir esses caches irá apagar os dados do servidor e forçar os navegadores a buscar novamente os dados, de modo que você poderá ter certeza de estar vendo os valores mais atualizados produzidos pelo código atual. Não há nenhum perigo em apagar os caches, mas o seu site pode aparecer mais lento por um tempo até que o servidor e os clientes calculem novas informações e as enviem para o cache.';
$string['purgecachesfinished'] = 'Todos os dados armazenados em cache foram excluídos.';
$string['purgecachesnoneselected'] = 'Selecione um ou mais caches para limpar';
$string['purgecachespage'] = 'Limpar caches';
$string['purgefiltercache'] = 'Filtros de Texto';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Strings de idioma';
$string['purgemuc'] = 'Todos os caches MUC';
$string['purgeothercaches'] = 'Todos os arquivos e caches diversos';
$string['purgeselectedcaches'] = 'Limpar caches selecionados';
$string['purgeselectedcachesfinished'] = 'Os caches selecionados foram limpos.';
$string['purgetemplates'] = 'Templates';
$string['purgethemecache'] = 'Temas';
$string['query'] = 'Pesquisa';
$string['question'] = 'Questão';
$string['questionbehaviours'] = 'Comportamento da questão';
$string['questioncwqpfscheck'] = 'Uma ou mais questões aleatórias no questionário estão configuradas para selecionar questões de uma mistura de categorias de questões compartilhadas e não compartilhadas. Veja o <a href="{$a->reporturl}">relatório de questões aleatórias</a> e a página <a href="{$a->docsurl}">Moodle Docs</a>.';
$string['questioncwqpfsok'] = 'Certo. Não existe questões \'aleatórias\' em seus questionários que estão configuradas para selecionar categorias de questões que misturem compartilhadas e não compartilhadas.';
$string['questiontype'] = 'Tipo de questão';
$string['questiontypes'] = 'Tipos de questão';
$string['quizattemptsupgradedmessage'] = 'No Moodle 2.1, houve uma grande atualização nas questões. Foi possível adiar partes da atualização do banco de dados para serem executadas mais tarde. Antes de atualizar para o Moodle 2.7, essa atualização deve ser concluída.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA Chave privada';
$string['recaptchapublickey'] = 'ReCAPTCHA Chave pública';
$string['referrernone'] = 'Navegador padrão';
$string['referrerpolicy'] = 'Política de referência';
$string['referrerpolicydesc'] = 'Defina o cabeçalho da política do referenciador a ser incluído nas respostas do seu site.';
$string['register'] = 'Registre seu site';
$string['registration'] = 'Registrar com o Moodle.org';
$string['registration_help'] = 'Registrando:

* Você receberá alertas de segurança;
* Você pode ativar as notificações push do aplicativo para dispositivos móveis em seu site;
* Você está contribuindo com nossas estatísticas do Moodle da comunidade mundial.';
$string['registrationwarning'] = 'Seu site ainda não está registrado.';
$string['registrationwarningcontactadmin'] = 'Seu site ainda não foi registrado. Por favor, informe seu administrador.';
$string['releasenoteslink'] = 'Para obter informações sobre esta versão de Moodle, por favor visite a página <a target="_blank" href="{$a}">Notas sobre a Versão</a>';
$string['rememberuserlicensepref'] = 'Lembrar da preferência de licença do usuário';
$string['rememberuserlicensepref_help'] = 'Se habilitado, a última licença selecionada pelo usuário é pré-selecionada ao carregar um arquivo no seletor de arquivos. Caso contrário, a licença padrão do site será pré-selecionada.';
$string['rememberusername'] = 'Lembrar identificação de usuário';
$string['rememberusername_desc'] = 'Habilite se você deseja armazenar cookies permanentes com "usernames" durante o login do usuário. Cookies permanentes podem ser considerados um problema de privacidade, se utilizados sem consentimento.';
$string['replacefrontsearch'] = 'Usado para busca de curso da página principal';
$string['reportsmanage'] = 'Gerenciar relatórios';
$string['required'] = 'Obrigatório';
$string['requiredentrieschanged'] = 'Nota: Após a atualização, a configuração \'Registros necessários antes da visualização\' agora é aplicada nas seguintes atividades do banco de dados: <br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Exigir descrição da atividade';
$string['requiremodintro_desc'] = 'Se ativado, os usuários serão forçados a introduzir uma descrição para cada atividade.';
$string['requires'] = 'Exige';
$string['resetindentation'] = 'Redefinir a indentação';
$string['resetindentation_help'] = 'Isto removerá qualquer indentação previamente definida para cursos em {$a->format}.';
$string['resetindentation_title'] = 'Redefinir a indentação na página do curso?';
$string['resetindentationsuccess'] = 'Indentação redefinida';
$string['restorecourse'] = 'Restaurar curso';
$string['restorernewroleid'] = 'Papel do usuário restaurador no curso';
$string['restorernewroleid_help'] = 'Se o usuário não tiver permissão para gerenciar o curso recém-restaurado, ele será inscrito automaticamente receberá este papel, se necessário. Selecione "Nenhum" se você não quer que os restauradores sejam capazes de gerenciar todos os cursos restaurados.';
$string['resultfilter'] = 'Filtrar por resultado';
$string['reverseproxy'] = 'Proxy reverso';
$string['reverseproxyignore'] = 'Ignorar proxies reversos';
$string['riskconfig'] = 'Usuários podem mudar a configuração e comportamento do site';
$string['riskconfigshort'] = 'Risco da configuração';
$string['riskdataloss'] = 'Usuários podem destruir grandes quantidades de conteúdo ou informação';
$string['riskdatalossshort'] = 'Risco de perda de dados';
$string['riskmanagetrust'] = 'Usuários podem mudar configurações de segurança de outros usuários';
$string['riskmanagetrustshort'] = 'Gerenciar segurança';
$string['riskpersonal'] = 'Usuários podem ganhar acesso a informações privadas de outros usuários';
$string['riskpersonalshort'] = 'Risco de privacidade';
$string['riskspam'] = 'Usuários podem enviar "spam" para usuários do site ou para outros';
$string['riskspamshort'] = 'Risco spam';
$string['riskxss'] = 'Usuários podem adicionar arquivos e textos que permitem cross-site scripting (XSS)';
$string['riskxssshort'] = 'Risco de XSS';
$string['roleswithexceptions'] = '{$a->roles}, com {$a->exceptions}';
$string['rssglobaldisabled'] = 'Desabilitado a nível de site';
$string['save'] = 'Salvar';
$string['savechanges'] = 'Salvar mudanças';
$string['scssinvalid'] = 'O código SCSS não é válido, falha: {$a}';
$string['search'] = 'Pesquisa';
$string['searchablecourses'] = 'Cursos que podem ser pesquisados';
$string['searchallavailablecourses'] = 'Cursos pesquisáveis';
$string['searchallavailablecourses_desc'] = 'Em algumas situações o mecanismo de busca pode não funcionar ao pesquisar em uma grande quantidade de cursos. Defina para pesquisar apenas em cursos com inscrição se você precisar restringir o número de cursos pesquisados.';
$string['searchallavailablecourses_off'] = 'Pesquisar apenas em cursos com inscrição';
$string['searchallavailablecourses_on'] = 'Pesquisar em todos os cursos que o usuário pode acessar';
$string['searchallavailablecoursesdesc'] = 'Se definido para pesquisar apenas nos cursos inscritos, as informações do curso (nome e resumo) e o conteúdo do curso serão pesquisados apenas nos cursos nos quais o usuário está inscrito. Caso contrário, as informações e o conteúdo do curso serão pesquisados em todos os cursos que o usuário pode acessar, como os cursos com acesso de convidado ativado.';
$string['searchalldeleted'] = 'Todos os conteúdos indexados foram excluídos';
$string['searchalternatesettings'] = 'Configurações alternativas apenas de consulta';
$string['searchalternatesettings_desc'] = 'Se você completar essas configurações, poderá selecionar \'configurações alternativas\' para este mecanismo de pesquisa na opção de mecanismo de pesquisa somente para consulta na página \'Gerenciar pesquisa global\'. Isso só é útil ao se mover entre dois mecanismos de pesquisa do mesmo tipo.';
$string['searchareadisabled'] = 'Área de pesquisa desativada';
$string['searchareaenabled'] = 'Área de pesquisa ativada';
$string['searchareas'] = 'Áreas de pesquisa';
$string['searchbanner'] = 'Informação de pesquisa';
$string['searchbannerenable'] = 'Mostrar informações de pesquisa';
$string['searchbannerenable_desc'] = 'Se ativado, o texto abaixo será exibido na parte superior da tela de pesquisa para todos os usuários. Isso pode ser usado para informar os usuários quando a manutenção do mecanismo de pesquisa está sendo realizada.';
$string['searchdefaultcategory'] = 'Categoria padrão de pesquisa';
$string['searchdefaultcategory_desc'] = 'Os resultados da categoria da área de pesquisa selecionada serão exibidos por padrão.';
$string['searchdeleteindex'] = 'Excluir todo os conteúdos indexados';
$string['searchdisplay'] = 'Opções de exibição dos resultados da pesquisa';
$string['searchenablecategories'] = 'Mostrar os resultados';
$string['searchenablecategories_desc'] = 'Se habilitado, os resultados da pesquisa serão exibidos em categorias separadas.';
$string['searchengine'] = 'Mecanismo de busca';
$string['searchenginealternatesettings'] = '{$a} (configurações alternativas)';
$string['searchenginequeryonly'] = 'Motor de pesquisa apenas de consulta';
$string['searchenginequeryonly_desc'] = 'Este mecanismo de busca será usado apenas para fazer consultas, não indexar. Ao usar esse recurso, você pode reindexar em um mecanismo de pesquisa diferente, enquanto as consultas do usuário continuam funcionando a partir deste.';
$string['searchenginequeryonly_none'] = 'Nenhum (use o mecanismo de busca simples para consultas)';
$string['searchenginequeryonlysame'] = 'O mecanismo de pesquisa somente para consulta e o mecanismo de pesquisa principal não podem ser definidos com o mesmo valor.';
$string['searchhideallcategory'] = 'Oculta a categoria de todos os resultados.';
$string['searchhideallcategory_desc'] = 'Se marcada, a categoria com todos os resultados ficará oculta na tela de resultados da pesquisa.';
$string['searchincludeallcourses'] = 'Incluir todos os cursos visíveis';
$string['searchincludeallcourses_desc'] = 'Se ativado, os resultados da pesquisa incluirão as informações (nome e resumo) dos cursos que estão visíveis ao usuário, mesmo que eles não tenham acesso ao conteúdo do curso.';
$string['searchindexactions'] = 'Ações de índice';
$string['searchindexdeleted'] = 'Índice excluído';
$string['searchindextime'] = 'Tempo limite de indexação';
$string['searchindextime_desc'] = 'Ao indexar grandes quantidades de novos conteúdos, a tarefa agendada irá parar depois que este limite de tempo for atingido. Continuará a próxima vez que a tarefa for executada.';
$string['searchindexupdated'] = 'Os conteúdos do mecanismo de busca foram atualizados';
$string['searchindexwhendisabled'] = 'Indexar quando desativado';
$string['searchindexwhendisabled_desc'] = 'Permite à tarefa agendada construir a indexação de pesquisa quando a pesquisa está desativada. É útil quando se quer contruir a indexação antes da instalação de pesquisa estar disponível para os estudantes.';
$string['searchinsettings'] = 'Pesquisa em configurações';
$string['searchlastrun'] = 'Última vez executado (time, # docs, # records, # ignores)';
$string['searchmanagement'] = 'Gerenciamento de pesquisa';
$string['searchmanagement_desc'] = 'Essas opções são úteis ao fazer alterações em sites com índices de pesquisa muito grandes que levam muito tempo para reconstruir.';
$string['searchmaxtopresults'] = 'Principais resultados';
$string['searchmaxtopresults_desc'] = 'Número máximo de melhores resultados mostrados sobre o resultado de busca por conteúdo, cursos e usuários.';
$string['searchnotavailable'] = 'Busca não disponível';
$string['searchoptions'] = 'Opções de busca';
$string['searchpartial'] = '(ainda não indexado completamente)';
$string['searchreindexed'] = 'Todos os conteúdos do site foram novamente indexados.';
$string['searchreindexindex'] = 'Reindexar todo o conteúdo do site';
$string['searchresults'] = 'Resultados da busca';
$string['searchsetupinfo'] = 'Configuração de pesquisa';
$string['searchteacherroles'] = 'Papéis do professor';
$string['searchteacherroles_desc'] = 'Selecione os papeis que farão usuários com este papel ranquear mais alto nos resultados de pesquisas.';
$string['searchtopresults'] = 'Principais resultados';
$string['searchupdateindex'] = 'Atualizar conteúdos indexados';
$string['sectionerror'] = 'Erro de sessão!';
$string['secureforms'] = 'Usar formulário adicional de segurança';
$string['security'] = 'Segurança';
$string['selectdevice'] = 'Selecione o dispositivo';
$string['selectsearchengine'] = 'Escolha um mecanismo de busca';
$string['selecttheme'] = 'Selecione o tema para o dispositivo {$a}';
$string['server'] = 'Servidor';
$string['serverchecks'] = 'Verificações do servidor';
$string['serverlimit'] = 'Limite do servidor';
$string['sessionautostartwarning'] = '<p>Foi detectado um erro grave de configuração, por favor informe ao administrador do servidor.</p> <p>Para funcionar adequadamente, o Moodle necessita que o administrador modifique as configurações do PHP.</p><p>
<code>session.auto_start</code> deve ser configurado para <code>off</code>.</p><p>Esta configuração é feita editando o <code>php.ini</code>, a configuração do Apache/IIS <br />ou o arquivo <code>.htaccess</code>no servidor.</p>
';
$string['sessioncookie'] = 'Prefixo do Cookie';
$string['sessioncookiedomain'] = 'Domínio do Cookie';
$string['sessioncookiepath'] = 'Caminho do Cookie';
$string['sessionhandling'] = 'Manipulação de sessão';
$string['sessiontimeout'] = 'Tempo limite';
$string['sessiontimeoutwarning'] = 'Aviso de tempo limite';
$string['settingdependenton'] = 'Essa configuração pode estar oculta, com base no valor de <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'O upload de arquivos é necessário para o funcionamento normal, por favor ative-o na configuração do PHP.';
$string['settingmaxinputvars'] = 'É recomendado que a configuração do PHP max_input_vars seja pelo menos 5000.';
$string['settingmaxinputvarsrequired'] = 'A configuração do PHP max_input_vars deve ser pelo menos 5000.';
$string['settingmemorylimit'] = 'Foi detectada memória insuficiente, por favor, aumente o limite de memória nas configurações do PHP.';
$string['settingsafemode'] = 'O Moodle não é totalmente compatível com o "safe mode", por favor peça ao administrador do servidor para desligá-lo. Rodar o Moodle no modo seguro não é suportado, você corre o risco de encontrar vários problemas se fizer isso.';
$string['settingzendexceptionignoreargs'] = 'É altamente recomendável que a configuração PHP zend.exception_ignore_args seja habilitada como precaução de segurança.';
$string['setupsearchengine'] = 'Configuração do mecanismo de busca';
$string['showcommentscount'] = 'Mostrar o número de comentários';
$string['showdetails'] = 'Mostrar detalhes';
$string['showuseridentity'] = 'Mostra a identidade do usuário';
$string['showuseridentity_desc'] = 'Ao selecionar ou pesquisar usuários, e também ao exibir listas de usuários, esses campos podem ser mostrados, além do nome completo. Os campos são exibidos apenas para usuários que têm a permissão moodle/site:viewuseridentity, por padrão, professores e gerentes. (Esta opção faz mais sentido se você escolher um ou dois campos que são obrigatórios na sua instituição.)

Os campos marcados com * são campos de perfil de usuário personalizados. Você pode selecionar esses campos, mas atualmente existem algumas telas onde eles não aparecerão.';
$string['simplexmlrequired'] = 'A extensão SimpleXML para o PHP agora é obrigatória para o Moodle.';
$string['sitemailcharset'] = 'Conjunto de caracteres';
$string['sitemaintenance'] = 'O sistema está em manutenção e não está disponível no momento.';
$string['sitemaintenancemode'] = 'Modo de manutenção';
$string['sitemaintenanceoff'] = 'O modo de manutenção foi desativado e o sistema está funcionando normalmente.';
$string['sitemaintenanceon'] = 'O sistema está em modo de manutenção (só os administradores podem entrar).';
$string['sitemaintenanceoncli'] = 'Seu site está em modo de manutenção CLI, nenhum acesso web é permitido.';
$string['sitemaintenancetitle'] = '{$a} em manutenção';
$string['sitemaintenancewarning'] = 'O sistema está atualmente em modo de manutenção (só os administradores podem entrar). Para retornar à operação normal, <a href="maintenance.php">desabilite o modo de manutenção</a>.';
$string['sitemaintenancewarning2'] = 'Seu site está em modo de manutenção (somente administradores podem se autenticar). Para retornar este site ao modo normal de operação, <a href="{$a}">desabilite o modo de manutenção</a>.';
$string['sitemenubar'] = 'Navegação no site';
$string['sitenameintitle'] = 'Incluir o nome do site no título da página';
$string['sitenameintitle_help'] = 'Esta configuração anexará o nome do site no final do título da página. É recomendável incluir o nome do site no título da página, pois isso melhorará a acessibilidade do site, permitindo que os usuários identifiquem rapidamente a página em que estão atualmente.';
$string['sitepolicies'] = 'Configurações de segurança do site';
$string['sitepolicy'] = 'URL da política do site';
$string['sitepolicy_help'] = 'A URL da política do site que todos os usuários registrados devem ver e concordar com antes de acessarem o site. Note que esta configuração só terá efeito se o manipulador de políticas do site estiver definido como padrão (core).';
$string['sitepolicyguest'] = 'URL de políticas do site para visitantes';
$string['sitepolicyguest_help'] = 'A URL da política do site que todos os visitantes devem ver e concordar com antes de acessarem o site. Note que esta configuração só terá efeito se o manipulador de políticas do site estiver definido como padrão (core).';
$string['sitepolicyhandler'] = 'Manipulador de política do site';
$string['sitepolicyhandler_desc'] = 'Isso determina como as regras e os consentimentos dos usuários são gerenciados. O gerenciador padrão habilita uma regra de URL e uma delas deverá ser especificada para visitantes. O gerenciador de regras permite que elas sejam definidas para o site, a privacidade, dentre outras. Ele também permite que os usuários visualizem os seus consentimentos e, caso aplicável, os menores também.';
$string['sitepolicyhandlercore'] = 'Padrão (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Se selecionado, uma seção tipo tópico será mostrada na página inicial do site.';
$string['sixtyfourbitsrequired'] = 'Foi detectado que seu site não está usando uma versão PHP de 64 bits. É necessário atualizar seu sistema (sistema operacional, PHP...) antes de instalar esta versão do Moodle.';
$string['sixtyfourbitswarning'] = 'Foi detectado que seu site não está usando uma versão do PHP de 64 bits. É recomendável que você atualize seu site para garantir compatibilidade futura.';
$string['slasharguments'] = 'Use argumentos com barra';
$string['slashargumentswarning'] = 'Recomenda-se que a utilização de argumentos com barra seja ativado. No futuro, será necessária. Para mais detalhes, consulte a documentação <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Usando argumentos de barra</a>';
$string['smartpix'] = 'Pesquisa inteligente de pix';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Tipo de autenticação SMTP';
$string['smtpdetail'] = 'Configurações do SMTP (Simple Mail Transfer Protocol) para enviar e-mails.';
$string['smtphosts'] = 'Servidores SMTP';
$string['smtpmaxbulk'] = 'Limite de sessão SMTP';
$string['smtppass'] = 'Senha de SMTP';
$string['smtpsecure'] = 'Segurança SMTP';
$string['smtpuser'] = 'Usuário do SMTP';
$string['soaprecommended'] = 'A extensão SOAP é útilizada por web services e alguns plugins. Sua instalação é opcional.';
$string['sort_fullname'] = 'Nome completo do curso';
$string['sort_idnumber'] = 'Número de identificação do curso';
$string['sort_shortname'] = 'Nome curto do curso';
$string['sort_sortorder'] = 'Ordem de classificação';
$string['spellengine'] = 'Mecanismo de verificação ortográfica';
$string['spelllanguagelist'] = 'Soletrar lista de idiomas';
$string['splrequired'] = 'A extensão SPL do PHP agora é necessária para o Moodle.';
$string['stats'] = 'Estatísticas';
$string['statsfirstrun'] = 'Intervalo máximo de processamento';
$string['statsmaxruntime'] = 'Máximo tempo de execução';
$string['statsmoodleorg'] = 'estatísticas';
$string['statsruntimedays'] = 'Dias a processar';
$string['statsruntimestart'] = 'Rodar em';
$string['statsuserthreshold'] = 'Limite de estatística para o usuário';
$string['stickyblocks'] = 'Blocos adesivos';
$string['stickyblockscourseview'] = 'Página do curso';
$string['stickyblocksduplicatenotice'] = 'Se os blocos que você acrescenta aqui já estão presentes em uma página específica, serão duplicados.<br />O bloco duplicado pode ser editado mas não é possível editar o bloco fixo.';
$string['stickyblocksmymoodle'] = 'Meu Moodle';
$string['stickyblockspagetype'] = 'Tipo de página a ser configurada';
$string['strictformsrequired'] = 'Validação estrita de campos obrigatórios';
$string['stripalltitletags'] = 'Remover tags HTML de todos os nomes das atividades';
$string['supportandservices'] = 'Suporte e serviços';
$string['supportavailability'] = 'Disponibilidade de suporte';
$string['supportcontact'] = 'Contato para suporte técnico';
$string['supportemail'] = 'Email de suporte';
$string['supportemailsubject'] = 'Pedido de suporte - {$a}';
$string['supportname'] = 'Nome de suporte';
$string['supportpage'] = 'Link para contato do suporte do site';
$string['suspenduser'] = 'Suspender conta de usuário';
$string['switchlang'] = 'Trocar diretório de idioma';
$string['systempaths'] = 'Caminhos do sistema';
$string['tablenosave'] = 'Mudanças na tabela acima são salvas automaticamente.';
$string['tablesnosave'] = 'Alterações nas tabelas acima são salvas automaticamente.';
$string['tabselectedtofront'] = 'Em tabelas com abas, a linha da aba selecionada deve estar na frente';
$string['tabselectedtofronttext'] = 'Trazer as colunas selecionadas para frente';
$string['task_adhoc_concurrency_limit'] = 'Limite de concorrência de tarefas ad hoc';
$string['task_adhoc_concurrency_limit_desc'] = 'O número de executores de tarefas ad hoc com permissão para executar simultaneamente. Se o limite for alto, as tarefas agendadas podem não ser executadas regularmente quando há muitas tarefas ad hoc. Uma configuração de 0 desativará completamente o processamento de tarefas ad hoc.';
$string['task_adhoc_max_runtime'] = 'Máximo de tempo para execução para tarefa ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'A duração de um executor de tarefa adhoc antes de ser liberado. É recomendada uma duração baixa, pois não há limite para o número de tarefas adhoc na fila. Se esse número for muito alto e você tiver uma fila grande de tarefas adhoc, as tarefas agendadas poderão não ser executadas regularmente.';
$string['task_dbreads'] = 'Leituras de banco de dados';
$string['task_dbstats'] = 'Banco de dados';
$string['task_dbwrites'] = 'Gravações de banco de dados';
$string['task_duration'] = 'Duração';
$string['task_endtime'] = 'Horário final';
$string['task_logmode'] = 'Quando registrar';
$string['task_logmode_all'] = 'Armazena a saída de log de todos os "jobs"';
$string['task_logmode_desc'] = 'Você pode escolher quando deseja que o log de tarefa aconteça. Por padrão, os logs são sempre capturados. Você pode desabilitar completamente ou alterar para apenas log das tarefas que falharem.';
$string['task_logmode_failonly'] = 'Armazena apenas logs para as tarefas que falharem.';
$string['task_logmode_none'] = 'Não adicionar nada ao log';
$string['task_logoutput'] = 'Task output';
$string['task_logretainruns'] = 'Manter as execuções';
$string['task_logretainruns_desc'] = 'O número de execuções mantidos de cada tarefa. Essas configurações interagem com a configuração do \'Período de Retenção\': o que for alcançado primeiro será aplicado.';
$string['task_logretention'] = 'Período de retenção';
$string['task_logretention_desc'] = 'Período máximo para o qual os logs devem ser mantidos. Essa configuração interage com a configuração \'Manter execuções\': o que for atingido primeiro será aplicado.';
$string['task_logtostdout'] = 'Exibir saída de log';
$string['task_logtostdout_desc'] = 'Quando os trabalhos estão em execução e a saída é capturada, se a saída capturada também deve ser exibida à medida que a tarefa é executada.';
$string['task_result'] = 'Resultado';
$string['task_result:failed'] = 'Erro';
$string['task_scheduled_concurrency_limit'] = 'Limite de tarefas agendadas simultâneas';
$string['task_scheduled_concurrency_limit_desc'] = 'O número executores de tarefas agendadas que podem ser executadas simultaneamente. Se o limite for alto, o servidor poderá ter sobrecarga e ter seu desempenho afetado. Uma configuração 0 desabilitará completamente o processamento de tarefas agendadas.';
$string['task_scheduled_max_runtime'] = 'Duração programada do executor de tarefas';
$string['task_scheduled_max_runtime_desc'] = 'O período de tempo de um executor de tarefas agendado antes de ser liberado.';
$string['task_starttime'] = 'Hora inicial';
$string['task_stats:dbreads'] = '{$a} leituras';
$string['task_stats:dbwrites'] = '{$a} escritas';
$string['task_status'] = 'Status da tarefa';
$string['task_status_desc'] = 'A tarefa <em>{$a->name}</em> está <strong>{$a->status}</strong>. Para detalhes, veja {$a->class} {$a->extradescription} em <a href="{$a->gotourl}"> Tarefas agendadas</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Agendada';
$string['taskadmintitle'] = 'Tarefas';
$string['taskanalyticscleanup'] = 'Limpeza de analytics';
$string['taskautomatedbackup'] = 'Backups automáticos';
$string['taskbackupcleanup'] = 'Limpar tabelas, logs e arquivos de backup';
$string['taskbadgescron'] = 'Conceder emblemas';
$string['taskbadgesmessagecron'] = 'Processamento em segundo plano para envio de notificação de emblemas';
$string['taskblogcron'] = 'Sincronize blogs externos';
$string['taskcachecleanup'] = 'Remover entradas de cache expirados';
$string['taskcachecron'] = 'Processamento em segundo plano para caches';
$string['taskcalendarcron'] = 'Enviar notificações de calendário';
$string['taskcheckforupdates'] = 'Verificar atualizações';
$string['taskcompletiondaily'] = 'Marca a conclusão como iniciada';
$string['taskcompletionregular'] = 'Cálculo regular da data de conclusão';
$string['taskcontextcleanup'] = 'Limpar contextos';
$string['taskcreatecontexts'] = 'Criar contextos ausentes';
$string['taskdeletecachetext'] = 'Excluir registros de textos antigos em cache';
$string['taskdeleteincompleteusers'] = 'Excluir usuários incompletos';
$string['taskdeleteunconfirmedusers'] = 'Excluir usuários não confirmados';
$string['taskeventscron'] = 'Processamento em segundo plano para eventos';
$string['taskfiletrashcleanup'] = 'Limpar arquivos na lixeira';
$string['taskglobalsearchindex'] = 'Indexação de pesquisa global';
$string['taskglobalsearchoptimize'] = 'Otimização de índice da busca global';
$string['taskgradecron'] = 'Processamento em segundo plano para livro de notas';
$string['taskgradehistorycleanup'] = 'Processamento em segundo plano para limpeza de tabelas de histórico de notas';
$string['taskh5pcleanup'] = 'Limpar arquivos H5P não utilizados';
$string['tasklegacycron'] = 'Processamento do cron antigo para plugins';
$string['tasklockcleanuptask'] = 'Limpar metadados de tarefas ad hoc';
$string['tasklogcleanup'] = 'Limpeza de logs de tarefas';
$string['tasklogging'] = 'Configuração do log de tarefas';
$string['tasklogs'] = 'Logs de tarefas';
$string['taskmessagingcleanup'] = 'Processamento em segundo plano para mensagens';
$string['taskpasswordresetcleanup'] = 'Limpar tentativas de recuperação se senha';
$string['taskplagiarismcron'] = 'Processamento em segundo plano para antigo agendador em plugins de plágio';
$string['taskportfoliocron'] = 'Processamento em segundo plano para plugins de portfolio';
$string['taskprocessing'] = 'Processamento de tarefas';
$string['taskquestioncron'] = 'Processamento em segundo plano para limpeza de visualizações de questão';
$string['taskquestionstatscleanupcron'] = 'Processamento em segundo plano para limpar o cache de estatísticas de questão';
$string['taskrefreshsystemtokens'] = 'Atualizar os tokens OAuth para as contas de serviço';
$string['taskregistrationcron'] = 'Registro do site';
$string['tasksendfailedloginnotifications'] = 'Enviar avisos de falha de autenticação';
$string['tasksendnewuserpasswords'] = 'Enviar novas senhas de usuários';
$string['tasksessioncleanup'] = 'Limpar sessões antigas';
$string['taskstatscron'] = 'Processamento em segundo plano para as estatísticas';
$string['tasktagcron'] = 'Processamento em segundo plano para as tags';
$string['tasktempfilecleanup'] = 'Excluir arquivos temporários obsoletos';
$string['tasktype'] = 'Tipo';
$string['tempdatafoldercleanup'] = 'Limpar arquivos de dados temporários com mais de';
$string['templates'] = 'Templates';
$string['testoutgoingmailconf'] = 'Testar configuração de saída de e-mail';
$string['testoutgoingmailconf_errorcommunications'] = 'Seu site não pôde se comunicar com seu servidor de e-mail. Por favor, verifique sua configuração de saída de e-mail.';
$string['testoutgoingmailconf_fromemail'] = 'Do nome de usuário ou endereço de email';
$string['testoutgoingmailconf_fromemail_help'] = 'Este campo emula o envio da mensagem daquele usuário, mas o cabeçalho De usado no e-mail real enviado dependerá de outras configurações, como allowedemaildomains';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Nome de usuário ou email inválido. O remetente deve ser um formato de email válido ou um nome de usuário existente no Moodle.';
$string['testoutgoingmailconf_message'] = 'Esta é uma mensagem de teste para confirmar que você configurou corretamente a saída de email do seu site.
Enviado: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Enviar uma mensagem de teste';
$string['testoutgoingmailconf_sentmail'] = 'Este site enviou com sucesso uma mensagem de teste para o servidor de email. <br /> De: {$a->fromemail} <br /> Para: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: mensagem de teste. {$a->additional} Enviado: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Assunto adicional';
$string['testoutgoingmailconf_toemail'] = 'Para endereço de email';
$string['testoutgoingmaildetail'] = 'Atenção: Antes de testar, por favor salve sua configuração. <br /> {$a}';
$string['testsiteupgradewarning'] = 'Você está usando o site de teste {$a}, para atualizá-lo usar corretamente a ferramenta de interface de linha de comando';
$string['themedesignermode'] = 'Modo de designer de tema
';
$string['themedesignermodewarning'] = 'O modo de design de tema está ativo. Isso não deve ser habilitado em sites de produção, pois pode reduzir significativamente o desempenho.';
$string['themelist'] = 'Lista de temas';
$string['themenoselected'] = 'Nenhum tema selecionado';
$string['themeresetcaches'] = 'Limpar o cache de temas';
$string['themeselect'] = 'Trocar tema';
$string['themeselector'] = 'Seletor de tema';
$string['themesettings'] = 'Configurações de tema';
$string['therewereerrors'] = 'Os dados continham erros';
$string['thirdpartylibrary'] = 'Biblioteca';
$string['thirdpartylibrarylocation'] = 'Localização';
$string['thirdpartylibs'] = 'Bibliotecas de terceiros';
$string['timezone'] = 'Fuso-horário padrão';
$string['timezoneforced'] = 'Fuso horário fixado pelo administrador';
$string['timezoneinvalid'] = 'Fuso horário inválido "{$a}"';
$string['timezoneisforcedto'] = 'Forçar todos os usuários a usar';
$string['timezonenotforced'] = 'O usuário pode escolher seu fuso horário';
$string['timezonephpdefault'] = 'Fuso horário padrão PHP ({$a})';
$string['timezoneserver'] = 'Fuso horário do servidor ({$a})';
$string['tlswarning'] = 'Nenhuma extensão PHP/cURL com suporte TLSv1.2 foi detectada. Alguns serviços podem não funcionar. É altamente recomendável atualizar suas bibliotecas TLS.';
$string['tokenduration'] = 'Duração de token criado pelo usuário';
$string['tokenduration_desc'] = 'Duração de tempo em que um token criado pelo usuário (por exemplo pelo aplicativo mobile) é válido.';
$string['tokenizerrecommended'] = 'É recomendado instalar extensão Tokenizer do PHP, que é opcional, isto incrementa a funcionalidade do Moodle em Rede.';
$string['tools'] = 'Ferramentas administrativas';
$string['toolsmanage'] = 'Gerenciar ferramentas administrativas';
$string['unattendedoperation'] = 'Operação não realizada';
$string['unbookmarkthispage'] = 'Desmarcar esta página';
$string['unicoderequired'] = 'É obrigatório que você guarde todos os seus dados no formato Unicode (UTF-8). Instalações novas devem ser construidas em banco de dados que tenham o seu conjunto de caracteres padrão em Unicode. Se você está migrando, você deverá executar o processo de migração para o UTF-8. (veja a página do Admin)';
$string['uninstallplugin'] = 'Desinstalar';
$string['unlockaccount'] = 'Desbloquear a conta';
$string['unoconvwarning'] = 'A versão do unoconv que esta instalado não é suportado. Recurso de atribuição de classificação Moodle requer a versão 0.7 ou superior.';
$string['unsettheme'] = 'Tema não definido';
$string['unsupported'] = 'Não tem suporte';
$string['unsupporteddbfileformat'] = 'Seu banco de dados utiliza Antelope como formato de arquivo. O suporte completo da codificação UTF-8 no MySQL e o MariaDB requer o formato do arquivo Barracuda. Converta para o formato de arquivo Barracuda. Consulte a documentação <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL suporte completo unicode</a> para detalhes.';
$string['unsupporteddbfilepertable'] = 'Para suporte total ao UTF-8, o MySQL e MariaDB exigem que altere a sua configuração MySQL \'innodb_file_per_table\' para \'ON\'. Consulte a documentação para obter mais detalhes.';
$string['unsupporteddblargeprefix'] = 'Para suporte total do UTF-8, o MySQL e MariaDB exigem que altere a sua configuração MySQL \'innodb_large_prefix\' para \'ON\'. Consulte a documentação para obter mais detalhes.';
$string['unsupporteddbstorageengine'] = 'O mecanismo de armazenamento do banco de dados que está em uso não é mais suportado.';
$string['unsupporteddbtablerowformat'] = 'Seu banco de dados possui tabelas usando Antelope como formato de arquivo. Recomenda-se converter as tabelas para o formato de arquivo Barracuda. Consulte a documentação <a href="https://docs.moodle.org/en/cli">Administração via linha de comando</a> para detalhes de uma ferramenta para converter tabelas InnoDB para Barracuda.';
$string['unsupportedphpversion7'] = 'PHP versão 7 e superior não são suportados.';
$string['unsupportedphpversion71'] = 'PHP versão 7.1 e superior não são suportados.';
$string['unsupportedphpversion72'] = 'PHP versão 7.2 e superior não são suportados.';
$string['unsupportedphpversion73'] = 'PHP versão 7.3 e superior não são suportados.';
$string['unsupportedphpversion74'] = 'PHP versão 7.4 e superior não são suportados.';
$string['unsupportedphpversion80'] = 'PHP versão 8.0 e superior não são suportados.';
$string['unsupportedphpversion81'] = 'PHP versão 8.1 e superior não são suportados.';
$string['unsupportedphpversion82'] = 'PHP versão 8.2 e/ou superior não são suportados.';
$string['unsupportedphpversion83'] = 'A versão PHP 8.3 ou superior não é suportada.';
$string['unsuspenduser'] = 'Ativar conta de usuário';
$string['updateaccounts'] = 'Atualizar contas existentes';
$string['updateautocheck'] = 'Verificar automaticamente novas atualizações';
$string['updateautocheck_desc'] = 'Se habilitado, seu site irá buscar automaticamente por atualizações disponíveis tanto do Moodle como dos plugins. Se houver uma nova atualização disponível, uma notificação será enviada aos administradores.';
$string['updateavailable'] = 'Há uma nova versão do Moodle disponível!';
$string['updateavailable_moreinfo'] = 'Mais informações...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versão {$a}';
$string['updateavailabledetailslink'] = 'Veja {$a->url} para mais detalhes';
$string['updateavailableforplugin'] = 'Existe uma versão mais recente disponível para alguns de seus plugins!';
$string['updateavailableinstall'] = 'Instalar esta atualização';
$string['updateavailableinstallall'] = 'Instalar atualizações disponíveis ({$a})';
$string['updateavailableinstallallhead'] = 'Instalando atualizações disponíveis';
$string['updateavailablenot'] = 'Seu código do Moodle está atualizado!';
$string['updateavailablerecommendation'] = 'É altamente recomendável que você atualize o seu site para a versão mais recente para obter todas as últimas correções de segurança e bugs.';
$string['updatecomponent'] = 'Atualizar componente';
$string['updateminmaturity'] = 'Maturidade mínima do código';
$string['updateminmaturity_desc'] = 'Notificações a respeito de atualizações são enviadas somente se o código tiver a maturidade selecionada. Atualizações de plugins que não declaram a maturidade do código são sempre reportadas sem levar em conta esse dado.';
$string['updatenotificationfooter'] = 'Seu site Moodle {$a->siteurl} está configurado para verificar automaticamente por atualizações disponíveis. Você está recebendo esta mensagem como administrador desse site. Você pode desabilitar as verificações automáticas por atualizações disponíveis na Administração do site / Servidor / Notificações de atualização ou customizar a entrega desta mensagem através de sua página preferências.';
$string['updatenotifications'] = 'Notificações de atualização';
$string['updatenotificationsubject'] = 'Há atualizações disponíveis para seu site Moodle
({$a->siteurl})';
$string['updatenotifybuilds'] = 'Avisar sobre novas versões "menores"';
$string['updatenotifybuilds_desc'] = 'Se habilitada, as atualizações disponíveis para o código do Moodle também serão reportadas quando uma nova versão "menor" da versão atual estiver disponível (por exemplo, 2.9.2 se você estiver usando a 2.9.1 ou 2.9). As versões menores  introduzem melhorias continuas em uma certa versão do Moodle e são liberadas semanalmente. Se desabilitado, as atualizações disponíveis somente serão reportadas quando houver uma nova versão "maior" do Moodle. As verificações de plugins não são afetadas por essa configuração.';
$string['upgradeerror'] = 'Erro desconhecido atualizando {$a->plugin} para a versão {$a->version}, não é possível prosseguir.';
$string['upgradeforumread'] = 'No Moodle 1.5 foi adicionada a possibilidade de monitorar as mensagens lidas/não lidas.<br />Para usar esta funcionalidade você precisa <a href="{$a}">atualizar as suas tabelas</a>';
$string['upgradeforumreadinfo'] = 'No Moodle 1.5 foi adicionada a possibilidade de monitorar as mensagens lidas/não lidas. Para usar esta funcionalidade, você precisa atualizar as tabelas que registram as informações das mensagens existentes. Dependendo do tamanho de sua instalação, isto pode tomar bastante tempo (horas) e pode exigir bastante do banco de dados, portanto é melhor fazê-lo num período de pouco uso. Enquanto isto a sua instalação continuará funcionando e os usuários não serão afetados. Uma vez iniciado este processo, permitir que seja concluído (mantenha a janela de seu navegador aberta). Se você interromper o processo fechando a janela, não se preocupe, você pode começar novamente.<br /><br />Quer iniciar o processo de atualização agora?';
$string['upgradekeyreq'] = 'Chave de atualização necessária';
$string['upgradekeyset'] = 'Chave de atualização (deixe em branco para não defini-la)';
$string['upgradelogs'] = 'Para o funcionamento completo os logs antigos tem que ser atualizados. <a href="{$a}">Mais informações</a>';
$string['upgradelogsinfo'] = 'Para que os logs antigos possam ser consultados em conexão com as atividades correspondentes, estes devem ser atualizados e arquivados segundo os novos parâmetros da aplicação. Se o seu site for muito grande este processo pode demorar algumas horas e sobrecarregar a base de dados. Não interrompa o processo, depois de iniciá-lo mantenha a janela do navegador aberta. Não se preocupe, os usuários poderão continuar a navegar no site durante este processo.<br /><br /> Você quer iniciar a atualização agora?';
$string['upgradepluginsfirst'] = 'Recomenda-se instalar todas as atualizações disponíveis primeiro';
$string['upgradepluginsinfo'] = 'Atualizando plugins';
$string['upgradepluginsinfo_help'] = 'Há atualizações disponíveis para alguns de seus plugins. Você deve instalar todos antes da atualização do banco de dados do Moodle. Se o seu site não suporta a instalação automática de atualizações, você tem que baixar e instalar novas versões do plugin no seu servidor manualmente.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Novas configurações';
$string['upgradesettingsintro'] = 'A configuração mostrada abaixo foi adicionada durante a sua última atualização do Moodle. Faça as alterações necessárias para o padrão e clique o botão \'Salvar mudanças\' no final desta página.';
$string['upgradestalefiles'] = 'Versões do Moodle misturadas detectadas, atualização não pode continuar';
$string['upgradestalefilesinfo'] = 'O processo de atualização do Moodle foi interrompido porque os scripts PHP de pelo menos duas versões principais foram detectados no diretório Moodle.

Isso pode causar sérios problemas mais tarde. Para continuar, você deve garantir que o diretório Moodle contenha apenas os arquivos de uma única versão do Moodle.

A maneira recomendada para limpar seu diretório Moodle é a seguinte:

* renomear o diretório atual do Moodle para "moodle_old"
* criar um novo diretório contendo apenas os arquivos obtidos via download de um pacote-padrão do Moodle, ou a partir do repositório Git do Moodle
* mover o config.php original e quaisquer plugins não-padrão do diretório "moodle_old" para o novo diretório.

Quando você tiver um diretório Moodle "limpo", atualize esta página para prosseguir com o processo de atualização.

Este aviso é frequentemente causado ao descompactar um pacote-padrão do Moodle sobre uma versão anterior. Enquanto isto é aceitável para pequenas atualizações, é fortemente não recomendada para grandes atualizações do Moodle.

Esta advertência também pode ser causada por um "checkout" ou operação de atualização incompleta do repositório Git: neste caso, aguarde a conclusão da operação, ou execute o comando apropriado de limpeza e repita a operação.

Você pode encontrar mais informações na documentação de atualização em <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Atualizar base de dados do Moodle agora';
$string['upgradesure'] = '<p> Seus arquivos do Moodle foram alterados, e você está prestes a atualizar automaticamente o seu servidor para esta versão: </p>
<p> <strong>{$a}</strong> </p>
<p> Uma vez que você fizer isso, você não pode voltar novamente. Por favor, note que este processo pode levar um longo tempo. </p>
<p> Você tem certeza de que deseja atualizar este servidor para esta versão? </p>';
$string['upgradetimedout'] = 'O tempo de atualização expirou, por favor, reinicie a operação.';
$string['upgradingdata'] = 'Atualizando os dados';
$string['upgradinglogs'] = 'Atualizando logs';
$string['upgradingversion'] = 'Atualizando para nova versão';
$string['upwards'] = 'para cima';
$string['useblogassociations'] = 'Habilitar associações';
$string['useexternalyui'] = 'Use bibliotecas YUI online
';
$string['user'] = 'Usuário';
$string['userbulk'] = 'Ações em lote sobre usuários';
$string['userbulkdownload'] = 'Exportar usuários como';
$string['userdefaultpreferences'] = 'Preferências padrão do usuário';
$string['userfeedbackafterupgrade'] = 'Após cada grande atualização';
$string['userfeedbackencouragement'] = '<p>No Moodle 3.9 em diante, foi incluída uma nova funcionalidade que permite aos usuários a opção de fornecer feedback sobre o software Moodle ao Moodle HQ via site de pesquisa externo hospedado pelo Moodle HQ. Nenhuma informação de identificação do usuário é encaminhada para o site de pesquisa.</p>
<p>O Moodle HQ se esforça para ser aberto e transparente sobre suas práticas de coleta de dados. Assim, queremos ter certeza de que você está ciente e no controle desta funcionalidade.</p>
<p>O feedback dos usuários ajudará bastante o Moodle HQ na melhoria do software Moodle. Para habilitar esta funcionalidade, por favor acesse <a href="{$a}">Configurações de Feedback</a>.</p>';
$string['userfeedbacknextreminder'] = 'Próximo lembrete de feedback';
$string['userfeedbacknextreminder_desc'] = 'Quando nós devemos pedir ao usuário para dar feedback de novo?';
$string['userfeedbackperiodically'] = 'Periodicamente';
$string['userfeedbackremindafter'] = 'Mostrar lembrete mais tarde';
$string['userfeedbackremindafter_desc'] = 'Lembrar os usuários novamente para fornecer feedback após um determinado número de dias.';
$string['userfiltersdefault'] = 'FIltros de usuário padrão';
$string['userfiltersdefault_desc'] = 'Selecione os filtros que devem ser mostrados na página \'Lista de usuários\' e na página \'Ações em lote com usuários\'. Mantenha pressionada a tecla Ctrl para selecionar vários itens. Quaisquer filtros não selecionados estarão disponíveis clicando no link "Mostrar mais".';
$string['userimagesdisabled'] = 'As imagens do usuário do perfil estão desativadas';
$string['userlist'] = 'Lista de usuários';
$string['usermanagement'] = 'Gerenciamento de usuário';
$string['userpolicies'] = 'Políticas para usuários';
$string['userpreference'] = 'Preferências de usuário';
$string['userquota'] = 'Espaço de arquivos privados';
$string['userquota_desc'] = 'A quantidade máxima de dados que cada usuário pode armazenar em sua área de arquivos privados.';
$string['users'] = 'Usuários';
$string['usesitenameforsitepages'] = 'Use nome do site para as páginas do site';
$string['usetags'] = 'Habilitar funcionalidade de tags';
$string['validateemptylineerror'] = 'Linhas em branco não são válidas';
$string['validateerror'] = 'Este valor não é válido';
$string['validateerrorlist'] = 'Estes registos são inválidos: {$a}';
$string['validateiperror'] = 'Estes endereços IP são inválidos: {$a}';
$string['verifychangedemail'] = 'Restringir domínios quando na alteração do endereço de email';
$string['warningcurrentsetting'] = 'Valor atual inválido: {$a}';
$string['warningiconvbuggy'] = 'Sua versão da biblioteca iconv não suporta o / / IGNORE modificador. Você deve instalar a extensão mbstring o que pode ser usado em vez de cordas de limpeza que contenham caracteres UTF-8 inválidos.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Preencher as opções a seguir se o seu servidor Moodle não pode acessar a internet diretamente. O acesso à internet é necessário para o download dos dados do ambiente, pacotes de idiomas, RSS, fusos-horários, etc.<br /><em>A extensão PHP cURL é altamente recomendada.</em>';
$string['xmlrpcwebserviceenabled'] = 'Foi detectado que o protocolo XML-RPC Web Service está habilitado em seu site. Este recurso depende da extensão PHP XML-RPC que não é mais mantida pelo PHP.';
$string['yuicomboloading'] = 'Carregamento do combo YUI';
$string['ziprequired'] = 'A extensão Zip do PHP é obrigatória. Binários infoZIP ou PclZip não são mais utilizados.';
