<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'ru', version '4.1'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Я принимаю <a href=":url" target="_blank">условия</a>';
$string['action'] = 'Действие';
$string['add'] = 'Добавить';
$string['addedandupdatedpp'] = 'Добавлены новые библиотеки H5P {$a->%new} и обновлены старые {$a->%old}.';
$string['addedandupdatedps'] = 'Добавлены новые библиотеки H5P {$a->%new} и обновлены старые {$a->%old}.';
$string['addedandupdatedsp'] = 'Добавлены новые библиотеки H5P {$a->%new} и обновлены старые {$a->%old}.';
$string['addedandupdatedss'] = 'Добавлена новая библиотека H5P {$a->%new} и обновлена  старая {$a->%old}.';
$string['addednewlibraries'] = 'Добавлены новые библиотеки H5P ({$a->%new}).';
$string['addednewlibrary'] = 'Добавлена новая библиотека H5P {$a->%new}.';
$string['additionalinfo'] = 'Дополнительная информация';
$string['additionallicenseinfo'] = 'Любая дополнительная информация о лицензии';
$string['addlibraries'] = 'Добавить библиотеки';
$string['address'] = 'Адрес';
$string['ajaxfailed'] = 'Не удалось загрузить данные.';
$string['anunexpectedsave'] = 'Произошел сбой. Не удалось сохранить данные.';
$string['attribution'] = 'Attribution 4.0';
$string['attributionnc'] = 'Attribution-NonCommercial 4.0';
$string['attributionncnd'] = 'Attribution-NonCommercial-NoDerivs 4.0';
$string['attributionncsa'] = 'Attribution-NonCommercial-ShareAlike 4.0';
$string['attributionnd'] = 'Attribution-NoDerivs 4.0';
$string['attributionsa'] = 'Attribution-ShareAlike 4.0';
$string['author'] = 'Автор';
$string['authorcomments'] = 'Комментарии автора';
$string['authorcommentsdescription'] = 'Комментарии для редактора контента (Этот текст не будет опубликован как часть информации об авторских правах).';
$string['authorname'] = 'Имя автора';
$string['authorrole'] = 'Роль автора';
$string['cancel'] = 'Отмена';
$string['cancellabel'] = 'Отмена';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Нет';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Да';
$string['ccattribution'] = 'С указанием авторства (CC BY)';
$string['ccattributionnc'] = 'С указанием авторства - Некоммерческая (CC BY-NC)';
$string['ccattributionncnd'] = 'С указанием авторства - Некоммерческая - Без производных (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'С указанием авторства - Некоммерческая - С сохранением условий (CC BY-NC-SA)';
$string['ccattributionnd'] = 'С указанием авторства - Без производных (CC BY-ND)';
$string['ccattributionsa'] = 'С указанием авторства - С сохранением условий (CC BY-SA)';
$string['ccpdd'] = 'Отказ от авторских прав, передача в общественное достояние';
$string['ccpdm'] = 'Произведение, находящееся в общественном достоянии';
$string['changedby'] = 'Изменено';
$string['changedescription'] = 'Описание изменений';
$string['changelog'] = 'Список изменений';
$string['changeplaceholder'] = 'Изображение обрезано, текст изменен и т.д.';
$string['city'] = 'Город';
$string['close'] = 'Закрыть';
$string['completionpassdesc'] = 'Студент должен набрать проходной балл для завершения элемента';
$string['confirmdialogbody'] = 'Пожалуйста, подтвердите, что вы хотите продолжить. Это действие необратимо.';
$string['confirmdialogheader'] = 'Подтвердите действие';
$string['confirmlabel'] = 'Подтвердить';
$string['connectionlost'] = 'Соединение потеряно. Результаты будут сохранены и отправлены вам, когда восстановится соединение.';
$string['connectionreestablished'] = 'Соединение восстановлено.';
$string['contactperson'] = 'Контактное лицо';
$string['contentchanged'] = 'Этот контент был изменен с момента его последнего использования.';
$string['contentcopied'] = 'Скопировано в буфер обмена';
$string['contentstatefrequency'] = 'Частота сохранения состояния контента';
$string['contentstatefrequency_help'] = 'В секундах. Частота автоматического сохранения изменений пользователя. Увеличьте это число, если у вас возникли проблемы со многими запросами ajax';
$string['contenttype'] = 'Тип содержимого';
$string['contenttypecacheheader'] = 'Кэш типов контента';
$string['copyright'] = 'Права на использование';
$string['copyrightinfo'] = 'Информация об авторских правах';
$string['copyrightstring'] = 'Авторское право';
$string['copyrighttitle'] = 'Просмотр информации об авторских правах на этот контент.';
$string['couldnotcopy'] = 'Невозможно скопировать файл.';
$string['couldnotparsejsonfromzip'] = 'Невозможно разобрать JSON из массива: %fileName';
$string['couldnotparsepostdata'] = 'Невозможно разобрать отправленные данные.';
$string['couldnotreadfilefromzip'] = 'Невозможно прочитать файл из массива: %fileName';
$string['couldnotsave'] = 'Невозможно сохранить файл.';
$string['country'] = 'Страна';
$string['create'] = 'Создать';
$string['creativecommons'] = 'Творческие Сообщества';
$string['ctcachebuttonlabel'] = 'Обновление кэша типов контента';
$string['ctcacheconnectionfailed'] = 'Не удалось установить связь с H5P Hub. Пожалуйста, повторите попытку позже.';
$string['ctcachedescription'] = 'Убедившись, что кэш типов контента обновлен, вы сможете просматривать, загружать и использовать последние библиотеки. Это отличается от обновления самих библиотек.';
$string['ctcachelastupdatelabel'] = 'Последнее обновление';
$string['ctcacheneverupdated'] = 'Никогда';
$string['ctcachenolibraries'] = 'Никакие типы контента не были получены от H5P Hub. Пожалуйста, повторите попытку позже.';
$string['ctcachesuccess'] = 'Кэш библиотек был успешно обновлён!';
$string['ctcachetaskname'] = 'Обновление кэша типов контента';
$string['currentpage'] = 'Страница $current из $total';
$string['dataviewreportlabel'] = 'Посмотреть ответы';
$string['date'] = 'Дата';
$string['description'] = 'Описание';
$string['disablefileextensioncheck'] = 'Отключить проверку расширения файла';
$string['disablefileextensioncheckwarning'] = 'Внимание! Отключение проверки расширения файла может иметь последствия для безопасности, поскольку это позволяет загружать php-файлы. Это, в свою очередь, может позволить злоумышленникам выполнить вредоносный код на вашем сайте. Пожалуйста, убедитесь, что вы уверены в том, что загружаете.';
$string['disablefullscreen'] = 'Отключить полноэкранный режим';
$string['disablehubconfirmationmsg'] = 'Вы всё ещё хотите отключить hub?';
$string['disablehubdescription'] = 'Настоятельно рекомендуется оставить эту опцию включенной. H5P Hub предоставляет простой интерфейс для получения новых типов контента и обновления существующих типов контента. В будущем это также упростит совместное использование и повторное использование контента. Если этот параметр отключен, вам нужно будет устанавливать и обновлять типы контента с помощью форм для загрузки файлов.';
$string['displayoptionalwaysshow'] = 'Всегда показывать';
$string['displayoptionauthoroff'] = 'Контролируется автором, по умолчанию отключено';
$string['displayoptionauthoron'] = 'Контролируется автором, по умолчанию включено';
$string['displayoptiondownloadalways'] = 'Всегда';
$string['displayoptiondownloadnever'] = 'Никогда';
$string['displayoptiondownloadpermission'] = 'Только при наличии разрешения на экспорт H5P';
$string['displayoptionnevershow'] = 'Никогда не показывать';
$string['displayoptionpermissions'] = 'Показывать только, если пользователь имеет разрешения на экспорт H5P';
$string['displayoptionpermissionsembed'] = 'Показывать только если у пользователя есть права на встраивание H5P';
$string['displayoptions'] = 'Отобразить настройки';
$string['download'] = 'Скачать';
$string['downloadfailed'] = 'Не удалось загрузить запрошенную библиотеку.';
$string['downloadtitle'] = 'Загрузить этот контент как H5P файл.';
$string['editor'] = 'Редактор';
$string['emailaddress'] = 'Адрес Email';
$string['emailconfirmbody'] = 'Здравствуйте, {$a->username}.
Спасибо Вам за отправленные ответы {$a->hvpname} в курсе «{$a->coursename}».
Это сообщение подтверждает, что Ваши ответы были сохранены.
Вы можете получить доступ к H5P в {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Спасибо Вам за отправленные ответы \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Подтверждение отправки: {$a->hvpname}';
$string['emailnotifybody'] = 'Здравствуйте, {$a->username}.
{$a->studentname} завершил(а) \'{$a->hvpname}\' ({$a->hvpurl}) в курсе \'{$a->coursename}\'.
Вы можете просмотреть данную попытку в {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} завершил(а) {$a->hvpname}. Посмотреть {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} завершил {$a->hvpname}.';
$string['embed'] = 'Вставить';
$string['embedloginfailed'] = 'У вас нет доступа к этому контенту. Попробуйте войти в систему';
$string['embedtitle'] = 'Просмотр встраиваемого кода этого контента.';
$string['empty'] = 'Нет доступных резальтатов';
$string['enableabout'] = 'Кнопка «О сервисе H5P»';
$string['enablecopyright'] = 'Кнопка «Авторское право»';
$string['enabledlrscontenttypes'] = 'Включение зависимых типов LRS';
$string['enabledlrscontenttypes_help'] = 'Позволяет использовать типы контента, которые полагаются на хранилище учебных записей (Learning Record Store), чтобы функционировать должным образом, например, тип контента опросника.';
$string['enabledownload'] = 'Разрешить скачивание';
$string['enableembed'] = 'Кнопка вставки';
$string['enableframe'] = 'Отображать панель действий и рамку';
$string['enablehublabel'] = 'Использовать H5P Hub';
$string['enablejavascript'] = 'Пожалуйста, включите JavaScript.';
$string['enablesavecontentstate'] = 'Сохранить состояние контента';
$string['enablesavecontentstate_help'] = 'Автоматическое сохранение текущего состояния интерактивного контента для каждого пользователя. Это означает, что пользователь может продолжить там, где он остановился.';
$string['failedtodownloadh5p'] = 'Не удалось загрузить запрошенный H5P.';
$string['filenotfoundonserver'] = 'Файл не найден на сервере. Проверьте настройки загрузки файлов.';
$string['filenotimage'] = 'Файл не является изображением.';
$string['filetypenotallowed'] = 'Недопустимый тип файла.';
$string['finished'] = 'Завершено';
$string['fullscreen'] = 'Полный экран';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'Файл H5P';
$string['h5ptitle'] = 'Посетите H5P.org, чтобы узнать больше интересного контента.';
$string['hide'] = 'Скрыть';
$string['hideadvanced'] = 'Скрыть расширенный';
$string['hubcommunicationdisabled'] = 'Связь с H5P Hub отключена из-за сбоя одного или нескольких требований H5P.';
$string['hubisdisabled'] = 'Hub отключен. Вы можете снова включить его в настройках H5P.';
$string['hubisdisableduploadlibraries'] = 'H5P Hub отключен, пока эта проблема не будет устранена. Вы можете загружать библиотеки через страницу «Библиотеки H5P».';
$string['hubsettingsheader'] = 'Типы контента';
$string['hvp:addinstance'] = 'Создавать новый элемент H5P';
$string['hvp:emailconfirmsubmission'] = 'Получать подтверждающее сообщение после представления';
$string['hvp:emailnotifysubmission'] = 'Получать подтверждающее сообщение, когда попытка будет отправлена';
$string['hvp:getcachedassets'] = 'Требуется для просмотра элементов H5P';
$string['hvp:getexport'] = 'Получать экспортированный файл H5P из курса';
$string['hvp:installrecommendedh5plibraries'] = 'Устанавливать рекомендованные библиотеки H5P';
$string['hvp:restrictlibraries'] = 'Ограничивать библиотеку H5P';
$string['hvp:savecontentuserdata'] = 'Сохранять данные H5P-контента пользователя';
$string['hvp:saveresults'] = 'Сохранять результат контента H5P';
$string['hvp:updatelibraries'] = 'Обновлять версию библиотеки H5P';
$string['hvp:userestrictedlibraries'] = 'Использовать ограниченные библиотеки H5P';
$string['hvp:view'] = 'Видеть элемент H5P и взаимодействовать с ним.';
$string['hvp:viewallresults'] = 'Видеть результаты всех студентов курса';
$string['hvp:viewresults'] = 'Видеть собственные результаты пройденных материалов H5P';
$string['installdenied'] = 'У вас нет разрешения на установку типов контента. Обратитесь к администратору вашего сайта.';
$string['installedlibraries'] = 'Установленные библиотеки';
$string['intro'] = 'Введение';
$string['invalidaudioformat'] = 'Недопустимый формат аудиофайла. Используйте mp3 или wav.';
$string['invalidcontentfolder'] = 'Недопустимая папка контента';
$string['invalidcontenttype'] = 'Выбран недопустимый тип контента.';
$string['invalidfieldtype'] = 'Недопустимый тип поля.';
$string['invalidfile'] = 'Файл «{$a->%filename}» недопустим. Разрешены только файлы со следующими расширениями: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Не удалось опубликовать H5P.';
$string['invalidimageformat'] = 'Недопустимый формат файла изображения. Используйте jpg, png или gif.';
$string['invalidlanguagefile'] = 'Недопустимый языковой файл {$a->%file} в библиотеке {$a->%library}';
$string['invalidlanguagefile2'] = 'Недопустимый языковой файл {$a->%languageFile} был включён в библиотеку {$a->%name}';
$string['invalidlibrary'] = 'H5P библиотека {$a->%library}, используемая в этом контенте (содержимом) недопустима';
$string['invalidlibrarydata'] = 'Предоставлены недопустимые данные {$a->%property} в {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Предоставленны недопустимые данные {$a->%property} в {$a->%library}. Ожидаемый тип данных: Boolean.';
$string['invalidlibraryname'] = 'Недопустимое имя библиотеки: {$a->%name}';
$string['invalidlibraryoption'] = 'Недопустимый вариант {$a->%option} в {$a->%library}';
$string['invalidlibraryproperty'] = 'Невозможно прочитать свойство {$a->%property} в {$a->%library}';
$string['invalidmainjson'] = 'Допустимый основной файл h5p.json отсутствует';
$string['invalidmultiselectoption'] = 'Недопустимый выбранный параметр при множественном выборе.';
$string['invalidparameters'] = 'Недопустимые параметры';
$string['invalidselectoption'] = 'Недопустимый выбранный параметр при выборе.';
$string['invalidsemanticsjson'] = 'Недопустимый файл semantics.json был включён в библиотеку {$a->%name}';
$string['invalidsemanticstype'] = 'Внутренняя ошибка H5P: неизвестный тип содержимого "{$a->@type}" в семантике. Удаление контента (содержимого)!';
$string['invalidstring'] = 'Предоставленная строка недопустима в соответствии с regexp в семантике. (value: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Недопустимый маркер безопасности.';
$string['invalidvideoformat'] = 'Неверный формат видеофайла. Используйте mp4 или webm.';
$string['invalidxapiresult'] = 'Не обнаружено xAPI результатов по заданной комбинации контента и id пользователя';
$string['javascriptloading'] = 'Ожидание JavaScript...';
$string['language'] = 'Язык';
$string['libraries'] = 'Библиотеки H5P';
$string['librarydirectoryerror'] = 'Имя библиотеки должно соответствовать machineName или machineName-majorVersion.minorVersion (из library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Действия';
$string['librarylistinstancedependencies'] = 'Пример зависимостей';
$string['librarylistinstances'] = 'Примеры';
$string['librarylistlibrarydependencies'] = 'Зависимости библиотек';
$string['librarylistrestricted'] = 'Ограничено';
$string['librarylisttitle'] = 'Название';
$string['librarynotselected'] = 'Необходимо выбрать вид контента.';
$string['license'] = 'Лицензия';
$string['licenseCC010U'] = 'CC0 1.0 Универсальная';
$string['licenseCC10'] = '1.0 Общая';
$string['licenseCC20'] = '2.0 Общая';
$string['licenseCC25'] = '2.5 Общая';
$string['licenseCC30'] = '3.0 Непортированная';
$string['licenseCC40'] = '4.0 Всемирная';
$string['licenseGPL'] = 'Открытое лицензионное соглашение';
$string['licenseV1'] = 'Версия 1';
$string['licenseV2'] = 'Версия 2';
$string['licenseV3'] = 'Версия 3';
$string['licensee'] = 'Владелец лицензии';
$string['licenseextras'] = 'Дополнения к лицензии';
$string['licenseversion'] = 'Версия лицензии';
$string['licenseversiondescription'] = 'Выберите версию лицензии';
$string['loadingdata'] = 'Загрузка данных.';
$string['logouploadtext'] = 'Логотип организации';
$string['lookforupdates'] = 'Искать обновления H5P';
$string['maximumgrade'] = 'Максимальная оценка.';
$string['maximumgradeerror'] = 'Введите допустимое положительное целое число в качестве максимального количества баллов, доступных для этого активного элемента.';
$string['maxpostsizetoosmall'] = 'Ваш максимальный размер сообщения PHP (PHP post) достаточно мал. При текущей настройке вы не можете загружать файлы, размер которых превышает {$a->%number} Мбайт. Это может быть проблемой при попытке загрузить файлы H5P, изображения и видео. Попробуйте увеличить его до более чем 5 Мбайт';
$string['maxscore'] = 'Максимальная оценка';
$string['maxuploadsizetoosmall'] = 'Ваш максимальный размер загрузки PHP (PHP upload) достаточно мал. При текущей настройке вы не можете загружать файлы, размер которых превышает {$a->%number} Мбайт. Это может быть проблемой при попытке загрузить файлы H5P, изображения и видео. Попробуйте увеличить его до более чем 5 Мбайт';
$string['messageprovider:confirmation'] = 'Подтверждение ваших ответов H5P';
$string['messageprovider:submission'] = 'Уведомления об ответах H5P';
$string['missingcontentfolder'] = 'Допустимая папка с контентом (содержимым) отсутствует';
$string['missingcontentuserdata'] = 'Ошибка: не удалось найти содержимое данных пользователя';
$string['missingcoreversion'] = 'Системе не удалось установить компонент <em> {$a->%component} </em> из пакета, для этого требуется более новая версия плагина H5P. На этом сайте работает версия {$a->%current}, а требуемая версия {$a->%required} или выше. Вам следует рассмотреть возможность обновления, а затем повторить попытку.';
$string['missingdependency'] = 'Отсутствует зависимость {$a->@dep}, требуемая {$a->@lib}.';
$string['missinglibrary'] = 'Отсутствует требуемая библиотека {$a->@library}';
$string['missinglibraryfile'] = 'Файл "{$a->%file}" отсутствует в библиотеке: "{$a->%name}"';
$string['missinglibraryjson'] = 'Не удалось найти файл library.json допустимого json формата для библиотеки {$a->%name}';
$string['missinglibraryproperty'] = 'Необходимое свойство {$a->%property} отсутствует в {$a->%library}';
$string['missingmbstring'] = 'Расширение mbstring PHP не загружено. H5P нуждается в нём для правильной работы';
$string['missingparameters'] = 'Недостающие параметры';
$string['missinguploadpermissions'] = 'Обратите внимание: в загружаемом вами файле могут быть библиотеки, но вам не разрешено загружать новые библиотеки. Обратитесь к администратору сайта.';
$string['modulename'] = 'Интерактивный контент';
$string['modulename_help'] = 'Модуль H5P позволяет создавать интерактивный контент, такой как интерактивные видео, наборы вопросов, задания Drag and Drop, вопросы с множественным выбором ответа, презентации и многое другое.

Помимо того, что H5P является средством разработки для огромного количества различного контента, вы можете импортировать и экспортировать файлы H5P для эффективного повторного использования и совместного использования.

Пользовательский интерфейс и баллы отслеживаются с использованием xAPI и доступны через Журнал оценок Moodle.

Вы можете добавлять интерактивный контент H5P, создавая его с помощью встроенного инструмента разработки или загружая файлы H5P, найденные на других сайтах, поддерживающих H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Интерактивный контент';
$string['nextpage'] = 'Следующая страница';
$string['noanswersubmitted'] = 'Этот пользователь еще не отправил ответ в H5P';
$string['nocontent'] = 'Не удалось найти или проанализировать файл content.json';
$string['nocontenttype'] = 'Тип содержимого не указан';
$string['nocopyright'] = 'Нет информации об авторских правах на это содержимое.';
$string['nodata'] = 'Нет доступных данных, соответствующих вашим критериям.';
$string['noextension'] = 'Загруженный файл не является допустимым пакетом HTML5 (у него нет расширения .h5p)';
$string['noh5ps'] = 'Нет интерактивного контента для этого курса.';
$string['nojson'] = 'Ошибка в основном файле h5p.json';
$string['nombstringexteension'] = 'Расширение mbstring PHP не загружено. Оно необходимо для оптимальной работы H5P';
$string['noparameters'] = 'Нет параметров';
$string['noparse'] = 'Не удалось выполнить синтаксический анализ основного файла h5p.json';
$string['nopermissiontogettranslations'] = 'У Вас нет допуска на восстановление перевода';
$string['nopermissiontorestrict'] = 'У вас нет разрешения на ограничение библиотек.';
$string['nopermissiontosavecontentuserdata'] = 'У вас нет права сохранять контент данных пользователя.';
$string['nopermissiontosaveresult'] = 'У вас нет разрешения на сохранение результатов для этого контента.';
$string['nopermissiontoupgrade'] = 'У вас нет разрешения на обновление библиотек.';
$string['nopermissiontouploadcontent'] = 'У вас нет разрешения для загрузки контента.';
$string['nopermissiontouploadfiles'] = 'У вас нет разрешения загружать файлы.';
$string['nopermissiontoviewcontenttypes'] = 'У вас нет разрешения на просмотр типов контента.';
$string['nopermissiontoviewresult'] = 'У вас нет разрешения на просмотр результатов по этому контенту.';
$string['nosuchlibrary'] = 'Нет такой библиотеки';
$string['notapplicable'] = 'Недоступно';
$string['nounzip'] = 'Загруженный файл не является допустимым пакетом HTML5 (его невозможно разархивировать)';
$string['noversionattribution'] = 'С указанием авторства';
$string['noversionattributionnc'] = 'С указанием авторства - Некоммерческая';
$string['noversionattributionncnd'] = 'С указанием авторства - Некоммерческая - Без производных';
$string['noversionattributionncsa'] = 'С указанием авторства - Некоммерческая - С сохранением условий';
$string['noversionattributionnd'] = 'С указанием авторства - Без производных';
$string['noversionattributionsa'] = 'С указанием авторства - С сохранением условий';
$string['nowriteaccess'] = 'Обнаружена проблема с доступом к серверу на запись. Убедитесь, что ваш сервер может записывать информацию в вашу папку данных.';
$string['noziparchive'] = 'Ваша версия PHP не поддерживает архив Zip.';
$string['offlinedialogbody'] = 'Не удалось отправить информацию о завершении задания. Пожалуйста, проверьте соединение с интернетом.';
$string['offlinedialogheader'] = 'Соединение с сервером было потеряно';
$string['offlinedialogretrybuttonlabel'] = 'Попробуйте снова';
$string['offlinesuccessfulsubmit'] = 'Результаты были успешно отправлены.';
$string['oldphpversion'] = 'Ваша версия PHP устарела. Для нормальной работы H5P требуется версия 5.2. Рекомендуется версия 5.6 или новее.';
$string['onlyupdate'] = 'Обновить только существующие библиотеки';
$string['optionalinfo'] = 'Дополнительная информация';
$string['options'] = 'Опции';
$string['originator'] = 'Создатель';
$string['pd'] = 'Общественное достояние';
$string['pddl'] = 'Соглашение и лицензия общественного достояния';
$string['pdm'] = 'Отметка общественного достояния';
$string['phone'] = 'Телефон';
$string['pluginadministration'] = 'Управление H5P (hvp)';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Требуется почтовое сообщение для доступа к заданной конечной точке';
$string['previouspage'] = 'Предыдущая страница';
$string['privacy:metadata:hvp_events:type'] = 'Тип события.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Правильный ответ.';
$string['question'] = 'Вопрос';
$string['remove'] = 'Удалить';
$string['removeimage'] = 'Удалить изображение';
$string['removeoldlogentries'] = 'Удалить старые записи журнала H5P';
$string['removetmpfiles'] = 'Удалить старые временные файлы H5P';
$string['reportnotsupported'] = 'Не поддерживается';
$string['resizescript'] = 'Включите этот скрипт на своем веб-сайте, если вы хотите динамически изменять размер встроенного содержимого:';
$string['reveal'] = 'Показать';
$string['reviseserversetupandretry'] = 'Когда вы изменили настройки сервера, вы можете снова включить связь H5P Hub в настройках H5P.';
$string['savechanges'] = 'Сохранить изменения';
$string['score'] = 'Оценка';
$string['screenshots'] = 'Снимки экрана';
$string['screenshotsdescription'] = 'Добавить до';
$string['search'] = 'Поиск';
$string['sendusagestatistics'] = 'Разрешить статистику использования';
$string['sendusagestatistics_help'] = 'Автоматически сообщаются данные статистики использования. которые помогут разработчикам лучше понять, как используется H5P и определить потенциальные области улучшения.';
$string['settings'] = 'Настройки H5P';
$string['shortdescription'] = 'Короткое описание';
$string['showadvanced'] = 'Показать дополнительно';
$string['showless'] = 'Показать меньше';
$string['showmore'] = 'Показать больше';
$string['sitecouldnotberegistered'] = 'Сайт не может быть зарегистрирован с этого узла. Свяжитесь с администратором вашего сайта.';
$string['sitekey'] = 'Ключ сайта';
$string['sitekeydescription'] = 'Секретный ключ сайта однозначно идентифицирует этот сайт с  Hub\'ом.';
$string['sitekeyregistered'] = 'Вам был предоставлен уникальный ключ, который идентифицирует вас с Hub\'ом при получении новых обновлений. Ключ доступен для просмотра на странице «Настройки H5P».';
$string['size'] = 'Размер';
$string['source'] = 'Источник';
$string['sslnotenabled'] = 'Ваш сервер не поддерживает SSL. SSL должен быть включен для обеспечения безопасного соединения с H5P Hub.';
$string['startingover'] = 'Вы должны начать сначала.';
$string['sublevel'] = 'Подуровень';
$string['successfullyregisteredwithhub'] = 'Ваш сайт был успешно зарегистрирован в H5P Hub.';
$string['successfullyregistred'] = 'Ваш аккаунт был успешно зарегистрирован в H5P Hub';
$string['successfullyupdated'] = 'Настройки вашего аккаунта в H5P Hub были успешно изменены';
$string['thumbnail'] = 'Миниатюра';
$string['title'] = 'Заголовок';
$string['unabletocreatedir'] = 'Не удается создать каталог.';
$string['unabletogetfieldtype'] = 'Не удалось получить тип поля.';
$string['undisclosed'] = 'Защищено';
$string['updatedlibraries'] = 'Обновлено H5P библиотек: {$a->%old}.';
$string['updatedlibrary'] = 'Обновлена H5P библиотека: {$a->%old}.';
$string['updatelibraries'] = 'Обновить все библиотеки';
$string['updateregistrationonhub'] = 'Сохранить настройки аккаунта';
$string['upgrade'] = 'Обновить H5P';
$string['upgradebuttonlabel'] = 'Обновить';
$string['upgradedone'] = 'Вы успешно обновили экземпляр(ы) контента: {$a}.';
$string['upgradeerror'] = 'При обработке параметров произошла ошибка:';
$string['upgradeerrorcontent'] = 'Не удалось обновить контент %id:';
$string['upgradeerrordata'] = 'Не удалось загрузить данные библиотеки %lib.';
$string['upgradeerrormissinglibrary'] = 'Не найдена необходимая библиотека %lib.';
$string['upgradeerrorparamsbroken'] = 'Параметры повреждены.';
$string['upgradeerrorscript'] = 'Не удалось обновить скрипт для %lib.';
$string['upgradeheading'] = 'Обновлен(ы) контент(ы): {$a}';
$string['upgradeinprogress'] = 'Обновление до %ver...';
$string['upgradeinvalidtoken'] = 'Ошибка: недействительный маркер безопасности!';
$string['upgradelibrarycontent'] = 'Обновить содержимое библиотеки';
$string['upgradelibrarymissing'] = 'Ошибка: ваша библиотека отсутствует!';
$string['upgrademessage'] = 'Вы собираетесь обновить  экземпляр(ы) контента - {$a}. Выберите обновленную версию.';
$string['upgradenoavailableupgrades'] = 'Обновлений для этой библиотеки нет.';
$string['upgradenothingtodo'] = 'Нет экземпляров контента для обновления.';
$string['upgradereturn'] = 'Вернуть';
$string['upload'] = 'Загрузить';
$string['uploadlibraries'] = 'Загрузить библиотеки';
$string['uploadsizelargerthanpostsize'] = 'Ваш максимальный размер загрузки PHP больше максимального размера сообщения. Это, как известно, вызывает проблемы в некоторых установках.';
$string['user'] = 'Пользователь';
$string['validatingh5pfailed'] = 'Не удалось проверить пакет h5p.';
$string['validationfailed'] = 'Запрашиваемый H5P недействителен';
$string['viewreportlabel'] = 'Отчёт';
$string['welcomecommunity'] = 'Мы надеемся что вам понравится H5P и вы вступите в наше растущее сообщество через наши <a {$a->forums}>форумы</a>.';
$string['welcomecontactus'] = 'Если у вас есть отзывы, не стесняйтесь <a {$a}>связаться с нами</a>. Мы очень серьезно относимся к отзывам и каждый день стараемся сделать H5P лучше!';
$string['welcomegettingstarted'] = 'Чтобы начать работу с H5P и Moodle, ознакомьтесь с <a {$a->moodle_tutorial}>руководством</a> и <a {$a->example_content}>примером контента</a> на странице H5P.org для вдохновения.';
$string['welcomeheader'] = 'Добро пожаловать в мир H5P!';
$string['wrongversion'] = 'Недопустимая версия библиотеки H5P {$a->%machineName}, используемая в этом контенте. Контент содержит {$a->%contentLibrary}, а должен содержать {$a->%semanticsLibrary}.';
$string['year'] = 'Год';
$string['years'] = 'Год(ы)';
$string['yearsfrom'] = 'Годы (с)';
$string['yearsto'] = 'Годы (по)';
