<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'zh_cn', version '4.1'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['activityoverview'] = '您有到期的问卷';
$string['additionalinfo'] = '附加信息';
$string['additionalinfo_help'] = '显示在问卷第一页顶端的文本。（即，指南，背景信息，等等。）';
$string['addnewquestion'] = '添加{$a}问题';
$string['addnewsection'] = '添加新小节';
$string['addquestion'] = '添加问题...';
$string['addquestions'] = '添加问题';
$string['addquestiontosection'] = '添加问题到小节';
$string['addselqtype'] = '添加选中的问题类型';
$string['alignment'] = '对齐单选按钮';
$string['alignment_help'] = '选择按钮对齐类型：垂直对齐（默认）或水平对齐。';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = '所有';
$string['allnameddegrees_help'] = '指定要显示比率值替换数字。值留空则不使用。';
$string['alreadyfilled'] = '您已经完成我们的问卷调查，谢谢您的参与。';
$string['andaveragevalues'] = '与平均值';
$string['anonymous'] = '匿名的';
$string['answer'] = '回答';
$string['answergiven'] = '已获回答';
$string['answernotgiven'] = '未获回答';
$string['answerquestions'] = '回答这些问题...';
$string['answers'] = '回答';
$string['attempted'] = '这个问卷调查已经提交了';
$string['attemptstillinprogress'] = '进行中。保存在：';
$string['autonumbering'] = '自动编号';
$string['autonumbering_help'] = '对问题和页面自动编号。 若问卷包含条件分支，您可能要禁用自动编号。';
$string['autonumberno'] = '不显示问题的个数或页数';
$string['autonumberpages'] = '自动分配页码';
$string['autonumberpagesandquestions'] = '自动分配问题序号与页码';
$string['autonumberquestions'] = '自动分配问题序号';
$string['average'] = '平均';
$string['averageposition'] = '平均布局';
$string['averagerank'] = '平均等级';
$string['averagesrow'] = '平均值 (适用范围):';
$string['bodytext'] = '正文文本';
$string['boxesnbexact'] = '恰好{$a}个框。';
$string['boxesnbmax'] = '最多{$a}个框。';
$string['boxesnbmin'] = '最少{$a}个框。';
$string['boxesnbreq'] = '这个问题您必须回答';
$string['by'] = '由';
$string['cannotviewpublicresponses'] = '您无法查看此公开问卷的答复。';
$string['chart:type'] = '图表类型';
$string['chart:type_help'] = '选择图表类型用于此反馈';
$string['chart:vprogress'] = '垂直进程条';
$string['checkallradiobuttons'] = '请选择<strong>{$a}</strong>单选按钮';
$string['checkboxes'] = '复选框';
$string['checkboxes_help'] = '每行填入一个选项，以供用户选择其中一个或多个答案。';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = '在此处插入新分页符';
$string['checkbreaksok'] = '呈现所有的分页符！';
$string['checkbreaksremoved'] = '移除{$a}额外的分页符';
$string['closebeforeopen'] = '您指定的关闭日期早于打开日期。';
$string['closed'] = '该问卷于{$a}关闭。谢谢。';
$string['closedate'] = '问卷的结束日期';
$string['closeson'] = '问卷调查在{$a}结束';
$string['completionsubmit'] = '学生必须提交此问卷才能完成';
$string['condition'] = '条件';
$string['confalts'] = '- 或者 - <br /> 确认页面';
$string['configemailreporting'] = '同意报告发邮件';
$string['configemailreportinglong'] = '启用将部分报告直接发送到指定电子邮件的选项。';
$string['configmaxsections'] = '反馈范围的最大值';
$string['configusergraph'] = '显示图表以获取“个性测试”反馈';
$string['configusergraphlong'] = '使用<a href="http://www.rgraph.net/">Rgraph</a>库显示“个性测试”反馈图表。';
$string['confirmdelallresp'] = '您确定要删除该问卷中的所有回答么？';
$string['confirmdelchildren'] = '如果您删除此问题，其子问题也将被删除:';
$string['confirmdeletesection'] = '您确定要删除反馈部分"{$a}"吗?';
$string['confirmdelgroupresp'] = '您确定要删除{$a}中的所有回答么？';
$string['confirmdelquestion'] = '您确定要删除位置{$a}上的问题吗？';
$string['confirmdelquestionresps'] = '这同时将删除对此问题已提供的{$a} 答复。';
$string['confirmdelresp'] = '您确定要删除&nbsp;{$a}&nbsp;的回答吗？';
$string['confirmremovequestion'] = '您确定要从"{$a->sname}"部分中删除问题“  "{$a->qname}"吗？';
$string['confpage'] = '标题文本';
$string['confpage_help'] = '用户完成问卷后显示的“确认”页面中的标题（粗体）和正文。（如果存在URL，则其优先于确认文本。）如果您保持此项为空，则在完成问卷时，将会显示默认信息（谢谢您完成该问卷）。';
$string['confpagedesc'] = '用户完成问卷后显示的“确认”页面中的标题（粗体）和正文。（如果存在URL，则其显示URL的内容。）';
$string['contentoptions'] = '问卷创建方式';
$string['couldnotcreatenewsurvey'] = '不能创建新的调查';
$string['couldnotdelresp'] = '不能删除回答';
$string['createcontent'] = '定义新内容';
$string['createcontent_help'] = '从单选框中选择问卷建立方式。默认方式是“创建新的问卷”。';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = '创建新的问卷';
$string['crontask'] = '问卷清理工作';
$string['date'] = '日期';
$string['date_help'] = '如果您想要回答是正确格式的日期，请使用这种问题类型';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = '使用天/月/年格式，比如1945年3月14日；<strong>14/3/1945</strong>';
$string['deleteallresponses'] = '删除所有回答';
$string['deletecurrentquestion'] = '删除问题{$a}';
$string['deletedallgroupresp'] = '删除在组{a}中的回答';
$string['deletedallresp'] = '问卷答复已删除';
$string['deletedisabled'] = '此项目无法删除';
$string['deletedresp'] = '删除回答';
$string['deleteresp'] = '删除这个回答';
$string['deletesection'] = '删除这个小节';
$string['deletingresp'] = '正在删除回答';
$string['dependencies'] = '附属';
$string['dependquestion'] = '上级问题';
$string['dependquestion_help'] = '您可以选择一个父问题以及该问题的选择选项。
如果先前已选择了其父问题和其选项，则子问题只会显示向学生发送。';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = '没有回答问题';
$string['directwarnings'] = '问题的直接关联将被删除。将影响：';
$string['displaymethod'] = '显示问题中没有定义的方法';
$string['download'] = '下载';
$string['downloadpdf'] = '下载 PDF';
$string['downloadtextformat'] = '下载';
$string['downloadtextformat_help'] = '此功能使您可以将问卷的所有答复保存为可选的受支持的文件格式。
 您可以选择在导出中包括其他数据项，也可以选择自动将文件发送给指定的用户。';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = '报告类型';
$string['dropdown'] = '下拉框';
$string['dropdown_help'] = '与使用单选按钮相比，使用下拉框没有真正的优势
 除了可能需要冗长的选项列表之外，以节省屏幕空间。';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = '编辑';
$string['editingfeedback'] = '编辑反馈设置';
$string['editingquestionnaire'] = '编辑问卷设置';
$string['editquestion'] = '正在编辑{$a}类型问题';
$string['email'] = '电子邮件';
$string['emailextra'] = '将下载发送到邮箱';
$string['emailextra_help'] = '将下载文件发送到列出的电子邮件地址，以逗号分隔。请注意，不会进行安全性或隐私检查。
 必须在模块设置中启用“ allowemailreporting”才能访问此功能。';
$string['emailroles'] = '发送下载到角色。';
$string['emailroles_help'] = '将通过电子邮件将下载文件发送给具有“mod/questionnaire：submissionnotification”功能的所有角色。
 必须在模块设置中启用“allowemailreporting”才能访问此功能。';
$string['emailsend'] = '发送报告';
$string['emailsnotspecified'] = '未指定电子邮件。';
$string['emailssent'] = '下载已发送到指定的电子邮件。';
$string['errnewname'] = '抱歉，该名称已被占用。请选择一个新名。';
$string['erroropening'] = '打开问卷时发生错误。';
$string['errortable'] = '系统表错误';
$string['essaybox'] = '多行文本框';
$string['essaybox_help'] = '该问题将显示一个纯文本框，其中包含 x 个文本列（或区域宽度）和 y 个文本行（文本行数）。

如果将x和y都保留为默认0值（或将其设置为0），则 moodle的HTML编辑器将显示标准高和宽（如果在课程/用户上下文和用户资料中可用）。';
$string['event_all_responses_deleted'] = '删除所有回复';
$string['event_all_responses_saved_as_text'] = '所有回复均保存为文本';
$string['event_all_responses_viewed'] = '查看所有回复报告';
$string['event_individual_responses_viewed'] = '个人回复报告已查看';
$string['event_non_respondents_viewed'] = '无回复已查看';
$string['event_previewed'] = '问卷预览';
$string['event_question_created'] = '创建问题';
$string['event_question_deleted'] = '删除问题';
$string['event_response_deleted'] = '个人回复已删除';
$string['event_resumed'] = '尝试恢复';
$string['event_saved'] = '回复已保存';
$string['event_submitted'] = '回复已提交';
$string['feedback'] = '反馈';
$string['feedback_help'] = '反馈帮助';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = '添加 {no} 更多反馈区';
$string['feedbackbysection'] = '反馈小节';
$string['feedbackdefaultlabel'] = '[New section]';
$string['feedbackeditingglobal'] = '编辑问卷全局反馈';
$string['feedbackeditingmessages'] = '编辑问卷反馈信息';
$string['feedbackeditingsections'] = '编辑问卷反馈小节';
$string['feedbackeditmessages'] = '保存版块设置并编辑反馈消息';
$string['feedbackeditsections'] = '保存设置并编辑反馈部分';
$string['feedbackerrorboundaryformat'] = '反馈分数范围必须为百分比或数字。无法识别您在范围 {$a} 中输入的值。';
$string['feedbackerrorboundaryoutofrange'] = '反馈分数范围必须在 0％和 100％之间。您在边界 {$a} 中输入的值超出范围。';
$string['feedbackerrorjunkinboundary'] = '您必须填写反馈分数范围区，不能有任何空白。';
$string['feedbackerrorjunkinfeedback'] = '您必须填写反馈区，不要有任何空白。';
$string['feedbackerrororder'] = '反馈分数范围必须是有序的，最高开始。您在范围 {$a} 中输入的值不正确。';
$string['feedbackglobal'] = '全局反馈';
$string['feedbackglobalheading'] = '全局反馈标题';
$string['feedbackglobalmessages'] = '全局反馈消息';
$string['feedbackhdr'] = '反馈';
$string['feedbackheading'] = '反馈标题';
$string['feedbackheading_help'] = '在反馈标题字段中，可使用2个变量：$scorepercent 和 $oppositescorepercent。';
$string['feedbackmessages'] = '{$a} 小节信息';
$string['feedbacknextsection'] = '下一节 {$a}';
$string['feedbacknone'] = '无反馈消息';
$string['feedbacknotes'] = '反馈备注';
$string['feedbacknotes_help'] = '在此处输入的文字将在反馈报告的末尾显示给受访者';
$string['feedbackoptions'] = '反馈选项';
$string['feedbackoptions_help'] = '如果您的调查问卷包含以下问题类型和问题设置，则反馈选项可用：
单选按钮；下拉框；是/否；或费率（正常或Osgood标度）。这些问题必须设置为“必填”，其“问题名称”字段不能为空，“可能的答案” 选项必须包含一个值。';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = '此问题属于反馈小节 [{$a}]';
$string['feedbackremovesection'] = '删除此问题将完全删除反馈小节 [{$a}]';
$string['feedbackreport'] = '反馈报告';
$string['feedbackscore'] = '反馈成绩单';
$string['feedbackscoreboundary'] = '反馈分数范围';
$string['feedbackscores'] = '显示成绩';
$string['feedbackscores_help'] = '显示反馈分数表';
$string['feedbacksection'] = '小节';
$string['feedbacksectionheading'] = '{$a} 小节标题';
$string['feedbacksectionheadingmissing'] = '您必须为此“反馈”部分输入标题！';
$string['feedbacksectionheadingtext'] = '标题';
$string['feedbacksectionlabel'] = '标签';
$string['feedbacksectionlabel_help'] = '此标签将在图表/图表中使用。请保持尽可能短！';
$string['feedbacksectionquestions'] = '{$a} 小节问题';
$string['feedbacksections'] = '反馈小节';
$string['feedbacksectionsselect'] = '小节';
$string['feedbacksectionsselect_help'] = '把你的问题放入小节';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = '保存反馈设置';
$string['feedbacktype'] = '反馈类型';
$string['field'] = '问题{$a}';
$string['fieldlength'] = '输入框的长度';
$string['fieldlength_help'] = '对于**文本框**问题类型，应设置**输入框长度**和**最大文本长度**。

默认的输入框长度为20个字符，最大输入长度为25个字符。';
$string['finished'] = '你已回答了此问卷中的所有问题！';
$string['firstrespondent'] = '首先受访';
$string['formateditor'] = 'HTML 编辑器';
$string['formatplain'] = '纯文本';
$string['grade'] = '提交问卷后的评分';
$string['gradesdeleted'] = '问卷调查成绩已删除';
$string['headingtext'] = '标题文本';
$string['horizontal'] = '水平对齐';
$string['id'] = 'ID号';
$string['includechoicecodes'] = '包含选项的代码';
$string['includechoicetext'] = '包含选项的内容';
$string['includeincomplete'] = '包含未完成的答复';
$string['includerankaverages'] = '包含未完成的答复';
$string['incorrectcourseid'] = '课程ID号错误';
$string['incorrectmodule'] = '课程模块的ID号错误';
$string['incorrectquestionnaire'] = '调查问题错误';
$string['invalidresponse'] = '无效的回答';
$string['invalidresponserecord'] = '无效的回答记录';
$string['invalidsurveyid'] = '无效的问卷ID号';
$string['kindofratescale'] = '评分量表的类型。';
$string['kindofratescale_help'] = '请查看Moodle在线文档帮助';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['length'] = '长度';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['maxdigitsallowed'] = '最大允许的数字位数';
$string['maxdigitsallowed_help'] = '使用最大数字长度和小数点位数参数，您可以设置数字的位数和小数的位数。';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = '强制回答的最大数量';
$string['maxtextlength'] = '文本的最大长度';
$string['minforcedresponses'] = '强制回答的最小数量';
$string['minforcedresponses_help'] = '使用这些参数，强制填写人必须选择**最少**和**最多**的选项。如果想强制选择固定数量的选项，将**最少**和**最多**参数设置为同样的值。如果只需要最小或者最大值，那就把另一个值空着（默认值**0**）。如果您设置了这些参数（而非默认值**0**），填写人没有按要求填写时，会出现警告。您需要把这些要求通过问卷调查的描述或者问题的文本中向填写者说明。';
$string['misconfigured'] = '课程配置错误';
$string['missingquestion'] = '您还有未回答的问题';
$string['missingquestions'] = '您还有未回答的问题：';
$string['modulename'] = '问卷调查';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = '问卷调查';
$string['myresponses'] = '所有您填写的问卷';
$string['myresponsetitle'] = '我的 {$a} 个回答';
$string['myresults'] = '我的结果';
$string['name'] = '名称';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['next'] = '继续';
$string['nextpage'] = '下一页';
$string['noanswer'] = '无回答';
$string['nodata'] = '无数据发布';
$string['noduplicates'] = '无重复选项';
$string['noneinuse'] = '当前暂无问卷内容';
$string['nopublicsurveys'] = '暂无公用调查问卷模板';
$string['noresponsedata'] = '该问题暂没有回答';
$string['noresponses'] = '无回答';
$string['normal'] = '标准的';
$string['notanumber'] = '<strong>{$a}</strong>的数字不正确';
$string['notapplicable'] = '不适合';
$string['notapplicablecolumn'] = '带“不适合”选项列';
$string['notavail'] = '此问卷暂时不能使用，请稍后再试。';
$string['noteligible'] = '您不能参加这个问卷调查';
$string['notemplatesurveys'] = '暂无调查问卷模版';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notopen'] = '该问卷调查到{$a}才开放。';
$string['num'] = '编号';
$string['numberfloat'] = '您所输入的数字<strong>{$a->precision}</strong>进行了格式重排或舍入。';
$string['numberofdecimaldigits'] = '小数的位数<strong>{$a->number}</strong>已使用';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = '评分量表的点数';
$string['numberscaleitems_help'] = '评分量表的点数。通常是3到5个点，默认为：**5**。';
$string['numeric'] = '数值型';
$string['numeric_help'] = '如果您希望问卷填写的是一个标准格式的数字，请使用这种问题类型。';
$string['of'] = '的';
$string['opendate'] = '问卷的开始日期';
$string['option'] = '选项{$a}';
$string['optionalname'] = '问题名称';
$string['optionalname_help'] = '问题名称仅用于将回答导出为CSV/Excel格式时。如果您不需要导出到CSV，您根本不用考虑问题名称。如果您计划经常将问卷的结果导出为CSV格式，对于问题的命名您有两个选择。';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '-或-';
$string['order_ascending'] = '递增顺序';
$string['order_default'] = '按默认顺序查看';
$string['order_descending'] = '递减顺序';
$string['orderresponses'] = '对回答排序';
$string['orderresponses_help'] = '对于以下四种问题类型，您可以在显示所有回答时，按回答的数量(平均值)对选项进行排序。

*单选按钮
*单选下拉列表
*多项选项（复选框）
*量表问题（包括李克特量表）。

在“所有回答”页面，默认的排序是问卷设计者问题选项的顺序。您也可以选择按递增或者递减的顺序显示。';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = '奥斯古德语义差异法';
$string['other'] = '其他:';
$string['otherempty'] = '如果您选择该选项，必须在文本框中输入些文字！';
$string['overviewnumresplog'] = '回答';
$string['overviewnumresplog1'] = '回答';
$string['overviewnumrespvw'] = '回答';
$string['overviewnumrespvw1'] = '回答';
$string['owner'] = '所有者';
$string['page'] = '页';
$string['pageof'] = '{$a->totpages}
的{$a->page}页';
$string['pluginadministration'] = '调查问卷管理';
$string['pluginname'] = '调查问卷';
$string['possibleanswers'] = '问题的选项';
$string['posteddata'] = '向往有提交数据的页';
$string['preview_label'] = '预览';
$string['preview_questionnaire'] = '- 问卷预览';
$string['previewing'] = '正在预览问卷';
$string['previous'] = '上一步';
$string['previouspage'] = '上一页';
$string['print'] = '打印';
$string['printblank'] = '打印空白';
$string['printblanktooltip'] = '在适于打印的窗口打开空白问卷';
$string['printtooltip'] = '在适于打印的窗口打开当前问卷';
$string['private'] = '私有';
$string['public'] = '公用';
$string['qtype'] = '填写次数限制';
$string['qtype_help'] = '设置用户可填写问卷的次数：一次，每天一次，每周一次，每月一分或者无次数限制（多次）。';
$string['qtypedaily'] = '只能每天填一次';
$string['qtypemonthly'] = '只能每月填一次';
$string['qtypeonce'] = '只能填写一次';
$string['qtypeunlimited'] = '可多次填写';
$string['qtypeweekly'] = '只能每周填一次';
$string['questionnaire:copysurveys'] = '复制模版和私有类问卷';
$string['questionnaire:createpublic'] = '创建公用问卷';
$string['questionnaire:createtemplates'] = '创建模版类问卷';
$string['questionnaire:deleteresponses'] = '删除所有回答';
$string['questionnaire:downloadresponses'] = '导出回答为CSV文件';
$string['questionnaire:editquestions'] = '创建并编辑问题';
$string['questionnaire:manage'] = '创建并编辑问卷';
$string['questionnaire:printblank'] = '打印空白问卷';
$string['questionnaire:readallresponseanytime'] = '随时查看所有的回答';
$string['questionnaire:readallresponses'] = '查看回答小结，包括打开次数';
$string['questionnaire:readownresponses'] = '查看自己的回答';
$string['questionnaire:submit'] = '完成并提交问卷';
$string['questionnaire:view'] = '查看一个调查问卷';
$string['questionnaire:viewsingleresponse'] = '查看单个完成的问卷';
$string['questionnaireadministration'] = '调查问卷管理';
$string['questionnairecloses'] = '关闭调查问卷';
$string['questionnaireopens'] = '开放调查问卷';
$string['questionnairereport'] = '调查问卷报告';
$string['questionnum'] = '问题编号';
$string['questions'] = '问题';
$string['questionsinsection'] = '此板块中的问题:';
$string['questiontypes'] = '问题的类型';
$string['questiontypes_help'] = '请查看Moodle在线文档帮助';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = '单选按钮';
$string['radiobuttons_help'] = '在这种问题类型中，填写人必须从提供的选项中选项一项。';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = '等级';
$string['ratescale'] = '评分量表(1..5)';
$string['ratescale_help'] = '请查看Moodle在线文档帮助';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = '调查问卷类型';
$string['realm_help'] = '* **调查问卷一共有三种类：**
 * 私有 - 只属于问卷所在的课程。
 * 模版 - 可被复制和编辑。
 * 公共 - 可在课程间共享。';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = '提交问卷之后重定向页面的URL地址。';
$string['remove'] = '删除';
$string['required'] = '是否必须回答';
$string['required_help'] = '如果您选择***是***，填写人必须回答这个问题才能提交问卷。';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = '缺少一个必要的参数。';
$string['reset'] = '重置';
$string['respeligiblerepl'] = '已通过角色重载代替';
$string['respondent'] = '填写人';
$string['respondenteligibleall'] = '所有的';
$string['respondenteligiblestudents'] = '仅由学生';
$string['respondenteligibleteachers'] = '仅由教师';
$string['respondents'] = '填写人';
$string['respondenttype'] = '调查问卷类型';
$string['respondenttype_help'] = '设置为“全名”将显示填写调查的用户全名。设置为“匿名”可隐藏用户的标识。';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = '匿名';
$string['respondenttypefullname'] = '全名';
$string['response'] = '回答';
$string['responsefieldlines'] = '输入框大小';
$string['responseformat'] = '问卷格式';
$string['responseoptions'] = '问卷选项';
$string['responses'] = '回答';
$string['responseview'] = '学生（角色）查看问卷结果';
$string['responseview_help'] = '您可以设置谁可以查看问卷提交的所有回答（通常是统计表格）。';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = '总是可以';
$string['responseviewstudentsnever'] = '从不可以';
$string['responseviewstudentswhenanswered'] = '填写完问卷后可查看';
$string['responseviewstudentswhenclosed'] = '在问卷调查结束之后';
$string['restrictedtoteacher'] = '这些功能只能由教师权限进行编辑';
$string['resume'] = '保存/恢复问卷填写';
$string['resume_help'] = '是否允许用户在提交问卷之前保存他们的回答。这样用户可以填写部分问卷，以后再从保存处恢复填写。';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = '恢复调查问卷';
$string['return'] = '返回';
$string['save'] = '保存';
$string['saveasnew'] = '保存为新问题';
$string['savedprogress'] = '您回答的调查问卷已保存，您可随时回来继续填写问卷。点击下面{$a}的链接。您可能需要输入用户名和密码以便继续完成问卷。';
$string['saveeditedquestion'] = '保存问题{$a}';
$string['savesettings'] = '保存设置';
$string['section'] = '说明';
$string['sectionbreak'] = '----- 分页符-----';
$string['sectionbreak_help'] = '----- 分页符-----';
$string['sectiontext'] = '标签';
$string['sectiontext_help'] = '这一段介绍系列问题的文字';
$string['selecttheme'] = '为此调查问卷选择一种主题(css)。';
$string['sendemail'] = '发送电子邮件';
$string['sendemail_help'] = '每次问卷提交发送一份结果到指定的邮箱。您可以设置多个邮箱接收，邮箱地址之间用逗号隔开。不填则表示不发送邮件。';
$string['settings'] = '设置';
$string['settingssaved'] = '设置已保存';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['submitoptions'] = '提交问卷的选项';
$string['submitsurvey'] = '提交问卷';
$string['submitted'] = '提交于：';
$string['subtitle'] = '副标题';
$string['subtitle_help'] = '问卷的副标题。仅在问卷第一页的标题下面显示。';
$string['summary'] = '小结';
$string['surveynotexists'] = '问卷不存在';
$string['surveyowner'] = '您必须是问卷的创建者才能进行该项操作';
$string['surveyresponse'] = '调查问卷的回答';
$string['template'] = '模版';
$string['templatenotviewable'] = '问卷的模版不可查看';
$string['text'] = '问题的内容';
$string['textareacolumns'] = '文本区的宽度';
$string['textareacolumns_help'] = '这种问题类型将显示一个**x列** **y行**的纯文本框。如果x,y的值为0(默认值)，Moodle的HTML编辑器会按标准的高度和宽度来显示。（标准的高度和宽度在 课程/用户的内容和用户设置中）';
$string['textarearows'] = '文本框的高度';
$string['textbox'] = '文本框';
$string['textbox_help'] = '对于文本框问题类型，应设置输入框长度和最大文本长度。默认的输入框长度为20个字符，最大输入长度为25个字符。';
$string['textdownloadoptions'] = '文本下载(CSV)的选项';
$string['thank_head'] = '感谢您完成本问卷';
$string['theme'] = '主题';
$string['thismonth'] = '本月';
$string['thisweek'] = '本周';
$string['thousands'] = '勿使用千位分隔符';
$string['title'] = '标题';
$string['title_help'] = '问卷的标题，会出现在每页的顶部。默认的标题就是问卷的名称，也可修改为您想要的标题。';
$string['today'] = '今天';
$string['total'] = '小计';
$string['type'] = '问题类型';
$string['undefinedquestiontype'] = '未定义的问题类型！';
$string['unknown'] = '未知';
$string['unknownaction'] = '未知的问卷动作...';
$string['url'] = '提交确认页面的 URL';
$string['url_help'] = '提交问卷之后重定向页面的URL地址';
$string['useprivate'] = '复制已有的';
$string['usepublic'] = '使用公用问卷';
$string['usetemplate'] = '复制已有的问卷';
$string['vertical'] = '垂直对齐';
$string['view'] = '查看';
$string['viewallresponses'] = '查看所有的回答';
$string['viewallresponses_help'] = '如果问卷调查被设置为 **小组模式**: *公开小组*，或*独立小组* 并且当前用户有访问所有组的权限，在当前课程中定义了组，那么用户可以访问下拉框中的组。这个下拉框可以让用户使用“过滤器”对问卷回答按小组进行分类。如果设置为 **小组模式**: *独立小组*，那么没有访问所有组权限的用户(如学生，无权限教师等)只能查看他们所属小组的回答。';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = '答复的列表';
$string['viewindividualresponse'] = '个别答复';
$string['viewresponses'] = '所有回答({$a})';
$string['viewyourresponses'] = '您填写的问卷-查看{$a}';
$string['warning'] = '警告，遇到了错误。';
$string['wrongdateformat'] = '输入的日期：<strong>{$a}</strong> 与示例中的格式不符。';
$string['wrongdaterange'] = '错误! 年份必须设置在1902-2037之间';
$string['wrongformat'] = '问题存在错误:&nbsp;';
$string['wrongformats'] = '问题存在错误:&nbsp;';
$string['yesno'] = '是/否';
$string['yesno_help'] = '简单的是否问题';
$string['yourresponse'] = '您的答复';
$string['yourresponses'] = '您的答复';
