<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'zh_cn', version '4.1'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = '以上';
$string['activitynavigationposition'] = '活动导航位置';
$string['activitynavigationpositiondesc'] = '选择活动导航位于 "上方" 或 "下方"。 "上方" 指活动的上方, "下方" 则是在下面。如果您希望使用自定义 css, 请使用选择器 "#activitynavigation"。';
$string['advert_alttext'] = '主题设计级别1横幅广告';
$string['advert_heading'] = '主题设计级别1';
$string['advert_tagline'] = '想知道如何定制主题，但没有开发背景、没有php经验也没有Moodle主题设计经验的话，‘MoodleBites 主题设计级别1\'就是为你打造的！它教你简单的Moodle主题开发，假如你还想进一步深入它也帮你打好基础。更多信息请点击此处。';
$string['aftercontent'] = '在内容之后';
$string['alert1'] = '警告一';
$string['alert2'] = '警告二';
$string['alert3'] = '警告三';
$string['alert_edit'] = '编辑警告信息';
$string['alert_general'] = '通知';
$string['alert_info'] = '信息';
$string['alert_warning'] = '警告';
$string['alertinfodesc'] = '输入警告信息设置。';
$string['alertsdesc'] = '在产品的页面上用三种不同的风格显示一个或多个警告。请注意在不需要的时候禁用它们。';
$string['alertsheading'] = '用户警告';
$string['alertsheadingsub'] = '在首页上显示重要的信息';
$string['alerttext'] = '警告文本';
$string['alerttextdesc'] = '这些是你想在警告中显示的文本';
$string['alerttitle'] = '标题';
$string['alerttitledesc'] = '警告的主要标题/抬头';
$string['alerttype'] = '级别';
$string['alerttypedesc'] = '设置一个最合适的警告级别';
$string['allclasses'] = '所有班级';
$string['allcourses'] = '所有课程';
$string['allmodules'] = '所有模块';
$string['allunits'] = '所有单元';
$string['alternativecolors'] = '替换颜色{$a}';
$string['alternativethemecolor'] = '替换主题颜色 {$a}';
$string['alternativethemecolordesc'] = '你的主题使用什么样的替换主题颜色 {$a}。';
$string['alternativethemecolorname'] = '替换颜色集合的名称 {$a}';
$string['alternativethemecolornamedesc'] = '此套备选主题颜色的可识别名称';
$string['alternativethemecolors'] = '替换主题颜色';
$string['alternativethemecolorsdesc'] = '定义用户可选择的备选主题颜色。';
$string['alternativethemedefaultbuttonbackgroundcolour'] = '默认按钮背景颜色 {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = '设置所有默认按钮的背景颜色 {$a}。';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = '默认按钮鼠标悬停背景颜色 {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = '为所有默认按钮设置鼠标悬停背景颜色 {$a}。';
$string['alternativethemedefaultbuttontextcolour'] = '默认按钮文字颜色 {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = '设置所有默认按钮文字颜色 {$a}。';
$string['alternativethemedefaultbuttontexthovercolour'] = '默认按钮鼠标悬停文字颜色 {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = '设置所有默认按钮鼠标悬停颜色 {$a}。';
$string['alternativethemefooterblockbackgroundcolour'] = '备选主题颜色的页脚区块背景颜色 {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = '设置备选主题颜色的页脚内区块背景颜色{$a}。';
$string['alternativethemefooterblockhovercolour'] = '备选主题颜色的页脚区链接鼠标悬念颜色 {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = '设置备选主题颜色中当鼠标悬停在页脚区文本链接时的文本颜色 {$a}。';
$string['alternativethemefooterblocktextcolour'] = '备选主题颜色中的页脚区文字颜色 {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = '设置备选主题颜色页脚文本块颜色 {$a}。';
$string['alternativethemefooterblockurlcolour'] = '备选主题颜色的页脚区域链接颜色 {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = '设置备选主题颜色页脚中的文本块链接颜色 {$a}。';
$string['alternativethemefootercolor'] = '备选主题颜色的页脚背景颜色 {$a}';
$string['alternativethemefootercolordesc'] = '设置备选主题颜色的页脚框颜色 {$a}。';
$string['alternativethemefooterheadingcolor'] = '备选主题颜色的页脚标题颜色 {$a}';
$string['alternativethemefooterheadingcolordesc'] = '设置备选主题颜色的页脚标题颜色{$a}。';
$string['alternativethemefooterhovercolor'] = '备选主题颜色的页脚链接鼠标悬停颜色 {$a}';
$string['alternativethemefooterhovercolordesc'] = '设置备选主题颜色中鼠标悬停在页脚文本链接时的文本颜色 {$a}。';
$string['alternativethemefootersepcolor'] = '备选主题颜色的页脚分隔线颜色 {$a}';
$string['alternativethemefootersepcolordesc'] = '分隔线是用于分隔内容的线条。在些设置备选主题颜色中分隔线的颜色 {$a}。';
$string['alternativethemefootertextcolor'] = '备选主题颜色中的页脚文字颜色 {$a}';
$string['alternativethemefootertextcolordesc'] = '设置备选主题颜色页脚文本颜色 {$a}。';
$string['alternativethemefooterurlcolor'] = '备选主题颜色的页脚链接鼠标悬停颜色 {$a}';
$string['alternativethemefooterurlcolordesc'] = '设置备选主题颜色页脚中的文本链接颜色 {$a}。';
$string['alternativethemehovercolor'] = '替换主题鼠标悬停颜色  {$a}';
$string['alternativethemehovercolordesc'] = '备选主题颜色的鼠标悬停颜色{$a}。';
$string['alternativethemeiconcolor'] = '备选图标颜色 {$a}';
$string['alternativethemeiconcolordesc'] = '为所有图标设置备选颜色{$a}。';
$string['alternativethememycoursesorderenrolbackcolour'] = '设置已选课未访问课程的备选背景颜色 {$a}';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = '设置已选但未访问课程的备选背景颜色{$a}。也是"我的课程顺序"中"最后访问..."设置。';
$string['alternativethemename'] = '颜色配置名称';
$string['alternativethemenamedesc'] = '提供一个名字给替换主题颜色';
$string['alternativethemenavcolor'] = '导航文本颜色 {$a}';
$string['alternativethemenavcolordesc'] = '设置导航文本的备选颜色 {$a}。即导航栏及线索风格。';
$string['alternativethemequizsubmitbackgroundcolour'] = '测验的 "全部提交并结束"按钮背景颜色 {$a}';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = '设置测验的"全部提交并结束"按钮的备选背景颜色{$a} 。';
$string['alternativethemequizsubmitbackgroundhovercolour'] = '测验的 "全部提交并结束"按钮鼠标悬停背景颜色 {$a}';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = '设置测验的"全部提交并结束"按钮的备选鼠标悬停背景颜色{$a} 。';
$string['alternativethemequizsubmittextcolour'] = '测验"全部提交并结束" 文字颜色 {$a}';
$string['alternativethemequizsubmittextcolourdesc'] = '设置测验的"全部提交并结束"按钮的备选文字 颜色{$a} 。';
$string['alternativethemequizsubmittexthovercolour'] = '测验 "全部提交并结束" 鼠标悬停文字颜色 {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = '设置测验的"全部提交并结束"按钮的备选鼠标悬停文字颜色{$a} 。';
$string['alternativethemesidepreblockbackgroundcolour'] = '备选{$a} "侧边预览" 区块背景颜色';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = '设置"侧边预览"区块的备选{$a}背景颜色';
$string['alternativethemesidepreblockhovercolour'] = '"侧边预览"区块链接鼠标悬停备选{$a}颜色';
$string['alternativethemesidepreblockhovercolourdesc'] = '设备"侧边预览"区块链接鼠标悬停其上时的备选{$a}颜色。';
$string['alternativethemesidepreblocktextcolour'] = '"侧边预览"区块文字备选{$a}颜色';
$string['alternativethemesidepreblocktextcolourdesc'] = '设置"侧边预览"区块的备选{$a}文字颜色。';
$string['alternativethemesidepreblockurlcolour'] = '"侧边预览"区块链接备选{$a}颜色';
$string['alternativethemesidepreblockurlcolourdesc'] = '设备"侧边预览"区块链接的备选{$a} 颜色。';
$string['alternativethemeslidebuttoncolor'] = '备选主题滑块颜色{$a}';
$string['alternativethemeslidebuttoncolordesc'] = '在备选主题中，滑块的颜色{$a}。';
$string['alternativethemeslidebuttonhovercolor'] = '备选主题滑块的鼠标悬停颜色{$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = '在备选主题中，当鼠标悬停其上时滑块的颜色{$a}。';
$string['alternativethemeslidecaptionbackgroundcolor'] = '备选主题滑块背景颜色{$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = '备选主题颜色的主题滑动标题背景色{$a}。不会应用于‘侧边\'滑动标题选项。';
$string['alternativethemeslidecaptiontextcolor'] = '备选主题滑动标题文本颜色 {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = '备选主题颜色的主题滑动标题背景色{$a}。不会应用于‘侧边\'滑动标题选项。';
$string['alternativethemeslidecolors'] = '备选主题滑动颜色';
$string['alternativethemeslidecolorsdesc'] = '定义用户可选择的备选主题滑动颜色。';
$string['alternativethemestripebackgroundcolour'] = '备选条带背景颜色{$a}';
$string['alternativethemestripebackgroundcolourdesc'] = '设置表格中的条带背景备选颜色{$a}';
$string['alternativethemestripetextcolour'] = '备选条带文字颜色{$a}';
$string['alternativethemestripetextcolourdesc'] = '设置表格中的条带文字备选颜色{$a}。';
$string['alternativethemestripeurlcolour'] = '备选条带URL颜色{$a}';
$string['alternativethemestripeurlcolourdesc'] = '设置表格中的条带备选颜色{$a}';
$string['alternativethemetextcolor'] = '替换文本颜色 {$a}';
$string['alternativethemetextcolordesc'] = '设置备选文字颜色{$a}。';
$string['alternativethemeurlcolor'] = '链接的备选颜色{$a}';
$string['alternativethemeurlcolordesc'] = '设置链接文字的备选颜色{$a}。';
$string['alwaysdisplay'] = '总是显示';
$string['android'] = '安卓（ Google Play）';
$string['androiddesc'] = '提供你自己移动应用在Google Play商店的URL。如果您没有自己的移动应用，可以考虑使用Moodle官方的移动应用。 (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['androidurl'] = '安卓(Google Play)URL';
$string['asconfigintlower'] = '{$a->value}超过最小值{$a->lower}限制';
$string['asconfigintnan'] = '{$a->value} 不是数值';
$string['asconfigintupper'] = '{$a->value}超过最大值{$a->upper}限制';
$string['backtotop'] = '回到顶部';
$string['badgepreferences'] = '勋章';
$string['badgesmi'] = '勋章';
$string['badgesmidesc'] = '如果用户拥有\'moodle/badges:manageownbadges\' 权限，则显示勋章菜单。启用勋章的作用范围为全站。';
$string['beforecontent'] = '内容之前';
$string['below'] = '下方';
$string['breadcrumbsimple'] = '简单';
$string['breadcrumbstyle'] = 'Breadcrumb 风格';
$string['breadcrumbstyled'] = '花哨';
$string['breadcrumbstyledesc'] = '你可以修改 breadcrumbs 风格。';
$string['breadcrumbstylednocollapse'] = '精致并不可收起';
$string['breadcrumbthin'] = '窄的';
$string['cachesused'] = '缓存用过的';
$string['calendarmi'] = '日历';
$string['calendarmidesc'] = '如果用户拥有\'moodle/calendar:manageownentries\'权限，则显示日历菜单项。';
$string['categoryctidesc'] = '如果启用，可以为每个分类设置不同图片。';
$string['categoryctiheading'] = '分类课程标题图片';
$string['categoryctiheadingcategory'] = '{$a->category}的分类课程标题图片';
$string['categoryctiheadingcs'] = '分类课程标题图片配置';
$string['categoryctiheadingsub'] = '使用图片展示课程分类';
$string['categoryctiheight'] = '分类 \'{$a->category}\' 课程标题图片高度';
$string['categoryctiheightdesc'] = '分类 \'{$a->category}\' 中课程标题图片高度像素数应在{$a->lower} 及{$a->upper} 之间。请不要在后面加上 \'px\'后缀，只输入数字即可。';
$string['categoryctiinfo'] = '{$a->category} 设置';
$string['categoryctiinfodesc'] = '分类课程标题图像设置:{$a->category}。';
$string['categoryctimage'] = '分类\'{$a->category}\' 课程的标题图像文件';
$string['categoryctimagedesc'] = '分类 \'{$a->category}\'中课程的标题图片。';
$string['categoryctimageurl'] = '分类 \'{$a->category}\'中课程标题图片URL';
$string['categoryctimageurldesc'] = '分类\'{$a->category}\'中课程标题图片的URL。如果文件有文件上传将会覆盖此文件。';
$string['categoryctitextbackgroundcolour'] = '分类\'{$a->category}\' 中课程标题背景颜色';
$string['categoryctitextbackgroundcolourdesc'] = '分类\'{$a->category}\'中课程标题文字背景颜色。';
$string['categoryctitextbackgroundopacity'] = '分类\'{$a->category}\'中课程标题文字背景透明度';
$string['categoryctitextbackgroundopacitydesc'] = '分类\'{$a->category}\'中课程标题文字背景透明度。';
$string['categoryctitextcolour'] = '分类\'{$a->category}\' 中课程标题文字颜色';
$string['categoryctitextcolourdesc'] = '分类\'{$a->category}\'中课程标题文字颜色。';
$string['categoryiconcategory'] = '分类的图标：{$a->category}.';
$string['categoryicondesc'] = '如果打开这个允许你设置每个课程的类别';
$string['categoryiconheading'] = '类别图标';
$string['categoryiconheadingsub'] = '使用图标代表你的类别';
$string['categoryiconinfo'] = '设置自定义类别图标';
$string['categoryiconinfodesc'] = '输入您要使用的图标名称或上传一张图片。列表在<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">这里</a>. 仅需输入"fa-"后面的内容。';
$string['categoryimagecategory'] = '分类图片:{$a->category}。';
$string['categoryincoursebreadcrumbfeature'] = '课程线索中的分类';
$string['categoryincoursebreadcrumbfeaturedesc'] = '在课程线索中显示分类链接。';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential主题</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>关于Essential主题</h3>
<p>Essential 最初是为Moodle 2.5基于Bootstrap主题开发的并受到:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans 的帮助。</p>
<h3>主题鸣谢</h3>
<p>原作者: Julian Ridden<br>
2014年7月由:<br>
Gareth J. Barnard<br>
David Bezemer接手<br>
2014年10月9日:<br>
Gareth J. Barnard接手<br>
</p>
<h3>赞助支持</h3>
<p>本主题免费提供您使用，如果您打算表达谢意，请考虑通过以下方式赞助:
<h4>PayPal</h4>
<p>请通过以下链接联系我<a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle档案\'</a> 以及详情。作为个人，本人无法在条款中增加‘现在购买’按钮。</p>
<br>通过赞助可以帮助维护工作并使本人可以向您提供更多更好的功能。没有您的支持，此主题无法维护。</p>
<p>
<h3>赞助人</h3>
<p>真诚感谢以下赞助者:</p>
<ul>
<li>Mihai Bojonca, TCM 国际学院.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Essential for Moodle 3.3 由以下朋友提供赞助:</h3>
<ul>
<li>ClassroomRevolution, LLC -- Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM 国际学院</li>
</ul>
</p>
<h3>定制化</h3>
<p>如果您喜欢此主题并希望我进行定制、将功能转换至其它主题、 创建全新的子主题的话，我会提报有竞争力价格。请通过\'http://moodle.org/user/profile.php?id=442195\' 联系我讨论您的需求。</p>
</div></div>';
$string['colordesc'] = '您可以在这里找到改变本主题多种颜色的各种设置。';
$string['colorheading'] = '颜色';
$string['colorheadingsub'] = '设置主题用到的颜色';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = '联系信息';
$string['contactinfodesc'] = '输入联系信息';
$string['copyright'] = '版权';
$string['copyrightdesc'] = '组织名称';
$string['coursecategorysettingstitle'] = '课程分类设置';
$string['coursecontentsearch'] = '课程内容搜索';
$string['coursecontentsearchdesc'] = '在‘首页’页启动课程内容搜索功能。 仅当Essential不在\'\\$CFG->themedir\'目录中。';
$string['coursegrades'] = '课程级别';
$string['coursegradesmi'] = '课程成绩';
$string['coursegradesmidesc'] = '如果用户拥有\'gradereport/user:view\'权限，则显示课程成绩菜单项。‘显示成绩’设置为作用范围为课程级别。';
$string['courselistteachericon'] = '课程列表中的教师头像';
$string['courselistteachericondesc'] = '您希望使用的头像的名称或留空。 列表 <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">在此</a>。只需在"fa-"之后输入即可, 例如 "星星"。';
$string['coursesettingstitle'] = '课程设置';
$string['coursetitleposition'] = '课程标题位置';
$string['coursetitlepositiondesc'] = '为课程选择‘上方’或‘内部’。其中‘上方’指侧边预览、页顶以及课程内容的上方;‘内部’指位于课程内容区域，与没有此设置时的情况一样。';
$string['ctioverride'] = '替换一门课程中的分类图片';
$string['ctioverridedesc'] = '当启用“enablecategorycti”功能时，如果您想优先取代课程中的分类课程标题图片，则可以编辑课程设置中的课程概览，并添加图片文件。然后在HTML模式下编辑，移除周围的"p"及"br"标签，随后移除\'style\'、\'width\'及\'height\'属性。同时移除任何由文本编辑器加在\'img\'上的\'class\'标签。最后添加类\'categorycti。\'。如要指定高度(px) 及包含其内的标题文字颜色 、背景颜色 以透明度，可分别使用以下属性: \'ctih\', \'ctit\', \'ctib\' 及 \'ctio\'。例如:<br/><br/>&lt;img src=&quot;https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg&quot; alt=&quot;Replacement image&quot; class=&quot;categorycti&quot; ctih=&quot;250&quot; ctit=&quot;#afafaf&quot; ctib=&quot;#222222&quot; ctio=&quot;0.5&quot;&gt;<br/><br/>当查阅课程清单时，此图片不会显示在概览页面中。';
$string['ctioverrideheight'] = '替换课程标题图片的默认高度';
$string['ctioverrideheightdesc'] = '课程标题优先替换图片的默认高度在{$a->lower}至{$a->upper}像素之间。请只输入数字，勿在后面加上\'px\'。';
$string['ctioverridetextbackgroundcolour'] = '课程标题文字背景颜色的优先替换素材';
$string['ctioverridetextbackgroundcolourdesc'] = '课程标题背景的默认优先替换颜色。';
$string['ctioverridetextbackgroundopacity'] = '课程标题文字背景透明度的默认替换值';
$string['ctioverridetextbackgroundopacitydesc'] = '课程标题文字背景透明度的默认替换值。';
$string['ctioverridetextcolour'] = '课程标题文字的优先替换颜色';
$string['ctioverridetextcolourdesc'] = '课程标题文字的默认优先替换颜色。';
$string['customcss'] = '课程 CSS';
$string['customcssdesc'] = '您在此文本区域提供的任何CSS规则将影响每一个页面，这是自定义本主题的简单方式。';
$string['customscrollbars'] = '自定义滚动条';
$string['customscrollbarsdesc'] = '使用自定义滚动条。将替换浏览器的标准滚动条。';
$string['dbqueries'] = 'DB 读/写';
$string['dbtime'] = '数据库查询时间';
$string['defaultcategoryicon'] = '默认类别图标';
$string['defaultcategoryicondesc'] = '设置一个默认类别图标';
$string['defaultcategoryimage'] = '默认分类图片';
$string['defaultcategoryimagedesc'] = '设置默认分类图片。当显示时将优先地替换图标。';
$string['defaultcolors'] = '默认颜色';
$string['displayafterlogin'] = '仅在登陆后显示';
$string['displaybeforelogin'] = '仅在登陆前显示';
$string['displayeditingmenu'] = '显示编辑按钮';
$string['displayeditingmenudesc'] = '在标题上显示按钮，此按钮的功能与默认页页的编辑按钮的功能一样。';
$string['displayhiddenmycourses'] = '显示隐藏课程';
$string['displayhiddenmycoursesdesc'] = '如果用户有查阅隐藏课程的权限，那么在‘课程菜单’中向用户显示隐藏课程';
$string['displaymycourses'] = '显示参与的课程';
$string['displaymycoursesdesc'] = '在自定义菜单显示用户参与的课程';
$string['docking'] = '启用停靠。';
$string['dockingdesc'] = '如果启用，停靠将可用。';
$string['dontdisplay'] = '从不显示';
$string['dropdownmenumaxheight'] = '下拉式菜单最大高度';
$string['dropdownmenumaxheightdesc'] = '当滚动条启用时，下拉式菜单的最大高度。在{$a->lower} 至{$a->upper} 像素之间。';
$string['dropdownmenuscroll'] = '下拉式菜单的滚动条';
$string['dropdownmenuscrolldesc'] = '当下拉式菜单有高度限制时，在菜单上显示滚动条。';
$string['editingmenu'] = '页面编辑开关';
$string['editingmenudesc'] = '如果有对应权限，显示一个按钮用于启用/禁用当前页面编辑。功能与正常页面上的编辑按钮相同。';
$string['enablealert'] = '打开警告';
$string['enablealertdesc'] = '打开或关闭警告';
$string['enablealternativethemecolors'] = '允许备选主题颜色{$a}';
$string['enablealternativethemecolorsdesc'] = '如果启用，用户可以选择备选主题颜色{$a}。';
$string['enablecategorycti'] = '允许分类课程标题图片';
$string['enablecategoryctics'] = '在分类设置页面中启用分类课程标题图片设置';
$string['enablecategorycticsdesc'] = '启用后，各顶层分类将分别有自己单独的设置页面。';
$string['enablecategoryctidesc'] = '启用后，你可以在点击“保存更改"后选择分类课程图片。';
$string['enablecategoryicon'] = '启用分类图标';
$string['enablecategoryicondesc'] = '启用后，你可以在点击“保存更改"后选择分类图标/图片。';
$string['enablecustomcategoryicon'] = '允许自定义分类图标/图片';
$string['enablecustomcategoryicondesc'] = '如果在本节之下启用，您将看到每个分类之后均会有一个自定义选项。在启用或禁用本设置后请点击保存。';
$string['extperfinfoheading'] = '扩展性能详情';
$string['facebook'] = '脸书';
$string['facebookdesc'] = '输入您的脸书页面。（如https://www.facebook.com/mycollege）';
$string['facebookurl'] = '脸书URL';
$string['favicon'] = '自定义网址收藏图标';
$string['favicondesc'] = '上传网址收藏图标。必须为.icon文件。';
$string['featuredesc'] = '您可以在这里找到改变本主题多种功能的各种设置。';
$string['featureheading'] = '功能';
$string['featureheadingsub'] = '设置在主题中使用的功能';
$string['findcoursecontent'] = '课程搜索:';
$string['fitvids'] = '使用FitVids';
$string['fitvidsdesc'] = '启用FitVids (fitvidsjs.com)使您嵌入的视频可互动。如果 FitVids 开启时您希望不应用在某个视频上，可以进入编辑器的HTML模式，在 \'iframe\'标签\'里添加\'class="fitvidsignore"\'。例如:  \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'。';
$string['fixedwidthnarrow'] = '固定宽带 - 窄';
$string['fixedwidthnormal'] = '固定宽度 - 正常';
$string['fixedwidthwide'] = '固定宽度 - 宽';
$string['flatnavigation'] = '启用扁平导航栏。';
$string['flatnavigationdesc'] = '如启用，将不使用导航及设置区块，转为使用扁平导航栏。';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = '输入您Flickr页面的URL。(例 http://www.flickr.com/photos/mycollege)';
$string['flickrurl'] = 'Flickr URL';
$string['floatingsubmitbuttons'] = '浮动的提交按钮';
$string['floatingsubmitbuttonsdesc'] = '当在桌面设备提交表格时，相关按钮显示在的‘浮动\'区域。这将帮助您减少在某些页面上的上下滚屏。不会出现在讨论区贴子中的课程选课功能。';
$string['fontcharacterset'] = 'Google字体附加字符集';
$string['fontcharactersetcyrillic'] = 'Cyrillic';
$string['fontcharactersetcyrillicext'] = '西里尔字母扩展';
$string['fontcharactersetdesc'] = '为不同语言选取附加字符集。使用很多字符集会拖慢您的Moodle, 所以请只选取您真正要使用的字符集。';
$string['fontcharactersetgreek'] = 'Greek';
$string['fontcharactersetgreekext'] = '希腊语扩展';
$string['fontcharactersetlatinext'] = '拉丁语扩展';
$string['fontcharactersetvietnamese'] = '越南语';
$string['fontfileeotbody'] = '正文用EOT字体文件';
$string['fontfileeotheading'] = '标题用EOT字体文件';
$string['fontfileotfbody'] = '正文用OTF字体文件';
$string['fontfileotfheading'] = '标题用OTF字体文件';
$string['fontfiles'] = '字体文件';
$string['fontfilesdesc'] = '在此上传字体文件。';
$string['fontfilesvgbody'] = '正文用SVG字体文件';
$string['fontfilesvgheading'] = '标题用SVG字体文件';
$string['fontfilettfbody'] = '正文用TTF字体文件';
$string['fontfilettfheading'] = '标题用TTF字体文件';
$string['fontfilewoffbody'] = '正文用WOFF字体文件';
$string['fontfilewoffheading'] = '标题用WOFF字体文件';
$string['fontfilewofftwobody'] = '正文用WOFF2字体文件';
$string['fontfilewofftwoheading'] = '标题用WOFF2字体文件';
$string['fontheadingdesc'] = '选择和输入希望在Moodle环境中使用的字体。';
$string['fontheadingsub'] = '字体设置';
$string['fontnamebody'] = '文字字体';
$string['fontnamebodydesc'] = '输入准确的字体名，字体用于所有其它文字。';
$string['fontnameheading'] = '标题字体';
$string['fontnameheadingdesc'] = '输入标题字体的准确名称。';
$string['fontselect'] = '字体选择器';
$string['fontselectdesc'] = '从以下可用字体定义方式中选择:<ul><li>\'用户字体\' 是用户机器上已安装的字体，您只需要指定字体名称。</li><li>\'Google web 字体\' 是在\'{$a->googlewebfonts}\'上可用的字体并指定字体名称。</li><li>\'自定义字体\'是您指定字体名称并将字体文件上传到服务器中。</li></ul> 请保存后显示您选择的选项。';
$string['fontsettings'] = '字体';
$string['fonttypecustom'] = '自定义字体';
$string['fonttypegoogle'] = 'Google web 字体';
$string['fonttypeuser'] = '用户字体';
$string['footerblockbackgroundcolour'] = '页脚区块背景颜色';
$string['footerblockbackgroundcolourdesc'] = '为页脚设置区域背景颜色。';
$string['footerblockhovercolour'] = '页脚区块鼠标悬颜色';
$string['footerblockhovercolourdesc'] = '设置当鼠标悬停在页脚区块文字上时的文字链接颜色。';
$string['footerblocktextcolour'] = '页脚区块文字颜色';
$string['footerblocktextcolourdesc'] = '设置页脚文字块的颜色。';
$string['footerblockurlcolour'] = '页脚区块链接颜色';
$string['footerblockurlcolourdesc'] = '设置页脚中文字链接区块的颜色。';
$string['footercolor'] = '页脚背景颜色';
$string['footercolordesc'] = '设置页脚区块的背景颜色。';
$string['footercolors'] = '页脚颜色';
$string['footercolorsdesc'] = '修改页面的页脚颜色。';
$string['footerheading'] = '页脚';
$string['footerheadingcolor'] = '页脚抬头颜色';
$string['footerheadingcolordesc'] = '设置页脚中标题的颜色。';
$string['footerhovercolor'] = '页脚链接 hover 颜色';
$string['footerhovercolordesc'] = '设置鼠标在页脚区链接文字上悬浮时的文字颜色。';
$string['footersepcolor'] = '页脚分隔符颜色';
$string['footersepcolordesc'] = '分隔线是用于分隔内容的线。在此设置分隔线颜色。';
$string['footertextcolor'] = '页脚文本颜色';
$string['footertextcolordesc'] = '设置页脚文字颜色。';
$string['footerurlcolor'] = '页脚链接颜色';
$string['footerurlcolordesc'] = '设置页脚中链接文字的颜色。';
$string['footnote'] = '页脚标记';
$string['footnotedesc'] = '您在此文本区域添加的任何内容将显示在全站所有页面的页脚区域。';
$string['forumdiscussionsmi'] = '讨论';
$string['forumdiscussionsmidesc'] = '如果用户拥有\'mod/forum:viewdiscussion\' 权限，则显示讨论（论坛）菜单项。';
$string['forumpostsmi'] = '论坛帖子';
$string['forumpostsmidesc'] = '如果用户拥有\'mod/forum:viewdiscussion\' 权限，则显示讨论（论坛）菜单项。';
$string['fppagetopblocks'] = '启用首页附加‘页顶’区块';
$string['fppagetopblocksdesc'] = '如果启用，将在侧边区块旁边、内容区域上方的位置显示附加区块。注意:每行的区块数由设置中的‘fppagetopblocksperrow\'参数决定。';
$string['fppagetopblocksperrow'] = '每行页顶区块数';
$string['fppagetopblocksperrowdesc'] = '说明首页‘页顶’区域每行区块数最小{$a->lower} 到最大{$a->upper}。';
$string['frontcontent'] = '启用首页内容区';
$string['frontcontentarea'] = '首页内容区的内容';
$string['frontcontentareadesc'] = '在此处输入的任何内容将显示在图片轮播与市场宣传位之间，并占据整个页面宽度。';
$string['frontcontentdesc'] = '启用后将在“图片轮播”及“市场宣传位”之间添加一个自定义内容区域，可以放置您自己的内容。';
$string['frontcontentheading'] = '首页内容区';
$string['frontpageblocks'] = '首页块对齐';
$string['frontpageblocksdesc'] = '在此指定首页上的标准Moodle区块位于内容前还是内容后。';
$string['frontpageblocksheading'] = '首页块';
$string['frontpageheading'] = '首页';
$string['frontpageheadingdesc'] = '在此指定您需要在首页显示的其它项目。';
$string['frontpagehomeblocksperrow'] = '每行的主区块数(曾称作‘中间’区块)';
$string['frontpagehomeblocksperrowdesc'] = '声明主页区块区域每行有多少区块。区块数介于{$a->lower} 及 {$a->upper} 之间。注意:为方便编辑，无论设置值为多少，编辑时显示每行两个区块。声明主区块区域每行有多少区块。区块数介于{$a->lower} 及 {$a->upper} 之间。';
$string['frontpagemiddleblocks'] = '启用附加主页（曾称’中间‘）区块数';
$string['frontpagemiddleblocksdesc'] = '启用后将在市场宣传正下方位显示附加区块位置。';
$string['frontpagesettingstitle'] = '首页设置';
$string['fullname'] = '网站全称';
$string['fullnamesummary'] = '全称及概况';
$string['generalheadingdesc'] = '在此配置主题的常规设置。';
$string['generalheadingsub'] = '常用设置';
$string['genericsettings'] = '常用';
$string['googleplus'] = 'Google+';
$string['googleplusdesc'] = '输入您在Google+上个人简介的URL。(如 https://plus.google.com/+mycollege)';
$string['googleplusurl'] = 'Google+ URL';
$string['gotobottom'] = '至本页末尾';
$string['gotopeople'] = '转到用户';
$string['haveheaderblock'] = '页眉块区域';
$string['haveheaderblockdesc'] = '在线索正下方显示页眉块区域。';
$string['headerbackground'] = '页眉背景图片';
$string['headerbackgrounddesc'] = '上传您自己的背景图片。';
$string['headerbackgroundstyle'] = '页眉背景风格';
$string['headerbackgroundstyledesc'] = '为页眉背景选择风格。';
$string['headerblocksperrow'] = '每行页眉块数量';
$string['headerblocksperrowdesc'] = '声明包含页眉块区域的页面每行有多少区块，数值介于{$a->lower} 和 {$a->upper} 之间。';
$string['headerheading'] = '抬头';
$string['headertextcolor'] = '标题文字颜色';
$string['headertextcolordesc'] = '设置标题文字颜色';
$string['headertitle'] = '页眉标题';
$string['headertitledesc'] = '配置在页眉内显示的标题。注: 页眉标题只在没有图标时可用。';
$string['helplink'] = '帮助链接';
$string['helplinkdesc'] = '如果您在上页选择了URL, 请填写帮助网站的完整URL（必须包含http:// 或 https://)。如果您选择了电子邮箱地址，请填写邮箱地址。';
$string['helplinktype'] = '启用菜单中的帮助链接';
$string['helplinktypedesc'] = '选择是否要在用户菜单中启用帮助选项，您可以选择提供在新窗口中打开的URL或是电子邮件地址。';
$string['hidedefaulteditingbutton'] = '隐藏默认页面编辑按钮';
$string['hidedefaulteditingbuttondesc'] = '隐藏所有页面上默认显示的页面编辑按钮。此设置仅在启用了“显示编辑按钮”选项后生效。';
$string['hideonphone'] = '在移动设备上隐藏轮播幻灯';
$string['hideonphonedesc'] = '如果希望禁用在移动设备上图片轮播可勾选此项。';
$string['hideontablet'] = '在平板上隐藏轮播幻灯';
$string['hideontabletdesc'] = '如果希望在平板电脑上禁用图片轮播可勾选此项。';
$string['hvpcustomcss'] = 'H5P 自定义 CSS';
$string['hvpcustomcssdesc'] = 'H5P模块 (moodle.org/plugins/mod_hvp) 的自定义 CSS (如果已安装)。';
$string['icon'] = '图标';
$string['image'] = '图像';
$string['included'] = '包含的文件';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = '请输入您在Instagram上的页面URL.(如http://instagram.com/mycollege)';
$string['instagramurl'] = 'Instagram URL';
$string['ios'] = 'iPhone/iPad (应用商店)';
$string['iosdesc'] = '提供您的移动应用在应用商店里的URL。如果您没有自己的移动应用，可考虑链接到Moodle官方移动应用(https://itunes.apple.com/en/app/moodle-mobile/id633359593)。';
$string['iosicon'] = 'iOS 主屏幕图标';
$string['iosicondesc'] = '本主题提供了默认的iOS及安卓的主屏幕图标。如果您愿意，也可以上传自己的自定义图标。';
$string['iosurl'] = 'iPhone/iPad (应用商店) URL';
$string['ipadicon'] = 'iPad 图标 (非视网膜屏)';
$string['ipadicondesc'] = '图标文件应为PNG格式，大小为72px x 72px。';
$string['ipadretinaicon'] = 'iPad 图标 (视网膜屏)';
$string['ipadretinaicondesc'] = '图标文件应为PNG格式，大小为 144p x 144px。';
$string['iphoneicon'] = 'iPhone/iPod Touch 图标 (非视网膜屏)';
$string['iphoneicondesc'] = '图标文件应为PNG格式，大小为57px x 57px。';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch 图标 (视网膜屏)';
$string['iphoneretinaicondesc'] = '图标文件应为PNG格式, 大小为 114px x 114px。';
$string['layout'] = '使用标准课程布局';
$string['layoutdesc'] = '本主题设计为将2列置于一侧。如果您喜欢Moodle标准课程布局，您可以勾选这个选框回到原3列布局。';
$string['left'] = '左侧';
$string['linkedin'] = '领英';
$string['linkedindesc'] = '输入您在领英的个人简介URL。(如，https://www.linkedin.com/company/mycollege)';
$string['linkedinurl'] = '领英URL';
$string['loadtime'] = '加载时间';
$string['loggedinas'] = '登录为';
$string['loggedinfrom'] = '登录自';
$string['loggedinfrommi'] = '登录自';
$string['loggedinfrommidesc'] = '如果用户为MNET远程用户，则显示登录来源菜单项。';
$string['loginbackground'] = '登录背景图像';
$string['loginbackgrounddesc'] = '上传您自己的登录背景图像。在下面选择图像的风格。';
$string['loginbackgroundopacity'] = '当有背景图像时，登录框的背景透明度';
$string['loginbackgroundopacitydesc'] = '当存在背景图像时，登录框背景透明度。';
$string['loginbackgroundstyle'] = '登录背景风格';
$string['loginbackgroundstyledesc'] = '选择已上传图像的风格。';
$string['logo'] = '公司标志';
$string['logodesc'] = '如想把自定义LOGO显示在页眉中，请在此上传文件。<br>图片将会根据设备的可用宽度比例进行缩放。实现响应式解决方案。 如果您有很多社交/应用图标，请认真检查结果。<br>如果上传了LOGO,它将替换默认标准图标及其名称。';
$string['logodesktopwidth'] = 'Logo在桌面显示的宽度';
$string['logodesktopwidthdesc'] = '在桌面应用显示Logo图像的窗口宽度, >= 980px.<br>请指定可用空间占比最小值{$a->lower} 最大值 {$a->upper}。<br>可用空间为“页面宽度”设置中指定的宽度。图片将撑满指定的占比。<br>备注: 容器的最小高度为64像素，因此如果计算的结果小于此数，显示时底边会有空隙。';
$string['logodimerror'] = '无效。请在数值后指定\'px\' 或 \'em\' 同时数值前不要输入任何内容。';
$string['logomobilewidth'] = '移动应用Logo宽度';
$string['logomobilewidthdesc'] = '在移动应用显示Logo图像的窗口宽度, <980px.<br>请指定可用空间占比最小值{$a->lower} 最大值 {$a->upper}。<br>可用空间为“页面宽度”设置中指定的宽度。图片将撑满指定的占比。<br>备注: 容器的最小高度为52像素，因此如果计算的结果小于此数，显示时底边会有空隙。';
$string['marketing1'] = '市场宣传位一';
$string['marketing2'] = '市场宣传位二';
$string['marketing3'] = '市场宣传位三';
$string['marketingbuttontext'] = '链接文字';
$string['marketingbuttontextdesc'] = '显示在按钮上的文字';
$string['marketingbuttonurl'] = '链接URL';
$string['marketingbuttonurldesc'] = '按钮指向的URL';
$string['marketingcontent'] = '内容';
$string['marketingcontentdesc'] = '需要显示在市场宣传位中的内容。写得短小精悍一些哦。';
$string['marketingdesc'] = '本主题在图片轮播下方启用3个"市场"或"广告"位。您可轻松展示核心信息并提供直接链接。';
$string['marketingheading'] = '市场宣传位';
$string['marketingheadingsub'] = '首页在可添加信息及链接的三个位置。';
$string['marketingheight'] = '市场宣传位容器的高度(px)';
$string['marketingheightdesc'] = '指定市场宣传位容器高度像素值。可进行调整来适应内容。如果宣传位有图片或链接，将会为所有宣传位添加此值。';
$string['marketingicon'] = '图标';
$string['marketingicondesc'] = '您想给图标的名字。列表 <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">在此</a>. 只要在"fa-"后输入内容即可，例如"星星"。';
$string['marketingimage'] = '图像';
$string['marketingimagedesc'] = '此选项可以在市场宣传位文字上方显示图片';
$string['marketingimageheight'] = '市场宣传图片的高度(px)';
$string['marketingimageheightdesc'] = '如果你希望在市场宣传位中显示图片，可以在此设置其像素高度。';
$string['marketinginfodesc'] = '输入市场宣传位的设置';
$string['marketingtitle'] = '标题';
$string['marketingtitledesc'] = '市场宣传位中显示的标题';
$string['marketingurltarget'] = '链接对象';
$string['marketingurltargetdesc'] = '选择链接的打开方式';
$string['marketingurltargetnew'] = '新页面';
$string['marketingurltargetparent'] = '父页面';
$string['marketingurltargetself'] = '当前页面';
$string['memused'] = '已使用的内存';
$string['messagesmi'] = '消息';
$string['messagesmidesc'] = '如果已启用消息服务，则显示消息工菜单。';
$string['mobileappsdesc'] = '你是否已从苹果应用商店或安卓应用商店获取了应用？在此提供链接，这样用户或以进行移动应用的下载。';
$string['mobileappsheading'] = '移动应用';
$string['mobileappsheadingsub'] = '链接至您的移动应用以便学生使用移动设备';
$string['modulesettingstitle'] = '模块设置';
$string['myclasses'] = '我的班级';
$string['mycourses'] = '我的课程';
$string['mycoursescatsubmenu'] = '分类及课程子菜单';
$string['mycoursescatsubmenudesc'] = '根据课程所属顶层分类将课程组织为子菜单。当 \'enablecategoryicon\'设置为\'否\'则使用主题默认的分类图标，当设置为\'是\'则为\'defaultcategoryicon\'设置的图标，如果\'enablecustomcategoryicon\'为\'是\'，则使用自定义分类图标。\'mycoursesmax\'将对分类级别有效。';
$string['mycoursesinfo'] = '参与的课程菜单';
$string['mycoursesinfodesc'] = '向用记显示动态列表展示已选课程。';
$string['mycoursesmax'] = '最大课程数';
$string['mycoursesmaxdesc'] = '声明列表中列出多少门课程最小值为{$a->lower} 且最大值为 {$a->upper} 其中 \'{$a->lower}\' 代表所有。';
$string['mycoursesorder'] = '课程排序';
$string['mycoursesorderdesc'] = '声明课程如何排序。课程排列顺序可在核心导航设置\'navsortmycoursessort\'设置。';
$string['mycoursesorderenrolbackcolour'] = '已选课但沿未访问课程的背景颜色';
$string['mycoursesorderenrolbackcolourdesc'] = '已选但尚未访问过的课程的背景颜色。当 \'mycoursesorder\' 设置为 \'最近访问...\'。';
$string['mycoursesorderid'] = '课程ID';
$string['mycoursesorderidasc'] = '升序';
$string['mycoursesorderiddes'] = '降序';
$string['mycoursesorderidorder'] = '课程ID顺序';
$string['mycoursesorderidorderdesc'] = '当“课程ID”按“课程排列顺序”设置时，课程ID的顺序。';
$string['mycoursesorderlast'] = '最后访问时间。如从未访问过则为选课开始时间';
$string['mycoursesordersort'] = '课程排列顺序';
$string['mycoursetitle'] = '术语';
$string['mycoursetitledesc'] = '修改“我的课程”菜单标题称呼。当"mycoursesorde"设置为"最后访问..."时，则增加“最近"二字。';
$string['mygrades'] = '我的级别';
$string['mygradesmi'] = '我的成绩';
$string['mygradesmidesc'] = '如果用户拥有课程\'gradereport/overview:view\'权限，则显示我的成绩菜单。全站级别不会勾选。';
$string['mylatestclasses'] = '我的最近班级';
$string['mylatestcourses'] = '我的最近课程';
$string['mylatestmodules'] = '我的最近模块';
$string['mylatestunits'] = '我的最近单元';
$string['mymodules'] = '我的模块';
$string['myunits'] = '我的单元';
$string['navbarabove'] = '导航栏位于页眉上方';
$string['navbarbelow'] = '导航栏位于页眉下方';
$string['navbartitle'] = '导航栏标题';
$string['navbartitledesc'] = '在此设置导航栏的标题内容。';
$string['nextsection'] = '下一节';
$string['nobreadcrumb'] = '隐藏';
$string['noenrolments'] = '你还没有参与';
$string['noslidetitle'] = '幻灯无标题 {$a->slide}';
$string['notitle'] = '无标题';
$string['numberofcoursesandsubcatcourses'] = '课程数量 - 子分类课程';
$string['numberofslides'] = '幻灯的数量';
$string['numberofslides_desc'] = '轮播器上幻灯的数量';
$string['oldnavbar'] = '使用旧式导航栏位置';
$string['oldnavbardesc'] = '启用此选项将使用旧式导航栏位置，将导航栏放在页眉下方。';
$string['pagebackground'] = '页面背景图片';
$string['pagebackgrounddesc'] = '上传您自己的背景图像。在下面选择图像的风格。';
$string['pagebackgroundstyle'] = '页面背景风格';
$string['pagebackgroundstyledesc'] = '选择已上传图像的风格。';
$string['pagebottomblocksperrow'] = '页面每行底部区块数';
$string['pagebottomblocksperrowdesc'] = '为包含’页面底部区块\'的页面声明每行多少区块最小值{$a->lower}最大值{$a->upper}。当前页面为:管理员、课程管理，等级及测试编辑。';
$string['pagetopblocks'] = '启用附加页‘页顶’区块';
$string['pagetopblocksdesc'] = '如启用，将为除首页之外所有页面的侧边区块旁、内容区域上方显示附加区块位置。首页有自己的单独设置。注音:每行区块数取决于\'pagetopblocksperrow\'设置。';
$string['pagetopblocksperrow'] = '每行页顶区块数';
$string['pagetopblocksperrowdesc'] = '对具有"页顶区块"的页面，声明每行区块数量，最小值{$a->lower}最大值{$a->upper}。当前页面为: 课程、课程分类、首页、我的公共页及打印。';
$string['pagewidth'] = '设置页面宽度';
$string['pagewidthdesc'] = '在列表中为您的网站选择可用的页面宽度。';
$string['participantsmenu'] = '参与者菜单';
$string['participantsmenudesc'] = '在课程和模块页面中显示参与者菜单。';
$string['paypal_click'] = 'Moodle 简介';
$string['paypal_desc'] = '{$a->url}\' 查看详情，因为我本人为个人，所以在官方条款中，我无法放置“现在购买”按钮或';
$string['peakmem'] = '峰值内存';
$string['perf_max'] = '详细的';
$string['perf_min'] = '最小的';
$string['perfinfo'] = '性能信息模式';
$string['perfinfodesc'] = '很多网站并不需要全面而详尽的性能信息。尤其是当用户进行访问时。当启用此功能，将显示一个最化化的整洁表格，表格中信用页面的基本加载信息。';
$string['perfinfoheading'] = '性能信息';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = '输入您Pinterest页面的URL(如 http://pinterest.com/mycollege/mypinboard)';
$string['pinteresturl'] = 'Pinterest URL';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = '选项';
$string['preferencesmidesc'] = '显示首选项菜单项。';
$string['previoussection'] = '上一节';
$string['privacy:metadata:preference:courseitemsearchtype'] = '当勾选和保存过\'coursecontentsearch\'选项，则此处为用户选择的课程搜索方式("课程全称“ - \'0\' 或所有课程内容- \'1\') 。如果此处无选项，则可能是课程搜索未启用，或用户在课程搜索开启时从未访问过首页。';
$string['privacy:request:preference:courseitemsearchtype'] = '用户已选择 "{$a->value}" 作为课程搜索偏好。 "{$a->name}"  中\'0\'代表课程全称，\'1\' 代表课程内容。';
$string['privatefilesmi'] = '私人文件';
$string['privatefilesmidesc'] = '如果用户拥有\'moodle/user:manageownfiles\'权限，则显示私人文件菜单项。';
$string['profilebarcustomtitle'] = '简介栏自定义区块标题';
$string['profilebarcustomtitledesc'] = '自定义简介栏区块标题。';
$string['profilelinkmi'] = '档案链接';
$string['profilelinkmidesc'] = '显示档案链接菜单项。';
$string['properties'] = '属性';
$string['propertiesdesc'] = '属性列表。';
$string['propertiesexport'] = '以JSON格式导出属性字符串';
$string['propertiesproperty'] = '属性';
$string['propertiesreturn'] = '返回';
$string['propertiessub'] = '属性';
$string['propertiesvalue'] = '值';
$string['putpropertiesadded'] = '已添加:';
$string['putpropertieschanged'] = '已修改:';
$string['putpropertiesdesc'] = '粘贴JSON字符串并"保存更改"。注意! 此操作并不检验设置的值及执行“清空所有缓存”。';
$string['putpropertiesfrom'] = '从';
$string['putpropertiesignorecti'] = '忽略所有课程标题图片设置。';
$string['putpropertiesignored'] = '已忽略:';
$string['putpropertiesname'] = '存入属性 - 实验性功能！';
$string['putpropertiesreportfiles'] = '别忘了上传下面的文件至设置:';
$string['putpropertiessettingsreport'] = '设置报表：';
$string['putpropertiesunchanged'] = '未改变:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = '我们的';
$string['putpropertyproperties'] = '属性';
$string['putpropertyreport'] = '报表：';
$string['putpropertyversion'] = '版本:';
$string['readme_click'] = '点击查看 README.txt';
$string['readme_desc'] = '请{$a->url}文件,其中有更多有关Essential主题的信息包括如何自定义。';
$string['readme_title'] = 'Essential自述';
$string['readmore'] = '阅读更多';
$string['region-footer-left'] = '页脚(左)';
$string['region-footer-middle'] = '页脚(中)';
$string['region-footer-right'] = '页脚(右)';
$string['region-header'] = '页眉';
$string['region-hidden-dock'] = '对用户隐藏';
$string['region-home'] = '主页';
$string['region-page-top'] = '页顶';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['returntosection'] = '返回至:{$a->section}';
$string['returntosectionfeature'] = '返回至章节';
$string['returntosectionfeaturedesc'] = '启用在课程模板中返回至章节的功能。';
$string['returntosectiontextlimitfeature'] = '返回至的章节名称文字限制';
$string['returntosectiontextlimitfeaturedesc'] = '按钮上章节名称长度限制，最小字符数{$a->lower} 最大字符数{$a->upper}。';
$string['right'] = '右';
$string['searchallcoursecontent'] = '搜索全部课程内容';
$string['searchallcoursecontentdefault'] = '默认搜索全部课程内容';
$string['searchallcoursecontentdefaultdesc'] = '设置课程内容搜索功能中“搜索所有课程内容”复选框的值。如果“搜索所有课程内容”未勾选，则只搜索课程的全称。';
$string['searchallcoursecontentenable'] = '启用搜索所有课程内容。';
$string['searchallcoursecontentenabledesc'] = '允许用户决定是否要搜索全部课程内容。如果禁用此选项，\'searchallcoursecontentdefault\'的值将被用于课程搜索。';
$string['serverload'] = '服务器负载';
$string['sessionsize'] = '会话量';
$string['shortname'] = '网站简称';
$string['shortnamesummary'] = '简称及概览';
$string['siteicon'] = '站点图标';
$string['siteicondesc'] = '没有自己的Logo? 输入您要使用的图标名称。列表<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">在此</a>。只需输入"fa-"之后的内容即可。';
$string['skype'] = 'Skype账号';
$string['skypedesc'] = '输入您单位的Skype账号的Skype用户名URI（如,skype://my.college）';
$string['skypeuri'] = 'Skype账号URI';
$string['slidebuttoncolor'] = '滑块颜色';
$string['slidebuttoncolordesc'] = '滑动导航按钮的颜色。';
$string['slidebuttonhovercolor'] = '滑块鼠标悬停颜色';
$string['slidebuttonhovercolordesc'] = '滑动导航按钮的鼠标悬停颜色。';
$string['slidecaption'] = '幻灯标题';
$string['slidecaptionbackgroundcolor'] = '幻灯标题背景颜色';
$string['slidecaptionbackgroundcolordesc'] = '幻灯标题背景颜色。对幻灯标题位于旁边的选项无效。';
$string['slidecaptionbelow'] = '幻灯标题在图像下方';
$string['slidecaptionbelowdesc'] = '幻灯标题是否在图片的下方。';
$string['slidecaptionbeside'] = '旁边';
$string['slidecaptioncentred'] = '幻灯标题居中';
$string['slidecaptioncentreddesc'] = '幻灯标题是否居中。';
$string['slidecaptiondesc'] = '输入幻灯标题文字';
$string['slidecaptionontop'] = '上方';
$string['slidecaptionoptions'] = '幻灯标题选项';
$string['slidecaptionoptionsdesc'] = '标题与图像的相对位置。';
$string['slidecaptiontextcolor'] = '幻灯标题文字颜色';
$string['slidecaptiontextcolordesc'] = '幻灯标题文字颜色。对幻灯标题位于旁边的选项无效。';
$string['slidecaptionunderneath'] = '下方';
$string['slidecolor'] = '幻灯文字颜色';
$string['slidecolordesc'] = '幻灯标题文字颜色。';
$string['slideimage'] = '幻灯图片';
$string['slideimagedesc'] = '透明图片的显示效果最佳。';
$string['slideinterval'] = '幻灯播放间隔';
$string['slideintervaldesc'] = '幻灯片切换间隔，单位毫秒。';
$string['slideno'] = '幻灯片 {$a->slide}';
$string['slidenodesc'] = '输入幻灯片 {$a->slide}的设置。';
$string['slideshowdesc'] = '创建多至6张图片轮播用于推广网站的重要元素。轮播为响应式，图片高度随之屏幕分辨率设置。建议的高度为300像素。宽度设置为100%，因此如果图像宽度大于屏幕宽度，实际高度将会较小。在小屏幕上图像高度会动态减小而无需单独提供图片。参考屏幕尺寸< 767px = 高度 165px, 宽度介于 768px 及 979px之间 = 高度 225px   宽度 > 980px = 高度 300px。如果没有指定拖放图片，将使用pix 目录下的默认图片。';
$string['slideshowheading'] = '图片轮播';
$string['slideshowheadingsub'] = '首页动态图片轮播';
$string['slidetitle'] = '幻灯片标题';
$string['slidetitledesc'] = '为幻灯输入说明性标题';
$string['slideurl'] = '侧边链接';
$string['slideurldesc'] = '输入幻灯片图片的目标链接';
$string['slideurltarget'] = '链接目标';
$string['slideurltargetdesc'] = '选择链接的打开方式';
$string['slideurltargetnew'] = '新页面';
$string['slideurltargetparent'] = '上级框架';
$string['slideurltargetself'] = '当前页面';
$string['socialdesc'] = '提供核心社交网络的直接链接来推广您的品牌。这些链接将出现在每个页面的页眉区域。';
$string['socialheading'] = '社交网络';
$string['socialheadingsub'] = '通过社交网络连接您的用户';
$string['socialnetworks'] = '社交网络';
$string['sponsor_desc'] = 'Paypal赞助，请通过以下方式联系我\\';
$string['sponsor_desc2'] = '可帮助Essential持续开发，或您可表达您的谢意。';
$string['sponsor_title'] = '赞助Essential';
$string['stylecover'] = '封面';
$string['stylefixed'] = '固定';
$string['styleguide'] = '风格指南';
$string['styleguidedesc'] = '原始文档代码 "{$a->origcodelicenseurl}"已授权。 Holder.js 由 "{$a->holderlicenseurl}" 授权。附加代码"{$a->thiscodelicenseurl}" 已授权为 "{$a->compatible}" 许可。 内容"{$a->contentlicenseurl}"已授权。文档已格式适配Moodle输出，并在合适的场合使用了FontAwesome图标。附加CSS可以在"essential_admin_setting_styleguide.php”文件，注释行"// 更多参考docs.css."下方找到。"{$a->globalsettings}”部分已被移除。';
$string['styleguidesub'] = 'Bootstrap V2.3.2 风格指南';
$string['stylestretch'] = '拉伸';
$string['styletiled'] = '平铺';
$string['switchrolemi'] = '切换角色';
$string['switchrolemidesc'] = '如果用户可以切换角色，显示切换角色菜单项。';
$string['tallyinoftotal'] = '{$a->rtally} in {$a->ctally} of {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} 共 {$a->total}';
$string['themecolor'] = '主题颜色';
$string['themecolordesc'] = '主题的颜色。此设置可改变多种部件生成您希望的全站颜色';
$string['themecolors'] = '主题颜色';
$string['themedefaultbuttonbackgroundcolour'] = '默认按钮背景颜色';
$string['themedefaultbuttonbackgroundcolourdesc'] = '设置所有默认按钮的背景颜色。';
$string['themedefaultbuttonbackgroundhovercolour'] = '默认按钮鼠标悬停背景颜色';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = '设置所有默认按钮的鼠标悬停背景颜色。';
$string['themedefaultbuttontextcolour'] = '默认按钮文字颜色';
$string['themedefaultbuttontextcolourdesc'] = '设置所有默认按钮文字颜色。';
$string['themedefaultbuttontexthovercolour'] = '默认按钮文字鼠标悬停颜色';
$string['themedefaultbuttontexthovercolourdesc'] = '设置所有默认按钮文字鼠标悬停颜色。';
$string['themehovercolor'] = '主题鼠标悬停颜色';
$string['themehovercolordesc'] = '主题鼠标悬停颜色。对链接、菜单等很有用。';
$string['themeiconcolor'] = '图标颜色';
$string['themeiconcolordesc'] = '设置所有图标的颜色。';
$string['themenavcolor'] = '导航文字颜色';
$string['themenavcolordesc'] = '设置导航文本的颜色，即导航栏及线索风格。';
$string['themequizsubmitbackgroundcolour'] = '测验的 "全部提交并结束"按钮背景颜色';
$string['themequizsubmitbackgroundcolourdesc'] = '设置测验的"全部提交并结束"按钮的背景颜色 。';
$string['themequizsubmitbackgroundhovercolour'] = '测验的 "全部提交并结束"按钮鼠标悬停背景颜色';
$string['themequizsubmitbackgroundhovercolourdesc'] = '设置测验的"全部提交并结束"按钮的背景鼠标悬停颜色 。';
$string['themequizsubmittextcolour'] = '测验"全部提交并结束" 文字颜色';
$string['themequizsubmittextcolourdesc'] = '设置测验的"全部提交并结束"按钮文字颜色。';
$string['themequizsubmittexthovercolour'] = '测验 "全部提交并结束" 鼠标悬停文字颜色';
$string['themequizsubmittexthovercolourdesc'] = '设置测验的"全部提交并结束"按钮文字鼠标悬停颜色。';
$string['themesidepreblockbackgroundcolour'] = '“侧边面板”区块背景颜色';
$string['themesidepreblockbackgroundcolourdesc'] = '设置"侧边面板"区块的背景颜色。';
$string['themesidepreblockhovercolour'] = '“侧边面板”链接的背景鼠标悬停颜色';
$string['themesidepreblockhovercolourdesc'] = '设置"侧边面板"区块中链接的鼠标悬停颜色。';
$string['themesidepreblocktextcolour'] = '“侧边面板”区块文字颜色';
$string['themesidepreblocktextcolourdesc'] = '设置"侧边预览"区块的文字颜色。';
$string['themesidepreblockurlcolour'] = '“侧边面板”区块的链接颜色';
$string['themesidepreblockurlcolourdesc'] = '设置"侧边面板"区块中链接的颜色。';
$string['themestripebackgroundcolour'] = '条带背景颜色';
$string['themestripebackgroundcolourdesc'] = '设置表格中条带的背景颜色。';
$string['themestripetextcolour'] = '条带文字颜色';
$string['themestripetextcolourdesc'] = '设置表格中条带的文字颜色。';
$string['themestripeurlcolour'] = '条带URL颜色';
$string['themestripeurlcolourdesc'] = '设置表格条带中URL的颜色。';
$string['themetextcolor'] = '文字颜色';
$string['themetextcolordesc'] = '设置文字颜色。';
$string['themeurlcolor'] = '链接颜色';
$string['themeurlcolordesc'] = '设置连接文本的颜色。';
$string['thiscourse'] = '本课程';
$string['togglemarketing'] = '启停市场热点功能';
$string['togglemarketingdesc'] = '选择是否隐藏或显示三个市场热点。';
$string['toggleslideshow'] = '启停轮播功能';
$string['toggleslideshowdesc'] = '选择是否隐藏或显示轮播。';
$string['twitter'] = 'Twitter URL';
$string['twitterdesc'] = '输入你的 Twitter URL。 (比如 https://www.twitter.com/mycollege)';
$string['twitterurl'] = '推特 URL';
$string['userimageborderradius'] = '用户图片边框半径';
$string['userimageborderradiusdesc'] = '指定用户图片边框半径，介于最小值{$a->lower} 最大值 {$a->upper} 像素之间。此设置在全站范围内有限，不包括页眉处使用 \'usermenuuserimageborderradius\'设置的图片。';
$string['usermenu'] = '用户菜单';
$string['usermenudesc'] = '用户菜单。';
$string['usermenuuserimageborderradius'] = '用户菜单图片边框半径';
$string['usermenuuserimageborderradiusdesc'] = '指定用户菜单中用户图片的边框半径，最小值{$a->lower} 最大值 {$a->upper}。';
$string['usersettingstitle'] = '用户设置';
$string['usesiteicon'] = '使用网站图标';
$string['usesiteicondesc'] = '如果没有Logo，则使用网站图标。';
$string['variablewidth'] = '可变宽度';
$string['versionalerttext1'] = '主题不是为此版本Moodle设计的。';
$string['versionalerttext2'] = '可能会发生未知错误 ，请获取兼容您Moodle版本的主题版本。';
$string['versionalerttitle'] = '版本警告:';
$string['visibleadminonly'] = '仅管理员能看到下面区域的模块';
$string['vk'] = 'VKontakte URL';
$string['vkdesc'] = '输入你的 Vkontakte URL。 (比如 http://www.vk.com/mycollege)';
$string['vkurl'] = 'VKontakte URL';
$string['website'] = '网站';
$string['websitedesc'] = '输入你自己的网站地址。 (比如 http://www.uplearning.nl)';
$string['websiteurl'] = '网站地址';
$string['windows'] = 'Windows桌面';
$string['windowsdesc'] = '提供Windows商店中您移动应用的链接。如果您没有自己的移动应用，您可以考虑链接到Moodle 的官方移动应用。例如 (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'Windows桌面版 URL';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = '提供Google Player商店中您移动应用的链接。如果您没有自己的移动应用，您可以考虑链接到Moodle 的官方移动应用。例如 (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'Windows Mobile URL';
$string['within'] = '内部';
$string['youtube'] = 'YouTube URL';
$string['youtubedesc'] = '输入你的 YouTube URL。 (比如 https://www.youtube.com/user/mycollege)';
$string['youtubeurl'] = 'YouTube URL';
