<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dash', language 'de', version '4.1'.
 *
 * @package     block_dash
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accordionfield1'] = 'Oberes linkes Feld';
$string['accordionfield1icon'] = 'Icon des oberen linken Felds';
$string['accordionfield2'] = 'Oberes rechtes Feld';
$string['accordionfield2icon'] = 'Icon des oberen rechten Felds';
$string['accordionfield3'] = 'Unteres linkes Feld';
$string['accordionfield3icon'] = 'Icon des unteren linken Felds';
$string['accordionfield4'] = 'Unteres linkes Feld';
$string['accordionfield4icon'] = 'Icon des unteren rechten Felds';
$string['achieved'] = 'Erreicht';
$string['activitybutton'] = 'Aktivitätsbutton';
$string['activityprogress'] = 'Fortschritt (abgeschlossen/gesamte Aktivitäten)';
$string['activityprogressbar'] = 'Fortschrittsbalken (abgeschlossen/gesamte Aktivitäten)';
$string['addcontent'] = 'Inhalt hinzufügen';
$string['addjointable'] = '{no} join Tabellen zum Formular hinzufügen';
$string['addnewfield'] = 'Neues Feld hinzufügen';
$string['addtocontacts'] = 'Zu Kontakten hinzufügen';
$string['alpha_asc'] = 'Alphabetisch sortieren von A bis Z';
$string['alpha_desc'] = 'Alphabetisch sortieren von Z bis A';
$string['always'] = 'Immer';
$string['anothertrailpath'] = 'Neuer Versuch';
$string['arrows'] = 'Pfeile anzeigen';
$string['arrows_help'] = 'Pfeilschaltflächen für die Navigation durch die nächste/vorherige Folie anzeigen.';
$string['asc'] = 'ASC';
$string['attribute'] = 'Attribut';
$string['auto'] = 'Auto';
$string['autoplay'] = 'Autoplay';
$string['autoplaySpeed'] = 'Autoplay-Geschwindigkeit (ms)';
$string['autoplaySpeed_help'] = 'Legen Sie die Geschwindigkeit des Autoplay in Millisekunden fest.';
$string['autoplay_help'] = 'Autoplay';
$string['availablefields'] = 'Verfügbare Felder';
$string['availablefields_help'] = 'Wählen Sie alle möglichen Felder aus, die diese Datenquelle verwenden soll. Nutzer/innen können die Felder für ihre Zwecke auswählen. Wenn Sie beispielsweise Nutzerinformationen anzeigen, versuchen Sie, so viele Nutzerfelder wie möglich einzuschließen.';
$string['backgroundcolor'] = 'Hintergrundfarbe';
$string['backgroundgradient'] = 'Hintergrundfarbverlauf';
$string['backgroundgradient_help'] = 'Einen Farbverlauf erstellen: <a href="https://cssgradient.io/" target="_blank">cssgradient.io</a>. Fügen Sie die Hintergrundeigenschaft (linear-gradient) ein.';
$string['backgroundimage'] = 'Hintergrundbild';
$string['backgroundimage_help'] = 'Den gesamten Blockhintergrund mit diesem Bild bedecken';
$string['backgroundimagefield'] = 'Hintergrundbild';
$string['backgroundimageurl'] = 'URL des Hintergrundbildes';
$string['backgroundposition'] = 'Hintergrundposition';
$string['backgroundposition_help'] = 'Das Hintergrundbild wird auf diese angegebene Position fokussiert';
$string['backgroundsize'] = 'Hintergrundgröße';
$string['backgroundsize_help'] = 'Das Hintergrundbild wird in dieser Größe angezeigt';
$string['badgecolorfield'] = 'Farbfeld des Badges';
$string['badgecolorfield_help'] = 'Wählen Sie ein Feld aus, das die Farben für die Badges der Timeline-Elemente zurückgibt.';
$string['badges'] = 'Badges';
$string['badgestitle'] = 'Badges';
$string['between'] = 'Zwischen';
$string['blockcontext'] = 'Block';
$string['blocksnotfound'] = 'Das aktuelle Dashboard enthält keine Blöcke.';
$string['blocktitle'] = 'Blocktitel';
$string['blocktitle_help'] = 'Titel, der in der Blocküberschrift angezeigt wird. Geben Sie einen kurzen und aussagekräftigen Titel für das ein, was dieser Block anzeigt.';
$string['blockwidth'] = 'Blockbreite';
$string['bodyfield'] = 'Body-Feld';
$string['bootstrapversion'] = 'Bootstrap-Version des Designs';
$string['bootstrapversion_desc'] = 'Wählen Sie die Bootstrap-Version Ihres Designs. Moodle verwendet im Allgemeinen die Version 4 und Totara die Version 3.';
$string['border'] = 'Rahmen';
$string['border_help'] = 'Wert der CSS-Rahmeneigenschaft.';
$string['border_option'] = 'Rahmen anzeigen';
$string['border_option_help'] = 'Sie können den Rahmen des Dash-Blocks hinzufügen.';
$string['bordervalue'] = 'Wert des Rahmens';
$string['buildown'] = 'Einen eigenen bauen';
$string['buildown_help'] = 'Datenquellen sind hochgradig konfigurierbar. Sie können die Datenquellen für verschiedene Zwecke verwenden. Filter-, Sortier- und Paginierungsfunktionen werden unterstützt';
$string['buynow'] = 'Jetzt kaufen';
$string['campaign'] = 'Kampagne';
$string['categories'] = 'Kategorien';
$string['categories_help'] = 'Die Quelle der Datenquellen-Kategorien enthält die verfügbaren Kategorien';
$string['category'] = 'Name der Kategorie';
$string['categorycoursecount'] = 'Anzahl der Kurse';
$string['categoryimage'] = 'Kategoriebild';
$string['categoryimagelink'] = 'Link zur Kategorie';
$string['categoryimageurl'] = 'URL des Kategoriebilds';
$string['categoryimgcategory'] = 'Bild für die Kategorie {$a->category}';
$string['categoryimgdesc'] = 'Bilder für die Kategorien hinzufügen';
$string['categoryimgfallback'] = 'Fallback-Bild für die Kategorie';
$string['categoryimgfallbackdesc'] = 'Laden Sie das Bild für das Standard-Fallback der Kategorien hoch. Wenn neue Kategorien erstellt werden, wird das Fallback-Bild angezeigt, bis ein neues Bild für die Kategorie hinzugefügt wird.';
$string['categoryimgheading'] = 'Kategoriebild';
$string['categoryimgheadingsub'] = 'Kategoriebilder';
$string['categoryurl'] = 'Kategorie-URL';
$string['centerMode'] = 'Zentrierter Modus';
$string['centerMode_help'] = 'Ermöglicht eine zentrierte Ansicht mit teilweise angezeigten vorherigen/nächsten Folien. Verwendung mit ungeraden Anzahl Slides.';
$string['centerPadding'] = 'Zentrierter Abstand (px)';
$string['centerPadding_help'] = 'Seitlicher Abstand wenn im zentrierten Modus (px).';
$string['centerbottom'] = 'Mittig unten';
$string['centercenter'] = 'Mittig halbe Höhe';
$string['centertop'] = 'Mittig oben';
$string['certificatecodelinked'] = 'Code mit Link';
$string['choosedatasource'] = 'Datenquelle wählen';
$string['choosefeature'] = 'Feature wählen';
$string['choosefilter'] = 'Filter wählen';
$string['chooseskill'] = 'Skill wählen';
$string['circlepath'] = 'Kreis';
$string['cohorts'] = 'Globale Gruppen';
$string['columns'] = 'Spalten';
$string['columns_help'] = 'Die Anzahl der Spalten, die pro Zeile im Raster angezeigt werden sollen.';
$string['competencyframework'] = 'Kompetenzframework';
$string['competencyimage'] = 'Kompetenz-Bild';
$string['completedactivities'] = 'Abgeschlossene Aktivitäten';
$string['completedcourse'] = 'Abgeschlossene Kurse';
$string['completedlearningpath'] = 'Lernpfad abgeschlossen. Gute Arbeit!';
$string['completion:completed'] = 'Abgeschlossen';
$string['completion:inprogress'] = 'In Bearbeitung';
$string['completion:notstarted'] = 'Noch nicht begonnen';
$string['conditionaddfields'] = '{no} Bedingung(en) hinzufügen';
$string['conditionsection'] = 'Bedingungs-Setup';
$string['conditionstatichdr'] = 'Bedingung #0';
$string['conditionvalue'] = 'Wert';
$string['confirmleavegroup'] = 'Möchten Sie die Gruppe {$a} wirklich verlassen?';
$string['contacts'] = 'Kontakte';
$string['contentdisplayallpage'] = 'Alle Seiten';
$string['contentdisplaysection'] = 'Abschnittsseiten';
$string['contenteditor'] = 'Inhalt';
$string['contentsectiondisplay'] = 'Abschnitte anzeigen';
$string['contentsections'] = 'Anzuzeigende Abschnitte';
$string['contextcategory'] = 'Kategorie';
$string['contextcourse'] = 'Kurs';
$string['contextid'] = 'Kontext';
$string['contextid_help'] = 'Der Kontext für dieses Dashboard. Wählen Sie einen bestimmten Kurs, wenn Sie die Datenergebnisse einschränken möchten (Beispiel: Filter "Aktueller Kurs"). Ansonsten wählen Sie "System" für allgemeine Zwecke.';
$string['contextlinked'] = 'Kontext mit Link';
$string['contextmissing'] = 'Fehlender Kontext';
$string['contextsystem'] = 'System';
$string['contexttype'] = 'Kontexttyp';
$string['contexturl'] = 'Kontext-URL';
$string['course_enrolments:abovecourseform'] = 'Über den Kursen';
$string['course_enrolments:belowcourseform'] = 'Unter den Kursen';
$string['course_enrolments:disabled'] = 'Deaktiviert';
$string['course_enrolments:progress'] = 'Fortschritt anzeigen';
$string['coursebutton'] = 'Kursbutton';
$string['coursecatcontext'] = 'Kurskategorie';
$string['coursecategories'] = 'Kursbereiche';
$string['coursecontent'] = 'Kurskontext';
$string['coursecontext'] = 'Kurs';
$string['coursedata:past'] = 'Vergangenheit';
$string['coursedate:future'] = 'Zukunft';
$string['coursedate:present'] = 'Gegenwart';
$string['coursedates'] = 'Kursdaten';
$string['coursefullname'] = 'Vollständiger Name des Kurses';
$string['courseidnumber'] = 'ID-Nummer des Kurses';
$string['courseimage'] = 'Standardbild für den Kurs';
$string['courseimagedesc'] = 'Hier können Sie ein Platzhalterbild hochladen, das als Kursbild angezeigt werden soll, falls in den Kurseinstellungen kein Kursbild existiert.';
$string['courseimagelink'] = 'Kursbild mit Link zum Kurs';
$string['courseinformation'] = 'Kursinformation';
$string['courseoverviewfilesurl'] = 'URL des Kursbilds';
$string['courseshortname'] = 'Kurs-Kurzname';
$string['coursestafftitle'] = 'Lehrpersonal';
$string['coursestartdate'] = 'Kursbeginn';
$string['coursestartdate_asc'] = 'Nach Kursbeginn (neuesten zuerst)';
$string['coursestartdate_desc'] = 'Nach Kursbeginn (ältesten zuerst)';
$string['coursesummary'] = 'Kurszusammenfassung';
$string['courseurl'] = 'Kurs-URL';
$string['createcustomlayout'] = 'Nutzerdefiniertes Layout erstellen';
$string['createdashboard'] = 'Dashboard erstellen';
$string['createlayout'] = 'Nutzerdefiniertes Layout erstellen';
$string['cssclass'] = 'CSS-Klasse';
$string['cssclass_help'] = 'Verwenden Sie eine nutzerdefinierte CSS-Klasse, um mehrere Klassen anzuwenden.';
$string['ctalink'] = '"Call to action"-Link';
$string['currentcategory'] = 'Aktuelle Kategorie';
$string['currentcourse'] = 'Aktueller Kurs';
$string['currentcoursecontext'] = 'Aktueller Kurskontext';
$string['custom'] = 'Nutzerdefiniert';
$string['customdatasource'] = 'Nutzerdefinierte Datenquelle';
$string['customdatasourcedeleted'] = 'Nutzerdefinierte Datenquelle gelöscht';
$string['customdatasources'] = 'Nutzerdefinierte Datenquellen';
$string['customfield'] = '{$a->name}';
$string['customfields'] = 'Nutzerdefinierte Felder';
$string['customlayoutcreated'] = 'Nutzerdefiniertes Layout <b>{$a->name}</b> erfolgreich erstellt.';
$string['customlayoutdeleted'] = 'Nutzerdefiniertes Layout <b>{$a->name}</b> erfolgreich gelöscht.';
$string['customlayoutedited'] = 'Nutzerdefiniertes Layout <b>{$a->name}</b> erfolgreich bearbeitet.';
$string['customsqlfield'] = 'SQL-Felder';
$string['customsqlselect'] = 'SQL-Abfrage';
$string['customurl'] = 'Nutzerdefinierte URL';
$string['customurltext'] = 'Nutzerdefinierter URL-Text';
$string['dash:managedatasource'] = 'Datenquellen verwalten';
$string['dash:managewidget'] = 'Widgets verwalten';
$string['dash:mygroups_view'] = 'Meine eigenen Gruppen ansehen';
$string['dashaddoncontentdesc'] = 'Wählen Sie aus den folgenden Layouts';
$string['dashbgimg'] = 'Hintergrundbild';
$string['dashbgimg_help'] = 'Dieses Hintergrundbild wird als Hintergrund für das Dashboard verwendet.';
$string['dashboard'] = 'Dashboard';
$string['dashboardcreated'] = 'Dashboard <b>{$a->name}</b> erfolgreich angelegt';
$string['dashboarddeleted'] = 'Dashboard <b>{$a->name}</b> erfolgreich gelöscht';
$string['dashboardduplicated'] = 'Dashboard erfolgreich dupliziert';
$string['dashboardedited'] = 'Dashboard <b>{$a->name}</b> erfolgreich bearbeitet';
$string['dashboardlink'] = 'Link zum Dashboard';
$string['dashboards'] = 'Dashboards';
$string['dashicon'] = 'Icon';
$string['dashthumbnailimg'] = 'Thumbnail-Bild';
$string['dashthumbnailimg_help'] = 'Dieses Thumbnail-Bild wird nur in der Datenquelle Dashboards angezeigt';
$string['dashthumbnailimgurl'] = 'URL des Thumbnail-Bilds';
$string['datasource'] = 'Datenquelle';
$string['datasource:completion_widget'] = 'Kursabschlusswidget';
$string['datasource:completions_data_source'] = 'Kursabschlüsse';
$string['datasource:courses_data_source'] = 'Kurse';
$string['datasource:courses_data_source_help'] = 'Liste der verfügbaren Kurse für die aktuelle Person';
$string['datasource:dashboard_data_source'] = 'Dashboards';
$string['datasource:dashboard_data_source_help'] = 'Liste der Dashboards';
$string['datasource:enrolments_widget'] = 'Einschreibewidgets';
$string['datasource:logstore_data_source'] = 'Logdaten der Website';
$string['datasource:logstore_data_source_help'] = 'Datenquelle von Logdaten der Website';
$string['datasource:roleassignments_data_source'] = 'Rollenzuweisungen';
$string['datasource:sections_widget'] = 'Kursabschnittswidget';
$string['datasourcename'] = 'Name der Datenquelle';
$string['datasources'] = 'Datenquellen';
$string['datecompleted'] = 'Datum des Abschlusses';
$string['daysuntilend'] = 'Tage bis Kursende';
$string['defaultsortdirection'] = 'Sortierreihenfolge';
$string['defaultsortfield'] = 'Sortieren nach';
$string['defaultsortfield_help'] = 'Sortiert die Datenbankergebnisse nach diesem Feld. Wenn das Layout die Sortierung nach Nutzer/innen unterstützt, ist dies die Standardeinstellung.';
$string['delete'] = 'Löschen';
$string['deletecondition'] = 'Diese Bedingung löschen';
$string['deleteconfirm'] = 'Möchten Sie wirklich das Dashboard <b>{$a->name}</b> löschen?';
$string['deleteconfirmcustomdatasource'] = 'Möchten Sie die nutzerdefinierte Datenquelle <b>{$a->name}</b> wirklich löschen?';
$string['deleteconfirmcustomlayout'] = 'Möchten Sie wirklich das nutzerdefinierte Layout <b>{$a->name}</b> löschen?';
$string['deletecustomdatasource'] = 'Nutzerdefinierte Datenquelle löschen';
$string['deletecustomlayout'] = 'Nutzerdefiniertes Layout löschen';
$string['deletedashboard'] = 'Dashboard löschen';
$string['deletefield'] = 'Dieses Feld löschen';
$string['desc'] = 'DESC';
$string['description'] = 'Beschreibung';
$string['designercustombgposition'] = 'Nutzerdefinierte Hintergrundposition';
$string['designercustombgsize'] = 'Nutzerdefinierte Hintergrundgröße';
$string['desktop_learningpath'] = 'Lernpfad für Desktop';
$string['details_area'] = 'Detailbereich';
$string['details_area_help'] = 'Wählen Sie, wie der Detailbereich angezeigt werden soll.';
$string['details_area_size_help'] = 'Wählen Sie, in welcher Größe der Detailbereich angezeigt werden soll.';
$string['details_bg_color'] = 'Hintergrundfarbe der Details';
$string['details_footer_left'] = 'Details Footer links';
$string['details_footer_right'] = 'Details Footer rechts';
$string['details_text_color'] = 'Textfarbe der Details';
$string['developerfield'] = '{$a}';
$string['developerfieldid'] = 'ID';
$string['disableall'] = 'Jede Dash-Ausgabe deaktivieren';
$string['disableall_help'] = 'Warnung: Zur Fehlersuche oder zur Behebung von Fehlern auf den Seiten';
$string['disableallmessage'] = 'Die Dash-Ausgabe ist deaktiviert. Prüfen Sie die Dash-Einstellungen.';
$string['disabled'] = 'Deaktiviert';
$string['displaycta'] = '"Call to action" anzeigen';
$string['donut'] = 'Ringdiagramm';
$string['downloadcsv'] = 'Im CSV-Format herunterladen';
$string['duedate'] = 'Fälligkeitsdatum';
$string['edit'] = 'Bearbeiten';
$string['editcontent'] = 'Inhalt bearbeiten';
$string['editcustomdatasource'] = 'Datenquelle bearbeiten';
$string['editcustomlayout'] = 'Nutzerdefiniertes Layout bearbeiten';
$string['editdashboard'] = 'Dashboard bearbeiten';
$string['edituserenrolment'] = 'Die Einschreibungen von {$a} bearbeiten';
$string['emptystateheading'] = 'Leerer Zustand';
$string['enableconditions'] = 'Bedingungen aktivieren';
$string['enabledconditions'] = 'Daten einschränken auf';
$string['enabledfields'] = 'Aktivierte Felder';
$string['enabledfilters'] = 'Aktivierte Filter';
$string['enabledownload'] = 'Daten exportieren';
$string['enabledownload_help'] = 'Diese Einstellung ermöglicht es Nutzer/innen, die Daten sowohl im CSV- als auch im XLS-Format herunterzuladen.';
$string['enablejoins'] = 'Joins aktivieren';
$string['enroldate_asc'] = 'Nach Datum der Einschreibung (älteste zuerst)';
$string['enroldate_desc'] = 'Nach Datum der Einschreibung (jüngste zuerst)';
$string['enroldetails'] = 'Einschreibedetails';
$string['enroled'] = 'Eingeschrieben';
$string['enrollment'] = 'Einschreibung';
$string['enrollment_options'] = 'Einschreibungs-Optionen';
$string['enrollmentmethod'] = 'Einschreibemethode';
$string['enrollmentmethodstatus'] = 'Status der Einschreibemethode';
$string['enrollmentoptions'] = 'Einschreibemethoden';
$string['enrollmentoptions:free'] = 'Kostenlos';
$string['enrollmentoptions:seeoptions'] = 'Optionen ansehen';
$string['enrollments'] = 'Einschreibungen';
$string['enrollmentself'] = 'Selbsteinschreibungen';
$string['enrollmentsnotself'] = 'Fremdeinschreibungen';
$string['enrollmentstatus'] = 'Einschreibestatus';
$string['enrollmenttimeend'] = 'Einschreibeende';
$string['enrolmentmethod'] = 'Einschreibemethode';
$string['enrolmentoptions'] = 'Einschreibeoptionen';
$string['enrolnow'] = 'Jetzt einschreiben';
$string['event:description'] = 'Beschreibung';
$string['event:enddate'] = 'Enddatum';
$string['event:filterdate'] = 'Datum';
$string['event:status'] = 'Status';
$string['event:typecategory'] = 'Kurskategorie';
$string['event:typecourse'] = 'Kurs';
$string['event_desc_core_event_user_enrolment_created'] = '{$a->relateduserfullname} war in <a href="{$a->eventurl}" title="{$a->contextname} ansehen">{$a->contextname}</a> eingeschrieben';
$string['event_desc_generic'] = '{$a->userfullname} {$a->action} <a href="{$a->eventurl}" title="{$a->contextname} ansehen">{$a->contextname}</a>';
$string['eventactivity:both'] = 'Nicht abgeschlossene und abgeschlossene Aktivitäten';
$string['eventactivity:incomplete'] = 'Nur nicht abgeschlossene Aktivitäten';
$string['eventbutton'] = 'Termin-Button';
$string['eventclass'] = 'Termin-Klasse';
$string['eventcolor'] = 'Termin-Farbe';
$string['eventcontext'] = 'Kontext des Termins';
$string['eventdescription'] = 'Termin-Beschreibung';
$string['eventicon'] = 'Termin-Icon';
$string['eventlink'] = 'Termin-Link';
$string['events'] = 'Termine';
$string['eventstatus'] = 'Status des Termins';
$string['eventtime'] = 'Zeitpunkt des Termins';
$string['eventurl'] = 'Termin-URL';
$string['extralargeimage'] = 'Extragroßes Bild';
$string['field'] = 'Feld';
$string['field:completedactivitiesinweek'] = 'Abgeschlossene Aktivitäten diese Woche';
$string['field:completedcourses'] = 'Abgeschlossene Kurse';
$string['field:completedcoursesinweek'] = 'Diese Woche abgeschlossene Kurse';
$string['field:courseimgsize'] = 'Größe des Kursbilds';
$string['field:enrolledprogress'] = 'Abgeschlossene Kurse/Kurse insgesamt';
$string['field:orderby'] = 'Sortieren nach';
$string['field:orderby_help'] = 'Sortieren nach';
$string['field:orderdirection'] = 'Sortierrichtung';
$string['field:orderdirection_help'] = 'Sortierrichtung';
$string['fieldcustomdata'] = 'Zusätzlicher Formatwert';
$string['fieldcustomdata_help'] = 'Geben Sie die zusätzlichen Daten zum ausgewählten Attribut ein.
<b>Beispiel:</b>
1. Geben Sie für das Link-Attribut den Link ein und verwenden Sie die Feldwerte als Parameter.
2. Verwenden Sie für das Prozent-Attribut den Outof-Wert. Für die Noten verwenden Sie 10, andernfalls 100.';
$string['fieldname'] = 'Feldname';
$string['fieldnotfound'] = 'Feld nicht gefunden';
$string['fields'] = 'Felder';
$string['fieldselect'] = 'SQL-Select für das Feld';
$string['fieldssection'] = 'Felder-Setup';
$string['fieldstatichdr'] = 'Feld #0';
$string['fieldtransformdata'] = 'Das Format transformieren';
$string['fieldtransformdata_help'] = 'Bei der Anzeige des Wertes in der Tabelle das Format transformieren';
$string['fontcolor'] = 'Schriftfarbe';
$string['footercontent'] = 'Footer-Inhalt';
$string['footercontent_help'] = 'Inhalt, der im Block-Footer angezeigt wird.';
$string['footerfield'] = 'Footer-Feld';
$string['footerrightfield'] = 'Footer-Feld (rechts)';
$string['fullnamelinked'] = 'Vollständiger Name mit Link zum Profil';
$string['generalsettings'] = 'Allgemeine Einstellungen';
$string['generateattributes'] = 'Feld-Attribute generieren';
$string['generatefields'] = 'Felder generieren';
$string['gotoevent'] = 'Zum Termin gehen';
$string['groupby'] = 'Gruppieren nach';
$string['headercontent'] = 'Header-Inhalt';
$string['headercontent_help'] = 'Inhalt, der im Block-Header angezeigt wird.';
$string['headerfooter'] = 'Header & Footer';
$string['headingfield'] = 'Überschriftenfeld';
$string['hidden'] = 'Verborgen';
$string['hidemycourses'] = 'Kurse verbergen, in die ich eingeschrieben bin';
$string['hideshow'] = 'Verbergen/Anzeigen';
$string['hidetable_help'] = 'Wenn diese Option aktiviert ist, können Nutzer/innen den Tabelleninhalt in der Dash-Instanz ausblenden. Nur die Kopf- und Fußzeilenblöcke bleiben sichtbar.';
$string['hidewhenempty'] = 'Verbergen, wenn leer';
$string['hidewhenempty_desc'] = 'Den Dash-Block ausblenden, wenn er leer ist.';
$string['iconfield'] = 'Icon-Feld';
$string['imageoverlayfield'] = 'Label auf Kursbild';
$string['imageoverlayfield_help'] = 'Inhalt wird als Label auf dem Kursbild mit farbigem Hintergrund angezeigt';
$string['imageurlfield'] = 'Feld für die Bild-URL';
$string['imageurlfield_help'] = 'Wählen Sie ein Bild-URL-Feld, das in jeder Karte im Raster verwendet werden soll.';
$string['incomplete'] = 'Nicht abgeschlossen';
$string['label:completedactivitiesinweek'] = 'Abgeschlossene Aktivitäten diese Woche';
$string['label:completedcourses'] = 'Abgeschlossene Kurse';
$string['label:completedcoursesinweek'] = 'Abgeschlossene Kurse diese Woche';
$string['label:earnedandtotalpoints'] = 'Erworbene Punkte/Punkte insgesamt';
$string['label:enrolledprogress'] = 'Abgeschlossene Kurse';
$string['label:numberofcontactreq'] = 'Kontaktanfragen';
$string['label:teammemberscount'] = 'Teammitglieder';
$string['largeimage'] = 'Großes Bild';
$string['layout'] = 'Layout';
$string['layoutaccordion2'] = 'Akkordeon-Layout';
$string['layoutcards'] = 'Raster-Layout';
$string['layoutgrid'] = 'Tabellen-Layout';
$string['leanringpath_infocontent'] = 'Sie haben <b>{$a->completed}</b> von <b> {$a->total} </b> Kursen abgeschlossen. Der nächste Kurs in diesem Lernpfad ist: <b> {$a->nextcourse}</b>';
$string['learningpath:path'] = 'Pfad';
$string['leftbottom'] = 'Links unten';
$string['leftcenter'] = 'Links halbe Höhe';
$string['lefttop'] = 'Links oben';
$string['maindashboard'] = 'Hauptdashboard';
$string['maintable'] = 'Haupttabelle <b>(mnt)</b> auswählen';
$string['maintable_help'] = 'Wählen Sie die Haupttabelle für die Erzeugung der Felder';
$string['maintablenotconfigured'] = 'Die Haupttabelle ist nicht als Entwicklerdatenquelle konfiguriert';
$string['managedashaddonplugins'] = 'Addons verwalten';
$string['managedashboards'] = 'Dashboards verwalten';
$string['managelayouts'] = 'Layouts verwalten';
$string['masonrycustomfield'] = 'Dash Einstellungen';
$string['maxlimit'] = 'Begrenzen auf';
$string['maxlimit_help'] = 'Höchstgrenze der angezeigten Abfrageergebnisse';
$string['mediumimage'] = 'Mittelgroßes Bild';
$string['menu'] = 'Menüreihenfolge';
$string['missingdatasource'] = 'Die Datenquellen fehlen. Bitte überprüfen Sie diese.';
$string['mobile_learningpath'] = 'Lernpfad für Mobile';
$string['modifieddate'] = 'Zuletzt geändert';
$string['modulecontext'] = 'Module';
$string['modulename'] = 'Modulname';
$string['mustachetemplate'] = 'Mustache-Template';
$string['mydashboards'] = 'Meine Dashboards';
$string['myenrolledcourses'] = 'Kurse, in die ich eingeschrieben bin';
$string['myparticipants'] = 'Meine Teilnehmer/innen';
$string['myprofiletable'] = 'Profil';
$string['myskills'] = 'Meine Skills';
$string['nocourselearnigpath'] = 'Es wurden noch keine Kurse zum Lernpfad hinzugefügt.';
$string['nocourses'] = 'Keine Kurse verfügbar';
$string['nogroupsavailable'] = 'Keine Gruppen verfügbar';
$string['none'] = 'Keine';
$string['notavailable'] = 'Nicht verfügbar';
$string['operator'] = 'Operator';
$string['operatorcondition'] = 'Bedingung';
$string['operatorequal'] = '=';
$string['operatorgreaterthan'] = '>';
$string['operatorgreaterthanequal'] = '>=';
$string['operatorin'] = 'IN (...)';
$string['operatorinquery'] = 'IN (Query)';
$string['operatorlessthan'] = '<';
$string['operatorlessthanequal'] = '<=';
$string['operatorlike'] = 'LIKE';
$string['operatorlikebetween'] = 'LIKE %..%';
$string['operatornotequal'] = '!=';
$string['operatornotin'] = 'NOT IN (...)';
$string['operatornotlike'] = 'NOT LIKE';
$string['originalrolename'] = 'Ursprünglicher Name';
$string['otheraddons'] = 'Andere Addons';
$string['pagination_summary'] = 'Zeigt {$a->limit_from} - {$a->limit_to} von {$a->total}';
$string['permissions'] = 'Zugang einschränken auf';
$string['permissionscohort'] = 'Globale Gruppe';
$string['permissionsrole'] = 'Rolle';
$string['perpage'] = 'Pro Seite';
$string['perpage_help'] = 'Anzahl der Karten, die im Raster pro Seite angezeigt werden sollen.';
$string['pictureofuserlinked'] = 'Nutzerbild mit Link zum Profil';
$string['placeholderfields'] = 'Platzhalterfelder';
$string['placeholderfields_help'] = 'Wählen Sie die Felder aus und verwenden Sie diese Felder im Feld zusätzliche benutzerdefinierte Werte mit {feldname}, diese werden durch die entsprechenden Werte ersetzt.';
$string['pluginname'] = 'Dash';
$string['privacy:metadata'] = 'Der Dash-Block zeigt nur Informationen zu Kursen an und speichert selbst keine Daten.';
$string['programimagelink'] = 'Programmbild mit Link';
$string['progress_help'] = 'Den Abschlussfortschritt des Kurses anzeigen';
$string['querytemplateinstructions'] = 'Platzhalter: <ul><li><b>%%SELECT%%</b> – Ersetzt durch alle Selects basierend auf Felddefinitionen. Fügen Sie keine eigenen Selects ein!</li><li><b>%%WHERE%%</b> – Ersetzt durch aus Filtern generierte Klauseln. Sie können problemlos weitere Klauseln hinzufügen, indem Sie nach %%WHERE%% ein AND anhängen.</li><li><b>%%GROUPBY%%</b> – Ersetzt durch Gruppierungsfelder abhängig von der Datenquelle.</li><li><b>%%ORDERBY%%</b> – Ersetzt durch Standardsortierung oder nutzerdefinierte Sortierung (z.B. durch Klicken auf die Spaltenüberschrift in einer Tabelle).</li></ul>';
$string['readymatewidgets_help'] = 'Verwenden Sie die untenstehenden Widgets. Widgets sind einfach zu verwenden, es müssen keine zusätzlichen Konfigurationen vorgenommen werden.';
$string['redirecttodashboard'] = 'Zum Dashboard weiterleiten';
$string['restrictaccess'] = 'Zugang einschränken';
$string['restrictaccessheading'] = 'Zugang einschränken';
$string['restrictbyactivitycompletion'] = 'Auf Aktivitätsabschlussstatus einschränken';
$string['restrictbycohort'] = 'Auf globale Gruppen einschränken';
$string['restrictbycoursecompletion'] = 'Auf Kursabschlussstatus einschränken';
$string['restrictbygrade'] = 'Auf Kursbewertung einschränken';
$string['restrictbygrade_help'] = 'Mit dieser Einstellung können Sie die Sichtbarkeit von Inhalten basierend auf der Kursbewertung einer Person im aktuellen Kurs steuern. Der Block ist nur sichtbar, wenn die Kursnote einer Person innerhalb des angegebenen Bereichs liegt.';
$string['restrictbygroup'] = 'Auf Kursgruppen einschränken';
$string['restrictbygroup_help'] = 'Mit dieser Einstellung können Sie die Sichtbarkeit von Inhalten basierend auf der Gruppenmitgliedschaft einer Person im aktuellen Kurs steuern. Nur Teilnehmer/innen, die Teil der ausgewählten Gruppen sind, können die Inhalte sehen.';
$string['restrictbyrole'] = 'Auf Rollen einschränken';
$string['restrictbyrole_help'] = 'Mit dieser Einstellung können Sie die Sichtbarkeit von Inhalten basierend auf der Rolle einer Person im aktuellen Kurs steuern. Nur Teilnehmer/innen, die die ausgewählten Rollen haben, können die Inhalte sehen.';
$string['restrictcurrentsection'] = 'Automatisch auf den aktuellen Abschnitt beschränken';
$string['restrictcurrentsection_desc'] = 'Wenn ein Dash-Block mit dem Content-Addon zu einer Seite mit einem Abschnitt hinzugefügt wird, wird er automatisch auf diesen Abschnitt beschränkt.';
$string['restrictrolecontext'] = 'Kontext';
$string['resumecourse'] = 'Kurs fortsetzen';
$string['resumelearningpath'] = 'Lernpfad fortsetzen';
$string['rightbottom'] = 'Rechts unten';
$string['rightcenter'] = 'Rechts halbe Höhe';
$string['righttop'] = 'Rechts oben';
$string['role_assignments'] = 'Rollenzuweisungen';
$string['savechanges'] = 'Änderungen speichern';
$string['setup'] = 'Setup';
$string['showheader'] = 'Header anzeigen';
$string['showheader_help'] = 'Den Blocktitel ausblenden, wenn Bearbeiten ausgeschaltet ist.';
$string['showhiddencourses'] = 'Verborgene Kurse anzeigen';
$string['skills'] = 'Skills';
$string['smallimage'] = 'Kleines Bild';
$string['smart_coursebutton'] = 'Smart Kursbutton';
$string['sortcoursestartdate'] = 'Kursbeginn';
$string['sortenrolmentdate'] = 'Datum der Einschreibung';
$string['source'] = 'Quelle';
$string['status:completed'] = 'Abgeschlossen';
$string['status:enrolled'] = 'Eingeschrieben';
$string['status:inprogress'] = 'In Bearbeitung';
$string['status:notcompleted'] = 'Nicht abgeschlossen';
$string['status:notenrolled'] = 'Nicht eingeschrieben';
$string['status:notyetstarted'] = 'Noch nicht begonnen';
$string['strcssclass'] = 'CSS-Klassen';
$string['strctaenrolment'] = 'Einschreibeseite ansehen';
$string['strcustom'] = 'Nutzerdefiniert';
$string['strdatasource'] = 'datasource';
$string['strdisabled'] = 'Deaktiviert';
$string['strgrid'] = 'Raster';
$string['strgridsize'] = 'Rastergröße';
$string['strinfo'] = 'Info';
$string['styleoptions'] = 'Stil-Optionen';
$string['styleoptions_help'] = 'Um individuelle Stile auf Elemente anzuwenden, können Sie nutzerdefinierte Felder verwenden. Wählen Sie die nutzerdefinierten Felder aus, die Sie als CSS-Klasse auf ein Rasterelement anwenden möchten. Hinweis: Sie müssen die CSS-Stile selbst erstellen, Dash verfügt nicht über vordefinierte CSS-Stile (wir planen jedoch, diese in der nächsten Version hinzuzufügen).';
$string['subheadingfield'] = 'Dachzeilenfeld';
$string['suggestcohort'] = 'Nutzer/innen vorschlagen, die in derselben globalen Gruppen sind';
$string['suggestcontacts'] = 'Vorgeschlagene Kontakte';
$string['suggestgroups'] = 'Nutzer/innen vorschlagen, die in denselben Gruppen sind';
$string['suggestinterests'] = 'Nutzer/innen vorschlagen, welche die gleichen Interessen haben';
$string['suggestion:cohort'] = 'Auch Mitglied von {$a->cohort}';
$string['suggestion:groups'] = 'In Ihrer Gruppe {$a->group}';
$string['suggestion:interest'] = 'Auch interessiert an {$a->interest}';
$string['suggestion:users'] = 'Empfohlen auf dieser Seite';
$string['supportsfieldvisibility'] = 'Sichtbarkeit der Unterstützungsfelder';
$string['supportsfieldvisibility_help'] = 'Wenn diese Option aktiviert ist, können Administrator/innen Felder bedingt aktivieren und deaktivieren.';
$string['supportsfiltering_help'] = 'Wenn diese Option aktiviert ist, ist das Filtern der Ergebnisse möglich. Dies wird von der Datenquelle übernommen.';
$string['supportspagination_help'] = 'Wenn diese Option aktiviert ist, werden die Ergebnisse automatisch paginiert. Eine Paginierungsleiste wird angezeigt.';
$string['supportssorting_help'] = 'Wenn diese Option aktiviert ist, ist Sortieren möglich (nur bei Tabellen).';
$string['system'] = 'System';
$string['systemcontext'] = 'System';
$string['tabconditions'] = 'Bedingungen';
$string['tabfields'] = 'Felder';
$string['tabfilters'] = 'Filter';
$string['tabgeneral'] = 'Allgemein';
$string['tablealias_c'] = 'Kurs';
$string['tablealias_cc'] = 'Kursbereich';
$string['tablealias_ccp'] = 'Kursabschluss';
$string['tablealias_dd'] = 'Dashboard';
$string['tablealias_e'] = 'Einschreibemethode';
$string['tablealias_g'] = 'Gruppe';
$string['tablealias_ra'] = 'Rollenzuweisung';
$string['tablealias_sl'] = 'Logdaten der Website';
$string['tablealias_tsk'] = 'Skills';
$string['tablejoinshdr'] = 'Tabellen verbinden';
$string['tablet_learningpath'] = 'Lernpfad für Tablet';
$string['tags'] = 'Tags';
$string['textcolor'] = 'Textfarbe';
$string['timemodified'] = 'Geändert um';
$string['timesinceevent'] = 'Zeit seit dem Termin';
$string['tinyimage'] = 'Extrakleines Bild';
$string['totalactivities'] = 'Aktivitäten insgesamt';
$string['totalactivitiescompletion'] = 'Aktivitäten insgesamt (abschlussrelevant)';
$string['totalpoints'] = 'Punkte insgesamt';
$string['totalprogress'] = 'Fortschritt insgesamt';
$string['transformformat'] = 'Format von {$a} transformieren';
$string['userprofilelink'] = 'Link zum Profil';
$string['users'] = 'Nutzer/innen';
$string['userscompleted'] = 'Nutzer/innen abgeschlossen';
$string['usersnotcompleted'] = 'Nutzer/innen nicht abgeschlossen';
$string['vertical'] = 'Vertikal';
$string['viewactivity'] = 'Aktivität ansehen';
$string['viewcourse'] = 'Zum Kurs';
$string['viewdetails'] = 'Details ansehen';
$string['viewprofile'] = 'Profile ansehen';
$string['widget'] = 'Widget';
$string['widget:course_completions'] = 'Kursabschlüsse';
$string['widget:course_completions_help'] = 'Kursfortschrittsbericht';
$string['widget:course_enrols'] = 'Einschreibewidgets';
$string['widget:course_enrols_help'] = 'Liste der eingeschriebenen Kurse mit Abschlussfortschritt anzeigen';
$string['widget:course_sections'] = 'Kursabschnitte';
$string['widget:course_sections_help'] = 'Verwenden Sie dieses Widget, um mühelos mit Ihren Kursabschnitten zu interagieren.';
$string['widget:groups:adduser'] = 'Nutzer/in hinzufügen';
$string['widget:groups:groupmembers'] = 'Mitglieder ansehen';
$string['widget:learningpath'] = 'Lernpfad';
$string['widget:learningpath_help'] = 'Liste der im Lernpfad verfügbaren Kurse.';
$string['widget:mycontacts'] = 'Meine Kontakte';
$string['widget:mygroups'] = 'Meine Gruppen';
$string['widget:mylearning_help'] = 'Liste der Kurse, die registrierte Nutzer/innen haben, mit grundlegenden Kursinformationen wie Trainer/innen und verfügbaren Badges sowie einer Liste der Kursabschnitte und -module';
$string['widget:myprofile'] = 'Mein Profil';
