<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_deepler', language 'de', version '4.1'.
 *
 * @package     local_deepler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['apikeytitle'] = 'API Key für DeepL Translate';
$string['apikeytitle_desc'] = 'Kopieren Sie Ihren API-Schlüssel von DeepL, um die maschinelle Übersetzung zu nutzen.';
$string['badsettings'] = 'Die Einstellung DeepL scheint unvollständig zu sein, wahrscheinlich fehlt der API-Schlüssel.
Fragen Sie Ihre/n Moodle-Administrator/in';
$string['canttranslate'] = 'Kann \'{$a}\' nicht in \'{$a}\' übersetzen, bitte wählen Sie eine andere Zielsprache';
$string['canttranslatesame'] = 'Beide Sprachen sind gleich:';
$string['contextdeepl'] = 'Kurskontext';
$string['contextdeepl_placeholder'] = 'Informieren Sie den Übersetzer (DeepL) über den Kontext, damit er kontextbezogener übersetzen kann... (experimentell)';
$string['deeplapidoc'] = 'siehe Einzelheiten in der Dokumentation von DeepL';
$string['deeplapidoctitle'] = 'API Einstellungen von DeepL';
$string['deeplapiexception'] = 'Die API von DeepL hat einen Fehler zurückgegeben';
$string['deepler:edittranslations'] = 'Kursübersetzungen in Deepl Übersetzer bearbeiten';
$string['deeplprotitle'] = 'DeepL Pro benützen?';
$string['deeplprotitle_desc'] = 'Wenn diese Option aktiviert ist, verwendet Deepl Übersetzer DeepL Pro anstelle der kostenlosen Version von DeepL.';
$string['doselecttarget'] = 'Wählen Sie bitte eine Zielsprache.';
$string['editbutton'] = 'Quelle direkt bearbeiten';
$string['errordbpartial'] = '{$a} der Felder wurden NICHT in der Datenbank gespeichert. Überprüfen Sie manuell vor Ort';
$string['errordbtitle'] = 'Datenbankfehler';
$string['errortoolong'] = '(Es könnte sein, dass der Text zu lang für das Feld ist... Prüfen Sie manuell vor Ort)';
$string['filters'] = 'Filter';
$string['formality'] = 'Anredeform';
$string['formalitydefault'] = 'standard';
$string['formalityless'] = 'informell';
$string['formalitymore'] = 'formell';
$string['formalitypreferless'] = 'informell bevorzugen';
$string['formalityprefermore'] = 'formell bevorzugen';
$string['glossaryid'] = 'Glossar-ID';
$string['glossaryid_placeholder'] = 'Glossar-ID, falls Sie eine haben ...';
$string['ignoretags'] = 'Zu ignorierende Tags';
$string['keepselected'] = 'Ausgewählt lassen';
$string['latexeascape'] = 'LaTeX escapen ($$LaTeXFormulas$$ nicht zum Übersetzen senden)';
$string['latexescapeadmin'] = 'Standardwert für LaTeX escapen
(in the courses translation page "Advanced Settings")';
$string['latexescapeadmin_desc'] = 'Set to true will check "escape LaTeX formulas, in the course translation form.
This will have the effect to enable by default the Non translation of LaTeX formulas in course (when set here to true).
Unchecking it here if your organisation rarely uses LaTeX formulas in the courses to slightly improve Deepler\'s performances.';
$string['modeltype'] = 'Modell';
$string['needsupdate'] = 'Needs update';
$string['nevertranslated'] = 'No \'{$a}\' translation yet';
$string['nodeeplpapi'] = ':-( Cannot connect to DeepL API. <br/>Check with your admin. Looks like there is a network issue.';
$string['nonsplittingtags'] = 'Nicht trennende Tags';
$string['notsupportedsource'] = 'Die Ausgangssprache, in der Sie sich befinden, wird von DeepL nicht unterstützt.';
$string['onomatopoeia'] = 'Autsch!!!';
$string['othersettingstitle'] = 'Andere Einstellungen';
$string['outlinedetection'] = 'XML Outline detection';
$string['pluginname'] = 'Deepl Übersetzer';
$string['pluginversion'] = 'Aktuelle Version';
$string['preescape'] = 'PRE html-Tag escapen';
$string['preescapeadmin'] = 'PRE html-Tag escapen';
$string['preescapeadmin_desc'] = 'Wenn diese Option aktiviertist, werden &lt;pre&gt;...&lt;/pre&gt; Inhalte nicht zur Übersetzung gesendet';
$string['preserveformatting'] = 'Formatierung beibehalten';
$string['privacy:metadata'] = 'Das Deepl Übersetzer Plugin speichert keine personenbezogenen Daten.';
$string['saveall'] = 'Alle&nbsp;speichern';
$string['saveallexplain'] = 'Batch save to database all selected translations.';
$string['saveallmodalbody'] = '<div class="spinner-border text-primary" role="status"><span class="sr-only">Saving...</span>\\n</div>
<p>Please wait ...<br/>When all fields are saved in the database,<br/>I will automatically close</p>
<p>If you are impatient, and want to close this window,
<br/>make sure all selected translation\'s statuses are <i class="fa fa-database" aria-hidden="true"></i></p>';
$string['saveallmodaltitle'] = 'Saving translations to the database';
$string['scannedfieldsize'] = 'Minimale Textfeldgröße';
$string['scannedfieldsize_desc'] = 'Kleine Textfelder sind in der Datenbank oft in der Grösse begrenzt. Der Textinhalt wächst recht schnell
 (plus die mlang-Tags) bei jedem Übersetzungsschritt.
 Nach der Übersetzung, wenn der Text zu groß ist, wird die Datenbank einen Fehler werfen. Legen Sie die Größe hier auf der Grundlage Ihrer wichtigsten Spracheigenschaften und
 der Anzahl der Sprachen, die Ihr Moodle unterstützt fest.';
$string['seesetting'] = 'Erweiterte Einstellungen';
$string['selectall'] = 'Alle';
$string['selecttargetlanguage'] = 'Zielsprache <em>{mlang {$a}}</em>';
$string['showhiddenforstudents'] = '"{$a}" anzeigen';
$string['sourcelang'] = 'Ausgangssprache <em>{mlang other}</em>';
$string['specialsourcetext'] = 'Eine andere Quelle als "{$a}" benützen';
$string['splitsentences'] = 'Sätze trennen?';
$string['splitsentences0'] = 'überhaupt kein Trennen';
$string['splitsentences1'] = 'Trennung bei Satzzeichen und Zeilenumbrüchen';
$string['splitsentencesnonewlines'] = 'Trennung nur bei Satzzeichen, Zeilenumbrüche ignorieren';
$string['splittingtags'] = 'Trennende Tags';
$string['statusfailed'] = 'Fehlgeschlagen';
$string['statussaved'] = 'Gespeichert';
$string['statussuccess'] = 'Erfolgreich';
$string['statustosave'] = 'Dies speichern';
$string['statustotranslate'] = 'Bereit zur Übersetzung';
$string['statuswait'] = 'Nicht ausgewählt';
$string['taghandling'] = 'Tags behandeln als :';
$string['tagsplaceholder'] = 'Alle Tags auflisten (Tags mit Komma trennen &quot;,&quot;)';
$string['tour_advancedsettings00'] = 'Click here to see how you can fine tune the DeepL’s behaviour.<br/><br/>Click now to get a guided tour of the features.';
$string['tour_advancedsettings00title'] = 'Erweiterte Einstellungen von DeepL';
$string['tour_advancedsettings01formality'] = '<p>Sets whether the translated text should lean towards formal or informal language.
This feature currently only works for target languages <em>DE</em> (<strong>German</strong>), <em>FR</em> (<strong>French</strong>), <em>IT</em>
(<strong>Italian</strong>), <em>ES</em> (Spanish), <em>NL</em> (Dutch), <em>PL</em> (Polish), <em>PT-BR</em> and <em>PT-PT</em> (Portuguese),
<em>JA</em> (Japanese), and <em>RU</em> (Russian).
Learn more about the plain\\/polite feature for Japanese <a
href="https://support.deepl.com/hc/en-us/articles/6306700061852-About-the-plain-polite-feature-in-Japanese">here</a>.
Setting this parameter with a target language that does not support formality will fail, unless one of the&nbsp;
<em>prefer_...</em> options are used. Possible options are:</p>
<ul><li><em>default</em> (default)</li>
<li><em>more</em> - for a more formal language</li>
<li><em>less</em> - for a more informal language</li>
<li><em>prefer more</em> - for a more formal language if available, otherwise fallback to default formality</li>
<li><em>prefer less</em> - for a more informal language if available, otherwise fallback to default formality</li></ul>';
$string['tour_advancedsettings01formalitytitle'] = 'Formality management';
$string['tour_advancedsettings02split'] = '<p>Sets whether the translation engine should first split the input into sentences.
For text translations where <em>checked</em>, meaning the engine splits on punctuation and on newlines.</p>
<p>For text translations where <em>nonewlines</em>, meaning the engine splits on punctuation only, ignoring newlines.</p>';
$string['tour_advancedsettings02splittitle'] = 'Manage how sentences are split by line';
$string['tour_advancedsettings03formating'] = '<p>Sets whether the translation engine should respect the original formatting,
even if it would usually correct some aspects.</p>
<p>The formatting aspects affected by this setting include:</p>
<ul><li>Punctuation at the beginning and end of the sentence</li><li>Upper/lower case at the beginning of the sentence</li></ul>';
$string['tour_advancedsettings03formatingtitle'] = 'Manage formating';
$string['tour_advancedsettings04glossary'] = '<p>Specify the glossary to use for the translation.</p>
<p><em>(Glossaries have to be uploaded via the DeepL API. This is not available yet with this plugin. See with your IT).</em></p>';
$string['tour_advancedsettings04glossarytitle'] = 'Glossary';
$string['tour_advancedsettings05context'] = '<p>This additional context can potentially improve translation quality when translating short,
low-context source texts.</p><p>The <em>context</em> parameter is an <strong>alpha feature</strong>.</p>
<p>So try to add some context if you feel the translated results could be improved, but you should not rely on it.</p>';
$string['tour_advancedsettings05contexttitle'] = 'Contextual information that can influence a translation but is not translated itself.';
$string['tour_advancedsettings06tag'] = '<p>Sets which kind of tags should be handled.</p>
<p>By default, the translation engine does not take tags into account.</p>
<p>By setting the <em>tag handling</em> parameter to either <em>xml</em> or <em>html</em>,
the API will process the markup input by extracting the text out of the structure, splitting it into individual sentences,
translating them, and placing them back into the respective markup structure.</p>';
$string['tour_advancedsettings06tagtitle'] = 'Tag handling';
$string['tour_advancedsettings07outline'] = '<p>The automatic detection of the XML structure won’t yield best results in all XML files.
You can disable this automatic mechanism altogether by setting the <em>outline detection</em> parameter to <em>unchecked</em>
and selecting the tags that should be considered structure tags. This will split sentences using the <em>splitting tags</em> parameter.</p>';
$string['tour_advancedsettings07outlinetitle'] = 'How outline is detected in XML';
$string['tour_advancedsettings08skiptag'] = '<p>Comma-separated list of XML or HTML tags that indicate text not to be translated.</p>
<p>To ensure that elements in the original text are not altered in translation (e.g. trademarks or product names).</p>
<p>Expl: adding "x" in the list :</p><p>Request:<em> Please open the page &lt;x&gt;Settings&lt;/x&gt; to configure your system.</em></p>
<p>Response:<em>Bitte öffnen Sie die Seite &lt;x&gt;Settings&lt;/x&gt; um Ihr System zu konfigurieren.</em></p>
<p>In HTML you can also use the <code><strong>translate="no"</strong></code> attribute :</p>
<p><code>  &lt;body&gt;</code><br /><code>    &lt;h1&gt;My First Heading&lt;/h1&gt;</code><br /><code>    &lt;p
<strong>translate="no"</strong>&gt;This will not be translated.&lt;/p&gt;</code><br /><code>  &lt;/body&gt;</code></p>
<p></p>';
$string['tour_advancedsettings08skiptagtitle'] = 'Skip translating certain tags’ content.';
$string['tour_advancedsettings09splittag'] = '<p>Comma-separated list of XML or HTML tags which never split sentences.</p>';
$string['tour_advancedsettings09splittagtitle'] = 'Tags that should not be considered to split the sentences.';
$string['tour_advancedsettings101other'] = '<p>Hier teilen Sie dem Plugin mit, dass es die Übersetzung von LaTeX-Zeichenfolgen ($$...$$) und oder PRE HTML-Tags vermeiden soll.</p>';
$string['tour_advancedsettings101othertitle'] = 'LaTeX und/oder PRE-Tag-Escaping aktivieren';
$string['tour_advancedsettings10splittag'] = '<p>Kommagetrennte Liste von XML- oder HTML-Tags, die immer ein Aufteilen verursachen.</p>';
$string['tour_advancedsettings10splittagtitle'] = 'Tag, das den Text in Sätze aufteilt.';
$string['tour_advancedsettings11sourcelang'] = '<p>Die Ausgangssprache ist die Sprache, in der der Kurs geschrieben wurde.
Am besten ist es, die gleiche Sprache für den gesamten Kurs zu verwenden.</p>';
$string['tour_advancedsettings11sourcelangtitle'] = 'Ausgangssprache';
$string['tour_advancedsettings12targetlang'] = '<p>The target language is the one you will ask DeepL to return.</p>
<p>Obviuosly if you select the same language as the source the translation button is deactivated.</p>';
$string['tour_advancedsettings12targetlangtitle'] = 'Zielsprache';
$string['tour_advancedsettings13filters'] = '<p>These filter show/hide the textual content found in the course.</p>
<p><strong>Up to date:<br /></strong></p>
<p>These are the content that are already translated and that no change were made in the source.</p>
<p>They will appear with the <span class="badge badge-pill badge-success"> </span> indicator. </p>
<p><strong>Needs update:<br /></strong></p>
<p>These are the textual contents that were never translated or that were modified after being translated.</p>
<p>They appear with the <span class="badge badge-pill badge-danger"> </span> indicator when they were never translated. </p>
<p>They appear with the <span class="badge badge-pill badge-warning"> </span>
indicator when they were already translated but the source text change since.</p>';
$string['tour_advancedsettings13filterstitle'] = 'Translation status filters';
$string['tour_advancedsettings14filters'] = '<p>Clicking here selects all visible content to be sent for translation.</p>';
$string['tour_advancedsettings14filterstitle'] = 'Alle auswählen';
$string['tour_advancedsettings15filters'] = '<p>Real time status of the planned and the actual consumption of DeepL’s service (for the current month).</p>';
$string['tour_advancedsettings15filterstitle'] = 'DeepL API consumption status';
$string['tour_advancedsettings16sendtodeepl'] = '<p>Clinkg this button will send all selected texts to DeepL and feed it in the editors.</p>
<p>At least one selection is needed to ctivate it.</p>';
$string['tour_advancedsettings16sendtodeepltitle'] = 'Zu DeepL senden';
$string['tour_advancedsettings17statusbullet'] = '<p>This indicates the translation status with 3 color code.</p>
<p><span class="badge badge-pill badge-danger"> </span> This text was never translated.</p>
<p><span class="badge badge-pill badge-warning"> </span> This text was translated but there was a change made in the database since.</p>
<p><span class="badge badge-pill badge-success"> </span> This text was already translated and up to date.</p>
<p><span class="badge badge-pill badge-dark"> </span> Cannot get the translation status since <em>source</em> and <em>target</em> lang are the same.</p>';
$string['tour_advancedsettings17statusbullettitle'] = 'Translation status bullet icon.';
$string['tour_advancedsettings18selection'] = '<p>To send a content to DeepL to be translated, you would need to tick that checkbox.</p>';
$string['tour_advancedsettings18selectiontitle'] = 'Selection checkbox';
$string['tour_advancedsettings19editsource'] = '<p><span class="p-1 btn btn-sm btn-outline-info"><i class="fa fa-pencil"> </i>
</span> Clicking on the pencil will jump to the course editor in the Moodle course.</p>
<p>Should you have revisions of the source, or want to make any change, as you cannot change the source from here.</p>';
$string['tour_advancedsettings19editsourcetitle'] = 'Quelle direkt bearbeiten.';
$string['tour_advancedsettings20togglemultilang'] = '<p>When translations {mlang} tags are present, this button appears.</p>
<p><i class="fa fa-language"></i></p>
<p>Click on it to toggle the content and see what was already translated. If the current selected source language is found in the
MLANG tags then this is displayed in red to alert you that the tag will be overriden.</p>';
$string['tour_advancedsettings20togglemultilangtitle'] = 'Toggle mutlilang content.';
$string['tour_advancedsettings21secondsource'] = 'You can choose a secondary source for specific content. <br/>If there is yet no OTHER lang tag, it will save the source in its language plus OTHER.';
$string['tour_advancedsettings21secondsourcetitle'] = 'Secondary source language.';
$string['tour_advancedsettings22process'] = '<p>When a text content is not selected and no translation was requested. <i class="fa fa-ellipsis-h"></i> is shown.</p>
<p><i class="fa fa-hourglass-start"></i> is displayed when you selected it and it is waiting for you to press the "Translate" button to send it to DeepL.</p>
<p><i class="fa fa-floppy-o"></i> will display after the text was fed back in the adjacent text editor.<br />
You can review the translated content, make some changes then press the icon to actually save it in the database. <br /><br />
<em>Note</em> that you can also save to the database in batch by clicking on the save all floating button below. <br />
Should you want to save all tranlsated text but leave some to review later, you can uncheck it on the left so that it will be skiped when saving all.</p>
<p>Once a text is saved this icon will display <i class="fa-solid fa-database"></i></p>';
$string['tour_advancedsettings22processtitle'] = 'Translation process indicator (far right)';
$string['tour_advancedsettings23saveall'] = '<p>When translations are retrieved from DeepL, they are not automatically saved to the database.</p>
<p>This to ensure the basics of translation, that a review is made before being stored and automatically dispatched to the public.</p>
<p>So you can either save them one by one or by clicking on the save all button.</p>
<p>If there are some translations that you do not want save in the batch, just unselect them before clicking "save all"</p>';
$string['tour_advancedsettings23savealltitle'] = 'Save all translations to database.';
$string['translatebutton'] = 'Übersetzen &rarr; {$a}';
$string['translateexplain'] = 'Alle markierten Zeilen in {$a} übersetzen';
$string['translationdisabled'] = 'Die Übersetzung ist deaktiviert, da dies als Link in der Datenbank verwendet wird.';
$string['uptodate'] = 'Aktuell';
$string['viewsource'] = 'Check multilingual content.';
$string['viewsourcedisabled'] = 'Noch kein mehrsprachiger Inhalt.';
$string['warningsource'] = 'Watch out ! The current source language &quot;{$a}&quot; is already as a multilang tag along side with the fallback tag &quot;OTHER&quot;. Note that both will be merge as the &quot;OTHER&quot; multilang tag.';
$string['wordcountsentence'] = 'Total <span id="local_deepler__wc">0</span> words, <span id="local_deepler__wosc">0</span> characters (<span id="local_deepler__wsc">0</span> chars including spaces) DeepL\'s usage = <span id="local_deepler__used">0</span>/<span id="local_deepler__max">0</span>';
