<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'uk', version '4.1'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Перегляньте всі курси';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Ви ще не зараховані на жодні курси.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Перегляньте всі доступні курси нижче та почніть навчатися.';
$string['addon.block_myoverview.noresult'] = 'Ваш пошук не відповідає жодному курсу.';
$string['addon.block_myoverview.noresultdescription'] = 'Спробуйте налаштувати фільтри або перегляньте всі курси нижче.';
$string['addon.blog.errorloadentries'] = 'Помилка завантаження записів блогу.';
$string['addon.blog.showonlyyourentries'] = 'Показати лише ваші записи';
$string['addon.calendar.calendarevent'] = 'Подія календаря';
$string['addon.calendar.calendarevents'] = 'Події календаря';
$string['addon.calendar.calendarreminders'] = 'Календарні нагадування';
$string['addon.calendar.currentmonth'] = 'Поточний місяць';
$string['addon.calendar.defaultnotificationtime'] = 'Час сповіщень за-замовчуванням';
$string['addon.calendar.errorloadevent'] = 'Помилка завантаження події.';
$string['addon.calendar.errorloadevents'] = 'Помилка завантаження подій.';
$string['addon.calendar.noevents'] = 'Немає подій';
$string['addon.calendar.reminders'] = 'Нагадування';
$string['addon.calendar.setnewreminder'] = 'Встановіть нове нагадування';
$string['addon.competency.errornocompetenciesfound'] = 'Не знайдено компетенції';
$string['addon.competency.nocompetencies'] = 'Немає компетенції';
$string['addon.coursecompletion.complete'] = 'Завершити';
$string['addon.coursecompletion.couldnotloadreport'] = 'Не вдалося завантажити звіт про закінчення курсу, будь ласка, спробуйте ще раз пізніше.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Конфігурація пристроїв';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Ваші користувачі не отримують жодних сповіщень з цього сайту на своїх мобільних пристроях. Увімкніть мобільні сповіщення на сторінці налаштувань сповіщень.';
$string['addon.messages.contactlistempty'] = 'Список контактів порожній';
$string['addon.messages.contactname'] = 'Ім\'я контакту';
$string['addon.messages.deletemessage'] = 'Видалити повідомлення';
$string['addon.messages.deletemessageconfirmation'] = 'Ви впевнені, що хочете видалити це повідомлення? Його буде видалено лише з вашої історії повідомлень, і він все одно його зможе переглядати користувач, який надіслав або отримав повідомлення.';
$string['addon.messages.errordeletemessage'] = 'Помилка при видаленні повідомлення.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Помилка при отриманні контактів з сервера.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Помилка при отриманні обговорення з сервера.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Помилка при отриманні повідомлень від сервера.';
$string['addon.messages.errorwhileretrievingusers'] = 'Помилка під час отримання користувачів із сервера.';
$string['addon.messages.messagenotsent'] = 'Повідомлення не було відправлено, будь ласка, спробуйте ще раз пізніше.';
$string['addon.messages.newmessages'] = 'Нові повідомлення';
$string['addon.messages.nousersfound'] = 'Користувачів не знайдено';
$string['addon.messages.showdeletemessages'] = 'Показати повідомлення про видалення';
$string['addon.messages.type_blocked'] = 'Заблоковано';
$string['addon.messages.type_offline'] = 'Офлайн';
$string['addon.messages.type_online'] = 'Онлайн';
$string['addon.messages.type_search'] = 'Результати пошуку';
$string['addon.messages.type_strangers'] = 'Інші';
$string['addon.messages.useentertosenddescdesktop'] = 'Якщо вимкнено, ви можете використовувати Ctrl+Enter, щоб надіслати повідомлення.';
$string['addon.messages.useentertosenddescmac'] = 'Якщо вимкнено, ви можете використовувати Cmd+Enter, щоб надіслати повідомлення.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Не вдалося надіслати повідомлення в бесіду {{conversation}}. {{помилка}}';
$string['addon.messages.warningmessagenotsent'] = 'Неможливо відправити повідомлення до {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Будь ласка, прийміть заяву-згоду.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Ви не можете додати або змінити представлення в додатку, тому що ми не могли отримати заяву з сайту.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Деякі методи класифікації поки не підтримуються додатком і не можуть бути змінені.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Ви не можете подати заявку в програмі, оскільки заяву про подання неможливо отримати з сайту.';
$string['addon.mod_assign.duedateno'] = 'Немає терміну';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Ви не можете додавати або редагувати подання в програмі, оскільки деякі плагіни ще не підтримуються для редагування.';
$string['addon.mod_assign.errorshowinginformation'] = 'Ми не можемо відобразити інформацію представлення';
$string['addon.mod_assign.feedbacknotsupported'] = 'Цей зворотний зв\'язок не підтримується програмою і не може містити всю інформацію';
$string['addon.mod_assign.gradenotsynced'] = 'Оцінки не синхронізовані';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Учасники без представлення не показуються';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Є {{count}} чернеток.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Є {{count}} учасників.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Є {{count}} матеріалів, які потребують оцінки.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Надано {{count}} завдань.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Є {{count}} команд.';
$string['addon.mod_assign.submissionnotsupported'] = 'Це подання не підтримується програмою і не може містити всю інформацію';
$string['addon.mod_assign.syncblockedusercomponent'] = 'оцінка користувача';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Оцінку подання було змінено на сайті.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Представлення користувача було змінено на сайті.';
$string['addon.mod_chat.confirmloss'] = 'Ти впевнений? Історія чату може бути втрачена.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Помилка при підключенні до чату.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Помилка отримання даних чату.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Помилка отримання користувачів чату.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Помилка отримання повідомлень з серверу.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Помилка відправки повідомлення.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Ви повинні бути онлайн для відправки повідомлення';
$string['addon.mod_chat.nosessionsfound'] = 'Сеансів не знайдено';
$string['addon.mod_chat.showincompletesessions'] = 'Показати незавершені сеанси';
$string['addon.mod_choice.errorgetchoice'] = 'Помилка при отриманні даних виборки.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% користувачів вибрали пункт: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Ваша остання відповідь має бути синхронізована, перш ніж вона буде включена в результати.';
$string['addon.mod_data.edittagsnotsupported'] = 'На жаль, програма не підтримує редагування тегів.';
$string['addon.mod_data.errorapproving'] = 'Помилка схвалення або скасування запису.';
$string['addon.mod_data.errordeleting'] = 'Помилка видалення запису.';
$string['addon.mod_data.gettinglocation'] = 'Отримання місцезнаходження';
$string['addon.mod_data.locationnotenabled'] = 'Місцезнаходження не ввімкнено';
$string['addon.mod_data.locationpermissiondenied'] = 'У дозволі на доступ до вашого місцезнаходження відмовлено.';
$string['addon.mod_data.mylocation'] = 'Моє місцезнаходження';
$string['addon.mod_data.searchbytagsnotsupported'] = 'На жаль, програма не підтримує пошук за тегами.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Зворотній зв’язок за допомогою CAPTCHA неможливо завершити в автономному режимі, або якщо він не налаштований, або якщо сервер не працює.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Надіслано відповідей: {{count}}.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Цей відгук було збережено для надсилання пізніше.';
$string['addon.mod_feedback.questionscountdescription'] = 'Є {{count}} запитань.';
$string['addon.mod_folder.emptyfilelist'] = 'Немає файлів для показу';
$string['addon.mod_forum.errorgetforum'] = 'Помилка отримання даних форуму';
$string['addon.mod_forum.errorgetgroups'] = 'Помилка отримання групових налаштувань.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Не вдалося створити нове обговорення в усіх групах.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'На цьому форумі ще немає обговорень.';
$string['addon.mod_forum.group'] = 'Група';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} дискусій';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} відповідей';
$string['addon.mod_forum.refreshposts'] = 'Оновити пости з обговоренням';
$string['addon.mod_glossary.browsemode'] = 'Перегляд записів';
$string['addon.mod_glossary.byalphabet'] = 'По алфавіту';
$string['addon.mod_glossary.byauthor'] = 'Групувати за автором';
$string['addon.mod_glossary.bycategory'] = 'Групувати за категорією';
$string['addon.mod_glossary.bynewestfirst'] = 'Новіші перші';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Нещодавно оновлені';
$string['addon.mod_glossary.bysearch'] = 'Пошук';
$string['addon.mod_glossary.cannoteditentry'] = 'Неможливо редагувати запис';
$string['addon.mod_glossary.entriestobesynced'] = 'Записи будуть синхронізовані';
$string['addon.mod_glossary.entrypendingapproval'] = 'Цей запис очікує схвалення.';
$string['addon.mod_glossary.errorloadingentries'] = 'Сталася помилка під час завантаження записів.';
$string['addon.mod_glossary.errorloadingentry'] = 'Сталася помилка під час завантаження запису.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Сталася помилка під час завантаження глосарію.';
$string['addon.mod_glossary.noentriesfound'] = 'Немає записів';
$string['addon.mod_glossary.searchquery'] = 'Пошуковий запит';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Завантажте файл H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Помилка отримання даних про активність H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Пакет H5P не завантажено. Вам потрібно завантажити його, щоб мати можливість ним користуватися.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Пакет H5P був змінений після останнього завантаження. Вам потрібно завантажити його знову, щоб мати можливість ним користуватися.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Щоб переглянути пакет H5P, потрібно бути онлайн.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Переглянути спробу {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Показати опис';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Цей урок містить перехід на сторінку випадкового вмісту. Це не можна спробувати в програмі, доки її не буде запущено у веб-переглядачі.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Ця спроба не може бути переглянута, тому що ще одна спроба була закінчена.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Ця спроба була закінчена в автономному режимі.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Офлайн спроба була синхронізована. Ви хочете розглянути її?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Спроба була закінчена на сайті.';
$string['addon.mod_lti.errorgetlti'] = 'Помилка при отриманні даних модуля.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Цей URL не є дійсним.';
$string['addon.mod_lti.launchactivity'] = 'Запуск діяльності';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Помилка при завантаженні вмісту сторінки.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Ви можете спробувати виконати цей тест у програмі, але вам потрібно буде надіслати спробу в браузері з таких причин:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Ця спроба тесту не може бути представлена з наступних причин:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Ця спроба не була синхронізована з {{$a}}. Якщо відтоді ви продовжили цю спробу на іншому пристрої, ви можете втратити дані.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'При збереженні відповідей сталася помилка. Ви впевнені, що хочете залишити тест?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Не можна спробувати виконати цей тест в програмі, оскільки програма не підтримує поведінку запитання:';
$string['addon.mod_quiz.errordownloading'] = 'Помилка при завантаженні потрібних даних.';
$string['addon.mod_quiz.errorgetattempt'] = 'Помилка при отриманні даних спроби.';
$string['addon.mod_quiz.errorgetquestions'] = 'Помилка отримання питань.';
$string['addon.mod_quiz.errorgetquiz'] = 'Помилка при отриманні даних тесту.';
$string['addon.mod_quiz.errorparsequestions'] = 'Сталася помилка під час читання питання. Будь ласка, спробуйте цей тест в веб-браузері.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Цей тест не може бути вирішених в додатку, оскільки він може містити питання, які не підтримуються додатком:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Цей тест не може бути зроблений в додатку, оскільки він має правила доступу, що не підтримується додатком:';
$string['addon.mod_quiz.errorsaveattempt'] = 'При збереженні даних спроби сталася помилка.';
$string['addon.mod_quiz.finishnotsynced'] = 'Готово, але не синхронізовано';
$string['addon.mod_quiz.opentoc'] = 'Відкрити навігаційне повідомлення.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Offline спроби були відкинуті, так як вони були закінчені на сайті або не знайдені.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Деякі відповіді форуму були відкинуті, бо питання були змінені в Інтернеті.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Спроба незавершена, оскільки деякі офлайнові відповіді відхилено. Будь ласка, перегляньте свої відповіді, а потім повторіть спробу.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Цей тест містить запитання, які не підтримуються програмою:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Помилка при завантаженні вмісту.';
$string['addon.mod_resource.openthefile'] = 'Відкрити';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Цей файл змінився з моменту останнього відкриття.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Існує новіша версія цього файлу. Щоб побачити це, підключіть свій пристрій до Інтернету.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Оцінка не може бути обчислена.';
$string['addon.mod_scorm.dataattemptshown'] = 'Ці дані належать до спроби № {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Під час створення нової спроби в автономному режимі сталася помилка. Будь ласка спробуйте ще раз.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Помилка завантаження SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Помилка отримання SCORM-даних.';
$string['addon.mod_scorm.errorinvalidversion'] = 'На жаль, додаток підтримує тільки SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Завантаження SCORM пакетів відключене у вашому сайті Moodle. Будь ласка, зверніться до адміністратора сайту Moodle.';
$string['addon.mod_scorm.errornovalidsco'] = 'Це SCORM не має доступних SCO для завантаження.';
$string['addon.mod_scorm.errorpackagefile'] = 'На жаль, додаток підтримує тільки ZIP пакети.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Під час синхронізації сталася помилка. Будь ласка спробуйте ще раз.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Ця спроба має дані, що не були синхронізовані.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Ця спроба не може бути відправлена, так як ви перевищили максимальну кількість спроб.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Цей SCORM не завантажений. Він буде автоматично завантажуватися при його відкритті.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Цей SCORM був змінений з моменту останнього завантаження. Він буде автоматично завантажуватися при її відкритті.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Деякі офлайн-дані зі спроби {{number}} було відхилено, оскільки їх не можна було зарахувати як нову спробу.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Деякі спроби не вдалося синхронізувати із сайтом, оскільки остання онлайн-спроба ще не завершена. Будь ласка, спершу завершите онлайн-спробу.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'На жаль, існує проблема вашого представлення. Будь ласка спробуйте ще раз.';
$string['addon.mod_survey.errorgetsurvey'] = 'Помилка отримання даних опитування.';
$string['addon.mod_survey.results'] = 'Результати';
$string['addon.mod_url.accessurl'] = 'Доступ до URL';
$string['addon.mod_url.pointingtourl'] = 'Точки URL цього ресурсу';
$string['addon.mod_wiki.errorloadingpage'] = 'Сталася помилка під час завантаження сторінки.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Ця вікі ще не має ніякого змісту.';
$string['addon.mod_wiki.gowikihome'] = 'Перейти на Вікі головну';
$string['addon.mod_wiki.subwiki'] = 'Субвікі';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Заголовок не може бути порожнім';
$string['addon.mod_wiki.viewpage'] = 'Переглянути сторінку';
$string['addon.mod_wiki.wikipage'] = 'Вікі-сторінка';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Стратегія оцінки {{$a}} не підтримується';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Вам потрібно ввести назву.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Подання було змінено на сайті.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Оцінка була змінена на сайті.';
$string['addon.notes.warningnotenotsent'] = 'Неможливо додати нотатку до курсу {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Помилка отримання сповіщень';
$string['addon.notifications.notifications'] = 'Сповіщення';
$string['addon.notifications.playsound'] = 'Грати звук';
$string['addon.notifications.therearentnotificationsyet'] = 'Немає сповіщень';
$string['addon.privatefiles.couldnotloadfiles'] = 'Не вдалося завантажити список файлів.';
$string['addon.privatefiles.emptyfilelist'] = 'Немає файлів для показу.';
$string['addon.privatefiles.erroruploadnotworking'] = 'На жаль, зараз неможливо завантажити файли на ваш сайт.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Видалити всі завантажені дані сайту?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Видалити завантажені дані з усіх курсів?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Видалити всі завантажені дані з \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Завантаження курсу';
$string['addon.storagemanager.courseinfo'] = 'Завантажте вміст курсу, щоб працювати в автономному режимі. Ваша активність синхронізується автоматично, коли пристрій знову під’єднається до мережі.';
$string['addon.storagemanager.deleteallsitedata'] = 'Видалити всі завантажені дані сайту';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Буде видалено всі завантажені дані з \'{{name}}\', включаючи всі завантажені курси та дані, які дозволяють працювати офлайн.';
$string['addon.storagemanager.deletecourses'] = 'Видалити завантажені дані з усіх курсів';
$string['addon.storagemanager.deletedata'] = 'Видалити завантажені дані';
$string['addon.storagemanager.deletedatafrom'] = 'Видалити всі завантажені дані з \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Завантажені курси';
$string['addon.storagemanager.downloads'] = 'Завантаження';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Помилка видалення завантажених даних.';
$string['addon.storagemanager.managedownloads'] = 'Керуйте завантаженнями';
$string['addon.storagemanager.totaldownloads'] = 'Загальна кількість завантажень';
$string['addon.storagemanager.totalspaceusage'] = 'Всього використано місця';
$string['appstoredescription'] = 'Примітка: Це офіційний додаток Mobile Moodle буде працювати тільки з сайтами Moodle, які були створені та дозволений доступ. Будь ласка, зверніться до адміністратора Moodle, якщо у вас є які-небудь проблеми з підключенням.
Якщо ваш сайт Moodle був налаштований правильно, ви можете користуватися цією програмою для:

- перегляду вмісту ваших курсів, навіть в автономному режимі
- отримувати миттєві сповіщення про повідомлення та інші події
- швидко знайти і зв\'язатися з іншими людьми в своїх курсах
- завантажувати зображення, аудіо, відео та інші файли з мобільного пристрою
- переглядати свої оцінки курсу
- та інше!

Будь ласка, зверніться за посиланням http://docs.moodle.org/en/Mobile_app для інформації.

Ми були б дуже вдячні за будь-які хороші відгуки про функціональність і ваші пропозиції про те, що ще ви хочете щоб ми зробили в додатку!

Додаток вимагає наступних дозволів:
Запис аудіо - Для запису звуку, щоб завантажити до Moodle
Читати і змінювати вміст SD карти - Зміст завантажуються на карту SD, так що ви можете побачити їх в автономному режимі
Доступ до мережі - Для того, щоб мати можливість з\'єднатися з вашим сайтом Moodle і перевірити, якщо ви підключені щоб не переходити в автономний режим
Запуск при завантаженні - Ви отримуєте локальні повідомлення, навіть якщо додаток працює у фоновому режимі
Запобігти сну телефону - Таким чином, ви можете отримувати повідомлення в будь-який час';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Аудіо на Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive file';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive folder';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive video';
$string['core.ajaxendpointnotfound'] = '<p>Кінцеву точку AJAX не знайдено. Це може статися, якщо сайт Moodle занадто старий або він блокує доступ до цієї кінцевої точки. Програма Moodle підтримує лише системи Moodle {{$a}} і далі. Зверніться до адміністратора сайту.</p>
<p>{{whoisadmin}}</p>';
$string['core.browser'] = 'Браузер';
$string['core.calculating'] = 'Розрахунок';
$string['core.cannotconnect'] = 'Неможливо з\'єднатися';
$string['core.cannotdownloadfiles'] = 'Завантаження файлів вимкнено. Будь ласка, зв’яжіться з адміністратором вашого сайту.';
$string['core.cannotlogoutpageblocks'] = 'Будь ласка, збережіть або відхиліть зміни, перш ніж продовжити.';
$string['core.cannotopeninapp'] = 'Цей файл може не працювати належним чином на цьому пристрої. Ви б все-таки хотіли його відкрити?';
$string['core.cannotopeninappdownload'] = 'Цей файл може не працювати належним чином на цьому пристрої. Ви все одно хочете завантажити його?';
$string['core.captureaudio'] = 'Запис аудіо';
$string['core.capturedimage'] = 'Зроблено фото.';
$string['core.captureimage'] = 'Сфотографувати';
$string['core.capturevideo'] = 'Запис відео';
$string['core.certificaterror'] = '<p>Ваш пристрій не може довіряти сертифікату цього сайту. Зверніться до адміністратора сайту.</p>
<p>{{whoisadmin}}</p>';
$string['core.clearsearch'] = 'Очистити пошук';
$string['core.clearstoreddata'] = 'Очистити сховище {{$a}}';
$string['core.clicktoseefull'] = 'Натисніть, щоб побачити весь вміст.';
$string['core.comments.commentsnotworking'] = 'Коментарі не можна отримати';
$string['core.comments.warningcommentsnotsent'] = 'Не вдалося синхронізувати коментарі. {{помилка}}';
$string['core.confirmcanceledit'] = 'Ви впевнені, що хочете залишити цю сторінку? Усі зміни будуть втрачені.';
$string['core.confirmleaveunknownchanges'] = 'Ви впевнені, що хочете залишити цю сторінку? Якщо у вас є незбережені зміни, вони будуть втрачені.';
$string['core.confirmloss'] = 'Ви впевнені? Всі зміни будуть втрачені.';
$string['core.confirmopeninbrowser'] = 'Ви хочете відкрити в браузері?';
$string['core.contenteditingsynced'] = 'Ви редагуєте вміст який був синхронізований.';
$string['core.contentlinks.chooseaccount'] = 'Виберіть аккаунт';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Виберіть обліковий запис, щоб відкрити посилання.';
$string['core.contentlinks.confirmurlothersite'] = 'Це посилання відноситься до іншого місця. Ви хочете відкрити?';
$string['core.contentlinks.errornoactions'] = 'Не вдалося знайти дію, яка виконується за цим посиланням.';
$string['core.contentlinks.errornosites'] = 'Не вдалося знайти сайт, щоб впоратися з цим посиланням.';
$string['core.contentlinks.errorredirectothersite'] = 'URL-адреса переспрямування не може вказувати на інший сайт.';
$string['core.copiedtoclipboard'] = 'Текст скопійований';
$string['core.copytoclipboard'] = 'Копіювати в буфер обміну';
$string['core.course.activitydisabled'] = 'Ваша організація відключила цю активність в мобільному додатку.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Ваша організація встановила плагін, який ще не підтримується.';
$string['core.course.allsections'] = 'Всі секції';
$string['core.course.aria:sectionprogress'] = 'Хід розділу:';
$string['core.course.availablespace'] = 'Зараз у вас є близько {{available}} вільного місця.';
$string['core.course.cannotdeletewhiledownloading'] = 'Файли не можна видалити під час завантаження активності. Будь ласка, дочекайтеся завершення завантаження.';
$string['core.course.confirmdownload'] = 'Ви збираєтеся завантажити {{size}}.{{availableSpace}} Дійсно продовжити?';
$string['core.course.confirmdownloadunknownsize'] = 'Не вдалося розрахувати розмір завантаження.{{availableSpace}} Дійсно продовжити?';
$string['core.course.confirmdownloadzerosize'] = 'Ви збираєтеся почати завантаження.{{availableSpace}} Дійсно продовжити?';
$string['core.course.confirmlimiteddownload'] = 'Наразі ви не підключені до Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Ви збираєтеся завантажити <strong>принаймні</strong> {{size}}.{{availableSpace}} Дійсно продовжити?';
$string['core.course.couldnotloadsectioncontent'] = 'Не вдалося завантажити вміст розділу, будь ласка, спробуйте ще раз пізніше.';
$string['core.course.couldnotloadsections'] = 'Не вдалося завантажити розділи. Будь-ласка спробуйте пізніше.';
$string['core.course.downloadcoursesprogressdescription'] = 'Завантаження курсів: завантажено {{count}} з {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Розділ завантаження: завантажено {{count}} з {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Помилка завантаження курсу.';
$string['core.course.errordownloadingsection'] = 'Помилка в завантаженні.';
$string['core.course.errorgetmodule'] = 'Помилка отримання даних про активність.';
$string['core.course.insufficientavailablequota'] = 'Ваш пристрій не міг виділити місце для збереження цього завантаження. Можливо, це резервує місце для оновлень програм і системи. Спочатку звільніть місце для зберігання.';
$string['core.course.insufficientavailablespace'] = 'Ви намагаєтеся завантажити {{size}}. Це призведе до того, що на вашому пристрої не буде достатньо місця для нормальної роботи. Спочатку звільніть місце для зберігання.';
$string['core.course.lastaccessedactivity'] = 'Останній доступ';
$string['core.course.manualcompletionnotsynced'] = 'Завершення вручну не синхронізоване.';
$string['core.course.modulenotfound'] = 'Ресурс або активність не знайдено. Переконайтеся, що ви в Інтернеті та все ще доступні.';
$string['core.course.nextactivity'] = 'Наступна діяльність';
$string['core.course.nextactivitynotfound'] = 'Наступну дію не знайдено. Можливо, він був прихований або видалений.';
$string['core.course.nocontentavailable'] = 'Немає контенту, доступного в даний момент.';
$string['core.course.previousactivity'] = 'Попередня діяльність';
$string['core.course.previousactivitynotfound'] = 'Попередня активність не знайдена. Можливо, він був прихований або видалений.';
$string['core.course.refreshcourse'] = 'Курс оновлення';
$string['core.course.useactivityonbrowser'] = 'Ви все ще можете використовувати його за допомогою браузера пристрою.';
$string['core.course.warningmanualcompletionmodified'] = 'На сайті було змінено ручне завершення діяльності.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Деякі офлайнові ручні завершення курсу "{{name}}" видалено. {{помилка}}';
$string['core.coursenogroups'] = 'Ви не є членом жодної групи цього курсу.';
$string['core.courses.browserenrolinstructions'] = 'Ми перенесемо вас у браузер вашого пристрою. Після того як ви завершите реєстрацію, поверніться до цієї програми.';
$string['core.courses.cannotretrievemorecategories'] = 'Категорії глибші, ніж рівень {{$a}} не можуть бути відновлені.';
$string['core.courses.completeenrolmentbrowser'] = 'Завершити реєстрацію в браузері';
$string['core.courses.downloadcourses'] = 'Завантажити всі курси';
$string['core.courses.enrolme'] = 'Зарахувати мене';
$string['core.courses.errorloadcategories'] = 'Сталася помилка під час завантаження категорій.';
$string['core.courses.errorloadcourses'] = 'Сталася помилка під час завантаження курсів.';
$string['core.courses.errorloadplugins'] = 'Не вдалося правильно завантажити плагіни, необхідні для цього курсу. Перезавантажте програму, щоб спробувати ще раз.';
$string['core.courses.errorsearching'] = 'Під час пошуку сталася помилка.';
$string['core.courses.filtermycourses'] = 'Відфільтрувати мої курси';
$string['core.courses.notenrollable'] = 'Ви не можете зареєструвати себе в цьому курсі.';
$string['core.courses.otherenrolments'] = 'Інші записи';
$string['core.courses.password'] = 'Ключ подачі заявок';
$string['core.courses.refreshcourses'] = 'Курси підвищення кваліфікації';
$string['core.courses.searchcoursesadvice'] = 'Ви можете скористатися кнопкою пошуку курсів, щоб знайти курси, до яких можна отримати доступ у якості гостя, або зареєструватися на курсах, які це дозволяють.';
$string['core.courses.showonlyenrolled'] = 'Показати лише мої курси';
$string['core.courses.totalcoursesearchresults'] = 'Всього курсів:  {{$a}}';
$string['core.currentdevice'] = 'Поточний пристрій';
$string['core.datastoredoffline'] = 'Дані зберігаються в пристрої, оскільки не можуть бути надіслані. Вони будуть автоматично відправлені пізніше.';
$string['core.deletedoffline'] = 'Видалено офлайн';
$string['core.deleting'] = 'Видалення';
$string['core.desktop'] = 'Робочий стіл';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Скинути';
$string['core.dismiss'] = 'Відхилити';
$string['core.dontshowagain'] = 'Не показувати знову.';
$string['core.downloaded'] = 'Завантажено';
$string['core.downloading'] = 'Завантаження';
$string['core.editor.hidetoolbar'] = 'Приховати панель інструментів';
$string['core.editor.toggle'] = 'Увімкнути редактор';
$string['core.emptysplit'] = 'Ця сторінка буде порожня, якщо ліва панель порожня або завантажується.';
$string['core.errorchangecompletion'] = 'Під час зміни статусу завершення сталася помилка. Будь ласка спробуйте ще раз.';
$string['core.errordeletefile'] = 'Помилка видалення файлу. Будь ласка спробуйте ще раз.';
$string['core.errordownloading'] = 'Помилка завантаження файлу.';
$string['core.errordownloadingsomefiles'] = 'Помилка завантаження файлів. Деякі файли можуть бути відсутні.';
$string['core.errorfileexistssamename'] = 'Файл з таким ім\'ям існує.';
$string['core.errorinvalidform'] = 'Форма містить недійсні дані. Будь ласка, переконайтеся, що всі обов’язкові поля заповнені та чи дані дійсні.';
$string['core.errorinvalidresponse'] = 'Отримано недійсну відповідь. Зверніться до адміністратора сайту, якщо помилка не зникає.';
$string['core.errorloadingcontent'] = 'Помилка завантаження вмісту.';
$string['core.errorofflinedisabled'] = 'Офлайн-перегляд на вашому сайті вимкнено. Щоб користуватися додатком, потрібно бути підключеним до Інтернету.';
$string['core.erroropenfiledownloading'] = 'Помилка відкриття файлу: потрібно дочекатися завершення завантаження.';
$string['core.erroropenfilenoapp'] = 'Помилка відкриття файлу: немає програми, щоб відкрити цей тип файлу.';
$string['core.erroropenfilenoextension'] = 'Помилка відкриття файлу: файл не має розширення.';
$string['core.erroropenpopup'] = 'Ця діяльність намагається відкрити спливаюче вікно. Це не підтримується в цьому додатку.';
$string['core.errorrenamefile'] = 'Помилка перейменування файлу. Будь ласка спробуйте ще раз.';
$string['core.errorsomedatanotdownloaded'] = 'Якщо ви завантажили цю дію, зверніть увагу, що деякі дані не завантажуються під час процесу завантаження з міркувань продуктивності та використання даних.';
$string['core.errorsync'] = 'Під час синхронізації сталася помилка. Будь ласка спробуйте ще раз.';
$string['core.errorsyncblocked'] = 'Цей {{$a}} зараз неможливо синхронізувати через триваючий процес. Будь-ласка спробуйте пізніше. Якщо проблема не зникає, спробуйте перезапустити програму.';
$string['core.errorurlschemeinvalidscheme'] = 'Ця URL-адреса призначена для використання в іншій програмі: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL-адресу цього сайту неможливо відкрити в цій програмі.';
$string['core.filenameexist'] = 'Файл вже існує: {{$a}}';
$string['core.fileuploader.audio'] = 'Аудіо';
$string['core.fileuploader.camera'] = 'Камера';
$string['core.fileuploader.confirmuploadfile'] = 'Ви збираєтеся завантажити {{size}}. Ви впевнені, що хочете продовжити?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Розрахувати розмір завантаження не вдалося. Ви впевнені, що хочете продовжити?';
$string['core.fileuploader.errorcapturingaudio'] = 'Помилка захоплення аудіо.';
$string['core.fileuploader.errorcapturingimage'] = 'Помилка захоплення зображення.';
$string['core.fileuploader.errorcapturingvideo'] = 'Помилка захоплення відео.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Помилка отримання зображення з альбома.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Ви повинні бути в мережі для завантаження файлів.';
$string['core.fileuploader.errornoapp'] = 'У вас немає програми, встановленої для виконання цієї дії.';
$string['core.fileuploader.errorreadingfile'] = 'Помилка читання файлу.';
$string['core.fileuploader.errorwhileuploading'] = 'Помилка при завантаженні файлу.';
$string['core.fileuploader.file'] = 'Файл';
$string['core.fileuploader.fileuploaded'] = 'Файл був успішно завантажений.';
$string['core.fileuploader.maxbytesfile'] = 'Файл {{$a.file}} завеликий. Максимальний розмір, який ви можете завантажити: {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Фото альбом.';
$string['core.fileuploader.readingfile'] = 'Читання файлу';
$string['core.fileuploader.readingfileperc'] = 'Читання файлу: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Виберіть файл';
$string['core.fileuploader.uploadafile'] = 'Завантажити файл';
$string['core.fileuploader.uploading'] = 'Завантаження';
$string['core.fileuploader.uploadingperc'] = 'Завантаження: {{$a}}%';
$string['core.fileuploader.video'] = 'Відео';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Перейти до {{$a}}';
$string['core.h5p.errorgetemail'] = 'Помилка отримання електронної пошти користувача. Перевірте з’єднання та спробуйте ще раз.';
$string['core.h5p.offlinedisabled'] = 'Сайт не дозволяє завантажувати пакети H5P.';
$string['core.h5p.play'] = 'Запустити H5P';
$string['core.hasdatatosync'] = '{{$a}} має автономні дані які будуть синхронізовані.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Цей вміст не працює?';
$string['core.image'] = 'Зображення';
$string['core.imageviewer'] = 'Переглядач зображень';
$string['core.ioscookieshelp'] = 'Для роботи вбудованого вмісту можуть знадобитися файли cookie. Будь ласка, перейдіть до налаштувань iOS додатка, увімкніть «Дозволити міжвеб-сайтове відстеження» та повторіть спробу.';
$string['core.lastdownloaded'] = 'Востаннє завантажено';
$string['core.lastsync'] = 'Остання синхронізація';
$string['core.loadmore'] = 'Завантажити більше';
$string['core.login.authenticating'] = 'Аутентифікація';
$string['core.login.changepasswordbutton'] = 'Відкрийте сторінку зміни пароля';
$string['core.login.changepasswordhelp'] = 'Якщо у вас виникли проблеми зі зміною пароля, зверніться до адміністратора сайту. «Адміністратори сайту» — це люди, які керують Moodle у вашій школі/університеті/компанії чи навчальній організації. Якщо ви не знаєте, як з ними зв’язатися, зв’яжіться зі своїми вчителями/тренерами.';
$string['core.login.changepasswordreconnectinstructions'] = 'Натисніть наведену нижче кнопку, щоб повторно підключитися до сайту. (Візьміть до уваги, що якщо ви не змінили пароль успішно, ви повернетесь до попереднього екрана).';
$string['core.login.confirmdeletesite'] = 'Ви впевнені, що хочете видалити обліковий запис на {{sitename}}?';
$string['core.login.connect'] = 'З\'єднано!';
$string['core.login.connecttomoodle'] = 'Підключитись до Moodle';
$string['core.login.connecttomoodleapp'] = 'Ви намагаєтеся підключитися до звичайного сайту Moodle. Будь ласка, завантажте офіційний додаток Moodle, щоб отримати доступ до цього сайту.';
$string['core.login.connecttoworkplaceapp'] = 'Ви намагаєтеся підключитися до сайту Moodle Workplace. Будь ласка, завантажте програму Moodle Workplace, щоб отримати доступ до цього сайту.';
$string['core.login.credentialsdescription'] = 'Будь ласка, введіть Ваше ім\'я користувача та пароль, щоб увійти в систему.';
$string['core.login.emailconfirmsentnoemail'] = '<p>На вашу адресу потрібно було надіслати електронний лист.</p><p>В ньому містяться прості інструкції щодо завершення реєстрації.</p><p>Якщо проблеми не зникнуть, зверніться до адміністратора сайту.</p>';
$string['core.login.emailnotmatch'] = 'Email не співпадають';
$string['core.login.erroraccesscontrolalloworigin'] = 'Перехресний виклик, який ви намагаєтеся здійснити, відхилено. Перевірте https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Під час видалення цього облікового запису сталася помилка. Будь ласка спробуйте ще раз.';
$string['core.login.errorexampleurl'] = 'URL-адреса https://campus.example.edu – це лише приклад URL-адреси, а не справжній сайт. <strong>Використовуйте URL-адресу сайту вашої школи чи організації.</strong>';
$string['core.login.errorqrnoscheme'] = 'Ця URL-адреса не є дійсною URL-адресою для входу.';
$string['core.login.errorupdatesite'] = 'При оновленні токена сайту сталася помилка.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Ви правильно ввели ім\'я? Також можливо, що ваш сайт не включено до нашого загальнодоступного каталогу сайтів. Якщо ви все ще не можете знайти його, введіть адресу свого сайту.';
$string['core.login.faqcannotfindmysitequestion'] = 'Я не можу знайти свій сайт.';
$string['core.login.faqsetupsiteanswer'] = 'Відвідайте {{$link}}, щоб перевірити різні варіанти створення власного сайту Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Розпочати.';
$string['core.login.faqsetupsitequestion'] = 'Я хочу створити власний сайт Moodle.';
$string['core.login.faqtestappanswer'] = 'Щоб протестувати програму на демонстраційному сайті Moodle, введіть «вчитель» або «студент» у полі «Ваш сайт» і натисніть кнопку «Підключитися до свого сайту».';
$string['core.login.faqtestappquestion'] = 'Я просто хочу протестувати програму, що я можу зробити?';
$string['core.login.faqwhatisurlanswer'] = '<p>Кожна організація має власну унікальну адресу або URL-адресу для свого сайту Moodle. Щоб знайти адресу:</p><ol><li>Відкрийте веб-переглядач і перейдіть на сторінку входу на сайт Moodle.</li><li>Угорі сторінки в адресному рядку ви побачите повідомлення. URL-адреса вашого сайту Moodle, напр. "campus.example.edu".<br>{{$image}}</li><li>Скопіюйте адресу (не копіюйте /login і те, що буде після нього), вставте її в програму Moodle і натисніть "Підключитися на ваш сайт"</li><li>Тепер ви можете увійти на свій сайт, використовуючи своє ім\'я користувача та пароль.</li></ol>';
$string['core.login.faqwhatisurlquestion'] = 'Яка моя адреса сайту? Як я можу знайти URL-адресу свого сайту?';
$string['core.login.faqwhereisqrcode'] = 'Де я можу знайти QR-код?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Якщо ваша організація ввімкнула його, ви знайдете QR-код на веб-сайті внизу сторінки профілю користувача.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Знайдіть свій сайт';
$string['core.login.invalidaccount'] = ' Перевірте дані для входу або попросіть адміністратора сайту перевірити конфігурацію сайту.
';
$string['core.login.invalidmoodleversion'] = '<p>Недійсна версія сайту Moodle. Додаток Moodle підтримує лише системи Moodle {{$a}} і далі.</p>
<p>Ви можете зв’язатися з адміністраторами свого сайту та попросити їх оновити свою систему Moodle.</p>
<p>"Адміністратори сайту" – це люди, які керують Moodle у вашій школі/університеті/компанії чи навчальній організації. Якщо ви не знаєте, як з ними зв’язатися, зверніться до своїх вчителів/тренерів.</p>';
$string['core.login.invalidsite'] = 'URL сайту недійсний.';
$string['core.login.invalidtime'] = 'Невірний час';
$string['core.login.invalidvaluemax'] = 'Максимальне значення {{$a}}';
$string['core.login.invalidvaluemin'] = 'Мінімальне значення {{$a}}';
$string['core.login.loginbutton'] = 'Вхід';
$string['core.login.mobileservicesnotenabled'] = 'На вашому сайті не ввімкнено мобільний доступ. Будь ласка, зв’яжіться з адміністратором вашого сайту, якщо ви вважаєте, що його потрібно ввімкнути.';
$string['core.login.notloggedin'] = 'Ви повинні увійти в систему.';
$string['core.login.onboardingcreatemanagecourses'] = 'Створюйте та керуйте своїми курсами';
$string['core.login.onboardingenrolmanagestudents'] = 'Зареєструйтеся та керуйте своїми студентами';
$string['core.login.onboardinggetstarted'] = 'Почніть роботу з Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'У мене вже є сайт Moodle';
$string['core.login.onboardingimalearner'] = 'Я учень';
$string['core.login.onboardingimaneducator'] = 'Я вчитель';
$string['core.login.onboardingineedasite'] = 'Мені потрібен сайт Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Надайте своєчасний зворотній зв’язок';
$string['core.login.onboardingtoconnect'] = 'Щоб підключитися до програми Moodle, вам потрібен сайт Moodle';
$string['core.login.onboardingwelcome'] = 'Ласкаво просимо до програми Moodle!';
$string['core.login.or'] = 'ЧИ';
$string['core.login.passwordrequired'] = 'Пароль необхідний';
$string['core.login.policyacceptmandatory'] = 'Я розумію та погоджуюся з обов’язковими правилами сайту';
$string['core.login.recaptchachallengeimage'] = 'Зображення виклику reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Термін перевірки закінчився. Дайте відповідь на таємне запитання ще раз.';
$string['core.login.recaptchaincorrect'] = 'Відповідь на таємне запитання неправильна.';
$string['core.login.reconnect'] = 'Повторне з\'єднання';
$string['core.login.removeaccount'] = 'Видалити обліковий запис';
$string['core.login.searchby'] = 'Пошук за:';
$string['core.login.selectsite'] = 'Будь ласка, виберіть свій обліковий запис:';
$string['core.login.signupplugindisabled'] = '{{$a}} не доступно.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Форма реєстрації містить обов’язкове спеціальне поле, яке не підтримується в програмі. Будь ласка, створіть свій обліковий запис за допомогою веб-браузера.';
$string['core.login.siteaddress'] = 'Ваш сайт';
$string['core.login.sitebadgedescription'] = 'Є {{count}} непрочитаних сповіщень.';
$string['core.login.sitehasredirect'] = 'Ваш сайт містить принаймні одне переспрямування HTTP. Програма не може виконувати переспрямування, це може бути проблемою, яка заважає програмі під’єднатися до вашого сайту.';
$string['core.login.siteinmaintenance'] = 'Сайт в режимі обслуговування';
$string['core.login.sitenotallowed'] = 'Цей сайт більше не доступний.';
$string['core.login.sitepolicynotagreederror'] = 'Політики сайту не погоджені';
$string['core.login.siteurl'] = 'URL сайту';
$string['core.login.siteurlrequired'] = 'Необхідна URL-адреса сайту, тобто <i>http://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'До сих пір не можете підключитися?';
$string['core.login.toggleremove'] = 'Редагувати список облікових записів';
$string['core.login.usernamerequired'] = 'Ім\'я користувача необхідне';
$string['core.login.visitchangepassword'] = 'Ви хочете відвідати сайт, щоб змінити пароль?';
$string['core.login.webservicesnotenabled'] = 'Можливо, на вашому хост-сайті не ввімкнено веб-служби. Зверніться по допомогу до свого адміністратора.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Ви все ще можете підключитися до сайту, ввівши своє ім’я користувача та пароль.';
$string['core.login.yourenteredsite'] = 'Підключіться до свого сайту';
$string['core.lostconnection'] = 'Ваш маркер аутентифікації недійсний або закінчився, вам доведеться підключитися до сайту.';
$string['core.mainmenu.switchaccount'] = 'Змінити обліковий запис';
$string['core.mainmenu.usermenutourdescription'] = 'Місце, де можна перевірити свої оцінки, змінити свої параметри або змінити обліковий запис.';
$string['core.mainmenu.usermenutourtitle'] = 'Дослідіть свою особисту область';
$string['core.needhelp'] = 'Потрібна допомога?';
$string['core.networkerroriframemsg'] = 'Цей вміст недоступний офлайн. Підключіться до Інтернету та повторіть спробу.';
$string['core.networkerrormsg'] = 'Мережа не включена або не працює.';
$string['core.nooptionavailable'] = 'Немає доступних опцій';
$string['core.nopasswordchangeforced'] = 'Ви не можете продовжити без зміни пароля.';
$string['core.nopermissionerror'] = 'Вибачте, але наразі у вас немає дозволів на це';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Не відправлено';
$string['core.nummore'] = 'Ще {{$a}}';
$string['core.openfile'] = 'Відкрити файл';
$string['core.openfullimage'] = 'Натисніть тут, щоб побачити зображення в повному розмірі';
$string['core.openinbrowser'] = 'Відкрити у браузері';
$string['core.openmodinbrowser'] = 'Відкрийте {{$a}} у браузері';
$string['core.opensecurityquestion'] = 'Відкрите таємне запитання';
$string['core.opensettings'] = 'Відкрийте налаштування';
$string['core.openwith'] = 'Відкрити за допомогою...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Грати';
$string['core.pulltorefresh'] = 'Потягніть щоб оновити';
$string['core.qrscanner'] = 'QR сканер';
$string['core.question.cannotdeterminestatus'] = 'Неможливо визначити статус';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Ваш сайт ще не підтримує вкладення файлів до відповідей.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Ваш сайт ще не підтримує редагування вбудованих файлів.';
$string['core.question.errorquestionnotsupported'] = 'Цей тип питання не підтримується додатком: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Торкніться, щоб вибрати, а потім натисніть, щоб опустити.';
$string['core.question.questionmessage'] = 'Питання {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Ви будете перенаправлені на сайт.';
$string['core.removefiles'] = 'Видалити файли {{$a}}';
$string['core.requireduserdatamissing'] = 'У цього користувача відсутні деякі необхідні дані профілю. Будь ласка, введіть дані на своєму сайті та повторіть спробу.<br>{{$a}}';
$string['core.resume'] = 'Резюме';
$string['core.retry'] = 'Повторити';
$string['core.scanqr'] = 'Скануйте QR-код';
$string['core.scrollbackward'] = 'Прокрутіть назад';
$string['core.scrollforward'] = 'Прокрутіть вперед';
$string['core.searching'] = 'Пошук';
$string['core.settings.about'] = 'Про додаток';
$string['core.settings.appsettings'] = 'Налаштування програми';
$string['core.settings.appversion'] = 'Версія програми';
$string['core.settings.cannotsyncloggedout'] = 'Цей сайт неможливо синхронізувати, оскільки ви вийшли. Будь ласка, спробуйте ще раз, коли ви знову увійдете на сайт.';
$string['core.settings.cannotsyncoffline'] = 'Неможливо синхронізувати в автономному режимі.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Неможливо синхронізувати, так як поточні налаштування тільки дозволяють синхронізуватись при підключенні до Wi-Fi. Підключіться до мережі Wi-Fi.';
$string['core.settings.changelanguage'] = 'Змінити на {{$a}}';
$string['core.settings.changelanguagealert'] = 'Зміна мови призведе до перезапуску програми.';
$string['core.settings.colorscheme'] = 'Кольорова схема';
$string['core.settings.colorscheme-dark'] = 'Темна тема';
$string['core.settings.colorscheme-light'] = 'Світла тема';
$string['core.settings.colorscheme-system'] = 'За замовчуванням системи';
$string['core.settings.colorscheme-system-notice'] = 'Системний режим за замовчуванням буде залежати від підтримки вашого пристрою.';
$string['core.settings.compilationinfo'] = 'Інформація про компіляцію';
$string['core.settings.copyinfo'] = 'Скопіюйте інформацію про пристрій у буфер обміну';
$string['core.settings.cordovadevicemodel'] = 'Модель пристрою Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Cordova Device OS version';
$string['core.settings.cordovadeviceplatform'] = 'Cordova Device platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['core.settings.cordovaversion'] = 'Cordova version';
$string['core.settings.debugdisplaydescription'] = 'Якщо ввімкнено, модальні помилки відображатимуть більше даних про помилку, якщо це можливо.';
$string['core.settings.developeroptions'] = 'Налаштування виробника';
$string['core.settings.deviceinfo'] = 'Інформація про пристрій';
$string['core.settings.deviceos'] = 'ОС пристрою';
$string['core.settings.displayformat'] = 'Формат відображення';
$string['core.settings.enabledownloadsection'] = 'Увімкнути секцію завантаження';
$string['core.settings.enablerichtexteditor'] = 'Включити редактор тексту';
$string['core.settings.enablerichtexteditordescription'] = 'Якщо ввімкнено, текстовий редактор буде доступний під час введення вмісту.';
$string['core.settings.entriesincache'] = '{{$a}} записів у кеші';
$string['core.settings.estimatedfreespace'] = 'Розрахунковий вільний простір';
$string['core.settings.filesystemroot'] = 'Коренева файлова система';
$string['core.settings.fontsize'] = 'Розмір тексту';
$string['core.settings.forcedsetting'] = 'Це налаштування було вимушене конфігурацією вашого сайту.';
$string['core.settings.helpusimprove'] = 'Допоможіть нам покращити цю програму';
$string['core.settings.ioscookies'] = 'Відстеження між веб-сайтами';
$string['core.settings.ioscookiesdescription'] = 'Для роботи вбудованого вмісту сайту можуть знадобитися міжсайтові файли cookie. Щоб увімкнути його, перейдіть до налаштувань iOS додатка та ввімкніть «Дозволити міжвеб-сайтове відстеження».';
$string['core.settings.localnotifavailable'] = 'Доступні локальні сповіщення';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.navigatorlanguage'] = 'Мова навігації';
$string['core.settings.navigatoruseragent'] = 'Навігаційний userAgent';
$string['core.settings.networkstatus'] = 'Статус інтернет з\'єднання';
$string['core.settings.opensourcelicenses'] = 'Ліцензії з відкритим кодом';
$string['core.settings.privacypolicy'] = 'Політика конфіденційності';
$string['core.settings.publisher'] = 'Видавець';
$string['core.settings.pushid'] = 'Ідентифікатор push-сповіщень';
$string['core.settings.reportinbackground'] = 'Відправляти помилки автоматично';
$string['core.settings.screen'] = 'Інформація на екрані';
$string['core.settings.showdownloadoptions'] = 'Показати параметри завантаження';
$string['core.settings.siteinfo'] = 'Інформація про сайт';
$string['core.settings.spaceusage'] = 'Використане місце';
$string['core.settings.synchronization'] = 'Синхронізація';
$string['core.settings.synchronizenow'] = 'Синхронізувати зараз';
$string['core.settings.synchronizenowhelp'] = 'Синхронізація сайту надсилає зміни, що очікують на розгляд, і всю офлайн-активність, збережену на пристрої, а також синхронізує деякі дані, як-от повідомлення та сповіщення.';
$string['core.settings.syncsettings'] = 'Налаштування синхронізації';
$string['core.settings.wificonnection'] = 'WiFi з\'єднання';
$string['core.settings.youradev'] = 'Тепер ви розробник';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Виберіть обліковий запис для зберігання файлу.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Існує файл з таким ім\'ям. Ви хочете замінити існуючий файл або перейменувати його в "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Немає сайтів. Будь ласка, додайте сайт, перш ніж ділитися файлом із програмою.';
$string['core.sharedfiles.nosharedfiles'] = 'На цьому сайті немає спільних файлів.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'У вас немає файлів для завантаження сюди. Якщо ви хочете завантажити файл з іншої програми, знайдіть файл і натисніть кнопку «Відкрити в».';
$string['core.sharedfiles.rename'] = 'Перейменувати';
$string['core.sharedfiles.replace'] = 'Перемістити';
$string['core.sharedfiles.sharedfiles'] = 'Розшарити файли';
$string['core.sharedfiles.successstorefile'] = 'Файл успішно збережено. Виберіть файл, який потрібно завантажити до ваших приватних файлів або використати в дії.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Вибачте...';
$string['core.start'] = 'Старт';
$string['core.storingfiles'] = 'Зберігання файлів';
$string['core.swipenavigationtourdescription'] = 'Проведіть пальцем ліворуч і праворуч, щоб переміщатися.';
$string['core.tablet'] = 'Планшет';
$string['core.tag.errorareanotsupported'] = 'Ця область тегів не підтримується програмою.';
$string['core.tag.tagareabadgedescription'] = 'Є {{count}} елементів.';
$string['core.tag.warningareasnotsupported'] = 'Деякі області тегів не відображаються, оскільки вони не підтримуються програмою.';
$string['core.thereisdatatosync'] = 'Є автономні {{$a}} для синхронізації.';
$string['core.toggledelete'] = 'Перемикач кнопки видалення';
$string['core.tryagain'] = 'Спробувати ще раз';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Опана...';
$string['core.unexpectederror'] = 'Неочікувана помилка. Будь ласка, закрийте і знову відкрийте додаток, щоб спробувати ще раз';
$string['core.unicodenotsupported'] = 'Деякі Emoji не підтримуються на цьому сайті. Такі символи будуть видалені, коли повідомлення буде відправлено.';
$string['core.unicodenotsupportedcleanerror'] = 'Порожній текст був знайдений при чищенні Unicode символів.';
$string['core.unknown'] = 'Невідомо';
$string['core.unzipping'] = 'Розпакування';
$string['core.updaterequired'] = 'Потрібне оновлення програми';
$string['core.updaterequireddesc'] = 'Оновіть свою програму до версії {{$a}}';
$string['core.user.contact'] = 'Контакт';
$string['core.user.detailsnotavailable'] = 'Деталі цього користувача вам не доступні';
$string['core.user.errorloaduser'] = 'Помилка завантаження користувача.';
$string['core.user.sendemail'] = 'Email';
$string['core.user.userwithid'] = 'Користувач з ідентифікатором {{id}}';
$string['core.usernologin'] = 'Аутентифікацію для цього облікового запису скасовано';
$string['core.viewcode'] = 'Переглянути код';
$string['core.vieweditor'] = 'Переглянути редактор';
$string['core.viewembeddedcontent'] = 'Перегляд вбудованого вмісту';
$string['core.warningofflinedatadeleted'] = 'Офлайн-дані з {{component}} \'{{name}}\' видалено. {{помилка}}';
$string['core.warnopeninbrowser'] = '<p>Ви збираєтеся вийти з програми, щоб відкрити цю URL-адресу у браузері свого пристрою. Продовжити?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Чому це відбувається?';
$string['core.wsfunctionnotavailable'] = 'Функція веб-сервіс не доступна.';
$string['core.youreoffline'] = 'Ви офлайн';
$string['core.youreonline'] = 'Ви знову в мережі';
$string['core.zoomin'] = 'Приблизити';
$string['core.zoomout'] = 'Зменшити';
$string['pluginname'] = 'Рядки мови Moodle Mobile';
