<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'uk', version '4.1'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Moodle можна вільно та безкоштовно завантажити і реєстрація є добровільною, тому ми не маємо повної інформації про всіх, хто нею користується. Але на основі тієї інформації, яку ми маємо, ми автоматично генеруємо цікаві графіки та цифри на сторінці статистики.';
$string['aboutstatisticsheading'] = 'Статистика Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Статистика Moodle';
$string['activeusers24hours'] = 'Зареєстровані користувачі, які заходили на сайт за останні 24 години:';
$string['activeuserspastmonth'] = 'Зареєстровані користувачі, які заходили на сайт за останній місяць';
$string['browsegittitle'] = 'Проглянути вихідний код';
$string['cachedef_frontpagecolumn'] = 'Колонки на Головній сторінці';
$string['cachedef_usefulposts'] = 'Корисні повідомлення';
$string['communities'] = 'Спільноти';
$string['communitiesmy'] = 'Мої спільноти';
$string['community'] = 'Спільнота';
$string['communityadministration'] = 'Адміністрація спільноти';
$string['communitycurrent'] = 'Поточна спільнота';
$string['communityenrolme'] = 'Стати членом цієї спільноти';
$string['communityenrolmentoptions'] = 'Вступ до спільноти';
$string['communityintro'] = 'Moodle має велику та різноманітну спільноту користувачів з понад <a href="http://moodle.org/userpics">{$a->usercount} зареєстрованих користувачів</a> тільки на цьому сайті, які говорять на більш ніж <a href="http://download.moodle.org/langpack/">{$a->langcount} мовах</a> в <a href="http://moodle.org/sites">{$a->countrycount} країнах</a> (ми маємо <a href="http://moodle.org/stats">більше статистики</a>).';
$string['communityjoinbyyourself'] = 'Приєднатися';
$string['communityjoinbyyourselfas'] = 'Приєднатися як {$a->rolename}';
$string['communitynoguestaccess'] = 'Гість не має доступу до цієї спільноти, спробуйте зайти під своїм обліковим записом.';
$string['communitynotenrollable'] = 'Ви не можете самостійно приєднатися до цієї спільноти. Будь ласка, зв’яжіться з Координатором спільноти.';
$string['communitysomeallowguest'] = 'Деякі спільноти дозволяють гостьовий доступ';
$string['communityunenrolme'] = 'Залишити спільноту {$a}';
$string['conferencecenter'] = 'Центр конференцій Moodle';
$string['connectedsites'] = 'Деякі сайти підключено до moodle.org за допомогою Мережі Moodle (Moodle Networking), тому ви можете зайти на них тільки-но пройдете аутентифікацію тут.';
$string['donations10over'] = 'Інші пожертви від $10 і більше';
$string['donationsassociation'] = 'Приєднуйтесь до <a href="https://moodleassociation.org/">Moodle Association</a> - Допоможіть визначити, як слід витрачати членські внески на елементи дорожньої карти Moodle';
$string['donationsdevelopment'] = 'Однак, розробка Moodle та обслуговування всіх сайтів нашої спільноти коштують нам чималих грошей, і ми завжди потребуємо додаткової підтримки. Якщо ви любите Moodle або вважаєте його корисним для вашого бізнесу, школи чи установи, будь ласка, зробіть пожертву. Навіть найменша допомога корисна.';
$string['donationsdonatenow'] = 'Пожертвувати';
$string['donationsensure'] = 'Пожертви гарантують, що основні гвинтики Машини Moodle (наші розробники) продовжують створювати нові функції та виправляти помилки, роблячи Moodle кращим для всіх нас.';
$string['donationsmoodle'] = 'Пожертви';
$string['donationsopensource'] = 'Moodle - це справжній відкритий код та абсолютно вільний від фінансових зобов’язань - саме таким має бути програмне забезпечення!';
$string['donationsover1000'] = 'Попередні пожертви понад $1000';
$string['donationsover200'] = 'Інші пожертви понад $200';
$string['donationsover500'] = 'Інші пожертви понад $500';
$string['donationspartner'] = 'Використовуючи сервіси <a href="https://moodle.com/partners/">сертифікованих партнерів Moodle</a> ви підтримуєте Moodle, оскільки 10% з їх доходу вносяться в проект Moodle.';
$string['donationsshop'] = 'Придбайте щось в нашій <a href="http://www.zazzle.com/moodle_hq/">Moodle крамниці</a> та користуйтеся цим з гордістю!';
$string['donationsthankeveryone'] = 'Дякуємо всім, хто долучився до проекту Moodle.';
$string['donationsthankyou'] = 'Дякуємо';
$string['donationstitle'] = 'Пожертви';
$string['donationsways'] = 'Інші способи фінансово підтримати Moodle:';
$string['download_activities'] = 'Діяльності';
$string['download_admintools'] = 'Інструменти Адміна';
$string['download_appdocumentation'] = 'Документація';
$string['download_appreleasenotes'] = 'Примітки до випуску';
$string['download_browseall'] = 'Переглянути все';
$string['download_downloadosx'] = 'Завантажити Moodle для OS X (включає Moodle, Apache, MySQL та PHP для запуску на Mac OS)';
$string['download_downloadwindows'] = 'Завантажити Moodle для Windows (включає Moodle, Apache, MySQL та PHP для запуску на Windows)';
$string['download_forandroid'] = 'Для Android';
$string['download_forios'] = 'Для iOS';
$string['download_helpbox_description'] = 'Прочитайте документацію для початку роботи та відвідайте наші форуми спільноти або просто зв’яжіться з нашими партнерами (Moodle Partner) для розміщення, встановлення та інших послуг.';
$string['download_helpbox_installing'] = 'Встановлення Moodle';
$string['download_helpbox_partners'] = 'Moodle Партнери';
$string['download_helpbox_support'] = 'Форуми підтримки';
$string['download_helpbox_title'] = 'Потрібна допомога?';
$string['download_helpbox_upgrading'] = 'Оновлення Moodle';
$string['download_hero_description'] = 'Moodle знаходиться під <a class="link" href="http://docs.moodle.org/dev/License"> GPL-ліцензією </a>, тобто кожен має ліцензоване право на вільне використання та користування перевагами нашої програми. <br> <br> Перевірте вашу інсталяцію на останню версію Moodle.';
$string['download_hero_headline'] = 'Moodle - відкрите програмне забезпечення';
$string['download_langpackinfo'] = 'Мовні пакети генеруються автоматично з результатів роботи перекладачів на <a href="http://lang.moodle.org/">Сайті перекладів</a>.  Для додаткової інформації дивіться <a href="https://docs.moodle.org/dev/Translation">Документацію перекладу</a>.';
$string['download_langpackinstallinfo'] = 'Додаткові мовні пакети можуть бути встановлені на вашому Moodle через <em> Керування > Керування сайтом > Мова інтерфейсу > Мовні пакети </em> або вручну. Для додаткової інформації дивіться <a href="https://docs.moodle.org/en/Language_packs">Документацію мовних пакетів</a>.';
$string['download_langpackinstalltitle'] = 'Встановлення мовних пакетів';
$string['download_langpacktitle'] = 'Мовні пакети для Moodle {$a}';
$string['download_mobileapp'] = 'Мобільний застосунок';
$string['download_themes'] = 'Теми оформлення';
$string['download_viewallbuilds'] = 'Переглянути всі версії (потребує запущеними веб-сервер, PHP та базу даних)';
$string['downloadcore'] = 'Система Moodle розповсюджується у вигляді стандартних пакетів. До них включено ядро системи та певна кількість основних модулів, які можна без проблем встановити практично на будь-якій платформі, де є РНР та база даних.';
$string['downloadcoretitle'] = 'Стандартні пакети Moodle';
$string['downloadintro'] = 'Moodle - це відкрите програмне забезпечення, яке розповсюджується під <a href="http://docs.moodle.org/dev/License">Ліцензією GPL</a>. Все, що ми створюємо, доступне вам для завантаження та використання абсолютно безкоштовно.';
$string['downloadlang'] = 'В поточних версіях Moodle додавання підтримки нових мов здійснюється автоматично через адміністративне меню вашого сайту. Але для деяких старих версій Moodel може знадобитися завантажити та встановити мовні пакети вручну.';
$string['downloadlangtitle'] = 'Мовні пакети';
$string['downloadmac'] = 'Якщо ви не  маєте налаштованого веб-сервера, то за допомогою цих пакетів "все-в-одному" можна легко встановити Moodle на комп’ютери Apple під керуванням Mac OS X.';
$string['downloadmactitle'] = 'Moodle для Mac OS X';
$string['downloadmodules'] = 'Перегляньте нашу всеосяжну базу даних додаткових модулів, які ви можете додати на ваш сайт Moodle, щоб отримати додаткову функціональність до базових пакетів.';
$string['downloadmodulestitle'] = 'Модулі';
$string['downloadthemes'] = 'Зовнішній вигляд сайту Moodle можна швидко змінити за допомогою різних тем оформлення. Ми маємо базу таких тем, які створили та розмістили користувачі Moodle.';
$string['downloadthemestitle'] = 'Теми оформлення';
$string['downloadviagitcvs'] = 'Інші способи отримати Moodle включають <a href="http://docs.moodle.org/en/Git_for_Administrators">скачування через Git</a> або <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">скачування через CVS</a> .';
$string['downloadwin'] = 'Якщо ви не  маєте налаштованого веб-сервера, то за допомогою цих пакетів "все-в-одному" можна легко встановити Moodle на комп’ютери під керуванням Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle для Windows';
$string['erroradminonly'] = 'Лише адміністратори можуть користуватися цим інтерфейсом.';
$string['erroralreadyvoted'] = 'Ви вже голосували за {$a}';
$string['errormaxmessages'] = 'Перепрошуємо, але Ви не можете відправляти більше ніж три повідомлення.';
$string['errornomainnews'] = 'Не вдалося знайти або створити головний новинний форум для сайту.';
$string['errorsendingmail'] = 'Виникла помилка під час  відправлення повідомлення. Будь ласка, повторіть спробу пізніше або зв’яжіться з адміністратором сайту.';
$string['eventdonation_created'] = 'Список пожертв створено';
$string['eventdonation_submitted'] = 'Пожертву надано';
$string['events'] = 'Хоча ми і спеціалізуємося на онлайн навчанні, все одно добре зібратися в одній кімнаті! Перейдіть за цими посиланнями для отримання детальної інформації про наші конференції (ми називаємо їх MoodleMoot) та інші події.';
$string['eventstitle'] = 'Події';
$string['feed_events'] = 'Події';
$string['feed_events_more'] = 'Ще події';
$string['feed_news'] = 'Оголошення';
$string['feed_news_more'] = 'Переглянути всі оголошення';
$string['feed_resources'] = 'Ресурси';
$string['feed_useful'] = 'Корисні повідомлення';
$string['feed_useful_more'] = 'Інші повідомлення';
$string['focusbox_community'] = 'Форуми підтримки та спільнот';
$string['focusbox_community_text'] = 'Отримуйте підтримку та діліться ідеями, вашою рідною мовою.';
$string['focusbox_community_viewall'] = 'Всі спільноти';
$string['focusbox_future'] = 'Допомога розвитку Moodle';
$string['focusbox_future_crowdfund'] = 'Проекти підтримки';
$string['focusbox_future_gdf'] = 'Спілкування розробників';
$string['focusbox_future_research'] = 'Дослідження Moodle';
$string['focusbox_future_roadmap'] = 'План розробки';
$string['focusbox_future_text'] = 'Дізнайтеся, що буде далі та допоможіть це покращити.';
$string['focusbox_future_ux'] = 'Обговорення досвіду використання (UX).';
$string['focusbox_settingup'] = 'Налаштування';
$string['focusbox_settingup_community'] = 'Підтримка спільноти';
$string['focusbox_settingup_download'] = 'Завантаження';
$string['focusbox_settingup_hosting'] = 'Хостінг';
$string['focusbox_settingup_install'] = 'Встановлення';
$string['focusbox_settingup_own'] = 'Ваш власний сайт';
$string['focusbox_settingup_partner'] = 'У Moodle партнерів';
$string['focusbox_settingup_plugins'] = 'Модулі';
$string['focusbox_settingup_support'] = 'Комерційна підтримка';
$string['focusbox_teaching'] = 'Навчання Moodle';
$string['focusbox_teaching_books'] = 'Книги';
$string['focusbox_teaching_courses'] = 'Курси і зміст';
$string['focusbox_teaching_docs'] = 'Документація';
$string['focusbox_teaching_text'] = 'Досліджуйте широкі можливості Moodle функцій та ресурсів.';
$string['focusbox_theproject'] = 'Проект Moodle';
$string['focusbox_theproject_about'] = 'Про Moodle';
$string['focusbox_theproject_devs'] = 'Розробники';
$string['focusbox_theproject_mua'] = 'Асоціація користувачів Moodle';
$string['focusbox_theproject_partners'] = 'Moodle Партнери';
$string['focusbox_theproject_stats'] = 'Статистика';
$string['focusbox_theproject_text'] = 'Дізнайтеся більше про проект Moodle і наші пропозиції відкритого партнерства.';
$string['focusbox_uptodate'] = 'Будьте в курсі подій';
$string['focusbox_uptodate_news'] = 'Оголошення';
$string['focusbox_uptodate_planet'] = 'Планета Moodle';
$string['focusbox_uptodate_security'] = 'Інформація з безпеки';
$string['focusbox_uptodate_social'] = 'Соціальні мережі';
$string['focusbox_uptodate_text'] = 'Останні Moodle новини та події по всьому світу.';
$string['generaldeveloperforum'] = 'Основний форум розробників';
$string['graphpopulation'] = 'Графік чисельності Moodle';
$string['graphregistrationmap'] = 'Карта реєстрації Moodle';
$string['graphregistrationmapdesc'] = 'Перша десятка країн за кількістю зареєстрованих сайтів (всього країн: {$a})';
$string['graphusersites'] = 'Порівняння користувачів та сайтів Moodle';
$string['heroslide_community_description'] = 'Ласкаво просимо до спільноти Moodle, де ви знайдете для себе справжнє значення відкритості та співпраці однієї з найбільших команд у світі по роботі з відкритим вихідним кодом.';
$string['heroslide_community_headline'] = 'Спільнота та глобальна підтримка';
$string['heroslide_community_slidecontrol'] = 'Підтримується світовою спільнотою';
$string['heroslide_donate_headline'] = 'Допоможіть нам змінити ситуацію з відкритою та якісною освітою для всіх';
$string['heroslide_getstarted40_description'] = 'Moodle LMS має нову індивідуальність і переосмислений досвід використання, що покращує онлайн-викладання та навчання для викладачів, учнів та адміністраторів.';
$string['heroslide_getstarted40_headline'] = 'Moodle 4.0 - Новий вигляд, кращі враження від користування!';
$string['heroslide_getstarted40_slidecontrol'] = 'Moodle 4.0 вже тут!';
$string['heroslide_getstarted_description'] = 'Moodle - найпопулярніша у світі система управління навчанням. Почніть створювати свій веб-сайт для навчання за лічені хвилини!';
$string['heroslide_getstarted_headline'] = 'Почати легко';
$string['heroslide_getstarted_slidecontrol'] = 'Почніть вже сьогодні';
$string['heroslide_global_description'] = 'Доступна понад 100 мовами, Moodle довіряють великі та малі установи з мільйонами користувачів по всьому світу.';
$string['heroslide_global_headline'] = 'Включає навчальне середовище світу';
$string['heroslide_global_slidecontrol'] = 'Включає навчальне середовище світу';
$string['heroslide_link_demo'] = 'Демонстрація';
$string['heroslide_link_donate'] = 'Пожертва';
$string['heroslide_link_features'] = 'Функціональність';
$string['heroslide_link_forums'] = 'Форуми спільноти';
$string['heroslide_link_getstarted'] = 'Почніть вже сьогодні';
$string['heroslide_link_getstarted40'] = 'Дізнайтеся про Moodle 4.0';
$string['heroslide_link_sites'] = 'Зареєстровані сайти';
$string['heroslide_link_stats'] = 'Статистика';
$string['heroslide_link_stories'] = 'Читати далі';
$string['heroslide_power40_description'] = 'Легко, швидко та інтуїтивно зрозуміло! Ознайомтеся з покращеним користуванням і новими функціями Moodle 4.0.';
$string['heroslide_power40_headline'] = 'Спробуйте Moodle 4.0';
$string['heroslide_power40_slidecontrol'] = 'Спробуйте Moodle 4.0';
$string['heroslide_power_description'] = 'Безкоштовна навчальна платформа для всього світу, яка допоможе вам створити ефективне інтернет навчання на основі співпраці у власному середовищі.';
$string['heroslide_power_headline'] = 'Сила. Безпека. Відкритість.';
$string['heroslide_power_slidecontrol'] = 'Потужна відкрита навчальна платформа';
$string['heroslide_story1_description'] = '"Навчання, яке ґрунтується на передових технологіях,  дозволяє нам спростити для студентів їх науковий пошук, творчість та розширити можливості." - професор Дерелл Еванс (Darrell Evans), перший віце-ректор, Університет Монаша';
$string['heroslide_story1_headline'] = 'Вдосконалення викладання та навчання всюди';
$string['heroslide_story2_description'] = 'Глобальний постачальник послуг з морського транспорту, логістики та морських послуг, GAC, через свою Корпоративну академію надає ініціативи з навчання та розвитку понад 10 000 працівників у понад 70 країнах.';
$string['heroslide_story2_headline'] = 'Досягнення майстерності корпоративного навчання';
$string['heroslide_story3_description'] = 'Форт-Веллі-коледж - один з найбільших коледжів Шотландії, що пропонує понад 750 курсів для понад 20 000 активних користувачів на своїх сайтах.';
$string['heroslide_story3_headline'] = 'Проведення всебічної гнучкої освіти';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas  (VSO) надає інтерактивне навчання та підтримку волонтерам на міжнародному рівні для забезпечення глобальних підходів до навчання.';
$string['heroslide_story4_headline'] = 'Допомога волонтерам у здійсненні програми боротьби з бідністю';
$string['heroslide_story_slidecontrol'] = 'Moodle історії зі всього світу';
$string['jobs'] = 'В нашій базі даних міститься інформація зі всього світу про вакансії пов’язані з Moodle.';
$string['logoinfo'] = 'Ім\'я Moodle ™ є зареєстрованою торговою маркою Moodle Trust.

Якщо ви маєте намір використовувати назву і/або логотип для реклами загальних послуг Moodle (наприклад, Moodle хостинг, підтримка Moodle, сертифікація Moodle, Moodle підготовка, Moodle консультації, налаштування Moodle, розробка Moodle курсів, розробка тем оформлення для Moodle, Moodle інтеграції, Moodle установки і т.д.) або в якості імені пакета програмного забезпечення, то ви повинні знайти і отримати прямий дозвіл в письмовій формі від Moodle Trust через [moodle.com службу підтримки] (http://moodle.com/helpdesk/), відповідно з нормами обмежень на товарні знаки.

Там немає ніяких обмежень щодо того, як ви використовуєте ім\'я в інших контекстах (наприклад, якщо ви використовуєте Moodle просто для читання курсів, то ви можете використовувати ім\'я вільно.) Якщо ви не впевнені в тому чи іншому випадку, будь ласка, запитаєте нас через [moodle.com службу підтримки] (http://moodle.com/helpdesk/). Ми будемо раді або надати вам офіційного дозволу в письмовій формі, або допомогти вам вирішити ваш випадок.';
$string['logotitle'] = 'Логотип Moodle';
$string['manageads'] = 'Керування партнерською рекламою';
$string['managedonations'] = 'Керування пожертвами';
$string['moodleorg:manageads'] = 'Керування партнерською рекламою';
$string['moodleorg:managedonations'] = 'Керування реєстром пожертв';
$string['moodlepartner_corporate'] = 'Корпоративне навчання';
$string['moodlepartner_other'] = 'Інші сектори';
$string['moodlepartner_school'] = 'Школа';
$string['moodlepartner_university'] = 'Університет';
$string['networkinfo'] = 'Наступні сайти Moodle були підключені до moodle.org з використанням Мережі Moodle, так що ви можете увійти до них прямо звідси.';
$string['networktitle'] = 'Під’єднані сайти';
$string['newregistrations'] = 'Нові реєстрації';
$string['newstitle'] = 'Оголошення';
$string['noenrolledcoursesyet'] = 'Ви ще не записані на жоден курс на цьому сайті';
$string['partnerslogan'] = 'Moodle Проєкт підтримується понад 90 сертифікованими <a href="https://moodle.com/partners/">Moodle Партнерами</a> по всьому світу.';
$string['permalink'] = 'Постійне посилання';
$string['pluginname'] = 'Сайт Moodle.org';
$string['popularissues'] = 'Найпопулярніші питання';
$string['privacy:metadata:db:registerdonations'] = 'Зберігає записи про пожертви Moodle';
$string['privacy:metadata:db:registerdonations:amount'] = 'Сума';
$string['privacy:metadata:db:registerdonations:name'] = 'Ім\'я';
$string['privacy:metadata:db:registerdonations:org'] = 'Організація';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Час пожертви';
$string['privacy:metadata:db:registerdonations:url'] = 'URL-адреса пожертвувача';
$string['recentlyratedposts'] = 'Нещодавніх повідомлень за рейтингом';
$string['recentpart'] = 'Ця сторінка показує частину людей. які сьогодні відвідували moodle.org';
$string['registeredsites'] = 'Навчальні заклади не зобов’язані інформувати будь-кого про своє використання Moodle, оскільки Moodle - це вільне програмне забезпечення. Одначе, частина сайтів зареєстровано у нас і ви можете побачити їх список.';
$string['registeredsitestitle'] = 'Зареєстровані сайти';
$string['registereduserslastday'] = 'Нові користувачі за останні 24 години:';
$string['registereduserstotal'] = 'Всього зареєстрованих користувачів';
$string['registrationgraphalt'] = 'Реєстрація Moodle за весь час';
$string['registrationgraphdesc'] = 'Ми проводимо <a href="http://docs.moodle.org/en/Usage">регулярну перевірку сайтів</a> , щоб переконатися, що вони все ще існують, тому іноді ви можете побачити зменшення їх кількості';
$string['registrationslast6months'] = 'Реєстрація за останні 6 місяців';
$string['registrationslastmonths'] = 'Реєстрації за останні {$a} місяців';
$string['registrationstotal'] = 'Всі поточні реєстрації';
$string['resources_courses'] = 'Курси';
$string['resources_jobs'] = 'Вакансії';
$string['resources_plugins'] = 'Модулі';
$string['roadmap'] = 'План розробки Moodle';
$string['rssdescription'] = 'Останні або популярні повідомлення форуму з moodle.org';
$string['rssmoodlecommore'] = 'Подивитися всі останні новини';
$string['rssmoodlecomtitle'] = 'Останні новини';
$string['rsstitle'] = 'Повідомлення форуму Moodle.org';
$string['searchmoodleorg'] = 'Пошук moodle.org';
$string['securitytitle'] = 'Інформація з безпеки';
$string['shop'] = 'Шукаєте спосіб показати себе частиною спільноти? Відвідайте магазин футболок, кухлів та інших речей.';
$string['social-facebook-moodle'] = 'Офіційна сторінка Moodle на Facebook';
$string['social-googleplus-community'] = 'Офіційна спільнота Moodle на Google+';
$string['social-googleplus-moodle'] = 'Офіційна сторінка Moodle на Google+';
$string['social-linkedin-moodle'] = 'Офіційна сторінка Moodle на LinkedIn';
$string['social-twitter-moodle'] = 'Офіційні повідомлення з Moodle, зібрані новини з Планети Moodle та Moodle Buzz, і корисні повідомлень на форумі';
$string['social-twitter-moodledev'] = 'Новини розробки та оновлень Moodle';
$string['social-twitter-moodlehq'] = 'Твіти з Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Вакансії пов’язані з Moodle';
$string['social-twitter-moodlenet'] = 'Відкриті Moodle курси та зміст';
$string['social-twitter-moodleplugins'] = 'Нові доповнення для Moodle';
$string['social-twitter-moodleresearch'] = 'Новини та оновлення на щорічній науковій Moodle конференції та дослідження пов’язані з Moodle';
$string['social-twitter-moodlesecurity'] = 'Оголошення безпеки Moodle';
$string['social-twitter-moodlesites'] = 'Оновлення статусів для мережі Moodle HQ сайтів і послуг';
$string['social-twitter-moodlethemes'] = 'Нові релізи тем оформлення';
$string['social-youtube-moodle'] = 'Офіційний канал Moodle на YouTube';
$string['socialinfo'] = 'Ми знаходимося на декількох сайтах соціальних мемереж для підвищення обізнаності про проект Moodle і щоб поділитися останніми новинами та подіями в світі Moodle. Слідкуйте за нами, щоб залишатися в темі і зустрічатися з іншими в спільноті!';
$string['socialtitle'] = 'Соціальні мережі';
$string['statscountries'] = 'Країн';
$string['statscourses'] = 'Курсів';
$string['statsenrolments'] = 'Записів на курси';
$string['statsposts'] = 'Повідомлень у форумах';
$string['statsquestions'] = 'Питань для тестів';
$string['statsresources'] = 'Ресурсів';
$string['statsteachers'] = 'Викладачів';
$string['statsusers'] = 'Користувачів';
$string['supportbooks'] = 'Ми маємо список книг про Moodle, які ви можете придбати.';
$string['supportcommercial'] = 'Moodle Партнери - це група авторизованих сервісних компаній світу, які фінансово підтримують проект Moodle. Вони надають широкий спектр додаткових комерційних послуг для користувачів в усьому світі:';
$string['supportdocs1'] = 'Найкраще почати з Документації Moodle, особливо зі сторінок частих питань (FAQ).';
$string['supportdocs2'] = 'Зручний шлях отримання потрібної документації - використання посилань "Документація Moodle для цієї сторінки" в нижній частині кожної сторінки вашого сайту Moodle.';
$string['supportdocsfaq'] = 'Часті питання';
$string['supportdocslang'] = 'Документація Moodle іншими мовами';
$string['supportforums'] = 'Наша спільнота користувачів спілкується на форумах у складі "курсів" на цьому сайті, який власне працює на платформі Moodle. Ви можете "записатися" на курс, щоб писати у форумах (запис абсолютно безкоштовний).';
$string['supportforumsenglish'] = 'Основні обговорення пов’язані з підтримкою та розробкою проходять між користувачами та розробниками англійською мовою тут:';
$string['supportforumsenglishname'] = 'Використання Moodle';
$string['supportforumslang'] = 'Головний форум користувачів Moodle англійською мовою тут:';
$string['supportforumslangname'] = 'Вітальня Moodle';
$string['supportforumslangurl'] = 'https://moodle.org/course/view.php?id=17228';
$string['supportforumslist'] = 'Також є інші форуми на різних мовах:';
$string['supportforumslistname'] = 'Список всіх форумів';
$string['supportintro'] = 'Ви не самотні! Існує кілька способів отримати допомогу по роботі з Moodle, коли вона вам потрібна.';
$string['top10countriesbyregistration'] = 'Перша десятка країн за кількістю реєстрацій';
$string['top10sitesbycourses'] = 'Перша десятка сайтів за кількістю курсів';
$string['top10sitesbyusers'] = 'Перша десятка сайтів за кількістю користувачів';
$string['versionsused'] = 'Використано версію';
