<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'sr_lt', version '4.1'.
 *
 * @package     local_amos
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS je centralni repozitorijum Moodle stringova, kao i istorije njihovih prethodnih prevoda. Repozitorijum prati dodavanje engleskih stringova u Moodle kôd, prikuplja prevode, upravlja uobičajenim zadacima  u vezi sa prevođenjem i generiše jezičke pakete koji se koriste na Moodle serverima.</p>
<p>Za više informacija pogledajte <a href="https://docs.moodle.org/dev/AMOS_manual">AMOS dokumentaciju</a>.</p>';
$string['amos'] = 'AMOS alat za prevođenje';
$string['amos:changecontriblang'] = 'Promeni jezik prevedenih stringova';
$string['amos:commit'] = 'Predaj radnu verziju prevedenih stringova u glavni repozitorijum';
$string['amos:execute'] = 'Izvrši dati AMOScript';
$string['amos:importfile'] = 'Uvezite stringove iz postavljene datoteke i prebacite ih u radnu verziju';
$string['amos:importstrings'] = 'Uvezite stringove (uključujući i engleske) direktno u glavni repozitorijum';
$string['amos:manage'] = 'Uredi AMOS portal';
$string['amos:stage'] = 'Koristi AMOS alat za prevođenje i unesi stringove u radnu verziju';
$string['amos:stash'] = 'Sačuvaj trenutnu radnu verziju u trajno sačuvane stringove';
$string['amos:usegoogle'] = 'Koristi Google servis za prevođenje';
$string['applangindexfile'] = 'Lokacije Moodle App langindex datoteke';
$string['applangindexfile_desc'] = 'Kompletna URL adresa sa kojemožete preuzeti datoteku. To će biti urađeno pomoću kron zadatka.';
$string['branchesall'] = 'Sve poznate Moodle verzije';
$string['branchesall_desc'] = 'Spisak kôdova Moodle verzija, odvojenih zarezima koje AMOS podržava. Ovo se koristi kako bi se popunio spisak verzija u filteru alata za prevođenje, kao i na drugim mestima.';
$string['branchsupported'] = 'Najstarija podržana Moodle verzije';
$string['branchsupported_desc'] = 'Kôd najstarije Moodle verzije koji još uvek treba da se prati zbog promena u engleskim stringovima i za koji se generišu jezički paketi za instalaciju. Za više informacija pogledajte <https://docs.moodle.org/dev/Releases#Version_support>';
$string['cachedef_lists'] = 'Spiskovi jezika i komponenti poznatih u AMOS-u';
$string['cachedef_stats'] = 'Statistički podaci koje generiše AMOS';
$string['commitbutton'] = 'Predaj prevod';
$string['commitkeepstaged'] = 'Ostavi stringove u radnoj verziji';
$string['commitmessage'] = 'Poruka uz predati prevod';
$string['commitmessageempty'] = 'Molimo vas da popunite poruku uz predati prevod';
$string['commitstage'] = 'Predaj radnu verziju prevedenih stringova';
$string['commitstage_help'] = 'Permanentno smešta sve prevedene stringove radne verzije u AMOS repozitorijum. Pre predaje automatski se uklanjaju stringovi koji se ne mogu predati kao i zastareli stringovi. Čuvaju se samo prevedeni stringovi koji se mogu predati. To znači da će biti predati samo oni stringovi koji su obeleženi zelenom bojom. Nakon predaje prevedenih stringova iz radne verzije se uklanjaju svi stringovi.';
$string['committable'] = 'Imate dozvolu da predate prevedene stringove u ovaj jezički paket';
$string['committableall'] = 'svi jezici';
$string['committablenone'] = 'nemate ovlašćenja ni nad jednim jezikom - molimo kontaktirajte AMOS menadžera';
$string['componentsall'] = 'Sve';
$string['componentsapp'] = 'Moodle App';
$string['componentsnone'] = 'Nijedna';
$string['componentsstandard'] = 'Standardne';
$string['confirmaction'] = 'Ova operacija se ne može poništiti. Jeste li sigurni?';
$string['contribaccept'] = 'Prihvati';
$string['contribactions'] = 'Akcije sa predatim prevodima';
$string['contribactions_help'] = 'Zavisno od vaših prava i toka obrade prevoda, na raspolaganju su vam sledeće akcije:

* Primeni - kopira u vašu radnu verziju sve prevedene stringove, ne menjajući ih
* Dodeli meni - postavlja vas kao osobu koja je odgovorna za pregled i integraciju poslatih prevoda
* Opozovi dodelu - ukida sve dodele  - prevod nikome nije dodeljen za pregled i proveru
* Započni pregled - dodeljuje vama nove prevode, podešava status na \'Na pregledu\' i kopira poslate prevode u vašu radnu verziju
* Prihvati - obeležava poslate prevode kao prihvaćene
* Odbij - obeležava poslate prevode kao odbijene. Molimo da u komentaru objasnite razloge odbijanja.

Prevodilac će biti obavešten e-poštom, kada dođe do promene statusa prevoda koje je poslao.';
$string['contribactions_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribapply'] = 'Primeni';
$string['contribassignee'] = 'Zadužen/a';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Dodeli meni';
$string['contribauthor'] = 'Autor';
$string['contribclosedno'] = 'Sakrij prihvaćene prevode';
$string['contribclosedyes'] = 'Prikaži prihvaćene prevode';
$string['contribcomponents'] = 'Komponente';
$string['contribid'] = 'ID';
$string['contribincomingnone'] = 'Nema novih prevoda';
$string['contribincomingsome'] = 'Novi prevodi ({$a})';
$string['contriblanguage'] = 'Jezik';
$string['contriblanguagebutton'] = 'Konvertuj';
$string['contriblanguagechange'] = 'Ispravljanje pogrešnog jezika paketa';
$string['contriblanguagechange_help'] = 'Ako je prevod stringova greškom poslat u pogrešan jezički paket, izaberite ispravan jezik iz donjeg padajućeg menija, a zatim kliknite na dugme \'Konvertuj\'.';
$string['contriblanguagereport'] = 'Prijavljivanje prevoda poslatog u pogrešan jezički paket';
$string['contriblanguagereport_help'] = 'Ako je ovaj prevod stringova greškom poslat u pogrešan jezički paket, molimo vas da kopirate URL adresu prevoda i pošaljete je e-poštom na `translation@moodle.org`. Prevod će potom biti premešten u odgovarajući jezički paket.';
$string['contriblanguagewrong'] = 'Pogrešan jezik?';
$string['contribnotif'] = '[AMOS] Obaveštenje o poslatom prevodu (#{$a->id})';
$string['contribnotifaccepted'] = '{$a->fullname} je prihvatio/la vaš prevod
#{$a->id} {$a->subject}

---------------------------------------------------------------------
Stranica sa prevodom: {$a->contriburl}';
$string['contribnotifcommented'] = '{$a->fullname} je dao/la komentar na poslati prevod
#{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

---------------------------------------------------------------------
Stranica sa prevodom: {$a->contriburl}';
$string['contribnotifconverted'] = '{$a->fullname} je premestio/la vaš prevod stringova
#{$a->id} {$a->subject}

Hvala na stringovima koje ste preveli. Međutim, čini se da ste prevod greškom poslali u pogrešan
jezički paket. Zbog toga je vaš prevod stringova odbijen i premešten iz
pogrešnog u ispravan jezički paket, na pregled od strane
menadžera odgovaraućeg paketa. Od vas se ne traži nikakva akcija.

Ubuduće, molimo vas da dobro proverite da li ste izabrali svoj jezik pre nego
što započnete prevođenje stringova.

---------------------------------------------------------------------
Originalna stranica sa prevodom: {$a->contriborigurl}
Nova stranica sa prevodom: {$a->contribnewurl}';
$string['contribnotifpending'] = 'Postoji prevod stringova na čekanju koji zahteva vašu akciju
#{$a->id} {$a->subject}

Kao menadžer jezičkog paketa, potrebno je da pregledate prevod i eventualno
prihvatite sve prevedene stringove. Kada završite, obeležite ih kao prihvaćene ili
odbijene.

Za više informacija pogledajte {$a->docsurl}.
---------------------------------------------------------------------
Stranica sa prevodom: {$a->contriburl}';
$string['contribnotifrejected'] = '{$a->fullname} je odbio/la vaš prevod stringova
#{$a->id} {$a->subject}

---------------------------------------------------------------------
Stranica sa prevodom: {$a->contriburl}';
$string['contribnotifsubmitted'] = '{$a->fullname} je predao/la novi prevod stringova
#{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

* Jezik: {$a->language}
* Komponente: {$a->components}
* Stingovi: {$a->strings}

---------------------------------------------------------------------
Stranica sa prevodom: {$a->contriburl}';
$string['contribreject'] = 'Odbij';
$string['contribresign'] = 'Opozovi dodelu';
$string['contribstaged'] = 'Radna verzija prevoda <a href="contrib.php?id={$a->id}">#{$a->id}</a> autora: {$a->author}';
$string['contribstagedinfo'] = 'Radna verzija prevoda';
$string['contribstagedinfo_help'] = 'Radna verzija sadrži stringove koje su preveli članovi zajednice. Pretpostavlja se da su menadžeri jezičkih paketa pregledali prevode stringova i potom im podesili im status na \'Prihvaćeno\' (ako su prevodi potvrđeni kao odgovarajući) ili \'Odbijeno\' (ako iz nekog razloga prevodi ne mogu da budu uključeni u zvanični jezički paket).';
$string['contribstagedinfo_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstartreview'] = 'Započnite pregled';
$string['contribstatus'] = 'Status';
$string['contribstatus0'] = 'Novo';
$string['contribstatus10'] = 'Na pregledu';
$string['contribstatus20'] = 'Odbijeno';
$string['contribstatus30'] = 'Prihvaćeno';
$string['contribstatus_help'] = 'Tok obrade poslatih prevoda se sastoji od nekoliko stanja:

* Nov - prevedeni stringovi su poslati ali još nisu pregledani
* Na pregledu - prevedeni stringovi su dodeljeni menadžeru jezičkog paketa i prebačeni u radnu verziju radi pregleda
* Odbijen - menadžer jezičkog paketa je odbio poslate prevode i verovatno ostavio objašnjenje u komentaru
* Prihvaćen - menadžer jezičkog paketa je prihvatio prevedene stringove';
$string['contribstatus_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstrings'] = 'Stringovi';
$string['contribstringseq'] = 'novih stringova: {$a->orig}';
$string['contribstringsnone'] = '{$a->orig} (svi su već prevedeni u jezičкom paketu)';
$string['contribstringssome'] = '{$a->orig} (od kojih {$a->same} već ima noviji prevod)';
$string['contribsubject'] = 'Naslov';
$string['contribsubmittednone'] = 'Nema poslatih prevoda';
$string['contribsubmittedsome'] = 'Vaši prevodi ({$a})';
$string['contribtimemodified'] = 'Izmenjeno';
$string['contribute'] = 'Predaj prevod';
$string['contributenow'] = 'Predaj prevod sada!';
$string['contributestats'] = 'Do sada je u AMOS predato ukupno <strong>{$a->count}</strong> stringova, prevedenih od strane članova zajednice';
$string['contributethanks'] = 'Veliko hvala prevodiocima {$a->listcontributors} za njihove skorašnje prevode!';
$string['contributethankslist'] = '{$a->contributor1}, {$a->contributor2}, {$a->contributor3} i {$a->contributor4}';
$string['contributions'] = 'Prevodi';
$string['creditsaddcontributor'] = 'Dodaj prevodioca';
$string['creditsaddmaintainer'] = 'Dodaj menadžera';
$string['creditscontact'] = 'Pošalji poruku';
$string['creditscontributors'] = 'Ostali prevodioci';
$string['creditsdelcontributor'] = 'Ukloni prevodioca';
$string['creditsdelmaintainer'] = 'Ukloni menadžera';
$string['creditsmaintainedby'] = 'Održava';
$string['creditsnomaintainer'] = 'U ovo trenutku ne postoji menadžer jezičkog paketa. <a href="{$a->url}">Postanite jedan od njih!</a>';
$string['creditsthanks'] = 'Na ovoj stranici želimo da se zahvalimo svima koji su doprineli prevođenju Moodlea. Njihov rad je omogući da se Moodlea raširi svuda po svetu.';
$string['creditstitlelong'] = 'Menadžeri jezičkog paketa i prevodioci';
$string['creditstitleshort'] = 'Zasluge';
$string['diff'] = 'Uporedi';
$string['diffstringmode'] = 'Prekidač režima razlika';
$string['err_exception'] = 'Greška: {$a}';
$string['err_invalidlangcode'] = 'Neispravan kôd jezika';
$string['err_parser'] = 'Greška prilikom parsiranja: {$a}';
$string['filtercmp'] = 'Komponente';
$string['filtercmp_desc'] = 'Prikaži stringove za ove komponente';
$string['filtercmpnothingselected'] = 'Molimo, izaberite komponentu';
$string['filterlng'] = 'Jezici';
$string['filterlng_desc'] = 'Prikaži prevode za ove jezike';
$string['filterlngnothingselected'] = 'Molimo, izaberite jezik';
$string['filtermis'] = 'Razno';
$string['filtermis_desc'] = 'Dodatni uslovi za prikaz stringova';
$string['filtermisfapp'] = 'samo stringovi koji se koriste u Moodle App';
$string['filtermisfapp_help'] = 'Ovaj string se koristi u Moodle Apps kao {$a}';
$string['filtermisfhas'] = 'samo prevedeni stringovi';
$string['filtermisfhlp'] = 'samo stringovi pomoći';
$string['filtermisfmis'] = 'samo nedostajući i zastareli stringovi';
$string['filtermisfout'] = 'samo zastareli stringovi';
$string['filtermisfstg'] = 'samo stringovi iz radne verzije';
$string['filtersid'] = 'Identifikator stringa';
$string['filtersid_desc'] = 'Ključ u nizu stringova';
$string['filtersidpartial'] = 'delimično poklapanje';
$string['filtertxt'] = 'Podstring';
$string['filtertxt_desc'] = 'String mora da sadrži dati tekst';
$string['filtertxtcasesensitive'] = 'VELIKA i mala slova';
$string['filtertxtregex'] = 'regularni izraz';
$string['filterver'] = 'Verzija';
$string['filterver_desc'] = 'Prikaži stringove za ovu Moodle verziju';
$string['filtervernothingselected'] = 'Molimo, izaberite verziju';
$string['foundmissing'] = 'Nedostaje: {$a}';
$string['foundmissingonthispage'] = '{$a} na ovoj stranici';
$string['foundtotal'] = 'Pronađeno: {$a}';
$string['googletranslate'] = 'pitaj Google';
$string['importfile'] = 'Uvezi prevedene stringove iz datoteke';
$string['importfile_help'] = 'Ukoliko ste svoje stringove preveli izvan AMOS-a pomoću ovog obrasca ih možete prebaciti u radnu verziju

* Datoteka mora biti ispravna Moodle PHP datoteka sa stringovima. Za primer pogledajte u direktorijum `/lang/en/` vaše Moodle instalacije.
* Naziv datoteke mora da se podudara sa nazivom iste datoteke sa stringovima engleskog jezičkog paketa za datu komponentu (npr. `moodle.php`, `assignment.php` ili `enrol_manual.php`).

Svi stringovi pronađeni u datoteci biće prebačeni u radnu verziju za izabranu verziju i jezik.

Više PHP datoteka može biti obrađeno odjednom ako ih spakujete u ZIP datoteku.';
$string['importfile_link'] = 'local/amos/importfile';
$string['language'] = 'Jezik';
$string['languagepacks'] = 'Dodatni jezički paketi mogu biti instalirani na vašem Moodle sajtu preko <em>Administracija > Administracija sajta > Jezik > Jezički paketi</em>, ili ručno. Za više informacija, pogledajte <a href="https://docs.moodle.org/en/Language_packs">Dokumentaciju za jezičke pakete</a>.';
$string['languages'] = 'Jezici';
$string['languagesall'] = 'Svi';
$string['languagesnone'] = 'Nijedan';
$string['lastavailable'] = 'Najnovija dostupna verzija';
$string['lessfilteringoptions'] = 'Manje opcija';
$string['log'] = 'Zapis';
$string['logfilterbranch'] = 'Verzije';
$string['logfiltercommithash'] = 'git heš';
$string['logfiltercommitmsg'] = 'Poruka uz predati prevod sadrži';
$string['logfiltercommits'] = 'Filtriranje predatih stringova';
$string['logfiltercommittedafter'] = 'Predato nakon';
$string['logfiltercommittedbefore'] = 'Predato pre';
$string['logfiltercomponent'] = 'Komponente';
$string['logfilterlang'] = 'Jezici';
$string['logfiltershow'] = 'Prikaži filtrirane predate prevode I stringove';
$string['logfiltersource'] = 'Izvor';
$string['logfiltersourceamos'] = 'amos (Web alat za prevođenje)';
$string['logfiltersourceautomerge'] = 'automatsko spajanje (prevod kopirani iz druge grane)';
$string['logfiltersourcebot'] = 'bot (masivne operacije izvršene od strane skripta)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOScript u poruci prilikom predaje stringova)';
$string['logfiltersourcefixdrift'] = 'fixdrift (fixed AMOS-git drift)';
$string['logfiltersourcegit'] = 'git (git kopija Moodle izvornog kôda i 1.x paketa)';
$string['logfiltersourceimport'] = 'uvezi (importovani stringovi za nestandardne dodatke)';
$string['logfiltersourcerevclean'] = 'revclean (obrnuti postupak čišćenja)';
$string['logfilterstringid'] = 'Identifikator stringa';
$string['logfilterstrings'] = 'Filter stringova';
$string['logfilterusergrp'] = 'Prevodilac';
$string['logfilterusergrpor'] = 'ili';
$string['maintainers'] = 'Menadžeri jezičkog paketa';
$string['manageamos'] = 'Upravljanje AMOS-om';
$string['markuptodate'] = 'Označavanje prevoda kao ažurnog';
$string['markuptodatelabel'] = 'označi kao ažuran';
$string['messageprovider:checker'] = 'Rezultati provere jezičkog paketa';
$string['messageprovider:contribution'] = 'Prevodi';
$string['morefilteringoptions'] = 'Više opcija';
$string['newlanguage'] = 'Novi jezik';
$string['nodiffs'] = 'Nije pronađena nijedna razlika';
$string['nofiletoimport'] = 'Navedite datoteku za uvoz podataka.';
$string['nologsfound'] = 'Nijedan string nije pronađen, molimo promenite filtere';
$string['nostringsfound'] = 'Nijedan string nije pronađen';
$string['nostringtoimport'] = 'Nijedan ispravan string nije pronađen u datoteci. Proverite da li je ime datoteke ispravno i da li je pravilno formatirana.';
$string['nothingtostage'] = 'Operacija nije vratila nijedan string koji bi mogao da bude prebačen u radnu verziju';
$string['novalidzip'] = 'Nije moguće raspakovati ZIP datoteku';
$string['numofcommitsabovelimit'] = 'Pronađeno je {$a->found} prevoda stringova koji se podudaraju sa filterom, koristeći {$a->limit} najnovijih';
$string['numofcommitsunderlimit'] = 'Pronađeno je {$a->found} prevoda stringova koji se podudaraju sa filterom';
$string['numofmatchingstrings'] = 'U okviru ovih prevoda, {$a->strings} izmena/e u {$a->commits} prevoda se podudara sa filterom stringova';
$string['outdatednotcommitted'] = 'Zastareli stringovi';
$string['outdatednotcommitted_help'] = 'AMOS je otkrio da je ovaj string možda zastareo, pošto je engleska verzija izmenjena nakon što je string preveden. Molimo, pregledajte prevod.';
$string['outdatednotcommittedwarning'] = 'Zastarelo';
$string['ownstashactions'] = 'Akcije sa sačuvanim stringovima';
$string['ownstashactions_help'] = '* Primeni - kopira prevedene stringove iz sačuvanih stringova (stash) u radnu verziju (stage), ne menjajući pri tome  sačuvane strinove. Ako string već postoji u radnoj verziji, on će biti prepisan stringom koji se nalazi u sačuvanim stringovima.
* Primeni/Odbaci (Pop) - premešta prevedene stringove u radnu verziju i potpuno briše sve sačuvane stringovе (tj. istovremeno izvršava komande Primeni i Odbaci).
* Odbaci - odbacuje tj. briše sačuvane stringove.
* Pošalji - otvara obrazac za slanje sačuvanih stringova zvaničnim menadžerima  jezičkog paketa, tako da oni mogu da uključe vaš prevod u zvanični jezički paket.';
$string['ownstashes'] = 'Vaši sačuvani stringovi';
$string['ownstashes_help'] = 'Ovo je spisak svih vaših sačuvanih stringova';
$string['ownstashesnone'] = 'Nema vaših sačuvanih stringova';
$string['permalink'] = 'Permanentni link';
$string['placeholder'] = 'Varijable (rezervisana mesta)';
$string['placeholder_help'] = 'Varijable (rezervisana mesta) su specijalne oznake unutar stringa, poput `{$a}` ili `{$a->something}`. One se zamenjuju odgovarajućim vrednostima prilikom prikazivanja stringa.

Važno je da ove varijable budu kopirane tačno onako kako su navedene u originalnom, engleskom, stringu. Nemojte ih prevoditi niti menjati njihovu orijentaciju sleva-nadesno.';
$string['placeholderwarning'] = 'promenljive (rezervisana mesta)';
$string['pluginclasscore'] = 'Ključni podsistemi';
$string['pluginclassnonstandard'] = 'Nestandardni dodaci';
$string['pluginclassstandard'] = 'Standardni dodaci';
$string['pluginname'] = 'AMOS';
$string['plugintypelocations'] = 'Lokacije tipova dodataka';
$string['plugintypelocations_desc'] = 'Omogućava da se definišu lokacije dodatnih standardnih tipova dodataka, kao što su tipovi poddodataka koje obezbeđuju standardni dodaci ili zastareli tipovi.';
$string['presetcommitmessage'] = 'Prevod #{$a->id} autora: {$a->author}';
$string['presetcommitmessage2'] = 'Nedostajući stringovi iz {$a->source} su integrisani u {$a->target} granu';
$string['presetcommitmessage3'] = 'Ispravljanje razlika između {$a->versiona} i {$a->versionb}';
$string['privacy:commitnumber'] = 'Predati prevod  {$a}';
$string['privacy:contribnumber'] = 'Prevod {$a}';
$string['privacy:filterusage'] = 'Upotreba filtera';
$string['privacy:metadata:db:amoscommits'] = 'Čuva sve meta-podatke vezane za predate prevode';
$string['privacy:metadata:db:amoscommits:commitmsg'] = 'Poruka koju je korisnik poslao uz predati prevod';
$string['privacy:metadata:db:amoscommits:timecommitted'] = 'Vremenska oznaka predatog prevoda';
$string['privacy:metadata:db:amoscommits:userinfo'] = 'Identifikacija korisnika kao što je to navedeno na izvornoj lokaciji, gde je prevod predat, npr. u Gitu.';
$string['privacy:metadata:db:amoscontributions'] = 'Prevodi članova zajednice';
$string['privacy:metadata:db:amoscontributions:lang'] = 'Kôd jezika kome ovaj prevod pripada.';
$string['privacy:metadata:db:amoscontributions:message'] = 'Početna poruka koja opisuje poslate prevode stringova.';
$string['privacy:metadata:db:amoscontributions:stashid'] = 'Interni identifikator priložene kopije sačuvanih stringova.';
$string['privacy:metadata:db:amoscontributions:status'] = 'Status toka prevoda';
$string['privacy:metadata:db:amoscontributions:subject'] = 'Naslov poslatog prevoda';
$string['privacy:metadata:db:amoscontributions:timecreated'] = 'Vremenska oznaka kada je zapis prevoda kreiran.';
$string['privacy:metadata:db:amoscontributions:timemodified'] = 'Vremenska oznaka kada je zapis prevoda nedavno menjan.';
$string['privacy:metadata:db:amosfilterusage'] = 'Zapis korišćenja filtera AMOS alata za prevođenje.';
$string['privacy:metadata:db:amosfilterusage:currentlang'] = 'Jezik tekuće sesije.';
$string['privacy:metadata:db:amosfilterusage:ismaintainer'] = 'Da li korisnik ima dozvolu da preda prevod u AMOS repozitorijum?';
$string['privacy:metadata:db:amosfilterusage:numofcomponents'] = 'Broj izabranih komponenti';
$string['privacy:metadata:db:amosfilterusage:numoflanguages'] = 'Broj izabranih jezika';
$string['privacy:metadata:db:amosfilterusage:numofversions'] = 'Broj izabranih verzija';
$string['privacy:metadata:db:amosfilterusage:showexistingonly'] = 'Da li treba prikazati samo postojeće prevode?';
$string['privacy:metadata:db:amosfilterusage:showgreylistedonly'] = 'Da li treba prikazati samo zasivljene stringove?';
$string['privacy:metadata:db:amosfilterusage:showhelpsonly'] = 'Da li treba prikazati samo stringove pomoći?';
$string['privacy:metadata:db:amosfilterusage:showmissingonly'] = 'Da li bi treba prikazati samo nedostajuće i zastarele stringove?';
$string['privacy:metadata:db:amosfilterusage:showoutdatedonly'] = 'Da li bi treba prikazati samo zastarele stringove?';
$string['privacy:metadata:db:amosfilterusage:showstagedonly'] = 'Da li bi treba prikazati samo stringove iz radne verzije?';
$string['privacy:metadata:db:amosfilterusage:showwithoutgreylisted'] = 'Da li zasivljene stringove treba ukloniti iz rezultata?';
$string['privacy:metadata:db:amosfilterusage:stringidpartial'] = 'Da li se zahteva delimično poklapanje za stringid?';
$string['privacy:metadata:db:amosfilterusage:substringcasesensitive'] = 'Da li podstring treba tretirati osetljivim na velika i mala slova?';
$string['privacy:metadata:db:amosfilterusage:substringregex'] = 'Da li podstring treba tretirati kao regularni izraz?';
$string['privacy:metadata:db:amosfilterusage:timesubmitted'] = 'Vremenska oznaka kada je obrazac za filtriranje poslat';
$string['privacy:metadata:db:amosfilterusage:usercountry'] = 'Kôd države korisnika kao što je izabrano u njegovom profilu';
$string['privacy:metadata:db:amosfilterusage:userlang'] = 'Preferirani jezik korisnika preuzet iz njegovog profila';
$string['privacy:metadata:db:amosfilterusage:usesdefaultlang'] = 'Da li je korisnik koristio unapred izabrane jezike?';
$string['privacy:metadata:db:amosfilterusage:usesdefaultversion'] = 'Da li je korisnik koristio unapred izabrane verzije u obrascu?';
$string['privacy:metadata:db:amosfilterusage:withstringid'] = 'Da li je ID oznaka stringa (stringid) navedena?';
$string['privacy:metadata:db:amosfilterusage:withsubstring'] = 'Da li je naveden podstring za pretragu?';
$string['privacy:metadata:db:amosstashes'] = 'Čuva informacije o sačuvanim prevedenim stringovima u skladištu prevoda';
$string['privacy:metadata:db:amosstashes:components'] = 'Spisak komponenti koji se čuvaju među sačuvanim stringovima';
$string['privacy:metadata:db:amosstashes:id'] = 'Interni identifikator sačuvanih stringova';
$string['privacy:metadata:db:amosstashes:languages'] = 'Spisak jezika koji se nalaze među sačuvanim stringovima';
$string['privacy:metadata:db:amosstashes:message'] = 'Poruka koja opisuje sačuvane stringove. Koristi se kao standardna poruka koja se šalje uz predati prevod, kada se sačuvani stringovi predaju kao prevod u jezički paket.';
$string['privacy:metadata:db:amosstashes:name'] = 'Naziv ili naslov sačuvanih stringova';
$string['privacy:metadata:db:amosstashes:strings'] = 'Naslov sačuvanih stringova';
$string['privacy:metadata:db:amosstashes:timecreated'] = 'Vremenska oznaka kada kopija sačuvanih stringova kreirana';
$string['privacy:metadata:db:amosstashes:timemodified'] = 'Vremenska oznaka kada je zapis nedavno menjan.';
$string['privacy:metadata:db:amostranslators'] = 'Opisuje odnos između jezičkog paketa i korisnika. Ovo može biti menadžer jezičkog paketa (ima ovlašćenja da prevod stringova ubaci u jezički paket) ili saradnik u prevođenju (prikazuje se na stranici korisnika zaslužnih za prevod).';
$string['privacy:metadata:db:amostranslators:lang'] = 'Kôd jezika za koji prevodilac ima dozvolu prevođenje, ili zvezdica za sve jezike.';
$string['privacy:metadata:db:amostranslators:status'] = 'Određuje da li je korisnik menadžer jezičkog paketa (0) ili saradnik u prevođenju (1) jezičkog paketa.';
$string['privacy:metadata:external:languagepacks'] = 'Prevodi stringova se izvoze u ZIP datoteke koje se distribuiraju globalno i instaliraju na Moodle sajtove.';
$string['privacy:metadata:external:languagepacks:email'] = 'Adresa e-pošte prevodioca (saradnika u prevođenju) može biti uključena u datoteke jezičkog paketa.';
$string['privacy:metadata:external:languagepacks:firstname'] = 'Ime prevodioca (saradnika u prevođenju) može biti uključena u datoteke jezičkog paketa.';
$string['privacy:metadata:external:languagepacks:lastname'] = 'Prezime prevodioca (saradnika u prevođenju) može biti uključena u datoteke jezičkog paketa.';
$string['privacy:metadata:subsystem:comment'] = 'Opišite kako dodatak koristi podsistem za komentare.';
$string['privacy:stashnumber'] = 'Sačuvani stringovi {$a}';
$string['privileges'] = 'Vaše privilegije';
$string['privilegesnone'] = 'Imate pravo samo da čitate javno dostupne informacije.';
$string['processing'] = 'Obrada...';
$string['quicklinks'] = 'Brzi linkovi';
$string['quicklinks_amos'] = 'AMOS alat za prevođenje';
$string['quicklinks_forum'] = 'Forum za prevođenje';
$string['quicklinks_manual'] = 'Uputstvo za korišćenje';
$string['quicklinks_newcomers'] = 'Pomoć za početnike';
$string['requestactions'] = 'Akcija';
$string['requestactions_help'] = '* Primeni - kopiraj prevedene stringove iz repozitorijuma (\'pull request\') u radnu verziju. Ako je string već u radnoj verziji, biće zamenjen kopijom iz sačuvanih stringova.
* Sakrij - blokira repozitorijum tako da vam se on više neće prikazivati.';
$string['savefilter'] = 'Prikaži stringove';
$string['script'] = 'AMOScript';
$string['script_help'] = 'AMOScript predstavlja skup instrukcija koji se izvršava nad repozitorijumom stringova';
$string['scriptexecute'] = 'Izvrši i rezultat prebaci u radnu verziju';
$string['sourceversion'] = 'Izvorna verzija';
$string['stage'] = 'Radna verzija';
$string['stageactions'] = 'Akcije sa radnom verzijom';
$string['stageactions_help'] = '* Uredi radnu verziju prevoda - menja podešavanja filtera prevoda tako da se prikazuju samo prevedeni stringovi radne verzije.
* Odbaci prevode koje se ne mogu predati - uklanja iz radne verzije sve prevedene stringove koje ne možete da predate. Pre predaje, iz radne verzije se automatski uklanjaju takvi stringovi.
* Ukloni zastarele prevode - uklanja iz radne verzije sve prevedene stringove koji, ili ne menjaju tekući prevod, ili su stariji od najnovijih prevoda u repozitorijumu. Pre predaje, iz radne verzije se automatski uklanjaju zastareli prevodi.
* Obriši sve prevode - uklanja iz radne verzije sve prevedene stringove';
$string['stagedownload'] = 'Preuzmi';
$string['stageedit'] = 'Uredi stringove radne verzije';
$string['stageprune'] = 'Odbaci prevode koje se ne mogu predati';
$string['stagerebase'] = 'Ukloni zastarele prevode';
$string['stagestringsnocommit'] = 'Broj prevedenih stringova u radnoj verziji: {$a->staged}';
$string['stagestringsnone'] = 'Nema prevedenih stringova u radnoj verziji';
$string['stagestringssome'] = 'Broj prevedenih stringova u radnoj verziji: {$a->staged}, od kojih {$a->committable} može biti predato';
$string['stagesubmit'] = 'Pošalji stringove menadžeru jezičkog paketa';
$string['stagetoolopen'] = 'Idi na radnu verziju';
$string['stagetranslation'] = 'Prevod';
$string['stagetranslation_help'] = 'Prikazuje prevedene stringove radne verzije koji će biti poslati. Boja pozadine ćelije znači:

* Zeleno - dodali ste prevod koji nedostaje i dozvoljeno vam je da ga pošaljete.
* Žuto - izmenili ste string i dozvoljeno vam je da pošaljete promene
* Plavo - promenili ste prevod ili dodali nedostajući ali vam nije dozvoljeno da ih pošaljete u dati jezički paket.
* Bez boje - prevedeni string u radnoj verziji je isti kao već postojeći i zato neće biti poslat.';
$string['stageunstageall'] = 'Obriši sve prevode';
$string['standardcomponents'] = 'Spisak standardnih komponenti';
$string['standardcomponents_desc'] = 'Spisak standardnih komponenti. Opcioni broj označava verziju kôda od kada je komponenta postala standardna. Ako je broj negativan, to označava poslednju verziju kada je komponenta bila prisutna kao standardna. Oba broja mogu biti prisutna. Primer:

* ` mod_workshop ` - bez verzija, ova komponenta se smatra standardnom za sve verzije
* ` report_infectedfiles 310 ` - označava komponentu koju treba smatrati standardnom počevši od Moodle verzije 3.10
* ` theme_clean 25 -36 ` - standardna komponenta počevši od Moodle verzije 2.5 do verzije 3.6, uključujući i tu verziju';
$string['stashactions'] = 'Sačuvaj tekući prevod';
$string['stashactions_help'] = 'Deo AMOS-a \'Sačuvani stringovi\' (stash) predstavlja snimak tekuće radne verzije (stage). Sačuvani stringovi mogu biti poslati menadžeru zvaničnog jezičkog paketa za uključivanje u jezički paket.';
$string['stashapply'] = 'Primeni';
$string['stashautosave'] = 'Automatska rezervna kopija sačuvanih stringova';
$string['stashautosave_help'] = 'Ova kopija sačuvanih stringova (stash) sadrži najnoviji snimak radne verzije prevedenih stringova. Možete je koristiti kao rezervnu kopiju, npr. u slučaju kada greškom izgubite sve prevedene stringove radne verzije. Upotrebite komandu \'Primeni\' da biste kopirali sve sačuvane stringove u radnu verziju (ako u radnoj verziji već postoji prevod nekog stringa, on će biti zamenjen prevodom iz kopije sačuvanih stringova).';
$string['stashcomponents'] = '<span>Komponente:</span> {$a}';
$string['stashdownload'] = 'Preuzmi';
$string['stashdrop'] = 'Odbaci';
$string['stashdropconfirm'] = 'Da li zaista želite da trajno obrišete kopiju sačuvanih stringova <em>\'{$a}\'</em>?';
$string['stashes'] = 'Sačuvani stringovi';
$string['stashlanguages'] = '<span>Jezici:</span> {$a}';
$string['stashpop'] = 'Primeni/Odbaci (Pop)';
$string['stashpush'] = 'Prebaci sve stringove iz radne verzije među sačuvane stringove';
$string['stashstrings'] = '<span>Broj stringova:</span> {$a}';
$string['stashsubmit'] = 'Pošalji menadžeru jezičkog paketa';
$string['stashsubmitdetails'] = 'Detalji o poslatom prevodu';
$string['stashsubmitmessage'] = 'Poruka';
$string['stashsubmitsubject'] = 'Naslov';
$string['stashtitle'] = 'Naziv sačuvanih stringova';
$string['stashtitledefault'] = 'Tekući prevod - {$a->time}';
$string['stdvernotebetween'] = 'Standardno od {$a->from} do {$a->to}';
$string['stdvernotefrom'] = 'Standardno od {$a->from}';
$string['stdvernoteto'] = 'Standardno do {$a->to}';
$string['stringhistory'] = 'istorija';
$string['strings'] = 'Stringovi';
$string['stringversionnotlatest'] = 'postoji novija verzija';
$string['submitting'] = 'Slanje prevoda';
$string['submitting_help'] = 'Ovo će prevedene stringove poslati zvaničnim menadžerima jezičkog paketa. Oni će moći vaš prevod da prebace u svoje radne verzije, pregledaju ga i na kraju prihvate. Molimo da im prilikom slanja prevoda pošaljete i poruku u kojoj ćete opisati šta ste uradili i zašto biste želeli da stringovi koje ste preveli bude uključen u prevod.';
$string['targetversion'] = 'Ciljna verzija';
$string['timeline'] = 'Hronologija stringa';
$string['timelineheading'] = 'Hronologija stringa: {$a->component} | {$a->strname}';
$string['translatortool'] = 'Alat za prevođenje';
$string['translatortoolopen'] = 'Otvoreni AMOS alat za prevođenje';
$string['translatortranslation'] = 'Prevod';
$string['translatortranslation_help'] = 'Kliknite na ćeliju kako biste mogli da uređujete njen sadržaj. Unesite prevod i kliknite izvan ćelije da sačuvate prevod. Boja pozadine ćelije označava:

* Zeleno - string je već preveden, možete eventualno da izmenite prevod.
* Žuto - string je možda zastareo.. Engleska verzija je verovatno promenjena nakon što je string bio preveden.
* Crveno - string još nije preveden.
* Plavo - promenili ste prevod i on je sada u radnoj verziji.
* Sivo - AMOS ne može da se koristi za prevod ovog stringa. Na primer, stringovi za Moodle  1.9 moraju da se uređuje samo preko CVS pristupa.

Menadžeri jezičkog paket mogu da vide mali crveni simbol u uglu ćelija čije sadržaje (prevode) mogu da potvrde.';
$string['typecontrib'] = 'Nestandardni dodaci';
$string['typecontribbadge'] = 'Nestandardni';
$string['typecore'] = 'Ključni podsistemi';
$string['typecorebadge'] = 'Ključni';
$string['typestandard'] = 'Standardni dodaci';
$string['typestandardbadge'] = 'Standardni';
$string['unableenfixaddon'] = 'Popravke engleskih stringova dozvoljene su samo za standardne dodatke';
$string['unableenfixcountries'] = 'Nazivi zemalja kopiraju se iz ISO 3166-1';
$string['unableunmaintained'] = 'Trenutno ne postoji menadžer za jezički paket \'{$a}\', tako da vaš prevod ne može da bude prihvaćen. Molimo vas da razmotrite mogućnost da postanete menadžer \'{$a}\' jezičkog paketa.';
$string['unstage'] = 'ukloni iz radne verzije';
$string['unstageconfirm'] = 'Potvrdite uklanjanje iz radne verzije';
$string['unstageconfirmlong'] = '<p>Nameravate da iz radne verzije uklonite prevod stringa <code>{$a->stringid}</code>, komponente <code>{$a->component}</code>, jezičkog paketa <code>{$a->language}</code>.</p><p>Da li ste sigurni?</p>';
$string['unstaging'] = 'Uklanjanje iz radne verzije';
$string['untranslate'] = 'ukloni prevod';
$string['untranslateconfirm'] = '<p> Nameravate da uklonite postojeći prevod stringa <code>{$a-> stringid}</code>, komponente <code>{$a->component}</code>, od <code>{$a->since}</code> i novijih verzija jezičkog paketa <code>{$a->language}</code>.</p><p>Da li ste sigurni?</p>';
$string['untranslatetitle'] = 'Uklanjanje prevoda iz jezičkog paketa';
$string['untranslating'] = 'Uklanjanje prevoda';
$string['userdefaultreset'] = 'Resetuj na moje podrazumevane vrednosti';
$string['userdefaultsave'] = 'Sačuvaj kao moje podrazumevane vrednosti';
$string['version'] = 'Verzija';
