<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'lo', version '4.1'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'ການເປີດໃຊ້ງານ';
$string['activityloading'] = 'ທ່ານຈະຖືກປ່ຽນເສັ້ນທາງອັດຕະໂນມັດໄປຫາກິດຈະກໍາໃນ';
$string['activityoverview'] = 'ທ່ານມີຊຸດ SCORM ທີ່ຕ້ອງການຄວາມສົນໃຈ';
$string['activitypleasewait'] = 'ກຳລັງໂຫຼດກິດຈະກຳ, ກະລຸນາລໍຖ້າ...';
$string['adminsettings'] = 'ການຕັ້ງຄ່າບໍລິຫານ';
$string['advanced'] = 'ຕົວກຳນົດ';
$string['aicchacpkeepsessiondata'] = 'ວັນທີຊ່ວງເວລາ AICC HACP';
$string['aicchacpkeepsessiondata_desc'] = 'ໄລຍະເວລາເປັນມື້ເພື່ອຮັກສາຂໍ້ມູນຊ່ວງເວລາ AICC HACP ພາຍນອກ (ການຕັ້ງຄ່າສູງຈະຕື່ມຂໍ້ມູນໃສ່ໃນຕາຕະລາງດ້ວຍຂໍ້ມູນເກົ່າ ແຕ່ອາດຈະເປັນປະໂຫຍດໃນເວລາດີບັກ)';
$string['aicchacptimeout'] = 'ໝົດເວລາ AICC HACP';
$string['aicchacptimeout_desc'] = 'ໄລຍະເວລາເປັນນາທີທີ່ຊ່ວງເວລາ AICC HACP ພາຍນອກສາມາດເປີດໄດ້';
$string['aiccuserid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ເປັນຕົວເລກຜ່ານ AICC';
$string['aiccuserid_desc'] = 'ມາດຕະຖານ AICC ສໍາລັບຊື່ຜູ້ໃຊ້ແມ່ນມີຄວາມຈຳກັດຫຼາຍເມື່ອປຽບທຽບກັບ Moodle, ແລະ ອະນຸຍາດໃຫ້ໃຊ້ຕົວອັກສອນທີ່ເປັນຕົວເລກ, ຂີດ ແລະ ຂີດກ້ອງເທົ່ານັ້ນ. ໄລຍະເວລາ, ຍະຫວ່າງ ແລະ ສັນຍາລັກ @ ແມ່ນບໍ່ໄດ້ຮັບອະນຸຍາດ. ຖ້າເປີດໃຊ້, ໝາຍເລກ ID ຜູ້ໃຊ້ຈະຖືກສົ່ງໄປໃສ່ຊຸດ AICC ແທນຊື່ຜູ້ໃຊ້.';
$string['aliasonly'] = 'ເມື່ອເລືອກໄຟລ໌ imsmanifest.xml ຈາກບ່ອນເກັບມ້ຽນ, ທ່ານຕ້ອງໃຊ້ ນາມແຝງ/ທາງລັດ ສຳລັບໄຟລ໌ນີ້.';
$string['allowapidebug'] = 'ເປີດໃຊ້ API debug ແລະ ການຕິດຕາມ (ຕັ້ງໜ້າກາກຈັບດ້ວຍ apidebugmask)';
$string['allowtypeaicchacp'] = 'ເປີດໃຊ້ງານ AICC HACP ພາຍນອກ';
$string['allowtypeaicchacp_desc'] = 'ຖ້າເປີດໃຊ້, ນີ້ອະນຸຍາດໃຫ້ AICC HACP ການສື່ສານພາຍນອກ ໂດຍບໍ່ຈໍາເປັນຕ້ອງເຂົ້າສູ່ລະບົບຜູ້ໃຊ້ສໍາລັບການຮ້ອງຂໍຕອບຈາກຊຸດ AICC ພາຍນອກ.';
$string['allowtypeexternal'] = 'ເປີດໃຊ້ງານປະເພດຊຸດພາຍນອກ';
$string['allowtypeexternalaicc'] = 'ເປີດໃຊ້ງານ URL AICC ໂດຍກົງ';
$string['allowtypeexternalaicc_desc'] = 'ຖ້າເປີດໃຊ້, ນີ້ອະນຸຍາດໃຫ້ url ໂດຍກົງໄປຫາຊຸດ AICC ງ່າຍດາຍ';
$string['allowtypelocalsync'] = 'ເປີດໃຊ້ງານປະເພດຊຸດແພັກເກດທີ່ດາວໂຫຼດແລ້ວ';
$string['apidebugmask'] = 'ຫນ້າກາກການຈັບດີບັກ API - ໃຊ້ regex ງ່າຍໆໃນ &lt;username&gt;:&lt;activityname&gt; ຕົວຢ່າງ: admin:.* ຈະດີບັກສຳລັບ ຜູ້ໃຊ້ບໍລິຫານ ເທົ່ານັ້ນ';
$string['areacontent'] = 'ໄຟລ໌ເນື້ອຫາ';
$string['areapackage'] = 'ໄຟລ໌ຊຸດແພັກເກດ';
$string['asset'] = 'ຊັບສິນ';
$string['assetlaunched'] = 'ຊັບສິນ - ເບິ່ງແລ້ວ';
$string['attempt'] = 'ຄວາມພະຍາຍາມ';
$string['attempt1'] = '1 ຄວາມພະຍາຍາມ';
$string['attempts'] = 'ຄວາມພະຍາຍາມ';
$string['attemptsmanagement'] = 'ການຈັດການຄວາມພະຍາຍາມ';
$string['attemptstatusall'] = 'ໜ້າແຜງໜ້າປັດ ແລະ ທາງເຂົ້າ';
$string['attemptstatusentry'] = 'ໜ້າທາງເຂົ້າເທົ່ານັ້ນ';
$string['attemptstatusmy'] = 'ແຜງໜ້າປັດເທົ່ານັ້ນ';
$string['attemptsx'] = '{$a} ຄວາມພະຍາຍາມ';
$string['attr_error'] = 'ຄ່າທີ່ບໍ່ດີສຳລັບຄຸນລັກສະນະ ({$a->attr}) ໃນແທັກ {$a->tag}.';
$string['autocommit'] = 'ຄຳໝັ້ນສັນຍາອັດຕະໂນມັດ';
$string['autocommit_help'] = 'ຖ້າເປີດໃຊ້, ຂໍ້ມູນ SCORM ຈະຖືກບັນທຶກໄວ້ໃນຖານຂໍ້ມູນໂດຍອັດຕະໂນມັດ. ເປັນປະໂຫຍດສໍາລັບວັດຖຸ SCORM ທີ່ບໍ່ໄດ້ບັນທຶກຂໍ້ມູນຂອງເຂົາເຈົ້າເປັນປົກກະຕິ.';
$string['autocommitdesc'] = 'ບັນທຶກຂໍ້ມູນ SCORM ໂດຍອັດຕະໂນມັດຖ້າຊຸດແພັກເກັດ SCORM ບໍ່ບັນທຶກມັນ.';
$string['autocontinue'] = 'ສືບຕໍ່ອັດຕະໂນມັດ';
$string['autocontinue_help'] = 'ຖ້າເປີດໃຊ້ງານ, ວັດຖຸການຮຽນຮູ້ຕໍ່ມາຈະຖືກເປີດໃຊ້ໂດຍອັດຕະໂນມັດ, ຖ້າບໍ່ດັ່ງນັ້ນປຸ່ມ ສືບຕໍ່ ຕ້ອງຖືກໃຊ້.';
$string['autocontinuedesc'] = 'ຖ້າເປີດໃຊ້ງານ, ວັດຖຸການຮຽນຮູ້ຕໍ່ມາຈະຖືກເປີດໃຊ້ໂດຍອັດຕະໂນມັດ, ຖ້າບໍ່ດັ່ງນັ້ນປຸ່ມ ສືບຕໍ່ ຕ້ອງຖືກໃຊ້.';
$string['averageattempt'] = 'ຄວາມພະຍາຍາມອັດຕະໂນມັດ';
$string['badarchive'] = 'ທ່ານຕ້ອງສະໜອງໄຟລ໌ zip ທີ່ຖືກຕ້ອງ';
$string['badimsmanifestlocation'] = 'ພົບໄຟລ໌ imsmanifest.xml ແຕ່ມັນບໍ່ໄດ້ຢູ່ໃນຮາກຂອງໄຟລ໌ zip ຂອງທ່ານ, ກະລຸນາບັນຈຸ SCORM ຂອງທ່ານຄືນໃໝ່';
$string['badmanifest'] = 'ບາງຄວາມຜິດພາດຢ່າງຊັດເຈນ: ເບິ່ງບັນທຶກຄວາມຜິດພາດ';
$string['browse'] = 'ເບິ່ງຕົວຢ່າງ';
$string['browsed'] = 'ຊອກຫາ';
$string['browsemode'] = 'ໂໝດເບິ່ງຕົວຢ່າງ';
$string['browserepository'] = 'ຊອກຫາບ່ອນເກັບມ້ຽນ';
$string['calculatedweight'] = 'ຄິດໄລ່ນ້ຳໜັກແລ້ວ';
$string['calendarend'] = '{$a} ປິດ';
$string['calendarstart'] = '{$a} ເປີດ';
$string['cannotaccess'] = 'ທ່ານບໍ່ສາມາດເອີ້ນສະຄຼິບໃນທາງນັ້ນໄດ້';
$string['cannotfindsco'] = 'ບໍ່ສາມາດຊອກຫາ SCO';
$string['chooseapacket'] = 'ເລືອກ ຫຼື ປັບປຸງແພັກເກດ';
$string['closebeforeopen'] = 'ທ່ານໄດ້ກໍານົດວັນທີປິດກ່ອນວັນທີເປີດ.';
$string['collapsetocwinsize'] = 'ຫຍໍ້ TOC ເມື່ອຂະໜາດໜ້າຈໍຂ້າງລຸ່ມນີ້';
$string['collapsetocwinsizedesc'] = 'ການຕັ້ງຄ່ານີ້ຊ່ວຍໃຫ້ທ່ານລະບຸຂະໜາດຂອງໜ້າຈໍຂ້າງລຸ່ມນີ້ທີ່ TOC ຄວນຫຍໍ້ລົງໂດຍອັດຕະໂນມັດ.';
$string['compatibilitysettings'] = 'ການຕັ້ງຄ່າຄວາມເຂົ້າກັນໄດ້';
$string['completed'] = 'ສຳເລັດແລ້ວ';
$string['completiondetail:allscos'] = 'ເຮັດພາກສ່ວນທັງໝົດຂອງກິດຈະກຳນີ້';
$string['completiondetail:completionscore'] = 'ໄດ້ຮັບຄະແນນ {$a} ຫຼື ຫຼາຍກວ່ານັ້ນ';
$string['completiondetail:completionstatuscompleted'] = 'ສຳເລັດກິດຈະກຳ';
$string['completiondetail:completionstatuscompletedorpassed'] = 'ສຳເລັດ ຫຼື ຜ່ານກິດຈະກຳ';
$string['completiondetail:completionstatuspassed'] = 'ຜ່ານກິດຈະກຳ';
$string['completionscorerequired'] = 'ຄະແນນຕ່ຳສຸດທີ່ຕ້ອງການ';
$string['completionscorerequired_help'] = 'ການເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້ ຈະຕ້ອງການໃຫ້ຜູ້ໃຊ້ມີຄະແນນຕ່ຳສຸດທີ່ປ້ອນເຂົ້າ ເພື່ອໃຫ້ສໍາເລັດໃນກິດຈະກໍາ SCORM ນີ້, ເຊັ່ນດຽວກັນກັບຂໍ້ກໍານົດການສໍາເລັດກິດຈະກໍາອື່ນໆ.';
$string['completionscorerequireddesc'] = 'ຕ້ອງມີຄະແນນຂັ້ນຕ່ຳ {$a} ສຳລັບການເຮັດສຳເລັດ';
$string['completionstatus_completed'] = 'ສຳເລັດແລ້ວ';
$string['completionstatus_passed'] = 'ຜ່ານແລ້ວ';
$string['completionstatusallscos'] = 'ຕ້ອງການ scos ທັງໝົດເພື່ອກັບຄືນສະຖານະການສຳເລັດ';
$string['completionstatusallscos_help'] = 'ບາງແພັກເກັດ SCORM ປະກອບດ້ວຍຫຼາຍອົງປະກອບ ຫຼື "scos" - ເມື່ອສິ່ງນີ້ຖືກເປີດໃຊ້ງານ scos ທັງໝົດພາຍໃນແພັກເກັດຈະຕ້ອງສົ່ງຄືນສະຖານະຂອງບົດຮຽນທີ່ກ່ຽວຂ້ອງສໍາລັບກິດຈະກໍານີ້ ເພື່ອຖືກໝາຍວ່າສໍາເລັດ.';
$string['completionstatusrequired'] = 'ສະຖານະທີ່ຕ້ອງການ';
$string['completionstatusrequired_help'] = 'ການກວດສອບໜຶ່ງ ຫຼື ຫຼາຍກວ່າໜຶ່ງສະຖານະຈະຕ້ອງໃຫ້ຜູ້ໃຊ້ບັນລຸຢ່າງໜ້ອຍໜຶ່ງໃນສະຖານະທີ່ກວດສອບແລ້ວ ເພື່ອໃຫ້ຖືກໝາຍວ່າ ສົມບູນໃນກິດຈະກໍາ SCORM ນີ້, ເຊັ່ນດຽວກັນກັບຄວາມຕ້ອງການການສໍາເລັດກິດຈະກໍາອື່ນໆ.';
$string['completionstatusrequireddesc'] = 'ນັກຮຽນຕ້ອງບັນລຸຢ່າງໜ້ອຍໜຶ່ງສະຖານະຕໍ່ໄປນີ້: {$a}';
$string['confirmloosetracks'] = 'ຄໍາເຕືອນ: ຊຸດແພັກເກດເບິ່ງຄືວ່າຈະມີການປ່ຽນແປງ ຫຼື ດັດແກ້. ຖ້າໂຄງສ້າງຊຸດແພັກເກັດຖືກປ່ຽນແປງ, ຜູ້ໃຊ້ບາງຄົນຕິດຕາມອາດຈະສູນເສຍໃນລະຫວ່າງຂະບວນການປັບປຸງ.';
$string['contents'] = 'ເນື້ອຫາ';
$string['coursepacket'] = 'ຊຸດແພັກເກດລາຍວິຊາ';
$string['coursestruct'] = 'ໂຄງສ້າງລາຍວິຊາ';
$string['crontask'] = 'ການປະມວນຜົນພື້ນຫຼັງສຳລັບ SCORM';
$string['currentwindow'] = 'ໜ້າຈໍປະຈຸບັນ';
$string['datadir'] = 'ລະບົບໄຟລ໌ຜິດພາດ: ບໍ່ສາມາດສ້າງລະບົບຂໍ້ມູນລາຍວິຊາໄດ້';
$string['defaultdisplaysettings'] = 'ການຕັ້ງຄ່າໜ້າຈໍສະແດງມາດຕະຖານ';
$string['defaultgradesettings'] = 'ການຕັ້ງຄ່າຄະແນນມາດຕະຖານ';
$string['defaultothersettings'] = 'ການຕັ້ງຄ່າມາດຕະຖານອື່ນໆ';
$string['deleteallattempts'] = 'ລຶບຄວາມພະຍາຍາມ SCORM ທັງໝົດ';
$string['deleteattemptcheck'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບຄວາມພະຍາຍາມເຫຼົ່ານີ້ອອກໝົດ?';
$string['deleteselected'] = 'ລຶບຄວາມພະຍາຍາມທີ່ເລືອກ';
$string['deleteuserattemptcheck'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບຄວາມພະຍາຍາມທັງໝົດຂອງທ່ານອອກໝົດ?';
$string['details'] = 'ລາຍລະອຽດການຕິດຕາມ';
$string['directories'] = 'ສະແດງການເຊື່ອມຕໍ່ລະບົບ';
$string['disabled'] = 'ປິດໃຊ້ງານ';
$string['display'] = 'ສະແດງຊຸດແພັກເກດ';
$string['displayactivityname'] = 'ສະແດງຊື່ກິດຈະກຳ';
$string['displayactivityname_help'] = 'ບໍ່ວ່າຈະສະແດງຊື່ກິດຈະກຳຢູ່ຂ້າງເທິງເຄື່ອງຫຼິ້ນ SCORM ຫຼືບໍ່.';
$string['displayattemptstatus'] = 'ສະແດງສະຖານະຄວາມພະຍາຍາມ';
$string['displayattemptstatus_help'] = 'ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ສະຫຼຸບສັງລວມຂອງຜູ້ໃຊ້ພະຍາຍາມສະແດງຢູ່ໃນບລັອກພາບລວມຂອງຂອງລາຍວິຊາໃນແຜງໜ້າປັດ ແລະ/ຫຼື ໜ້າທາງເຂົ້າ SCORM.';
$string['displayattemptstatusdesc'] = 'ບໍ່ວ່າບົດສະຫຼຸບຂອງຄວາມພະຍາຍາມຂອງຜູ້ໃຊ້ຈະສະແດງຢູ່ໃນບລັອກພາບລວມຂອງລາຍວິຊາໃນແຜງໜ້າປັດ ແລະ/ຫຼື ໜ້າທາງເຂົ້າ SCORM.';
$string['displaycoursestructure'] = 'ສະແດງໂຄງສ້າງລາຍວິຊາຢູ່ໃນໜ້າທາງເຂົ້າ';
$string['displaycoursestructure_help'] = 'ຖ້າເປີດໃຊ້ງານ, ຕາຕະລາງເນື້ອໃນຈະສະແດງຢູ່ໃນໜ້າໂຄງຮ່າງ SCORM.';
$string['displaycoursestructuredesc'] = 'ຖ້າເປີດໃຊ້ງານ, ຕາຕະລາງເນື້ອໃນຈະສະແດງຢູ່ໃນໜ້າໂຄງຮ່າງ SCORM.';
$string['displaydesc'] = 'ບໍ່ວ່າຈະສະແດງຊຸດແພັກເກດ SCORM ໃນໜ້າຈໍໃໝ່ຫຼືບໍ່.';
$string['displaysettings'] = 'ສະແດງການຕັ້ງຄ່າ';
$string['dnduploadscorm'] = 'ເພີ່ມແພັກເກດ SCORM';
$string['domxml'] = 'ຫ້ອງສະມຸດພາຍນອກ DOMXML';
$string['element'] = 'ອົງປະກອບ';
$string['enter'] = 'ປ້ອນເຂົ້າ';
$string['entercourse'] = 'ລາຍວິຊາປ້ອນເຂົ້າ';
$string['errorlogs'] = 'ບັນທຶກຜິດພາດ';
$string['eventattemptdeleted'] = 'ລຶບຄວາມພະຍາຍາມ';
$string['eventinteractionsviewed'] = 'ເບິ່ງການໂຕ້ຕອບແລ້ວ';
$string['eventreportviewed'] = 'ເບິ່ງລາຍງານແລ້ວ';
$string['eventscolaunched'] = 'ເປີດຕົວ Sco';
$string['eventscorerawsubmitted'] = 'ສົ່ງຄະແນນດິບ SCORM ແລ້ວ';
$string['eventstatussubmitted'] = 'ສົ່ງສະຖານະ SCORM ແລ້ວ';
$string['eventtracksviewed'] = 'ເບິ່ງການຕິດຕາມແລ້ວ';
$string['eventuserreportviewed'] = 'ເບິ່ງລາຍງານແລ້ວ';
$string['everyday'] = 'ທຸກໆມື້';
$string['everytime'] = 'ທຸກເວລາມັນຖືກນຳໃຊ້';
$string['exceededmaxattempts'] = 'ທ່ານພະຍາຍາມຮອດຈຳນວນສູງສຸດແລ້ວ.';
$string['exit'] = 'ອອກຈາກລາຍວິຊາ';
$string['exitactivity'] = 'ອອກຈາກກິດຈະກຳ';
$string['expired'] = 'ຂໍອະໄພ, ກິດຈະກໍານີ້ໄດ້ປິດໃນວັນທີ {$a} ແລະ ບໍ່ມີຕໍ່ໄປອີກແລ້ວ';
$string['external'] = 'ປັບປຸງການກຳນົດເວລາພາຍນອກ';
$string['failed'] = 'ລົ້ມເຫຼວ';
$string['finishscorm'] = 'ຖ້າທ່ານເບິ່ງແຫຼ່ງຂໍ້ມູນນີ້ແລ້ວ, {$a}';
$string['finishscormlinkname'] = 'ຄລິກທີ່ນີ້ເພື່ອກັບໄປຫາໜ້າລາຍວິຊາ';
$string['firstaccess'] = 'ເຂົ້າຫາຄັ້ງທຳອິດ';
$string['firstattempt'] = 'ຄວາມພະຍາຍາມຄັ້ງທຳອິດ';
$string['floating'] = 'ການລອຍ';
$string['forceattemptalways'] = 'ສະເໝີ';
$string['forceattemptoncomplete'] = 'ເມື່ອຄວາມພະຍາຍາມທີ່ຜ່ານມາສໍາເລັດ, ຜ່ານ ຫຼື ຕົກ';
$string['forcecompleted'] = 'ບັງຄັບສຳເລັດແລ້ວ';
$string['forcecompleted_help'] = 'ຖ້າເປີດໃຊ້ງານ, ສະຖານະຂອງຄວາມພະຍາຍາມໃນປັດຈຸບັນຖືກບັງຄັບໃຫ້ "ສໍາເລັດ". (ໃຊ້ໄດ້ກັບແພັກເກດ SCORM 1.2 ເທົ່ານັ້ນ.)';
$string['forcecompleteddesc'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການຕັ້ງຄ່າທີ່ສໍາເລັດຜົນບັງຄັບ';
$string['forcejavascript'] = 'ບັງຄັບຜູ້ໃຊ້ເພື່ອເປີດໃຊ້ງານ JavaScript';
$string['forcejavascript_desc'] = 'ຖ້າເປີດໃຊ້ງານ (ແນະນໍາ) ນີ້ຈະຂັດຂວາງການເຂົ້າເຖິງວັດຖຸ SCORM ເມື່ອ JavaScript ບໍ່ຖືກຮອງຮັບ/ເປີດໃຊ້ງານ ໃນຕົວທ່ອງເວັບຂອງຜູ້ໃຊ້. ຖ້າປິດໃຊ້ງານຜູ້ໃຊ້ອາດຈະເບິ່ງ SCORM ແຕ່ການສື່ສານ API ຈະລົ້ມເຫຼວ ແລະ ບໍ່ມີຂໍ້ມູນຊັ້ນຮຽນຈະຖືກບັນທຶກໄວ້.';
$string['forcejavascriptmessage'] = 'JavaScript ແມ່ນຈຳເປັນເພື່ອເບິ່ງວັດຖຸນີ້, ກະລຸນາເປີດໃຊ້ງານ JavaScript ໃນຕົວທ່ອງເວັບຂອງທ່ານ ແລະ ລອງໃໝ່ອີກຄັ້ງ.';
$string['forcenewattempts'] = 'ບັງຄັບຄວາມພະຍາຍາມໃໝ່';
$string['forcenewattempts_help'] = 'ມີ 3 ທາງເລືອກ:

* ບໍ່ - ຖ້າຄວາມພະຍາຍາມທີ່ຜ່ານມາສໍາເລັດ, ຜ່ານ ຫຼື ລົ້ມເຫຼວ, ນັກຮຽນຈະຖືກສະໜອງໃຫ້ມີທາງເລືອກທີ່ຈະເຂົ້າໄປໃນໂໝດການທົບທວນຄືນ ຫຼື ເລີ່ມຕົ້ນຄວາມພະຍາຍາມໃໝ່.
* ເມື່ອຄວາມພະຍາຍາມທີ່ຜ່ານມາສໍາເລັດ, ຜ່ານ ຫຼື ຕົກ - ນີ້ອີງໃສ່ຊຸດ SCORM ກໍານົດສະຖານະຂອງ \'ສໍາເລັດ\', \'ຜ່ານ\' ຫຼື \'ຕົກ\'.
* ສະເຫມີ - ແຕ່ລະການເຂົ້າຄືນໃຫມ່ຂອງກິດຈະກໍາ SCORM ຈະສ້າງຄວາມພະຍາຍາມໃຫມ່ແລະນັກຮຽນຈະບໍ່ຖືກກັບຄືນໄປຫາຈຸດດຽວກັນທີ່ພວກເຂົາໄດ້ບັນລຸໃນຄວາມພະຍາຍາມທີ່ຜ່ານມາຂອງພວກເຂົາ.';
$string['found'] = 'ພົບຄວາມຊັດເຈນ';
$string['frameheight'] = 'ຄວາມສູງຂອງກອບເວທີ ຫຼື ໜ້າຈໍ.';
$string['framewidth'] = 'ຄວາມກວ້າງຂອງກອບເວທີ ຫຼື ໜ້າຈໍ.';
$string['fromleft'] = 'ຈາກທາງຊ້າຍ';
$string['fromtop'] = 'ຈາກເທິງສຸດ';
$string['fullscreen'] = 'ຕື່ມເຕັມໜ້າຈໍສະແດງ';
$string['general'] = 'ຂໍ້ມູນທົ່ວໄປ';
$string['gradeaverage'] = 'ຄະແນນສະເລ່ຍ';
$string['gradeforattempt'] = 'ຄະແນນສຳລັບຄວາມພະຍາຍາມ';
$string['gradehighest'] = 'ຄະແນນສູງສຸດ';
$string['grademethod'] = 'ວິທີການໃຫ້ຄະແນນ';
$string['grademethod_help'] = 'ວິທີການໃຫ້ຄະແນນກໍານົດວິທີການໃຫ້ຄະແນນ ສໍາລັບຄວາມພະຍາຍາມດຽວຂອງກິດຈະກໍາຖືກກໍານົດ.

ມີ 4 ວິທີການໃຫ້ຄະແນນ:

* ວັດຖຸການຮຽນຮູ້ - ຈໍານວນຂອງວັດຖຸການຮຽນຮູ້ສໍາເລັດ/ຜ່ານ
* ຄະແນນສູງສຸດ - ຄະແນນສູງສຸດທີ່ໄດ້ຮັບໃນທຸກວັດຖຸການຮຽນຮູ້ທີ່ຜ່ານການ
* ຄະແນນສະເລ່ຍ - ຄ່າສະເລ່ຍຂອງຄະແນນທັງໝົດ
* ຄະແນນລວມ - ຜົນລວມຂອງຄະແນນທັງໝົດ';
$string['grademethoddesc'] = 'ວິທີການໃຫ້ຄະແນນກໍານົດວິທີການໃຫ້ຄະແນນ ສໍາລັບຄວາມພະຍາຍາມດຽວຂອງກິດຈະກໍາຖືກກໍານົດ.';
$string['gradereported'] = 'ລາຍງານຄະແນນແລ້ວ';
$string['gradescoes'] = 'ການຮຽນຮູ້ວັດຖຸ';
$string['gradesettings'] = 'ການຕັ້ງຄ່າຄະແນນ';
$string['gradesum'] = 'ຄະແນນລວມ';
$string['height'] = 'ລວງສູງ';
$string['hidden'] = 'ເຊື່ອງໄວ້';
$string['hidebrowse'] = 'ປິດໃຊ້ງານໂໝດເບິ່ງຕົວຢ່າງ';
$string['hidebrowse_help'] = 'ໂໝດສະແດງຕົວຢ່າງເຮັດໃຫ້ນັກຮຽນສາມາດທ່ອງເບິ່ງກິດຈະກຳໃດໜຶ່ງກ່ອນພະຍາຍາມມັນ. ຖ້າໂໝດສະແດງຕົວຢ່າງຖືກປິດໄວ້, ປຸ່ມສະແດງຕົວຢ່າງຈະຖືກເຊື່ອງໄວ້.';
$string['hidebrowsedesc'] = 'ໂໝດສະແດງຕົວຢ່າງເຮັດໃຫ້ນັກຮຽນສາມາດທ່ອງເບິ່ງກິດຈະກຳໃດໜຶ່ງກ່ອນພະຍາຍາມມັນ.';
$string['hideexit'] = 'ເຊື່ອງລິ້ງອອກ';
$string['hidereview'] = 'ເຊື່ອງປຸ່ມທົບທວນຄືນ';
$string['hidetoc'] = 'ສະແດງໂຄງສ້າງລາຍວິຊາໃນເຄື່ອງຫຼິ້ນ';
$string['hidetoc_help'] = 'ວິທີການສະແດງຕາຕະລາງເນື້ອໃນຢູ່ໃນເຄື່ອງຫຼີ້ນ SCORM';
$string['hidetocdesc'] = 'ການຕັ້ງຄ່ານີ້ລະບຸວິທີການສະແດງຕາຕະລາງເນື້ອໃນຢູ່ໃນເຄື່ອງຫຼິ້ນ SCORM.';
$string['highestattempt'] = 'ຄວາມພະຍາຍາມສູງສຸດ';
$string['identifier'] = 'ຕົວລະບຸຄຳຖາມ';
$string['incomplete'] = 'ບໍ່ສຳເລັດ';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ SCORM';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເລິກຂອງມັນສະໝອງບັນລຸໄດ້ໂດຍນັກຮຽນໃນກິດຈະກໍາ SCORM.';
$string['indicator:cognitivedepthdef'] = 'ຄວາມຮູ້ SCORM';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ຂອງການມີສ່ວນຮ່ວມທາງດ້ານສະຕິປັນຍາທີ່ສະເໜີໂດຍກິດຈະກໍາ SCORM ໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເບິ່ງ, ເບິ່ງ, ສົ່ງ, ເບິ່ງຄໍາຕິຊົມ)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'ສັງຄົມ SCORM';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມກວ້າງຂອງສັງຄົມທີ່ນັກຮຽນບັນລຸໄດ້ໃນກິດຈະກໍາ SCORM.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມ SCORM';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເໜີໂດຍກິດຈະກໍາ SCORM ໃນລະຫວ່າງການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມຢ່າງດຽວ)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'ຂໍ້ມູນ';
$string['interactions'] = 'ການໂຕ້ຕອບ';
$string['invalidactivity'] = 'ກິດຈະກຳ SCORM ບໍ່ຖືກ';
$string['invalidhacpsession'] = 'ຊ່ວງເວລາ HACP ບໍ່ຖືກຕ້ອງ';
$string['invalidmanifestname'] = 'ອາດຈະເລືອກໄຟລ໌ imsmanifest.xml ຫຼື .zip ເທົ່ານັ້ນ';
$string['invalidmanifestresource'] = 'ຄຳເຕືອນ: ແຫຼ່ງຂໍ້ມູນຕໍ່ໄປນີ້ຖືກອ້າງອີງໃນຄວາມຊັດເຈນຂອງທ່ານແຕ່ບໍ່ສາມາດຊອກຫາໄດ້:';
$string['invalidstatus'] = 'ສະຖານະບໍ່ຖືກຕ້ອງ';
$string['invalidurl'] = 'ລະບຸ URL ບໍ່ຖືກຕ້ອງ';
$string['invalidurlhttpcheck'] = 'ລະບຸ URL ບໍ່ຖືກຕ້ອງ. ຂໍ້ຄວາມດີບັກ:<pre>{$a->cmsg}</pre>';
$string['last'] = 'ການປະເມີນຫຼ້າສຸດໃນ';
$string['lastaccess'] = 'ເຂົ້າຫາຫຼ້າສຸດ';
$string['lastattempt'] = 'ຄວາມພະຍາຍາມສຳເລັດຫຼ້າສຸດ';
$string['lastattemptlock'] = 'ຄວາມພະຍາຍາມສຸດທ້າຍຫຼັງຈາກການລັອກ';
$string['lastattemptlock_help'] = 'ຖ້າເປີດໃຊ້, ນັກຮຽນຖືກປ້ອງກັນບໍ່ໃຫ້ເປີດເຄື່ອງຫຼິ້ນ SCORM ຫຼັງຈາກໃຊ້ຄວາມພະຍາຍາມຈັດສັນທັງໝົດຂອງເຂົາເຈົ້າ.';
$string['lastattemptlockdesc'] = 'ຖ້າເປີດໃຊ້, ນັກຮຽນຖືກປ້ອງກັນບໍ່ໃຫ້ເປີດເຄື່ອງຫຼິ້ນ SCORM ຫຼັງຈາກໃຊ້ຄວາມພະຍາຍາມຈັດສັນທັງໝົດຂອງເຂົາເຈົ້າ.';
$string['location'] = 'ສະແດງແຖບສະຖານທີ່ຕັ້ງ';
$string['masteryoverride'] = 'ຄະແນນຄວາມຊຳນານລົບລ້າງສະຖານະ';
$string['masteryoverride_help'] = 'ຖ້າເປີດໃຊ້ງານ ແລະ ໃຫ້ຄະແນນຄວາມຊຳນານ, ເມື່ອ LMSFinish ຖືກເອີ້ນ ແລະ ກໍານົດຄະແນນດິບ, ສະຖານະພາບຈະຖືກຄິດໄລ່ຄືນໃໝ່ ໂດຍໃຊ້ຄະແນນດິບ ແລະ ຄະແນນຕົ້ນສະບັບ ແລະ ສະຖານະພາບໃດໆທີ່ສະໜອງໃຫ້ໂດຍ SCORM (ລວມທັງ "ບໍ່ຄົບຖ້ວນ") ຈະຖືກແທນທີ່.';
$string['masteryoverridedesc'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການຕັ້ງຄ່າການລົບລ້າງຄະແນນຄວາມຊຳນານ';
$string['max'] = 'ຄະແນນສູງສຸດ';
$string['maximumattempts'] = 'ຈຳນວນຄວາມພະຍາຍາມ';
$string['maximumattempts_help'] = 'ການຕັ້ງຄ່ານີ້ເຮັດໃຫ້ຈໍານວນຄວາມພະຍາຍາມຖືກຈໍາກັດ. ມັນສາມາດໃຊ້ໄດ້ກັບຊຸດແພັກເກັດ SCORM 1.2 ແລະ AICC ເທົ່ານັ້ນ.';
$string['maximumattemptsdesc'] = 'ການຕັ້ງຄ່ານີ້ ກໍານົດຄວາມພະຍາຍາມສູງສຸດເລີ່ມຕົ້ນສໍາລັບກິດຈະກໍາໃດຫນຶ່ງ';
$string['maximumgradedesc'] = 'ການຕັ້ງຄ່ານີ້ ກໍານົດລະດັບສູງສຸດມາດຕະຖານສໍາລັບກິດຈະກໍາ';
$string['menubar'] = 'ສະແດງແຖບເມນູ';
$string['min'] = 'ຄະແນນນ້ອຍສຸດ';
$string['missing_attribute'] = 'ຄຸນລັກສະນະຂາດຫາຍໄປ {$a->attr} ໃນແທັກ {$a->tag}';
$string['missing_tag'] = 'ແທັກຂາດຫາຍໄປ {$a->tag}';
$string['missingparam'] = 'ຕົວກຳນົດຂາດຫາຍໄປ ຫຼື ຜິດ';
$string['mode'] = 'ໂໝດ';
$string['modulename'] = 'ແພັກເກດ SCORM';
$string['modulename_help'] = 'ຊຸດ SCORM ເປັນຊຸດຂອງໄຟລ໌ທີ່ຖືກຫຸ້ມຫໍ່ຕາມມາດຕະຖານທີ່ໄດ້ຕົກລົງກັນສໍາລັບການຮຽນຮູ້ວັດຖຸ. ຊຸດກິດຈະກໍາ SCORM ຊ່ວຍໃຫ້ແພັກເກດ SCORM ຫຼື AICC ອັບໂຫຼດເປັນໄຟລ໌ zip ແລະ ເພີ່ມເຂົ້າໃນຫຼັກສູດ.

ເນື້ອຫາມັກຈະສະແດງຢູ່ໃນຫຼາຍຫນ້າ, ດ້ວຍການນໍາທາງລະຫວ່າງໜ້າ. ມີທາງເລືອກຕ່າງໆສໍາລັບການສະແດງເນື້ອຫາຢູ່ໃນປ່ອງຢ້ຽມປັອບອັບ, ມີຕາຕະລາງເນື້ອໃນ, ມີປຸ່ມນໍາທາງ ແລະອື່ນໆ. ກິດຈະກໍາ SCORM ໂດຍທົ່ວໄປປະກອບມີຄໍາຖາມ, ໂດຍມີຄະແນນທີ່ບັນທຶກໄວ້ໃນປື້ມຄະແນນ.

ກິດຈະກໍາ SCORM ອາດຈະຖືກນໍາໃຊ້

* ສໍາລັບການນໍາສະເໜີເນື້ອໃນມັນຕິມີເດຍ ແລະ ພາບເຄື່ອນໄຫວ
* ເປັນເຄື່ອງມືການປະເມີນຜົນ';
$string['modulename_link'] = 'mod/scorm/view';
$string['modulenameplural'] = 'ແພັກເກດ SCORM';
$string['myaiccsessions'] = 'ຊ່ວງເວລາ AICC ຂອງຂ້ອຍ';
$string['myattempts'] = 'ຄວາມພະຍາຍາມຂອງຂ້ອຍ';
$string['nav'] = 'ສະແດງການນຳທາງ';
$string['nav_help'] = 'ການຕັ້ງຄ່ານີ້ກຳນົດວ່າ ຈະສະແດງ ຫຼື ເຊື່ອງປຸ່ມນຳທາງ ແລະ ຕຳແໜ່ງຂອງມັນຫຼືບໍ່.

ມີ 3 ທາງເລືອກ:

* ບໍ່ - ປຸ່ມນໍາທາງບໍ່ໄດ້ສະແດງ
* ພາຍໃຕ້ເນື້ອໃນ - ປຸ່ມນໍາທາງແມ່ນສະແດງໃຫ້ເຫັນຂ້າງລຸ່ມນີ້ເນື້ອໃນຊຸດ SCORM
* ລອຍ - ປຸ່ມນໍາທາງແມ່ນສະແດງໃຫ້ເຫັນແບບລອຍ, ໂດຍມີຕໍາແໜ່ງຈາກດ້ານເທິງ ແລະ ຈາກຊ້າຍທີ່ກໍານົດໂດຍຊຸດ.';
$string['navdesc'] = 'ການຕັ້ງຄ່ານີ້ກຳນົດວ່າຈະສະແດງ ຫຼື ເຊື່ອງປຸ່ມນຳທາງ ແລະ ຕຳແໜ່ງຂອງມັນຫຼືບໍ່.';
$string['navigation'] = 'ການນຳທາງ';
$string['navpositionleft'] = 'ຕໍາແໜ່ງຂອງປຸ່ມນໍາທາງຈາກຊ້າຍເປັນພິກເຊລ.';
$string['navpositiontop'] = 'ຕຳແໜ່ງຂອງປຸ່ມນຳທາງຈາກເທິງສຸດເປັນພິກເຊລ.';
$string['networkdropped'] = 'ເຄື່ອງຫຼິ້ນ SCORM ໄດ້ກໍານົດວ່າ ການເຊື່ອມຕໍ່ອິນເຕີເນັດຂອງທ່ານບໍ່ໜ້າເຊື່ອຖື ຫຼື ຖືກລົບກວນ. ຖ້າທ່ານສືບຕໍ່ຢູ່ໃນກິດຈະກໍາ SCORM ນີ້, ຄວາມຄືບຫນ້າຂອງທ່ານອາດຈະບໍ່ຖືກບັນທຶກໄວ້.<br />
ທ່ານຄວນອອກຈາກກິດຈະກໍາໃນປັດຈຸບັນ, ແລະ ກັບຄືນໃນເວລາທີ່ທ່ານມີການເຊື່ອມຕໍ່ອິນເຕີເນັດທີ່ເຊື່ອຖືໄດ້.';
$string['newattempt'] = 'ເລິ່ມຕົ້ນຄວາມພະຍາຍາມໃໝ່';
$string['next'] = 'ສືບຕໍ່';
$string['no_attributes'] = 'ແທັກ {$a->tag} ຕ້ອງມີຄຸນສົມບັດ';
$string['no_children'] = 'ແທັກ {$a->tag} ຕ້ອງມີລູກ';
$string['noactivity'] = 'ບໍ່ມີຫຍັງລາຍງານ';
$string['noattemptsallowed'] = 'ຈຳນວນຄວາມພະຍາຍາມທີ່ອະນຸຍາດ';
$string['noattemptsmade'] = 'ຈຳນວນຄວາມພະຍາຍາມທີ່ທ່ານໄດ້ເຮັດ';
$string['nolimit'] = 'ຄວາມພະຍາຍາມບໍ່ຈຳກັດ';
$string['nomanifest'] = 'ຊຸດໄຟລ໌ບໍ່ຖືກຕ້ອງ - ບໍ່ມີໂຄງສ້າງ imsmanifest.xml ຫຼື AICC';
$string['noprerequisites'] = 'ຂໍອະໄພ, ແຕ່ທ່ານບໍ່ມີຄວາມຕ້ອງການເບື້ອງຕົ້ນເພື່ອເຂົ້າເຖິງການເຄື່ອນໄຫວນີ້.';
$string['noreports'] = 'ບໍ່ມີລາຍງານໃຫ້ສະແດງ';
$string['normal'] = 'ປົກກະຕິ';
$string['noscriptnoscorm'] = 'ຕົວທ່ອງເວັບຂອງທ່ານບໍ່ຮອງຮັບ JavaScript ຫຼື ມັນປິດການຮອງຮັບ JavaScript. ຊຸດ SCORM ນີ້ອາດຈະບໍ່ຫຼິ້ນ ຫຼື ບັນທຶກຂໍ້ມູນຢ່າງຖືກຕ້ອງ.';
$string['not_corr_type'] = 'ປະເພດບໍ່ກົງກັນສຳລັບແທັກ {$a->tag}';
$string['notattempted'] = 'ບໍ່ໄດ້ພະຍາຍາມ';
$string['notopenyet'] = 'ຂໍອະໄພ, ການເຄື່ອນໄຫວນີ້ບໍ່ສາມາດໃຊ້ໄດ້ຈົນກ່ວາ {$a}';
$string['objectives'] = 'ຈຸດປະສົງ';
$string['openafterclose'] = 'ທ່ານໄດ້ລະບຸວັນທີເປີດຫຼັງຈາກວັນທີປິດ';
$string['optallstudents'] = 'ຜູ້ໃຊ້ທັງໝົດ';
$string['optattemptsonly'] = 'ຜູ້ໃຊ້ທີ່ພະຍາຍາມເທົ່ານັ້ນ';
$string['options'] = 'ທາງເລືອກ (ປ້ອງກັນໂດຍບາງຕົວທ່ອງເວັບ)';
$string['optionsadv'] = 'ທາງເລືອກ (ຂັ້ນສູງ)';
$string['optionsadv_desc'] = 'ຖ້າກວດເບິ່ງຄວາມກວ້າງ ແລະ ຄວາມສູງຈະຖືກສະແດງເປັນການຕັ້ງຄ່າຂັ້ນສູງ.';
$string['optnoattemptsonly'] = 'ຜູ້ໃຊ້ທີ່ບໍ່ພະຍາຍາມເທົ່ານັ້ນ';
$string['organization'] = 'ອົງກອນ';
$string['organizations'] = 'ອົງການຈັດຕັ້ງ';
$string['othersettings'] = 'ການຕັ້ງຄ່າເພີ່ມເຕີມ';
$string['package'] = 'ໄຟລ໌ແພັກເກດ';
$string['package_help'] = 'ໄຟລ໌ແພັກເກັດແມ່ນໄຟລ໌ zip (ຫຼື pif) ທີ່ມີໄຟລ໌ຄໍານິຍາມຫຼັກສູດ SCORM/AICC.';
$string['packagedir'] = 'ລະບົບໄຟລ໌ຜິດພາດ: ບໍ່ສາມາດສ້າງລະບົບແພັກໄດ້';
$string['packagefile'] = 'ບໍ່ມີໄຟລ໌ແພັກເກດທີ່ລະບຸ';
$string['packagehdr'] = 'ແພັກເກດ';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'ການຕັ້ງຄ່ານີ້ເຮັດໃຫ້ URL ສໍາລັບແພັກເກັດ SCORM ຖືກລະບຸ, ແທນທີ່ຈະເລືອກໄຟລ໌ຜ່ານຕົວເລືອກໄຟລ໌.';
$string['page-mod-scorm-x'] = 'ໜ້າຊຸດ SCORM ໃດໜຶ່ງ';
$string['pagesize'] = 'ຂະໜາດໜ້າ';
$string['passed'] = 'ຜ່ານ';
$string['php5'] = 'PHP 5 (ຫໍສະໝດພື້ນເມືອງ DOMXML)';
$string['pluginadministration'] = 'ການບໍລິຫານແພັກເກດ SCORM';
$string['pluginname'] = 'ແພັກເກດ SCORM';
$string['popup'] = 'ໜ້າຈໍໃໝ່';
$string['popuplaunched'] = 'ຊຸດ SCORM ນີ້ໄດ້ຖືກເປີດຕົວຢູ່ໃນປ່ອງຢ້ຽມປ໊ອບອັບ, ຖ້າທ່ານເບິ່ງຊັບພະຍາກອນນີ້ສໍາເລັດແລ້ວ, ຄລິກທີ່ນີ້ເພື່ອກັບຄືນໄປຫາຫນ້າລາຍວິຊາ.';
$string['popupmenu'] = 'ເມນູເລື່ອນລົງ';
$string['popupopen'] = 'ເປີດແພັກເກດໃນໜ້າຈໍໃໝ່';
$string['popupsblocked'] = 'ປະກົດວ່າໜ້າຈໍປັອບອັບຖືກບລັອກ, ຢຸດແພັກເກັດ SCORM ນີ້ ຈາກການຫຼິ້ນ. ກະລຸນາກວດເບິ່ງການຕັ້ງຄ່າບຣາວເຊີຂອງທ່ານກ່ອນທີ່ຈະລອງອີກຄັ້ງ.';
$string['position_error'] = 'ແທັກ {$a->tag} ບໍ່ສາມາດເປັນລູກຂອງແທັກ {$a->parent}';
$string['preferencespage'] = 'ການຕັ້ງຄ່າພຽງແຕ່ສຳລັບໜ້ານີ້';
$string['preferencesuser'] = 'ການຕັ້ງຄ່າພຽງແຕ່ສຳລັບລາຍງານນີ້';
$string['prev'] = 'ກ່ອນໜ້າ';
$string['privacy:metadata:aicc:data'] = 'ຂໍ້ມູນສ່ວນຕົວຜ່ານຈາກລະບົບຍ່ອຍ AICC/SCORM.';
$string['privacy:metadata:aicc:externalpurpose'] = 'ປັ໊ກອິນນີ້ສົ່ງຂໍ້ມູນພາຍນອກໂດຍໃຊ້ AICC HACP.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'ສະຖານະບົດຮຽນທີ່ຈະຖືກຕິດຕາມ';
$string['privacy:metadata:aicc_session:scormmode'] = 'ໂໝດຂອງອົງປະກອບທີ່ຈະຖືກຕິດຕາມ';
$string['privacy:metadata:aicc_session:scormstatus'] = 'ສະຖານະຂອງອົງປະກອບທີ່ຈະຖືກຕິດຕາມ';
$string['privacy:metadata:aicc_session:sessiontime'] = 'ຊ່ວງເວລາທີ່ຈະຖືກຕິດຕາມ';
$string['privacy:metadata:aicc_session:timecreated'] = 'ເວລາເມື່ອໄດ້ຕິດຕາມອົງປະກອບຖືກສ້າງ';
$string['privacy:metadata:attempt'] = 'ຈຳນວນຄວາມພະຍາຍາມ';
$string['privacy:metadata:scoes_track:element'] = 'ຊື່ຂອງອົງປະກອບທີ່ຈະຖືກຕິດຕາມ';
$string['privacy:metadata:scoes_track:value'] = 'ມູນຄ່າຂອງອົງປະກອບທີ່ໄດ້ໃຫ້';
$string['privacy:metadata:scorm_aicc_session'] = 'ຂໍ້ມູນຊ່ວງເວລາຂອງ AICC HACP';
$string['privacy:metadata:scorm_scoes_track'] = 'ຂໍ້ມູນການຕິດຕາມຂອງ SCOes ທີ່ຂຶ້ນກັບກິດຈະກໍາ';
$string['privacy:metadata:timemodified'] = 'ເວລາທີ່ອົງປະກອບຕິດຕາມໄດ້ຖືກດັດແກ້ຫຼ້າສຸດ';
$string['privacy:metadata:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ເຂົ້າເຖິງກິດຈະກໍາ SCORM';
$string['protectpackagedownloads'] = 'ປົກປ້ອງການດາວໂຫຼດແພັກເກດ';
$string['protectpackagedownloads_desc'] = 'ຖ້າເປີດໃຊ້ງານ, ແພັກເກດ SCORM ສາມາດດາວໂຫຼດໄດ້ພຽງແຕ່ຖ້າຜູ້ໃຊ້ມີຄວາມສາມາດ course:manageactivities. ຖ້າປິດໃຊ້ງານ, ແພັກເກັດ SCORM ສາມາດດາວໂຫຼດໄດ້ສະເໝີ (ໂດຍມືຖື ຫຼື ວິທີອື່ນ).';
$string['raw'] = 'ຄະແນນດິບ';
$string['regular'] = 'ຄວາມຊັດເຈນປົກກະຕິ';
$string['report'] = 'ລາຍງານ';
$string['reportcountallattempts'] = '{$a->nbattempts} ຄວາມພະຍາຍາມສຳລັບຜູ້ໃຊ້ {$a->nbusers}, ຈາກທັງໝົດ {$a->nbresults} ຜົນໄດ້ຮັບ';
$string['reportcountattempts'] = '{$a->nbresults} ຜົນໄດ້ຮັບ ({$a->nbusers} ຜູ້ໃຊ້)';
$string['reports'] = 'ລາຍງານ';
$string['repositorynotsupported'] = 'ບ່ອນເກັບມ້ຽນນີ້ບໍ່ຮອງຮັບການເຊື່ອມຕໍ່ໂດຍກົງກັບໄຟລ໌ imsmanifest.xml.';
$string['response'] = 'ການຕອບກັບ';
$string['result'] = 'ຜົນໄດ້ຮັບ';
$string['results'] = 'ຜົນໄດ້ຮັບ';
$string['review'] = 'ທົບທວນຄືນ';
$string['reviewmode'] = 'ໂໝດທົບທວນຄືນ';
$string['rightanswer'] = 'ຄຳຕອບທີ່ຖືກຕ້ອງ';
$string['scoes'] = 'ວັດຖຸການຮຽນຮູ້';
$string['score'] = 'ຄະແນນ';
$string['scorm:addinstance'] = 'ເພີ່ມຊຸດ SCORM ໃໝ່';
$string['scorm:deleteownresponses'] = 'ລຶບຄວາມພະຍາຍາມຂອງຕົວເອງແລ້ວ';
$string['scorm:deleteresponses'] = 'ລຶບຄວາມພະຍາຍາມ SCORM';
$string['scorm:savetrack'] = 'ບັນທຶກການຕິດຕາມ';
$string['scorm:skipview'] = 'ຂ້າມພາບລວມ';
$string['scorm:viewreport'] = 'ເບິ່ງລາຍງານ';
$string['scorm:viewscores'] = 'ເບິ່ງຄະແນນ';
$string['scormclose'] = 'ມີໃຫ້ຢູ່ທີ່';
$string['scormcourse'] = 'ລາຍວິຊາການຮຽນຮູ້';
$string['scormloggingoff'] = 'ປິດການບັນທຶກ API';
$string['scormloggingon'] = 'ເປີດການບັນທຶກ API';
$string['scormopen'] = 'ມີໃຫ້ຈາກ';
$string['scormresponsedeleted'] = 'ລຶບຄວາມພະຍາຍາມຜູ້ໃຊ້ແລ້ວ';
$string['scormstandard'] = 'ໂໝດມາດຕະຖານ SCORM';
$string['scormstandarddesc'] = 'ເມື່ອປິດໃຊ້ງານ, Moodle ອະນຸຍາດໃຫ້ແພັກເກັດ SCORM 1.2 ເກັບຮັກສາໄດ້ຫຼາຍກວ່າທີ່ລະບຸໄວ້, ແລະ ໃຊ້ການຕັ້ງຄ່າຮູບແບບຊື່ເຕັມຂອງ Moodle ເມື່ອສົ່ງຊື່ຜູ້ໃຊ້ໄປຫາແພັກເກັດ SCORM.';
$string['scormtype'] = 'ປະເພດ';
$string['scormtype_help'] = 'ການຕັ້ງຄ່ານີ້ ກໍານົດວິທີການບັນຈຸເຂົ້າໃນລາຍວິຊາ. ມີເຖິງ 4 ທາງເລືອກ:

* ແພັກເກັດທີ່ອັບໂຫຼດແລ້ວ - ເປີດໃຊ້ແພັກເກດ SCORM ທີ່ຈະເລືອກຜ່ານຕົວເລືອກໄຟລ໌
* ພາຍນອກ SCORM ທີ່ຊັດເຈນ - ເປີດໃຊ້ URL imsmanifest.xml ທີ່ຈະລະບຸ. ຫມາຍເຫດ: ຖ້າ URL ມີຊື່ໂດເມນທີ່ແຕກຕ່າງຈາກເວັບໄຊທ໌ຂອງທ່ານ, "ຊຸດທີ່ດາວໂຫຼດ" ແມ່ນທາງເລືອກທີ່ດີກວ່າ, ເພາະວ່າ ຖ້າບໍ່ດັ່ງນັ້ນຄະແນນຈະບໍ່ຖືກບັນທຶກໄວ້.
* ແພັກເກດທີ່ດາວໂຫຼດ - ເປີດໃຊ້ງານ URL ຂອງຊຸດທີ່ຈະໄດ້ຮັບການລະບຸໄວ້. ແພກເກດຈະຖືກ ແຍກອອກ ແລະ ບັນທຶກໄວ້ໃນເຄື່ອງ, ແລະ ປັບປຸງເມື່ອແພັກເກດ SCORM ພາຍນອກຖືກປັບປຸງ.
* URL AICC ພາຍນອກ - URL ນີ້ແມ່ນ URL ເປີດຕົວສໍາລັບກິດຈະກໍາ AICC ດຽວ. ຊຸດ psuedo ຈະໄດ້ຮັບການກໍ່ສ້າງປະມານນີ້.';
$string['scrollbars'] = 'ອະນຸຍາດໜ້າຈໍໃຫ້ຖືກເລື່ອນ';
$string['search:activity'] = 'ຊຸດ SCORM - ຂໍ້ມູນກິດຈະກຳ';
$string['selectall'] = 'ເລືອກທັງໝົດ';
$string['selectnone'] = 'ບໍ່ເລືອກທັງໝົດ';
$string['show'] = 'ສະແດງ';
$string['sided'] = 'ໄປທາງຂ້າງ';
$string['skipview'] = 'ນັກຮຽນຂ້າມໂຄງປະກອບເນື້ອຫາ';
$string['skipview_help'] = 'ການຕັ້ງຄ່ານີ້ ກໍານົດວ່າໜ້າໂຄງສ້າງເນື້ອຫາຄວນຈະຖືກຂ້າມ (ບໍ່ສະແດງ). ຖ້າແພັກເກັດມີວັດຖຸການຮຽນຮູ້ອັນດຽວ, ຫນ້າໂຄງສ້າງເນື້ອຫາສາມາດຂ້າມໄດ້ຕະຫຼອດເວລາ.';
$string['skipviewdesc'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບເວລາທີ່ຈະຂ້າມໂຄງສ້າງເນື້ອຫາສໍາລັບໜ້າ';
$string['slashargs'] = 'ຄໍາເຕືອນ: slash arguments ຖືກປິດຢູ່ໃນເວັບໄຊທ໌ນີ້ ແລະ ວັດຖຸອາດຈະບໍ່ເຮັດວຽກຕາມທີ່ຄາດໄວ້!';
$string['stagesize'] = 'ຂະໜາດເວທີ';
$string['stagesize_help'] = 'ການຕັ້ງຄ່າສອງອັນນີ້ ລະບຸຄວາມກວ້າງຂອງກອບ/ໜ້າຈໍ ແລະ ຄວາມສູງສຳລັບວັດຖຸການຮຽນຮູ້.';
$string['started'] = 'ເລີ່ມຕົ້ນໃນ';
$string['status'] = 'ສະຖານະ';
$string['statusbar'] = 'ສະແດງແຖບສະຖານະ';
$string['student_response'] = 'ການຕອບກັບ';
$string['subplugintype_scormreport'] = 'ລາຍງານ';
$string['subplugintype_scormreport_plural'] = 'ລາຍງານ';
$string['suspended'] = 'ຖືກລະງັບ';
$string['syntax'] = 'Syntax ຜິດພາດ';
$string['tag_error'] = 'ແທັກບໍ່ຮູ້ຈັກ ({$a->tag}) ກັບເນື້ອຫານີ້: {$a->value}';
$string['time'] = 'ເວລາ';
$string['title'] = 'ຫົວຂໍ້';
$string['toc'] = 'TOC';
$string['too_many_attributes'] = 'ແທັກ {$a->tag} ມີຄຸນລັກສະນະຫຼາຍເກີນໄປ';
$string['too_many_children'] = 'ແທັກ {$a->tag} ມີລູກຫຼາຍເກີນໄປ';
$string['toolbar'] = 'ສະແດງແຖບເຄື່ອງມື';
$string['totaltime'] = 'ເວລາ';
$string['trackcorrectcount'] = 'ຈຳນວນຖືກຕ້ອງ';
$string['trackcorrectcount_help'] = 'ຜົນໄດ້ຮັບຈຳນວນຖືກຕ້ອງສຳລັບຄຳຖາມ';
$string['trackid'] = 'ລະຫັດປະຈຳຕົວ';
$string['trackid_help'] = 'ນີ້ແມ່ນຕົວລະບຸທີ່ກໍານົດໄວ້ໂດຍຊຸດ SCORM ຂອງທ່ານສໍາລັບຄໍາຖາມນີ້, ຂໍ້ກໍານົດຂອງ SCORM ບໍ່ອະນຸຍາດໃຫ້ມີຂໍ້ຄວາມເຕັມຄໍາຖາມ.';
$string['trackingloose'] = 'ຄຳເຕືອນ: ຂໍ້ມູນການຕິດຕາມຂອງແພັກເກັດນີ້ຈະສູນຫາຍໄປ!';
$string['tracklatency'] = 'ເວລາແຝງ';
$string['tracklatency_help'] = 'ເວລາທີ່ຜ່ານໄປລະຫວ່າງເວລາທີ່ຄໍາຖາມໄດ້ຖືກເຮັດໃຫ້ຜູ້ຮຽນມີຄໍາຕອບ ແລະ ເວລາຕອບຄໍາຖາມທໍາອິດ.';
$string['trackpattern'] = 'ຮູບແບບ';
$string['trackpattern_help'] = 'ນີ້ແມ່ນສິ່ງທີ່ຄໍາຕອບທີ່ຖືກຕ້ອງຕໍ່ຄໍາຖາມນີ້, ມັນບໍ່ໄດ້ສະແດງໃຫ້ເຫັນຄໍາຕອບຂອງນັກຮຽນ.';
$string['trackresponse'] = 'ການຕອບກັບ';
$string['trackresponse_help'] = 'ນີ້ແມ່ນຄໍາຕອບຂອງຜູ້ຮຽນສໍາລັບຄໍາຖາມນີ້';
$string['trackresult'] = 'ຜົນໄດ້ຮັບ';
$string['trackresult_help'] = 'ສະແດງວ່າ ຜູ້ຮຽນປ້ອນຄຳຕອບທີ່ຖືກຕ້ອງຫຼືບໍ່.';
$string['trackscoremax'] = 'ຄະແນນສູງສຸດ';
$string['trackscoremax_help'] = 'ຄ່າສູງສຸດທີ່ສາມາດໄດ້ຮັບການມອບໝາຍສໍາລັບຄະແນນດິບ';
$string['trackscoremin'] = 'ຄະແນນຕ່ຳສຸດ';
$string['trackscoremin_help'] = 'ຄ່າຕ່ຳສຸດທີ່ສາມາດໄດ້ຮັບການກໍານົດສໍາລັບຄະແນນດິບ';
$string['trackscoreraw'] = 'ຄະແນນດິບ';
$string['trackscoreraw_help'] = 'ຕົວເລກທີ່ສະທ້ອນໃຫ້ເຫັນການປະຕິບັດຂອງຜູ້ຮຽນທີ່ກ່ຽວຂ້ອງກັບໄລຍະຜູກພັນໂດຍຄ່າຂອງ ຕ່ຳສຸດ ແລະ ສູງສຸດ';
$string['tracksuspenddata'] = 'ຂໍ້ມູນລະງັບ';
$string['tracksuspenddata_help'] = 'ໃຫ້ພື້ນທີ່ຈັດເກັບ ແລະ ດຶງຂໍ້ມູນລະຫວ່າງຊ່ວງເວລາຂອງຜູ້ຮຽນ';
$string['tracktime'] = 'ເວລາ';
$string['tracktime_help'] = 'ເວລາທີ່ຄວາມພະຍາຍາມໄດ້ເລີ່ມຕົ້ນ';
$string['tracktype'] = 'ປະເພດ';
$string['tracktype_help'] = 'ປະເພດຂອງຄໍາຖາມ, ຕົວຢ່າງ "ທາງເລືອກ" ຫຼື "ຄໍາຕອບສັ້ນ".';
$string['trackweight'] = 'ນ້ຳໜັກ';
$string['trackweight_help'] = 'ນ້ຳໜັກມອບຫມາຍໃຫ້ຄໍາຖາມ ໃນເວລາທີ່ການຄິດໄລ່ຄະແນນ.';
$string['type'] = 'ປະເພດ';
$string['typeaiccurl'] = 'AICC URL ພາຍນອກ';
$string['typeexternal'] = 'ຄວາມຊັດເຈນ SCORM ພາຍນອກ';
$string['typelocal'] = 'ອັບໂຫຼດຊຸດແພັກເກດ';
$string['typelocalsync'] = 'ດາວໂຫຼດຊຸດແພັກເກດ';
$string['undercontent'] = 'ພາຍໃຕ້ເນື້ອຫາ';
$string['unziperror'] = 'ເກີດຄວາມຜິດພາດໃນລະຫວ່າງການແຍກໄຟລ໌ແພັກເກດ';
$string['updatefreq'] = 'ຄວາມຖີ່ຂອງການປັບປຸງອັດຕະໂນມັດ';
$string['updatefreq_error'] = 'ຄວາມຖີ່ການປັບປຸງອັດຕະໂນມັດ ສາມາດຕັ້ງໄດ້ເມື່ອໄຟລ໌ແພັກເກັດຖືກເປັນເຈົ້າພາບຢູ່ພາຍນອກເທົ່ານັ້ນ';
$string['updatefreq_help'] = 'ນີ້ອະນຸຍາດໃຫ້ແພັກເກດພາຍນອກດາວໂຫຼດ ແລະ ປັບປຸງໂດຍອັດຕະໂນມັດ';
$string['updatefreqdesc'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດຄວາມຖີ່ຂອງການປັບປຸງອັດຕະໂນມັດເລີ່ມຕົ້ນຂອງກິດຈະກໍາ';
$string['validateascorm'] = 'ກວດສອບແພັກເກດ';
$string['validation'] = 'ຜົນການກວດສອບ';
$string['validationtype'] = 'ການຕັ້ງຄ່ານີ້ ກໍານົດຫ້ອງສະໝຸດ DOMXML ທີ່ໃຊ້ສໍາລັບການກວດສອບ SCORM Manifest. ຖ້າຫາກວ່າ ທ່ານບໍ່ຮູ້ວ່າອອກທາງເລືອກທີ່ເລືອກ.';
$string['value'] = 'ມູນຄ່າ';
$string['versionwarning'] = 'ສະບັບຊັດເຈນເກົ່າກວ່າ 1.3, ເຕືອນຢູ່ທີ່ແທັກ {$a->tag}';
$string['viewallreports'] = 'ເບິ່ງລາຍງານສຳລັບ {$a} ຄວາມພະຍາຍາມ';
$string['viewalluserreports'] = 'ເບິ່ງລາຍງານສຳລັບ {$a} ຜູ້ໃຊ້';
$string['whatgrade'] = 'ການພະຍາຍາມໃຫ້ຄະແນນ';
$string['whatgrade_help'] = 'ຖ້າຫາກວ່າຄວາມພະຍາຍາມຫຼາຍຄັ້ງໄດ້ຮັບອະນຸຍາດໃຫ້, ການຕັ້ງຄ່ານີ້ລະບຸວ່າ ຄວາມພະຍາຍາມສູງສຸດ, ສະເລ່ຍ (ສະເລ່ຍ), ຄັ້ງທໍາອິດ ຫຼື ຄັ້ງສຸດທ້າຍໄດ້ຖືກບັນທຶກໄວ້ໃນປຶ້ມຄະແນນ. ຕົວເລືອກຄວາມພະຍາຍາມທີ່ສໍາເລັດຄັ້ງສຸດທ້າຍບໍ່ລວມເອົາຄວາມພະຍາຍາມທີ່ມີສະຖານະ \'ລົ້ມເຫຼວ\'.

ໝາຍເຫດກ່ຽວກັບການຈັດການຄວາມພະຍາຍາມຫຼາຍຄັ້ງ:

* ທາງເລືອກໃນການເລີ່ມຕົ້ນຄວາມພະຍາຍາມໃໝ່ ແມ່ນສະຫນອງໃຫ້ໂດຍກ່ອງກາເຄື່ອງໝາຍຂ້າງເທິງປຸ່ມ ປ້ອນເຂົ້າ ໃນໜ້າໂຄງສ້າງເນື້ອຫາ, ດັ່ງນັ້ນ ໃຫ້ແນ່ໃຈວ່າ ທ່ານກໍາລັງສະໜອງການເຂົ້າເຖິງໜ້ານັ້ນ ຖ້າທ່ານຕ້ອງການອະນຸຍາດໃຫ້ມີຄວາມພະຍາຍາມຫຼາຍກວ່າໜຶ່ງຄັ້ງ.
* ບາງຊຸດ SCORM ມີຄວາມສະຫຼາດກ່ຽວກັບຄວາມພະຍາຍາມໃໝ່, ຈໍານວນຫຼາຍບໍ່ແມ່ນ. ນີ້ໝາຍຄວາມວ່າ ຖ້າຜູ້ຮຽນເຂົ້າໄປໃນຄວາມພະຍາຍາມທີ່ມີຢູ່ແລ້ວ, ຖ້າເນື້ອຫາ SCORM ບໍ່ມີເຫດຜົນພາຍໃນ ເພື່ອຫຼີກເວັ້ນການຂຽນທັບຄວາມພະຍາຍາມທີ່ຜ່ານມາ ພວກເຂົາສາມາດຂຽນທັບໄດ້, ເຖິງແມ່ນວ່າຄວາມພະຍາຍາມຈະ \'ສໍາເລັດ\' ຫຼື \'ຜ່ານ\'.
* ການຕັ້ງຄ່າ "ບັງຄັບສໍາເລັດ", "ບັງຄັບຄວາມພະຍາຍາມໃໝ່" ແລະ "ລັອກຫຼັງຈາກຄວາມພະຍາຍາມສຸດທ້າຍ" ຍັງສະໜອງການຄຸ້ມຄອງເພີ່ມເຕີມຂອງຄວາມພະຍາຍາມຫຼາຍຄັ້ງ.';
$string['whatgradedesc'] = 'ບໍ່ວ່າຈະເປັນຄວາມພະຍາຍາມສູງສຸດ, ສະເລ່ຍ (ສະເລ່ຍ), ຄວາມພະຍາຍາມສໍາເລັດຄັ້ງທໍາອິດ ຫຼື ຄັ້ງສຸດທ້າຍ ຈະຖືກບັນທຶກໄວ້ໃນປື້ມຄະແນນ ຖ້າຄວາມພະຍາຍາມຫຼາຍຄັ້ງໄດ້ຮັບອະນຸຍາດ.';
$string['width'] = 'ຄວາມກ້ວາງ';
$string['window'] = 'ໜ້າຈໍ';
$string['youmustselectastatus'] = 'ທ່ານຕ້ອງເລືອກສະຖານະເພື່ອຕ້ອງການ';
