<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'ro', version '4.1'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Acțiuni';
$string['activate'] = 'Permite accesul';
$string['activatesuccess'] = 'Accesul la ecusoane a fost permis cu succes.';
$string['addalignment'] = 'Adăugați abilități externe sau standard';
$string['addbackpack'] = 'Adăugați rucsac de insigne';
$string['addbadge'] = 'Adaugă ecusoane';
$string['addbadge_help'] = 'Selectează toate ecusoanele care trebuie adăugate acestei cerințe. Țineți apăsată tasta CTRL pentru a selecta mai multe elemente.';
$string['addbadgecriteria'] = 'Adaugă criteriu ecuson';
$string['addcohort'] = 'Adaugă cohortă';
$string['addcohort_help'] = 'Selectați toate cohortele ce trebuie adăugate acestei cerințe a ecusoanelor. Țineți apăsată tasta CTRL pentru a selecta mai multe elemente.';
$string['addcompetency'] = 'Adăugați competență';
$string['addcompetency_help'] = 'Selectați toate competențele care ar trebui adăugate la această cerință de insignă. Țineți apăsată tasta CTRL pentru a selecta mai multe elemente.';
$string['addcourse'] = 'Adaugă cursuri';
$string['addcourse_help'] = 'Selectați toate cursurile ce trebuie adăugate acestei cerințe a ecusoanelor. Țineți apăsată tasta CTRL pentru a selecta mai multe elemente.';
$string['addcriteria'] = 'Adăugați criteriu';
$string['addcriteriatext'] = 'Pentru a adăuga criterii, selectați una dintre opțiunile din meniul drop-down.';
$string['addedtobackpack'] = 'S-a adăugat insignă la rucsac';
$string['addrelated'] = 'Adăugați insignă asociată';
$string['addtobackpack'] = 'Adaugă în rucsac';
$string['adminonly'] = 'Această pagină este destinată numai administratorilor de site.';
$string['after'] = 'după data emiterii.';
$string['aggregationmethod'] = 'Metodă de agregare';
$string['alignment'] = 'Aliniere';
$string['all'] = 'Toate';
$string['allmethod'] = 'Toate condițiile selectate sunt îndeplinite';
$string['allmethodactivity'] = 'Toate activitățile selectate sunt finalizate';
$string['allmethodbadges'] = 'Toate ecusoanele selectate au fost dobândite';
$string['allmethodcohort'] = 'Calitatea de membru în cohortele selectate';
$string['allmethodcompetencies'] = 'Toate competențele selectate au fost finalizate';
$string['allmethodcourseset'] = 'Toate cursurile selectate au fost finalizate';
$string['allmethodmanual'] = 'Toate rolurile selectate permit acordarea ecusonului';
$string['allmethodprofile'] = 'Toate câmpurile de profil selectate au fost completate';
$string['allowcoursebadges'] = 'Activează ecusoanele cursurilor';
$string['allowcoursebadges_desc'] = 'Permite crearea și alocarea ecusoanelor în cadrul cursului.';
$string['allowexternalbackpack'] = 'Activează conectarea la rucsacul extern';
$string['allowexternalbackpack_desc'] = 'Permite utilizatorilor să configureze conexiunile și să afișeze ecusoanele de la furnizorii externi.

Observatii: Se recomandă să nu activați aceasta opțiune în cazul în care site-ul web nu poate fi accesat din Internet (de exemplu, datorită firewall).';
$string['any'] = 'Oricare';
$string['anymethod'] = 'Este îndeplinită oricare dintre condițiile selectate';
$string['anymethodactivity'] = 'Este finalizată oricare dintre activitățile selectate';
$string['anymethodbadges'] = 'A fost obținut oricare dintre ecusoanele selectate';
$string['anymethodcohort'] = 'Apartenență la oricare dintre cohortele selectate';
$string['anymethodcompetencies'] = 'Oricare dintre competențele selectate au fost finalizate';
$string['anymethodcourseset'] = 'Este finalizat oricare dintre cursurile selectate';
$string['anymethodmanual'] = 'Oricare dintre rolurile selectate poate acorda ecusonul';
$string['anymethodprofile'] = 'A fost completat oricare dintre câmpurile profilului selectat';
$string['apiversion'] = 'Versiune API acceptată';
$string['archivebadge'] = 'Doriți să ștergeți ecusonul "{$a}", dar să păstrați ecusoanele existente emise?';
$string['archiveconfirm'] = 'Șterge și păstrează ecusoanele existente emise';
$string['archivehelp'] = '<p>Această opțiune permite marcarea ecusonului ca "retras", acesta nemaifigurând în lista de ecusoane. Utilizatorii nu vor mai putea dobândi acest ecuson, dar destinatarii existenți ai acestui ecuson îl vor putea afișa în continuare pe pagina de profil și îl vor putea trimite în backpack-urile externe.</p>
<p>Dacă doriți ca utilizatorii dumneavoastră să aibă acces în continuare la ecusoanele dobândite, este important să selectați această opțiune, în loc să ștergeți complet ecusoanele.</p>';
$string['attachment'] = 'Atașează ecusonul la mesaj';
$string['attachment_help'] = 'Dacă este activat, fișierul ecusonului emis va fi atașat e-mailului destinatarului, în vederea descărcării. (Atașamentele pot fi activate din Administrare site > Conectări > Ieșiri mesaje > Email pentru a utiliza această opțiune.)';
$string['award'] = 'Acordă ecusonul';
$string['awardedto'] = 'Acordat lui {$a}';
$string['awardedtoyou'] = 'Emis mie';
$string['awardoncron'] = 'Accesul la ecusoane a fost activat cu succes. Prea mulți utilizatori pot câștiga imediat acest ecuson. Pentru a asigura performanța site-ului, procesarea acestei acțiuni va dura ceva timp.';
$string['awards'] = 'Destinatari';
$string['backpackapiurl'] = 'Adresa URL a rucsacului de insigne';
$string['backpackavailability'] = 'Verificarea ecusonului extern';
$string['backpackavailability_help'] = 'Pentru ca destinatarii ecusonului să poată demonstra că au obținut ecusoanele de la dumneavoastră, este necesar ca un serviciu extern backpack să poată accesa site-ul dumneavoastră și să poată verifica ecusoanele emise de pe acesta. Site dumneavoastră nu este accesibil în acest moment, ceea ce înseamnă că ecusoanele emise sar care urmează să fie emise nu pot fi verificate.

**De ce vizualizez acest mesaj?**

Este posibil ca firewall-ul dumneavoastră să prevină accesul utilizatorilor din afara rețelei, site-ul dumneavoastră să fie protejat prin parolă sau să rulați site-ul pe un calculator care nu este disponibil de pe Internet (cum ar fi un dispozitiv de dezvoltare locală).

**Aceasta constituie o problemă?**

Este necesar să remediați acest aspect pe orice site de producție pe care intenționați să emiteți ecusoane, în caz contrar destinatarii acestora nu vor putea demonstra proveniența ecusoanelor. În cazul în care site-ul dumneavoastră nu este activ, puteți crea și emite ecusoane de probă cât timp site-ul este accesibil înainte de activare.

*Ce se întâmplă dacă nu pot face întregul site accesibil?**

Singura adresă URL necesară pentru verificare [adresa URL a site-ului dumneavoastră]/badges/assertion.php, prin urmare verificarea ecusonului este posibilă dacă reușiți să modificați firewall-ul dumneavoastră pentru a permite accesul extern la acest fișier.';
$string['backpackbadgessettings'] = 'Schimbați setările rucsacului';
$string['backpackbadgessummary'] = 'Ai afișate {$a->totalbadges} insigne din {$a->totalcollections} colecții.';
$string['backpackcannotsendverification'] = 'Nu poate fi transmis e-mailul de verificare';
$string['backpackconnected'] = 'Rucsacul este conectat';
$string['backpackconnection'] = 'Conectare backpack';
$string['backpackconnection_help'] = 'Conectarea la un rucsac îți permite să îți partajezi ecusoanele de pe acest site și să îți afișezi colecțiile publice de ecusoane din rucsac pe pagina ta de profil de pe acest site.';
$string['backpackconnectioncancelattempt'] = 'Conectare utilizând o adresă de e-mail diferită';
$string['backpackconnectionconnect'] = 'Conectare la backpack';
$string['backpackconnectionnottested'] = 'Conexiunea nu poate fi testată pentru acest rucsac deoarece doar rucsacurile Open Badges v2.0 sunt acceptate.';
$string['backpackconnectionok'] = 'Conexiunea la rucsac a fost stabilită cu succes';
$string['backpackconnectionresendemail'] = 'Retrimite e-mail-ul de verificare';
$string['backpackconnectionunexpectedmessage'] = 'Rucsacul a returnat eroarea: „{$a}”.';
$string['backpackconnectionunexpectedresult'] = 'A apărut o problemă la conectarea la backpack. Furnizorul de backpack îți trimite mesajul: \'{$a}\'.';
$string['backpackdetails'] = 'Setări backpack';
$string['backpackdisconnected'] = 'Rucsacul este deconectat';
$string['backpackemail'] = 'Adresă e-mail';
$string['backpackemail_help'] = 'Adresa de e-mail asociată cu backpack-ul dumneavoastră. Pe durata conectării dumneavoastră, orice ecuson dobândit pe acest site va fi asociat cu această adresă de e-mail.';
$string['backpackemail_required'] = 'Adresa de email trebuie să fie completată';
$string['backpackemailverificationpending'] = 'Verificare în așteptare';
$string['backpackemailverifyemailbody'] = 'Bună,

A fost solicitată o nouă conectare la backpack-ul dumneavoastră OpenBadges  de către "{$a->sitename}" utilizând adresa dumneavoastră de e-mail.

Pentru a confirma și activa conectarea la backpack-ul dumneavoastră, vă rugăm să mergeți pe

{$a->link}

În majoritatea programelor de e-mail, aceasta ar trebui să fie afișat sub forma unui link scris cu albastru, pe care trebui doar să apăsați. Dacă acest lucru nu funcționează, atunci copiați și inserați adresa în spațiul destinat acesteia din partea superioară a browser-ului dumneavoastră web .

Dacă aveți nevoie de asistență, vă rugăm să contactați administratorul site-ului,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Verificare prin e-mail a backpack-ului OpenBadges';
$string['backpackemailverifypending'] = 'A fost transmis un e-mail de verificare către <strong>{$a}</strong>. Dați click pe link-ul de verificare din e-mail pentru a activa conectarea dumneavoastră la backpack.';
$string['backpackemailverifysuccess'] = 'Vă mulțumim pentru verificarea adresei dumneavoastră de e-mail. În acest moment sunteți conectat la backpack-ul dumneavoastră.';
$string['backpackemailverifytokenmismatch'] = 'Token-ul din l-ul pe care ați dat click nu corespunde token-ului setat. Asigurați-vă că ați dat click pe  link-ul din cel mai recent e-mail primit.';
$string['backpackexporterror'] = 'Nu se poate exporta ecusonul în rucsac';
$string['backpackexporterrorwithinfo'] = 'Nu se poate exporta ecusonul "{$a->badgename}" în rucsac. Eroare: {$a->error}';
$string['backpackimport'] = 'Setările importului de ecusoane';
$string['backpackimport_help'] = 'După ce conectarea la  backpack a fost realizată cu succes, ecusoanele din backpack-ul dumneavoastră pot fi afișate pe pagina de ecusoane și pe cea de profil.

În acest loc puteți selecta colecțiile de ecusoane din backpack-ul dumneavoastră, pe care doriți să le afișați pe profil.';
$string['backpackneedsupdate'] = 'Rucsacul conectat la acest profil nu se potrivește cu rucsacul site-ului. Trebuie să deconectați și să reconectați rucsacul.';
$string['backpackprovider'] = 'Furnizor de rucsac';
$string['backpacksettings'] = 'Setări rucsac';
$string['backpackweburl'] = 'URL-ul backpack-ului';
$string['badgedetails'] = 'Detalii ecuson';
$string['badgeimage'] = 'Imagine';
$string['badgeimage_help'] = 'Imaginea trebuie să aibă dimensiunea de cel puțin 300 x 300. Va fi afișată ca 300 x 300 pixeli pe pagina ecusonului și 100 x 100 pixeli pe pagina de profil a utilizatorului.';
$string['badgeissued'] = 'Ecuson emis';
$string['badgeprivacysetting'] = 'Setările de confidențialitate ale ecusonului';
$string['badgeprivacysetting_help'] = 'Ecusoanele dobândite pot fi afișate pe pagina de profil a contului dumneavoastră. Aceste setări vă permit stabilirea în mod automat a vizibilității ecusoanelor recent dobândite.

Puteți gestiona separat setările de confidențialitate ale ecusonului pe pagina dumneavoastră de ecusoane.';
$string['badgeprivacysetting_str'] = 'Afișează în mod automat ecusoanele dobândite pe pagina mea de profil';
$string['badges'] = 'Ecusoane';
$string['badgesalt'] = 'Cheia de securizare pentru generarea hash-ului adreselor de e-mail ale destinatarilor';
$string['badgesalt_desc'] = 'Utilizarea hașurării permite serviciilor backpack să confirme câștigătorul ecusonului fără să fie nevoie să expună adresa de e-mail a acestuia. Această setare va utiliza numai numere și litere.

Note: În scopul verificării destinatarului, vă rugăm să evitați modificarea acestei setări din momentul inițierii ecusoanelor.';
$string['badgesdisabled'] = 'Ecusoanele nu sunt activate pe acest site.';
$string['badgesearned'] = 'Numărul de ecusoane dobândite: {$a}';
$string['badgesettings'] = 'Setări ecusoane';
$string['badgestatus_0'] = 'Nu sunt disponibile';
$string['badgestatus_1'] = 'Sunt disponibile';
$string['badgestatus_2'] = 'Ecusonul nu este disponibil (blocat de criteriile de acordare)';
$string['badgestatus_3'] = 'Ecusonul este disponibil (blocat de criteriile de acordare)';
$string['badgestatus_4'] = 'Arhivat';
$string['badgestoearn'] = 'Numărul de ecusoane disponibile: {$a}';
$string['badgesview'] = 'Ecusoane curs';
$string['badgeurl'] = 'Link către ecusoanele emise';
$string['balignment'] = 'Criterii ({$a})';
$string['bawards'] = 'Destinatari ({$a})';
$string['bcriteria'] = 'Criteriu';
$string['bdetails'] = 'Editează detalii';
$string['bendorsement'] = 'Susținere';
$string['bmessage'] = 'Mesaj';
$string['boverview'] = 'Privire de ansamblu';
$string['brelated'] = 'Insigne conexe ({$a})';
$string['bydate'] = 'Completat până la data:';
$string['claim'] = 'Cerere';
$string['claimcomment'] = 'Comentariu de susținere';
$string['claimid'] = 'Adresa URL de revendicare rucsac';
$string['clearsettings'] = 'Șterge setări';
$string['completioninfo'] = 'Acest ecuson a fost emis spre completare:';
$string['completionnotenabled'] = 'Finalizarea nu este activată pentru acest curs, astfel încât nu poate fi inclusă în rândul criteriilor privind ecusonul. Finalizare cursului poate fi activată din setările acestuia.';
$string['configenablebadges'] = 'Atunci când este activată, această caracteristică vă permite să creați ecusoane și să le acordați utilizatorilor site-ului.';
$string['configuremessage'] = 'Mesaj ecuson';
$string['connect'] = 'Conectați-vă';
$string['connected'] = 'Conectat';
$string['connecting'] = 'În curs de conectare...';
$string['contact'] = 'Contactați';
$string['contact_help'] = 'O adresă de e-mail asociată cu emitentul ecusonului.';
$string['copyof'] = 'Copia {$a}';
$string['course'] = 'Curs: {$a}';
$string['coursebadges'] = 'Ecusoane';
$string['coursebadgesdisabled'] = 'Ecusoanele cursului nu sunt activate pe acest site.';
$string['coursebadgetitle'] = '{$a} ecuson curs';
$string['coursecompletion'] = 'Utilizatorii trebuie să finalizeze acest curs.';
$string['create'] = 'Ecuson nou';
$string['createbutton'] = 'Creează ecuson';
$string['creatorbody'] = '<p>{$a->user} au fost îndeplinite toate cerințele și a fost acordat ecusonul. Vizualizarea ecusonului emis pe {$a->link} </p>';
$string['creatorsubject'] = '"{$a}" a fost acordat!';
$string['criteria_0'] = 'Acest ecuson este acordat atunci când...';
$string['criteria_1'] = 'Finalizarea unei activități';
$string['criteria_1_help'] = 'Permite acordarea unui ecuson utilizatorilor pe baza finalizării unui set de activități din cadrul unui curs.';
$string['criteria_2'] = 'Emitere manuală în funcție de rol';
$string['criteria_2_help'] = 'Permite acordarea manuală a unui ecuson utilizatorilor care îndeplinesc un anumit rol pe site sau în cadrul cursului.';
$string['criteria_3'] = 'Participare socială';
$string['criteria_3_help'] = 'Social';
$string['criteria_4'] = 'Finalizarea cursului';
$string['criteria_4_help'] = 'Permite acordarea unui ecuson utilizatorilor care au finalizat cursul. Acest criteriu este însoțit de parametrii suplimentari, cum ar fi nota minimă și data finalizării cursului.';
$string['criteria_5'] = 'Finalizarea unui set de curs';
$string['criteria_5_help'] = 'Permite acordarea unui ecuson utilizatorilor care au finalizat un set de curs. Fiecare curs poate fi însoțit de parametrii suplimentari, cum ar fi nota minimă și data finalizării cursului.';
$string['criteria_6'] = 'Completarea profilului';
$string['criteria_6_help'] = 'Permite acordarea unui ecuson utilizatorilor pentru completarea numitor câmpuri din profilul lor. Puteți selecta dintre câmpurile de profil implicite și personalizate disponibile pentru utilizatori.';
$string['criteria_7'] = 'Ecusoane obținute';
$string['criteria_7_help'] = 'Permite acordarea unui ecuson utilizatorilor pornind de la celelalte ecusoane dobândite.';
$string['criteria_8'] = 'Calitatea de membru al cohortei';
$string['criteria_8_help'] = 'Permite acordarea unui ecuson utilizatorilor pornind de la calitatea de membru al cohortei.';
$string['criteria_9'] = 'Competențe';
$string['criteria_9_help'] = 'Permite acordarea unei insigne utilizatorilor pe baza competențelor pe care le-au dobândit.';
$string['criteria_descr'] = 'Utilizatorii dobândesc acest ecuson atunci când îndeplinesc următoarele cerințe:';
$string['criteria_descr_0'] = 'Completați <strong>{$a}</strong> dintre cerințele enumerate.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> dintre următoarele activității sunt îndeplinite:';
$string['criteria_descr_2'] = 'Acest ecuson trebuie acordat de către utilizatorii cu <strong>{$a}</strong> dintre următoarele roluri:';
$string['criteria_descr_4'] = 'Utilizatorii trebuie să finalizeze cursul';
$string['criteria_descr_5'] = '<strong>{$a}</strong> dintre următoarele cursuri sunt finalizate:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> dintre următoarele câmpuri de profil al utilizatorului trebuie completate:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> dintre următoarele ecusoane trebuie dobândite:';
$string['criteria_descr_8'] = 'Este necesară calitate de membru în <strong>{$a}</strong> următoarele cohorte:';
$string['criteria_descr_9'] = '<strong> {$a} </strong> dintre următoarele competențe trebuie completate:';
$string['criteria_descr_bydate'] = 'by <em>{$a}</em>';
$string['criteria_descr_grade'] = 'cu nota minimă <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Finalizează <strong>{$a}</strong> din:';
$string['criteria_descr_short1'] = 'Finalizează <strong>{$a}</strong> din:';
$string['criteria_descr_short2'] = 'Acordat de <strong>{$a}</strong> din:';
$string['criteria_descr_short4'] = 'Finalizează cursul';
$string['criteria_descr_short5'] = 'Finalizează <strong>{$a}</strong> din:';
$string['criteria_descr_short6'] = 'Finalizează <strong>{$a}</strong> din:';
$string['criteria_descr_short7'] = 'Finalizează <strong>{$a}</strong> din:';
$string['criteria_descr_short8'] = 'Calitatea de membru în <strong>{$a}</strong> din:';
$string['criteria_descr_short9'] = 'Completați <strong> {$a} </strong> din:';
$string['criteria_descr_single_1'] = 'Următoarele activități trebuie finalizate:';
$string['criteria_descr_single_2'] = 'Acest ecuson trebuie acordat de către utilizatorii cu următoarele roluri:';
$string['criteria_descr_single_4'] = 'Utilizatorii trebuie să finalizeze cursul';
$string['criteria_descr_single_5'] = 'Următorul curs trebuie finalizat:';
$string['criteria_descr_single_6'] = 'Următorul câmp de profil al utilizatorului trebuie completat:';
$string['criteria_descr_single_7'] = 'Următorul ecuson trebuie dobândit:';
$string['criteria_descr_single_8'] = 'ESte necesar să fiți membru în următoarea cohortă:';
$string['criteria_descr_single_9'] = 'Următoarele competențe trebuie să fie completate:';
$string['criteria_descr_single_short1'] = 'Finalizează:';
$string['criteria_descr_single_short2'] = 'Acordat de:';
$string['criteria_descr_single_short4'] = 'Finalizează cursul';
$string['criteria_descr_single_short5'] = 'Finalizează:';
$string['criteria_descr_single_short6'] = 'Finalizează:';
$string['criteria_descr_single_short7'] = 'Finalizează:';
$string['criteria_descr_single_short8'] = 'Membru în:';
$string['criteria_descr_single_short9'] = 'Complet:';
$string['criteriacreated'] = 'Criteriu ecuson creat cu succes';
$string['criteriadeleted'] = 'Criteriu ecuson creat cu succes';
$string['criteriasummary'] = 'Rezumat criterii';
$string['criteriaupdated'] = 'Criteriu ecuson actualizat cu succes';
$string['criterror'] = 'Probleme parametrii actuali';
$string['criterror_help'] = 'Acest set de câmpuri arată toți parametrii adăugați inițial la cerințele acestui ecuson și care nu mai sunt disponibili. Se recomandă să debifați astfel de parametrii pentru a vă asigura că, pe viitor, utilizatorii pot câștiga acest ecuson.';
$string['currentimage'] = 'Imaginea curentă';
$string['currentstatus'] = 'Status-ul curent:';
$string['dateawarded'] = 'Data emiterii';
$string['dateearned'] = 'Dată: {$a}';
$string['day'] = 'Ziua(zilele)';
$string['deactivate'] = 'Dezactivează acces';
$string['deactivatesuccess'] = 'Accesul la ecusoane a fost dezactivat cu succes.';
$string['defaultissuercontact'] = 'Detalii contact emitent implicit al ecusonului';
$string['defaultissuercontact_desc'] = 'O adresă de e-mail asociată cu emitentul ecusonului.';
$string['defaultissuername'] = 'Numele emitentului implicit al ecusonului';
$string['defaultissuername_desc'] = 'Numele agentului sau autorității emitente.';
$string['defaultissuerpassword'] = 'Parola emitentului de insignă';
$string['defaultissuerpassword_help'] = 'Este necesar un cont pe site-ul rucsacului cu adresa de e-mail, așa cum este specificat în setarea adresei de e-mail a emitentului de ecusoane în setările Administrare site / Ecusoane / Setările ecusoane. Parola pentru cont ar trebui să fie introdusă aici.';
$string['delbadge'] = 'Doriți să ștergeți ecusonul "{$a}" și să eliminați toate ecusoanele existente emise?';
$string['delconfirm'] = 'Șterge și elimină ecusoanele existente emise';
$string['delcritconfirm'] = 'Sunteți sigur că doriți să ștergeți acest criteriu?';
$string['deletehelp'] = '<p>Ștergerea în întregime a unui ecuson înseamnă că toate înregistrările privind informațiile și criteriile acestuia vor fi eliminate pentru totdeauna. Utilizatorii care au câștigat acest ecuson nu-l vor mai putea accesa și nici nu-l vor mai putea afișa pe paginile de profil.</p>
<p>Note: Utilizatorii care au câștigat acest ecuson și l-au transmis spre backpack-ul extern, îl vor avea în continuare în acest loc. Cu toate acestea, ei nu vor mai putea accesa paginile privind criteriile și evidența, pagini care fac legătura cu acest site web.</p>';
$string['delexternalbackpack'] = 'Ștergeți site-ul rucsacului';
$string['delexternalbackpackconfirm'] = 'Ștergeți site-ul rucsaculului „{$a}”?';
$string['delparamconfirm'] = 'Sunteți sigur că doriți să ștergeți acest parametru?';
$string['description'] = 'Descriere';
$string['disconnect'] = 'Deconectare';
$string['donotaward'] = 'În prezent, acest ecuson nu este activ, deci nu poate fi acordat utilizatorilor. Dacă doriți să acordați acest ecuson, vă rugăm să schimbați statusul său în activ.';
$string['enablebadges'] = 'Activează ecusoane';
$string['endorsement'] = 'Susținere';
$string['error:backpackdatainvalid'] = 'Returnarea datelor în backpack nu este validă.';
$string['error:backpackemailnotfound'] = 'E-mailul "{$a}" nu este asociat unui backpack. Este necesar <a href="http://backpack.openbadges.org">să creați un backpack</a> pentru acel cont sau să vă conectați cu o altă adresă de e-mail.';
$string['error:backpacknotavailable'] = 'Site-ul dumneavoastră nu poate fi accesat de pe Internet, deci orice ecuson emis de pa acest site nu poate fi verificat de serviciile backpack externe.';
$string['error:backpackproblem'] = 'A apărut o problemă la conectarea la fursnizorul dumneavoastră de servicii backpack. Vă rguăm să încercați mai târziu.';
$string['error:badgeawardnotfound'] = 'Acest ecuson acordat nu poate fi verificat.  Este posibil ca acest ecuson să fi fost revocat.';
$string['error:badgenotfound'] = 'Ecusonul nu a fost găsit';
$string['error:cannotact'] = 'Ecusonul nu poate fi activat.';
$string['error:cannotawardbadge'] = 'Ecusonul nu poate fi acordat utilizatorului.';
$string['error:cannotdeletecriterion'] = 'Acest criteriu nu poate fi șters.';
$string['error:cannotrevokebadge'] = 'Nu se poate anula ecusonul unui utilizator.';
$string['error:clone'] = 'Ecusonul nu poate fi clonat.';
$string['error:connectionunknownreason'] = 'Conexiunea nu a reușit, dar nu a fost furnizat niciun motiv.';
$string['error:duplicatename'] = 'Ecusonul cu acest nume există deja în sistem.';
$string['error:externalbadgedoesntexist'] = 'Ecusonul nu a fost găsit';
$string['error:guestuseraccess'] = 'În prezent utilizați accesul pentru vizitatori. Pentru a vizualiza ecusoanele este necesar să vă conectați folosind contul dumneavoastră de utilizator.';
$string['error:invalidcriteriatype'] = 'Tip criteriu invalid.';
$string['error:invalidexpiredate'] = 'Data de expirare trebuie să fie în viitor.';
$string['error:invalidexpireperiod'] = 'Perioada de expirare nu poate fi negativă sau egală cu 0.';
$string['error:invalidparambadge'] = 'Ecusonul nu există.';
$string['error:invalidparamcohort'] = 'Cohorta nu există.';
$string['error:noactivities'] = 'În acest curs nu se găsesc activități cu criteriu de finalizare activat.';
$string['error:nobadges'] = 'În prezent, nu se găsesc insigne cu acces activat pentru a fi adăugate drept criterii. O insignă de site poate avea drept criteriu doar alte insigne de site. O insignă de curs poate avea drept criterii alte insigne de curs sau insigne de site.';
$string['error:nocohorts'] = 'Nu se găsesc cohorte';
$string['error:nocourses'] = 'Finalizarea cursului nu este activată pentru niciunul dintre cursurile din acest site, deci nu poate fi afișată. Finalizarea cursului poate fi activată din setările cursului.';
$string['error:nogroupslink'] = '<p> Sunt afișate numai colecțiile publice. <a href="{$a}" target="_blank" rel="nofollow"> Accesați rucsacul </a> pentru a crea câteva colecții publice. </p>';
$string['error:nogroupssummary'] = '<p> Nu se găsesc colecții publice de insigne disponibile în rucsac. </p>';
$string['error:nopermissiontoview'] = 'Nu aveți permisiunea de a vizualiza destinatarii ecusonului';
$string['error:nosuchbadge'] = 'Ecusonul cu id-ul {$a} nu există.';
$string['error:nosuchcohort'] = 'Avertisment: Această cohortă nu mai este disponibilă.';
$string['error:nosuchcourse'] = 'Avertisment: Acest curs nu mai este disponibil.';
$string['error:nosuchfield'] = 'Avertisment: Acest câmp de profil al utilizatorului nu mai este disponibil.';
$string['error:nosuchmod'] = 'Avertisment: Această activitate nu mai este disponibilă.';
$string['error:nosuchrole'] = 'Avertisment: Această poziție nu mai este disponibilă.';
$string['error:nosuchuser'] = 'Utilizatorul acestei adrese de e-mail nu are un cont cu furnizorul curent de backpack.';
$string['error:notifycoursedate'] = 'Avertisment: Ecusoanele asociate cursului și finalizării activității nu vor fi emise până la data de începere a cursului.';
$string['error:parameter'] = 'Avertisment: Trebuie selectat cel puțin un parametru pentru a asigura fluxul corect al emiterii ecusonului.';
$string['error:relatedbadgedoesntexist'] = 'Fără nicio insignă publică cu acest identificator';
$string['error:requesterror'] = 'Solicitarea de conectare a eșuat (eroare cod {$a}).';
$string['error:requesttimeout'] = 'Solicitarea de conectare a expirat înainte de a fi completată.';
$string['error:save'] = 'Ecusonul nu a putu fi salvat.';
$string['error:userdeleted'] = '{$a->user} (Acest utilizator nu mai există pe {$a->site})';
$string['eventbadgearchived'] = 'Ecuson arhivat';
$string['eventbadgeawarded'] = 'Ecuson acordat';
$string['eventbadgecreated'] = 'Ecuson creat';
$string['eventbadgecriteriacreated'] = 'Criteriu ecuson creat';
$string['eventbadgecriteriadeleted'] = 'Criteriu ecuson șters';
$string['eventbadgecriteriaupdated'] = 'Criteriu ecuson actualizat';
$string['eventbadgedeleted'] = 'Ecuson șters';
$string['eventbadgedisabled'] = 'Ecuson dezactivat';
$string['eventbadgeduplicated'] = 'Duplicat ecuson';
$string['eventbadgeenabled'] = 'Ecuson activat';
$string['eventbadgelistingviewed'] = 'Lista ecusoanelor vizualizate';
$string['eventbadgerevoked'] = 'Ecuson revizualizat';
$string['eventbadgeupdated'] = 'Ecuson actualizat';
$string['eventbadgeviewed'] = 'Ecuson vizualizat';
$string['evidence'] = 'Evidență';
$string['existingrecipients'] = 'Destinatari ecusonului existent';
$string['existsinbackpack'] = 'Ecusonul există deja în backpack';
$string['expired'] = 'Expirat';
$string['expiredate'] = 'Acest ecuson expiră în {$a}.';
$string['expireddate'] = 'Acest ecuson expiră pe {$a}.';
$string['expiredin'] = 'Expirat {$a}';
$string['expireperiod'] = 'Acest ecuson expiră în {$a} zile după ce a fost emis.';
$string['expireperiodh'] = 'Acest ecuson expiră în {$a} ore după ce a fost emis.';
$string['expireperiodm'] = 'Acest ecuson expiră în {$a} minute după ce a fost emis.';
$string['expireperiods'] = 'Acest ecuson expiră în {$a} secunde după ce a fost emis.';
$string['expiresin'] = 'Expiră {$a}';
$string['expirydate'] = 'Data expirării';
$string['expirydate_help'] = 'Opțional, ecusoanele pot expira la o dată specifică sau data poate calculată pornind de la data la care ecusonul a fost emis utilizatorului.';
$string['externalbadges'] = 'Ecusoanele mele de pe alte site-uri web';
$string['externalbadges_help'] = 'Această zonă afișează ecusoanele din backpack-ul dumneavoastră extern.';
$string['externalbadgesp'] = 'Ecusoanele de pe alte site-uri web:';
$string['externalconnectto'] = 'Pentru a afișa ecusoanele externe este necesar să vă conectați la <a href="{$a}">conectat la un backpack</a>.';
$string['fixed'] = 'Dată fixată';
$string['hidden'] = 'Ascuns';
$string['hiddenbadge'] = 'Din păcate, proprietarul ecusonului nu a făcut aceste informații disponibile.';
$string['hostedurl'] = 'Adresă URL externă';
$string['hostedurldescription'] = 'URL extern unde este găzduit ecusonul';
$string['imageauthoremail'] = 'E-mailul autorului imaginii';
$string['imageauthoremail_help'] = 'Dacă este specificat, adresa de e-mail a autorului imaginii insignei este afișată pe pagina insignei.';
$string['imageauthorname'] = 'Numele autorului imaginii';
$string['imageauthorname_help'] = 'Dacă este specificat, numele autorului imaginii insignei este afișat pe pagina insignei.';
$string['imageauthorurl'] = 'URL-ul autorului imaginii';
$string['imageauthorurl_help'] = 'Dacă este specificat, pe pagina insignei este afișat un link către site-ul autorului imaginii insignei. Adresa URL trebuie să aibă un prefix http: // sau https: //.';
$string['imagecaption'] = 'Legenda imaginii';
$string['imagecaption_help'] = 'Dacă este specificat, pe pagina insignei este afișată o legendă a imaginii.';
$string['includeauthdetails'] = 'Includeți detalii de autentificare cu rucsacul';
$string['invalidurl'] = 'URL invalid';
$string['issuancedetails'] = 'Ecuson expirat';
$string['issuedbadge'] = 'Informații privind ecusonul emis';
$string['issuedby'] = 'Emis de {$a}';
$string['issuedon'] = 'Emis {$a}';
$string['issuerdetails'] = 'Detalii emitent';
$string['issueremail'] = 'Email';
$string['issueremail_help'] = 'O adresă de e-mail de contact a organizației care emite aprobarea.';
$string['issuername'] = 'Nume emitent';
$string['issuername_endorsement'] = 'Numele susținătorului';
$string['issuername_endorsement_help'] = 'Numele susținătorului';
$string['issuername_help'] = 'Numele agentului sau autorității emitente.';
$string['issuerurl'] = 'Adresa URL a emitentului';
$string['issuerurl_help'] = 'Site-ul web al organizației care emite aprobarea. Adresa URL trebuie să aibă un prefix http: // sau https: //.';
$string['language'] = 'Limbă';
$string['language_help'] = 'Limba utilizată pe pagina insignei.';
$string['listbackpacks'] = 'Lista de backpack-uri';
$string['localbadges'] = 'Ecusoanele mele de pe {$a} site-ul web';
$string['localbadgesh'] = 'Ecusoanele mele de pe acest site web';
$string['localbadgesh_help'] = 'Toate ecusoanele câștigate pe acest site web prin finalizarea cursurilor, a activităților de curs, precum și a altor cerințe.

Puteți gestiona ecusoanele aici făcându-le publice sau private pentru pagina dumneavoastră de profil.

Puteți descărca toate ecusoanele sau fiecare ecuson în mod separat și le puteți salva pe calculatorul dumneavoastră. Ecusoanele descărcate pot fi adăugate la serviciul dumneavoastră backpack extern.';
$string['localbadgesp'] = 'Ecusoane de la {$a}:';
$string['localconnectto'] = 'Pentru a distribui ecusoanele în afara acestui site web, trebuie să vă <a href="{$a}">conectați la un backpack</a>.';
$string['makeprivate'] = 'Faceți privat';
$string['makepublic'] = 'Faceți public';
$string['managebackpacks'] = 'Gestionați rucsacurile';
$string['managebadges'] = 'Gestionare ecusoane';
$string['message'] = 'Cuprins mesaj';
$string['messagebody'] = '<p>Vi s-a acordat ecusonul "%badgename%"!</p>
<p>Informații suplimentare privind acest ecuson pot fi găsite pe  %badgelink% pagina de informații ecuson.</p>
<p>Puteți gestiona și descărca ecusonul din pagina {$a} dumneavoastră.</p>';
$string['messagesubject'] = 'Felicitări! Tocmai ați câștigat un ecuson!';
$string['method'] = 'Acest criteriu este îndeplinit, atunci când...';
$string['mingrade'] = 'Nota minimă necesară';
$string['month'] = 'Luni';
$string['moredetails'] = 'Mai multe detalii';
$string['mybackpack'] = 'Setările backpack-ului meu';
$string['mybadges'] = 'Ecusoanele mele';
$string['never'] = 'Niciodată';
$string['newbackpack'] = 'Adăugați un rucsac nou';
$string['newbadge'] = 'Adaugă un nou ecuson';
$string['newimage'] = 'Imagine nouă';
$string['noalignment'] = 'Această insignă nu are competențe sau standarde externe specificate.';
$string['noawards'] = 'Acest ecuson nu a fost câștigat încă.';
$string['nobackpack'] = 'Nu există niciun serviciu backpack conectat la acest cont.<br/>';
$string['nobackpackbadgessummary'] = 'Nu se găsesc ecusoane în colecțiile pe care le-ați selectat.';
$string['nobackpackcollectionssummary'] = 'Nu au fost selectate colecții de insigne.';
$string['nobackpacks'] = 'Nu se găsesc rucsaci disponibili';
$string['nobadges'] = 'În prezent, nu se găsesc insigne disponibile pentru ca utilizatorii să le câștige.';
$string['nocompetencies'] = 'Fără competențe selectate';
$string['nocriteria'] = 'Criteriul pentru acest ecuson nu a fost configurat încă.';
$string['noendorsement'] = 'Această insignă nu are nicio susținere.';
$string['noexpiry'] = 'Acest ecuson nu are o dată de expirare.';
$string['noparamstoadd'] = 'Fără parametri suplimentari disponibili pentru a fi adăugați la această cerință a ecusonului.';
$string['norelated'] = 'Această insignă nu are nicio insignă asociată.';
$string['notacceptedrole'] = 'Rolul dumneavoastră curent nu se numără printre rolurile care pot emite manual acest ecuson.<br/>
Dacă doriți să vizualizați utilizatorii care au câștigat deja acest ecuson, puteți vizita pagina {$a}.';
$string['notconnected'] = 'Nu este conectat';
$string['notealignment'] = 'Pot fi specificate abilități sau standarde externe, cu care insigna este aliniată. Orice abilități sau standarde externe sunt afișate pe pagina insignei.';
$string['noteendorsement'] = 'O aprobare de la o terță parte poate fi utilizată pentru a adăuga valoare insignei. De exemplu, o insignă emisă de un profesor poate fi vizată de școală sau o insignă emisă de un organism local de atribuire poate fi aprobată de către organismul național de atribuire.';
$string['noterelated'] = 'Insignele cu o conexiune pot fi marcate ca asociate. De exemplu, insignele cu aceleași criterii care sunt afișate în diferite limbi pot fi marcate ca fiind corelate. Orice ecusoane aferente sunt afișate pe pagina de ecusoane.';
$string['nothingtoadd'] = 'Fără criterii disponibile de adăugat.';
$string['notification'] = 'Notifică persoana care a creat ecusonul';
$string['notification_help'] = 'Această setare gestionează notificările trimise către creatorul ecusonului pentru a-l informa ca ecusonul a fost emis.

Sunt disponibile următoarele opțiuni:

* **NICIODATĂ** – Nu trimite notificări.

* **DE FIECARE DATĂ** – Trimite o notificare de fiecare dată când acest ecuson este acordat.

* **ZILNIC** – Trimite notificări odată pe zi.

* **SĂPTĂMÂNAL** – Trimite notificări odată pe săptămână.

* **LUNAR** – Trimite notificări odată pe lună.';
$string['notifydaily'] = 'Zilnic';
$string['notifyevery'] = 'De fiecare dată';
$string['notifymonthly'] = 'Lunar';
$string['notifyweekly'] = 'Săptămânal';
$string['numawards'] = 'Acest ecuson poate fi emis <a href="{$a->link}">{$a->count}</a> utilizatorilor.';
$string['numawardstat'] = 'Acest ecuson a fost emis {$a} utilizatorilor.';
$string['oauth2issuer'] = 'Servicii OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Altă navigare ...';
$string['overallcrit'] = 'dintre criteriile selectate au fost îndeplinite.';
$string['password_required'] = 'Parola nu poate fi lăsată necompletată';
$string['potentialrecipients'] = 'Destinatari potențiali ai ecusonului';
$string['preferences'] = 'Preferințe ecuson';
$string['privacy:metadata:backpack'] = 'O înregistrare a backpack-urilor utilizatorilor';
$string['privacy:metadata:backpack:backpackuid'] = 'Element unic de identificare a backpack-ului';
$string['privacy:metadata:backpack:email'] = 'Adresa de e-mail asociată cu backpack-ul';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Identificatorul rucsacului';
$string['privacy:metadata:backpack:userid'] = 'Identificatorul utilizatorului care deține backpack-ul';
$string['privacy:metadata:backpackoauth2'] = 'Informații OAuth 2 atunci când utilizatorul se conectează la un rucsac extern';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'Identficator serviciu OAuth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Lista scopului de conectare al rucsacului';
$string['privacy:metadata:backpackoauth2:token'] = 'Jeton conexiune rucsac';
$string['privacy:metadata:backpackoauth2:userid'] = 'ldentificatorul utilizatorului conectat la rucsac';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Identificatorul utilizatorului conectat modificat';
$string['privacy:metadata:badge'] = 'O colecție de ecusoane';
$string['privacy:metadata:badge:timecreated'] = 'Momentul în care a fost creat ecusonul';
$string['privacy:metadata:badge:timemodified'] = 'Momentul în care a fost modificat ultima dată ecusonul';
$string['privacy:metadata:badge:usercreated'] = 'Identificatorul utilizatorului care a creat ecusonul';
$string['privacy:metadata:badge:usermodified'] = 'Identificatorul utilizatorului care a modificat ecusonul';
$string['privacy:metadata:criteriamet'] = 'O colecție de criterii îndeplinite';
$string['privacy:metadata:criteriamet:datemet'] = 'Data îndeplinirii criteriilor';
$string['privacy:metadata:criteriamet:userid'] = 'Identificatorul utilizatorului care a îndeplinit criteriile';
$string['privacy:metadata:external:backpacks'] = 'Informațiile distribuite atunci când utilizatorii transmit ecusoanele deținute către un backpack extern';
$string['privacy:metadata:external:backpacks:badge'] = 'Numele ecusonului';
$string['privacy:metadata:external:backpacks:description'] = 'Descrierea ecusonului';
$string['privacy:metadata:external:backpacks:image'] = 'Imaginea ecusonului';
$string['privacy:metadata:external:backpacks:issuer'] = 'Câteva informații privind emitentul';
$string['privacy:metadata:external:backpacks:url'] = 'Adresa Moodle URL unde pot fi vizualizate informațiile privind ecusoanele emise';
$string['privacy:metadata:issued'] = 'O înregistrarea a ecusoanelor acordate';
$string['privacy:metadata:issued:dateexpire'] = 'Data expirării ecusonului';
$string['privacy:metadata:issued:dateissued'] = 'Data acordării';
$string['privacy:metadata:issued:userid'] = 'Identificatorul utilizatorului care a acordat ecusonul';
$string['privacy:metadata:manualaward'] = 'Înregistrarea acordărilor manuale';
$string['privacy:metadata:manualaward:datemet'] = 'Data la care utilizatorului i-a fost acordat ecusonul';
$string['privacy:metadata:manualaward:issuerid'] = 'Identificatorul utilizatorului care oferă ecusonul';
$string['privacy:metadata:manualaward:issuerrole'] = 'Poziția utilizatorului care a acordat ecusonul';
$string['privacy:metadata:manualaward:recipientid'] = 'Identificatorul utilizatorului căruia i-a fost acordat manual ecusonul';
$string['recipient'] = 'Destinatarul ecusonului';
$string['recipientdetails'] = 'Detalii destinatar';
$string['recipientidentificationproblem'] = 'Nu poate fi găsit destinatarul acestui ecuson printre urilizatorii existenți.';
$string['recipients'] = 'Destinatari ecuson';
$string['recipientvalidationproblem'] = 'Utilizatorul curent nu poate fi verificat ca destinatar al acestui ecuson.';
$string['relatedbages'] = 'Ecusoane conexe';
$string['relative'] = 'Data relativă';
$string['requiredbadge'] = 'Cel puțin un ecuson trebuie adăugat la criteriile ecusonului.';
$string['requiredcohort'] = 'Cel puțin o cohortă trebuie adăugată la criteriile cohortei.';
$string['requiredcompetency'] = 'La criteriul competenței ar trebui adăugată cel puțin o competență.';
$string['requiredcourse'] = 'Cel puțin un curs trebuie adăugat la criteriile setului de curs.';
$string['reviewbadge'] = 'Modificările aduse accesării ecusonului';
$string['reviewconfirm'] = '<p>Acest lucru va face vizibil celorlalți utilizatori ecusonul dumneavoastră și le va permite să-l câștige.</p>

<p>Este posibil ca unii dintre utilizatori să îndeplinească deja criteriile acestui ecuson, iar acest ecuson va fi emis imediat după ce îl veți activa.</p>

<p>Odată ce ecusonul a fost emis acesta va fi <strong>blocat</strong> - anumite setări incluzând criteriul și setările expirării nu mai pot fi modificate.</p>

<p>Sunteți sigur că doriți să activați accesul la ecuson "{$a}"?</p>';
$string['revoke'] = 'Revocă ecuson';
$string['save'] = 'Salvare';
$string['searchname'] = 'Căutare după nume';
$string['selectaward'] = 'Vă rugăm să selectați poziția pe care doriți să o utilizați pentru a acorda acest ecuson:';
$string['selectgroup_end'] = 'Sunt afișate numai colecțiile publice, <a href="http://backpack.openbadges.org">vizitați backpack-ul dumneavoastră</a> pentru a crea mai multe colecții publice.';
$string['selectgroup_start'] = 'Selectați colecțiile din backpack-ul dumneavoastră pentru a fi afișate pe acest site:';
$string['selecting'] = 'Cu ecusoanele selectate...';
$string['setup'] = 'Configurează conexiune';
$string['sitebackpack'] = 'Rucsac extern activ';
$string['sitebackpack_help'] = 'Rucsacul extern la care utilizatorii se pot conecta de pe acest site. Rețineți că modificarea acestei setări după ce utilizatorii și-au conectat rucsacurile va necesita ca fiecare utilizator să meargă la pagina de setări a rucsacului și să se deconecteze, apoi să se reconecteze.';
$string['sitebackpackdeleted'] = 'Site-ul rucsacului a fost șters.';
$string['sitebackpacknotdeleted'] = 'Acest rucsac nu a putut fi șters deoarece este momentan implicit pe site';
$string['sitebackpackwarning'] = 'Nu s-a putut conecta la rucsac. <br/> <br/> Verificați dacă setarea de administrator „Adresa de e-mail a emitentului de insignă” este adresa de e-mail validă pentru un cont de pe site-ul web al rucsacului. <br/> <br/> Verificați dacă „Parola emitentului insignei” din <a href="{$a->url}"> pagina de setări a rucsacului site-ului </a>, este parola corectă pentru contul de pe site-ul rucsacului. <br/> <br/> Rucsacul a returnat: „{$a->warning}”';
$string['sitebadges'] = 'Ecusoane site';
$string['sitebadges_help'] = 'Ecusoanele de site pot fi acordate utilizatorilor numai pentru activități legate de site-ul respectiv. Acestea includ parcurgerea și finalizarea unui set de cursuri sau a unor părți din prifilul utilizatorului. Ecusoanele de site pot fi emise și manual de către un utilizator altui utilizator.

Ecusoanele pentru activități legate de curs trebuie create la nivel de curs. Ecusoanele de curs pot fi găsite pe Administrare curs > Ecusoane.';
$string['sitebadgetitle'] = '{$a} ecuson site';
$string['status'] = 'Status ecuson';
$string['status_help'] = 'Status-ul unui ecuson determină comportamentul acestuia în sistem:

* **DISPONIBIL** – Aceasta înseamnă că ecusonul poate fi câștigat de utilizatori. Cât timp un ecuson este disponibil pentru utilizatori, criteriile lui pot fi modificate .

* **INDISPONIBIL** – Aceasta înseamnă că ecusonul nu este disponibil pentru utilizatori și nu poate fi câștigat sau emis manual. Dacă un astfel de ecuson nu a mai fost emis niciodată, criteriile sale pot fi modificate.

Odată ce un ecuson a fost emis cel puțin unui utilizator, acesta devina automat **BLOCAT**. Ecusoanele blocate pot fi câștigate în continuare de utilizatori, dar criteriile lui nu mai pot fi modificate. Dacă este necesar să modificați detaliile sau criteriile unui ecuson blocat, puteți duplica acest ecuson și efectua toate modificările dorite.

*De ce blocăm ecusoanele?*

Dorim să ne asigurăm că toți utilizatorii îndeplinesc aceleași cerințe, pentru a câștiga un ecuson. În mod curent, nu este posibilă revocarea unui ecuson. Dacă permitem modificarea cerințelor ecusoanelor în orice moment, cel mai probabil vom ajunge în situația în care utilizatorii câștigă același ecuson pentru îndeplinirea unor cerințe complet diferite.';
$string['statusmessage_0'] = 'Acest ecuson nu este în prezent disponibil pentru utilizatori. Activați accesul dacă doriți ca utilizatorii să câștige acest ecuson.';
$string['statusmessage_1'] = 'Acest ecuson este în prezent disponibil pentru utilizatori. Dezactivați accesul, dacă doriți să efectuați modificări.';
$string['statusmessage_2'] = 'Acest ecuson nu este în prezent disponibil pentru utilizatori, iar criteriile sale sunt blocate. Activați accesul dacă doriți ca utilizatorii să câștige acest ecuson.';
$string['statusmessage_3'] = 'Acest ecuson este în prezent disponibil pentru utilizatori, dar criteriile sale sunt blocate.';
$string['statusmessage_4'] = 'Acest ecuson este în prezent arhivat.';
$string['subject'] = 'Subiect mesaj';
$string['targetcode'] = 'Cod';
$string['targetcode_help'] = 'Un identificator unic de șir pentru referențierea abilității sau standardului extern în cadrul său.';
$string['targetdescription'] = 'Descriere';
$string['targetdescription_help'] = 'Scurtă descriere a abilității sau standardului extern.';
$string['targetframework'] = 'Cadru';
$string['targetframework_help'] = 'Numele abilității externe sau al cadrului standard.';
$string['targetname'] = 'Denumire';
$string['targetname_help'] = 'Abilitatea sau standardul extern cu care este aliniată insigna.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Un link către o pagină care descrie abilitatea sau standardul extern. Adresa URL trebuie să aibă un prefix http: // sau https: //.';
$string['testbackpack'] = 'Rucsac de testare „{$a}”';
$string['testsettings'] = 'Setări de testare';
$string['type'] = 'Tip';
$string['variablesubstitution'] = 'Substituirea variabilei în mesaje.';
$string['variablesubstitution_help'] = 'În mesajul unui ecuson, anumite variabile pot fi inserate în subiectul și/ sau conținutul unui mesaj, astfel încât acestea să fie înlocuite cu valori reale în momentul trimiterii mesajului. Variabilele trebuie inserate în text exact în modul arătat mai jos. Pot fi utilizate următoarele variabile:

%numeecuson%
: Aceasta va fi înlocuită cu numele complet al ecusonului.

%numeutilizator%
: Aceasta va fi înlocuită cu numele complet al destinatarului.

%linkecuson%
: Aceasta va fi înlocuită de adresa publică URL cu informații privind ecusonul emis.';
$string['version'] = 'Versiune';
$string['version_help'] = 'Câmpul versiune poate fi utilizat pentru a urmări evoluția insignei. Dacă este specificat, versiunea este afișată pe pagina insignei.';
$string['viewbadge'] = 'Vizualizare ecusoane emise';
$string['visible'] = 'Vizibil';
$string['warnexpired'] = '(Acest ecuson a expirat!)';
$string['year'] = 'An(i)';
