<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_urkund', language 'nl', version '4.1'.
 *
 * @package     plagiarism_urkund
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowallsupportedfiles'] = 'Sta alle ondersteunde bestandstypen toe';
$string['allowallsupportedfiles_help'] = 'De leraar kan hier aangeven welke bestandstypen naar Ouriginal worden verzonden om verwerkt te worden. Het voorkomt niet dat leerlingen andere bestandstypen kunnen uploaden naar de opdracht.';
$string['areyousurebulk'] = 'Weet je zeker dat je de {$a} geselecteerde bestanden wilt verwijderen?';
$string['areyousurefiltereddelete'] = 'Weet je zeker dat je de {$a} bestanden die overeenkomen met het huidige filter wilt verwijderen?';
$string['areyousurefilteredresubmit'] = 'Weet je zeker dat je de {$a} bestanden die overeenkomen met het huidige filter opnieuw wilt insturen?';
$string['assessmentresubmitted'] = 'Beoordeling opnieuw ingestuurd';
$string['assignforcedisclosureagreement'] = 'Instemmen met openbaring door Ouriginal forceren';
$string['assignforcedisclosureagreement_desc'] = 'Indien ingeschakeld, zal de gebruiker worden gedwongen aan te geven dat zij ermee instemmen dat hun inzending naar Ouriginal wordt gestuurd voordat zij deze kunnen uploaden.';
$string['assignforcesubmissionstatement'] = 'Verklaring bij inzenden opdracht forceren';
$string['assignforcesubmissionstatement_desc'] = 'Indien ingeschakeld, wordt de verklaring bij inzenden opdracht geforceerd ingeschakeld als Ouriginal in de Opdracht is ingeschakeld.<br />
<strong>LET OP: Als je dit aanvinkt, wordt deze instelling geforceerd in alle opdrachten in je leeromgeving waar Ouriginal is ingeschakeld.</strong>';
$string['assignpreventexistingenable'] = 'Inschakelen voorkomen wanneer er inzendingen zijn';
$string['assignpreventexistingenable_desc'] = 'Voorkomen dat niet-sitebeheerders Ouriginal kunnen inschakelen wanneer de Opdracht al inzendingen bevat.';
$string['assignsettings'] = 'Opdrachtinstellingen';
$string['attempts'] = 'Aantal gedane pogingen';
$string['cannotsubmitonbehalf'] = 'Leerlingen wordt in deze Opdracht verplicht in te stemmen met de inzendingsverklaring van Ouriginal voordat zij kunnen insturen, je kunt dit niet namens hen doen';
$string['cannotupgradeunprocesseddata'] = 'De huidige versie van de plugin kan niet worden geüpgraded vanwege nog niet verwerkte data. Keer terug naar een eerdere versie van deze plugin en schoon de oude events op.</h1><p>Deze versie van de plugin vertrouwt op de nieuwe event API in Moodle, maar uw installatie bevat niet-verwerkte events gerelateerd aan de oude API.</p>
 U dient terug te keren naar een oudere versie van de Ouriginal plugin, de site in onderhoudsmodus te zetten, de Moodle cron te laten draaien en er zeker van zijn dat alle oude events zijn opgeschoond. Probeer daarna opnieuw naar deze versie van de Ouriginal plugin te upgraden.</p>
 <p>Ga voor meer informatie naar: <a href="https://docs.moodle.org/en/Plagiarism_Prevention_URKUND_Settings#Installation_failed_due_to_unprocessed_data">Ouriginal Installatie mislukt vanwege niet verwerkte data</a></p>';
$string['charcount'] = 'Minimum aantal tekens';
$string['charcount_help'] = 'Hiermee stel je een minimum in op het aantal tekens dat vereist is voor online tekst (forumberichten en online tekstinzendingen in opdracht) voordat de inhoud naar Ouriginal zal worden verstuurd.';
$string['confirmresetall'] = 'Dit reset alle bestanden met de status: {$a}';
$string['courseshortname'] = 'Korte naam van de cursus';
$string['cronwarningscores'] = 'De onderhoudstaak van Ouriginal voor het ophalen van scores heeft ten minste 30 min niet gelopen - Cron moet zijn ingesteld voor een correcte werking van Ouriginal.';
$string['cronwarningsendfiles'] = 'De onderhoudstaak van Ouriginal voor het versturen van bestanden heeft ten minste 30 min niet gelopen - Cron moet zijn ingesteld voor een correcte werking van Ouriginal.';
$string['debugfilter'] = 'Bestanden filteren op';
$string['defaultsdesc'] = 'De volgende instellingen zijn standaard wanneer Ouriginal wordt aangezet binnen een Activiteitsmodule';
$string['defaultupdated'] = 'De standaardwaarden zijn geüpdatet';
$string['deleteallfiltered'] = 'Verwijder alle bestanden die overeenkomen met het huidige filter';
$string['deletedwarning'] = 'Dit bestand kon niet worden gevonden - mogelijk is het verwijderd door de gebruiker';
$string['deleteselectedfiles'] = 'Geselecteerde bestanden verwijderen';
$string['errorcode'] = 'Foutmelding';
$string['errorcode_101'] = 'Fout: Documentlimiet bereikt';
$string['errorcode_3'] = 'Fout: Document te kort';
$string['errorcode_4'] = 'Fout: Deadline verstreken';
$string['errorcode_403'] = 'Ontvangeradres voor je account ophalen mislukt: je zult er handmatig een moeten invoeren.';
$string['errorcode_409'] = 'Je ontvangeradres is verwijderd en moet worden hersteld. Neem contact op met Ouriginal om dit account te herstellen';
$string['errorcode_5000'] = 'Fout: Genereren rapport mislukt';
$string['errorcode_7001'] = 'Fout: Indexeren mislukt';
$string['errorcode_unknown'] = 'Fout: {$a}';
$string['errorcreate'] = 'Je moet handmatig een analyse-adres invoeren.';
$string['explainerrors'] = 'Deze pagina toont alle bestanden die op dit moment een foutstatus kennen. <br/>Op het moment dat de bestanden verwijderd worden op deze pagina, is het niet mogelijk deze opnieuw in te dienen en zullen fouten niet langer worden weergegeven aan leraren of leerlingen.';
$string['file'] = 'Bestand';
$string['filedeleted'] = 'Bestand verwijderd uit wachtrij';
$string['filereset'] = 'Een bestand is gereset om opnieuw ingediend te worden bij Ouriginal';
$string['fileresubmitted'] = 'Bestand is in wachtrij gezet voor herindiening';
$string['filesresubmitted'] = '{$a} bestanden opnieuw ingediend';
$string['filter30'] = 'Ouder dan 30 dagen uitsluiten';
$string['filter7'] = 'Ouder dan 7 dagen uitsluiten';
$string['filter90'] = 'Ouder dan 90 dagen uitsluiten';
$string['getallscores'] = 'Haal alle scores op';
$string['getscore'] = 'Haal score op';
$string['getscores'] = 'Haal scores op';
$string['heldevents'] = 'Vastgehouden events';
$string['heldeventsdescription'] = 'Dit zijn events die niet voltooid zijn bij de eerste poging en zijn daarom in de wachtrij geplaatst voor herindiening - deze events verhinderen daaropvolgende events te voltooien en dienen mogelijk nader onderzocht te worden. Een aantal van deze events zijn mogelijk niet relevant voor Ouriginal.';
$string['iagree'] = 'Ik ga akkoord';
$string['iagreetostatement'] = 'Ik ga ermee akkoord dat mijn inzending voor verwerking naar Ouriginal wordt gestuurd.';
$string['id'] = 'ID';
$string['identifier'] = 'Identifier';
$string['idisagree'] = 'Annuleren';
$string['module'] = 'Module';
$string['modulenotfound'] = 'Kon module voor {$a->module} met id {$a->modid} niet vinden.';
$string['name'] = 'Naam';
$string['nofilter'] = 'Geen filter';
$string['noreceiver'] = 'Er was geen ontvangstadres gespecificeerd';
$string['optout'] = 'Opt-out';
$string['pending'] = 'Dit bestand staat in de wachtrij om ingediend te worden bij Ouriginal';
$string['pluginname'] = 'Ouriginal plagiaatplugin';
$string['previouslysubmitted'] = 'Eerder ingediend als';
$string['privacy:metadata:core_files'] = 'Bestanden en tekst toegevoegd aan activiteitenmodules waar de Ouriginal plugin is ingeschakeld.';
$string['privacy:metadata:plagiarism_urkund_client'] = 'Naar externe Ouriginal API verstuurde gebruikersinformatie';
$string['privacy:metadata:plagiarism_urkund_client:email'] = 'E-mailadres van gebruiker';
$string['privacy:metadata:plagiarism_urkund_client:file'] = 'Fysieke kopie van tekst of bestandsinhoud verstuurd naar Ouriginal';
$string['privacy:metadata:plagiarism_urkund_client:filename'] = 'Naam van ingestuurd bestand.';
$string['privacy:metadata:plagiarism_urkund_files'] = 'Bewaart informatie over de ingestuurde bestanden.';
$string['privacy:metadata:plagiarism_urkund_files:lastmodified'] = 'Tijdstip wanneer het record voor het laatst werd bijgewerkt';
$string['privacy:metadata:plagiarism_urkund_files:similarityscore'] = 'Gelijkenisscore opgehaald van Ouriginal';
$string['privacy:metadata:plagiarism_urkund_files:userid'] = 'Het gebruikersid in Moodle';
$string['processing'] = 'Dit bestand is ingediend bij Ouriginal en wacht op analyserapport';
$string['receivernotvalid'] = 'Dit is geen geldig ontvangstadres.';
$string['recordsdeleted'] = '{$a} fouten zijn verwijderd';
$string['regenerationrequested'] = 'Alle rapporten zijn aangemerkt voor opnieuw genereren. Het kan enige tijd duren voordat de bijgewerkte rapporten beschikbaar zijn.';
$string['report'] = 'rapport';
$string['restrictcontent'] = 'Dien bijgevoegd bestand en in-line tekst in';
$string['restrictcontent_help'] = 'URKUND kan de geüploade bestanden verwerken, maar kan ook in-line tekst van forumberichten en tekst van online tekst opdrachten verwerken. U kunt kiezen welke componenten naar Ouriginal zullen worden verzonden.';
$string['restrictcontentfiles'] = 'Dien alleen bijgevoegde bestanden in';
$string['restrictcontentno'] = 'Dien alles in';
$string['restrictcontenttext'] = 'Dien alleen in-line tekst in';
$string['restrictfiles'] = 'Bestandstypes om in te dienen';
$string['resubmit'] = 'Dien opnieuw in';
$string['resubmitall'] = 'Dien alle bestanden met de volgende status in: {$a}';
$string['resubmitallfiltered'] = 'Alle bestanden die overeenkomen met het huidige filter opnieuw indienen';
$string['resubmitclose'] = 'Na afsluitdatum opnieuw indienen';
$string['resubmitdue'] = 'Na deadline opnieuw indienen';
$string['resubmittourkund'] = 'Alle Ouriginal rapporten opnieuw genereren';
$string['savedconfigfailed'] = 'Een incorrecte gebruikersnaam-/wachtwoordcombinatie is ingevuld, Ouriginal is uitgeschakeld, probeer opnieuw.';
$string['savedconfigsuccess'] = 'Plagiaatinstellingen opgeslagen';
$string['scoreavailable'] = 'Het bestand is verwerkt door Ouriginal en het rapport is nu beschikbaar.';
$string['scorenotavailableyet'] = 'Dit bestand is nog niet door Ouriginal verwerkt.';
$string['sendfiles'] = 'Verstuur bestanden uit wachtrij';
$string['showall'] = 'Toon alle fouten';
$string['showwhencutoff'] = 'Na einddatum activiteit';
$string['showwhendue'] = 'Na deadline activiteit';
$string['similarity'] = 'Ouriginal';
$string['status'] = 'Status';
$string['status_202'] = 'Ontvangen, wacht op rapport';
$string['status_404'] = 'Analyse-adres betstaat niet';
$string['status_413'] = 'Bestand te groot';
$string['status_415'] = 'Bestandsformaat niet ondersteund';
$string['status_444'] = 'Er is geen analyse-adres toegevoegd';
$string['status_pending'] = 'Wacht op verzending';
$string['storedocuments'] = 'Inzendingen toevoegen aan de database van Ouriginal';
$string['storedocuments_help'] = 'Indien ingesteld op Ja, zullen inzendingen worden toegevoegd aan de database van Ouriginal om toekomstige inzendingen mee te vergelijken. Indien ingesteld op Nee, zal het document bij Ouriginal worden verwijderd nadat de analyse is voltooid.';
$string['studentdisclosure'] = 'Verklaring voor leerlingen';
$string['studentdisclosure_help'] = 'Deze tekst zal aan alle leerlingen worden getoond op de bestand-upload-pagina.';
$string['studentdisclosuredefault'] = 'Alle geüploade bestanden worden opnieuw verwerkt door de plagiaatdetectieservice Ouriginal. Indien u wilt voorkomen dat uw document wordt gebruikt als een bron voor analyse buiten deze site door andere organisaties, kunt u de opt-out link gebruiken nadat het rapport is gegenereerd.';
$string['studentemailcontent'] = 'Het bestand dat u heeft ingediend voor {$a->modulename} in {$a->coursename} is nu verwerkt door Plagiaattool Ouriginal.
{$a->modulelink}

Indien u wilt voorkomen dat uw document wordt gebruikt als een bron voor analyse buiten deze site door andere organisaties, kunt u deze opt-out link gebruiken:
{$a->optoutlink}\'';
$string['studentemailcontentnoopt'] = 'Het bestand dat je hebt ingezonden naar {$a->modulename} in {$a->coursename} is nu verwerkt door Ouriginal plagiaatscontrole.
{$a->modulelink}';
$string['studentemailsubject'] = 'Bestand verwerkt door Ouriginal';
$string['submissionagreement'] = 'Instemming inzending';
$string['submitondraft'] = 'Dien bestand in wanneer deze voor het eerst wordt geüpload';
$string['submitonfinal'] = 'Dien bestand in wanneer de leerling het  instuurt voor beoordeling';
$string['timesubmitted'] = 'Tijd ingezonden';
$string['toolarge'] = 'Dit bestand is te groot om door Ouriginal verwerkt te worden';
$string['unknownwarning'] = 'Een is een fout opgetreden bij het proberen te verzenden van dit bestand naar Ouriginal';
$string['unknownwarninggetscore'] = 'Er is een fout opgetreden bij het ophalen van de score voor dit bestand van Ouriginal';
$string['unsupportedfiletype'] = 'Dit bestandstype wordt niet ondersteund door Ouriginal';
$string['updateallowedfiletypes'] = 'Update toegestane bestandstypen en verwijder Ouriginal records die geassocieerd zijn met verwijderde activiteiten.';
$string['urkund'] = 'Ouriginal plagiaatplugin';
$string['urkund:advancedsettings'] = 'Toestaan dat de leraar de geavanceerde module instellingen van Ouriginal kan bekijken';
$string['urkund:enable'] = 'Sta de leraar toe Ouriginal aan/uit te zetten binnen een activiteit';
$string['urkund:resetfile'] = 'Sta de leraar toe het bestand opnieuw in te dienen bij Ouriginal na een fout';
$string['urkund:resubmitallfiles'] = 'Sta de leraar toe ALLE bestanden opnieuw in te dienen bij Ouriginal';
$string['urkund:resubmitonclose'] = 'Sta de leraar toe bestanden opnieuw in te dienen bij Ouriginal op de afsluitdatum of deadline';
$string['urkund:viewreport'] = 'Sta de leraar toe een volledig rapport van Ouriginal te bekijken';
$string['urkund_advanceditems'] = 'Set instellingen om aan te merken als geavanceerd';
$string['urkund_advanceditems_help'] = 'De lijst van hier als geavanceerd aangemerkte instellingen zal als geavanceerd worden getoond in de module-instellingen. Als dat het geval is, worden ze verborgen voor leraren indien zij niet het recht \'urkund:advancedsettings\' hebben.';
$string['urkund_api'] = 'Ouriginal integratieadres';
$string['urkund_api_help'] = 'Dit is het adres van de Ouriginal API, standaard: https://secure.urkund.com';
$string['urkund_draft_submit'] = 'Wanneer dient het bestand ingediend te worden';
$string['urkund_enableoptout'] = 'Toon opt-out link';
$string['urkund_enableoptoutdesc'] = 'Dit uitzetten verwijdert de optie voor leerlingen om de inhoud van hun tekst te tonen of te verbergen (afhankelijk van de standaardinstelling) mocht die overeen komen met documenten van andere gebruikers (“opt-in” en “opt-out”). Door deze functie te deactiveren verklaart u dat u de verantwoordelijkheid neemt voor het beheren van het auteursrecht van de inzendingen van uw leerlingen en dat dit niet in strijd is met de wetten die van toepassing zijn in uw land.';
$string['urkund_enableplugin'] = 'Schakel Ouriginal in voor {$a}';
$string['urkund_hidefilename'] = 'Verberg naam ingestuurd bestand';
$string['urkund_hidefilenamedesc'] = 'Door dit in te schakelen wordt er een generieke bestandsnaam naar Ouriginal gestuurd, zodat leerlingen geen bestandsnamen van bronnen kunnen zien die overeenkomen met een bestaande inzending.';
$string['urkund_lang'] = 'Taal';
$string['urkund_lang_help'] = 'Taalcode aangeleverd door Ouriginal';
$string['urkund_password'] = 'Wachtwoord';
$string['urkund_password_help'] = 'Wachtwoord zoals aangeleverd door Ouriginal om toegang te krijgen tot de API';
$string['urkund_receiver'] = 'Adres van ontvanger';
$string['urkund_receiver_help'] = 'Dit is een uniek adres dat door Ouriginal is aangeleverd voor de leraar';
$string['urkund_resubmit_on_close'] = 'Opnieuw indienen bij afsluiten';
$string['urkund_resubmit_on_close_desc'] = 'Werk opnieuw indienen bij Ouriginal zodra instuurperiode is afgesloten.';
$string['urkund_resubmit_on_close_help'] = 'Deze instelling inschakelen zal ervoor zorgen dat inzendingen opnieuw naar Ouriginal worden verstuurd nadat de inzendingsperiode voor de opdracht is verstreken.';
$string['urkund_show_student_report'] = 'Toon gelijkenisrapport aan de leerling';
$string['urkund_show_student_report_help'] = 'Het gelijkenisrapport toont welke onderdelen van de inzending geplagieerd werden en de locatie waar Ouriginal deze inhoud het eerst tegenkwam';
$string['urkund_show_student_score'] = 'Toon gelijkenisscore aan de leerling';
$string['urkund_show_student_score_help'] = 'De gelijkenisscore is het percentage van de inzending dat overeenkomt met andere inhoud.';
$string['urkund_studentemail'] = 'Stuur leerling een e-mail';
$string['urkund_studentemail_help'] = 'Hiermee zal een e-mail naar de leerling worden gestuurd als het bestand is verwerkt, zodat hij weet dat er een rapport beschikbaar is. In deze e-mail staat ook de opt-out link.';
$string['urkund_unitid'] = 'Unit ID';
$string['urkund_unitid_help'] = 'Ouriginal kan automatisch ontvangeradressen aanmaken voor iedere gebruiker. Laat deze instelling leeg als je hetzelfde adres voor alle opdrachten wilt gebruiken, of neem contact op met Ouriginal voor het Unit ID als je deze functie wilt gebruiken.
Waarschuwing: het instellen van deze waarde zal de standaard ontvangeradressen op siteniveau leegmaken, omdat deze niet meer van toepassing zullen zijn.';
$string['urkund_username'] = 'Gebruikersnaam';
$string['urkund_username_help'] = 'Gebruikersnaam zoals aangeleverd door Ouriginal om toegang te krijgen tot de API';
$string['urkund_userpref'] = 'Gebruik laatst opgeslagen ontvanger';
$string['urkund_userprefdesc'] = 'Indien ingeschakeld, zal het laatste ontvangeradres dat door de gebruiker is ingevoerd worden bewaard als het standaard te gebruiken adres als de gebruiker een nieuwe opdracht maakt, Als dit niet is ingeschakeld, wordt altijd de standaardinstelling van de site gebruikt.';
$string['urkunddebug'] = 'Debugging';
$string['urkunddefaults'] = 'Ouriginal standaardwaarden';
$string['urkunddefaults_assign'] = 'Standaardinstellingen Opdracht';
$string['urkunddefaults_forum'] = 'Standaardinstellingen Forum';
$string['urkunddefaults_hsuforum'] = 'Standaardinstellingen voor HSU forum';
$string['urkunddefaults_quiz'] = 'Standaardinstellingen voor Test';
$string['urkunddefaults_workshop'] = 'Standaardinstellingen Workshop';
$string['urkundexplain'] = 'Voor meer informatie over deze plugin gaat u naar:: <a href="https://ouriginal.com/nl" target="_blank">https://ouriginal.com/nl/</a>';
$string['urkundfiles'] = 'Ouriginal Bestanden';
$string['useurkund'] = 'Ouriginal inschakelen';
$string['waitingevents'] = 'Er zijn {$a->countallevents} events die wachten op de cron en {$a->countheld} events worden vastgehouden voor herindiening';
