<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'nl', version '4.1'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Ik begrijp en aanvaard de gegevensverwerkingsovereenkomst';
$string['activityoverview'] = 'Je hebt aankomende bigbluebuttonbn-sessies';
$string['bbbduetimeoverstartingtime'] = 'De sluittijd voor deze activiteit moet later zijn dan de opentijd';
$string['bbbdurationwarning'] = 'De maximale lengte voor deze sessie is %duration% minuten.';
$string['bbbrecordallfromstartwarning'] = 'Deze sessie wordt vanaf het begin opgenomen.';
$string['bbbrecordwarning'] = 'Deze sessie kan opgenomen worden.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Voeg een nieuwe BigBlueButton ruimte toe';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Maak een live sessie';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Maak een sessie met opname';
$string['bigbluebuttonbn:deleterecordings'] = 'Opnames verwijderen';
$string['bigbluebuttonbn:importrecordings'] = 'Opnames importeren';
$string['bigbluebuttonbn:join'] = 'Neem deel aan een BigBlueButton sessie';
$string['bigbluebuttonbn:managerecordings'] = 'Beheeropnames';
$string['bigbluebuttonbn:protectrecordings'] = 'Opnames beveiligen';
$string['bigbluebuttonbn:publishrecordings'] = 'Opnames publiceren';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Beveilig opnames ongedaan maken';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Publicatie van opnames ongedaan maken';
$string['bigbluebuttonbn:view'] = 'Bekijk een BigBlueButton ruimte';
$string['bigbluebuttondisablednotification'] = 'De BigBlueButton activiteitsmodule is uitgeschakeld en all bestaande BigBlueButton cursusactiviteiten zijn momenteel niet beschikbaar. Voor je deze plugin opnieuw inschakelt moet je er voor zorgen dat je de <a href="{$a}" target="_blank">gegevensverwerkingsovereenkomst</a> met Blindside Networks Inc. gelezen en aanvaard hebt.';
$string['bigbluebuttondisablednotification_subject'] = 'BigBlueButton activiteitsmodule uitgeschakeld';
$string['cachedef_currentfetch'] = 'Gegevens om alle recent opgehaalde opnames weer te geven.';
$string['cachedef_recordings'] = 'Metagegevens opnemen';
$string['cachedef_serverinfo'] = 'Externe serverinformatie';
$string['cachedef_validatedurls'] = 'Cache van gevalideerde URL-controles';
$string['calendarstarts'] = '{$a} is gepland voor';
$string['cannotperformaction'] = 'Kan actie {$a} niet uitvoeren op deze opname';
$string['completionattendance'] = 'Leerling moet de bijeenkomst bijwonen voor:';
$string['completionattendance_desc'] = 'De ruimte binnengaan en ten minste {$a} minuut(en) blijven.';
$string['completionattendance_event_desc'] = 'Leerling is de ruimte binnengegaan en is minimaal {$a} minuut(en) in de sessie gebleven';
$string['completionattendancegroup'] = 'Aanwezigheid vereist';
$string['completionattendancegroup_help'] = 'Het bijwonen van de sessie gedurende (n) minuten is vereist voor voltooiing.';
$string['completionengagement_desc'] = 'Meedoen tijdens de sessie';
$string['completionengagementchats'] = 'Chats';
$string['completionengagementchats_desc'] = 'Deelnemen aan {$a} chat(s).';
$string['completionengagementchats_event_desc'] = 'Heeft {$a} chat(s) gemaakt';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Wijzig {$a} keer hun emoji(\'s)';
$string['completionengagementemojis_event_desc'] = 'Heeft {$a} hun emoji(s) gewijzigd';
$string['completionengagementgroup'] = 'Deelname vereisen';
$string['completionengagementgroup_help'] = 'Actieve deelname tijdens de sessie is vereist voor voltooiing.';
$string['completionengagementpollvotes'] = 'Poll stemmen';
$string['completionengagementpollvotes_desc'] = 'Leerling moet {$a} keer stemmen in polls';
$string['completionengagementpollvotes_event_desc'] = 'Heeft {$a} keer gestemd in een poll';
$string['completionengagementraisehand'] = 'Hand opsteken vereisen';
$string['completionengagementraisehand_desc'] = 'Hand {$a} keer opsteken';
$string['completionengagementraisehand_event_desc'] = 'Heeft {$a} keer zijn hand opgestoken';
$string['completionengagementtalks'] = 'Spreken';
$string['completionengagementtalks_desc'] = 'Praat {$a} keer';
$string['completionengagementtalks_event_desc'] = 'Heeft {$a} keer gesproken';
$string['completionupdatestate'] = 'Status voltooiing update';
$string['completionvalidatestate'] = 'Bevestig voltooiing';
$string['completionvalidatestatetriggered'] = 'Valideren dat de voltooiing is geactiveerd.';
$string['completionview'] = 'Bekijken vereisen';
$string['completionview_desc'] = 'Leerling moet de ruimte bekijken om te voltooien.';
$string['completionview_event_desc'] = 'Heeft de ruimte bekeken.';
$string['config_default_messages'] = 'Standaardberichten';
$string['config_default_messages_description'] = 'Stel standaardberichten in voor activiteiten';
$string['config_disablecam_default'] = 'Uitschakelen camera standaard ingeschakeld';
$string['config_disablecam_default_description'] = 'Indien ingeschakeld, worden de webcams uitgeschakeld.';
$string['config_disablecam_editable'] = 'Camera uitschakelen kan worden bewerkt';
$string['config_disablecam_editable_description'] = 'Camera standaard uitschakelen kan worden gewijzigd wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_disablemic_default'] = 'Schakel microfoon standaard uit';
$string['config_disablemic_default_description'] = 'Indien ingeschakeld, worden de microfoons uitgeschakeld.';
$string['config_disablemic_editable'] = 'Microfoon uitschakelen kan worden gewijzigd';
$string['config_disablemic_editable_description'] = 'Microfoon standaard uitschakelen kan worden gewijzigd wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_disablenote_default'] = 'Schakel gedeelde notities standaard uit';
$string['config_disablenote_default_description'] = 'Indien ingeschakeld, worden de gedeelde notities uitgeschakeld.';
$string['config_disablenote_editable'] = 'Gedeelde notities uitschakelen kunnen worden bewerkt';
$string['config_disablenote_editable_description'] = 'Gedeelde notities standaard uitschakelen kan worden bewerkt wanneer het exemplaar wordt toegevoegd of bijgewerkt.';
$string['config_disableprivatechat_default'] = 'Schakel privéchat standaard uit';
$string['config_disableprivatechat_default_description'] = 'Indien ingeschakeld, wordt de privéchat uitgeschakeld.';
$string['config_disableprivatechat_editable'] = 'Schakel privéchat uit kan worden bewerkt';
$string['config_disableprivatechat_editable_description'] = 'Standaard uitschakelen van privéchat kan worden bewerkt wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_disablepublicchat_default'] = 'Schakel openbare chat standaard uit';
$string['config_disablepublicchat_default_description'] = 'Indien ingeschakeld, wordt de openbare chat uitgeschakeld.';
$string['config_disablepublicchat_editable'] = 'Schakel openbare chat uit kan worden bewerkt';
$string['config_disablepublicchat_editable_description'] = 'Het standaard uitschakelen van openbare chat kan worden bewerkt wanneer het exemplaar wordt toegevoegd of bijgewerkt.';
$string['config_dpa_note'] = 'Opmerking: om te voldoen aan je gegevensbeschermingsverplichtingen moet je voor je een service-provider voor deze plugin gebruikt, de gegevensverwerkingsovereenkomst van deze gegevensverwerker gelezen en aanvaard hebben.
Voor de standaard gratis BigBlueButton-service is dit  de <a href="{$a}" target="_blank">Blindside Networks gegevensverwerkingsovereenkomst</a>.
Consulteer je eigen privacy-adviseur voor advies.';
$string['config_experimental_features'] = 'Experimentele functies';
$string['config_experimental_features_description'] = 'Configuratie voor experimentele functies.';
$string['config_extended_capabilities'] = 'Uitgebreide mogelijkheden';
$string['config_extended_capabilities_description'] = 'Configuratie voor uitgebreide mogelijkheden wanneer de BigBlueButton server deze aanbiedt.';
$string['config_general'] = 'Algemene instellingen';
$string['config_general_description'] = 'Deze instellingen worden <strong>altijd</strong> gebruikt';
$string['config_guestaccess_enabled'] = 'Toegang externe gast';
$string['config_guestaccess_enabled_description'] = 'Gebruikers zonder account voor je site toegang verlenen in de ruimte.';
$string['config_hideuserlist_default'] = 'Gebruikerslijst verbergen standaard ingeschakeld';
$string['config_hideuserlist_default_description'] = 'Indien ingeschakeld, wordt de gebruikerslijst van de sessie verborgen.';
$string['config_hideuserlist_editable'] = 'De gebruikerslijst verbergen kan worden bewerkt';
$string['config_hideuserlist_editable_description'] = 'De standaard gebruikerslijst verbergen kan worden bewerkt wanneer het exemplaar wordt toegevoegd of bijgewerkt.';
$string['config_importrecordings'] = 'Opnames importeren';
$string['config_importrecordings_description'] = 'Deze instellingen zijn specifiek per functie.';
$string['config_importrecordings_enabled'] = 'Opnamen importeren ingeschakeld';
$string['config_importrecordings_enabled_description'] = 'Wanneer dit en de opnamefunctie zijn ingeschakeld, is het mogelijk om opnames van verschillende cursussen in een activiteit te importeren.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importeer opnames van verwijderde activiteiten ingeschakeld';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Wanneer dit en de functie voor het importeren van opnames zijn ingeschakeld, is het mogelijk om opnames te importeren van activiteiten die niet langer in de cursus zijn.';
$string['config_locksettings'] = 'Configuratie voor vergrendelingsinstellingen';
$string['config_locksettings_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface voor vergrendelingsinstellingen in of uit, en definiëren ook standaardwaarden voor deze opties.';
$string['config_meetingevents_enabled'] = 'Live sessies registreren';
$string['config_meetingevents_enabled_description'] = 'Indien ingeschakeld, worden live bijeenkomsten verwerkt nadat de sessie is geëindigd. Deze functie is vereist voor Activiteitsvoltooiing en werkt alleen als de BigBlueButton server post_events scripts kan verwerken.';
$string['config_muteonstart'] = 'Microfoon stil bij aanvang';
$string['config_muteonstart_default'] = 'Standaard microfoon stil bij aanvang';
$string['config_muteonstart_default_description'] = 'Indien ingeschakeld, wordt de microfoon stil gezet bij de aanvang van een sessie.';
$string['config_muteonstart_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties.';
$string['config_muteonstart_editable'] = 'Microfoon stil bij aanvang kanaangepast worden';
$string['config_muteonstart_editable_description'] = 'Microfoon stil bij aanvang kan standaard aangepast worden wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_participant'] = 'Deelnemers';
$string['config_participant_description'] = 'Deze instellingen definiëren de standaard rol voor deelnemers..';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_participant_moderator_default_description'] = 'Deze regel wordt standaard gebruikt wanneer een nieuwe ruimte wordt toegevoegd.';
$string['config_poll_interval'] = 'Interval (in seconden) om de status van de ruimte te verversen';
$string['config_poll_interval_description'] = 'Het Interval om de status van de ruimte te verversen moet minstens 2 seconden zijn. Indien nodig kun je de belasting op de externe server verlagen door deze waarde te verhogen.';
$string['config_presentation_default'] = 'Standaard presentatiebestand';
$string['config_presentation_default_description'] = 'Een bestand dat in alle ruimtes gebruikt kan worden.';
$string['config_preuploadpresentation'] = 'Prestentatie vooraf uploaden';
$string['config_preuploadpresentation_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties. De functie werkt alleen als de Moodle-server toegankelijk is voor BigBlueButton ..';
$string['config_preuploadpresentation_editable'] = 'Vooraf uploaden van een presentatie kan aangepast worden';
$string['config_preuploadpresentation_editable_description'] = 'Het vooraf uploaden van de presentatie kan aangepast worden in de gebruikersinterface wanneer de ruimte wordt toegevoegd of aangepast.';
$string['config_recording'] = 'Opname';
$string['config_recording_all_from_start_default'] = 'Opname starten vanaf het begin';
$string['config_recording_all_from_start_default_description'] = 'Moet de instelling \'Opname starten vanaf het begin\' standaard ingeschakeld worden wanneer er een nieuwe BigBlueButton-ruimte gemaakt wordt?';
$string['config_recording_all_from_start_editable'] = 'Opname starten vanaf het begin kan worden bewerkt';
$string['config_recording_all_from_start_editable_description'] = 'Moet de instelling \'Opname starten vanaf het begin\' kunnen bewerkt worden in de BigBlueButton activiteits-instellingen?';
$string['config_recording_default'] = 'Opnamefunctie standaard ingeschakeld';
$string['config_recording_default_description'] = 'Moet de instelling \'Sessie kan opgenomen worden\' standaard ingeschakeld worden wanneer er een nieuwe BigBlueButton-ruimte toegevoegd wordt?';
$string['config_recording_description'] = 'Deze instellingen zijn kenmerkspecifiek';
$string['config_recording_editable'] = 'Sessie kan opgenomen worden kan bewerkt worden';
$string['config_recording_editable_description'] = 'Moet \'Sessie kan opgenomen worden\' bewerkt kunnen worden in de BigBlueButton activiteitsinstellingen?';
$string['config_recording_hide_button_default'] = 'Opnameknop verbergen';
$string['config_recording_hide_button_default_description'] = 'Indien aangevinkt zal de knop voor opname verborgen zijn';
$string['config_recording_hide_button_editable'] = 'Verberg opnameknop kan worden bewerkt';
$string['config_recording_hide_button_editable_description'] = 'Moet \'Verberg opnameknop\' bewerkbaar zijn in de BigBlueButton activiteitsinstellingen?';
$string['config_recording_protect_editable'] = 'De beschermstatus van opnames kan aangepast worden';
$string['config_recording_protect_editable_description'] = 'Indien ingeschakeld zal de interface een optie hebben om de opnames te beschermen.';
$string['config_recording_refresh_period'] = 'Opnameverversingsperiode (in seconden)';
$string['config_recording_refresh_period_description'] = 'Hoe vaak moet de BigBlueButton-server bevraagd worden om externe informatie over een opname te bekomen?';
$string['config_recordingready_enabled'] = 'Melding wanneer de opname klaar is ingeschakeld';
$string['config_recordingready_enabled_description'] = 'Indien ingeschakeld zal er een melding gestuurd worden wanneer de opname-iink beschikbaar is. Deze functie vereist dat post_publish_recording_ready_callback is ingeschakeld op de BigBlueButton-server';
$string['config_recordings'] = 'Toon opnames';
$string['config_recordings_asc_sort'] = 'Sorteer de opnames in chronologische volgorde';
$string['config_recordings_asc_sort_description'] = 'Opnames worden gerangschikt op datum, ofwel chronologisch of omgekeerd chronologisch (meest recente opname eerst).';
$string['config_recordings_deleted_default'] = 'Neem opnamen op van verwijderde activiteiten standaard ingeschakeld';
$string['config_recordings_deleted_default_description'] = 'Indien ingeschakeld, bevat de opnametabel de opnames die behoren tot activiteiten die verwijderd zijn.';
$string['config_recordings_deleted_editable'] = 'Functionaliteit "Neem opnamen op van verwijderde activiteiten" kan bewerkt worden';
$string['config_recordings_deleted_editable_description'] = 'Functionaliteit "Neem opnamen op van verwijderde activiteiten"  kan standaard worden bewerkt wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_recordings_description'] = 'Deze instellingen zijn kenmerkspecifiek';
$string['config_recordings_general'] = 'Opname-instellingen weergeven';
$string['config_recordings_general_description'] = 'Deze instellingen worden alleen gebruikt bij het weergeven van opnames';
$string['config_recordings_imported_default'] = 'Toon alleen geïmporteerde links die standaard zijn ingeschakeld';
$string['config_recordings_imported_default_description'] = 'Indien ingeschakeld, bevat de opnametabel alleen de geïmporteerde links naar opnames.';
$string['config_recordings_imported_editable'] = 'Alleen de functie voor geïmporteerde links weergeven kan worden bewerkt';
$string['config_recordings_imported_editable_description'] = 'Alleen standaard geïmporteerde links weergeven kan worden bewerkt wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_recordings_preview_default'] = 'Voorbeeldweergave is standaard ingeschakeld';
$string['config_recordings_preview_default_description'] = 'Indien ingeschakeld, bevat de tabel een voorbeeldweergave van de presentatie.';
$string['config_recordings_preview_editable'] = 'Voorbeeldweergave kan aangepast worden';
$string['config_recordings_preview_editable_description'] = 'De voorbeeldweergave kan aangepast worden wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_scheduled'] = 'Geplande sessies';
$string['config_scheduled_description'] = 'Deze instellingen bepalen het standaardgedrag voor geplande sessies.';
$string['config_scheduled_pre_opening'] = 'Toegang mogelijk voor het startmoment';
$string['config_scheduled_pre_opening_description'] = 'De tijd in minuten dat de sessie toegankelijk is voor het geplande startmoment.';
$string['config_server_url'] = 'BigBlueButton Server URL';
$string['config_server_url_description'] = 'De standaard toegangsrechten zijn voor een <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton service voor Moodle (opent in een nieuw venster)</a> geleverd door Blindside Networks met volgende beperkingen:
<ol>
<li>De maximale lengte voor elke sessie is 60 minuten</li>
<li>Het maximale aantal gelijktijdige gebruikers per sessie is 25</li>
<li>Opnames verlopen na zeven (7) dagen en kunnen niet gedownload worden</li>
<li>Webcams van de leerlingen zijn enkel zichtbaar voor de moderator.</li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton geheime sleutel';
$string['config_shared_secret_description'] = 'De geheime sleutel van je BigBlueButton server. De standaard geheime sleutel is voor een BigBlueButton-service, geleverd door Blindside Networks.';
$string['config_uidelegation_enabled'] = 'UI-delegatie is ingeschakeld';
$string['config_uidelegation_enabled_description'] = 'Deze instellingen schakelen de delegatie van de gebruikersinterface naar de BigBlueButton-server in of uit.';
$string['config_userlimit'] = 'Gebruikerslimiet';
$string['config_userlimit_default'] = 'Gebruikerslimiet standaard ingeschakeld';
$string['config_userlimit_default_description'] = 'Het aantal gebruikers dat standaard is toegestaan in een sessie wanneer een nieuwe ruimte  wordt toegevoegd. Als het aantal op 0 is ingesteld, dan is het aantal gebruikers onbeperkt.';
$string['config_userlimit_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties.';
$string['config_userlimit_editable'] = 'Gebruikerslimietfunctie kan worden bewerkt';
$string['config_userlimit_editable_description'] = 'De gebruikerslimietwaarde kan standaard worden bewerkt wanneer de ruimte of conferentie wordt toegevoegd of bijgewerkt.';
$string['config_voicebridge'] = 'Voice bridge';
$string['config_voicebridge_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties.';
$string['config_voicebridge_editable'] = 'Conference voice bridge kan worden bewerkt';
$string['config_voicebridge_editable_description'] = 'Er kan een permanent voice bridge nummer worden toegewezen aan een ruimte. Indien toegewezen, kan het nummer niet worden gebruikt door een andere ruimte.';
$string['config_waitformoderator'] = 'Wacht op moderator';
$string['config_waitformoderator_cache_ttl'] = 'Wacht op moderator cache TTL (seconden)';
$string['config_waitformoderator_cache_ttl_description'] = 'Om een grote hoeveelheid gebruikers te ondersteunen, maakt deze plug-in gebruik van een cache. Deze parameter definieert de tijd dat de cache wordt bewaard voordat het volgende verzoek naar de BigBlueButton-server wordt verzonden.';
$string['config_waitformoderator_default'] = 'Wacht tot moderator standaard is ingeschakeld';
$string['config_waitformoderator_default_description'] = 'Moet de instelling \'Wachten op moderator\' standaard ingeschakeld zijn als een nieuwe BigBlueButton ruimte wordt toegevoegd?';
$string['config_waitformoderator_description'] = 'Deze instellingen zijn kenmerkspecifiek';
$string['config_waitformoderator_editable'] = 'Functie Wachten op moderator kan worden bewerkt';
$string['config_waitformoderator_editable_description'] = 'Moet \'Wacht op moderator\'-instelling kunnen bewerkt worden in de BigBlueButton activiteitsinstellingen?';
$string['config_waitformoderator_ping_interval'] = 'Wacht op moderator-ping (seconden)';
$string['config_waitformoderator_ping_interval_description'] = 'Hoe vaak moet de server bevraagd worden om te controleren of de moderator de ruimte is binnengekomen?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton maakt gebruik van config.php met een globale variabele die is afgeschaft. Converteer het bestand want het zal niet meer worden ondersteund in toekomstige versies.';
$string['config_warning_curl_not_installed'] = 'Deze functie vereist dat de CURL extensie voor php is geïnstalleerd en ingeschakeld. Deze instellingen zullen alleen toegankelijk zijn als is voldaan aan deze voorwaarde.';
$string['config_welcome_default'] = 'Standaard welkomstbericht';
$string['config_welcome_default_description'] = 'Het welkomstbericht wordt getoond wanneer deelnemers de ruimte betreden. Als het veld leeg gelaten wordt, dan wordt het bericht getoond dat op de BigBlueButton-server is ingesteld.';
$string['config_welcome_editable'] = 'Standaard welkomstbericht is bewerkbaar door leraren';
$string['config_welcome_editable_description'] = 'Welkomstbericht kan bewerkt worden wanneer de ruimte wordt toegevoegd of bewerkt';
$string['dpainfonotsigned'] = 'Voordat je deze plug-in inschakelt, moet je bevestigen dat je de <a href="{$a}">Blindside Networks-gegevensverwerkingsovereenkomst</a> hebt gelezen en geaccepteerd.';
$string['enablingbigbluebutton'] = 'BigBlueButton-activiteit inschakelen';
$string['enablingbigbluebuttondpainfo'] = 'Om te voldoen aan je gegevensbeschermingsverplichtingen moet je voor je deze plugin gebruikt, de <a href="{$a}" target="_blank">Blindside Networds gegevensverwerkingsovereenkomst</a>  gelezen en aanvaard hebben.
Consulteer je eigen privacy-adviseur voor advies.';
$string['end_session_confirm'] = 'Weet je zeker dat je de sessie wil beëindigen?';
$string['end_session_confirm_title'] = 'Sessie echt beëindigen?';
$string['end_session_notification'] = 'De sessie is beëindigd.';
$string['ends_at'] = 'Eindigt';
$string['event_activity_created'] = 'Activiteit gemaakt';
$string['event_activity_deleted'] = 'Activiteit verwijderd';
$string['event_activity_updated'] = 'Activiteit bijgewerkt';
$string['event_live_session'] = 'Live sessie-evenement';
$string['event_meeting_created'] = 'BigBlueButtonBN bijeenkomst aangemaakt';
$string['event_meeting_ended'] = 'BigBlueButton bijeenkomst gedwongen beëindigd';
$string['event_meeting_joined'] = 'bBigBlueButtonBN bijeenkomst bijgewoond';
$string['event_meeting_left'] = 'BigBlueButtonBN bijeenkomst verlaten';
$string['event_recording_deleted'] = 'Opname verwijderd';
$string['event_recording_edited'] = 'Opname bewerkt';
$string['event_recording_imported'] = 'Opname geïmporteerd';
$string['event_recording_protected'] = 'Opname beveiligd';
$string['event_recording_published'] = 'Opname gepubliceerd';
$string['event_recording_unprotected'] = 'Onbeschermd opnemen';
$string['event_recording_unpublished'] = 'Publicatie van opname ongedaan gemaakt';
$string['event_recording_viewed'] = 'Opname bekeken';
$string['event_unknown'] = 'Onbekende gebeurtenis';
$string['general_error_cannot_create_meeting'] = 'Kan geen sessie maken.';
$string['general_error_cannot_get_recordings'] = 'Kan geen opnames ophalen.';
$string['general_error_no_answer'] = 'Lege reactie. Controleer de url van de BigBlueButton-server EN controleer of de BigBlueButton-server actief is.';
$string['general_error_not_allowed_to_create_instances'] = 'De gebruiker mag geen enkel type instantie maken.';
$string['general_error_not_found'] = 'Kan BigBlueButtonactiviteit met ID {$a} niet vinden.';
$string['general_error_unable_connect'] = 'Kon geen verbinding maken. Controleer de url van de BigBlueButton server EN  controleer of de BigBlueButton server aan staat.
Details: {$a}';
$string['guest_invitation_full_message'] = 'Beste,
<p>Je bent uitgenodigd voor een BigBlueButton-sessie <strong>{$a->name}</strong> in de cursus {$a->course_fullname}.</p>
<p>Link: {$a->guestjoinurl}<br/>
<p>Wachtwoord: {$a->guestpassword}</p>
<p>Als je hulp nodig hebt, neem dan contact op met {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Beste,,

Je bent uitgenodigd voor een BigBlueButton-sessie {$a->name} in de cursus {$a->course_fullname}.

Link: {$a->guestjoinurl}
Wachtwoord: {$a->guestpassword}

Als je hulp nodig hebt, neem dan contact op met {$a->sender}.';
$string['guest_invitation_subject'] = 'Uitnodiging: {$a->name} sessie in {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Activiteit niet gevonden';
$string['guestaccess_add'] = 'Gasten toevoegen';
$string['guestaccess_add_no_id'] = 'Geen ID van de BigBlueButton instantie ingegeven.';
$string['guestaccess_copy_link'] = 'Kopieer link';
$string['guestaccess_copy_password'] = 'Wachtwoord kopiëren';
$string['guestaccess_emails'] = 'E-mailadressen gasten';
$string['guestaccess_emails_help'] = 'Een lijst van e-mailadressen, door komma\'s gescheiden';
$string['guestaccess_emails_invalidemail'] = 'Ongeldig e-mailadres: {$a}';
$string['guestaccess_feature_disabled'] = 'Gasttoegang uitgeschakeld';
$string['guestaccess_invite_failure'] = 'Fout {$a->errors} bij uitnodigen {$a->emails}';
$string['guestaccess_invite_success'] = 'Er wordt een uitnodiging gestuurd naar {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Deelnemen aan bijeenkomst';
$string['guestaccess_meeting_invalid_password'] = 'Wachtwoord onjuist.';
$string['guestaccess_meeting_link'] = 'Bijeenkomstlink';
$string['guestaccess_meeting_not_started'] = 'De bijeenkomst is nog niet begonnen. Probeer het later nogmaals.';
$string['guestaccess_meeting_password'] = 'Wachtwoord bijeenkomst';
$string['guestaccess_password'] = 'Wachtwoord';
$string['guestaccess_title'] = 'Gasten aan deze bijeenkomst toevoegen';
$string['guestaccess_username'] = 'Gebruikersnaam gast';
$string['index_confirm_end'] = 'Wil je de sessie beëindigen?';
$string['index_disabled'] = 'uitgeschakeld';
$string['index_enabled'] = 'ingeschakeld';
$string['index_ending'] = 'Sessie beëindigen ... wachten';
$string['index_error_bbtn'] = 'BigBlueButton-ID {$a} is onjuist';
$string['index_error_checksum'] = 'Er is een checksum-fout opgetreden. Zorg ervoor dat je het juiste geheim hebt ingevoerd.';
$string['index_error_forciblyended'] = 'Kon niet deelnemen aan deze sessie omdat deze handmatig is beëindigd.';
$string['index_error_noinstances'] = 'Er zijn geen bigbluebutton-ruimte';
$string['index_error_unable_display'] = 'Kon geen sessie tonen. Controleer de URL van de BigBlueButton server EN  controleer of de BigBlueButton server aan staat.';
$string['index_heading'] = 'BigBlueButton ruimtes';
$string['index_heading_actions'] = 'Acties';
$string['index_heading_group'] = 'Groep';
$string['index_heading_moderator'] = 'Moderators';
$string['index_heading_name'] = 'Ruimte';
$string['index_heading_recording'] = 'Opname';
$string['index_heading_users'] = 'Gebruikers';
$string['index_heading_viewer'] = 'Kijkers';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN cognitief';
$string['indicator:cognitivedepth_help'] = 'Deze indicator is gebaseerd op de cognitieve diepte die de student bereikt bij een BigBlueButtonBN-activiteit.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN sociaal';
$string['indicator:socialbreadth_help'] = 'Deze indicator is gebaseerd op de sociale breedte die de student bereikt bij een BigBlueButtonBN-activiteit.';
$string['instance_type_default'] = 'Ruimte met opnames';
$string['instance_type_recording_only'] = 'Alleen opnames';
$string['instance_type_room_only'] = 'Enkel ruimte';
$string['instanceprofilewithoutrecordings'] = 'Dit instantieprofiel kan geen opnamen weergeven';
$string['messageprovider:instance_updated'] = 'BigBlueButton-sessie bijgewerkt';
$string['messageprovider:recording_ready'] = 'BigBlueButton-opname beschikbaar';
$string['minute'] = 'minuut';
$string['minutes'] = 'minuten';
$string['mod_form_block_general'] = 'Algemeen';
$string['mod_form_block_guestaccess'] = 'Gasttoegang';
$string['mod_form_block_participants'] = 'Toegewezen rol gedurende live sessie';
$string['mod_form_block_presentation'] = 'Inhoud van presentatie';
$string['mod_form_block_presentation_default'] = 'Standaard inhoud van presentatie';
$string['mod_form_block_record'] = 'Opname-instellingen';
$string['mod_form_block_recordings'] = 'Opname bekijken';
$string['mod_form_block_room'] = 'Ruimte-instellingen';
$string['mod_form_block_schedule'] = 'Planning voor sessie';
$string['mod_form_field_closingtime'] = 'Sluit';
$string['mod_form_field_conference_name'] = 'Sessie-naam';
$string['mod_form_field_disablecam'] = 'Schakel webcams uit';
$string['mod_form_field_disablemic'] = 'Schakel microfoons uit';
$string['mod_form_field_disablenote'] = 'Schakel gedeelde notities uit';
$string['mod_form_field_disableprivatechat'] = 'Schakel privéchat uit';
$string['mod_form_field_disablepublicchat'] = 'Schakel openbare chat uit';
$string['mod_form_field_duration'] = 'Duur';
$string['mod_form_field_duration_help'] = 'Het instellen van de duur van een bijeenkomst stelt de maximale tijd vast dat een bijeenkomst open blijft alvorens de opname stopt';
$string['mod_form_field_guestallowed'] = 'Gasttoegang toestaan';
$string['mod_form_field_hideuserlist'] = 'Gebruikerslijst verbergen';
$string['mod_form_field_instanceprofiles'] = 'Instantietype';
$string['mod_form_field_instanceprofiles_help'] = 'Als een sessie opgenomen moet worden, kies dan voor \'Ruimte met opnames\', anders \'Enkel ruimte\'. Nadat een sessie is opgenomen en er geen sessies meer volgen, kies dan voor \'Alleen opnames\'.';
$string['mod_form_field_intro'] = 'Beschrijving';
$string['mod_form_field_intro_help'] = 'Een korte beschrijving voor de ruimte.';
$string['mod_form_field_mustapproveuser'] = 'Gasten die deelnemen, moeten worden toegelaten door een moderator';
$string['mod_form_field_muteonstart'] = 'Microfoon stil bij aanvang';
$string['mod_form_field_name'] = 'Naam ruimte';
$string['mod_form_field_nosettings'] = 'Er kunnen geen instellingen worden bewerkt';
$string['mod_form_field_openingtime'] = 'Open';
$string['mod_form_field_participant_add'] = 'Deelnemer toevoegen';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Toeschouwer';
$string['mod_form_field_participant_list'] = 'Deelnemer';
$string['mod_form_field_participant_list_action_add'] = 'Toevoegen';
$string['mod_form_field_participant_list_action_remove'] = 'Verwijderen';
$string['mod_form_field_participant_list_text_as'] = 'Sessie volgen als';
$string['mod_form_field_participant_list_type_all'] = 'Alle aangemelde gebruikers';
$string['mod_form_field_participant_list_type_owner'] = 'Eigenaar';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Gebruiker';
$string['mod_form_field_record'] = 'Sessie kan worden opgenomen.';
$string['mod_form_field_recordallfromstart'] = 'Neem alles vanaf het begin op';
$string['mod_form_field_recordhidebutton'] = 'Opnameknop verbergen';
$string['mod_form_field_recordings_deleted'] = 'Neem opnamen op van verwijderde activiteiten';
$string['mod_form_field_recordings_html'] = 'Toon de tabel in gewone HTML';
$string['mod_form_field_recordings_imported'] = 'Toon alleen geïmporteerde links';
$string['mod_form_field_recordings_preview'] = 'Toon voorbeeldweergave van opname';
$string['mod_form_field_room_name'] = 'Naam van de ruimte';
$string['mod_form_field_userlimit'] = 'Gebruikerslimiet';
$string['mod_form_field_userlimit_help'] = 'Maximaal aantal toegestane gebruikers in een sessie. Indien ingesteld op 0 is het aantal gebruikers onbeperkt.';
$string['mod_form_field_voicebridge'] = 'Voice bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Format fout. Een getal tussen 1 en 9999 wordt verwacht.';
$string['mod_form_field_voicebridge_help'] = 'Een getal tussen 1 en 9999 dat moet worden ingevoerd door deelnemers als ze via inbellen willen deelnemen. Als de waarde 0 is, wordt het statische voice bridge getal genegeerd en zal er een willekeurig getal worden gegenereerd door BigBlueButton. Het cijfer 7 zal voor de vier ingevoerde cijfers verschijnen.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Geen unieke waarde. Dit getal wordt door een andere ruimte gebruikt.';
$string['mod_form_field_wait'] = 'Wachten op moderator';
$string['mod_form_field_wait_help'] = 'Moeten gebruikers wachten op een moderator voor ze de ruimte binnen kunnen?';
$string['mod_form_field_welcome'] = 'Welkomstbericht';
$string['mod_form_field_welcome_default'] = 'Welkom bij %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Het welkomstbericht wordt getoond wanneer deelnemers de ruimte binnenkomen. Als dit veld leeg gelaten wordt, dan wordt een standaardbericht dat door de site-beheerder is ingesteld, getoond.';
$string['mod_form_locksettings'] = 'Vergrendelinstellingen';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton is een vrije software web conferentie-systeem, ontworpen voor online leren. Het systeem ondersteunt het delen van audio, video, chat, presentaties, schermen, een whiteboard voor meerder gebruikers, brainstormruimtes, stemmen en emojis.

Met BigBlueButton kun je een ruimte maken voor sessies zoals live online lessen, virtuele kantoor-uren of groepswerk met leerlingen op een externe locatie. De sessie kan opgenomen worden om later te vertonen.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton-activiteit';
$string['nosuchinstance'] = 'Geen dergelijke instantie {$a->entity} met ID {$a->id}';
$string['notification_instance_created_intro'] = 'De <a href="{$a->link}">{$a->name}</a> BigBlueButton-ruimte is gemaakt.';
$string['notification_instance_created_small'] = 'Er is een nieuwe BigBlueButton-ruimte met de naam {$a->name} gemaakt.';
$string['notification_instance_created_subject'] = 'Er is een nieuwe BigBlueButton-ruimte gemaakt';
$string['notification_instance_description'] = 'Beschrijving';
$string['notification_instance_end_date'] = 'Einddatum';
$string['notification_instance_name'] = 'Titel';
$string['notification_instance_start_date'] = 'Start date';
$string['notification_instance_updated_intro'] = 'De <a href="{$a->link}">{$a->name}</a> BigBlueButton-ruimte is bijgewerkt.';
$string['notification_instance_updated_small'] = 'De {$a->name} BigBlueButton-sessie is bijgewerkt';
$string['notification_instance_updated_subject'] = 'Je BigBlueButton-ruimte is bijgewerkt';
$string['notification_recording_ready_html'] = 'Er is nu een opname beschikbaar voor de sessie in de BigBlueButton-ruimte <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'Er is nu een opname beschikbaar voor de sessie in de BigBlueButton-ruimte {$a->name}. Ga naar {$a->link} voor de link naar de opname.';
$string['notification_recording_ready_small'] = 'Er is een nieuwe opname beschikbaar voor de {$a->name} BigBlueButton-ruimte';
$string['notification_recording_ready_subject'] = 'Opname beschikbaar';
$string['pluginadministration'] = 'BigBlueButton beheer';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Om BigBlueButton-sessies te creëren en eraan deel te nemen, moeten gebruikersgegevens worden uitgewisseld met de server.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'De volledige naam van de gebruiker die toegang heeft tot de BigBlueButton-server.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Het gebruikers-ID van de gebruiker die toegang heeft tot de BigBlueButton-server.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton sessie-configuratie';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Een lijst met regels die de rol definiëren die gebruikers tijdens de BibBlueButton-sessie zullen hebben. Een gebruikers-ID kan worden opgeslagen omdat per rol of gebruiker rechten kunnen worden verleend.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Slaat gebeurtenissen op die zijn geactiveerd bij het gebruik van de plug-in.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Het type gebeurtenis dat door de gebruiker is geactiveerd.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'De sessie-ID waartoe de gebruiker toegang heeft.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Bijkomende informatie, gerelateerd aan de sessie van de opname.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Het tijdstip waarop het logboek is gemaakt.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'De gebruikers-ID van de gebruiker die de gebeurtenis heeft geactiveerd.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Slaat metadata over opnames op.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'De gebruikers-ID van de gebruiker die het laatst een opname heeft gewijzigd.';
$string['recordings_from_deleted_activities'] = 'Opnames van verwijderde activiteiten';
$string['recordingurlnotfound'] = 'De opname-URL is ongeldig.';
$string['removedevents'] = 'Verwijderde evenementen';
$string['removedlogs'] = 'Aangepaste logboeken verwijderd';
$string['removedrecordings'] = 'Verwijderde opnames';
$string['removedtags'] = 'Verwijderde tags';
$string['report_join_info'] = '{$a} sessie(s)';
$string['report_play_recording_info'] = '{$a} opname(s) afgespeeld';
$string['report_room_view'] = 'bekeken';
$string['resetevents'] = 'Gebeurtenissen verwijderen';
$string['resetlogs'] = 'Verwijder aangepaste logboeken';
$string['resetlogs_help'] = 'Als je de logboeken verwijdert, gaan verwijzingen naar opnamen verloren.';
$string['resetrecordings'] = 'Verwijder opnames';
$string['resetrecordings_help'] = 'Het verwijderen van de opnames maakt ze overal ontoegankelijk en kan niet ongedaan worden gemaakt!';
$string['resettags'] = 'Verwijder tags';
$string['search:activity'] = 'BigBlueButtonBN - activiteitsinformatie';
$string['search:tags'] = 'BigBlueButtonBN - tagt informatie';
$string['sendnotification'] = 'Stuur een melding';
$string['settings'] = 'BigBlueButton-instellingen';
$string['started_at'] = 'Is begonnen';
$string['starts_at'] = 'Begint';
$string['taskname:check_dismissed_recordings'] = 'Controleer op opnames die nog niet gevonden zijn';
$string['taskname:check_pending_recordings'] = 'Opnames in behandeling ophalen';
$string['userlimitreached'] = 'Het aantal toegestane gebruikers in een sessie is bereikt.';
$string['view_conference_action_end'] = 'Sessie beëindigen';
$string['view_conference_action_join'] = 'Deelnemen aan sessie';
$string['view_error_action_not_completed'] = 'Actie kon niet worden voltooid';
$string['view_error_bigbluebutton'] = 'BigBlueButton antwoordde met fouten. {$a}';
$string['view_error_create'] = 'De BigBlueButton-server reageerde met een foutmelding.  De ruimte kon niet worden gecreëerd.';
$string['view_error_current_state_not_found'] = 'Huidige status is niet gevonden. De opname is mogelijk verwijderd of de BigBlueButton-server is niet compatibel met de uitgevoerde actie.';
$string['view_error_import_no_courses'] = 'Er zijn geen cursussen om te zoeken naar opnames';
$string['view_error_import_no_recordings'] = 'Er zijn geen opnames in deze cursus om te importeren';
$string['view_error_invalid_session'] = 'De sessie is verlopen. Ga terug naar de hoofdpagina van de activiteit.';
$string['view_error_max_concurrent'] = 'Het aantal toegestane gelijktijdige sessies is bereikt.';
$string['view_error_meeting_not_running'] = 'Er is iets misgegaan, de sesse loopt niet.';
$string['view_error_no_group'] = 'Er zijn nog geen groepen. Je moet eerst groepen maken voor je de sessie kunt starten.';
$string['view_error_no_group_student'] = 'Je bent nog geen lid van een groep. Neem contact op met je leraar.';
$string['view_error_no_group_teacher'] = 'Er zijn nog geen groepen. Je moet eerst groepen maken.';
$string['view_error_unable_join'] = 'Kon niet deelnemen aan de sessue. Controleer de URL van de BigBlueButton server EN controleer of de BigBlueButton server aan staat.';
$string['view_error_unable_join_student'] = 'Kon geen verbinding maken met de BigBlueButton server.';
$string['view_error_unable_join_teacher'] = 'Kon geen verbinding maken met de BigBlueButton server. Neem contact op met de beheerder.';
$string['view_error_url_missing_parameters'] = 'Er ontbreken parameters in deze URL';
$string['view_error_userlimit_reached'] = 'De limiet van aantal toegestane gebruikers in een sessie is bereikt.';
$string['view_groups_nogroups_warning'] = 'De ruimte is geconfigureerd voor het gebruik van groepen, maar er zijn geen groepen gedefinieerd voor de cursus.';
$string['view_groups_notenrolled_warning'] = 'De ruimte is geconfigureerd voor gebruik met groepen, maar je bent geen lid van een groep';
$string['view_groups_selection'] = 'Selecteer de groep waaraan je wilt deelnemen en bevestig';
$string['view_groups_selection_join'] = 'Deelnemen';
$string['view_groups_selection_warning'] = 'Er is een ruimte voor iedere groep en jij hebt toegang tot meer dan één groep. Kies zeker de juiste groep.';
$string['view_login_moderator'] = 'Inloggen als moderator ...';
$string['view_login_viewer'] = 'Inloggen als toeschouwer ...';
$string['view_message_and'] = 'en';
$string['view_message_conference_has_ended'] = 'De sessie is geëindigd.';
$string['view_message_conference_in_progress'] = 'De sessie is bezig.';
$string['view_message_conference_not_started'] = 'De sessie is nog niet begonnen.';
$string['view_message_conference_room_ready'] = 'De ruimte is gereed. Je kunt nu deelnemen aan de sessie.';
$string['view_message_conference_user_limit_reached'] = 'De limiet van aantal toegestane gebruikers in een sessie is bereikt.';
$string['view_message_conference_wait_for_moderator'] = 'Wachten op een moderator om te kunnen deelnemen.';
$string['view_message_cron_disabled'] = 'De lijst met opnames is waarschijnlijk niet up-to-date. Contacteer je site-beheerder met volgende informatie: {$a}.';
$string['view_message_finished'] = 'Deze activiteit is afgelopen.';
$string['view_message_has_joined'] = 'is binnengekomen';
$string['view_message_have_joined'] = 'zijn binnengekomen';
$string['view_message_hour'] = 'uur';
$string['view_message_hours'] = 'uren';
$string['view_message_importrecordings_disabled'] = 'Opnamelinks importeren is uitgeschakeld op deze server.';
$string['view_message_minute'] = 'minuut';
$string['view_message_minutes'] = 'minuten';
$string['view_message_moderator'] = 'Moderator';
$string['view_message_moderators'] = 'Moderators';
$string['view_message_norecordings'] = 'Er zijn geen opnames beschikbaar.';
$string['view_message_notavailableyet'] = 'Deze sessie is nog niet beschikbaar.';
$string['view_message_recordings_disabled'] = 'Opnames zijn uitgeschakeld op deze server. BigBlueButton-activiteiten van het type "enkel opname" kunnen niet worden gebruikt.';
$string['view_message_room_closed'] = 'Deze ruimte is gesloten.';
$string['view_message_room_open'] = 'Deze ruimte is open.';
$string['view_message_room_ready'] = 'Deze ruimte is gereed.';
$string['view_message_session_for'] = 'de sessie voor';
$string['view_message_session_has_user'] = 'Er is';
$string['view_message_session_has_users'] = 'Er zijn';
$string['view_message_session_no_users'] = 'Er zijn geen gebruikers voor deze sessie';
$string['view_message_session_running_for'] = 'De sessie is bezig voor';
$string['view_message_session_started_at'] = 'De sessie is begonnen om';
$string['view_message_tab_close'] = 'Dit tab/venster moet handmatig gesloten worden';
$string['view_message_times'] = 'keer';
$string['view_message_user'] = 'Gebruiker';
$string['view_message_users'] = 'Gebruikers';
$string['view_message_viewer'] = 'Toeschouwer';
$string['view_message_viewers'] = 'Toeschouwers';
$string['view_mobile_message_groups_not_supported'] = 'Deze instantie is ingeschakeld om met groepen te werken, maar de mobiele app ondersteunt dit nog niet. Gebruik de webversie.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Je bent langer dan 45 seconden op deze pagina. Ververs de pagina om te kunnen deelnemen aan de sessie.';
$string['view_noguests'] = 'De BigBlueButton-sessie is niet geopend voor gasten.';
$string['view_nojoin'] = 'Je hebt geen rol die mag deelnemen aan deze sessie.';
$string['view_recording'] = 'opname';
$string['view_recording_actionbar'] = 'Werkbalk';
$string['view_recording_activity'] = 'Activiteit';
$string['view_recording_button_import'] = 'Opname-links importeren';
$string['view_recording_button_return'] = 'Ga terug';
$string['view_recording_course'] = 'Cursus';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Weet je zeker dat je deze {$a} wilt verwijderen?';
$string['view_recording_delete_confirmation_warning_p'] = 'Deze opname heeft {$a} geassocieerde links die in andere cursussen of activiteiten zijn geïmporteerd. Als de opname wordt verwijderd, worden ook deze links verwijderd.';
$string['view_recording_delete_confirmation_warning_s'] = 'Deze opname heeft {$a} geassocieerde link die in andere cursussen of activiteiten is geïmporteerd. Als de opname wordt verwijderd, wordt ook deze link verwijderd.';
$string['view_recording_description'] = 'Beschrijving';
$string['view_recording_description_edithint'] = 'Je kunt een beschrijving toevoegen om de opname later makkelijk terug te vinden.';
$string['view_recording_description_editlabel'] = 'Bewerk beschrijving';
$string['view_recording_duration'] = 'Duur';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'De URL voor dit opnameformaat is niet bereikbaar.';
$string['view_recording_format_notes'] = 'Opmerkingen';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentatie';
$string['view_recording_format_screenshare'] = 'Scherm delen';
$string['view_recording_format_statistics'] = 'Statistieken';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Weet je zeker dat je deze opname wilt importeren?';
$string['view_recording_length'] = 'Lengte';
$string['view_recording_link'] = 'geïmporteerde link';
$string['view_recording_link_warning'] = 'Dit is een link die wijst naar een opname die is gecreëerd in een andere cursus of activiteit.';
$string['view_recording_list_action_delete'] = 'Verwijderen';
$string['view_recording_list_action_edit'] = 'Bijwerken';
$string['view_recording_list_action_play'] = 'Afspelen';
$string['view_recording_list_action_process'] = 'Verwerken';
$string['view_recording_list_action_protect'] = 'Beschermen';
$string['view_recording_list_action_publish'] = 'Publiceren';
$string['view_recording_list_action_unprotect'] = 'Beveiliging opheffen';
$string['view_recording_list_action_unpublish'] = 'Publicatie ongedaan maken';
$string['view_recording_list_action_update'] = 'Updaten';
$string['view_recording_list_actionbar'] = 'Werkbalk';
$string['view_recording_list_actionbar_delete'] = 'Verwijder';
$string['view_recording_list_actionbar_edit'] = 'Bewerken';
$string['view_recording_list_actionbar_hide'] = 'Verberg';
$string['view_recording_list_actionbar_import'] = 'Importeren';
$string['view_recording_list_actionbar_protect'] = 'Maak het privé';
$string['view_recording_list_actionbar_publish'] = 'Publiceer';
$string['view_recording_list_actionbar_show'] = 'Toon';
$string['view_recording_list_actionbar_unprotect'] = 'Maak het openbaar';
$string['view_recording_list_actionbar_unpublish'] = 'Maak publiceren ongedaan';
$string['view_recording_list_activity'] = 'Activiteit';
$string['view_recording_list_course'] = 'Cursus';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Beschrijving';
$string['view_recording_list_duration'] = 'Duur';
$string['view_recording_list_recording'] = 'Opname';
$string['view_recording_meeting'] = 'Bijeenkomst';
$string['view_recording_modal_button'] = 'Toepassen';
$string['view_recording_modal_title'] = 'Waarden instellen voor opname';
$string['view_recording_name'] = 'Naam';
$string['view_recording_name_edithint'] = 'Je kunt een naam toevoegen om de opname later makkelijk terug te vinden.';
$string['view_recording_name_editlabel'] = 'Naam bewerken';
$string['view_recording_playback'] = 'Afspelen';
$string['view_recording_preview'] = 'Voorbeeldweergave';
$string['view_recording_preview_help'] = 'Plaats de muisaanwijzer op een afbeelding om deze op volledige grootte te bekijken';
$string['view_recording_protect_confirmation'] = 'Weet je zeker dat je deze {$a} wilt beschermen?';
$string['view_recording_protect_confirmation_warning_p'] = 'Aan deze opname zijn {$a} links gekoppeld die zijn geïmporteerd in verschillende cursussen of activiteiten. Als de opname is beveiligd, heeft dit ook invloed op de geïmporteerde links.';
$string['view_recording_protect_confirmation_warning_s'] = 'Aan deze opname is een {$a} link gekoppeld die is geïmporteerd in een andere cursus of activiteit. Als de opname is beveiligd, heeft dit ook invloed op de geïmporteerde links.';
$string['view_recording_publish_confirmation'] = 'Weet je zeker dat je deze {$a} wilt publiceren?';
$string['view_recording_publish_confirmation_warning_p'] = 'Aan deze opname zijn {$a} links gekoppeld die zijn geïmporteerd in verschillende cursussen of activiteiten. Als de opname wordt gepubliceerd, worden die links ook gepubliceerd.';
$string['view_recording_publish_confirmation_warning_s'] = 'Deze opname heeft {$a} link gekoppeld die is geïmporteerd in een andere cursus of activiteit. Als de opname wordt gepubliceerd, wordt die link ook gepubliceerd.';
$string['view_recording_publish_link_deleted'] = 'Deze link kan niet opnieuw worden gepubliceerd omdat de oorspronkelijke opname niet bestaat op de BigBlueButton-server. De link moet worden verwijderd.';
$string['view_recording_publish_link_not_published'] = 'Deze link kan niet opnieuw worden gepubliceerd omdat de oorspronkelijke opname niet meer is gepubliceerd.';
$string['view_recording_recording'] = 'Opname';
$string['view_recording_select_course'] = 'Selecteer eerst een cursus in het rolmenu';
$string['view_recording_tags'] = 'Tags';
$string['view_recording_unprotect_confirmation'] = 'Weet je zeker dat je de beveiliging van deze {$a} wilt opheffen?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Aan deze opname zijn {$a} links gekoppeld die zijn geïmporteerd in verschillende cursussen of activiteiten. Als de opname onbeschermd is, heeft dit ook invloed op de geïmporteerde links.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Aan deze opname is een {$a} link gekoppeld die is geïmporteerd in een andere cursus of activiteit. Als de opname onbeschermd is, heeft dit ook invloed op de geïmporteerde links.';
$string['view_recording_unprotect_link_deleted'] = 'Deze link kan niet onbeschermd zijn omdat de oorspronkelijke opname niet bestaat op de BigBlueButton-server. De link moet worden verwijderd.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Deze link kan niet onbeschermd zijn omdat de oorspronkelijke opname beschermd is.';
$string['view_recording_unpublish_confirmation'] = 'Weet je zeker dat je publiceren ongedaan wilt maken voor deze {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Deze opname heeft {$a} geassocieerde links die in andere cursussen of activiteiten zijn geïmporteerd. Als de publicatie van de opname ongedaan gemaakt wordt, gebeurt dat ook voor deze links.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Deze opname heeft {$a} geassocieerde link die in andere cursussen of activiteiten is geïmporteerd. Als de publicatie van de opname ongedaan gemaakt wordt, gebeurt dat ook voor deze link.';
$string['view_recording_yui_first'] = 'Eerste';
$string['view_recording_yui_go'] = 'Ga';
$string['view_recording_yui_last'] = 'Laatste';
$string['view_recording_yui_next'] = 'Volgende';
$string['view_recording_yui_page'] = 'Pagina';
$string['view_recording_yui_prev'] = 'Vorige';
$string['view_recording_yui_rows'] = 'Rijen';
$string['view_recording_yui_show_all'] = 'Toon alles';
$string['view_room'] = 'Bekijk ruimte';
$string['view_section_title_presentation'] = 'Presentatie-bestand';
$string['view_section_title_recordings'] = 'Opnames';
$string['view_warning_default_server'] = 'Deze site gebruikt een <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton service voor Moodle (opent in nieuw venster))</a> die door  Blindside Networks aangeboden wordt met volgende beperkingen:
<ol>
<li>De maximale lengte van elke sessie is 60 minuten</li>
<li>Het maximale aantal gelijktijdige gebruikers per sessie is 25</li>
<li>Opnames verdwijnen na zeven (7) dagen en kunnen niet gedownload worden</li>
<li>Webcams van leerlingen zijn enkel zichtbaar voor de moderator.</li>
</ol>';
$string['waitformoderator'] = 'Wachten op een moderator om mee te doen.';
