<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'ar', version '4.1'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'عنوان';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'إدراج/تعديل المرتكز';
$string['advanced:backcolor_desc'] = 'لون الخلفية';
$string['advanced:block'] = 'تنسيق';
$string['advanced:blockquote'] = 'اقتباس كتلة';
$string['advanced:blockquote_desc'] = 'اقتباس كتلة';
$string['advanced:bold_desc'] = 'عريض (Ctrl+B)';
$string['advanced:bullist_desc'] = 'أدرج/أزل قائمة نقطية';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'أدرج رمزاً';
$string['advanced:cleanup_desc'] = 'إزالة النصوص البرمجية الفوضوية';
$string['advanced:clipboard_msg'] = 'النسخ/القص/اللصق غير متوافر في متصفح Mozilla و Firefox. هل تريد معرفة المزيد من المعلومات عن هذه المشكلة؟';
$string['advanced:code'] = 'كود';
$string['advanced:code_desc'] = 'تحرير مصدر HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'نسخ';
$string['advanced:custom1_desc'] = 'شرحك الخاص هنا';
$string['advanced:cut_desc'] = 'قص';
$string['advanced:dd'] = 'وصف التعريف';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'كلمة تعريف';
$string['advanced:font_size'] = 'حجم الخط';
$string['advanced:fontdefault'] = 'نوع الخط';
$string['advanced:forecolor_desc'] = 'لون النص';
$string['advanced:h1'] = 'عنوان 1';
$string['advanced:h2'] = 'عنوان 2';
$string['advanced:h3'] = 'عنوان 3';
$string['advanced:h4'] = 'عنوان 4';
$string['advanced:h5'] = 'عنوان 5';
$string['advanced:h6'] = 'عنوان 6';
$string['advanced:help_desc'] = 'مساعدة';
$string['advanced:help_shortcut'] = 'إضغط ALT-F10 لشريط الأدوات. أضغط ALT-0 للمساعدة';
$string['advanced:hr_desc'] = 'أدرج خطاً أفقياً';
$string['advanced:image_delta_height'] = 'ارتفاع الصورة';
$string['advanced:image_delta_width'] = 'عرض الصورة';
$string['advanced:image_desc'] = 'إدراج/تعديل صورة';
$string['advanced:image_props_desc'] = 'خصائص الصورة';
$string['advanced:indent_desc'] = 'زيادة المسافة البادئة';
$string['advanced:italic_desc'] = 'مائل (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'محاذاة للوسط';
$string['advanced:justifyfull_desc'] = 'ضبط';
$string['advanced:justifyleft_desc'] = 'محاذاة لليسار';
$string['advanced:justifyright_desc'] = 'محاذاة لليمين';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'إدراج/تعديل رابط';
$string['advanced:more_colors'] = 'مزيد من الألوان...';
$string['advanced:newdocument'] = 'هل تريد حقا مسح جميع المحتويات?';
$string['advanced:newdocument_desc'] = 'مستند جديد';
$string['advanced:numlist_desc'] = 'إدراج/إزالة قائمة رقمية';
$string['advanced:outdent_desc'] = 'إنقاص المسافة البادئة';
$string['advanced:paragraph'] = 'فقرة';
$string['advanced:paste_desc'] = 'لصق';
$string['advanced:path'] = 'المسار';
$string['advanced:pre'] = 'منسق';
$string['advanced:redo_desc'] = 'إعادة (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'مسح التنسيقات';
$string['advanced:rich_text_area'] = 'منطقة نص منسق';
$string['advanced:samp'] = 'نموذج نص برمجي';
$string['advanced:shortcuts_desc'] = 'مساعدة الوصول';
$string['advanced:striketrough_desc'] = 'شطب';
$string['advanced:style_select'] = 'اختيار أسلوب العرض';
$string['advanced:sub_desc'] = 'نص سفلي';
$string['advanced:sup_desc'] = 'نص مرقى';
$string['advanced:toolbar'] = 'شريط الأدوات';
$string['advanced:toolbar_focus'] = 'إنتقل لشريط الأدوات - Alt+Q، إنتقل للمحرر - Alt-Z، إنتقل لمسار العنصر - Alt-X';
$string['advanced:underline_desc'] = 'تسطير (Ctrl+U)';
$string['advanced:undo_desc'] = 'تراجع (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'حذف الرابط';
$string['advanced:visualaid_desc'] = 'إظهار/إخفاء الإرشادات/العناصر غير المرئية';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'الكاتب';
$string['advanced_dlg:about_general'] = 'حول';
$string['advanced_dlg:about_help'] = 'مساعدة';
$string['advanced_dlg:about_license'] = 'الرخصة';
$string['advanced_dlg:about_loaded'] = 'الملاحق المحملة';
$string['advanced_dlg:about_plugin'] = 'الملحق';
$string['advanced_dlg:about_plugins'] = 'الملاحق';
$string['advanced_dlg:about_title'] = 'حول TinyMCE';
$string['advanced_dlg:about_version'] = 'الإصدار';
$string['advanced_dlg:accessibility_help'] = 'المساعدة في الوصول';
$string['advanced_dlg:accessibility_usage_title'] = 'الاستعمال العام';
$string['advanced_dlg:anchor_invalid'] = 'لطفاً، حدد اسم مرتكز صحيح.';
$string['advanced_dlg:anchor_name'] = 'اسم المرتكز';
$string['advanced_dlg:anchor_title'] = 'إدراج/تحرير المرتكز';
$string['advanced_dlg:charmap_title'] = 'إختر رمزاً';
$string['advanced_dlg:charmap_usage'] = 'استعمل سهمي اليمين واليسار للتنقل.';
$string['advanced_dlg:code_title'] = 'محرر مصدر HTML';
$string['advanced_dlg:code_wordwrap'] = 'التفاف النص';
$string['advanced_dlg:colorpicker_color'] = 'اللون:';
$string['advanced_dlg:colorpicker_name'] = 'الاسم:';
$string['advanced_dlg:colorpicker_named_tab'] = 'الأسماء';
$string['advanced_dlg:colorpicker_named_title'] = 'أسماء الألوان';
$string['advanced_dlg:colorpicker_palette_tab'] = 'اللوحة';
$string['advanced_dlg:colorpicker_palette_title'] = 'لوحة الألوان';
$string['advanced_dlg:colorpicker_picker_tab'] = 'المازج';
$string['advanced_dlg:colorpicker_picker_title'] = 'مازج الألوان';
$string['advanced_dlg:colorpicker_title'] = 'حدد لون';
$string['advanced_dlg:image_align'] = 'محاذاة';
$string['advanced_dlg:image_align_baseline'] = 'خط القاعدة';
$string['advanced_dlg:image_align_bottom'] = 'اسفل';
$string['advanced_dlg:image_align_left'] = 'يسار';
$string['advanced_dlg:image_align_middle'] = 'توسيط عمودي';
$string['advanced_dlg:image_align_right'] = 'يمين';
$string['advanced_dlg:image_align_textbottom'] = 'أسفل النص';
$string['advanced_dlg:image_align_texttop'] = 'أعلى النص';
$string['advanced_dlg:image_align_top'] = 'أعلى';
$string['advanced_dlg:image_alt'] = 'وصف الصورة';
$string['advanced_dlg:image_border'] = 'الحدود';
$string['advanced_dlg:image_dimensions'] = 'القياسات';
$string['advanced_dlg:image_hspace'] = 'المسافة الأفقية';
$string['advanced_dlg:image_list'] = 'قائمة الصور';
$string['advanced_dlg:image_src'] = 'رابط الصورة';
$string['advanced_dlg:image_title'] = 'إدراج/تعديل صورة';
$string['advanced_dlg:image_vspace'] = 'المسافة العمودية';
$string['advanced_dlg:invalid_color_value'] = 'قيمة لونية غير صحيحة';
$string['advanced_dlg:link_is_email'] = 'الرابط الذي أدخلته يبدو أنه عنوان بريد الكتروني. هل تريد اضافة البادئة الضرورية mailto: ؟';
$string['advanced_dlg:link_is_external'] = 'الرابط الذي أدخلته يبدو أنه رابط لصفحة خارجية. هل تريد اضافة البادئة http:// ؟';
$string['advanced_dlg:link_list'] = 'قائمة الروابط';
$string['advanced_dlg:link_target'] = 'المسار';
$string['advanced_dlg:link_target_blank'] = 'فتح الرابط في صفحة جديدة';
$string['advanced_dlg:link_target_same'] = 'فتح الرابط في نفس الصفحة';
$string['advanced_dlg:link_title'] = 'إدراج/تعديل رابط';
$string['advanced_dlg:link_titlefield'] = 'العنوان';
$string['advanced_dlg:link_url'] = 'الرابط';
$string['advhr:advhr_desc'] = 'أدرج خطاً أفقياً';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'عادي';
$string['advhr_dlg:noshade'] = 'بدون ظل';
$string['advhr_dlg:size'] = 'الإرتفاع';
$string['advhr_dlg:width'] = 'العرض';
$string['advhr_dlg:widthunits'] = 'الوحدات';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'إدراج/تحرير صورة';
$string['advimage_dlg:align'] = 'محاذاة';
$string['advimage_dlg:align_baseline'] = 'خط القاعدة';
$string['advimage_dlg:align_bottom'] = 'أسفل';
$string['advimage_dlg:align_left'] = 'يسار';
$string['advimage_dlg:align_middle'] = 'وسط';
$string['advimage_dlg:align_right'] = 'يمين';
$string['advimage_dlg:align_textbottom'] = 'أسفل النص';
$string['advimage_dlg:align_texttop'] = 'أعلى النص';
$string['advimage_dlg:align_top'] = 'أعلى';
$string['advimage_dlg:alt'] = 'وصف الصورة';
$string['advimage_dlg:alt_image'] = 'صورة بديلة';
$string['advimage_dlg:border'] = 'الحدود';
$string['advimage_dlg:classes'] = 'فئات';
$string['advimage_dlg:constrain_proportions'] = 'تطابق الأبعاد';
$string['advimage_dlg:dialog_title'] = 'إدراج/تعديل صورة';
$string['advimage_dlg:dimensions'] = 'الأبعاد';
$string['advimage_dlg:example_img'] = 'ظهور صورة المعاينة';
$string['advimage_dlg:general'] = 'عام';
$string['advimage_dlg:height'] = 'الارتفاع';
$string['advimage_dlg:hspace'] = 'المسافة الأفقية';
$string['advimage_dlg:id'] = 'المُعرَّف';
$string['advimage_dlg:image_list'] = 'قائمة الصور';
$string['advimage_dlg:langcode'] = 'رمز اللغة';
$string['advimage_dlg:langdir'] = 'اتجاه اللغة';
$string['advimage_dlg:list'] = 'قائمة الصور';
$string['advimage_dlg:long_desc'] = 'وصف الرابط';
$string['advimage_dlg:ltr'] = 'يسار الى يمين';
$string['advimage_dlg:map'] = 'صورة الخريطة';
$string['advimage_dlg:misc'] = 'متنوعة';
$string['advimage_dlg:missing_alt'] = 'هل أنت متأكد من رغبتك في المتابعة بدون إضافة وصف للصورة؟ من دونه، قد لا تكون الصورة قابلة للاستعمال من طرف بعض المستخدمين ذوي الاعاقات، أو لمن يستعملون متصفحات نصية أو المتصفحات بدون عرض الصور.';
$string['advimage_dlg:mouseout'] = 'عند خروج الفأرة من المنطقة';
$string['advimage_dlg:mouseover'] = 'عند دخول الفأرة للمنطقة';
$string['advimage_dlg:preview'] = 'معاينة';
$string['advimage_dlg:rtl'] = 'يمين الى يسار';
$string['advimage_dlg:src'] = 'رابط الصورة';
$string['advimage_dlg:style'] = 'أسلوب';
$string['advimage_dlg:swap_image'] = 'صورة مقايضة';
$string['advimage_dlg:tab_advanced'] = 'متقدم';
$string['advimage_dlg:tab_appearance'] = 'المظهر';
$string['advimage_dlg:tab_general'] = 'عام';
$string['advimage_dlg:title'] = 'العنوان';
$string['advimage_dlg:vspace'] = 'المسافة العمودية';
$string['advimage_dlg:width'] = 'العرض';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'إدراج/تعديل رابط';
$string['advlink_dlg:accesskey'] = 'مفتاح الاختصار';
$string['advlink_dlg:advanced_props'] = 'خصائص متقدمة';
$string['advlink_dlg:advanced_tab'] = 'متقدم';
$string['advlink_dlg:anchor_names'] = 'المرتكزات';
$string['advlink_dlg:classes'] = 'الفئات';
$string['advlink_dlg:encoding'] = 'مسار شفرة الحرف';
$string['advlink_dlg:event_props'] = 'الأحداث';
$string['advlink_dlg:events_tab'] = 'الأحداث';
$string['advlink_dlg:general_props'] = 'خصائص عامة';
$string['advlink_dlg:general_tab'] = 'عام';
$string['advlink_dlg:height'] = 'الارتفاع';
$string['advlink_dlg:id'] = 'المُعرَّف';
$string['advlink_dlg:is_email'] = 'الرابط الذي أدخلته يبدو أنه عنوان بريد الكتروني. هل تريد اضافة البادئة الضرورية mailto: ؟';
$string['advlink_dlg:is_external'] = 'الرابط الذي أدخلته يبدو أنه رابط لصفحة خارجية. هل تريد اضافة البادئة http:// ؟';
$string['advlink_dlg:langcode'] = 'شفرة اللغة';
$string['advlink_dlg:langdir'] = 'اتجاه اللغة';
$string['advlink_dlg:link_list'] = 'قائمة الروابط';
$string['advlink_dlg:list'] = 'قائمة الروابط';
$string['advlink_dlg:ltr'] = 'يسار الى يمين';
$string['advlink_dlg:mime'] = 'مسار MIME type';
$string['advlink_dlg:popup'] = 'JavaScript منبثق';
$string['advlink_dlg:popup_dependent'] = 'تابع (Mozilla/Firefox فقط)';
$string['advlink_dlg:popup_location'] = 'عرض شريط الموضع';
$string['advlink_dlg:popup_menubar'] = 'عرض شريط القائمة';
$string['advlink_dlg:popup_name'] = 'اسم النافذة';
$string['advlink_dlg:popup_opts'] = 'الخيارات';
$string['advlink_dlg:popup_position'] = 'الموقع (X/Y)';
$string['advlink_dlg:popup_props'] = 'خصائص منبثقة';
$string['advlink_dlg:popup_resizable'] = 'جعل النافذة قابلة للتصغير والتكبير';
$string['advlink_dlg:popup_return'] = 'إدراج \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'عرض أشرطة التمرير';
$string['advlink_dlg:popup_size'] = 'الحجم';
$string['advlink_dlg:popup_statusbar'] = 'عرض شريط الحالة';
$string['advlink_dlg:popup_tab'] = 'نافذة منبثقة';
$string['advlink_dlg:popup_toolbar'] = 'عرض شرط الأدوات';
$string['advlink_dlg:popup_url'] = 'رابط النافذة المنبثقة';
$string['advlink_dlg:rel'] = 'ربط الصفحة بالمقصد';
$string['advlink_dlg:rev'] = 'العلاقة الهدف للصفحة';
$string['advlink_dlg:rtl'] = 'يمين الى يسار';
$string['advlink_dlg:style'] = 'الأسلوب';
$string['advlink_dlg:tabindex'] = 'فهرس التبويب';
$string['advlink_dlg:target'] = 'المسار';
$string['advlink_dlg:target_blank'] = 'فتح في نافذة جديدة';
$string['advlink_dlg:target_langcode'] = 'مسار اللغة';
$string['advlink_dlg:target_name'] = 'مسار الاسم';
$string['advlink_dlg:target_parent'] = 'فتح في النافذة/الاطار الأصلي';
$string['advlink_dlg:target_same'] = 'فتح في نفس النافدة/الإطار';
$string['advlink_dlg:target_top'] = 'فتح في اطار علوي (سيستبدل جميع الاطارات)';
$string['advlink_dlg:title'] = 'إدراج/تعديل رابط';
$string['advlink_dlg:titlefield'] = 'العنوان';
$string['advlink_dlg:url'] = 'الرابط';
$string['advlink_dlg:width'] = 'العرض';
$string['advlist:circle'] = 'دائرة';
$string['advlist:def'] = 'افتراضي';
$string['advlist:disc'] = 'تنازلي';
$string['advlist:lower_alpha'] = 'حرف/رقم صغير';
$string['advlist:lower_greek'] = 'يوناني صغير';
$string['advlist:lower_roman'] = 'روماني صغير';
$string['advlist:square'] = 'مربع';
$string['advlist:types'] = 'أنواع';
$string['advlist:upper_alpha'] = 'حرف/رقم كبير';
$string['advlist:upper_roman'] = 'روماني كبير';
$string['aria:rich_text_area'] = 'منطقة نص منسق';
$string['autosave:restore_content'] = 'استعادة المحتوى المحفوظ تلقائياً';
$string['autosave:unload_msg'] = 'التغييرات التي قمت بها ستفقد إن قمت بالانتقال من هذه الصفحة.';
$string['autosave:warning_message'] = 'إذا قمت باستعادة المحتوى المحفوظ، ستخسر كل المحتوى المتواجد حالياً في المحرر.

هل أنت متأكد من رغبتك في استعادة المحتوى المحفوظ؟';
$string['availablebuttons'] = 'الأزرار المتاحة';
$string['colors:000000'] = 'غامق';
$string['colors:000080'] = 'أزرق بحري';
$string['colors:0000FF'] = 'أزرق';
$string['colors:003300'] = 'أخضر داكن';
$string['colors:003366'] = 'سمائي غامق';
$string['colors:008000'] = 'أخضر';
$string['colors:008080'] = 'تركوازي';
$string['colors:00CCFF'] = 'أزرق سمائي';
$string['colors:00FF00'] = 'جيري';
$string['colors:00FFFF'] = 'مائي';
$string['colors:333300'] = 'زيتوني غامق';
$string['colors:333333'] = 'رمادي غامق جداً';
$string['colors:333399'] = 'نيلي';
$string['colors:3366FF'] = 'أزرق ملكي';
$string['colors:339966'] = 'أخضر بحري';
$string['colors:33CCCC'] = 'تركوازي';
$string['colors:666699'] = 'أزرق رمادي';
$string['colors:800000'] = 'ماروني';
$string['colors:800080'] = 'أرجواني';
$string['colors:808000'] = 'زيتوني';
$string['colors:808080'] = 'رمادي';
$string['colors:993300'] = 'برتقالي محروق';
$string['colors:993366'] = 'بني';
$string['colors:999999'] = 'رمادي معتدل';
$string['colors:99CC00'] = 'أخضر مصفر';
$string['colors:99CCFF'] = 'أزرق سمائي خفيف';
$string['colors:C0C0C0'] = 'فضي';
$string['colors:CC99FF'] = 'برقوقي';
$string['colors:CCFFCC'] = 'أخضر باهت';
$string['colors:CCFFFF'] = 'سماوي باهت';
$string['colors:FF0000'] = 'أحمر';
$string['colors:FF00FF'] = 'أرجواني';
$string['colors:FF6600'] = 'برتقالي';
$string['colors:FF9900'] = 'كهرماني';
$string['colors:FF99CC'] = 'وردي';
$string['colors:FFCC00'] = 'ذهبي';
$string['colors:FFCC99'] = 'قرنفلي';
$string['colors:FFFF00'] = 'أصفر';
$string['colors:FFFF99'] = 'أصفر خفيف';
$string['colors:FFFFFF'] = 'أبيض';
$string['common:apply'] = 'تطبيق';
$string['common:browse'] = 'استعراض';
$string['common:cancel'] = 'إلغاء';
$string['common:class_name'] = 'الفئة';
$string['common:clipboard_msg'] = 'النسخ/القص/اللصق غير متوافر في متصفح Mozilla و Firefox. هل تريد معرفة المزيد من المعلومات عن هذه المشكلة؟';
$string['common:clipboard_no_support'] = 'حاليا، هذه الخاصية غير مدعومة من قبل هذا المتصفح، استعمل اختصارات لوحة المفاتيح.';
$string['common:close'] = 'اغلاق';
$string['common:edit_confirm'] = 'هل تريد استخدام المحرر لمربع النص هذا?';
$string['common:insert'] = 'إدراج';
$string['common:invalid_data'] = 'خطأ: القيم المدخلة خاطئة، لقد تم تحديدها باللون الأحمر.';
$string['common:invalid_data_min'] = '{#field} ينبغي أن يكون رقماً أكبر من {#min}';
$string['common:invalid_data_number'] = '{#field} ينبغي أن يكون رقماً';
$string['common:invalid_data_size'] = '{#field} ينبغي أن يكون رقماً أو نسبة مئوية';
$string['common:more_colors'] = 'مزيد من الألوان...';
$string['common:not_set'] = '-- بدون تحديد --';
$string['common:popup_blocked'] = 'عذراً، ولكننا نلاحظ أن مانع النوافذ المنبثقة قد قام بتعطيل نافذة تقدم بعض وظائف النظام. يتطلب الأمر قيامك بتعطيل منع النوافذ المنبثقة لهذا الموقع لتتمكن من تشغيل تلك الأداة بشكل كامل.';
$string['common:update'] = 'تحديث';
$string['common:value'] = '(قيمة)';
$string['contextmenu:align'] = 'محاذاة';
$string['contextmenu:center'] = 'وسط';
$string['contextmenu:full'] = 'ضبط';
$string['contextmenu:left'] = 'يسار';
$string['contextmenu:right'] = 'يمين';
$string['customconfig'] = 'تهيئة مخصصة';
$string['customconfig_desc'] = 'تهيئة مخصصة متقدمة لـ TinyMCE بصيغة JSON، على سبيل المثال: {"option1" : "value2", "option2" : "value2"}. أي خيارات تحدد هنا تتجاوز إعدادات الإضافة القياسية.';
$string['customtoolbar'] = 'شريط أدوات المحرر';
$string['customtoolbar_desc'] = 'كل سطر يحتوي على قائمة مفصولة بفوارز من أسماء الأزرار. استعمل "wrap" بمثابة فاصل مجموعات، يتم تجاهل الأسطر الفارغة. أنظر <a href="{$a}" target="_blank">{$a}</a> للاطلاع على قائمة الأزرار الافتراضية في TinyMCE.<br />السطر الأول سيتم إظهاره دائماً، بينما إظهار شريطا الأدوات الثاني والثالث يمكن التحكم فيه.';
$string['directionality:ltr_desc'] = 'من اليسار الى اليمين';
$string['directionality:rtl_desc'] = 'من اليمين الى اليسار';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'الإبتسامات';
$string['emotions_dlg:cool'] = 'هادئ';
$string['emotions_dlg:cry'] = 'صرخة';
$string['emotions_dlg:desc'] = 'الإبتسامات';
$string['emotions_dlg:embarassed'] = 'محرج';
$string['emotions_dlg:foot_in_mouth'] = 'في القدم والفم';
$string['emotions_dlg:frown'] = 'عبوس';
$string['emotions_dlg:innocent'] = 'بريء';
$string['emotions_dlg:kiss'] = 'قبلة';
$string['emotions_dlg:laughing'] = 'ضحك';
$string['emotions_dlg:money_mouth'] = 'المال الفم';
$string['emotions_dlg:sealed'] = 'مغلق';
$string['emotions_dlg:smile'] = 'ابتسامة';
$string['emotions_dlg:surprised'] = 'مندهش';
$string['emotions_dlg:title'] = 'إدراج ابتسامة';
$string['emotions_dlg:tongue_out'] = 'لسان خارج';
$string['emotions_dlg:undecided'] = 'متردد';
$string['emotions_dlg:usage'] = 'استعمل سهمي اليمين واليسار للتنقل.';
$string['emotions_dlg:wink'] = 'غمزة';
$string['emotions_dlg:yell'] = 'هتاف';
$string['fontselectlist'] = 'قائمة الخطوط المتاحة';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'خصائص المستند';
$string['fullpage_dlg:active_color'] = 'لون الرابط النشطr';
$string['fullpage_dlg:add'] = 'إضافة عنصر جديد';
$string['fullpage_dlg:add_base'] = 'عنصر أساسي';
$string['fullpage_dlg:add_comment'] = 'إضافة تعليق';
$string['fullpage_dlg:add_link'] = 'اضافة عنصر رابط';
$string['fullpage_dlg:add_meta'] = 'عنصر وصفي';
$string['fullpage_dlg:add_script'] = 'عنصر نصي برمجي';
$string['fullpage_dlg:add_style'] = 'عنصر تنسيق';
$string['fullpage_dlg:add_title'] = 'عنصر عنوان';
$string['fullpage_dlg:advanced_props'] = 'متقدم';
$string['fullpage_dlg:advanced_tab'] = 'متقدم';
$string['fullpage_dlg:appearance_bgprops'] = 'خصائص الخلفية';
$string['fullpage_dlg:appearance_linkprops'] = 'ألوان الرابط';
$string['fullpage_dlg:appearance_marginprops'] = 'هوامش الجسم';
$string['fullpage_dlg:appearance_style'] = 'Stylesheet and style خصائص';
$string['fullpage_dlg:appearance_tab'] = 'المظهر';
$string['fullpage_dlg:appearance_textprops'] = 'خصائص النص';
$string['fullpage_dlg:author'] = 'المؤلف';
$string['fullpage_dlg:base_element'] = 'عنصر قاعدي';
$string['fullpage_dlg:bgcolor'] = 'لون الخلفية';
$string['fullpage_dlg:bgimage'] = 'الصورة الخلفية';
$string['fullpage_dlg:bottom_margin'] = 'الهامش الأسفل';
$string['fullpage_dlg:charset'] = 'محارف';
$string['fullpage_dlg:comment_element'] = 'تعليق';
$string['fullpage_dlg:content'] = 'المحتوى';
$string['fullpage_dlg:copyright'] = 'الحقوق الفكرية';
$string['fullpage_dlg:defer'] = 'أرجأ';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'ميز الأحرف';
$string['fullpage_dlg:font_face'] = 'اسم الخط';
$string['fullpage_dlg:font_size'] = 'حجم الخط';
$string['fullpage_dlg:fontface'] = 'نوع الخط';
$string['fullpage_dlg:fontsize'] = 'حجم الخط';
$string['fullpage_dlg:general_props'] = 'عام';
$string['fullpage_dlg:head_elements'] = 'العناصر الرأسية';
$string['fullpage_dlg:hover_color'] = 'لون الرابط عند مرور الفأرة';
$string['fullpage_dlg:href'] = '';
$string['fullpage_dlg:hreflang'] = 'لغة Href';
$string['fullpage_dlg:info'] = 'المعلومات';
$string['fullpage_dlg:langcode'] = 'شفرة اللغة';
$string['fullpage_dlg:langdir'] = 'اتجاه اللغة';
$string['fullpage_dlg:langprops'] = 'اللغة والترميز';
$string['fullpage_dlg:language'] = 'اللغة';
$string['fullpage_dlg:left_margin'] = 'الهامش الأيسر';
$string['fullpage_dlg:link_color'] = 'لون الرابط';
$string['fullpage_dlg:link_element'] = 'رابط';
$string['fullpage_dlg:ltr'] = 'يسار to يمين';
$string['fullpage_dlg:media'] = 'وسائط متعددة';
$string['fullpage_dlg:meta_description'] = 'الوصف';
$string['fullpage_dlg:meta_element'] = 'اضافة';
$string['fullpage_dlg:meta_index_follow'] = 'تأشير وتابع الروابط';
$string['fullpage_dlg:meta_index_nofollow'] = 'تأشير ولا تتابع الروابط';
$string['fullpage_dlg:meta_keywords'] = 'كلمات البحث';
$string['fullpage_dlg:meta_noindex_follow'] = 'لا تؤشر وتابع الروابط';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'لا تفهرس ولا تتبع الروابط';
$string['fullpage_dlg:meta_props'] = 'معلومات ميتا';
$string['fullpage_dlg:meta_robots'] = 'عناكب محركات البحث';
$string['fullpage_dlg:meta_tab'] = 'عام';
$string['fullpage_dlg:meta_title'] = 'العنوان';
$string['fullpage_dlg:movedown'] = 'تحريك العنصر المختار إلى الأسفل';
$string['fullpage_dlg:moveup'] = 'تحريك العنصر المختار إلى الأعلى';
$string['fullpage_dlg:name'] = 'اسم';
$string['fullpage_dlg:properties'] = 'خصائص';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'حذف العنصر المختار';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'الهامش الأيمن';
$string['fullpage_dlg:rtl'] = 'يمين to يسار';
$string['fullpage_dlg:script_element'] = 'سكربت';
$string['fullpage_dlg:src'] = 'المصدر';
$string['fullpage_dlg:style'] = 'النمط';
$string['fullpage_dlg:style_element'] = 'تنسيق';
$string['fullpage_dlg:stylesheet'] = 'Stylesheet';
$string['fullpage_dlg:target'] = 'المسار';
$string['fullpage_dlg:text_color'] = 'لون النص';
$string['fullpage_dlg:textcolor'] = 'اللون';
$string['fullpage_dlg:title'] = 'خصائص المستند';
$string['fullpage_dlg:title_element'] = 'عنصر عنوان';
$string['fullpage_dlg:top_margin'] = 'الهامش العلوي';
$string['fullpage_dlg:type'] = 'النوع';
$string['fullpage_dlg:value'] = 'القيمة';
$string['fullpage_dlg:visited_color'] = 'لون الرابط المعروض من قبل';
$string['fullpage_dlg:xml_pi'] = 'تصريح XML';
$string['fullscreen:desc'] = 'تبديل ملء الشاشة';
$string['iespell:download'] = 'برنامج ieSpell غير موجود. هل تريد أن تقوم بتنصيبه الآن؟';
$string['iespell:iespell_desc'] = 'التدقيق الإملائي';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'الأحد,الإثنين,الثلاثاء,الأربعاء,الخميس,الجمعة,السبت,الأحد';
$string['insertdatetime:day_short'] = 'أحد,إثن,ثلا,أرب,خمي,جمع,سبت,أحد';
$string['insertdatetime:insertdate_desc'] = 'إدراج التاريخ';
$string['insertdatetime:inserttime_desc'] = 'إدراج الوقت';
$string['insertdatetime:months_long'] = 'يناير,فبراير,مارس,ابريل,مايو,يونيو,يوليو,اغسطس,سبتمبر,اكتوبر,نوفمبر,ديسمبر';
$string['insertdatetime:months_short'] = 'يناير,فبراير,مارس,ابريل,مايو,يونيو,يوليو,اغسطس,سبتمبر,اكتوبر,نوفمبر,ديسمبر';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'تبديل التموضع المطلق';
$string['layer:backward_desc'] = 'تحريك للمؤخرة';
$string['layer:content'] = 'طبقة جديدة...';
$string['layer:forward_desc'] = 'تحريك للمقدمة';
$string['layer:insertlayer_desc'] = 'إدراج طبقة جديدة';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'إدراج/تحرير الوسائط المضمنة';
$string['media:edit'] = 'تحرير الوسائط المضمَّنة';
$string['media_dlg:advanced'] = 'متقدم';
$string['media_dlg:align'] = 'المحاذاة';
$string['media_dlg:align_bottom'] = 'أسفل';
$string['media_dlg:align_bottom_left'] = 'أسفل اليسار';
$string['media_dlg:align_bottom_right'] = 'أسفل يمين';
$string['media_dlg:align_center'] = 'مركز';
$string['media_dlg:align_left'] = 'يسار';
$string['media_dlg:align_right'] = 'يمين';
$string['media_dlg:align_top'] = 'أعلى';
$string['media_dlg:align_top_left'] = 'أعلى اليسار';
$string['media_dlg:align_top_right'] = 'أعلى يمين';
$string['media_dlg:altsource1'] = 'المصدر البديل 1';
$string['media_dlg:altsource2'] = 'المصدر البديل 2';
$string['media_dlg:audio'] = 'صوت HTML5';
$string['media_dlg:autogotourl'] = 'عنوان إعادة التوجيه التلقائي';
$string['media_dlg:autohref'] = '';
$string['media_dlg:autostart'] = 'تشغيل تلقائي';
$string['media_dlg:balance'] = 'توازن';
$string['media_dlg:base'] = 'القاعدة';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'الخلفية';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'مُعرَّف التعليق';
$string['media_dlg:center'] = 'مركز';
$string['media_dlg:class_name'] = 'الفئة';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'تقييد أبعاد';
$string['media_dlg:controller'] = 'مراقب';
$string['media_dlg:controls'] = 'الأدوات';
$string['media_dlg:correction'] = 'لا تصحيح';
$string['media_dlg:currentmarker'] = 'العلامة الحالية';
$string['media_dlg:currentposition'] = 'الوضع الحالي';
$string['media_dlg:defaultframe'] = 'الإطار الافتراضي';
$string['media_dlg:embedded_audio_options'] = 'خيارات الصوت المضمن';
$string['media_dlg:embeddedaudio'] = 'صوت مضمن';
$string['media_dlg:enabled'] = 'تمكين';
$string['media_dlg:enablejavascript'] = 'تمكين JavaScript';
$string['media_dlg:endtime'] = 'وقت النهاية';
$string['media_dlg:file'] = 'ملف/URL';
$string['media_dlg:flash'] = 'فلاش';
$string['media_dlg:flash_options'] = 'خصائص ال Flash';
$string['media_dlg:flashvars'] = 'متغيرات فلاش';
$string['media_dlg:fullscreen'] = 'ملء الشاشة';
$string['media_dlg:general'] = 'عام';
$string['media_dlg:hidden'] = 'مخفي';
$string['media_dlg:href'] = '';
$string['media_dlg:hspace'] = 'المسافة الأفقية';
$string['media_dlg:html5_audio_options'] = 'خيارات الصوت';
$string['media_dlg:html5_video_options'] = 'خيارات فيديو HTML5';
$string['media_dlg:id'] = 'المُعرَّف';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'وضعية الصورة';
$string['media_dlg:invokeurls'] = 'حث الروابط URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'قائمة';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'اعادة تشغيل (loop)';
$string['media_dlg:maintainaspect'] = 'الحفاظ على المظهر';
$string['media_dlg:menu'] = 'عرض القائمة';
$string['media_dlg:mute'] = 'الغاء الصوت';
$string['media_dlg:name'] = 'الاسم';
$string['media_dlg:nojava'] = '';
$string['media_dlg:numloop'] = 'عدد الحلقات';
$string['media_dlg:play'] = 'تشغيل تلقائي';
$string['media_dlg:playcount'] = 'عدد مرات التشغيل';
$string['media_dlg:playeveryframe'] = 'تشغيل كل الإطار';
$string['media_dlg:poster'] = 'ملصق إعلاني';
$string['media_dlg:prefetch'] = 'جلب قبلي';
$string['media_dlg:preload'] = 'التحميل المسبق';
$string['media_dlg:preload_auto'] = 'دع متصفح المستخدم يقرر';
$string['media_dlg:preload_metadata'] = 'التحميل المسبق للبيانات الوصفية للفيديو';
$string['media_dlg:preload_none'] = 'لا تقم بالتحميل المسبق';
$string['media_dlg:preview'] = 'معاينة';
$string['media_dlg:progress'] = 'تقدم';
$string['media_dlg:qt_options'] = 'خيارات Quicktime';
$string['media_dlg:qt_stream_warn'] = 'مصادر تدفق RTSP تنبغي إضافتها إلى حقل مصدر QT تحت التبويب المتقدم.
عليك أيضاً أن تضيف النسخة التي لا تملك خاصية التدفق إلى الحقل.';
$string['media_dlg:qtsrc'] = 'مصدر QT';
$string['media_dlg:qtsrcchokespeed'] = 'سرعة الخنق';
$string['media_dlg:quality'] = 'الجودة';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'تقييم';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'خيارا مشغل Real media';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'الجدول';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'خصائص Shockwave';
$string['media_dlg:shuffle'] = 'الخلط';
$string['media_dlg:size'] = 'الأبعاد';
$string['media_dlg:sound'] = 'صوت';
$string['media_dlg:source'] = 'المصدر';
$string['media_dlg:starttime'] = 'وقت البداية';
$string['media_dlg:stretchtofit'] = 'تمتد لتناسب';
$string['media_dlg:swstretchhalign'] = 'الوضعية الأفقية للتمديد';
$string['media_dlg:swstretchstyle'] = 'نمط التمديد';
$string['media_dlg:swstretchvalign'] = 'الوضعية العمودية للمتديد';
$string['media_dlg:target'] = 'المسار';
$string['media_dlg:targetcache'] = 'المسار cache';
$string['media_dlg:title'] = 'إدراج/تحرير الوسائط المضمنة';
$string['media_dlg:type'] = 'النوع';
$string['media_dlg:uimode'] = 'نمط واجهة المستخدم';
$string['media_dlg:video'] = 'فيديو HTML5';
$string['media_dlg:volume'] = 'مستوى الصوت';
$string['media_dlg:vspace'] = 'المسافة العمودية';
$string['media_dlg:windowlessvideo'] = 'نوافذ الفيديو';
$string['media_dlg:windowsmedia'] = 'وسائط وندوز';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'خيارات مشغل وسائط وندوز';
$string['nonbreaking:nonbreaking_desc'] = 'إدراج الحرف non-breaking space';
$string['pagebreak:desc'] = 'أدرج فاصل صفحات للطباعة';
$string['paste:paste_text_desc'] = 'إلصقه كنص عادي';
$string['paste:paste_word_desc'] = 'لصق من مستند وورد';
$string['paste:plaintext_mode'] = 'اللصق حالياً هو بنمط النص العادي. أنقر مجدداً لتبديله إلى نمط اللصق الاعتيادي. بعد أن تقوم بلصق شيء ما، ستعود إلى نمط اللصق الاعتيادي.';
$string['paste:plaintext_mode_stick'] = 'اللصق حالياً هو بنمط النص العادي. أنقر مجدداً لتبديله إلى نمط اللصق الاعتيادي.';
$string['paste:selectall_desc'] = 'تحديد الكل';
$string['paste_dlg:text_linebreaks'] = 'أبقِ فواصل الأسطر';
$string['paste_dlg:text_title'] = 'استعمل CTRL+V في لوحة المفاتيح للصق النص في النافذة.';
$string['paste_dlg:word_title'] = 'استعمل CTRL+V في لوحة المفاتيح للصق النص في النافذة.';
$string['pluginname'] = 'محرر TinyMCE HTML (موروث)';
$string['preview:preview_desc'] = 'معاينة';
$string['print:print_desc'] = 'الطباعة';
$string['privacy:metadata'] = 'إن إضافة محرر TinyMCE HTML لا تخزن أي بيانات شخصية.';
$string['save:cancel_desc'] = 'الغاء جميع التعديلات';
$string['save:save_desc'] = 'حفظ';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'بحث/استبدال';
$string['searchreplace:search_desc'] = 'بحث';
$string['searchreplace_dlg:allreplaced'] = 'جميع الكلمات التي توافق كلمة البحث تم استبدالها.';
$string['searchreplace_dlg:direction'] = 'الإتجاه';
$string['searchreplace_dlg:down'] = 'اسفل';
$string['searchreplace_dlg:findnext'] = 'بحث عن التالي';
$string['searchreplace_dlg:findwhat'] = 'البحث عن';
$string['searchreplace_dlg:mcase'] = 'التأكد من حالة الأحرف';
$string['searchreplace_dlg:notfound'] = 'انتهى البحث. لم يتم العثور على كلمة البحث.';
$string['searchreplace_dlg:replace'] = 'استبدال';
$string['searchreplace_dlg:replace_title'] = 'بحث/استبدال';
$string['searchreplace_dlg:replaceall'] = 'استبدال الكل';
$string['searchreplace_dlg:replacewith'] = 'استبدال بـ';
$string['searchreplace_dlg:search_title'] = 'بحث';
$string['searchreplace_dlg:searchnext_desc'] = 'بحث من جديد';
$string['searchreplace_dlg:up'] = 'اعلى';
$string['settings'] = 'إعدادات عامة';
$string['simple:bold_desc'] = 'عريض(Ctrl+B)';
$string['simple:bullist_desc'] = 'أدرج/إزل قائمة نقطية';
$string['simple:cleanup_desc'] = 'إزالة النصوص البرمجية الفوضوية';
$string['simple:italic_desc'] = 'مائل(Ctrl+I)';
$string['simple:numlist_desc'] = 'أدرج/إزل قائمة رقمية';
$string['simple:redo_desc'] = 'اعادة (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'شطب';
$string['simple:underline_desc'] = 'تسطير (Ctrl+U)';
$string['simple:undo_desc'] = 'تراجع (Ctrl+Z)';
$string['spellchecker:desc'] = 'تبديل المدقق الإملائي';
$string['spellchecker:ignore_word'] = 'تجاهل الكلمة';
$string['spellchecker:ignore_words'] = 'تجاهل الكل';
$string['spellchecker:langs'] = 'اللغات';
$string['spellchecker:learn_word'] = 'تعلم الكلمة';
$string['spellchecker:menu'] = 'إعدادات المدقق الإملائي';
$string['spellchecker:no_mpell'] = 'لم يتم العثور على أخطاء إملائية.';
$string['spellchecker:no_sug'] = 'لا اقتراحات';
$string['spellchecker:sug'] = 'الإقتراحات';
$string['spellchecker:wait'] = 'الرجاء الإنتظار...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'تعديل نمط CSS';
$string['style_dlg:apply'] = 'تطبيق';
$string['style_dlg:background'] = 'الخلفية';
$string['style_dlg:background_attachment'] = 'مرفق';
$string['style_dlg:background_color'] = 'لون الخلفية';
$string['style_dlg:background_hpos'] = 'الوضعية الأفقية';
$string['style_dlg:background_image'] = 'الصورة الخلفية';
$string['style_dlg:background_repeat'] = 'اعادة';
$string['style_dlg:background_tab'] = 'الخلفية';
$string['style_dlg:background_vpos'] = 'الوضعية العمودية';
$string['style_dlg:block'] = 'كتلة';
$string['style_dlg:block_display'] = 'العرض';
$string['style_dlg:block_letterspacing'] = 'رسالة المباعدة';
$string['style_dlg:block_tab'] = 'قطعة';
$string['style_dlg:block_text_align'] = 'مواءمة النص';
$string['style_dlg:block_text_indent'] = 'ازاحة النص';
$string['style_dlg:block_vertical_alignment'] = 'المواءمة العمودية';
$string['style_dlg:block_whitespace'] = 'المسافة البيضاء';
$string['style_dlg:block_wordspacing'] = 'كلمة المباعدة';
$string['style_dlg:border'] = 'حدود';
$string['style_dlg:border_tab'] = 'الحدود';
$string['style_dlg:bottom'] = 'أسفل';
$string['style_dlg:box'] = 'مربع';
$string['style_dlg:box_clear'] = 'واضح';
$string['style_dlg:box_float'] = 'الطفو';
$string['style_dlg:box_height'] = 'الإرتفاع';
$string['style_dlg:box_tab'] = 'صندوق';
$string['style_dlg:box_width'] = 'العرض';
$string['style_dlg:bullet_image'] = 'صورة الرصاصة';
$string['style_dlg:clip'] = 'مشبك';
$string['style_dlg:color'] = 'اللون';
$string['style_dlg:height'] = 'الإرتفاع';
$string['style_dlg:left'] = 'يسار';
$string['style_dlg:list'] = 'قائمة';
$string['style_dlg:list_tab'] = 'قائمة';
$string['style_dlg:list_type'] = 'نوع';
$string['style_dlg:margin'] = 'هامش';
$string['style_dlg:overflow'] = 'الفيض';
$string['style_dlg:padding'] = 'البطانة';
$string['style_dlg:placement'] = 'الموضع';
$string['style_dlg:position'] = 'الموضع';
$string['style_dlg:positioning_tab'] = 'وضع';
$string['style_dlg:positioning_type'] = 'النوع';
$string['style_dlg:right'] = 'يمين';
$string['style_dlg:same'] = 'نفس للكل';
$string['style_dlg:style'] = 'نسق';
$string['style_dlg:text'] = 'نص';
$string['style_dlg:text_blink'] = 'ومضة';
$string['style_dlg:text_case'] = 'حالة';
$string['style_dlg:text_color'] = 'اللون';
$string['style_dlg:text_decoration'] = 'زخرفة';
$string['style_dlg:text_font'] = 'خط';
$string['style_dlg:text_lineheight'] = 'ارتفاع الخط';
$string['style_dlg:text_none'] = 'بلا';
$string['style_dlg:text_overline'] = 'خط علوي';
$string['style_dlg:text_props'] = 'نص';
$string['style_dlg:text_size'] = 'الحجم';
$string['style_dlg:text_striketrough'] = 'تشطيب';
$string['style_dlg:text_style'] = 'نسق';
$string['style_dlg:text_tab'] = 'نص';
$string['style_dlg:text_underline'] = 'خط سفلي';
$string['style_dlg:text_variant'] = 'متغير';
$string['style_dlg:text_weight'] = 'عرض';
$string['style_dlg:title'] = 'تعديل نمط CSS';
$string['style_dlg:toggle_insert_span'] = 'أدرج امتداداً عند هذا التحديد';
$string['style_dlg:top'] = 'أعلى';
$string['style_dlg:visibility'] = 'حالة الإظهار';
$string['style_dlg:width'] = 'العرض';
$string['style_dlg:zindex'] = 'ترتيب النوافذ Z-index';
$string['subplugintype_tinymce'] = 'ملحق';
$string['subplugintype_tinymce_plural'] = 'ملاحق';
$string['table:cell'] = 'خلية';
$string['table:cell_desc'] = 'خصائص خلية الجدول';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'عمود';
$string['table:col_after_desc'] = 'إدراج عمود بعد';
$string['table:col_before_desc'] = 'إدراج عمود قبل';
$string['table:copy_row_desc'] = 'نسخ صف';
$string['table:cut_row_desc'] = 'قص صف';
$string['table:del'] = 'إحذف الجدول';
$string['table:delete_col_desc'] = 'حذف العمود';
$string['table:delete_row_desc'] = 'حذف الصف';
$string['table:desc'] = 'إدراج/تحرير جدول';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'دمج خلايا الجدول';
$string['table:paste_row_after_desc'] = 'لصق صف جدول بعد';
$string['table:paste_row_before_desc'] = 'لصق صف جدول قبل';
$string['table:props_desc'] = 'خصائص الجدول';
$string['table:row'] = 'صف';
$string['table:row_after_desc'] = 'إدراج صف بعد';
$string['table:row_before_desc'] = 'إدراج صف قبل';
$string['table:row_desc'] = 'خصائص صف الجدول';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'تقسيم الخلايا المدموجة';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'خصائص متقدمة';
$string['table_dlg:advanced_tab'] = 'متقدم';
$string['table_dlg:align'] = 'محاذاة';
$string['table_dlg:align_bottom'] = 'أسفل';
$string['table_dlg:align_default'] = 'الافتراضي';
$string['table_dlg:align_left'] = 'يسار';
$string['table_dlg:align_middle'] = 'وسط';
$string['table_dlg:align_right'] = 'يمين';
$string['table_dlg:align_top'] = 'أعلى';
$string['table_dlg:bgcolor'] = 'لون الخلفية';
$string['table_dlg:bgimage'] = 'الصورة الخلفية';
$string['table_dlg:border'] = 'الحدود';
$string['table_dlg:bordercolor'] = 'لون الحدود';
$string['table_dlg:caption'] = 'عنوان الجدول';
$string['table_dlg:cell_all'] = 'تحديث جميع الخلايا الموجودة في الجدول';
$string['table_dlg:cell_cell'] = 'تحديث الخلية الحالية';
$string['table_dlg:cell_col'] = 'تحديث كل الخلايا في العمود';
$string['table_dlg:cell_limit'] = 'لقد تعديت العدد الأقصى المسموح به للخلايا الخاص بـ{$cells}.';
$string['table_dlg:cell_row'] = 'تحديث جميع الخلايا الموحودة في السطر';
$string['table_dlg:cell_title'] = 'خصائص أعمدة الجدول';
$string['table_dlg:cell_type'] = 'نوع الخية';
$string['table_dlg:cellpadding'] = 'بطانة الخلية';
$string['table_dlg:cellspacing'] = 'المسافة بين الخلايا';
$string['table_dlg:col_limit'] = 'لقد تعديت العدد الأقصى المسموح به للأعمدة الخاص بـ{$cols}.';
$string['table_dlg:colgroup'] = 'مجموعة العمود';
$string['table_dlg:cols'] = 'أعمدة';
$string['table_dlg:frame'] = 'الاطار';
$string['table_dlg:frame_all'] = 'الكل';
$string['table_dlg:frame_cols'] = 'الأعمدة';
$string['table_dlg:frame_groups'] = 'المجموعات';
$string['table_dlg:frame_none'] = 'فارغ';
$string['table_dlg:frame_rows'] = 'الأسطر';
$string['table_dlg:general_props'] = 'خصائص عامة';
$string['table_dlg:general_tab'] = 'عام';
$string['table_dlg:height'] = 'الإرتفاع';
$string['table_dlg:id'] = '';
$string['table_dlg:langcode'] = 'شفرة اللغة';
$string['table_dlg:langdir'] = 'اتجاه اللغة';
$string['table_dlg:ltr'] = 'يسار to يمين';
$string['table_dlg:merge_cells_title'] = 'دمج خلايا الجدول';
$string['table_dlg:mime'] = 'المسار MIME type';
$string['table_dlg:missing_scope'] = 'هل أنت متأكد من رغبتك في المتابعة بدون تحديد المدى الخاص بخلية الترويسة لهذا الجدول؟ من دونه، قد يكون من الصعب على بعض المستخدمين ذوي الإعاقات فهم محتويات الجدول أو بياناته.';
$string['table_dlg:row_all'] = 'تحديث جميع الأسطر';
$string['table_dlg:row_even'] = 'تحدي الأسطر الزوجية';
$string['table_dlg:row_limit'] = 'لقد تعديت العدد الأقصى المسموح به للأسطر الخاص بـ{$rows}.';
$string['table_dlg:row_odd'] = 'تحديث الأسطر الفردية';
$string['table_dlg:row_row'] = 'تحديث السطر الحالي';
$string['table_dlg:row_title'] = 'خصائص أسطر الجدول';
$string['table_dlg:rowgroup'] = 'مجموعة السطر';
$string['table_dlg:rows'] = 'أسطر';
$string['table_dlg:rowtype'] = 'نوع الصف';
$string['table_dlg:rtl'] = 'يمين to يسار';
$string['table_dlg:rules'] = 'القواعد';
$string['table_dlg:rules_above'] = 'أعلى';
$string['table_dlg:rules_below'] = 'أسفل';
$string['table_dlg:rules_border'] = 'الحدود';
$string['table_dlg:rules_box'] = 'صندوق';
$string['table_dlg:rules_hsides'] = 'الجوانب الأفقية';
$string['table_dlg:rules_lhs'] = 'الجانب الأفقي الأيسر';
$string['table_dlg:rules_rhs'] = 'الجانب الأفقي الأيمن';
$string['table_dlg:rules_void'] = 'باطل';
$string['table_dlg:rules_vsides'] = 'الجوانب العمودية';
$string['table_dlg:scope'] = 'المدى';
$string['table_dlg:style'] = 'نسق';
$string['table_dlg:summary'] = 'موجز';
$string['table_dlg:tbody'] = 'جسم الجدول';
$string['table_dlg:td'] = 'المحتوى';
$string['table_dlg:tfoot'] = 'تذييل الجدول';
$string['table_dlg:th'] = 'العنوان';
$string['table_dlg:thead'] = 'رأس الجدول';
$string['table_dlg:title'] = 'إدراج/تعديل الجدول';
$string['table_dlg:valign'] = 'المحاذاة العمودية';
$string['table_dlg:width'] = 'العرض';
$string['template:desc'] = 'إدراج مظهر موجود مسبقا';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'الأحد,الإثنين,الثلاثاء,الأربعاء,الخميس,الجمعة,السبت,الأحد';
$string['template_dlg:day_short'] = 'أحد,إثن,ثلا,أرب,خمي,جمع,سبت,أحد';
$string['template_dlg:desc'] = 'إدراج قبل تعين محتوى القالب';
$string['template_dlg:desc_label'] = 'الوصف';
$string['template_dlg:label'] = 'القالب';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'يناير,فبراير,مارس,ابريل,مايو,يونيو,يوليو,اغسطس,سبتمبر,اكتوبر,نوفمبر,ديسمبر';
$string['template_dlg:months_short'] = 'يناير,فبراير,مارس,ابريل,مايو,يونيو,يوليو,اغسطس,سبتمبر,اكتوبر,نوفمبر,ديسمبر';
$string['template_dlg:preview'] = 'معاينة';
$string['template_dlg:select'] = 'حدد مظهر';
$string['template_dlg:title'] = 'القوالب';
$string['template_dlg:warning'] = 'تحذير: تحديث القالب بقالب آخر ربما يؤدي لفقدان البيانات.';
$string['visualblocks:desc'] = 'إظهار/إخفاء عناصر الكتل';
$string['visualchars:desc'] = 'إظهار/إخفاء المسيطرات البصرية';
$string['wordcount:words'] = 'كلمات:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'الاختصار';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'الاختصار';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'إدراج/تحرير السمات';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'اقتباس';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'حذف';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'إدراج';
$string['xhtmlxtras_dlg:attrib_tab'] = 'صفات';
$string['xhtmlxtras_dlg:attribs_title'] = 'إدراج/تحرير السمات';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'الصفات';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'الأحداث';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'حرف الاختصار';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'اقتباس';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'الفئة';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'التاريخ/الوقت';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'المعرف ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'اللغة';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'اتجاه النص';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'الأسلوب';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'ترتيب التبويب';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'عنوان';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'يسار الى يمين';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'يمين الى يسار';
$string['xhtmlxtras_dlg:events_tab'] = 'الأحداث';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'سمات العنصر';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'أحداث العنصر';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'الإعدادات العامة';
$string['xhtmlxtras_dlg:general_tab'] = 'عام';
$string['xhtmlxtras_dlg:insert_date'] = 'إدراج التاريخ/الوقت الحالي';
$string['xhtmlxtras_dlg:option_ltr'] = 'يسار الى يمين';
$string['xhtmlxtras_dlg:option_rtl'] = 'يمين الى يسار';
$string['xhtmlxtras_dlg:remove'] = 'حذف';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'عنصر اختصار';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'عنصر اختزال';
$string['xhtmlxtras_dlg:title_cite_element'] = 'عنصر اقتباس';
$string['xhtmlxtras_dlg:title_del_element'] = 'عنصر الحذف';
$string['xhtmlxtras_dlg:title_ins_element'] = 'عنصر إدراج';
