<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'af', version '4.1'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Aksies vir die bepunterkoppelvlak';
$string['actionsforpost'] = 'Aksies vir plasing';
$string['activitydate:due'] = 'Benodig teen:';
$string['activityoverview'] = 'Daar is nuwe forumplasings';
$string['addanewdiscussion'] = 'Voeg \'n nuwe besprekingsonderwerp by';
$string['addanewquestion'] = 'Voeg \'n nuwe vraag by';
$string['addanewtopic'] = 'Voeg \'n nuwe onderwerp by';
$string['addtofavourites'] = 'Merk hierdie onderwerp met \'n sterretjie';
$string['advancedsearch'] = 'Gevorderde soek';
$string['alldiscussions'] = 'Alle besprekings';
$string['allforums'] = 'Alle forums';
$string['allowdiscussions'] = 'Kan \'n {$a} \'n plasing op hierdie forum maak?';
$string['allowsallsubscribe'] = 'Hierdie forum laat almal toe om te kies of hulle wil inteken of nie';
$string['allowsdiscussions'] = 'Hierdie forum laat elke persoon toe om een nuwe besprekingsonderwerp te begin';
$string['allsubscribe'] = 'Teken in vir alle forums';
$string['allunsubscribe'] = 'Ontdoen intekening vir alle forums';
$string['allusers'] = 'Alle gebruikers';
$string['alreadyfirstpost'] = 'Hierdie is reeds die eerste plasing in die bespreking';
$string['anyfile'] = 'Enige lêer';
$string['areaattachment'] = 'Aanhangsels';
$string['areapost'] = 'Boodskappe';
$string['attachment'] = 'Aanhangsel';
$string['attachment_help'] = 'Jy het die opsie om een of meer lêer by \'n forumplasing aan te heg. As jy \'n beeld aanheg, sal dit ná die boodskap gewys word.';
$string['attachmentname'] = 'Aanhangsel {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Jy kan nie aanhangsels sonder \'n plasing-ID eksporteer nie.';
$string['attachments'] = 'Aanhangsels';
$string['attachmentswordcount'] = 'Aanhangsels en woordtelling';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} antwoord privaat op {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} antwoord op {$a->author}';
$string['availability'] = 'Beskikbaarheid';
$string['blockafter'] = 'Plasingsdrempel vir blokkering';
$string['blockafter_help'] = 'Hierdie instelling spesifiseer die maksimum aantal plasings wat \'n gebruiker in die gegewe tydperk kan plaas. Gebruikers aan wie mod/forum:postwithoutthrottling vergun is, word vrygestel van perke op plasings.';
$string['blockperiod'] = 'Tydperk vir blokkering';
$string['blockperiod_help'] = 'Studente kan geblok word sodat hulle nie meer as \'n sekere aantal plasings in \'n gegewe tydperk kan plaas nie. Gebruikers aan wie mod/forum:postwithoutthrottling vergun is, word vrygestel van perke op plasings.';
$string['blockperioddisabled'] = 'Moenie blok nie';
$string['blogforum'] = 'Standaardforum wat gewys word in \'n formaat wat soos \'n blog lyk';
$string['bynameondate'] = 'deur {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Forumvolgstatus vir gebruiker';
$string['calendardue'] = '{$a} is uitstaande';
$string['cancelreply'] = 'Kanselleer antwoord';
$string['cannotadd'] = 'Kon nie die bespreking by hierdie forum voeg nie';
$string['cannotadddiscussion'] = 'Groeplidmaatskap word vereis om besprekings tot hierdie forum by te voeg.';
$string['cannotadddiscussionall'] = 'Jy het nie toestemming om \'n nuwe besprekingsonderwerp vir alle deelnemers by te voeg nie.';
$string['cannotadddiscussiongroup'] = 'Jy kan nie \'n nuwe bespreking skep nie omdat jy nie \'n lid van enige groep is nie.';
$string['cannotaddsubscriber'] = 'Kon nie intekenaar met ID {$a} by hierdie forum voeg nie!';
$string['cannotaddteacherforumto'] = 'Kon nie omgeskakelde eksemplaar van onderwyserforum by gedeelte 0 in die kursus byvoeg nie.';
$string['cannotcreatediscussion'] = 'Kon nie \'n nuwe bespreking skep nie';
$string['cannotcreateinstanceforteacher'] = 'Kon nie \'n eksemplaar van \'n nuwe kursusmodule vir die onderwyserforum skep nie';
$string['cannotdeletepost'] = 'Jy kan nie hierdie plasing skrap nie!';
$string['cannoteditposts'] = 'Jy kan nie ander mense se plasings redigeer nie!';
$string['cannotexportforum'] = 'Jy kan nie hierdie forum eksporteer nie.';
$string['cannotfavourite'] = 'Jammer, jy het nie toestemming om besprekings met sterretjies te merk nie.';
$string['cannotfinddiscussion'] = 'Kon nie die bespreking in hierdie forum vind nie.';
$string['cannotfindfirstpost'] = 'Kon nie die eerste plasing in hierdie forum vind nie.';
$string['cannotfindorcreateforum'] = 'Kon nie \'n hoofaankondigingsforum vir die webwerf vind of skep nie.';
$string['cannotfindparentpost'] = 'Kon nie topvoorsaat van plasing {$a} vind nie';
$string['cannotmovefromsingleforum'] = 'Kan nie bespreking vanaf \'n eenvoudige enkelbesprekingsforum verskuif nie';
$string['cannotmovenotvisible'] = 'Forum nie sigbaar nie';
$string['cannotmovetonotexist'] = 'Jy kan nie na daardie forum verskuif nie - dit bestaan nie!';
$string['cannotmovetonotfound'] = 'Teikenforum nie in hierdie kursus gevind nie.';
$string['cannotmovetosingleforum'] = 'Kan nie bespreking na \'n eenvoudige enkelbesprekingsforum verskuif nie';
$string['cannotpindiscussions'] = 'Jammer, jy het nie toestemming om besprekings vas te pen nie.';
$string['cannotpurgecachedrss'] = 'Kon nie die RSS-voere in die cache vir die bron- en/of bestemmingsforum(s) skoonmaak nie - gaan jou lêertoestemmings na.';
$string['cannotremovesubscriber'] = 'Kon nie intekenaar met ID {$a} uit hierdie forum verwyder nie!';
$string['cannotreply'] = 'Jy kan nie op hierdie plasing antwoord nie.';
$string['cannotsplit'] = 'Besprekings vanuit hierdie forum kan nie verdeel word nie.';
$string['cannotsubscribe'] = 'Jammer, jy moet \'n groeplid wees as jy wil inteken.';
$string['cannottrack'] = 'Kon nie ophou om daardie forum te volg nie';
$string['cannotunsubscribe'] = 'Kon nie jou intekening vir daardie forum ontdoen nie';
$string['cannotupdatepost'] = 'Jy kan nie hierdie plasing bywerk nie.';
$string['cannotviewpostyet'] = 'Jy kan nie ander studente se vrae in hierdie bespreking lees nie omdat jy nog nie \'n plasing gemaak het nie.';
$string['cannotviewusersposts'] = 'Daar is geen plasings wat deur hierdie gebruiker gemaak is wat jy kan bekyk nie.';
$string['cleanreadtime'] = 'Merk ou plasings as gelees uur';
$string['clicktofavourite'] = 'Jy het nie hierdie bespreking gester nie. Klik om te ster.';
$string['clicktolockdiscussion'] = 'Klik om hierdie bespreking te sluit';
$string['clicktosubscribe'] = 'Jy is nie vir hierdie bespreking ingeteken nie. Klik om in te teken.';
$string['clicktounfavourite'] = 'Jy het hierdie bespreking gester. Klik om ster te ontdoen.';
$string['clicktounlockdiscussion'] = 'Klik om hierdie bespreking te ontsluit.';
$string['clicktounsubscribe'] = 'Jy is ingeteken vir hierdie bespreking. Klik om intekening te ontdoen.';
$string['close'] = 'Sluit';
$string['closegrader'] = 'Sluit beoordelaar';
$string['completiondetail:discussions'] = 'Begin besprekings: {$a}';
$string['completiondetail:posts'] = 'Maak forumplasings: {$a}';
$string['completiondetail:replies'] = 'Plasingresponse: {$a}';
$string['completiondiscussions'] = 'Student moet besprekings skep:';
$string['completiondiscussionsdesc'] = 'Student moet ten minste {$a} bespreking(s) skep';
$string['completiondiscussionsgroup'] = 'Vereis besprekings';
$string['completiondiscussionshelp'] = 'vereis besprekings om te voltooi';
$string['completionposts'] = 'Student moet besprekings of antwoorde plaas:';
$string['completionpostsdesc'] = 'Student moet ten minste {$a} bespreking(s) of antwoord/antwoorde plaas';
$string['completionpostsgroup'] = 'Vereis plasings';
$string['completionpostshelp'] = 'vereis besprekings of antwoorde om te voltooi';
$string['completionreplies'] = 'Student moet antwoorde plaas:';
$string['completionrepliesdesc'] = 'Student moet ten minste {$a} antwoord/antwoorde plaas';
$string['completionrepliesgroup'] = 'Vereis antwoorde';
$string['completionreplieshelp'] = 'vereis antwoorde om te voltooi';
$string['configcleanreadtime'] = 'Die uur van die dag waarop ou plasings vanuit die "gelees"-tabel verwyder moet word';
$string['configdigestmailtime'] = 'Mense wat verkies dat hul e-pos in bondelvorm gestuur moet word, sal die bondel daagliks ontvang. Hierdie instelling beheer die tyd van die dag waarop daaglikse pos gestuur word (die volgende cron wat ná hierdie uur loop, sal dit stuur).';
$string['configdisplaymode'] = 'Die verstekvertoonmodus vir besprekings indien een nie gestel is nie.';
$string['configenablerssfeeds'] = 'Hierdie skakel sal RSS-voere vir alle forums moontlik maak. Jy sal steeds die voere handmatig in die instellings vir elke forum moet aanskakel.';
$string['configenabletimedposts'] = 'Stel op "ja" as wil hê dat vertoontydperke gewys moet word wanneer \'n nuwe forumbespreking geplaas word.';
$string['configlongpost'] = 'Enige plasing bó hierdie lengte (in karakters, HTML uitgesluit) word as lank geag. Plasings wat op die webwerf se voorblad, kursusblaaie in sosiale formaat of as gebruikerprofiele gewys word, word verkort ten einde \'n natuurlike breek êrens tussen die forum_shortpost- en forum_longpost-waardes te skep.';
$string['configmanydiscussions'] = 'Maksimum getal besprekings wat in \'n forum per blad gewys moet word';
$string['configmaxattachments'] = 'Maksimum aantal aanhangsels wat by verstek per plasing toegelaat word';
$string['configmaxbytes'] = 'Maksimum grootte by verstek vir alle forumaanhangsels op die webwerf (onderworpe aan kursusperke en ander plaaslike instellings)';
$string['configoldpostdays'] = 'Getal dae waarna ou plasings as gelees beskou word';
$string['configreplytouser'] = 'Wanneer \'n forumplasing per e-pos versend word, moet dit die gebruiker se e-posadres bevat sodat ontvangers persoonlik eerder as via die forum kan respondeer? Selfs al is dit op "Ja" gestel, kan gebruikers in hul profiel kies om hul e-posadresse geheim te hou.';
$string['configrssarticlesdefault'] = 'Indien RSS-voere geaktiveer is, stel die verstekaantal artikels (hetsy besprekings of plasings).';
$string['configrsstypedefault'] = 'Indien RSS-voere geaktiveer is, stel die verstekaktiwiteitstipe.';
$string['configshortpost'] = 'Enige plasing onder hierdie lengte (in karakters, HTML uitgesluit) word as kort beskou (sien hieronder).';
$string['configsubscriptiontype'] = 'Verstekinstelling vir inskrywingsmodus';
$string['configtrackingtype'] = 'Verstekinstelling vir leesvolging';
$string['configtrackreadposts'] = 'Stel op "ja" as jy gelees/ongelees vir ellke gebruiker wil volg.';
$string['configusermarksread'] = 'Indien "ja", moet die gebruiker die plasing handmatig as gelees merk. Indien "nee", word die plasing, wanneer dit bekyk word, as gelees gemerk.';
$string['confirmsubscribe'] = 'Wil jy regtig vir hierdie forum \'{$a}\' inteken?';
$string['confirmsubscribediscussion'] = 'Wil jy regtig inteken vir bespreking \'{$a->discussion}\' in forum \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Wil jy regtig jou intekening vir forum \'{$a}\' ontdoen?';
$string['confirmunsubscribediscussion'] = 'Wil jy regtig jou intekening vir bespreking \'{$a->discussion}\' in forum \'{$a->forum}\' ontdoen?';
$string['couldnotadd'] = 'Kon nie jou plasing weens \'n onbekende fout byvoeg nie.';
$string['couldnotdeletereplies'] = 'Jammer, daardie kan nie geskrap word nie omdat mense reeds daarop gereageer het.';
$string['couldnotupdate'] = 'Kon nie jou plasing weens \'n onbekende fout bywerk nie.';
$string['created'] = 'Geskep';
$string['crontask'] = 'Forumpos- en -instandhoudingstakies';
$string['cutoffdate'] = 'Afsnydatum';
$string['cutoffdate_help'] = 'Indien gestel, sal die forum nie plasings ná hierdie datum aanvaar nie.';
$string['cutoffdatereached'] = 'Die afsnydatum vir plasings op hierdie forum is bereik, so jy kan nie meer daarop plaas nie.';
$string['cutoffdatevalidation'] = 'Die afsnydatum kan nie vroeër as die keerdatum wees nie.';
$string['delete'] = 'Skrap';
$string['deleteddiscussion'] = 'Die besprekingsonderwerp is geskrap';
$string['deletedpost'] = 'Die plasing is geskrap';
$string['deletedposts'] = 'Daardie plasings is geskrap';
$string['deleteduser'] = 'Skrap gebruiker';
$string['deletesure'] = 'Is jy seker jy wil hierdie plasing skrap?';
$string['deletesureplural'] = 'Is jy seker jy wil hierdie plasing en alle antwoorde skrap? ({$a} plasings)';
$string['digestmailheader'] = 'Hierdie is jou daaglikse bondel nuwe plasings vanaf die {$a->sitename}-forums. Om jou verstekvoorkeure vir forume-pos te verander, gaan na {$a->userprefs}.';
$string['digestmailpost'] = 'Verander jou voorkeure vir forumbondels';
$string['digestmailpostlink'] = 'Verander jou voorkeure vir forumbondels: {$a}';
$string['digestmailprefs'] = 'jou gebruikersprofiel';
$string['digestmailsubject'] = '{$a}: forumbondel';
$string['digestmailtime'] = 'Uur waarop bondel-e-pos gestuur moet word';
$string['digestsentusers'] = 'E-posbondels suksesvol gestuur na {$a} gebruikers.';
$string['disallowsubscribe'] = 'Inskrywings nie toegelaat nie';
$string['disallowsubscribeteacher'] = 'Inskrywings nie toegelaat nie (onderwysers uitgesonder)';
$string['disallowsubscription'] = 'Inskrywing';
$string['disallowsubscription_help'] = 'Hierdie forum is só gekonfigureer dat jy nie vir besprekings kan inteken nie.';
$string['discussion'] = 'Bespreking';
$string['discussionlistsortbycreatedasc'] = 'Orden volgens datum geskep in stygende volgorde';
$string['discussionlistsortbycreateddesc'] = 'Orden volgens datum geskep in dalende volgorde';
$string['discussionlistsortbydiscussionasc'] = 'Orden volgens besprekingsnaam in stygende volgorde';
$string['discussionlistsortbydiscussiondesc'] = 'Orden volgens besprekingsnaam in dalende volgorde';
$string['discussionlistsortbygroupasc'] = 'Orden volgens groep in stygende volgorde';
$string['discussionlistsortbygroupdesc'] = 'Orden volgens groep in dalende volgorde';
$string['discussionlistsortbylastpostasc'] = 'Orden volgens datum waarop laaste plasing geskep is in stygende volgorde';
$string['discussionlistsortbylastpostdesc'] = 'Orden volgens datum waarop laaste plasing geskep is in dalende volgorde';
$string['discussionlistsortbyrepliesasc'] = 'Orden volgens aantal antwoorde in stygende volgorde';
$string['discussionlistsortbyrepliesdesc'] = 'Orden volgens aantal antwoorde in dalende volgorde';
$string['discussionlistsortbystarterasc'] = 'Orden volgens naam van persoon wat bespreking begin het in stygende volgorde';
$string['discussionlistsortbystarterdesc'] = 'Orden volgens naam van persoon wat bespreking begin het in dalende volgorde';
$string['discussionlocked'] = 'Hierdie bespreking is gesluit, dus kan jy nie meer daarop antwoord nie.';
$string['discussionlockingdisabled'] = 'Moenie besprekings sluit nie';
$string['discussionlockingheader'] = 'Sluit van besprekings';
$string['discussionmoved'] = 'Hierdie bespreking is verskuif na \'{$a}\'.';
$string['discussionmovedpost'] = 'Hierdie bespreking is hierheen verskuif: <a href="{$a->discusshref}"></a> in die forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Bespreking se naam';
$string['discussionnownotsubscribed'] = '{$a->name} sal NIE in kennis gestel word van nuwe plasings in \'{$a->discussion}\' van \'{$a->forum}\' nie';
$string['discussionnowsubscribed'] = '{$a->name} sal in kennis gestel word van nuwe plasings in \'{$a->discussion}\' van \'{$a->forum}\'';
$string['discussionpin'] = 'Pen';
$string['discussionpinned'] = 'Gepen';
$string['discussionpinned_help'] = 'Gepende besprekings sal bo-aan \'n forum verskyn.';
$string['discussions'] = 'Besprekings';
$string['discussionsplit'] = 'Bespreking is verdeel';
$string['discussionsstartedby'] = 'Besprekings begin deur {$a}';
$string['discussionsstartedbyrecent'] = 'Besprekings onlangs begin deur {$a}';
$string['discussionsstartedbyuserincourse'] = 'Besprekings begin deur {$a->fullname} in {$a->coursename}';
$string['discussionstartedby'] = 'Bespreking begin deur {$a}';
$string['discussionsubscribed'] = 'Jy is nie vir hierdie bespreking ingeteken nie.';
$string['discussionsubscribestart'] = 'Stel my in kennis van nuwe plasings in hierdie bespreking';
$string['discussionsubscribestop'] = 'Ek wil nie in kennis gestel word van nuwe plasings in hierdie bespreking nie';
$string['discussionsubscription'] = 'Inskrywing vir bespreking';
$string['discussionsubscription_help'] = 'Intekening vir \'n bespreking beteken dat jy in kennis gestel sal word van nuwe plasings in daardie bespreking.';
$string['discussionunpin'] = 'Ontdoen pen';
$string['discussionunsubscribed'] = 'Jou intekening vir hierdie forum is nou ontdoen.';
$string['discussthistopic'] = 'Bespreek hierdie onderwerp';
$string['discusstopicname'] = 'Bespreek die onderwerp: {$a}';
$string['displayend'] = 'Wys tot';
$string['displayend_help'] = 'Hierdie instelling spesifiseer of \'n forumplasing ná \'n sekere datum verberg moet word. Let daarop dat administrateurs deurentyd forumplasings kan bekyk.';
$string['displayenddate'] = 'Wys tot: {$a}.';
$string['displaymode'] = 'Vertoonmodus';
$string['displayperiod'] = 'Vertoontydperk';
$string['displaystart'] = 'Wys vanaf';
$string['displaystart_help'] = 'Hierdie instelling spesifiseer of \'n forumplasing vanaf \'n sekere datum gewys moet word. Let daarop dat administrateurs deurentyd forumplasings kan bekyk.';
$string['displaystartdate'] = 'Wys vanaf: {$a}.';
$string['displaywordcount'] = 'Wys woordtelling';
$string['displaywordcount_help'] = 'Hierdie instelling spesifiseer of die woordtelling van elke plasing gewys moet word of nie.';
$string['duedate'] = 'Keerdatum';
$string['duedate_help'] = 'Teen wanneer plasings op die forum moet geskied. Alhoewel hierdie datum in die kalender as die keerdatum vir die forum gewys word, sal plasings steeds ná hierdie datum toegelaat word. Stel \'n forumafsnydatum om plasings op die forum ná \'n sekere datum te verhoed.';
$string['duedatetodisplayincalendar'] = 'Keerdatum wat in kalender gewys moet word';
$string['eachuserforum'] = 'Elke persoon plaas een bespreking';
$string['edit'] = 'Redigeer';
$string['editedby'] = 'Geredigeer deur {$a->name} - oorspronklike indiening {$a->date}';
$string['editedpostupdated'] = '{$a} se plasing is bygewerk';
$string['editing'] = 'Redigering';
$string['emaildigestcompleteshort'] = 'Handel plasings af';
$string['emaildigestdefault'] = 'Verstek ({$a})';
$string['emaildigestoffshort'] = 'Geen bondel nie';
$string['emaildigestsubjectsshort'] = 'Slegs onderwerpe';
$string['emaildigesttype'] = 'Opsies vir e-posbondels';
$string['emaildigesttype_help'] = 'Die tipe kennisgewings wat jy vir elke forum sal ontvang.

* Verstek - volg die bondelinstelling soos aangetref in jou gebruikerprofiel. As jy jou profiel bywerk, sal daardie wysiging ook hier gewys word;
* Geen bondel nie - jy sal een e-pos per forumplasing ontvang;
* Bondel - volledige plasings - jy sal een gebondelde e-pos per dag ontvang wat die volledige inhoud van elke forumplasing bevat;
* Bondel - slegs onderwerp - jy sal een gebondelde e-pos per dag ontvang wat slegs die onderwerp van elke forumplasing bevat.';
$string['emptymessage'] = 'Iets het skeef geloof met jou plasing. Miskien het jy dit leeg gelaat, of die aanhangsel was te groot. Jou veranderings is NIE gestoor  nie.';
$string['errorcannotlock'] = 'Jy het nie toestemming om besprekings te sluit nie.';
$string['erroremptymessage'] = 'Plasingsboodskap kan nie leeg wees nie.';
$string['erroremptysubject'] = 'Plasingsonderwerp kan nie leeg wees nie.';
$string['errorenrolmentrequired'] = 'Jy moet vir hierdie kursus ingeskryf wees om toegang tot hierdie inhoud te verkry.';
$string['errorwhiledelete'] = 'Iets het skeefgeloop met die skrap van \'n rekord.';
$string['eventassessableuploaded'] = 'Inhoud is geplaas.';
$string['eventcoursesearched'] = 'Kursus gesoek';
$string['eventdiscussioncreated'] = 'Bespreking geskep';
$string['eventdiscussiondeleted'] = 'Bespreking geskrap';
$string['eventdiscussionmoved'] = 'Bespreking verskuif';
$string['eventdiscussionpinned'] = 'Bespreking gepen';
$string['eventdiscussionsubscriptioncreated'] = 'Besprekingsinskrywing geskep';
$string['eventdiscussionsubscriptiondeleted'] = 'Besprekingsinskrywing geskrap';
$string['eventdiscussionunpinned'] = 'Bespreking nie meer gepen nie';
$string['eventdiscussionupdated'] = 'Bespreking bygewerk';
$string['eventdiscussionviewed'] = 'Bespreking bekyk';
$string['eventpostcreated'] = 'Plasing geskep';
$string['eventpostdeleted'] = 'Plasing geskrap';
$string['eventpostupdated'] = 'Plasing bygewerk';
$string['eventreadtrackingdisabled'] = 'Leesvolging gedeaktiveer';
$string['eventreadtrackingenabled'] = 'Leesvolging geaktiveer';
$string['eventsubscribersviewed'] = 'Intekenare bekyk';
$string['eventsubscriptioncreated'] = 'Inskrywing geskep';
$string['eventsubscriptiondeleted'] = 'Inskrywing geskrap';
$string['eventuserreportviewed'] = 'Gebruikersverslag bekyk';
$string['everyonecanchoose'] = 'Almal kan kies om in te teken';
$string['everyonecannowchoose'] = 'Almal kan nou kies om in te teken';
$string['everyoneisnowsubscribed'] = 'Almal is nou ingeteken vir hierdie forum';
$string['everyoneissubscribed'] = 'Almal is ingeteken vir hierdie forum';
$string['existingsubscribers'] = 'Bestaande intekenare';
$string['export'] = 'Eksporteer';
$string['exportattachmentname'] = 'Eksporteer aanhangsel {$a} na portefeulje';
$string['exportdiscussion'] = 'Eksporteer bespreking in geheel na portefeulje';
$string['exporthumandates'] = 'Datums wat deur mense gelees kan word';
$string['exporthumandates_help'] = 'Of datums geëksporteer moet word in \'n formaat wat deur mense gelees kan word of as \'n tydstempel (ry syfers).';
$string['exportoptions'] = 'Eksporteer opsies';
$string['exportstriphtml'] = 'Verwyder HTML';
$string['exportstriphtml_help'] = 'Of HTML-merkers soos p en br uit die plasingsboodskap op die forum verwyder moet word';
$string['favourites'] = 'Gester';
$string['favouriteupdated'] = 'Jou sterretjie-opsies is bygewerk.';
$string['firstpost'] = 'Eerste plasing';
$string['forcedreadtracking'] = 'Laat geforseerde leesvolging toe';
$string['forcedreadtracking_desc'] = 'Maak dit moontlik om forums as geforseerde leesvolging te stel. Dit sal tot gevolg hê dat sommige gebruikers se werksverrigting afneem, veral in kursusse met baie forums en plasings. Indien afgeskakel, sal enige forums wat voorheen as Geforseer gestel is, as opsioneel behartig word.';
$string['forcesubscribed'] = 'Hierdie forum forseer almal om in te teken.';
$string['forcesubscribed_help'] = 'Hierdie forum is só gekonfigureer dat jy nie jou intekening vir besprekings kan ontdoen nie.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Voeg \'n nuwe forum by';
$string['forum:addnews'] = 'Voeg aankondigings by';
$string['forum:addquestion'] = 'Voeg vraag by';
$string['forum:allowforcesubscribe'] = 'Laat geforseerde intekening toe';
$string['forum:canoverridecutoff'] = 'Plasing op forums ná hierdie afsnydatum';
$string['forum:canoverridediscussionlock'] = 'Antwoord op besprekings wat gesluit is';
$string['forum:canposttomygroups'] = 'Plaas vir alle groepe wat toegang het tot';
$string['forum:cantogglefavourite'] = 'Ster besprekings';
$string['forum:createattachment'] = 'Skep aanhangsels';
$string['forum:deleteanypost'] = 'Skrap enige plasings (wanneer ook al)';
$string['forum:deleteownpost'] = 'Skrap eie plasings (sonder keerdatum)';
$string['forum:editanypost'] = 'Redigeer enige plasing';
$string['forum:exportdiscussion'] = 'Eksporteer bespreking in geheel';
$string['forum:exportforum'] = 'Eksporteer forum';
$string['forum:exportownpost'] = 'Eksporteer eie plasing';
$string['forum:exportpost'] = 'Eksporteer plasing';
$string['forum:grade'] = 'Bepunt forum';
$string['forum:managesubscriptions'] = 'Bestuur intekenare';
$string['forum:movediscussions'] = 'Verskuif besprekings';
$string['forum:pindiscussions'] = 'Pen besprekings';
$string['forum:postprivatereply'] = 'Respondeer privaat op plasings';
$string['forum:postwithoutthrottling'] = 'Vrygestel van plasingsdrempel';
$string['forum:rate'] = 'Beoordeel plasings';
$string['forum:readprivatereplies'] = 'Bekyk private response';
$string['forum:replynews'] = 'Respondeer op aankondigings';
$string['forum:replypost'] = 'Respondeer op plasings';
$string['forum:splitdiscussions'] = 'Verdeel besprekings';
$string['forum:startdiscussion'] = 'Begin nuwe besprekings';
$string['forum:viewallratings'] = 'Bekyk alle onverwerkte beoordelings deur individue';
$string['forum:viewanyrating'] = 'Bekyk totale beoordelings wat enigeen ontvang het';
$string['forum:viewdiscussion'] = 'Bekyk besprekings';
$string['forum:viewhiddentimedposts'] = 'Bekyk verborge gereëlde plasings';
$string['forum:viewqandawithoutposting'] = 'Sien altyd V-en-A-plasings';
$string['forum:viewrating'] = 'Bekyk die totale beoordeling wat jy ontvang het';
$string['forum:viewsubscribers'] = 'Bekyk intekenare';
$string['forumauthorhidden'] = 'Outeur (verberg)';
$string['forumblockingalmosttoomanyposts'] = 'Jy nader die drempel vir plasings. Jy het {$a->numposts} kere in die afgelope {$a->blockperiod} geplaas en die perk is {$a->blockafter} plasings.';
$string['forumbodydeleted'] = 'Die inhoud van hierdie forumplasing is verwyder en is nie meer toeganklik nie.';
$string['forumbodyhidden'] = 'Hierdie plasing kan nie deur jou bekyk word nie, waarskynlik omdat jy nie in die bespreking geplaas het nie, omdat die maksimum redigeringstyd nog nie verstryk het nie, die bespreking nog nie begin het nie of omdat die bespreking verstryk het.';
$string['forumgrader'] = 'Forumbepunter';
$string['forumgradingnavigation'] = 'Navigasie van forumbepunting';
$string['forumgradingpanel'] = 'Forumbepuntingspaneel';
$string['forumintro'] = 'Beskrywing';
$string['forumname'] = 'Naam van forum';
$string['forumposts'] = 'Forumplasings';
$string['forums'] = 'Forums';
$string['forumsubjectdeleted'] = 'Hierdie forumplasing is verwyder';
$string['forumsubjecthidden'] = 'Onderwerp (verberg)';
$string['forumtracked'] = 'Ongelese plasings word gevolg';
$string['forumtrackednot'] = 'Ongelese plasings word nie gevolg nie';
$string['forumtype'] = 'Forumtipe';
$string['forumtype_help'] = 'Daar is 5 forumtipes:

*\'n Eenvoudige bespreking - \'n Ekele besprekingsonderwerp waarom almal kan antwoord (kan nie met afsonderlike groepe gebruik word nie)
*Elke persoon plaas een bespreking - Elke student kan presies een nuwe besprekingsonderwerp plaas waarop almal kan antwoord
* V-en-A-forum - Studente moet eers hul eie perspektiewe plaas voordat ander studente se plasings bekyk kan word
* Standaardforum wat in \'n formaat soortgelyk aan \'n blog gewys word - \'n Oop forum waar enigeen op enige tydstip \'n nuwe bespreking kan begin en waarin besprekingsonderwerpe  op een blad met "Bespreek hierdie onderwerp"-skakels gewys word
*Standaardforum vir algemene gebruik -   \'n Oop forum waar enigeen op enige tydstip \'n nuwe bespreking kan begin';
$string['generalforum'] = 'Standaardforum vir algemene gebruik';
$string['generalforums'] = 'Algemene forums';
$string['grade_forum_header'] = 'Bepunting van forum in geheel';
$string['grade_forum_name'] = 'Forum in geheel';
$string['grade_forum_title'] = 'Punt';
$string['grade_rating_name'] = 'Aanslag';
$string['graded'] = 'Bepunt';
$string['gradedby'] = 'Bepunt deur';
$string['gradeforrating'] = 'Punt vir aanslag: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Punt vir beoordeling verberg';
$string['gradeforwholeforum'] = 'Punt vir forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Punt vir forum verberg';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = '{$a->name} beoordeling';
$string['gradeitemnameforwholeforum'] = '{$a->name} forum in geheel';
$string['grades:gradesavedfor'] = 'Punt gestoor vir {$a->fullname}';
$string['grades:gradesavefailed'] = 'Kon nie punt vir {$a->fullname} stoor nie: {$a->error}';
$string['gradeusers'] = 'Bepunt gebruikers';
$string['grading'] = 'Bepunting';
$string['gradingstatus'] = 'Puntstatus:';
$string['hiddenforumpost'] = 'Verbergde forumplasing';
$string['hidegraderpanel'] = 'Verberg bepunterpaneel';
$string['hidepreviousrepliescount'] = 'Verberg vorige antwoorde ({$a}';
$string['hideusersearch'] = 'Verberg gebruikersoektog';
$string['indexoutoftotal'] = '{$a->index} van {$a->total}';
$string['indicator:cognitivedepth'] = 'Forum kognitief';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanwyser is gegrond op die kognitiewe diepte wat die student in \'n forumaktiwiteit behaal het.';
$string['indicator:cognitivedepthdef'] = 'Forum kognitief';
$string['indicator:cognitivedepthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die kognitiewe betrokkenheid bereik wat deur die forumaktiwiteite aangebied word (Vlakke = Nie bekyk nie, Bekyk, Ingedien, Terugvoer bekyk, Kommentaar op terugvoer, Herindiening ná terugvoer bekyk is)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Forum sosiaal';
$string['indicator:socialbreadth_help'] = 'Hierdie aanwyser is gegrond op die sosiale omvang wat deur die student in \'n forumaktiwiteit bereik is.';
$string['indicator:socialbreadthdef'] = 'Forum sosiaal';
$string['indicator:socialbreadthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die sosiale betrokkenheid bereik wat deur die forumaktiwiteite aangebied word (Vlakke = Geen deelname nie, Slegs deelnemer, Deelnemer saam met ander)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'in {$a}';
$string['inreplyto'] = 'In antwoord op {$a}';
$string['introblog'] = 'Die plasings in hierdie forum is outomaties hierheen gekopieer vanaf gebruikers in hierdie kursus se blogs omdat daardie blog-inskrywings nie meer beskikbaar is nie.';
$string['intronews'] = 'Algemene nuus en kennisgewings';
$string['introsocial'] = '\'n Oop forum waar jy na hartelus oor enigiets kan klets';
$string['introteacher'] = '\'n Forum net vir onderwysers se notas en besprekings';
$string['invalidaccess'] = 'Toegang tot hierdie blad is nie korrek verkry nie';
$string['invaliddigestsetting'] = '\'n Ongeldige instelling vir \'n e-posbondel is verskaf';
$string['invaliddiscussionid'] = 'Bespreking-ID is verkeerd of bestaan nie meer nie';
$string['invalidforcesubscribe'] = 'Ongeldige "forseer inskrywing"-modus';
$string['invalidforumid'] = 'Forum-ID is verkeerd';
$string['invalidparentpostid'] = 'Die ID van die voorsaatplasing is verkeerd';
$string['invalidpostid'] = 'Ongeldige plasing-ID - {$a}';
$string['lastpost'] = 'Laaste plasing';
$string['learningforums'] = 'Leerforums';
$string['lockdiscussion'] = 'Sluit hierdie bespreking';
$string['lockdiscussionafter'] = 'Sluit besprekings ná \'n tydperk van onaktiwiteit';
$string['lockdiscussionafter_help'] = 'Besprekings kan outomaties gesluit word nadat \'n gespesifiseerde tyd sedert die laaste respons verloop het.

Gebruikers met die vermoë om te respondeer op besprekings wat gesluit is, kan \'n bespreking ontsluit deur daarop te antwoord.';
$string['locked'] = 'Gesluit';
$string['lockupdated'] = 'Die sluitopsie is bygewerk.';
$string['longpost'] = 'Long plasing';
$string['mailnow'] = 'Stuur kennisgewings oor forumplasings sonder tydvertraging vir redigering';
$string['managesubscriptionsoff'] = 'Voltooi inskrywingbestuur';
$string['managesubscriptionson'] = 'Bestuur intekenare';
$string['manydiscussions'] = 'Besprekings per blad';
$string['markalldread'] = 'Merk alle plasings in hierdie bespreking as gelees.';
$string['markallread'] = 'Merk alle plasings in hierdie forum as gelees.';
$string['markasread'] = 'Merk as gelees';
$string['markasreadonnotification'] = 'Wanneer kennisgewings oor forumplasings gestuur word';
$string['markasreadonnotification_help'] = 'Wanneer jy kennis van \'n forumplasing kry, kan jy kies of dit die plasing as gelees moet merk vir die doeleindes van forumvolging.';
$string['markasreadonnotificationno'] = 'Moenie die plasing as gelees merk nie';
$string['markasreadonnotificationyes'] = 'Merk die plasing as gelees';
$string['markread'] = 'Merk as gelees';
$string['markreadbutton'] = 'Merk<br />as gelees';
$string['markunread'] = 'Merk as ongelees';
$string['markunreadbutton'] = 'Merk<br />ongelees';
$string['maxattachments'] = 'Maksimum aantal aanhangsels';
$string['maxattachments_help'] = 'Hierdie instelling spesifiseer die maksimum aantal lêers wat by \'n forumplasing aangeheg kan word.';
$string['maxattachmentsize'] = 'Maksimum grootte van aanhangsel';
$string['maxattachmentsize_help'] = 'Hierdie instelling spesifiseer die maksimum grootte van \'n lêer wat by \'n forumplasing aangeheg kan word.';
$string['maxtimehaspassed'] = 'Jammer, maar die maksimum tyd vir redigering van hierdie plasing ({$a}) het verstryk!';
$string['message'] = 'Boodskap';
$string['messageinboundattachmentdisallowed'] = 'Kon nie jou respons plaas nie omdat dit \'n aanhangsel insluit en die forum nie aanhangsels toelaat nie.';
$string['messageinboundfilecountexceeded'] = 'Kon nie jou respons plaas nie omdat dit meer as die maksimum aantal toegelate aanhangsels vir die forum bevat ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Kon nie jou respons plaas nie aangesien die totale grootte van die aanhangsel ({$a->filesize}) groter is as die maksimum grootte wat vir die forum toegelaat word ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Kon nie jou respons plaas nie aangesien die forum tans nie beskikbaar is nie.';
$string['messageinboundnopostforum'] = 'Kon nie jou respons plaas nie aangesien jy nie toestemming het om in die {$a->forum->name} -forum te plaas nie.';
$string['messageinboundthresholdhit'] = 'Kon nie jou respons plaas nie. Jy het die plasingsdrempel vir hierdie forum oorskry.';
$string['messageprovider:digests'] = 'Forumbondels waarvoor ingeteken is';
$string['messageprovider:posts'] = 'Forumplasings waarvoor ingeteken is';
$string['missingsearchterms'] = 'Die volgende soekterme kom slegs in die HTML-markering van hierdie boodskap voor:';
$string['modeflatnewestfirst'] = 'Wys antwoorde plat, met nuutste eerste';
$string['modeflatoldestfirst'] = 'Wys antwoorde plat, met oudste eerste';
$string['modenested'] = 'Wys antwoorde in geneste vorm';
$string['modenestedv2'] = 'Wys antwoorde in eksperimentele geneste vorm';
$string['modethreaded'] = 'Wys antwoorde in gerygde vorm';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Die forumaktiwiteitsmodule stel deelnemers in staat om a-sinchroniese besprekings te voer, d.w.s. besprekings wat oor \'n lang tydperk plaasvind.

Daar is verskillende soorte forums om van te kies, soos \'n standaardforum waar almal te eniger tyd \'n nuwe bespreking kan begin; \'n forum waar elke student net een bespreking kan plaas; of \'n vraag-en-antwoord-forum waar deelnemers eers \'n plasing moet maak voordat hulle ander se plasings kan sien. \'n Onderwyser kan toelaat dat lêers aan forumplasings aangeheg word. Aangehegte prente word in die forum vertoon.

Deelnemers kan inteken op \'n forum om kennisgewings oor nuwe forumplasings te ontvang. \'n Onderwyser kan die intekeningmodus instel op opsioneel, gedwonge of outomaties, of sonder enige intekeninge . Indien nodig, kan studente geblokkeer word om meer as \'n gegewe aantal plasings in \'n bepaalde tydperk te plaas; dit kan voorkom dat individue besprekings oorheers.

Forumplasings kan deur onderwysers of deelnemers beoordeel word (portuurevaluering). Punte kan saamgevoeg word om \'n finale punt te vorm wat in die punteboek aangeteken word.

Forums het baie gebruike, soos

* \'n Sosiale ruimte vir studente om mekaar te leer ken
* Vir kursusaankondigings (gebruik \'n nuusforum met gedwonge intekening)
* Vir die bespreking van kursusinhoud of leesmateriaal
* Om aanlyn voort te gaan met \'n kwessie wat voorheen in \'n persoonlike sessie geopper is
* Vir besprekings slegs vir onderwysers (gebruik \'n verborge forum)
* \'n Hulpsentrum waar tutors en studente raad kan gee
* \'n Een-tot-een-ondersteuningsgebied vir privaat student-onderwyser-kommunikasie (gebruik \'n forum met aparte groepe en met een student per groep)
* Vir uitbreidingsaktiwiteite, byvoorbeeld \'dinkskrums\' waarin studente kan nadink en oplossings voorstel';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forums';
$string['more'] = 'meer';
$string['movedmarker'] = '(Verskuif)';
$string['movethisdiscussionlabel'] = 'Verskuif die huidige bespreking na die gespesifiseerde forum';
$string['movethisdiscussionto'] = 'Verskuif hierdie bespreking na ...';
$string['mustprovidediscussionorpost'] = 'Om te eksporteer, moet jy óf \'n bespreking-ID óf plasing-ID verskaf.';
$string['myprofileotherdis'] = 'Forumbesprekings';
$string['myprofileowndis'] = 'My forumbesprekings';
$string['myprofileownpost'] = 'My forumplasings';
$string['namenews'] = 'Aankondigings';
$string['namenews_help'] = 'Die kursusaankondigingsforum is \'n spesiale forum vir aankondigings en word outomaties geskep wanneer \'n kursus geskep word. \'n Kursus kan slegs een aankondigingsforum hê. Slegs onderwysers en administrateurs kan aankondigings plaas. Die "Jongste aankondigings"-blok sal onlangse aankondigings wys.';
$string['namesocial'] = 'Sosiale forum';
$string['nameteacher'] = 'Onderwyserforum';
$string['newforumposts'] = 'Nuwe forumplasings';
$string['nextdiscussiona'] = 'Volgende bespreking: {$a}';
$string['nextuser'] = 'Stoor veranderings en gaan aan na die volgende gebruiker';
$string['noattachments'] = 'Daar is geen aanhangsels vir hierdie plasing nie';
$string['nodiscussions'] = 'Daar is nog geen besprekingsonderwerpe in hierdie forum nie';
$string['nodiscussionsstartedby'] = '{$a} het nog geen besprekings begin nie';
$string['nodiscussionsstartedbyyou'] = 'Jy het nog nie enige besprekings begin nie';
$string['noguestpost'] = 'Jammer, gaste word nie toegelaat om te plaas nie.';
$string['noguestsubscribe'] = 'Jammer, gaste word nie toegelaat om in te teken nie.';
$string['noguesttracking'] = 'Jammer, gaste word nie toegelaat om volgingsopsies te stel nie.';
$string['nomorepostscontaining'] = 'Geen verdere plasings wat \'{$a}\' bevat, gevind nie';
$string['nonews'] = 'Nog geen aankondigings geplaas nie.';
$string['noonecansubscribenow'] = 'Intekening word nou geweier';
$string['nopermissiontosubscribe'] = 'Jy het nie toestemming om forumintekenare te bekyk nie';
$string['nopermissiontoview'] = 'Jy het nie toestemming om hierdie plasing te bekyk nie';
$string['nopostforum'] = 'Jammer, jy word nie toegelaat om op hierdie forum te plaas nie';
$string['noposts'] = 'Geen plasings nie';
$string['nopostsmadebyuser'] = 'Geen plasings deur {$a} nie';
$string['nopostsmadebyyou'] = 'Jy het geen plasings gemaak nie';
$string['noquestions'] = 'Daar is nog geen vrae in hierdie forum nie';
$string['nosubscribers'] = 'Daar is nog geen intekenare vir hierdie forum nie';
$string['notexists'] = 'Bespreking bestaan nie meer nie';
$string['notgraded'] = 'Nog nie bepunt nie';
$string['nothingnew'] = 'Niks nuuts vir {$a} nie';
$string['notingroup'] = 'Jammer, maar jy moet deel van \'n groep wees om hierdie forum te sien.';
$string['notinstalled'] = 'Die forummodule is nie geïnstalleer nie';
$string['notlocked'] = 'Sluit';
$string['notpartofdiscussion'] = 'Hierdie plasing is nie deel van \'n bespreking nie!';
$string['notrackforum'] = 'Moenie ongelese plasings volg nie';
$string['notsubscribed'] = 'Teken in';
$string['nousersmatch'] = 'Geen gebruiker(s) vir gegewe kriteria gevind nie';
$string['noviewdiscussionspermission'] = 'Jy het nie toestemming om besprekings in hierdie forum te bekyk nie';
$string['nowallsubscribed'] = 'Jy is nou vir alle forums in {$a} ingeteken.';
$string['nowallunsubscribed'] = 'Jou intekening vir alle forums in {$a} is nou ontdoen.';
$string['nowgradinguser'] = 'Bepunt tans {$a}';
$string['nownotsubscribed'] = '{$a->name} sal NIE in kennis gestel word van nuwe plasings in \'{$a->forum}\' nie';
$string['nownottracking'] = '{$a->name} volg nie meer \'{$a->forum}\' nie.';
$string['nowsubscribed'] = '{$a->name} sal in kennis gestel word van nuwe plasings in \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} volg nou \'{$a->forum}\'.';
$string['numberofreplies'] = 'Getal antwoorde: {$a}';
$string['numposts'] = '{$a} plasings';
$string['olderdiscussions'] = 'Ouer besprekings';
$string['oldertopics'] = 'Ouer onderwerpe';
$string['oldpostdays'] = 'Lees ná dae';
$string['page-mod-forum-discuss'] = 'Blad wat draad van bespreking in forummodule wys';
$string['page-mod-forum-view'] = 'Forummodule se hoofblad';
$string['page-mod-forum-x'] = 'Enige blad van forummodule';
$string['parent'] = 'Wys voorsaat';
$string['parentofthispost'] = 'Voorsaat van hierdie plasing';
$string['permalink'] = 'Permalink';
$string['permanentlinktoparentpost'] = 'Permanente skakel na die voorsaat van hierdie plasing';
$string['permanentlinktopost'] = 'Permanente skakel na hierdie plasing';
$string['pindiscussion'] = 'Pen hierdie bespreking';
$string['pinupdated'] = 'Die pen-opsie is bygewerk.';
$string['pluginadministration'] = 'Forumadministrasie';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Jou plasing is suksesvol bygevoeg.</p> <p>Jy het {$a} om dit te redigeer as jy enige veranderings wil aanbring.</p>';
$string['postaddedsuccess'] = 'Jou plasing is suksesvol bygevoeg.';
$string['postaddedtimeleft'] = 'Jy het {$a} om dit te redigeer as jy enige veranderings wil aanbring.';
$string['postbymailsuccess'] = 'Jou antwoord "{$a->subject}" is suksesvol geplaas: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Jou antwoord <a href="{$a->discussionurl}">{$a->subject}</a> is suksesvol geplaas.';
$string['postbyuser'] = '{$a->post} deur {$a->user}';
$string['postincontext'] = 'Bekyk hierdie plasing in konteks';
$string['postisprivatereply'] = 'Hierdie is \'n private antwoord. Dit is nie sigbaar vir ander deelnemers nie.';
$string['postmailinfolink'] = 'Hierdie is \'n afskrif van \'n boodskap wat in {$a->coursename} geplaas is.

Om te antwoord, klik op hierdie skakel: {$a->replylink}';
$string['postmailnow'] = '<p>Hierdie plasing sal onmiddellik per e-pos versend word na alle forumintekenare.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Meestal eiesoortige kennis';
$string['postrating2'] = 'Eiesoortig en verbonde';
$string['postrating3'] = 'Meestal verbonde kennis';
$string['posts'] = 'Plasings';
$string['postsfrom'] = 'Plasings vanaf';
$string['postsmadebyuser'] = 'Plasings gemaak deur {$a}';
$string['postsmadebyuserincourse'] = 'Plasings gemaak deur {$a->fullname} in {$a->coursename}';
$string['poststo'] = 'Plasings na';
$string['posttoforum'] = 'Gepos na forum';
$string['posttomygroups'] = 'Pos \'n kopie aan alle groepe';
$string['posttomygroups_help'] = 'Pos \'n kopie van hierdie boodskap aan alle groepe waartoe jy toegang het. Deelnemers in groepe waartoe jy nie toegang het nie, sal nie hierdie plasing sien nie.';
$string['postupdated'] = 'Jou plasing is bygewerk';
$string['potentialsubscribers'] = 'Potensiele intekenare';
$string['prevdiscussiona'] = 'Vorige bespreking: {$a}';
$string['previoususer'] = 'Stoor veranderings en gaan na die vorige gebruiker';
$string['privacy:digesttypenone'] = 'Ons hou nie enige data wat betrekking  het op die tipe bondel wat vir hierdie forum verkies word nie.';
$string['privacy:digesttypepreference'] = 'Jy het gekies om die volgende tipe forumbondel te ontvang: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Jy het die volgende voorkeur vir intekening op besprekings in hierdie forum gekies: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Hierdie forum maak gebruik van die beoordelingsubstelsel om die beoordeling van plasings te ondersteun.';
$string['privacy:metadata:core_tag'] = 'Hierdie forum maak gebruik van die merksubstelsel om die merk van plasings te ondersteun.';
$string['privacy:metadata:forum_digests'] = 'Inligting oor die bondelvoorkeure vir elke forum';
$string['privacy:metadata:forum_digests:forum'] = 'Die forum waarvoor ingeteken is.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Die bondelvoorkeur';
$string['privacy:metadata:forum_digests:userid'] = 'Die ID van die gebruiker met die bondelvoorkeur';
$string['privacy:metadata:forum_discussion_subs'] = 'Inligting oor die inskrywings vir individuele forumbesprekings.';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Die ID van die besprekings waarvoor ingeteken is.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Die aanvangstyd van die inskrywing';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Die ID van die gebruiker met die besprekingintekening';
$string['privacy:metadata:forum_discussions'] = 'Inligting oor die individuele forumbespreking wat deur \'n gebruiker geskep is';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - wat word in hierdie veld gestoor?';
$string['privacy:metadata:forum_discussions:name'] = 'Die naam van die bespreking, soos deur die outeur gekies';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Die tyd toe die bespreking laas gewysig is';
$string['privacy:metadata:forum_discussions:userid'] = 'Die ID van die gebruiker wat die bespreking geskep het';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Die ID van die gebruiker wat die bespreking laas op een of ander wyse gewysig het';
$string['privacy:metadata:forum_grades'] = 'Bepunt data vir die forum';
$string['privacy:metadata:forum_grades:forum'] = 'Die forum wat bepunt is';
$string['privacy:metadata:forum_grades:grade'] = 'Die punt wat toegeken is';
$string['privacy:metadata:forum_grades:userid'] = 'Die gebruiker wat bepunt is';
$string['privacy:metadata:forum_posts'] = 'Inligting oor die bondelvoorkeure vir elke forum';
$string['privacy:metadata:forum_posts:created'] = 'Die tyd toe die plasing geskep is';
$string['privacy:metadata:forum_posts:discussion'] = 'Die bespreking waarin die plasing is';
$string['privacy:metadata:forum_posts:message'] = 'Die boodskap van die forumplasing';
$string['privacy:metadata:forum_posts:modified'] = 'Die tyd toe die plasing laas gewysig is';
$string['privacy:metadata:forum_posts:parent'] = 'Die voorsaatplasing waarop geantwoord is';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Die ID van die gebruiker aan wie hierdie antwoord gestuur is';
$string['privacy:metadata:forum_posts:subject'] = 'Die onderwerp van die forumplasing';
$string['privacy:metadata:forum_posts:totalscore'] = 'Die forumplasing se boodskap';
$string['privacy:metadata:forum_posts:userid'] = 'Die ID van die gebruiker wat die forumplasing geskryf het';
$string['privacy:metadata:forum_queue'] = 'Tydelike log van plasings wat in bondelvorm gepos sal word';
$string['privacy:metadata:forum_queue:discussionid'] = 'Forumbespreking-ID';
$string['privacy:metadata:forum_queue:postid'] = 'Forumplasing-ID';
$string['privacy:metadata:forum_queue:timemodified'] = 'Die gewysigde tyd van die oorspronklike plasing';
$string['privacy:metadata:forum_queue:userid'] = 'Gebruiker wat kennis van hierdie plasing moet neem';
$string['privacy:metadata:forum_read'] = 'Inligting oor watter plasings deur die gebruiker gelees is';
$string['privacy:metadata:forum_read:discussionid'] = 'Die bespreking waarin die plasing is';
$string['privacy:metadata:forum_read:firstread'] = 'Die eerste keer toe die plasing gelees is';
$string['privacy:metadata:forum_read:lastread'] = 'Die mees onlangse tyd toe die plasing gelees is';
$string['privacy:metadata:forum_read:postid'] = 'Die plasing wat gelees is';
$string['privacy:metadata:forum_read:userid'] = 'Die ID van die gebruiker waarop hierdie rekord betrekking het';
$string['privacy:metadata:forum_subscriptions'] = 'Inligting oor die forums waarvoor die gebruiker ingeteken het';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Die forum waarvoor ingeteken is';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Die ID van die gebruiker waarop hierdie foruminskrywing betrekking het';
$string['privacy:metadata:forum_track_prefs'] = 'Inligting oor in welke forums die gebruiker gekies het om gelese plasings te volg';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Die forum waarin leesopvolging geaktiveer is';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Die ID van die gebruiker waarop hierdie voorkeur vir forumvolging betrekking het';
$string['privacy:metadata:preference:autosubscribe'] = 'Of ingeteken moet word op besprekings wanneer daar op plasings in hulle geantwoord word';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Die voorkeurvolgorde waarvolgens die besprekingslys georden moet word';
$string['privacy:metadata:preference:maildigest'] = 'Die voorkeurstelling vir gebondelde pos wat vir die hele webwerf geld';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Of forumplasings as gelees gemerk moet word wanneer hulle as boodskappe ontvang word';
$string['privacy:metadata:preference:trackforums'] = 'Of leesvolging geaktiveer moet word';
$string['privacy:postwasread'] = 'Hierdie plasing is die eerste keer gelees op {$a->firstread} en is mees onlangs gelees op {$a->lastread}.';
$string['privacy:readtrackingdisabled'] = 'Jy het gekies om nie plasings te volg wat deur jou in hierdie forum gelees is nie.';
$string['privacy:request:delete:discussion:name'] = 'Skrap op versoek van die outeur';
$string['privacy:request:delete:post:message'] = 'Die inhoud van hierdie plasing is geskrap op versoek van die outeur.';
$string['privacy:request:delete:post:subject'] = 'Skrap op versoek van die outeur';
$string['privacy:subscribedtoforum'] = 'Jy is vir hierdie forum ingeteken.';
$string['privatereply'] = 'Antwoord privaat';
$string['privatereply_help'] = '\'n Private antwoord kan slegs bekyk word deur die outeur van die plasing waarop gerespondeer word, en deur gebruikers met die vermoë om private antwoorde te bekyk.';
$string['processingdigest'] = 'Bewerk tans e-posbondel vir gebruiker {$a}';
$string['processingpost'] = 'Bewerk tans plasing {$a}';
$string['prune'] = 'Verdeel';
$string['prunedpost'] = '\'n Nuwe bespreking voortspruitend uit daardie plasing is geskep.';
$string['pruneheading'] = 'Verdeel die bespreking en verskuif hierdie plasing na \'n nuwe bespreking.';
$string['qandaforum'] = 'V-en-A-forum';
$string['qandanotify'] = 'Hierdie is \'n vraag-en-antwoordforum. Om ander response op hierdie vrae te sien, moet jy eers jou antwoord plaas.';
$string['re'] = 'Insake:';
$string['readtherest'] = 'Lees die res van hierdie onderwerp';
$string['removeallforumtags'] = 'Verwyder alle forummerkers';
$string['removefromfavourites'] = 'Ontster hierdie bespreking';
$string['replies'] = 'Antwoorde';
$string['repliesmany'] = '{$a} antwoorde tot dusver';
$string['repliesone'] = '{$a} antwoord tot dusver';
$string['reply'] = 'Antwoord';
$string['reply_handler'] = 'Antwoord op forumplasings via e-pos';
$string['reply_handler_name'] = 'Antwoord op forumplasings';
$string['replyauthorself'] = '{$a} (jy)';
$string['replyforum'] = 'Antwoord op forum';
$string['replyingtoauthor'] = 'Antwoord tans {$a}...';
$string['replyplaceholder'] = 'Skryf jou antwoord...';
$string['replytopostbyemail'] = 'Jy kan via e-pos hierop antwoord';
$string['replytouser'] = 'Gebruik e-pos adres in antwoord op';
$string['resetdigests'] = 'Skrap alle per-gebruiker-voorkeure vir forumbondels';
$string['resetforums'] = 'Skrap alle plasings van';
$string['resetforumsall'] = 'Skrap alle plasings';
$string['resetsubscriptions'] = 'Skrap alle foruminskrywings';
$string['resettrackprefs'] = 'Skrap alle voorkeure vir forumvolging';
$string['rssarticles'] = 'Getal onlangse RSS-artikels';
$string['rssarticles_help'] = 'Hierdie instelling spesifiseer die getal artikels (óf besprekings óf plasings) wat by die RSS-voer ingesluit moet word. Tussen 5 en 20 is oor die algemeen aanvaarbaar.';
$string['rsssubscriberssdiscussions'] = 'RSS-voer van besprekings';
$string['rsssubscriberssposts'] = 'RSS-voer van plasings';
$string['rsstype'] = 'RSS-voer vir hierdie aktiwiteit';
$string['rsstype_help'] = 'Om die RSS-voer vir hierdie aktiwiteit te aktiveer, kies óf besprekings óf plasings wat by die voer ingesluit moet word.';
$string['rsstypedefault'] = 'Tipe RSS-voer';
$string['search'] = 'Soek';
$string['search:activity'] = 'Forum - aktiwiteitinligting';
$string['search:post'] = 'Forum - plasings';
$string['searchdatefrom'] = 'Plasings moet meer onlangs as hierdie wees';
$string['searchdateto'] = 'Plasings moet ouer as hierdie wees';
$string['searchforumintro'] = 'Tik asseblief soekvoorwaardes in een of meer van die volgende velde:';
$string['searchforums'] = 'Deursoek forums';
$string['searchfullwords'] = 'Hierdie woorde moet in geheel wys';
$string['searchnotwords'] = 'Hierdie woorde moet NIE ingesluit word nie';
$string['searcholderposts'] = 'Deursoek ouer plasings...';
$string['searchphrase'] = 'Hierdie presiese frase moet in die plasing verskyn';
$string['searchresults'] = 'Deursoek resultate';
$string['searchsubject'] = 'Hierdie woorde moet in die onderwerp wees';
$string['searchtags'] = 'Is gemerk met';
$string['searchuser'] = 'Hierdie naam moet by outeur pas';
$string['searchuserid'] = 'Die Moodle-ID van die outeur';
$string['searchusers'] = 'Deursoek gebruikers';
$string['searchwhichforums'] = 'Kies watter forums om te deursoek';
$string['searchwords'] = 'Hierdie woorde kan op enige plek in die plasing verskyn';
$string['seeallposts'] = 'Sien alles wat deur hierdie gebruiker geplaas is';
$string['sendstudentnotificationsdefault'] = 'Verstekinstelling vir "Stel studente in kennis"';
$string['sendstudentnotificationsdefault_help'] = 'Stel die verstekwaarde vir die "Stel studente in kennis"-merkblokkie op die bepuntingsvorm.';
$string['sendstudentnotificationsno'] = 'Nee';
$string['sendstudentnotificationsyes'] = 'Ja, stuur kennisgewing aan student';
$string['settings'] = 'Instellings';
$string['shortpost'] = 'Kort plasing';
$string['showgraderpanel'] = 'Wys nasienerpaneel';
$string['showingcountoftotaldiscussions'] = 'Lys van besprekings. Wys {$a->count} van {$a->total} besprekings';
$string['showmoreusers'] = 'Wys meer gebruikers';
$string['showpreviousrepliescount'] = 'Wys vorige antwoorde ({$a})';
$string['showsubscribers'] = 'Wys/redigeer huidige intekenare';
$string['showusersearch'] = 'Wys gebruikersoektog';
$string['singleforum'] = '\'n Enkele eenvoudige bespreking';
$string['smallmessage'] = '{$a->user} het \'n plasing in {$a->forumname} gemaak';
$string['smallmessagedigest'] = 'Forumbondel wat {$a} boodskappe bevat';
$string['starredonly'] = 'Soektog het slegs besprekings gester';
$string['startedby'] = 'Begin deur';
$string['subject'] = 'Onderwerp';
$string['subscribe'] = 'Teken in vir hierdie forum';
$string['subscribeall'] = 'Teken almal vir hierdie forum in';
$string['subscribed'] = 'Ingeteken';
$string['subscribediscussion'] = 'Teken in vir hierdie bespreking';
$string['subscribeenrolledonly'] = 'Jammer, slegs ingeskrewe gebruikers word toegelaat om in te teken vir kennisgewings oor plasings op die forum.';
$string['subscribenone'] = 'Ontdoen almal se intekening vir hierdie forum';
$string['subscribers'] = 'Intekenare';
$string['subscriberstowithcount'] = 'Intekenare vir "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Stel my in kennis van nuwe plasings in hierdie forum';
$string['subscribestop'] = 'Ek wil nie in kennis gestel word van nuwe plasings in hierdie forum nie';
$string['subscription'] = 'Intekening';
$string['subscription_help'] = 'As jy vir \'n forum ingeteken is, beteken dit jy kennis gegee sal word van nuwe forumplasings. Gewoonlik kan jy kies of jy ingeteken wil wees, maar soms word intekening geforseer sodat almal kennisgewings ontvang.';
$string['subscriptionandtracking'] = 'Intekening en volging';
$string['subscriptionauto'] = 'Outo-inskrywing';
$string['subscriptiondisabled'] = 'Inskrywing gedeaktiveer';
$string['subscriptionforced'] = 'Geforseerde inskrywing';
$string['subscriptionmode'] = 'Inskrywingsmodus';
$string['subscriptionmode_help'] = 'Wanneer \'n deelnemer vir \'n forum ingeteken is, beteken dit dat hulle kennis gegee sal word van forumplasings. Daar kan uit 4 modusopsies vir intekening gekies word:

* Opsionele intekening - Deelnemer kan kies om in te teken al dan nie
* Geforseerde intekening - Almal word ingeteken en kan nie intekening ontdoen nie
* Outo-intekening - Almal word aanvanklik ingeteken maar kan kies om hul intekening op enige tydstip te ontdoen
* Intekening versper - intekening word nie toegelaat nie';
$string['subscriptionoptional'] = 'Opsionele inskrywing';
$string['subscriptions'] = 'Inskrywings';
$string['tagarea_forum_posts'] = 'Forumplasings';
$string['tagsdeleted'] = 'Forummerkers is geskrap';
$string['thisforumhasduedate'] = 'Die keerdatum vir plasing op hierdie forum is {$a}.';
$string['thisforumisdue'] = 'Die keerdatum vir plasing op hierdie forum was {$a}.';
$string['thisforumisthrottled'] = 'Hierdie forum het \'n beperkte aantal forumplasings wat jy in \'n gegewe tydperk kan maak - dit is tans gestel op {$a->blockafter} plasing(s) binne {$a->blockperiod}';
$string['timed'] = 'Gereël';
$string['timeddiscussion'] = 'Gereëlde bespreking';
$string['timedhidden'] = 'Gereëlde status: Verberg vir studente';
$string['timedposts'] = 'Gereëlde plasings';
$string['timedvisible'] = 'Gereëlde status: Sigbaar vir alle gebruikers';
$string['timestartenderror'] = 'Die einddatum wat gewys word, kan die vroeër as die begindatum wees nie';
$string['togglediscussionmenu'] = 'Skakel besprekingkieslys aan/af';
$string['togglefullscreen'] = 'Skakel volskerm aan/af';
$string['togglesettingsdrawer'] = 'Skakel instellingslaai aan/af';
$string['trackforum'] = 'Volg ongelese plasings';
$string['tracking'] = 'Volg';
$string['trackingoff'] = 'Afgeskakel';
$string['trackingon'] = 'Geforseer';
$string['trackingoptional'] = 'Opsioneel';
$string['trackingtype'] = 'Leesvolging';
$string['trackingtype_help'] = 'Leesvolging maak dit vir deelnemers moontlik om te kyk watter plasings hulle nog nie gesien het nie deur enige nuwe plasings uit te lig.

Indien op opsioneel gestel, kan deelnemers kies of hulle volging aan of af wil skakel via \'n skakel in die aksiekieslys of administrasieblok, afhangende van die tema. (Gebruikers moet ook forumvolging in hul forumvoorkeure aktiveer.)

As "Laat geforseerde leesvolging toe" in die webwerfadministrasie geaktiveer is, sal \'n verdere opsie - geforseer - beskikbaar wees. Dit beteken dat volging altyd aangeskakel is, ongeag gebruikers se forumvoorkeure.';
$string['trackreadposts_header'] = 'Forumvolging';
$string['unlockdiscussion'] = 'Ontsluit hier bespreking';
$string['unpindiscussion'] = 'Ontpen hierdie bespreking';
$string['unread'] = 'Ongelees';
$string['unreadpost'] = 'Ongelese plasing';
$string['unreadposts'] = 'Ongelese plasings';
$string['unreadpostsnumber'] = '{$a} ongelese plasings';
$string['unreadpostsone'] = '1 ongelese plasing';
$string['unsubscribe'] = 'Ontdoen intekening vir hierdie forum';
$string['unsubscribeall'] = 'Ontdoen intekening vir alle forums';
$string['unsubscribeallconfirm'] = 'Jy is tans ingeteken vir {$a->forums} forums, en {$a->discussions} besprekings. Wil jy regtig jou intekening vir alle forums en besprekings ontdoen en outo-intekening vir besprekings ontdoen?';
$string['unsubscribeallconfirmdiscussions'] = 'Jy is tans ingeteken vir {$a->discussions} besprekings. Wil jy regtig jou intekening vir alle besprekings ontdoen en outo-intekening vir besprekings ontdoen?';
$string['unsubscribeallconfirmforums'] = 'Jy is tans ingeteken vir {$a->forums}  forums. Wil jy regtig jou intekening vir alle forums ontdoen en outo-intekening versper?';
$string['unsubscribealldone'] = 'Alle opsionele forumintekenings is verwyder. Jy sal steeds kennisgewings vanaf forums met geforseerde intekening ontvang. Om forumkennisgewings te bestuur, gaan na "Boodskappe" in "My profiel"-instellings.';
$string['unsubscribeallempty'] = 'Jy is nie vir enige forums ingeteken nie. Om alle kennisgewings vanaf hierdie bediener te versper, gaan na "Boodskappe" in "My profiel"-instellings.';
$string['unsubscribed'] = 'Intekening ontdoen';
$string['unsubscribediscussion'] = 'Ontdoen intekening vir hierdie bespreking';
$string['unsubscribediscussionlink'] = 'Ontdoen intekening vir hierdie bespreking: {$a}';
$string['unsubscribelink'] = 'Ontdoen intekening vir hierdie forum: {$a}';
$string['unsubscribeshort'] = 'Ontdoen intekening';
$string['useexperimentalui'] = 'Gebruik eksperimentele geneste besprekingsaansig';
$string['usermarksread'] = 'Handmatige merk van gelese boodskappe';
$string['usernavigation'] = 'Gebruikernavigasie';
$string['usersforumposts'] = 'Gebruiker se forumplasings';
$string['viewalldiscussions'] = 'Bekyk alle besprekings';
$string['viewconversation'] = 'Bekyk bespreking';
$string['viewgrades'] = 'Bekyk punte';
$string['viewparentpost'] = 'Bekyk voorsaatplasing';
$string['viewthediscussion'] = 'Bekyk die bespreking';
$string['warnafter'] = 'Plasingsdrempel vir waarskuwing';
$string['warnafter_help'] = 'Studente kan gewaarsku word wanneer hulle die maksimum getal toegelate plasings binne \'n gegewe tydperk nader. Hierdie instelling bepaal na hoeveel plasings hulle gewaarsku word. Gebruikers met die vermoë  mod/forum:postwithoutthrottling word vrygestel van perke op plasings.';
$string['warnformorepost'] = 'Waarskuwing! Daar is meer as een bespreking in hierdie forum - gebruik die mees onlangse';
$string['yournewquestion'] = 'Jou nuwe vraag';
$string['yournewtopic'] = 'Jou nuwe besprekingsonderwerp';
$string['yourreply'] = 'Jou antwoord';
