<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_preg', language 'af', version '4.1'.
 *
 * @package     qtype_preg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_leaf_control'] = '';
$string['answerno'] = 'Antwoord {$a}';
$string['answersinstruct'] = '<p>Voer (minstens een) reguliere uitdrukkings in die gekose notasie as antwoord(e) in. As \'n korrekte antwoord gegee word, behoort dit by minstens een reguliere uitdrukking te pas met 100% punttoekenning.</p><p>Jy kan plekhouers soos {$0} in die terugvoer gebruik om vasgelegde dele van \'n student se antwoord in te voeg. {$0} sal vervang word deur die hele passende deel, {$1} met die eerste subpatroonpassing, ens. As die gekose enjin nie subpatroonvaslegging ondersteun nie, behoort jy slegs {$0} te gebruik.</p>';
$string['any_leaf_control'] = '';
$string['anycrlf_leaf_control'] = '';
$string['approximatematch'] = 'Tikfoutopsporing';
$string['approximatematch_help'] = 'Tikfoutopsporing verskaf passing sonder sensitiwiteit vir sommige fouttellings. As die passer foute teëkom, word passing gedeeltelik.';
$string['assertfailmodeasis'] = 'Vinnig';
$string['assertfailmodedescription'] = 'Volmodus laat die eindigetoestand-outomata-enjin 100% korrek werk met eenvoudige bewerings en laat ondersteuning van komplekse bewerings toe, maar werk ongeveer twee maal stadiger as die vinnige modus. Vinnige modus kan selde \'n verkeerde wenk in komplekse regex\'e met \\b of \\B bewerings oplewer.';
$string['assertfailmodelabel'] = 'Beweringsondersteuningsmodus';
$string['assertfailmodemerge'] = 'Vol';
$string['authoring_form_charset_flags'] = 'ware betekenis (verenigde formaat)';
$string['authoring_form_charset_mode'] = 'Vertoon modus vir komplekse karakterklasse:';
$string['authoring_form_charset_userinscription'] = 'soos geskryf in reguliere uitdrukkings';
$string['authoring_form_check_strings'] = 'Kontroleer die string(e)';
$string['authoring_form_edit_header'] = 'Reguliere uitdrukking';
$string['authoring_form_edit_header_help'] = 'Voer jou regex hier in. Jy sal ooreenstemmende sintaksisboom, verklarende grafiek en beskrywing sien. Kliek "Berg veranderinge" om veranderinge in die regex aan te bring.';
$string['authoring_form_graph_build'] = 'Die grafiek word gebou ...';
$string['authoring_form_options_header'] = 'Ooreenstemmende opsies';
$string['authoring_form_options_header_help'] = 'Hier kan jy die ooreenstemming stel. Hierdie opsies sal in die vraagwysigingsvorm geberg word.';
$string['authoring_form_page_header'] = 'Regex-bouer';
$string['authoring_form_rect_selection_mode'] = 'Reghoekseleksiemodus';
$string['authoring_form_rect_selection_select'] = 'Kies';
$string['authoring_form_testing_header'] = 'Reguliere uitdrukking-toetsing';
$string['authoring_form_testing_header_help'] = 'Hier kan jy stringe (een per lyn) invoer om jou regex te toets. Nadat jy "Kontroleer die string(e)" gekliek het, sal jy resultate op regterhand sien: ooreenstemmende dele is groen, nie-ooreenstemmende dele is rooi. \'n Ikoon dui aan of die gegewe string met die hele regex ooreengestem het (groen regmerkie) of nie (rooi kruis).';
$string['authoring_form_testing_textarea'] = 'Voer stringe in om te pas (een per lyn)';
$string['authoring_form_text'] = 'Voer jou regex hier in:';
$string['authoring_form_tooltip'] = 'Maak regex-bouer oop';
$string['authoring_form_tree_build'] = 'Die boom word gebou ...';
$string['backref_intersection'] = 'Die gebruik van terugverwysings met bewerings word nog nie ondersteun nie.';
$string['backreforrecursionforapproximate'] = 'Terugverwysings of rekursie vir passing met tikfoutopsporing';
$string['bsr_anycrlf_leaf_control'] = '';
$string['bsr_unicode_leaf_control'] = '';
$string['c_at_end_of_pattern_node_error'] = 'Sintaksisfout: \\c aan die einde van patroon';
$string['callout_big_number_node_error'] = 'Die getal {$a->addinfo} in die oproep is te groot, dit behoort nie groter as 255 te wees nie';
$string['capital_esc_z_leaf_assert'] = 'einde van die string';
$string['char_code_disallowed_node_error'] = 'Unicode-kodepunte 0xd800 ... 0xdfff word nou toegelaat';
$string['char_code_too_big_node_error'] = 'Die karakterkode {$a->addinfo} is te groot';
$string['charhintpenalty'] = 'Straftoekenning vir die volgende karakterwenk';
$string['charhintpenalty_help'] = 'Straftoekenning vir die verkry van die eenkarakterwenk. Gewoonlik sal dit \'n groter as gewoonlik Moodle-vraagstraftoekenning wees (wat van toepassing is op enige nuwe poging om die vraag sonder wenke te beantwoord). Hierdie straftoekennings is onderling uitsluitend.';
$string['circumflex_leaf_assert'] = 'begin van die string';
$string['collapsed_node'] = 'toegevoude subuitdrukking';
$string['commit_leaf_control'] = '';
$string['condsubexpr_assert_expected_node_error'] = 'Bewering of voorwaarde verwag';
$string['condsubexpr_too_much_alter_node_error'] = 'Sintaksisfout: te veel topvlakveranderinge in die voorwaardelike subpatroonposisie vanaf  {$a->colfirst} na {$a->collast}. Gebruik parentese as jy afwisselings in ja-uitdrukking op nee-uitdrukkings wil insluit.';
$string['condsubexpr_zero_condition_node_error'] = 'Ongeldige voorwaarde (?(0)';
$string['correctanswer'] = 'Korrekte antwoord';
$string['correctanswer_help'] = 'Voer \'n korrekte antwoord in (nie \'n reguliere uitdrukking nie) om aan studente te vertoon. As jy dit leeg laat, sal die passingenjin probeer om self \'n antwoord te genereer, deur daarop te let om die een die naaste aan die student se antwoord te verkry. Tot tyd en wyl kan slegs eindigetoestand-outomataenjin korrekte antwoorde genereer.';
$string['cr_leaf_control'] = '';
$string['crlf_leaf_control'] = '';
$string['cx_should_be_ascii_node_error'] = '\\c behoort deur \'n ascii-karakter gevolg te word';
$string['debugheading'] = 'Ontfoutverstellings';
$string['defaultenginedescription'] = 'Passingenjin by verstek gekies wanneer \'n nuwe vraag geskep word';
$string['defaultenginelabel'] = 'Verstek passingenjin';
$string['defaultlangdescription'] = 'Taal by verstek gekies wanneer \'n nuwe vraag geskep word';
$string['defaultlanglabel'] = 'Verstek taal';
$string['defaultnotationdescription'] = 'Notasie by verstek gekies wanneer \'n nuwe vraag geskep word';
$string['defaultnotationlabel'] = 'Verstek notasie';
$string['define_node_cond_subexpr'] = '"definieer"-kondisionele subpatroon';
$string['description_accept_leaf_control'] = 'dwing suksesvolle subpatroonpassing';
$string['description_any_leaf_control'] = 'nuwereël pas by enige Unicode nuwereël-reeks';
$string['description_anycrlf_leaf_control'] = 'nuwereël pas by reëleinde, reël aanskuif of reëleinde gevolg deur reël aanskuif';
$string['description_bsr_anycrlf_leaf_control'] = '\\R pas by CR, LF, of CRLF';
$string['description_bsr_unicode_leaf_control'] = '\\R pas by enige Unicode nuwereël-reeks';
$string['description_capital_esc_z_leaf_assert'] = 'einde van die string';
$string['description_char'] = '<span class="text-info" class=\'font-family:"Courier New", Courier, monospace;\'>{$a->char}</span>';
$string['description_char0'] = 'Nulkarakter (NUL)';
$string['description_char1'] = 'begin van opskrifkarakter (SOH)';
$string['description_char10'] = 'dataskakelontsnapkarakter (DLE)';
$string['description_char11'] = 'toestelbeheer 1 (oft. XON) karakter (DC1)';
$string['description_char12'] = 'toestelbeheer 2 karakter (DC2)';
$string['description_char13'] = 'toestelbeheer 3 (oft. XOFF) karakter (DC3)';
$string['description_char14'] = 'toestelbeheer 4 karakter (DC4)';
$string['description_char15'] = 'negatiewe erkenningskarakter (NAK)';
$string['description_char16'] = 'sinchrone leegloopkarakter (SYN)';
$string['description_char17'] = 'einde van transmissieblokkarakter (ETB)';
$string['description_char18'] = 'kanselleerkarakter (CAN)';
$string['description_char19'] = 'einde van mediumkarakter (EM)';
$string['description_char1A'] = 'substitusiekarakter (SUB)';
$string['description_char1B'] = 'ontsnap (ESC)';
$string['description_char1C'] = 'dokumentskeierkarakter (FS)';
$string['description_char1D'] = 'groepskeierkarakter (GS)';
$string['description_char1E'] = 'rekordskeierkarakter (RS)';
$string['description_char1F'] = 'eenheidskeierkarakter (US)';
$string['description_char2'] = 'begin-van-tekskarakter (STX)';
$string['description_char20'] = 'spasie';
$string['description_char2002'] = 'en-spasie';
$string['description_char2003'] = 'em-spasie';
$string['description_char2009'] = 'smal spasie';
$string['description_char200C'] = 'nulbreedte niekoppelaar';
$string['description_char200D'] = 'nulbreedte koppelaar';
$string['description_char3'] = 'einde-van-tekskarakter (ETX)';
$string['description_char4'] = 'einde-van-transmissiekarakter (EOT)';
$string['description_char5'] = 'navraagkarakter (ENQ)';
$string['description_char6'] = 'erkenningkarakter (ACK)';
$string['description_char7'] = 'alarmkarakter (BEL)';
$string['description_char7F'] = 'uitwiskarakter (DEL)';
$string['description_char8'] = 'terugspasieerkarakter (BS)';
$string['description_char9'] = 'tabulering (HT)';
$string['description_charA'] = 'reëlaanskuif (LF)';
$string['description_charA0'] = 'niebreekruimte';
$string['description_charAD'] = 'sagtekoppeltekenkarakter';
$string['description_charB'] = 'vertikale tabulering (VT)';
$string['description_charC'] = 'vormvoer (FF)';
$string['description_charD'] = 'reëleindekarakter (CR)';
$string['description_charE'] = 'uitskuifkarakter (SO)';
$string['description_charF'] = 'inskuifkarakter (SI)';
$string['description_char_16value'] = 'karakter met kode 0x{$a->code}';
$string['description_charflag_Arabic'] = 'Arabiese karakter';
$string['description_charflag_Arabic_neg'] = 'nie Arabiese karakter';
$string['description_charflag_Armenian'] = 'Armeense karakter';
$string['description_charflag_Armenian_neg'] = 'nie Armeense karakter';
$string['description_charflag_Avestan'] = 'Avestaankarakter';
$string['description_charflag_Avestan_neg'] = 'nie Avestaankarakter';
$string['description_charflag_Balinese'] = 'Balinese karakter';
$string['description_charflag_Balinese_neg'] = 'nie Balinese karakter';
$string['description_charflag_Bamum'] = 'Bamumkarakter';
$string['description_charflag_Bamum_neg'] = 'nie Bamumkarakter';
$string['description_charflag_Bengali'] = 'Bengaalse karakter';
$string['description_charflag_Bengali_neg'] = 'nie Bengaalse karakter';
$string['description_charflag_Bopomofo'] = 'Bopomofokarakter';
$string['description_charflag_Bopomofo_neg'] = 'nie Bopomofokarakter';
$string['description_charflag_Braille'] = 'Braillekarakter';
$string['description_charflag_Braille_neg'] = 'nie Braillekarakter';
$string['description_charflag_Buginese'] = 'Buginese karakter';
$string['description_charflag_Buginese_neg'] = 'nie Buginese karakter';
$string['description_charflag_Buhid'] = 'Buhidkarakter';
$string['description_charflag_Buhid_neg'] = 'nie Buhidkarakter';
$string['description_charflag_C'] = 'ander Unicode-eiendom';
$string['description_charflag_C_neg'] = 'nie ander Unicode-eiendom';
$string['description_charflag_Canadian_Aboriginal'] = 'Kanadese Aboriginaalkarakter';
$string['description_charflag_Canadian_Aboriginal_neg'] = 'nie Kanadese Aboriginaalkarakter';
$string['description_charflag_Carian'] = 'Kariaanse karakter';
$string['description_charflag_Carian_neg'] = 'nie Kariaanse karakter';
$string['description_charflag_Cc'] = 'beheer';
$string['description_charflag_Cc_neg'] = 'nie beheer';
$string['description_charflag_Cf'] = 'formaat';
$string['description_charflag_Cf_neg'] = 'nie formaat';
$string['description_charflag_Cham'] = 'Chamkarakter';
$string['description_charflag_Cham_neg'] = 'nie Chamkarakter';
$string['description_charflag_Cherokee'] = 'Cherokeekarakter';
$string['description_charflag_Cherokee_neg'] = 'nie Cherokeekarakter';
$string['description_charflag_Cn'] = 'ontoegewys';
$string['description_charflag_Cn_neg'] = 'nie ontoegewys';
$string['description_charflag_Co'] = 'privaat gebruik';
$string['description_charflag_Co_neg'] = 'nie privaat gebruik';
$string['description_charflag_Common'] = 'Gemeenskaplike karakter';
$string['description_charflag_Common_neg'] = 'nie Gemeenskaplike karakter';
$string['description_charflag_Coptic'] = 'Koptiese karakter';
$string['description_charflag_Coptic_neg'] = 'nie Koptiese karakter';
$string['description_charflag_Cs'] = 'surrogaat';
$string['description_charflag_Cs_neg'] = 'nie surrogaat';
$string['description_charflag_Cuneiform'] = 'Spykerskrifkarakter';
$string['description_charflag_Cuneiform_neg'] = 'nie Spykerskrifkarakter';
$string['description_charflag_Cypriot'] = 'Sipriotiese karakter';
$string['description_charflag_Cypriot_neg'] = 'nie Sipriotiese karakter';
$string['description_charflag_Cyrillic'] = 'Cyrilliese karakter';
$string['description_charflag_Cyrillic_neg'] = 'nie Cyrilliese karakter';
$string['description_charflag_Deseret'] = 'Deseretkarakter';
$string['description_charflag_Deseret_neg'] = 'nie Deseretkarakter';
$string['description_charflag_Devanagari'] = 'Devanagarikarakter';
$string['description_charflag_Devanagari_neg'] = 'nie Devanagarikarakter';
$string['description_charflag_Egyptian_Hieroglyphs'] = 'Egiptiese Hiërogliefkarakter';
$string['description_charflag_Egyptian_Hieroglyphs_neg'] = 'nie Egiptiese Hiërogliefkarakter';
$string['description_charflag_Ethiopic'] = 'Etiopiese karakter';
$string['description_charflag_Ethiopic_neg'] = 'nie Etiopiese karakter';
$string['description_charflag_Georgian'] = 'Georgiese karakter';
$string['description_charflag_Georgian_neg'] = 'nie Georgiese karakter';
$string['description_charflag_Glagolitic'] = 'Glagolitiese karakter';
$string['description_charflag_Glagolitic_neg'] = 'nie Glagolitiese karakter';
$string['description_charflag_Gothic'] = 'Gotiese karakter';
$string['description_charflag_Gothic_neg'] = 'nie Gotiese karakter';
$string['description_charflag_Greek'] = 'Griekse karakter';
$string['description_charflag_Greek_neg'] = 'nie Griekse karakter';
$string['description_charflag_Gujarati'] = 'Goedjaratikarakter';
$string['description_charflag_Gujarati_neg'] = 'nie Goedjaratikarakter';
$string['description_charflag_Gurmukhi'] = 'Gurmukhikarakter';
$string['description_charflag_Gurmukhi_neg'] = 'nie Gurmukhikarakter';
$string['description_charflag_Han'] = 'Hankarakter';
$string['description_charflag_Han_neg'] = 'nie Hankarakter';
$string['description_charflag_Hangul'] = 'Hangulkarakter';
$string['description_charflag_Hangul_neg'] = 'nie Hangulkarakter';
$string['description_charflag_Hanunoo'] = 'Hanunookarakter';
$string['description_charflag_Hanunoo_neg'] = 'nie Hanunookarakter';
$string['description_charflag_Hebrew'] = 'Hebreeuse karakter';
$string['description_charflag_Hebrew_neg'] = 'nie Hebreeuse karakter';
$string['description_charflag_Hiragana'] = 'Hiraganakarakter';
$string['description_charflag_Hiragana_neg'] = 'nie Hiraganakarakter';
$string['description_charflag_Imperial_Aramaic'] = 'Imperiese Aramese karakter';
$string['description_charflag_Imperial_Aramaic_neg'] = 'nie Imperiese Aramese karakter';
$string['description_charflag_Inherited'] = 'Geërfde karakter';
$string['description_charflag_Inherited_neg'] = 'nie Geërfde karakter';
$string['description_charflag_Inscriptional_Pahlavi'] = 'Ingeskrewe Pahlavikarakter';
$string['description_charflag_Inscriptional_Pahlavi_neg'] = 'nie Ingeskrewe Pahlavikarakter';
$string['description_charflag_Inscriptional_Parthian'] = 'Ingeskrewe Partiaanse karakter';
$string['description_charflag_Inscriptional_Parthian_neg'] = 'nie Ingeskrewe Partiaanse karakter';
$string['description_charflag_Javanese'] = 'Javaanse karakter';
$string['description_charflag_Javanese_neg'] = 'nie Javaanse karakter';
$string['description_charflag_Kaithi'] = 'Kaithikarakter';
$string['description_charflag_Kaithi_neg'] = 'nie Kaithikarakter';
$string['description_charflag_Kannada'] = 'Kannadakarakter';
$string['description_charflag_Kannada_neg'] = 'nie Kannadakarakter';
$string['description_charflag_Katakana'] = 'Katakanakarakter';
$string['description_charflag_Katakana_neg'] = 'nie Katakanakarakter';
$string['description_charflag_Kayah_Li'] = 'Kaya Li-karakter';
$string['description_charflag_Kayah_Li_neg'] = 'nie Kaya Li-karakter';
$string['description_charflag_Kharoshthi'] = 'Kharoshthikarakter';
$string['description_charflag_Kharoshthi_neg'] = 'nie Kharoshthikarakter';
$string['description_charflag_Khmer'] = 'Khmerkarakter';
$string['description_charflag_Khmer_neg'] = 'nie Khmerkarakter';
$string['description_charflag_L'] = 'letter';
$string['description_charflag_L_neg'] = 'nie letter';
$string['description_charflag_Lao'] = 'Laokarakter';
$string['description_charflag_Lao_neg'] = 'nie Laokarakter';
$string['description_charflag_Latin'] = 'Latynse karakter';
$string['description_charflag_Latin_neg'] = 'nie Latynse karakter';
$string['description_charflag_Lepcha'] = 'Lepchakarakter';
$string['description_charflag_Lepcha_neg'] = 'nie Lepchakarakter';
$string['description_charflag_Limbu'] = 'Limbukarakter';
$string['description_charflag_Limbu_neg'] = 'nie Limbukarakter';
$string['description_charflag_Linear_B'] = 'Lineêre B-karakter';
$string['description_charflag_Linear_B_neg'] = 'nie Lineêre B-karakter';
$string['description_charflag_Lisu'] = 'Lisukarakter';
$string['description_charflag_Lisu_neg'] = 'nie Lisukarakter';
$string['description_charflag_Ll'] = 'kleinletter';
$string['description_charflag_Ll_neg'] = 'nie kleinletter';
$string['description_charflag_Lm'] = 'wysigerletter';
$string['description_charflag_Lm_neg'] = 'nie wysigerletter';
$string['description_charflag_Lo'] = 'ander letter';
$string['description_charflag_Lo_neg'] = 'nie ander letter';
$string['description_charflag_Lt'] = 'titelkasletter';
$string['description_charflag_Lt_neg'] = 'nie titelkasletter';
$string['description_charflag_Lu'] = 'hoofkasletter';
$string['description_charflag_Lu_neg'] = 'nie hoofkasletter';
$string['description_charflag_Lycian'] = 'Lisiaanse karakter';
$string['description_charflag_Lycian_neg'] = 'nie Lisiaanse karakter';
$string['description_charflag_Lydian'] = 'Lidiese karakter';
$string['description_charflag_Lydian_neg'] = 'nie Lidiese karakter';
$string['description_charflag_M'] = 'merk';
$string['description_charflag_M_neg'] = 'nie merk';
$string['description_charflag_Malayalam'] = 'Maleisiese karakter';
$string['description_charflag_Malayalam_neg'] = 'nie Maleisiese karakter';
$string['description_charflag_Mc'] = 'spasiëringsmerk';
$string['description_charflag_Mc_neg'] = 'nie spasiëringsmerk';
$string['description_charflag_Me'] = 'omsluitende merk';
$string['description_charflag_Me_neg'] = 'nie omsluitende merk';
$string['description_charflag_Meetei_Mayek'] = 'Meetei Mayek-karakter';
$string['description_charflag_Meetei_Mayek_neg'] = 'nie Meetei Mayek-karakter';
$string['description_charflag_Mn'] = 'niespasiëringsmerk';
$string['description_charflag_Mn_neg'] = 'nie niespasiëringsmerk';
$string['description_charflag_Mongolian'] = 'Mongoolse karakter';
$string['description_charflag_Mongolian_neg'] = 'nie Mongoolse karakter';
$string['description_charflag_Myanmar'] = 'Mianmarkarakter';
$string['description_charflag_Myanmar_neg'] = 'nie Mianmarkarakter';
$string['description_charflag_N'] = 'getal';
$string['description_charflag_N_neg'] = 'nie getal';
$string['description_charflag_Nd'] = 'desimale getal';
$string['description_charflag_Nd_neg'] = 'nie desimale getal';
$string['description_charflag_New_Tai_Lue'] = 'Nuwe Tai Lue-karakter';
$string['description_charflag_New_Tai_Lue_neg'] = 'nie Nuwe Tai Lue-karakter';
$string['description_charflag_Nko'] = 'Nkokarakter';
$string['description_charflag_Nko_neg'] = 'nie Nkokarakter';
$string['description_charflag_Nl'] = 'letternommer';
$string['description_charflag_Nl_neg'] = 'nie letternommer';
$string['description_charflag_No'] = 'ander nommer';
$string['description_charflag_No_neg'] = 'nie ander nommer';
$string['description_charflag_Ogham'] = 'Oghamkarakter';
$string['description_charflag_Ogham_neg'] = 'nie Oghamkarakter';
$string['description_charflag_Ol_Chiki'] = 'Ol_Chikikarakter';
$string['description_charflag_Ol_Chiki_neg'] = 'nie Ol_Chikikarakter';
$string['description_charflag_Old_Italic'] = 'Ou Italiese karakter';
$string['description_charflag_Old_Italic_neg'] = 'nie Ou Italiese karakter';
$string['description_charflag_Old_Persian'] = 'Ou Persiese karakter';
$string['description_charflag_Old_Persian_neg'] = 'nie Ou Persiese karakter';
$string['description_charflag_Old_South_Arabian'] = 'Ou Suid_Arabiese karakter';
$string['description_charflag_Old_South_Arabian_neg'] = 'nie Ou Suid_Arabiese karakter';
$string['description_charflag_Old_Turkic'] = 'Ou_Turkse karakter';
$string['description_charflag_Old_Turkic_neg'] = 'nie Ou_Turkse karakter';
$string['description_charflag_Oriya'] = 'Oriyakarakter';
$string['description_charflag_Oriya_neg'] = 'nie Oriyakarakter';
$string['description_charflag_Osmanya'] = 'Osmanjakarakter';
$string['description_charflag_Osmanya_neg'] = 'nie Osmanjakarakter';
$string['description_charflag_P'] = 'leestekens';
$string['description_charflag_P_neg'] = 'nie leestekens';
$string['description_charflag_Pc'] = 'verbindingsleestekens';
$string['description_charflag_Pc_neg'] = 'nie verbindingsleestekens';
$string['description_charflag_Pd'] = 'streepleestekens';
$string['description_charflag_Pd_neg'] = 'nie streepleestekens';
$string['description_charflag_Pe'] = 'sluitingsleestekens';
$string['description_charflag_Pe_neg'] = 'nie sluitingsleestekens';
$string['description_charflag_Pf'] = 'finale leestekens';
$string['description_charflag_Pf_neg'] = 'nie finale leestekens';
$string['description_charflag_Phags_Pa'] = 'Phags_Pa-karakter';
$string['description_charflag_Phags_Pa_neg'] = 'nie Phags_Pa-karakter';
$string['description_charflag_Phoenician'] = 'Fenisiese karakter';
$string['description_charflag_Phoenician_neg'] = 'nie Fenisiese karakter';
$string['description_charflag_Pi'] = 'aanvanklike leestekens';
$string['description_charflag_Pi_neg'] = 'nie aanvanklike leestekens';
$string['description_charflag_Po'] = 'ander leestekens';
$string['description_charflag_Po_neg'] = 'nie ander leestekens';
$string['description_charflag_Ps'] = 'oop leestekens';
$string['description_charflag_Ps_neg'] = 'nie oop leestekens';
$string['description_charflag_Rejang'] = 'Rejangkarakter';
$string['description_charflag_Rejang_neg'] = 'nie Rejangkarakter';
$string['description_charflag_Runic'] = 'Runekarakter';
$string['description_charflag_Runic_neg'] = 'nie Runekarakter';
$string['description_charflag_S'] = 'simbool';
$string['description_charflag_S_neg'] = 'nie simbool';
$string['description_charflag_Samaritan'] = 'Samaritaanse karakter';
$string['description_charflag_Samaritan_neg'] = 'nie Samaritaanse karakter';
$string['description_charflag_Saurashtra'] = 'Saurashtrakarakter';
$string['description_charflag_Saurashtra_neg'] = 'nie Saurashtrakarakter';
$string['description_charflag_Sc'] = 'geldeenheidsimbool';
$string['description_charflag_Sc_neg'] = 'nie geldeenheidsimbool';
$string['description_charflag_Shavian'] = 'Shaviankarakter';
$string['description_charflag_Shavian_neg'] = 'nie Shaviankarakter';
$string['description_charflag_Sinhala'] = 'Sinhalakarakter';
$string['description_charflag_Sinhala_neg'] = 'nie Sinhalakarakter';
$string['description_charflag_Sk'] = 'wysigersimbool';
$string['description_charflag_Sk_neg'] = 'nie wysigersimbool';
$string['description_charflag_Sm'] = 'wiskundige simbool';
$string['description_charflag_Sm_neg'] = 'nie wiskundige simbool';
$string['description_charflag_So'] = 'ander simbool';
$string['description_charflag_So_neg'] = 'nie ander simbool';
$string['description_charflag_Sundanese'] = 'Sundanese karakter';
$string['description_charflag_Sundanese_neg'] = 'nie Sundanese karakter';
$string['description_charflag_Syloti_Nagri'] = 'Syloti_Nagri-karakter';
$string['description_charflag_Syloti_Nagri_neg'] = 'nie Syloti_Nagri-karakter';
$string['description_charflag_Syriac'] = 'Siriese karakter';
$string['description_charflag_Syriac_neg'] = 'nie Siriese karakter';
$string['description_charflag_Tagalog'] = 'Tagalogkarakter';
$string['description_charflag_Tagalog_neg'] = 'nie Tagalogkarakter';
$string['description_charflag_Tagbanwa'] = 'Tagbanwakarakter';
$string['description_charflag_Tagbanwa_neg'] = 'nie Tagbanwakarakter';
$string['description_charflag_Tai_Le'] = 'Tai_Le-karakter';
$string['description_charflag_Tai_Le_neg'] = 'nie Tai_Le-karakter';
$string['description_charflag_Tai_Tham'] = 'Tai_Tham-karakter';
$string['description_charflag_Tai_Tham_neg'] = 'nie Tai_Tham-karakter';
$string['description_charflag_Tai_Viet'] = 'Tai_Viet-karakter';
$string['description_charflag_Tai_Viet_neg'] = 'nie Tai_Viet-karakter';
$string['description_charflag_Tamil'] = 'Tamilkarakter';
$string['description_charflag_Tamil_neg'] = 'nie Tamilkarakter';
$string['description_charflag_Telugu'] = 'Telugukarakter';
$string['description_charflag_Telugu_neg'] = 'nie Telugukarakter';
$string['description_charflag_Thaana'] = 'Thaanakarakter';
$string['description_charflag_Thaana_neg'] = 'nie Thaanakarakter';
$string['description_charflag_Thai'] = 'Thaise karakter';
$string['description_charflag_Thai_neg'] = 'nie Thaise karakter';
$string['description_charflag_Tibetan'] = 'Tibettaanse karakter';
$string['description_charflag_Tibetan_neg'] = 'nie Tibettaanse karakter';
$string['description_charflag_Tifinagh'] = 'Tifinagh-karakter';
$string['description_charflag_Tifinagh_neg'] = 'nie Tifinagh-karakter';
$string['description_charflag_Ugaritic'] = 'Ugaritiese karakter';
$string['description_charflag_Ugaritic_neg'] = 'nie Ugaritiese karakter';
$string['description_charflag_Vai'] = 'Vaikarakter';
$string['description_charflag_Vai_neg'] = 'nie Vaikarakter';
$string['description_charflag_Xan'] = 'enige alfanumeriese karakter';
$string['description_charflag_Xan_neg'] = 'nie enige alfanumeriese karakter';
$string['description_charflag_Xps'] = 'enige POSIX-spasiekarakter';
$string['description_charflag_Xps_neg'] = 'nie enige POSIX-spasiekarakter';
$string['description_charflag_Xsp'] = 'enige Perl-spasiekarakter';
$string['description_charflag_Xsp_neg'] = 'nie enige Perl-spasiekarakter';
$string['description_charflag_Xwd'] = 'enige Perl "word" karakter';
$string['description_charflag_Xwd_neg'] = 'nie enige Perl "word" karakter';
$string['description_charflag_Yi'] = 'Yi-karakter';
$string['description_charflag_Yi_neg'] = 'nie Yi-karakter';
$string['description_charflag_Z'] = 'skeier';
$string['description_charflag_Z_neg'] = 'nie skeier';
$string['description_charflag_Zl'] = 'lynskeier';
$string['description_charflag_Zl_neg'] = 'nie lynskeier';
$string['description_charflag_Zp'] = 'paragraafskeier';
$string['description_charflag_Zp_neg'] = 'nie paragraafskeier';
$string['description_charflag_Zs'] = 'spasieskeier';
$string['description_charflag_Zs_neg'] = 'nie spasieskeier';
$string['description_charflag_alnum'] = '\'n letter of syfer';
$string['description_charflag_alnum_neg'] = 'nie \'n letter of nie syfer';
$string['description_charflag_alpha'] = '\'n letter';
$string['description_charflag_alpha_neg'] = 'nie \'n letter';
$string['description_charflag_ascii'] = '\'n karakter met kodes 0-127';
$string['description_charflag_ascii_neg'] = 'nie \'n karakter met kodes 0-127';
$string['description_charflag_blank'] = 'slegs \'n spasie of tabelkeep';
$string['description_charflag_blank_neg'] = 'nie \'n spasie of tabelkeep';
$string['description_charflag_cntrl'] = '\'n beheerkarakter';
$string['description_charflag_cntrl_neg'] = 'nie \'n beheerkarakter';
$string['description_charflag_digit'] = '\'n desimale syfer';
$string['description_charflag_digit_neg'] = 'nie \'n desimale syfer';
$string['description_charflag_dot'] = 'enige karakter';
$string['description_charflag_graph'] = '\'n drukkarakter (spasie uitgesluit)';
$string['description_charflag_graph_neg'] = 'nie \'n drukkarakter (spasie uitgesluit)';
$string['description_charflag_lower'] = '\'n kleinletter';
$string['description_charflag_lower_neg'] = 'nie \'n kleinletter';
$string['description_charflag_print'] = '\'n drukkarakter (spasie ingesluit)';
$string['description_charflag_print_neg'] = 'nie \'n drukkarakter (spasie ingesluit)';
$string['description_charflag_punct'] = '\'n drukkarakter (letters en syfers en spasie uitgesluit)';
$string['description_charflag_punct_neg'] = 'nie \'n drukkarakter (letters en syfers en spasie uitgesluit)';
$string['description_charflag_slashd'] = '\'n desimale syfer';
$string['description_charflag_slashd_neg'] = 'nie \'n desimale syfer';
$string['description_charflag_slashh'] = '\'n horisontale witspasiekarakter';
$string['description_charflag_slashh_neg'] = 'nie \'n horisontale witspasiekarakter';
$string['description_charflag_slashs'] = '\'n witspasie';
$string['description_charflag_slashs_neg'] = 'nie \'n witspasie';
$string['description_charflag_slashv'] = '\'n vertikale witspasiekarakter';
$string['description_charflag_slashv_neg'] = 'nie \'n vertikale witspasiekarakter';
$string['description_charflag_slashw'] = '\'n woordkarakter';
$string['description_charflag_slashw_neg'] = 'nie \'n woordkarakter';
$string['description_charflag_space'] = '\'n witspasie';
$string['description_charflag_space_neg'] = 'nie \'n witspasie';
$string['description_charflag_upper'] = '\'n hoofletter';
$string['description_charflag_upper_neg'] = 'nie \'n hoofletter';
$string['description_charflag_word'] = '\'n woordkarakter';
$string['description_charflag_word_neg'] = 'nie \'n woordkarakter';
$string['description_charflag_xdigit'] = '\'n heksadesimale syfer';
$string['description_charflag_xdigit_neg'] = 'nie \'n heksadesimale syfer';
$string['description_charset'] = 'een van die volgende karakters: {$a->characters};';
$string['description_charset_neg'] = 'enige karakter behalwe die volgende: {$a->characters};';
$string['description_charset_neg_one'] = 'nie {$a->characters}';
$string['description_charset_range'] = 'enige karakter {$a}';
$string['description_circumflex_leaf_assert'] = 'begin van die string';
$string['description_commit_leaf_control'] = 'as die res van die patroon nie ooreenstem nie - algehele mislukking, geen vordering van beginpunt nie';
$string['description_cr_leaf_control'] = 'newline stem slegs ooreen met reëleinde';
$string['description_crlf_leaf_control'] = 'newline stem slegs ooreen met reëleinde gevolg deur reëlaanskuif';
$string['description_define_node_cond_subexpr'] = 'definisie van {$a->firstoperand}';
$string['description_dollar_leaf_assert'] = 'einde van die string';
$string['description_duplicate_node_subexpr'] = 'groepering (herstel groepnommer vir die vaslegging van groepe in elke afwisseling): [ {$a->firstoperand} ]';
$string['description_empty_leaf_meta'] = 'niks';
$string['description_errorafter'] = '</span>';
$string['description_errorbefore'] = '<span style="color:red">';
$string['description_esc_a_leaf_assert'] = 'begin van die string';
$string['description_esc_b_leaf_assert'] = '\'n woordgrens';
$string['description_esc_b_leaf_assert_neg'] = 'nie \'n woordgrens';
$string['description_esc_g_leaf_assert'] = 'eerste ooreenstemmende posisie in die string';
$string['description_fail_leaf_control'] = 'dwing mislukking';
$string['description_grouping_node_subexpr'] = 'groepering: [ {$a->firstoperand} ]';
$string['description_leaf_backref'] = 'teks stem ooreen met subpatroon #{$a}';
$string['description_leaf_backref_name'] = 'teks stem ooreen met subpatroon "{$a}"';
$string['description_leaf_options'] = '{$a}:';
$string['description_leaf_subexpr_call'] = 'oproep van die subpatroon #{$a}';
$string['description_leaf_subexpr_call_all'] = 'oproep van die hele reguliere uitdrukking';
$string['description_leaf_subexpr_call_all_recursive'] = 'rekursiewe oproep van die hele reguliere uitdrukking';
$string['description_leaf_subexpr_call_name'] = 'oproep van die subpatroon "{$a}"';
$string['description_leaf_subexpr_call_name_recursive'] = 'rekursiewe oproep van die subpatroon "{$a}"';
$string['description_leaf_subexpr_call_recursive'] = 'rekursiewe oproep van die subpatroon #{$a}';
$string['description_leaf_template'] = 'templaat sonder parameters';
$string['description_lf_leaf_control'] = 'newline stem slegs met reëlaanskuif ooreen';
$string['description_mark_name_leaf_control'] = 'stel naam op {$a->name} om terug te stuur';
$string['description_nla_node_assert'] = 'verdere teks behoort nie ooreen te stem nie: [{$a->firstoperand}]';
$string['description_nla_node_assert_cond'] = 'verdere teks stem nie ooreen nie: [{$a->firstoperand}]';
$string['description_nlb_node_assert'] = 'voorafgaande teks behoort nie ooreen te stem nie: [{$a->firstoperand}]';
$string['description_nlb_node_assert_cond'] = 'voorafgaande teks stem nie ooreen nie: [{$a->firstoperand}]';
$string['description_no_start_opt_leaf_control'] = 'geen begin-ooreenstemmingoptimisering nie';
$string['description_node_alt'] = '{$a->firstoperand} of {$a->secondoperand}';
$string['description_node_alt_wcomma'] = '{$a->firstoperand} of {$a->secondoperand}';
$string['description_node_concat'] = '{$a->firstoperand} dan {$a->secondoperand}';
$string['description_node_concat_and'] = '{$a->firstoperand} en {$a->secondoperand}';
$string['description_node_concat_short'] = '{$a->firstoperand}{$a->secondoperand}';
$string['description_node_concat_space'] = '{$a->firstoperand} {$a->secondoperand}';
$string['description_node_concat_wcomma'] = '{$a->firstoperand} dan {$a->secondoperand}';
$string['description_node_cond_subexpr'] = 'as {$a->cond} kontroleer dan: [{$a->firstoperand}]{$a->else}';
$string['description_node_cond_subexpr_else'] = 'kontroleer andersins: [{$a->secondoperand}]';
$string['description_node_finite_quant'] = '{$a->firstoperand} herhaal vanaf {$a->leftborder} tot {$a->rightborder} maal {$a->greedy}';
$string['description_node_finite_quant_0'] = '{$a->firstoperand} herhaal nie meer as {$a->rightborder} maal nie of ontbreek {$a->greedy}';
$string['description_node_finite_quant_01'] = '{$a->firstoperand} ontbreek moontlik {$a->greedy}';
$string['description_node_finite_quant_1'] = '{$a->firstoperand} herhaal nie meer as {$a->rightborder} maal nie {$a->greedy}';
$string['description_node_finite_quant_borders_err'] = '(verkeerde kwantifiseerdergrense)';
$string['description_node_finite_quant_strict'] = '{$a->firstoperand} herhaal {$a->leftborder} maal {$a->greedy}';
$string['description_node_infinite_quant'] = '{$a->firstoperand} herhaal minstens {$a->leftborder} maal {$a->greedy}';
$string['description_node_infinite_quant_0'] = '{$a->firstoperand} herhaal enige aantal keer of ontbreek {$a->greedy}';
$string['description_node_infinite_quant_1'] = '{$a->firstoperand} herhaal enige aantal keer {$a->greedy}';
$string['description_node_template'] = 'templaat met parameters';
$string['description_onceonly_node_subexpr'] = 'een maal gekontroleerde subpatroon #{$a->number}: [ {$a->firstoperand} ]';
$string['description_onceonly_node_subexpr_name'] = 'een maal gekontroleerde subpatroon "{$a->name} #{$a->number}": [ {$a->firstoperand} ]';
$string['description_operand'] = 'operand';
$string['description_option_J'] = 'laat duplikaat name toe';
$string['description_option_U'] = 'kwantifiseerders gryp by verstek nie';
$string['description_option_i'] = 'kasloos';
$string['description_option_m'] = 'multilyn ooreenstemming';
$string['description_option_s'] = 'dotmetakarakter stem ooreen \\n';
$string['description_option_x'] = 'witspasies in uitdrukking is geïgnoreer';
$string['description_pla_node_assert'] = 'verdere teks moet ooreenstem met: [{$a->firstoperand}]';
$string['description_pla_node_assert_cond'] = 'verdere teks stem ooreen met: [{$a->firstoperand}]';
$string['description_plb_node_assert'] = 'voorafgaande teks moet ooreenstem met: [{$a->firstoperand}]';
$string['description_plb_node_assert_cond'] = 'voorafgaande teks stem ooreen met: [{$a->firstoperand}]';
$string['description_prune_leaf_control'] = 'as die res van die patroon nie ooreenstem nie - beweeg na volgende beginkarakter';
$string['description_quant_greedy'] = '';
$string['description_quant_lazy'] = '(trae kwantifiseerder)';
$string['description_quant_possessive'] = '(besitlike kwantifiseerder)';
$string['description_range'] = 'van {$a->start} tot {$a->end}';
$string['description_recursion_node_cond_subexpr'] = 'die patroon #{$a->number} is in rekursiewe ooreenstemming';
$string['description_recursion_node_cond_subexpr_all'] = 'die hele patroon is in rekursiewe ooreenstemming';
$string['description_recursion_node_cond_subexpr_name'] = 'die patroon "{$a->name}" is in rekursiewe ooreenstemming';
$string['description_skip_leaf_control'] = 'as die res van die patroon nie ooreenstem nie - beweeg na huidige ooreenstemmende posisie';
$string['description_skip_name_leaf_control'] = 'as die res van die patroon nie ooreenstem nie - beweeg na (*PUNT:{$a})';
$string['description_small_esc_z_leaf_assert'] = 'einde van die string';
$string['description_subexpr_node_cond_subexpr'] = 'die subpatroon #{$a->number} is suksesvol gepas';
$string['description_subexpr_node_cond_subexpr_name'] = 'die subpatroon #{$a->name} is suksesvol gepas';
$string['description_subexpr_node_cond_subexpr_wrapper'] = 'as {$a->cond} kontroleer dan: [{$a->firstoperand}]{$a->else}';
$string['description_subexpr_node_subexpr'] = 'subpatroon #{$a->number}: [ {$a->firstoperand} ]';
$string['description_subexpr_node_subexpr_name'] = 'subpatroon "{$a->name}" #{$a->number}: [ {$a->firstoperand} ]';
$string['description_template_brackets_opt'] = 'teks in blokhakies of daarbuite';
$string['description_template_brackets_req'] = 'teks in blokhakies';
$string['description_template_custom_parens_opt'] = 'teks in opsionele doelgemaakte hakies of daarsonder';
$string['description_template_custom_parens_req'] = 'teks in opsionele doelgemaakte hakies';
$string['description_template_integer'] = 'enige getal insluitend + of -';
$string['description_template_parens_opt'] = 'teks in ronde hakies of daarsonder';
$string['description_template_parens_req'] = 'teks in ronde hakies';
$string['description_template_word'] = 'enige woord';
$string['description_then_leaf_control'] = 'as die res van die patroon nie ooreenstem nie - spoor terug na volgende afwisseling';
$string['description_tool'] = 'Beskrywing';
$string['description_tool_help'] = 'Hier kan jy \'n beskrywing van jou reguliere uitdrukking sien. Deur die nodus van die boom te druk word die ooreenstemmende subgrafiek belig en die ooreenstemmende deel van die beskrywing met \'n geel kleur gemerk.';
$string['description_ucp_leaf_control'] = 'PCRE_UCP';
$string['description_unsetoption_J'] = 'moet nie duplikaat name toelaat nie';
$string['description_unsetoption_U'] = 'kwantifiseerders gryp by verstek';
$string['description_unsetoption_i'] = 'kassensitief';
$string['description_unsetoption_m'] = 'nie multilynooreenstemming';
$string['description_unsetoption_s'] = 'dotmetakarakter stem nie ooreen \\n';
$string['description_unsetoption_x'] = 'witspasies in uitdrukking is nie geïgnoreer nie';
$string['description_utf16_leaf_control'] = 'UTF-16 modus';
$string['description_utf8_leaf_control'] = 'UTF-8 modus';
$string['different_subexpr_names_node_error'] = 'Verskillende subpatroonname vir subpatrone van dieselfde nommer';
$string['dollar_leaf_assert'] = 'einde van die string';
$string['doterror'] = 'Kan nie {$a->name} vir hierdie regex teken nie';
$string['duplicate_subexpr_names_node_error'] = 'Twee benoemde subpatrone het dieselfde naam';
$string['empty_fa'] = 'Geen string kan met hierdie reguliere uitdrukking ooreenstem nie (eindige outomaat is leeg)';
$string['empty_leaf_meta'] = 'leegheid';
$string['engine'] = 'Ooreenstemmende enjin';
$string['engine_heading_descriptions'] = 'Om reguliere uitdrukkings by mekaar te pas, kan tyd en geheue verg. Hierdie verstellings laat jou toe om perke van tyd- en geheuegebruik deur die ooreenstemmingsenjins te stel. Verhoog dit wanneer jy boodskappe ontvang dat die reguliere uitdrukking te kompleks is, maar hou jou bediener se prestasievermoë in gedagte (jy mag moontlik ook die PHP-tyd- en -geheueperke wil verhoog). Verlaag dit as jy \'n blanko bladsy kry wanneer \'n preg-vraag geberg of geloop word.';
$string['engine_help'] = '<p>Daar is geen \'beste\' ooreenstemmingsenjin nie, dus kan jy die enjin kies wat die beste by die spesifieke reguliere uitdrukking pas.</p><p>Moeder <b>PHP-preg-ooreenstemmingsenjin</b> werk met preg_match()-funksie uit PHP-taal. Dit is byna 100% foutvry en kan met volledige PCRE-sintaksis werk, maar kan nie gevorderde funksies ondersteun nie (soos die vertoon van gedeeltelike ooreenstemmings en wenke).</p><p><b>FA-ooreenstemmingsenjin</b> gebruik doelgemaakte ooreenstemmingskode. Dit ondersteun gedeeltelike ooreenstemming en wenke, maar nie lookaround-bewerings nie (jy sal in kennis gestel word wanneer jy \'n vraag probeer berg sonder ondersteunde uitdrukkings) en kan moontlik foute bevat.</p><p>As die verskil tussen enjins vir jou te moeilik is, probeer almal om te sien hoe hul vermoëns aan jou behoeftes voldoen. As een enjin in \'n vraag faal, probeer ander enjins om te sien of hulle dit beter kan hanteer.</p><p>FA-enjin is waarskynlik die beste keuse as jy nie lookaround-bewerings gebruik nie.</p>';
$string['error_PCREincorrectregex'] = 'Verkeerde reguliere uitdrukking - sintaksisfout! Konsulteer <a href="http://pcre.org/pcre.txt">PCRE documentation</a> vir meer inligting.';
$string['error_duringauthoringtool'] = 'Daar het foute voorgekom toe daar probeer is om {$a}: te bou';
$string['error_infiniterecursion'] = 'Regex bevat oneindige rekursie';
$string['esc_a_leaf_assert'] = 'begin van die string';
$string['esc_b_leaf_assert'] = '\'n woordgrens';
$string['esc_g_leaf_assert'] = 'eerste ooreenstemmende posisie in die string';
$string['exactmatch'] = 'Presiese ooreenstemming';
$string['exactmatch_help'] = '<p>By verstek keer reguliere uitdrukking-ooreenstemming as waar as daar minstens een ooreenstemming in die gegewe string (antwoord) is. Presiese ooreenstemming beteken dat die ooreenstemming die hele string moet wees.</p><p>Stel dit op Ja, as jy reguliere uitdrukkings skryf vir volledige studenteantwoorde. Deur dit op Nee te stel, kry jy bykomende beweeglikheid: jy kan \'n antwoord met lae (of nul-) punt spesifiseer om algemene foute op te vang en kommentaar daaroor te lewer. Jy kan steeds vir sommige van jou reguliere uitdrukkings presiese ooreenstemmings spesifiseer as jy dit met ^ begin en met $ eindig.</p>';
$string['explain_any_char'] = 'Enige karaktervorm';
$string['explain_any_char_except'] = 'Enige karakter behalwe';
$string['explain_begin'] = 'begin';
$string['explain_define'] = 'TODO';
$string['explain_end'] = 'eindig';
$string['explain_false'] = 'onwaar';
$string['explain_parameter'] = 'parameter';
$string['explain_true'] = 'waar';
$string['explain_unknow_meta'] = 'onbekende meta';
$string['explain_unknow_template'] = 'onbekende templaat';
$string['explaining_graph_tool'] = 'Verklarende grafiek';
$string['explaining_graph_tool_help'] = 'Hier kan jy \'n verklarende grafiek sien. Deur die nodus van die boom te druk, word die ooreenstemmende subgrafiek met \'n donkergroen reghoek gemerk. Jy kan ook veelvuldige nodusse gelyk binne \'n reghoek kies deur die Reghoekseleksiemodus-merkboks te merk.';
$string['fa_matcher'] = 'Eindigetoestand-outomata';
$string['fa_settings_heading'] = 'Eindigetoestand-outomata enjinverstellings';
$string['fa_simulation_state_limit'] = 'Outomatasimulasieperk: toestande';
$string['fa_simulation_state_limit_description'] = 'Wanneer \'n string met \'n regex gepas word wat terugverwysings of rekursie bevat, kan een FA-toestand bereik word deur verskillende paaie te gebruik. Dit beteken dat daar etlike "simulasietoestande" vir een "strukturele toestand" geskep is. Hierdie verstelling laat jou die algehele aantal van sulke simulasietoestande beheer.';
$string['fa_state_limit'] = 'Outomatagrootteperk: toestande';
$string['fa_state_limit_description'] = 'Maks. aantal toestande in FA. Stel tyd- en geheueperke vir die FA-enjin wanneer komplekse regex\'e gepas word.';
$string['fa_transition_limit'] = 'Outomatagrootteperk: oorgange';
$string['fa_transition_limit_description'] = 'Maks. aantal oorgange in FA. Stel tyd- en geheueperke vir die FA-enjin wanneer komplekse regex\'e gepas word.';
$string['fail_leaf_control'] = '';
$string['greedyquant'] = 'grypkwantifiseerders';
$string['grouping_node_subexpr'] = 'groepering';
$string['groupspaircountoverlimit'] = 'Moontlike aantal groeppare in een stap van die outomata-ekwivalensie-kontrolealgoritme wat oorloop. Hierdie beperking is nodig om teen \'n langdurige vergelyking te beskerm. Versoek jou werfadministrateur om verstellings te verander, indien nodig.';
$string['hintcolouredstring'] = 'gepasde deel van die antwoord';
$string['hintgradeborder'] = 'Wenk-puntgrens';
$string['hintgradeborder_help'] = 'Antwoorde met \'n punt van minder as die wenk-puntgrens sal nie in wenke gebruik word nie.';
$string['hinthowtofixpic'] = 'hoe om antwoord reg te maak';
$string['hinting'] = 'Wenkopsies';
$string['hinting_help'] = 'Wenkopsies laat jou toe om beskikbaarheid en straftoekennings vir verskillende wenke te stel.';
$string['hintnextchar'] = 'volgende korrekte karakter';
$string['hintnextlexem'] = 'volgende korrekte {$a}';
$string['howtofixpichintpenalty'] = 'Straftoekenning vir hoe om prent reg te maak-wenk';
$string['howtofixpichintpenalty_help'] = 'Straftoekenning vir hoe om prent reg te maak-wenk';
$string['incorrect_charset_range_node_error'] = 'Verkeerde karakteromvang in posisie van {$a->colfirst} tot {$a->collast}: die linkerkarakter is "groter" as die regterkarakter';
$string['incorrect_quant_range_node_error'] = 'Verkeerde kwantifiseerderomvang in posisie van {$a->colfirst} tot {$a->collast}: die linkergrens is groter as die regtergrens';
$string['langselect'] = 'Taal';
$string['langselect_help'] = 'Vir die volgende lexeme-wenk behoort jy \'n taal te kies wat gebruik word om antwoorde tot lexeme af te breek. Elke taal het sy eie reëls vir lexeme. Tale word gedefinieer met \'Formele taalblok\'';
$string['lazyquant'] = 'Trae kwantifiseerders';
$string['lazyquantforapproximate'] = 'Trae kwantifiseerders vir benaderde ooreenstemming met tikfoutopsporing';
$string['leaf_assert'] = 'eenvoudige bewering';
$string['leaf_backref'] = 'terugverwysing';
$string['leaf_charset'] = 'karakterstel';
$string['leaf_charset_error'] = 'verkeerde karakterstel';
$string['leaf_charset_except'] = 'enige karakter behalwe';
$string['leaf_charset_neg'] = 'negatiewe karakterstel';
$string['leaf_charset_one'] = 'karakter';
$string['leaf_control'] = 'beheervolgorde';
$string['leaf_meta'] = 'metakarakter of ontsnap-volgorde';
$string['leaf_options'] = 'wysiger';
$string['leaf_subexpr_call'] = 'subuitdrukking oproep';
$string['leaf_template'] = 'templaat sonder parameters';
$string['lexemhintpenalty'] = 'Straftoekenning vir die volgende lexeme-wenk';
$string['lexemhintpenalty_help'] = 'Straftoekenning vir die verkry van die volgende lexeme-wenk. Gewoonlik sal dit groter as die gewone Moodle-vraagstraftoekenning wees (wat van toepassing is op enige nuwe poging om vraag sonder wenke te beantwoord) en volgende karakter een. Hierdie straftoekennings is onderling uitsluitend.';
$string['lexemusername'] = 'Student-sigbare naam vir lexeme';
$string['lexemusername_help'] = 'Jou studente sal waarskynlik nie weet dat \'n atomiese deel van die taal wat hulle leer <b>lexeme</> genoem word nie. Hulle kan verkies om dit "woord" of "getal" of iets dergeliks te noem. Jy kan \'n naam vir lexeme definieer wat op die "Wenk vir volgende lexeme"-knoppie daar vertoon sal word.';
$string['lf_leaf_control'] = '';
$string['lnu_unsupported_node_error'] = 'Volgordes \\L, \\l, \\N{name}, \\U, word nie ondersteun nie';
$string['mark_name_leaf_control'] = '';
$string['maxerrorsshowndescription'] = 'Maksimum aantal foute wat vir elke reguliere uitdrukking in die vraagwysingsvorm vertoon word';
$string['maxerrorsshownlabel'] = 'Maksimum aantal foute vertoon';
$string['maxtypos'] = 'Tikfoutbeperking';
$string['maxtypos_help'] = 'Boonste tikfoutbeperking vir ooreenstemming met tikfoutopsporing. Om die beperking te oorskry lei tot verkeerde ooreenstemming.';
$string['mergedassertion_option'] = 'Jy moet volledige beweringsmodus vir die gebruik van komplekse positiewe bewerings stel.';
$string['mergemodeforassertion'] = 'Kies asseblief volledige beweringsondersteuning in die verstellings. In vinnig modus {$a}';
$string['missing_brackets_for_g_node_error'] = '\\g word nie gevolg deur versterkte, hoekige of aangehaalde naam/getal of deur \'n gewone getal nie';
$string['missing_brackets_for_k_node_error'] = '\\k word nie gevolg deur versterkte, hoekige of aangehaalde naam/getal of deur \'n gewone getal nie';
$string['missing_callout_ending_node_error'] = 'Ongeslote uitroep';
$string['missing_close_paren_node_error'] = 'Sintaksisfout: ontbrekende sluithakie \')\' vir die openingshakie in posisie {$a->colfirst}';
$string['missing_comment_ending_node_error'] = 'Sintaksisfout: ontbrekende sluithakie vir die kommentaar in posisie vanaf {$a->colfirst} tot {$a->collast}';
$string['missing_condsubexpr_ending_node_error'] = 'Ongeslote voorwaardelike subpatroonnaam';
$string['missing_control_ending_node_error'] = 'Ontbrekende sluithakie na beheervolgorde';
$string['missing_open_paren_node_error'] = 'Sintaksisfout: ontbrekende openingshakie \'(\' vir die sluithakie in posisie {$a->colfirst}';
$string['missing_subexpr_name_ending_node_error'] = 'Sintaksisfout in subpatroonnaam';
$string['missing_template_close_paren_node_error'] = 'Sintaksisfout: ontbrekende templaatsluiting \'(?###>)\' vir die templaatopening in posisie {$a->colfirst}';
$string['missing_template_open_paren_node_error'] = 'Sintaksisfout: ontbrekende templaatopening \'(?###name<)\' vir die templaatsluiting in posisie {$a->colfirst}';
$string['nla_node_assert'] = 'negatiewe vooruitkykbewering';
$string['nla_node_cond_subexpr'] = 'negatiewe vooruitkyk-kondisionele subpatroon';
$string['nlb_node_assert'] = 'negatiewe terugkykbewering';
$string['nlb_node_cond_subexpr'] = 'negatiewe terugkyk-kondisionele subpatroon';
$string['no_start_opt_leaf_control'] = '';
$string['noapproximateforhowtofixpichint'] = 'Tikfoutanalise en tikfoutperk bo 0 word vereis. Probeer om tikfoutopsporing te ontsper of om tikfoutperk bo nul te stel. Gekose ooreenstemmingsenjin kan die beskikbaarheid van tikfoutafdeling affekteer.';
$string['nocorrectanswermatch'] = 'Geen maksimumpunt reguliere uitdrukking stem met die korrekte antwoord ooreen nie';
$string['node_alt'] = 'afwisseling';
$string['node_assert'] = 'lookaround-bewering';
$string['node_concat'] = 'aaneenskakeling';
$string['node_cond_subexpr'] = 'voorwaardelike subpatroon';
$string['node_error'] = 'sintaksisfout';
$string['node_finite_quant'] = 'eindigekwantifiseerder';
$string['node_infinite_quant'] = 'oneindigekwantifiseerder';
$string['node_subexpr'] = 'subpatroon';
$string['node_template'] = 'templaat met parameters';
$string['nohintgradeborderpass'] = 'Geen antwoord het \'n punt groter as of gelyk aan die wenk-puntgrens nie. Dit versper wenke.';
$string['nosubexprcapturing'] = '{$a} enjin ondersteun nie subpatroonvaslegging nie, verwyder asseblief die plekhouers (behalwe {$0}) uit die terugvoer of kies \'n ander enjin';
$string['notation'] = 'Reguliere uitdrukkingnotasie';
$string['notation_help'] = '<p>Jy kan die notasie om reguliere uitdrukkings in te voer, kies. As jy net \'n reguliere uitdrukking wil skryf, kies asseblief die verstek, <b>Reguliere uitdrukking</b> notasie wat baie ná aan PCRE is, maar addisionele foutbestande vermoëns het. Dit sal lynbreuke in jou uitdrukkings ignoreer, wat \'n ligte mate van formatering toelaat.</p><p><b>Reguliere uitdrukking (uitgebrei)</b> notasie is geskep vir \'n makliker hantering van groot uitdrukkings. Dit sal nie-ontsnapte witspasiekarakters ignoreer, wat nie binne karakterklas is nie, en sal enigiets uit nie-ontsnapte # tot die einde van die string as kommentaar hanteer. Dit is ekwivalent aan PCRE_EXTENDED-opsie en PHP "x"-wysiger.</p><p><b>Moodle kortantwoord</b> notasie laat jou toe om preg as \'n gewone Moodle-kortantwoordvraag met wenkvermoë te gebruik - sonder die nodigheid om reguliere uitdrukkings te verstaan. Kopieer net jou antwoorde uit kortantwoordvraag. Die \'*\' oorheersstring word ondersteun.</P>';
$string['notation_mdlshortanswer'] = 'Moodle-kortantwoord';
$string['notation_native'] = 'Reguliere uitdrukking';
$string['notation_pcreextended'] = 'Reguliere uitdrukking (uitgebrei)';
$string['objectname'] = 'vraag';
$string['onceonly_node_subexpr'] = 'slegs eenmalige subpatroon';
$string['pathtodotempty'] = 'Kan nie {$a->name} teken nie: pad na punt van graphviz is leeg. Vra asseblief jou administrateur om <a href="http://www.graphviz.com">graphviz</a> te installeer en die pad daarheen te spesifiseer met die \'padnapunt\'-opsie by Administrasie > Bediener > Stelsel > Paaie';
$string['pathtodotincorrect'] = 'Kan nie {$a->name} teken nie: pad na punt van graphviz is verkeerd of punt kan nie uitgevoer word nie. Vra asseblief jou administrateur om te kontroleer of <a href="http://www.graphviz.com">graphviz</a> geïnstalleer is en \'padnapunt\'-opsie korrek is by Administrasie > Bediener > Stelselpaaie';
$string['php_preg_matcher'] = 'PHP preg-uitbreiding';
$string['pla_node_assert'] = 'positiewe vooruitkyk-bewering';
$string['pla_node_cond_subexpr'] = 'positiewe vooruitkyk kondisionele subpatroon';
$string['plb_node_assert'] = 'positiewe terugkyk-bewering';
$string['plb_node_cond_subexpr'] = 'positiewe terugkyk kondisionele subpatroon';
$string['pluginname'] = 'Reguliere uitdrukking';
$string['pluginname_help'] = '<p>Reguliere uitdrukkings is \'n vorm van skryfpatrone om verskillende stringe te pas. Jy kan dit gebruik om antwoorde op twee maniere te verifieer: \'n uitdrukking om met volledige (gewoonlik korrekte) antwoord te pas, of \'n uitdrukking om \'n gedeelte van die antwoord te pas (wat byvoorbeeld gebruik kan word om algemene foute op te spoor en geskikte kommentaar te lewer).</p><p>Hierdie vraag gebruik die PHP perl-versoenbare reguliere uitdrukkingsintaksis as die verstek notasie. Daar is baie gidse oor die skep en gebruik van reguliere uitdrukking, waarvan die volgende een is: <a href="http://www.phpfreaks.com/content/print/126">example</a>. Jy kan \'n sintaksisuiteensetting van uitdrukking hier kry: <a href="http://www.nusphere.com/kb/phpmanual/reference.pcre.pattern.syntax.htm">php manual</a>. Let daarop dat jy nie reguliere uitdrukking in skeier moet omsluit of enige wysigers spesifiseer nie - Moodle sal dit namens jou doen.</p><p>Jy kan ook hierdie vraag as die gevorderde vorm van kortantwoord met wenk gebruik, selfs as jy niks van reguliere uitdrukkings weet nie! Kies net <b>Moodle-kortantwoord</b> as notasie vir jou vrae.';
$string['pluginname_link'] = 'question/type/preg';
$string['pluginnameadding'] = '\'n Reguliere uitdrukking-vraag word bygevoeg';
$string['pluginnameediting'] = '\'n Reguliere uitdrukking-vraag word gewysig';
$string['pluginnamesummary'] = 'Voer \'n stringrespons van student in wat met etlike reguliere uitdrukkings gepas kan word. Vertoon aan die student die korrekte deel van sy antwoord. Deur gedrag met veelvuldige probeerslae te gebruik, kan \'n wenk gegee word deur \'n volgende korrekte karakter of lexeme te vertel.<br/>Jy kan dit gebruik sonder om reguliere uitdrukking te ken om wenke te verkry, deur die \'Moodle-kortantwoord\'-notasie te gebruik.';
$string['posix_class_outside_charset_node_error'] = 'POSIX-klasse word nie buite karakterstelle toegelaat nie';
$string['possessivequant'] = 'Besitlike kwantifiseerders';
$string['privacy:metadata'] = 'Die Preg-vraagtipe berg nie gebruikerdata nie.';
$string['prune_leaf_control'] = '';
$string['quantifier_without_parameter_node_error'] = 'Sintaksisfout: kwantifiseerder in posisie van {$a->colfirst} tot {$a->collast} beskik nie oor \'n operand nie - niks om te herhaal nie';
$string['questioneditingheading'] = 'Vraagwysingverstellings';
$string['recursion_leaf_assert'] = 'fiktief';
$string['recursion_node_cond_subexpr'] = 'rekursiewe kondisionele subpatroon';
$string['regex_handler'] = 'Regex-hanteerder';
$string['set_unset_same_modifier_node_error'] = 'Stel en verander die {$a->addinfo} wysiger gelyktydig in posisie van {$a->colfirst} tot {$a->collast}';
$string['simplification_equivalences_full_1'] = '\'n Eenvoudige bewering is oorbodig omdat die volgende reeds dieselfde het';
$string['simplification_equivalences_full_10'] = 'Die twee geneste herhalings kan met een vervang word';
$string['simplification_equivalences_full_11'] = 'Kwantifiseerder "{$a->first}" ekwivalent "{$a->second}"';
$string['simplification_equivalences_full_12'] = 'Kwantifiseerder "?" kan verwyder word, aangesien \'n alternatief dieselfde leegheid kan wees';
$string['simplification_equivalences_full_13'] = 'Die leegheid in die alternatief is oorbodig, omdat alternatief en altyd saamval met leegheid';
$string['simplification_equivalences_full_14'] = 'Kwantifiseerder affekteer nie die bewerking van die reguliere uitdrukking nie, dit kan verwyder word';
$string['simplification_equivalences_full_2'] = 'Leë hakies affekteer nie die bewerking van \'n reguliere uitdrukking nie, jy kan verwyder';
$string['simplification_equivalences_full_2_1'] = 'Hakies affekteer nie die bewerking van \'n reguliere uitdrukking nie, jy kan verwyder';
$string['simplification_equivalences_full_3'] = 'Leë hakies affekteer nie die bewerking van die reguliere uitdrukking nie, aangesien dit nie terugverwysing of voorwaardelike subpatrone het nie, dit kan verwyder word';
$string['simplification_equivalences_full_3_1'] = 'Hakies affekteer nie die bewerking van die reguliere uitdrukking nie, aangesien dit nie terugverwysing of kondisionele subpatrone het nie, dit kan verwyder word';
$string['simplification_equivalences_full_4'] = 'Identiese herhalende deel van die uitdrukking kan kortliks geskryf word';
$string['simplification_equivalences_full_5'] = 'Die blokhakies kan verwyder word omdat daar net een karakter in is';
$string['simplification_equivalences_full_6'] = 'Dit word beter met blokhakies voorgestel';
$string['simplification_equivalences_full_7'] = 'Jy kan \'n %subuitdrukking% van die hakies maak';
$string['simplification_equivalences_full_8'] = 'Dit is gemakliker om te skryf met die "?"';
$string['simplification_equivalences_full_8_1'] = 'Leegheid in die alternatief kan moontlik verwyder word. Alternatief en daarsonder kan met leegheid ooreenstem';
$string['simplification_equivalences_full_9'] = 'Jy kan \'n kantifiseerder "?" verwyder. Ek het \'n alternatief en voeg \'n leë alternatief daarby';
$string['simplification_equivalences_short_1'] = 'Opeenvolgende eenvoudige bewerings';
$string['simplification_equivalences_short_10'] = 'Vervanging van twee kantifiseerders een';
$string['simplification_equivalences_short_11'] = 'Verander na \'n ekwivalente kwantifiseerder';
$string['simplification_equivalences_short_12'] = 'Oorskot kwantifiseerder "?"';
$string['simplification_equivalences_short_13'] = 'Oorskot leegheid in die alternatief';
$string['simplification_equivalences_short_14'] = 'Die nuttelose kwantifiseerder';
$string['simplification_equivalences_short_2'] = 'Die leë hakies "(?:)"';
$string['simplification_equivalences_short_2_1'] = 'Die nuttelose hakies "(?:)"';
$string['simplification_equivalences_short_3'] = 'Leë hakies "()"';
$string['simplification_equivalences_short_3_1'] = 'Die nuttelose hakies "()"';
$string['simplification_equivalences_short_4'] = 'Herhalende subuitdrukking';
$string['simplification_equivalences_short_5'] = 'Die ekstra blokhakies';
$string['simplification_equivalences_short_6'] = 'Kan lei tot die ekwivalente karakterklasse';
$string['simplification_equivalences_short_7'] = 'Invoer van alternatiewe subuitdrukkings';
$string['simplification_equivalences_short_8'] = 'Oormatige leegheid in die alternatief';
$string['simplification_equivalences_short_8_1'] = 'Oormatige leegheid in die alternatief';
$string['simplification_equivalences_short_9'] = 'Oormatige kwantifiseerder "?"';
$string['simplification_errors_full_1'] = 'Eenvoudige bewering "^" is oorbodig, aangesien dit nie aan die begin van die reguliere uitdrukking is nie';
$string['simplification_errors_full_2'] = 'Eenvoudige bewering "$" is oorbodig, aangesien dit nie aan die einde van die reguliere uitdrukking is nie';
$string['simplification_errors_short_1'] = 'Oorbodige eenvoudige bewering "^"';
$string['simplification_errors_short_2'] = 'Oorbodige eenvoudige bewering "$"';
$string['simplification_tips_full_1'] = 'Jy kan enige witspasie (soos \'n tabelkeep) wil toelaat, jy moet "\\s" gebruik';
$string['simplification_tips_full_2'] = 'Jy kan enige aantal witspasiekarakters in hierdie plek wil toelaat, jy moet \'n kwantifiseerder "+" gebruik';
$string['simplification_tips_full_3'] = 'Hakies laat die ooreenstemming toe om hierdie deel van die uitdrukking te onthou. As jy nie die hakies benodig nie, kan dit vervang word met groep "(?.)"';
$string['simplification_tips_full_4'] = 'Jy kan enige aantal witspasiekarakters in hierdie plek wil toelaat, jy moet die kwantifiseerder "*" gebruik';
$string['simplification_tips_full_5'] = 'Die uitdrukking stem ooreen met enige string';
$string['simplification_tips_full_6'] = 'Jy wil moontlik die kas ignoreer, dit kan gedoen word met die opsie kassensitiwiteit af "(?i)"';
$string['simplification_tips_full_7'] = 'Hierdie deel word nie gekopieer nie, jy kan dit \'n naam gee en elders oproep';
$string['simplification_tips_full_8'] = 'Jy moet moontlik die "presiese ooreenstemming" eerder as "^" en "$" aan die begin en einde van die uitdrukking ontsper';
$string['simplification_tips_full_8_alt'] = '"^" en "$" in die begin en aan die einde van die stelling is oorbodig, omdat "presiese ooreenstemming" ontsper is';
$string['simplification_tips_short_1'] = 'Vou lys van witspasie oop';
$string['simplification_tips_short_2'] = 'Vermeerder die hoeveelheid witspasie';
$string['simplification_tips_short_3'] = 'Die ekstra hakies, waarvoor daar geen terugverwysings is nie';
$string['simplification_tips_short_4'] = 'Slegs een witspasie';
$string['simplification_tips_short_5'] = 'Die uitdrukking stem ooreen met leegheid';
$string['simplification_tips_short_6'] = 'Gebruik opsie (?i) eerder as die karakterklas met gepaarde hoof- en kleinletters';
$string['simplification_tips_short_7'] = 'Herhaalde gebruik van die uitdrukking';
$string['simplification_tips_short_8'] = 'Onnodige bewerings links en regs';
$string['simplification_tool'] = 'Vereenvoudiging van reguliere uitdrukking';
$string['simplification_tool_apply'] = 'Wend aan en volgende';
$string['simplification_tool_cancel'] = 'Kanselleer en volgende';
$string['simplification_tool_equivalence'] = 'Ekwivalensies:';
$string['simplification_tool_error'] = 'Foute:';
$string['simplification_tool_help'] = 'Hier kan jy wenke besigtig om reguliere uitdrukkings te vereenvoudig, as dit nodig is. Wenke kom in drie soorte: ekwivalensies (vervanging van uitdrukking op meer optimale ekwivalente uitdrukking), wenke (sluit in gevalle wat misgekyk kan word) en foute (gevalle waarin die reguliere uitdrukking met enige string ooreenstem of nie met enigiets ooreenstem nie).';
$string['simplification_tool_tip'] = 'Wenke:';
$string['skip_leaf_control'] = '';
$string['skip_name_leaf_control'] = '';
$string['slash_at_end_of_pattern_node_error'] = 'Sintaksisfout: \\ aan einde van patroon';
$string['small_esc_z_leaf_assert'] = 'einde van die string';
$string['subexpr_leaf_assert'] = 'fiktief';
$string['subexpr_name_expected_node_error'] = 'Subpatroonnaam verwag';
$string['subexpr_node_cond_subexpr'] = '"subpatroon"-kondisionele subpatroon';
$string['subexpr_node_subexpr'] = 'subpatroon';
$string['subexpression'] = 'Subpatroon';
$string['syntax_tree_tool'] = 'Sintaksisboom';
$string['syntax_tree_tool_collapsing_mode'] = 'Toevoumodus';
$string['syntax_tree_tool_help'] = 'Hier kan jy die sintaksisboom van jou uitdrukking sien. Deur die nodus van die boom te druk word die ooreenstemmende subboom, subgrafiek en ooreenstemmende deel van beskrywing gemerk. Jy kan ook die nodusse toevou / oopvou deur Toevoumodus aan te skakel.';
$string['then_leaf_control'] = '';
$string['tobecontinued'] = '...';
$string['too_large_fa'] = 'Reguliere uitdrukking is te kompleks om deur {$a->engine} gepas te word, weens die tyd- en/of geheueperke. Probeer asseblief \'n ander ooreenstemmingsenjin, vra jou administrateur om <a href="{$a->link}">tyd- en geheueperke te verhoog</a> of vereenvoudig jou reguliere uitdrukking.';
$string['toolargequant'] = 'Té groot eindigekwantifiseerder';
$string['toomanyerrors'] = '.......{$a} meer foute';
$string['truefalse_leaf_assert'] = 'fiktief';
$string['typoanalysis'] = 'Tikfoutanalise';
$string['typoanalysis_help'] = 'Tikfoutanalise aanvaar dat student foute binne \'n antwoord kan hê.';
$string['typosfound'] = 'Tikfoute gevind';
$string['typospenalty'] = 'Straftoekenning vir elke tikfout wat teëgekom is';
$string['typospenalty_help'] = 'Straftoekenning vir elke tikfout wat teëgekom is';
$string['ucp_leaf_control'] = '';
$string['unallowedhint'] = 'Gekose wenk nie toegelaat nie weens beperkings in vraagverstellings. Stel asseblief "Laat {$a} wenke toe" na "ja" om dit toe te laat. Gekose ooreenstemmingsenjin kan beskikbaarheid van wenke affekteer.';
$string['unclosed_charset_node_error'] = 'Sintaksisfout: \'n sluithakie \']\' vir die karakterstel wat in posisie {$a->colfirst} begin, ontbreek';
$string['unexisting_subexpr_node_error'] = 'Subpatroon "{$a->addinfo}" bestaan nie';
$string['ungreedyquant'] = 'Niegryp kwantifiseerders';
$string['unknown_control_sequence_node_error'] = 'Onbekende beheersekwensie: {$a->addinfo}';
$string['unknown_error_node_error'] = 'Onbekende foute';
$string['unknown_posix_class_node_error'] = 'Onbekende POSIX-klas: {$a->addinfo}';
$string['unknown_template_node_error'] = 'Onbekende templaat: {$a->addinfo}';
$string['unknown_unicode_property_node_error'] = 'Onbekende Unicode-eienskap: {$a->addinfo}';
$string['unrecognized_pqh_node_error'] = 'Onbekende karakter na (? of (?-';
$string['unrecognized_pqlt_node_error'] = 'Onbekende karakter na (?<';
$string['unrecognized_pqp_node_error'] = 'Onbekende karakter na (?P';
$string['unsupported'] = '{$a->nodename} in posisie van {$a->linefirst}:{$a->colfirst} tot {$a->linelast}:{$a->collast} nie deur {$a->engine} ondersteun nie.';
$string['unsupported_modifier_node_error'] = 'Onbekende, verkeerde of onondersteunde wysiger(s): {$a->addinfo}';
$string['unsupportedmodifier'] = 'Fout: wysiger {$a->modifier} word nie deur die {$a->classname} ondersteun nie.';
$string['usecharhint'] = 'Laat volgende karakterwenk toe';
$string['usecharhint_help'] = 'In gedrag wat veelvuldige probeerslae toelaat (bv. aanpassend of interaktief) vertoon aan student die \'Wenk vir volgende karakter\' knoppie wat toelaat dat \'n eenkarakter wenk verkry word terwyl die \'Wenk vir volgende karakter-straftoekenning\' toegepas word. Nie alle ooreenstemmingsenjins ondersteun wenke nie.';
$string['usehint_help'] = 'In gedrag wat veelvuldige probeerslae toelaat (bv. aanpassend of interaktief) vertoon aan student die \'Wenk vir volgende karakter\' knoppie wat toelaat dat \'n eenkarakter wenk verkry word terwyl die \'Wenk vir volgende karakter-straftoekenning\' toegepas word. Nie alle ooreenstemmingsenjins ondersteun wenke nie.';
$string['usehowtofixpichint'] = 'Laat hoe om wenke reg te stel toe (prent)';
$string['usehowtofixpichint_help'] = 'Wys aan student wat hy moet doen om string te korrigeer. Tikfoutanalise en tikfoutperk bo 0 word vereis.';
$string['uselexemhint'] = 'Laat lexemewenke toe (woord, getal, leesteken)';
$string['uselexemhint_help'] = '<p>In gedrag wat veelvuldige probeerslae toelaat (bv. aanpassend of interaktief) vertoon aan studente die \'Wenk vir volgende woord\' knoppie wat toelaat dat \'n wenk vertoon word wat huidige lexeme voltooi of wat die volgende een vertoon as die lexeme volledig is, terwyl die \'Wenk vir volgende lexeme-straftoekenning\' toegepas word. Nie alle ooreenstemmingsenjins ondersteun wenke nie.</p><p><b>Lexeme</b> is \'n atomiese deel van die taal: \'n woord, getal, leesteken, operateur, ens.</p>';
$string['utf16_leaf_control'] = '';
$string['utf8_leaf_control'] = '';
$string['wrong_template_params_count_node_error'] = 'Verkeerde templaatparametertelling:  {$a->addinfo->expected} verwag, {$a->addinfo->given} gegee';
