<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_flexibase', language 'af', version '4.1'.
 *
 * @package     theme_flexibase
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminhelp'] = 'Adminhulp';
$string['alert1'] = 'Eerste waarskuwing';
$string['alert2'] = 'Tweede waarskuwing';
$string['alert3'] = 'Derde waarskuwing';
$string['alert_general'] = 'Aankondiging';
$string['alert_info'] = 'Inligting';
$string['alert_warning'] = 'Waarskuwing';
$string['alertinfodesc'] = 'Voer die verstellings van jou waarskuwing in.';
$string['alertsdesc'] = 'Dit sal \'n waarskuwing (of etlike) in drie verskillende style aan jou gebruikers op die Moodle-voorblad vertoon. Onthou asseblief om dit te versper wanneer dit nie meer nodig is nie.';
$string['alertsheading'] = 'Gebruikerwaarskuwings';
$string['alertsheadingsub'] = 'Vertoon belangrike boodskappe aan jou gebruikers op die voorblad';
$string['alerttext'] = 'Waarskuwingsteks';
$string['alerttextdesc'] = 'Dit is die hoofteks van die waarskuwing. Waarskuwings behoort so kort moontlik gehou te word, terwyl die betekenis behou word, om te verseker dat gebruikers dit wel lees.';
$string['alerttitle'] = 'Titel';
$string['alerttitledesc'] = 'Hooftitel/opskrif van jou waarskuwing.';
$string['alerttype'] = 'Vlak';
$string['alerttypedesc'] = 'Stel die toepaslike waarskuwingsvlak/tipe om jou gebruikers die beste in te lig; Inligting, Waarskuwing, Gevaar - hierdie vlakke pas die relevante ikoon en temakleure op die waarskuwings toe.';
$string['allclasses'] = 'Alle klasse';
$string['allcourses'] = 'Alle kursusse';
$string['allmodules'] = 'Alle modules';
$string['allunits'] = 'Alle eenhede';
$string['alwaysdisplay'] = 'Vertoon altyd';
$string['alwaysexpandsiteadmin'] = 'Bevolk altyd werfadministrasiekielsys';
$string['alwaysexpandsiteadmindesc'] = 'Deur hierdie opsie te ontsper, sal die Werfadministrasiekieslys (indien van toepassing) ten koste van prestasie bevolk word.';
$string['awesomebarheading'] = 'AwesomeBar-verstellings';
$string['awesomebarsettings'] = 'AwesomeBar/Navigasieverstellings';
$string['awesomebarsettingsdesc'] = 'Die "AwesomeBar" is die swart navigasiestafie wat boaan die blaaiervenster vasgeheg is.<br>Hierdie verstellings hou verband met die "AwesomeBar" en ander bladnavigasie.';
$string['badgepreferences'] = 'Kentekenvoorkeure';
$string['black'] = 'Swart';
$string['blackdesc'] = 'Swart verstelling - Verstek sal #000 wees, maar dit kan aangepas word as daar \'n behoefte bestaan om kontrasvlakke te verstel.';
$string['blog'] = 'Blog-URL';
$string['blogdesc'] = 'Voer die URL van jou instelling se blog in (d.w.s. http://www.moodleman.net)';
$string['blogpreferences'] = 'Blogvoorkeure';
$string['bootstraphelp'] = 'Bootstrap Voorbeelde';
$string['borderradius'] = 'Rantradius';
$string['borderradiusdesc'] = 'Rantradius';
$string['branddanger'] = 'Handelsmerk Gevaar';
$string['branddangerdesc'] = 'Handelsmerkkleur vir gevaarwaarskuwings en -panele, ens.';
$string['branddangerlight'] = 'Handelsmerk Gevaar Lig';
$string['branddangerlightdesc'] = 'Handelsmerk Gevaar Lig';
$string['brandinfo'] = 'Handelsmerk Inligting';
$string['brandinfodesc'] = 'Handelsmerkkleur vir inligtingswaarskuwings en -panele, ens.';
$string['brandinfolight'] = 'Handelsmerk Inligtinglig';
$string['brandinfolightdesc'] = 'Handelsmerk Inligtinglig';
$string['brandprimary'] = 'Handelsmerk Primêr';
$string['brandprimarydesc'] = 'Jou hoof-handelsmerkkleur';
$string['brandprimarylight'] = 'Handelsmerk Primêr Lig';
$string['brandprimarylightdesc'] = 'Handelsmerk Primêr Lig';
$string['brandprimarylighter'] = 'Handelsmerk Primêr Ligter';
$string['brandprimarylighterdesc'] = 'Handelsmerk Primêr Ligter';
$string['brandprimarylightest'] = 'Handelsmerk Primêr Ligste';
$string['brandprimarylightestdesc'] = 'Handelsmerk Primêr Ligste';
$string['brandsuccess'] = 'Handelsmerk Sukses';
$string['brandsuccessdesc'] = 'Handelsmerkkleur vir suksesvolle waarskuwings, positiewe panele, knoppies, ens.';
$string['brandsuccesslight'] = 'Handelsmerk Sukses Lig';
$string['brandsuccesslightdesc'] = 'Handelsmerk Sukses Lig';
$string['brandwarning'] = 'Handelsmerk Waarskuwing';
$string['brandwarningdesc'] = 'Handelsmerkkleur vir waarskuwings en panele, ens.';
$string['brandwarninglight'] = 'Handelsmerk Waarskuwing Lig';
$string['brandwarninglightdesc'] = 'Handelsmerk Waarskuwing Lig';
$string['captionbackgroundcolour'] = 'Agtegrondkleur van opskrif';
$string['captionbackgroundcolourdesc'] = 'Kies tussen \'n ligte of donker semideursigtige agtergrond.';
$string['captiondark'] = 'Donker agtergrond';
$string['captionlight'] = 'Ligte agtergrond';
$string['captiontextcolour'] = 'Tekskleur van opskrif';
$string['captiontextcolourdesc'] = 'Kleur van die karousel skyfieopskrifteks. Die verstek is wit.';
$string['captiontheme'] = 'Tema primêre handelsmerkkleur';
$string['carouseldesc'] = 'Stel tot 8 prente, met titel, opskrif en skakel-url vir die voorbladkarousel.';
$string['carouselheading'] = 'Karousel Skyfievertoning';
$string['carouselheadingsub'] = 'Stel prente en opskrifte van die voorbladkarousel';
$string['categoryiconcategory'] = 'Die ikoon vir die kategorie: {$a->category}.';
$string['categoryicondesc'] = 'Indien ontsper, sal dit jou toelaat om ikone vir elke kategorie van kursus te stel.<br>Let wel: As kategorie-ikone gebruik word, word aan hulle \'n vasgestelde hoogte toegeken, geskik vir \'n enkele lyn naam met \'n klein onderkantlyn, of \'n tweelyn-naam. As jou kategorie soms titels het wat langer as hierdie is, kan jy dit moontlik in jou doelgemaakte css wil herstel om addisionele spasie toe te laat, bv. <code>.flexibasecats.panel {height: 230px;}</code>';
$string['categoryiconheading'] = 'Kategorie-ikone';
$string['categoryiconheadingsub'] = 'Gebruik ikone om jou kategorieë voor te stel';
$string['categoryiconinfo'] = 'Kategorie-ikoon';
$string['categoryiconinfodesc'] = 'Doelgemaakte Kategorie-ikoon';
$string['categoryiconsize'] = 'Grootte van kategorie-ikoon';
$string['categoryiconsizedesc'] = 'Stel \'n grootte vir die kategorie-ikoon';
$string['choosereadme'] = '<p>flexibase is op die Bootstra3-moedertema (bootstrap) en die bootswatch Spacelab gebaseer.</p>
<p>Dit gebruik egter flexbox-uitlegte vir die hoofuitleg-komponentareas, eerder as bootstrap-roosters om \'n maklike manier aan admins te verskaf om \'n groot verskeidenheid uitlegte op hul werf te bestuur deur die temaverstellingsbladsye, sonder dat enige kode doelgemaak hoef te word.</p><p class="alert-warning"><b>LET WEL:</b> Hierdie uitlegopsies word nie toegepas op blaaiers wat glad nie Flexbox ondersteun nie, soos IE 9 en daaronder. Flexbox legacy en voorafingestelde weergawes word ondersteun.</p>
<p>Jy kan meer besonderhede in die LEESMY.txt-dokument vind, asook die ingeslote kursusrugsteundokument, wat op jou eie werf herstel kan word vir meer inligting oor sommige van die temafunksies.</p>';
$string['colordesc'] = 'Hier kan jy verskillende verstellings vind om baie van die kleure in hierdie tema te verander.';
$string['colorheading'] = 'Hierdie waarskuwings kan deur die gebruiker toegemaak word - vir daardie sessie, maar as die bladsy verfris word, sal dit weer verskyn. Dit is opsetlik, aangesien die waarskuwings bedoel is vir belangrike boodskappe wat op die skerm gehou moet word. Daar is ander maniere om opspringboodskappe wat toegemaak kan word, te vertoon, soos die globaleboodskap plaaslike invoegtoepassing. Onthou asseblief om die boodskappe te versper as dit nie meer nodig is nie.';
$string['colorheadingsub'] = 'Stel die kleure wat in jou tema gebruik word';
$string['configtitle'] = 'FlexiBase';
$string['contenthelp'] = 'Wenke vir Inhoudskepping';
$string['courseboxactivitynotice'] = 'Aktiwiteit<br>Kennisgewings';
$string['coursegrades'] = 'Kursuspunte';
$string['courseheaderdefaultimage'] = 'Verstek kursushofieprent';
$string['courseheaderdefaultimagedesc'] = 'Die verstek prent om vir die kursushofieprente te gebruik wanneer geen kursusprent gevind word nie - as dit leeg gelaat word, sal slegs kursusse met \'n kursusprent in die Kursusopsommingdokumente \'n opskrifprent hê.';
$string['courseheaderimageheight'] = 'Hoogte van Kursushofieprent';
$string['courseheaderimageheightdesc'] = 'Stel die hoogte van enige prente wat as hofiebaniere gebruik word (aanbevole hoogte 150-175 px).<br>Let wel: As jy dit na minder as 125 px stel, kan dit ook nodig wees dat jy die fontgrootte van die kursuspunt wysig om dit na \'n enkele lyn te bring (voeg <code>.courseheadergradepercentage table tbody tr:last-of-type .column-itemname, .courseheadergradepercentage table tbody tr:last-of-type .column-percentage {font-size:120%;}</code> by jou doelgemaaktecss).';
$string['courseimageheaderoption'] = 'Kursushofieprente';
$string['courseimageheaderoption1'] = 'Kursusprent as \'n hofiebanier';
$string['courseimageheaderoption2'] = 'Kursusprent as \'n aparte prent';
$string['courseimageheaderoption3'] = 'Geen kursushofieprent';
$string['courseimageheaderoptiondesc'] = 'Konfigureer hoe die prente vir kursushofies gebruik word. Kies geen prent, prent as hofieagtergrond of prent as aparte prent boaan die kursusblad.';
$string['coursepageimagesinfo'] = 'Kursubladprente';
$string['coursepageimagesinfodesc'] = 'Verstellings vir Kursusbladhofieprente';
$string['courseslayout'] = 'Kursusse';
$string['courseslayoutdesc'] = 'Kantstafie-uitleg vir kursusbladsye';
$string['coursesleafonly'] = 'Bevolk "Kursusse" kieslys';
$string['coursesleafonlydesc'] = 'Op werwe met \'n groot aantal kursusse kan die generering van die volledige lys kursusse in die Awesomebar prestasieprobleme veroorsaak. Versper hierdie verstelling (stel dit op "Nee") om te verhoed dat die lys gegenereer word - die "Kursusse"-nodus sal as \'n vinnige pad na die kursuslys bly.';
$string['coursesloggedinonly'] = 'Versteek Kursusse-kieslys van gebruikers wat nie ingeteken is nie';
$string['coursesloggedinonlydesc'] = 'As jy nie wil hê dat gebruikers wat nie ingeteken is nie, die "Kursusse"-kieslys in die Awesomebar moet kan sien nie, ontsper hierdie verstelling.';
$string['coursetileimagesinfo'] = 'Prente van Voorbladkursusteëls';
$string['coursetileimagesinfodesc'] = 'Verstellings vir Voorbladkursusteëlprente';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'Die Doelgemaakte CSS-verstellingsboks bied jou ten volle beheer oor enige en alle CSS binne die tema, aangesien hierdie verstelling enigiets binne die temastyle oorheen kan skryf, wat insluit dié items wat in ander dele van die verstellingsbladsye verstel word. Daar moet op gelet word dat die Flexibase-tema ook \'n doelgemaakte LESS-verstelling het (sien die addisionele LESS-blad), wat jou toelaat om LESS saam met die CSS te gebruik.';
$string['customisationshelp'] = 'Doelmakingshulp';
$string['customless'] = 'Doelgemaakte LESS';
$string['customlessdesc'] = 'Watter LESS-reëls jy ook al by hierdie teksarea voeg, sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik. Flexibase is een van die min temas wat oor hierdie LESS-verstellings beskik en maak gebruik van LESS \'in die verbygaan\' uit beide die verstellings hierbo én uit hierdie doelgemaakte LESS-boks. Hierdie verstelling laat toe dat enige LESS-veranderlike of reël op dieselfde manier oorheengeskryf word as wat die doelgemaakte CSS-boks die tema-css oorheenskryf. (Let wel: doelgemaaktecss sal customLESS oorheenskryf, aangesien die CSS-reëls die laaste is om toegepas te word.)';
$string['custommenuafterawesomebar'] = 'Plaas doelgemaakte kieslys ná Awesomebar';
$string['custommenuafterawesomebardesc'] = 'Plaas doelgemaakte kieslys ná Awesomebar-inhoud. Andersins sal dit voor die Verstellingskieslyste verskyn. (Slegs van toepassing indien vorige opsie ontsper is.)';
$string['custommenuinawesomebar'] = 'Voeg doelgemaakte kieslys by Awesomebar';
$string['custommenuinawesomebardesc'] = 'Skuif die doelgemaakte kieslys na die Awesomebar. Andersins sal dit onder die hofie verskyn.';
$string['dashboardcoursetileinfo'] = 'Paneelbord-kursuslysopsies';
$string['dashboardcoursetileinfodesc'] = 'Verstellings vir Paneelbordkursusteëls. Let wel: die verstek prent wat vir die voorbladkursusteëls met oorlegging gebruik word, word gebruik wanneer kursusteëls op die My Paneelbord-blad vertoon word, saam met die oorleggingkleure wat vir die voorbladkursusteëlopsies gestel is.';
$string['dashboardrenderer'] = 'Paneelbordkursuslys';
$string['dashboardrendererdesc'] = 'Beheer hoe die kursuslys op die My Paneelbord-blad uitgebeeld word - as \'n standaard lys of as kursusteëls.';
$string['dashboardrendereroption1'] = 'Kursusteëls';
$string['dashboardrendereroption2'] = 'Verstek lys';
$string['default'] = 'verstek';
$string['defaultcategoryicon'] = 'Verstek kategorie-ikoon';
$string['defaultcategoryicondesc'] = 'Stel as \'n verstek kategorie-ikoon';
$string['defaultlayout'] = 'Verstek';
$string['defaultlayoutdesc'] = 'Kantstafie-uitleg vir verstek bladsye';
$string['displayafterlogin'] = 'Vertoon slegs ná intekening';
$string['displaybeforelogin'] = 'Vertoon slegs voor intekening';
$string['displaymycourses'] = 'Vertoon ingeskrewe kursusse';
$string['displaymycoursesdesc'] = 'Vertoon ingeskrewe kursusse vir gebruikers in die Doelgemaakte Kieslys';
$string['docsheadingdesc'] = 'Bladsyinligting - teks hier om \'n hulpblad vir verstellingsbladsye te skep';
$string['docsheadingsub'] = 'Verstellingsdokumente';
$string['dontdisplay'] = 'Vertoon nooit';
$string['enablealert'] = 'Ontsper waarskuwing';
$string['enablealertdesc'] = 'Laat toe dat boodskap vertoon word. Deur hierdie verstelling te versper, laat ook toe dat die inhoud van die waarskuwing in plek gelaat word, indien dit weer gebruik sou word, maar word nie vertoon nie.';
$string['enablecategoryicon'] = 'Ontsper kategorie-ikone';
$string['enablecategoryicondesc'] = 'Dit sal kategorie-ikone toelaat om vertoon te word, maar slegs \'n verstek ikoon sal gebruik word tensy die doelgemaakte verstellings hieronder ook ontsper word.';
$string['enablecustomcategoryicon'] = 'Ontsper doelgemaakte kategorie-ikone';
$string['enablecustomcategoryicondesc'] = 'Indien ontsper, sal jy onder hierdie afdeling elke kategorie sien met \'n doelmaakbare opsie agter elkeen; berg asseblief ná hierdie opsie ontsper/versper word.';
$string['evenmktingspots'] = 'Ewe breed';
$string['expandtoactivities'] = 'Vou oop om aktiwiteite binne afdelings te vertoon';
$string['expandtoactivitiesdesc'] = 'Deur hierdie opsie te ontsper word aktiwiteite onder die afdelings in die Awesomebar vertoon, maar dit verswak prestasie - veral in kursusse met baie aktiwiteite/hulpbronne.';
$string['facebook'] = 'Facebook-URL';
$string['facebookdesc'] = 'Voer die URL van jou Facebook-blad in (d.w.s. http://www.facebook.com/pukunui)';
$string['falogo'] = 'Boonste Stafie FontAwesome-ikoon';
$string['falogodesc'] = '\'n Font-awesome-ikoon sal slegs vertoon word as geen logoprent vir die boonste stafie opgelaai is nie. Die verstek prent van \'tuis\' sal gebruik word as geen ander ikoon in hierdie verstelling geïdentifiseer is nie. As geen mini-logo\'s egter hierbo bygevoeg is nie, en die \'o\' in die verstelling bygevoeg word, sal geen logo of ikoon op die boonste stafie vertoon nie.<br />\'n Volledige lys FontAwesome-ikone kan gevind word by http://fontawesome.io/icons/';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Sleep jou favicon hierheen om dit op te laai. Let wel: blaaiers berg gewoonlik die favicon in die kasgeheue, dus kan dit nodig wees om jou blaaier se kasgeheue skoon te maak voordat veranderinge gesien word.';
$string['few'] = '\'n Paar';
$string['flexmarketing'] = 'Fleks bemarkingsplekke';
$string['flexmarketingdesc'] = 'Stel of bemarkingsplekke fleks met inhoud, of eweredige breedtes is. Byvoorbeeld: As 3 bemarkingplekke gebruik word en die middelste plek bevat meer inhoud, sal dit \'fleks\' sodat dit groter is as die plekke aan weerskante.';
$string['flexmktingspots'] = 'Fleks met inhoud';
$string['flickr'] = 'Flickr-URL';
$string['flickrdesc'] = 'Voer die URL van jou Flickr-blad in (d.w.s. http://www.flickr.com/mycollege)';
$string['fontfacebody'] = 'Liggaamteks fontaansig';
$string['fontfacebodydesc'] = 'Verskaf die naam van die font wat jy vir die hoof liggaamteks wil gebruik, bv. Ubuntu of Open Sans.';
$string['fontfaceheadings'] = 'Hofieteks fontaansig';
$string['fontfaceheadingsdesc'] = 'Voeg die naam van die font wat jy as hofieteks wil gebruik, in (H1-H6)';
$string['fontfamilybody'] = 'Liggaamteks fontaansig';
$string['fontfamilybodydesc'] = 'Serif of sans-serif. Dit laat toe dat \'n terugval gebruik word as die hooffont nie werk nie (bv. netwerkkoppeling tot die webfont het verlore gegaan).';
$string['fontfamilyheadings'] = 'Hofieteks fontfamilie';
$string['fontfamilyheadingsdesc'] = 'Terugval fonttipe in geval van mislukking (bv. verlore koppeling aan webfontskakeling). Serif/Sans-Serif';
$string['fontheader'] = '';
$string['fontheaderdesc'] = 'Let wel: Fontgroottes van hofies word volgens die liggaamsgrootte bereken om sodoende \'n perspektief te handhaaf. Dit word ook vooraf as vetdruk ingestel (fontgewig:700).<br>Sodra \'n web-gebaseerde font egter hierbo gelaai is, kan dit gebruik word om enige vooraf ingestelde waardes oorheen te skryf, sodat verskillende fonte en gewigte vir elke hofietipe gestel kan word (of vir enige ander css-kieser), soos deur die gebruik van doelgemaaktecss vereis word. Bv. <code>h3 {font-family:"your font", serif;font-weight:900;font-size:18pt;font-color:red</code><br>Wees bewus dat die verandering van daardie fontgroottes per hand kan beteken dat jy die aanpassings van die lynhoogte moet oordink (word ook volgens die liggaam se fontgrootte bereken), asook die kantlyne, om die gepaste voorkoms en gevoel van jou tipografie te handhaaf.';
$string['fontheadingdesc'] = 'Hierdie verstellingsblad laat jou toe om met tot ses verskillende webfonte te skakel (bv. <a href=\'https://www.google.com/fonts\'>Google fonts</a>). Kopieer en plak die <code><link\\></code> kode wat vir jou gekose font verskaf word, in een van die verstellingsbokse. Jy kan op hierdie manier webbeskikbare fonte uit enige bron byvoeg, nie net uit Google nie.';
$string['fontheadingsub'] = 'Fontverstellings';
$string['fontlink'] = 'Fontskakel';
$string['fontlinkdesc'] = 'Vind die webskakel vir die font wat jy wil gebruik. Dit word verskaf deur werwe soos google fonts en ander aanlyn fontwinkels. Kopieer die volledige webskakel na hierdie verstelling, bv. <code>< link href=\'https://fonts.googleapis.com/css?family=Ubuntu:400,700italic,500,700\' rel=\'stylesheet\' type=\'text/css\'\\></code>';
$string['fontsep'] = 'Webfontskakels';
$string['fontsep2'] = 'Fontgebruik';
$string['fontsep2desc'] = 'Let wel: Jy kan enige font gebruik wat oor die algemeen as "web-veilig" beskou word, d.w.s. wat normaalweg op jou gebruikers se rekenaars geïnstalleer sou wees, of enige van die webfonte waarna jy hierbo geskakel het.';
$string['fontsepdesc'] = '';
$string['fontsettings'] = 'Fonte';
$string['fontsizebody'] = 'Grootte van Liggaamfont';
$string['fontsizebodydesc'] = 'Dit kan as px, pt of em gestel wees, maar verseker asseblief dat die eenhede gespesifiseer word.';
$string['frontpagecoursesettings'] = 'Kursusprente';
$string['frontpagedesc'] = 'Konfigureer hoe die prente vir kursusteëls op die voorblad en as kursusprente op die kursusbladsye gebruik word.';
$string['frontpagelayout'] = 'Voorblad';
$string['frontpagelayoutdesc'] = 'Kantstafie-uitleg van die voorblad';
$string['frontpagerenderer'] = 'Voorbladkursusbokse';
$string['frontpagerendererdefaultimage'] = 'Verstek Voorbladkursusteëlprent';
$string['frontpagerendererdefaultimagedesc'] = 'Die verstek prent om vir die voorbladkursusteëls te gebruik wanneer geen kursusprent gevind word nie (van toepassing op Teëls met oorlegging)';
$string['frontpagerendererdesc'] = 'Beheer hoe die kursusbokse op die voorblad uitgebeeld word, met of sonder die oorlegging.';
$string['frontpagerendereroption1'] = 'Teëls';
$string['frontpagerendereroption2'] = 'Teëls met oorlegging';
$string['frontpagesettingsheading'] = 'Kursusprente word gebruik';
$string['generalheadingdesc'] = 'Konfigureer die algemene verstellings van die tema hier.';
$string['generalheadingsub'] = 'Algemene verstellings';
$string['genericsettings'] = 'Algemeen';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Voer die URL van jou Google+ profiel in (d.w.s. https://google.com/+Pukunui/)';
$string['gray'] = 'Grys';
$string['graybase'] = 'Grys Basis';
$string['graybasedesc'] = 'Grys Basis-verstelling - Dit is die kleur wat gebruik word om grys skakerings te skep. Die verstek sal #000 wees, maar dit kan aangepas word as daar \'n behoefte is om kontrasvlakke aan te pas.';
$string['graydark'] = 'Grys Donker';
$string['graydarkdesc'] = 'Grys Donker';
$string['graydarker'] = 'Grys Donkerder';
$string['graydarkerdesc'] = 'Grs Donkerder';
$string['graydesc'] = 'Grys';
$string['graylight'] = 'Grys Lig';
$string['graylightdesc'] = 'Grys Lig';
$string['graylighter'] = 'Grys Ligter';
$string['graylighterdesc'] = 'Grys Ligter';
$string['graylightest'] = 'Grys Ligste';
$string['graylightestdesc'] = 'Grys Ligste';
$string['headerbg'] = '\'n Werfhofie-agtergrondprent';
$string['headerbgdesc'] = 'Hierdie verstelling laat toe dat \'n hofie-agtergrondprent deur die werf vertoon word, alhoewel dit op kursusbladsye oorheengeskryf sal word as kursushofieprente ook gebruik word. Die prent behoort ongeveer 1200 px x 75 px te wees, alhoewel dit kan verskil met die verwagte skermgrootte van die meerderheid van jou gebruikers, of jou institusionele handelsmerkontwerp.<br>Geen verstek prent is by hierdie verstelling gevoeg nie, alhoewel daar etlike voorbeeldprente in die tema se pix-lêer is.';
$string['hidenavigationblock'] = 'Versteek Navigasieblok';
$string['hidenavigationblockdesc'] = 'Hierdie verstelling verwyder die standaard Navigasieblok van alle bladsye.';
$string['hideonphone'] = 'Versteek karousel op mobiele toestelle';
$string['hideonphonedesc'] = 'Kies as jy skyfievertonings op mobiele toestelle wil versper.';
$string['hideontablet'] = 'Versteek karousel op tablette';
$string['hideontabletdesc'] = 'Kies as jy die karousel op tablette wil versper.';
$string['hidesettingsblock'] = 'Versteek Verstellingsblok';
$string['hidesettingsblockdesc'] = 'Hierdie verstelling verwyder die standaard Verstellingsblok van alle bladsye.';
$string['imagebankheading'] = 'Prentebank';
$string['imagebankheadingdesc'] = 'Om die aantal beskikbare prente in die prentebank te verander, verander die \'Aantal prente in die prentebank\' hieronder en berg die bladsy om by te werk.';
$string['imagebankheadingsub'] = 'Sleep die prent wat jy wil gebruik na die dokumentkieser vir elke \'kluis\' en berg die bladsy.';
$string['imagebankimage'] = 'Prent';
$string['imagebankimage_desc'] = 'Prent-URL om te kopieer: \'{$a->imagedesc}\' en gebruik, d.w.s. voeg \'n HTML-wysiger in.';
$string['imagebanksettings'] = 'Prentebank';
$string['instagram'] = 'Instagram-URL';
$string['instagramdesc'] = 'Voer die URL van jou Instagram-blad in (d.w.s. http://instagram.com/mycollege)';
$string['inverse'] = 'inverse';
$string['layoutdesc'] = '<p>Daar is 5 verskillende uitlegte vir jou werfbladsye beskikbaar:</p>
<p><img style=margin:2px;" src ="../theme/image.php?theme=flexibase&amp;image=settings/layout1&amp;component=theme" alt="Pre and Post Layout" title="Pre and Post layout">  <img style=margin:2px;" src ="../theme/image.php?theme=flexibase&amp;image=settings/layout2&amp;component=theme" alt="Two Pre Layout" title="Two Pre layout"/>  <img style=margin:2px;" src ="../theme/image.php?theme=flexibase&amp;image=settings/layout3&amp;component=theme" alt="Two Pre Layout" title="Two Pre layout"/>  <img style=margin:2px;" src ="../theme/image.php?theme=flexibase&amp;image=settings/layout4&amp;component=theme" alt="Two Pre Layout" title="Two Pre layout"/>  <img style=margin:2px;" src ="../theme/image.php?theme=flexibase&amp;image=settings/layout5&amp;component=theme" alt="Two Pre Layout" title="Two Pre layout"/></p>
<p>Daar is ook addisionele blokareas bo- en onderaan en binne die hoofinhoudarea, wat enorme buigsaamheid bied, sonder die nodigheid om uitlegdokumente in die kode te stel. Dit is beskikbaar op al die bladsytipes hieronder en kan gebruik word (of nie) soos nodig. Daar word nie regtig verwag dat enigiemand AL hierdie blokareas op een slag sal gebruik nie, aangesien dit waarskynlik \'n uiters oorvol bladsy sal skep (of \'n baie groot skerm sal vereis). Die addisionele areas word egter verskaf om soveel buigsaamheid as moontlik toe te laat in die ontwerp en uitleg van bladsye, in kombinasie met die vermoë om die hoofuitleg van drie verskillende bladsytipes te verstel, sonder om toegang tot die temakode of om die config.php te moet wysig.<br />Alle uitlegte is ontwerp om met RTL versoenbaar en responsief te wees.<br /></p><p class="alert-warning"><b>LET WEL:</b> Hierdie uitlegopsies word nie in blaaiers toegepas wat glad nie Flexbox ondersteun nie, soos IE 9 en daaronder. Flexbox-nalatenskap en vooraf ingestelde weergawes word ondersteun.</p>';
$string['layoutheading'] = 'Uitleg';
$string['layoutheadingsub'] = 'Stel die uitleg wat deur die bladsye in jou werf gebruik word';
$string['layoutshelp'] = 'Uitleg en Areas Hulp';
$string['legacyflexbox'] = 'Jou Blaaier ondersteun nalatenskap-flexbox-uitlegte, dus, al sou jy hierdie tema kon gebruik soos die bedoeling was, sal sommige van die funksies en uitlegte van hierdie tema moontlik nie beskikbaar wees nie. Vir beste resultate, gradeer asseblief jou blaaier op (IE10+, Firefox22+, Chrome21+, Safari7+)';
$string['lessadditionaldesc'] = 'Addisioneel vir die tema - Hierdie is die sekondêre kleure, gewoonlik ligter/donkerder vorme van die primêre kleure - dit behoort waarskynlik slegs aangepas te word waar kontrasvlakke weens die keuse van handelsmerkkleure verander moet word.<br />Hierdie verstellings is as teksveld gelos, sodat LESS-reëls bygevoeg kan word (soos per die verstek), maar dit kan ook \'n html-kleurnaam, hex-waarde of rgb/rgba-kleurwaarde hê. <br /><b>LET WEL:</b> \'n Fout of tikfout in hierdie velde kan veroorsaak dat die LESS-samesteller misluk en die bladsy teruggestuur word sonder dat CSS toegepas is. <b style="background-color:yellow;">OMTEDOEN</b> Foutlokvalle vir hierdie invoere - moeilik, aangesien daar baie opsionele invoerstyle is, LESS - wat mixins, html-name, hex, rgb(a) kan insluit.';
$string['lessadditionalsettings'] = 'Addisionele LESS';
$string['lessadditionalsub'] = 'Addisionele LESS-verstellings';
$string['lessbranddesc'] = 'Hoofkleure van die tema - Dit is die sleutelkleure waaruit alles gebou word.';
$string['lessbrandsettings'] = 'Hoofkleure van handelsmerk';
$string['lessbrandsub'] = 'Hoofkleure van handelsmerk';
$string['lessvarclick'] = 'LESS-veranderlikes dokument';
$string['lessvariablesfile'] = 'LESS-veranderlikes';
$string['lessvariablesfiledesc'] = 'Vir verwysingsdoeleindes, wanneer die addisonele LESS-verstellings of DoelgemaakteLESS gewysig word, kliek asseblief om \'n teksweergawe van die {$a->url} te sien.';
$string['linkedin'] = 'LinkedIn-URL';
$string['linkedindesc'] = 'Voer die URL van jou LinkedIn-profiel in (d.w.s. http://www.linkedin.com/company/pukunui-technology)';
$string['loggedinas'] = 'ingeteken as';
$string['loggedinfrom'] = 'Ingeteken vanaf';
$string['loginbg'] = 'Intekenagtergrond';
$string['loginbgdesc'] = 'Hierdie verstelling laat toe dat jy \'n agtergrondprent vir die intekenblad oplaai. Die aanbevole prentgrootte is ongeveer 1200 x 800 px, alhoewel dit saam met jou verwagte gebruikerskermgrootte, of saam met jou institusionele handelsmerkontwerp kan verander.';
$string['logo'] = 'Hooflogo van Hofie';
$string['logodesc'] = 'Laai assbelief jou doelgemaakte logo vir die Hoofopskrif hier op as jy dit by die hofie  wil voeg.<br>Gewoonlik is die aanbevole hoogte van hierdie logo 75 px. As jou logo daarvan verskil, kan dit nodig wees dat jy \'n doelgemaaktecss-reël byvoeg om die hoogte van die hofie te wysig, bv. <code>a.logo {height: 100px;}</code>.<br>Jy kan ook doelgemaaktecss byvoeg om die bladsytitel te versteek deur css vertoon met hierdie verstelling te gebruik, bv. <code>.headerlogo h1 {display:none;}</code>.';
$string['mainmenulocation'] = 'Plasing van Hoofkieslysstafie';
$string['mainmenulocationdesc'] = 'Waar die hoofkieslysstafie moet verskyn. Let wel: As die AwesomeBar nie ontsper is nie, sal die kies van die AwesomeBar-plasing veroorsaak dat die hoofkieslys en al sy opsies versteek word.<br><strong>Let wel: Die tema is ontwerp met die hoofkieslys in die onderste stafie (hoofkieslysstafie), soos per die verstek, en dit is tans die enigeste plek waar die kieslys op klein skerms responsief is. Hou dit asseblief in gedagte as jy alternatiewe plasings kies volgens die byvoeging van hierdie verstelling per gebruikersversoek.</strong>';
$string['mainmenusheadingdesc'] = 'Hierdie verstellings laat die werfadmin toe om opsies vir die hoofkieslys te bepaal.';
$string['mainmenusheadingsub'] = 'Opsies vir Hoofkieslysstafie';
$string['marketing1'] = 'Bemarkingsplek Een';
$string['marketing2'] = 'Bemarkingsplek Twee';
$string['marketing3'] = 'Bemarkingsplek Drie';
$string['marketing4'] = 'Bemarkingsplek Vier';
$string['marketingbuttontext'] = 'Skakelteks';
$string['marketingbuttontextdesc'] = 'Teks wat op die knoppie moet verskyn.';
$string['marketingbuttonurl'] = 'Skakel-URL';
$string['marketingbuttonurldesc'] = 'URL waarna die knoppie sal wys.';
$string['marketingcontent'] = 'Inhoud';
$string['marketingcontentdesc'] = 'Inhoud om in die bermarkingsboks te vertoon. Hou dit kort en kragtig. Die inhoud van elke bemarkingsplek word deur \'n html-wysiger verskaf, dus kan dit geformatteerde teks, prente en selfs bootstrap-komponente, soos \'n klein karousel, insluit.';
$string['marketingdesc'] = 'Hierdie tema bied die opsie om vier "bemarking-" of "advertensie"-plekke net onder die skyfievertoning te ontsper. Dit laat jou toe om maklik kerninligting aan jou gebruikers te identifiseer en direkte skakels te verskaf.';
$string['marketingheading'] = 'Bemarkingsplekke';
$string['marketingheadingsub'] = 'Vier plekke op die voorblad om inligting en skakels in te voeg.';
$string['marketingheight'] = 'Hoogte van Bemarkingsprente';
$string['marketingheightdesc'] = 'As jy prente in die Bemarkingsbokse wil vertoon, kan jy die hoogte daarvan hier spesifiseer.';
$string['marketingicon'] = 'Ikoon';
$string['marketingicondesc'] = 'Naam van die ikoon wat jy wil gebruik. Die lys is <a href="http://fontawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer net in wat ná die "fa-" is.';
$string['marketingimage'] = 'Prent';
$string['marketingimagedesc'] = 'Dit bied die opsie om \'n prent bokant die teks in die bemarkingsplek te vertoon.';
$string['marketinginfodesc'] = 'Voer die verstellings van jou bemarkingsplek in.';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Titel om in hierdie bemarkingsplek te vertoon.';
$string['marketingtitleicon'] = 'Opskrifikoon';
$string['marketingtitleicondesc'] = 'Naam van die ikoon wat jy wil gebruik. Die lys is <a href="http://fontawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer net in wat ná die "fa-" is.';
$string['menunavbarcolour'] = 'Kleur van Hoofkieslys se Navstafie';
$string['menunavbarcolourdesc'] = 'Eerder as om die werklike kleur te stel, bepaal hierdie of die hoof-handelsmerkkleure gebruik word, of die omgekeerde (inverse) daarvan.';
$string['menusheadingdesc'] = 'Hierdie verstellings kan gebruik word om kieslysopsies, soos watter items op die Hoofkieslysstafie of in die Gebruikeraftrekkieslys verskyn, en waar die Hoofkieslys verskyn, te beheer. Sommige van die items kan aan beide die hoofkieslys en die gebruikeraftreklys beskikbaar wees - die administrateur moet bepaal op watter plek (of albei) vir hul werf benodig word.';
$string['menusheadingsub'] = 'Verstellings wat verband hou met die Hoof- en Gebruikerkieslyste';
$string['menussettings'] = 'Kieslysverstellings';
$string['messagepreferences'] = 'Boodskapvoorkeure';
$string['minilogo'] = 'Logo van Boonste Stafie';
$string['minilogodesc'] = 'Eerder as (of saam met) die hoof hofielogo, kan jy \'n minilogo boaan die handelsmerkstafie byvoeg. Hierdie ikoon behoort nie meer as 30 px hoog te wees nie, en as een bygevoeg word, sal dit enige fontawesome-ikoon oorheenskryf wat in die verstelling hieronder in die boonste handelsmerkstafie geplaas is.';
$string['mmawesome'] = 'Op die AwesomeBar (indien ontsper).';
$string['mmbranding'] = 'Op die handelsmerkstafie (bo die opskrif)';
$string['mmcalendar'] = 'Hoofkieslys -Kalender';
$string['mmcalendardesc'] = 'Vertoon Kalender-skakel op die Hoofkieslys';
$string['mmdashboard'] = 'Hoofkieslys -Paneelbord';
$string['mmdashboarddesc'] = 'Vertoon Paneelbord-skakel op Hoofkieslys';
$string['mmmain'] = 'Op die Hoofkieslysstafie (onder die opskrif)';
$string['mmsitehome'] = 'Hoofkieslys -Werftuiste';
$string['mmsitehomedesc'] = 'Vertoon Werftuiste-skakel op Hoofkieslys - Dit omseil die herlei na MyTuiste as daardie opsie gekies is';
$string['mmthemehelp'] = 'Hoofkieslys - Temahulp';
$string['mmthemehelpdesc'] = 'Vertoon skakel na temahulp op Hoofkieslys';
$string['mmthiscourse'] = 'Hoofkieslys -Hierdie Kursus';
$string['mmthiscoursedesc'] = 'Vertoon Hierdie Kursus-skakel op Hoofkieslys, binne \'n kursusblad';
$string['myclasses'] = 'My Klasse';
$string['mycourses'] = 'My Kursusse';
$string['mycoursesinfo'] = 'Ingeskrewe kursusse-kieslys';
$string['mycoursesinfodesc'] = 'Vertoon \'n dinamiese lys van ingeskrewe kursusse aan die gebruiker.';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Verander die terminologie van die "My Kursusse"-skakel in die aftrekkieslys';
$string['mygrades'] = 'My Punte';
$string['myhomelayout'] = 'My Tuiste';
$string['myhomelayoutdesc'] = 'Kantstafie-uitleg vir die My Tuiste-paneelbordblad';
$string['mymodules'] = 'My Modules';
$string['myunits'] = 'My Eenhede';
$string['noenrolments'] = 'Jy het tans geen inskrywings nie';
$string['noflexbox'] = 'Jou blaaier ondersteun nie Flexbox-uitlegte nie, dus sal sommige van die funksies en uitlegte van hierdie tema moontlik nie aan jou beskikbaar gestel wees nie. Vir die beste resultate, gradeer asseblief jou blaaier op (IE10+, Firefox22+, Chrome21+, Safari7+)';
$string['none'] = 'geen';
$string['noslidetitle'] = 'Geen titel vir skyfie {$a->slide}';
$string['numberoffonts'] = 'Aantal webfonte';
$string['numberoffontsdesc'] = 'Jy kan kies om tot 6 web-gebaseerde fonte af te laai.';
$string['numberofimagebankimages'] = 'Aantal prente in die prentebank';
$string['numberofimagebankimages_desc'] = 'Stel die aantal prente wat jy in die bank wil berg (tot 16) en berg dan die bladsy. Dit sal \'n dokumentkieser vir elk van die aantal prente wat jy geselekteer het, verskaf.';
$string['numberofslides'] = 'Aantal skyfies';
$string['numberofslides_desc'] = 'Aantal skyfies op die karousel. Jy kan tot 8 skyfies stel.';
$string['pagesadditionalregionsbody'] = 'Drie addisionele areas is by die tema gevoeg.<br /><strong>Slegs Werfadministrateur</strong> - Hierdie area laat die Administrateur toe om blokke in \'n area te voeg wat nie aan gebruikers sigbaar sal wees nie, bv. Adminboekmerke.<br /> <strong>Slegs Kursusonderwysers</strong> - Laat toe dat blokke geplaas word wat slegs aan kursusonderwysers sigbaar is, bv. die plaas van \'n kennisgewing in \'n html-blok wat regoor die werf aan kursusonderwysers sigbaar is (soortgelyk aan die roltoestemmings op \'n individuele blok, maar dit is van toepassing op die hele area en verseker dat daardie blokke altyd op dieselfde plek is)<br /><strong>Waarskuwings</strong> - Hierdie is \'n spesiale area wat boaan die bladsy gevoeg is, wat enigeen met kursuswysigingsregte toelaat om \'n Waarskuwingskennisgewing in \'n html-blok te plaas. Werfwaarskuwings bly deur die Tema-verstellingsbladsye beskikbaar, maar dit kan slegs deur die werfadministrateurs binnegegaan word en vertoon op die voorblad en paneelbord. Hierdie blokarea kan deur enigeen met daardie toestemmings gewysig word en is van toepassing op elke bladsy, wat kursusse insluit. Dit laat toe dat \'n html-blok by \'n individuele kursus of blad gevoeg word, of deur dit te stel om regoor die werf te vertoon deur die normale blokposisioneringsverstellings te gebruik. Blokke wat by hierdie area gevoeg is, se paneelopskrif word versteek wanneer nie in wysigingsmodus nie, daarom lyk dit meer soos \'n waarskuwing.';
$string['pagesadditionalregionshead'] = 'Areas - Addisionele areas vir spesiale doeleindes';
$string['pagesadditionalregionstitle'] = 'Areas - Addisionele areas vir spesiale doeleindes';
$string['pagesadmincloningbody'] = 'As jy enige tema wil wysig of verander, word dit dikwels aanbeveel dat \'n nasaattema van daardie hooftema gemaak word, of om \'n kloon daarvan te maak. Gegewe hoe flexibase Moodle-kern LESS-kompilering gebruik, en die verlengde gebruik van LESS in die verstellingsbladsye, kan die skep van \'n nasaattema in werklikheid meer kompleks word as om \'n kloon te gebruik en te onderhou. Daarom is die aanbeveling om \'n kloon van die tema te gebruik - dit moet egter onderhou word vir stabiele bywerkings met die moedertema.<br>Om \'n kloon van flexibase te skep:';
$string['pagesadmincloninglista'] = 'Kopieer tema';
$string['pagesadmincloninglistb'] = 'Verwyder die /leesmy- en /invoegtoepassing-lêers (nie noodsaaklik nie, dit is nie werkende dele van die tema nie en dus maak dit nie regtig saak of dit daar is of nie, maar dit haal dit uit die pad van herbenaming - Let wel: die /invoegtoepassings-lêer is verwyder uit)';
$string['pagesadmincloninglistc'] = 'Herbenoem lêer';
$string['pagesadmincloninglistd'] = 'Herbenoem taallêer (/lang/en/theme_themename.php)';
$string['pagesadmincloningliste'] = 'Herbenoem LESS-lêer (/less/themename.less)';
$string['pagesadmincloninglistf'] = 'Vind en vervang alle eksemplare van flexibase (insluitend hooflettervariasies)
<pre>Op Linux kan jy \'n grep-opdrag gebruik (ek moes dit 3 maal doen - flexibase, Flexibase en FlexiBase) <br><code>grep -rl "flexibase" /var/www/html/moodle/theme/yourthemename/  | xargs sed -i \'s|flexibase|yourthemename|g\'</code></pre>';
$string['pagesadmincloninglistg'] = 'Installeer soos gewoonlik';
$string['pagesadmincloningtitle'] = 'Kloon van Tema';
$string['pagesadmincssbody'] = 'Die flexibase-tema is geskep met LESS en CSS om die voorkoms en gevoel te skep. Die oorspronklike LESS-veranderlikes en CSS-dokumente wat gebruik is om die tema te skep, kan in die /leesmy-lêer van die tema gevind word vir verwysing. Flexibase gebruik LESS-kompilasie in die verbygaan (wanneer Temaontwerpermodus ontsper is), wat sommige van die verstellings toelaat om van die buigbaarheid van LESS gebruik te maak.<br><br>As ontwerpbesluit is die temakleuropsies beperk tot die hoofhandelsmerkkleure wat in die meeste bootstrap-temas gebruik word, en ligter/donkerder weergawes daarvan. Dit word deur LESS toegepas, maar kan oorheengeskryf word soos nodig vir meer spesifieke vereistes, deur doelgemaakte css te gebruik.<br><br>Een waarskuwing wanneer LESS-verstellings gebruik word - verkeerde CSS sal dikwels eenvoudig deur die blaaier geïgnoreer word, maar verkeerde LESS sal veroorsaak dat die hele LESS misluk en die voorkoms en gevoel van die werf nie uitgebeeld word nie. As dit gebeur, korrigeer of maak eenvoudig jou laaste verandering ongedaan en jou werf behoort na normaal terug te keer. Ek beveel aan dat temaveranderinge deur url ontsper word (in <code>Werfadmin > Voorkoms> Temas> Temaverstellings</code>), wanneer veranderinge aangebring word, aangesien jy dan kan terugval op \'n ander tema soos Clean indien jou veranderinge probleme met jou werf sou veroorsaak.';
$string['pagesadmincsstitle'] = 'CSS en LESS';
$string['pagesadminhelpheading'] = 'Ondersteuning vir Administrateurs';
$string['pagesadmininstallationbottom'] = 'Hoe jy ook al jou tema oplaai, behoort jy dan <code>Werfadministrasie > Kennisgewings</code> te besoek, wat die databasisopgraderingsproses sal sneller en die installasie van die tema sal finaliseer.';
$string['pagesadmininstallationlista'] = 'Gebruik github om die tema te kloon van <a href="https://github.com/roelmann/moodle-theme_flexibase">sy bewaararea.</a>
<pre>cd /path/to/your/moodle/theme<br>git clone https://github.com/roelmann/moodle-theme_flexibase.git flexibase</pre>';
$string['pagesadmininstallationlistb'] = 'Laai die tema af by <a href="https://moodle.org/plugins/theme_flexibase">Moodle-invoegtoepassingsdatabasis</a> en onttrek die lêer na jou /temas-lêer op jou bediener.';
$string['pagesadmininstallationlistc'] = 'Installer uit jou werf-voorkant by <code>Werfadministrasie > Invoegtoepassings > <a href="https://docs.moodle.org/30/en/Installing_plugins">Installeer Invoegtoepassing</a></code>. Dit bied die opsie om direk uit die invoegtoepassingdatabasis te installeer, of om \'n zipdokument te gebruik wat voorheen afgelaai is.';
$string['pagesadmininstallationtitle'] = 'Installasie';
$string['pagesadmininstallationtop'] = 'Daar is etlike maniere om flexibase op jou werf te installeer.';
$string['pagesadminlayoutsbodya'] = 'Daar is twee elemente van bladsyuitlegte in flexibase.';
$string['pagesadminlayoutsbodyb'] = 'Volledige besonderhede en ondersteuning vir die uitlegopsies kan gevind word by <a class="btn btn-info" href="<?php echo $CFG->wwwroot ?>/theme/flexibase/pages/layouthelp.php">Uitleg- en areas-hulp</a> blad.';
$string['pagesadminlayoutslista'] = 'Gedefinieerde uitlegte - Die gedefinieerde uitlegte laat die werfadministrateur toe om \'n vooraf gedefinieerde uitleg vir algemene bladsytipes te stel.';
$string['pagesadminlayoutslistb'] = 'Blokareas - Daar is \'n reeks blokareas in flexibase. Dit laat \'n inhoudskepper (d.w.s. \'n tutor) toe om inhoudblokke te plaas - anders as die aangewese hoofinhoud - in \'n groot verskeidenheid posisies op die bladsy. Daar word nie verwag dat alle areas op enige enkele bladsy gebruik sal word nie, maar dit bied \'n groot hoeveelheid buigbaarheid van uitleg aan die inhoudskepper, sonder die behoefte aan toevoer deur \'n administrateur.';
$string['pagesadminlayoutstitle'] = 'Uitlegte';
$string['pagesadminsettingsbodya'] = 'Die flexibase-tema kan grootliks deur die werfadministrateurs gestuur word deur die verstellingsbladsye, en jy word aangemoedig om hierdie verstellings waar moontlik te gebruik. Dit is omdat temaverstellings sal voortduur wanneer die tema bygewerk word, terwyl kodeveranderinge met \'n bywerking oorheengeskryf sal word.';
$string['pagesadminsettingsbodyb'] = 'Volledige hulp met die temaverstellings kan gevind word by die <a class="btn btn-info" href="<?php echo $CFG->wwwroot ?>/theme/flexibase/pages/settingshelp.php">Verstellingshulpblad</a>.';
$string['pagesadminsettingsbodyc'] = 'Verstellings bestaan vir logo\'s, kleure, kieslyste, fonte, kursushofieprente en baie funksies soos waarskwuings, uitlegte en die voorbladkarousel. Daar is ook doelgemaakte CSS- en doelgemaakte LESS-verstellings om fynere verstellings van temaoorheenskrywings toe te laat.';
$string['pagesadminsettingstitle'] = 'Verstellings';
$string['pagesbscssbodya'] = 'Hierdie voorbeelde uit die bootstrap-tematemplaat by <a href="http://getbootstrap.com/examples/theme/">http://getbootstrap.com/examples/theme/</a></p>
<p><strong>Enige van hierdie dele kan gekopieer en in jou eie inhoud binne Flexibase gebruik word.</strong>';
$string['pagesbscsstitle'] = 'Bootstrap CSS-deeltjies';
$string['pagescontentbuttonsbodybottom'] = 'Jy kan knoppie-klasse op ander voorwerpe toepas, soos &lt;button&gt; of toevoere, maar skakels soos dié hierbo word waarskynlik die meeste gebruik binne inhoud wat deur onderwysers geskep word.';
$string['pagescontentbuttonsbodytop'] = 'Knoppies kan sekere skakels meer aantreklik laat voorkom en konsekwende styl tussen knoppies in die hooftema en skakels binne jou inhoud meebring. Omdat flexibase op bootstrap gebou is, kan jy eenvoudig die bootstrap-klasse gebruik om knoppies by te voeg, soos:';
$string['pagescontentbuttonsdanger'] = 'Gevaar';
$string['pagescontentbuttonsdefault'] = 'Verstek';
$string['pagescontentbuttonsinfo'] = 'Inligting';
$string['pagescontentbuttonspre'] = '&lt;a class="btn btn-default" href="#" role="button"&gt;Default&lt;/a&gt;<br>&lt;a class="btn btn-primary" href="#" role="button"&gt;Primary&lt;/a&gt;<br>&lt;a class="btn btn-info" href="#" role="button"&gt;info&lt;/a&gt;<br>&lt;a class="btn btn-success" href="#" role="button"&gt;Success&lt;/a&gt;<br>&lt;a class="btn btn-warning" href="#" role="button"&gt;Warning&lt;/a&gt;<br>&lt;a class="btn btn-danger" href="#" role="button"&gt;Danger&lt;/a&gt;';
$string['pagescontentbuttonsprimary'] = 'Primêr';
$string['pagescontentbuttonssuccess'] = 'Sukses';
$string['pagescontentbuttonstitle'] = 'Knoppies word bygevoeg';
$string['pagescontentbuttonswarning'] = 'Waarskuwing';
$string['pagescontentcarouselbodybottom'] = 'Jy kan knoppie-klasse op ander voorwerpe toepas, soos &lt;button&gt; of toevoere, maar skakels soos dié hierbo word waarskynlik die meeste gebruik binne inhoud wat deur onderwysers geskep word.';
$string['pagescontentcarouselbodytop'] = 'Alhoewel daar \'n groot karousel vir die werftuisblad in die tema verskaf word, is dit nie noodwendig altyd geskik nie, óf \'n individuele onderwyser kan \'n glyer van inhoud op hul eie kursusblad benodig. Mits die gebruiker vetroud genoeg is om die html hieronder te gebruik en aan te pas om hul eie teks en prente by te voeg (alhoewel slegs beligte lyne in werklikheid aangepas moet word) kan \'n bootstrap-karouselglyer by enige html-blok of inhoudafdelingetiket gevoeg word - blokke self kan dan by enige van die uitlegareas op die bladsy gevoeg word.';
$string['pagescontentcarouselcapone'] = 'Byskrif van eerste skyfie';
$string['pagescontentcarouselcapthree'] = 'Byskrif van derde skyfie';
$string['pagescontentcarouselcaptwo'] = 'Byskrif van tweede skyfie';
$string['pagescontentcarouselnote'] = '&lt;!-- Hierdie lyn is nodig omdat die flexbox wat in flexibox gebruik word, andersins die breedte van die inhoudblok sou aanpas om by die prent te pas, eerder as andersom - pas óf die prentgroottes wat gebruik word reg aan, óf gebruik hierdie omvouer en pas die breedte daarvolgens aan --&gt;';
$string['pagescontentcarouselnxt'] = 'Volgende';
$string['pagescontentcarouselprev'] = 'Vorige';
$string['pagescontentcarouseltitle'] = 'Karousel';
$string['pagescontentfabody'] = 'Flexibase is gebou met fontawesome font-gebaseerde ikone, wat beteken jy kan fontawesome ook in jou eie inhoud gebruik. Daar is \'n <a href="https://moodle.org/plugins/filter_fontawesome">font-awesome filter</a> in die invoegtoepassingsdatabasis beskikbaar om te vermy om in die html in te gaan. As jy egter nie die filter kan installeer nie, kan jy steeds fontawesome-ikone gebruik, hetsy deur die html - as jy van die meer gevorderde effekte wil gebruik, óf vir regtig eenvoudige gebruik - kopieer en plak net die ikoon wat jy wil hê van die <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">fontawesome-ikoonblad</a> af.';
$string['pagescontentfatitle'] = 'Fontawesome word gebruik';
$string['pagescontentimagesbody'] = 'Jy kan die voorkoms van prente beheer deur bootstrap-klasse daarby te voeg - as jy die TinyMCE-wysiger gebruik, laat die prentinvoegfunksie jou toe om klasse by te voeg, as jy Atto gebruik (die verstek wysiger), kan dit nodig wees dat jy die html binnegaan:<br><br>Prente in Bootstrap 3 kan responsief-vriendelik gemaak word via die byvoeging van die .img-responsiewe klas.<br><code>&lt;img src="..." class="img-responsive" alt="Responsive image"&gt;</code><br><br>en jy kan vorms by \'n prent voeg:';
$string['pagescontentimagestitle'] = 'Beheer van Prente';
$string['pagescontentpanelsbodybottom'] = 'As dit \'n eenmalige paneel is, sou jy \'n css-reël kon byvoeg soos: style="width:200px; float:right" in die aanvanklike <code>div class=panel</code> lyn om \'n deurbraakbokspaneel te skep. Alternatiewelik, as jy dit gereeld gaan gebruik, kan jy \'n klas byvoeg en doelgemaaktecss vir stilering van jou eie panele skep. (Hierdie spesifieke wenkeblad het nie ten doel om meer gevorderde onderwerpe, soos doelgemaakte stilering, te behandel nie, aangesien dit slegs deur die werfadministrateur bygevoeg kan word.)<br><br>Die klas "paneel-gevaar" kan vervang word met enige van die ander standaard bootstrap-tipes - paneel-primêr, paneel-sukses, paneel-waarskuwing, paneel-gevaar, paneel-inligting, of paneel-verstek, vir verskillende kleurkombinasies.';
$string['pagescontentpanelsbodytop'] = 'Hierdie hulpbladsye bestaan uit panele. Dit kan gebruik word om, byvoorbeeld, boks-uit inligting by jou inhoud te voeg.';
$string['pagescontentpanelspre'] = '&lt;div class="panel panel-danger"&gt;<br>    &lt;div class="panel-heading"&gt;<br>        &lt;h3 class="panel-title"&gt;your Heading&lt;/h3&gt;<br>    &lt;/div&gt;<br>    &lt;div class="panel-body"&gt;<br>        &lt;p&gt;Your content.&lt;/p&gt;<br>    &lt;/div&gt;<br>&lt;/div&gt;';
$string['pagescontentpanelstitle'] = 'Panele word gebruik';
$string['pagescontenttabsbodybottom'] = 'Jy kan knoppie-klasse op ander voorwerpe toepas, soos &lt;button&gt; of toevoere, maar skakels soos dié hierbo word waarskynlik die meeste gebruik binne inhoud wat deur onderwysers geskep word.';
$string['pagescontenttabsbodytop'] = 'Oortjies kan \'n baie nuttige manier wees om inhoud binne een area te vertoon en die "rol van die dood" te vermy. Dit kan egter ongemaklik wees om by te voeg as die gebruiker nie gemaklik is met die gebruik van html nie, aangesien daar meer is om by jou eie doelwitte aan te pas as met, byvoorbeeld, knoppies.';
$string['pagescontenttabshc'] = 'Inhoud van Tuis-oortjie';
$string['pagescontenttabshome'] = 'Tuis';
$string['pagescontenttabspc'] = 'Inhoud van Profiel-oortjie';
$string['pagescontenttabsprofile'] = 'Profiel';
$string['pagescontenttabssc'] = 'Inhoud van Verstellings-oortjie';
$string['pagescontenttabssetting'] = 'Verstellings';
$string['pagescontenttabstitle'] = 'Oortjies word bygevoeg';
$string['pagescontenttitle'] = 'Nuttige kode-deeltjies';
$string['pagescontenttopbody'] = 'Hoewel die Bootstrap-CSS en Komponente op die toepaslike knoppies hierbo gevind kan word, het hierdie blad ten doel om net \'n paar van die meer nuttiges op een plek byeen te bring vir \'n vinnige verwysing en hoe dit in die inhoud binne die flexibase-tema gebruik kan word. Let wel: Omdat flexibase rondom Bootstrap 3 gebou is, sal sommige van hierdie funksies nie werk as jy die tema dan na \'n Bootstrap 2-gebaseerde tame verander nie, of na \'n ouer tema sonder enige bootstrap-fondament.';
$string['pagescustomblocksbodya'] = 'Flexibase beeld die blokke as panele uit en gebruik paneel-primêre kleure om die blokke te stileer. Dit kan in doelgemaakteLESS-verstellings oorheengeskryf word, hetsy vir alle blokke of selfs vir individuele blokke, wat verskillende kleure volgens vereiste verskaf. Byvoorbeeld: <br><br>Alle blokhofies - dit kan in doelgemaakte css eerder as doelgemaakte LESS gaan, indien so verkies.';
$string['pagescustomblocksbodyb'] = 'Die navigasieblok word spesifiek geteiken deur die klaskieser (soos wat dit hieronder geskryf is, sou dit doelgemaakte LESS wees, maar in geval van \'n eenvoudige agtergrond soos hierbo, kan dit in Doelgemaakte CSS gaan).';
$string['pagescustomblocksbodyc'] = 'LESS-veranderlikes binne doelgemaakteLESS word gebruik om die opskrif van die kalenderblok te verander.';
$string['pagescustomblockstitle'] = 'Blokhofies';
$string['pagescustomcsslessbody'] = 'Om met enige CSS- of LESS-doelmaking te help, word die volledige tema-CSS en die flexibase-temaveranderlikes.less en flexibase.less ook as teksdokumente in die tema /leesmy-lêer verskaf. Die aanbeveling is om hierdie apart na \'n nuttige plek te ekstraheer, sodat \'n mens sonder toegang tot die bedienerdokumente na hulle kan verwys, wanneer enige voorkant-doelmaking uitgevoer word.<br><br>Omdat LESS in die vergygaan gekompileer word, kan die gebruik van Temaontwerpermodus bladuitbeeldig uiters stadig maak. Dit is te verwagte en is nie \'n probleem wanneer TDM versper en alle gegenereerde CSS gekaseer word nie. Nog iets om op te let wat die doelmaak van LESS betref is dat, terwyl foute in CSS dikwels geïgnoreer word of onverwagse visuele resultate tot gevolg het, sal foute in LESS veroorsaak dat die kompilering misluk en hoegenaamd geen styl op die werf toegepas sal word nie. In hierdie geval moet jy jou laaste veranderinge omkeer, waarna die werf dan na normaal terug behoort te keer. Dit is daarom wat die LESS-dokumente as verwysingsteksdokumente beskikbaar gemaak is - om die voorkoms van potensiële foute in enige doelmakings te verminder.<br><br>Wanneer enige temadoelmaking uitgevoer word, hetsy aan kode of aan verstellings, word jy ook aangeraai om te verseker dat die algemene temaverstelling "Laat Temaveranderinge in URL toe" ontsper is. Dit sal jou toelaat om op die Clean-tema terug te val in die onwaarskynlike geval dat jou veranderinge veroorsaak dat flexibase misluk.';
$string['pagescustomcsslesstitle'] = 'LESS/CSS verwysing en doelmaking';
$string['pagescustomisationbody'] = '<strong>Let wel:</strong> doelmakings aan kernkode behoort gewoonlik deur \'n kloon van die tema gedoen te word om probleme, wat met bywerking kan voorkom, te vermy (Sien meer besonderhede op die <a href="adminhelp.php" class="btn btn-info">Adminhulpblad</a>).';
$string['pagescustomisationtitle'] = 'Temadoelmaking vir Administrateurs';
$string['pagescustompixcorebody'] = 'Flexibase het \'n stel pix_core-ikone, waarvan die kleur verander word om met die verstek kleurskema van die tema ooreen te stem. Dit is moontlik nie vir almal geskik nie, dus bevat die pix_core-lêer dieselfde stel svg-ikone wat in aparte lêers as /blou (die tema verstek), /rooi, /geel en /groen herkleur is. Vervang eenvoudig die bestaande ikone met dié uit die verkose kleurstel, indien nodig. As jy na die verstek grys Moodle-ikone wil terugkeer, wis eenvoudig die pix_core-lêer uit, en die tema sal nie meer die kernikone oorheenskryf nie.<br><br>Dit is moontlik om \'n stel ikone met jou eie kleurskema te skep deur hulpmiddels op die internet te gebruik en die bestaande ikone met jou eie kleurskema te vervang. Een manier om dit op \'n Linux-rekenaar te doen is om \'n bash-opdrag, soos <code>grep -rl "2fa4e7" path/to/your/pix_core/folder  | xargs sed -i \'s|2fa4e7|86fb96|g\'</code> te gebruik, waar 2fa4e7 die blou kleur van die bestaande ikone en 86fb96 die nuwe kleur is (as HEX-waardes).<br><br>Let wel: As jy dit binne flexibase doen in plaas van in jou eie kloon, word jy aangeraai om \'n aparte kopie van jou herkleurde ikoonstel te bewaar, sodat jy dit maklik vervang wanneer jy die tema bywerk.';
$string['pagescustompixcoretitle'] = 'Pix_Core-ikone';
$string['pagesettingmmoptions'] = 'Jy kan kies om te wys:';
$string['pagesettingsabblocks'] = 'Omdat die funksionaliteit van hierdie blokke deur die AwesomeBar gedupliseer word, bied dit jou die opsie om dit te versteek. As persoonlike aanbeveling: Ek laat dit gewoonlik vertoon, maar konfigureer dit na verstek in die werfadministrateursarea onderaan die skerm.';
$string['pagesettingsadditionallead'] = 'Addisionele kleure vir die tema - Hierdie is sekondêre kleure, gewoonlik ligter/donkerder vorms van die primêre kleure.</p><p>Dit behoort waarskynlik net aangepas te word waar kontrasvlakke weens die keuse van handelsmerkkleure verander moet word.<br>Hierdie verstellings is as teksveld (eerder as \'n kleurkieser) gelaat, sodat LESS-reëls bygevoeg kan word (soos per die verstek), maar dit kan ook \'n html-kleurnaam, hex-waarde of rgb/rgba-kleurwaarde stel.';
$string['pagesettingsalertsdesc2'] = 'Kleur';
$string['pagesettingsbrandbody1'] = 'Hierdie verstellingsblad bevat ook die velde van die skakerings van grys, gebaseer op die grys-basis verstelling op die Hoof-handelsmerkkleureblad.';
$string['pagesettingsbrandbody2'] = '\'n Addisionele LESS-verstelling vir <strong>rantradius</strong> word ook op hierdie bladsy gevind, aangesien dit gebruik word in die LESS-veranderlikes om ook die radius van kleiner en groter vorms te bereken.';
$string['pagesettingsbrandlead'] = '9 hoof-handelsmerkkleurverstellings word as kleurkiesers verskaf, alhoewel die hex-kleurwaarde, html-herkende kleurnaam, of rgb-kodes ook in die teksboks met elke kleurkieser ingevoer kan word. Die kleurverstellings is die hoofverstellings wat in bootstrap/bootswatch-temas gebruik word om versoenbaarheid van ander bootswatches te verseker, as basis vir die herontwerp van jou temakleure. Hierdie is die sleutelkleure waaruit die tema gebou is.<br />Kleurkiesers word verskaf vir:';
$string['pagesettingscarouselhead'] = 'Hoof-karouselverstellings';
$string['pagesettingscarouselhead2'] = 'Skyfieverstellings';
$string['pagesettingscategorycustom'] = 'Hierdie area sal elk van die beskikbare kategorieë/subkategorieë lys en sal \'n doelgemaakte fontawesome-ikoonnaam by daardie kategorie laat voeg. Let wel: jy benodig nie die \'fa-\' gedeelte van die naam nie, slegs die werklike naam van die ikoon, alhoewel, as jy ook ander fa-effekte wil byvoeg, kan jy dit ná die ikoonnaam byvoeg, en dit sal die fa- gedeelte benodig.';
$string['pagesettingscategoryhead'] = 'Algemene kategorie-ikoonverstellings';
$string['pagesettingscourseimagelead'] = 'Hierdie verstellingsblad beheer die voorbladkursusteëls en die kursusblad-hofieprente<br><br>Die kursusteëls en hofieprente is in die kursusblad self as die kursusopsommingsdokument gestel (Kursusadministrasie > Wysig Verstellings > Kursusopsommingsdokumente). As jy die Werfadministrasie > Voorkoms > Kursusse > Kursusopsommingsdokument-beperking stel om meer as een dokument toe te laat, kan jy verskillende prente vir beide die voorbladkursusteël (eerste prent) en die kursushofieprent (laaste prent) gebruik.';
$string['pagesettingscustomsocial'] = 'Doelgemaakte Sosiale Skakels';
$string['pagesettingscustomsocialdesc'] = 'Daar is ook drie doelgemaakte skakels waar jy beide \'n URL en \'n geassosieerde fontawesome-ikoon kan byvoeg. Dit stel jou in staat om instelling-spesifieke skakels te teiken (bv. interne bladsy op \'n intranetwerf) of nuwe/streektegnologie wat nie as deel van die temaversteklys toegepas is nie.';
$string['pagesettingsfontuploads'] = 'Tans word individuele fontdokument oplaaie nie ondersteun nie, alhoewel dit in die toekomsplan vir hierdie tema is.';
$string['pagesettingsgenericlead'] = 'In flexibase het alle verstellings wat LESS- of CSS-waardes affekteer, \'n terugroep, wat outomaties die kasgeheue skoonmaak. Dit kan die bladsy se laaityd affekteer wanneer jy veranderinge berg, maar vermy die behoefte vir temaontwerpersmodus of skrapping van kasgeheue.';
$string['pagesettingsimagebank'] = 'Prent 1, Prent 2 ...';
$string['pagesettingsimagebankdesc'] = 'As die Prentebank self slegs aan werfadministrateurs beskikbaar is, kan dit werd wees om te oorweeg om \'n kopie van daardie URL-skakels iewers te hou wat toeganklik aan ander is wat dit mag nodig hê (as dit vir gebruik deur enigiemand anders as die werfadministrateur is).';
$string['pagesettingsmarketinghead'] = 'Algemene Bemarkingsplek-verstellings';
$string['pagesettingsmarketinghead2'] = 'Bemarkingsplek-verstellings - Plek1, Plek2 ...';
$string['pagesettingspresetsocial'] = 'Vooraf ingestelde sosiale ikone';
$string['pagesettingspresetsocialdesc'] = 'Die algemeenste skakels word met vasgestelde ikone verskaf, dus hoef jy net jou toepaslike URL by te voeg. As geen URL verskaf word nie en die verstelling leeg gelaat word, sal die ikoon nie vertoon word nie, dus kry jy slegs die ikone wat jy wil hê.';
$string['pageshelplinks'] = 'Hulpbladskakels:';
$string['pageslayoutsadminbody'] = 'Flexibase het 5 verskillende kiesbare uitlegte vir 4 van die hoof bladsytipes.<br><br>Hierdie uitlegte kan op die verstek bladsy, voorblad, kursusblad of my tuisblad toegepas word. Een addisionele nota is die twee uitlegte met enkele kantstawe, dus gebruik dit in werklikheid beide side-pre en side-post, maar dit vertoon side-post onder side-pre in \'n enkele visuele area. Hoewel geen \'slegs inhoud\'-uitleg verskaf word nie, kan dit maklik verkry word deur alle blokke uit alle areas te verwyder - die hoof inhoudspasie sal vergroot om die hele bladsy te vul.';
$string['pageslayoutsadminhead'] = 'Uitlegte - vir administrateurs';
$string['pageslayoutsadmintitle'] = 'Uitlegte - vir administrateurs';
$string['pageslayoutsdiagramstitle'] = 'Uitlegdiagramme';
$string['pageslayoutsregionsbody'] = 'Soos in die diagramme getoon, het Flexibase ook \'n verskeidenheid areas om inhoudblokke te dra. Hierdie blokke kan die vooraf gedefinieerde blokke wees (Skakel Wysiging Aan > Voeg \'n Blok by) of jy kan uit daardie lys \'n HTML-blok byvoeg, wat jou toelaat om jou eie inhoud by enige area wat op die bladsy gebruik word, te voeg. As ontwerpwenk - die aantal areas word verskaf om aanpasbaarheid toe te laat. Daar word nie verwag dat die meeste werwe elke area op enige enkele bladsy sal gebruik nie. Hoewel dit in enkele gevalle toepaslik kan wees, sal dit waarskynlik \'n baie besige voorkoms aan die bladsy verleen en in die meerderheid gevalle die aandag van die inhoud aftrek.';
$string['pageslayoutsregionshead'] = 'Areas - vir inhoudskeppers';
$string['pageslayoutsregionstitle'] = 'Areas - vir inhoudskeppers';
$string['pageslayoutstitle'] = 'Uitlegte en Areas';
$string['pagessettingsbody'] = '';
$string['pagessettingsfontslead'] = 'Hierdie verstelling laat jou toe om met tot 6 web-gebaseerde fonte (bv. Google fonts) te skakel. Dit laat jou ook toe om fonte op sekere areas van jou tipografiestilering toe te pas en die verstek temafonte oorheen te skryf.';
$string['pagessettingsfontsnumber'] = '- Jy kan met tot 6 webfonte skakel. Dit kan maklik in die temakode uitgebrei word, maar voordat sulke kodeveranderinge aangebring word, behoort jy eers die impak van toekomstige bywerkings te oorweeg (d.w.s. volg aanbevole praktyk en bring kodeveranderinge in jou eie kloon-/nasaattema aan), en ook of jy regtig meer as 6 fonte in jou werfontwerp wil hê (bykomend tot die web-veilige verstek fonte wat op die meeste rekenaars geïnstalleer is). Die verstelling behoort na 0 as verstek terug te keer, en jy sal eers daardie getal moet verander en die bladsy berg. Wanneer die bladsy verfris, sal jy dan die aantal Fontskakelverstellings wat jy gekies het om te gebruik, ontvang.';
$string['pagessettingslayoutbody'] = 'Daar is ook addisionele blokareas aan die bo- en onderkant en binne die hoofinhoudarea, wat enorme buigbaarheid bied, sonder die nodigheid om uitlegdokumente in die kode te stel. Dit is op al die bladsytipes hieronder beskikbaar en kan gebruik word (of nie) soos nodig. Daar word nie regtig verwag dat enigemand AL hierdie blokareas op een bladsy sal gebruik nie, aangesien dit waarskynlik \'n oorvol bladsy sal skep (of \'n baie groot skerm sal benodig). Die addisionele areas word egter verskaf om soveel as moontlik buigbaarheid in die ontwerp en uitleg van die bladsye toe te laat, saam met die vermoë om die hoofuitleg van verskillende bladsye aan te pas sonder om toegang tot die temakode te verkry of die config.php te wysig.<br>Alle uitlegte is ontwerp om RTL-versoenbaar en repsonsief te wees.<br><br>Die bladsye waarop jy hierdie uitlegte kan toepas, is:';
$string['pagessettingslayoutcourse'] = 'Kursusbladsye';
$string['pagessettingslayoutdash'] = 'My Tuiste/Paneelbord';
$string['pagessettingslayoutdefault'] = 'Verstek';
$string['pagessettingslayouthome'] = 'Werfvoorblad';
$string['pagessettingslayoutlead'] = 'Daar is 5 uitlegte vir jou werfbladsye beskikbaar:';
$string['pagessettingslead'] = 'Inligting om met die gebruik van die verstellingsbladsye in Flexibase te help. Temaverstellingsbladsye is slegs aan werfadministrateurs beskikbaar.';
$string['pagessettingstitle'] = 'Verstellingsbladsye Hulp';
$string['pinterest'] = 'Pinterest-URL';
$string['pinterestdesc'] = 'Voer die URL van jou Pinterest-blad in (d.w.s. http://pinterest.com/mycollege)';
$string['pluginname'] = 'FlexiBase';
$string['preandpost'] = 'Pre- en Post-kantstafies';
$string['readme_click'] = 'kliek vir LEESMY.txt';
$string['readme_desc'] = 'Asseblief {$a->url} bevat meer inligting oor die FlexiBase-tema.';
$string['readme_title'] = 'FlexiBase-leesmy';
$string['readmore'] = 'Lees meer';
$string['region-side-adminbottom'] = 'Slegs Werfadministrateur';
$string['region-side-alert'] = 'Opsionele Waarskuwingsarea';
$string['region-side-bottom'] = 'Onder';
$string['region-side-mainbottom'] = 'Hoofinhoud Onder';
$string['region-side-mainpost'] = 'Hoofinhoud Regs';
$string['region-side-mainpre'] = 'Hoofinhoud Links';
$string['region-side-maintop'] = 'Hoofinhoud Bo';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['region-side-teachbtm'] = 'Slegs Kursusonderwysers';
$string['region-side-top'] = 'Bo';
$string['rendereroverlaycolour'] = 'Kleur van oorlegging';
$string['rendereroverlaycolourdesc'] = 'Die kleur van die oorlegging, wanneer die "Teëls met oorlegging"-uitbeelder gekies is.';
$string['rendereroverlayfontcolour'] = 'Fontkleur van oorlegging';
$string['rendereroverlayfontcolourdesc'] = 'Die kleur van die font, wanneer oor \'n kursusboks met "Teëls met oorlegging"-uitbeelder ontsper, gesweef word.';
$string['settingsdocs'] = 'Verstellingsbladsye Hulpdokumente';
$string['settingshelp'] = 'Verstellings Hulp';
$string['showawesomebar'] = 'Vertoon AwesomeBar';
$string['showawesomebardesc'] = 'Bepaal of die AwesomeBar hoegenaamd gebruik word';
$string['showlogo'] = 'Vertoon Hoof-Hofielogo';
$string['showlogodesc'] = 'Hierdie verstelling bepaal of die hoof-hofielogo op net die voorblad (en My Paneelbord) vertoon word, of regdeur die werf - Let wel: as jy glad nie \'n hoof-hofielogo wil vertoon nie, laat die bogemelde dokumentkieser leeg.';
$string['showlogoeverywhere'] = 'Alle bladsye';
$string['showlogofrontonly'] = 'Slegs Voorblad';
$string['singlepost'] = 'Enkele kantstafie - Post';
$string['singlepre'] = 'Enkele kantstafie - Pre';
$string['skype'] = 'Skype-rekening';
$string['skypedesc'] = 'Voer die Skype-gebruikersnaam van jou instelling se Skype-rekening in';
$string['slidecaption'] = 'Skyfiebyskrif';
$string['slidecaptiondesc'] = 'Voer die byskrifteks in om vir die skyfie te gebruik. Dit is skoonteks en sluit nie html in nie.';
$string['slideimage'] = 'Skyfieprent';
$string['slideimagedesc'] = '\'n Dokumentkieser om jou prente te sleep. Verseker verkieslik dat al jou prente dieselfde grootte is.';
$string['slideno'] = 'Skyfie {$a->slide}';
$string['slidenodesc'] = 'Voer die verstellings van skyfie {$a->slide} in.';
$string['slidetitle'] = 'Skyfietitel';
$string['slidetitledesc'] = 'Voer \'n beskrywende titel vir jou skyfie in';
$string['slideurl'] = 'Skyfieskakel';
$string['slideurldesc'] = 'Voer die teikenbestemming van die skyfie se prentskakel in';
$string['socialdesc'] = 'Verskaf direkte skakels na die kern sosiale netwerke wat jou handelsmerk promoveer. Dit sal in die hofie van elke bladsy verskyn.';
$string['socialheading'] = 'Sosiale Netwerkwerk';
$string['socialheadingsub'] = 'Interreageer met jou gebruikers deur sosiale netwerkwerk.';
$string['sociallink'] = 'Doelgemaakte Sosiale Skakel';
$string['sociallinkdesc'] = 'Voer die URL van jou doelgemaakte sosiale mediaskakel in (d.w.s. http://www.moodleman.net)';
$string['sociallinkicon'] = 'Skakelikoon';
$string['sociallinkicondesc'] = 'Voer die fontawesome-naam van die ikoon van jou skakel in.<br />\'n Volledige lys van FontAwesome-ikone kan gevind word by http://fontawesome.io/icons/';
$string['socialnetworks'] = 'Sosiale Netwerke';
$string['stylemarketing'] = 'Stileer Bemarkingsplekke';
$string['stylemarketingblocks'] = 'Blokstyl';
$string['stylemarketingdesc'] = 'Stel of bemarkingsplekke vertoon word as plekke met groot ikone, of as \'standaard\' blokstilering.';
$string['stylemarketingspots'] = 'Ikoonplekstyl';
$string['thiscourse'] = 'Hierdie kursus';
$string['togglemarketing'] = 'Bemarkingsplekvertoon';
$string['togglemarketingdesc'] = 'Kies of jy die vier Bemarkingsplekke wil versteek of vertoon.';
$string['toggleslideshow'] = 'Tokkel Karouselvertoon';
$string['toggleslideshowdesc'] = 'Kies of jy die karousel wil versteek of vertoon.';
$string['topbarcolour'] = 'Kleur van boonste NavStafie';
$string['topbarcolourdesc'] = 'Eerder as om die kleur self te stel, bepaal dit of die hoof handelsmerkkleur of die omgekeerde daarvan gebruik word.';
$string['tumblr'] = 'Tumlbr-URL';
$string['tumblrdesc'] = 'Voer die URL van jou Tumblr in (d.w.s. http://moodleman.tumblr.com)';
$string['twitter'] = 'Twitter-URL';
$string['twitterdesc'] = 'Voer die URL van jou Twitter-voer in (d.w.s. http://www.twitter.com/pukunui)';
$string['twopost'] = 'Twee kantstafies - Post';
$string['twopre'] = 'Twee kantstafies - Pre';
$string['umbadgepreferences'] = 'Gebruikeskieslys - Kentekenvoorkeure';
$string['umbadgepreferencesdesc'] = 'Vertoon Kentekenvoorkeurskakel in Gebruikerskieslys';
$string['umbadges'] = 'Gebruikerskieslys - Kentekens';
$string['umbadgesdesc'] = 'Vertoon Kentekenskakel in Gebruikerskieslys';
$string['umblogpreferences'] = 'Gebruikerskieslys - Blogvoorkeure';
$string['umblogpreferencesdesc'] = 'Vertoon Blogvoorkeurskakel in Gebruikerskieslys';
$string['umcalendar'] = 'Gebruikerskieslys - Kalender';
$string['umcalendardesc'] = 'Vertoon Kalenderskakel in Gebruikerskieslys';
$string['umdashboard'] = 'Gebruikerskieslys - Paneelbord';
$string['umdashboarddesc'] = 'Vertoon Paneelbordskakel in Gebruikerskieslys';
$string['umdiscussions'] = 'Gebruikerskieslys - Forumbesprekings';
$string['umdiscussionsdesc'] = 'Vertoon Forumbesprekingskakel in Gebruikerskieslys';
$string['umeditprofile'] = 'Gebruikerskieslys - Wysig Profiel';
$string['umeditprofiledesc'] = 'Vertoon Wysig Profiel-skakel in Gebruikerskieslys';
$string['umfiles'] = 'Gebruikerskieslys - Private Dokumente';
$string['umfilesdesc'] = 'Vertoon Private Dokumente-skakel in Gebruikerskieslys';
$string['umgrades'] = 'Gebruikerskieslys - My Punte';
$string['umgradesdesc'] = 'Vertoon My Punte-skakel in Gebruikerskieslys';
$string['umlogout'] = 'Gebruikerskieslys - Uitteken';
$string['umlogoutdesc'] = 'Vertoon Uittekenskakel in Gebruikerskieslys';
$string['ummessagepreferences'] = 'Gebruikerskieslys - Boodskapvoorkeure';
$string['ummessagepreferencesdesc'] = 'Vertoon Boodskapvoorkeurskakel in Gebruikerskieslys';
$string['ummessages'] = 'Gebruikerskieslys - Boodskappe';
$string['ummessagesdesc'] = 'Vertoon Boodskapskakel in Gebruikerskieslys';
$string['umpassword'] = 'Gebruikerskieslys - Verander Wagwoord';
$string['umpassworddesc'] = 'Vertoon Verander Wagwoord-skakel in Gebruikerskieslys';
$string['umposts'] = 'Gebruikerskieslys - Forumplasings';
$string['umpostsdesc'] = 'Vertoon Forumplasingskakel in Gebruikerskieslys';
$string['umpreferences'] = 'Gebruikerskieslys - Voorkeure';
$string['umpreferencesdesc'] = 'Vertoon Gebruikervoorkeurskakel in Gebruikerskieslys';
$string['umprofile'] = 'Gebruikerskieslys - Profiel';
$string['umprofiledesc'] = 'Vertoon Profielskakel in Gebruikerskieslys';
$string['usecategoryicon'] = 'Ontsper kategorie-ikone';
$string['usecategoryicondesc'] = 'Gebruik doelgemaakte ikone vir kategorieë';
$string['usermenus'] = 'Doelgemaakte Gebruikerskieslys';
$string['usermenusdesc'] = 'Hierdie opsie vervang die hoof-gebruikerskieslysopsie op die Voorkoms > Temas > Verstellingsblad.<br>Dit is in die formaat naam|url|fontawesome-ikoonnaam<br>bv. <br><pre>My Profiel|/user/profile.php|user<br>
Boodskappe|/message/index.php|envelope</pre>';
$string['usermenusheadingdesc'] = 'Hierdie verstellings laat toe dat die werfadmin bepaal watter items op die gebruikeraftrekkieslys verskyn.<br>Daar is tans geen opsie om hierdie items te hersorteer nie, maar dit kan egter in die hoofopsies versteek word en dan in \'n ander volgorde by die doelgemaakte gebruikerskieslys-verstellingsboks gevoeg word.';
$string['usermenusheadingsub'] = 'Gebruikeraftrekkieslys-opsies';
$string['vimeo'] = 'Vimeo-URL';
$string['vimeodesc'] = 'Voer die URL van jou Vimeo-kanaal in (d.w.s. http://vimeo.com/moodleman)';
$string['vk'] = 'VKontakte-URL';
$string['vkdesc'] = 'Voer die URL van jou VKontakte-blad in (d.w.s. http://www.vk.com/mycollege)';
$string['website'] = 'Webwerf-URL';
$string['websitedesc'] = 'Voer die URL van jou eie webwerf in (d.w.s. http://www.pukunui.com)';
$string['white'] = 'Wit';
$string['whitedesc'] = 'Wit verstelling - Verstek sal #fff wees, maar dit kan aangepas word as daar \'n behoefte is om kontrasvlakke aan te pas.';
$string['youtube'] = 'YouTube-URL';
$string['youtubedesc'] = 'Voer die URL van jou YouTube-kanaal in (d.w.s. http://www.youtube.com/moodleman)';
