<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'turnitintooltwo', language 'af', version '4.1'.
 *
 * @package     turnitintooltwo
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activatemigration'] = 'Ontsper Migrasiehulpmiddelverstellings';
$string['activatemigrationnotice'] = 'Met aktivering van die Moodle-migrasiehulpmiddel, word die V1-migrasie-oortjie in die Turnitin Opdrag 2-verstellings vertoon.<br>Kies die oortjie om die hulpmiddel te bestuur (ook om die gebruik daarvan te versper en enige gemigreerde V1-opdragte te verwyder).';
$string['addresubmissiontiidesc'] = 'Gebruiker-herindiening is aan Turnitin gestuur';
$string['addsubmission'] = 'Voeg Indiening by';
$string['addsubmissiondesc'] = 'Gebruiker-bygevoegde indiening';
$string['addsubmissiontiidesc'] = 'Gebruikerindiening aan Turnitin gestuur';
$string['allowlate'] = 'Laat Indienings ná die Sperdatum toe';
$string['allownonor'] = 'Laat indiening van enige dokumenttipe toe?';
$string['allownonor_help'] = 'Hierdie verstelling sal enige dokumenttipe ingedien laat word. Met hierdie opsie na "Ja" gestel, sal indienings nagegaan word vir ooreenkomste waar moontlik, indienings sal vir aflaai beskikbaar wees en GradeMark-terugvoerhulpmiddels sal waar moontlik beskikbaar wees.';
$string['allsubmissions'] = 'Indieninginkas';
$string['anon'] = 'Anoniem';
$string['anonalert'] = 'Jou plasingsdatum is voor jou huidige tyd, dit sal anonieme nasien vir hierdie opdrag permanent versper as jy dit berg.';
$string['anonblindmarkingnote'] = 'Let wel: Die aparte Turnitin anonieme nasienverstelling is verwyder. Turnitin sal Moodle se blinde nasienverstelling gebruik om die anonieme nasienverstelling te bepaal.';
$string['anonenabled'] = 'Anonieme Nasien Ontsper';
$string['anytype'] = 'Enige Indieningstipe';
$string['assigngeterror'] = 'Kon nie Turnitintooltwo-data verkry nie';
$string['assignmentid'] = 'V1 Opdrag-ID';
$string['assignments'] = 'opdragte';
$string['assignmenttitle'] = 'Nuwe Opdragtitel';
$string['attachrubric'] = 'Voeg \'n rubriek by hierdie opdrag';
$string['attachrubricnote'] = 'Let wel: Studente sal aangehegte rubrieke en hul inhoud voor indiening kan beskou.';
$string['autorefreshgrades'] = 'Outoverfris Punte / Tellings';
$string['autorefreshgrades_help'] = 'By verstek sal die Moodle-integrasie-invoegtoepassing ná elke oproep na Turnitin poog om die veranderinge binne Turnitin gemaak, af te trek. Jy kan hierdie opsie gebruik om hierdie funksie af te skakel, maar om sinchronisering tussen beide stelsels te kan handhaaf, moet jy gereeld punte en soortgelykheidstellings vanuit Moodle per hand verfris.';
$string['ced'] = 'Einddatum van Klas';
$string['changerubricwarning'] = 'Deur die rubriek te verander of los te maak, sal alle bestaande rubriekpunte uit indienings in hierdie opdrag verwyder word, ook uit puntekaarte wat voorheen nagesien is. Algehele punte vir voorheen nagesiende indienings sal behoue bly.';
$string['checkagainstnote'] = 'Let wel: As jy nie "Ja" vir minstens een van die "Kontroleer teen ..." opsies hieronder kies nie, sal \'n Soortgelykheidsverslag NIE gegenereer word nie.';
$string['checkingupgrade'] = 'Daar word vir beskikbare bywerking gekontroleer';
$string['checkupgrade'] = 'Kontroleer vir beskikbare bywerking';
$string['classcreationerror'] = 'Turnitin-klasskepping het misluk';
$string['classupdateerror'] = 'Kon nie Turnitin-klasdata bywerk nie';
$string['close'] = 'Maak toe';
$string['closebutton'] = 'Maak toe';
$string['code'] = 'Kode';
$string['compareinstitution'] = 'Vergelyk ingediende dokumente met indienings binne hierdie instelling';
$string['complete'] = 'voltooi';
$string['config'] = 'Konfigurasie';
$string['configupdated'] = 'Konfigurasie is bygewerk';
$string['configureerror'] = 'Jy moet hierdie module volledig as Administrateur konfigureer voordat jy dit binne \'n kursus kan gebruik. Kontak asseblief jou Moodle-administrateur.';
$string['confirmv1deletetext'] = 'Jy het {$a} gemigreerde V1-opdrag(te) vir permanente uitwissing geselekteer.';
$string['confirmv1deletetitle'] = 'Wis geselekteerde opdragte uit?';
$string['confirmv1deletewarning'] = 'Hierdie aksie kan nie ongedaan gemaak word nie.';
$string['connecttest'] = 'Toets Turnitin-konneksie';
$string['connecttestcommerror'] = 'Kon nie aan Turnitin koppel nie. Maak dubbeld seker van jou API-URL-verstelling.';
$string['connecttesterror'] = 'Daar was \'n fout met die koppeling aan Turnitin. Die terugkeerfoutboodskap volg hieronder:<br />';
$string['connecttestsuccess'] = 'Moodle het suksesvol aan Turnitin gekoppel.';
$string['copyassigndata'] = 'Kopieer Turnitin-opdragdata';
$string['copyrightagreement'] = 'Deur hierdie boks te merk, bevestig ek dat hierdie indiening my eie werk is en ek aanvaar alle verantwoordelikheid vir enige kopieregskending wat as gevolg van hierdie indiening kan voorkom.';
$string['copyrightagreementerror'] = 'Merk asseblief die boks om aan te dui dat jy die ooreenkoms aanvaar voor jy indien.';
$string['course'] = 'Kursus';
$string['coursebrowserassignmentdesc'] = 'In die tabel hieronder kan jy tot 5 opdragte selekteer om as dele van \'n gerepliseerde Turnitin-opdrag in Moodle te skep.';
$string['coursebrowserdesc'] = 'Jy kan Turnitin hieronder vir klasse deursoek om op Moodle as \'n kursus te herskep';
$string['courseexistsmoodle'] = 'Hierdie klas bestaan tans in Moodle as:';
$string['coursegeterror'] = 'Kon nie kursusdata verkry nie';
$string['coursegettiierror'] = 'Kon nie kursusdata vanaf Turnitin verkry nie';
$string['courseiderror'] = 'Kursus-ID is verkeerd';
$string['coursemisconfigured'] = 'Kursus is verkeer gekonfigureer';
$string['coursemodidincorrect'] = 'Kursusmodule-ID was verkeerd';
$string['coursemodincorrect'] = 'Kursusmodule is verkeerd';
$string['coursestomigrate'] = 'Jy het {$a} klasse beskikbaar om vanuit Turnitin te herstel';
$string['coursetitle'] = 'Kursustitel';
$string['coursetitleerror'] = 'Jy moet \'n klastitel verskaf om na te soek';
$string['createassignmenterror'] = 'Daar was \'n fout toe probeer is om die opdrag in Turnitin te skep';
$string['createcourse'] = 'Skep Nuwe Moodle-kursus';
$string['created'] = 'Geskep';
$string['createmoodleassignments'] = 'Herskep alle Opdragte van geselekteerde klasse in Moodle?';
$string['createmoodlecourses'] = 'Herskep Kursusse';
$string['createsubmissionerror'] = 'Daar was \'n fout toe probeer is om die indiening in Turnitin te skep';
$string['cronsubmittedsuccessfully'] = 'Indiening: {$a->title} (TII ID: {$a->submissionid}) vir die opdrag {$a->assignmentname} op die kursus {$a->coursename} is suksesvol aan Turnitin ingedien.';
$string['crontaskmodeactive'] = 'Turnitintooltwo - Gestaakte Cron-oproep weens aktiewe taakmodus';
$string['defaultassignmenttiititle'] = 'Opdrag vanaf Turnitin';
$string['defaultcoursetiititle'] = 'Kursus vanaf Turnitin';
$string['defaultinserterror'] = 'Daar was \'n fout toe daar probeer is om \'n verstek verstellingswaarde in die databasis in te voeg';
$string['defaults'] = 'Verstek Verstellings';
$string['defaults_desc'] = 'Die volgende verstellings sal die verstek verstellings wees wat vir nuwe eksemplare van die Moodle Direct Turnitin-opdrag 2 gebruik word.';
$string['defaultsdesc'] = 'Die volgende verstellings is die verstek wat gestel word wanneer Turnitin binne \'n Aktiwiteitmodule ontsper word';
$string['defaultupdated'] = 'Turnitin verstek is bygewerk';
$string['defaultupdateerror'] = 'Daar was \'n fout toe probeer is om \'n verstek verstellingswaarde in die databasis by te werk';
$string['deletable'] = 'Uitwisbaar';
$string['delete_selected'] = 'Wis Geselekteerde uit';
$string['deleteassignmenterror'] = 'Daar was \'n fout toe probeer is om die opdrag in Turnitin uit te wis';
$string['deleteconfirm'] = 'Is jy seker jy wil hierdie indiening uitwis?\\n\\nHierdie aksie kan nie ongedaan gemaak word nie.';
$string['deletepart'] = 'Wis Deel uit';
$string['deletesubmission'] = 'Wis Indiening uit';
$string['deletesubmissiondesc'] = 'Gebruiker het die indiening uitgewis';
$string['deletesubmissiontiidesc'] = 'Gebruiker het die indiening van Turnitin uitgewis';
$string['diagnosticoptions_0'] = 'Af';
$string['diagnosticoptions_1'] = 'Standaard';
$string['diagnosticoptions_2'] = 'Ontfouting';
$string['digital_receipt_message'] = 'Geagte {$a->firstname} {$a->lastname},<br /><br />Jy het die dokument <strong>{$a->submission_title}</strong> suksesvol aan die opdrag <strong>{$a->assignment_name}{$a->assignment_part}</strong> in die klas <strong>{$a->course_fullname}</strong> op <strong>{$a->submission_date}</strong> ingedien. Jou indiening-ID is <strong>{$a->submission_id}</strong>. Jou volledige digitale kwitansie kan vanuit die opdragboks of vanaf die druk/laai af-knoppie in die dokumentbeskouer besigtig en gedruk word.<br /><br />Dankie dat jy Turnitin gebruik het,<br /><br />Die Turnitin-span';
$string['digital_receipt_subject'] = 'Hierdie is jou Turnitin Digitale Kwitansie';
$string['digitalreceipt'] = 'Digitale Kwitansie';
$string['disableanonconfirm'] = 'Om dit te doen sal anonieme nasien op hierdie opdrag permanent versper. Is jy seker?';
$string['displaygradesas'] = 'Puntvertoon';
$string['displaygradesas_help'] = 'Hierdie opsie stel die vertoonmodus vir punte; die opsies is: vertoon as \'n persentasie of vertoon as \'n breuk, d.w.s. 45/60.';
$string['displaygradesasfraction'] = 'Vertoon punte as Breuk (bv. 90/100)';
$string['displaygradesaspercent'] = 'Vertoon punte as Persentasie (bv. 89%)';
$string['dontmigrateassignment'] = 'Gaan voort sonder om te Migreer';
$string['download'] = 'Laai af';
$string['download_button_warning'] = '\'n Student moet geselekteer wees vir hierdie funksie om beskikbaar te wees.';
$string['downloadassignment'] = 'Laai Opdrag na Moodle af';
$string['downloadexport'] = 'Voer uit';
$string['downloadgrademarkzip'] = 'Laai Geselekteerde GradeMark-dokumente af';
$string['downloadgradexls'] = 'Puntuitvoere (XLS)';
$string['downloadorigfileszip'] = 'Laai Oorspronklike Dokumente Af';
$string['downloadorigzip'] = 'ZIP-dokument (Oorspronklike Formaat)';
$string['downloadpdfzip'] = 'ZIP-dokument (PDF)';
$string['downloadsubmission'] = 'Laai Indiening af';
$string['draftsubmit'] = 'Wanneer behoort die dokument aan Turnitin ingedien te word?';
$string['dtdue'] = 'Sperdatum';
$string['dtpost'] = 'Plasingsdatum';
$string['dtstart'] = 'Aanvangsdatum';
$string['duplicatesfound'] = 'Duplikaat kopieë van dieselfde Turnitin-opdragte is gevind; duplikate kom voor wanneer een of meer Moodle Direct-opdragte aan dieselfde enkele Turnitin-opdrag via die Turnitin-API gekoppel is. Dit is daarvoor bekend dat dit probleme veroorsaak, vernaamlik dat indienings wat aan een van die duplikate gemaak is, in die indieningsinkas van die ander sal verskyn. Om dit reg te stel, moet jy óf die duplikaat opdragte uitwis, óf die kursus waar die duplikaat opdragte is, terugstel.<br /><br />Die volgende duplikate is gevind:';
$string['edit'] = 'Wysig';
$string['editassignmenterror'] = 'Daar was \'n fout toe probeer is om die opdrag in Turnitin te wysig';
$string['emptycreatedfile'] = 'Die dokument wat jy probeer indien is óf leeg, óf korrup';
$string['enablemigrationtool'] = 'Migrasie-aksie tydens opdragbekendstelling';
$string['enablemigrationtool_help'] = 'Die migrasiehulpmiddel kan gestel word na af, per hand of outomaties. Per hand sal die instrukteurs toelaat om te kies of \'n opdrag migreer moet word, terwyl outomaties die migrasie sal uitvoer met \'n instrukteur se eerste besoek aan \'n V1-opdrag.';
$string['enablemigrationtoolfail'] = 'Ons kon nie jou Moodle-migrasiehulpmiddelverstelling bywerk nie. Probeer asseblief weer.';
$string['enablemigrationtoolsuccess'] = 'V1-migrasiehulpmiddelverstelling is geberg';
$string['enableperformancelogs'] = 'Ontsper Netwerkprestasieaantekening';
$string['enableperformancelogs_desc'] = 'Indien ontsper, sal elke versoek aan die Turnitin-bediener in {tempdir}/turnitintooltwo/logs gelog word';
$string['enablepseudo'] = 'Ontsper Studentprivaatheid';
$string['enablepseudo_desc'] = 'As hierdie opsie gekies is, sal studente se e-posadresse vir Turnitin API-oproepe omgeskakel word na \'n pseudo-ekwivalent.<br /><i>(<b>Let wel:</b> Hierdie opsie kan nie verander word as enige Moodle-gebruikerdata reeds met Turnitin gesinchroniseer is nie)</i>';
$string['enrolling'] = 'Studente word op Turnitin ingeskryf';
$string['erater'] = 'Ontsper e-rater grammatikatoetser';
$string['erater_categories'] = 'e-rater Kategorieë';
$string['erater_dictionary'] = 'e-rater Woordeboek';
$string['erater_dictionary_en'] = 'Beide VSA en VK Engelse Woordeboeke';
$string['erater_dictionary_engb'] = 'VK Engelse Woordeboek';
$string['erater_dictionary_enus'] = 'VSA Engelse Woordeboek';
$string['erater_grammar'] = 'Grammatika';
$string['erater_handbook'] = 'ETS&copy; Handboek';
$string['erater_handbook_advanced'] = 'Gevorderd';
$string['erater_handbook_elementary'] = 'Laerskool';
$string['erater_handbook_highschool'] = 'Hoërskool';
$string['erater_handbook_learners'] = 'Engelse Leerders';
$string['erater_handbook_middleschool'] = 'Middelskool';
$string['erater_mechanics'] = 'Meganika';
$string['erater_spelling'] = 'Spelling';
$string['erater_style'] = 'Styl';
$string['erater_usage'] = 'Gebruik';
$string['errorenrollingall'] = 'Daar was \'n fout met die inskrywing van alle studente op Turnitin - konsulteer asseblief jou stelseladministrateur';
$string['errors'] = 'Foute';
$string['errorsdesc'] = 'Daar was \'n fout toe daar probeer is om die volgende dokumente na Turnitin op te laai.';
$string['eventremoved'] = 'Hierdie gebeurtenis is uit die cron-tou verwyder en sal nie weer verwerk word nie.';
$string['excludebiblio'] = 'Sluit Bibliografie uit';
$string['excludebiblio_help'] = 'Hierdie verstelling laat die instrukteur toe om die teks wat in die bibliografie verskyn, asook werke aangehaal of verwysingsafdelings, van studentantwoordstelle daarvan uit te sluit om vir ooreenstemmings gekontroleer te word wanneer Soortgelykheidsverslae gegenereer word. Hierdie verstelling kan in individuele Soortgelykheidsverslae oorheers word.';
$string['excludepercent'] = 'Persentasie';
$string['excludequoted'] = 'Sluit Aangehaalde Materiaal uit';
$string['excludequoted_help'] = 'Hierdie verstelling laat die instrukteur toe om teks, wat in die aanhalings verskyn, uit te sluit wanneer daar vir ooreenstemmings gekontroleer word tydens generering van Soortgelykheidsverslae. Hierdie verstelling kan in individuele Soortgelykheidsverslae oorheers word.';
$string['excludevalue'] = 'Sluit Klein Ooreenstemmings uit';
$string['excludevalue_help'] = 'Hierdie verstelling laat die instrukteur toe om ooreenstemmings, wat nie oor voldoende lengte beskik nie (deur die instrukteur bepaal), uit te sluit van oorweging wanneer Soortgelykheidsverslae gegenereer word. Hierdie verstelling kan in individuele Soortgelykheidsverslae oorheers word.';
$string['excludewords'] = 'Woorde';
$string['exportexcel'] = 'Voer uit na Excel';
$string['exportoriginal'] = 'Voer uit na oorspronklike formaat';
$string['exportpdf'] = 'Voer uit na PDF';
$string['faultcode'] = 'Foutkode';
$string['filebrowser'] = 'Moodle Direct Dokumentblaaier';
$string['filedeleteconfirm'] = 'Is jy seker jy wil hierdie dokument uitwis? Hierdie aksie kan nie ongedaan gemaak word nie.';
$string['filedoesnotexist'] = 'Dokument is uitgewis';
$string['filename'] = 'Dokumentnaam';
$string['files'] = 'Dokumente';
$string['filetosubmit'] = 'Dokument om In te Dien';
$string['filetosubmit_help'] = 'Wanneer \'n dokument aan \'n indieningdeel ingedien word, blaai deur jou rekenaar vir die dokument om op te laai d.m.v. hierdie vormelement.';
$string['fileupload'] = 'Dokumentoplaai';
$string['genduedate'] = 'Genereer verslae op sperdatum (studente kan tot sperdatum herindien)';
$string['genimmediately1'] = 'Genereer verslae dadelik (studente kan nie herindien nie)';
$string['genimmediately2'] = 'Genereer verslae dadelik (studente kan tot sperdatum herindien): Ná {$a->num_resubmissions} herindienings genereer verslae ná {$a->num_hours} ure.';
$string['getassignmenterror'] = 'Kon nie migrasieassesserings vanaf Turnitin verkry nie';
$string['grademark'] = 'GradeMark';
$string['grademarkzip'] = 'Gekose GradeMark-dokumente';
$string['gradenosubmission'] = 'Gebruiker-ontsperde nasien sonder \'n indiening vir die gebruiker met id';
$string['gradingtemplate'] = 'Graderingstemplaat';
$string['hasmigrated'] = 'Gemigreer?';
$string['helpdesklink'] = 'Benodig jy Hulp met Turnitin?';
$string['hidepeermark'] = 'Versteek Eweknienasien-opdragte';
$string['hidepeermarkinstructions'] = 'Versteek Eweknienasien-instruksies';
$string['hidesummary'] = 'Versteek opdragopsomming';
$string['id'] = 'Id';
$string['inactive'] = 'Onaktief';
$string['institutionalcheck'] = 'Kontroleer teen Instellingsbewaararea';
$string['institutionalchecksettings'] = 'Kontroleer teen<br />Instellingsbewaararea';
$string['institutionalrepository'] = 'Instellingsbewaararea (Waar van Toepassing)';
$string['instructor'] = 'Instrukteur';
$string['instructorreceipt'] = 'Stel Instrukteur in kennis met Indiening';
$string['instructorreceipt_desc'] = 'Kies of \'n kennisgewing aan elke instrukteur op \'n kursus gestuur moet word wanneer \'n indiening op \'n opdrag gemaak word.';
$string['integration'] = 'Integrasie';
$string['internetcheck'] = 'Kontroleer teen internet';
$string['internetcheck_help'] = 'Kontroleer teen die Turnitin internetbewaararea wanneer Soortgelykheidsverslae vir indienings verwerk word. Die soortgelykheidsindekspersentasie kan verminder as dit ontkies word.';
$string['journalcheck'] = 'Kontroleer teen joernale,<br />vaktydskrifte en publikasies';
$string['journalcheck_help'] = 'Kontroleer teen die Turnitin-joernale-, -vaktydskrifte- en -publikasies-bewaararea wanneer Soortgelykheidsverslae vir indienings verwerk word. Die soortgelykheidsindekspersentasie kan verminder as dit ontkies word.';
$string['launchgrademark'] = 'GradeMark';
$string['launchpeermarkmanager'] = 'Lanseer Eweknienasien-bestuurder';
$string['launchpeermarkreviews'] = 'Lanseer Eweknienasien-oorsigte';
$string['launchquickmarkmanager'] = 'Lanseer Snelmerk-bestuurder';
$string['launchrubricmanager'] = 'Lanseer Rubriekbestuurder';
$string['launchrubricview'] = 'Besigtig die Rubriek wat vir nasien gebruik word';
$string['launchrubricviewshort'] = 'Nasienrubriek';
$string['layoutoptions_0'] = 'Volle breedte';
$string['layoutoptions_1'] = 'Moodle verstek - met navigasie';
$string['line'] = 'Lyn';
$string['linkcourse'] = 'Koppel Kursus aan bestaande Moodle-kursus';
$string['listsubmissions'] = 'Lys Indienings';
$string['listsubmissionsdesc'] = 'Gebruiker het die lys van indienings by kursus beskou';
$string['listsubmissionsdesc_student'] = 'Gebruiker het hul indieninginkas by kursus beskou';
$string['loadingdv'] = 'Turnitin-Dokumentbeskouer word Gelaai';
$string['marksavailable'] = 'Punte Beskikbaar';
$string['max_marks_warning'] = 'Wees asseblief bewus dat verandering van die Punte Beskikbaar ná gradering die punteboek kan affekteer';
$string['maxfilesize'] = 'Maksimum Dokumentgrootte';
$string['maxfilesize_help'] = 'Hierdie verstelling bepaal die maksimum dokumentgrootte vir gebruikerindienings op elke opdragdeel. Die maksmimum waarde waarop jy hierdie waarde kan stel, word deur die waarde wat in kursusverstellings gestel is, bepaal; hierdie waarde is verder beperk tot \'n maksimum dokumentgrootte van 100 MB, wat die maksimum toegelate dokumentgrootte vir dokumentoplaaie na Turnitin is.';
$string['maxlength'] = 'Die maksimum lengte vir {$a->field} is {$a->length} karakters';
$string['maxmarks'] = 'Maks. Punte';
$string['maxmarkserror'] = 'Maksimum Punte moet tussen 0 en 100 wees';
$string['membercheckerror'] = 'Daar was \'n fout toe daar probeer is om gebruikers wat vir hierdie kursus ingeskryf is, te kontroleer';
$string['message'] = 'Boodskap';
$string['messagenonsubmitters'] = 'Stel Nie-indieners in Kennis';
$string['messageprovider:nonsubmitters'] = 'Turnitin-opdrag Nie-indienerkennisgewings';
$string['messageprovider:notify_instructor_of_submission'] = 'Turnitin-opdrag Instrukteur Digitale Kwitansiekennisgewings';
$string['messageprovider:submission'] = 'Turnitin-opdrag Digitale Kwitansiekennisgewings';
$string['messagesinbox'] = 'Turnitin Boodskapinkas';
$string['migrateassignment'] = 'Migreer Opdrag';
$string['migrated'] = 'Gemigreer';
$string['migrating'] = 'Hierdie opdrag word tans na \'n Moodle Direct V2-opdrag gemigreer.';
$string['migration:auto'] = 'Outomaties met aanvang';
$string['migration:manual'] = 'Por instrukteur met lansering';
$string['migration:off'] = 'Versper migrasie';
$string['migration_event_desc'] = 'Turnitin Hulpmiddel V1-kursus: {$a->v1_name} ({$a->v1_cm_id}) is na Turnitin V2 ({$a->v2_cm_id}) gemigreer.';
$string['migration_event_name'] = 'Migreer V1-opdrag na V2';
$string['migration_status'] = 'Migrasiestatus';
$string['migrationactivationfailure'] = 'Die migrasiehulpmiddel kon nie ontsper word nie.';
$string['migrationactivationsuccess'] = 'Die migrasiehulpmiddel is suksesvol ontsper.';
$string['migrationassignmentcreated'] = 'Migrasie-opdrag geskep - ID: {$a}';
$string['migrationassignmentcreationerror'] = 'Kon nie migrasie-opdrag skep nie - kursus {$a}';
$string['migrationassignmenterror1'] = 'Kon nie \'n nuwe kursusmodule by die kursus {$a} voeg nie';
$string['migrationassignmenterror2'] = 'Kon nie die nuwe kursusmodule by daardie afdeling voeg nie - kursus {$a}';
$string['migrationassignmenterror3'] = 'Kon nie \'n gebeurtenis vir die gemigreerde opdrag skep nie - kursus {$a}';
$string['migrationassignmentgeterror'] = 'Kon geen van die opdragte vanaf Turnitin verkry nie';
$string['migrationassignmentpartcreated'] = 'Migrasie-opdragdeel geskep - ID: {$a}';
$string['migrationassignmenttitle'] = 'V1 Opdragtitel';
$string['migrationcoursecreated'] = 'Klas van Turnitin op Moodle herskep';
$string['migrationcoursecreatederror'] = 'Kursus {$a} is herskep maar daar het \'n fout met die berging van die skakel voorgekom';
$string['migrationcoursecreateerror'] = 'Kursus {$a} kon nie op Moodle geskep word nie';
$string['migrationcoursegeterror'] = 'Kon geen van die klasse vanaf Turnitin verkry nie';
$string['migrationinprogress'] = 'Migrasie aan die gang';
$string['migrationredirect'] = 'Jy sal met voltooiing na die Moodle Direct V2-opdrag herlei word.';
$string['migrationselectall'] = 'Kies alle gemigreerde opdragte';
$string['migrationtool:gradebookerror'] = 'Jou opdrag is suksesvol van Moodle Direct V1 na V2 gemigreer. Sommige punte het egter nie tydens migrasie in die punteboek opgedateer nie. Die oorspronklike V1-opdrag is aan jou beskikbaar om enige teenstrydige punte te kontroleer. Verwyder asseblief die V1-opdrag sodra jy hierdie kontrole voltooi het.<br><br><strong>Waarskuwing:</strong>As \'n gemigreerde V1-opdrag nie verwyder word nie, kan dit veroorsaak dat punte twee maal vir die punteboektotaal ingereken word.';
$string['migrationtool:successful'] = 'Jou opdrag is suksesvol vanaf Moodle Direct V1 na V2 gemigreer. Die oorspronklike V1-opdrag is verwyder.';
$string['migrationtool:successfulcron'] = 'Jou opdrag is suksesvol vanaf Moodle Direct V1 na V2 gemigreer. Aangesien dit \'n groot opdrag is, laat asseblief tyd toe vir die punteboek om op te dateer. Die oorspronklike V1-opdrag sal outomaties verwyder word sodra die opdatering voltooi is.<br><br><strong>Waarskuwing:</strong> Om die V1-opdrag per hand te verwyder, kan tot gevolg hê dat die punteboek nie korrek opdateer nie.';
$string['migrationtoolaccounterror'] = 'Jy moet dieselfde Turnitin-rekening-ID in beide jou V1- en V2-invoegtoepassings gebruik om die Moodle Migrasiehulpmiddel te ontsper.';
$string['migrationtoolerror'] = 'Die migrasie van hierdie opdrag het misluk. Probeer asseblief weer.';
$string['migrationtoolinfo'] = 'Jou administrateur het die migrasie van hierdie Moodle Direct V1-opdrag na V2 gemagtig.<br /><br /> Moodle Direct V1 en V2 werk dieselfde, met V2 wat toegang tot ekstra funksies bied. Deur te kies om hierdie opdrag te migreer, sal jou opdragverstellings outomaties oorgedra word.';
$string['migrationtoolintro'] = 'Gebruik hierdie hulpmiddel om opdragmigrasie vanaf Moodle Direct V1 na Moodle Direct V2 te konfigureer.';
$string['migrationtoolprogress'] = 'Kies die gemigreerde V1-opdragte wat jy wil verwyder. V1-opdragte wat nog nie gemigreer het nie, kan nie verwyder word nie.';
$string['migrationtooltitle'] = 'Migreer jou Moodle Direct V1-opdrag na V2?';
$string['migrationtoolv1list'] = 'Gebruik die lys hieronder om die Moodle Direct V1-opdragte, wat voor weergawe {$a} gemigreer het, te verwyder; dit sal enige onakkuraathede in die Moodle-punteboek oplos. Jy kan ook V1-opdragte identifiseer wat nog nie na V2 gemigreer het nie.
<br/><br/>Vir meer inligting, besoek die vrystellingsnotas by: <a href=https://help.turnitin.com/release-notes/turnitin-release-notes-home.htm>help.turnitin.com/release-notes</a>';
$string['module'] = 'Module';
$string['modulename'] = 'Turnitin Opdrag 2';
$string['modulename_help'] = 'Skep \'n Turnitin Moodle Direct-opdrag wat \'n aktiwiteit in Moodle met \'n opdrag/opdragte op Turnitin koppel. Wanneer dit gekoppel is, laat die aktiwiteit instrukteurs toe om studente se werk te assesseer en terugvoer te verskaf deur die assesseringshulpmiddels te gebruik wat in Turnitin se Dokumentbeskouer beskikbaar is.';
$string['modulenameplural'] = 'Turnitin-opdragte';
$string['modulenamewithv2plural'] = 'Turnitin-opdragte (V2)';
$string['moduleversion'] = 'Weergawe';
$string['moodlelinked'] = 'Aan Moodle gekoppel';
$string['mysubmissions'] = 'My Indienings';
$string['newcourseenddate'] = 'Nuwe kursuseinddatum';
$string['newenddatedesc'] = 'Kies \'n nuwe einddatum vir die kursus hieronder, wat dan in Turnitin bygewerk sal word.';
$string['no'] = 'Nee';
$string['nofinfolibrary'] = 'Om hierdie invoegtoepassing te gebruik, sal jy die PHP Fileinfo-uitbreiding op jou bediener geïnstalleer moet hê.';
$string['nogrades'] = 'Nee, ek sal soortgelykheidstellings en punte per hand verfris';
$string['nointegration'] = 'Geen Integrasie';
$string['nolimit'] = 'Geen Beperking';
$string['nombstringlibrary'] = 'Om hierdie invoegtoepassing te gebruik, sal jy die PHP mbstring-uitbreiding op jou bediener geïnstalleer moet hê.';
$string['nonenrolledstudent'] = 'Nie-ingeskrewe Student';
$string['nonmoodleuser'] = 'Nie-Moodle Gebruiker';
$string['nonsubmitterserror'] = 'Verskaf asseblief \'n onderwerp en boodskap vir die e-pos';
$string['nonsubmittersformdesc'] = 'Voer asseblief \'n boodskap hieronder in om aan studente te stuur wat nog nie hierdie opdrag ingedien het nie.';
$string['nonsubmittersformsuccess'] = 'Jou boodskap na nie-indieners is gestuur.';
$string['nonsubmittersmessage'] = 'Boodskap';
$string['nonsubmittersmessageerror'] = 'Verskaf asseblief \'n boodskap vir die e-pos';
$string['nonsubmitterssendtoself'] = 'Stuur \'n afskrif van hierdie boodskap aan my';
$string['nonsubmitterssubject'] = 'Onderwerp';
$string['nonsubmitterssubjecterror'] = 'Verskaf asseblief \'n onderwerp vir die e-pos';
$string['nonsubmitterssubmit'] = 'Stuur e-pos';
$string['noofreviewsrequired'] = 'Aantal Hersienings Vereis';
$string['noreason'] = 'Geen rede gespesifiseer nie';
$string['norepository'] = 'Geen Bewaararea';
$string['norubric'] = 'Geen rubriek';
$string['noscript'] = 'Turnitin vereis Javateks, maar dit is nie in jou blaaier ontsper nie. Ontsper asseblief Javateks in jou blaaier om jou toe te laat om die volledige funksionaliteit van Turnitin te gebruik.';
$string['noscriptsummary'] = 'Turnitin vereis Javateks, maar dit is nie in jou blaaier ontsper nie. Jy sal nie toegang tot Turnitin kan verkry as dit nie ontsper is nie.';
$string['noscriptula'] = '(Aangesien jy nie javateks ontsper het nie, sal jy die bladsy per hand moet verfris voordat jy \'n indiening kan maak, nadat jy die Turnitin-gebruikersooreenkoms aanvaar het)';
$string['nosoaplibrary'] = 'Om hierdie invoegtoepassing te gebruik, moet jy die PHP SOAP-uitbreiding op jou bediener geïnstalleer hê.';
$string['nosubmissiondataavailable'] = 'Geen ander indieningsdata beskikbaar nie';
$string['nosubmissions'] = 'Geen indienings is gemaak nie';
$string['notadmin'] = 'Moodle-administrateurvoorregte word vir die versoekte aksie vereis.';
$string['notavailableyet'] = 'Nie beskikbaar nie';
$string['notorcapable'] = 'Dit is nie moontlik om \'n Soortgelykheidsverslag vir hierdie dokument te produseer nie.';
$string['noturnitinassignemnts'] = 'Daar is geen Turnitin-opdragte nie';
$string['notutors'] = 'Daar is geen tutors op hierdie klas met Turnitin ingeskryf nie';
$string['noxmlwriterlibrary'] = 'Om hierdie invoegtoepassing te gebruik, sal jy die PHP XMLWriter-invoegtoepassing op jou bediener geïnstalleer moet hê.';
$string['numberofparts'] = 'Aantal Dele';
$string['numberofparts_help'] = 'Laat die skep van \'n veeldelige opdrag toe, individuele gebruikers kan een werkstuk aan elke deel indien.';
$string['objectid'] = 'Turnitin-indiening-ID';
$string['offlinestatus'] = 'Turnitin is op vanlyn gestel. (Die veranderlike $CFG->tiioffline is na \'waar\' gestel.)';
$string['or'] = 'Of';
$string['origfileszip'] = 'Oorspronklike Dokumente';
$string['otherrubric'] = 'Gebruik rubriek wat aan ander instrukteur behoort';
$string['overallgrade'] = 'Algehele Punt';
$string['overallgrade_help'] = 'Die algehele punt bepaal die maksimum toegelate punt vir algehele opdrag, elke deel van \'n opdrag het \'n maksimum punt daaraan toegeken, wat gebruik word om die punte proporsioneel te versprei om die algehele punt te bepaal.';
$string['partdberror'] = 'Daar was \'n probleem met die invoer van Deel {$a} in die databasis<br />';
$string['partdeleted'] = 'Opdragdeel is uitgewis';
$string['partdeleteerror'] = 'Kon nie opdragdeel {$a} data uitwis nie';
$string['partdeletewarning'] = 'Die opdragdeel wat jy probeer uitwis, bevat indienings. Jy sal hierdie indienings verloor as jy hierdie opdragdeel uitwis.\\n\\nIs jy seker jy wil voortgaan?';
$string['partdueerror'] = 'Aanvangsdatum moet voor sperdatum wees.';
$string['partgeterror'] = 'Kon nie opdragdeeldata verkry nie';
$string['partname'] = 'Opdragdeel';
$string['partnameerror'] = 'Deelnaam kan nie blanko gelaat word nie.';
$string['partnametoolarge'] = 'Die deelnaam is te groot. Beperk asseblief tot 40 karakters.';
$string['partposterror'] = 'Aanvangsdatum moet voor plasingsdatum wees.';
$string['partupdateerror'] = 'Daar was \'n probleem met die bywerk van Deel {$a} in die databasis<br />';
$string['peermark'] = 'Eweknienasien';
$string['peermarkassignments'] = 'Eweknienasien Opdragte';
$string['pending'] = 'Hangende';
$string['permissiondeniederror'] = 'Jy beskik nie oor die korrekte toestemming om die versoekte aksie te volvoer nie';
$string['pluginadministration'] = 'Turnitin Opdrag 2-administrasie';
$string['pluginname'] = 'Turnitin Opdrag 2';
$string['portfolio'] = 'Portefeulje';
$string['postdate_warning'] = 'Wees asseblief daarvan bewus dat verandering van die opdragdatums kan affekteer wanneer punte aan die student sigbaar is, en wanneer die studente se identiteite aan instrukteurs onthul word.';
$string['pp_classcreationerror'] = 'Hierdie klas kon nie op Turnitin geskep word nie; konsulteer asseblief jou API-logs vir verdere inligting';
$string['pp_createsubmissionerror'] = 'Daar was \'n fout in die plagiaat-invoegtoepassing toe \'n indiening geskep is';
$string['pp_submission_error'] = 'Turnitin het \'n fout met jou indiening teruggestuur:';
$string['pp_updatesubmissionerror'] = 'Daar was \'n fout in die plagiaat-invoegtoepassing toe \'n indiening bygewerk is';
$string['ppassignmentcreateerror'] = 'Hierdie module kan nie op Turnitin geskep word nie. Konsulteer asseblief jou API-logs vir meer inligting';
$string['ppassignmentediterror'] = 'Module {$a->title} (TII ID: {$a->assignmentid}) kon nie op Turnitin gewysig word nie. Konsulteer asseblief jou API-logs vir meer inligting.';
$string['print'] = 'Druk';
$string['privacy:metadata:core_files'] = 'Turnitin Opdrag 2 berg dokumente wat na Moodle opgelaai is om \'n Turnitin-indiening te vorm.';
$string['privacy:metadata:turnitintooltwo_client'] = 'Om \'n indiening aan Turnitin suksesvol te doen, moet spesifieke gebruikerdata tussen Moodle en Turnitin uitgeruil word. Vir meer inligting oor Moodle-invoegtoepassings en GDPR, besoek asseblief: https://help.turnitin.com/feedback-studio/moodle/moodle-plugins-and-gdpr.htm';
$string['privacy:metadata:turnitintooltwo_client:email'] = 'Die gebruiker se e-posadres word deur Moodle gedeel om die skepping van \'n Turnitin-rekening toe te laat.';
$string['privacy:metadata:turnitintooltwo_client:firstname'] = 'Die gebruiker se voornaam word aan Turnitin gestuur sodat die gebruiker geïdentifiseer kan word.';
$string['privacy:metadata:turnitintooltwo_client:lastname'] = 'Die gebruiker se van word aan Turnitin gestuur sodat die gebruiker geïdentifiseer kan word.';
$string['privacy:metadata:turnitintooltwo_client:submission_content'] = 'Wees asseblief daarvan bewus dat die inhoud van \'n dokument/indiening aan Turnitin gestuur word om verwerk te word.';
$string['privacy:metadata:turnitintooltwo_client:submission_filename'] = 'Die naam van die ingediende dokument word aan Turnitin gestuur sodat dit geïdentifiseer kan word.';
$string['privacy:metadata:turnitintooltwo_client:submission_title'] = 'Die titel van die indiening word aan Turnitin gestuur sodat dit geïdentifiseer kan word.';
$string['privacy:metadata:turnitintooltwo_submissions'] = 'Inligting oor \'n indiening wat aan Turnitin gestuur is.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_attempts'] = '\'n Tydstempel wat aandui wanneer die gebruiker terugvoer op hul indiening besigtig het.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_filename'] = 'Die naam van die dokument wat aan Turnitin ingedien is.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_grade'] = 'Die punt wat deur \'n instrukteur op die indiening toegepas is.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_hash'] = '\'n Indiening-spesifieke huts wat die gebruiker se ID bevat.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_modified'] = '\'n Tydstempel wat aandui wanneer die gebruiker hul indiening laaste gewysig het.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_objectid'] = 'Die ID wat deur Turnitin gebruik word om na die indiening te verwys.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_orcapable'] = 'Dui aan of Turnitin \'n soortgelykheidsverslag vir die indiening kon produseer.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_score'] = 'Die soortgelykheidstelling van die indiening.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_title'] = 'Die titel van die indiening.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_transmatch'] = 'Dui aan of Turnitin vertaalpassing gebruik het om \'n Soortgelykheidsverslag vir die indiening te produseer.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_unanon'] = 'Dui aan dat die anonimiteit van \'n indiening verwyder is, wat die outeur se identiteit aan die instrukteur bekendmaak.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_unanonreason'] = '\'n Verduideliking vir die verwydering van \'n outeur se anonimiteit, deur hul instrukteur verskaf.';
$string['privacy:metadata:turnitintooltwo_submissions:userid'] = 'Die ID van die gebruiker wat \'n indiening gemaak het.';
$string['privacy:metadata:turnitintooltwo_users'] = 'Inligting wat \'n Moodle-gebruiker aan \'n Turnitin-gebruikersrekening koppel, asook aan enige voorkeure spesifiek tot Turnitin. Dit sluit in verstek opdragverstellings en enige Turnitin-rubrieke in hulle besit.';
$string['privacy:metadata:turnitintooltwo_users:instructor_defaults'] = 'Die instrukteur se verstek opdragverstellings';
$string['privacy:metadata:turnitintooltwo_users:instructor_rubrics'] = 'Die Turnitin-rubriekpuntekaarte wat aan die instrukteur behoort';
$string['privacy:metadata:turnitintooltwo_users:turnitin_uid'] = 'Die gebruiker se Turnitin-rekening-ID.';
$string['privacy:metadata:turnitintooltwo_users:user_agreement_accepted'] = 'Dui aan of die gebruiker die Turnitin Eindgebruiker Lisensie-ooreenkoms (EULA) aanvaar het.';
$string['privacy:metadata:turnitintooltwo_users:userid'] = 'Die ID van die gebruiker wat aan \'n Turnitin-rekening gekoppel word.';
$string['proxypassword'] = 'Proxywagwoord';
$string['proxypassword_desc'] = '<b>[Opsioneel]</b><br />As jou proxy Magtiging vereis, voer die wagwoord hier in.';
$string['proxyport'] = 'Proxypoort';
$string['proxyport_desc'] = '<b>[Opsioneel]</b><br />As jou bediener \'n Proxy gebruik om aan die internet te koppel, voer die proxypoort hier in.';
$string['proxyurl'] = 'Proxy-URL';
$string['proxyurl_desc'] = '<b>[Opsioneel]</b><br />As jou bediener \'n Proxy gebruik om aan die internet te koppel, voer die proxyadres hier in.';
$string['proxyuser'] = 'Proxygebruikersnaam';
$string['proxyuser_desc'] = '<b>[Opsioneel]</b><br />As jou proxy Magtiging vereis, voer die gebruikersnaam hier in.';
$string['pseudoemailaddress'] = 'Pseudo-e-posadres';
$string['pseudoemaildomain'] = 'Pseudo-e-posdomein';
$string['pseudoemaildomain_desc'] = '<b>[Opsioneel]</b><br />\'n Opsionele domein vir pseudo-e-posadresse. (Keer by verstek terug na @tiimoodle.com indien leeg gelaat)';
$string['pseudoemailsalt'] = 'Pseudo-enkripsiesout';
$string['pseudoemailsalt_desc'] = '<b>[Opsioneel]</b><br />\'n Opsionele salt om die kompleksiteit van die gegenereerde Pseudo-student-e-posadres te vergroot.<br />(<b>Let wel:</b> Die salt behoort onveranderd te bly om konsekwente pseudo-e-posadresse te handhaaf)';
$string['pseudofirstname'] = 'Pseudovoornaam van student';
$string['pseudofirstname_desc'] = '<b>[Opsioneel]</b><br />Die student se voornaam om in die Turnitin-dokumentbeskouer te vertoon';
$string['pseudolastname'] = 'Pseudovan van student';
$string['pseudolastname_desc'] = 'Die student se van om in die Turnitin-dokumentbeskouer te vertoon';
$string['pseudolastnamegen'] = 'Outogenereer Van';
$string['pseudolastnamegen_desc'] = 'Indien na ja gestel, en die pseudovan na \'n gebruikersprofielveld gestel is, sal die veld outomaties met \'n unieke identifiseerder bevolk word.';
$string['receipt_instructor_copy'] = '\'n Indiening genaamd <strong>{$a->submission_title}</strong> is gemaak op opdrag <strong>{$a->assignment_name}{$a->assignment_part}</strong> in die klas <strong>{$a->course_fullname}</strong>.<br /><br />Indiening-ID: <strong>{$a->submission_id}</strong><br />Indieningsdatum: <strong>{$a->submission_date}</strong><br />';
$string['receipt_instructor_copy_subject'] = 'Indiening op opdrag is gemaak';
$string['receiptassignmenttitle'] = 'Opdragtitel';
$string['receiptparagraph'] = 'Hierdie bewys van ontvangs bevestig dat Turnitin jou indiening ontvang het. Hieronder sal jy die kwitansie-inligting van jou indiening vind.';
$string['recreatemulticlasses'] = 'Jou geselekteerde klasse word nou herskep; dit kan tot \'n paar minute neem, afhangend van hoeveel jy geselekteer het';
$string['recreatemulticlassescomplete'] = 'Herskepping van klas is nou voltooi. {$a->completed} uit {$a->total} is suksesvol geskep.';
$string['redirecttoeula'] = 'Ons herlei jou na die Eindgebruiker Lisensie-ooreenkoms';
$string['refid'] = 'Verw. ID';
$string['refreshallgrades'] = 'Verfris alle Punte van Turnitin';
$string['refreshingallgrades'] = 'Punte van Turnitin word verfris';
$string['relinkusers'] = 'Herkoppel Gebruikers';
$string['renew_assignment_dates'] = 'Nuwe opdragdatums';
$string['renew_assignment_dates_help'] = 'Kies hierdie opsie om nuwe opdragdatums te gebruik wanneer jy \'n kursus terugstel. Die opdrag se aanvangsdatum sal gestel word na die datum en tyd van die kursusterugstel, terwyl die sper- en plasingsdatum sewe dae van nou verby sal wees.<br/><br/>As jy eerder nie nuwe opdragdatums wil gebruik nie, is dit ook reg; Turnitin sal dan eerder die kursus se oorspronklike opdragdatums gebruik. Enige anonieme nasienverstellings sal egter nie vir opdragte oorgedra word waar die plasingsdatum verby is nie.';
$string['replaceassigndata'] = 'Vervang Turnitin-opdragdata';
$string['reportgenspeed'] = 'Verslaggenereringspoed';
$string['reportgenspeed_help'] = 'Daar is drie opsies vir hierdie opdragverstelling: \'Genereer verslae dadelik (herindienings word nie toegelaat nie)\', \'Genereer verslae dadelik (herindienings word tot sperdatum toegelaat)\' en \'Genereer verslae op sperdatum (herindienings word tot sperdatum toegelaat)\'<br /><br />Die opsie \'Genereer verslae dadelik (herindienings word nie toegelaat nie)\' genereer Soortgelykheidsverslae dadelik wanneer \'n student \'n indiening maak. As hierdie opsie gekies is, sal jou studente nie \'n herindiening op die opdrag kan maak nie.<br /><br />Om herindienings toe te laat, kies \'Genereer verslae dadelik (herindienings word tot sperdatum toegelaat)-opsie. Dit laat studente toe om deurlopend indienings op die opdrag te maak, tot en met die sperdatum. Dit kan tot 24 uur neem om Soortgelykheidsverslae vir herindienings te verwerk.<br /><br />Die opsie \'Genereer verslae op sperdatum (herindienings word tot sperdatum toegelaat)\' sal slegs \'n Soortgelykheidsverslag op die opdrag se sperdatum genereer. Hierdie verstelling sal dit só maak dat alles wat op die opdrag ingedien word, met mekaar vergelyk sal word wanneer die Soortgelykheidsverslae geskep word.';
$string['reportgenspeed_resubmission'] = 'Jy het reeds \'n indiening op hierdie opdrag gemaak en \'n Soortgelykheidsverslag is vir jou indiening gegenereer. As jy kies om jou indiening weer te maak, sal jou vroeëre indiening vervang word en \'n nuwe verslag sal gegenereer word. Ná {$a->num_resubmissions} herindienings sal jy {$a->num_hours} uur ná \'n herindiening moet wag om \'n nuwe Soortgelykheidsverslag te kan besigtig.';
$string['repositoryoptions_0'] = 'Ontsper instrukteur standaard bewaararea-opsies';
$string['repositoryoptions_1'] = 'Ontsper instrukteur uitgebreide bewaararea-opsies';
$string['repositoryoptions_2'] = 'Dien alle indienings op die standaard bewaararea in';
$string['repositoryoptions_3'] = 'Moet geen indienings op \'n bewaararea indien nie';
$string['repositoryoptions_4'] = 'Dien alle indienings op die instelling se bewaararea in';
$string['restorationheader'] = 'Turnitin Klasherstel';
$string['resubmission'] = 'Herindiening';
$string['resubmissiongradewarn'] = 'Herindienings word vir hierdie opdrag toegelaat totdat die sperdatum verby is. Enige en alle punte sal uitgewis word wanneer of as die indiening heringedien word. Wil jy graag voortgaan?';
$string['resubmissiongradewarnaware'] = 'Wees asseblief bewus dat, as hierdie herindiening gemaak is, enige en alle punte uitgewis sal word.';
$string['resubmit'] = 'Dien weer in';
$string['resubmitselected'] = 'Dien Geselekteerde Dokumente weer in';
$string['resubmitting'] = 'Word heringedien';
$string['resubmittoturnitin'] = 'Dien weer op Turnitin in';
$string['reveal'] = 'Onthul';
$string['revealdesc'] = 'Gee asseblief \'n rede hieronder vir die openbaarmaking van \'n student se naam.';
$string['revealerror'] = 'Jy moet \'n geldige rede insluit vir die openbaarmaking van \'n student se naam.';
$string['revealreason'] = 'Rede vir Openbaarmaking';
$string['savecourseenddate'] = 'Berg nuwe einddatum van kursus';
$string['savecourseenddateerror'] = 'Daar was \'n fout toe ons probeer het om \'n nuwe kursuseinddatum in Turnitin te berg';
$string['saveusage'] = 'Berg Datastorting';
$string['searchcourses'] = 'Deursoek Kursusse';
$string['selectcourse'] = 'Kies Moodle-kursus';
$string['selectcoursecategory'] = 'Kies Kursuskategorie';
$string['selectoption'] = 'Kies Opsie';
$string['semptytable'] = 'Geen resultate gevind nie.';
$string['setinstructordefaults'] = 'Stel hierdie waardes as opdrag se verstek';
$string['setinstructordefaults_help'] = 'Hierdie verstellings sal gebruik word vir enige nuwe eksemplare van die Moodle Direct Turnitin-opdrag wat deur jou geskep is. Dit sal die verstek waardes wat deur jou stelseladministrateur gespesifiseer is, vervang, en is uniek aan jou.';
$string['settings'] = 'Verstellings';
$string['settingsinserterror'] = 'Daar was \'n fout toe daar probeer is om \'n verstelling in die databasis te voeg';
$string['settingsupdateerror'] = 'Daar was \'n fout toe daar probeer is om \'n verstelling in die databasis by te werk';
$string['sharedrubric'] = 'Gedeelde Rubriek';
$string['showpeermark'] = 'Vertoon Eweknienasien-opdragte';
$string['showpeermarkinstructions'] = 'Vertoon Eweknienasien-instruksies';
$string['showsummary'] = 'Vertoon opdragopsomming';
$string['showusage'] = 'Vertoon Datastorting';
$string['similarity'] = 'Soortgelykheid';
$string['sinfo'] = 'Vertoon_BEGIN_tot_EINDE_van_TOTALE_inskrywings.';
$string['slengthmenu'] = 'Vertoon_KIESLYS_Inskrywings';
$string['slengthmigrationmenu'] = 'Vertoon_KIESLYS_opdragte';
$string['snext'] = 'Volgende';
$string['source'] = 'Bron';
$string['spapercheck'] = 'Kontroleer teen gebergde studentindienings';
$string['spapercheck_help'] = 'Kontroleer teen die Turnitin-studentindieningbewaararea wanneer Soortgelykheidsverslae vir indienings verwerk word. Die soortgelykheidsindeks kan verminder as hierdie nie geselekteer is nie.';
$string['sprevious'] = 'Vorige';
$string['sprocessing'] = 'Data van Turnitin word gelaai ...';
$string['ssearch'] = 'Soek:';
$string['standardrepository'] = 'Standaard Bewaararea';
$string['startdatenotyearago'] = 'Aanvangsdatum kan nie meer as 1 jaar gelede wees nie';
$string['student'] = 'Student';
$string['student_notread'] = 'Die student het nie hierdie indiening beskou nie.';
$string['student_read'] = 'Die student het die indiening beskou op:';
$string['studentdataprivacy'] = 'Studentdata Privaatheidsverstellings';
$string['studentdataprivacy_desc'] = 'Die volgende verstellings kan gekonfigureer word om te verseker dat die student se persoonlike data nie via die API na Turnitin oorgedra word nie.';
$string['studentdisclosure'] = 'Studentonthulling';
$string['studentdisclosure_help'] = 'Hierdie teks sal aan alle studente op die dokumentoplaaiblad vertoon word.';
$string['studentdisclosuredefault'] = 'Alle dokumente sal aan die plagiaatbespeuringsdiens, Turnitin.com, gestuur word';
$string['studentfirstname'] = 'Voornaam';
$string['studentlastname'] = 'Van';
$string['studentremoved'] = 'Student is uit die kursus binne Turnitin verwyder';
$string['studentremovingerror'] = 'Daar was \'n probleem met verwydering van die student uit die kursus binne Turnitin';
$string['studentreports'] = 'Vertoon Soortgelykheidsverslae aan Studente';
$string['studentreports_help'] = 'Laat jou toe om Turnitin-soortgelykheidsverlae aan studentegebruikers te vertoon. Indien na ja gestel, sal die soortgelykheidsverslag wat deur Turnitin gegenereer is, aan die student beskikbaar wees om te besigtig.';
$string['studentstatus'] = 'Ingedien {$a->modified} (Indiening-ID: {$a->objectid})';
$string['submissionagreementerror'] = 'Jy moet die ooreenkoms vir hierdie indiening aanvaar';
$string['submissionauthor'] = 'Indieningsouteur';
$string['submissiondate'] = 'Indieningsdatum';
$string['submissiondeleted'] = 'Indiening is Uitgewis';
$string['submissiondeleteerror'] = 'Kon nie indienings uitwis nie';
$string['submissionextract'] = 'Uittreksel uit indiening';
$string['submissionfileerror'] = 'Jy moet \'n dokument vir indiening aanheg';
$string['submissionfiletypeerror'] = 'Dokumenttipe nie toegelaat nie. Toegelate tipes is ({$a})';
$string['submissiongeterror'] = 'Kon nie indieningsdata verkry nie';
$string['submissiongrade'] = 'Punt';
$string['submissionorig'] = 'Soortgelykheid';
$string['submissionpart'] = 'Indieningsdeel';
$string['submissionpart_help'] = 'Kies die deel van die Turnitin-opdrag waaraan hierdie indiening gemaak moet word.';
$string['submissions'] = 'Indienings';
$string['submissiontexterror'] = 'Jy moet die teks vir hierdie indiening insluit';
$string['submissiontitle'] = 'Indieningstitel';
$string['submissiontitle_help'] = 'Voer die indieningstitel in van die werkstuk wat jy indien.';
$string['submissiontitleerror'] = 'Jy moet \'n titel vir hierdie indiening insluit';
$string['submissiontype'] = 'Indieningstipe';
$string['submissiontype_help'] = '<p>Dui die indieningstipe(s) aan wat jy aan Turnitin mag indien.</p>';
$string['submissionupdateerror'] = 'Kon nie indieningsdata bywerk nie';
$string['submissionuploadsuccess'] = 'Jou indiening is suksesvol op Turnitin opgelaai.';
$string['submitnothing'] = 'Ontsper vir hierdie student nasien sonder indiening';
$string['submitnothingwarning'] = 'Deur op die grys pen te kliek vir \'n student wat nie \'n dokument ingedien het nie, skep dit \'n graderingstemplaat, wat jou sal toelaat om aan die student GradeMark-terugvoer vir die opdrag te gee. \'n Graderingstemplaat neem die plek in van \'n indiening en sal die student daarvan verhoed om opdragte in te dien waar herindiening nie toegelaat word nie.<br><br>Is jy seker jy wil nasien sonder \'n indiening?';
$string['submitondraft'] = 'Dien dokument in wanneer dit eerste opgelaai is';
$string['submitonfinal'] = 'Dien dokument in wanneer student dit vir nasien stuur';
$string['submitpaper'] = 'Dien Indiening In';
$string['submitpapersto'] = 'Berg Studentindienings';
$string['submitpapersto_help'] = '<strong>Geen Bewaararea: </strong><br />Turnitin is opdrag gegee om nie ingediende dokumente in enige bewaararea te berg nie. Ons verwerk slegs die indiening om die aanvanklike soortgelykheidskontrole te doen.<br /><br /><strong>Standaard Bewaararea: </strong><br />Turnitin sal \'n kopie van die ingediende dokument slegs in die Standaard Bewaararea berg. Deur hierdie opsie te kies, word Turnitin opdrag gegee om slegs gebergde dokumente te gebruik om soortgelykheidskontroles uit te voer teenoor enige dokumente wat in die toekoms ingedien word.<br /><br /><strong>Instelling se Bewaararea (Waar van Toepassing): </strong><br />Deur hierdie opsie te kies, word Turnitin opdrag gegee om slegs ingediende dokumente by \'n privaat bewaararea van jou instelling te voeg. Soortgelykheidskontroles van die ingediende dokumente sal slegs deur ander instrukteurs binne jou instelling uitgevoer word.';
$string['submitted'] = 'Ingedien';
$string['submittoturnitin'] = 'Dien aan Turnitin in';
$string['szerorecords'] = 'Geen rekords om te vertoon nie.';
$string['task_name'] = 'Turnitintooltwo Cron-taak';
$string['testingconnection'] = 'Konneksie aan Turnitin word getoets';
$string['textsubmission'] = 'Teksindiening';
$string['texttosubmit'] = 'Teks om in te dien';
$string['texttosubmit_help'] = 'Kopieer en plak die teks van jou indiening in hierdie boks.';
$string['tii2updateerror'] = 'Daar was \'n probleem met die bywerk van die V2-opdrag in die datatabasis. Probeer asseblief weer.<br />';
$string['tii_submission_failure'] = 'Raadpleeg asseblief jou tutor of Moodle-administrateur vir verdere inligting';
$string['tiiaccountconfig'] = 'Turnitin-rekeningkonfigurasie';
$string['tiiaccountsettings'] = 'Turnitin-rekeningverstellings';
$string['tiiaccountsettings_desc'] = 'Verseker asseblief dat hierdie verstellings ooreenstem met dié in jou Turnitin-rekening, anders kan jy probleme ervaar met opdragskepping en/of studentindienings.';
$string['tiiassignmentgeterror'] = 'Daar het \'n fout voorgekom toe daar probeer is om \'n opdrag van Turnitin te verkry';
$string['tiidebugginglogs'] = 'Ontfouting en Loginskrywing';
$string['tiiexplain'] = 'Turnitin is \'n kommersiële produk en jy moes intekengeld vir hierdie diens betaal het. Vir meer inligting, sien <a href=http://docs.moodle.org/en/Turnitin_administration>http://docs.moodle.org/en/Turnitin_administration</a>';
$string['tiimiscsettings'] = 'Diverse Invoegtoepassingverstellings';
$string['tiisubmissiongeterror'] = 'Daar het \'n fout voorgekom toe daar probeer is om \'n indiening vanaf Turnitin te verkry';
$string['tiisubmissionsgeterror'] = 'Daar het \'n fout voorgekom toe daar probeer is om indienings vir hierdie opdrag van Turnitin te verkry';
$string['tiiusergeterror'] = 'Daar was \'n fout toe daar probeer is om die gebruikersbesonderhede van Turnitin te verkry';
$string['title'] = 'Titel';
$string['transmatch'] = 'Vertaalbypassing';
$string['transmatch_desc'] = 'Bepaal of Vertaalbypassing as \'n verstelling op die opdrag se opstelskerm beskikbaar sal wees.<br /><i>(Ontsper hierdie opsie slegs as Vertaalbypassing op jou Turnitin-rekening ontsper is)</i>';
$string['turnitin'] = 'Turnitin';
$string['turnitinaccountid'] = 'Turnitin-rekening-ID';
$string['turnitinaccountid_desc'] = '<b>[Vereis]</b><br />Voer jou Turnitin Primêre Rekening-ID in';
$string['turnitinanon'] = 'Anonieme Nasien';
$string['turnitinanon_help'] = 'Jy kan jou Turnitin-opdrag konfigureer om Anonieme Nasien te gebruik deur hierdie waarde na Ja te stel. Sodra \'n indiening gemaak is, kan anonieme nasien nie versper word nie.';
$string['turnitinapiurl'] = 'Turnitin API-URL';
$string['turnitinapiurl_desc'] = '<b>[Vereis]</b><br />Kies \'n Turnitin API-URL';
$string['turnitinconfig'] = 'Turnitin Plagiaatinvoegtoepassingkonfigurasie';
$string['turnitindefaults'] = 'Turnitin plagiaatinvoegtoepassing verstek verstellings';
$string['turnitindeleteconfirm'] = 'Deur indienings uit te wis, word hulle uit jou indieningslys en inkas verwyder, maar nie heeltemal\\nvan die Turnitin-databasis verwyder nie.\\n\\nIs jy seker jy wil hierdie indiening uitwis? Hierdie aksie kan nie ongedaan gemaak word nie.';
$string['turnitindeletionerror'] = 'Uitwissing van Turnitin-indiening het misluk. Die plaaslike Moodle-kopie is verwyder, maar die indiening in Turnitin kon nie verwyder word nie.';
$string['turnitindiagnostic'] = 'Ontsper Diagnostiese Modus';
$string['turnitindiagnostic_desc'] = '<b>[Versigtig]</b><br />Ontsper Diagnostiese Modues slegs om probleme met Turnitin-API op te spoor.';
$string['turnitinenablepeermark'] = 'Ontsper Peermark-opdragte';
$string['turnitinenablepeermark_desc'] = 'Kies of die skep van Peermark-opdragte toegelaat moet word.<br/><i>(Dit is slegs beskikbaar aan diegene wat Peermark vir hul rekening gekonfigureer het)</i>';
$string['turnitinenrolstudents'] = 'Skryf Alle Studente In';
$string['turnitingmoptions'] = 'GradeMark-opsies';
$string['turnitinhelpdesk'] = 'Turnitin-Hulptoonbank';
$string['turnitinid'] = 'Turnitin-ID';
$string['turnitinloading'] = 'Data word Gesinchroniseer';
$string['turnitinoroptions'] = 'Opsies van Soortgelykheidsverslae';
$string['turnitinpaperid'] = 'Turnitin-indiening-ID';
$string['turnitinpart'] = 'Deel {$a}';
$string['turnitinpluginsettings'] = 'Verstellings van Turnitin-plagiaatinvoegtoepassing';
$string['turnitinppulapost'] = 'Jou dokument is nie aan Turnitin ingedien nie. Kliek asseblief hier om ons EULA te aanvaar.';
$string['turnitinppulapre'] = 'Om \'n dokument aan Turnitin in te doen, moet jy eers ons EULA aanvaar. Deur die EULA nie te aanvaar nie, sal jou dokument slegs aan Moodle ingedien word. Kliek hier om te aanvaar.';
$string['turnitinrefreshingsubmissions'] = 'Indienings word Verfris';
$string['turnitinrefreshsubmissions'] = 'Verfris Indienings';
$string['turnitinrepositoryoptions'] = 'Indieningbewaararea-opdragte';
$string['turnitinrepositoryoptions_desc'] = 'Kies die bewaararea-opsies vir Turnitin-opdragte.<br /><i>(\'n Instellingsbewaararea is slegs beskikbaar aan diegene wat dit vir hul rekening ontsper het)</i>';
$string['turnitinrepositoryoptions_help'] = '<strong>Ontsper instrukteur standaard bewaararea-opsies: </strong><br />Instrukteurs kan Turnitin opdrag gee om dokumente by óf die standaard bewaararea, óf by geen area te voeg nie.<br /><br /><strong>Ontsper instrukteur uitgebreide bewaararea-opsies: </strong><br />Hierdie opsie sal instrukteurs toelaat om \'n opdragverstelling te beskou, om studente toe te laat om Turnitin opdrag te gee waar hul dokumente geberg sal word. Studente kan kies om hul dokumente by die standaard studentbewaararea te voeg, of by jou instelling se privaat bewaararea.<br /><br /><strong>Dien alle indienings aan die standaard bewaararea in: </strong><br />Alle dokumente sal by verstek by die standaard studentbewaararea gevoeg word.<br /><br /><strong>Moet geen indienings aan \'n bewaararea indien nie: </strong>Dokumente sal slegs gebruik word om die aanvanklike kontrole met Turnitin te doen en om aan die instrukteur vir nasien te vertoon.<br /><br /><strong>Dien alle indienings aan die instelling se bewaararea in: </strong><br />Turnitin word opdrag gegee om alle indienings binne die instelling se indieningbewaararea te berg. Soortgelykheidskontroles van die ingediende dokumente sal slegs deur ander instrukteurs binne jou instelling uitgevoer word.';
$string['turnitinsecretkey'] = 'Turnitin Gedeelde Sleutel';
$string['turnitinsecretkey_desc'] = '<b>[Vereis]</b><br />Voer jou Turnitin Gedeelde sleutel in<br /></i>(Gestel deur jou Turnitin-administrateur)</i>';
$string['turnitinsettingshelpwizard'] = 'Ontsper Turnitin-hulptoonbank vir Instrukteurs';
$string['turnitinsettingshelpwizard_desc'] = 'Kies of instrukteurs toegang tot die Turnitin-hulptoonbankslimmerd vanuit Moodle mag hê.';
$string['turnitinstatus'] = 'Turnitin-status';
$string['turnitinstudents'] = 'Turnitin-studente';
$string['turnitinstudents_desc'] = 'Die gekose Gebruikers hieronder is vir hierdie Turnitin-klas ingeskryf. Ingeskrewe studente kan toegang tot hierdie klas verkry deur op die Turnitin-weberf in te teken.';
$string['turnitinstudentsremove'] = 'Is jy seker jy wil hierdie student uit die kursus binne Turnitin verwyder?';
$string['turnitinsubmissionid'] = 'Turnitin-indiening-ID';
$string['turnitintoolofflineerror'] = 'Ons ervaar \'n tydelike probleem. Probeer asseblief binnekort weer.';
$string['turnitintooltwo'] = 'Turnitin-hulpmiddel';
$string['turnitintooltwo:addinstance'] = 'Voeg Turnitin-hulpmiddelaktiwiteit by';
$string['turnitintooltwo:admin'] = 'Bestuur Turnitin-hulpmiddel';
$string['turnitintooltwo:grade'] = 'Merk Turnitin-hulpmiddelopdragte';
$string['turnitintooltwo:read'] = 'Lees Turnitin-hulpmiddelopdragte';
$string['turnitintooltwo:submit'] = 'Dien aan Turnitin-hulpmiddelopdragte in';
$string['turnitintooltwo:view'] = 'Besigtig Turnitin-hulpmiddelopdragte';
$string['turnitintooltwoadministration'] = 'Turnitin Opdrag 2-administrasie';
$string['turnitintooltwoagreement'] = 'Vrywaring / Ooreenkoms';
$string['turnitintooltwoagreement_default'] = 'Ek bevestig dat hierdie indiening my eie werk is en ek aanvaar alle verantwoordelikheid vir enige kopieregskending wat as gevolg van hierdie indiening kan plaasvind.';
$string['turnitintooltwoagreement_desc'] = '<b>[Opsioneel]</b><br />Voer \'n ooreenkomsbevestigingstelling vir indienings in.<br />(<b>Let wel:</b> As die ooreenkoms heeltemal blanko gelaat word, sal geen ooreenkomsbevestiging deur studente tydens indiening vereis word nie)';
$string['turnitintooltwodeleteerror'] = 'Kon nie turnitintooltwo-data uitwis nie';
$string['turnitintooltwogeterror'] = 'Kon nie turnitintooltwo-data verkry nie';
$string['turnitintooltwointro'] = 'Opsomming';
$string['turnitintooltwoname'] = 'Turnitin-opdragnaam';
$string['turnitintooltworesetdata0'] = 'Kopieer Turnitin-opdragte <i>(Skep Duplikate, Nuwe Turnitin-klas)</i>';
$string['turnitintooltworesetdata1'] = 'Vervang Turnitin-opdragte <i>(Vervang Opdragdele, Hergebruik Turnitin-klas)</i>';
$string['turnitintooltworesetdata2'] = 'Laat Turnitin-opdragte onaangeraak';
$string['turnitintooltworesetinfo'] = 'Kies \'n opsie hieronder vir die Turnitin-opdragte in hierdie kursus:';
$string['turnitintooltwoupdateerror'] = 'Kon nie Turnitintooltwo-data bywerk nie';
$string['turnitintutors'] = 'Turnitin-tutors';
$string['turnitintutors_desc'] = 'Die geselekteerde Tutors hieronder is as tutors op hierdie Turnitin-klas ingeskryf. Ingeskrewe tutors kan toegang tot hierdie klas verkry deur op die Turnitin-webwerf in te teken.';
$string['turnitintutorsadd'] = 'Voeg Turnitin-tutor by';
$string['turnitintutorsallenrolled'] = 'Alle Tutors is op Turnitin ingeskryf';
$string['turnitintutorsremove'] = 'Is jy seker jy wil hierdie tutor van die kursus binne Turnitin verwyder?';
$string['turnitinula'] = 'Jy moet die nuutste Turnitin-gebruikersooreenkoms aanvaar, voordat jy \'n indiening kan maak.';
$string['turnitinula_btn'] = 'Kliek asseblief hier om die Ooreenkoms te lees en te aanvaar.';
$string['turnitinuseanon'] = 'Gebruik Anonieme Nasien';
$string['turnitinuseanon_desc'] = 'Kies of Anonieme Nasien toegelaat moet word wanneer indienings nagesien word.<br /><i>(Dit is slegs beskikbaar aan diegene wat Anonieme Nasien vir hul rekenaar gekonfigureer het)</i>';
$string['turnitinusegrademark'] = 'Gebruik GradeMark';
$string['turnitinusegrademark_desc'] = 'Kies of GradeMark gebruik moet word om indienings na te sien.<br /><i>(Dit is slegs beskikbaar aan diegene wat GradeMark vir hul rekening ontsper het)</i>';
$string['turnitinusegrademark_help'] = 'Gebruik hierdie verstelling om te kies om Turnitin GradeMark te gebruik om die indienings na te sien, of om Moodle te gebruik om indiening na te sien.';
$string['turnitinuserepository'] = 'Ontsper Instellingbewaararea';
$string['turnitinuserepository_desc'] = 'Kies of die gebruik van Instellingbewaarareas in Turnitin-opdragte toegelaat moet word.<br /><i>(Dit is slegs beskikbaar aan diegene wat \'n Instellingbewaararea vir hul rekening ontsper het)</i>';
$string['turnitinuserepository_help'] = 'Gebruik hierdie verstelling om die Instellingbewaararea-opsie in die opdrag se opstelskerm te ontsper.<br /><i>(Dit is slegs beskikbaar aan diegene wat \'n Instellingbewaararea vir hul rekenaar ontsper het)</i>';
$string['tutoradded'] = 'Tutor is by die kursus in Turnitin bygevoeg';
$string['tutoraddingerror'] = 'Daar was \'n probleem met die byvoeg van die tutor by die kursus in Turnitin';
$string['tutorremoved'] = 'Tutor is uit die kursus binne Turnitin verwyder';
$string['tutorremovingerror'] = 'Daar was \'n probleem met die verwydering van die tutor vanuit die kursus binne Turnitin.';
$string['tutorstatus'] = '{$a->submitted}/{$a->total} Studentindienings, {$a->graded} Indiening {$a->gplural} Nagesien';
$string['type'] = 'Indieningstipe';
$string['types'] = 'Indieningstipes';
$string['types_help'] = '<p>Indienings kan in twee verskillende formate gedoen word. Kopieer en Plak, of Dokumentoplaai.</p>';
$string['unanonymiseerror'] = 'Daar was \'n fout toe daar probeer is om die naam van die student te onthul';
$string['uniquepartname'] = 'Deelnaam moet uniek wees';
$string['unlinkedusers'] = 'Ontkoppelde Gebruikers';
$string['unlinkrelinkusers'] = 'Ontkoppel / Herkoppel Turnitin-gebruikers';
$string['unlinkusers'] = 'Ontkoppel Gebruikers';
$string['updatepart'] = 'Werk Deel By';
$string['updatesubmissionerror'] = 'Daar was \'n fout toe daar probeer is om jou indiening aan Turnitin weer in te dien';
$string['upgradeavailable'] = 'Bywerking Beskikbaar';
$string['upgradenotavailable'] = 'Geen Bywerking Beskikbaar nie';
$string['uploadingsubtoturnitin'] = 'Jou indiening word op Turnitin gelaai';
$string['user'] = 'Gebruiker';
$string['usercreationerror'] = 'Skep van Turnitin-gebruiker het misluk';
$string['userdeleteerror'] = 'Kon nie gebruikerdata uitwis nie';
$string['userfinderror'] = 'Daar was \'n fout toe daar probeer is om die gebruiker in Turnitin te vind';
$string['usergeterror'] = 'Kon nie gebruikerdata verkry nie';
$string['userjoinerror'] = 'Daar was \'n fout toe daar probeer is om \'n gebruiker aan \'n kursus in Turnitin te koppel';
$string['userremoveerror'] = 'Daar was \'n fout toe daar probeer is om \'n gebruiker van \'n kursus in Turnitin te verwyder';
$string['userstounlink'] = 'Gebruikers om te Ontkoppel';
$string['usersunlinkrelink'] = 'Gebruikers om te Ontkoppel / Herkoppel';
$string['userupdateerror'] = 'Kon nie gebruikerdata bywerk nie';
$string['useturnitin'] = 'Ontsper Turnitin';
$string['useturnitin_mod'] = 'Ontsper Turnitin vir {$a}';
$string['usinglatest'] = 'Jy gebruik die nuutste weergawe!';
$string['v1assignmentsdeleted'] = 'Die opdrag(te) is suksesvol uitgewis.';
$string['v1migrationsubtitle'] = 'Moodle Direct V1 na V2 Migrasiehulpmiddel';
$string['v1migrationtitle'] = 'V1-migrasie';
$string['viewdigitalreceipt'] = 'Beskou Digitale Kwitansie';
$string['viewreport'] = 'Besigtig Verslag';
$string['viewsubmission'] = 'Besigtig Indiening';
$string['viewsubmissiondesc'] = 'Gebruiker het indiening besigtig';
$string['wrongaccountid'] = 'Daar was \'n fout met koppeling aan jou Turnitin-klas. Die rekening wat jy gekonfigureer het, is rekening {$a->current}. Die rekening waaruit hierdie klas is, is {$a->backupid}. Jy kan net klasse herstel wat uit dieselfde Turnitin-rekening afkomstig is.';
$string['yes'] = 'Ja';
$string['yesgrades'] = 'Ja, verfris soortgelykheidstellings en punte outomaties';
