<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'no', version '4.1'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Etikett for hjelpemidler';
$string['acceptTerms'] = 'Jeg aksepterer <a href=":url" target="_blank">brukervilkårene</a>';
$string['accountDetailsLinkText'] = 'her';
$string['actions'] = 'Handlinger';
$string['add'] = 'Legg til';
$string['addedandupdatedpp'] = 'La til {$a->%new} nye H5P bibliotek og oppdaterte {$a->%old} gamle.';
$string['addedandupdatedps'] = 'La til {$a->%new} nye H5P bibliotek og oppdaterte {$a->%old} gammelt.';
$string['addedandupdatedsp'] = 'La til {$a->%new} nytt H5P bibliotek og oppdaterte {$a->%old} gamle.';
$string['addedandupdatedss'] = 'La til {$a->%new} nytt H5P bibliotek og oppdaterte {$a->%old} gammelt.';
$string['addednewlibraries'] = 'La til {$a->%new} nye H5P bibliotek.';
$string['addednewlibrary'] = 'La til {$a->%new} nytt H5P bibliotek.';
$string['additionallicenseinfo'] = 'Mer informasjon om lisensen';
$string['address'] = 'Addresse';
$string['age'] = 'Typisk alder';
$string['ageDescription'] = 'Målgruppe for dette innholdet. Aldergrupper kan separeres med komma, f.eks. "1,34-45,-50,59-"';
$string['altText'] = 'Alternativ tekst';
$string['atto_h5p'] = 'Sett inn H5P-knapp';
$string['atto_h5p_description'] = 'Knappen "Sett inn H5P" i Atto-editoren lar brukere sette inn H5P-innhold ved å legge inn en URL, innbyggingskode eller laste opp en H5P-fil.';
$string['author'] = 'Forfatter';
$string['authorcomments'] = 'Forfatterkommentarer';
$string['authorcommentsdescription'] = 'Kommentarer fra innholdets forfatter. (Denne teksten vil ikkepubliseres som en del av opphavsrettinformasjonen.)';
$string['authorname'] = 'Forfatters navn';
$string['authorrole'] = 'Forfatters rolle';
$string['back'] = 'Tilbake';
$string['by'] = 'av';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Nei';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Ja';
$string['cancelPublishConfirmationDialogDescription'] = 'Er du sikker på at du ønsker å avbryte delingsprosessen?';
$string['cancelPublishConfirmationDialogTitle'] = 'Avbryt deling';
$string['cancellabel'] = 'Avbryt';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changeHasBeenSubmitted'] = 'Det har blitt gjort en endring for';
$string['changedby'] = 'Endret av';
$string['changedescription'] = 'Endringsbeskrivelse';
$string['changelog'] = 'Endringslogg';
$string['changeplaceholder'] = 'Foto beskåret, tekst endret, etc.';
$string['city'] = 'Sted';
$string['close'] = 'Lukk';
$string['confirmdialogbody'] = 'Vennligst bekreft at du ønsker å fortsette. Denne handlingen kan ikke angr';
$string['confirmdialogheader'] = 'Bekreft handling';
$string['confirmlabel'] = 'Bekreft';
$string['connectionLost'] = 'Tilkobling tapt. Resultatene blir lagret og sendt når forbindelsen er gjenopprettet.';
$string['connectionReestablished'] = 'Tilkoblingen gjenopprettet.';
$string['contactPerson'] = 'Kontaktperson';
$string['contactPersonDescription'] = 'H5P vil ta kontakt med kontaktpersonen i tilfelle det er problemer med det delte innholdet. Kontaktpersonens navn eller annen informasjon vil ikke publiseres eller deles med tredjeparter.';
$string['contentAvailable'] = 'Innholdet vil vanligvis bli tilgjengelig på huben i løpet av en virkedag.';
$string['contentCopied'] = 'Innhold kopiert til utklippstavla';
$string['contentLicenseTitle'] = 'Lisensinformasjon';
$string['contentUpdateSoon'] = 'Innholdet ditt vil oppdateres snart';
$string['contentchanged'] = 'Innholdet har blitt endret siden sist visning.';
$string['contentinuse'] = 'Dette innholdet kan være i bruk andre steder.';
$string['contenttype'] = 'Innholdstype';
$string['copyright'] = 'Bruksrettigheter';
$string['copyrightWarning'] = 'Opphavsrettsbeskyttet materiale kan ikke deles i H5P Content Hub. Hvis innholdet er lisensiert med en OER-vennlig lisens som Creative Commons, vennligst velg riktig lisens. Hvis ikke kan dette innholdet ikke deles.';
$string['copyrightinfo'] = 'Opphavsrettinformasjon';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Vis informasjon om opphavsrett for innholdet.';
$string['couldNotParseJSONFromZip'] = 'Kan ikke analysere JSON fra pakken: {$a ->%fileName}';
$string['couldNotReadFileFromZip'] = 'Kan ikke lese fil fra pakken: {$a ->%fileName}';
$string['country'] = 'Land';
$string['creativecommons'] = 'Creative Commons';
$string['currentStep'] = 'Steg :step av :total';
$string['date'] = 'Dato';
$string['deletelibraryconfirm'] = '<p>Er du sikker på at du ønsker å slette versjon <em>\'{$a->version}\'</em> fra biblioteket <em>\'{$a->name}\'</em>? Dette vil fjerne biblioteket all dets bruk.</p><p>Dette kan ikke angres.</p>';
$string['deletelibraryversion'] = 'Slett versjon';
$string['deleting'] = 'Sletter et bibliotek';
$string['description'] = 'Beskrivelse';
$string['disablefullscreen'] = 'Deaktiver fullskjerm';
$string['discipline:dropdownButton'] = 'Nedtrekksknapp';
$string['discipline:in'] = 'i';
$string['discipline:searchPlaceholder'] = 'Søk etter fagfelt';
$string['disciplineDescription'] = 'Du kan velge flere fagfelt';
$string['disciplineLabel'] = 'Fagfelt';
$string['disciplineLimitReachedMessage'] = 'Du kan velge opptil :numDisciplines fagfelt';
$string['disciplines'] = 'Fagfelt';
$string['download'] = 'Last ned';
$string['downloadtitle'] = 'Last ned dette innholdet som en H5P-fil.';
$string['editInfoTitle'] = 'Rediger informasjon for <strong>:title</strong>';
$string['editcontent'] = 'Rediger H5P-innhold';
$string['editingFailed'] = 'Redigering mislyktes.';
$string['editor'] = 'Redaktør';
$string['emailAddress'] = 'Epostadresse';
$string['emailAddressDescription'] = 'Epostadressen vil brukes av H5P for å kontakte utgiveren i tilfelle det er problemer med innholdet eller utgiveren ønsker å gjenopprette kontoen sin. Den vil ikke publiseres eller deles med tredjeparter.';
$string['embed'] = 'Bygg inn';
$string['embedtitle'] = 'Vis innbyggingskoden for dette innholde';
$string['error:emptycontentid'] = 'Oppgitt URL er feil, eller du kan ikke redigere denne filen.';
$string['eventh5pdeleted'] = 'H5P slettet';
$string['eventh5pviewed'] = 'H5P innhold vist';
$string['feature'] = 'Funksjoner';
$string['fetchtypesfailure'] = 'Kunne ikke finne noen informasjon om tilgjengelige H5P innholdstyper. Kunne ikke koble til H5P filområde.';
$string['fileExceedsMaxSize'] = 'En av filene inni pakken er større en maks tillatt filstørrelse. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Vis H5P filter';
$string['filter_displayh5p_description'] = 'Vis H5P filteret konverterer URLer til innebygd H5P innhold.';
$string['fullscreen'] = 'Fullskjerm';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'H5P-editor';
$string['h5pfilenotfound'] = 'H5P-fil ikke funnet';
$string['h5pinvalidurl'] = 'Ugyldig H5P innholdsURL';
$string['h5plibraryhandler'] = 'H5P rammeverkhåndterer';
$string['h5plibraryhandler_help'] = 'H5P rammeverket som brukes til å vise H5P-innhold. Nyeste versjon er anbefalt.';
$string['h5pmanage'] = 'Administrer H5P innholdstyper';
$string['h5poverview'] = 'H5P oversikt';
$string['h5ppackage'] = 'H5P innholdstype';
$string['h5ppackage_help'] = 'En H5P innholdstype er en fil med endelsen H5P eller Zip som innehodler alle påkrevde bibliotek for å vise innholdet.';
$string['h5pprivatefile'] = 'H5P-innholdet kan ikke vises siden du ikke har tilgang til .h5p-filen.';
$string['h5psettings'] = 'H5P innstillinger';
$string['h5ptitle'] = 'Besøk h5p.org for å sjekke ut mer innhold.';
$string['helpChoosingLicense'] = 'Hjelp meg å velge lisens';
$string['hideadvanced'] = 'Skjul avansert';
$string['icon'] = 'Ikon';
$string['iconDescription'] = '640x480 piksler. Hvis ikke valgt innhold vil bruke kategoriikonet';
$string['installedcontentlibraries'] = 'Installerte H5P bibliotek';
$string['installedcontenttypes'] = 'Installerte H5P innholdstyper';
$string['installedh5p'] = 'Installert H5P';
$string['invalidAge'] = 'Ugyldig inndataformat for typisk alder. Mulige inndataformater atskilt med komma: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'H5P-fil ikke funnet (ugyldig kontekstid)';
$string['invalidfile'] = 'Filen "{$a ->% filename}" er ikke tillatt. Bare filer med følgende utvidelser er tillatt: {$a ->%files-allowed}.';
$string['invalidlanguagefile'] = 'Ugyldig språkfil {$a->%file} i bibliotek {$a->%library}';
$string['invalidlanguagefile2'] = 'Ugyldig språkfil {$a->%languageFile} har blitt inkludert i biblioteket {$a->%name}';
$string['invalidlibrarydata'] = 'Ugyldig data for {$a->%property} i {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Ugyldig data oppgitt for {$a->%property} i {$a->%library}. Boolsk verdi forventet.';
$string['invalidlibraryname'] = 'Ugyldig biblioteknavn: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P biblioteket {$a->%library} brukt i innholdet er ikke gldig';
$string['invalidlibraryoption'] = 'Ugylidg valg {$a->%option} i {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan ikke lese egenskapen {$a->%property} i {$a->%library}';
$string['invalidmainjson'] = 'Det mangler en gyldig h5p.json hovedfil';
$string['invalidmultiselectoption'] = 'Ugyldig valg i flervalg.';
$string['invalidpackage'] = 'Ugyldig H5P innholdstype';
$string['invalidselectoption'] = 'Ugyldig valg.';
$string['invalidsemanticsjson'] = 'Ugyldig semantics.json file har blitt inkludert i biblioteket {$a->%name}';
$string['invalidsemanticstype'] = 'H5P intern feil: ukjent innholdstype "{$a -> @type}" i semantikk. Fjerner innhold!';
$string['invalidstring'] = 'Forutsatt streng er ikke gyldig i henhold til regexp i semantikk. (verdi: "{$a ->%value}", regexp: "{$a ->%regexp}")';
$string['isNowSubmitted'] = 'Er nå lagt til i H5P-huben';
$string['keywordExists'] = 'Nøkkelord eksisterer fra før!';
$string['keywords'] = 'Nøkkelord';
$string['keywordsDescription'] = 'Du kan legge til flere nøkkelord separert med komma. Klikke "Enter" eller "Legg til" for å bekrefte nøkkelord';
$string['keywordsExits'] = 'Nøkkelord eksisterer fra før!';
$string['keywordsPlaceholder'] = 'Legg til nøkkelord';
$string['language'] = 'Språk';
$string['level'] = 'Nivå';
$string['librariesmanagerdescription'] = '<p> H5P gjør det mulig for brukere å lage interaktivt innhold ved å tilby en rekke innholdstyper. </p> <p> For å sikre at bare pålitelige H5P-innholdstyper brukes på portalen ditt, må du <i> enten </i> </p><ul> <li> Last opp H5P-innholdstyper fra h5p.org <i> eller</i></li> <li> Aktiver cron-oppgaven \'Last ned tilgjengelige H5P-innholdstyper fra h5p.org </li> > </ul> <p> Merk at brukere bare vil kunne bruke H5P-innholdstypene som er installert på portalen din. </p>';
$string['librarydirectoryerror'] = 'Bibliotekets mappenavn må samsvare med machineName eller machineName-majorVersion.minorVersion (fra library.json). (Mappe: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion}';
$string['license'] = 'Lisens';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) dedikasjon til offentlig domene';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generisk';
$string['licenseCC20'] = '2.0 Generisk';
$string['licenseCC25'] = '2.5 Generisk';
$string['licenseCC30'] = '3.0 Uportert';
$string['licenseCC40'] = '4.0 Internasjonalt';
$string['licenseDescription'] = 'Velg en lisens for ditt innhold';
$string['licenseDetails'] = 'Lisensdetaljer';
$string['licenseDialogDescription'] = 'Klikk på en spesifkk lisens for å få informasjon om riktig bruk';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Versjon 1';
$string['licenseV2'] = 'Versjon 2';
$string['licenseV3'] = 'Versjon 3';
$string['licenseVersionDescription'] = 'Velg en lisensversjon';
$string['licensee'] = 'Lisensholder';
$string['licenseextras'] = 'Lisens tillegg';
$string['licenseversion'] = 'Lisensversjon';
$string['lockh5pdeploy'] = 'H5P-innholdet er ikke tilgjengelig fordi det lastes opp. Vennligst prøv igjen senere.';
$string['logoUploadText'] = 'Organisasjonslogo eller avatar';
$string['longDescription'] = 'Lang beskrivelse';
$string['longDescriptionPlaceholder'] = 'Lang beskrivelse av innholdet ditt';
$string['mainTitle'] = 'Deler <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Denne filen kan ikke vises fordi innholdstypen er deaktivert. Kontakt administratoren din for å be om aktivering av innholdstypen.';
$string['maxLength'] = ':length er maksimalt antall tegn';
$string['missingcontentfolder'] = 'En gyldig innholdsmappe mangler';
$string['missingcoreversion'] = 'Systemet klarte ikke å installere {$a ->%component} komponenten fra pakken, da det krever en nyere versjon av H5P-modulen. Denne portalen kjører for øyeblikket versjon {$a ->%current}, mens den nødvendige versjonen er {$a ->%required} eller høyere. Oppgrader og prøv igjen.';
$string['missingdependency'] = 'Manglende avhengighet {$a->@dep} kreves av {$a->@lib}.';
$string['missinglibrary'] = 'Mangler obligatorisk bibliotek {$a->@library}';
$string['missinglibraryfile'] = 'Filae "{$a->%file}" mangler fra biblioteket: "{$a->%name}"';
$string['missinglibraryjson'] = 'Fant ikke library.json fila i gyldig format for biblioteket {$a->%name}';
$string['missinglibraryproperty'] = 'Den obligatoriske egenskapen  {$a->%property} mangler fra{$a->%library}';
$string['missingmbstring'] = '"mbstring" PHP-utvidelsen er ikke lastet inn. "mbstring" kreves at H5P fungerer som den skal.';
$string['missinguploadpermissions'] = 'Merk at bibliotekene kan eksistere i filen du lastet opp, men du har ikke lov til å laste opp nye biblioteker. Kontakt administratoren din.';
$string['next'] = 'Neste';
$string['nocopyright'] = 'Ingen opphavsrettinformasjon tilgjengelige for dette innholdet.';
$string['noextension'] = 'Filen du lastet opp er ikke en gyldig HTML5-pakke. (Den har ikke .h5p-filendelsen.)';
$string['noh5plibhandlerdefined'] = 'Det er ikke installert noen H5P-rammeverkhåndterer og H5P innhold kan ikke vises.';
$string['nojson'] = 'H5p.json-hovedfilen er ikke gyldig';
$string['nopermissiontodeploy'] = 'Denne filen kan ikke vises fordi den er lastet opp av en bruker uten den nødvendige rettigheten til å distribuere H5P-innhold.';
$string['nopermissiontoedit'] = 'Du har ikke tillatelser til å redigere H5P innhold.';
$string['notrustablefile'] = 'Denne filen kan ikke vises fordi den er lastet opp av en bruker uten mulighet til å oppdatere H5P-innholdstyper. Kontakt administratoren din for å be om innholdstypen som skal installeres.';
$string['nounzip'] = 'Filen du lastet opp er ikke en gyldig HTML5-pakke. (Det er ikke mulig å pakke den ut.)';
$string['offlineDialogBody'] = 'Vi kunne ikke sende informasjon om hvordan du fullførte denne oppgaven. Vennligst sjekk internettforbindelsen din.';
$string['offlineDialogHeader'] = 'Forbindelsen din til serveren gikk tapt';
$string['offlineDialogRetryButtonLabel'] = 'Prøv på nytt nå';
$string['offlineDialogRetryMessage'] = 'Prøv på nytt :num ....';
$string['offlineSuccessfulSubmit'] = 'Resultater sendt.';
$string['optionalInfo'] = 'Valgfri informasjon';
$string['originator'] = 'Opphavsmann';
$string['pd'] = 'Offentlig domene';
$string['pddl'] = 'Dedikasjon og lisens for offentlig domene';
$string['pdm'] = 'Offentlig domene merke (PDM)';
$string['phone'] = 'Telefon';
$string['pleaseWait'] = 'Vennligst vent...';
$string['pluginname'] = 'H5P Pakke';
$string['privacy:metadata'] = 'H5P-undersystemet lagrer ingen personopplysninger.';
$string['publisherDescription'] = 'Publiser beskrivelse';
$string['publisherDescriptionText'] = 'Dette vil vises under "Utgiverinformasjon" for delt innhold';
$string['publisherFieldDescription'] = 'Dette vil vises under "Utgivernavn" for delt innhold';
$string['publisherFieldTitle'] = 'Utgiver';
$string['registerOnHub'] = 'Registrert deg på H5P-huben';
$string['registrationFailed'] = 'En feil oppstod';
$string['registrationFailedDescription'] = 'Vi kunne ikke opprette en konto. Vennligst prøv igjen på et senere tidspunkt.';
$string['registrationTitle'] = 'H5P-hubregistrering';
$string['remove'] = 'Fjern';
$string['removeChip'] = 'Fjern :chip fra listen';
$string['removeImage'] = 'Fjern bilde';
$string['requiredInfo'] = 'Påkrevd informasjon';
$string['resizescript'] = 'Inkluder dette ksriptet på nettsiden din om du ønsker dynamisk størrelse på det innebygde inn';
$string['resubmitScores'] = 'Forsøker å levere lagrede resultater.';
$string['reuse'] = 'Bruk på nytt';
$string['reuseContent'] = 'Bruk innhold på nytt';
$string['reuseDescription'] = 'Bruk dette innholdet på nytt.';
$string['reviewAndSave'] = 'Se gjennom og lagre';
$string['reviewAndShare'] = 'Se gjennom og dele';
$string['reviewInfo'] = 'Gjennomgå info';
$string['reviewMessage'] = 'Se gjennom informasjonen nedenfor før du deler';
$string['saveChanges'] = 'Lagre endringer';
$string['screenshots'] = 'Skjermbilder';
$string['screenshotsDescription'] = 'Legg til opptil fem skjermbilder av innholdet ditt';
$string['share'] = 'Del';
$string['shareFailed'] = 'Deling mislyktes.';
$string['shareTryAgain'] = 'Noe gikk galt. Prøv å dele på nytt.';
$string['shared'] = 'Delt';
$string['sharingNote'] = 'Alle innholdsdetaljer kan redigeres etter deling';
$string['shortDescription'] = 'Kort beskrivelse';
$string['shortDescriptionPlaceholder'] = 'Kort beskrivelse av innholdet';
$string['showadvanced'] = 'Vis avansert';
$string['showless'] = 'Vis mindre';
$string['showmore'] = 'Vis mer';
$string['size'] = 'Størrelse';
$string['someKeywordsExits'] = 'Noen av disse søkeordene finnes allerede';
$string['source'] = 'Kilde';
$string['startingover'] = 'Du må starte på nytt';
$string['status'] = 'Status';
$string['subContentWarning'] = 'Underinnhold (bilder, spørsmål osv.) vil bli delt under :lisens med mindre annet er spesifisert i forfatterverktøyet';
$string['sublevel'] = 'Undernivå';
$string['submitted'] = 'Innlevert!';
$string['successfullyRegistred'] = 'Du har registrert en konto på H5P-huben';
$string['successfullyRegistredDescription'] = 'Dine kontodetaljer kan endres';
$string['successfullyUpdated'] = 'Dine kontodetaljer på H5P-huben har blitt endret';
$string['task_h5p'] = 'H5P cronjobb';
$string['task_h5p_description'] = 'H5P cronjobben laster ned H5P innholdstyper fra h5p.org';
$string['thumbnail'] = 'Thumbnail';
$string['title'] = 'Tittel';
$string['undisclosed'] = 'Ikke oppgitt';
$string['unpackedFilesExceedsMaxSize'] = 'Den totale størrelsen på de utpakkede filene overstiger den maksimale tillatte størrelsen. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Lagre kontoinnstillinger';
$string['updatedlibraries'] = 'Oppdaterte {$a->%old} H5P bibliotek.';
$string['updatedlibrary'] = 'Oppdaterte {$a->%old} H5P bibliotek.';
$string['uploadlibraries'] = 'Last opp H5P innholdstype';
$string['uploadsuccess'] = 'Vellykket opplasting av H5P innholdstyper';
$string['wrongversion'] = 'Versjonen av H5P-biblioteket {$a ->% machineName} som er brukt i dette innholdet, er ikke gyldig. Innhold inneholder {$a ->%contentLibrary}, men det skal være {$a ->%semanticsLibrary}.';
$string['year'] = 'År';
$string['years'] = 'År';
$string['yearsfrom'] = 'År (fra)';
$string['yearsto'] = 'År (til)';
$string['zip'] = 'Postnummer';
