<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'zh_cn', version '4.1'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = '地址';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = '插入/编辑书签';
$string['advanced:backcolor_desc'] = '设置背景色';
$string['advanced:block'] = '格式';
$string['advanced:blockquote'] = '板块引用';
$string['advanced:blockquote_desc'] = '板块引用';
$string['advanced:bold_desc'] = '粗体 (Ctrl+B)';
$string['advanced:bullist_desc'] = '插入/删除项目符号列表';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = '插入特殊符号';
$string['advanced:cleanup_desc'] = '清理混乱格式';
$string['advanced:clipboard_msg'] = '在Mozilla和Firfox中不能使用拷贝/剪切/粘贴功能。您想了解关于此问题的更多信息吗？';
$string['advanced:code'] = '代码';
$string['advanced:code_desc'] = '编辑HTML源代码';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = '复制';
$string['advanced:custom1_desc'] = '在此输入描述';
$string['advanced:cut_desc'] = '剪切';
$string['advanced:dd'] = '定义描述';
$string['advanced:div'] = 'DIV层级';
$string['advanced:dt'] = '名词定义';
$string['advanced:font_size'] = '文字大小';
$string['advanced:fontdefault'] = '字体';
$string['advanced:forecolor_desc'] = '文字颜色';
$string['advanced:h1'] = '一级标题';
$string['advanced:h2'] = '二级标题';
$string['advanced:h3'] = '三级标题';
$string['advanced:h4'] = '四级标题
';
$string['advanced:h5'] = '五级标题';
$string['advanced:h6'] = '六级标题';
$string['advanced:help_desc'] = '帮助';
$string['advanced:help_shortcut'] = '按 ALT-F10 为工具栏，按 ALT-0 为帮助';
$string['advanced:hr_desc'] = '插入水平线';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = '插入/编辑图片';
$string['advanced:image_props_desc'] = '图片属性';
$string['advanced:indent_desc'] = '增加缩进';
$string['advanced:italic_desc'] = '斜体 (Ctrl+I)';
$string['advanced:justifycenter_desc'] = '居中对齐';
$string['advanced:justifyfull_desc'] = '左右对齐';
$string['advanced:justifyleft_desc'] = '靠左对齐';
$string['advanced:justifyright_desc'] = '靠右对齐';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = '插入/编辑链接';
$string['advanced:more_colors'] = '更多颜色';
$string['advanced:newdocument'] = '您确定要清除所有内容吗?';
$string['advanced:newdocument_desc'] = '新建文件';
$string['advanced:numlist_desc'] = '插入/删除编号列表';
$string['advanced:outdent_desc'] = '减少缩进';
$string['advanced:paragraph'] = '段落';
$string['advanced:paste_desc'] = '粘贴';
$string['advanced:path'] = '路径';
$string['advanced:pre'] = '预设格式';
$string['advanced:redo_desc'] = '恢复（Ctrl+Y）';
$string['advanced:removeformat_desc'] = '清除格式';
$string['advanced:rich_text_area'] = '富文本';
$string['advanced:samp'] = '代码范例';
$string['advanced:shortcuts_desc'] = '可访问性功能帮助';
$string['advanced:striketrough_desc'] = '删除线';
$string['advanced:style_select'] = '样式';
$string['advanced:sub_desc'] = '下标';
$string['advanced:sup_desc'] = '上标';
$string['advanced:toolbar'] = '工具栏';
$string['advanced:toolbar_focus'] = '跳到工具按钮 - Alt+Q，跳到编辑器 - Alt+Z，跳到元素路径 - Alt-X';
$string['advanced:underline_desc'] = '下划线 (Ctrl+U)';
$string['advanced:undo_desc'] = '撤销 (Ctrl+Z)';
$string['advanced:unlink_desc'] = '删除链接';
$string['advanced:visualaid_desc'] = '显示/隐藏指南/不可见的元素';
$string['advanced_dlg:about_author'] = '作者';
$string['advanced_dlg:about_general'] = '关于';
$string['advanced_dlg:about_help'] = '帮助';
$string['advanced_dlg:about_license'] = '授权';
$string['advanced_dlg:about_loaded'] = '已加载的插件';
$string['advanced_dlg:about_plugin'] = '插件';
$string['advanced_dlg:about_plugins'] = '插件';
$string['advanced_dlg:about_title'] = '关于TinyMCE';
$string['advanced_dlg:about_version'] = '版本';
$string['advanced_dlg:accessibility_help'] = '使用帮助';
$string['advanced_dlg:accessibility_usage_title'] = '一般使用';
$string['advanced_dlg:anchor_invalid'] = '请指定有效的书签名称';
$string['advanced_dlg:anchor_name'] = '书签名称';
$string['advanced_dlg:anchor_title'] = '插入/编辑书签';
$string['advanced_dlg:charmap_title'] = '插入特殊符号';
$string['advanced_dlg:charmap_usage'] = '使用左右箭头来导航。';
$string['advanced_dlg:code_title'] = 'HTML源码编辑器';
$string['advanced_dlg:code_wordwrap'] = '自动换行';
$string['advanced_dlg:colorpicker_color'] = '颜色：';
$string['advanced_dlg:colorpicker_name'] = '名称：';
$string['advanced_dlg:colorpicker_named_tab'] = '常用颜色';
$string['advanced_dlg:colorpicker_named_title'] = '常用颜色';
$string['advanced_dlg:colorpicker_palette_tab'] = '安全色';
$string['advanced_dlg:colorpicker_palette_title'] = 'WEB颜色';
$string['advanced_dlg:colorpicker_picker_tab'] = '调色盘';
$string['advanced_dlg:colorpicker_picker_title'] = '调色盘';
$string['advanced_dlg:colorpicker_title'] = '选择颜色';
$string['advanced_dlg:image_align'] = '对齐方式';
$string['advanced_dlg:image_align_baseline'] = '基准线';
$string['advanced_dlg:image_align_bottom'] = '靠下';
$string['advanced_dlg:image_align_left'] = '靠左';
$string['advanced_dlg:image_align_middle'] = '置中';
$string['advanced_dlg:image_align_right'] = '靠右';
$string['advanced_dlg:image_align_textbottom'] = '文字下方';
$string['advanced_dlg:image_align_texttop'] = '文字上方';
$string['advanced_dlg:image_align_top'] = '靠上';
$string['advanced_dlg:image_alt'] = '图片说明';
$string['advanced_dlg:image_border'] = '边框';
$string['advanced_dlg:image_dimensions'] = '尺寸';
$string['advanced_dlg:image_hspace'] = '水平间距';
$string['advanced_dlg:image_list'] = '图片清单';
$string['advanced_dlg:image_src'] = '图片网页地址';
$string['advanced_dlg:image_title'] = '插入/编辑图片';
$string['advanced_dlg:image_vspace'] = '垂直间距';
$string['advanced_dlg:invalid_color_value'] = '无效的颜色值';
$string['advanced_dlg:link_is_email'] = '您输入的网页地址是email地址，是否需要加上 mailto:前缀？';
$string['advanced_dlg:link_is_external'] = '您输入的 网页地址 是一个外部超链接，是否要加上 http:// 前缀？';
$string['advanced_dlg:link_list'] = '链接列表';
$string['advanced_dlg:link_target'] = '目标';
$string['advanced_dlg:link_target_blank'] = '在新窗口中打开链接';
$string['advanced_dlg:link_target_same'] = '在同一个窗口中打开链接';
$string['advanced_dlg:link_title'] = '插入/编辑链接';
$string['advanced_dlg:link_titlefield'] = '标题';
$string['advanced_dlg:link_url'] = '网址链接';
$string['advhr:advhr_desc'] = '插入水平线';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = '正常';
$string['advhr_dlg:noshade'] = '无阴影';
$string['advhr_dlg:size'] = '高度';
$string['advhr_dlg:width'] = '宽度';
$string['advhr_dlg:widthunits'] = '单位';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = '插入/编辑图片';
$string['advimage_dlg:align'] = '对齐方式';
$string['advimage_dlg:align_baseline'] = '基准线';
$string['advimage_dlg:align_bottom'] = '靠下';
$string['advimage_dlg:align_left'] = '靠左';
$string['advimage_dlg:align_middle'] = '置中';
$string['advimage_dlg:align_right'] = '靠右';
$string['advimage_dlg:align_textbottom'] = '文字下方';
$string['advimage_dlg:align_texttop'] = '文字上方';
$string['advimage_dlg:align_top'] = '靠上';
$string['advimage_dlg:alt'] = '图像描述';
$string['advimage_dlg:alt_image'] = '替代图片';
$string['advimage_dlg:border'] = '边框';
$string['advimage_dlg:classes'] = '类';
$string['advimage_dlg:constrain_proportions'] = '约束比例';
$string['advimage_dlg:dialog_title'] = '插入/编辑图片';
$string['advimage_dlg:dimensions'] = '尺寸';
$string['advimage_dlg:example_img'] = '图片外观预览';
$string['advimage_dlg:general'] = '一般';
$string['advimage_dlg:height'] = '高';
$string['advimage_dlg:hspace'] = '水平间距';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = '图片列表';
$string['advimage_dlg:langcode'] = '语言代码';
$string['advimage_dlg:langdir'] = '语言书写方向';
$string['advimage_dlg:list'] = '图片列表';
$string['advimage_dlg:long_desc'] = '长描述链接';
$string['advimage_dlg:ltr'] = '从左到右';
$string['advimage_dlg:map'] = '图片 Map';
$string['advimage_dlg:misc'] = '其它';
$string['advimage_dlg:missing_alt'] = '您确定要不设置图片描述就继续吗？没有描述的图片可能会不方便残障人士、使用文本浏览器的用户或禁止浏览器显示图片的人访问。';
$string['advimage_dlg:mouseout'] = '鼠标移出';
$string['advimage_dlg:mouseover'] = '鼠标移入';
$string['advimage_dlg:preview'] = '预览';
$string['advimage_dlg:rtl'] = '从右到左';
$string['advimage_dlg:src'] = '图片网页地址';
$string['advimage_dlg:style'] = '样式';
$string['advimage_dlg:swap_image'] = '翻转图像';
$string['advimage_dlg:tab_advanced'] = '高级';
$string['advimage_dlg:tab_appearance'] = '外观';
$string['advimage_dlg:tab_general'] = '一般';
$string['advimage_dlg:title'] = '标题';
$string['advimage_dlg:vspace'] = '垂直间距';
$string['advimage_dlg:width'] = '宽';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = '插入/编辑链接';
$string['advlink_dlg:accesskey'] = '访问密钥';
$string['advlink_dlg:advanced_props'] = '高级属性';
$string['advlink_dlg:advanced_tab'] = '高级';
$string['advlink_dlg:anchor_names'] = '书签';
$string['advlink_dlg:classes'] = '类';
$string['advlink_dlg:encoding'] = '目标字符编码';
$string['advlink_dlg:event_props'] = '事件';
$string['advlink_dlg:events_tab'] = '事件';
$string['advlink_dlg:general_props'] = '一般属性';
$string['advlink_dlg:general_tab'] = '一般';
$string['advlink_dlg:height'] = '高';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = '您输入的网页地址似乎是email地址,是否需要加 mailto:前缀？';
$string['advlink_dlg:is_external'] = '您输入的 网页地址 似乎为外部超连结，是否要加上 "http://" 前缀？';
$string['advlink_dlg:langcode'] = '语言代码';
$string['advlink_dlg:langdir'] = '语言书写方向';
$string['advlink_dlg:link_list'] = '超链接清单';
$string['advlink_dlg:list'] = '超链接清单';
$string['advlink_dlg:ltr'] = '从左到右';
$string['advlink_dlg:mime'] = '目标MIME类型';
$string['advlink_dlg:popup'] = 'JavaScript 弹出窗口';
$string['advlink_dlg:popup_dependent'] = '浏览器限制(仅支持 Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = '显示地址栏';
$string['advlink_dlg:popup_menubar'] = '显示菜单栏';
$string['advlink_dlg:popup_name'] = '窗口名称';
$string['advlink_dlg:popup_opts'] = '选项';
$string['advlink_dlg:popup_position'] = '位置(X/Y)';
$string['advlink_dlg:popup_props'] = '弹出窗口属性';
$string['advlink_dlg:popup_resizable'] = '弹窗可调整大小';
$string['advlink_dlg:popup_return'] = '插入 "return false"';
$string['advlink_dlg:popup_scrollbars'] = '显示滚动条';
$string['advlink_dlg:popup_size'] = '大小';
$string['advlink_dlg:popup_statusbar'] = '显示状态栏';
$string['advlink_dlg:popup_tab'] = '弹出窗口';
$string['advlink_dlg:popup_toolbar'] = '显示工具条';
$string['advlink_dlg:popup_url'] = '弹出窗口网页地址';
$string['advlink_dlg:rel'] = '关联网页到目标';
$string['advlink_dlg:rev'] = '关联目标到网页';
$string['advlink_dlg:rtl'] = '从右到左';
$string['advlink_dlg:style'] = '样式';
$string['advlink_dlg:tabindex'] = '标签索引';
$string['advlink_dlg:target'] = '目标';
$string['advlink_dlg:target_blank'] = '在新窗口打开';
$string['advlink_dlg:target_langcode'] = '目标语言';
$string['advlink_dlg:target_name'] = '目标名称';
$string['advlink_dlg:target_parent'] = '在父窗口/框架中打开';
$string['advlink_dlg:target_same'] = '在当前窗口/框架中打开';
$string['advlink_dlg:target_top'] = '在顶层框架中打开（替换所有的框架）';
$string['advlink_dlg:title'] = '插入/编辑链接';
$string['advlink_dlg:titlefield'] = '标题';
$string['advlink_dlg:url'] = '网址链接';
$string['advlink_dlg:width'] = '宽度';
$string['advlist:circle'] = '圆圈';
$string['advlist:def'] = '默认';
$string['advlist:disc'] = '圆点';
$string['advlist:lower_alpha'] = '小写的英文字';
$string['advlist:lower_greek'] = '小写的希腊文字';
$string['advlist:lower_roman'] = '小写的罗马数字';
$string['advlist:square'] = '方形';
$string['advlist:types'] = '样式';
$string['advlist:upper_alpha'] = '大写的英文字';
$string['advlist:upper_roman'] = '大写的罗马数字';
$string['aria:rich_text_area'] = '富文本';
$string['autosave:restore_content'] = '恢复自动保存的内容';
$string['autosave:unload_msg'] = '如果您离开此网页，您所做的更改将丢失。
';
$string['autosave:warning_message'] = '如果您恢复已保存的内容，您将丢失编辑器中当前的所有内容。

您确定要恢复已保存的内容吗?';
$string['availablebuttons'] = '可用的按钮';
$string['colors:000000'] = '黑色';
$string['colors:000080'] = '深蓝色';
$string['colors:0000FF'] = '蓝色';
$string['colors:003300'] = '暗绿色';
$string['colors:003366'] = '暗蓝色';
$string['colors:008000'] = '绿色';
$string['colors:008080'] = '青色';
$string['colors:00CCFF'] = '天蓝色';
$string['colors:00FF00'] = '绿黄色';
$string['colors:00FFFF'] = '浅绿色';
$string['colors:333300'] = '暗橄榄色';
$string['colors:333333'] = '深黑灰色';
$string['colors:333399'] = '靛蓝色';
$string['colors:3366FF'] = '宝蓝色';
$string['colors:339966'] = '海绿色';
$string['colors:33CCCC'] = '蓝绿色';
$string['colors:666699'] = '灰蓝色';
$string['colors:800000'] = '褐红色';
$string['colors:800080'] = '紫色';
$string['colors:808000'] = '橄榄色';
$string['colors:808080'] = '灰色';
$string['colors:993300'] = '深橙黄色';
$string['colors:993366'] = '棕色';
$string['colors:999999'] = '中灰色';
$string['colors:99CC00'] = '黄绿色';
$string['colors:99CCFF'] = '浅天蓝色';
$string['colors:C0C0C0'] = '银色';
$string['colors:CC99FF'] = '紫红色';
$string['colors:CCFFCC'] = '浅绿色';
$string['colors:CCFFFF'] = '浅青色';
$string['colors:FF0000'] = '红色';
$string['colors:FF00FF'] = '洋红色';
$string['colors:FF6600'] = '橙色';
$string['colors:FF9900'] = '琥珀色';
$string['colors:FF99CC'] = '粉红色';
$string['colors:FFCC00'] = '金色';
$string['colors:FFCC99'] = '桃红色桃红色';
$string['colors:FFFF00'] = '黄色';
$string['colors:FFFF99'] = '淡黄色';
$string['colors:FFFFFF'] = '白色';
$string['common:apply'] = '应用';
$string['common:browse'] = '浏览';
$string['common:cancel'] = '取消';
$string['common:class_name'] = '类';
$string['common:clipboard_msg'] = '拷贝/剪切/粘贴在Mozilla和Firefox中不可用。您想了解关于此问题的更多信息吗？';
$string['common:clipboard_no_support'] = '当前浏览器不支持，请改用键盘快捷键。';
$string['common:close'] = '关闭';
$string['common:edit_confirm'] = '您想在本文本域内使用所见即所得模式吗？';
$string['common:insert'] = '插入';
$string['common:invalid_data'] = '错误:输入的值无效，这些值用红色标记。';
$string['common:invalid_data_min'] = '{#field} 必须大于{#min}';
$string['common:invalid_data_number'] = '{#field}必须是一个数字';
$string['common:invalid_data_size'] = '{#field}必须是一个数字或百分比';
$string['common:more_colors'] = '更多颜色';
$string['common:not_set'] = '--尚未设定--';
$string['common:popup_blocked'] = '抱歉，我们发现您的弹出窗口拦截器拦截了一个功能窗口。如果想全功能使用此工具，您必须对本网站禁用弹出窗口拦截器。';
$string['common:update'] = '更新';
$string['common:value'] = '(值)';
$string['contextmenu:align'] = '对齐';
$string['contextmenu:center'] = '居中对齐';
$string['contextmenu:full'] = '左右对齐';
$string['contextmenu:left'] = '靠左对齐';
$string['contextmenu:right'] = '靠右对齐';
$string['customconfig'] = '自定义配置';
$string['customconfig_desc'] = '自定义JSON格式的高级TinyMCE配置，例如： {"option1" : "value2", "option2" : "value2"}。这里指定的任何选项都会覆盖标准设置和插件设置。';
$string['customtoolbar'] = '编辑器工具栏';
$string['customtoolbar_desc'] = '每行包含一个逗号分隔的按钮名称列表，使用“换行”作为组分隔符，空行被忽略。有关默认TinyMCE按钮列表，请参见<a href="{$a}" target="_blank">{$a}</a>。
始终显示第一行，其中可以切换第二个和第三个工具栏的可见性。';
$string['directionality:ltr_desc'] = '从左到右';
$string['directionality:rtl_desc'] = '从右到左';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = '表情';
$string['emotions_dlg:cool'] = '玩酷';
$string['emotions_dlg:cry'] = '哭泣';
$string['emotions_dlg:desc'] = '表情列表';
$string['emotions_dlg:embarassed'] = '尴尬';
$string['emotions_dlg:foot_in_mouth'] = '咧嘴';
$string['emotions_dlg:frown'] = '皱眉';
$string['emotions_dlg:innocent'] = '天真';
$string['emotions_dlg:kiss'] = '吻';
$string['emotions_dlg:laughing'] = '大笑';
$string['emotions_dlg:money_mouth'] = '发财';
$string['emotions_dlg:sealed'] = '保密';
$string['emotions_dlg:smile'] = '微笑';
$string['emotions_dlg:surprised'] = '惊讶';
$string['emotions_dlg:title'] = '插入表情';
$string['emotions_dlg:tongue_out'] = '吐舌头';
$string['emotions_dlg:undecided'] = '思考';
$string['emotions_dlg:usage'] = '使用左右箭头来导航。';
$string['emotions_dlg:wink'] = '眨眼';
$string['emotions_dlg:yell'] = '大叫';
$string['fontselectlist'] = '可用字体列表';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = '文档属性';
$string['fullpage_dlg:active_color'] = 'Active 颜色';
$string['fullpage_dlg:add'] = '新增元素';
$string['fullpage_dlg:add_base'] = '基本元素';
$string['fullpage_dlg:add_comment'] = '注释';
$string['fullpage_dlg:add_link'] = 'Link 元素';
$string['fullpage_dlg:add_meta'] = 'Meta 元素';
$string['fullpage_dlg:add_script'] = 'Script 元素';
$string['fullpage_dlg:add_style'] = 'Style 元素';
$string['fullpage_dlg:add_title'] = 'Title 元素';
$string['fullpage_dlg:advanced_props'] = '高级';
$string['fullpage_dlg:advanced_tab'] = '高级';
$string['fullpage_dlg:appearance_bgprops'] = '背景属性';
$string['fullpage_dlg:appearance_linkprops'] = '链接颜色';
$string['fullpage_dlg:appearance_marginprops'] = '边距';
$string['fullpage_dlg:appearance_style'] = '样式表与样式属性';
$string['fullpage_dlg:appearance_tab'] = '外观';
$string['fullpage_dlg:appearance_textprops'] = '文字属性';
$string['fullpage_dlg:author'] = '作者';
$string['fullpage_dlg:base_element'] = '基本元素';
$string['fullpage_dlg:bgcolor'] = '背景颜色';
$string['fullpage_dlg:bgimage'] = '背景图片';
$string['fullpage_dlg:bottom_margin'] = '下边距';
$string['fullpage_dlg:charset'] = '字符集';
$string['fullpage_dlg:comment_element'] = '注释';
$string['fullpage_dlg:content'] = '内容';
$string['fullpage_dlg:copyright'] = '版权声明';
$string['fullpage_dlg:defer'] = '延期';
$string['fullpage_dlg:doctypes'] = '文档类型';
$string['fullpage_dlg:encoding'] = '字符编码';
$string['fullpage_dlg:font_face'] = '字体风格';
$string['fullpage_dlg:font_size'] = '文字大小';
$string['fullpage_dlg:fontface'] = '字体名称';
$string['fullpage_dlg:fontsize'] = '文字大小';
$string['fullpage_dlg:general_props'] = '标准';
$string['fullpage_dlg:head_elements'] = 'Head 元素';
$string['fullpage_dlg:hover_color'] = '悬停颜色';
$string['fullpage_dlg:href'] = '超链接';
$string['fullpage_dlg:hreflang'] = '超链接语言';
$string['fullpage_dlg:info'] = '信息';
$string['fullpage_dlg:langcode'] = '语言代码';
$string['fullpage_dlg:langdir'] = '语言书写方向';
$string['fullpage_dlg:langprops'] = '语言和编码';
$string['fullpage_dlg:language'] = '语言';
$string['fullpage_dlg:left_margin'] = '左边距';
$string['fullpage_dlg:link_color'] = '链接颜色';
$string['fullpage_dlg:link_element'] = 'Link 元素';
$string['fullpage_dlg:ltr'] = '从左到右';
$string['fullpage_dlg:media'] = '媒体';
$string['fullpage_dlg:meta_description'] = '描述';
$string['fullpage_dlg:meta_element'] = 'Meta 元素';
$string['fullpage_dlg:meta_index_follow'] = '索引并链接';
$string['fullpage_dlg:meta_index_nofollow'] = '索引但不链接';
$string['fullpage_dlg:meta_keywords'] = '关键字';
$string['fullpage_dlg:meta_noindex_follow'] = '不索引但链接';
$string['fullpage_dlg:meta_noindex_nofollow'] = '不索引也不链接';
$string['fullpage_dlg:meta_props'] = 'Mata信息';
$string['fullpage_dlg:meta_robots'] = '机器人';
$string['fullpage_dlg:meta_tab'] = '标准';
$string['fullpage_dlg:meta_title'] = '标题';
$string['fullpage_dlg:movedown'] = '下移选择的元素';
$string['fullpage_dlg:moveup'] = '上移选择的元素';
$string['fullpage_dlg:name'] = '名称';
$string['fullpage_dlg:properties'] = '属性';
$string['fullpage_dlg:rel'] = 'rel';
$string['fullpage_dlg:remove'] = '删除选择的元素';
$string['fullpage_dlg:rev'] = 'rev';
$string['fullpage_dlg:right_margin'] = '右边距';
$string['fullpage_dlg:rtl'] = '从右到左';
$string['fullpage_dlg:script_element'] = 'Script 元素';
$string['fullpage_dlg:src'] = '源';
$string['fullpage_dlg:style'] = '样式';
$string['fullpage_dlg:style_element'] = 'Style 元素';
$string['fullpage_dlg:stylesheet'] = '样式列表';
$string['fullpage_dlg:target'] = '目标';
$string['fullpage_dlg:text_color'] = '文字颜色';
$string['fullpage_dlg:textcolor'] = '颜色';
$string['fullpage_dlg:title'] = '文档属性';
$string['fullpage_dlg:title_element'] = 'Title 元素';
$string['fullpage_dlg:top_margin'] = '上边距';
$string['fullpage_dlg:type'] = '类型';
$string['fullpage_dlg:value'] = '值';
$string['fullpage_dlg:visited_color'] = 'Visited 颜色';
$string['fullpage_dlg:xml_pi'] = 'XML声明';
$string['fullscreen:desc'] = '切换全屏模式';
$string['iespell:download'] = '检测不到ieSpell插件程序，是否立即安装？';
$string['iespell:iespell_desc'] = '拼写检查';
$string['insertdatetime:date_fmt'] = '%Y/%m/%d';
$string['insertdatetime:day_long'] = '星期日,星期一,星期二,星期三,星期四,星期五,星期六,星期日';
$string['insertdatetime:day_short'] = '周日,周一,周二,周三,周四,周五,周六,周日';
$string['insertdatetime:insertdate_desc'] = '插入日期';
$string['insertdatetime:inserttime_desc'] = '插入时间';
$string['insertdatetime:months_long'] = '一月,二月,三月,四月,五月,六月,七月,八月,九月,十月,十一月,十二月';
$string['insertdatetime:months_short'] = '1月,2月,3月,4月,5月,6月,7月,8月,9月,10月,11月,12月';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = '切换到绝对位置';
$string['layer:backward_desc'] = '置后';
$string['layer:content'] = '新建图层...';
$string['layer:forward_desc'] = '置前';
$string['layer:insertlayer_desc'] = '插入图层';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = '插入/编辑嵌入的媒体';
$string['media:edit'] = '编辑嵌入式媒体';
$string['media_dlg:advanced'] = '高级';
$string['media_dlg:align'] = '对齐';
$string['media_dlg:align_bottom'] = '靠下';
$string['media_dlg:align_bottom_left'] = '左下';
$string['media_dlg:align_bottom_right'] = '右下';
$string['media_dlg:align_center'] = '置中';
$string['media_dlg:align_left'] = '靠左';
$string['media_dlg:align_right'] = '靠右';
$string['media_dlg:align_top'] = '靠上';
$string['media_dlg:align_top_left'] = '左上';
$string['media_dlg:align_top_right'] = '右上';
$string['media_dlg:altsource1'] = '替代来源1';
$string['media_dlg:altsource2'] = '替代来源2';
$string['media_dlg:audio'] = 'HTML5音频';
$string['media_dlg:autogotourl'] = '自动转到URL';
$string['media_dlg:autohref'] = '自动超链接';
$string['media_dlg:autostart'] = '自动播放';
$string['media_dlg:balance'] = '平衡';
$string['media_dlg:base'] = '基准';
$string['media_dlg:baseurl'] = '基准URL';
$string['media_dlg:bgcolor'] = '背景';
$string['media_dlg:cache'] = '缓存';
$string['media_dlg:captioningid'] = '字幕ID';
$string['media_dlg:center'] = '置中';
$string['media_dlg:class_name'] = '类';
$string['media_dlg:console'] = '控制台';
$string['media_dlg:constrain_proportions'] = '约束比例';
$string['media_dlg:controller'] = '控制器';
$string['media_dlg:controls'] = '控制';
$string['media_dlg:correction'] = '无须更正';
$string['media_dlg:currentmarker'] = '当前标记';
$string['media_dlg:currentposition'] = '当前位置';
$string['media_dlg:defaultframe'] = '默认框架';
$string['media_dlg:embedded_audio_options'] = '嵌入式音频选项';
$string['media_dlg:embeddedaudio'] = '嵌入式音频';
$string['media_dlg:enabled'] = '启用';
$string['media_dlg:enablejavascript'] = '启用 JavaScript';
$string['media_dlg:endtime'] = '结束时间';
$string['media_dlg:file'] = '文件/网页地址';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash 选项';
$string['media_dlg:flashvars'] = 'Flash 变量';
$string['media_dlg:fullscreen'] = '全屏';
$string['media_dlg:general'] = '一般';
$string['media_dlg:hidden'] = '隐藏';
$string['media_dlg:href'] = '超链接';
$string['media_dlg:hspace'] = '水平间距';
$string['media_dlg:html5_audio_options'] = '音频选项';
$string['media_dlg:html5_video_options'] = 'HTML5视频选项';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = '内嵌框架';
$string['media_dlg:imagestatus'] = '图片状态';
$string['media_dlg:invokeurls'] = '调用的url';
$string['media_dlg:kioskmode'] = 'Kiosk模式';
$string['media_dlg:list'] = '列表';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = '循环';
$string['media_dlg:maintainaspect'] = '锁定比例';
$string['media_dlg:menu'] = '显示选项';
$string['media_dlg:mute'] = '静音';
$string['media_dlg:name'] = '名称';
$string['media_dlg:nojava'] = '没有Java';
$string['media_dlg:numloop'] = '循环次数';
$string['media_dlg:play'] = '自动播放';
$string['media_dlg:playcount'] = '播放次数';
$string['media_dlg:playeveryframe'] = '逐帧播放';
$string['media_dlg:poster'] = '海报';
$string['media_dlg:prefetch'] = '预读取';
$string['media_dlg:preload'] = '预加载';
$string['media_dlg:preload_auto'] = '让用户的浏览器来决定';
$string['media_dlg:preload_metadata'] = '预加载视频元数据';
$string['media_dlg:preload_none'] = '不要预加载';
$string['media_dlg:preview'] = '预览';
$string['media_dlg:progress'] = '进展';
$string['media_dlg:qt_options'] = 'Quick Time 选项';
$string['media_dlg:qt_stream_warn'] = '流媒体rtsp资源应该在“高级”中的QT src域里添加。
您同时也应该添加一个非流媒体资源到src域。';
$string['media_dlg:qtsrc'] = 'QT 源';
$string['media_dlg:qtsrcchokespeed'] = '阻塞速度';
$string['media_dlg:quality'] = '品质';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = '比率';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real Media Player 选项';
$string['media_dlg:salign'] = '对齐方式';
$string['media_dlg:scale'] = '缩放';
$string['media_dlg:scriptcallbacks'] = 'Script 回调';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave 选项';
$string['media_dlg:shuffle'] = '随机';
$string['media_dlg:size'] = '外形尺寸';
$string['media_dlg:sound'] = '声音';
$string['media_dlg:source'] = '源';
$string['media_dlg:starttime'] = '开始时间';
$string['media_dlg:stretchtofit'] = '缩放至最佳大小';
$string['media_dlg:swstretchhalign'] = '缩放至水平对齐';
$string['media_dlg:swstretchstyle'] = '缩放样式';
$string['media_dlg:swstretchvalign'] = '缩放至垂直对齐';
$string['media_dlg:target'] = '目标';
$string['media_dlg:targetcache'] = '目标缓存';
$string['media_dlg:title'] = '插入/编辑嵌入的媒体';
$string['media_dlg:type'] = '类型';
$string['media_dlg:uimode'] = '用户界面模式';
$string['media_dlg:video'] = 'HTML5视频';
$string['media_dlg:volume'] = '音量';
$string['media_dlg:vspace'] = '垂直间距';
$string['media_dlg:windowlessvideo'] = '无窗口的视频';
$string['media_dlg:windowsmedia'] = 'Windows媒体';
$string['media_dlg:wmode'] = '窗口模式';
$string['media_dlg:wmp_options'] = 'Windows媒体播放器选项';
$string['nonbreaking:nonbreaking_desc'] = '插入空格';
$string['pagebreak:desc'] = '插入分页符进行打印';
$string['paste:paste_text_desc'] = '粘贴为纯文本格式';
$string['paste:paste_word_desc'] = '粘贴自Word';
$string['paste:plaintext_mode'] = '粘贴现在是纯文本模式。再次单击以切换回常规粘贴模式。粘贴后，您将回到常规的粘贴模式。';
$string['paste:plaintext_mode_stick'] = '粘贴现在是纯文本模式。再次单击以切换回常规粘贴模式。';
$string['paste:selectall_desc'] = '全选';
$string['paste_dlg:text_linebreaks'] = '保留分行符号';
$string['paste_dlg:text_title'] = '使用键盘上的Ctrl+V将文本粘贴到窗口中。';
$string['paste_dlg:word_title'] = '使用键盘上的Ctrl+V将文本粘贴到窗口中。';
$string['pluginname'] = 'TinyMCE HTML编辑器';
$string['preview:preview_desc'] = '预览';
$string['print:print_desc'] = '打印';
$string['privacy:metadata'] = 'TinyMCE HTML编辑器插件不存储任何个人数据。';
$string['save:cancel_desc'] = '取消所有更改';
$string['save:save_desc'] = '保存';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = '查找/替换';
$string['searchreplace:search_desc'] = '查找';
$string['searchreplace_dlg:allreplaced'] = '所有符合的字符串均已替换。';
$string['searchreplace_dlg:direction'] = '方向';
$string['searchreplace_dlg:down'] = '向下';
$string['searchreplace_dlg:findnext'] = '查找下一个';
$string['searchreplace_dlg:findwhat'] = '查找目标';
$string['searchreplace_dlg:mcase'] = '区分大小写';
$string['searchreplace_dlg:notfound'] = '查找已经完成。没有找到字符串。';
$string['searchreplace_dlg:replace'] = '替换';
$string['searchreplace_dlg:replace_title'] = '查找/替换';
$string['searchreplace_dlg:replaceall'] = '全部替换';
$string['searchreplace_dlg:replacewith'] = '替换为';
$string['searchreplace_dlg:search_title'] = '查找';
$string['searchreplace_dlg:searchnext_desc'] = '继续查找';
$string['searchreplace_dlg:up'] = '向上';
$string['settings'] = '常规设置';
$string['simple:bold_desc'] = '粗体(Ctrl+B)';
$string['simple:bullist_desc'] = '插入/删除项目符号列表';
$string['simple:cleanup_desc'] = '清理混乱的代码';
$string['simple:italic_desc'] = '斜体 (Ctrl+I)';
$string['simple:numlist_desc'] = '插入/删除编号列表';
$string['simple:redo_desc'] = '恢复 (Ctrl+Y)';
$string['simple:striketrough_desc'] = '删除线';
$string['simple:underline_desc'] = '下划线 (Ctrl+U)';
$string['simple:undo_desc'] = '撤销 (Ctrl+Z)';
$string['spellchecker:desc'] = '切换拼写检查器';
$string['spellchecker:ignore_word'] = '忽略';
$string['spellchecker:ignore_words'] = '全部忽略';
$string['spellchecker:langs'] = '语言';
$string['spellchecker:learn_word'] = '学习单词';
$string['spellchecker:menu'] = '拼写检查器设置';
$string['spellchecker:no_mpell'] = '没有发现拼写错误。';
$string['spellchecker:no_sug'] = '无建议';
$string['spellchecker:sug'] = '建议';
$string['spellchecker:wait'] = '请稍候...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = '编辑 CSS 样式表';
$string['style_dlg:apply'] = '应用';
$string['style_dlg:background'] = '背景';
$string['style_dlg:background_attachment'] = '附件';
$string['style_dlg:background_color'] = '背景颜色';
$string['style_dlg:background_hpos'] = '水平位置';
$string['style_dlg:background_image'] = '背景图片';
$string['style_dlg:background_repeat'] = '重复';
$string['style_dlg:background_tab'] = '背景';
$string['style_dlg:background_vpos'] = '垂直位置';
$string['style_dlg:block'] = '区块';
$string['style_dlg:block_display'] = '显示';
$string['style_dlg:block_letterspacing'] = '字母间距';
$string['style_dlg:block_tab'] = '区块';
$string['style_dlg:block_text_align'] = '文字对齐';
$string['style_dlg:block_text_indent'] = '文字缩进';
$string['style_dlg:block_vertical_alignment'] = '垂直对齐';
$string['style_dlg:block_whitespace'] = '空格';
$string['style_dlg:block_wordspacing'] = '间距';
$string['style_dlg:border'] = '边框';
$string['style_dlg:border_tab'] = '边框';
$string['style_dlg:bottom'] = '靠下';
$string['style_dlg:box'] = '方块';
$string['style_dlg:box_clear'] = '清除';
$string['style_dlg:box_float'] = '浮动';
$string['style_dlg:box_height'] = '高';
$string['style_dlg:box_tab'] = '方块';
$string['style_dlg:box_width'] = '宽';
$string['style_dlg:bullet_image'] = '图片项目符号';
$string['style_dlg:clip'] = '剪辑';
$string['style_dlg:color'] = '颜色';
$string['style_dlg:height'] = '高';
$string['style_dlg:left'] = '左侧';
$string['style_dlg:list'] = '列表';
$string['style_dlg:list_tab'] = '列表';
$string['style_dlg:list_type'] = '类型';
$string['style_dlg:margin'] = '外边距';
$string['style_dlg:overflow'] = '溢出';
$string['style_dlg:padding'] = '内边距';
$string['style_dlg:placement'] = '布局';
$string['style_dlg:position'] = '位置';
$string['style_dlg:positioning_tab'] = '位置';
$string['style_dlg:positioning_type'] = '类型';
$string['style_dlg:right'] = '右侧';
$string['style_dlg:same'] = '全部相同';
$string['style_dlg:style'] = '样式';
$string['style_dlg:text'] = '文本';
$string['style_dlg:text_blink'] = '闪烁';
$string['style_dlg:text_case'] = '字型';
$string['style_dlg:text_color'] = '颜色';
$string['style_dlg:text_decoration'] = '装饰';
$string['style_dlg:text_font'] = '字体';
$string['style_dlg:text_lineheight'] = '行高';
$string['style_dlg:text_none'] = '无';
$string['style_dlg:text_overline'] = '上划线';
$string['style_dlg:text_props'] = '文本';
$string['style_dlg:text_size'] = '文字大小';
$string['style_dlg:text_striketrough'] = '删除线';
$string['style_dlg:text_style'] = '样式';
$string['style_dlg:text_tab'] = '文本';
$string['style_dlg:text_underline'] = '底线';
$string['style_dlg:text_variant'] = '变量';
$string['style_dlg:text_weight'] = '字重';
$string['style_dlg:title'] = '编辑 CSS 样式表';
$string['style_dlg:toggle_insert_span'] = '在选择处插入跨度';
$string['style_dlg:top'] = '顶部';
$string['style_dlg:visibility'] = '可见';
$string['style_dlg:width'] = '宽';
$string['style_dlg:zindex'] = 'Z-坐标';
$string['subplugintype_tinymce'] = '插件';
$string['subplugintype_tinymce_plural'] = '插件';
$string['table:cell'] = '单元格';
$string['table:cell_desc'] = '单元格属性';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = '列';
$string['table:col_after_desc'] = '在右侧插入列';
$string['table:col_before_desc'] = '在左侧插入列';
$string['table:copy_row_desc'] = '复制表行';
$string['table:cut_row_desc'] = '剪切表行';
$string['table:del'] = '删除表格';
$string['table:delete_col_desc'] = '删除列';
$string['table:delete_row_desc'] = '删除行';
$string['table:desc'] = '插入/编辑表格';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = '合并单元格';
$string['table:paste_row_after_desc'] = '粘贴到下方';
$string['table:paste_row_before_desc'] = '粘贴到上方';
$string['table:props_desc'] = '表格属性';
$string['table:row'] = '行';
$string['table:row_after_desc'] = '在下方插入行';
$string['table:row_before_desc'] = '在上方插入行';
$string['table:row_desc'] = '行属性';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = '分割单元格';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = '高级属性';
$string['table_dlg:advanced_tab'] = '高级';
$string['table_dlg:align'] = '对齐';
$string['table_dlg:align_bottom'] = '靠下';
$string['table_dlg:align_default'] = '默认';
$string['table_dlg:align_left'] = '靠左对齐';
$string['table_dlg:align_middle'] = '置中对齐';
$string['table_dlg:align_right'] = '靠右对齐';
$string['table_dlg:align_top'] = '靠上';
$string['table_dlg:bgcolor'] = '背景颜色';
$string['table_dlg:bgimage'] = '背景图片';
$string['table_dlg:border'] = '边框';
$string['table_dlg:bordercolor'] = '边框颜色';
$string['table_dlg:caption'] = '表格标题';
$string['table_dlg:cell_all'] = '更新表中的所有单元格';
$string['table_dlg:cell_cell'] = '更新当前单元格';
$string['table_dlg:cell_col'] = '更新列中的所有单元格';
$string['table_dlg:cell_limit'] = '已超过最大单元格限制：{$cells} 。';
$string['table_dlg:cell_row'] = '更新行中的所有单元格';
$string['table_dlg:cell_title'] = '单元格属性';
$string['table_dlg:cell_type'] = '单元格类型';
$string['table_dlg:cellpadding'] = '单元格填充';
$string['table_dlg:cellspacing'] = '单元格间距';
$string['table_dlg:col_limit'] = '已超过最大列数限制：{$cols}。';
$string['table_dlg:colgroup'] = '列组';
$string['table_dlg:cols'] = '列数';
$string['table_dlg:frame'] = '框架';
$string['table_dlg:frame_all'] = '全部';
$string['table_dlg:frame_cols'] = '列';
$string['table_dlg:frame_groups'] = '组';
$string['table_dlg:frame_none'] = '无';
$string['table_dlg:frame_rows'] = '行';
$string['table_dlg:general_props'] = '一般属性';
$string['table_dlg:general_tab'] = '一般';
$string['table_dlg:height'] = '高度';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = '语言代码';
$string['table_dlg:langdir'] = '语言书写方向';
$string['table_dlg:ltr'] = '从左到右';
$string['table_dlg:merge_cells_title'] = '合并单元格';
$string['table_dlg:mime'] = 'MIME 类型';
$string['table_dlg:missing_scope'] = '您确定不指定表头单元格的范围吗？没有它，或许那些有障碍的用户会更难理解表格展示的内容或数据。';
$string['table_dlg:row_all'] = '更新表格的所有行';
$string['table_dlg:row_even'] = '更新表格的偶数行';
$string['table_dlg:row_limit'] = '已超过最大行数限制：{$rows}。';
$string['table_dlg:row_odd'] = '更新表格的奇数行';
$string['table_dlg:row_row'] = '更新当前行';
$string['table_dlg:row_title'] = '行属性';
$string['table_dlg:rowgroup'] = '行组';
$string['table_dlg:rows'] = '行数';
$string['table_dlg:rowtype'] = '行类型';
$string['table_dlg:rtl'] = '从右到左';
$string['table_dlg:rules'] = '规则';
$string['table_dlg:rules_above'] = '上';
$string['table_dlg:rules_below'] = '下';
$string['table_dlg:rules_border'] = '边框';
$string['table_dlg:rules_box'] = '方块';
$string['table_dlg:rules_hsides'] = '水平';
$string['table_dlg:rules_lhs'] = '左边';
$string['table_dlg:rules_rhs'] = '右边';
$string['table_dlg:rules_void'] = '空';
$string['table_dlg:rules_vsides'] = '垂直';
$string['table_dlg:scope'] = '范围';
$string['table_dlg:style'] = '样式';
$string['table_dlg:summary'] = '摘要';
$string['table_dlg:tbody'] = '表格主体';
$string['table_dlg:td'] = '数据';
$string['table_dlg:tfoot'] = '页脚';
$string['table_dlg:th'] = '表头';
$string['table_dlg:thead'] = '页眉';
$string['table_dlg:title'] = '插入/编辑表格';
$string['table_dlg:valign'] = '垂直对齐';
$string['table_dlg:width'] = '宽度';
$string['template:desc'] = '插入预定义的模板内容';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = '星期日,星期一,星期二,星期三,星期四,星期五,星期六,星期日';
$string['template_dlg:day_short'] = '周日,周一,周二,周三,周四,周五,周六,周日';
$string['template_dlg:desc'] = '插入预定义的模板内容';
$string['template_dlg:desc_label'] = '描述';
$string['template_dlg:label'] = '模板';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = '一月,二月,三月,四月,五月,六月,七月,八月,九月,十月,十一月,十二月';
$string['template_dlg:months_short'] = '1月,2月,3月,4月,5月,6月,7月,8月,9月,10月,11月,12月';
$string['template_dlg:preview'] = '预览';
$string['template_dlg:select'] = '选择模板';
$string['template_dlg:title'] = '模板';
$string['template_dlg:warning'] = '警告:使用不同的模板更新模板可能会导致数据丢失。';
$string['visualblocks:desc'] = '显示/隐藏区块元素';
$string['visualchars:desc'] = '显示/隐藏可视控制字符';
$string['wordcount:words'] = '字数：';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = '缩写';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = '首字母缩写';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = '插入/编辑属性';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = '引用';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = '删除';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = '插入';
$string['xhtmlxtras_dlg:attrib_tab'] = '属性';
$string['xhtmlxtras_dlg:attribs_title'] = '插入/编辑属性';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = '属性';
$string['xhtmlxtras_dlg:attribute_events_tab'] = '事件';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = '快捷键';
$string['xhtmlxtras_dlg:attribute_label_cite'] = '引用';
$string['xhtmlxtras_dlg:attribute_label_class'] = '类';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = '日期/时间';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = '语言';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = '文字书写方向';
$string['xhtmlxtras_dlg:attribute_label_style'] = '样式';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tab索引';
$string['xhtmlxtras_dlg:attribute_label_title'] = '标题';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = '从左到右';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = '从右到左';
$string['xhtmlxtras_dlg:events_tab'] = '事件';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = '元素属性';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = '元素事件';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = '常规设置';
$string['xhtmlxtras_dlg:general_tab'] = '一般';
$string['xhtmlxtras_dlg:insert_date'] = '插入当前日期/时间';
$string['xhtmlxtras_dlg:option_ltr'] = '从左到右';
$string['xhtmlxtras_dlg:option_rtl'] = '从右到左';
$string['xhtmlxtras_dlg:remove'] = '移除';
$string['xhtmlxtras_dlg:title_abbr_element'] = '缩写元素';
$string['xhtmlxtras_dlg:title_acronym_element'] = '首字母缩写元素';
$string['xhtmlxtras_dlg:title_cite_element'] = '引用元素';
$string['xhtmlxtras_dlg:title_del_element'] = '删除元素';
$string['xhtmlxtras_dlg:title_ins_element'] = '插入元素';
