<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'zh_cn', version '4.1'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = '活动图标大小';
$string['activityiconsize_desc'] = '调整课程中使用的活动图标的大小。';
$string['activitylinkstitle'] = '活动';
$string['activitylinkstitle_desc'] = '查看课程中的所有活动';
$string['activitymenu'] = '显示分组活动菜单';
$string['activitymenu_desc'] = '在课程管理面板显示学生和教师的课程活动列表。这个管理面板显示了学生和老师所有活动的分组列表。';
$string['advancedsettings'] = '高级设置';
$string['alert'] = '首页提示';
$string['alert_desc'] = '这是一个会出现在首页上的特殊的提示信息。';
$string['backgroundimage'] = '默认的页面背景图片';
$string['backgroundimage_desc'] = '页面背景图片';
$string['backtotop'] = '滚动到顶部';
$string['badges'] = '勋章';
$string['badges_desc'] = '奖励您的学生';
$string['blockdisplay'] = '版块显示位置选项';
$string['blockdisplay_desc'] = '选择如何在首页和课程页面上显示版块。Fordson增加了一个3列可折叠版块面板，可以被用户隐藏。选择Boost默认选项为板块使用右侧单个列。Boost默认选项还将“添加一个版块”按钮移回页面左侧的导航栏。我们还建议在使用上述设置中的任何Boost页面布局时使用“Boost默认的单列”。';
$string['blockdisplay_off'] = 'Boost默认单列';
$string['blockdisplay_on'] = 'Fordson默认三列';
$string['blockwidthfordson'] = '版块列的宽度';
$string['blockwidthfordson_desc'] = '调整版块列的宽度。';
$string['blog'] = '博客网址';
$string['blogdesc'] = '输入您的机构博客的网址（例如： http://dearbornschools.org)';
$string['bodybackground'] = '主体背景色';
$string['bodybackground_desc'] = '用于背景的主要颜色。';
$string['brandColour'] = '品牌颜色';
$string['brandColour_desc'] = '您的主品牌颜色';
$string['branddanger'] = '‎品牌风险';
$string['branddanger_desc'] = '风险提示和面板等的品牌颜色';
$string['brandemail'] = '组织 Email';
$string['brandemaildesc'] = '出现在页脚中的组织的电子邮件地址。';
$string['brandinfo'] = '品牌信息';
$string['brandinfo_desc'] = '品牌颜色信息提醒、面板等';
$string['brandorganization'] = '组织名称';
$string['brandorganizationdesc'] = '显示在页脚的组织名称。';
$string['brandphone'] = '组织电话';
$string['brandphonedesc'] = '显示在页脚的电话号码。';
$string['brandprimary'] = '主品牌';
$string['brandprimary_desc'] = '您的主品牌颜色';
$string['brandsuccess'] = '品牌成功';
$string['brandsuccess_desc'] = '成功的提示、赞成的面板、按钮等的品牌颜色';
$string['brandwarning'] = '品牌警告';
$string['brandwarning_desc'] = '用于警告、提示和面板等的品牌颜色';
$string['brandwebsite'] = '组织网站';
$string['brandwebsitedesc'] = '显示在页脚的组织网站。';
$string['breadcrumbbkg'] = 'Breadcrumb（面包屑）背景颜色';
$string['breadcrumbbkg_desc'] = 'Breadcrumb（面包屑）背景颜色。';
$string['cardbkg'] = '内容背景颜色';
$string['cardbkg_desc'] = '课程内容与版块的背景颜色。';
$string['catsicon'] = '类别图标';
$string['catsicon_desc'] = '选择一个图标来表示课程类别。';
$string['choosereadme'] = 'Fordson为默认的Boost主题提供了独特的视觉体验，包括定制功能，如颜色选择器、改进的导航和增强的首页体验。';
$string['collapsibletopics'] = '可折叠主题课程格式';
$string['collapsibletopics_desc'] = '如果您安装了可折叠主题格式( <a href="https://moodle.org/plugins/format_collapsibletopics">format_collapsibletopics</a> )， Fordson主题可以提供一个增强的课程格式视图和特殊的样式，更好地集成了Fordson的整体外观和感觉。特别的关怀和关注已经被开发出来，为所有年龄和技能的用户提供更流畅的用户体验。';
$string['colours_desc'] = '颜色选择器将允许您自定义页面上主要元素的外观和感觉。如果您使用的是其他预设而不是默认设置，您需要删除下面的任何自定义颜色以获得最佳效果，因为这些颜色将覆盖预置的不希望看到的结果。通常，预置将具有默认颜色，您希望在这里自定义它们之前看到这些颜色。';
$string['colours_headingsub'] = '颜色设置';
$string['colours_settings'] = '颜色';
$string['configtitle'] = 'Fordson (福特森)';
$string['contentsettings'] = '内容区';
$string['courseactivities'] = '课程活动';
$string['courseblockpanelbtn'] = '课程板块';
$string['courseblockpanelbtnclose'] = '关闭';
$string['courseboxheight'] = '课程磁贴高度';
$string['courseboxheight_desc'] = '在首页和课程类别中控制课程磁贴的高度。';
$string['courseeditingcog'] = '显示默认的课程设置菜单';
$string['courseeditingcog_desc'] = '如果使用“课程管理面板”，则默认菜单被隐藏。通过选中此选项，您可以显示默认菜单以及教师课程管理面板。如果使用第三方插件使用课程菜单访问设置，则这是理想的选择。';
$string['coursehome'] = '课程主页';
$string['courseinfo'] = '课程描述';
$string['coursemanage'] = '课程设置';
$string['coursemanage_desc'] = '管理您的整个课程';
$string['coursemanagementbutton'] = '课程管理';
$string['coursemanagementinfo'] = '课程管理面板菜单';
$string['coursemanagementinfodesc'] = '福特森（Fordson）提供了一个独特且井井有条的课程管理面板，教师可以从课程中的任何位置访问该面板，以访问其课程管理链接。学生还可以访问“学生课程仪表盘”，其中包括与课程相关的信息。强烈建议您保持开启状态。';
$string['coursemanagementtextbox'] = '课程管理消息';
$string['coursemanagementtextbox_desc'] = '在每个课程页面的课程管理面板中为教师添加一条消息。';
$string['coursemanagementtoggle'] = '显示学生和教师的课程管理面板';
$string['coursemanagementtoggle_desc'] = '这将在教师的井井有条的面板中显示“课程管理”链接，该面板提供了他们管理课程和用户所需的所有链接的仪表盘。它还将为具有成绩、课程完成情况以及课程中其他项目的学生显示课程概览面板。';
$string['coursestaff'] = '课程教师';
$string['coursestyle1'] = '‎磁贴风格 1';
$string['coursestyle10'] = '默认的Moodle课程显示';
$string['coursestyle2'] = '‎磁贴风格 2';
$string['coursestyle3'] = '‎磁贴风格 3';
$string['coursestyle4'] = '‎磁贴风格 4
w/课程概览';
$string['coursestyle5'] = '水平风格 1';
$string['coursestyle6'] = '水平图像背景 完整细节';
$string['coursestyle7'] = '水平图像背景 只有标题和教师';
$string['coursestyle8'] = '水平两列';
$string['coursestyle9'] = '企业培训-最小的完成进度条';
$string['coursetileinfo'] = '课程显示选项';
$string['coursetileinfodesc'] = '这些设置使您可以自定义课程在首页以及课程类别的显示方式。';
$string['coursetilestyle'] = '课程磁贴显示';
$string['coursetilestyle_desc'] = '当您查看课程类别时，您可以选择以下风格来显示课程。<a href="https://goo.gl/fMXzSo" target="_new">Fordson 的说明</a>';
$string['createinfo'] = '专门的课程创建按钮';
$string['createinfodesc'] = '当用户可以创建新课程时，这个按钮就会出现在首页上。那些站点级别的课程创建角色将看到这个按钮。';
$string['currentinparentheses'] = '(当前的)';
$string['customloginheading'] = '自定义登录页面';
$string['customlogininfo'] = '自定义登录页面设置';
$string['customlogininfo_desc'] = '这允许您创建自定义登录页面。主题中的其他设置将显示在登录页面上，包括以下内容:<br> <b>*站点管理>安全>站点策略>强制用户登录=确保选中此选项，用户将被带到您的自定义登录页面。<br> *站点管理>外观>图标>图标=在这里上传一个图片，它将出现在登录表单的上方。<br> *Fordson>自定义图像设置>默认登录图像可用于更改登录页面的背景图像。<br> * Fordson > 内容区 >首页提示可用于在页面顶部提供通知。</ b>';
$string['dashactivityoverview'] = '活动概览';
$string['displaybottom'] = '在页面底部显示';
$string['displaymycourses'] = '显示加入的课程';
$string['displaymycoursesdesc'] = '在顶部导航条显示用户加入的课程';
$string['displaythiscourse'] = '显示课程菜单';
$string['displaythiscoursedesc'] = '在顶部导航条为用户显示跳转到课程小节的菜单。这包含以前在导航抽屉中找到的菜单项。';
$string['displaytop'] = '在页面顶部显示';
$string['drawerbkg'] = '侧面导航抽屉背景颜色';
$string['drawerbkg_desc'] = '页面左侧菜单的侧面导航抽屉背景颜色。';
$string['easyenrollmentintegration'] = '简易选课插件';
$string['easyenrollmentintegration_desc'] = '简易选课插件 (<a href=" https://moodle.org/plugins/_" > Easy Enrollment plugin </a>)允许学生直接从Moodle主页选课。该选课插件使用6位数字代码或带有网络摄像头支持的自动生成的二维码来选课。学生输入代码或扫描二维码，然后立即被选入课程中的预定课程或课程组。这个插件自动激活，一旦您安装简易选课插件并在站点管理里激活它。只有在插件安装并正确配置之后，它才会被激活。';
$string['editoff'] = '关闭编辑';
$string['editon'] = '打开编辑';
$string['enablecategoryicon'] = '类别显示图标';
$string['enablecategoryicon_desc'] = '当勾选此项时，将以图标的形式显示课程类别';
$string['enhancedmydashboard'] = '增强的我的个人主页';
$string['enhancedmydashboard_desc'] = '开启它将增强我的个人主页页面，包括所有的fordson特性，比如简易选课表单，版块滑块，图标导航条，自定义主页文本，幻灯片，和更多。';
$string['enrollcoursecard'] = '访问';
$string['facebook'] = 'Facebook 网址';
$string['facebookdesc'] = '输入您的Facebook页面的URL。 (i.e http://www.facebook.com/)';
$string['favicon'] = '网站图标';
$string['favicon_desc'] = '把Fordson的网站图标换掉。带有透明背景、32px高度的图片效果最好。允许的类型：PNG, JPG, ICO';
$string['feature1info'] = '特性一';
$string['feature2info'] = '特性二';
$string['feature3info'] = '特性三';
$string['featureimage'] = '特性图片';
$string['featureimage_desc'] = '这张图片将出现在特性文本旁边的一行中。';
$string['featureinfo_desc'] = '一个特性由图像和文本组成，它们将出现在自定义登录页面的一行中。必须同时添加图像和文本才能显示该特性。';
$string['featuretext'] = '特性文本';
$string['featuretext_desc'] = '该文本将会出现在特性图片旁边的一行中。使用Heading4在文本框中生成一个特别的标题。在Atto编辑器中，H4是中号标题。';
$string['flickr'] = 'Flickr 网址';
$string['flickrdesc'] = '输入您的Flickr 页网址。 (i.e http://www.flickr.com/)';
$string['footerbkg'] = '页脚背景颜色';
$string['footerbkg_desc'] = '页面底部的页脚背颜色。';
$string['footerdesc'] = '下面的项目允许您在主题页脚添加品牌信息。';
$string['footerheading'] = '页脚';
$string['footerheadingsocial'] = '社交软件图标';
$string['footerheadingsub'] = '自定义首页的页脚';
$string['footnote'] = '脚注';
$string['footnotedesc'] = '主页脚的脚注内容编辑器';
$string['fploginform'] = '登录表单颜色';
$string['fploginform_desc'] = '自定义主页的登录表单背景颜色。';
$string['fpsignup'] = '登录';
$string['fptextbox'] = '已验证用户的首页文本框';
$string['fptextbox_desc'] = '一旦用户通过身份验证，此文本框就会出现在首页上。它是放置欢迎消息并为学习者提供指导的理想选择。';
$string['fptextboxlogout'] = '访客的首页文本框';
$string['fptextboxlogout_desc'] = '此文本框出现在访客的首页上，是放置欢迎消息或链接到登录页面的理想选择。';
$string['frontpagemycoursessorting'] = '我的课程按最后访问顺序排序';
$string['frontpagemycoursessorting_desc'] = '当勾选此特性将按用户最后访问的时间排序显示我的课程(已加入课程)。这将覆盖导航下的“对我的课程排序”设置。如果未选中，则主页中我的课程将正常显示。这包括我的课程在页面顶部的下拉菜单中的显示，以及我加入的课程在网站主页上的显示。这不会影响个人主页或个人主页版块。';
$string['generalcontentinfo'] = '常规内容显示设置';
$string['generalcontentinfodesc'] = '以下选项可帮助您自定义内容的显示方式，并打开Fordson的其他特性。';
$string['generalsettings'] = '常规设置';
$string['googleplus'] = 'Google+ 网址';
$string['googleplusdesc'] = '输入您的谷歌+配置文件的URL。 (i.e https://google.com/)';
$string['gutterwidth'] = '内容填充';
$string['gutterwidth_desc'] = '此设置控制在主内容的左右两边使用多少间距。';
$string['headerdefaultimage'] = '默认页眉图像';
$string['headerdefaultimage_desc'] = '课程页眉和非课程页面的默认图像';
$string['headerimagepadding'] = '页眉图像高度';
$string['headerimagepadding_desc'] = '控制课程页眉图像的内边距和高度。';
$string['headerlogo'] = '页眉徽标';
$string['headerlogo_desc'] = '该徽标将显示在页面顶部页眉区域中，它使用自适应图像缩放。';
$string['homemyclasses'] = '班级主页';
$string['homemycomp'] = '能力主页';
$string['homemycourses'] = '课程主页';
$string['homemycred'] = '证书主页';
$string['homemylectures'] = '讲座主页';
$string['homemylessons'] = '课堂主页';
$string['homemymodules'] = '模块主页';
$string['homemyplans'] = '计划主页';
$string['homemyprofessionaldevelopment'] = '专业发展主页';
$string['homemyprograms'] = '程序主页';
$string['homemytraining'] = '训练主页';
$string['homemyunits'] = '单元主页';
$string['iconnavheading'] = '图标导航';
$string['iconnavheadingsub'] = '在首页上创建带有图标的按钮。链接可以到任何地方。';
$string['iconwidth'] = '首页图标宽度';
$string['iconwidth_desc'] = '首页上图标导航栏中8个图标的宽度。';
$string['iconwidthinfo'] = '图标按钮的宽度设置';
$string['iconwidthinfodesc'] = '选择一个宽度，使您的链接文本适合图标导航按钮。';
$string['ilearnsecurebrowser'] = '此测验由iLearn安全浏览器保护（必须使用使用iLearn应用的Chromebook尝试此测验）';
$string['imagesettings'] = '自定义图像设置';
$string['instagram'] = 'nstagram 网址';
$string['instagramdesc'] = '输入您的Instagram页面的URL。(i.e http://instagram.com/)';
$string['integrationinfo'] = '插件集成';
$string['integrationinfo_desc'] = 'Fordson可以激活增强特性，并更好地与某些插件集成。下面的设置将允许您使用默认的插件行为或开启Fordson开发人员已实现的高级特性。';
$string['integrationoff'] = '关闭集成';
$string['integrationon'] = '开启集成';
$string['jitsibuttontext'] = '自动Jitsi会议页眉按钮';
$string['jitsibuttontextdesc'] = '为将添加到每个Moodle课程顶部的按钮添加文本。此按钮会将用户带到Jitsi会议室，该会议室由课程名称和课程ID号构成URL。您必须具有Jitsi Web会议服务器。';
$string['jitsibuttonurl'] = 'Jitsi服务器网址';
$string['jitsibuttonurldesc'] = '公共服务器示例：https://meet.jit.si <br>不添加一个后面的反斜杠<br>此网址将用于自动添加到每个Moodle课程“页眉”区域中的按钮。我们强烈建议您设置自己的Jitsi服务器并强制登录到Jitsi会议室。';
$string['layoutinfo'] = '布局设置';
$string['layoutinfodesc'] = '通过选择一个外观设计来控制页面布局。';
$string['learningcontentpadding'] = '学习内容间距';
$string['learningcontentpadding_desc'] = '这控制页面顶部和主课程内容之间的间距。通常，您希望它小于页眉图像的高度。';
$string['linkedin'] = 'LinkedIn 网址';
$string['linkedindesc'] = '输入您的LinkedIn个人资料的URL。(i.e http://www.linkedin.com/)';
$string['loginimage'] = '默认登录图像';
$string['loginimage_desc'] = '登录页面的背景图片';
$string['loginnavicon1'] = '图标 1';
$string['loginnavicon2'] = '图标 2';
$string['loginnavicon3'] = '图标 3';
$string['loginnavicon4'] = '图标 4';
$string['loginnavicontext'] = '图标文本';
$string['loginnavicontextdesc'] = '将出现在图标下面的文本。为了达到最好的效果，尽量简短。';
$string['loginnavicontitletext'] = '图标标题';
$string['loginnavicontitletextdesc'] = '显示在图标下面作为标题的文本。';
$string['logintopimage'] = '登录页面的头图图片';
$string['logintopimage_desc'] = '此图片显示在登录框右侧的登录页面上。最好是带有透明背景的徽标或头图。';
$string['marketboxbuttoncolor'] = '营销盒按钮颜色';
$string['marketboxbuttoncolor_desc'] = '营销盒按钮背景色。';
$string['marketboxcolor'] = '营销盒背景色';
$string['marketboxcolor_desc'] = '营销盒的背景色。';
$string['marketboxcontentcolor'] = '营销盒内容背景色';
$string['marketboxcontentcolor_desc'] = '营销盒内容的背景颜色。这是文本出现在营销点的位置，可以不同于盒子的背景颜色来吸引人们对文字的注意。';
$string['marketing1'] = '营销点 1';
$string['marketing2'] = '营销点 2';
$string['marketing3'] = '营销点 3';
$string['marketing4'] = '营销点 4';
$string['marketing5'] = '营销点 5';
$string['marketing6'] = '营销点 6';
$string['marketing7'] = '营销点 7';
$string['marketing8'] = '营销点 8';
$string['marketing9'] = '营销点 9';
$string['marketingbuttontext'] = '链接文本';
$string['marketingbuttontextdesc'] = '显示在按钮上的文本。';
$string['marketingbuttonurl'] = '链接网址';
$string['marketingbuttonurldesc'] = '按钮将指向的网址。';
$string['marketingcontent'] = '内容';
$string['marketingcontentdesc'] = '要显示在营销盒子中的内容。保持简短和亲切。';
$string['marketingdesc'] = '此主题提供了在幻灯片下方启用三个“营销”或“广告”点的选项。这些使您可以轻松地向用户标识核心信息并提供直接链接。';
$string['marketingheading'] = '营销磁贴';
$string['marketingheadingsub'] = '在首页上的三个位置添加信息和链接';
$string['marketingheight'] = '营销图片高度';
$string['marketingheightdesc'] = '如果您想在营销盒中显示图像，您可以在这里指定它们的高度。';
$string['marketingicon'] = '链接图标';
$string['marketingicondesc'] = '您希望在营销网址按钮中使用的图标的名称。列表是<a href="https://fontawesome.com/v4.7.0/icons/" target="_new">这儿</a>。输入“fa-”后面的单词，例如:“star”。';
$string['marketingimage'] = '图像';
$string['marketingimage_desc'] = '这提供了在营销点显示图像的选项';
$string['marketinginfodesc'] = '输入您的营销点的设置。您必须包括标题，以便营销点显示出来。标题将激活各个营销点。';
$string['marketingstyle'] = '营销磁贴样式选择器';
$string['marketingstyle1'] = '顶部条突出';
$string['marketingstyle2'] = '便利贴';
$string['marketingstyle3'] = '简单';
$string['marketingstyle4'] = '盒装阴影';
$string['marketingstyle_desc'] = '从以下营销样式中选择。这些将改变站点主页上营销盒的外观和样式。';
$string['marketingtitle'] = '标题';
$string['marketingtitledesc'] = '这个营销点显示的标题。您必须包括一个标题，以便显示营销磁贴。';
$string['marketingurltarget'] = '链接目标';
$string['marketingurltargetdesc'] = '选择如何打开链接';
$string['marketingurltargetnew'] = '新页';
$string['marketingurltargetparent'] = '父框架';
$string['marketingurltargetself'] = '当前页';
$string['markettextbg'] = '营销磁贴文字背景';
$string['markettextbg_desc'] = '营销磁贴文字区域的背景颜色。';
$string['menusettings'] = '菜单设置';
$string['myclasses'] = '我的班级';
$string['mycomp'] = '我的能力';
$string['mycourses'] = '我的课程';
$string['mycoursesinfo'] = '动态的已加入课程列表和课程导航菜单';
$string['mycoursesinfodesc'] = '在顶部导航栏中向用户显示已加入课程的动态列表。这也将控制每个课程的课程导航下拉菜单。';
$string['mycoursetitle'] = '用词';
$string['mycoursetitledesc'] = '在下拉菜单中改变“我的课程”链接的用词';
$string['mycred'] = '我的证书';
$string['mygradestext'] = '我的成绩';
$string['mylectures'] = '我的讲座';
$string['mylessons'] = '我的课堂';
$string['mymodules'] = '我的模块';
$string['myplans'] = '我的计划';
$string['myprofessionaldevelopment'] = '我的专业发展';
$string['myprograms'] = '我的程序';
$string['myprogresspercentage'] = '% 完成';
$string['myprogresstext'] = '我的进展';
$string['mytraining'] = '我的培训';
$string['myunits'] = '我的单元';
$string['navbarcolorswitch'] = '导航条颜色开关';
$string['navbarcolorswitch_desc'] = '该特性根据用户角色改变导航条的颜色。学生看到一种颜色，教师看到另一种颜色。当教师改变角色，在帮助区分学生视图和教师视图时，这很有用。';
$string['navbarcolorswitch_off'] = '不根据角色改变导航条颜色。';
$string['navbarcolorswitch_on'] = '根据角色改变导航条颜色。';
$string['navdrawerbtn'] = '导航';
$string['navicon'] = '图标';
$string['navicon1'] = '主页图标一';
$string['navicon2'] = '主页图标二';
$string['navicon3'] = '主页图标三';
$string['navicon4'] = '主页图标四';
$string['navicon5'] = '主页图标五';
$string['navicon6'] = '主页图标六';
$string['navicon7'] = '主页图标七';
$string['navicon8'] = '主页图标八';
$string['naviconbutton1textdefault'] = '仪表盘';
$string['naviconbutton2textdefault'] = '日程管理';
$string['naviconbutton3textdefault'] = '勋章';
$string['naviconbutton4textdefault'] = '所有课程';
$string['naviconbuttoncreatetextdefault'] = '创建一门课程';
$string['naviconbuttontext'] = '链接文本';
$string['naviconbuttontextdesc'] = '出现在图标下面的文本。';
$string['naviconbuttonurl'] = '链接网址';
$string['naviconbuttonurldesc'] = '按钮将指向的网址。您可以链接到任何地方，包括外部网站，只要输入正确的网址。如果您的Moodle站点位于子目录中，则默认网址将不起作用。请调整网址以反映子目录。例如，如果“moodle”是您的子目录文件夹，那么网址需要更改为/moodle/my/';
$string['navicondesc'] = '您希望使用的图标的名称。列表是<a href="https://fontawesome.com/v4.7.0/icons/" target="_new">这儿</a>。输入“fa-”后面的单词，例如:“star”。';
$string['naviconslidedesc'] = '推荐的图标文本：箭头-圆圈-向下。或者从列表中选择<a href="https://fontawesome.com/v4.7.0/icons/" target="_new">这儿</a>。输入“fa-”后面的单词，例如:“star”。';
$string['noenrolments'] = '您目前没有选课';
$string['nomycourses'] = '您没有加入任何课程。';
$string['pagelayout'] = '布局选择器';
$string['pagelayout1'] = '默认Boost布局';
$string['pagelayout2'] = '全宽/顶部页眉图像';
$string['pagelayout3'] = '内容居中/顶部页眉图像重叠';
$string['pagelayout4'] = '内容居中/页眉图像全屏';
$string['pagelayout5'] = '默认Boost布局/页眉图像在课程标题盒子里';
$string['pagelayout_desc'] = '从以下布局中选择。某些页面布局需要在“预设的调整”页面上进行其他调整。请务必注意：学习内容间距，页眉图像高度和内容内边距，因为它们将帮助调整页眉图像在主学习内容左右的位置和内边距。<a href="https://goo.gl/fMXzSo" target="_new">Fordson的说明</a>';
$string['pinterest'] = 'Pinterest 网址';
$string['pinterestdesc'] = '输入您的Pinterest页面的URL。(i.e http://pinterest.com/)';
$string['pluginname'] = 'Fordson（福特森）';
$string['preset'] = '主题预设';
$string['preset_desc'] = '选择一个预设以大致改变主题的外观。 <a href="https://goo.gl/fMXzSo" target="_new">Fordson的说明</a>';
$string['presetadjustmentsettings'] = '预设调整';
$string['presetfiles'] = '额外的主题预设文件';
$string['presetfiles_desc'] = '预设文件可用于显著改变主题的外观。有关创建和共享您自己的预设文件的信息，请参见https://docs.moodle.org/dev/Boost_Presets。';
$string['presets_settings'] = '预设';
$string['privacy:metadata'] = 'Fordson主题不存储任何个人用户数据。';
$string['qbank'] = '题库';
$string['qbank_desc'] = '创建和组织测验题';
$string['rawscss'] = '原生SCSS';
$string['rawscss_desc'] = '使用此字段提供的SCSS代码将插入样式表末尾。';
$string['rawscsspre'] = '原生初始SCSS';
$string['rawscsspre_desc'] = '在此字段中，您可以提供初始化的SCSS代码，它将在其他所有内容之前插入。大多数时候，您将使用此设置来定义变量。';
$string['region-fp-a'] = '列 A';
$string['region-fp-b'] = '列 B';
$string['region-fp-c'] = '列 C';
$string['region-side-pre'] = '右';
$string['section_mods'] = '模块：';
$string['sectionlayout'] = '小节样式选择器';
$string['sectionlayout1'] = 'Boost 默认';
$string['sectionlayout2'] = '粗体笔记卡片';
$string['sectionlayout3'] = '文件夹选项卡';
$string['sectionlayout4'] = '夹纸记录板夹';
$string['sectionlayout5'] = '简单的盒子';
$string['sectionlayout6'] = '突出显示小节标题';
$string['sectionlayout7'] = '‎大学学习者‎';
$string['sectionlayout8'] = '公司学习者';
$string['sectionlayout_desc'] = '从以下主题/星期小节样式中选择。<a href="https://goo.gl/fMXzSo" target="_new">Instructions for Fordson</a>';
$string['setting_navdrawersettings'] = '导航抽屉设置';
$string['setting_navdrawersettings_desc'] = '启用Boost导航抽屉特性。 Fordson不需要导航抽屉进行导航。我们用跳转到小节的下拉菜单替换了它。您可以重新启用下面的导航抽屉。';
$string['showactivitynav'] = '显示活动导航';
$string['showactivitynav_desc'] = '取消此选项可以关闭活动页面底部的活动导航。';
$string['showblockregions'] = '显示额外的首页版块区域';
$string['showblockregions_desc'] = '在网站首页上再打开三个版块区域。它们显示在图标导航条的正下方。';
$string['showcourseadminstudents'] = '显示学生课程管理齿轮图标';
$string['showcourseadminstudents_desc'] = '这将向学生显示课程设置。如果您要允许他们取消选课，则需要这样做。';
$string['showcourseheaderimage'] = '显示课程图片';
$string['showcourseheaderimage_desc'] = '允许教师通过将图片文件上传到课程设置中来定制课程页眉图像。';
$string['showcustomlogin'] = '开启自定义登录';
$string['showcustomlogin_desc'] = '您必须开启此选项才能激活下面的自定义设置。';
$string['showloginform'] = '显示登录窗口';
$string['showloginform_desc'] = '取消此选项可在首页上为退出用户隐藏自定义登录窗口。';
$string['shownavclosed'] = '导航抽屉默认关闭';
$string['shownavclosed_desc'] = '默认情况下，在每个页面上为所有用户显示折叠的导航抽屉。';
$string['shownavdrawer'] = '显示导航抽屉';
$string['shownavdrawer_desc'] = 'Fordson通过使用一个下拉菜单进行课程内导航，消除了导航抽屉的需要。如果您必须使用导航抽屉，您可以选中这个框来重新启用它。';
$string['showonlygroupteachers'] = '只显示同组教师';
$string['showonlygroupteachers_desc'] = '启用后，“学生课程管理面板”上只会显示与该学生同组的教师。';
$string['showslideshow'] = '激活幻灯片';
$string['showslideshow_desc'] = '选中此选项可打开幻灯片特性。';
$string['showstudentcompletion'] = '显示学生学习进度';
$string['showstudentcompletion_desc'] = '在学生仪表盘面板显示学生学习进度。即使勾选了这个，课程也必须开启课程进度才能显示。';
$string['showstudentgrades'] = '显示学生成绩';
$string['showstudentgrades_desc'] = '在学生仪表盘面板显示学生成绩单链接。即使这个选中了，课程也必须开启显示学生成绩才能显示。';
$string['siteadminquicklink'] = '站点管理';
$string['skype'] = 'Skype帐户';
$string['skypedesc'] = '输入您的组织的Skype用户名';
$string['slide1info'] = '幻灯片1';
$string['slide1infodesc'] = '幻灯片1细节。';
$string['slide2info'] = '幻灯片2';
$string['slide2infodesc'] = '幻灯片2细节';
$string['slide3info'] = '幻灯片3';
$string['slide3infodesc'] = '幻灯片3细节';
$string['slidecontent'] = '幻灯片描述';
$string['slidecontent_desc'] = '为这张幻灯片添加一个描述。';
$string['slideimage'] = '幻灯片图片';
$string['slideimage_desc'] = '为这张幻灯片添加背景图片。';
$string['sliderinfo'] = '专用滑动图标按钮';
$string['sliderinfodesc'] = '这个按钮将显示/隐藏一个从图标导航条滑下的特殊文本框。这是特色课程、提供帮助，或列出员工培训需求的理想方案。';
$string['slideshowheight'] = '幻灯片高度';
$string['slideshowheight_desc'] = '在“站点首页/个人主页”页面上调整幻灯片的高度。在“自定义登录”页面上将忽略此设置。在“自定义登录页面”上，幻灯片的高度取决于页面的大小和宽度。';
$string['slideshowpages'] = '幻灯片页面';
$string['slideshowpages0'] = '只显示在自定义登录页面上';
$string['slideshowpages1'] = '只显示在站点首页和个人主页上';
$string['slideshowpages2'] = '每个地方显示';
$string['slideshowpages_desc'] = '确定幻灯片应显示在哪些主页上。如果在自定义登录页面上使用幻灯片，建议仅上传图像，而不使用下面的幻灯片文本选项。注意：幻灯片不会出现在移动设备上。';
$string['slideshowsettings'] = '幻灯片';
$string['slideshowspacer'] = '自定义登录页面上的幻灯片间隔';
$string['slideshowspacer_desc'] = '在自定义登录页上，此设置用于在登录表单下方添加分隔，以防您将文本放入幻灯片中。';
$string['slidetextbox'] = '滑动的文本框';
$string['slidetextbox_desc'] = '当按下“滑动”按钮时，将显示此文本框内容。';
$string['slidetitle'] = '幻灯片标题';
$string['slidetitle_desc'] = '输入此幻灯片的标题。';
$string['sociallink'] = '自定义社交应用链接';
$string['sociallinkdesc'] = '输入您的自定义社交媒体链接。 (例如：http://dearbornschools.org)';
$string['sociallinkicon'] = '链接图标';
$string['sociallinkicondesc'] = '输入您的链接图标的图标名称<br />完整的图标列表可以在以下地址找到https://fontawesome.com/v4.7.0/icons/';
$string['socialnetworks'] = '社交网络';
$string['studentdashboardtextbox'] = '学生仪表盘消息';
$string['studentdashboardtextbox_desc'] = '在每个课程页面的学生仪表盘面板中为学生添加一条消息。';
$string['studentdashbutton'] = '课程仪表盘';
$string['textcontentinfo'] = '自定义内容';
$string['textcontentinfodesc'] = '使用下面的文本框为用户添加定制的信息。';
$string['thiscourse'] = '这门课程';
$string['thismyclasses'] = '这个班级';
$string['thismycomp'] = '这个能力';
$string['thismycourses'] = '这门课程';
$string['thismycred'] = '这个证书';
$string['thismylectures'] = '这个讲座';
$string['thismylessons'] = '这堂课';
$string['thismymodules'] = '这个模块';
$string['thismyplans'] = '这个计划';
$string['thismyprofessionaldevelopment'] = '这个专业发展';
$string['thismyprograms'] = '这个程序';
$string['thismytraining'] = '这个培训';
$string['thismyunits'] = '这个单元';
$string['titletooltip'] = '课程标题提示';
$string['titletooltip_desc'] = '如果使用“修剪课程标题”，则可以使用工具提示，这些提示将在工具提示中显示整个课程标题。选中此框以打开工具提示。';
$string['togglemarketing'] = '营销磁贴位置';
$string['togglemarketing_desc'] = '确定营销磁贴在首页上的位置。';
$string['topnavbarbg'] = '顶部导航导航条默认';
$string['topnavbarbg_desc'] = '顶部导航条内容的背景颜色。';
$string['topnavbarteacherbg'] = '教师角色顶部导航导航条';
$string['topnavbarteacherbg_desc'] = '当用户是教师时，顶部导航条的内容背景颜色。此特性必须在菜单设置中开启。请查看导航条颜色开关设置。';
$string['trimsummary'] = '修剪课程简介';
$string['trimsummary_desc'] = '输入一个数字来修剪课程简介的长度。这个数字表示将显示的字符数。';
$string['trimtitle'] = '修剪课程标题';
$string['trimtitle_desc'] = '输入一个数字来修剪课程标题的长度。这个数字表示将显示的字符数。';
$string['tumblr'] = 'Tumblr 网址';
$string['tumblrdesc'] = '输入Tumblr的网址。(i.e http://www.tumblr.com)';
$string['twitter'] = 'Twitter 网址';
$string['twitterdesc'] = '输入您的Twitter feed 的URL。 (i.e http://www.twitter.com/)';
$string['userlinks'] = '用户链接';
$string['userlinks_desc'] = '管理您的学生';
$string['viewfcfmodules'] = '查看活动和资源';
$string['viewsectionmodules'] = '查看小节模块';
$string['vimeo'] = 'Vimeo 网址';
$string['vimeodesc'] = '输入您的Vimeo channel网址。 (i.e http://vimeo.com/)';
$string['vk'] = 'VKontakte 网址';
$string['vkdesc'] = '输入您的Vkontakte页面的URL。 (i.e http://www.vk.com/)';
$string['website'] = '网站网址';
$string['websitedesc'] = '输入您自己网站的网址。 (i.e http://dearbornschools.org)';
$string['youtube'] = 'YouTube 网址';
$string['youtubedesc'] = '输入您的YouTube channel的URL。(i.e http://www.youtube.com/)';
