<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'da', version '4.1'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Tilføj aftale';
$string['addingappointments'] = 'Tilføj aftaler';
$string['addremoveattendees'] = 'Tilføj/fjern deltagere';
$string['addsession'] = 'Tilføj session';
$string['addtimeframe'] = 'Tilføj tidsramme';
$string['advanced'] = 'Avanceret';
$string['allowcancellations'] = 'Tillad aflysning';
$string['allowcancellations_help'] = 'Hvis dette er markeret, vil sessionsdeltagere kunne afmelde sig.';
$string['allowcancellationsdefault'] = 'Tillad aflysning (standard)';
$string['allowcancellationsdefault_help'] = 'Hvis dette er markeret, vil standardindstillingen, når der oprettes nye sessioner for denne aktivitet, være at tillade afmeldinger.';
$string['allowwaitlist'] = 'Tillad venteliste';
$string['allowwaitlist_help'] = 'Når "Tillad venteliste" er markeret, vil kursister kunne tilmelde sig en aftalesession, selvom den allerede er fuld.<br />

Når en kursist tilmelder sig en session, der allerede er fuld, vil de modtage en e-mail, der informerer dem om, at de er blevet sat på venteliste til sessionen og vil blive underrettet, når en booking bliver ledig.';
$string['alreadysignedup'] = 'Du er allerede tilmeldt denne aftaleaktivitet.';
$string['appointment'] = 'Aftale';
$string['appointment:addattendees'] = 'Tilføj deltagere til en aftalesession';
$string['appointment:addinstance'] = 'Tilføj forekomst';
$string['appointment:configurecancellation'] = 'Tillad konfiguration af afmeldinger, når du tilføjer/redigerer en aftaleaktivitet.';
$string['appointment:editsessions'] = 'Tilføj, rediger, kopiér og slet aftalesessioner.';
$string['appointment:managecustomfields'] = 'Administrer brugerdefinerede felter for aftalesessioner.';
$string['appointment:overbook'] = 'Tilmeld dig fulde sessioner, der ikke har venteliste aktiveret.';
$string['appointment:removeattendees'] = 'Fjern deltagere fra en aftalesession.';
$string['appointment:signup'] = 'Tilmeld dig en session.';
$string['appointment:takeattendance'] = 'Tag fremmøde.';
$string['appointment:view'] = 'Se aftaleaktiviteter og sessioner.';
$string['appointment:viewattendees'] = 'Se fremmødeliste og deltagere.';
$string['appointment:viewcancellations'] = 'Se afmeldinger.';
$string['appointmentactivity'] = 'Aftaleaktivitet';
$string['appointmentcustomfields'] = 'Brugerdefinerede aftalefelter';
$string['appointmentname'] = 'Aftalenavn';
$string['appointments'] = 'Aftaler';
$string['appointmentsession'] = 'Aftalesession';
$string['appointmentsessiondates'] = 'Aftalesessionsdatoer';
$string['appointmentsessions'] = 'Aftalesessioner';
$string['appointmentsettings'] = 'Aftaleindstillinger';
$string['approvalreqd'] = 'Godkendelse kræves';
$string['approvalreqd_help'] = 'Når "Godkendelse kræves" er markeret, skal en kursist have godkendelse fra sin leder for at få tilladelse til at deltage i en aftalesession.';
$string['approve'] = 'Godkend';
$string['attendance'] = 'Fremmøde';
$string['attendanceinstructions'] = 'Vælg de brugere, der deltog i sessionen:';
$string['attendedsession'] = 'Deltog i sessionen';
$string['attendees'] = 'Deltagere';
$string['attendeestablesummary'] = 'Personer, der planlægger at deltage i eller har deltaget i denne session.';
$string['availableseats'] = '{$a} pladser ledige';
$string['book'] = 'Book';
$string['bookedat'] = '<strong>Booked:</strong> {$a}';
$string['bookedvscapacity'] = 'Booket / Kapacitet';
$string['bookingcancelled'] = 'Din booking er blevet aflyst.';
$string['bookingcompleted'] = 'Din booking er blevet gennemført.';
$string['bookingfull'] = 'Fuld';
$string['bookingopen'] = 'Åben';
$string['break'] = 'Pause';
$string['break_help'] = 'Denne indstilling definerer pausen mellem sessioner. Indstillingen 0 betyder, at der ikke er behov for pause.';
$string['calendaroptions'] = 'Kalenderindstillinger';
$string['cancel'] = 'Slet';
$string['cancelbooking'] = 'Afbestil booking';
$string['cancellationinstrmngr'] = '# Besked til lederen';
$string['cancellationinstrmngr_help'] = 'Når **Send besked til lederen** er markeret, sendes teksten i feltet **Besked til lederen** til en kursists leder for at informere om, at de har afbestilt en aftalebooking.';
$string['cancellationmessage'] = 'Afbestillingsbesked';
$string['cancellationmessage_help'] = 'Denne besked sendes, når brugere afbestiller deres booking til en session.';
$string['cancellations'] = 'Afbestillinger';
$string['cancellationstablesummary'] = 'Liste over personer, der har afbestilt deres tilmelding til en session.';
$string['cancelreason'] = 'Årsag til afbestilling';
$string['cannotapproveatcapacity'] = 'Du kan ikke godkende flere deltagere, da denne session er fuld.';
$string['cannotsignupsessioninprogress'] = 'Du kan ikke tilmelde dig, denne session er i gang.';
$string['cannotsignupsessionover'] = 'Du kan ikke tilmelde dig, denne session er overstået.';
$string['capacity'] = 'Kapacitet';
$string['capacity_help'] = '**Kapacitet** er antallet af pladser, der er tilgængelige i en session.

Når en aftalesession når sin kapacitet, vises sessionsoplysningerne ikke på kursets side. Oplysningerne vises gråtonet på siden \'Se alle sessioner\', og kursisten kan ikke tilmelde sig sessionen.
&nbsp;';
$string['closed'] = 'Lukket';
$string['completionattended_help'] = 'Hvis aktiveret, vil aktiviteten blive betragtet som fuldført, hvis kursistens bookingfremmøde er markeret som "Fuldt deltaget" eller "Delvist deltaget".';
$string['completionbooked'] = 'Kursisten skal booke en aftale for at fuldføre denne aktivitet.';
$string['completionbooked_help'] = 'Hvis aktiveret, vil aktiviteten blive betragtet som fuldført, hvis kursistens status er "Booket", "Fuldt deltaget" eller "Delvist deltaget". Hvis kursisten har afbestilt, er på venteliste, eller deres fremmøde er markeret som "Udeblevet", vil aktiviteten ikke blive betragtet som fuldført.';
$string['completiondetail:attended'] = 'Deltag i en aftale.';
$string['completiondetail:booked'] = 'Book en aftale.';
$string['confirmationinstrmngr'] = '# Besked til lederen';
$string['confirmationinstrmngr_help'] = 'Når "Send besked til lederen" er markeret, sendes teksten i feltet "Besked til lederen" til en leder for at informere om, at en medarbejder har tilmeldt sig en aftalesession.';
$string['confirmationmessage'] = 'Bekræftelsesbesked';
$string['confirmationmessage_help'] = 'Denne besked sendes, når brugere tilmelder sig en session.';
$string['confirmcancelbooking'] = 'Bekræft afbestilling.';
$string['courseresetsessions'] = 'Fjern alle sessioner.';
$string['courseresetsignups'] = 'Fjern alle sessionstilmeldinger.';
$string['crontask'] = 'Vedligeholdelsesjobs for aftaler.';
$string['currentstatus'] = 'Nuværende status';
$string['customisednotifications'] = 'Tilpassede notifikationer.';
$string['date'] = 'Dato';
$string['decidelater'] = 'Bestemt senere';
$string['decline'] = 'Afvis.';
$string['delete'] = 'Slet';
$string['deleteappointmentconfirm'] = 'Er du helt sikker på, at du vil slette denne aftale og alle dens bookinger?';
$string['deletesession'] = 'Slet session';
$string['deletetimeframe'] = 'Slet tidsramme.';
$string['details'] = 'Detaljer';
$string['duplicate'] = 'Dupliker';
$string['duplicateappointment'] = 'Dupliker aftale.';
$string['editingappointment'] = 'Redigerer aftale.';
$string['email:message'] = 'Besked';
$string['email:subject'] = 'Emne.';
$string['emailmanager'] = 'Send besked til lederen.';
$string['emailmanagercancellation'] = '#Send besked til lederen.';
$string['emailmanagercancellation_help'] = 'Når "Send besked til lederen" er markeret, vil der blive sendt en e-mail til kursistens leder for at informere dem om, at aftalebookingen er blevet afbestilt.';
$string['emailmanagerconfirmation'] = '#Send besked til lederen.';
$string['emailmanagerconfirmation_help'] = 'Når "Send besked til lederen" er markeret, vil der blive sendt en bekræftelsesmail til kursistens leder, når kursisten tilmelder sig en aftalesession.';
$string['emailmanagerreminder'] = '#Send besked til lederen.';
$string['emailmanagerreminder_help'] = 'Når "Send besked til lederen" er markeret, vil der blive sendt en påmindelsesbesked til kursistens leder et par dage før startdatoen for aftalesessionen.';
$string['empty'] = 'Tom';
$string['endtime'] = 'Sluttidspunkt.';
$string['entitiysession'] = 'Session';
$string['error:cancellationsnotallowed'] = 'Du har ikke tilladelse til at afbestille denne tilmelding.';
$string['error:canttakeattendanceforunstartedsession'] = 'Kan ikke tage fremmøde for en session, der endnu ikke er startet.';
$string['error:eventoccurred'] = 'Du kan ikke afbestille en begivenhed, der allerede har fundet sted.';
$string['error:invaliduserid'] = 'Ugyldigt bruger-ID.';
$string['error:manageremailaddressmissing'] = 'Du er i øjeblikket ikke tildelt en leder i systemet. Kontakt venligst webstedsadministratoren.';
$string['error:sessionsplitexceeds'] = 'Sessionsdelingstiden overstiger sessionsvarigheden.';
$string['error:sessionstartafterend'] = 'Sessions starttidspunkt er senere end sessionens sluttidspunkt.';
$string['errorcannoteditsessions'] = 'Du har ikke tilladelse til at redigere sessioner.';
$string['errorcannotviewappointment'] = 'Du har ikke tilladelse til at se denne aftale.';
$string['errorcannotviewattendees'] = 'Du har ikke tilladelse til at se deltagere.';
$string['eventaddsession'] = 'Session tilføjet';
$string['eventapproverequests'] = 'Sessionsgodkendelsesanmodninger.';
$string['eventattendancetaken'] = 'Sessionfremmøde registreret.';
$string['eventattendeesviewed'] = 'Sessionsdeltagere set.';
$string['eventcancelbooking'] = 'Sessionsafbestillingsbooking.';
$string['eventcourseappointmentviewed'] = 'Kursusaftaleforekomster set.';
$string['eventcoursemoduleviewed'] = 'Aftalemodulforekomst set.';
$string['eventdeletesession'] = 'Session slettet';
$string['eventsignup'] = 'Sessionstilmelding.';
$string['eventupdatesession'] = 'Session opdateret.';
$string['full'] = 'Datoen er fuldt optaget.';
$string['fullfilter'] = 'Fuld';
$string['goback'] = 'Gå tilbage';
$string['icalendarheading'] = 'iCalendar-vedhæftninger.';
$string['joinwaitlist'] = 'Tilmeld venteliste.';
$string['location'] = 'Lokation';
$string['managecustomfields'] = 'Administrer brugerdefinerede felter.';
$string['modulename'] = 'Aftalebooking.';
$string['modulename_help'] = 'Aftale er et aktivitetsmodul for undervisere til at holde styr på personlige aktiviteter.

Det gør det muligt for underviseren at oprette et bookingsystem for en eller flere personlige eller klassebaserede sessioner, som eleverne kan tilmelde sig.

Dette aktivitetsmodul er velegnet til enten 1-til-1 sessioner eller aktiviteter med flere sessioner, såsom seminarer.

Sessioner kan have flere datoer og tidspunkter inden for en enkelt aftaleaktivitet og kan oprettes i bulk ved hjælp af de tidsrum, der er angivet i konfigurationen.

Aktiviteten giver mulighed for sporing af fremmøde.';
$string['modulename_link'] = 'Appointments';
$string['modulenameplural'] = 'Aftaler';
$string['multipleappointments'] = 'Flere aftaler.';
$string['noactionableunapprovedrequests'] = 'Ingen anmodninger om godkendelse, der kan handles på.';
$string['noremindersneedtobesent'] = 'Ingen påmindelser skal sendes.';
$string['nosignedupusers'] = 'Ingen brugere har tilmeldt sig denne session.';
$string['notset'] = 'Ikke angivet.';
$string['notsignedup'] = 'Du er ikke tilmeldt denne session.';
$string['partiallyfull'] = 'Delvist fuld.';
$string['placeholder:alldates'] = '[alledatoer]';
$string['placeholder:appointmentname'] = '[aftalenavn]';
$string['placeholder:attendeeslink'] = '[deltagerlink]';
$string['placeholder:details'] = '[detaljer]';
$string['placeholder:finishtime'] = '[sluttidspunkt]';
$string['placeholder:firstname'] = '[fornavn]';
$string['placeholder:lastname'] = '[efternavn]';
$string['placeholder:reminderperiod'] = '[påmindelsesperiode]';
$string['placeholder:sessiondate'] = '[dato]';
$string['placeholder:starttime'] = '[starttidspunkt]';
$string['pluginadministration'] = 'Aftaleadministration.';
$string['pluginname'] = 'Aftale';
$string['potentialattendees'] = 'Potentielle deltagere.';
$string['privacy:metadata:appointment_signups'] = 'Brugertilmeldinger til aftalesessioner.';
$string['privacy:metadata:appointment_signups:id'] = 'Tilmeldingens id.';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'Tidspunktet, hvor en påmindelse sidst blev sendt.';
$string['privacy:metadata:appointment_signups:sessionid'] = 'Sessionens id.';
$string['privacy:metadata:appointment_signups_status'] = 'Status for en brugers tilmelding til en session.';
$string['privacy:metadata:appointment_signups_status:grade'] = 'Karakteren tildelt for deltagelse i sessionen.';
$string['privacy:metadata:appointment_signups_status:note'] = 'Gemmer årsagen til en afbestilt session.';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'Tilmeldingens id.';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'Status for tilmeldingen, f.eks. afbestilt, afvist, fuldt_deltaget.';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'Tidspunktet hvor tilmeldingen blev oprettet.';
$string['privacy:metadata:userid'] = 'ID\'et på den bruger, der tilgik aftaleaktiviteten.';
$string['remindermessage'] = 'Påmindelsesbesked.';
$string['remindermessage_help'] = 'Denne besked sendes et par dage før en sessions startdato.';
$string['reminderperiod'] = 'Dage før beskeden sendes.';
$string['reminderperiod_help'] = 'Påmindelsesbeskeden sendes dette antal dage før sessionens start.';
$string['requestmessage'] = 'Anmodningsbesked.';
$string['requestmessage_help'] = 'Når **Godkendelse kræves** er aktiveret, er sektionen **Anmodningsbesked** tilgængelig.

Sektionen **Anmodningsbesked** viser de beskeder, der sendes til kursisten og deres leder vedrørende godkendelsesprocessen for kursisten for at deltage i aftalesessionen.

**Emne:** er emnelinjen, der vises på de e-mails med anmodning om godkendelse, der sendes til lederen og kursisten.

**Besked:** er e-mailteksten, der sendes til kursisten for at informere dem om, at deres anmodning om at deltage i aftalesessionen er blevet sendt til deres leder til godkendelse.

**Besked til lederen:** er e-mailteksten, der sendes til kursistens leder og anmoder om godkendelse til at deltage i aftalesessionen.';
$string['requeststablesummary'] = 'Personer, der anmoder om at deltage i denne session.';
$string['room'] = 'Lokale.';
$string['saveattendance'] = 'Gem fremmøde.';
$string['search:activity'] = 'Aftaleaktiviteter.';
$string['seatsavailable'] = 'Ledige pladser.';
$string['seatsbooked'] = 'Bookede pladser.';
$string['sessionavailability'] = 'Sessions tilgængelighed.';
$string['sessiondatetime'] = 'Sessionsdato/-tidspunkt.';
$string['sessiondescription'] = 'Beskrivelse.';
$string['sessionduration'] = 'Sessionsvarighed.';
$string['sessionfinished'] = 'Færdig.';
$string['sessionfinishtime'] = 'Sessions sluttidspunkt.';
$string['sessioninprogress'] = 'Session i gang.';
$string['sessionisfull'] = 'Denne session er nu fuld. Du bliver nødt til at vælge et andet tidspunkt eller tale med instruktøren.';
$string['sessionnotstarted'] = 'Ikke startet';
$string['sessionrequiresmanagerapproval'] = 'Denne session kræver ledergodkendelse for at booke.';
$string['sessions'] = 'Sessioner';
$string['sessionsdetailstablesummary'] = 'Fuld beskrivelse af den aktuelle session.';
$string['sessionstartdate'] = 'Sessions startdato.';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (tidszone: {$a->timezone})';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime} (tidszone: {$a->timezone})';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Sessions starttidspunkt.';
$string['sessionstatus'] = 'Sessionsstatus.';
$string['setting:defaultcancellationmessagedefault'] = 'Dette er for at informere om, at din booking på følgende aftale er blevet afbestilt:<br><br>
***BOOKING AFBESTILT***<br><br>
Deltager: [firstname] [lastname]<br>
Aftale: [appointmentname]<br><br>
Dato(er):<br>
[alldates]<br><br>
Lokation: [session:location]<br>
Sted: [session:venue]<br>
Lokale: [session:room]';
$string['setting:defaultcancellationsubjectdefault'] = 'Afbestilling af aftalebooking.';
$string['setting:defaultconfirmationmessagedefault'] = 'This is to confirm that you are now booked on the following appointment:<br><br>
Participant:   [firstname] [lastname]<br>
Appointment:   [appointmentname]<br><br>
Date(s):<br>
[alldates]<br><br>
Location:   [session:location]<br>
Venue:   [session:venue]<br>
Room:   [session:room]<br><br>
***Please arrive ten minutes before the appointment starts***<br><br>
To re-schedule or cancel your booking<br>
To re-schedule your booking you need to cancel this booking and then re-book a new session.<br>
To cancel your booking, return to the appointment page, and then select \'Cancel\'.<br><br>
[details]<br><br>
You will receive a reminder [reminderperiod] business days before this appointment.<br><br>';
$string['setting:defaultconfirmationsubjectdefault'] = 'Bekræftelse af aftalebooking: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultremindermessagedefault'] = 'Dette er en påmindelse om, at du er booket til følgende aftale:<br><br>
Deltager: [firstname] [lastname]<br>
Aftale: [appointmentname]<br><br>
Dato(er):<br>
[alldates]<br><br>
Lokation: [session:location]<br>
Sted: [session:venue]<br>
Lokale: [session:room]<br><br>
***Ankom venligst ti minutter før aftalen starter***<br><br>
For at ombooke eller afbestille din booking<br>
For at ombooke din booking skal du afbestille denne booking og derefter booke en ny session.<br>
For at afbestille din booking skal du vende tilbage til aftalesiden og derefter vælge \'Afbestil\'.<br><br>
[details]';
$string['setting:defaultremindersubjectdefault'] = 'Påmindelse om aftalebooking: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestmessagedefault'] = 'Din anmodning om at booke til følgende aftale er blevet sendt til din leder:

Deltager: [firstname] [lastname]
Aftale: [appointmentname]

Dato(er):
[alldates]

Lokation: [session:location]
Sted: [session:venue]
Lokale: [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Anmodning om aftalebooking: [appointmentname], [starttime]-[finishtime]';
$string['setting:defaultupdatemessagedefault'] = 'Dette er for at informere dig om, at aftalen, du har booket eller tilmeldt venteliste til, er blevet ændret:<br><br>
Deltager: [firstname] [lastname]<br>
Aftale: [appointmentname]<br><br>
Dato(er):<br>
[alldates]<br><br>
Lokation: [session:location]<br>
Sted: [session:venue]<br>
Lokale: [session:room]<br><br>
***Bemærk, at dette ikke er en bekræftelse på aftalebooking***<br><br>
For at afbestille din booking eller placering på ventelisten skal du vende tilbage til aftalesiden og derefter vælge \'Afbestil\'.<br><br>
[details]<br><br>';
$string['setting:defaultupdatesubjectdefault'] = 'Aftaleopdatering: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultwaitlistedmessagedefault'] = 'Dette er for at informere dig om, at du er blevet tilføjet til ventelisten for:<br><br>
Aftale: [appointmentname]<br>
Lokation: [session:location]<br>
Deltager: [firstname] [lastname]<br><br>
***Bemærk, at dette ikke er en bekræftelse på aftalebooking***<br><br>
Ved at blive sat på venteliste har du registreret din interesse i denne aftale og vil blive kontaktet direkte, når sessioner bliver tilgængelige.<br><br>
For at fjerne dig selv fra denne venteliste skal du vende tilbage til denne aftale og klikke på Afbestil. Bemærk, at der ikke er nogen e-mailbekræftelse for fjernelse af ventelisten.';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Venteliste rådgivning for [appointmentname]';
$string['setting:oneemailperday'] = 'Send separat e-mail for hver dag i begivenheder, der strækker sig over flere dage.';
$string['setting:oneemailperday_caption'] = 'Separat e-mail for hver dag.';
$string['settings'] = 'Indstillinger.';
$string['shortname'] = '# Kort navn';
$string['shortname_help'] = '**Kort navn** er beskrivelsen af sessionen, der vises i træningskalenderen, når **Vis i kalenderen** er aktiveret.';
$string['showoncalendar'] = 'Kalendervisningsindstillinger.';
$string['showoncalendar_help'] = 'Når **Websted** er valgt, vises aftaleaktivitetssessionerne i webstedets kalender som en global begivenhed. Alle webstedsbrugere vil kunne se disse sessioner.

Når **Kursus** er valgt, vises alle aftaleaktivitetssessionerne i kursuskalenderen og som kursusbegivenhed på webstedsniveaukalenderen og er synlige for alle brugere, der er tilmeldt kurset.

Når **Ingen** er valgt, vises aftaleaktivitetssessionerne kun som brugerbegivenheder i en bekræftet deltagers kalender, forudsat at indstillingen **Vis i brugerens kalender** er valgt.';
$string['sign-ups'] = 'Tilmeldinger.';
$string['signupforthissession'] = 'Tilmeld dig denne aftalesession.';
$string['split'] = 'Automatisk opdeling.';
$string['split_help'] = 'Denne indstilling definerer varigheden af hver session, der oprettes inden for tidsrammen. Indstillingen til 0 deaktiverer indstillingen.';
$string['status'] = 'Status';
$string['status_approved'] = 'Godkendt.';
$string['status_booked'] = 'Booket.';
$string['status_declined'] = 'Afvist.';
$string['status_fully_attended'] = 'Fuldt deltaget.';
$string['status_no_show'] = 'Udeblevet.';
$string['status_partially_attended'] = 'Delvist deltaget.';
$string['status_requested'] = 'Anmodet.';
$string['status_user_cancelled'] = 'Bruger afbestilt.';
$string['status_waitlisted'] = 'På venteliste.';
$string['suppressemail'] = 'Undertryk e-mailnotifikation.';
$string['suppressemail_help'] = 'Brug denne mulighed, hvis du vil tilføje/fjerne brugere fra en aftalesession lydløst. Når denne indstilling er aktiveret, sendes den sædvanlige e-mailbekræftelse ikke til de valgte brugere.';
$string['takeattendance'] = 'Tag fremmøde.';
$string['thirdpartyemailaddress'] = 'Tredjeparts e-mailadresse(r).';
$string['thirdpartyemailaddress_help'] = '**Tredjeparts e-mailadresse(r)** er et valgfrit felt, der bruges til at angive e-mailadressen på en tredjepart (såsom en ekstern instruktør), som derefter vil modtage bekræftelsesmeddelelser, når en bruger tilmelder sig en session.
Når du indtaster **flere e-mailadresser**, skal du adskille hver adresse med et komma. For eksempel: bob@example.com,joe@example.com';
$string['thirdpartywaitlist'] = 'Underret tredjepart om ventelistesessioner.';
$string['thirdpartywaitlist_help'] = 'Når **Underret tredjepart om ventelistesessioner** er valgt, vil tredjeparten(erne) blive underrettet, når en kursist tilmelder sig en ventelistesession. Når **Underret tredjepart om ventelistesessioner** ikke er aktiveret, vil tredjeparten(erne) kun blive underrettet, når en bruger tilmelder sig (eller afbestiller) en planlagt session.';
$string['timecancelled'] = 'Tidspunkt afbestilt.';
$string['timeframes'] = 'Tidsrammer.';
$string['timerequested'] = 'Tidspunkt anmodet.';
$string['timesignedup'] = 'Tidspunkt tilmeldt.';
$string['timestart'] = 'Starttidspunkt.';
$string['unapprovedrequests'] = 'Ikke-godkendte anmodninger.';
$string['unknowndate'] = '(ukendt dato)';
$string['unknowntime'] = '(ukendt tidspunkt)';
$string['updatemessage'] = 'Opdater besked';
$string['updatemessage_help'] = 'Denne besked sendes, når en session ændres.';
$string['usercalentry'] = 'Vis post i brugerens kalender.';
$string['usercalentry_help'] = 'Når denne indstilling er aktiv, tilføjes en brugerbegivenhedspost til kalenderen for en deltager i en aftalesession. Når den er slået fra, forhindrer dette en dubletbegivenhed i at blive vist i en sessionsdeltagers kalender, hvor du har kalendervisningsindstillinger sat til Kursus eller Websted.';
$string['usercancelledon'] = 'Bruger afbestilt den {$a}';
$string['usernotsignedup'] = 'Status: ikke tilmeldt';
$string['usersignedup'] = 'Status: tilmeldt';
$string['usersignedupon'] = 'Bruger tilmeldt den {$a}';
$string['userwillbewaitlisted'] = 'Denne session er i øjeblikket fuld. Ved at klikke på knappen "Tilmeld" vil du blive sat på sessionens venteliste.';
$string['venue'] = 'Sted.';
$string['waitlistedmessage'] = 'Venteliste besked.';
$string['waitlistedmessage_help'] = 'Denne besked sendes, når brugere tilmelder sig en session på ventelisten.';
