<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'board', language 'da', version '4.1'.
 *
 * @package     board
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Cancel'] = 'Annuller';
$string['Ok'] = 'Ok';
$string['addcomment'] = 'Tilføj kommentar';
$string['addrating'] = 'Vurdere opslag';
$string['addrating_all'] = 'af Alle';
$string['addrating_none'] = 'Deaktiveret';
$string['addrating_students'] = 'af Studerende';
$string['addrating_teachers'] = 'af Lærere';
$string['allowyoutube'] = 'Tillad Youtube';
$string['allowyoutube_desc'] = 'Hvis aktiveret, vises knap der kan indlejre youtube-videoer';
$string['aria_addmedia'] = 'Tilføj {type} til opslag {post} fra kolonne {column}';
$string['aria_addmedianew'] = 'Tilføj {type} til nyt opslag fra kolonne {column}';
$string['aria_canceledit'] = 'Annuller redigering af opslag {post} fra kolonne {column}';
$string['aria_cancelnew'] = 'Annuller nyt opslag til kolonne {column}';
$string['aria_choosefileedit'] = 'Vælg fil til opslag {post} fra kolonne {column}';
$string['aria_choosefilenew'] = 'Vælg fil til nyt opslag fra kolonne {column}';
$string['aria_deleteattachment'] = 'Slet vedhæftning på opslag {post} fra kolonne {column}';
$string['aria_deletecolumn'] = 'Slet kolonne {column}';
$string['aria_deletepost'] = 'Slet opslag {post} fra kolonne {column}';
$string['aria_editpost'] = 'Rediger opslag {post}';
$string['aria_movecolumn'] = 'Flyt kolonne {column}';
$string['aria_movepost'] = 'Flyt opslag {post}';
$string['aria_newcolumn'] = 'Tilføj ny kolonne';
$string['aria_newpost'] = 'Tilføj nyt opslag til kolonne {column}';
$string['aria_postedit'] = 'Gem redigering af opslag {post} fra kolonne {column}';
$string['aria_postnew'] = 'Gem nyt opslag til kolonne  {column}';
$string['aria_ratepost'] = 'Vurder opslag {post} fra kolonne {column}';
$string['background_color'] = 'Baggrundsfarve';
$string['background_color_help'] = 'Skal være en gyldig hex-farve, som fx #00cc99';
$string['background_image'] = 'Baggrundsbillede';
$string['blanktargetenabled'] = 'Denne tavle er konfigureret til at åbne weblinks i et nyt vindue eller ny fane.';
$string['board:addinstance'] = 'Tilføj en ny tavle-instans';
$string['board:deleteallcomments'] = 'Se og slet alle kommentarer på opslag';
$string['board:manageboard'] = 'Administrer kolonner og alle opslag';
$string['board:postcomment'] = 'Opret og se kommentarer på opslag';
$string['board:view'] = 'Se tavle-indhold og administrer egne opslag';
$string['board_column_locked'] = 'Denne kolonne er låst og kan ikke redigeres.';
$string['boardhasnotes'] = 'Denne tavle har allerede opslag, det er ikke tilladt at ændre brugertilstanden';
$string['boardsettings'] = 'Indstillinger';
$string['brickfieldlogo'] = 'Powered by Brickfield-logo';
$string['cancel_button_text'] = 'Annuller';
$string['choose_file'] = 'Vælg billedfil';
$string['column_colours'] = 'Kolonnefarver';
$string['column_colours_desc'] = 'Farverne der bruges i topppen af hver kolonne. Disse er hex-farver og skal stå på en linje og have 3 eller 6 tegn. Hvis en værdi ikke er lig med en farve, vises standardfarven.';
$string['comment'] = 'Kommentar';
$string['comments'] = '{$a} Kommentarer';
$string['completiondetail:notes'] = 'Tilføj noter: {$a}';
$string['completionnotes'] = 'Studerende skal oprette dette antal noter for at færdiggøre aktiviteten';
$string['completionnotesgroup'] = 'Kræver noter';
$string['default_column_heading'] = 'Overskrift';
$string['delete'] = 'Slet';
$string['deletecomment'] = 'Slet kommentar';
$string['embed_height'] = 'Indlejringshøjde';
$string['embed_height_desc'] = 'Højde på den iframe, tavlen indlejres i.  Det skal være en gyldig CSS-værdi, fx px, rem, %, osv...';
$string['embed_width'] = 'Indlejringsbredde';
$string['embed_width_desc'] = 'Bredde på den iframe, tavlen indlejres i.  Det skal være en gyldig CSS-værdi, fx px, rem, %, osv...';
$string['embedboard'] = 'Indlejr tavlen på forsiden af kurset';
$string['enableblanktarget'] = 'Aktiver åbning i nyt vindue/på ny fane';
$string['enableblanktarget_help'] = 'Når aktiveret, åbner alle links i nyt vindue/på ny fane.';
$string['event_add_column'] = 'Kolonne tilføjet';
$string['event_add_column_desc'] = 'Deltageren med id \'{$a->userid}\' oprettede kolonne med id \'{$a->objectid}\' og navn \'{$a->name}\'.';
$string['event_add_comment'] = 'Kommentar tilføjet';
$string['event_add_comment_desc'] = 'Deltageren med id \'{$a->userid}\' tilføjede en kommentar med id \'{$a->objectid}\', indhold \'{$a->content}\' på noteid \'{$a->noteid}\'.';
$string['event_add_note'] = 'Opslag tilføjet';
$string['event_add_note_desc'] = 'Deltageren med id \'{$a->userid}\' oprettede opslag med id \'{$a->objectid}\', overskrift \'{$a->heading}\', indhold \'{$a->content}\', medier \'{$a->media}\' i kolonneid \'{$a->columnid}\', gruppeid \'{$a->groupid}\'.';
$string['event_delete_column'] = 'Kolonne slettet';
$string['event_delete_column_desc'] = 'Deltageren med id \'{$a->userid}\'  slettede kolonne med id \'{$a->objectid}\'.';
$string['event_delete_note'] = 'Opslag slettet';
$string['event_delete_note_desc'] = 'Deltageren med id \'{$a->userid}\' slettede opslag med id \'{$a->objectid}\' fra kolonneid \'{$a->columnid}\'.';
$string['event_move_note'] = 'Opslag flyttet';
$string['event_move_note_desc'] = 'Deltageren med id \'{$a->userid}\' flyttede opslag med id \'{$a->objectid}\' til kolonneid \'{$a->columnid}\'.';
$string['event_rate_note'] = 'Opslag vurderet';
$string['event_rate_note_desc'] = 'Brugeren med id \'{$a->userid}\' vurderede opslag med id \'{$a->objectid}\' til \'{$a->rating}\'.';
$string['event_update_column'] = 'Kolonne opdateret';
$string['event_update_column_desc'] = 'Deltageren med id  \'{$a->userid}\' opdaterede kolonne med id \'{$a->objectid}\' til \'{$a->name}\'.';
$string['event_update_note'] = 'Opslag opdateret';
$string['event_update_note_desc'] = 'Deltageren med id  \'{$a->userid}\' opdaterede opslag med id \'{$a->objectid}\' overskrift \'{$a->heading}\', indhold \'{$a->content}\', medier \'{$a->media}\' på kolonne id \'{$a->columnid}\'.';
$string['export_board'] = 'Eksporter CSV';
$string['export_content'] = 'Opret tekst';
$string['export_email'] = 'E-mail';
$string['export_firstname'] = 'Fornavn';
$string['export_heading'] = 'Overskrift';
$string['export_info'] = 'Titel';
$string['export_lastname'] = 'Efternavn';
$string['export_submissions'] = 'Eksporter opslag';
$string['export_timecreated'] = 'Oprettelsesdato';
$string['export_url'] = 'Opret URL';
$string['form_body'] = 'Indhold';
$string['form_image_file'] = 'Billedfil';
$string['form_mediatype'] = 'Medier';
$string['form_title'] = 'Titel';
$string['hideheaders'] = 'Skjul kolonneoverskrifter for studerende';
$string['history'] = 'Tavle-historik';
$string['history_refresh'] = 'Tavle genopfrisk-timer';
$string['history_refresh_desc'] = 'Timeout i sekunder mellem automatisk genopfrisk. Hvis den sættes til 0 eller er tom, vil tavlen kun opdateres når en handling foretages (tilføj/opdater/etc)';
$string['historyinfo'] = 'Skemaet med tavlehistorik bruges kun til at gemme midlertidige poster, som benyttes af javascript-processer til at genopfriske visninger.  De slettes straks efter brug.';
$string['invalid_file_extension'] = 'Filtypen kan ikke uploades.';
$string['invalid_file_size_max'] = 'Filen er for stor.';
$string['invalid_file_size_min'] = 'Filstørrelse for lille';
$string['invalid_youtube_url'] = 'Ugyldig YouTube-URL';
$string['media_selection'] = 'Medievalg';
$string['media_selection_buttons'] = 'Knapper';
$string['media_selection_desc'] = 'Konfigurer hvordan medievalg i opslag vises.';
$string['media_selection_dropdown'] = 'Dropdown';
$string['modal_title_edit'] = 'Rediger opslag, kolonne  {column}';
$string['modal_title_new'] = 'Nyt opslag, kolonne {column}';
$string['modulename'] = 'Tavle';
$string['modulename_help'] = 'Dette er en ny Moodle-aktivitet, som giver en lærer mulighed for at oprette en opslagstavle.';
$string['modulenameplural'] = 'Tavler';
$string['move_column_to_aftercolumn'] = 'Flyt kolonne hen efter kolonne  {$a}';
$string['move_column_to_firstplace'] = 'Flyt kolonne til første placering';
$string['move_to_afterpost'] = 'Flyt hen efter opslag {$a}';
$string['move_to_firstitemcolumn'] = 'Flyt til kolonne {$a}';
$string['new_column_icon'] = 'Nyt kolonneikon';
$string['new_column_icon_desc'] = 'Ikon vist på den nye kolonne-knap';
$string['new_note_icon'] = 'Nyt opslag-ikon';
$string['new_note_icon_desc'] = 'Ikon vist på den nye opslagsknap';
$string['nopermission'] = 'Du har ikke rettigheder til at se denne tavle';
$string['note_changed_text'] = 'Det opslag, du redigerer, er ændret';
$string['note_changed_title'] = 'Bekræft';
$string['note_deleted_text'] = 'Det opslag du redigerede er blevet slettet';
$string['nousers'] = 'Denne tavle-aktivitet har ingen tilmeldte deltagere';
$string['opensinnewwindow'] = 'Åbner i nyt vindue';
$string['option_empty'] = 'Ingen';
$string['option_image'] = 'Billede';
$string['option_image_info'] = 'Billedtitel';
$string['option_image_url'] = 'Billed-URL';
$string['option_link_info'] = 'Link-titel';
$string['option_link_url'] = 'Link URL';
$string['option_youtube'] = 'Video (YouTube)';
$string['option_youtube_info'] = 'Videotitel';
$string['option_youtube_url'] = 'YouTube URL';
$string['pluginadministration'] = 'Tavle-modul-administration';
$string['pluginname'] = 'Tavle';
$string['post_button_text'] = 'Opslag';
$string['post_max_length'] = 'Max længde på opslag';
$string['post_max_length_desc'] = 'Den maksimale tilladte længde. Alt over den længde bliver skåret væk.';
$string['postbydate'] = 'Opslag efter dato';
$string['postbyenabled'] = 'Begræns elevers opslag efter dato';
$string['posts'] = 'Opslag';
$string['privacy:metadata:board_comments'] = 'Kommentarer til hvert opslag';
$string['privacy:metadata:board_comments:content'] = 'Indholdet af kommentaren til opslaget';
$string['privacy:metadata:board_comments:noteid'] = 'ID på det relaterede opslag';
$string['privacy:metadata:board_comments:timecreated'] = 'Tidspunkt for oprettelse af kommentar';
$string['privacy:metadata:board_comments:userid'] = 'ID på deltageren, der tilføjede kommentaren til opslaget';
$string['privacy:metadata:board_history'] = 'Midlertidig tavle-historik-poster bruges af javascript-processer til at genopfriske visninger, og de slettes straks efter brug';
$string['privacy:metadata:board_history:action'] = 'Udført handling';
$string['privacy:metadata:board_history:boardid'] = 'Tavlens ID';
$string['privacy:metadata:board_history:content'] = 'JSON-data på den udførte handling';
$string['privacy:metadata:board_history:timecreated'] = 'Tidspunkt hvor handlingen blev foretaget';
$string['privacy:metadata:board_history:userid'] = 'ID på den deltager, der udførte handlingen';
$string['privacy:metadata:board_note_ratings'] = 'Information om de individuelle vurderinger af hvert opslag';
$string['privacy:metadata:board_note_ratings:noteid'] = 'ID på det relaterede opslag';
$string['privacy:metadata:board_note_ratings:timecreated'] = 'Tidspunkt hvor vurderingen blev foretaget';
$string['privacy:metadata:board_note_ratings:userid'] = 'ID på den deltager, der oprettede vurderingen';
$string['privacy:metadata:board_notes'] = 'Information om de individuelle opslag på hver tavle';
$string['privacy:metadata:board_notes:columnid'] = 'Opslagets kolonneplacering';
$string['privacy:metadata:board_notes:content'] = 'Opslagets indhold';
$string['privacy:metadata:board_notes:heading'] = 'Opslagets overskrift';
$string['privacy:metadata:board_notes:info'] = 'Information om opslagets medier';
$string['privacy:metadata:board_notes:timecreated'] = 'Tidspunkt for oprettelse af opslaget';
$string['privacy:metadata:board_notes:url'] = 'Opslagets medie-url';
$string['privacy:metadata:board_notes:userid'] = 'ID på den deltager, der oprettede opslaget';
$string['rate_note_text'] = 'Er du sikker på, at du vil vurdere denne post?';
$string['rate_note_title'] = 'Bekræft';
$string['ratings'] = 'Vurderinger';
$string['remove_column_text'] = 'Er du sikker på, at du vil slette denne "{$a}" kolonne og alle de opslag, den indeholder';
$string['remove_column_title'] = 'Bekræft';
$string['remove_note_text'] = 'Er du sikker på at du vil slette dette opslag og alle de data det indeholder. Det vil berøre alle andre deltagere.';
$string['remove_note_title'] = 'Bekræft';
$string['selectuser'] = 'Vælg deltager';
$string['selectuserplease'] = 'Vælg venligst en deltager';
$string['singleusermode'] = 'Enkelt-deltager-mode';
$string['singleusermode_desc'] = 'I enkelt-deltager-mode kan en deltager kun tilføje opslag på deres egen tavle - hvis privat er valgt, kan deltagere ikke se andres tavler. Hvis offentlig er valgt,  kan deltagertavler tilgås via drop down liste.';
$string['singleusermodenone'] = 'Deaktiveret';
$string['singleusermodenotembed'] = 'En enkelt-bruger-tavle kan ikke embeddes. Ændr venligst dine indstillinger.';
$string['singleusermodeprivate'] = 'Enkelt-bruger-mode (privat)';
$string['singleusermodepublic'] = 'Enkelt-bruger-mode (offentlig)';
$string['sortby'] = 'Sorter efter';
$string['sortbydate'] = 'Oprettelsesdato';
$string['sortbynone'] = 'Ingen';
$string['sortbyrating'] = 'Vurdering';
$string['userscanedit'] = 'Tillad alle brugere at redigere placeringen af deres opslag';
$string['warning'] = 'Notifikation';
